use ::libc;
extern "C" {
    fn tolower(_: libc::c_int) -> libc::c_int;
    fn strcmp(_: *const libc::c_char, _: *const libc::c_char) -> libc::c_int;
    fn strdup(_: *const libc::c_char) -> *mut libc::c_char;
    fn strlen(_: *const libc::c_char) -> libc::c_ulong;
}
pub type __uint32_t = libc::c_uint;
pub type uint32_t = __uint32_t;
#[no_mangle]
pub unsafe extern "C" fn stricmp_(
    mut str1: *const libc::c_char,
    mut str2: *const libc::c_char,
) -> libc::c_int {
    let mut _str1: *mut libc::c_char = strdup(str1);
    let mut _str2: *mut libc::c_char = strdup(str2);
    let mut i: libc::c_int = 0 as libc::c_int;
    while (i as libc::c_ulong) < strlen(_str1) {
        *_str1
            .offset(
                i as isize,
            ) = tolower(*_str1.offset(i as isize) as libc::c_int) as libc::c_char;
        i += 1;
        i;
    }
    let mut i_0: libc::c_int = 0 as libc::c_int;
    while (i_0 as libc::c_ulong) < strlen(_str2) {
        *_str2
            .offset(
                i_0 as isize,
            ) = tolower(*_str2.offset(i_0 as isize) as libc::c_int) as libc::c_char;
        i_0 += 1;
        i_0;
    }
    return strcmp(_str1, _str2);
}
#[no_mangle]
pub unsafe extern "C" fn rotr_(mut v: uint32_t, mut nbits: libc::c_int) -> uint32_t {
    let mut low: uint32_t = v >> nbits;
    let mut high: uint32_t = v << 32 as libc::c_int - nbits;
    return high | low;
}
