use ::libc;
extern "C" {
    pub type _IO_wide_data;
    pub type _IO_codecvt;
    pub type _IO_marker;
    pub type smk_t;
    fn tolower(_: libc::c_int) -> libc::c_int;
    fn strcpy(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn SDL_GetTicks() -> Uint32;
    fn ftell(__stream: *mut FILE) -> libc::c_long;
    fn fseek(
        __stream: *mut FILE,
        __off: libc::c_long,
        __whence: libc::c_int,
    ) -> libc::c_int;
    fn fread(
        _: *mut libc::c_void,
        _: libc::c_ulong,
        _: libc::c_ulong,
        _: *mut FILE,
    ) -> libc::c_ulong;
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn printf(_: *const libc::c_char, _: ...) -> libc::c_int;
    fn fopen(_: *const libc::c_char, _: *const libc::c_char) -> *mut FILE;
    fn fclose(__stream: *mut FILE) -> libc::c_int;
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn FullBlit(bArrow: bool32_t);
    fn ClrDraw();
    static mut force_redraw: libc::c_int;
    static mut gbLoopMovie: bool32_t;
    static mut gpPalette: [uint32_t; 256];
    static mut gpBuffer: *mut uint32_t;
    fn smk_open_memory(buffer: *const uint8_t, size: uint32_t) -> smk;
    fn smk_close(object: smk);
    fn smk_info_all(
        object: smk,
        frame: *mut uint32_t,
        frame_count: *mut uint32_t,
        usf: *mut libc::c_double,
    ) -> int8_t;
    fn smk_info_video(
        object: smk,
        w: *mut uint32_t,
        h: *mut uint32_t,
        y_scale_mode: *mut uint8_t,
    ) -> int8_t;
    fn smk_enable_video(object: smk, enable: uint8_t) -> int8_t;
    fn smk_get_palette(object: smk) -> *const uint8_t;
    fn smk_get_video(object: smk) -> *const uint8_t;
    fn smk_first(object: smk) -> int8_t;
    fn smk_next(object: smk) -> int8_t;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
pub type C2RustUnnamed = libc::c_uint;
pub const _ISalnum: C2RustUnnamed = 8;
pub const _ISpunct: C2RustUnnamed = 4;
pub const _IScntrl: C2RustUnnamed = 2;
pub const _ISblank: C2RustUnnamed = 1;
pub const _ISgraph: C2RustUnnamed = 32768;
pub const _ISprint: C2RustUnnamed = 16384;
pub const _ISspace: C2RustUnnamed = 8192;
pub const _ISxdigit: C2RustUnnamed = 4096;
pub const _ISdigit: C2RustUnnamed = 2048;
pub const _ISalpha: C2RustUnnamed = 1024;
pub const _ISlower: C2RustUnnamed = 512;
pub const _ISupper: C2RustUnnamed = 256;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type size_t = libc::c_ulong;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _IO_FILE {
    pub _flags: libc::c_int,
    pub _IO_read_ptr: *mut libc::c_char,
    pub _IO_read_end: *mut libc::c_char,
    pub _IO_read_base: *mut libc::c_char,
    pub _IO_write_base: *mut libc::c_char,
    pub _IO_write_ptr: *mut libc::c_char,
    pub _IO_write_end: *mut libc::c_char,
    pub _IO_buf_base: *mut libc::c_char,
    pub _IO_buf_end: *mut libc::c_char,
    pub _IO_save_base: *mut libc::c_char,
    pub _IO_backup_base: *mut libc::c_char,
    pub _IO_save_end: *mut libc::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: libc::c_int,
    pub _flags2: libc::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: libc::c_ushort,
    pub _vtable_offset: libc::c_schar,
    pub _shortbuf: [libc::c_char; 1],
    pub _lock: *mut libc::c_void,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut libc::c_void,
    pub __pad5: size_t,
    pub _mode: libc::c_int,
    pub _unused2: [libc::c_char; 20],
}
pub type _IO_lock_t = ();
pub type FILE = _IO_FILE;
pub type Uint32 = uint32_t;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_0 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_0 = 92160;
pub const BTMBUFFY: C2RustUnnamed_0 = 144;
pub const BTMBUFFX: C2RustUnnamed_0 = 640;
pub const BUFFERSIZE: C2RustUnnamed_0 = 503808;
pub const BUFFERY: C2RustUnnamed_0 = 656;
pub const BUFFERX: C2RustUnnamed_0 = 768;
pub const GAMEY: C2RustUnnamed_0 = 352;
pub const CTRLPANY: C2RustUnnamed_0 = 128;
pub const TOTALY: C2RustUnnamed_0 = 480;
pub const TOTALX: C2RustUnnamed_0 = 640;
pub const MAX_PLRS: C2RustUnnamed_0 = 4;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const ENABLE_VIDEO: C2RustUnnamed_1 = 1;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_2 = 255;
pub const VIEWDRAW: C2RustUnnamed_2 = 1;
pub const NODRAW: C2RustUnnamed_2 = 0;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PaletteStruct {
    pub peBlue: uint8_t,
    pub peGreen: uint8_t,
    pub peRed: uint8_t,
    pub peFlags: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_3 {
    pub unused: libc::c_int,
}
pub type HSFILE = *mut C2RustUnnamed_3;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_4 {
    pub unused: libc::c_int,
}
pub type HSVIDEO = *mut C2RustUnnamed_4;
pub type smk = *mut smk_t;
#[no_mangle]
pub unsafe extern "C" fn StormDestroy() -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
static mut last_err_code: uint32_t = 0 as libc::c_int as uint32_t;
#[no_mangle]
pub unsafe extern "C" fn SErrSetLastError(mut err_code: uint32_t) {
    last_err_code = err_code;
}
#[no_mangle]
pub unsafe extern "C" fn SErrGetLastError() -> uint32_t {
    return last_err_code;
}
#[no_mangle]
pub unsafe extern "C" fn SFileOpenFile(
    mut filename: *const libc::c_char,
    mut handle: *mut HSFILE,
) -> bool32_t {
    let mut szName: [libc::c_char; 260] = [0; 260];
    strcpy(szName.as_mut_ptr(), filename);
    let mut p: *mut libc::c_char = szName.as_mut_ptr();
    while *p as libc::c_int != '\0' as i32 {
        if libc::isupper(*p as i32) as libc::c_int != 0
        {
            *p = tolower(*p as libc::c_int) as libc::c_char;
        }
        if *p as libc::c_int == '\\' as i32 {
            *p = '/' as i32 as libc::c_char;
        }
        p = p.offset(1);
        p;
    }
    let mut f: *mut FILE = fopen(
        szName.as_mut_ptr(),
        b"rb\0" as *const u8 as *const libc::c_char,
    );
    if f.is_null() {
        let mut szPath: [libc::c_char; 260] = [0; 260];
        sprintf(
            szPath.as_mut_ptr(),
            b"diabdat/%s\0" as *const u8 as *const libc::c_char,
            szName.as_mut_ptr(),
        );
        printf(
            b"(dbg) opening %s\n\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
        f = fopen(szPath.as_mut_ptr(), b"rb\0" as *const u8 as *const libc::c_char);
        if f.is_null() {
            printf(
                b"unable to open '%s'\n\0" as *const u8 as *const libc::c_char,
                szPath.as_mut_ptr(),
            );
            return 0 as libc::c_int as bool32_t;
        }
    }
    *handle = f as HSFILE;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SFileReadFile(
    mut handle: HSFILE,
    mut buffer: *mut libc::c_void,
    mut bytestoread: uint32_t,
    mut bytesread: *mut uint32_t,
) -> bool32_t {
    let mut f: *mut FILE = handle as *mut FILE;
    if f.is_null() {
        return 0 as libc::c_int as bool32_t;
    }
    *bytesread = fread(
        buffer,
        1 as libc::c_int as libc::c_ulong,
        bytestoread as libc::c_ulong,
        f,
    ) as uint32_t;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SFileCloseFile(mut handle: HSFILE) -> bool32_t {
    let mut f: *mut FILE = handle as *mut FILE;
    if f.is_null() {
        return 0 as libc::c_int as bool32_t;
    }
    fclose(f);
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SFileGetFileSize(mut handle: HSFILE) -> uint32_t {
    let mut f: *mut FILE = handle as *mut FILE;
    if f.is_null() {
        return 0 as libc::c_int as uint32_t;
    }
    fseek(f, 0 as libc::c_long, 2 as libc::c_int);
    let mut size: uint32_t = ftell(f) as uint32_t;
    fseek(f, 0 as libc::c_long, 0 as libc::c_int);
    return size;
}
#[no_mangle]
pub unsafe extern "C" fn SFileSetFilePointer(
    mut handle: HSFILE,
    mut distancetomove: int32_t,
    mut whence: libc::c_int,
) -> uint32_t {
    return 0 as libc::c_int as uint32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SFileDdaBeginEx(
    mut handle: HSFILE,
    mut buffersize: uint32_t,
    mut flags: uint32_t,
    mut offset: uint32_t,
    mut volume: int32_t,
    mut pan: int32_t,
) -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SFileDdaEnd(mut handle: HSFILE) -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SFileDdaGetPos(
    mut handle: HSFILE,
    mut position: *mut uint32_t,
    mut maxposition: *mut uint32_t,
) -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SFileDdaSetVolume(
    mut handle: HSFILE,
    mut volume: int32_t,
    mut pan: int32_t,
) -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SFileDdaDestroy() -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SRegSaveValue(
    mut keyname: *const libc::c_char,
    mut valuename: *const libc::c_char,
    mut value: uint32_t,
) -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SRegLoadValue(
    mut keyname: *const libc::c_char,
    mut valuename: *const libc::c_char,
    mut value: *mut uint32_t,
) -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub static mut gpSmackVid: smk = 0 as *const smk_t as *mut smk_t;
#[no_mangle]
pub static mut gdwSmackFrames: uint32_t = 0;
#[no_mangle]
pub static mut gdwCurrFrame: uint32_t = 0;
#[no_mangle]
pub static mut gdwSmackWidth: uint32_t = 0;
#[no_mangle]
pub static mut gdwSmackHeight: uint32_t = 0;
#[no_mangle]
pub static mut gdwSmackTick: uint32_t = 0;
#[no_mangle]
pub static mut gdwSmackFps: uint32_t = 0;
#[no_mangle]
pub static mut gbSmackScaled: bool32_t = 1 as libc::c_int as bool32_t;
#[no_mangle]
pub unsafe extern "C" fn DrawVideo1x(mut src: *const uint8_t) {
    let mut x: uint32_t = ((TOTALX as libc::c_int / 2 as libc::c_int) as uint32_t)
        .wrapping_sub(gdwSmackWidth / 2 as libc::c_int as uint32_t);
    let mut y: uint32_t = ((TOTALY as libc::c_int / 2 as libc::c_int) as uint32_t)
        .wrapping_sub(gdwSmackHeight / 2 as libc::c_int as uint32_t);
    let mut dst: *mut uint32_t = &mut *gpBuffer
        .offset(
            x
                .wrapping_add(64 as libc::c_int as uint32_t)
                .wrapping_add(
                    y.wrapping_add(160 as libc::c_int as uint32_t)
                        * 768 as libc::c_int as uint32_t,
                ) as isize,
        ) as *mut uint32_t;
    let mut i: uint32_t = 0;
    let mut j: uint32_t = 0;
    i = 0 as libc::c_int as uint32_t;
    while i < gdwSmackHeight {
        j = 0 as libc::c_int as uint32_t;
        while j < gdwSmackWidth {
            *dst.offset(j as isize) = gpPalette[*src.offset(j as isize) as usize];
            j = j.wrapping_add(1);
            j;
        }
        dst = dst.offset(BUFFERX as libc::c_int as isize);
        src = src.offset(gdwSmackWidth as isize);
        i = i.wrapping_add(1);
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawVideo2x(mut src: *const uint8_t) {
    let mut x: uint32_t = ((TOTALX as libc::c_int / 2 as libc::c_int) as uint32_t)
        .wrapping_sub(gdwSmackWidth);
    let mut y: uint32_t = ((TOTALY as libc::c_int / 2 as libc::c_int) as uint32_t)
        .wrapping_sub(gdwSmackHeight);
    let mut dst1: *mut uint32_t = &mut *gpBuffer
        .offset(
            x
                .wrapping_add(64 as libc::c_int as uint32_t)
                .wrapping_add(
                    y.wrapping_add(160 as libc::c_int as uint32_t)
                        * 768 as libc::c_int as uint32_t,
                ) as isize,
        ) as *mut uint32_t;
    let mut dst2: *mut uint32_t = dst1.offset(BUFFERX as libc::c_int as isize);
    let mut i: uint32_t = 0;
    let mut j: uint32_t = 0;
    let mut k: uint32_t = 0;
    i = 0 as libc::c_int as uint32_t;
    while i < gdwSmackHeight {
        j = 0 as libc::c_int as uint32_t;
        k = 0 as libc::c_int as uint32_t;
        while j < gdwSmackWidth {
            let mut c: uint32_t = gpPalette[*src.offset(j as isize) as usize];
            *dst1.offset(k as isize) = c;
            *dst2.offset(k as isize) = c;
            *dst1.offset(k.wrapping_add(1 as libc::c_int as uint32_t) as isize) = c;
            *dst2.offset(k.wrapping_add(1 as libc::c_int as uint32_t) as isize) = c;
            j = j.wrapping_add(1);
            j;
            k = k.wrapping_add(2 as libc::c_int as uint32_t);
        }
        dst1 = dst1.offset((BUFFERX as libc::c_int * 2 as libc::c_int) as isize);
        dst2 = dst2.offset((BUFFERX as libc::c_int * 2 as libc::c_int) as isize);
        src = src.offset(gdwSmackWidth as isize);
        i = i.wrapping_add(1);
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawVideoFrame() {
    let mut pal: *const uint8_t = smk_get_palette(gpSmackVid);
    let mut src: *const uint8_t = smk_get_video(gpSmackVid);
    let mut p: *mut PaletteStruct = gpPalette.as_mut_ptr() as *mut PaletteStruct;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 256 as libc::c_int {
        (*p.offset(i as isize))
            .peRed = *pal.offset((i * 3 as libc::c_int + 0 as libc::c_int) as isize);
        (*p.offset(i as isize))
            .peGreen = *pal.offset((i * 3 as libc::c_int + 1 as libc::c_int) as isize);
        (*p.offset(i as isize))
            .peBlue = *pal.offset((i * 3 as libc::c_int + 2 as libc::c_int) as isize);
        (*p.offset(i as isize)).peFlags = 0 as libc::c_int as uint8_t;
        i += 1;
        i;
    }
    if gbSmackScaled == 0 {
        DrawVideo1x(src);
    } else {
        DrawVideo2x(src);
    }
    force_redraw = FULLDRAW as libc::c_int;
    FullBlit(0 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn SVidDestroy() -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SVidPlayBegin(
    mut filename: *const libc::c_char,
    mut handle: *mut HSVIDEO,
) -> bool32_t {
    if ENABLE_VIDEO as libc::c_int == 0 {
        return 1 as libc::c_int as bool32_t;
    }
    let mut dwSize: uint32_t = 0;
    let mut pVideo: *mut uint8_t = LoadFileInMem(filename, &mut dwSize);
    gpSmackVid = smk_open_memory(pVideo, dwSize);
    if gpSmackVid.is_null() {
        return 0 as libc::c_int as bool32_t;
    }
    gdwCurrFrame = 0 as libc::c_int as uint32_t;
    let mut usf: libc::c_double = 0.;
    smk_info_all(gpSmackVid, 0 as *mut uint32_t, &mut gdwSmackFrames, &mut usf);
    smk_info_video(
        gpSmackVid,
        &mut gdwSmackWidth,
        &mut gdwSmackHeight,
        0 as *mut uint8_t,
    );
    gdwSmackFps = (1000000.0f64 / usf) as uint32_t;
    smk_enable_video(gpSmackVid, 1 as libc::c_int as uint8_t);
    smk_first(gpSmackVid);
    *handle = gpSmackVid as HSVIDEO;
    gdwSmackTick = SDL_GetTicks();
    ClrDraw();
    DrawVideoFrame();
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SVidPlayContinue() -> bool32_t {
    if ENABLE_VIDEO as libc::c_int == 0 {
        return 0 as libc::c_int as bool32_t;
    }
    let mut ThisTick: uint32_t = SDL_GetTicks();
    if ThisTick.wrapping_sub(gdwSmackTick)
        < 1000 as libc::c_int as uint32_t / gdwSmackFps
    {
        return 1 as libc::c_int as bool32_t;
    }
    gdwSmackTick = ThisTick;
    gdwCurrFrame = gdwCurrFrame.wrapping_add(1);
    gdwCurrFrame;
    if gdwCurrFrame == gdwSmackFrames {
        if gbLoopMovie == 0 {
            return 0 as libc::c_int as bool32_t;
        }
        gdwCurrFrame = 0 as libc::c_int as uint32_t;
        smk_first(gpSmackVid);
    } else {
        smk_next(gpSmackVid);
    }
    DrawVideoFrame();
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SVidPlayEnd(mut video: HSVIDEO) -> bool32_t {
    if ENABLE_VIDEO as libc::c_int == 0 {
        return 0 as libc::c_int as bool32_t;
    }
    smk_close(gpSmackVid);
    video = 0 as HSVIDEO;
    return 0 as libc::c_int as bool32_t;
}
