use ::libc;
extern "C" {
    fn free(_: *mut libc::c_void);
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    static mut gbMaxPlayers: uint8_t;
    fn queue_is_empty() -> bool32_t;
    fn queue_push(data: *mut uint8_t, len: libc::c_int);
    fn queue_pop() -> *mut Message;
    fn SErrSetLastError(err_code: uint32_t);
}
pub type __uint8_t = libc::c_uchar;
pub type __uint32_t = libc::c_uint;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const MAX_MSG_SIZE: C2RustUnnamed = 512;
pub const MIN_MSG_SIZE: C2RustUnnamed = 128;
pub const SEND_ALL_MASK: C2RustUnnamed = 4294967295;
pub const MAX_SEND_STR_LEN: C2RustUnnamed = 80;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const NO_STORM_NETWORK: C2RustUnnamed_0 = 0;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _Message {
    pub next: *mut _Message,
    pub data: *mut uint8_t,
    pub len: libc::c_int,
}
pub type Message = _Message;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SNETCAPS {
    pub size: uint32_t,
    pub flags: uint32_t,
    pub maxmessagesize: uint32_t,
    pub maxqueuesize: uint32_t,
    pub maxplayers: uint32_t,
    pub bytessec: uint32_t,
    pub latencyms: uint32_t,
    pub defaultturnssec: uint32_t,
    pub defaultturnsintransit: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SNETEVENT {
    pub eventid: uint32_t,
    pub playerid: uint32_t,
    pub data: *mut libc::c_void,
    pub databytes: uint32_t,
}
pub type SNETEVENTPROC = Option::<unsafe extern "C" fn(*mut SNETEVENT) -> ()>;
pub const PEER_ID_ALL: C2RustUnnamed_1 = 4294967295;
pub const PLAYER_ID_SINGLE_PLAYER: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
#[no_mangle]
pub unsafe extern "C" fn SNetInitializeProvider(mut providerid: uint32_t) -> bool32_t {
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetDestroy() -> bool32_t {
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetCreateGame(
    mut gamename: *const libc::c_char,
    mut gamepassword: *const libc::c_char,
    mut gamedescription: *const libc::c_char,
    mut gamecategorybits: uint32_t,
    mut initdata: *mut libc::c_void,
    mut initdatabytes: uint32_t,
    mut maxplayers: uint32_t,
    mut playername: *const libc::c_char,
    mut playerdescription: *const libc::c_char,
    mut playerid: *mut uint32_t,
) -> bool32_t {
    *playerid = 0 as libc::c_int as uint32_t;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetJoinGame(
    mut gameid: uint32_t,
    mut gamename: *const libc::c_char,
    mut gamepassword: *const libc::c_char,
    mut playername: *const libc::c_char,
    mut playerdescription: *const libc::c_char,
    mut playerid: *mut uint32_t,
) -> bool32_t {
    app_fatal_(
        b"storm/snet_loopback.c\0" as *const u8 as *const libc::c_char,
        36 as libc::c_int,
        b"unable to join game; loopback interface only supports hosting games\n\0"
            as *const u8 as *const libc::c_char,
    );
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetLeaveGame(mut exitcode: uint32_t) -> bool32_t {
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetSendMessage(
    mut targetplayerid: uint32_t,
    mut data: *mut libc::c_void,
    mut databytes: uint32_t,
) -> bool32_t {
    if NO_STORM_NETWORK as libc::c_int != 0 {
        return (gbMaxPlayers as libc::c_int != 1 as libc::c_int) as libc::c_int
            as bool32_t;
    }
    if targetplayerid != PLAYER_ID_SINGLE_PLAYER as libc::c_int as uint32_t
        || targetplayerid == PEER_ID_ALL as libc::c_uint
    {
        return 1 as libc::c_int as bool32_t;
    }
    queue_push(data as *mut uint8_t, databytes as libc::c_int);
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetReceiveMessage(
    mut senderplayerid: *mut uint32_t,
    mut data: *mut *mut libc::c_void,
    mut databytes: *mut uint32_t,
) -> bool32_t {
    if NO_STORM_NETWORK as libc::c_int != 0 {
        return 0 as libc::c_int as bool32_t;
    }
    if queue_is_empty() != 0 {
        SErrSetLastError(
            0x80000000 as libc::c_uint
                | ((0x510 as libc::c_int) << 16 as libc::c_int) as libc::c_uint
                | (107 as libc::c_int & 0xffff as libc::c_int) as libc::c_uint,
        );
        return 0 as libc::c_int as bool32_t;
    }
    SErrSetLastError(0 as libc::c_int as uint32_t);
    let mut msg: *mut Message = queue_pop();
    *senderplayerid = 0 as libc::c_int as uint32_t;
    *data = (*msg).data as *mut libc::c_void;
    *databytes = (*msg).len as uint32_t;
    free(msg as *mut libc::c_void);
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetSendTurn(
    mut data: *mut libc::c_void,
    mut databytes: uint32_t,
) -> bool32_t {
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetReceiveTurns(
    mut firstplayerid: uint32_t,
    mut arraysize: uint32_t,
    mut arraydata: *mut *mut libc::c_void,
    mut arraydatabytes: *mut uint32_t,
    mut arrayplayerstatus: *mut uint32_t,
) -> bool32_t {
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetRegisterEventHandler(
    mut eventid: uint32_t,
    mut callback: SNETEVENTPROC,
) -> bool32_t {
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetUnregisterEventHandler(
    mut eventid: uint32_t,
    mut callback: SNETEVENTPROC,
) -> bool32_t {
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetDropPlayer(
    mut playerid: uint32_t,
    mut exitcode: uint32_t,
) -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetGetGameInfo(
    mut index: uint32_t,
    mut buffer: *mut libc::c_void,
    mut buffersize: uint32_t,
    mut byteswritten: *mut uint32_t,
) -> bool32_t {
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetGetOwnerTurnsWaiting(mut turns: *mut uint32_t) -> bool32_t {
    *turns = 0 as libc::c_int as uint32_t;
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetGetProviderCaps(mut caps: *mut SNETCAPS) -> bool32_t {
    let mut null_caps: SNETCAPS = {
        let mut init = SNETCAPS {
            size: ::core::mem::size_of::<SNETCAPS>() as libc::c_ulong as uint32_t,
            flags: 0x20000000 as libc::c_int as uint32_t,
            maxmessagesize: MAX_MSG_SIZE as libc::c_int as uint32_t,
            maxqueuesize: 16 as libc::c_int as uint32_t,
            maxplayers: 1 as libc::c_int as uint32_t,
            bytessec: 0x300000 as libc::c_int as uint32_t,
            latencyms: 0 as libc::c_int as uint32_t,
            defaultturnssec: 30 as libc::c_int as uint32_t,
            defaultturnsintransit: 0 as libc::c_int as uint32_t,
        };
        init
    };
    memcpy(
        caps as *mut libc::c_void,
        &mut null_caps as *mut SNETCAPS as *const libc::c_void,
        ::core::mem::size_of::<SNETCAPS>() as libc::c_ulong,
    );
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SNetGetTurnsInTransit(mut turns: *mut uint32_t) -> bool32_t {
    *turns = 0 as libc::c_int as uint32_t;
    return 1 as libc::c_int as bool32_t;
}
