use ::libc;
extern "C" {
    fn calloc(_: libc::c_ulong, _: libc::c_ulong) -> *mut libc::c_void;
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
}
pub type __uint8_t = libc::c_uchar;
pub type __uint32_t = libc::c_uint;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _Message {
    pub next: *mut _Message,
    pub data: *mut uint8_t,
    pub len: libc::c_int,
}
pub type Message = _Message;
#[no_mangle]
pub static mut msg_queue_head: *mut Message = 0 as *const Message as *mut Message;
#[no_mangle]
pub unsafe extern "C" fn queue_is_empty() -> bool32_t {
    if msg_queue_head.is_null() {
        return 1 as libc::c_int as bool32_t;
    }
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn new_message(
    mut data: *mut uint8_t,
    mut len: libc::c_int,
) -> *mut Message {
    let mut msg: *mut Message = calloc(
        ::core::mem::size_of::<Message>() as libc::c_ulong,
        1 as libc::c_int as libc::c_ulong,
    ) as *mut Message;
    (*msg)
        .data = calloc(len as libc::c_ulong, 1 as libc::c_int as libc::c_ulong)
        as *mut uint8_t;
    (*msg).len = len;
    memcpy(
        (*msg).data as *mut libc::c_void,
        data as *const libc::c_void,
        len as libc::c_ulong,
    );
    return msg;
}
#[no_mangle]
pub unsafe extern "C" fn queue_push(mut data: *mut uint8_t, mut len: libc::c_int) {
    let mut msg: *mut Message = new_message(data, len);
    if msg_queue_head.is_null() {
        msg_queue_head = msg;
        return;
    }
    let mut node: *mut Message = msg_queue_head;
    while !((*node).next).is_null() {
        node = (*node).next;
    }
    (*node).next = msg;
}
#[no_mangle]
pub unsafe extern "C" fn queue_pop() -> *mut Message {
    if msg_queue_head.is_null() {
        assert_fail(
            47 as libc::c_int,
            b"storm/message_queue.c\0" as *const u8 as *const libc::c_char,
            b"msg_queue_head != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut msg: *mut Message = msg_queue_head;
    msg_queue_head = (*msg_queue_head).next;
    return msg;
}
