use ::libc;
extern "C" {
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn SFileOpenFile(filename: *const libc::c_char, handle: *mut HSFILE) -> bool32_t;
    fn SFileReadFile(
        handle: HSFILE,
        buffer: *mut libc::c_void,
        bytestoread: uint32_t,
        bytesread: *mut uint32_t,
    ) -> bool32_t;
    fn SFileSetFilePointer(
        handle: HSFILE,
        distancetomove: int32_t,
        whence: libc::c_int,
    ) -> uint32_t;
}
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int32_t = __int32_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed {
    pub unused: libc::c_int,
}
pub type HSFILE = *mut C2RustUnnamed;
#[no_mangle]
pub unsafe extern "C" fn patSFileOpenFile(
    mut filename: *const libc::c_char,
    mut handle: *mut HSFILE,
    mut bCanFail: bool32_t,
) -> bool32_t {
    if SFileOpenFile(filename, handle) != 0 {
        return 1 as libc::c_int as bool32_t;
    }
    if bCanFail != 0 {
        return 0 as libc::c_int as bool32_t;
    }
    app_fatal_(
        b"src/wave.c\0" as *const u8 as *const libc::c_char,
        15 as libc::c_int,
        b"unable to open '%s\0" as *const u8 as *const libc::c_char,
        filename,
    );
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn patSFileReadFile(
    mut handle: HSFILE,
    mut buffer: *mut libc::c_void,
    mut bytestoread: uint32_t,
) {
    let mut dwBytes: uint32_t = 0;
    SFileSetFilePointer(handle, 0 as libc::c_int, 1 as libc::c_int);
    SFileReadFile(handle, buffer, bytestoread, &mut dwBytes);
    if !(bytestoread == dwBytes) {
        assert_fail(
            23 as libc::c_int,
            b"src/wave.c\0" as *const u8 as *const libc::c_char,
            b"bytestoread == dwBytes\0" as *const u8 as *const libc::c_char,
        );
    }
}
