use ::libc;
extern "C" {
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn GetMiniTiles(
        lv: int32_t,
        v1: *mut int32_t,
        v2: *mut int32_t,
        v3: *mut int32_t,
        v4: *mut int32_t,
    );
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut dPiece: [[libc::c_int; 112]; 112];
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dPlayer: [[int8_t; 112]; 112];
    static mut dMonster: [[libc::c_int; 112]; 112];
    static mut dObject: [[int8_t; 112]; 112];
    static mut dItem: [[int8_t; 112]; 112];
    static mut dSpecial: [[int8_t; 112]; 112];
    static mut gbMaxPlayers: uint8_t;
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut quests: [QuestStruct; 16];
    static mut TWarpFrom: libc::c_int;
}
pub type C2RustUnnamed = libc::c_uint;
pub const Q_BETRAYER: C2RustUnnamed = 15;
pub const Q_SCHAMB: C2RustUnnamed = 14;
pub const Q_PWATER: C2RustUnnamed = 13;
pub const Q_SKELKING: C2RustUnnamed = 12;
pub const Q_WARLORD: C2RustUnnamed = 11;
pub const Q_ANVIL: C2RustUnnamed = 10;
pub const Q_BLOOD: C2RustUnnamed = 9;
pub const Q_BLIND: C2RustUnnamed = 8;
pub const Q_LTBANNER: C2RustUnnamed = 7;
pub const Q_BUTCHER: C2RustUnnamed = 6;
pub const Q_DIABLO: C2RustUnnamed = 5;
pub const Q_VEIL: C2RustUnnamed = 4;
pub const Q_ZHAR: C2RustUnnamed = 3;
pub const Q_GARBUD: C2RustUnnamed = 2;
pub const Q_BKMUSHRM: C2RustUnnamed = 1;
pub const Q_ROCK: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const QUEST_DONE: C2RustUnnamed_0 = 3;
pub const QUEST_NOTDONE: C2RustUnnamed_0 = 2;
pub const QUEST_NOTACTIVE: C2RustUnnamed_0 = 1;
pub const QUEST_NOTAVAIL: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const LVL_TWARPUP: C2RustUnnamed_1 = 7;
pub const LVL_TWARPDN: C2RustUnnamed_1 = 6;
pub const LVL_WARP: C2RustUnnamed_1 = 5;
pub const LVL_NODIR: C2RustUnnamed_1 = 4;
pub const LVL_RTN: C2RustUnnamed_1 = 3;
pub const LVL_SET: C2RustUnnamed_1 = 2;
pub const LVL_UP: C2RustUnnamed_1 = 1;
pub const LVL_DOWN: C2RustUnnamed_1 = 0;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_2 = 32;
pub const MAXMICRO: C2RustUnnamed_2 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_2 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_2 = 64;
pub const MAXMREND: C2RustUnnamed_2 = 128;
pub const MAXTILES: C2RustUnnamed_2 = 2048;
pub const MDMAXY: C2RustUnnamed_2 = 40;
pub const MDMAXX: C2RustUnnamed_2 = 40;
pub const MAXDUNY: C2RustUnnamed_2 = 112;
pub const MAXDUNX: C2RustUnnamed_2 = 112;
pub const DMAXY: C2RustUnnamed_2 = 112;
pub const DMAXX: C2RustUnnamed_2 = 112;
pub const DIRTEDGED2: C2RustUnnamed_2 = 16;
pub const DIRTEDGE: C2RustUnnamed_2 = 32;
pub const NUMSLEVELS: C2RustUnnamed_2 = 10;
pub const NUMLEVELS: C2RustUnnamed_2 = 17;
pub const LVL4_START: C2RustUnnamed_2 = 13;
pub const LVL3_START: C2RustUnnamed_2 = 9;
pub const LVL2_START: C2RustUnnamed_2 = 5;
pub const LVL1_START: C2RustUnnamed_2 = 1;
pub const TLVL_START: C2RustUnnamed_2 = 0;
pub const LVLLENGTH: C2RustUnnamed_2 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct QuestStruct {
    pub _qlevel: uint8_t,
    pub _qtype: uint8_t,
    pub _qactive: uint8_t,
    pub _qlvltype: uint8_t,
    pub _qtx: libc::c_int,
    pub _qty: libc::c_int,
    pub _qslvl: uint8_t,
    pub _qidx: uint8_t,
    pub _qmsg: uint8_t,
    pub _qvar1: uint8_t,
    pub _qvar2: uint8_t,
    pub align_0011: [uint8_t; 3],
    pub _qlog: bool32_t,
}
#[no_mangle]
pub unsafe extern "C" fn T_FillTile(
    mut xx: libc::c_int,
    mut yy: libc::c_int,
    mut t: libc::c_int,
) {
    let mut v1: int32_t = 0;
    let mut v2: int32_t = 0;
    let mut v3: int32_t = 0;
    let mut v4: int32_t = 0;
    GetMiniTiles(t, &mut v1, &mut v2, &mut v3, &mut v4);
    dPiece[xx as usize][yy as usize] = v1;
    dPiece[(xx + 1 as libc::c_int) as usize][yy as usize] = v2;
    dPiece[xx as usize][(yy + 1 as libc::c_int) as usize] = v3;
    dPiece[(xx + 1 as libc::c_int) as usize][(yy + 1 as libc::c_int) as usize] = v4;
}
#[no_mangle]
pub unsafe extern "C" fn T_FillSector(
    mut pSector: *mut uint8_t,
    mut xi: libc::c_int,
    mut yi: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    let mut w: libc::c_int = 0;
    let mut h: libc::c_int = 0;
    let mut lm: *mut uint16_t = 0 as *mut uint16_t;
    lm = pSector as *mut uint16_t;
    w = *lm as libc::c_int;
    lm = lm.offset(1);
    lm;
    h = *lm as libc::c_int;
    lm = lm.offset(1);
    lm;
    yy = yi;
    j = 0 as libc::c_int;
    while j < h {
        xx = xi;
        i = 0 as libc::c_int;
        while i < w {
            T_FillTile(xx, yy, *lm as libc::c_int);
            xx += 2 as libc::c_int;
            lm = lm.offset(1);
            lm;
            i += 1;
            i;
        }
        yy += 2 as libc::c_int;
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn T_Pass3() {
    let mut pSector: *mut uint8_t = 0 as *mut uint8_t;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    yy = 0 as libc::c_int;
    while yy < DMAXY as libc::c_int {
        xx = 0 as libc::c_int;
        while xx < DMAXX as libc::c_int {
            dPiece[xx as usize][yy as usize] = 0 as libc::c_int;
            dPiece[(xx + 1 as libc::c_int) as usize][yy as usize] = 0 as libc::c_int;
            dPiece[xx as usize][(yy + 1 as libc::c_int) as usize] = 0 as libc::c_int;
            dPiece[(xx + 1 as libc::c_int)
                as usize][(yy + 1 as libc::c_int) as usize] = 0 as libc::c_int;
            xx += 2 as libc::c_int;
        }
        yy += 2 as libc::c_int;
    }
    pSector = LoadFileInMem(
        b"Levels\\TownData\\Sector1s.DUN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    T_FillSector(pSector, 46 as libc::c_int, 46 as libc::c_int);
    let mut p__p: *mut libc::c_void = pSector as *mut libc::c_void;
    pSector = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    pSector = LoadFileInMem(
        b"Levels\\TownData\\Sector2s.DUN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    T_FillSector(pSector, 46 as libc::c_int, 0 as libc::c_int);
    let mut p__p_0: *mut libc::c_void = pSector as *mut libc::c_void;
    pSector = 0 as *mut uint8_t;
    mem_free_dbg(p__p_0);
    pSector = LoadFileInMem(
        b"Levels\\TownData\\Sector3s.DUN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    T_FillSector(pSector, 0 as libc::c_int, 46 as libc::c_int);
    let mut p__p_1: *mut libc::c_void = pSector as *mut libc::c_void;
    pSector = 0 as *mut uint8_t;
    mem_free_dbg(p__p_1);
    pSector = LoadFileInMem(
        b"Levels\\TownData\\Sector4s.DUN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    T_FillSector(pSector, 0 as libc::c_int, 0 as libc::c_int);
    let mut p__p_2: *mut libc::c_void = pSector as *mut libc::c_void;
    pSector = 0 as *mut uint8_t;
    mem_free_dbg(p__p_2);
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        if plr[myplr as usize].pTownWarps as libc::c_int & 0x1 as libc::c_int == 0 {
            T_FillTile(48 as libc::c_int, 20 as libc::c_int, 320 as libc::c_int);
        }
        if plr[myplr as usize].pTownWarps as libc::c_int & 0x2 as libc::c_int == 0 {
            T_FillTile(16 as libc::c_int, 68 as libc::c_int, 332 as libc::c_int);
            T_FillTile(16 as libc::c_int, 70 as libc::c_int, 331 as libc::c_int);
        }
        if plr[myplr as usize].pTownWarps as libc::c_int & 0x4 as libc::c_int == 0 {
            xx = 36 as libc::c_int;
            while xx < 46 as libc::c_int {
                T_FillTile(
                    xx,
                    78 as libc::c_int,
                    random_(
                        b"src/town.c\0" as *const u8 as *const libc::c_char,
                        98 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        4 as libc::c_int,
                    ) + 1 as libc::c_int,
                );
                xx += 1;
                xx;
            }
        }
    }
    if quests[Q_PWATER as libc::c_int as usize]._qactive as libc::c_int
        == QUEST_DONE as libc::c_int
        || quests[Q_PWATER as libc::c_int as usize]._qactive as libc::c_int
            == QUEST_NOTAVAIL as libc::c_int
    {
        T_FillTile(60 as libc::c_int, 70 as libc::c_int, 71 as libc::c_int);
    } else {
        T_FillTile(60 as libc::c_int, 70 as libc::c_int, 342 as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn CreateTown(mut entry: libc::c_int) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    if entry == LVL_DOWN as libc::c_int {
        ViewX = 75 as libc::c_int;
        ViewY = 68 as libc::c_int;
    } else if entry == LVL_UP as libc::c_int {
        ViewX = 25 as libc::c_int;
        ViewY = 31 as libc::c_int;
    } else if entry == LVL_TWARPUP as libc::c_int {
        if TWarpFrom == 5 as libc::c_int {
            ViewX = 49 as libc::c_int;
            ViewY = 22 as libc::c_int;
        }
        if TWarpFrom == 9 as libc::c_int {
            ViewX = 18 as libc::c_int;
            ViewY = 69 as libc::c_int;
        }
        if TWarpFrom == 13 as libc::c_int {
            ViewX = 41 as libc::c_int;
            ViewY = 81 as libc::c_int;
        }
    }
    T_Pass3();
    memset(
        dFlags.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
    );
    memset(
        dPlayer.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
    );
    memset(
        dMonster.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[libc::c_int; 112]; 112]>() as libc::c_ulong,
    );
    memset(
        dObject.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
    );
    memset(
        dItem.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
    );
    memset(
        dSpecial.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
    );
    j = 0 as libc::c_int;
    while j < DMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < DMAXX as libc::c_int {
            let mut nPiece: libc::c_int = dPiece[i as usize][j as usize];
            if nPiece == 360 as libc::c_int {
                dSpecial[i as usize][j as usize] = 1 as libc::c_int as int8_t;
            } else if nPiece == 358 as libc::c_int {
                dSpecial[i as usize][j as usize] = 2 as libc::c_int as int8_t;
            } else if nPiece == 129 as libc::c_int {
                dSpecial[i as usize][j as usize] = 6 as libc::c_int as int8_t;
            } else if nPiece == 130 as libc::c_int {
                dSpecial[i as usize][j as usize] = 7 as libc::c_int as int8_t;
            } else if nPiece == 128 as libc::c_int {
                dSpecial[i as usize][j as usize] = 8 as libc::c_int as int8_t;
            } else if nPiece == 117 as libc::c_int {
                dSpecial[i as usize][j as usize] = 9 as libc::c_int as int8_t;
            } else if nPiece == 157 as libc::c_int {
                dSpecial[i as usize][j as usize] = 10 as libc::c_int as int8_t;
            } else if nPiece == 158 as libc::c_int {
                dSpecial[i as usize][j as usize] = 11 as libc::c_int as int8_t;
            } else if nPiece == 156 as libc::c_int {
                dSpecial[i as usize][j as usize] = 12 as libc::c_int as int8_t;
            } else if nPiece == 162 as libc::c_int {
                dSpecial[i as usize][j as usize] = 13 as libc::c_int as int8_t;
            } else if nPiece == 160 as libc::c_int {
                dSpecial[i as usize][j as usize] = 14 as libc::c_int as int8_t;
            } else if nPiece == 214 as libc::c_int {
                dSpecial[i as usize][j as usize] = 15 as libc::c_int as int8_t;
            } else if nPiece == 212 as libc::c_int {
                dSpecial[i as usize][j as usize] = 16 as libc::c_int as int8_t;
            } else if nPiece == 217 as libc::c_int {
                dSpecial[i as usize][j as usize] = 17 as libc::c_int as int8_t;
            } else if nPiece == 216 as libc::c_int {
                dSpecial[i as usize][j as usize] = 18 as libc::c_int as int8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
