use ::libc;
extern "C" {
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn SDL_GetTicks() -> Uint32;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn DiabloAllocPtr(dwBytes: uint32_t) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
}
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type Uint32 = uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const TIMED_MSG_DELAY: C2RustUnnamed = 500;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TTimedMsg {
    pub pNext: *mut TTimedMsg,
    pub lTime: int32_t,
    pub bLen: uint8_t,
    pub bData: [uint8_t; 1],
}
static mut sgpTimedMsgHead: *mut TTimedMsg = 0 as *const TTimedMsg as *mut TTimedMsg;
#[no_mangle]
pub unsafe extern "C" fn tmsg_get(
    mut pbMsg: *mut uint8_t,
    mut dwMaxLen: uint32_t,
) -> uint32_t {
    if pbMsg.is_null() {
        assert_fail(
            24 as libc::c_int,
            b"src/tmsg.c\0" as *const u8 as *const libc::c_char,
            b"pbMsg\0" as *const u8 as *const libc::c_char,
        );
    }
    if sgpTimedMsgHead.is_null() {
        return 0 as libc::c_int as uint32_t;
    }
    if (*sgpTimedMsgHead).lTime - SDL_GetTicks() as int32_t >= 0 as libc::c_int {
        return 0 as libc::c_int as uint32_t;
    }
    let mut ptMsg: *mut TTimedMsg = sgpTimedMsgHead;
    sgpTimedMsgHead = (*sgpTimedMsgHead).pNext;
    let mut bLen: uint8_t = (*ptMsg).bLen;
    if bLen == 0 {
        assert_fail(
            42 as libc::c_int,
            b"src/tmsg.c\0" as *const u8 as *const libc::c_char,
            b"bLen\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(bLen as uint32_t <= dwMaxLen) {
        assert_fail(
            43 as libc::c_int,
            b"src/tmsg.c\0" as *const u8 as *const libc::c_char,
            b"bLen <= dwMaxLen\0" as *const u8 as *const libc::c_char,
        );
    }
    memcpy(
        pbMsg as *mut libc::c_void,
        ((*ptMsg).bData).as_mut_ptr() as *const libc::c_void,
        bLen as libc::c_ulong,
    );
    let mut p__p: *mut libc::c_void = ptMsg as *mut libc::c_void;
    ptMsg = 0 as *mut TTimedMsg;
    mem_free_dbg(p__p);
    return bLen as uint32_t;
}
#[no_mangle]
pub unsafe extern "C" fn tmsg_add(mut pbMsg: *const uint8_t, mut bLen: uint8_t) {
    if pbMsg.is_null() {
        assert_fail(
            53 as libc::c_int,
            b"src/tmsg.c\0" as *const u8 as *const libc::c_char,
            b"pbMsg\0" as *const u8 as *const libc::c_char,
        );
    }
    if bLen == 0 {
        assert_fail(
            54 as libc::c_int,
            b"src/tmsg.c\0" as *const u8 as *const libc::c_char,
            b"bLen\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut ptMsg: *mut TTimedMsg = DiabloAllocPtr(
        (::core::mem::size_of::<TTimedMsg>() as libc::c_ulong)
            .wrapping_add(bLen as libc::c_ulong) as uint32_t,
    ) as *mut TTimedMsg;
    (*ptMsg).pNext = 0 as *mut TTimedMsg;
    (*ptMsg).lTime = SDL_GetTicks() as int32_t + TIMED_MSG_DELAY as libc::c_int;
    (*ptMsg).bLen = bLen;
    memcpy(
        ((*ptMsg).bData).as_mut_ptr() as *mut libc::c_void,
        pbMsg as *const libc::c_void,
        bLen as libc::c_ulong,
    );
    let mut ppMsg: *mut *mut TTimedMsg = &mut sgpTimedMsgHead;
    while !(*ppMsg).is_null() {
        ppMsg = &mut (**ppMsg).pNext;
    }
    *ppMsg = ptMsg;
}
#[no_mangle]
pub unsafe extern "C" fn tmsg_init() {
    if !sgpTimedMsgHead.is_null() {
        assert_fail(
            72 as libc::c_int,
            b"src/tmsg.c\0" as *const u8 as *const libc::c_char,
            b"!sgpTimedMsgHead\0" as *const u8 as *const libc::c_char,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn tmsg_free() {
    while !sgpTimedMsgHead.is_null() {
        let mut pNext: *mut TTimedMsg = (*sgpTimedMsgHead).pNext;
        let mut p__p: *mut libc::c_void = sgpTimedMsgHead as *mut libc::c_void;
        sgpTimedMsgHead = 0 as *mut TTimedMsg;
        mem_free_dbg(p__p);
        sgpTimedMsgHead = pNext;
    }
}
