use ::libc;
extern "C" {
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn GetRndSeed(file: *const libc::c_char, line: libc::c_int) -> int32_t;
    fn DRLG_HoldThemeRooms();
    fn CreateRndItem(
        _: libc::c_int,
        _: libc::c_int,
        _: bool32_t,
        _: bool32_t,
        _: bool32_t,
    );
    fn CreateTypeItem(
        _: libc::c_int,
        _: libc::c_int,
        _: bool32_t,
        _: libc::c_int,
        _: libc::c_int,
        _: bool32_t,
        _: bool32_t,
    );
    fn ItemNoFlippy() -> libc::c_int;
    fn IsSkel(mt: libc::c_int) -> bool32_t;
    fn SpawnSkeleton(i: libc::c_int, x: libc::c_int, y: libc::c_int) -> bool32_t;
    fn PreSpawnSkeleton() -> libc::c_int;
    fn AddMonster(
        x: libc::c_int,
        y: libc::c_int,
        dir: libc::c_int,
        mtype: libc::c_int,
        InMap: bool32_t,
    ) -> libc::c_int;
    fn IsGoat(mt: libc::c_int) -> bool32_t;
    fn AddObject(_: libc::c_int, _: libc::c_int, _: libc::c_int);
    fn QuestStatus(_: libc::c_int) -> bool32_t;
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut nSolidTable: [uint8_t; 2049];
    static mut nTrapTable: [uint8_t; 2049];
    static mut dPiece: [[libc::c_int; 112]; 112];
    static mut dTransVal: [[int8_t; 112]; 112];
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dMonster: [[libc::c_int; 112]; 112];
    static mut dObject: [[int8_t; 112]; 112];
    static mut dItem: [[int8_t; 112]; 112];
    static mut themeCount: libc::c_int;
    static mut themeLoc: [THEME_LOC; 50];
    static mut item: [ItemStruct; 128];
    static mut nummtypes: libc::c_int;
    static mut Monsters: [CMonster; 16];
    static mut object: [ObjectStruct; 127];
    static mut InitObjFlag: bool32_t;
    static mut theme: [ThemeStruct; 50];
    static mut numthemes: libc::c_int;
    static mut armorFlag: bool32_t;
    static mut bCrossFlag: bool32_t;
    static mut weaponFlag: bool32_t;
    static mut zharlib: libc::c_int;
    static mut numtrigs: libc::c_int;
    static mut trigs: [TriggerStruct; 5];
}
pub type C2RustUnnamed = libc::c_uint;
pub const MAXTHEMES: C2RustUnnamed = 50;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const THEME_NUMGOOD: C2RustUnnamed_0 = 4;
pub const TOTAL_THEMES: C2RustUnnamed_0 = 17;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed_1 = 191;
pub const SETP_TEMP: C2RustUnnamed_1 = 64;
pub const SETP_MASK: C2RustUnnamed_1 = 127;
pub const SETP_BIT: C2RustUnnamed_1 = 128;
pub const BFMASK_MISSILE: C2RustUnnamed_1 = 254;
pub const BFMASK_SETPC: C2RustUnnamed_1 = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed_1 = 239;
pub const BFMASK_PLRLR: C2RustUnnamed_1 = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed_1 = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed_1 = 127;
pub const BFLAG_MISSILE: C2RustUnnamed_1 = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed_1 = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed_1 = 4;
pub const BFLAG_SETPC: C2RustUnnamed_1 = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed_1 = 16;
pub const BFLAG_PLRLR: C2RustUnnamed_1 = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed_1 = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed_1 = 128;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const IT_FOOD: C2RustUnnamed_2 = 14;
pub const IT_AMULET: C2RustUnnamed_2 = 13;
pub const IT_RING: C2RustUnnamed_2 = 12;
pub const IT_GOLD: C2RustUnnamed_2 = 11;
pub const IT_STAFF: C2RustUnnamed_2 = 10;
pub const IT_HARMOR: C2RustUnnamed_2 = 9;
pub const IT_MARMOR: C2RustUnnamed_2 = 8;
pub const IT_HELM: C2RustUnnamed_2 = 7;
pub const IT_ARMOR: C2RustUnnamed_2 = 6;
pub const IT_SHIELD: C2RustUnnamed_2 = 5;
pub const IT_MACE: C2RustUnnamed_2 = 4;
pub const IT_BOW: C2RustUnnamed_2 = 3;
pub const IT_AXE: C2RustUnnamed_2 = 2;
pub const IT_SWORD: C2RustUnnamed_2 = 1;
pub const IT_MISC: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const MPFLAG_UNIQ: C2RustUnnamed_3 = 4;
pub const MPFLAG_DONT: C2RustUnnamed_3 = 2;
pub const MPFLAG_SCATTER: C2RustUnnamed_3 = 1;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const OBJ_VILEPORT: C2RustUnnamed_4 = 0;
pub const OBJ_TORCH: C2RustUnnamed_4 = 0;
pub const OBJ_ALTGIRL: C2RustUnnamed_4 = 0;
pub const OBJ_STALAG5: C2RustUnnamed_4 = 0;
pub const OBJ_STALAG4: C2RustUnnamed_4 = 0;
pub const OBJ_STALAG3: C2RustUnnamed_4 = 0;
pub const OBJ_STALAG2: C2RustUnnamed_4 = 0;
pub const OBJ_STALAG1: C2RustUnnamed_4 = 0;
pub const OBJ_ROCK4: C2RustUnnamed_4 = 0;
pub const OBJ_ROCK3: C2RustUnnamed_4 = 0;
pub const OBJ_ROCK2: C2RustUnnamed_4 = 0;
pub const OBJ_ROCK1: C2RustUnnamed_4 = 0;
pub const OBJ_BIGROCK: C2RustUnnamed_4 = 0;
pub const OBJ_FORGE: C2RustUnnamed_4 = 0;
pub const OBJ_ANVIL: C2RustUnnamed_4 = 0;
pub const OBJ_STNPLATE: C2RustUnnamed_4 = 0;
pub const OBJ_MTLPLATE: C2RustUnnamed_4 = 0;
pub const OBJ_WOODPLATE: C2RustUnnamed_4 = 0;
pub const OBJ_INVPLATE: C2RustUnnamed_4 = 0;
pub const OBJ_DEADSKL: C2RustUnnamed_4 = 0;
pub const OBJ_VAPOR: C2RustUnnamed_4 = 0;
pub const OBJ_NUDEMAN3: C2RustUnnamed_4 = 0;
pub const OBJ_NUDEMAN1R: C2RustUnnamed_4 = 0;
pub const OBJ_NUDEMAN1L: C2RustUnnamed_4 = 0;
pub const OBJ_NUDEW8: C2RustUnnamed_4 = 0;
pub const OBJ_NUDEW2L: C2RustUnnamed_4 = 0;
pub const OBJ_NUDEW1R: C2RustUnnamed_4 = 0;
pub const OBJ_NUDEW1L: C2RustUnnamed_4 = 0;
pub const OBJ_TORTURE6R: C2RustUnnamed_4 = 0;
pub const OBJ_WATERJUG: C2RustUnnamed_4 = 0;
pub const OBJ_SWITCHSKR: C2RustUnnamed_4 = 0;
pub const OBJ_SWITCHRR: C2RustUnnamed_4 = 0;
pub const OBJ_SWITCHRL: C2RustUnnamed_4 = 0;
pub const OBJ_SWITCHMR: C2RustUnnamed_4 = 0;
pub const OBJ_SWITCHML: C2RustUnnamed_4 = 0;
pub const OBJ_STEAMTRAP: C2RustUnnamed_4 = 0;
pub const OBJ_SPKTRAP: C2RustUnnamed_4 = 0;
pub const OBJ_GATER: C2RustUnnamed_4 = 0;
pub const OBJ_GATEL: C2RustUnnamed_4 = 0;
pub const OBJ_FTNR: C2RustUnnamed_4 = 0;
pub const OBJ_FTNL: C2RustUnnamed_4 = 0;
pub const OBJ_FTNROUND: C2RustUnnamed_4 = 0;
pub const OBJ_CHAINLR: C2RustUnnamed_4 = 0;
pub const OBJ_CHAINLL: C2RustUnnamed_4 = 0;
pub const OBJ_CHAING2R: C2RustUnnamed_4 = 0;
pub const OBJ_CHAING2L: C2RustUnnamed_4 = 0;
pub const OBJ_CHAING1R: C2RustUnnamed_4 = 0;
pub const OBJ_CHAING1L: C2RustUnnamed_4 = 0;
pub const OBJ_CHAINER: C2RustUnnamed_4 = 0;
pub const OBJ_CHAINEL: C2RustUnnamed_4 = 0;
pub const OBJ_CANBRA: C2RustUnnamed_4 = 0;
pub const OBJ_BOOK1R: C2RustUnnamed_4 = 0;
pub const OBJ_BOOK1L: C2RustUnnamed_4 = 0;
pub const OBJ_BLOCK: C2RustUnnamed_4 = 0;
pub const OBJ_BLADER: C2RustUnnamed_4 = 0;
pub const OBJ_BLADEL: C2RustUnnamed_4 = 0;
pub const OBJ_SIGNCHEST: C2RustUnnamed_4 = 97;
pub const OBJ_SLAINHERO: C2RustUnnamed_4 = 96;
pub const OBJ_LAZSTAND: C2RustUnnamed_4 = 95;
pub const OBJ_MUSHPATCH: C2RustUnnamed_4 = 94;
pub const OBJ_WEAPONRACKN: C2RustUnnamed_4 = 93;
pub const OBJ_WEAPONRACK: C2RustUnnamed_4 = 92;
pub const OBJ_TBCROSS: C2RustUnnamed_4 = 91;
pub const OBJ_WARWEAP: C2RustUnnamed_4 = 90;
pub const OBJ_WARARMOR: C2RustUnnamed_4 = 89;
pub const OBJ_STEELTOME: C2RustUnnamed_4 = 88;
pub const OBJ_STORYCANDLE: C2RustUnnamed_4 = 87;
pub const OBJ_STORYBOOK: C2RustUnnamed_4 = 86;
pub const OBJ_MCIRCLE2: C2RustUnnamed_4 = 85;
pub const OBJ_MCIRCLE1: C2RustUnnamed_4 = 84;
pub const OBJ_ALTBOY: C2RustUnnamed_4 = 83;
pub const OBJ_TEARFTN: C2RustUnnamed_4 = 82;
pub const OBJ_MURKYFTN: C2RustUnnamed_4 = 81;
pub const OBJ_CAULDRON: C2RustUnnamed_4 = 80;
pub const OBJ_GOATSHRINE: C2RustUnnamed_4 = 79;
pub const OBJ_ARMORSTANDN: C2RustUnnamed_4 = 78;
pub const OBJ_ARMORSTAND: C2RustUnnamed_4 = 77;
pub const OBJ_PURIFYINGFTN: C2RustUnnamed_4 = 76;
pub const OBJ_L3DOORR: C2RustUnnamed_4 = 75;
pub const OBJ_L3DOORL: C2RustUnnamed_4 = 74;
pub const OBJ_PEDISTAL: C2RustUnnamed_4 = 73;
pub const OBJ_BLOODBOOK: C2RustUnnamed_4 = 72;
pub const OBJ_BLINDBOOK: C2RustUnnamed_4 = 71;
pub const OBJ_TCHEST3: C2RustUnnamed_4 = 70;
pub const OBJ_TCHEST2: C2RustUnnamed_4 = 69;
pub const OBJ_TCHEST1: C2RustUnnamed_4 = 68;
pub const OBJ_DECAP: C2RustUnnamed_4 = 67;
pub const OBJ_BLOODFTN: C2RustUnnamed_4 = 66;
pub const OBJ_BOOKCANDLE: C2RustUnnamed_4 = 65;
pub const OBJ_BOOKSTAND: C2RustUnnamed_4 = 64;
pub const OBJ_BOOKCASER: C2RustUnnamed_4 = 63;
pub const OBJ_BOOKCASEL: C2RustUnnamed_4 = 62;
pub const OBJ_SKELBOOK: C2RustUnnamed_4 = 61;
pub const OBJ_SHRINER: C2RustUnnamed_4 = 60;
pub const OBJ_SHRINEL: C2RustUnnamed_4 = 59;
pub const OBJ_BARRELEX: C2RustUnnamed_4 = 58;
pub const OBJ_BARREL: C2RustUnnamed_4 = 57;
pub const OBJ_WEAPRACK: C2RustUnnamed_4 = 56;
pub const OBJ_BOOKSHELF: C2RustUnnamed_4 = 55;
pub const OBJ_TRAPR: C2RustUnnamed_4 = 54;
pub const OBJ_TRAPL: C2RustUnnamed_4 = 53;
pub const OBJ_BOOKLVR: C2RustUnnamed_4 = 52;
pub const OBJ_WATER: C2RustUnnamed_4 = 51;
pub const OBJ_FLAMELVR: C2RustUnnamed_4 = 50;
pub const OBJ_FLAMEHOLE: C2RustUnnamed_4 = 49;
pub const OBJ_SARC: C2RustUnnamed_4 = 48;
pub const OBJ_TORCHR2: C2RustUnnamed_4 = 47;
pub const OBJ_TORCHL2: C2RustUnnamed_4 = 46;
pub const OBJ_TORCHR: C2RustUnnamed_4 = 45;
pub const OBJ_TORCHL: C2RustUnnamed_4 = 44;
pub const OBJ_L2DOORR: C2RustUnnamed_4 = 43;
pub const OBJ_L2DOORL: C2RustUnnamed_4 = 42;
pub const OBJ_BOOK2R: C2RustUnnamed_4 = 41;
pub const OBJ_TORTURE5: C2RustUnnamed_4 = 40;
pub const OBJ_TORTURE4: C2RustUnnamed_4 = 39;
pub const OBJ_TORTURE3: C2RustUnnamed_4 = 38;
pub const OBJ_TORTURE2: C2RustUnnamed_4 = 37;
pub const OBJ_TORTURE1: C2RustUnnamed_4 = 36;
pub const OBJ_TNUDEW3: C2RustUnnamed_4 = 35;
pub const OBJ_TNUDEW2: C2RustUnnamed_4 = 34;
pub const OBJ_TNUDEW1: C2RustUnnamed_4 = 33;
pub const OBJ_TNUDEM4: C2RustUnnamed_4 = 32;
pub const OBJ_TNUDEM3: C2RustUnnamed_4 = 31;
pub const OBJ_TNUDEM2: C2RustUnnamed_4 = 30;
pub const OBJ_TNUDEM1: C2RustUnnamed_4 = 29;
pub const OBJ_SWITCHSKL: C2RustUnnamed_4 = 28;
pub const OBJ_NUDEW2R: C2RustUnnamed_4 = 27;
pub const OBJ_BCROSS: C2RustUnnamed_4 = 26;
pub const OBJ_BOOK2L: C2RustUnnamed_4 = 25;
pub const OBJ_ANGEL: C2RustUnnamed_4 = 24;
pub const OBJ_STAND: C2RustUnnamed_4 = 23;
pub const OBJ_CRUX3: C2RustUnnamed_4 = 22;
pub const OBJ_CRUX2: C2RustUnnamed_4 = 21;
pub const OBJ_CRUX1: C2RustUnnamed_4 = 20;
pub const OBJ_SKSTICK5: C2RustUnnamed_4 = 19;
pub const OBJ_SKSTICK4: C2RustUnnamed_4 = 18;
pub const OBJ_SKSTICK3: C2RustUnnamed_4 = 17;
pub const OBJ_SKSTICK2: C2RustUnnamed_4 = 16;
pub const OBJ_SKSTICK1: C2RustUnnamed_4 = 15;
pub const OBJ_SKPILE: C2RustUnnamed_4 = 14;
pub const OBJ_BANNERR: C2RustUnnamed_4 = 13;
pub const OBJ_BANNERM: C2RustUnnamed_4 = 12;
pub const OBJ_BANNERL: C2RustUnnamed_4 = 11;
pub const OBJ_CANDLEO: C2RustUnnamed_4 = 10;
pub const OBJ_CANDLE2: C2RustUnnamed_4 = 9;
pub const OBJ_CANDLE1: C2RustUnnamed_4 = 8;
pub const OBJ_CHEST3: C2RustUnnamed_4 = 7;
pub const OBJ_CHEST2: C2RustUnnamed_4 = 6;
pub const OBJ_CHEST1: C2RustUnnamed_4 = 5;
pub const OBJ_LEVER: C2RustUnnamed_4 = 4;
pub const OBJ_SKFIRE: C2RustUnnamed_4 = 3;
pub const OBJ_L1DOORR: C2RustUnnamed_4 = 2;
pub const OBJ_L1DOORL: C2RustUnnamed_4 = 1;
pub const OBJ_L1LIGHT: C2RustUnnamed_4 = 0;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const OSEL_ALL: C2RustUnnamed_5 = 3;
pub const OSEL_TOP: C2RustUnnamed_5 = 2;
pub const OSEL_FLR: C2RustUnnamed_5 = 1;
pub const OSEL_NONE: C2RustUnnamed_5 = 0;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const Q_BETRAYER: C2RustUnnamed_6 = 15;
pub const Q_SCHAMB: C2RustUnnamed_6 = 14;
pub const Q_PWATER: C2RustUnnamed_6 = 13;
pub const Q_SKELKING: C2RustUnnamed_6 = 12;
pub const Q_WARLORD: C2RustUnnamed_6 = 11;
pub const Q_ANVIL: C2RustUnnamed_6 = 10;
pub const Q_BLOOD: C2RustUnnamed_6 = 9;
pub const Q_BLIND: C2RustUnnamed_6 = 8;
pub const Q_LTBANNER: C2RustUnnamed_6 = 7;
pub const Q_BUTCHER: C2RustUnnamed_6 = 6;
pub const Q_DIABLO: C2RustUnnamed_6 = 5;
pub const Q_VEIL: C2RustUnnamed_6 = 4;
pub const Q_ZHAR: C2RustUnnamed_6 = 3;
pub const Q_GARBUD: C2RustUnnamed_6 = 2;
pub const Q_BKMUSHRM: C2RustUnnamed_6 = 1;
pub const Q_ROCK: C2RustUnnamed_6 = 0;
pub type C2RustUnnamed_7 = libc::c_int;
pub const THEME_WEAPONRACK: C2RustUnnamed_7 = 16;
pub const THEME_BRNCROSS: C2RustUnnamed_7 = 15;
pub const THEME_TEARFTN: C2RustUnnamed_7 = 14;
pub const THEME_MURKYFTN: C2RustUnnamed_7 = 13;
pub const THEME_CAULDRON: C2RustUnnamed_7 = 12;
pub const THEME_GOATSHRINE: C2RustUnnamed_7 = 11;
pub const THEME_ARMORSTAND: C2RustUnnamed_7 = 10;
pub const THEME_PURIFYINGFTN: C2RustUnnamed_7 = 9;
pub const THEME_DECAP: C2RustUnnamed_7 = 8;
pub const THEME_BLOODFTN: C2RustUnnamed_7 = 7;
pub const THEME_TORTURE: C2RustUnnamed_7 = 6;
pub const THEME_LIBRARY: C2RustUnnamed_7 = 5;
pub const THEME_TREASURE: C2RustUnnamed_7 = 4;
pub const THEME_SKELRM: C2RustUnnamed_7 = 3;
pub const THEME_MONSTPIT: C2RustUnnamed_7 = 2;
pub const THEME_SHRINE: C2RustUnnamed_7 = 1;
pub const THEME_BARREL: C2RustUnnamed_7 = 0;
pub const THEME_NONE: C2RustUnnamed_7 = -1;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
pub type C2RustUnnamed_8 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_8 = 32;
pub const MAXMICRO: C2RustUnnamed_8 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_8 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_8 = 64;
pub const MAXMREND: C2RustUnnamed_8 = 128;
pub const MAXTILES: C2RustUnnamed_8 = 2048;
pub const MDMAXY: C2RustUnnamed_8 = 40;
pub const MDMAXX: C2RustUnnamed_8 = 40;
pub const MAXDUNY: C2RustUnnamed_8 = 112;
pub const MAXDUNX: C2RustUnnamed_8 = 112;
pub const DMAXY: C2RustUnnamed_8 = 112;
pub const DMAXX: C2RustUnnamed_8 = 112;
pub const DIRTEDGED2: C2RustUnnamed_8 = 16;
pub const DIRTEDGE: C2RustUnnamed_8 = 32;
pub const NUMSLEVELS: C2RustUnnamed_8 = 10;
pub const NUMLEVELS: C2RustUnnamed_8 = 17;
pub const LVL4_START: C2RustUnnamed_8 = 13;
pub const LVL3_START: C2RustUnnamed_8 = 9;
pub const LVL2_START: C2RustUnnamed_8 = 5;
pub const LVL1_START: C2RustUnnamed_8 = 1;
pub const TLVL_START: C2RustUnnamed_8 = 0;
pub const LVLLENGTH: C2RustUnnamed_8 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct THEME_LOC {
    pub x: libc::c_int,
    pub y: libc::c_int,
    pub ttval: libc::c_int,
    pub width: libc::c_int,
    pub height: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ObjectStruct {
    pub _otype: libc::c_int,
    pub _ox: libc::c_int,
    pub _oy: libc::c_int,
    pub _oLight: bool32_t,
    pub _oAnimFlag: bool32_t,
    pub _oAnimData: *mut uint8_t,
    pub _oAnimDelay: libc::c_int,
    pub _oAnimCnt: libc::c_int,
    pub _oAnimLen: libc::c_int,
    pub _oAnimFrame: libc::c_int,
    pub _oAnimWidth: int32_t,
    pub _oAnimWidth2: int32_t,
    pub _oDelFlag: bool32_t,
    pub _oBreak: int8_t,
    pub _oSolidFlag: bool32_t,
    pub _oMissFlag: bool32_t,
    pub _oSelFlag: int8_t,
    pub _oPreFlag: bool32_t,
    pub _oTrapFlag: bool32_t,
    pub _oDoorFlag: bool32_t,
    pub _olid: libc::c_int,
    pub _oRndSeed: libc::c_int,
    pub _oVar1: int32_t,
    pub _oVar2: int32_t,
    pub _oVar3: int32_t,
    pub _oVar4: int32_t,
    pub _oVar5: int32_t,
    pub _oVar6: int32_t,
    pub _oVar7: int32_t,
    pub _oVar8: int32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ThemeStruct {
    pub ttype: int8_t,
    pub ttval: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TriggerStruct {
    pub _tx: libc::c_int,
    pub _ty: libc::c_int,
    pub _tmsg: libc::c_uint,
    pub _tlvl: libc::c_int,
}
#[no_mangle]
pub static mut bFountainFlag: bool32_t = 0;
#[no_mangle]
pub static mut cauldronFlag: bool32_t = 0;
#[no_mangle]
pub static mut mFountainFlag: bool32_t = 0;
#[no_mangle]
pub static mut pFountainFlag: bool32_t = 0;
#[no_mangle]
pub static mut tFountainFlag: bool32_t = 0;
#[no_mangle]
pub static mut treasureFlag: bool32_t = 0;
#[no_mangle]
pub static mut themex: libc::c_int = 0;
#[no_mangle]
pub static mut themey: libc::c_int = 0;
#[no_mangle]
pub static mut themeVar1: libc::c_int = 0;
#[no_mangle]
pub static mut ThemeGood: [libc::c_int; 4] = [
    THEME_GOATSHRINE as libc::c_int,
    THEME_SHRINE as libc::c_int,
    THEME_SKELRM as libc::c_int,
    THEME_LIBRARY as libc::c_int,
];
#[no_mangle]
pub static mut ThemeGoodIn: [bool32_t; 4] = [0; 4];
#[no_mangle]
pub static mut trm5x: [libc::c_int; 25] = [
    -(2 as libc::c_int),
    -(1 as libc::c_int),
    0 as libc::c_int,
    1 as libc::c_int,
    2 as libc::c_int,
    -(2 as libc::c_int),
    -(1 as libc::c_int),
    0 as libc::c_int,
    1 as libc::c_int,
    2 as libc::c_int,
    -(2 as libc::c_int),
    -(1 as libc::c_int),
    0 as libc::c_int,
    1 as libc::c_int,
    2 as libc::c_int,
    -(2 as libc::c_int),
    -(1 as libc::c_int),
    0 as libc::c_int,
    1 as libc::c_int,
    2 as libc::c_int,
    -(2 as libc::c_int),
    -(1 as libc::c_int),
    0 as libc::c_int,
    1 as libc::c_int,
    2 as libc::c_int,
];
#[no_mangle]
pub static mut trm5y: [libc::c_int; 25] = [
    -(2 as libc::c_int),
    -(2 as libc::c_int),
    -(2 as libc::c_int),
    -(2 as libc::c_int),
    -(2 as libc::c_int),
    -(1 as libc::c_int),
    -(1 as libc::c_int),
    -(1 as libc::c_int),
    -(1 as libc::c_int),
    -(1 as libc::c_int),
    0 as libc::c_int,
    0 as libc::c_int,
    0 as libc::c_int,
    0 as libc::c_int,
    0 as libc::c_int,
    1 as libc::c_int,
    1 as libc::c_int,
    1 as libc::c_int,
    1 as libc::c_int,
    1 as libc::c_int,
    2 as libc::c_int,
    2 as libc::c_int,
    2 as libc::c_int,
    2 as libc::c_int,
    2 as libc::c_int,
];
#[no_mangle]
pub static mut trm3x: [libc::c_int; 9] = [
    -(1 as libc::c_int),
    0 as libc::c_int,
    1 as libc::c_int,
    -(1 as libc::c_int),
    0 as libc::c_int,
    1 as libc::c_int,
    -(1 as libc::c_int),
    0 as libc::c_int,
    1 as libc::c_int,
];
#[no_mangle]
pub static mut trm3y: [libc::c_int; 9] = [
    -(1 as libc::c_int),
    -(1 as libc::c_int),
    -(1 as libc::c_int),
    0 as libc::c_int,
    0 as libc::c_int,
    0 as libc::c_int,
    1 as libc::c_int,
    1 as libc::c_int,
    1 as libc::c_int,
];
#[no_mangle]
pub unsafe extern "C" fn TFit_Shrine(mut i: libc::c_int) -> bool32_t {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut found: libc::c_int = 0;
    if !((i as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            61 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)i < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    xp = 0 as libc::c_int;
    yp = 0 as libc::c_int;
    found = 0 as libc::c_int;
    while found == 0 {
        if dTransVal[xp as usize][yp as usize] as libc::c_int == theme[i as usize].ttval
        {
            if nTrapTable[dPiece[xp as usize][(yp - 1 as libc::c_int) as usize] as usize]
                as libc::c_int != 0
                && nSolidTable[dPiece[(xp - 1 as libc::c_int) as usize][yp as usize]
                    as usize] == 0
                && nSolidTable[dPiece[(xp + 1 as libc::c_int) as usize][yp as usize]
                    as usize] == 0
                && dTransVal[(xp - 1 as libc::c_int) as usize][yp as usize]
                    as libc::c_int == theme[i as usize].ttval
                && dTransVal[(xp + 1 as libc::c_int) as usize][yp as usize]
                    as libc::c_int == theme[i as usize].ttval
                && dObject[(xp - 1 as libc::c_int)
                    as usize][(yp - 1 as libc::c_int) as usize] as libc::c_int
                    == 0 as libc::c_int
                && dObject[(xp + 1 as libc::c_int)
                    as usize][(yp - 1 as libc::c_int) as usize] as libc::c_int
                    == 0 as libc::c_int
            {
                found = 1 as libc::c_int;
            }
            if found == 0 {
                if nTrapTable[dPiece[(xp - 1 as libc::c_int) as usize][yp as usize]
                    as usize] as libc::c_int != 0
                    && nSolidTable[dPiece[xp as usize][(yp - 1 as libc::c_int) as usize]
                        as usize] == 0
                    && nSolidTable[dPiece[xp as usize][(yp + 1 as libc::c_int) as usize]
                        as usize] == 0
                    && dTransVal[xp as usize][(yp - 1 as libc::c_int) as usize]
                        as libc::c_int == theme[i as usize].ttval
                    && dTransVal[xp as usize][(yp + 1 as libc::c_int) as usize]
                        as libc::c_int == theme[i as usize].ttval
                    && dObject[(xp - 1 as libc::c_int)
                        as usize][(yp - 1 as libc::c_int) as usize] as libc::c_int
                        == 0 as libc::c_int
                    && dObject[(xp - 1 as libc::c_int)
                        as usize][(yp + 1 as libc::c_int) as usize] as libc::c_int
                        == 0 as libc::c_int
                {
                    found = 2 as libc::c_int;
                }
            }
        }
        if found == 0 {
            xp += 1;
            xp;
            if xp == DMAXX as libc::c_int {
                xp = 0 as libc::c_int;
                yp += 1;
                yp;
                if yp == DMAXY as libc::c_int {
                    return 0 as libc::c_int as bool32_t;
                }
            }
        }
    }
    themex = xp;
    themey = yp;
    themeVar1 = found;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn TFit_Obj5(mut t: libc::c_int) -> bool32_t {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut r: libc::c_int = 0;
    let mut rs: libc::c_int = 0;
    let mut found: bool32_t = 0;
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            98 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    xp = 0 as libc::c_int;
    yp = 0 as libc::c_int;
    r = random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        101 as libc::c_int,
        0 as libc::c_int as uint8_t,
        5 as libc::c_int,
    ) + 1 as libc::c_int;
    rs = r;
    while r > 0 as libc::c_int {
        found = 0 as libc::c_int as bool32_t;
        if dTransVal[xp as usize][yp as usize] as libc::c_int == theme[t as usize].ttval
            && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
        {
            found = 1 as libc::c_int as bool32_t;
            i = 0 as libc::c_int;
            while found != 0 && i < 25 as libc::c_int {
                if nSolidTable[dPiece[(xp + trm5x[i as usize])
                    as usize][(yp + trm5y[i as usize]) as usize] as usize] != 0
                {
                    found = 0 as libc::c_int as bool32_t;
                }
                if dTransVal[(xp + trm5x[i as usize])
                    as usize][(yp + trm5y[i as usize]) as usize] as libc::c_int
                    != theme[t as usize].ttval
                {
                    found = 0 as libc::c_int as bool32_t;
                }
                i += 1;
                i;
            }
        }
        if found == 0 {
            xp += 1;
            xp;
            if xp == DMAXX as libc::c_int {
                xp = 0 as libc::c_int;
                yp += 1;
                yp;
                if yp == DMAXY as libc::c_int {
                    if r == rs {
                        return 0 as libc::c_int as bool32_t
                    } else {
                        yp = 0 as libc::c_int;
                    }
                }
            }
        } else {
            r -= 1;
            r;
        }
    }
    themex = xp;
    themey = yp;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn TFit_SkelRoom(mut t: libc::c_int) -> bool32_t {
    let mut i: libc::c_int = 0;
    if leveltype as libc::c_int == 1 as libc::c_int
        || leveltype as libc::c_int == 2 as libc::c_int
    {
        i = 0 as libc::c_int;
        while i < nummtypes {
            if IsSkel(Monsters[i as usize].mtype as libc::c_int) != 0 {
                themeVar1 = i;
                return TFit_Obj5(t);
            }
            i += 1;
            i;
        }
    }
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn TFit_GoatShrine(mut t: libc::c_int) -> bool32_t {
    let mut i: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < nummtypes {
        if IsGoat(Monsters[i as usize].mtype as libc::c_int) != 0 {
            themeVar1 = i;
            return TFit_Obj5(t);
        }
        i += 1;
        i;
    }
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn CheckThemeObj3(
    mut xp: libc::c_int,
    mut yp: libc::c_int,
    mut t: libc::c_int,
    mut f: libc::c_int,
) -> bool32_t {
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            169 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 9 as libc::c_int {
        if xp + trm3x[i as usize] < 0 as libc::c_int
            || yp + trm3y[i as usize] < 0 as libc::c_int
        {
            return 0 as libc::c_int as bool32_t;
        }
        if nSolidTable[dPiece[(xp + trm3x[i as usize])
            as usize][(yp + trm3y[i as usize]) as usize] as usize] != 0
        {
            return 0 as libc::c_int as bool32_t;
        }
        if dTransVal[(xp + trm3x[i as usize])
            as usize][(yp + trm3y[i as usize]) as usize] as libc::c_int
            != theme[t as usize].ttval
        {
            return 0 as libc::c_int as bool32_t;
        }
        if dObject[(xp + trm3x[i as usize]) as usize][(yp + trm3y[i as usize]) as usize]
            as libc::c_int != 0 as libc::c_int
        {
            return 0 as libc::c_int as bool32_t;
        }
        if f != -(1 as libc::c_int)
            && random_(
                b"src/themes.c\0" as *const u8 as *const libc::c_char,
                183 as libc::c_int,
                0 as libc::c_int as uint8_t,
                f,
            ) == 0 as libc::c_int
        {
            return 0 as libc::c_int as bool32_t;
        }
        i += 1;
        i;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn TFit_Obj3(mut t: libc::c_int) -> bool32_t {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut objrnd: [int8_t; 4] = [
        4 as libc::c_int as int8_t,
        4 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        5 as libc::c_int as int8_t,
    ];
    yp = 1 as libc::c_int;
    while yp < DMAXY as libc::c_int - 1 as libc::c_int {
        xp = 1 as libc::c_int;
        while xp < DMAXX as libc::c_int - 1 as libc::c_int {
            if CheckThemeObj3(
                xp,
                yp,
                t,
                objrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                    as libc::c_int,
            ) != 0
            {
                themex = xp;
                themey = yp;
                return 1 as libc::c_int as bool32_t;
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn CheckThemeReqs(mut t: libc::c_int) -> bool32_t {
    let mut rv: bool32_t = 1 as libc::c_int as bool32_t;
    match t {
        1 | 5 => {
            if leveltype as libc::c_int == 3 as libc::c_int
                || leveltype as libc::c_int == 4 as libc::c_int
            {
                rv = 0 as libc::c_int as bool32_t;
            }
        }
        3 => {
            if leveltype as libc::c_int == 3 as libc::c_int
                || leveltype as libc::c_int == 4 as libc::c_int
            {
                rv = 0 as libc::c_int as bool32_t;
            }
        }
        7 => {
            if bFountainFlag == 0 {
                rv = 0 as libc::c_int as bool32_t;
            }
        }
        9 => {
            if pFountainFlag == 0 {
                rv = 0 as libc::c_int as bool32_t;
            }
        }
        13 => {
            if mFountainFlag == 0 {
                rv = 0 as libc::c_int as bool32_t;
            }
        }
        14 => {
            if tFountainFlag == 0 {
                rv = 0 as libc::c_int as bool32_t;
            }
        }
        10 | 16 => {
            if leveltype as libc::c_int == 1 as libc::c_int {
                rv = 0 as libc::c_int as bool32_t;
            }
        }
        12 => {
            if leveltype as libc::c_int != 4 as libc::c_int || cauldronFlag == 0 {
                rv = 0 as libc::c_int as bool32_t;
            }
        }
        _ => {}
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn SpecialThemeFit(
    mut i: libc::c_int,
    mut t: libc::c_int,
) -> bool32_t {
    let mut rv: bool32_t = 1 as libc::c_int as bool32_t;
    rv = CheckThemeReqs(t);
    match t {
        1 | 5 => {
            if rv != 0 {
                rv = TFit_Shrine(i);
            }
        }
        3 => {
            if rv != 0 {
                rv = TFit_SkelRoom(i);
            }
        }
        7 => {
            if rv != 0 {
                rv = TFit_Obj5(i);
            }
            if rv != 0 {
                bFountainFlag = 0 as libc::c_int as bool32_t;
            }
        }
        9 => {
            if rv != 0 {
                rv = TFit_Obj5(i);
            }
            if rv != 0 {
                pFountainFlag = 0 as libc::c_int as bool32_t;
            }
        }
        13 => {
            if rv != 0 {
                rv = TFit_Obj5(i);
            }
            if rv != 0 {
                mFountainFlag = 0 as libc::c_int as bool32_t;
            }
        }
        14 => {
            if rv != 0 {
                rv = TFit_Obj5(i);
            }
            if rv != 0 {
                tFountainFlag = 0 as libc::c_int as bool32_t;
            }
        }
        12 => {
            if rv != 0 {
                rv = TFit_Obj5(i);
            }
            if rv != 0 {
                cauldronFlag = 0 as libc::c_int as bool32_t;
            }
        }
        11 => {
            if rv != 0 {
                rv = TFit_GoatShrine(i);
            }
        }
        8 | 6 | 10 | 15 | 16 => {
            if rv != 0 {
                rv = TFit_Obj3(i);
            }
        }
        4 => {
            rv = treasureFlag;
            if rv != 0 {
                treasureFlag = 0 as libc::c_int as bool32_t;
            }
        }
        _ => {}
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn CheckThemeRoom(mut tv: libc::c_int) -> bool32_t {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut tarea: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < numtrigs {
        if dTransVal[trigs[i as usize]._tx as usize][trigs[i as usize]._ty as usize]
            as libc::c_int == tv
        {
            return 0 as libc::c_int as bool32_t;
        }
        i += 1;
        i;
    }
    tarea = 0 as libc::c_int;
    j = 0 as libc::c_int;
    while j < DMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < DMAXX as libc::c_int {
            if dTransVal[i as usize][j as usize] as libc::c_int == tv {
                if dFlags[i as usize][j as usize] as libc::c_int
                    & BFLAG_SETPC as libc::c_int != 0
                {
                    return 0 as libc::c_int as bool32_t;
                }
                tarea += 1;
                tarea;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    if leveltype as libc::c_int == 1 as libc::c_int {
        if tarea < 9 as libc::c_int || tarea > 100 as libc::c_int {
            return 0 as libc::c_int as bool32_t;
        }
    }
    j = 0 as libc::c_int;
    while j < DMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < DMAXX as libc::c_int {
            if dTransVal[i as usize][j as usize] as libc::c_int == tv
                && nSolidTable[dPiece[i as usize][j as usize] as usize] == 0
            {
                if dTransVal[(i - 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    != tv
                    && nSolidTable[dPiece[(i - 1 as libc::c_int) as usize][j as usize]
                        as usize] == 0
                {
                    return 0 as libc::c_int as bool32_t;
                }
                if dTransVal[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    != tv
                    && nSolidTable[dPiece[(i + 1 as libc::c_int) as usize][j as usize]
                        as usize] == 0
                {
                    return 0 as libc::c_int as bool32_t;
                }
                if dTransVal[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    != tv
                    && nSolidTable[dPiece[i as usize][(j - 1 as libc::c_int) as usize]
                        as usize] == 0
                {
                    return 0 as libc::c_int as bool32_t;
                }
                if dTransVal[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    != tv
                    && nSolidTable[dPiece[i as usize][(j + 1 as libc::c_int) as usize]
                        as usize] == 0
                {
                    return 0 as libc::c_int as bool32_t;
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn InitThemes() {
    let mut i: libc::c_int = 0;
    let mut t: libc::c_int = 0;
    numthemes = 0 as libc::c_int;
    zharlib = -(1 as libc::c_int);
    armorFlag = 1 as libc::c_int as bool32_t;
    bFountainFlag = 1 as libc::c_int as bool32_t;
    cauldronFlag = 1 as libc::c_int as bool32_t;
    mFountainFlag = 1 as libc::c_int as bool32_t;
    pFountainFlag = 1 as libc::c_int as bool32_t;
    tFountainFlag = 1 as libc::c_int as bool32_t;
    treasureFlag = 1 as libc::c_int as bool32_t;
    bCrossFlag = 0 as libc::c_int as bool32_t;
    weaponFlag = 1 as libc::c_int as bool32_t;
    if currlevel as libc::c_int == 16 as libc::c_int {
        return;
    }
    if leveltype as libc::c_int == 1 as libc::c_int {
        i = 0 as libc::c_int;
        while i < THEME_NUMGOOD as libc::c_int {
            ThemeGoodIn[i as usize] = 0 as libc::c_int as bool32_t;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < 256 as libc::c_int && numthemes < MAXTHEMES as libc::c_int {
            if CheckThemeRoom(i) != 0 {
                theme[numthemes as usize].ttval = i;
                t = ThemeGood[random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    428 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    THEME_NUMGOOD as libc::c_int,
                ) as usize];
                while SpecialThemeFit(numthemes, t) == 0 {
                    t = random_(
                        b"src/themes.c\0" as *const u8 as *const libc::c_char,
                        430 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        TOTAL_THEMES as libc::c_int,
                    );
                }
                theme[numthemes as usize].ttype = t as int8_t;
                numthemes += 1;
                numthemes;
            }
            i += 1;
            i;
        }
    }
    if leveltype as libc::c_int == 2 as libc::c_int
        || leveltype as libc::c_int == 3 as libc::c_int
        || leveltype as libc::c_int == 4 as libc::c_int
    {
        if !((themeCount as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
            assert_fail(
                441 as libc::c_int,
                b"src/themes.c\0" as *const u8 as *const libc::c_char,
                b"(uint32_t)themeCount < MAXTHEMES\0" as *const u8 as *const libc::c_char,
            );
        }
        i = 0 as libc::c_int;
        while i < themeCount {
            theme[i as usize].ttype = THEME_NONE as libc::c_int as int8_t;
            i += 1;
            i;
        }
        if QuestStatus(Q_ZHAR as libc::c_int) != 0 {
            i = 0 as libc::c_int;
            while i < themeCount {
                theme[i as usize].ttval = themeLoc[i as usize].ttval;
                if SpecialThemeFit(i, THEME_LIBRARY as libc::c_int) != 0 {
                    theme[i as usize].ttype = THEME_LIBRARY as libc::c_int as int8_t;
                    zharlib = i;
                    break;
                } else {
                    i += 1;
                    i;
                }
            }
        }
        i = 0 as libc::c_int;
        while i < themeCount {
            if theme[i as usize].ttype as libc::c_int == THEME_NONE as libc::c_int {
                theme[i as usize].ttval = themeLoc[i as usize].ttval;
                t = ThemeGood[random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    462 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    THEME_NUMGOOD as libc::c_int,
                ) as usize];
                while SpecialThemeFit(i, t) == 0 {
                    t = random_(
                        b"src/themes.c\0" as *const u8 as *const libc::c_char,
                        464 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        TOTAL_THEMES as libc::c_int,
                    );
                }
                theme[i as usize].ttype = t as int8_t;
            }
            i += 1;
            i;
        }
        numthemes += themeCount;
    }
}
#[no_mangle]
pub unsafe extern "C" fn HoldThemeRooms() {
    let mut i: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut tv: int8_t = 0;
    if currlevel as libc::c_int == 16 as libc::c_int {
        return;
    }
    if !((numthemes as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            482 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)numthemes < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    if leveltype as libc::c_int == 1 as libc::c_int {
        i = 0 as libc::c_int;
        while i < numthemes {
            tv = theme[i as usize].ttval as int8_t;
            y = 0 as libc::c_int;
            while y < DMAXY as libc::c_int {
                x = 0 as libc::c_int;
                while x < DMAXX as libc::c_int {
                    if dTransVal[x as usize][y as usize] as libc::c_int
                        == tv as libc::c_int
                    {
                        dFlags[x
                            as usize][y
                            as usize] = (dFlags[x as usize][y as usize] as libc::c_int
                            | BFLAG_SETPC as libc::c_int) as int8_t;
                    }
                    x += 1;
                    x;
                }
                y += 1;
                y;
            }
            i += 1;
            i;
        }
    } else {
        DRLG_HoldThemeRooms();
    };
}
#[no_mangle]
pub unsafe extern "C" fn PlaceThemeMonsts(mut t: libc::c_int, mut f: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut mtype: libc::c_int = 0;
    let mut scattertypes: [libc::c_int; 111] = [0; 111];
    let mut numscattypes: libc::c_int = 0 as libc::c_int;
    let mut i: libc::c_int = 0;
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            506 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    i = 0 as libc::c_int;
    while i < nummtypes {
        if Monsters[i as usize].mPlaceFlags as libc::c_int
            & MPFLAG_SCATTER as libc::c_int != 0
        {
            let fresh0 = numscattypes;
            numscattypes = numscattypes + 1;
            scattertypes[fresh0 as usize] = i;
        }
        i += 1;
        i;
    }
    mtype = scattertypes[random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        512 as libc::c_int,
        0 as libc::c_int as uint8_t,
        numscattypes,
    ) as usize];
    yp = 0 as libc::c_int;
    while yp < DMAXY as libc::c_int {
        xp = 0 as libc::c_int;
        while xp < DMAXX as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
                && dItem[xp as usize][yp as usize] as libc::c_int == 0 as libc::c_int
                && dObject[xp as usize][yp as usize] as libc::c_int == 0 as libc::c_int
            {
                if random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    517 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    f,
                ) == 0 as libc::c_int
                {
                    AddMonster(
                        xp,
                        yp,
                        random_(
                            b"src/themes.c\0" as *const u8 as *const libc::c_char,
                            518 as libc::c_int,
                            0 as libc::c_int as uint8_t,
                            8 as libc::c_int,
                        ),
                        mtype,
                        1 as libc::c_int as bool32_t,
                    );
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
}
#[no_mangle]
pub unsafe extern "C" fn PlaceSpecificThemeMonsts(
    mut t: libc::c_int,
    mut f: libc::c_int,
    mut mtype: libc::c_int,
) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            528 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    yp = 0 as libc::c_int;
    while yp < DMAXY as libc::c_int {
        xp = 0 as libc::c_int;
        while xp < DMAXX as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
                && dItem[xp as usize][yp as usize] as libc::c_int == 0 as libc::c_int
                && dObject[xp as usize][yp as usize] as libc::c_int == 0 as libc::c_int
            {
                if random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    532 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    f,
                ) == 0 as libc::c_int
                {
                    AddMonster(
                        xp,
                        yp,
                        random_(
                            b"src/themes.c\0" as *const u8 as *const libc::c_char,
                            533 as libc::c_int,
                            0 as libc::c_int as uint8_t,
                            8 as libc::c_int,
                        ),
                        mtype,
                        1 as libc::c_int as bool32_t,
                    );
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
}
#[no_mangle]
pub unsafe extern "C" fn Theme_Barrel(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut r: libc::c_int = 0;
    let mut barrnd: [int8_t; 4] = [
        2 as libc::c_int as int8_t,
        6 as libc::c_int as int8_t,
        4 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
    ];
    let mut monstrnd: [int8_t; 4] = [
        5 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            545 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    yp = 0 as libc::c_int;
    while yp < DMAXY as libc::c_int {
        xp = 0 as libc::c_int;
        while xp < DMAXX as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
            {
                if random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    549 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    barrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                        as int32_t,
                ) == 0
                {
                    if random_(
                        b"src/themes.c\0" as *const u8 as *const libc::c_char,
                        550 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        barrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                            as int32_t,
                    ) == 0
                    {
                        r = OBJ_BARREL as libc::c_int;
                    } else {
                        r = OBJ_BARRELEX as libc::c_int;
                    }
                    AddObject(r, xp, yp);
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_Shrine(mut t: libc::c_int) {
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        6 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    TFit_Shrine(t);
    if themeVar1 == 1 as libc::c_int {
        AddObject(OBJ_CANDLE2 as libc::c_int, themex - 1 as libc::c_int, themey);
        AddObject(OBJ_SHRINER as libc::c_int, themex, themey);
        AddObject(OBJ_CANDLE2 as libc::c_int, themex + 1 as libc::c_int, themey);
    } else {
        AddObject(OBJ_CANDLE2 as libc::c_int, themex, themey - 1 as libc::c_int);
        AddObject(OBJ_SHRINEL as libc::c_int, themex, themey);
        AddObject(OBJ_CANDLE2 as libc::c_int, themex, themey + 1 as libc::c_int);
    }
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_MonstPit(mut t: libc::c_int) {
    let mut r: libc::c_int = 0;
    let mut ixp: libc::c_int = 0;
    let mut iyp: libc::c_int = 0;
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            583 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    r = random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        584 as libc::c_int,
        0 as libc::c_int as uint8_t,
        100 as libc::c_int,
    ) + 1 as libc::c_int;
    ixp = 0 as libc::c_int;
    iyp = 0 as libc::c_int;
    while r > 0 as libc::c_int {
        if dTransVal[ixp as usize][iyp as usize] as libc::c_int
            == theme[t as usize].ttval
            && nSolidTable[dPiece[ixp as usize][iyp as usize] as usize] == 0
        {
            r -= 1;
            r;
        }
        if r > 0 as libc::c_int {
            ixp += 1;
            ixp;
            if ixp == DMAXX as libc::c_int {
                ixp = 0 as libc::c_int;
                iyp += 1;
                iyp;
                if iyp == DMAXY as libc::c_int {
                    iyp = 0 as libc::c_int;
                }
            }
        }
    }
    CreateRndItem(
        ixp,
        iyp,
        1 as libc::c_int as bool32_t,
        0 as libc::c_int as bool32_t,
        1 as libc::c_int as bool32_t,
    );
    ItemNoFlippy();
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_SkelRoom(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut ii: libc::c_int = 0;
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    TFit_SkelRoom(t);
    xp = themex;
    yp = themey;
    AddObject(OBJ_SKFIRE as libc::c_int, xp, yp);
    if random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        617 as libc::c_int,
        0 as libc::c_int as uint8_t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as int32_t,
    ) != 0
    {
        ii = PreSpawnSkeleton();
        SpawnSkeleton(ii, xp - 1 as libc::c_int, yp - 1 as libc::c_int);
    } else {
        AddObject(
            OBJ_BANNERL as libc::c_int,
            xp - 1 as libc::c_int,
            yp - 1 as libc::c_int,
        );
    }
    ii = PreSpawnSkeleton();
    SpawnSkeleton(ii, xp, yp - 1 as libc::c_int);
    if random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        625 as libc::c_int,
        0 as libc::c_int as uint8_t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as int32_t,
    ) != 0
    {
        ii = PreSpawnSkeleton();
        SpawnSkeleton(ii, xp + 1 as libc::c_int, yp - 1 as libc::c_int);
    } else {
        AddObject(
            OBJ_BANNERR as libc::c_int,
            xp + 1 as libc::c_int,
            yp - 1 as libc::c_int,
        );
    }
    if random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        631 as libc::c_int,
        0 as libc::c_int as uint8_t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as int32_t,
    ) != 0
    {
        ii = PreSpawnSkeleton();
        SpawnSkeleton(ii, xp - 1 as libc::c_int, yp);
    } else {
        AddObject(OBJ_BANNERM as libc::c_int, xp - 1 as libc::c_int, yp);
    }
    if random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        637 as libc::c_int,
        0 as libc::c_int as uint8_t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as int32_t,
    ) != 0
    {
        ii = PreSpawnSkeleton();
        SpawnSkeleton(ii, xp + 1 as libc::c_int, yp);
    } else {
        AddObject(OBJ_BANNERM as libc::c_int, xp + 1 as libc::c_int, yp);
    }
    if random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        643 as libc::c_int,
        0 as libc::c_int as uint8_t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as int32_t,
    ) != 0
    {
        ii = PreSpawnSkeleton();
        SpawnSkeleton(ii, xp - 1 as libc::c_int, yp + 1 as libc::c_int);
    } else {
        AddObject(
            OBJ_BANNERR as libc::c_int,
            xp - 1 as libc::c_int,
            yp + 1 as libc::c_int,
        );
    }
    ii = PreSpawnSkeleton();
    SpawnSkeleton(ii, xp, yp + 1 as libc::c_int);
    if random_(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        651 as libc::c_int,
        0 as libc::c_int as uint8_t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as int32_t,
    ) != 0
    {
        ii = PreSpawnSkeleton();
        SpawnSkeleton(ii, xp + 1 as libc::c_int, yp + 1 as libc::c_int);
    } else {
        AddObject(
            OBJ_BANNERL as libc::c_int,
            xp + 1 as libc::c_int,
            yp + 1 as libc::c_int,
        );
    }
    if dObject[xp as usize][(yp - 3 as libc::c_int) as usize] as libc::c_int
        == 0 as libc::c_int
    {
        AddObject(OBJ_SKELBOOK as libc::c_int, xp, yp - 2 as libc::c_int);
    }
    if dObject[xp as usize][(yp + 3 as libc::c_int) as usize] as libc::c_int
        == 0 as libc::c_int
    {
        AddObject(OBJ_SKELBOOK as libc::c_int, xp, yp + 2 as libc::c_int);
    }
}
#[no_mangle]
pub unsafe extern "C" fn Theme_Treasure(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut treasrnd: [int8_t; 4] = [
        4 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        10 as libc::c_int as int8_t,
    ];
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
    ];
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            671 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    GetRndSeed(
        b"src/themes.c\0" as *const u8 as *const libc::c_char,
        672 as libc::c_int,
    );
    yp = 0 as libc::c_int;
    while yp < DMAXY as libc::c_int {
        xp = 0 as libc::c_int;
        while xp < DMAXX as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
            {
                let mut rv: libc::c_int = random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    676 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    treasrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                        as int32_t,
                );
                if random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    677 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    treasrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                        as int32_t,
                ) * 2 as libc::c_int == 0
                {
                    CreateTypeItem(
                        xp,
                        yp,
                        0 as libc::c_int as bool32_t,
                        IT_GOLD as libc::c_int,
                        0 as libc::c_int,
                        0 as libc::c_int as bool32_t,
                        1 as libc::c_int as bool32_t,
                    );
                    let mut i: libc::c_int = ItemNoFlippy();
                    if rv
                        >= treasrnd[(leveltype as libc::c_int - 1 as libc::c_int)
                            as usize] as libc::c_int - 2 as libc::c_int
                    {
                        if leveltype as libc::c_int != 1 as libc::c_int {
                            item[i as usize]._ivalue /= 2 as libc::c_int;
                        }
                    }
                }
                if rv == 0 as libc::c_int {
                    CreateRndItem(
                        xp,
                        yp,
                        0 as libc::c_int as bool32_t,
                        0 as libc::c_int as bool32_t,
                        1 as libc::c_int as bool32_t,
                    );
                    ItemNoFlippy();
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_Library(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut oi: libc::c_int = 0;
    let mut librnd: [int8_t; 4] = [
        1 as libc::c_int as int8_t,
        2 as libc::c_int as int8_t,
        2 as libc::c_int as int8_t,
        5 as libc::c_int as int8_t,
    ];
    let mut monstrnd: [int8_t; 4] = [
        5 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    TFit_Shrine(t);
    if themeVar1 == 1 as libc::c_int {
        AddObject(OBJ_BOOKCANDLE as libc::c_int, themex - 1 as libc::c_int, themey);
        AddObject(OBJ_BOOKCASER as libc::c_int, themex, themey);
        AddObject(OBJ_BOOKCANDLE as libc::c_int, themex + 1 as libc::c_int, themey);
    } else {
        AddObject(OBJ_BOOKCANDLE as libc::c_int, themex, themey - 1 as libc::c_int);
        AddObject(OBJ_BOOKCASEL as libc::c_int, themex, themey);
        AddObject(OBJ_BOOKCANDLE as libc::c_int, themex, themey + 1 as libc::c_int);
    }
    yp = 1 as libc::c_int;
    while yp < DMAXY as libc::c_int - 1 as libc::c_int {
        xp = 1 as libc::c_int;
        while xp < DMAXX as libc::c_int - 1 as libc::c_int {
            if CheckThemeObj3(xp, yp, t, -(1 as libc::c_int)) != 0
                && dMonster[xp as usize][yp as usize] == 0 as libc::c_int
                && random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    718 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    librnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                        as int32_t,
                ) == 0
            {
                AddObject(OBJ_BOOKSTAND as libc::c_int, xp, yp);
                if random_(
                    b"src/themes.c\0" as *const u8 as *const libc::c_char,
                    721 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    (librnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                        as libc::c_int) << 1 as libc::c_int,
                ) != 0
                {
                    if dObject[xp as usize][yp as usize] as libc::c_int
                        > 0 as libc::c_int
                    {
                        oi = dObject[xp as usize][yp as usize] as libc::c_int
                            - 1 as libc::c_int;
                        object[oi as usize]
                            ._oSelFlag = OSEL_NONE as libc::c_int as int8_t;
                        object[oi as usize]._oAnimFrame += 2 as libc::c_int;
                    }
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    if QuestStatus(Q_ZHAR as libc::c_int) != 0 {
        if t != zharlib {
            PlaceThemeMonsts(t, monstrnd[leveltype as usize] as libc::c_int);
        }
    } else {
        PlaceThemeMonsts(t, monstrnd[leveltype as usize] as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn Theme_Torture(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut tortrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
    ];
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            752 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    yp = 1 as libc::c_int;
    while yp < DMAXY as libc::c_int - 1 as libc::c_int {
        xp = 1 as libc::c_int;
        while xp < DMAXX as libc::c_int - 1 as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
            {
                if CheckThemeObj3(xp, yp, t, -(1 as libc::c_int)) != 0
                    && random_(
                        b"src/themes.c\0" as *const u8 as *const libc::c_char,
                        757 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        tortrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                            as int32_t,
                    ) == 0
                {
                    AddObject(OBJ_TNUDEM2 as libc::c_int, xp, yp);
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_BloodFountain(mut t: libc::c_int) {
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    TFit_Obj5(t);
    AddObject(OBJ_BLOODFTN as libc::c_int, themex, themey);
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_Decap(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut decaprnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
    ];
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            779 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    yp = 1 as libc::c_int;
    while yp < DMAXY as libc::c_int - 1 as libc::c_int {
        xp = 1 as libc::c_int;
        while xp < DMAXX as libc::c_int - 1 as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
            {
                if CheckThemeObj3(xp, yp, t, -(1 as libc::c_int)) != 0
                    && random_(
                        b"src/themes.c\0" as *const u8 as *const libc::c_char,
                        784 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        decaprnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                            as int32_t,
                    ) == 0
                {
                    AddObject(OBJ_DECAP as libc::c_int, xp, yp);
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_PurifyingFountain(mut t: libc::c_int) {
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    TFit_Obj5(t);
    AddObject(OBJ_PURIFYINGFTN as libc::c_int, themex, themey);
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_ArmorStand(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut armorrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
    ];
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            806 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    if armorFlag != 0 {
        TFit_Obj3(t);
        AddObject(OBJ_ARMORSTAND as libc::c_int, themex, themey);
    }
    yp = 0 as libc::c_int;
    while yp < DMAXY as libc::c_int {
        xp = 0 as libc::c_int;
        while xp < DMAXX as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
            {
                if CheckThemeObj3(xp, yp, t, -(1 as libc::c_int)) != 0
                    && random_(
                        b"src/themes.c\0" as *const u8 as *const libc::c_char,
                        816 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        armorrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                            as int32_t,
                    ) == 0
                {
                    AddObject(OBJ_ARMORSTANDN as libc::c_int, xp, yp);
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
    armorFlag = 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn Theme_GoatShrine(mut t: libc::c_int) {
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            830 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    TFit_GoatShrine(t);
    AddObject(OBJ_GOATSHRINE as libc::c_int, themex, themey);
    yy = themey - 1 as libc::c_int;
    while yy <= themey + 1 as libc::c_int {
        xx = themex - 1 as libc::c_int;
        while xx <= themex + 1 as libc::c_int {
            if dTransVal[xx as usize][yy as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xx as usize][yy as usize] as usize] == 0
            {
                if !(xx == themex && yy == themey) {
                    AddMonster(
                        xx,
                        yy,
                        1 as libc::c_int,
                        themeVar1,
                        1 as libc::c_int as bool32_t,
                    );
                }
            }
            xx += 1;
            xx;
        }
        yy += 1;
        yy;
    }
}
#[no_mangle]
pub unsafe extern "C" fn Theme_Cauldron(mut t: libc::c_int) {
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    TFit_Obj5(t);
    AddObject(OBJ_CAULDRON as libc::c_int, themex, themey);
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_MurkyFountain(mut t: libc::c_int) {
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    TFit_Obj5(t);
    AddObject(OBJ_MURKYFTN as libc::c_int, themex, themey);
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_TearFountain(mut t: libc::c_int) {
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    TFit_Obj5(t);
    AddObject(OBJ_TEARFTN as libc::c_int, themex, themey);
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn Theme_BrnCross(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    let mut bcrossrnd: [int8_t; 4] = [
        5 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
    ];
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            878 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    yp = 0 as libc::c_int;
    while yp < DMAXY as libc::c_int {
        xp = 0 as libc::c_int;
        while xp < DMAXX as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
            {
                if CheckThemeObj3(xp, yp, t, -(1 as libc::c_int)) != 0
                    && random_(
                        b"src/themes.c\0" as *const u8 as *const libc::c_char,
                        882 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        bcrossrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                            as int32_t,
                    ) == 0
                {
                    AddObject(OBJ_TBCROSS as libc::c_int, xp, yp);
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
    bCrossFlag = 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn Theme_WeaponRack(mut t: libc::c_int) {
    let mut xp: libc::c_int = 0;
    let mut yp: libc::c_int = 0;
    let mut weaponrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
        5 as libc::c_int as int8_t,
        8 as libc::c_int as int8_t,
    ];
    let mut monstrnd: [int8_t; 4] = [
        6 as libc::c_int as int8_t,
        7 as libc::c_int as int8_t,
        3 as libc::c_int as int8_t,
        9 as libc::c_int as int8_t,
    ];
    if !((t as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            898 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)t < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    if weaponFlag != 0 {
        TFit_Obj3(t);
        AddObject(OBJ_WEAPONRACK as libc::c_int, themex, themey);
    }
    yp = 0 as libc::c_int;
    while yp < DMAXY as libc::c_int {
        xp = 0 as libc::c_int;
        while xp < DMAXX as libc::c_int {
            if dTransVal[xp as usize][yp as usize] as libc::c_int
                == theme[t as usize].ttval
                && nSolidTable[dPiece[xp as usize][yp as usize] as usize] == 0
            {
                if CheckThemeObj3(xp, yp, t, -(1 as libc::c_int)) != 0
                    && random_(
                        b"src/themes.c\0" as *const u8 as *const libc::c_char,
                        908 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        weaponrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize]
                            as int32_t,
                    ) == 0
                {
                    AddObject(OBJ_WEAPONRACKN as libc::c_int, xp, yp);
                }
            }
            xp += 1;
            xp;
        }
        yp += 1;
        yp;
    }
    PlaceThemeMonsts(
        t,
        monstrnd[(leveltype as libc::c_int - 1 as libc::c_int) as usize] as libc::c_int,
    );
    weaponFlag = 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn UpdateL4Trans() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < DMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < DMAXX as libc::c_int {
            if dTransVal[i as usize][j as usize] as libc::c_int != 0 as libc::c_int {
                dTransVal[i as usize][j as usize] = 1 as libc::c_int as int8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn CreateThemeRooms() {
    let mut i: libc::c_int = 0;
    if currlevel as libc::c_int == 16 as libc::c_int {
        return;
    }
    InitObjFlag = 1 as libc::c_int as bool32_t;
    if !((numthemes as uint32_t) < MAXTHEMES as libc::c_int as uint32_t) {
        assert_fail(
            939 as libc::c_int,
            b"src/themes.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)numthemes < MAXTHEMES\0" as *const u8 as *const libc::c_char,
        );
    }
    i = 0 as libc::c_int;
    while i < numthemes {
        themex = 0 as libc::c_int;
        themey = 0 as libc::c_int;
        match theme[i as usize].ttype as libc::c_int {
            0 => {
                Theme_Barrel(i);
            }
            1 => {
                Theme_Shrine(i);
            }
            2 => {
                Theme_MonstPit(i);
            }
            3 => {
                Theme_SkelRoom(i);
            }
            4 => {
                Theme_Treasure(i);
            }
            5 => {
                Theme_Library(i);
            }
            6 => {
                Theme_Torture(i);
            }
            7 => {
                Theme_BloodFountain(i);
            }
            8 => {
                Theme_Decap(i);
            }
            9 => {
                Theme_PurifyingFountain(i);
            }
            10 => {
                Theme_ArmorStand(i);
            }
            11 => {
                Theme_GoatShrine(i);
            }
            12 => {
                Theme_Cauldron(i);
            }
            14 => {
                Theme_TearFountain(i);
            }
            13 => {
                Theme_MurkyFountain(i);
            }
            15 => {
                Theme_BrnCross(i);
            }
            16 => {
                Theme_WeaponRack(i);
            }
            _ => {}
        }
        i += 1;
        i;
    }
    InitObjFlag = 0 as libc::c_int as bool32_t;
    if leveltype as libc::c_int == 4 as libc::c_int && themeCount > 0 as libc::c_int {
        UpdateL4Trans();
    }
}
