use ::libc;
extern "C" {
    fn abs(_: libc::c_int) -> libc::c_int;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn GetDirection(
        x1: libc::c_int,
        y1: libc::c_int,
        x2: libc::c_int,
        y2: libc::c_int,
    ) -> libc::c_int;
    fn M_StartStand(i: libc::c_int, md: libc::c_int);
    fn M_WalkDir(i: libc::c_int, md: libc::c_int);
    fn DirOK(i: libc::c_int, mdir: libc::c_int) -> bool32_t;
    fn encode_enemy(m: libc::c_int) -> libc::c_int;
    fn decode_enemy(m: libc::c_int, enemy: libc::c_int);
    fn M_ClearSquares(i: libc::c_int);
    fn delta_sync_monster(pSync: *const TSyncMonster, bLevel: uint8_t);
    static mut currlevel: uint8_t;
    static mut dMonster: [[libc::c_int; 112]; 112];
    static mut item: [ItemStruct; 128];
    static mut numitems: int32_t;
    static mut itemactive: [libc::c_int; 127];
    static mut monster: [MonsterStruct; 200];
    static mut nummonsters: int32_t;
    static mut monstactive: [libc::c_int; 200];
    static mut gbBufferMsgs: uint8_t;
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const LRU_INIT: C2RustUnnamed = 255;
pub const LRU_REINIT: C2RustUnnamed = 65534;
pub const LRU_NEVER: C2RustUnnamed = 65535;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const ITEM_GOLD: C2RustUnnamed_0 = 168;
pub const ITEM_SBATLBOW: C2RustUnnamed_0 = 167;
pub const ITEM_COMPSTF: C2RustUnnamed_0 = 166;
pub const ITEM_SWARBOW: C2RustUnnamed_0 = 165;
pub const ITEM_WINDFOR: C2RustUnnamed_0 = 164;
pub const ITEM_REAVER: C2RustUnnamed_0 = 163;
pub const ITEM_PROTECT: C2RustUnnamed_0 = 162;
pub const ITEM_GRANDPA: C2RustUnnamed_0 = 161;
pub const ITEM_GRIZZLY: C2RustUnnamed_0 = 160;
pub const ITEM_NAJARMOR: C2RustUnnamed_0 = 159;
pub const ITEM_CROSBOW: C2RustUnnamed_0 = 158;
pub const ITEM_ARKARMOR: C2RustUnnamed_0 = 157;
pub const ITEM_GEMGRTAXE: C2RustUnnamed_0 = 156;
pub const ITEM_BISHOPSTF: C2RustUnnamed_0 = 155;
pub const ITEM_RINGMAIL: C2RustUnnamed_0 = 154;
pub const ITEM_BPLATE: C2RustUnnamed_0 = 153;
pub const ITEM_PARMOR3: C2RustUnnamed_0 = 152;
pub const ITEM_PARMOR2: C2RustUnnamed_0 = 151;
pub const ITEM_CAPE: C2RustUnnamed_0 = 150;
pub const ITEM_CLOAK: C2RustUnnamed_0 = 149;
pub const ITEM_LRGSHLD: C2RustUnnamed_0 = 148;
pub const ITEM_KITESHLD: C2RustUnnamed_0 = 147;
pub const ITEM_IRONSHLD: C2RustUnnamed_0 = 146;
pub const ITEM_GREATAXE: C2RustUnnamed_0 = 145;
pub const ITEM_HANDAXE: C2RustUnnamed_0 = 144;
pub const ITEM_WICKAXE: C2RustUnnamed_0 = 143;
pub const ITEM_LRGAXE: C2RustUnnamed_0 = 142;
pub const ITEM_BROADAXE: C2RustUnnamed_0 = 141;
pub const ITEM_ANVIL: C2RustUnnamed_0 = 140;
pub const ITEM_RINGARMOR: C2RustUnnamed_0 = 139;
pub const ITEM_HVYROBE: C2RustUnnamed_0 = 138;
pub const ITEM_ROBE: C2RustUnnamed_0 = 137;
pub const ITEM_SPLTARMOR: C2RustUnnamed_0 = 136;
pub const ITEM_LARMOR: C2RustUnnamed_0 = 135;
pub const ITEM_GRTSWORD: C2RustUnnamed_0 = 134;
pub const ITEM_HNTRBOW: C2RustUnnamed_0 = 133;
pub const ITEM_TSHIELD: C2RustUnnamed_0 = 132;
pub const ITEM_FLAIL: C2RustUnnamed_0 = 131;
pub const ITEM_BALLNCHN: C2RustUnnamed_0 = 130;
pub const ITEM_QARMOR: C2RustUnnamed_0 = 129;
pub const ITEM_RAGS: C2RustUnnamed_0 = 128;
pub const ITEM_HLARMOR: C2RustUnnamed_0 = 127;
pub const ITEM_INNSIGN: C2RustUnnamed_0 = 126;
pub const ITEM_LONGSTAFF: C2RustUnnamed_0 = 125;
pub const ITEM_STLSTAFF: C2RustUnnamed_0 = 124;
pub const ITEM_IRONSTAFF: C2RustUnnamed_0 = 123;
pub const ITEM_MAUL: C2RustUnnamed_0 = 122;
pub const ITEM_SMLWARHAM: C2RustUnnamed_0 = 121;
pub const ITEM_STLSHRTBOW: C2RustUnnamed_0 = 120;
pub const ITEM_STLLONGBOW: C2RustUnnamed_0 = 119;
pub const ITEM_SHORTBOW: C2RustUnnamed_0 = 118;
pub const ITEM_WOLFSHLD: C2RustUnnamed_0 = 117;
pub const ITEM_SKULLSHLD: C2RustUnnamed_0 = 116;
pub const ITEM_SMLSHLD: C2RustUnnamed_0 = 115;
pub const ITEM_SCLARMOR: C2RustUnnamed_0 = 114;
pub const ITEM_HVYSHIELD: C2RustUnnamed_0 = 113;
pub const ITEM_SMALLAXE: C2RustUnnamed_0 = 112;
pub const ITEM_CHARMOR: C2RustUnnamed_0 = 111;
pub const ITEM_2HSWORD: C2RustUnnamed_0 = 110;
pub const ITEM_SHRTSTAFF: C2RustUnnamed_0 = 109;
pub const ITEM_COMPBOW: C2RustUnnamed_0 = 108;
pub const ITEM_STDARMOR: C2RustUnnamed_0 = 107;
pub const ITEM_CLEAVER: C2RustUnnamed_0 = 106;
pub const ITEM_WSHIELD: C2RustUnnamed_0 = 105;
pub const ITEM_AXE: C2RustUnnamed_0 = 104;
pub const ITEM_PARMOR: C2RustUnnamed_0 = 103;
pub const ITEM_LONGBOW: C2RustUnnamed_0 = 102;
pub const ITEM_BTLAXE: C2RustUnnamed_0 = 101;
pub const ITEM_COMPSHLD: C2RustUnnamed_0 = 100;
pub const ITEM_SAMHELM: C2RustUnnamed_0 = 99;
pub const ITEM_FHELM3: C2RustUnnamed_0 = 98;
pub const ITEM_BOOK4: C2RustUnnamed_0 = 97;
pub const ITEM_MAP: C2RustUnnamed_0 = 96;
pub const ITEM_CROWN2: C2RustUnnamed_0 = 95;
pub const ITEM_CLOTHES: C2RustUnnamed_0 = 94;
pub const ITEM_SKLCAP2: C2RustUnnamed_0 = 93;
pub const ITEM_FLESH: C2RustUnnamed_0 = 92;
pub const ITEM_LCAP: C2RustUnnamed_0 = 91;
pub const ITEM_SKLCAP: C2RustUnnamed_0 = 90;
pub const ITEM_MUSHROOM: C2RustUnnamed_0 = 89;
pub const ITEM_BOOK: C2RustUnnamed_0 = 88;
pub const ITEM_BOOK3: C2RustUnnamed_0 = 87;
pub const ITEM_BOOK2: C2RustUnnamed_0 = 86;
pub const ITEM_GRTHELM: C2RustUnnamed_0 = 85;
pub const ITEM_FHELM2: C2RustUnnamed_0 = 84;
pub const ITEM_BUCKLER: C2RustUnnamed_0 = 83;
pub const ITEM_FHELM: C2RustUnnamed_0 = 82;
pub const ITEM_HARLEQ: C2RustUnnamed_0 = 81;
pub const ITEM_JESTER: C2RustUnnamed_0 = 80;
pub const ITEM_MCROWN: C2RustUnnamed_0 = 79;
pub const ITEM_SKCROWN: C2RustUnnamed_0 = 78;
pub const ITEM_CROWN: C2RustUnnamed_0 = 77;
pub const ITEM_ROCK: C2RustUnnamed_0 = 76;
pub const ITEM_HELM: C2RustUnnamed_0 = 75;
pub const ITEM_SKULSWORD: C2RustUnnamed_0 = 74;
pub const ITEM_MAGSWORD: C2RustUnnamed_0 = 73;
pub const ITEM_SCIMITAR2: C2RustUnnamed_0 = 72;
pub const ITEM_CLUB3: C2RustUnnamed_0 = 71;
pub const ITEM_CLUB2: C2RustUnnamed_0 = 70;
pub const ITEM_CLUB1: C2RustUnnamed_0 = 69;
pub const ITEM_KNTSWORD: C2RustUnnamed_0 = 68;
pub const ITEM_SABRE: C2RustUnnamed_0 = 67;
pub const ITEM_CLUB: C2RustUnnamed_0 = 66;
pub const ITEM_CLAYMORE: C2RustUnnamed_0 = 65;
pub const ITEM_SHORTSRD: C2RustUnnamed_0 = 64;
pub const ITEM_MORNSTAR: C2RustUnnamed_0 = 63;
pub const ITEM_SCIMITAR: C2RustUnnamed_0 = 62;
pub const ITEM_BROADSRD: C2RustUnnamed_0 = 61;
pub const ITEM_LONGSRD: C2RustUnnamed_0 = 60;
pub const ITEM_MACE: C2RustUnnamed_0 = 59;
pub const ITEM_FALCHION: C2RustUnnamed_0 = 58;
pub const ITEM_BASTSRD: C2RustUnnamed_0 = 57;
pub const ITEM_BLADE: C2RustUnnamed_0 = 56;
pub const ITEM_DAGGER5: C2RustUnnamed_0 = 55;
pub const ITEM_DAGGER4: C2RustUnnamed_0 = 54;
pub const ITEM_DAGGER3: C2RustUnnamed_0 = 53;
pub const ITEM_BIGBOTTLE: C2RustUnnamed_0 = 52;
pub const ITEM_DAGGER2: C2RustUnnamed_0 = 51;
pub const ITEM_DAGGER1: C2RustUnnamed_0 = 50;
pub const ITEM_POUCH1: C2RustUnnamed_0 = 49;
pub const ITEM_AMULET4: C2RustUnnamed_0 = 48;
pub const ITEM_AMULET3: C2RustUnnamed_0 = 47;
pub const ITEM_AMULET2: C2RustUnnamed_0 = 46;
pub const ITEM_AMULET1: C2RustUnnamed_0 = 45;
pub const ITEM_AMULET: C2RustUnnamed_0 = 44;
pub const ITEM_BREAD: C2RustUnnamed_0 = 43;
pub const ITEM_FANG: C2RustUnnamed_0 = 42;
pub const ITEM_CLAW: C2RustUnnamed_0 = 41;
pub const ITEM_BRAIN: C2RustUnnamed_0 = 40;
pub const ITEM_BLUEBTL2: C2RustUnnamed_0 = 39;
pub const ITEM_LTBLUEBTL: C2RustUnnamed_0 = 38;
pub const ITEM_GOLDBTL: C2RustUnnamed_0 = 37;
pub const ITEM_BLKBTL2: C2RustUnnamed_0 = 36;
pub const ITEM_BREDBTL: C2RustUnnamed_0 = 35;
pub const ITEM_ORGBTL: C2RustUnnamed_0 = 34;
pub const ITEM_YELBTL: C2RustUnnamed_0 = 33;
pub const ITEM_REDBTL: C2RustUnnamed_0 = 32;
pub const ITEM_WHTEBTL: C2RustUnnamed_0 = 31;
pub const ITEM_BLKBTL: C2RustUnnamed_0 = 30;
pub const ITEM_VILE: C2RustUnnamed_0 = 29;
pub const ITEM_JPYRIMID: C2RustUnnamed_0 = 28;
pub const ITEM_JCUBE: C2RustUnnamed_0 = 27;
pub const ITEM_JSPHERE: C2RustUnnamed_0 = 26;
pub const ITEM_BLOODGEM: C2RustUnnamed_0 = 25;
pub const ITEM_PYRIMID: C2RustUnnamed_0 = 24;
pub const ITEM_CUBE: C2RustUnnamed_0 = 23;
pub const ITEM_SPHERE: C2RustUnnamed_0 = 22;
pub const ITEM_EAR3: C2RustUnnamed_0 = 21;
pub const ITEM_EAR2: C2RustUnnamed_0 = 20;
pub const ITEM_EAR1: C2RustUnnamed_0 = 19;
pub const ITEM_EMPYBAND: C2RustUnnamed_0 = 18;
pub const ITEM_GOLDENELIX: C2RustUnnamed_0 = 17;
pub const ITEM_3COLORPOT: C2RustUnnamed_0 = 16;
pub const ITEM_SPECTRAL: C2RustUnnamed_0 = 15;
pub const ITEM_BRNRING: C2RustUnnamed_0 = 14;
pub const ITEM_MJRING: C2RustUnnamed_0 = 13;
pub const ITEM_SLVRRING: C2RustUnnamed_0 = 12;
pub const ITEM_3JRING: C2RustUnnamed_0 = 11;
pub const ITEM_BLUERING: C2RustUnnamed_0 = 10;
pub const ITEM_WOODRING: C2RustUnnamed_0 = 9;
pub const ITEM_1JRING: C2RustUnnamed_0 = 8;
pub const ITEM_GOLDRING: C2RustUnnamed_0 = 7;
pub const ITEM_5GOLD: C2RustUnnamed_0 = 6;
pub const ITEM_3GOLD: C2RustUnnamed_0 = 5;
pub const ITEM_1GOLD: C2RustUnnamed_0 = 4;
pub const ITEM_SCROLL3: C2RustUnnamed_0 = 3;
pub const ITEM_SCROLL2: C2RustUnnamed_0 = 2;
pub const ITEM_SCROLL: C2RustUnnamed_0 = 1;
pub const ITEM_BLUEBTL: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const IDI_LASTQUEST: C2RustUnnamed_1 = 22;
pub const IDI_FIRSTQUEST: C2RustUnnamed_1 = 6;
pub const IDI_RESURRECT: C2RustUnnamed_1 = 34;
pub const IDI_LAZSTAFF: C2RustUnnamed_1 = 33;
pub const IDI_LGTFORGE: C2RustUnnamed_1 = 32;
pub const IDI_GRISWOLD: C2RustUnnamed_1 = 31;
pub const IDI_FULLMANA: C2RustUnnamed_1 = 30;
pub const IDI_FULLHEAL: C2RustUnnamed_1 = 29;
pub const IDI_ARMOFVAL: C2RustUnnamed_1 = 28;
pub const IDI_PORTAL: C2RustUnnamed_1 = 27;
pub const IDI_IDENTIFY: C2RustUnnamed_1 = 26;
pub const IDI_MANA: C2RustUnnamed_1 = 25;
pub const IDI_HEAL: C2RustUnnamed_1 = 24;
pub const IDI_EAR: C2RustUnnamed_1 = 23;
pub const IDI_MAPOFDOOM: C2RustUnnamed_1 = 22;
pub const IDI_BLDSTONE: C2RustUnnamed_1 = 21;
pub const IDI_SPECELIX: C2RustUnnamed_1 = 20;
pub const IDI_FUNGALTM: C2RustUnnamed_1 = 19;
pub const IDI_BRAIN: C2RustUnnamed_1 = 18;
pub const IDI_MUSHROOM: C2RustUnnamed_1 = 17;
pub const IDI_ANVIL: C2RustUnnamed_1 = 16;
pub const IDI_GLDNELIX: C2RustUnnamed_1 = 15;
pub const IDI_STEELVEIL: C2RustUnnamed_1 = 14;
pub const IDI_HARCREST: C2RustUnnamed_1 = 13;
pub const IDI_BANNER: C2RustUnnamed_1 = 12;
pub const IDI_TRING: C2RustUnnamed_1 = 11;
pub const IDI_OPTAMULET: C2RustUnnamed_1 = 10;
pub const IDI_ROCK: C2RustUnnamed_1 = 9;
pub const IDI_INFRARING: C2RustUnnamed_1 = 8;
pub const IDI_SKCROWN: C2RustUnnamed_1 = 7;
pub const IDI_CLEAVER: C2RustUnnamed_1 = 6;
pub const IDI_SORCEROR: C2RustUnnamed_1 = 5;
pub const IDI_ROGUE: C2RustUnnamed_1 = 4;
pub const IDI_WARRCLUB: C2RustUnnamed_1 = 3;
pub const IDI_WARRSHLD: C2RustUnnamed_1 = 2;
pub const IDI_WARRIOR: C2RustUnnamed_1 = 1;
pub const IDI_GOLD: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const MM_TALK: C2RustUnnamed_2 = 17;
pub const MM_HEAL: C2RustUnnamed_2 = 16;
pub const MM_STONE: C2RustUnnamed_2 = 15;
pub const MM_MISSILE: C2RustUnnamed_2 = 14;
pub const MM_DELAY: C2RustUnnamed_2 = 13;
pub const MM_RSATTACK: C2RustUnnamed_2 = 12;
pub const MM_SPSTAND: C2RustUnnamed_2 = 11;
pub const MM_RATTACK: C2RustUnnamed_2 = 10;
pub const MM_FADEOUT: C2RustUnnamed_2 = 9;
pub const MM_FADEIN: C2RustUnnamed_2 = 8;
pub const MM_SATTACK: C2RustUnnamed_2 = 7;
pub const MM_DEATH: C2RustUnnamed_2 = 6;
pub const MM_GOTHIT: C2RustUnnamed_2 = 5;
pub const MM_ATTACK: C2RustUnnamed_2 = 4;
pub const MM_WALK3: C2RustUnnamed_2 = 3;
pub const MM_WALK2: C2RustUnnamed_2 = 2;
pub const MM_WALK: C2RustUnnamed_2 = 1;
pub const MM_STAND: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const NUM_CMDS: C2RustUnnamed_3 = 96;
pub const FAKE_CMD_DROPID: C2RustUnnamed_3 = 95;
pub const FAKE_CMD_SETID: C2RustUnnamed_3 = 94;
pub const CMD_REMSHIELD: C2RustUnnamed_3 = 93;
pub const CMD_SETSHIELD: C2RustUnnamed_3 = 92;
pub const CMD_NOVA: C2RustUnnamed_3 = 91;
pub const CMD_AWAKEGOLEM: C2RustUnnamed_3 = 90;
pub const CMD_ENDSHIELD: C2RustUnnamed_3 = 89;
pub const CMD_SYNCQUEST: C2RustUnnamed_3 = 88;
pub const CMD_KILLGOLEM: C2RustUnnamed_3 = 87;
pub const CMD_SYNCPUTITEM: C2RustUnnamed_3 = 86;
pub const CMD_ITEMEXTRA: C2RustUnnamed_3 = 85;
pub const CMD_SPELLXYD: C2RustUnnamed_3 = 84;
pub const CMD_RETOWN: C2RustUnnamed_3 = 83;
pub const CMD_SETVIT: C2RustUnnamed_3 = 82;
pub const CMD_SETDEX: C2RustUnnamed_3 = 81;
pub const CMD_SETMAG: C2RustUnnamed_3 = 80;
pub const CMD_SETSTR: C2RustUnnamed_3 = 79;
pub const CMD_STRING: C2RustUnnamed_3 = 78;
pub const CMD_HEALOTHER: C2RustUnnamed_3 = 77;
pub const CMD_DLEVEL_END: C2RustUnnamed_3 = 76;
pub const CMD_DLEVEL_JUNK: C2RustUnnamed_3 = 75;
pub const CMD_DLEVEL_16: C2RustUnnamed_3 = 74;
pub const CMD_DLEVEL_15: C2RustUnnamed_3 = 73;
pub const CMD_DLEVEL_14: C2RustUnnamed_3 = 72;
pub const CMD_DLEVEL_13: C2RustUnnamed_3 = 71;
pub const CMD_DLEVEL_12: C2RustUnnamed_3 = 70;
pub const CMD_DLEVEL_11: C2RustUnnamed_3 = 69;
pub const CMD_DLEVEL_10: C2RustUnnamed_3 = 68;
pub const CMD_DLEVEL_9: C2RustUnnamed_3 = 67;
pub const CMD_DLEVEL_8: C2RustUnnamed_3 = 66;
pub const CMD_DLEVEL_7: C2RustUnnamed_3 = 65;
pub const CMD_DLEVEL_6: C2RustUnnamed_3 = 64;
pub const CMD_DLEVEL_5: C2RustUnnamed_3 = 63;
pub const CMD_DLEVEL_4: C2RustUnnamed_3 = 62;
pub const CMD_DLEVEL_3: C2RustUnnamed_3 = 61;
pub const CMD_DLEVEL_2: C2RustUnnamed_3 = 60;
pub const CMD_DLEVEL_1: C2RustUnnamed_3 = 59;
pub const CMD_DLEVEL_0: C2RustUnnamed_3 = 58;
pub const CMD_DEACTIVATEPORTAL: C2RustUnnamed_3 = 57;
pub const CMD_ACTIVATEPORTAL: C2RustUnnamed_3 = 56;
pub const CMD_SATTACKXY: C2RustUnnamed_3 = 55;
pub const CMD_SEND_PLRINFO: C2RustUnnamed_3 = 54;
pub const CMD_PLAYER_JOINLEVEL: C2RustUnnamed_3 = 53;
pub const CMD_DROPITEM: C2RustUnnamed_3 = 52;
pub const CMD_PLRLEVEL: C2RustUnnamed_3 = 51;
pub const CMD_PLRDAMAGE: C2RustUnnamed_3 = 50;
pub const CMD_DELPLRITEMS: C2RustUnnamed_3 = 49;
pub const CMD_CHANGEPLRITEMS: C2RustUnnamed_3 = 48;
pub const CMD_BREAKOBJ: C2RustUnnamed_3 = 47;
pub const CMD_PLROPOBJ: C2RustUnnamed_3 = 46;
pub const CMD_OPERATEOBJ: C2RustUnnamed_3 = 45;
pub const CMD_CLOSEDOOR: C2RustUnnamed_3 = 44;
pub const CMD_OPENDOOR: C2RustUnnamed_3 = 43;
pub const CMD_GOTOAGETITEM: C2RustUnnamed_3 = 42;
pub const CMD_GOTOGETITEM: C2RustUnnamed_3 = 41;
pub const CMD_REQUESTAGITEM: C2RustUnnamed_3 = 40;
pub const CMD_REQUESTGITEM: C2RustUnnamed_3 = 39;
pub const CMD_PLRDEAD: C2RustUnnamed_3 = 38;
pub const CMD_MONSTDAMAGE: C2RustUnnamed_3 = 37;
pub const CMD_MONSTDEATH: C2RustUnnamed_3 = 36;
pub const CMD_SYNCDATA: C2RustUnnamed_3 = 35;
pub const CMD_DEBUG: C2RustUnnamed_3 = 34;
pub const CMD_CHEAT_SPELL_LEVEL: C2RustUnnamed_3 = 33;
pub const CMD_CHEAT_EXPERIENCE: C2RustUnnamed_3 = 32;
pub const CMD_WARP: C2RustUnnamed_3 = 31;
pub const CMD_NEWLVL: C2RustUnnamed_3 = 30;
pub const CMD_TALKXY: C2RustUnnamed_3 = 29;
pub const CMD_KNOCKBACK: C2RustUnnamed_3 = 28;
pub const CMD_OPOBJT: C2RustUnnamed_3 = 27;
pub const CMD_RESURRECT: C2RustUnnamed_3 = 26;
pub const CMD_TSPELLPID: C2RustUnnamed_3 = 25;
pub const CMD_TSPELLID: C2RustUnnamed_3 = 24;
pub const CMD_SPELLPID: C2RustUnnamed_3 = 23;
pub const CMD_SPELLID: C2RustUnnamed_3 = 22;
pub const CMD_RATTACKPID: C2RustUnnamed_3 = 21;
pub const CMD_RATTACKID: C2RustUnnamed_3 = 20;
pub const CMD_ATTACKPID: C2RustUnnamed_3 = 19;
pub const CMD_ATTACKID: C2RustUnnamed_3 = 18;
pub const CMD_DISARMXY: C2RustUnnamed_3 = 17;
pub const CMD_OPOBJXY: C2RustUnnamed_3 = 16;
pub const CMD_TSPELLXY: C2RustUnnamed_3 = 15;
pub const CMD_SPELLXY: C2RustUnnamed_3 = 14;
pub const CMD_RATTACKXY: C2RustUnnamed_3 = 13;
pub const CMD_ATTACKXY: C2RustUnnamed_3 = 12;
pub const CMD_RESPAWNITEM: C2RustUnnamed_3 = 11;
pub const CMD_PUTITEM: C2RustUnnamed_3 = 10;
pub const CMD_AGETITEM: C2RustUnnamed_3 = 9;
pub const CMD_GETITEM: C2RustUnnamed_3 = 8;
pub const CMD_SBSPELL: C2RustUnnamed_3 = 7;
pub const CMD_ADDVIT: C2RustUnnamed_3 = 6;
pub const CMD_ADDDEX: C2RustUnnamed_3 = 5;
pub const CMD_ADDMAG: C2RustUnnamed_3 = 4;
pub const CMD_ADDSTR: C2RustUnnamed_3 = 3;
pub const CMD_ACK_PLRINFO: C2RustUnnamed_3 = 2;
pub const CMD_WALKXY: C2RustUnnamed_3 = 1;
pub const CMD_STAND: C2RustUnnamed_3 = 0;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const BUFFER_PROCESS: C2RustUnnamed_4 = 2;
pub const BUFFER_ON: C2RustUnnamed_4 = 1;
pub const BUFFER_OFF: C2RustUnnamed_4 = 0;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterStruct {
    pub _mMTidx: libc::c_int,
    pub _mmode: libc::c_int,
    pub _mgoal: uint8_t,
    pub _mgoalvar1: libc::c_int,
    pub _mgoalvar2: libc::c_int,
    pub _mgoalvar3: libc::c_int,
    pub _mgoalvar4: libc::c_int,
    pub _pathcount: uint8_t,
    pub _mx: libc::c_int,
    pub _my: libc::c_int,
    pub _mfutx: libc::c_int,
    pub _mfuty: libc::c_int,
    pub _moldx: libc::c_int,
    pub _moldy: libc::c_int,
    pub _mxoff: int32_t,
    pub _myoff: int32_t,
    pub _mxvel: int32_t,
    pub _myvel: int32_t,
    pub _mdir: libc::c_int,
    pub _menemy: libc::c_int,
    pub _menemyx: uint8_t,
    pub _menemyy: uint8_t,
    pub _mAnimData: *mut uint8_t,
    pub _mAnimDelay: libc::c_int,
    pub _mAnimCnt: libc::c_int,
    pub _mAnimLen: libc::c_int,
    pub _mAnimFrame: libc::c_int,
    pub _meflag: libc::c_int,
    pub _mDelFlag: bool32_t,
    pub _mVar1: int32_t,
    pub _mVar2: int32_t,
    pub _mVar3: int32_t,
    pub _mVar4: int32_t,
    pub _mVar5: int32_t,
    pub _mVar6: int32_t,
    pub _mVar7: int32_t,
    pub _mVar8: int32_t,
    pub _mmaxhp: int32_t,
    pub _mhitpoints: int32_t,
    pub _mAi: uint8_t,
    pub _mint: uint8_t,
    pub _mFlags: uint32_t,
    pub _msquelch: uint8_t,
    pub _mAFNum: libc::c_int,
    pub _lastx: libc::c_int,
    pub _lasty: libc::c_int,
    pub _mRndSeed: libc::c_int,
    pub _mAISeed: libc::c_int,
    pub _Wandering: bool32_t,
    pub _uniqtype: uint8_t,
    pub _uniqtrans: uint8_t,
    pub _udeadval: int8_t,
    pub mWhoHit: int8_t,
    pub mLevel: int8_t,
    pub mExp: uint16_t,
    pub mHit: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMagicRes: uint16_t,
    pub mtalkmsg: libc::c_int,
    pub leader: uint8_t,
    pub leaderflag: uint8_t,
    pub packsize: uint8_t,
    pub mlid: uint8_t,
    pub mName: *const libc::c_char,
    pub MType: *mut CMonster,
    pub MData: *mut MonsterData,
}
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct TSyncHeader {
    pub bCmd: uint8_t,
    pub bLevel: uint8_t,
    pub wLen: uint16_t,
    pub bObjId: uint8_t,
    pub bObjCmd: uint8_t,
    pub bItemI: uint8_t,
    pub bItemX: uint8_t,
    pub bItemY: uint8_t,
    pub wItemIndx: uint16_t,
    pub wItemCI: uint16_t,
    pub dwItemSeed: libc::c_int,
    pub bItemId: uint8_t,
    pub bItemDur: uint8_t,
    pub bItemMDur: uint8_t,
    pub bItemCh: uint8_t,
    pub bItemMCh: uint8_t,
    pub wItemVal: uint16_t,
    pub dwItemBuff: uint32_t,
    pub bPInvLoc: uint8_t,
    pub wPInvIndx: uint16_t,
    pub wPInvCI: uint16_t,
    pub dwPInvSeed: libc::c_int,
    pub bPInvId: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct TSyncMonster {
    pub _mndx: uint8_t,
    pub _mx: uint8_t,
    pub _my: uint8_t,
    pub _menemy: uint8_t,
    pub _mdelta: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
pub type C2RustUnnamed_5 = libc::c_uint;
pub const NUM_INVLOC: C2RustUnnamed_5 = 7;
pub const INVLOC_BODY: C2RustUnnamed_5 = 6;
pub const INVLOC_HAND2: C2RustUnnamed_5 = 5;
pub const INVLOC_HAND1: C2RustUnnamed_5 = 4;
pub const INVLOC_NECK: C2RustUnnamed_5 = 3;
pub const INVLOC_RING2: C2RustUnnamed_5 = 2;
pub const INVLOC_RING1: C2RustUnnamed_5 = 1;
pub const INVLOC_HEAD: C2RustUnnamed_5 = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
static mut sgwDelta: [uint16_t; 200] = [0; 200];
static mut sgwLRU: [uint16_t; 200] = [0; 200];
static mut sgnLRUScan: libc::c_int = 0;
static mut sgnSyncItem: libc::c_int = 0 as libc::c_int;
static mut sgnSyncPInv: libc::c_int = 0 as libc::c_int;
unsafe extern "C" fn prep_monster_list() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < nummonsters {
        let mut mi: libc::c_int = monstactive[i as usize];
        sgwDelta[mi
            as usize] = (abs(plr[myplr as usize]._px - monster[mi as usize]._mx)
            + abs(plr[myplr as usize]._py - monster[mi as usize]._my)) as uint16_t;
        if monster[mi as usize]._msquelch == 0 {
            sgwDelta[mi
                as usize] = (sgwDelta[mi as usize] as libc::c_int
                + 0x1000 as libc::c_int) as uint16_t;
        } else if sgwLRU[mi as usize] != 0 {
            sgwLRU[mi as usize] = (sgwLRU[mi as usize]).wrapping_sub(1);
            sgwLRU[mi as usize];
        }
        i += 1;
        i;
    }
}
unsafe extern "C" fn get_monster(mut p: *mut TSyncMonster, mut mi: libc::c_int) {
    (*p)._mndx = mi as uint8_t;
    (*p)._mx = monster[mi as usize]._mx as uint8_t;
    (*p)._my = monster[mi as usize]._my as uint8_t;
    (*p)._menemy = encode_enemy(mi) as uint8_t;
    (*p)
        ._mdelta = (if sgwDelta[mi as usize] as libc::c_int > 0xff as libc::c_int {
        0xff as libc::c_int
    } else {
        sgwDelta[mi as usize] as libc::c_int
    }) as uint8_t;
    sgwDelta[mi as usize] = 0xffff as libc::c_int as uint16_t;
    sgwLRU[mi
        as usize] = (if monster[mi as usize]._msquelch as libc::c_int != 0 {
        LRU_REINIT as libc::c_int
    } else {
        LRU_NEVER as libc::c_int
    }) as uint16_t;
}
unsafe extern "C" fn get_best_monster(mut p: *mut TSyncMonster) -> bool32_t {
    let mut nFound: libc::c_int = -(1 as libc::c_int);
    let mut dwMin: uint32_t = 0xffffffff as libc::c_uint;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < nummonsters {
        let mut mi: libc::c_int = monstactive[i as usize];
        if !(sgwDelta[mi as usize] as uint32_t >= dwMin) {
            if !(sgwLRU[mi as usize] as libc::c_int >= LRU_REINIT as libc::c_int) {
                dwMin = sgwDelta[mi as usize] as uint32_t;
                nFound = mi;
            }
        }
        i += 1;
        i;
    }
    if nFound == -(1 as libc::c_int) {
        return 0 as libc::c_int as bool32_t;
    }
    get_monster(p, nFound);
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn get_lru_monster(mut p: *mut TSyncMonster) -> bool32_t {
    let mut nFound: libc::c_int = -(1 as libc::c_int);
    let mut dwMin: uint32_t = LRU_REINIT as libc::c_int as uint32_t;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < nummonsters {
        if sgnLRUScan >= nummonsters {
            sgnLRUScan = 0 as libc::c_int;
        }
        let mut mi: libc::c_int = monstactive[sgnLRUScan as usize];
        if !(sgwLRU[mi as usize] as uint32_t >= dwMin) {
            dwMin = sgwLRU[mi as usize] as uint32_t;
            nFound = mi;
        }
        i += 1;
        i;
        sgnLRUScan += 1;
        sgnLRUScan;
    }
    if nFound == -(1 as libc::c_int) {
        return 0 as libc::c_int as bool32_t;
    }
    get_monster(p, nFound);
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn FillHeaderSync(mut pHdr: *mut TSyncHeader) {
    let mut ii: libc::c_int = 0;
    if numitems > 0 as libc::c_int {
        if sgnSyncItem >= numitems {
            sgnSyncItem = 0 as libc::c_int;
        }
        let fresh0 = sgnSyncItem;
        sgnSyncItem = sgnSyncItem + 1;
        ii = itemactive[fresh0 as usize];
        (*pHdr).bItemI = ii as uint8_t;
        (*pHdr).bItemX = item[ii as usize]._ix as uint8_t;
        (*pHdr).bItemY = item[ii as usize]._iy as uint8_t;
        (*pHdr).wItemIndx = item[ii as usize].IDidx as uint16_t;
        if item[ii as usize].IDidx == IDI_EAR as libc::c_int {
            (*pHdr)
                .wItemCI = ((item[ii as usize]._iName[7 as libc::c_int as usize]
                as libc::c_int) << 8 as libc::c_int
                | item[ii as usize]._iName[8 as libc::c_int as usize] as libc::c_int)
                as uint16_t;
            (*pHdr)
                .dwItemSeed = (item[ii as usize]._iName[9 as libc::c_int as usize]
                as libc::c_int) << 24 as libc::c_int
                | (item[ii as usize]._iName[10 as libc::c_int as usize] as libc::c_int)
                    << 16 as libc::c_int
                | (item[ii as usize]._iName[11 as libc::c_int as usize] as libc::c_int)
                    << 8 as libc::c_int
                | item[ii as usize]._iName[12 as libc::c_int as usize] as libc::c_int;
            (*pHdr)
                .bItemId = item[ii as usize]._iName[13 as libc::c_int as usize]
                as uint8_t;
            (*pHdr)
                .bItemDur = item[ii as usize]._iName[14 as libc::c_int as usize]
                as uint8_t;
            (*pHdr)
                .bItemMDur = item[ii as usize]._iName[15 as libc::c_int as usize]
                as uint8_t;
            (*pHdr)
                .bItemCh = item[ii as usize]._iName[16 as libc::c_int as usize]
                as uint8_t;
            (*pHdr)
                .bItemMCh = item[ii as usize]._iName[17 as libc::c_int as usize]
                as uint8_t;
            (*pHdr)
                .wItemVal = ((item[ii as usize]._iName[18 as libc::c_int as usize]
                as libc::c_int) << 8 as libc::c_int
                | (item[ii as usize]._iCurs - ITEM_EAR1 as libc::c_int)
                    << 6 as libc::c_int | item[ii as usize]._ivalue) as uint16_t;
            (*pHdr)
                .dwItemBuff = ((item[ii as usize]._iName[19 as libc::c_int as usize]
                as libc::c_int) << 24 as libc::c_int
                | (item[ii as usize]._iName[20 as libc::c_int as usize] as libc::c_int)
                    << 16 as libc::c_int
                | (item[ii as usize]._iName[21 as libc::c_int as usize] as libc::c_int)
                    << 8 as libc::c_int
                | item[ii as usize]._iName[22 as libc::c_int as usize] as libc::c_int)
                as uint32_t;
        } else {
            (*pHdr).wItemCI = item[ii as usize]._iCreateInfo;
            (*pHdr).dwItemSeed = item[ii as usize]._iSeed;
            (*pHdr).bItemId = item[ii as usize]._iIdentified as uint8_t;
            (*pHdr).bItemDur = item[ii as usize]._iDurability as uint8_t;
            (*pHdr).bItemMDur = item[ii as usize]._iMaxDur as uint8_t;
            (*pHdr).bItemCh = item[ii as usize]._iCharges as uint8_t;
            (*pHdr).bItemMCh = item[ii as usize]._iMaxCharges as uint8_t;
            if item[ii as usize].IDidx == IDI_GOLD as libc::c_int {
                (*pHdr).wItemVal = item[ii as usize]._ivalue as uint16_t;
            }
        }
    } else {
        (*pHdr).bItemI = 0xff as libc::c_int as uint8_t;
    }
    if !((sgnSyncPInv as uint32_t) < NUM_INVLOC as libc::c_int as uint32_t) {
        assert_fail(
            158 as libc::c_int,
            b"src/sync.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)sgnSyncPInv < NUM_INVLOC\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut itm: *mut ItemStruct = &mut *((*plr.as_mut_ptr().offset(myplr as isize))
        .InvBody)
        .as_mut_ptr()
        .offset(sgnSyncPInv as isize) as *mut ItemStruct;
    if (*itm)._itype != -(1 as libc::c_int) {
        (*pHdr).bPInvLoc = sgnSyncPInv as uint8_t;
        (*pHdr).wPInvIndx = (*itm).IDidx as uint16_t;
        (*pHdr).wPInvCI = (*itm)._iCreateInfo;
        (*pHdr).dwPInvSeed = (*itm)._iSeed;
        (*pHdr).bPInvId = (*itm)._iIdentified as uint8_t;
    } else {
        (*pHdr).bPInvLoc = 0xff as libc::c_int as uint8_t;
    }
    sgnSyncPInv += 1;
    sgnSyncPInv;
    if sgnSyncPInv >= NUM_INVLOC as libc::c_int {
        sgnSyncPInv = 0 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn sync_get(
    mut pbBuf: *mut uint8_t,
    mut dwMaxLen: uint32_t,
) -> uint32_t {
    if nummonsters < 1 as libc::c_int {
        return dwMaxLen;
    }
    if (dwMaxLen as libc::c_ulong)
        < (::core::mem::size_of::<TSyncMonster>() as libc::c_ulong)
            .wrapping_add(::core::mem::size_of::<TSyncHeader>() as libc::c_ulong)
    {
        return dwMaxLen;
    }
    let mut pHdr: *mut TSyncHeader = pbBuf as *mut TSyncHeader;
    pbBuf = pbBuf
        .offset(::core::mem::size_of::<TSyncHeader>() as libc::c_ulong as isize);
    dwMaxLen = (dwMaxLen as libc::c_ulong)
        .wrapping_sub(::core::mem::size_of::<TSyncHeader>() as libc::c_ulong) as uint32_t
        as uint32_t;
    (*pHdr).bCmd = CMD_SYNCDATA as libc::c_int as uint8_t;
    (*pHdr).bLevel = currlevel;
    (*pHdr).wLen = 0 as libc::c_int as uint16_t;
    FillHeaderSync(pHdr);
    if !(dwMaxLen <= 0xffff as libc::c_int as uint32_t) {
        assert_fail(
            201 as libc::c_int,
            b"src/sync.c\0" as *const u8 as *const libc::c_char,
            b"dwMaxLen <= 0xffff\0" as *const u8 as *const libc::c_char,
        );
    }
    prep_monster_list();
    let mut nMonsters: libc::c_int = 0 as libc::c_int;
    while nMonsters < nummonsters {
        if (dwMaxLen as libc::c_ulong)
            < ::core::mem::size_of::<TSyncMonster>() as libc::c_ulong
        {
            break;
        }
        let mut bGotOne: bool32_t = 0 as libc::c_int as bool32_t;
        if nMonsters < 2 as libc::c_int {
            bGotOne = get_lru_monster(pbBuf as *mut TSyncMonster);
        }
        if bGotOne == 0 {
            bGotOne = get_best_monster(pbBuf as *mut TSyncMonster);
        }
        if bGotOne == 0 {
            break;
        }
        pbBuf = pbBuf
            .offset(::core::mem::size_of::<TSyncMonster>() as libc::c_ulong as isize);
        (*pHdr)
            .wLen = ((*pHdr).wLen as libc::c_ulong)
            .wrapping_add(::core::mem::size_of::<TSyncMonster>() as libc::c_ulong)
            as uint16_t as uint16_t;
        dwMaxLen = (dwMaxLen as libc::c_ulong)
            .wrapping_sub(::core::mem::size_of::<TSyncMonster>() as libc::c_ulong)
            as uint32_t as uint32_t;
        nMonsters += 1;
        nMonsters;
    }
    return dwMaxLen;
}
unsafe extern "C" fn sync_monster(mut pnum: libc::c_int, mut p: *const TSyncMonster) {
    let mut ndx: libc::c_int = (*p)._mndx as libc::c_int;
    if monster[ndx as usize]._mhitpoints == 0 as libc::c_int {
        return;
    }
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < nummonsters && monstactive[i as usize] != ndx {
        i += 1;
        i;
    }
    let mut delta: uint32_t = (abs(plr[myplr as usize]._px - monster[ndx as usize]._mx)
        + abs(plr[myplr as usize]._py - monster[ndx as usize]._my)) as uint32_t;
    if delta > 0xff as libc::c_int as uint32_t {
        delta = 0xff as libc::c_int as uint32_t;
    }
    if delta < (*p)._mdelta as uint32_t {
        return
    } else if delta == (*p)._mdelta as uint32_t && pnum > myplr {
        return
    }
    if monster[ndx as usize]._mfutx == (*p)._mx as libc::c_int
        && monster[ndx as usize]._mfuty == (*p)._my as libc::c_int
    {
        return;
    }
    if monster[ndx as usize]._mmode == MM_MISSILE as libc::c_int {
        return;
    }
    if monster[ndx as usize]._mmode == MM_STONE as libc::c_int {
        return;
    }
    let mut mdx: libc::c_int = abs(monster[ndx as usize]._mx - (*p)._mx as libc::c_int);
    let mut mdy: libc::c_int = abs(monster[ndx as usize]._my - (*p)._my as libc::c_int);
    if mdx > 2 as libc::c_int || mdy > 2 as libc::c_int {
        if dMonster[(*p)._mx as usize][(*p)._my as usize] == 0 {
            M_ClearSquares(ndx);
            dMonster[(*p)._mx as usize][(*p)._my as usize] = ndx + 1 as libc::c_int;
            monster[ndx as usize]._mx = (*p)._mx as libc::c_int;
            monster[ndx as usize]._my = (*p)._my as libc::c_int;
            decode_enemy(ndx, (*p)._menemy as libc::c_int);
            M_StartStand(
                ndx,
                GetDirection(
                    (*p)._mx as libc::c_int,
                    (*p)._my as libc::c_int,
                    monster[ndx as usize]._menemyx as libc::c_int,
                    monster[ndx as usize]._menemyy as libc::c_int,
                ),
            );
            monster[ndx as usize]._msquelch = 255 as libc::c_int as uint8_t;
        }
    } else if monster[ndx as usize]._mmode < MM_WALK as libc::c_int
        || monster[ndx as usize]._mmode > MM_WALK3 as libc::c_int
    {
        let mut md: libc::c_int = GetDirection(
            monster[ndx as usize]._mx,
            monster[ndx as usize]._my,
            (*p)._mx as libc::c_int,
            (*p)._my as libc::c_int,
        );
        if DirOK(ndx, md) != 0 {
            M_ClearSquares(ndx);
            dMonster[monster[ndx as usize]._mx
                as usize][monster[ndx as usize]._my as usize] = ndx + 1 as libc::c_int;
            M_WalkDir(ndx, md);
            monster[ndx as usize]._msquelch = 255 as libc::c_int as uint8_t;
        }
    }
    decode_enemy(ndx, (*p)._menemy as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn sync_update(
    mut pnum: libc::c_int,
    mut pbBuf: *const uint8_t,
) -> uint32_t {
    let mut pHdr: *const TSyncHeader = pbBuf as *const TSyncHeader;
    pbBuf = pbBuf
        .offset(::core::mem::size_of::<TSyncHeader>() as libc::c_ulong as isize);
    if (*pHdr).bCmd as libc::c_int != CMD_SYNCDATA as libc::c_int {
        app_fatal_(
            b"src/sync.c\0" as *const u8 as *const libc::c_char,
            349 as libc::c_int,
            b"bad sync command\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(gbBufferMsgs as libc::c_int != BUFFER_PROCESS as libc::c_int) {
        assert_fail(
            353 as libc::c_int,
            b"src/sync.c\0" as *const u8 as *const libc::c_char,
            b"gbBufferMsgs != BUFFER_PROCESS\0" as *const u8 as *const libc::c_char,
        );
    }
    if gbBufferMsgs as libc::c_int == BUFFER_ON as libc::c_int {
        return ((*pHdr).wLen as libc::c_ulong)
            .wrapping_add(::core::mem::size_of::<TSyncHeader>() as libc::c_ulong)
            as uint32_t;
    }
    if pnum == myplr {
        return ((*pHdr).wLen as libc::c_ulong)
            .wrapping_add(::core::mem::size_of::<TSyncHeader>() as libc::c_ulong)
            as uint32_t;
    }
    let mut wLen: uint16_t = (*pHdr).wLen;
    while wLen as libc::c_ulong
        >= ::core::mem::size_of::<TSyncMonster>() as libc::c_ulong
    {
        if currlevel as libc::c_int == (*pHdr).bLevel as libc::c_int {
            sync_monster(pnum, pbBuf as *const TSyncMonster);
        }
        delta_sync_monster(pbBuf as *const TSyncMonster, (*pHdr).bLevel);
        pbBuf = pbBuf
            .offset(::core::mem::size_of::<TSyncMonster>() as libc::c_ulong as isize);
        wLen = (wLen as libc::c_ulong)
            .wrapping_sub(::core::mem::size_of::<TSyncMonster>() as libc::c_ulong)
            as uint16_t as uint16_t;
    }
    if !(wLen as libc::c_int == 0 as libc::c_int) {
        assert_fail(
            377 as libc::c_int,
            b"src/sync.c\0" as *const u8 as *const libc::c_char,
            b"wLen == 0\0" as *const u8 as *const libc::c_char,
        );
    }
    return ((*pHdr).wLen as libc::c_ulong)
        .wrapping_add(::core::mem::size_of::<TSyncHeader>() as libc::c_ulong)
        as uint32_t;
}
#[no_mangle]
pub unsafe extern "C" fn sync_init() {
    sgnLRUScan = myplr * 16 as libc::c_int;
    memset(
        sgwLRU.as_mut_ptr() as *mut libc::c_void,
        LRU_INIT as libc::c_int,
        ::core::mem::size_of::<[uint16_t; 200]>() as libc::c_ulong,
    );
}
