use ::libc;
extern "C" {
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn strcpy(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn strcat(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn strlen(_: *const libc::c_char) -> libc::c_ulong;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn DrawPanelFont(poffset: int32_t, nCel: int32_t, clr: int8_t);
    fn SDL_GetTicks() -> Uint32;
    fn SetICursor(i: libc::c_int);
    fn SetCursor_(i: libc::c_int);
    fn stream_stop();
    fn PlaySFX(_: libc::c_int);
    fn DrawCel(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn GetRndSeed(file: *const libc::c_char, line: libc::c_int) -> int32_t;
    fn SetRndSeed(file: *const libc::c_char, line: libc::c_int, s: int32_t);
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn TDrawRect(x: libc::c_int, y: libc::c_int, w: libc::c_int, h: libc::c_int);
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn RemoveInvItem(_: libc::c_int, _: libc::c_int);
    fn AutoPlace(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: bool32_t,
    ) -> bool32_t;
    fn SpecialAutoPlace(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: bool32_t,
    ) -> bool32_t;
    fn CalculateGold(pnum: libc::c_int) -> int32_t;
    fn RemoveSpdBarItem(pnum: libc::c_int, iv: libc::c_int);
    fn CalcPlrInv(_: libc::c_int, _: bool32_t);
    fn PrintItemPower(_: int8_t, x: *const ItemStruct);
    fn SpawnSmith(_: libc::c_int);
    fn SpawnPremium(_: libc::c_int);
    fn SpawnWitch(_: libc::c_int);
    fn SpawnBoy(_: libc::c_int);
    fn SpawnHealer(_: libc::c_int);
    fn SpawnStoreGold();
    fn GetGoldSeed(pnum: libc::c_int, h: *mut ItemStruct);
    fn InitQTextMsg(_: libc::c_int);
    fn DrawQTextBack();
    static gbFontTransTbl: [uint8_t; 256];
    static fonttrans: [uint8_t; 128];
    static fontkern: [uint8_t; 68];
    static mut chrflag: bool32_t;
    static mut sbookflag: bool32_t;
    static mut drawhpflag: bool32_t;
    static mut dropGoldFlag: bool32_t;
    static mut tempstr: [libc::c_char; 256];
    static mut cursW: libc::c_int;
    static mut cursH: libc::c_int;
    static mut icursW28: libc::c_int;
    static mut icursH28: libc::c_int;
    static mut MouseX: libc::c_int;
    static mut MouseY: libc::c_int;
    static mut force_redraw: libc::c_int;
    static mut glSeedTbl: [uint32_t; 17];
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut AP2x2Tbl: [libc::c_int; 10];
    static mut invflag: bool32_t;
    static mut AllItemsList: [ItemDataStruct; 157];
    static mut qtextflag: uint8_t;
    static mut gbMaxPlayers: uint8_t;
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut questlist: [QuestData; 16];
    static mut quests: [QuestStruct; 16];
    static mut questlog: bool32_t;
    static mut nBuffWTbl: [int32_t; 1024];
    static mut spelldata: [SpellData; 37];
    static mut SStringY: [libc::c_int; 24];
    static mut smithitem: [ItemStruct; 20];
    static mut premiumitem: [ItemStruct; 6];
    static mut numpremium: libc::c_int;
    static mut premiumlevel: libc::c_int;
    static mut healitem: [ItemStruct; 20];
    static mut witchitem: [ItemStruct; 20];
    static mut boyitem: ItemStruct;
    static mut boylevel: libc::c_int;
    static mut golditem: ItemStruct;
    static mut stextflag: int8_t;
    static mut pSTextBoxCels: *mut uint8_t;
    static mut pSTextSpinCels: *mut uint8_t;
    static mut pSTextSlidCels: *mut uint8_t;
    static mut Qtalklist: [[libc::c_int; 16]; 11];
    static mut towner: [TownerStruct; 16];
    static mut gpBuffer: *mut uint32_t;
    static mut set_stores_seed: libc::c_int;
    fn _logf(format: *const libc::c_char, _: ...);
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type C2RustUnnamed = libc::c_uint;
pub const VIEW_CURSOR: C2RustUnnamed = 1;
pub const ICSTART: C2RustUnnamed = 12;
pub const WATCH_CURS: C2RustUnnamed = 11;
pub const HEALOTHER_CURS: C2RustUnnamed = 10;
pub const TARGET_CURS: C2RustUnnamed = 9;
pub const RESURRECT_CURS: C2RustUnnamed = 8;
pub const TELE_CURS: C2RustUnnamed = 7;
pub const OIL_CURS: C2RustUnnamed = 6;
pub const DISARM_CURS: C2RustUnnamed = 5;
pub const RECHARGE_CURS: C2RustUnnamed = 4;
pub const REPAIR_CURS: C2RustUnnamed = 3;
pub const IDENTIFY_CURS: C2RustUnnamed = 2;
pub const GLOVE_CURS: C2RustUnnamed = 1;
pub const NO_CURSOR: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const ICOLOR_GOLD: C2RustUnnamed_0 = 3;
pub const ICOLOR_RED: C2RustUnnamed_0 = 2;
pub const ICOLOR_BLUE: C2RustUnnamed_0 = 1;
pub const ICOLOR_WHITE: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_int;
pub const ITEMFTYPES: C2RustUnnamed_1 = 35;
pub const RESIST_MAX: C2RustUnnamed_1 = 75;
pub const GOLD_VMAX: C2RustUnnamed_1 = 5000;
pub const GOLD_VT2: C2RustUnnamed_1 = 2500;
pub const GOLD_VT1: C2RustUnnamed_1 = 1000;
pub const INFINITE_DUR: C2RustUnnamed_1 = 255;
pub const ITEM_RND: C2RustUnnamed_1 = -1;
pub const TEMPAVAIL: C2RustUnnamed_1 = 127;
pub const MAXUITEMS: C2RustUnnamed_1 = 128;
pub const MAXITEMS: C2RustUnnamed_1 = 127;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const STOREIDCOST: C2RustUnnamed_2 = 100;
pub const MAXHOLDITEMS: C2RustUnnamed_2 = 48;
pub const NUMSTLINES: C2RustUnnamed_2 = 24;
pub const MAXPREMIUM: C2RustUnnamed_2 = 6;
pub const MAXHEALITEMS: C2RustUnnamed_2 = 20;
pub const MAXWITCHITEMS: C2RustUnnamed_2 = 20;
pub const MAXSMITHITEMS: C2RustUnnamed_2 = 20;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_3 = 255;
pub const VIEWDRAW: C2RustUnnamed_3 = 1;
pub const NODRAW: C2RustUnnamed_3 = 0;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const IMID_SPECTRAL: C2RustUnnamed_4 = 44;
pub const IMID_EAR: C2RustUnnamed_4 = 43;
pub const IMID_MAPOFDOOM: C2RustUnnamed_4 = 42;
pub const IMID_LASTOIL: C2RustUnnamed_4 = 41;
pub const IMID_OILIMPER: C2RustUnnamed_4 = 40;
pub const IMID_OILHARD: C2RustUnnamed_4 = 39;
pub const IMID_OILPERM: C2RustUnnamed_4 = 38;
pub const IMID_OILFORT: C2RustUnnamed_4 = 37;
pub const IMID_OILBLKSM: C2RustUnnamed_4 = 36;
pub const IMID_OILSKILL: C2RustUnnamed_4 = 35;
pub const IMID_OILDEATH: C2RustUnnamed_4 = 34;
pub const IMID_OILSHRP: C2RustUnnamed_4 = 33;
pub const IMID_OILMAST: C2RustUnnamed_4 = 32;
pub const IMID_OILACC: C2RustUnnamed_4 = 31;
pub const IMID_OIL: C2RustUnnamed_4 = 30;
pub const IMID_FIRSTOIL: C2RustUnnamed_4 = 29;
pub const IMID_MEAT: C2RustUnnamed_4 = 28;
pub const IMID_UNIQUE: C2RustUnnamed_4 = 27;
pub const IMID_AMULET: C2RustUnnamed_4 = 26;
pub const IMID_RING: C2RustUnnamed_4 = 25;
pub const IMID_BOOK: C2RustUnnamed_4 = 24;
pub const IMID_STAFF: C2RustUnnamed_4 = 23;
pub const IMID_TSCROLL: C2RustUnnamed_4 = 22;
pub const IMID_SCROLL: C2RustUnnamed_4 = 21;
pub const IMID_LASTPOT: C2RustUnnamed_4 = 20;
pub const IMID_FREJUV: C2RustUnnamed_4 = 19;
pub const IMID_REJUV: C2RustUnnamed_4 = 18;
pub const IMID_ENVIT: C2RustUnnamed_4 = 17;
pub const IMID_ENDEX: C2RustUnnamed_4 = 16;
pub const IMID_ENMAG: C2RustUnnamed_4 = 15;
pub const IMID_ENSTR: C2RustUnnamed_4 = 14;
pub const IMID_EVIT: C2RustUnnamed_4 = 13;
pub const IMID_EDEX: C2RustUnnamed_4 = 12;
pub const IMID_EMAG: C2RustUnnamed_4 = 11;
pub const IMID_ESTR: C2RustUnnamed_4 = 10;
pub const IMID_PNEXP: C2RustUnnamed_4 = 9;
pub const IMID_PEXP: C2RustUnnamed_4 = 8;
pub const IMID_PFMANA: C2RustUnnamed_4 = 7;
pub const IMID_PMANA: C2RustUnnamed_4 = 6;
pub const IMID_PDHEAL: C2RustUnnamed_4 = 5;
pub const IMID_PSHEAL: C2RustUnnamed_4 = 4;
pub const IMID_PLHEAL: C2RustUnnamed_4 = 3;
pub const IMID_PHEAL: C2RustUnnamed_4 = 2;
pub const IMID_FIRSTPOT: C2RustUnnamed_4 = 1;
pub const IMID_NONE: C2RustUnnamed_4 = 0;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const QUEST_DONE: C2RustUnnamed_5 = 3;
pub const QUEST_NOTDONE: C2RustUnnamed_5 = 2;
pub const QUEST_NOTACTIVE: C2RustUnnamed_5 = 1;
pub const QUEST_NOTAVAIL: C2RustUnnamed_5 = 0;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const USFX_DIABLOD: C2RustUnnamed_6 = 857;
pub const USFX_ZHAR2: C2RustUnnamed_6 = 856;
pub const USFX_ZHAR1: C2RustUnnamed_6 = 855;
pub const USFX_WLOCK1: C2RustUnnamed_6 = 854;
pub const USFX_WARLRD1: C2RustUnnamed_6 = 853;
pub const USFX_SNOT3: C2RustUnnamed_6 = 852;
pub const USFX_SNOT2: C2RustUnnamed_6 = 851;
pub const USFX_SNOT1: C2RustUnnamed_6 = 850;
pub const USFX_SKING1: C2RustUnnamed_6 = 849;
pub const USFX_LAZ2: C2RustUnnamed_6 = 848;
pub const USFX_LAZ1: C2RustUnnamed_6 = 847;
pub const USFX_LACH3: C2RustUnnamed_6 = 846;
pub const USFX_LACH2: C2RustUnnamed_6 = 845;
pub const USFX_LACH1: C2RustUnnamed_6 = 844;
pub const USFX_IZUAL1: C2RustUnnamed_6 = 843;
pub const USFX_GARBUD4: C2RustUnnamed_6 = 842;
pub const USFX_GARBUD3: C2RustUnnamed_6 = 841;
pub const USFX_GARBUD2: C2RustUnnamed_6 = 840;
pub const USFX_GARBUD1: C2RustUnnamed_6 = 839;
pub const USFX_CLEAVER: C2RustUnnamed_6 = 838;
pub const PS_DIABLVLINT: C2RustUnnamed_6 = 837;
pub const PS_NAR9: C2RustUnnamed_6 = 836;
pub const PS_NAR8: C2RustUnnamed_6 = 835;
pub const PS_NAR7: C2RustUnnamed_6 = 834;
pub const PS_NAR6: C2RustUnnamed_6 = 833;
pub const PS_NAR5: C2RustUnnamed_6 = 832;
pub const PS_NAR4: C2RustUnnamed_6 = 831;
pub const PS_NAR3: C2RustUnnamed_6 = 830;
pub const PS_NAR2: C2RustUnnamed_6 = 829;
pub const PS_NAR1: C2RustUnnamed_6 = 828;
pub const PS_WARR102: C2RustUnnamed_6 = 827;
pub const PS_WARR101: C2RustUnnamed_6 = 826;
pub const PS_WARR100: C2RustUnnamed_6 = 825;
pub const PS_WARR99: C2RustUnnamed_6 = 824;
pub const PS_WARR98: C2RustUnnamed_6 = 823;
pub const PS_WARR97: C2RustUnnamed_6 = 822;
pub const PS_WARR96B: C2RustUnnamed_6 = 821;
pub const PS_WARR95F: C2RustUnnamed_6 = 820;
pub const PS_WARR95E: C2RustUnnamed_6 = 819;
pub const PS_WARR95D: C2RustUnnamed_6 = 818;
pub const PS_WARR95C: C2RustUnnamed_6 = 817;
pub const PS_WARR95B: C2RustUnnamed_6 = 816;
pub const PS_WARR95: C2RustUnnamed_6 = 815;
pub const PS_WARR94: C2RustUnnamed_6 = 814;
pub const PS_WARR93: C2RustUnnamed_6 = 813;
pub const PS_WARR92: C2RustUnnamed_6 = 812;
pub const PS_WARR91: C2RustUnnamed_6 = 811;
pub const PS_WARR90: C2RustUnnamed_6 = 810;
pub const PS_WARR89: C2RustUnnamed_6 = 809;
pub const PS_WARR88: C2RustUnnamed_6 = 808;
pub const PS_WARR87: C2RustUnnamed_6 = 807;
pub const PS_WARR86: C2RustUnnamed_6 = 806;
pub const PS_WARR85: C2RustUnnamed_6 = 805;
pub const PS_WARR84: C2RustUnnamed_6 = 804;
pub const PS_WARR83: C2RustUnnamed_6 = 803;
pub const PS_WARR82: C2RustUnnamed_6 = 802;
pub const PS_WARR81: C2RustUnnamed_6 = 801;
pub const PS_WARR80: C2RustUnnamed_6 = 800;
pub const PS_WARR79: C2RustUnnamed_6 = 799;
pub const PS_WARR78: C2RustUnnamed_6 = 798;
pub const PS_WARR77: C2RustUnnamed_6 = 797;
pub const PS_WARR76: C2RustUnnamed_6 = 796;
pub const PS_WARR75: C2RustUnnamed_6 = 795;
pub const PS_WARR74: C2RustUnnamed_6 = 794;
pub const PS_WARR73: C2RustUnnamed_6 = 793;
pub const PS_WARR72: C2RustUnnamed_6 = 792;
pub const PS_WARR71: C2RustUnnamed_6 = 791;
pub const PS_WARR70: C2RustUnnamed_6 = 790;
pub const PS_WARR69B: C2RustUnnamed_6 = 789;
pub const PS_WARR69: C2RustUnnamed_6 = 788;
pub const PS_WARR68: C2RustUnnamed_6 = 787;
pub const PS_WARR67: C2RustUnnamed_6 = 786;
pub const PS_WARR66: C2RustUnnamed_6 = 785;
pub const PS_WARR65: C2RustUnnamed_6 = 784;
pub const PS_WARR64: C2RustUnnamed_6 = 783;
pub const PS_WARR63: C2RustUnnamed_6 = 782;
pub const PS_WARR62: C2RustUnnamed_6 = 781;
pub const PS_WARR61: C2RustUnnamed_6 = 780;
pub const PS_WARR60: C2RustUnnamed_6 = 779;
pub const PS_WARR59: C2RustUnnamed_6 = 778;
pub const PS_WARR58: C2RustUnnamed_6 = 777;
pub const PS_WARR57: C2RustUnnamed_6 = 776;
pub const PS_WARR56: C2RustUnnamed_6 = 775;
pub const PS_WARR55: C2RustUnnamed_6 = 774;
pub const PS_WARR54: C2RustUnnamed_6 = 773;
pub const PS_WARR53: C2RustUnnamed_6 = 772;
pub const PS_WARR52: C2RustUnnamed_6 = 771;
pub const PS_WARR51: C2RustUnnamed_6 = 770;
pub const PS_WARR50: C2RustUnnamed_6 = 769;
pub const PS_WARR49: C2RustUnnamed_6 = 768;
pub const PS_WARR48: C2RustUnnamed_6 = 767;
pub const PS_WARR47: C2RustUnnamed_6 = 766;
pub const PS_WARR46: C2RustUnnamed_6 = 765;
pub const PS_WARR45: C2RustUnnamed_6 = 764;
pub const PS_WARR44: C2RustUnnamed_6 = 763;
pub const PS_WARR43: C2RustUnnamed_6 = 762;
pub const PS_WARR42: C2RustUnnamed_6 = 761;
pub const PS_WARR41: C2RustUnnamed_6 = 760;
pub const PS_WARR40: C2RustUnnamed_6 = 759;
pub const PS_WARR39: C2RustUnnamed_6 = 758;
pub const PS_WARR38: C2RustUnnamed_6 = 757;
pub const PS_WARR37: C2RustUnnamed_6 = 756;
pub const PS_WARR36: C2RustUnnamed_6 = 755;
pub const PS_WARR35: C2RustUnnamed_6 = 754;
pub const PS_WARR34: C2RustUnnamed_6 = 753;
pub const PS_WARR33: C2RustUnnamed_6 = 752;
pub const PS_WARR32: C2RustUnnamed_6 = 751;
pub const PS_WARR31: C2RustUnnamed_6 = 750;
pub const PS_WARR30: C2RustUnnamed_6 = 749;
pub const PS_WARR29: C2RustUnnamed_6 = 748;
pub const PS_WARR28: C2RustUnnamed_6 = 747;
pub const PS_WARR27: C2RustUnnamed_6 = 746;
pub const PS_WARR26: C2RustUnnamed_6 = 745;
pub const PS_WARR25: C2RustUnnamed_6 = 744;
pub const PS_WARR24: C2RustUnnamed_6 = 743;
pub const PS_WARR23: C2RustUnnamed_6 = 742;
pub const PS_WARR22: C2RustUnnamed_6 = 741;
pub const PS_WARR21: C2RustUnnamed_6 = 740;
pub const PS_WARR20: C2RustUnnamed_6 = 739;
pub const PS_WARR19: C2RustUnnamed_6 = 738;
pub const PS_WARR18: C2RustUnnamed_6 = 737;
pub const PS_WARR17: C2RustUnnamed_6 = 736;
pub const PS_WARR16C: C2RustUnnamed_6 = 735;
pub const PS_WARR16B: C2RustUnnamed_6 = 734;
pub const PS_WARR16: C2RustUnnamed_6 = 733;
pub const PS_WARR15C: C2RustUnnamed_6 = 732;
pub const PS_WARR15B: C2RustUnnamed_6 = 731;
pub const PS_WARR15: C2RustUnnamed_6 = 730;
pub const PS_WARR14C: C2RustUnnamed_6 = 729;
pub const PS_WARR14B: C2RustUnnamed_6 = 728;
pub const PS_WARR14: C2RustUnnamed_6 = 727;
pub const PS_WARR13: C2RustUnnamed_6 = 726;
pub const PS_WARR12: C2RustUnnamed_6 = 725;
pub const PS_WARR11: C2RustUnnamed_6 = 724;
pub const PS_WARR10: C2RustUnnamed_6 = 723;
pub const PS_WARR9: C2RustUnnamed_6 = 722;
pub const PS_WARR8: C2RustUnnamed_6 = 721;
pub const PS_WARR7: C2RustUnnamed_6 = 720;
pub const PS_WARR6: C2RustUnnamed_6 = 719;
pub const PS_WARR5: C2RustUnnamed_6 = 718;
pub const PS_WARR4: C2RustUnnamed_6 = 717;
pub const PS_WARR3: C2RustUnnamed_6 = 716;
pub const PS_WARR2: C2RustUnnamed_6 = 715;
pub const PS_WARR1: C2RustUnnamed_6 = 714;
pub const PS_ROGUE102: C2RustUnnamed_6 = 713;
pub const PS_ROGUE101: C2RustUnnamed_6 = 712;
pub const PS_ROGUE100: C2RustUnnamed_6 = 711;
pub const PS_ROGUE99: C2RustUnnamed_6 = 710;
pub const PS_ROGUE98: C2RustUnnamed_6 = 709;
pub const PS_ROGUE97: C2RustUnnamed_6 = 708;
pub const PS_ROGUE96: C2RustUnnamed_6 = 707;
pub const PS_ROGUE95: C2RustUnnamed_6 = 706;
pub const PS_ROGUE94: C2RustUnnamed_6 = 705;
pub const PS_ROGUE93: C2RustUnnamed_6 = 704;
pub const PS_ROGUE92: C2RustUnnamed_6 = 703;
pub const PS_ROGUE91: C2RustUnnamed_6 = 702;
pub const PS_ROGUE90: C2RustUnnamed_6 = 701;
pub const PS_ROGUE89: C2RustUnnamed_6 = 700;
pub const PS_ROGUE88: C2RustUnnamed_6 = 699;
pub const PS_ROGUE87: C2RustUnnamed_6 = 698;
pub const PS_ROGUE86: C2RustUnnamed_6 = 697;
pub const PS_ROGUE85: C2RustUnnamed_6 = 696;
pub const PS_ROGUE84: C2RustUnnamed_6 = 695;
pub const PS_ROGUE83: C2RustUnnamed_6 = 694;
pub const PS_ROGUE82: C2RustUnnamed_6 = 693;
pub const PS_ROGUE81: C2RustUnnamed_6 = 692;
pub const PS_ROGUE80: C2RustUnnamed_6 = 691;
pub const PS_ROGUE79: C2RustUnnamed_6 = 690;
pub const PS_ROGUE78: C2RustUnnamed_6 = 689;
pub const PS_ROGUE77: C2RustUnnamed_6 = 688;
pub const PS_ROGUE76: C2RustUnnamed_6 = 687;
pub const PS_ROGUE75: C2RustUnnamed_6 = 686;
pub const PS_ROGUE74: C2RustUnnamed_6 = 685;
pub const PS_ROGUE73: C2RustUnnamed_6 = 684;
pub const PS_ROGUE72: C2RustUnnamed_6 = 683;
pub const PS_ROGUE71: C2RustUnnamed_6 = 682;
pub const PS_ROGUE70: C2RustUnnamed_6 = 681;
pub const PS_ROGUE69B: C2RustUnnamed_6 = 680;
pub const PS_ROGUE69: C2RustUnnamed_6 = 679;
pub const PS_ROGUE68: C2RustUnnamed_6 = 678;
pub const PS_ROGUE67: C2RustUnnamed_6 = 677;
pub const PS_ROGUE66: C2RustUnnamed_6 = 676;
pub const PS_ROGUE65: C2RustUnnamed_6 = 675;
pub const PS_ROGUE64: C2RustUnnamed_6 = 674;
pub const PS_ROGUE63: C2RustUnnamed_6 = 673;
pub const PS_ROGUE62: C2RustUnnamed_6 = 672;
pub const PS_ROGUE61: C2RustUnnamed_6 = 671;
pub const PS_ROGUE60: C2RustUnnamed_6 = 670;
pub const PS_ROGUE59: C2RustUnnamed_6 = 669;
pub const PS_ROGUE58: C2RustUnnamed_6 = 668;
pub const PS_ROGUE57: C2RustUnnamed_6 = 667;
pub const PS_ROGUE56: C2RustUnnamed_6 = 666;
pub const PS_ROGUE55: C2RustUnnamed_6 = 665;
pub const PS_ROGUE54: C2RustUnnamed_6 = 664;
pub const PS_ROGUE53: C2RustUnnamed_6 = 663;
pub const PS_ROGUE52: C2RustUnnamed_6 = 662;
pub const PS_ROGUE51: C2RustUnnamed_6 = 661;
pub const PS_ROGUE50: C2RustUnnamed_6 = 660;
pub const PS_ROGUE49: C2RustUnnamed_6 = 659;
pub const PS_ROGUE48: C2RustUnnamed_6 = 658;
pub const PS_ROGUE47: C2RustUnnamed_6 = 657;
pub const PS_ROGUE46: C2RustUnnamed_6 = 656;
pub const PS_ROGUE45: C2RustUnnamed_6 = 655;
pub const PS_ROGUE44: C2RustUnnamed_6 = 654;
pub const PS_ROGUE43: C2RustUnnamed_6 = 653;
pub const PS_ROGUE42: C2RustUnnamed_6 = 652;
pub const PS_ROGUE41: C2RustUnnamed_6 = 651;
pub const PS_ROGUE40: C2RustUnnamed_6 = 650;
pub const PS_ROGUE39: C2RustUnnamed_6 = 649;
pub const PS_ROGUE38: C2RustUnnamed_6 = 648;
pub const PS_ROGUE37: C2RustUnnamed_6 = 647;
pub const PS_ROGUE36: C2RustUnnamed_6 = 646;
pub const PS_ROGUE35: C2RustUnnamed_6 = 645;
pub const PS_ROGUE34: C2RustUnnamed_6 = 644;
pub const PS_ROGUE33: C2RustUnnamed_6 = 643;
pub const PS_ROGUE32: C2RustUnnamed_6 = 642;
pub const PS_ROGUE31: C2RustUnnamed_6 = 641;
pub const PS_ROGUE30: C2RustUnnamed_6 = 640;
pub const PS_ROGUE29: C2RustUnnamed_6 = 639;
pub const PS_ROGUE28: C2RustUnnamed_6 = 638;
pub const PS_ROGUE27: C2RustUnnamed_6 = 637;
pub const PS_ROGUE26: C2RustUnnamed_6 = 636;
pub const PS_ROGUE25: C2RustUnnamed_6 = 635;
pub const PS_ROGUE24: C2RustUnnamed_6 = 634;
pub const PS_ROGUE23: C2RustUnnamed_6 = 633;
pub const PS_ROGUE22: C2RustUnnamed_6 = 632;
pub const PS_ROGUE21: C2RustUnnamed_6 = 631;
pub const PS_ROGUE20: C2RustUnnamed_6 = 630;
pub const PS_ROGUE19: C2RustUnnamed_6 = 629;
pub const PS_ROGUE18: C2RustUnnamed_6 = 628;
pub const PS_ROGUE17: C2RustUnnamed_6 = 627;
pub const PS_ROGUE16: C2RustUnnamed_6 = 626;
pub const PS_ROGUE15: C2RustUnnamed_6 = 625;
pub const PS_ROGUE14: C2RustUnnamed_6 = 624;
pub const PS_ROGUE13: C2RustUnnamed_6 = 623;
pub const PS_ROGUE12: C2RustUnnamed_6 = 622;
pub const PS_ROGUE11: C2RustUnnamed_6 = 621;
pub const PS_ROGUE10: C2RustUnnamed_6 = 620;
pub const PS_ROGUE9: C2RustUnnamed_6 = 619;
pub const PS_ROGUE8: C2RustUnnamed_6 = 618;
pub const PS_ROGUE7: C2RustUnnamed_6 = 617;
pub const PS_ROGUE6: C2RustUnnamed_6 = 616;
pub const PS_ROGUE5: C2RustUnnamed_6 = 615;
pub const PS_ROGUE4: C2RustUnnamed_6 = 614;
pub const PS_ROGUE3: C2RustUnnamed_6 = 613;
pub const PS_ROGUE2: C2RustUnnamed_6 = 612;
pub const PS_ROGUE1: C2RustUnnamed_6 = 611;
pub const PS_MAGE102: C2RustUnnamed_6 = 610;
pub const PS_MAGE101: C2RustUnnamed_6 = 609;
pub const PS_MAGE100: C2RustUnnamed_6 = 608;
pub const PS_MAGE99: C2RustUnnamed_6 = 607;
pub const PS_MAGE98: C2RustUnnamed_6 = 606;
pub const PS_MAGE97: C2RustUnnamed_6 = 605;
pub const PS_MAGE96: C2RustUnnamed_6 = 604;
pub const PS_MAGE95: C2RustUnnamed_6 = 603;
pub const PS_MAGE94: C2RustUnnamed_6 = 602;
pub const PS_MAGE93: C2RustUnnamed_6 = 601;
pub const PS_MAGE92: C2RustUnnamed_6 = 600;
pub const PS_MAGE91: C2RustUnnamed_6 = 599;
pub const PS_MAGE90: C2RustUnnamed_6 = 598;
pub const PS_MAGE89: C2RustUnnamed_6 = 597;
pub const PS_MAGE88: C2RustUnnamed_6 = 596;
pub const PS_MAGE87: C2RustUnnamed_6 = 595;
pub const PS_MAGE86: C2RustUnnamed_6 = 594;
pub const PS_MAGE85: C2RustUnnamed_6 = 593;
pub const PS_MAGE84: C2RustUnnamed_6 = 592;
pub const PS_MAGE83: C2RustUnnamed_6 = 591;
pub const PS_MAGE82: C2RustUnnamed_6 = 590;
pub const PS_MAGE81: C2RustUnnamed_6 = 589;
pub const PS_MAGE80: C2RustUnnamed_6 = 588;
pub const PS_MAGE79: C2RustUnnamed_6 = 587;
pub const PS_MAGE78: C2RustUnnamed_6 = 586;
pub const PS_MAGE77: C2RustUnnamed_6 = 585;
pub const PS_MAGE76: C2RustUnnamed_6 = 584;
pub const PS_MAGE75: C2RustUnnamed_6 = 583;
pub const PS_MAGE74: C2RustUnnamed_6 = 582;
pub const PS_MAGE73: C2RustUnnamed_6 = 581;
pub const PS_MAGE72: C2RustUnnamed_6 = 580;
pub const PS_MAGE71: C2RustUnnamed_6 = 579;
pub const PS_MAGE70: C2RustUnnamed_6 = 578;
pub const PS_MAGE69B: C2RustUnnamed_6 = 577;
pub const PS_MAGE69: C2RustUnnamed_6 = 576;
pub const PS_MAGE68: C2RustUnnamed_6 = 575;
pub const PS_MAGE67: C2RustUnnamed_6 = 574;
pub const PS_MAGE66: C2RustUnnamed_6 = 573;
pub const PS_MAGE65: C2RustUnnamed_6 = 572;
pub const PS_MAGE64: C2RustUnnamed_6 = 571;
pub const PS_MAGE63: C2RustUnnamed_6 = 570;
pub const PS_MAGE62: C2RustUnnamed_6 = 569;
pub const PS_MAGE61: C2RustUnnamed_6 = 568;
pub const PS_MAGE60: C2RustUnnamed_6 = 567;
pub const PS_MAGE59: C2RustUnnamed_6 = 566;
pub const PS_MAGE58: C2RustUnnamed_6 = 565;
pub const PS_MAGE57: C2RustUnnamed_6 = 564;
pub const PS_MAGE56: C2RustUnnamed_6 = 563;
pub const PS_MAGE55: C2RustUnnamed_6 = 562;
pub const PS_MAGE54: C2RustUnnamed_6 = 561;
pub const PS_MAGE53: C2RustUnnamed_6 = 560;
pub const PS_MAGE52: C2RustUnnamed_6 = 559;
pub const PS_MAGE51: C2RustUnnamed_6 = 558;
pub const PS_MAGE50: C2RustUnnamed_6 = 557;
pub const PS_MAGE49: C2RustUnnamed_6 = 556;
pub const PS_MAGE48: C2RustUnnamed_6 = 555;
pub const PS_MAGE47: C2RustUnnamed_6 = 554;
pub const PS_MAGE46: C2RustUnnamed_6 = 553;
pub const PS_MAGE45: C2RustUnnamed_6 = 552;
pub const PS_MAGE44: C2RustUnnamed_6 = 551;
pub const PS_MAGE43: C2RustUnnamed_6 = 550;
pub const PS_MAGE42: C2RustUnnamed_6 = 549;
pub const PS_MAGE41: C2RustUnnamed_6 = 548;
pub const PS_MAGE40: C2RustUnnamed_6 = 547;
pub const PS_MAGE39: C2RustUnnamed_6 = 546;
pub const PS_MAGE38: C2RustUnnamed_6 = 545;
pub const PS_MAGE37: C2RustUnnamed_6 = 544;
pub const PS_MAGE36: C2RustUnnamed_6 = 543;
pub const PS_MAGE35: C2RustUnnamed_6 = 542;
pub const PS_MAGE34: C2RustUnnamed_6 = 541;
pub const PS_MAGE33: C2RustUnnamed_6 = 540;
pub const PS_MAGE32: C2RustUnnamed_6 = 539;
pub const PS_MAGE31: C2RustUnnamed_6 = 538;
pub const PS_MAGE30: C2RustUnnamed_6 = 537;
pub const PS_MAGE29: C2RustUnnamed_6 = 536;
pub const PS_MAGE28: C2RustUnnamed_6 = 535;
pub const PS_MAGE27: C2RustUnnamed_6 = 534;
pub const PS_MAGE26: C2RustUnnamed_6 = 533;
pub const PS_MAGE25: C2RustUnnamed_6 = 532;
pub const PS_MAGE24: C2RustUnnamed_6 = 531;
pub const PS_MAGE23: C2RustUnnamed_6 = 530;
pub const PS_MAGE22: C2RustUnnamed_6 = 529;
pub const PS_MAGE21: C2RustUnnamed_6 = 528;
pub const PS_MAGE20: C2RustUnnamed_6 = 527;
pub const PS_MAGE19: C2RustUnnamed_6 = 526;
pub const PS_MAGE18: C2RustUnnamed_6 = 525;
pub const PS_MAGE17: C2RustUnnamed_6 = 524;
pub const PS_MAGE16: C2RustUnnamed_6 = 523;
pub const PS_MAGE15: C2RustUnnamed_6 = 522;
pub const PS_MAGE14: C2RustUnnamed_6 = 521;
pub const PS_MAGE13: C2RustUnnamed_6 = 520;
pub const PS_MAGE12: C2RustUnnamed_6 = 519;
pub const PS_MAGE11: C2RustUnnamed_6 = 518;
pub const PS_MAGE10: C2RustUnnamed_6 = 517;
pub const PS_MAGE9: C2RustUnnamed_6 = 516;
pub const PS_MAGE8: C2RustUnnamed_6 = 515;
pub const PS_MAGE7: C2RustUnnamed_6 = 514;
pub const PS_MAGE6: C2RustUnnamed_6 = 513;
pub const PS_MAGE5: C2RustUnnamed_6 = 512;
pub const PS_MAGE4: C2RustUnnamed_6 = 511;
pub const PS_MAGE3: C2RustUnnamed_6 = 510;
pub const PS_MAGE2: C2RustUnnamed_6 = 509;
pub const PS_MAGE1: C2RustUnnamed_6 = 508;
pub const TSFX_WOUND: C2RustUnnamed_6 = 507;
pub const TSFX_WITCH50: C2RustUnnamed_6 = 506;
pub const TSFX_WITCH49: C2RustUnnamed_6 = 505;
pub const TSFX_WITCH48: C2RustUnnamed_6 = 504;
pub const TSFX_WITCH47: C2RustUnnamed_6 = 503;
pub const TSFX_WITCH46: C2RustUnnamed_6 = 502;
pub const TSFX_WITCH45: C2RustUnnamed_6 = 501;
pub const TSFX_WITCH44: C2RustUnnamed_6 = 500;
pub const TSFX_WITCH43: C2RustUnnamed_6 = 499;
pub const TSFX_WITCH42: C2RustUnnamed_6 = 498;
pub const TSFX_WITCH41: C2RustUnnamed_6 = 497;
pub const TSFX_WITCH40: C2RustUnnamed_6 = 496;
pub const TSFX_WITCH39: C2RustUnnamed_6 = 495;
pub const TSFX_WITCH38: C2RustUnnamed_6 = 494;
pub const TSFX_WITCH37: C2RustUnnamed_6 = 493;
pub const TSFX_WITCH36: C2RustUnnamed_6 = 492;
pub const TSFX_WITCH35: C2RustUnnamed_6 = 491;
pub const TSFX_WITCH34: C2RustUnnamed_6 = 490;
pub const TSFX_WITCH33: C2RustUnnamed_6 = 489;
pub const TSFX_WITCH32: C2RustUnnamed_6 = 488;
pub const TSFX_WITCH31: C2RustUnnamed_6 = 487;
pub const TSFX_WITCH30: C2RustUnnamed_6 = 486;
pub const TSFX_WITCH29: C2RustUnnamed_6 = 485;
pub const TSFX_WITCH28: C2RustUnnamed_6 = 484;
pub const TSFX_WITCH27: C2RustUnnamed_6 = 483;
pub const TSFX_WITCH26: C2RustUnnamed_6 = 482;
pub const TSFX_WITCH25: C2RustUnnamed_6 = 481;
pub const TSFX_WITCH24: C2RustUnnamed_6 = 480;
pub const TSFX_WITCH23: C2RustUnnamed_6 = 479;
pub const TSFX_WITCH22: C2RustUnnamed_6 = 478;
pub const TSFX_WITCH21: C2RustUnnamed_6 = 477;
pub const TSFX_WITCH20: C2RustUnnamed_6 = 476;
pub const TSFX_WITCH19: C2RustUnnamed_6 = 475;
pub const TSFX_WITCH18: C2RustUnnamed_6 = 474;
pub const TSFX_WITCH17: C2RustUnnamed_6 = 473;
pub const TSFX_WITCH16: C2RustUnnamed_6 = 472;
pub const TSFX_WITCH15: C2RustUnnamed_6 = 471;
pub const TSFX_WITCH14: C2RustUnnamed_6 = 470;
pub const TSFX_WITCH13: C2RustUnnamed_6 = 469;
pub const TSFX_WITCH12: C2RustUnnamed_6 = 468;
pub const TSFX_WITCH11: C2RustUnnamed_6 = 467;
pub const TSFX_WITCH10: C2RustUnnamed_6 = 466;
pub const TSFX_WITCH9: C2RustUnnamed_6 = 465;
pub const TSFX_WITCH8: C2RustUnnamed_6 = 464;
pub const TSFX_WITCH7: C2RustUnnamed_6 = 463;
pub const TSFX_WITCH6: C2RustUnnamed_6 = 462;
pub const TSFX_WITCH5: C2RustUnnamed_6 = 461;
pub const TSFX_WITCH4: C2RustUnnamed_6 = 460;
pub const TSFX_WITCH3: C2RustUnnamed_6 = 459;
pub const TSFX_WITCH2: C2RustUnnamed_6 = 458;
pub const TSFX_WITCH1: C2RustUnnamed_6 = 457;
pub const TSFX_TAVERN45: C2RustUnnamed_6 = 456;
pub const TSFX_TAVERN44: C2RustUnnamed_6 = 455;
pub const TSFX_TAVERN43: C2RustUnnamed_6 = 454;
pub const TSFX_TAVERN42: C2RustUnnamed_6 = 453;
pub const TSFX_TAVERN41: C2RustUnnamed_6 = 452;
pub const TSFX_TAVERN40: C2RustUnnamed_6 = 451;
pub const TSFX_TAVERN39: C2RustUnnamed_6 = 450;
pub const TSFX_TAVERN38: C2RustUnnamed_6 = 449;
pub const TSFX_TAVERN37: C2RustUnnamed_6 = 448;
pub const TSFX_TAVERN36: C2RustUnnamed_6 = 447;
pub const TSFX_TAVERN35: C2RustUnnamed_6 = 446;
pub const TSFX_TAVERN34: C2RustUnnamed_6 = 445;
pub const TSFX_TAVERN33: C2RustUnnamed_6 = 444;
pub const TSFX_TAVERN32: C2RustUnnamed_6 = 443;
pub const TSFX_TAVERN31: C2RustUnnamed_6 = 442;
pub const TSFX_TAVERN30: C2RustUnnamed_6 = 441;
pub const TSFX_TAVERN29: C2RustUnnamed_6 = 440;
pub const TSFX_TAVERN28: C2RustUnnamed_6 = 439;
pub const TSFX_TAVERN27: C2RustUnnamed_6 = 438;
pub const TSFX_TAVERN26: C2RustUnnamed_6 = 437;
pub const TSFX_TAVERN25: C2RustUnnamed_6 = 436;
pub const TSFX_TAVERN24: C2RustUnnamed_6 = 435;
pub const TSFX_TAVERN23: C2RustUnnamed_6 = 434;
pub const TSFX_TAVERN22: C2RustUnnamed_6 = 433;
pub const TSFX_TAVERN21: C2RustUnnamed_6 = 432;
pub const TSFX_TAVERN20: C2RustUnnamed_6 = 431;
pub const TSFX_TAVERN19: C2RustUnnamed_6 = 430;
pub const TSFX_TAVERN18: C2RustUnnamed_6 = 429;
pub const TSFX_TAVERN17: C2RustUnnamed_6 = 428;
pub const TSFX_TAVERN16: C2RustUnnamed_6 = 427;
pub const TSFX_TAVERN15: C2RustUnnamed_6 = 426;
pub const TSFX_TAVERN14: C2RustUnnamed_6 = 425;
pub const TSFX_TAVERN13: C2RustUnnamed_6 = 424;
pub const TSFX_TAVERN12: C2RustUnnamed_6 = 423;
pub const TSFX_TAVERN11: C2RustUnnamed_6 = 422;
pub const TSFX_TAVERN10: C2RustUnnamed_6 = 421;
pub const TSFX_TAVERN9: C2RustUnnamed_6 = 420;
pub const TSFX_TAVERN8: C2RustUnnamed_6 = 419;
pub const TSFX_TAVERN7: C2RustUnnamed_6 = 418;
pub const TSFX_TAVERN6: C2RustUnnamed_6 = 417;
pub const TSFX_TAVERN5: C2RustUnnamed_6 = 416;
pub const TSFX_TAVERN4: C2RustUnnamed_6 = 415;
pub const TSFX_TAVERN3: C2RustUnnamed_6 = 414;
pub const TSFX_TAVERN2: C2RustUnnamed_6 = 413;
pub const TSFX_TAVERN1: C2RustUnnamed_6 = 412;
pub const TSFX_TAVERN0: C2RustUnnamed_6 = 411;
pub const TSFX_STORY38: C2RustUnnamed_6 = 410;
pub const TSFX_STORY37: C2RustUnnamed_6 = 409;
pub const TSFX_STORY36: C2RustUnnamed_6 = 408;
pub const TSFX_STORY35: C2RustUnnamed_6 = 407;
pub const TSFX_STORY34: C2RustUnnamed_6 = 406;
pub const TSFX_STORY33: C2RustUnnamed_6 = 405;
pub const TSFX_STORY32: C2RustUnnamed_6 = 404;
pub const TSFX_STORY31: C2RustUnnamed_6 = 403;
pub const TSFX_STORY30: C2RustUnnamed_6 = 402;
pub const TSFX_STORY29: C2RustUnnamed_6 = 401;
pub const TSFX_STORY28: C2RustUnnamed_6 = 400;
pub const TSFX_STORY27: C2RustUnnamed_6 = 399;
pub const TSFX_STORY26: C2RustUnnamed_6 = 398;
pub const TSFX_STORY25: C2RustUnnamed_6 = 397;
pub const TSFX_STORY24: C2RustUnnamed_6 = 396;
pub const TSFX_STORY23: C2RustUnnamed_6 = 395;
pub const TSFX_STORY22: C2RustUnnamed_6 = 394;
pub const TSFX_STORY21: C2RustUnnamed_6 = 393;
pub const TSFX_STORY20: C2RustUnnamed_6 = 392;
pub const TSFX_STORY19: C2RustUnnamed_6 = 391;
pub const TSFX_STORY18: C2RustUnnamed_6 = 390;
pub const TSFX_STORY17: C2RustUnnamed_6 = 389;
pub const TSFX_STORY16: C2RustUnnamed_6 = 388;
pub const TSFX_STORY15: C2RustUnnamed_6 = 387;
pub const TSFX_STORY14: C2RustUnnamed_6 = 386;
pub const TSFX_STORY13: C2RustUnnamed_6 = 385;
pub const TSFX_STORY12: C2RustUnnamed_6 = 384;
pub const TSFX_STORY11: C2RustUnnamed_6 = 383;
pub const TSFX_STORY10: C2RustUnnamed_6 = 382;
pub const TSFX_STORY9: C2RustUnnamed_6 = 381;
pub const TSFX_STORY8: C2RustUnnamed_6 = 380;
pub const TSFX_STORY7: C2RustUnnamed_6 = 379;
pub const TSFX_STORY6: C2RustUnnamed_6 = 378;
pub const TSFX_STORY5: C2RustUnnamed_6 = 377;
pub const TSFX_STORY4: C2RustUnnamed_6 = 376;
pub const TSFX_STORY3: C2RustUnnamed_6 = 375;
pub const TSFX_STORY2: C2RustUnnamed_6 = 374;
pub const TSFX_STORY1: C2RustUnnamed_6 = 373;
pub const TSFX_STORY0: C2RustUnnamed_6 = 372;
pub const TSFX_PRIEST7: C2RustUnnamed_6 = 371;
pub const TSFX_PRIEST6: C2RustUnnamed_6 = 370;
pub const TSFX_PRIEST5: C2RustUnnamed_6 = 369;
pub const TSFX_PRIEST4: C2RustUnnamed_6 = 368;
pub const TSFX_PRIEST3: C2RustUnnamed_6 = 367;
pub const TSFX_PRIEST2: C2RustUnnamed_6 = 366;
pub const TSFX_PRIEST1: C2RustUnnamed_6 = 365;
pub const TSFX_PRIEST0: C2RustUnnamed_6 = 364;
pub const TSFX_PEGBOY43: C2RustUnnamed_6 = 363;
pub const TSFX_PEGBOY42: C2RustUnnamed_6 = 362;
pub const TSFX_PEGBOY41: C2RustUnnamed_6 = 361;
pub const TSFX_PEGBOY40: C2RustUnnamed_6 = 360;
pub const TSFX_PEGBOY39: C2RustUnnamed_6 = 359;
pub const TSFX_PEGBOY38: C2RustUnnamed_6 = 358;
pub const TSFX_PEGBOY37: C2RustUnnamed_6 = 357;
pub const TSFX_PEGBOY36: C2RustUnnamed_6 = 356;
pub const TSFX_PEGBOY35: C2RustUnnamed_6 = 355;
pub const TSFX_PEGBOY34: C2RustUnnamed_6 = 354;
pub const TSFX_PEGBOY33: C2RustUnnamed_6 = 353;
pub const TSFX_PEGBOY32: C2RustUnnamed_6 = 352;
pub const TSFX_PEGBOY31: C2RustUnnamed_6 = 351;
pub const TSFX_PEGBOY30: C2RustUnnamed_6 = 350;
pub const TSFX_PEGBOY29: C2RustUnnamed_6 = 349;
pub const TSFX_PEGBOY28: C2RustUnnamed_6 = 348;
pub const TSFX_PEGBOY27: C2RustUnnamed_6 = 347;
pub const TSFX_PEGBOY26: C2RustUnnamed_6 = 346;
pub const TSFX_PEGBOY25: C2RustUnnamed_6 = 345;
pub const TSFX_PEGBOY24: C2RustUnnamed_6 = 344;
pub const TSFX_PEGBOY23: C2RustUnnamed_6 = 343;
pub const TSFX_PEGBOY22: C2RustUnnamed_6 = 342;
pub const TSFX_PEGBOY21: C2RustUnnamed_6 = 341;
pub const TSFX_PEGBOY20: C2RustUnnamed_6 = 340;
pub const TSFX_PEGBOY19: C2RustUnnamed_6 = 339;
pub const TSFX_PEGBOY18: C2RustUnnamed_6 = 338;
pub const TSFX_PEGBOY17: C2RustUnnamed_6 = 337;
pub const TSFX_PEGBOY16: C2RustUnnamed_6 = 336;
pub const TSFX_PEGBOY15: C2RustUnnamed_6 = 335;
pub const TSFX_PEGBOY14: C2RustUnnamed_6 = 334;
pub const TSFX_PEGBOY13: C2RustUnnamed_6 = 333;
pub const TSFX_PEGBOY12: C2RustUnnamed_6 = 332;
pub const TSFX_PEGBOY11: C2RustUnnamed_6 = 331;
pub const TSFX_PEGBOY10: C2RustUnnamed_6 = 330;
pub const TSFX_PEGBOY9: C2RustUnnamed_6 = 329;
pub const TSFX_PEGBOY8: C2RustUnnamed_6 = 328;
pub const TSFX_PEGBOY7: C2RustUnnamed_6 = 327;
pub const TSFX_PEGBOY6: C2RustUnnamed_6 = 326;
pub const TSFX_PEGBOY5: C2RustUnnamed_6 = 325;
pub const TSFX_PEGBOY4: C2RustUnnamed_6 = 324;
pub const TSFX_PEGBOY3: C2RustUnnamed_6 = 323;
pub const TSFX_PEGBOY2: C2RustUnnamed_6 = 322;
pub const TSFX_PEGBOY1: C2RustUnnamed_6 = 321;
pub const TSFX_HEALER47: C2RustUnnamed_6 = 320;
pub const TSFX_HEALER46: C2RustUnnamed_6 = 319;
pub const TSFX_HEALER45: C2RustUnnamed_6 = 318;
pub const TSFX_HEALER44: C2RustUnnamed_6 = 317;
pub const TSFX_HEALER43: C2RustUnnamed_6 = 316;
pub const TSFX_HEALER42: C2RustUnnamed_6 = 315;
pub const TSFX_HEALER41: C2RustUnnamed_6 = 314;
pub const TSFX_HEALER40: C2RustUnnamed_6 = 313;
pub const TSFX_HEALER39: C2RustUnnamed_6 = 312;
pub const TSFX_HEALER38: C2RustUnnamed_6 = 311;
pub const TSFX_HEALER37: C2RustUnnamed_6 = 310;
pub const TSFX_HEALER36: C2RustUnnamed_6 = 309;
pub const TSFX_HEALER35: C2RustUnnamed_6 = 308;
pub const TSFX_HEALER34: C2RustUnnamed_6 = 307;
pub const TSFX_HEALER33: C2RustUnnamed_6 = 306;
pub const TSFX_HEALER32: C2RustUnnamed_6 = 305;
pub const TSFX_HEALER31: C2RustUnnamed_6 = 304;
pub const TSFX_HEALER30: C2RustUnnamed_6 = 303;
pub const TSFX_HEALER29: C2RustUnnamed_6 = 302;
pub const TSFX_HEALER28: C2RustUnnamed_6 = 301;
pub const TSFX_HEALER27: C2RustUnnamed_6 = 300;
pub const TSFX_HEALER26: C2RustUnnamed_6 = 299;
pub const TSFX_HEALER25: C2RustUnnamed_6 = 298;
pub const TSFX_HEALER24: C2RustUnnamed_6 = 297;
pub const TSFX_HEALER23: C2RustUnnamed_6 = 296;
pub const TSFX_HEALER22: C2RustUnnamed_6 = 295;
pub const TSFX_HEALER21: C2RustUnnamed_6 = 294;
pub const TSFX_HEALER20: C2RustUnnamed_6 = 293;
pub const TSFX_HEALER19: C2RustUnnamed_6 = 292;
pub const TSFX_HEALER18: C2RustUnnamed_6 = 291;
pub const TSFX_HEALER17: C2RustUnnamed_6 = 290;
pub const TSFX_HEALER16: C2RustUnnamed_6 = 289;
pub const TSFX_HEALER15: C2RustUnnamed_6 = 288;
pub const TSFX_HEALER14: C2RustUnnamed_6 = 287;
pub const TSFX_HEALER13: C2RustUnnamed_6 = 286;
pub const TSFX_HEALER12: C2RustUnnamed_6 = 285;
pub const TSFX_HEALER11: C2RustUnnamed_6 = 284;
pub const TSFX_HEALER10: C2RustUnnamed_6 = 283;
pub const TSFX_HEALER9: C2RustUnnamed_6 = 282;
pub const TSFX_HEALER8: C2RustUnnamed_6 = 281;
pub const TSFX_HEALER7: C2RustUnnamed_6 = 280;
pub const TSFX_HEALER6: C2RustUnnamed_6 = 279;
pub const TSFX_HEALER5: C2RustUnnamed_6 = 278;
pub const TSFX_HEALER4: C2RustUnnamed_6 = 277;
pub const TSFX_HEALER3: C2RustUnnamed_6 = 276;
pub const TSFX_HEALER2: C2RustUnnamed_6 = 275;
pub const TSFX_HEALER1: C2RustUnnamed_6 = 274;
pub const TSFX_DRUNK35: C2RustUnnamed_6 = 273;
pub const TSFX_DRUNK34: C2RustUnnamed_6 = 272;
pub const TSFX_DRUNK33: C2RustUnnamed_6 = 271;
pub const TSFX_DRUNK32: C2RustUnnamed_6 = 270;
pub const TSFX_DRUNK31: C2RustUnnamed_6 = 269;
pub const TSFX_DRUNK30: C2RustUnnamed_6 = 268;
pub const TSFX_DRUNK29: C2RustUnnamed_6 = 267;
pub const TSFX_DRUNK28: C2RustUnnamed_6 = 266;
pub const TSFX_DRUNK27: C2RustUnnamed_6 = 265;
pub const TSFX_DRUNK26: C2RustUnnamed_6 = 264;
pub const TSFX_DRUNK25: C2RustUnnamed_6 = 263;
pub const TSFX_DRUNK24: C2RustUnnamed_6 = 262;
pub const TSFX_DRUNK23: C2RustUnnamed_6 = 261;
pub const TSFX_DRUNK22: C2RustUnnamed_6 = 260;
pub const TSFX_DRUNK21: C2RustUnnamed_6 = 259;
pub const TSFX_DRUNK20: C2RustUnnamed_6 = 258;
pub const TSFX_DRUNK19: C2RustUnnamed_6 = 257;
pub const TSFX_DRUNK18: C2RustUnnamed_6 = 256;
pub const TSFX_DRUNK17: C2RustUnnamed_6 = 255;
pub const TSFX_DRUNK16: C2RustUnnamed_6 = 254;
pub const TSFX_DRUNK15: C2RustUnnamed_6 = 253;
pub const TSFX_DRUNK14: C2RustUnnamed_6 = 252;
pub const TSFX_DRUNK13: C2RustUnnamed_6 = 251;
pub const TSFX_DRUNK12: C2RustUnnamed_6 = 250;
pub const TSFX_DRUNK11: C2RustUnnamed_6 = 249;
pub const TSFX_DRUNK10: C2RustUnnamed_6 = 248;
pub const TSFX_DRUNK9: C2RustUnnamed_6 = 247;
pub const TSFX_DRUNK8: C2RustUnnamed_6 = 246;
pub const TSFX_DRUNK7: C2RustUnnamed_6 = 245;
pub const TSFX_DRUNK6: C2RustUnnamed_6 = 244;
pub const TSFX_DRUNK5: C2RustUnnamed_6 = 243;
pub const TSFX_DRUNK4: C2RustUnnamed_6 = 242;
pub const TSFX_DRUNK3: C2RustUnnamed_6 = 241;
pub const TSFX_DRUNK2: C2RustUnnamed_6 = 240;
pub const TSFX_DRUNK1: C2RustUnnamed_6 = 239;
pub const TSFX_DEADGUY: C2RustUnnamed_6 = 238;
pub const TSFX_COW2: C2RustUnnamed_6 = 237;
pub const TSFX_COW1: C2RustUnnamed_6 = 236;
pub const TSFX_SMITH56: C2RustUnnamed_6 = 235;
pub const TSFX_SMITH55: C2RustUnnamed_6 = 234;
pub const TSFX_SMITH54: C2RustUnnamed_6 = 233;
pub const TSFX_SMITH53: C2RustUnnamed_6 = 232;
pub const TSFX_SMITH52: C2RustUnnamed_6 = 231;
pub const TSFX_SMITH51: C2RustUnnamed_6 = 230;
pub const TSFX_SMITH50: C2RustUnnamed_6 = 229;
pub const TSFX_SMITH49: C2RustUnnamed_6 = 228;
pub const TSFX_SMITH48: C2RustUnnamed_6 = 227;
pub const TSFX_SMITH47: C2RustUnnamed_6 = 226;
pub const TSFX_SMITH46: C2RustUnnamed_6 = 225;
pub const TSFX_SMITH45: C2RustUnnamed_6 = 224;
pub const TSFX_SMITH44: C2RustUnnamed_6 = 223;
pub const TSFX_SMITH43: C2RustUnnamed_6 = 222;
pub const TSFX_SMITH42: C2RustUnnamed_6 = 221;
pub const TSFX_SMITH41: C2RustUnnamed_6 = 220;
pub const TSFX_SMITH40: C2RustUnnamed_6 = 219;
pub const TSFX_SMITH39: C2RustUnnamed_6 = 218;
pub const TSFX_SMITH38: C2RustUnnamed_6 = 217;
pub const TSFX_SMITH37: C2RustUnnamed_6 = 216;
pub const TSFX_SMITH36: C2RustUnnamed_6 = 215;
pub const TSFX_SMITH35: C2RustUnnamed_6 = 214;
pub const TSFX_SMITH34: C2RustUnnamed_6 = 213;
pub const TSFX_SMITH33: C2RustUnnamed_6 = 212;
pub const TSFX_SMITH32: C2RustUnnamed_6 = 211;
pub const TSFX_SMITH31: C2RustUnnamed_6 = 210;
pub const TSFX_SMITH30: C2RustUnnamed_6 = 209;
pub const TSFX_SMITH29: C2RustUnnamed_6 = 208;
pub const TSFX_SMITH28: C2RustUnnamed_6 = 207;
pub const TSFX_SMITH27: C2RustUnnamed_6 = 206;
pub const TSFX_SMITH26: C2RustUnnamed_6 = 205;
pub const TSFX_SMITH25: C2RustUnnamed_6 = 204;
pub const TSFX_SMITH24: C2RustUnnamed_6 = 203;
pub const TSFX_SMITH23: C2RustUnnamed_6 = 202;
pub const TSFX_SMITH22: C2RustUnnamed_6 = 201;
pub const TSFX_SMITH21: C2RustUnnamed_6 = 200;
pub const TSFX_SMITH20: C2RustUnnamed_6 = 199;
pub const TSFX_SMITH19: C2RustUnnamed_6 = 198;
pub const TSFX_SMITH18: C2RustUnnamed_6 = 197;
pub const TSFX_SMITH17: C2RustUnnamed_6 = 196;
pub const TSFX_SMITH16: C2RustUnnamed_6 = 195;
pub const TSFX_SMITH15: C2RustUnnamed_6 = 194;
pub const TSFX_SMITH14: C2RustUnnamed_6 = 193;
pub const TSFX_SMITH13: C2RustUnnamed_6 = 192;
pub const TSFX_SMITH12: C2RustUnnamed_6 = 191;
pub const TSFX_SMITH11: C2RustUnnamed_6 = 190;
pub const TSFX_SMITH10: C2RustUnnamed_6 = 189;
pub const TSFX_SMITH9: C2RustUnnamed_6 = 188;
pub const TSFX_SMITH8: C2RustUnnamed_6 = 187;
pub const TSFX_SMITH7: C2RustUnnamed_6 = 186;
pub const TSFX_SMITH6: C2RustUnnamed_6 = 185;
pub const TSFX_SMITH5: C2RustUnnamed_6 = 184;
pub const TSFX_SMITH4: C2RustUnnamed_6 = 183;
pub const TSFX_SMITH3: C2RustUnnamed_6 = 182;
pub const TSFX_SMITH2: C2RustUnnamed_6 = 181;
pub const TSFX_SMITH1: C2RustUnnamed_6 = 180;
pub const TSFX_BMAID40: C2RustUnnamed_6 = 179;
pub const TSFX_BMAID39: C2RustUnnamed_6 = 178;
pub const TSFX_BMAID38: C2RustUnnamed_6 = 177;
pub const TSFX_BMAID37: C2RustUnnamed_6 = 176;
pub const TSFX_BMAID36: C2RustUnnamed_6 = 175;
pub const TSFX_BMAID35: C2RustUnnamed_6 = 174;
pub const TSFX_BMAID34: C2RustUnnamed_6 = 173;
pub const TSFX_BMAID33: C2RustUnnamed_6 = 172;
pub const TSFX_BMAID32: C2RustUnnamed_6 = 171;
pub const TSFX_BMAID31: C2RustUnnamed_6 = 170;
pub const TSFX_BMAID30: C2RustUnnamed_6 = 169;
pub const TSFX_BMAID29: C2RustUnnamed_6 = 168;
pub const TSFX_BMAID28: C2RustUnnamed_6 = 167;
pub const TSFX_BMAID27: C2RustUnnamed_6 = 166;
pub const TSFX_BMAID26: C2RustUnnamed_6 = 165;
pub const TSFX_BMAID25: C2RustUnnamed_6 = 164;
pub const TSFX_BMAID24: C2RustUnnamed_6 = 163;
pub const TSFX_BMAID23: C2RustUnnamed_6 = 162;
pub const TSFX_BMAID22: C2RustUnnamed_6 = 161;
pub const TSFX_BMAID21: C2RustUnnamed_6 = 160;
pub const TSFX_BMAID20: C2RustUnnamed_6 = 159;
pub const TSFX_BMAID19: C2RustUnnamed_6 = 158;
pub const TSFX_BMAID18: C2RustUnnamed_6 = 157;
pub const TSFX_BMAID17: C2RustUnnamed_6 = 156;
pub const TSFX_BMAID16: C2RustUnnamed_6 = 155;
pub const TSFX_BMAID15: C2RustUnnamed_6 = 154;
pub const TSFX_BMAID14: C2RustUnnamed_6 = 153;
pub const TSFX_BMAID13: C2RustUnnamed_6 = 152;
pub const TSFX_BMAID12: C2RustUnnamed_6 = 151;
pub const TSFX_BMAID11: C2RustUnnamed_6 = 150;
pub const TSFX_BMAID10: C2RustUnnamed_6 = 149;
pub const TSFX_BMAID9: C2RustUnnamed_6 = 148;
pub const TSFX_BMAID8: C2RustUnnamed_6 = 147;
pub const TSFX_BMAID7: C2RustUnnamed_6 = 146;
pub const TSFX_BMAID6: C2RustUnnamed_6 = 145;
pub const TSFX_BMAID5: C2RustUnnamed_6 = 144;
pub const TSFX_BMAID4: C2RustUnnamed_6 = 143;
pub const TSFX_BMAID3: C2RustUnnamed_6 = 142;
pub const TSFX_BMAID2: C2RustUnnamed_6 = 141;
pub const TSFX_BMAID1: C2RustUnnamed_6 = 140;
pub const LS_WALLSTRT: C2RustUnnamed_6 = 139;
pub const LS_WALLLOOP: C2RustUnnamed_6 = 138;
pub const LS_VTHEFT: C2RustUnnamed_6 = 137;
pub const LS_TELEPORT: C2RustUnnamed_6 = 136;
pub const LS_TRAPDIS: C2RustUnnamed_6 = 135;
pub const LS_STORM: C2RustUnnamed_6 = 134;
pub const LS_SPOUTSTR: C2RustUnnamed_6 = 133;
pub const LS_SPOUTLOP: C2RustUnnamed_6 = 132;
pub const LS_SOULFIRE: C2RustUnnamed_6 = 131;
pub const LS_SHATTER: C2RustUnnamed_6 = 130;
pub const LS_SENTINEL: C2RustUnnamed_6 = 129;
pub const LS_SCURIMP: C2RustUnnamed_6 = 128;
pub const LS_SCURSE: C2RustUnnamed_6 = 127;
pub const LS_RESUR: C2RustUnnamed_6 = 126;
pub const LS_PUDDLE: C2RustUnnamed_6 = 125;
pub const LS_PORTAL: C2RustUnnamed_6 = 124;
pub const LS_NOVA: C2RustUnnamed_6 = 123;
pub const LS_MSHIELD: C2RustUnnamed_6 = 122;
pub const LS_LTNING: C2RustUnnamed_6 = 121;
pub const LS_LNING1: C2RustUnnamed_6 = 120;
pub const LS_INVPOT: C2RustUnnamed_6 = 119;
pub const LS_INVISIBL: C2RustUnnamed_6 = 118;
pub const LS_INFRAVIS: C2RustUnnamed_6 = 117;
pub const LS_HYPER: C2RustUnnamed_6 = 116;
pub const LS_HOLYBOLT: C2RustUnnamed_6 = 115;
pub const LS_GUARDLAN: C2RustUnnamed_6 = 114;
pub const LS_GUARD: C2RustUnnamed_6 = 113;
pub const LS_GSHRINE: C2RustUnnamed_6 = 112;
pub const LS_GOLUMDED: C2RustUnnamed_6 = 111;
pub const LS_GOLUM: C2RustUnnamed_6 = 110;
pub const LS_FOUNTAIN: C2RustUnnamed_6 = 109;
pub const LS_FLASH: C2RustUnnamed_6 = 108;
pub const LS_FLAMWAVE: C2RustUnnamed_6 = 107;
pub const LS_FIRIMP2: C2RustUnnamed_6 = 106;
pub const LS_FIRIMP1: C2RustUnnamed_6 = 105;
pub const LS_FBOLT2: C2RustUnnamed_6 = 104;
pub const LS_FBOLT1: C2RustUnnamed_6 = 103;
pub const LS_FBALL: C2RustUnnamed_6 = 102;
pub const LS_ETHEREAL: C2RustUnnamed_6 = 101;
pub const LS_ELEMENTL: C2RustUnnamed_6 = 100;
pub const LS_ELECIMP1: C2RustUnnamed_6 = 99;
pub const LS_DSERP: C2RustUnnamed_6 = 98;
pub const LS_CHLTNING: C2RustUnnamed_6 = 97;
pub const LS_CBOLT: C2RustUnnamed_6 = 96;
pub const LS_CALDRON: C2RustUnnamed_6 = 95;
pub const LS_BSIMPCT: C2RustUnnamed_6 = 94;
pub const LS_BONESP: C2RustUnnamed_6 = 93;
pub const LS_BLSIMPT: C2RustUnnamed_6 = 92;
pub const LS_BLODSTAR: C2RustUnnamed_6 = 91;
pub const LS_BLODBOIL: C2RustUnnamed_6 = 90;
pub const LS_ARROWALL: C2RustUnnamed_6 = 89;
pub const LS_APOC: C2RustUnnamed_6 = 88;
pub const LS_ACIDS: C2RustUnnamed_6 = 87;
pub const LS_ACID: C2RustUnnamed_6 = 86;
pub const IS_REPAIR: C2RustUnnamed_6 = 85;
pub const LS_HEALING: C2RustUnnamed_6 = 84;
pub const IS_CAST9: C2RustUnnamed_6 = 83;
pub const IS_CAST8: C2RustUnnamed_6 = 82;
pub const IS_CAST7: C2RustUnnamed_6 = 81;
pub const IS_CAST6: C2RustUnnamed_6 = 80;
pub const IS_CAST5: C2RustUnnamed_6 = 79;
pub const IS_CAST4: C2RustUnnamed_6 = 78;
pub const IS_CAST3: C2RustUnnamed_6 = 77;
pub const IS_CAST2: C2RustUnnamed_6 = 76;
pub const IS_CAST12: C2RustUnnamed_6 = 75;
pub const IS_CAST10: C2RustUnnamed_6 = 74;
pub const IS_CAST1: C2RustUnnamed_6 = 73;
pub const IS_TRAP: C2RustUnnamed_6 = 72;
pub const SFX_SILENCE: C2RustUnnamed_6 = 71;
pub const IS_TITLSLCT: C2RustUnnamed_6 = 70;
pub const IS_TITLEMOV: C2RustUnnamed_6 = 69;
pub const IS_SWRDFKD: C2RustUnnamed_6 = 68;
pub const IS_SHLDFKD: C2RustUnnamed_6 = 67;
pub const IS_SARC: C2RustUnnamed_6 = 66;
pub const IS_RBOOK: C2RustUnnamed_6 = 65;
pub const IS_MAGIC1: C2RustUnnamed_6 = 64;
pub const IS_MAGIC: C2RustUnnamed_6 = 63;
pub const IS_LEVER: C2RustUnnamed_6 = 62;
pub const IS_ISWORD: C2RustUnnamed_6 = 61;
pub const IS_ISTAF: C2RustUnnamed_6 = 60;
pub const IS_ISIGN: C2RustUnnamed_6 = 59;
pub const IS_ISHIEL: C2RustUnnamed_6 = 58;
pub const IS_ISCROL: C2RustUnnamed_6 = 57;
pub const IS_IROCK: C2RustUnnamed_6 = 56;
pub const IS_IRING: C2RustUnnamed_6 = 55;
pub const IS_IPOT: C2RustUnnamed_6 = 54;
pub const IS_IMUSH: C2RustUnnamed_6 = 53;
pub const IS_ILARM: C2RustUnnamed_6 = 52;
pub const IS_IHARM: C2RustUnnamed_6 = 51;
pub const IS_IGRAB: C2RustUnnamed_6 = 50;
pub const IS_ICAP: C2RustUnnamed_6 = 49;
pub const IS_IBOW: C2RustUnnamed_6 = 48;
pub const IS_IBOOK: C2RustUnnamed_6 = 47;
pub const IS_IBODY: C2RustUnnamed_6 = 46;
pub const IS_IBLST: C2RustUnnamed_6 = 45;
pub const IS_IAXE: C2RustUnnamed_6 = 44;
pub const IS_IANVL: C2RustUnnamed_6 = 43;
pub const IS_HLMTFKD: C2RustUnnamed_6 = 42;
pub const IS_GOLD: C2RustUnnamed_6 = 41;
pub const IS_FSWOR: C2RustUnnamed_6 = 40;
pub const IS_FSTAF: C2RustUnnamed_6 = 39;
pub const IS_FSIGN: C2RustUnnamed_6 = 38;
pub const IS_FSHLD: C2RustUnnamed_6 = 37;
pub const IS_FSCRL: C2RustUnnamed_6 = 36;
pub const IS_FROCK: C2RustUnnamed_6 = 35;
pub const IS_FRING: C2RustUnnamed_6 = 34;
pub const IS_FPOT: C2RustUnnamed_6 = 33;
pub const IS_FMUSH: C2RustUnnamed_6 = 32;
pub const IS_FMAG1: C2RustUnnamed_6 = 31;
pub const IS_FMAG: C2RustUnnamed_6 = 30;
pub const IS_FLARM: C2RustUnnamed_6 = 29;
pub const IS_FHARM: C2RustUnnamed_6 = 28;
pub const IS_FCAP: C2RustUnnamed_6 = 27;
pub const IS_FBOW: C2RustUnnamed_6 = 26;
pub const IS_FBOOK: C2RustUnnamed_6 = 25;
pub const IS_FBODY: C2RustUnnamed_6 = 24;
pub const IS_FBLST: C2RustUnnamed_6 = 23;
pub const IS_FAXE: C2RustUnnamed_6 = 22;
pub const IS_FANVL: C2RustUnnamed_6 = 21;
pub const IS_DOOROPEN: C2RustUnnamed_6 = 20;
pub const IS_DOORCLOS: C2RustUnnamed_6 = 19;
pub const IS_CHEST: C2RustUnnamed_6 = 18;
pub const IS_BHIT1: C2RustUnnamed_6 = 17;
pub const IS_BHIT: C2RustUnnamed_6 = 16;
pub const IS_BARREL: C2RustUnnamed_6 = 15;
pub const IS_BARLFIRE: C2RustUnnamed_6 = 14;
pub const IS_ARMRFKD: C2RustUnnamed_6 = 13;
pub const IS_QUESTDN: C2RustUnnamed_6 = 12;
pub const PS_DEAD: C2RustUnnamed_6 = 11;
pub const PS_SWING2: C2RustUnnamed_6 = 10;
pub const PS_SWING: C2RustUnnamed_6 = 9;
pub const PS_LGHIT1: C2RustUnnamed_6 = 8;
pub const PS_LGHIT: C2RustUnnamed_6 = 7;
pub const PS_TMAG: C2RustUnnamed_6 = 6;
pub const PS_FMAG: C2RustUnnamed_6 = 5;
pub const PS_BFIRE: C2RustUnnamed_6 = 4;
pub const PS_WALK4: C2RustUnnamed_6 = 3;
pub const PS_WALK3: C2RustUnnamed_6 = 2;
pub const PS_WALK2: C2RustUnnamed_6 = 1;
pub const PS_WALK1: C2RustUnnamed_6 = 0;
pub type C2RustUnnamed_7 = libc::c_uint;
pub const STORE_BARMAID: C2RustUnnamed_7 = 23;
pub const STORE_DRUNK: C2RustUnnamed_7 = 22;
pub const STORE_TAVERN: C2RustUnnamed_7 = 21;
pub const STORE_IDSHOW: C2RustUnnamed_7 = 20;
pub const STORE_TALK: C2RustUnnamed_7 = 19;
pub const STORE_SPBUY: C2RustUnnamed_7 = 18;
pub const STORE_STORYID: C2RustUnnamed_7 = 17;
pub const STORE_HBUY: C2RustUnnamed_7 = 16;
pub const STORE_STORYTLR: C2RustUnnamed_7 = 15;
pub const STORE_HEALER: C2RustUnnamed_7 = 14;
pub const STORE_BBUY: C2RustUnnamed_7 = 13;
pub const STORE_BOY: C2RustUnnamed_7 = 12;
pub const STORE_CONFIRM: C2RustUnnamed_7 = 11;
pub const STORE_NOROOM: C2RustUnnamed_7 = 10;
pub const STORE_NOMONEY: C2RustUnnamed_7 = 9;
pub const STORE_WRECHARGE: C2RustUnnamed_7 = 8;
pub const STORE_WSELL: C2RustUnnamed_7 = 7;
pub const STORE_WBUY: C2RustUnnamed_7 = 6;
pub const STORE_WITCH: C2RustUnnamed_7 = 5;
pub const STORE_SREPAIR: C2RustUnnamed_7 = 4;
pub const STORE_SSELL: C2RustUnnamed_7 = 3;
pub const STORE_SBUY: C2RustUnnamed_7 = 2;
pub const STORE_SMITH: C2RustUnnamed_7 = 1;
pub const STORE_NONE: C2RustUnnamed_7 = 0;
pub type C2RustUnnamed_8 = libc::c_uint;
pub const STEXT_LARGE: C2RustUnnamed_8 = 1;
pub const STEXT_SMALL: C2RustUnnamed_8 = 0;
pub type C2RustUnnamed_9 = libc::c_uint;
pub const TXT_INTRO: C2RustUnnamed_9 = 258;
pub const TXT_BOOK33: C2RustUnnamed_9 = 257;
pub const TXT_BOOK32: C2RustUnnamed_9 = 256;
pub const TXT_BOOK31: C2RustUnnamed_9 = 255;
pub const TXT_BOOK23: C2RustUnnamed_9 = 254;
pub const TXT_BOOK22: C2RustUnnamed_9 = 253;
pub const TXT_BOOK21: C2RustUnnamed_9 = 252;
pub const TXT_BOOK13: C2RustUnnamed_9 = 251;
pub const TXT_BOOK12: C2RustUnnamed_9 = 250;
pub const TXT_BOOK11: C2RustUnnamed_9 = 249;
pub const TXT_COW2: C2RustUnnamed_9 = 248;
pub const TXT_COW1: C2RustUnnamed_9 = 247;
pub const TXT_ROGLORD: C2RustUnnamed_9 = 246;
pub const TXT_ROGBLIND: C2RustUnnamed_9 = 245;
pub const TXT_ROGBLOOD: C2RustUnnamed_9 = 244;
pub const TXT_ROGBONE: C2RustUnnamed_9 = 243;
pub const TXT_SORLORD: C2RustUnnamed_9 = 242;
pub const TXT_SORBLIND: C2RustUnnamed_9 = 241;
pub const TXT_SORBLOOD: C2RustUnnamed_9 = 240;
pub const TXT_SORBONE: C2RustUnnamed_9 = 239;
pub const TXT_WARLORD: C2RustUnnamed_9 = 238;
pub const TXT_WARBLIND: C2RustUnnamed_9 = 237;
pub const TXT_WARBLOOD: C2RustUnnamed_9 = 236;
pub const TXT_WARBONE: C2RustUnnamed_9 = 235;
pub const TXT_WIRT12: C2RustUnnamed_9 = 234;
pub const TXT_WIRT11: C2RustUnnamed_9 = 233;
pub const TXT_WIRT9: C2RustUnnamed_9 = 232;
pub const TXT_WIRT8: C2RustUnnamed_9 = 231;
pub const TXT_WIRT7: C2RustUnnamed_9 = 230;
pub const TXT_WIRT6: C2RustUnnamed_9 = 229;
pub const TXT_WIRT5: C2RustUnnamed_9 = 228;
pub const TXT_WIRT4: C2RustUnnamed_9 = 227;
pub const TXT_WIRT3: C2RustUnnamed_9 = 226;
pub const TXT_WIRT2: C2RustUnnamed_9 = 225;
pub const TXT_WIRT1: C2RustUnnamed_9 = 224;
pub const TXT_ADRIA13: C2RustUnnamed_9 = 223;
pub const TXT_ADRIA12: C2RustUnnamed_9 = 222;
pub const TXT_ADRIA10: C2RustUnnamed_9 = 221;
pub const TXT_ADRIA9: C2RustUnnamed_9 = 220;
pub const TXT_ADRIA8: C2RustUnnamed_9 = 219;
pub const TXT_ADRIA7: C2RustUnnamed_9 = 218;
pub const TXT_ADRIA6: C2RustUnnamed_9 = 217;
pub const TXT_ADRIA5: C2RustUnnamed_9 = 216;
pub const TXT_ADRIA4: C2RustUnnamed_9 = 215;
pub const TXT_ADRIA3: C2RustUnnamed_9 = 214;
pub const TXT_ADRIA2: C2RustUnnamed_9 = 213;
pub const TXT_ADRIA1: C2RustUnnamed_9 = 212;
pub const TXT_FARN13: C2RustUnnamed_9 = 211;
pub const TXT_FARN12: C2RustUnnamed_9 = 210;
pub const TXT_FARN11: C2RustUnnamed_9 = 209;
pub const TXT_FARN10: C2RustUnnamed_9 = 208;
pub const TXT_FARN9: C2RustUnnamed_9 = 207;
pub const TXT_FARN8: C2RustUnnamed_9 = 206;
pub const TXT_FARN6: C2RustUnnamed_9 = 205;
pub const TXT_FARN5: C2RustUnnamed_9 = 204;
pub const TXT_FARN4: C2RustUnnamed_9 = 203;
pub const TXT_FARN3: C2RustUnnamed_9 = 202;
pub const TXT_FARN2: C2RustUnnamed_9 = 201;
pub const TXT_FARN1: C2RustUnnamed_9 = 200;
pub const TXT_GRIS13: C2RustUnnamed_9 = 199;
pub const TXT_GRIS12: C2RustUnnamed_9 = 198;
pub const TXT_GRIS10: C2RustUnnamed_9 = 197;
pub const TXT_GRIS9: C2RustUnnamed_9 = 196;
pub const TXT_GRIS8: C2RustUnnamed_9 = 195;
pub const TXT_GRIS7: C2RustUnnamed_9 = 194;
pub const TXT_GRIS6: C2RustUnnamed_9 = 193;
pub const TXT_GRIS5: C2RustUnnamed_9 = 192;
pub const TXT_GRIS4: C2RustUnnamed_9 = 191;
pub const TXT_GRIS3: C2RustUnnamed_9 = 190;
pub const TXT_GRIS2: C2RustUnnamed_9 = 189;
pub const TXT_GRIS1: C2RustUnnamed_9 = 188;
pub const TXT_GILIAN10: C2RustUnnamed_9 = 187;
pub const TXT_GILIAN9: C2RustUnnamed_9 = 186;
pub const TXT_GILIAN7: C2RustUnnamed_9 = 185;
pub const TXT_GILIAN6: C2RustUnnamed_9 = 184;
pub const TXT_GILIAN5: C2RustUnnamed_9 = 183;
pub const TXT_GILIAN4: C2RustUnnamed_9 = 182;
pub const TXT_GILIAN3: C2RustUnnamed_9 = 181;
pub const TXT_GILIAN2: C2RustUnnamed_9 = 180;
pub const TXT_GILIAN1: C2RustUnnamed_9 = 179;
pub const TXT_PEPIN11: C2RustUnnamed_9 = 178;
pub const TXT_PEPIN10: C2RustUnnamed_9 = 177;
pub const TXT_PEPIN9: C2RustUnnamed_9 = 176;
pub const TXT_PEPIN7: C2RustUnnamed_9 = 175;
pub const TXT_PEPIN6: C2RustUnnamed_9 = 174;
pub const TXT_PEPIN5: C2RustUnnamed_9 = 173;
pub const TXT_PEPIN4: C2RustUnnamed_9 = 172;
pub const TXT_PEPIN3: C2RustUnnamed_9 = 171;
pub const TXT_PEPIN2: C2RustUnnamed_9 = 170;
pub const TXT_PEPIN1: C2RustUnnamed_9 = 169;
pub const TXT_OGDEN10: C2RustUnnamed_9 = 168;
pub const TXT_OGDEN9: C2RustUnnamed_9 = 167;
pub const TXT_OGDEN8: C2RustUnnamed_9 = 166;
pub const TXT_OGDEN6: C2RustUnnamed_9 = 165;
pub const TXT_OGDEN5: C2RustUnnamed_9 = 164;
pub const TXT_OGDEN4: C2RustUnnamed_9 = 163;
pub const TXT_OGDEN3: C2RustUnnamed_9 = 162;
pub const TXT_OGDEN2: C2RustUnnamed_9 = 161;
pub const TXT_OGDEN1: C2RustUnnamed_9 = 160;
pub const TXT_STORY11: C2RustUnnamed_9 = 159;
pub const TXT_STORY10: C2RustUnnamed_9 = 158;
pub const TXT_STORY9: C2RustUnnamed_9 = 157;
pub const TXT_STORY7: C2RustUnnamed_9 = 156;
pub const TXT_STORY6: C2RustUnnamed_9 = 155;
pub const TXT_STORY5: C2RustUnnamed_9 = 154;
pub const TXT_STORY4: C2RustUnnamed_9 = 153;
pub const TXT_STORY3: C2RustUnnamed_9 = 152;
pub const TXT_STORY2: C2RustUnnamed_9 = 151;
pub const TXT_STORY1: C2RustUnnamed_9 = 150;
pub const TXT_ZHAR2: C2RustUnnamed_9 = 149;
pub const TXT_ZHAR1: C2RustUnnamed_9 = 148;
pub const TXT_GARB4: C2RustUnnamed_9 = 147;
pub const TXT_GARB3: C2RustUnnamed_9 = 146;
pub const TXT_GARB2: C2RustUnnamed_9 = 145;
pub const TXT_GARB1: C2RustUnnamed_9 = 144;
pub const TXT_MODPB1: C2RustUnnamed_9 = 143;
pub const TXT_MODW1: C2RustUnnamed_9 = 142;
pub const TXT_MODTD1: C2RustUnnamed_9 = 141;
pub const TXT_MODBS1: C2RustUnnamed_9 = 140;
pub const TXT_MODBM1: C2RustUnnamed_9 = 139;
pub const TXT_MODH1: C2RustUnnamed_9 = 138;
pub const TXT_MODTO1: C2RustUnnamed_9 = 137;
pub const TXT_MODST3: C2RustUnnamed_9 = 136;
pub const TXT_MODST2: C2RustUnnamed_9 = 135;
pub const TXT_MODST1: C2RustUnnamed_9 = 134;
pub const TXT_BLKMPB1: C2RustUnnamed_9 = 133;
pub const TXT_BLKMW5: C2RustUnnamed_9 = 132;
pub const TXT_BLKMW4: C2RustUnnamed_9 = 131;
pub const TXT_BLKMW3: C2RustUnnamed_9 = 130;
pub const TXT_BLKMW2: C2RustUnnamed_9 = 129;
pub const TXT_BLKMW1: C2RustUnnamed_9 = 128;
pub const TXT_BLKMTD1: C2RustUnnamed_9 = 127;
pub const TXT_BLKMBS1: C2RustUnnamed_9 = 126;
pub const TXT_BLKMBM1: C2RustUnnamed_9 = 125;
pub const TXT_BLKMH2: C2RustUnnamed_9 = 124;
pub const TXT_BLKMH1: C2RustUnnamed_9 = 123;
pub const TXT_BLKMTO1: C2RustUnnamed_9 = 122;
pub const TXT_BLKMST1: C2RustUnnamed_9 = 121;
pub const TXT_INFRAPB1: C2RustUnnamed_9 = 120;
pub const TXT_INFRAW1: C2RustUnnamed_9 = 119;
pub const TXT_INFRATD1: C2RustUnnamed_9 = 118;
pub const TXT_INFRABS3: C2RustUnnamed_9 = 117;
pub const TXT_INFRABS2: C2RustUnnamed_9 = 116;
pub const TXT_INFRABS1: C2RustUnnamed_9 = 115;
pub const TXT_INFRABM1: C2RustUnnamed_9 = 114;
pub const TXT_INFRAH1: C2RustUnnamed_9 = 113;
pub const TXT_INFRATO1: C2RustUnnamed_9 = 112;
pub const TXT_INFRAST1: C2RustUnnamed_9 = 111;
pub const TXT_WARLRD1: C2RustUnnamed_9 = 110;
pub const TXT_WARLRDPB1: C2RustUnnamed_9 = 109;
pub const TXT_WARLRDW1: C2RustUnnamed_9 = 108;
pub const TXT_WARLRDTD1: C2RustUnnamed_9 = 107;
pub const TXT_WARLRDBS1: C2RustUnnamed_9 = 106;
pub const TXT_WARLRDBM1: C2RustUnnamed_9 = 105;
pub const TXT_WARLRDH1: C2RustUnnamed_9 = 104;
pub const TXT_WARLRDTO1: C2RustUnnamed_9 = 103;
pub const TXT_WARLRDST1: C2RustUnnamed_9 = 102;
pub const TXT_BLOODPB1: C2RustUnnamed_9 = 101;
pub const TXT_BLOODW1: C2RustUnnamed_9 = 100;
pub const TXT_BLOODTD1: C2RustUnnamed_9 = 99;
pub const TXT_BLOODBS1: C2RustUnnamed_9 = 98;
pub const TXT_BLOODBM1: C2RustUnnamed_9 = 97;
pub const TXT_BLOODH1: C2RustUnnamed_9 = 96;
pub const TXT_BLOODTO1: C2RustUnnamed_9 = 95;
pub const TXT_BLOODST1: C2RustUnnamed_9 = 94;
pub const TXT_ANVILPB1: C2RustUnnamed_9 = 93;
pub const TXT_ANVILW1: C2RustUnnamed_9 = 92;
pub const TXT_ANVILTD1: C2RustUnnamed_9 = 91;
pub const TXT_ANVILBS3: C2RustUnnamed_9 = 90;
pub const TXT_ANVILBS2: C2RustUnnamed_9 = 89;
pub const TXT_ANVILBS1: C2RustUnnamed_9 = 88;
pub const TXT_ANVILBM1: C2RustUnnamed_9 = 87;
pub const TXT_ANVILH1: C2RustUnnamed_9 = 86;
pub const TXT_ANVILTO1: C2RustUnnamed_9 = 85;
pub const TXT_ANVILST1: C2RustUnnamed_9 = 84;
pub const TXT_VEIL3: C2RustUnnamed_9 = 83;
pub const TXT_VEIL2: C2RustUnnamed_9 = 82;
pub const TXT_VEIL1: C2RustUnnamed_9 = 81;
pub const TXT_VEILPB1: C2RustUnnamed_9 = 80;
pub const TXT_VEILW1: C2RustUnnamed_9 = 79;
pub const TXT_VEILTD1: C2RustUnnamed_9 = 78;
pub const TXT_VEILBS1: C2RustUnnamed_9 = 77;
pub const TXT_VEILBM1: C2RustUnnamed_9 = 76;
pub const TXT_VEILH1: C2RustUnnamed_9 = 75;
pub const TXT_VEILTO1: C2RustUnnamed_9 = 74;
pub const TXT_VEILST1: C2RustUnnamed_9 = 73;
pub const TXT_BLINDPB1: C2RustUnnamed_9 = 72;
pub const TXT_BLINDW1: C2RustUnnamed_9 = 71;
pub const TXT_BLINDTD1: C2RustUnnamed_9 = 70;
pub const TXT_BLINDBS1: C2RustUnnamed_9 = 69;
pub const TXT_BLINDBM1: C2RustUnnamed_9 = 68;
pub const TXT_BLINDH1: C2RustUnnamed_9 = 67;
pub const TXT_BLINDTO1: C2RustUnnamed_9 = 66;
pub const TXT_BLINDST1: C2RustUnnamed_9 = 65;
pub const TXT_BUTCH2: C2RustUnnamed_9 = 64;
pub const TXT_BUTCH1: C2RustUnnamed_9 = 63;
pub const TXT_BUTCHPB1: C2RustUnnamed_9 = 62;
pub const TXT_BUTCHW1: C2RustUnnamed_9 = 61;
pub const TXT_BUTCHTD1: C2RustUnnamed_9 = 60;
pub const TXT_BUTCHBS1: C2RustUnnamed_9 = 59;
pub const TXT_BUTCHBM1: C2RustUnnamed_9 = 58;
pub const TXT_BUTCHH1: C2RustUnnamed_9 = 57;
pub const TXT_BUTCHTO1: C2RustUnnamed_9 = 56;
pub const TXT_BUTCHST1: C2RustUnnamed_9 = 55;
pub const TXT_BONEPB1: C2RustUnnamed_9 = 54;
pub const TXT_BONEW1: C2RustUnnamed_9 = 53;
pub const TXT_BONETD1: C2RustUnnamed_9 = 52;
pub const TXT_BONEBS1: C2RustUnnamed_9 = 51;
pub const TXT_BONEBM1: C2RustUnnamed_9 = 50;
pub const TXT_BONEH1: C2RustUnnamed_9 = 49;
pub const TXT_BONETO1: C2RustUnnamed_9 = 48;
pub const TXT_BONEST1: C2RustUnnamed_9 = 47;
pub const TXT_PWPB1: C2RustUnnamed_9 = 46;
pub const TXT_PWW1: C2RustUnnamed_9 = 45;
pub const TXT_PWTD1: C2RustUnnamed_9 = 44;
pub const TXT_PWBS1: C2RustUnnamed_9 = 43;
pub const TXT_PWBM1: C2RustUnnamed_9 = 42;
pub const TXT_PWH3: C2RustUnnamed_9 = 41;
pub const TXT_PWH2: C2RustUnnamed_9 = 40;
pub const TXT_PWH1: C2RustUnnamed_9 = 39;
pub const TXT_PWTO1: C2RustUnnamed_9 = 38;
pub const TXT_PWST1: C2RustUnnamed_9 = 37;
pub const TXT_VB2: C2RustUnnamed_9 = 36;
pub const TXT_VB1: C2RustUnnamed_9 = 35;
pub const TXT_VBPB1: C2RustUnnamed_9 = 34;
pub const TXT_VBW1: C2RustUnnamed_9 = 33;
pub const TXT_VBTD1: C2RustUnnamed_9 = 32;
pub const TXT_VBBS1: C2RustUnnamed_9 = 31;
pub const TXT_VBBM1: C2RustUnnamed_9 = 30;
pub const TXT_VBH1: C2RustUnnamed_9 = 29;
pub const TXT_VBP4: C2RustUnnamed_9 = 28;
pub const TXT_VBP3: C2RustUnnamed_9 = 27;
pub const TXT_VBTO1: C2RustUnnamed_9 = 26;
pub const TXT_VBST3: C2RustUnnamed_9 = 25;
pub const TXT_VBST2: C2RustUnnamed_9 = 24;
pub const TXT_VBST1: C2RustUnnamed_9 = 23;
pub const TXT_BOL3: C2RustUnnamed_9 = 22;
pub const TXT_BOL2: C2RustUnnamed_9 = 21;
pub const TXT_BOL1: C2RustUnnamed_9 = 20;
pub const TXT_BOLPB1: C2RustUnnamed_9 = 19;
pub const TXT_BOLW1: C2RustUnnamed_9 = 18;
pub const TXT_BOLTD1: C2RustUnnamed_9 = 17;
pub const TXT_BOLBS1: C2RustUnnamed_9 = 16;
pub const TXT_BOLBM1: C2RustUnnamed_9 = 15;
pub const TXT_BOLH1: C2RustUnnamed_9 = 14;
pub const TXT_BOLTO2: C2RustUnnamed_9 = 13;
pub const TXT_BOLTO1: C2RustUnnamed_9 = 12;
pub const TXT_BOLST1: C2RustUnnamed_9 = 11;
pub const TXT_KING1: C2RustUnnamed_9 = 10;
pub const TXT_KINGPB1: C2RustUnnamed_9 = 9;
pub const TXT_KINGW1: C2RustUnnamed_9 = 8;
pub const TXT_KINGTD1: C2RustUnnamed_9 = 7;
pub const TXT_KINGBS1: C2RustUnnamed_9 = 6;
pub const TXT_KINGBM1: C2RustUnnamed_9 = 5;
pub const TXT_KINGH1: C2RustUnnamed_9 = 4;
pub const TXT_KINGTO3: C2RustUnnamed_9 = 3;
pub const TXT_KINGTO2: C2RustUnnamed_9 = 2;
pub const TXT_KINGTO1: C2RustUnnamed_9 = 1;
pub const TXT_KINGST1: C2RustUnnamed_9 = 0;
pub type C2RustUnnamed_10 = libc::c_uint;
pub const TWN_COW: C2RustUnnamed_10 = 9;
pub const TWN_BOY: C2RustUnnamed_10 = 8;
pub const TWN_BARMAID: C2RustUnnamed_10 = 7;
pub const TWN_WITCH: C2RustUnnamed_10 = 6;
pub const TWN_DRUNK: C2RustUnnamed_10 = 5;
pub const TWN_TELLER: C2RustUnnamed_10 = 4;
pub const TWN_BAROWNER: C2RustUnnamed_10 = 3;
pub const TWN_DEAD: C2RustUnnamed_10 = 2;
pub const TWN_HEALER: C2RustUnnamed_10 = 1;
pub const TWN_BLKSMITH: C2RustUnnamed_10 = 0;
pub type bool32_t = uint32_t;
pub type Uint32 = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemDataStruct {
    pub iRnd: bool32_t,
    pub iClass: int8_t,
    pub iLoc: int8_t,
    pub iCurs: libc::c_int,
    pub itype: int8_t,
    pub iItemId: int8_t,
    pub iName: *const libc::c_char,
    pub iSName: *const libc::c_char,
    pub iMinMLvl: int8_t,
    pub iDurability: libc::c_int,
    pub iMinDam: libc::c_int,
    pub iMaxDam: libc::c_int,
    pub iMinAC: libc::c_int,
    pub iMaxAC: libc::c_int,
    pub iMinStr: int8_t,
    pub iMinMag: int8_t,
    pub iMinDex: int8_t,
    pub iFlags: int32_t,
    pub iMiscId: libc::c_int,
    pub iSpell: int32_t,
    pub iUsable: bool32_t,
    pub iValue: libc::c_int,
    pub iMaxValue: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct STextStruct {
    pub _sx: libc::c_int,
    pub _syoff: libc::c_int,
    pub _sstr: [libc::c_char; 128],
    pub _sjust: bool32_t,
    pub _sclr: int8_t,
    pub _sline: bool32_t,
    pub _ssel: bool32_t,
    pub _sval: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
pub const NUMLEVELS: C2RustUnnamed_16 = 17;
pub const IMAGIC_UNIQUE: C2RustUnnamed_14 = 2;
pub const IT_MISC: C2RustUnnamed_15 = 0;
pub const IC_ARMOR: C2RustUnnamed_11 = 2;
pub const IC_WEAP: C2RustUnnamed_11 = 1;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct QuestData {
    pub _qdlvl: uint8_t,
    pub _qdmultlvl: int8_t,
    pub _qlvlt: uint8_t,
    pub _qdtype: uint8_t,
    pub _qdrnd: uint8_t,
    pub _qslvl: uint8_t,
    pub _qflags: bool32_t,
    pub _qdmsg: libc::c_int,
    pub _qlstr: *const libc::c_char,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct QuestStruct {
    pub _qlevel: uint8_t,
    pub _qtype: uint8_t,
    pub _qactive: uint8_t,
    pub _qlvltype: uint8_t,
    pub _qtx: libc::c_int,
    pub _qty: libc::c_int,
    pub _qslvl: uint8_t,
    pub _qidx: uint8_t,
    pub _qmsg: uint8_t,
    pub _qvar1: uint8_t,
    pub _qvar2: uint8_t,
    pub align_0011: [uint8_t; 3],
    pub _qlog: bool32_t,
}
pub const MAXQUESTS: C2RustUnnamed_19 = 16;
pub const IMAGIC_NONE: C2RustUnnamed_14 = 0;
pub const INVLOC_NECK: C2RustUnnamed_17 = 3;
pub const INVLOC_RING2: C2RustUnnamed_17 = 2;
pub const INVLOC_RING1: C2RustUnnamed_17 = 1;
pub const INVLOC_HAND2: C2RustUnnamed_17 = 5;
pub const INVLOC_HAND1: C2RustUnnamed_17 = 4;
pub const INVLOC_BODY: C2RustUnnamed_17 = 6;
pub const INVLOC_HEAD: C2RustUnnamed_17 = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SpellData {
    pub sName: uint8_t,
    pub sManaCost: uint8_t,
    pub sType: uint8_t,
    pub sNameText: *const libc::c_char,
    pub sSkillText: *const libc::c_char,
    pub sBookLvl: libc::c_int,
    pub sStaffLvl: libc::c_int,
    pub sTargeted: bool32_t,
    pub sTownSpell: bool32_t,
    pub sMinInt: libc::c_int,
    pub sSFX: uint8_t,
    pub sMissiles: [uint8_t; 3],
    pub sManaAdj: uint8_t,
    pub sMinMana: uint8_t,
    pub sStaffMin: libc::c_int,
    pub sStaffMax: libc::c_int,
    pub sBookCost: libc::c_int,
    pub sStaffCost: libc::c_int,
}
pub const IT_STAFF: C2RustUnnamed_15 = 10;
pub const IDI_LAZSTAFF: C2RustUnnamed_13 = 33;
pub const IDI_LASTQUEST: C2RustUnnamed_13 = 22;
pub const IDI_FIRSTQUEST: C2RustUnnamed_13 = 6;
pub const MAXSPD: C2RustUnnamed_18 = 8;
pub const IT_FOOD: C2RustUnnamed_15 = 14;
pub const IT_GOLD: C2RustUnnamed_15 = 11;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TownerStruct {
    pub _tmode: libc::c_int,
    pub _ttype: libc::c_int,
    pub _tx: libc::c_int,
    pub _ty: libc::c_int,
    pub _txoff: int32_t,
    pub _tyoff: int32_t,
    pub _txvel: int32_t,
    pub _tyvel: int32_t,
    pub _tdir: libc::c_int,
    pub _tAnimData: *mut uint8_t,
    pub _tAnimDelay: libc::c_int,
    pub _tAnimCnt: libc::c_int,
    pub _tAnimLen: libc::c_int,
    pub _tAnimFrame: libc::c_int,
    pub _tAnimFrameCnt: libc::c_int,
    pub _tAnimOrder: int8_t,
    pub _tAnimWidth: int32_t,
    pub _tAnimWidth2: int32_t,
    pub _tTenPer: libc::c_int,
    pub _teflag: libc::c_int,
    pub _tbtcnt: libc::c_int,
    pub _tSelFlag: bool32_t,
    pub _tMsgSaid: bool32_t,
    pub qsts: [TNQ; 16],
    pub _tSeed: libc::c_int,
    pub _tVar1: int32_t,
    pub _tVar2: int32_t,
    pub _tVar3: int32_t,
    pub _tVar4: int32_t,
    pub _tName: [libc::c_char; 32],
    pub _tNAnim: [*mut uint8_t; 8],
    pub _tNFrames: libc::c_int,
    pub _tNData: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TNQ {
    pub _qsttype: uint8_t,
    pub _qstmsg: uint8_t,
    pub _qstmsgact: uint8_t,
}
pub const MAXINV: C2RustUnnamed_18 = 40;
pub const ITEM_3GOLD: C2RustUnnamed_12 = 5;
pub const ITEM_1GOLD: C2RustUnnamed_12 = 4;
pub const ITEM_5GOLD: C2RustUnnamed_12 = 6;
pub type C2RustUnnamed_11 = libc::c_uint;
pub const IC_SPECIAL: C2RustUnnamed_11 = 5;
pub const IC_GOLD: C2RustUnnamed_11 = 4;
pub const IC_ITEM: C2RustUnnamed_11 = 3;
pub type C2RustUnnamed_12 = libc::c_uint;
pub const ITEM_GOLD: C2RustUnnamed_12 = 168;
pub const ITEM_SBATLBOW: C2RustUnnamed_12 = 167;
pub const ITEM_COMPSTF: C2RustUnnamed_12 = 166;
pub const ITEM_SWARBOW: C2RustUnnamed_12 = 165;
pub const ITEM_WINDFOR: C2RustUnnamed_12 = 164;
pub const ITEM_REAVER: C2RustUnnamed_12 = 163;
pub const ITEM_PROTECT: C2RustUnnamed_12 = 162;
pub const ITEM_GRANDPA: C2RustUnnamed_12 = 161;
pub const ITEM_GRIZZLY: C2RustUnnamed_12 = 160;
pub const ITEM_NAJARMOR: C2RustUnnamed_12 = 159;
pub const ITEM_CROSBOW: C2RustUnnamed_12 = 158;
pub const ITEM_ARKARMOR: C2RustUnnamed_12 = 157;
pub const ITEM_GEMGRTAXE: C2RustUnnamed_12 = 156;
pub const ITEM_BISHOPSTF: C2RustUnnamed_12 = 155;
pub const ITEM_RINGMAIL: C2RustUnnamed_12 = 154;
pub const ITEM_BPLATE: C2RustUnnamed_12 = 153;
pub const ITEM_PARMOR3: C2RustUnnamed_12 = 152;
pub const ITEM_PARMOR2: C2RustUnnamed_12 = 151;
pub const ITEM_CAPE: C2RustUnnamed_12 = 150;
pub const ITEM_CLOAK: C2RustUnnamed_12 = 149;
pub const ITEM_LRGSHLD: C2RustUnnamed_12 = 148;
pub const ITEM_KITESHLD: C2RustUnnamed_12 = 147;
pub const ITEM_IRONSHLD: C2RustUnnamed_12 = 146;
pub const ITEM_GREATAXE: C2RustUnnamed_12 = 145;
pub const ITEM_HANDAXE: C2RustUnnamed_12 = 144;
pub const ITEM_WICKAXE: C2RustUnnamed_12 = 143;
pub const ITEM_LRGAXE: C2RustUnnamed_12 = 142;
pub const ITEM_BROADAXE: C2RustUnnamed_12 = 141;
pub const ITEM_ANVIL: C2RustUnnamed_12 = 140;
pub const ITEM_RINGARMOR: C2RustUnnamed_12 = 139;
pub const ITEM_HVYROBE: C2RustUnnamed_12 = 138;
pub const ITEM_ROBE: C2RustUnnamed_12 = 137;
pub const ITEM_SPLTARMOR: C2RustUnnamed_12 = 136;
pub const ITEM_LARMOR: C2RustUnnamed_12 = 135;
pub const ITEM_GRTSWORD: C2RustUnnamed_12 = 134;
pub const ITEM_HNTRBOW: C2RustUnnamed_12 = 133;
pub const ITEM_TSHIELD: C2RustUnnamed_12 = 132;
pub const ITEM_FLAIL: C2RustUnnamed_12 = 131;
pub const ITEM_BALLNCHN: C2RustUnnamed_12 = 130;
pub const ITEM_QARMOR: C2RustUnnamed_12 = 129;
pub const ITEM_RAGS: C2RustUnnamed_12 = 128;
pub const ITEM_HLARMOR: C2RustUnnamed_12 = 127;
pub const ITEM_INNSIGN: C2RustUnnamed_12 = 126;
pub const ITEM_LONGSTAFF: C2RustUnnamed_12 = 125;
pub const ITEM_STLSTAFF: C2RustUnnamed_12 = 124;
pub const ITEM_IRONSTAFF: C2RustUnnamed_12 = 123;
pub const ITEM_MAUL: C2RustUnnamed_12 = 122;
pub const ITEM_SMLWARHAM: C2RustUnnamed_12 = 121;
pub const ITEM_STLSHRTBOW: C2RustUnnamed_12 = 120;
pub const ITEM_STLLONGBOW: C2RustUnnamed_12 = 119;
pub const ITEM_SHORTBOW: C2RustUnnamed_12 = 118;
pub const ITEM_WOLFSHLD: C2RustUnnamed_12 = 117;
pub const ITEM_SKULLSHLD: C2RustUnnamed_12 = 116;
pub const ITEM_SMLSHLD: C2RustUnnamed_12 = 115;
pub const ITEM_SCLARMOR: C2RustUnnamed_12 = 114;
pub const ITEM_HVYSHIELD: C2RustUnnamed_12 = 113;
pub const ITEM_SMALLAXE: C2RustUnnamed_12 = 112;
pub const ITEM_CHARMOR: C2RustUnnamed_12 = 111;
pub const ITEM_2HSWORD: C2RustUnnamed_12 = 110;
pub const ITEM_SHRTSTAFF: C2RustUnnamed_12 = 109;
pub const ITEM_COMPBOW: C2RustUnnamed_12 = 108;
pub const ITEM_STDARMOR: C2RustUnnamed_12 = 107;
pub const ITEM_CLEAVER: C2RustUnnamed_12 = 106;
pub const ITEM_WSHIELD: C2RustUnnamed_12 = 105;
pub const ITEM_AXE: C2RustUnnamed_12 = 104;
pub const ITEM_PARMOR: C2RustUnnamed_12 = 103;
pub const ITEM_LONGBOW: C2RustUnnamed_12 = 102;
pub const ITEM_BTLAXE: C2RustUnnamed_12 = 101;
pub const ITEM_COMPSHLD: C2RustUnnamed_12 = 100;
pub const ITEM_SAMHELM: C2RustUnnamed_12 = 99;
pub const ITEM_FHELM3: C2RustUnnamed_12 = 98;
pub const ITEM_BOOK4: C2RustUnnamed_12 = 97;
pub const ITEM_MAP: C2RustUnnamed_12 = 96;
pub const ITEM_CROWN2: C2RustUnnamed_12 = 95;
pub const ITEM_CLOTHES: C2RustUnnamed_12 = 94;
pub const ITEM_SKLCAP2: C2RustUnnamed_12 = 93;
pub const ITEM_FLESH: C2RustUnnamed_12 = 92;
pub const ITEM_LCAP: C2RustUnnamed_12 = 91;
pub const ITEM_SKLCAP: C2RustUnnamed_12 = 90;
pub const ITEM_MUSHROOM: C2RustUnnamed_12 = 89;
pub const ITEM_BOOK: C2RustUnnamed_12 = 88;
pub const ITEM_BOOK3: C2RustUnnamed_12 = 87;
pub const ITEM_BOOK2: C2RustUnnamed_12 = 86;
pub const ITEM_GRTHELM: C2RustUnnamed_12 = 85;
pub const ITEM_FHELM2: C2RustUnnamed_12 = 84;
pub const ITEM_BUCKLER: C2RustUnnamed_12 = 83;
pub const ITEM_FHELM: C2RustUnnamed_12 = 82;
pub const ITEM_HARLEQ: C2RustUnnamed_12 = 81;
pub const ITEM_JESTER: C2RustUnnamed_12 = 80;
pub const ITEM_MCROWN: C2RustUnnamed_12 = 79;
pub const ITEM_SKCROWN: C2RustUnnamed_12 = 78;
pub const ITEM_CROWN: C2RustUnnamed_12 = 77;
pub const ITEM_ROCK: C2RustUnnamed_12 = 76;
pub const ITEM_HELM: C2RustUnnamed_12 = 75;
pub const ITEM_SKULSWORD: C2RustUnnamed_12 = 74;
pub const ITEM_MAGSWORD: C2RustUnnamed_12 = 73;
pub const ITEM_SCIMITAR2: C2RustUnnamed_12 = 72;
pub const ITEM_CLUB3: C2RustUnnamed_12 = 71;
pub const ITEM_CLUB2: C2RustUnnamed_12 = 70;
pub const ITEM_CLUB1: C2RustUnnamed_12 = 69;
pub const ITEM_KNTSWORD: C2RustUnnamed_12 = 68;
pub const ITEM_SABRE: C2RustUnnamed_12 = 67;
pub const ITEM_CLUB: C2RustUnnamed_12 = 66;
pub const ITEM_CLAYMORE: C2RustUnnamed_12 = 65;
pub const ITEM_SHORTSRD: C2RustUnnamed_12 = 64;
pub const ITEM_MORNSTAR: C2RustUnnamed_12 = 63;
pub const ITEM_SCIMITAR: C2RustUnnamed_12 = 62;
pub const ITEM_BROADSRD: C2RustUnnamed_12 = 61;
pub const ITEM_LONGSRD: C2RustUnnamed_12 = 60;
pub const ITEM_MACE: C2RustUnnamed_12 = 59;
pub const ITEM_FALCHION: C2RustUnnamed_12 = 58;
pub const ITEM_BASTSRD: C2RustUnnamed_12 = 57;
pub const ITEM_BLADE: C2RustUnnamed_12 = 56;
pub const ITEM_DAGGER5: C2RustUnnamed_12 = 55;
pub const ITEM_DAGGER4: C2RustUnnamed_12 = 54;
pub const ITEM_DAGGER3: C2RustUnnamed_12 = 53;
pub const ITEM_BIGBOTTLE: C2RustUnnamed_12 = 52;
pub const ITEM_DAGGER2: C2RustUnnamed_12 = 51;
pub const ITEM_DAGGER1: C2RustUnnamed_12 = 50;
pub const ITEM_POUCH1: C2RustUnnamed_12 = 49;
pub const ITEM_AMULET4: C2RustUnnamed_12 = 48;
pub const ITEM_AMULET3: C2RustUnnamed_12 = 47;
pub const ITEM_AMULET2: C2RustUnnamed_12 = 46;
pub const ITEM_AMULET1: C2RustUnnamed_12 = 45;
pub const ITEM_AMULET: C2RustUnnamed_12 = 44;
pub const ITEM_BREAD: C2RustUnnamed_12 = 43;
pub const ITEM_FANG: C2RustUnnamed_12 = 42;
pub const ITEM_CLAW: C2RustUnnamed_12 = 41;
pub const ITEM_BRAIN: C2RustUnnamed_12 = 40;
pub const ITEM_BLUEBTL2: C2RustUnnamed_12 = 39;
pub const ITEM_LTBLUEBTL: C2RustUnnamed_12 = 38;
pub const ITEM_GOLDBTL: C2RustUnnamed_12 = 37;
pub const ITEM_BLKBTL2: C2RustUnnamed_12 = 36;
pub const ITEM_BREDBTL: C2RustUnnamed_12 = 35;
pub const ITEM_ORGBTL: C2RustUnnamed_12 = 34;
pub const ITEM_YELBTL: C2RustUnnamed_12 = 33;
pub const ITEM_REDBTL: C2RustUnnamed_12 = 32;
pub const ITEM_WHTEBTL: C2RustUnnamed_12 = 31;
pub const ITEM_BLKBTL: C2RustUnnamed_12 = 30;
pub const ITEM_VILE: C2RustUnnamed_12 = 29;
pub const ITEM_JPYRIMID: C2RustUnnamed_12 = 28;
pub const ITEM_JCUBE: C2RustUnnamed_12 = 27;
pub const ITEM_JSPHERE: C2RustUnnamed_12 = 26;
pub const ITEM_BLOODGEM: C2RustUnnamed_12 = 25;
pub const ITEM_PYRIMID: C2RustUnnamed_12 = 24;
pub const ITEM_CUBE: C2RustUnnamed_12 = 23;
pub const ITEM_SPHERE: C2RustUnnamed_12 = 22;
pub const ITEM_EAR3: C2RustUnnamed_12 = 21;
pub const ITEM_EAR2: C2RustUnnamed_12 = 20;
pub const ITEM_EAR1: C2RustUnnamed_12 = 19;
pub const ITEM_EMPYBAND: C2RustUnnamed_12 = 18;
pub const ITEM_GOLDENELIX: C2RustUnnamed_12 = 17;
pub const ITEM_3COLORPOT: C2RustUnnamed_12 = 16;
pub const ITEM_SPECTRAL: C2RustUnnamed_12 = 15;
pub const ITEM_BRNRING: C2RustUnnamed_12 = 14;
pub const ITEM_MJRING: C2RustUnnamed_12 = 13;
pub const ITEM_SLVRRING: C2RustUnnamed_12 = 12;
pub const ITEM_3JRING: C2RustUnnamed_12 = 11;
pub const ITEM_BLUERING: C2RustUnnamed_12 = 10;
pub const ITEM_WOODRING: C2RustUnnamed_12 = 9;
pub const ITEM_1JRING: C2RustUnnamed_12 = 8;
pub const ITEM_GOLDRING: C2RustUnnamed_12 = 7;
pub const ITEM_SCROLL3: C2RustUnnamed_12 = 3;
pub const ITEM_SCROLL2: C2RustUnnamed_12 = 2;
pub const ITEM_SCROLL: C2RustUnnamed_12 = 1;
pub const ITEM_BLUEBTL: C2RustUnnamed_12 = 0;
pub type C2RustUnnamed_13 = libc::c_uint;
pub const IDI_RESURRECT: C2RustUnnamed_13 = 34;
pub const IDI_LGTFORGE: C2RustUnnamed_13 = 32;
pub const IDI_GRISWOLD: C2RustUnnamed_13 = 31;
pub const IDI_FULLMANA: C2RustUnnamed_13 = 30;
pub const IDI_FULLHEAL: C2RustUnnamed_13 = 29;
pub const IDI_ARMOFVAL: C2RustUnnamed_13 = 28;
pub const IDI_PORTAL: C2RustUnnamed_13 = 27;
pub const IDI_IDENTIFY: C2RustUnnamed_13 = 26;
pub const IDI_MANA: C2RustUnnamed_13 = 25;
pub const IDI_HEAL: C2RustUnnamed_13 = 24;
pub const IDI_EAR: C2RustUnnamed_13 = 23;
pub const IDI_MAPOFDOOM: C2RustUnnamed_13 = 22;
pub const IDI_BLDSTONE: C2RustUnnamed_13 = 21;
pub const IDI_SPECELIX: C2RustUnnamed_13 = 20;
pub const IDI_FUNGALTM: C2RustUnnamed_13 = 19;
pub const IDI_BRAIN: C2RustUnnamed_13 = 18;
pub const IDI_MUSHROOM: C2RustUnnamed_13 = 17;
pub const IDI_ANVIL: C2RustUnnamed_13 = 16;
pub const IDI_GLDNELIX: C2RustUnnamed_13 = 15;
pub const IDI_STEELVEIL: C2RustUnnamed_13 = 14;
pub const IDI_HARCREST: C2RustUnnamed_13 = 13;
pub const IDI_BANNER: C2RustUnnamed_13 = 12;
pub const IDI_TRING: C2RustUnnamed_13 = 11;
pub const IDI_OPTAMULET: C2RustUnnamed_13 = 10;
pub const IDI_ROCK: C2RustUnnamed_13 = 9;
pub const IDI_INFRARING: C2RustUnnamed_13 = 8;
pub const IDI_SKCROWN: C2RustUnnamed_13 = 7;
pub const IDI_CLEAVER: C2RustUnnamed_13 = 6;
pub const IDI_SORCEROR: C2RustUnnamed_13 = 5;
pub const IDI_ROGUE: C2RustUnnamed_13 = 4;
pub const IDI_WARRCLUB: C2RustUnnamed_13 = 3;
pub const IDI_WARRSHLD: C2RustUnnamed_13 = 2;
pub const IDI_WARRIOR: C2RustUnnamed_13 = 1;
pub const IDI_GOLD: C2RustUnnamed_13 = 0;
pub type C2RustUnnamed_14 = libc::c_uint;
pub const IMAGIC_MAGIC: C2RustUnnamed_14 = 1;
pub type C2RustUnnamed_15 = libc::c_uint;
pub const IT_AMULET: C2RustUnnamed_15 = 13;
pub const IT_RING: C2RustUnnamed_15 = 12;
pub const IT_HARMOR: C2RustUnnamed_15 = 9;
pub const IT_MARMOR: C2RustUnnamed_15 = 8;
pub const IT_HELM: C2RustUnnamed_15 = 7;
pub const IT_ARMOR: C2RustUnnamed_15 = 6;
pub const IT_SHIELD: C2RustUnnamed_15 = 5;
pub const IT_MACE: C2RustUnnamed_15 = 4;
pub const IT_BOW: C2RustUnnamed_15 = 3;
pub const IT_AXE: C2RustUnnamed_15 = 2;
pub const IT_SWORD: C2RustUnnamed_15 = 1;
pub type C2RustUnnamed_16 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_16 = 32;
pub const MAXMICRO: C2RustUnnamed_16 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_16 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_16 = 64;
pub const MAXMREND: C2RustUnnamed_16 = 128;
pub const MAXTILES: C2RustUnnamed_16 = 2048;
pub const MDMAXY: C2RustUnnamed_16 = 40;
pub const MDMAXX: C2RustUnnamed_16 = 40;
pub const MAXDUNY: C2RustUnnamed_16 = 112;
pub const MAXDUNX: C2RustUnnamed_16 = 112;
pub const DMAXY: C2RustUnnamed_16 = 112;
pub const DMAXX: C2RustUnnamed_16 = 112;
pub const DIRTEDGED2: C2RustUnnamed_16 = 16;
pub const DIRTEDGE: C2RustUnnamed_16 = 32;
pub const NUMSLEVELS: C2RustUnnamed_16 = 10;
pub const LVL4_START: C2RustUnnamed_16 = 13;
pub const LVL3_START: C2RustUnnamed_16 = 9;
pub const LVL2_START: C2RustUnnamed_16 = 5;
pub const LVL1_START: C2RustUnnamed_16 = 1;
pub const TLVL_START: C2RustUnnamed_16 = 0;
pub const LVLLENGTH: C2RustUnnamed_16 = 4;
pub type C2RustUnnamed_17 = libc::c_uint;
pub const NUM_INVLOC: C2RustUnnamed_17 = 7;
pub type C2RustUnnamed_18 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_18 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_18 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_18 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_18 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_18 = 32;
pub const MAXPATHLEN: C2RustUnnamed_18 = 25;
pub const MANA_SHIFT: C2RustUnnamed_18 = 6;
pub const HP_SHIFT: C2RustUnnamed_18 = 6;
pub const NUM_CLASSES: C2RustUnnamed_18 = 3;
pub const MAXPACKLEN: C2RustUnnamed_18 = 256;
pub type C2RustUnnamed_19 = libc::c_uint;
pub const QUEST_OFFSETS: C2RustUnnamed_19 = 7;
pub const MAXMULTIQUESTS: C2RustUnnamed_19 = 4;
#[no_mangle]
pub static mut stextsize: int8_t = 0;
#[no_mangle]
pub static mut stextspin: libc::c_int = 0;
#[no_mangle]
pub static mut stextsel: libc::c_int = 0;
#[no_mangle]
pub static mut stextlhold: libc::c_int = 0;
#[no_mangle]
pub static mut stextshold: libc::c_int = 0;
#[no_mangle]
pub static mut stextvhold: libc::c_int = 0;
#[no_mangle]
pub static mut stextscrl: bool32_t = 0;
#[no_mangle]
pub static mut stextsval: libc::c_int = 0;
#[no_mangle]
pub static mut stextsmax: libc::c_int = 0;
#[no_mangle]
pub static mut stextup: libc::c_int = 0;
#[no_mangle]
pub static mut stextdown: libc::c_int = 0;
#[no_mangle]
pub static mut stextscrlubtn: int8_t = 0;
#[no_mangle]
pub static mut stextscrldbtn: int8_t = 0;
#[no_mangle]
pub static mut stext: [STextStruct; 24] = [STextStruct {
    _sx: 0,
    _syoff: 0,
    _sstr: [0; 128],
    _sjust: 0,
    _sclr: 0,
    _sline: 0,
    _ssel: 0,
    _sval: 0,
}; 24];
#[no_mangle]
pub static mut storehold: [ItemStruct; 48] = [ItemStruct {
    _iSeed: 0,
    _iCreateInfo: 0,
    _itype: 0,
    _ix: 0,
    _iy: 0,
    _iAnimFlag: 0,
    _iAnimData: 0 as *const uint8_t as *mut uint8_t,
    _iAnimLen: 0,
    _iAnimFrame: 0,
    _iAnimWidth: 0,
    _iAnimWidth2: 0,
    _iInvalid: 0,
    _iSelFlag: 0,
    _iPostDraw: 0,
    _iIdentified: 0,
    _iMagical: 0,
    _iName: [0; 64],
    _iIName: [0; 64],
    _iLoc: 0,
    _iClass: 0,
    _iCurs: 0,
    _ivalue: 0,
    _iIvalue: 0,
    _iMinDam: 0,
    _iMaxDam: 0,
    _iAC: 0,
    _iFlags: 0,
    _iMiscId: 0,
    _iSpell: 0,
    _iCharges: 0,
    _iMaxCharges: 0,
    _iDurability: 0,
    _iMaxDur: 0,
    _iPLDam: 0,
    _iPLToHit: 0,
    _iPLAC: 0,
    _iPLStr: 0,
    _iPLMag: 0,
    _iPLDex: 0,
    _iPLVit: 0,
    _iPLFR: 0,
    _iPLLR: 0,
    _iPLMR: 0,
    _iPLMana: 0,
    _iPLHP: 0,
    _iPLDamMod: 0,
    _iPLGetHit: 0,
    _iPLLight: 0,
    _iSplLvlAdd: 0,
    _iRequest: 0,
    _iUid: 0,
    _iFMinDam: 0,
    _iFMaxDam: 0,
    _iLMinDam: 0,
    _iLMaxDam: 0,
    _iPLEnAc: 0,
    _iPrePower: 0,
    _iSufPower: 0,
    _iVAdd1: 0,
    _iVMult1: 0,
    _iVAdd2: 0,
    _iVMult2: 0,
    _iMinStr: 0,
    _iMinMag: 0,
    _iMinDex: 0,
    _iStatFlag: 0,
    IDidx: 0,
    _oldlight: 0,
}; 48];
#[no_mangle]
pub static mut storehidx: [int8_t; 48] = [0; 48];
#[no_mangle]
pub static mut storenumh: libc::c_int = 0;
#[no_mangle]
pub static mut gossipstart: libc::c_int = 0;
#[no_mangle]
pub static mut gossipend: libc::c_int = 0;
#[no_mangle]
pub static mut talkname: [*const libc::c_char; 9] = [
    b"Griswold\0" as *const u8 as *const libc::c_char,
    b"Pepin\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Ogden\0" as *const u8 as *const libc::c_char,
    b"Cain\0" as *const u8 as *const libc::c_char,
    b"Farnham\0" as *const u8 as *const libc::c_char,
    b"Adria\0" as *const u8 as *const libc::c_char,
    b"Gillian\0" as *const u8 as *const libc::c_char,
    b"Wirt\0" as *const u8 as *const libc::c_char,
];
#[no_mangle]
pub static mut talker: libc::c_int = 0;
#[no_mangle]
pub unsafe extern "C" fn InitStores() {
    if !pSTextBoxCels.is_null() {
        assert_fail(
            85 as libc::c_int,
            b"src/stores.c\0" as *const u8 as *const libc::c_char,
            b"!pSTextBoxCels\0" as *const u8 as *const libc::c_char,
        );
    }
    pSTextBoxCels = LoadFileInMem(
        b"Data\\TextBox2.CEL\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    pSTextSpinCels = LoadFileInMem(
        b"Data\\PentSpn2.CEL\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    pSTextSlidCels = LoadFileInMem(
        b"Data\\TextSlid.CEL\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    ClearSText(0 as libc::c_int, NUMSTLINES as libc::c_int);
    stextflag = STORE_NONE as libc::c_int as int8_t;
    stextspin = 1 as libc::c_int;
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    numpremium = 0 as libc::c_int;
    premiumlevel = 1 as libc::c_int;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAXPREMIUM as libc::c_int {
        premiumitem[i as usize]._itype = -(1 as libc::c_int);
        i += 1;
        i;
    }
    boyitem._itype = -(1 as libc::c_int);
    boylevel = 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn SetupTownStores() {
    let mut i: libc::c_int = 0;
    let mut l: libc::c_int = 0;
    let mut stores_seed: int32_t = 0;
    if set_stores_seed != 0 as libc::c_int {
        stores_seed = set_stores_seed;
    } else {
        stores_seed = SDL_GetTicks() as int32_t;
    }
    SetRndSeed(
        b"src/stores.c\0" as *const u8 as *const libc::c_char,
        113 as libc::c_int,
        (glSeedTbl[currlevel as usize].wrapping_mul(stores_seed as uint32_t)) as int32_t,
    );
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        l = 0 as libc::c_int;
        i = 0 as libc::c_int;
        while i < NUMLEVELS as libc::c_int {
            if plr[myplr as usize]._pLvlVisited[i as usize] != 0 {
                l = i;
            }
            i += 1;
            i;
        }
    } else {
        l = plr[myplr as usize]._pLevel as libc::c_int >> 1 as libc::c_int;
    }
    l += 2 as libc::c_int;
    if l < 6 as libc::c_int {
        l = 6 as libc::c_int;
    }
    if l > 16 as libc::c_int {
        l = 16 as libc::c_int;
    }
    _logf(b"generating stores template gold item\0" as *const u8 as *const libc::c_char);
    SpawnStoreGold();
    SpawnSmith(l);
    SpawnWitch(l);
    SpawnHealer(l);
    SpawnBoy(plr[myplr as usize]._pLevel as libc::c_int);
    SpawnPremium(plr[myplr as usize]._pLevel as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn FreeStoreMem() {
    let mut p__p: *mut libc::c_void = pSTextBoxCels as *mut libc::c_void;
    pSTextBoxCels = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    let mut p__p_0: *mut libc::c_void = pSTextSpinCels as *mut libc::c_void;
    pSTextSpinCels = 0 as *mut uint8_t;
    mem_free_dbg(p__p_0);
    let mut p__p_1: *mut libc::c_void = pSTextSlidCels as *mut libc::c_void;
    pSTextSlidCels = 0 as *mut uint8_t;
    mem_free_dbg(p__p_1);
}
#[no_mangle]
pub unsafe extern "C" fn DrawSTextBack() {
    DrawCel(
        408 as libc::c_int,
        487 as libc::c_int,
        pSTextBoxCels,
        1 as libc::c_int,
        271 as libc::c_int,
    );
    TDrawRect(
        347 as libc::c_int,
        28 as libc::c_int,
        265 as libc::c_int,
        297 as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn PrintSString(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut cjustflag: bool32_t,
    mut str: *const libc::c_char,
    mut col: int8_t,
    mut val: libc::c_int,
) {
    let mut boffset: int32_t = 0;
    let mut sl: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut w: libc::c_int = 0;
    let mut tw: libc::c_int = 0;
    let mut aw: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    let mut xa: libc::c_int = 0;
    let mut valstr: [libc::c_char; 32] = [0; 32];
    yy = SStringY[y as usize] + stext[y as usize]._syoff;
    if stextsize as libc::c_int == STEXT_SMALL as libc::c_int {
        xa = 416 as libc::c_int;
    } else {
        xa = 96 as libc::c_int;
    }
    boffset = nBuffWTbl[(yy + 204 as libc::c_int) as usize] + x + xa;
    sl = strlen(str) as libc::c_int;
    if stextsize as libc::c_int == STEXT_SMALL as libc::c_int {
        aw = 257 as libc::c_int;
    } else {
        aw = 577 as libc::c_int;
    }
    w = 0 as libc::c_int;
    if cjustflag != 0 {
        tw = 0 as libc::c_int;
        i = 0 as libc::c_int;
        while i < sl {
            let mut c: uint8_t = gbFontTransTbl[*str.offset(i as isize) as uint8_t
                as usize];
            c = fonttrans[c as usize];
            tw += fontkern[c as usize] as libc::c_int + 1 as libc::c_int;
            i += 1;
            i;
        }
        if tw < aw {
            w = aw - tw >> 1 as libc::c_int;
        }
        boffset += w;
    }
    if stextsel == y {
        if cjustflag != 0 {
            xx = x + w + xa - 20 as libc::c_int;
        } else {
            xx = x + xa - 20 as libc::c_int;
        }
        DrawCel(
            xx,
            yy + 205 as libc::c_int,
            pSTextSpinCels,
            stextspin,
            12 as libc::c_int,
        );
    }
    i = 0 as libc::c_int;
    while i < sl {
        let mut c_0: uint8_t = gbFontTransTbl[*str.offset(i as isize) as uint8_t
            as usize];
        c_0 = fonttrans[c_0 as usize];
        w += fontkern[c_0 as usize] as libc::c_int + 1 as libc::c_int;
        if c_0 as libc::c_int != 0 as libc::c_int && w <= aw {
            DrawPanelFont(boffset, c_0 as int32_t, col);
        }
        boffset += fontkern[c_0 as usize] as libc::c_int + 1 as libc::c_int;
        i += 1;
        i;
    }
    if cjustflag == 0 && val >= 0 as libc::c_int {
        sprintf(valstr.as_mut_ptr(), b"%d\0" as *const u8 as *const libc::c_char, val);
        boffset = nBuffWTbl[(yy + 204 as libc::c_int) as usize] + 656 as libc::c_int - x;
        sl = strlen(valstr.as_mut_ptr()) as libc::c_int;
        i = sl - 1 as libc::c_int;
        while i >= 0 as libc::c_int {
            let mut c_1: uint8_t = gbFontTransTbl[valstr[i as usize] as uint8_t
                as usize];
            c_1 = fonttrans[c_1 as usize];
            boffset -= fontkern[c_1 as usize] as libc::c_int + 1 as libc::c_int;
            if c_1 as libc::c_int != 0 as libc::c_int {
                DrawPanelFont(boffset, c_1 as int32_t, col);
            }
            i -= 1;
            i;
        }
    }
    if stextsel == y {
        if cjustflag != 0 {
            xx = x + w + xa + 4 as libc::c_int;
        } else {
            xx = 660 as libc::c_int - x;
        }
        DrawCel(
            xx,
            yy + 205 as libc::c_int,
            pSTextSpinCels,
            stextspin,
            12 as libc::c_int,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawSLine(mut y: libc::c_int) {
    let mut soffset: int32_t = 0;
    let mut doffset: int32_t = 0;
    let mut width: int32_t = 0;
    let mut yy: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut pFrom: *mut uint32_t = 0 as *mut uint32_t;
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    yy = SStringY[y as usize];
    if stextsize as libc::c_int == STEXT_LARGE as libc::c_int {
        soffset = 142170 as libc::c_int;
        doffset = nBuffWTbl[(yy + 198 as libc::c_int) as usize] + 90 as libc::c_int;
        width = 587 as libc::c_int;
    } else {
        soffset = 142490 as libc::c_int;
        doffset = nBuffWTbl[(yy + 198 as libc::c_int) as usize] + 410 as libc::c_int;
        width = 267 as libc::c_int;
    }
    if gpBuffer.is_null() {
        assert_fail(
            253 as libc::c_int,
            b"src/stores.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = &mut *gpBuffer.offset(soffset as isize) as *mut uint32_t;
    pTo = &mut *gpBuffer.offset(doffset as isize) as *mut uint32_t;
    i = 0 as libc::c_int;
    while i < 3 as libc::c_int {
        memcpy(
            pTo as *mut libc::c_void,
            pFrom as *const libc::c_void,
            (width * 4 as libc::c_int) as libc::c_ulong,
        );
        pFrom = pFrom.offset(768 as libc::c_int as isize);
        pTo = pTo.offset(768 as libc::c_int as isize);
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawScrlBar(mut y1: libc::c_int, mut y2: libc::c_int) {
    let mut i: libc::c_int = 0;
    let mut yy1: libc::c_int = 0;
    let mut yy2: libc::c_int = 0;
    let mut v: libc::c_int = 0;
    let mut s: libc::c_int = 0;
    yy1 = SStringY[y1 as usize] + 204 as libc::c_int;
    yy2 = SStringY[y2 as usize] + 204 as libc::c_int;
    if stextscrlubtn as libc::c_int != -(1 as libc::c_int) {
        DrawCel(
            665 as libc::c_int,
            yy1,
            pSTextSlidCels,
            12 as libc::c_int,
            12 as libc::c_int,
        );
    } else {
        DrawCel(
            665 as libc::c_int,
            yy1,
            pSTextSlidCels,
            10 as libc::c_int,
            12 as libc::c_int,
        );
    }
    if stextscrldbtn as libc::c_int != -(1 as libc::c_int) {
        DrawCel(
            665 as libc::c_int,
            yy2,
            pSTextSlidCels,
            11 as libc::c_int,
            12 as libc::c_int,
        );
    } else {
        DrawCel(
            665 as libc::c_int,
            yy2,
            pSTextSlidCels,
            9 as libc::c_int,
            12 as libc::c_int,
        );
    }
    i = yy1 + 12 as libc::c_int;
    while i < yy2 {
        DrawCel(
            665 as libc::c_int,
            i,
            pSTextSlidCels,
            14 as libc::c_int,
            12 as libc::c_int,
        );
        i += 12 as libc::c_int;
    }
    if stextsel != 22 as libc::c_int {
        s = stextsel;
    } else {
        s = stextlhold;
    }
    if storenumh > 1 as libc::c_int {
        v = (s - stextup >> 2 as libc::c_int) + stextsval;
        v = v * 1000 as libc::c_int;
        v = v / (storenumh - 1 as libc::c_int);
        v = v * (SStringY[y2 as usize] - SStringY[y1 as usize] - 24 as libc::c_int);
        v = v / 1000 as libc::c_int;
    } else {
        v = 0 as libc::c_int;
    }
    v += SStringY[(y1 + 1 as libc::c_int) as usize] + 204 as libc::c_int;
    DrawCel(665 as libc::c_int, v, pSTextSlidCels, 13 as libc::c_int, 12 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn SetupSTextWin() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextsel = -(1 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn SetupSTextLWin() {
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    stextsel = -(1 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn ClearSText(mut s: libc::c_int, mut e: libc::c_int) {
    let mut i: libc::c_int = 0;
    i = s;
    while i < e {
        stext[i as usize]._sx = 0 as libc::c_int;
        stext[i as usize]._syoff = 0 as libc::c_int;
        stext[i as usize]
            ._sstr[0 as libc::c_int as usize] = 0 as libc::c_int as libc::c_char;
        stext[i as usize]._sjust = 0 as libc::c_int as bool32_t;
        stext[i as usize]._sclr = ICOLOR_WHITE as libc::c_int as int8_t;
        stext[i as usize]._sline = 0 as libc::c_int as bool32_t;
        stext[i as usize]._ssel = 0 as libc::c_int as bool32_t;
        stext[i as usize]._sval = -(1 as libc::c_int);
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn AddSLine(mut y: libc::c_int) {
    stext[y as usize]._sx = 0 as libc::c_int;
    stext[y as usize]._syoff = 0 as libc::c_int;
    stext[y as usize]
        ._sstr[0 as libc::c_int as usize] = 0 as libc::c_int as libc::c_char;
    stext[y as usize]._sline = 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn AddSTextVal(mut y: libc::c_int, mut val: libc::c_int) {
    stext[y as usize]._sval = val;
}
#[no_mangle]
pub unsafe extern "C" fn OffsetSTextY(mut y: libc::c_int, mut yo: libc::c_int) {
    stext[y as usize]._syoff = yo;
}
#[no_mangle]
pub unsafe extern "C" fn AddSText(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut j: bool32_t,
    mut str: *const libc::c_char,
    mut clr: int8_t,
    mut sel: bool32_t,
) {
    stext[y as usize]._sx = x;
    stext[y as usize]._syoff = 0 as libc::c_int;
    strcpy((stext[y as usize]._sstr).as_mut_ptr(), str);
    stext[y as usize]._sjust = j;
    stext[y as usize]._sclr = clr;
    stext[y as usize]._sline = 0 as libc::c_int as bool32_t;
    stext[y as usize]._ssel = sel;
}
unsafe extern "C" fn PrintStoreItem(
    mut x: *const ItemStruct,
    mut l: libc::c_int,
    mut iclr: int8_t,
) {
    let mut sstr: [libc::c_char; 128] = [0; 128];
    sstr[0 as libc::c_int as usize] = 0 as libc::c_int as libc::c_char;
    if (*x)._iIdentified != 0 {
        if (*x)._iMagical as libc::c_int != IMAGIC_UNIQUE as libc::c_int
            && (*x)._iPrePower as libc::c_int != -(1 as libc::c_int)
        {
            PrintItemPower((*x)._iPrePower, x);
            strcat(sstr.as_mut_ptr(), tempstr.as_mut_ptr());
        }
        if (*x)._iSufPower as libc::c_int != -(1 as libc::c_int) {
            PrintItemPower((*x)._iSufPower, x);
            if sstr[0 as libc::c_int as usize] as libc::c_int != 0 as libc::c_int {
                strcat(sstr.as_mut_ptr(), b",  \0" as *const u8 as *const libc::c_char);
            }
            strcat(sstr.as_mut_ptr(), tempstr.as_mut_ptr());
        }
    }
    if (*x)._iMiscId == IMID_STAFF as libc::c_int
        && (*x)._iMaxCharges != 0 as libc::c_int
    {
        sprintf(
            tempstr.as_mut_ptr(),
            b"Charges: %d/%d\0" as *const u8 as *const libc::c_char,
            (*x)._iCharges,
            (*x)._iMaxCharges,
        );
        if sstr[0 as libc::c_int as usize] as libc::c_int != 0 as libc::c_int {
            strcat(sstr.as_mut_ptr(), b",  \0" as *const u8 as *const libc::c_char);
        }
        strcat(sstr.as_mut_ptr(), tempstr.as_mut_ptr());
    }
    if sstr[0 as libc::c_int as usize] as libc::c_int != 0 as libc::c_int {
        AddSText(
            40 as libc::c_int,
            l,
            0 as libc::c_int as bool32_t,
            sstr.as_mut_ptr(),
            iclr,
            0 as libc::c_int as bool32_t,
        );
        l += 1;
        l;
    }
    sstr[0 as libc::c_int as usize] = 0 as libc::c_int as libc::c_char;
    if (*x)._iClass as libc::c_int == IC_WEAP as libc::c_int {
        sprintf(
            sstr.as_mut_ptr(),
            b"Damage: %d-%d  \0" as *const u8 as *const libc::c_char,
            (*x)._iMinDam,
            (*x)._iMaxDam,
        );
    }
    if (*x)._iClass as libc::c_int == IC_ARMOR as libc::c_int {
        sprintf(
            sstr.as_mut_ptr(),
            b"Armor: %d  \0" as *const u8 as *const libc::c_char,
            (*x)._iAC,
        );
    }
    if (*x)._iMaxDur == INFINITE_DUR as libc::c_int || (*x)._iMaxDur == 0 as libc::c_int
    {
        strcat(
            sstr.as_mut_ptr(),
            b"Indestructible,  \0" as *const u8 as *const libc::c_char,
        );
    } else {
        sprintf(
            tempstr.as_mut_ptr(),
            b"Dur: %d/%d,  \0" as *const u8 as *const libc::c_char,
            (*x)._iDurability,
            (*x)._iMaxDur,
        );
        strcat(sstr.as_mut_ptr(), tempstr.as_mut_ptr());
    }
    if (*x)._itype == IT_MISC as libc::c_int {
        sstr[0 as libc::c_int as usize] = 0 as libc::c_int as libc::c_char;
    }
    if (*x)._iMinStr as libc::c_int + (*x)._iMinMag as libc::c_int
        + (*x)._iMinDex as libc::c_int == 0 as libc::c_int
    {
        strcat(
            sstr.as_mut_ptr(),
            b"No required attributes\0" as *const u8 as *const libc::c_char,
        );
    } else {
        strcpy(tempstr.as_mut_ptr(), b"Required:\0" as *const u8 as *const libc::c_char);
        if (*x)._iMinStr as libc::c_int != 0 as libc::c_int {
            sprintf(
                tempstr.as_mut_ptr(),
                b"%s %d Str\0" as *const u8 as *const libc::c_char,
                tempstr.as_mut_ptr(),
                (*x)._iMinStr as libc::c_int,
            );
        }
        if (*x)._iMinMag as libc::c_int != 0 as libc::c_int {
            sprintf(
                tempstr.as_mut_ptr(),
                b"%s %d Mag\0" as *const u8 as *const libc::c_char,
                tempstr.as_mut_ptr(),
                (*x)._iMinMag as libc::c_int,
            );
        }
        if (*x)._iMinDex as libc::c_int != 0 as libc::c_int {
            sprintf(
                tempstr.as_mut_ptr(),
                b"%s %d Dex\0" as *const u8 as *const libc::c_char,
                tempstr.as_mut_ptr(),
                (*x)._iMinDex as libc::c_int,
            );
        }
        strcat(sstr.as_mut_ptr(), tempstr.as_mut_ptr());
    }
    let fresh0 = l;
    l = l + 1;
    AddSText(
        40 as libc::c_int,
        fresh0,
        0 as libc::c_int as bool32_t,
        sstr.as_mut_ptr(),
        iclr,
        0 as libc::c_int as bool32_t,
    );
    if (*x)._iMagical as libc::c_int == IMAGIC_UNIQUE as libc::c_int
        && (*x)._iIdentified != 0
    {
        let fresh1 = l;
        l = l + 1;
        AddSText(
            40 as libc::c_int,
            fresh1,
            0 as libc::c_int as bool32_t,
            b"Unique Item\0" as *const u8 as *const libc::c_char,
            iclr,
            0 as libc::c_int as bool32_t,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn StoreAutoPlace() {
    let mut i: libc::c_int = 0;
    let mut w: libc::c_int = 0;
    let mut h: libc::c_int = 0;
    let mut idx: libc::c_int = 0;
    let mut done: bool32_t = 0;
    SetICursor(plr[myplr as usize].HoldItem._iCurs + ICSTART as libc::c_int);
    w = icursW28;
    h = icursH28;
    done = 0 as libc::c_int as bool32_t;
    if w == 1 as libc::c_int && h == 1 as libc::c_int {
        idx = plr[myplr as usize].HoldItem.IDidx;
        if plr[myplr as usize].HoldItem._iStatFlag != 0
            && AllItemsList[idx as usize].iUsable != 0
        {
            i = 0 as libc::c_int;
            while i < MAXSPD as libc::c_int && done == 0 {
                if plr[myplr as usize].SpdList[i as usize]._itype == -(1 as libc::c_int)
                {
                    plr[myplr as usize]
                        .SpdList[i as usize] = plr[myplr as usize].HoldItem;
                    done = 1 as libc::c_int as bool32_t;
                }
                i += 1;
                i;
            }
        }
        i = 30 as libc::c_int;
        while i <= 39 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 1;
            i;
        }
        i = 20 as libc::c_int;
        while i <= 29 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 1;
            i;
        }
        i = 10 as libc::c_int;
        while i <= 19 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i <= 9 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 1;
            i;
        }
    }
    if w == 1 as libc::c_int && h == 2 as libc::c_int {
        i = 29 as libc::c_int;
        while i >= 20 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i -= 1;
            i;
        }
        i = 9 as libc::c_int;
        while i >= 0 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i -= 1;
            i;
        }
        i = 19 as libc::c_int;
        while i >= 10 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i -= 1;
            i;
        }
    }
    if w == 1 as libc::c_int && h == 3 as libc::c_int {
        i = 0 as libc::c_int;
        while i < 20 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 1;
            i;
        }
    }
    if w == 2 as libc::c_int && h == 2 as libc::c_int {
        i = 0 as libc::c_int;
        while i < 10 as libc::c_int && done == 0 {
            done = AutoPlace(
                myplr,
                AP2x2Tbl[i as usize],
                w,
                h,
                1 as libc::c_int as bool32_t,
            );
            i += 1;
            i;
        }
        i = 21 as libc::c_int;
        while i < 29 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 2 as libc::c_int;
        }
        i = 1 as libc::c_int;
        while i < 9 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 2 as libc::c_int;
        }
        i = 10 as libc::c_int;
        while i < 19 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 1;
            i;
        }
    }
    if w == 2 as libc::c_int && h == 3 as libc::c_int {
        i = 0 as libc::c_int;
        while i < 9 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 1;
            i;
        }
        i = 10 as libc::c_int;
        while i < 19 as libc::c_int && done == 0 {
            done = AutoPlace(myplr, i, w, h, 1 as libc::c_int as bool32_t);
            i += 1;
            i;
        }
    }
    if done != 0 {
        memset(
            &mut (*plr.as_mut_ptr().offset(myplr as isize)).HoldItem as *mut ItemStruct
                as *mut libc::c_void,
            0 as libc::c_int,
            ::core::mem::size_of::<ItemStruct>() as libc::c_ulong,
        );
        plr[myplr as usize].HoldItem._itype = -(1 as libc::c_int);
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_StartSmith() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    AddSText(
        0 as libc::c_int,
        1 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Welcome to the\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        3 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Blacksmith's shop\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        7 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Would you like to:\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        10 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Talk to Griswold\0" as *const u8 as *const libc::c_char,
        ICOLOR_BLUE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        12 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Buy basic items\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        14 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Buy premium items\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        16 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Sell items\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Repair items\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        20 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Leave the shop\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
    storenumh = 20 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn S_ScrollSBuy(mut idx: libc::c_int) {
    let mut l: libc::c_int = 0;
    let mut ls: libc::c_int = 0;
    let mut iclr: int8_t = 0;
    ClearSText(5 as libc::c_int, 21 as libc::c_int);
    stextup = 5 as libc::c_int;
    l = 5 as libc::c_int;
    while l < 20 as libc::c_int {
        if smithitem[idx as usize]._itype != -(1 as libc::c_int) {
            ls = l;
            iclr = ICOLOR_WHITE as libc::c_int as int8_t;
            if smithitem[idx as usize]._iMagical != 0 {
                iclr = ICOLOR_BLUE as libc::c_int as int8_t;
            }
            if smithitem[idx as usize]._iStatFlag == 0 {
                iclr = ICOLOR_RED as libc::c_int as int8_t;
            }
            if smithitem[idx as usize]._iMagical != 0 {
                AddSText(
                    20 as libc::c_int,
                    l,
                    0 as libc::c_int as bool32_t,
                    (smithitem[idx as usize]._iIName).as_mut_ptr(),
                    iclr,
                    1 as libc::c_int as bool32_t,
                );
            } else {
                AddSText(
                    20 as libc::c_int,
                    l,
                    0 as libc::c_int as bool32_t,
                    (smithitem[idx as usize]._iName).as_mut_ptr(),
                    iclr,
                    1 as libc::c_int as bool32_t,
                );
            }
            AddSTextVal(l, smithitem[idx as usize]._iIvalue);
            PrintStoreItem(
                &mut *smithitem.as_mut_ptr().offset(idx as isize),
                l + 1 as libc::c_int,
                iclr,
            );
            stextdown = ls;
            idx += 1;
            idx;
        }
        l += 4 as libc::c_int;
    }
    if stext[stextsel as usize]._ssel == 0 && stextsel != 22 as libc::c_int {
        stextsel = stextdown;
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_StartSBuy() {
    let mut i: libc::c_int = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    stextscrl = 1 as libc::c_int as bool32_t;
    stextsval = 0 as libc::c_int;
    sprintf(
        tempstr.as_mut_ptr(),
        b"I have these items for sale :           Your gold : %d\0" as *const u8
            as *const libc::c_char,
        plr[myplr as usize]._pGold,
    );
    AddSText(
        0 as libc::c_int,
        1 as libc::c_int,
        1 as libc::c_int as bool32_t,
        tempstr.as_mut_ptr(),
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSLine(3 as libc::c_int);
    AddSLine(21 as libc::c_int);
    S_ScrollSBuy(stextsval);
    AddSText(
        0 as libc::c_int,
        22 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Back\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while smithitem[i as usize]._itype != -(1 as libc::c_int) {
        storenumh += 1;
        storenumh;
        i += 1;
        i;
    }
    stextsmax = storenumh - 4 as libc::c_int;
    if stextsmax < 0 as libc::c_int {
        stextsmax = 0 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_ScrollSPBuy(mut idx: libc::c_int) {
    let mut l: libc::c_int = 0;
    let mut ls: libc::c_int = 0;
    let mut iclr: int8_t = 0;
    let mut boughtitems: libc::c_int = 0;
    ClearSText(5 as libc::c_int, 21 as libc::c_int);
    stextup = 5 as libc::c_int;
    boughtitems = idx;
    idx = 0 as libc::c_int;
    while boughtitems != 0 {
        if premiumitem[idx as usize]._itype != -(1 as libc::c_int) {
            boughtitems -= 1;
            boughtitems;
        }
        idx += 1;
        idx;
    }
    l = 5 as libc::c_int;
    while l < 20 as libc::c_int && idx < MAXPREMIUM as libc::c_int {
        if premiumitem[idx as usize]._itype != -(1 as libc::c_int) {
            ls = l;
            iclr = ICOLOR_WHITE as libc::c_int as int8_t;
            if premiumitem[idx as usize]._iMagical != 0 {
                iclr = ICOLOR_BLUE as libc::c_int as int8_t;
            }
            if premiumitem[idx as usize]._iStatFlag == 0 {
                iclr = ICOLOR_RED as libc::c_int as int8_t;
            }
            AddSText(
                20 as libc::c_int,
                l,
                0 as libc::c_int as bool32_t,
                (premiumitem[idx as usize]._iIName).as_mut_ptr(),
                iclr,
                1 as libc::c_int as bool32_t,
            );
            AddSTextVal(l, premiumitem[idx as usize]._iIvalue);
            PrintStoreItem(
                &mut *premiumitem.as_mut_ptr().offset(idx as isize),
                l + 1 as libc::c_int,
                iclr,
            );
            stextdown = ls;
        } else if idx < MAXPREMIUM as libc::c_int {
            l -= 4 as libc::c_int;
        }
        idx += 1;
        idx;
        l += 4 as libc::c_int;
    }
    if stext[stextsel as usize]._ssel == 0 && stextsel != 22 as libc::c_int {
        stextsel = stextdown;
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_StartSPBuy() -> bool32_t {
    let mut i: libc::c_int = 0;
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXPREMIUM as libc::c_int {
        if premiumitem[i as usize]._itype != -(1 as libc::c_int) {
            storenumh += 1;
            storenumh;
        }
        i += 1;
        i;
    }
    if storenumh == 0 as libc::c_int {
        StartStore(STORE_SMITH as libc::c_int as int8_t);
        stextsel = 14 as libc::c_int;
        return 0 as libc::c_int as bool32_t;
    } else {
        stextsize = STEXT_LARGE as libc::c_int as int8_t;
        stextscrl = 1 as libc::c_int as bool32_t;
        stextsval = 0 as libc::c_int;
        sprintf(
            tempstr.as_mut_ptr(),
            b"I have these premium items for sale :   Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
        stextsmax = storenumh - 4 as libc::c_int;
        if stextsmax < 0 as libc::c_int {
            stextsmax = 0 as libc::c_int;
        }
        S_ScrollSPBuy(stextsval);
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SmithSellOk(mut i: libc::c_int) -> bool32_t {
    if plr[myplr as usize].InvList[i as usize]._itype == -(1 as libc::c_int) {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize]._itype == IT_MISC as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize]._itype == IT_GOLD as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize]._itype == IT_FOOD as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize]._itype == IT_STAFF as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize].IDidx == IDI_LAZSTAFF as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn S_ScrollSSell(mut idx: libc::c_int) {
    let mut l: libc::c_int = 0;
    let mut ls: libc::c_int = 0;
    let mut v: libc::c_int = 0;
    let mut iclr: int8_t = 0;
    ClearSText(5 as libc::c_int, 21 as libc::c_int);
    stextup = 5 as libc::c_int;
    l = 5 as libc::c_int;
    while l < 20 as libc::c_int && idx < storenumh {
        if storehold[idx as usize]._itype != -(1 as libc::c_int) {
            ls = l;
            iclr = ICOLOR_WHITE as libc::c_int as int8_t;
            if storehold[idx as usize]._iMagical != 0 {
                iclr = ICOLOR_BLUE as libc::c_int as int8_t;
            }
            if storehold[idx as usize]._iStatFlag == 0 {
                iclr = ICOLOR_RED as libc::c_int as int8_t;
            }
            if storehold[idx as usize]._iMagical as libc::c_int != 0
                && storehold[idx as usize]._iIdentified != 0
            {
                AddSText(
                    20 as libc::c_int,
                    l,
                    0 as libc::c_int as bool32_t,
                    (storehold[idx as usize]._iIName).as_mut_ptr(),
                    iclr,
                    1 as libc::c_int as bool32_t,
                );
                v = storehold[idx as usize]._iIvalue;
            } else {
                AddSText(
                    20 as libc::c_int,
                    l,
                    0 as libc::c_int as bool32_t,
                    (storehold[idx as usize]._iName).as_mut_ptr(),
                    iclr,
                    1 as libc::c_int as bool32_t,
                );
                v = storehold[idx as usize]._ivalue;
            }
            AddSTextVal(l, v);
            PrintStoreItem(
                &mut *storehold.as_mut_ptr().offset(idx as isize),
                l + 1 as libc::c_int,
                iclr,
            );
            stextdown = ls;
        }
        idx += 1;
        idx;
        l += 4 as libc::c_int;
    }
    stextsmax = storenumh - 4 as libc::c_int;
    if stextsmax < 0 as libc::c_int {
        stextsmax = 0 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_StartSSell() {
    let mut i: libc::c_int = 0;
    let mut sellok: bool32_t = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    sellok = 0 as libc::c_int as bool32_t;
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXHOLDITEMS as libc::c_int {
        storehold[i as usize]._itype = -(1 as libc::c_int);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < plr[myplr as usize]._pNumInv {
        if SmithSellOk(i) != 0 {
            sellok = 1 as libc::c_int as bool32_t;
            storehold[storenumh as usize] = plr[myplr as usize].InvList[i as usize];
            if storehold[storenumh as usize]._iMagical as libc::c_int != 0
                && storehold[storenumh as usize]._iIdentified != 0
            {
                storehold[storenumh as usize]
                    ._ivalue = storehold[storenumh as usize]._iIvalue;
            }
            storehold[storenumh as usize]
                ._ivalue = storehold[storenumh as usize]._ivalue >> 2 as libc::c_int;
            if storehold[storenumh as usize]._ivalue == 0 {
                storehold[storenumh as usize]._ivalue = 1 as libc::c_int;
            }
            storehold[storenumh as usize]
                ._iIvalue = storehold[storenumh as usize]._ivalue;
            storehidx[storenumh as usize] = i as int8_t;
            storenumh += 1;
            storenumh;
        }
        i += 1;
        i;
    }
    if sellok == 0 {
        stextscrl = 0 as libc::c_int as bool32_t;
        sprintf(
            tempstr.as_mut_ptr(),
            b"You have nothing I want.            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    } else {
        stextscrl = 1 as libc::c_int as bool32_t;
        stextsval = 0 as libc::c_int;
        stextsmax = plr[myplr as usize]._pNumInv;
        sprintf(
            tempstr.as_mut_ptr(),
            b"Which item is for sale?            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        S_ScrollSSell(stextsval);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn SmithRepairOk(mut i: libc::c_int) -> bool32_t {
    if plr[myplr as usize].InvList[i as usize]._itype == -(1 as libc::c_int) {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize]._itype == IT_MISC as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize]._itype == IT_GOLD as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize]._itype == IT_FOOD as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].InvList[i as usize]._iDurability
        == plr[myplr as usize].InvList[i as usize]._iMaxDur
    {
        return 0 as libc::c_int as bool32_t;
    }
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn AddStoreHoldRepair(mut itm: *mut ItemStruct, mut i: libc::c_int) {
    let mut v: libc::c_int = 0;
    if !((*itm)._iMaxDur > 0 as libc::c_int) {
        assert_fail(
            787 as libc::c_int,
            b"src/stores.c\0" as *const u8 as *const libc::c_char,
            b"itm->_iMaxDur > 0\0" as *const u8 as *const libc::c_char,
        );
    }
    storehold[storenumh as usize] = *itm;
    itm = &mut *storehold.as_mut_ptr().offset(storenumh as isize) as *mut ItemStruct;
    if (*itm)._iMagical as libc::c_int != 0 && (*itm)._iIdentified != 0 {
        (*itm)._ivalue = (*itm)._iIvalue * 30 as libc::c_int / 100 as libc::c_int;
    }
    v = ((*itm)._iMaxDur - (*itm)._iDurability) * 100 as libc::c_int / (*itm)._iMaxDur;
    v = v * (*itm)._ivalue / 100 as libc::c_int;
    if v == 0 as libc::c_int {
        if (*itm)._iMagical as libc::c_int != 0 && (*itm)._iIdentified != 0 {
            return
        } else {
            v = 1 as libc::c_int;
        }
    }
    if v > 1 as libc::c_int {
        v >>= 1 as libc::c_int;
    }
    (*itm)._iIvalue = v;
    (*itm)._ivalue = (*itm)._iIvalue;
    let fresh2 = storenumh;
    storenumh = storenumh + 1;
    storehidx[fresh2 as usize] = i as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn S_StartSRepair() {
    let mut i: libc::c_int = 0;
    let mut repairok: bool32_t = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    repairok = 0 as libc::c_int as bool32_t;
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXHOLDITEMS as libc::c_int {
        storehold[i as usize]._itype = -(1 as libc::c_int);
        i += 1;
        i;
    }
    if plr[myplr as usize].InvBody[INVLOC_HEAD as libc::c_int as usize]._itype
        != -(1 as libc::c_int)
        && plr[myplr as usize].InvBody[INVLOC_HEAD as libc::c_int as usize]._iDurability
            != plr[myplr as usize].InvBody[INVLOC_HEAD as libc::c_int as usize]._iMaxDur
    {
        repairok = 1 as libc::c_int as bool32_t;
        AddStoreHoldRepair(
            &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
                .as_mut_ptr()
                .offset(INVLOC_HEAD as libc::c_int as isize),
            -(1 as libc::c_int),
        );
    }
    if plr[myplr as usize].InvBody[INVLOC_BODY as libc::c_int as usize]._itype
        != -(1 as libc::c_int)
        && plr[myplr as usize].InvBody[INVLOC_BODY as libc::c_int as usize]._iDurability
            != plr[myplr as usize].InvBody[INVLOC_BODY as libc::c_int as usize]._iMaxDur
    {
        repairok = 1 as libc::c_int as bool32_t;
        AddStoreHoldRepair(
            &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
                .as_mut_ptr()
                .offset(INVLOC_BODY as libc::c_int as isize),
            -(2 as libc::c_int),
        );
    }
    if plr[myplr as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._itype
        != -(1 as libc::c_int)
        && plr[myplr as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            != plr[myplr as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iMaxDur
    {
        repairok = 1 as libc::c_int as bool32_t;
        AddStoreHoldRepair(
            &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
                .as_mut_ptr()
                .offset(INVLOC_HAND1 as libc::c_int as isize),
            -(3 as libc::c_int),
        );
    }
    if plr[myplr as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._itype
        != -(1 as libc::c_int)
        && plr[myplr as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            != plr[myplr as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iMaxDur
    {
        repairok = 1 as libc::c_int as bool32_t;
        AddStoreHoldRepair(
            &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
                .as_mut_ptr()
                .offset(INVLOC_HAND2 as libc::c_int as isize),
            -(4 as libc::c_int),
        );
    }
    i = 0 as libc::c_int;
    while i < plr[myplr as usize]._pNumInv {
        if SmithRepairOk(i) != 0 {
            repairok = 1 as libc::c_int as bool32_t;
            AddStoreHoldRepair(
                &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvList)
                    .as_mut_ptr()
                    .offset(i as isize),
                i,
            );
        }
        i += 1;
        i;
    }
    if repairok == 0 {
        stextscrl = 0 as libc::c_int as bool32_t;
        sprintf(
            tempstr.as_mut_ptr(),
            b"You have nothing to repair.            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    } else {
        stextscrl = 1 as libc::c_int as bool32_t;
        stextsval = 0 as libc::c_int;
        stextsmax = plr[myplr as usize]._pNumInv;
        sprintf(
            tempstr.as_mut_ptr(),
            b"Repair which item?            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        S_ScrollSSell(stextsval);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_StartWitch() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    AddSText(
        0 as libc::c_int,
        2 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Witch's shack\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        9 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Would you like to:\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        12 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Talk to Adria\0" as *const u8 as *const libc::c_char,
        ICOLOR_BLUE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        14 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Buy items\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        16 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Sell items\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Recharge staves\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        20 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Leave the shack\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
    storenumh = 20 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn S_ScrollWBuy(mut idx: libc::c_int) {
    let mut l: libc::c_int = 0;
    let mut ls: libc::c_int = 0;
    let mut iclr: int8_t = 0;
    ClearSText(5 as libc::c_int, 21 as libc::c_int);
    stextup = 5 as libc::c_int;
    l = 5 as libc::c_int;
    while l < 20 as libc::c_int {
        if witchitem[idx as usize]._itype != -(1 as libc::c_int) {
            ls = l;
            iclr = ICOLOR_WHITE as libc::c_int as int8_t;
            if witchitem[idx as usize]._iMagical != 0 {
                iclr = ICOLOR_BLUE as libc::c_int as int8_t;
            }
            if witchitem[idx as usize]._iStatFlag == 0 {
                iclr = ICOLOR_RED as libc::c_int as int8_t;
            }
            if witchitem[idx as usize]._iMagical != 0 {
                AddSText(
                    20 as libc::c_int,
                    l,
                    0 as libc::c_int as bool32_t,
                    (witchitem[idx as usize]._iIName).as_mut_ptr(),
                    iclr,
                    1 as libc::c_int as bool32_t,
                );
            } else {
                AddSText(
                    20 as libc::c_int,
                    l,
                    0 as libc::c_int as bool32_t,
                    (witchitem[idx as usize]._iName).as_mut_ptr(),
                    iclr,
                    1 as libc::c_int as bool32_t,
                );
            }
            AddSTextVal(l, witchitem[idx as usize]._iIvalue);
            PrintStoreItem(
                &mut *witchitem.as_mut_ptr().offset(idx as isize),
                l + 1 as libc::c_int,
                iclr,
            );
            stextdown = ls;
            idx += 1;
            idx;
        }
        l += 4 as libc::c_int;
    }
    if stext[stextsel as usize]._ssel == 0 && stextsel != 22 as libc::c_int {
        stextsel = stextdown;
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_StartWBuy() {
    let mut i: libc::c_int = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    stextscrl = 1 as libc::c_int as bool32_t;
    stextsval = 0 as libc::c_int;
    stextsmax = 20 as libc::c_int;
    sprintf(
        tempstr.as_mut_ptr(),
        b"I have these items for sale :           Your gold : %d\0" as *const u8
            as *const libc::c_char,
        plr[myplr as usize]._pGold,
    );
    AddSText(
        0 as libc::c_int,
        1 as libc::c_int,
        1 as libc::c_int as bool32_t,
        tempstr.as_mut_ptr(),
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSLine(3 as libc::c_int);
    AddSLine(21 as libc::c_int);
    S_ScrollWBuy(stextsval);
    AddSText(
        0 as libc::c_int,
        22 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Back\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while witchitem[i as usize]._itype != -(1 as libc::c_int) {
        storenumh += 1;
        storenumh;
        i += 1;
        i;
    }
    stextsmax = storenumh - 4 as libc::c_int;
    if stextsmax < 0 as libc::c_int {
        stextsmax = 0 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn WitchSellOk(mut i: libc::c_int) -> bool32_t {
    let mut rv: bool32_t = 0;
    let mut pI: *mut ItemStruct = 0 as *mut ItemStruct;
    rv = 0 as libc::c_int as bool32_t;
    if i >= 0 as libc::c_int {
        pI = &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvList)
            .as_mut_ptr()
            .offset(i as isize) as *mut ItemStruct;
    } else {
        pI = &mut *((*plr.as_mut_ptr().offset(myplr as isize)).SpdList)
            .as_mut_ptr()
            .offset(-(i + 1 as libc::c_int) as isize) as *mut ItemStruct;
    }
    if (*pI)._itype == IT_MISC as libc::c_int {
        rv = 1 as libc::c_int as bool32_t;
    }
    if (*pI)._itype == IT_STAFF as libc::c_int {
        rv = 1 as libc::c_int as bool32_t;
    }
    if (*pI).IDidx >= IDI_FIRSTQUEST as libc::c_int
        && (*pI).IDidx <= IDI_LASTQUEST as libc::c_int
    {
        rv = 0 as libc::c_int as bool32_t;
    }
    if (*pI).IDidx == IDI_LAZSTAFF as libc::c_int {
        rv = 0 as libc::c_int as bool32_t;
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn S_StartWSell() {
    let mut i: libc::c_int = 0;
    let mut sellok: bool32_t = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    sellok = 0 as libc::c_int as bool32_t;
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXHOLDITEMS as libc::c_int {
        storehold[i as usize]._itype = -(1 as libc::c_int);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < plr[myplr as usize]._pNumInv {
        if WitchSellOk(i) != 0 {
            sellok = 1 as libc::c_int as bool32_t;
            storehold[storenumh as usize] = plr[myplr as usize].InvList[i as usize];
            if storehold[storenumh as usize]._iMagical as libc::c_int != 0
                && storehold[storenumh as usize]._iIdentified != 0
            {
                storehold[storenumh as usize]
                    ._ivalue = storehold[storenumh as usize]._iIvalue;
            }
            storehold[storenumh as usize]
                ._ivalue = storehold[storenumh as usize]._ivalue >> 2 as libc::c_int;
            if storehold[storenumh as usize]._ivalue == 0 {
                storehold[storenumh as usize]._ivalue = 1 as libc::c_int;
            }
            storehold[storenumh as usize]
                ._iIvalue = storehold[storenumh as usize]._ivalue;
            storehidx[storenumh as usize] = i as int8_t;
            storenumh += 1;
            storenumh;
        }
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXSPD as libc::c_int {
        if plr[myplr as usize].SpdList[i as usize]._itype != -(1 as libc::c_int)
            && WitchSellOk(-(i + 1 as libc::c_int)) != 0
        {
            sellok = 1 as libc::c_int as bool32_t;
            storehold[storenumh as usize] = plr[myplr as usize].SpdList[i as usize];
            if storehold[storenumh as usize]._iMagical as libc::c_int != 0
                && storehold[storenumh as usize]._iIdentified != 0
            {
                storehold[storenumh as usize]
                    ._ivalue = storehold[storenumh as usize]._iIvalue;
            }
            storehold[storenumh as usize]
                ._ivalue = storehold[storenumh as usize]._ivalue >> 2 as libc::c_int;
            if storehold[storenumh as usize]._ivalue == 0 {
                storehold[storenumh as usize]._ivalue = 1 as libc::c_int;
            }
            storehold[storenumh as usize]
                ._iIvalue = storehold[storenumh as usize]._ivalue;
            storehidx[storenumh as usize] = -(i + 1 as libc::c_int) as int8_t;
            storenumh += 1;
            storenumh;
        }
        i += 1;
        i;
    }
    if sellok == 0 {
        stextscrl = 0 as libc::c_int as bool32_t;
        sprintf(
            tempstr.as_mut_ptr(),
            b"You have nothing I want.            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    } else {
        stextscrl = 1 as libc::c_int as bool32_t;
        stextsval = 0 as libc::c_int;
        stextsmax = plr[myplr as usize]._pNumInv;
        sprintf(
            tempstr.as_mut_ptr(),
            b"Which item is for sale?            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        S_ScrollSSell(stextsval);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn WitchRechargeOk(mut i: libc::c_int) -> bool32_t {
    let mut rv: bool32_t = 0;
    rv = 0 as libc::c_int as bool32_t;
    if plr[myplr as usize].InvList[i as usize]._itype == IT_STAFF as libc::c_int
        && plr[myplr as usize].InvList[i as usize]._iCharges
            != plr[myplr as usize].InvList[i as usize]._iMaxCharges
    {
        rv = 1 as libc::c_int as bool32_t;
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn AddStoreHoldRecharge(mut itm: ItemStruct, mut i: libc::c_int) {
    let mut v: libc::c_int = 0;
    storehold[storenumh as usize] = itm;
    storehold[storenumh as usize]._ivalue += spelldata[itm._iSpell as usize].sStaffCost;
    v = (storehold[storenumh as usize]._iMaxCharges
        - storehold[storenumh as usize]._iCharges) * 100 as libc::c_int
        / storehold[storenumh as usize]._iMaxCharges;
    storehold[storenumh as usize]
        ._ivalue = v * storehold[storenumh as usize]._ivalue / 100 as libc::c_int
        >> 1 as libc::c_int;
    storehold[storenumh as usize]._iIvalue = storehold[storenumh as usize]._ivalue;
    storehidx[storenumh as usize] = i as int8_t;
    storenumh += 1;
    storenumh;
}
#[no_mangle]
pub unsafe extern "C" fn S_StartWRecharge() {
    let mut i: libc::c_int = 0;
    let mut rechargeok: bool32_t = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    rechargeok = 0 as libc::c_int as bool32_t;
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXHOLDITEMS as libc::c_int {
        storehold[i as usize]._itype = -(1 as libc::c_int);
        i += 1;
        i;
    }
    if plr[myplr as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._itype
        == IT_STAFF as libc::c_int
        && plr[myplr as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iCharges
            != plr[myplr as usize]
                .InvBody[INVLOC_HAND1 as libc::c_int as usize]
                ._iMaxCharges
    {
        rechargeok = 1 as libc::c_int as bool32_t;
        AddStoreHoldRecharge(
            plr[myplr as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize],
            -(1 as libc::c_int),
        );
    }
    i = 0 as libc::c_int;
    while i < plr[myplr as usize]._pNumInv {
        if WitchRechargeOk(i) != 0 {
            rechargeok = 1 as libc::c_int as bool32_t;
            AddStoreHoldRecharge(plr[myplr as usize].InvList[i as usize], i);
        }
        i += 1;
        i;
    }
    if rechargeok == 0 {
        stextscrl = 0 as libc::c_int as bool32_t;
        sprintf(
            tempstr.as_mut_ptr(),
            b"You have nothing to recharge.            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    } else {
        stextscrl = 1 as libc::c_int as bool32_t;
        stextsval = 0 as libc::c_int;
        stextsmax = plr[myplr as usize]._pNumInv;
        sprintf(
            tempstr.as_mut_ptr(),
            b"Recharge which item?            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        S_ScrollSSell(stextsval);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_StartNoMoney() {
    StartStore(stextshold as int8_t);
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    ClearSText(5 as libc::c_int, 23 as libc::c_int);
    AddSText(
        0 as libc::c_int,
        14 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"You do not have enough gold\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
}
#[no_mangle]
pub unsafe extern "C" fn S_StartNoRoom() {
    StartStore(stextshold as int8_t);
    stextscrl = 0 as libc::c_int as bool32_t;
    ClearSText(5 as libc::c_int, 23 as libc::c_int);
    AddSText(
        0 as libc::c_int,
        14 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"You do not have enough room in inventory\0" as *const u8
            as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
}
#[no_mangle]
pub unsafe extern "C" fn S_StartConfirm() {
    let mut iclr: int8_t = 0;
    let mut idprint: bool32_t = 0;
    StartStore(stextshold as int8_t);
    stextscrl = 0 as libc::c_int as bool32_t;
    ClearSText(5 as libc::c_int, 23 as libc::c_int);
    iclr = ICOLOR_WHITE as libc::c_int as int8_t;
    if plr[myplr as usize].HoldItem._iMagical != 0 {
        iclr = ICOLOR_BLUE as libc::c_int as int8_t;
    }
    if plr[myplr as usize].HoldItem._iStatFlag == 0 {
        iclr = ICOLOR_RED as libc::c_int as int8_t;
    }
    if plr[myplr as usize].HoldItem._iMagical != 0 {
        idprint = 1 as libc::c_int as bool32_t;
    } else {
        idprint = 0 as libc::c_int as bool32_t;
    }
    if stextshold == STORE_STORYID as libc::c_int {
        idprint = 0 as libc::c_int as bool32_t;
    }
    if plr[myplr as usize].HoldItem._iMagical as libc::c_int != 0
        && plr[myplr as usize].HoldItem._iIdentified == 0
    {
        if stextshold == STORE_SSELL as libc::c_int {
            idprint = 0 as libc::c_int as bool32_t;
        }
        if stextshold == STORE_WSELL as libc::c_int {
            idprint = 0 as libc::c_int as bool32_t;
        }
        if stextshold == STORE_SREPAIR as libc::c_int {
            idprint = 0 as libc::c_int as bool32_t;
        }
        if stextshold == STORE_WRECHARGE as libc::c_int {
            idprint = 0 as libc::c_int as bool32_t;
        }
    }
    if idprint != 0 {
        AddSText(
            20 as libc::c_int,
            8 as libc::c_int,
            0 as libc::c_int as bool32_t,
            (plr[myplr as usize].HoldItem._iIName).as_mut_ptr(),
            iclr,
            0 as libc::c_int as bool32_t,
        );
    } else {
        AddSText(
            20 as libc::c_int,
            8 as libc::c_int,
            0 as libc::c_int as bool32_t,
            (plr[myplr as usize].HoldItem._iName).as_mut_ptr(),
            iclr,
            0 as libc::c_int as bool32_t,
        );
    }
    AddSTextVal(8 as libc::c_int, plr[myplr as usize].HoldItem._iIvalue);
    PrintStoreItem(
        &mut (*plr.as_mut_ptr().offset(myplr as isize)).HoldItem,
        9 as libc::c_int,
        iclr,
    );
    match stextshold {
        2 | 6 | 16 | 18 => {
            strcpy(
                tempstr.as_mut_ptr(),
                b"Are you sure you want to buy this item?\0" as *const u8
                    as *const libc::c_char,
            );
        }
        3 | 7 => {
            strcpy(
                tempstr.as_mut_ptr(),
                b"Are you sure you want to sell this item?\0" as *const u8
                    as *const libc::c_char,
            );
        }
        4 => {
            strcpy(
                tempstr.as_mut_ptr(),
                b"Are you sure you want to repair this item?\0" as *const u8
                    as *const libc::c_char,
            );
        }
        8 => {
            strcpy(
                tempstr.as_mut_ptr(),
                b"Are you sure you want to recharge this item?\0" as *const u8
                    as *const libc::c_char,
            );
        }
        13 => {
            strcpy(
                tempstr.as_mut_ptr(),
                b"Do we have a deal?\0" as *const u8 as *const libc::c_char,
            );
        }
        17 => {
            strcpy(
                tempstr.as_mut_ptr(),
                b"Are you sure you want to identify this item?\0" as *const u8
                    as *const libc::c_char,
            );
        }
        _ => {}
    }
    AddSText(
        0 as libc::c_int,
        15 as libc::c_int,
        1 as libc::c_int as bool32_t,
        tempstr.as_mut_ptr(),
        ICOLOR_WHITE as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Yes\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        20 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"No\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
}
#[no_mangle]
pub unsafe extern "C" fn S_StartBoy() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    AddSText(
        0 as libc::c_int,
        2 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Wirt the Peg-legged boy\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
    if boyitem._itype != -(1 as libc::c_int) {
        AddSText(
            0 as libc::c_int,
            8 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Talk to Wirt\0" as *const u8 as *const libc::c_char,
            ICOLOR_BLUE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        AddSText(
            0 as libc::c_int,
            12 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"I have something for sale,\0" as *const u8 as *const libc::c_char,
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSText(
            0 as libc::c_int,
            14 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"but it will cost 50 gold\0" as *const u8 as *const libc::c_char,
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSText(
            0 as libc::c_int,
            16 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"just to take a look. \0" as *const u8 as *const libc::c_char,
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSText(
            0 as libc::c_int,
            18 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"What have you got?\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        AddSText(
            0 as libc::c_int,
            20 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Say goodbye\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
    } else {
        AddSText(
            0 as libc::c_int,
            12 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Talk to Wirt\0" as *const u8 as *const libc::c_char,
            ICOLOR_BLUE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        AddSText(
            0 as libc::c_int,
            18 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Say goodbye\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_StartBBoy() {
    let mut iclr: libc::c_int = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    sprintf(
        tempstr.as_mut_ptr(),
        b"I have this item for sale :           Your gold : %d\0" as *const u8
            as *const libc::c_char,
        plr[myplr as usize]._pGold,
    );
    AddSText(
        0 as libc::c_int,
        1 as libc::c_int,
        1 as libc::c_int as bool32_t,
        tempstr.as_mut_ptr(),
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSLine(3 as libc::c_int);
    AddSLine(21 as libc::c_int);
    iclr = ICOLOR_WHITE as libc::c_int;
    if boyitem._iMagical != 0 {
        iclr = ICOLOR_BLUE as libc::c_int;
    }
    if boyitem._iStatFlag == 0 {
        iclr = ICOLOR_RED as libc::c_int;
    }
    if boyitem._iMagical != 0 {
        AddSText(
            20 as libc::c_int,
            10 as libc::c_int,
            0 as libc::c_int as bool32_t,
            (boyitem._iIName).as_mut_ptr(),
            iclr as int8_t,
            1 as libc::c_int as bool32_t,
        );
    } else {
        AddSText(
            20 as libc::c_int,
            10 as libc::c_int,
            0 as libc::c_int as bool32_t,
            (boyitem._iName).as_mut_ptr(),
            iclr as int8_t,
            1 as libc::c_int as bool32_t,
        );
    }
    AddSTextVal(
        10 as libc::c_int,
        boyitem._iIvalue + (boyitem._iIvalue >> 1 as libc::c_int),
    );
    PrintStoreItem(&mut boyitem, 11 as libc::c_int, iclr as int8_t);
    AddSText(
        0 as libc::c_int,
        22 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Leave\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn S_StartHealer() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    AddSText(
        0 as libc::c_int,
        1 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Welcome to the\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        3 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Healer's home\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        9 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Would you like to:\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        12 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Talk to Pepin\0" as *const u8 as *const libc::c_char,
        ICOLOR_BLUE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        14 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Receive healing\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        16 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Buy items\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Leave Healer's home\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
    storenumh = 20 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn S_ScrollHBuy(mut idx: libc::c_int) {
    let mut l: libc::c_int = 0;
    let mut ls: libc::c_int = 0;
    let mut iclr: int8_t = 0;
    ClearSText(5 as libc::c_int, 21 as libc::c_int);
    stextup = 5 as libc::c_int;
    l = 5 as libc::c_int;
    while l < 20 as libc::c_int {
        if healitem[idx as usize]._itype != -(1 as libc::c_int) {
            ls = l;
            iclr = ICOLOR_WHITE as libc::c_int as int8_t;
            if healitem[idx as usize]._iStatFlag == 0 {
                iclr = ICOLOR_RED as libc::c_int as int8_t;
            }
            AddSText(
                20 as libc::c_int,
                l,
                0 as libc::c_int as bool32_t,
                (healitem[idx as usize]._iName).as_mut_ptr(),
                iclr,
                1 as libc::c_int as bool32_t,
            );
            AddSTextVal(l, healitem[idx as usize]._iIvalue);
            PrintStoreItem(
                &mut *healitem.as_mut_ptr().offset(idx as isize),
                l + 1 as libc::c_int,
                iclr,
            );
            stextdown = ls;
            idx += 1;
            idx;
        }
        l += 4 as libc::c_int;
    }
    if stext[stextsel as usize]._ssel == 0 && stextsel != 22 as libc::c_int {
        stextsel = stextdown;
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_StartHBuy() {
    let mut i: libc::c_int = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    stextscrl = 1 as libc::c_int as bool32_t;
    stextsval = 0 as libc::c_int;
    sprintf(
        tempstr.as_mut_ptr(),
        b"I have these items for sale :           Your gold : %d\0" as *const u8
            as *const libc::c_char,
        plr[myplr as usize]._pGold,
    );
    AddSText(
        0 as libc::c_int,
        1 as libc::c_int,
        1 as libc::c_int as bool32_t,
        tempstr.as_mut_ptr(),
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSLine(3 as libc::c_int);
    AddSLine(21 as libc::c_int);
    S_ScrollHBuy(stextsval);
    AddSText(
        0 as libc::c_int,
        22 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Back\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while healitem[i as usize]._itype != -(1 as libc::c_int) {
        storenumh += 1;
        storenumh;
        i += 1;
        i;
    }
    stextsmax = storenumh - 4 as libc::c_int;
    if stextsmax < 0 as libc::c_int {
        stextsmax = 0 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_StartStory() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    AddSText(
        0 as libc::c_int,
        2 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"The Town Elder\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        9 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Would you like to:\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        12 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Talk to Cain\0" as *const u8 as *const libc::c_char,
        ICOLOR_BLUE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        14 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Identify an item\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Say goodbye\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn IdItemOk(mut i: *mut ItemStruct) -> bool32_t {
    if (*i)._itype == -(1 as libc::c_int) {
        return 0 as libc::c_int as bool32_t;
    }
    if (*i)._iMagical as libc::c_int == IMAGIC_NONE as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if (*i)._iIdentified != 0 {
        return 0 as libc::c_int as bool32_t;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn AddStoreHoldId(mut itm: ItemStruct, mut i: libc::c_int) {
    storehold[storenumh as usize] = itm;
    storehold[storenumh as usize]._ivalue = STOREIDCOST as libc::c_int;
    storehold[storenumh as usize]._iIvalue = STOREIDCOST as libc::c_int;
    storehidx[storenumh as usize] = i as int8_t;
    storenumh += 1;
    storenumh;
}
#[no_mangle]
pub unsafe extern "C" fn S_StartSIdentify() {
    let mut i: libc::c_int = 0;
    let mut idok: bool32_t = 0;
    stextsize = STEXT_LARGE as libc::c_int as int8_t;
    idok = 0 as libc::c_int as bool32_t;
    storenumh = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXHOLDITEMS as libc::c_int {
        storehold[i as usize]._itype = -(1 as libc::c_int);
        i += 1;
        i;
    }
    if IdItemOk(
        &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
            .as_mut_ptr()
            .offset(INVLOC_HEAD as libc::c_int as isize),
    ) != 0
    {
        idok = 1 as libc::c_int as bool32_t;
        AddStoreHoldId(
            plr[myplr as usize].InvBody[INVLOC_HEAD as libc::c_int as usize],
            -(1 as libc::c_int),
        );
    }
    if IdItemOk(
        &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
            .as_mut_ptr()
            .offset(INVLOC_BODY as libc::c_int as isize),
    ) != 0
    {
        idok = 1 as libc::c_int as bool32_t;
        AddStoreHoldId(
            plr[myplr as usize].InvBody[INVLOC_BODY as libc::c_int as usize],
            -(2 as libc::c_int),
        );
    }
    if IdItemOk(
        &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
            .as_mut_ptr()
            .offset(INVLOC_HAND1 as libc::c_int as isize),
    ) != 0
    {
        idok = 1 as libc::c_int as bool32_t;
        AddStoreHoldId(
            plr[myplr as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize],
            -(3 as libc::c_int),
        );
    }
    if IdItemOk(
        &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
            .as_mut_ptr()
            .offset(INVLOC_HAND2 as libc::c_int as isize),
    ) != 0
    {
        idok = 1 as libc::c_int as bool32_t;
        AddStoreHoldId(
            plr[myplr as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize],
            -(4 as libc::c_int),
        );
    }
    if IdItemOk(
        &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
            .as_mut_ptr()
            .offset(INVLOC_RING1 as libc::c_int as isize),
    ) != 0
    {
        idok = 1 as libc::c_int as bool32_t;
        AddStoreHoldId(
            plr[myplr as usize].InvBody[INVLOC_RING1 as libc::c_int as usize],
            -(5 as libc::c_int),
        );
    }
    if IdItemOk(
        &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
            .as_mut_ptr()
            .offset(INVLOC_RING2 as libc::c_int as isize),
    ) != 0
    {
        idok = 1 as libc::c_int as bool32_t;
        AddStoreHoldId(
            plr[myplr as usize].InvBody[INVLOC_RING2 as libc::c_int as usize],
            -(6 as libc::c_int),
        );
    }
    if IdItemOk(
        &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvBody)
            .as_mut_ptr()
            .offset(INVLOC_NECK as libc::c_int as isize),
    ) != 0
    {
        idok = 1 as libc::c_int as bool32_t;
        AddStoreHoldId(
            plr[myplr as usize].InvBody[INVLOC_NECK as libc::c_int as usize],
            -(7 as libc::c_int),
        );
    }
    i = 0 as libc::c_int;
    while i < plr[myplr as usize]._pNumInv {
        if IdItemOk(
            &mut *((*plr.as_mut_ptr().offset(myplr as isize)).InvList)
                .as_mut_ptr()
                .offset(i as isize),
        ) != 0
        {
            idok = 1 as libc::c_int as bool32_t;
            AddStoreHoldId(plr[myplr as usize].InvList[i as usize], i);
        }
        i += 1;
        i;
    }
    if idok == 0 {
        stextscrl = 0 as libc::c_int as bool32_t;
        sprintf(
            tempstr.as_mut_ptr(),
            b"You have nothing to identify.            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    } else {
        stextscrl = 1 as libc::c_int as bool32_t;
        stextsval = 0 as libc::c_int;
        stextsmax = plr[myplr as usize]._pNumInv;
        sprintf(
            tempstr.as_mut_ptr(),
            b"Identify which item?            Your gold : %d\0" as *const u8
                as *const libc::c_char,
            plr[myplr as usize]._pGold,
        );
        AddSText(
            0 as libc::c_int,
            1 as libc::c_int,
            1 as libc::c_int as bool32_t,
            tempstr.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
            0 as libc::c_int as bool32_t,
        );
        AddSLine(3 as libc::c_int);
        AddSLine(21 as libc::c_int);
        S_ScrollSSell(stextsval);
        AddSText(
            0 as libc::c_int,
            22 as libc::c_int,
            1 as libc::c_int as bool32_t,
            b"Back\0" as *const u8 as *const libc::c_char,
            ICOLOR_WHITE as libc::c_int as int8_t,
            1 as libc::c_int as bool32_t,
        );
        OffsetSTextY(22 as libc::c_int, 6 as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_StartIdShow() {
    let mut iclr: int8_t = 0;
    StartStore(stextshold as int8_t);
    stextscrl = 0 as libc::c_int as bool32_t;
    ClearSText(5 as libc::c_int, 23 as libc::c_int);
    iclr = ICOLOR_WHITE as libc::c_int as int8_t;
    if plr[myplr as usize].HoldItem._iMagical != 0 {
        iclr = ICOLOR_BLUE as libc::c_int as int8_t;
    }
    if plr[myplr as usize].HoldItem._iStatFlag == 0 {
        iclr = ICOLOR_RED as libc::c_int as int8_t;
    }
    AddSText(
        0 as libc::c_int,
        7 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"This item is:\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        20 as libc::c_int,
        11 as libc::c_int,
        0 as libc::c_int as bool32_t,
        (plr[myplr as usize].HoldItem._iIName).as_mut_ptr(),
        iclr,
        0 as libc::c_int as bool32_t,
    );
    PrintStoreItem(
        &mut (*plr.as_mut_ptr().offset(myplr as isize)).HoldItem,
        12 as libc::c_int,
        iclr,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Done\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
}
#[no_mangle]
pub unsafe extern "C" fn S_StartTalk() {
    let mut i: libc::c_int = 0;
    let mut tq: libc::c_int = 0;
    let mut sn: libc::c_int = 0;
    let mut la: libc::c_int = 0;
    let mut gl: libc::c_int = 0;
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    sprintf(
        tempstr.as_mut_ptr(),
        b"Talk to %s\0" as *const u8 as *const libc::c_char,
        talkname[talker as usize],
    );
    AddSText(
        0 as libc::c_int,
        2 as libc::c_int,
        1 as libc::c_int as bool32_t,
        tempstr.as_mut_ptr(),
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
    tq = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXQUESTS as libc::c_int {
        if quests[i as usize]._qactive as libc::c_int == QUEST_NOTDONE as libc::c_int
            && Qtalklist[talker as usize][i as usize] != -(1 as libc::c_int)
            && quests[i as usize]._qlog != 0
        {
            tq += 1;
            tq;
        }
        i += 1;
        i;
    }
    if tq > 6 as libc::c_int {
        sn = 14 as libc::c_int - (tq >> 1 as libc::c_int);
        la = 1 as libc::c_int;
    } else {
        sn = 15 as libc::c_int - tq;
        la = 2 as libc::c_int;
    }
    gl = sn - 2 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXQUESTS as libc::c_int {
        if quests[i as usize]._qactive as libc::c_int == QUEST_NOTDONE as libc::c_int
            && Qtalklist[talker as usize][i as usize] != -(1 as libc::c_int)
            && quests[i as usize]._qlog != 0
        {
            AddSText(
                0 as libc::c_int,
                sn,
                1 as libc::c_int as bool32_t,
                questlist[i as usize]._qlstr,
                ICOLOR_WHITE as libc::c_int as int8_t,
                1 as libc::c_int as bool32_t,
            );
            sn += la;
        }
        i += 1;
        i;
    }
    AddSText(
        0 as libc::c_int,
        gl,
        1 as libc::c_int as bool32_t,
        b"Gossip\0" as *const u8 as *const libc::c_char,
        ICOLOR_BLUE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        22 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Back\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
}
#[no_mangle]
pub unsafe extern "C" fn S_StartTavern() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    AddSText(
        0 as libc::c_int,
        1 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Welcome to the\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        3 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Rising Sun\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        9 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Would you like to:\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        12 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Talk to Ogden\0" as *const u8 as *const libc::c_char,
        ICOLOR_BLUE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Leave the tavern\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
    storenumh = 20 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn S_StartBarMaid() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    AddSText(
        0 as libc::c_int,
        2 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Gillian\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        9 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Would you like to:\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        12 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Talk to Gillian\0" as *const u8 as *const libc::c_char,
        ICOLOR_BLUE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Say goodbye\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
    storenumh = 20 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn S_StartDrunk() {
    stextsize = STEXT_SMALL as libc::c_int as int8_t;
    stextscrl = 0 as libc::c_int as bool32_t;
    AddSText(
        0 as libc::c_int,
        2 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Farnham the Drunk\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        9 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Would you like to:\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        12 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Talk to Farnham\0" as *const u8 as *const libc::c_char,
        ICOLOR_BLUE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSText(
        0 as libc::c_int,
        18 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Say Goodbye\0" as *const u8 as *const libc::c_char,
        ICOLOR_WHITE as libc::c_int as int8_t,
        1 as libc::c_int as bool32_t,
    );
    AddSLine(5 as libc::c_int);
    storenumh = 20 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn StartStore(mut s: int8_t) {
    let mut i: libc::c_int = 0;
    sbookflag = 0 as libc::c_int as bool32_t;
    invflag = 0 as libc::c_int as bool32_t;
    chrflag = 0 as libc::c_int as bool32_t;
    questlog = 0 as libc::c_int as bool32_t;
    dropGoldFlag = 0 as libc::c_int as bool32_t;
    ClearSText(0 as libc::c_int, NUMSTLINES as libc::c_int);
    ReleaseStoreBtn();
    match s as libc::c_int {
        1 => {
            S_StartSmith();
        }
        2 => {
            if storenumh > 0 as libc::c_int {
                S_StartSBuy();
            }
        }
        3 => {
            S_StartSSell();
        }
        4 => {
            S_StartSRepair();
        }
        5 => {
            S_StartWitch();
        }
        6 => {
            if storenumh > 0 as libc::c_int {
                S_StartWBuy();
            }
        }
        7 => {
            S_StartWSell();
        }
        8 => {
            S_StartWRecharge();
        }
        9 => {
            S_StartNoMoney();
        }
        10 => {
            S_StartNoRoom();
        }
        11 => {
            S_StartConfirm();
        }
        12 => {
            S_StartBoy();
        }
        13 => {
            S_StartBBoy();
        }
        14 => {
            S_StartHealer();
        }
        15 => {
            S_StartStory();
        }
        16 => {
            if storenumh > 0 as libc::c_int {
                S_StartHBuy();
            }
        }
        17 => {
            S_StartSIdentify();
        }
        18 => {
            if S_StartSPBuy() == 0 {
                return;
            }
        }
        19 => {
            S_StartTalk();
        }
        20 => {
            S_StartIdShow();
        }
        21 => {
            S_StartTavern();
        }
        22 => {
            S_StartDrunk();
        }
        23 => {
            S_StartBarMaid();
        }
        _ => {}
    }
    i = 0 as libc::c_int;
    while i < NUMSTLINES as libc::c_int && stext[i as usize]._ssel == 0 {
        i += 1;
        i;
    }
    if i == NUMSTLINES as libc::c_int {
        stextsel = -(1 as libc::c_int);
    } else {
        stextsel = i;
    }
    stextflag = s;
    if s as libc::c_int == STORE_SBUY as libc::c_int && storenumh == 0 as libc::c_int {
        StartStore(STORE_SMITH as libc::c_int as int8_t);
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawSText() {
    let mut i: libc::c_int = 0;
    if stextsize as libc::c_int == STEXT_SMALL as libc::c_int {
        DrawSTextBack();
    } else {
        DrawQTextBack();
    }
    if stextscrl != 0 {
        match stextflag as libc::c_int {
            2 => {
                S_ScrollSBuy(stextsval);
            }
            18 => {
                S_ScrollSPBuy(stextsval);
            }
            3 | 4 | 7 | 8 | 17 => {
                S_ScrollSSell(stextsval);
            }
            6 => {
                S_ScrollWBuy(stextsval);
            }
            16 => {
                S_ScrollHBuy(stextsval);
            }
            _ => {}
        }
    }
    i = 0 as libc::c_int;
    while i < NUMSTLINES as libc::c_int {
        if stext[i as usize]._sline != 0 {
            DrawSLine(i);
        }
        if stext[i as usize]._sstr[0 as libc::c_int as usize] as libc::c_int
            != 0 as libc::c_int
        {
            PrintSString(
                stext[i as usize]._sx,
                i,
                stext[i as usize]._sjust,
                (stext[i as usize]._sstr).as_mut_ptr(),
                stext[i as usize]._sclr,
                stext[i as usize]._sval,
            );
        }
        i += 1;
        i;
    }
    if stextscrl != 0 {
        DrawScrlBar(4 as libc::c_int, 20 as libc::c_int);
    }
    stextspin = (stextspin & 0x7 as libc::c_int) + 1 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn STextESC() {
    if qtextflag != 0 {
        qtextflag = 0 as libc::c_int as uint8_t;
        if leveltype as libc::c_int == 0 as libc::c_int {
            stream_stop();
        }
        return;
    }
    match stextflag as libc::c_int {
        1 | 5 | 12 | 13 | 14 | 15 | 21 | 23 | 22 => {
            stextflag = STORE_NONE as libc::c_int as int8_t;
        }
        19 => {
            StartStore(stextshold as int8_t);
            stextsel = stextlhold;
        }
        2 => {
            StartStore(STORE_SMITH as libc::c_int as int8_t);
            stextsel = 12 as libc::c_int;
        }
        18 => {
            StartStore(STORE_SMITH as libc::c_int as int8_t);
            stextsel = 14 as libc::c_int;
        }
        3 => {
            StartStore(STORE_SMITH as libc::c_int as int8_t);
            stextsel = 16 as libc::c_int;
        }
        4 => {
            StartStore(STORE_SMITH as libc::c_int as int8_t);
            stextsel = 18 as libc::c_int;
        }
        6 => {
            StartStore(STORE_WITCH as libc::c_int as int8_t);
            stextsel = 14 as libc::c_int;
        }
        7 => {
            StartStore(STORE_WITCH as libc::c_int as int8_t);
            stextsel = 16 as libc::c_int;
        }
        8 => {
            StartStore(STORE_WITCH as libc::c_int as int8_t);
            stextsel = 18 as libc::c_int;
        }
        16 => {
            StartStore(STORE_HEALER as libc::c_int as int8_t);
            stextsel = 16 as libc::c_int;
        }
        17 => {
            StartStore(STORE_STORYTLR as libc::c_int as int8_t);
            stextsel = 14 as libc::c_int;
        }
        20 => {
            StartStore(STORE_STORYID as libc::c_int as int8_t);
        }
        9 | 10 | 11 => {
            StartStore(stextshold as int8_t);
            stextsel = stextlhold;
            stextsval = stextvhold;
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn STextUp() {
    PlaySFX(IS_TITLEMOV as libc::c_int);
    if stextsel != -(1 as libc::c_int) {
        if stextscrl != 0 {
            if stextsel == stextup {
                if stextsval != 0 as libc::c_int {
                    stextsval -= 1;
                    stextsval;
                }
            } else {
                stextsel -= 1;
                stextsel;
                while stext[stextsel as usize]._ssel == 0 {
                    if stextsel == 0 as libc::c_int {
                        stextsel = NUMSTLINES as libc::c_int - 1 as libc::c_int;
                    } else {
                        stextsel -= 1;
                        stextsel;
                    }
                }
            }
        } else {
            if stextsel == 0 as libc::c_int {
                stextsel = NUMSTLINES as libc::c_int - 1 as libc::c_int;
            } else {
                stextsel -= 1;
                stextsel;
            }
            while stext[stextsel as usize]._ssel == 0 {
                if stextsel == 0 as libc::c_int {
                    stextsel = NUMSTLINES as libc::c_int - 1 as libc::c_int;
                } else {
                    stextsel -= 1;
                    stextsel;
                }
            }
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn STextDown() {
    PlaySFX(IS_TITLEMOV as libc::c_int);
    if stextsel != -(1 as libc::c_int) {
        if stextscrl != 0 {
            if stextsel == stextdown {
                if stextsval < stextsmax {
                    stextsval += 1;
                    stextsval;
                }
            } else {
                stextsel += 1;
                stextsel;
                while stext[stextsel as usize]._ssel == 0 {
                    if stextsel == NUMSTLINES as libc::c_int - 1 as libc::c_int {
                        stextsel = 0 as libc::c_int;
                    } else {
                        stextsel += 1;
                        stextsel;
                    }
                }
            }
        } else {
            if stextsel == NUMSTLINES as libc::c_int - 1 as libc::c_int {
                stextsel = 0 as libc::c_int;
            } else {
                stextsel += 1;
                stextsel;
            }
            while stext[stextsel as usize]._ssel == 0 {
                if stextsel == NUMSTLINES as libc::c_int - 1 as libc::c_int {
                    stextsel = 0 as libc::c_int;
                } else {
                    stextsel += 1;
                    stextsel;
                }
            }
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn STextPgUp() {
    PlaySFX(IS_TITLEMOV as libc::c_int);
    if stextsel != -(1 as libc::c_int) && stextscrl != 0 {
        if stextsel == stextup {
            if stextsval != 0 as libc::c_int {
                stextsval -= 4 as libc::c_int;
            }
            if stextsval < 0 as libc::c_int {
                stextsval = 0 as libc::c_int;
            }
        } else {
            stextsel = stextup;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn STextPgDown() {
    PlaySFX(IS_TITLEMOV as libc::c_int);
    if stextsel != -(1 as libc::c_int) && stextscrl != 0 {
        if stextsel == stextdown {
            if stextsval < stextsmax {
                stextsval += 4 as libc::c_int;
            }
            if stextsval > stextsmax {
                stextsval = stextsmax;
            }
        } else {
            stextsel = stextdown;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_SmithEnter() {
    match stextsel {
        10 => {
            talker = TWN_BLKSMITH as libc::c_int;
            stextshold = STORE_SMITH as libc::c_int;
            stextlhold = 10 as libc::c_int;
            gossipstart = TXT_GRIS2 as libc::c_int;
            gossipend = TXT_GRIS13 as libc::c_int;
            StartStore(STORE_TALK as libc::c_int as int8_t);
        }
        12 => {
            StartStore(STORE_SBUY as libc::c_int as int8_t);
        }
        14 => {
            StartStore(STORE_SPBUY as libc::c_int as int8_t);
        }
        16 => {
            StartStore(STORE_SSELL as libc::c_int as int8_t);
        }
        18 => {
            StartStore(STORE_SREPAIR as libc::c_int as int8_t);
        }
        20 => {
            stextflag = STORE_NONE as libc::c_int as int8_t;
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn SetGoldCurs(mut pnum: libc::c_int, mut i: libc::c_int) {
    if plr[pnum as usize].InvList[i as usize]._ivalue >= GOLD_VT2 as libc::c_int {
        plr[pnum as usize].InvList[i as usize]._iCurs = ITEM_5GOLD as libc::c_int;
    } else if plr[pnum as usize].InvList[i as usize]._ivalue <= GOLD_VT1 as libc::c_int {
        plr[pnum as usize].InvList[i as usize]._iCurs = ITEM_1GOLD as libc::c_int;
    } else {
        plr[pnum as usize].InvList[i as usize]._iCurs = ITEM_3GOLD as libc::c_int;
    };
}
#[no_mangle]
pub unsafe extern "C" fn SetSpdbarGoldCurs(mut pnum: libc::c_int, mut i: libc::c_int) {
    if plr[pnum as usize].SpdList[i as usize]._ivalue >= GOLD_VT2 as libc::c_int {
        plr[pnum as usize].SpdList[i as usize]._iCurs = ITEM_5GOLD as libc::c_int;
    } else if plr[pnum as usize].SpdList[i as usize]._ivalue <= GOLD_VT1 as libc::c_int {
        plr[pnum as usize].SpdList[i as usize]._iCurs = ITEM_1GOLD as libc::c_int;
    } else {
        plr[pnum as usize].SpdList[i as usize]._iCurs = ITEM_3GOLD as libc::c_int;
    };
}
#[no_mangle]
pub unsafe extern "C" fn TakePlrsMoney(mut cost: int32_t) {
    let mut i: libc::c_int = 0;
    plr[myplr as usize]._pGold = CalculateGold(myplr) - cost;
    i = 0 as libc::c_int;
    while i < MAXSPD as libc::c_int && cost > 0 as libc::c_int {
        if plr[myplr as usize].SpdList[i as usize]._itype == IT_GOLD as libc::c_int
            && plr[myplr as usize].SpdList[i as usize]._ivalue
                != GOLD_VMAX as libc::c_int
        {
            if cost < plr[myplr as usize].SpdList[i as usize]._ivalue {
                plr[myplr as usize].SpdList[i as usize]._ivalue -= cost;
                SetSpdbarGoldCurs(myplr, i);
                cost = 0 as libc::c_int;
            } else {
                cost -= plr[myplr as usize].SpdList[i as usize]._ivalue;
                RemoveSpdBarItem(myplr, i);
                i = -(1 as libc::c_int);
            }
        }
        i += 1;
        i;
    }
    if cost > 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXSPD as libc::c_int && cost > 0 as libc::c_int {
            if plr[myplr as usize].SpdList[i as usize]._itype == IT_GOLD as libc::c_int {
                if cost < plr[myplr as usize].SpdList[i as usize]._ivalue {
                    plr[myplr as usize].SpdList[i as usize]._ivalue -= cost;
                    SetSpdbarGoldCurs(myplr, i);
                    cost = 0 as libc::c_int;
                } else {
                    cost -= plr[myplr as usize].SpdList[i as usize]._ivalue;
                    RemoveSpdBarItem(myplr, i);
                    i = -(1 as libc::c_int);
                }
            }
            i += 1;
            i;
        }
    }
    force_redraw = FULLDRAW as libc::c_int;
    if cost > 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < plr[myplr as usize]._pNumInv && cost > 0 as libc::c_int {
            if plr[myplr as usize].InvList[i as usize]._itype == IT_GOLD as libc::c_int
                && plr[myplr as usize].InvList[i as usize]._ivalue
                    != GOLD_VMAX as libc::c_int
            {
                if cost < plr[myplr as usize].InvList[i as usize]._ivalue {
                    plr[myplr as usize].InvList[i as usize]._ivalue -= cost;
                    SetGoldCurs(myplr, i);
                    cost = 0 as libc::c_int;
                } else {
                    cost -= plr[myplr as usize].InvList[i as usize]._ivalue;
                    RemoveInvItem(myplr, i);
                    i = -(1 as libc::c_int);
                }
            }
            i += 1;
            i;
        }
        if cost > 0 as libc::c_int {
            i = 0 as libc::c_int;
            while i < plr[myplr as usize]._pNumInv && cost > 0 as libc::c_int {
                if plr[myplr as usize].InvList[i as usize]._itype
                    == IT_GOLD as libc::c_int
                {
                    if cost < plr[myplr as usize].InvList[i as usize]._ivalue {
                        plr[myplr as usize].InvList[i as usize]._ivalue -= cost;
                        SetGoldCurs(myplr, i);
                        cost = 0 as libc::c_int;
                    } else {
                        cost -= plr[myplr as usize].InvList[i as usize]._ivalue;
                        RemoveInvItem(myplr, i);
                        i = -(1 as libc::c_int);
                    }
                }
                i += 1;
                i;
            }
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn SmithBuyItem() {
    let mut idx: libc::c_int = 0;
    TakePlrsMoney(plr[myplr as usize].HoldItem._iIvalue);
    if plr[myplr as usize].HoldItem._iMagical == 0 {
        plr[myplr as usize].HoldItem._iIdentified = 0 as libc::c_int as bool32_t;
    }
    StoreAutoPlace();
    idx = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    if idx == MAXSMITHITEMS as libc::c_int - 1 as libc::c_int {
        smithitem[idx as usize]._itype = -(1 as libc::c_int);
    } else {
        while smithitem[(idx + 1 as libc::c_int) as usize]._itype != -(1 as libc::c_int)
        {
            smithitem[idx as usize] = smithitem[(idx + 1 as libc::c_int) as usize];
            idx += 1;
            idx;
        }
        smithitem[idx as usize]._itype = -(1 as libc::c_int);
    }
    CalcPlrInv(myplr, 1 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn S_SBuyEnter() {
    let mut idx: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut done: bool32_t = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_SMITH as libc::c_int as int8_t);
        stextsel = 12 as libc::c_int;
    } else {
        stextshold = STORE_SBUY as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        idx = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        if plr[myplr as usize]._pGold < smithitem[idx as usize]._iIvalue {
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            plr[myplr as usize].HoldItem = smithitem[idx as usize];
            SetCursor_(plr[myplr as usize].HoldItem._iCurs + ICSTART as libc::c_int);
            done = 0 as libc::c_int as bool32_t;
            i = 0 as libc::c_int;
            while i < MAXINV as libc::c_int && done == 0 {
                done = AutoPlace(
                    myplr,
                    i,
                    cursW / 28 as libc::c_int,
                    cursH / 28 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                );
                i += 1;
                i;
            }
            if done != 0 {
                StartStore(STORE_CONFIRM as libc::c_int as int8_t);
            } else {
                StartStore(STORE_NOROOM as libc::c_int as int8_t);
            }
            SetCursor_(GLOVE_CURS as libc::c_int);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn SmithBuyPItem() {
    let mut idx: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    TakePlrsMoney(plr[myplr as usize].HoldItem._iIvalue);
    if plr[myplr as usize].HoldItem._iMagical == 0 {
        plr[myplr as usize].HoldItem._iIdentified = 0 as libc::c_int as bool32_t;
    }
    StoreAutoPlace();
    let mut xx: libc::c_int = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    idx = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while xx >= 0 as libc::c_int {
        if premiumitem[i as usize]._itype != -(1 as libc::c_int) {
            xx -= 1;
            xx;
            idx = i;
        }
        i += 1;
        i;
    }
    premiumitem[idx as usize]._itype = -(1 as libc::c_int);
    numpremium -= 1;
    numpremium;
    SpawnPremium(plr[myplr as usize]._pLevel as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn S_SPBuyEnter() {
    let mut idx: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut done: bool32_t = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_SMITH as libc::c_int as int8_t);
        stextsel = 14 as libc::c_int;
    } else {
        stextshold = STORE_SPBUY as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        let mut xx: libc::c_int = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        idx = 0 as libc::c_int;
        i = 0 as libc::c_int;
        while xx >= 0 as libc::c_int {
            if premiumitem[i as usize]._itype != -(1 as libc::c_int) {
                xx -= 1;
                xx;
                idx = i;
            }
            i += 1;
            i;
        }
        if plr[myplr as usize]._pGold < premiumitem[idx as usize]._iIvalue {
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            plr[myplr as usize].HoldItem = premiumitem[idx as usize];
            SetCursor_(plr[myplr as usize].HoldItem._iCurs + ICSTART as libc::c_int);
            done = 0 as libc::c_int as bool32_t;
            i = 0 as libc::c_int;
            while i < MAXINV as libc::c_int && done == 0 {
                done = AutoPlace(
                    myplr,
                    i,
                    cursW / 28 as libc::c_int,
                    cursH / 28 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                );
                i += 1;
                i;
            }
            if done != 0 {
                StartStore(STORE_CONFIRM as libc::c_int as int8_t);
            } else {
                StartStore(STORE_NOROOM as libc::c_int as int8_t);
            }
            SetCursor_(GLOVE_CURS as libc::c_int);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn StoreGoldFit(mut idx: libc::c_int) -> bool32_t {
    let mut sz: libc::c_int = 0;
    let mut numsqrs: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut cost: int32_t = 0;
    cost = storehold[idx as usize]._iIvalue;
    numsqrs = cost / GOLD_VMAX as libc::c_int;
    if cost % GOLD_VMAX as libc::c_int != 0 as libc::c_int {
        numsqrs += 1;
        numsqrs;
    }
    SetCursor_(storehold[idx as usize]._iCurs + ICSTART as libc::c_int);
    sz = cursW / 28 as libc::c_int * (cursH / 28 as libc::c_int);
    SetCursor_(GLOVE_CURS as libc::c_int);
    if sz >= numsqrs {
        return 1 as libc::c_int as bool32_t;
    }
    i = 0 as libc::c_int;
    while i < MAXINV as libc::c_int {
        if plr[myplr as usize].InvGrid[i as usize] as libc::c_int == 0 as libc::c_int {
            sz += 1;
            sz;
        }
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < plr[myplr as usize]._pNumInv {
        if plr[myplr as usize].InvList[i as usize]._itype == IT_GOLD as libc::c_int
            && plr[myplr as usize].InvList[i as usize]._ivalue
                != GOLD_VMAX as libc::c_int
        {
            if cost + plr[myplr as usize].InvList[i as usize]._ivalue
                <= GOLD_VMAX as libc::c_int
            {
                cost = 0 as libc::c_int;
            } else {
                cost
                    -= GOLD_VMAX as libc::c_int
                        - plr[myplr as usize].InvList[i as usize]._ivalue;
            }
        }
        i += 1;
        i;
    }
    numsqrs = cost / GOLD_VMAX as libc::c_int;
    if cost % GOLD_VMAX as libc::c_int != 0 as libc::c_int {
        numsqrs += 1;
        numsqrs;
    }
    if sz >= numsqrs {
        return 1 as libc::c_int as bool32_t
    } else {
        return 0 as libc::c_int as bool32_t
    };
}
#[no_mangle]
pub unsafe extern "C" fn PlaceStoreGold(mut v: int32_t) {
    let mut i: libc::c_int = 0;
    let mut ii: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    let mut done: bool32_t = 0;
    done = 0 as libc::c_int as bool32_t;
    ii = 0 as libc::c_int;
    while ii < MAXINV as libc::c_int && done == 0 {
        yy = ii / 10 as libc::c_int * 10 as libc::c_int;
        xx = ii % 10 as libc::c_int;
        if plr[myplr as usize].InvGrid[(xx + yy) as usize] as libc::c_int
            == 0 as libc::c_int
        {
            i = plr[myplr as usize]._pNumInv;
            GetGoldSeed(myplr, &mut golditem);
            plr[myplr as usize].InvList[i as usize] = golditem;
            plr[myplr as usize]._pNumInv += 1;
            plr[myplr as usize]._pNumInv;
            plr[myplr as usize]
                .InvGrid[(xx + yy) as usize] = plr[myplr as usize]._pNumInv as int8_t;
            plr[myplr as usize].InvList[i as usize]._ivalue = v;
            SetGoldCurs(myplr, i);
            done = 1 as libc::c_int as bool32_t;
        }
        ii += 1;
        ii;
    }
}
#[no_mangle]
pub unsafe extern "C" fn StoreSellItem() {
    let mut idx: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut cost: int32_t = 0;
    idx = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    if storehidx[idx as usize] as libc::c_int >= 0 as libc::c_int {
        RemoveInvItem(myplr, storehidx[idx as usize] as libc::c_int);
    } else {
        RemoveSpdBarItem(
            myplr,
            -(storehidx[idx as usize] as libc::c_int + 1 as libc::c_int),
        );
    }
    memset(
        &mut (*plr.as_mut_ptr().offset(myplr as isize)).HoldItem as *mut ItemStruct
            as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<ItemStruct>() as libc::c_ulong,
    );
    plr[myplr as usize].HoldItem._itype = -(1 as libc::c_int);
    cost = storehold[idx as usize]._iIvalue;
    storenumh -= 1;
    storenumh;
    if idx != storenumh {
        while idx < storenumh {
            storehold[idx as usize] = storehold[(idx + 1 as libc::c_int) as usize];
            storehidx[idx as usize] = storehidx[(idx + 1 as libc::c_int) as usize];
            idx += 1;
            idx;
        }
    }
    plr[myplr as usize]._pGold += cost;
    i = 0 as libc::c_int;
    while i < plr[myplr as usize]._pNumInv && cost > 0 as libc::c_int {
        if plr[myplr as usize].InvList[i as usize]._itype == IT_GOLD as libc::c_int
            && plr[myplr as usize].InvList[i as usize]._ivalue
                != GOLD_VMAX as libc::c_int
        {
            if cost + plr[myplr as usize].InvList[i as usize]._ivalue
                <= GOLD_VMAX as libc::c_int
            {
                plr[myplr as usize].InvList[i as usize]._ivalue += cost;
                SetGoldCurs(myplr, i);
                cost = 0 as libc::c_int;
            } else {
                cost
                    -= GOLD_VMAX as libc::c_int
                        - plr[myplr as usize].InvList[i as usize]._ivalue;
                plr[myplr as usize]
                    .InvList[i as usize]
                    ._ivalue = GOLD_VMAX as libc::c_int;
                SetGoldCurs(myplr, i);
            }
        }
        i += 1;
        i;
    }
    if cost > 0 as libc::c_int {
        while cost > GOLD_VMAX as libc::c_int {
            PlaceStoreGold(GOLD_VMAX as libc::c_int);
            cost -= GOLD_VMAX as libc::c_int;
        }
        PlaceStoreGold(cost);
    }
}
#[no_mangle]
pub unsafe extern "C" fn S_SSellEnter() {
    let mut idx: libc::c_int = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_SMITH as libc::c_int as int8_t);
        stextsel = 16 as libc::c_int;
    } else {
        stextshold = STORE_SSELL as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        idx = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        plr[myplr as usize].HoldItem = storehold[idx as usize];
        if StoreGoldFit(idx) != 0 {
            StartStore(STORE_CONFIRM as libc::c_int as int8_t);
        } else {
            StartStore(STORE_NOROOM as libc::c_int as int8_t);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn SmithRepairItem() {
    let mut i: libc::c_int = 0;
    let mut idx: libc::c_int = 0;
    TakePlrsMoney(plr[myplr as usize].HoldItem._iIvalue);
    idx = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    storehold[idx as usize]._iDurability = storehold[idx as usize]._iMaxDur;
    i = storehidx[idx as usize] as libc::c_int;
    if i < 0 as libc::c_int {
        if i == -(1 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_HEAD as libc::c_int as usize]
                ._iDurability = plr[myplr as usize]
                .InvBody[INVLOC_HEAD as libc::c_int as usize]
                ._iMaxDur;
        }
        if i == -(2 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_BODY as libc::c_int as usize]
                ._iDurability = plr[myplr as usize]
                .InvBody[INVLOC_BODY as libc::c_int as usize]
                ._iMaxDur;
        }
        if i == -(3 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_HAND1 as libc::c_int as usize]
                ._iDurability = plr[myplr as usize]
                .InvBody[INVLOC_HAND1 as libc::c_int as usize]
                ._iMaxDur;
        }
        if i == -(4 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_HAND2 as libc::c_int as usize]
                ._iDurability = plr[myplr as usize]
                .InvBody[INVLOC_HAND2 as libc::c_int as usize]
                ._iMaxDur;
        }
    } else {
        plr[myplr as usize]
            .InvList[i as usize]
            ._iDurability = plr[myplr as usize].InvList[i as usize]._iMaxDur;
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_SRepairEnter() {
    let mut idx: libc::c_int = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_SMITH as libc::c_int as int8_t);
        stextsel = 18 as libc::c_int;
    } else {
        stextshold = STORE_SREPAIR as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        idx = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        plr[myplr as usize].HoldItem = storehold[idx as usize];
        if plr[myplr as usize]._pGold < storehold[idx as usize]._iIvalue {
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            StartStore(STORE_CONFIRM as libc::c_int as int8_t);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_WitchEnter() {
    match stextsel {
        12 => {
            talker = TWN_WITCH as libc::c_int;
            stextshold = STORE_WITCH as libc::c_int;
            stextlhold = 12 as libc::c_int;
            gossipstart = TXT_ADRIA2 as libc::c_int;
            gossipend = TXT_ADRIA13 as libc::c_int;
            StartStore(STORE_TALK as libc::c_int as int8_t);
        }
        14 => {
            StartStore(STORE_WBUY as libc::c_int as int8_t);
        }
        16 => {
            StartStore(STORE_WSELL as libc::c_int as int8_t);
        }
        18 => {
            StartStore(STORE_WRECHARGE as libc::c_int as int8_t);
        }
        20 => {
            stextflag = STORE_NONE as libc::c_int as int8_t;
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn WitchBuyItem() {
    let mut idx: libc::c_int = 0;
    idx = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    if idx < 3 as libc::c_int {
        plr[myplr as usize]
            .HoldItem
            ._iSeed = GetRndSeed(
            b"src/stores.c\0" as *const u8 as *const libc::c_char,
            2283 as libc::c_int,
        );
    }
    TakePlrsMoney(plr[myplr as usize].HoldItem._iIvalue);
    StoreAutoPlace();
    if idx < 3 as libc::c_int {
        CalcPlrInv(myplr, 1 as libc::c_int as bool32_t);
        return;
    }
    if idx == MAXWITCHITEMS as libc::c_int - 1 as libc::c_int {
        witchitem[idx as usize]._itype = -(1 as libc::c_int);
    } else {
        while witchitem[(idx + 1 as libc::c_int) as usize]._itype != -(1 as libc::c_int)
        {
            witchitem[idx as usize] = witchitem[(idx + 1 as libc::c_int) as usize];
            idx += 1;
            idx;
        }
        witchitem[idx as usize]._itype = -(1 as libc::c_int);
    }
    CalcPlrInv(myplr, 1 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn S_WBuyEnter() {
    let mut idx: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut done: bool32_t = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_WITCH as libc::c_int as int8_t);
        stextsel = 14 as libc::c_int;
    } else {
        stextshold = STORE_WBUY as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        idx = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        if plr[myplr as usize]._pGold < witchitem[idx as usize]._iIvalue {
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            plr[myplr as usize].HoldItem = witchitem[idx as usize];
            SetCursor_(plr[myplr as usize].HoldItem._iCurs + ICSTART as libc::c_int);
            done = 0 as libc::c_int as bool32_t;
            i = 0 as libc::c_int;
            while i < MAXINV as libc::c_int && done == 0 {
                done = SpecialAutoPlace(
                    myplr,
                    i,
                    cursW / 28 as libc::c_int,
                    cursH / 28 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                );
                i += 1;
                i;
            }
            if done != 0 {
                StartStore(STORE_CONFIRM as libc::c_int as int8_t);
            } else {
                StartStore(STORE_NOROOM as libc::c_int as int8_t);
            }
            SetCursor_(GLOVE_CURS as libc::c_int);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_WSellEnter() {
    let mut idx: libc::c_int = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_WITCH as libc::c_int as int8_t);
        stextsel = 16 as libc::c_int;
    } else {
        stextshold = STORE_WSELL as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        idx = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        plr[myplr as usize].HoldItem = storehold[idx as usize];
        if StoreGoldFit(idx) != 0 {
            StartStore(STORE_CONFIRM as libc::c_int as int8_t);
        } else {
            StartStore(STORE_NOROOM as libc::c_int as int8_t);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn WitchRechargeItem() {
    let mut i: libc::c_int = 0;
    let mut idx: libc::c_int = 0;
    TakePlrsMoney(plr[myplr as usize].HoldItem._iIvalue);
    idx = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    storehold[idx as usize]._iCharges = storehold[idx as usize]._iMaxCharges;
    i = storehidx[idx as usize] as libc::c_int;
    if i < 0 as libc::c_int {
        plr[myplr as usize]
            .InvBody[INVLOC_HAND1 as libc::c_int as usize]
            ._iCharges = plr[myplr as usize]
            .InvBody[INVLOC_HAND1 as libc::c_int as usize]
            ._iMaxCharges;
    } else {
        plr[myplr as usize]
            .InvList[i as usize]
            ._iCharges = plr[myplr as usize].InvList[i as usize]._iMaxCharges;
    }
    CalcPlrInv(myplr, 1 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn S_WRechargeEnter() {
    let mut idx: libc::c_int = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_WITCH as libc::c_int as int8_t);
        stextsel = 18 as libc::c_int;
    } else {
        stextshold = STORE_WRECHARGE as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        idx = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        plr[myplr as usize].HoldItem = storehold[idx as usize];
        if plr[myplr as usize]._pGold < storehold[idx as usize]._iIvalue {
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            StartStore(STORE_CONFIRM as libc::c_int as int8_t);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_BoyEnter() {
    if boyitem._itype != -(1 as libc::c_int) && stextsel == 18 as libc::c_int {
        if plr[myplr as usize]._pGold < 50 as libc::c_int {
            stextshold = STORE_BOY as libc::c_int;
            stextlhold = stextsel;
            stextvhold = stextsval;
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            TakePlrsMoney(50 as libc::c_int);
            StartStore(STORE_BBUY as libc::c_int as int8_t);
        }
    } else if stextsel == 8 as libc::c_int && boyitem._itype != -(1 as libc::c_int)
        || stextsel == 12 as libc::c_int && boyitem._itype == -(1 as libc::c_int)
    {
        talker = TWN_BOY as libc::c_int;
        stextshold = STORE_BOY as libc::c_int;
        stextlhold = stextsel;
        gossipstart = TXT_WIRT2 as libc::c_int;
        gossipend = TXT_WIRT12 as libc::c_int;
        StartStore(STORE_TALK as libc::c_int as int8_t);
    } else {
        stextflag = STORE_NONE as libc::c_int as int8_t;
    };
}
#[no_mangle]
pub unsafe extern "C" fn BoyBuyItem() {
    TakePlrsMoney(plr[myplr as usize].HoldItem._iIvalue);
    StoreAutoPlace();
    boyitem._itype = -(1 as libc::c_int);
    stextshold = STORE_BOY as libc::c_int;
    CalcPlrInv(myplr, 1 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn HealerBuyItem() {
    let mut idx: libc::c_int = 0;
    idx = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        if idx < 2 as libc::c_int {
            plr[myplr as usize]
                .HoldItem
                ._iSeed = GetRndSeed(
                b"src/stores.c\0" as *const u8 as *const libc::c_char,
                2446 as libc::c_int,
            );
        }
    } else if idx < 3 as libc::c_int {
        plr[myplr as usize]
            .HoldItem
            ._iSeed = GetRndSeed(
            b"src/stores.c\0" as *const u8 as *const libc::c_char,
            2450 as libc::c_int,
        );
    }
    TakePlrsMoney(plr[myplr as usize].HoldItem._iIvalue);
    if plr[myplr as usize].HoldItem._iMagical == 0 {
        plr[myplr as usize].HoldItem._iIdentified = 0 as libc::c_int as bool32_t;
    }
    StoreAutoPlace();
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        if idx < 2 as libc::c_int {
            return;
        }
    } else if idx < 3 as libc::c_int {
        return
    }
    idx = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    if idx == MAXHEALITEMS as libc::c_int - 1 as libc::c_int {
        healitem[idx as usize]._itype = -(1 as libc::c_int);
    } else {
        while healitem[(idx + 1 as libc::c_int) as usize]._itype != -(1 as libc::c_int) {
            healitem[idx as usize] = healitem[(idx + 1 as libc::c_int) as usize];
            idx += 1;
            idx;
        }
        healitem[idx as usize]._itype = -(1 as libc::c_int);
    }
    CalcPlrInv(myplr, 1 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn S_BBuyEnter() {
    let mut i: libc::c_int = 0;
    let mut done: bool32_t = 0;
    if stextsel == 10 as libc::c_int {
        stextshold = STORE_BBUY as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        if plr[myplr as usize]._pGold
            < boyitem._iIvalue + (boyitem._iIvalue >> 1 as libc::c_int)
        {
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            plr[myplr as usize].HoldItem = boyitem;
            plr[myplr as usize].HoldItem._iIvalue
                += plr[myplr as usize].HoldItem._iIvalue >> 1 as libc::c_int;
            SetCursor_(plr[myplr as usize].HoldItem._iCurs + ICSTART as libc::c_int);
            done = 0 as libc::c_int as bool32_t;
            i = 0 as libc::c_int;
            while i < MAXINV as libc::c_int && done == 0 {
                done = AutoPlace(
                    myplr,
                    i,
                    cursW / 28 as libc::c_int,
                    cursH / 28 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                );
                i += 1;
                i;
            }
            if done != 0 {
                StartStore(STORE_CONFIRM as libc::c_int as int8_t);
            } else {
                StartStore(STORE_NOROOM as libc::c_int as int8_t);
            }
            SetCursor_(GLOVE_CURS as libc::c_int);
        }
    } else {
        stextflag = STORE_NONE as libc::c_int as int8_t;
    };
}
#[no_mangle]
pub unsafe extern "C" fn StoryIdItem() {
    let mut i: libc::c_int = 0;
    let mut idx: libc::c_int = 0;
    idx = (stextlhold - stextup >> 2 as libc::c_int) + stextvhold;
    i = storehidx[idx as usize] as libc::c_int;
    if i < 0 as libc::c_int {
        if i == -(1 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_HEAD as libc::c_int as usize]
                ._iIdentified = 1 as libc::c_int as bool32_t;
        }
        if i == -(2 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_BODY as libc::c_int as usize]
                ._iIdentified = 1 as libc::c_int as bool32_t;
        }
        if i == -(3 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_HAND1 as libc::c_int as usize]
                ._iIdentified = 1 as libc::c_int as bool32_t;
        }
        if i == -(4 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_HAND2 as libc::c_int as usize]
                ._iIdentified = 1 as libc::c_int as bool32_t;
        }
        if i == -(5 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_RING1 as libc::c_int as usize]
                ._iIdentified = 1 as libc::c_int as bool32_t;
        }
        if i == -(6 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_RING2 as libc::c_int as usize]
                ._iIdentified = 1 as libc::c_int as bool32_t;
        }
        if i == -(7 as libc::c_int) {
            plr[myplr as usize]
                .InvBody[INVLOC_NECK as libc::c_int as usize]
                ._iIdentified = 1 as libc::c_int as bool32_t;
        }
    } else {
        plr[myplr as usize]
            .InvList[i as usize]
            ._iIdentified = 1 as libc::c_int as bool32_t;
    }
    plr[myplr as usize].HoldItem._iIdentified = 1 as libc::c_int as bool32_t;
    TakePlrsMoney(plr[myplr as usize].HoldItem._iIvalue);
    CalcPlrInv(myplr, 1 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn S_ConfirmEnter() {
    if stextsel == 18 as libc::c_int {
        match stextshold {
            2 => {
                SmithBuyItem();
            }
            18 => {
                SmithBuyPItem();
            }
            3 | 7 => {
                StoreSellItem();
            }
            4 => {
                SmithRepairItem();
            }
            6 => {
                WitchBuyItem();
            }
            8 => {
                WitchRechargeItem();
            }
            13 => {
                BoyBuyItem();
            }
            16 => {
                HealerBuyItem();
            }
            17 => {
                StoryIdItem();
                StartStore(STORE_IDSHOW as libc::c_int as int8_t);
                return;
            }
            _ => {}
        }
        StartStore(stextshold as int8_t);
    } else {
        StartStore(stextshold as int8_t);
        stextsel = stextlhold;
        stextsval = stextvhold;
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_HealerEnter() {
    match stextsel {
        12 => {
            talker = TWN_HEALER as libc::c_int;
            stextshold = STORE_HEALER as libc::c_int;
            stextlhold = 12 as libc::c_int;
            gossipstart = TXT_PEPIN2 as libc::c_int;
            gossipend = TXT_PEPIN11 as libc::c_int;
            StartStore(STORE_TALK as libc::c_int as int8_t);
        }
        14 => {
            if plr[myplr as usize]._pHitPoints != plr[myplr as usize]._pMaxHP {
                PlaySFX(IS_CAST8 as libc::c_int);
            }
            plr[myplr as usize]._pHitPoints = plr[myplr as usize]._pMaxHP;
            plr[myplr as usize]._pHPBase = plr[myplr as usize]._pMaxHPBase;
            drawhpflag = 1 as libc::c_int as bool32_t;
        }
        16 => {
            StartStore(STORE_HBUY as libc::c_int as int8_t);
        }
        18 => {
            stextflag = STORE_NONE as libc::c_int as int8_t;
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_HBuyEnter() {
    let mut idx: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut done: bool32_t = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_HEALER as libc::c_int as int8_t);
        stextsel = 16 as libc::c_int;
    } else {
        stextshold = STORE_HBUY as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        idx = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        if plr[myplr as usize]._pGold < healitem[idx as usize]._iIvalue {
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            plr[myplr as usize].HoldItem = healitem[idx as usize];
            SetCursor_(plr[myplr as usize].HoldItem._iCurs + ICSTART as libc::c_int);
            done = 0 as libc::c_int as bool32_t;
            i = 0 as libc::c_int;
            while i < MAXINV as libc::c_int && done == 0 {
                done = SpecialAutoPlace(
                    myplr,
                    i,
                    cursW / 28 as libc::c_int,
                    cursH / 28 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                );
                i += 1;
                i;
            }
            if done != 0 {
                StartStore(STORE_CONFIRM as libc::c_int as int8_t);
            } else {
                StartStore(STORE_NOROOM as libc::c_int as int8_t);
            }
            SetCursor_(GLOVE_CURS as libc::c_int);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_StoryEnter() {
    match stextsel {
        12 => {
            talker = TWN_TELLER as libc::c_int;
            stextshold = STORE_STORYTLR as libc::c_int;
            stextlhold = 12 as libc::c_int;
            gossipstart = TXT_STORY2 as libc::c_int;
            gossipend = TXT_STORY11 as libc::c_int;
            StartStore(STORE_TALK as libc::c_int as int8_t);
        }
        14 => {
            StartStore(STORE_STORYID as libc::c_int as int8_t);
        }
        18 => {
            stextflag = STORE_NONE as libc::c_int as int8_t;
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_SIDEnter() {
    let mut idx: libc::c_int = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(STORE_STORYTLR as libc::c_int as int8_t);
        stextsel = 14 as libc::c_int;
    } else {
        stextshold = STORE_STORYID as libc::c_int;
        stextlhold = stextsel;
        stextvhold = stextsval;
        idx = (stextsel - stextup >> 2 as libc::c_int) + stextsval;
        plr[myplr as usize].HoldItem = storehold[idx as usize];
        if plr[myplr as usize]._pGold < storehold[idx as usize]._iIvalue {
            StartStore(STORE_NOMONEY as libc::c_int as int8_t);
        } else {
            StartStore(STORE_CONFIRM as libc::c_int as int8_t);
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_TalkEnter() {
    let mut i: libc::c_int = 0;
    let mut tq: libc::c_int = 0;
    let mut sn: libc::c_int = 0;
    let mut la: libc::c_int = 0;
    if stextsel == 22 as libc::c_int {
        StartStore(stextshold as int8_t);
        stextsel = stextlhold;
    } else {
        tq = 0 as libc::c_int;
        i = 0 as libc::c_int;
        while i < MAXQUESTS as libc::c_int {
            if quests[i as usize]._qactive as libc::c_int == QUEST_NOTDONE as libc::c_int
                && Qtalklist[talker as usize][i as usize] != -(1 as libc::c_int)
                && quests[i as usize]._qlog != 0
            {
                tq += 1;
                tq;
            }
            i += 1;
            i;
        }
        if tq > 6 as libc::c_int {
            sn = 14 as libc::c_int - (tq >> 1 as libc::c_int);
            la = 1 as libc::c_int;
        } else {
            sn = 15 as libc::c_int - tq;
            la = 2 as libc::c_int;
        }
        if stextsel == sn - 2 as libc::c_int {
            SetRndSeed(
                b"src/stores.c\0" as *const u8 as *const libc::c_char,
                2719 as libc::c_int,
                towner[talker as usize]._tSeed,
            );
            let mut m: libc::c_int = random_(
                b"src/stores.c\0" as *const u8 as *const libc::c_char,
                2720 as libc::c_int,
                0 as libc::c_int as uint8_t,
                gossipend - gossipstart + 1 as libc::c_int,
            ) + gossipstart;
            InitQTextMsg(m);
        } else {
            i = 0 as libc::c_int;
            while i < MAXQUESTS as libc::c_int {
                if quests[i as usize]._qactive as libc::c_int
                    == QUEST_NOTDONE as libc::c_int
                    && Qtalklist[talker as usize][i as usize] != -(1 as libc::c_int)
                    && quests[i as usize]._qlog != 0
                {
                    if sn == stextsel {
                        InitQTextMsg(Qtalklist[talker as usize][i as usize]);
                    }
                    sn += la;
                }
                i += 1;
                i;
            }
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_TavernEnter() {
    match stextsel {
        12 => {
            talker = TWN_BAROWNER as libc::c_int;
            stextshold = STORE_TAVERN as libc::c_int;
            stextlhold = 12 as libc::c_int;
            gossipstart = TXT_OGDEN2 as libc::c_int;
            gossipend = TXT_OGDEN10 as libc::c_int;
            StartStore(STORE_TALK as libc::c_int as int8_t);
        }
        18 => {
            stextflag = STORE_NONE as libc::c_int as int8_t;
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_BarmaidEnter() {
    match stextsel {
        12 => {
            talker = TWN_BARMAID as libc::c_int;
            stextshold = STORE_BARMAID as libc::c_int;
            stextlhold = 12 as libc::c_int;
            gossipstart = TXT_GILIAN2 as libc::c_int;
            gossipend = TXT_GILIAN10 as libc::c_int;
            StartStore(STORE_TALK as libc::c_int as int8_t);
        }
        18 => {
            stextflag = STORE_NONE as libc::c_int as int8_t;
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn S_DrunkEnter() {
    match stextsel {
        12 => {
            talker = TWN_DRUNK as libc::c_int;
            stextshold = STORE_DRUNK as libc::c_int;
            stextlhold = 12 as libc::c_int;
            gossipstart = TXT_FARN2 as libc::c_int;
            gossipend = TXT_FARN13 as libc::c_int;
            StartStore(STORE_TALK as libc::c_int as int8_t);
        }
        18 => {
            stextflag = STORE_NONE as libc::c_int as int8_t;
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn STextEnter() {
    if qtextflag != 0 {
        qtextflag = 0 as libc::c_int as uint8_t;
        if leveltype as libc::c_int == 0 as libc::c_int {
            stream_stop();
        }
        return;
    }
    PlaySFX(IS_TITLSLCT as libc::c_int);
    match stextflag as libc::c_int {
        1 => {
            S_SmithEnter();
        }
        2 => {
            S_SBuyEnter();
        }
        18 => {
            S_SPBuyEnter();
        }
        3 => {
            S_SSellEnter();
        }
        4 => {
            S_SRepairEnter();
        }
        5 => {
            S_WitchEnter();
        }
        6 => {
            S_WBuyEnter();
        }
        7 => {
            S_WSellEnter();
        }
        8 => {
            S_WRechargeEnter();
        }
        9 | 10 => {
            StartStore(stextshold as int8_t);
            stextsel = stextlhold;
            stextsval = stextvhold;
        }
        11 => {
            S_ConfirmEnter();
        }
        12 => {
            S_BoyEnter();
        }
        13 => {
            S_BBuyEnter();
        }
        14 => {
            S_HealerEnter();
        }
        15 => {
            S_StoryEnter();
        }
        16 => {
            S_HBuyEnter();
        }
        17 => {
            S_SIDEnter();
        }
        19 => {
            S_TalkEnter();
        }
        20 => {
            StartStore(STORE_STORYID as libc::c_int as int8_t);
        }
        21 => {
            S_TavernEnter();
        }
        23 => {
            S_BarmaidEnter();
        }
        22 => {
            S_DrunkEnter();
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn CheckStoreBtn() {
    let mut y: libc::c_int = 0;
    if qtextflag != 0 {
        qtextflag = 0 as libc::c_int as uint8_t;
        if leveltype as libc::c_int == 0 as libc::c_int {
            stream_stop();
        }
        return;
    }
    if stextsel == -(1 as libc::c_int) {
        return;
    }
    if MouseY < 32 as libc::c_int || MouseY > 320 as libc::c_int {
        return;
    }
    if stextsize as libc::c_int == STEXT_SMALL as libc::c_int {
        if MouseX < 344 as libc::c_int || MouseX > 616 as libc::c_int {
            return;
        }
    } else if MouseX < 24 as libc::c_int || MouseX > 616 as libc::c_int {
        return
    }
    y = (MouseY - 32 as libc::c_int) / 12 as libc::c_int;
    if stextscrl != 0 && MouseX > 600 as libc::c_int {
        if y == 4 as libc::c_int {
            if stextscrlubtn as libc::c_int <= 0 as libc::c_int {
                STextUp();
                stextscrlubtn = 10 as libc::c_int as int8_t;
            } else {
                stextscrlubtn -= 1;
                stextscrlubtn;
            }
        }
        if y == 20 as libc::c_int {
            if stextscrldbtn as libc::c_int <= 0 as libc::c_int {
                STextDown();
                stextscrldbtn = 10 as libc::c_int as int8_t;
            } else {
                stextscrldbtn -= 1;
                stextscrldbtn;
            }
        }
    } else {
        if y < 5 as libc::c_int {
            return;
        }
        if y >= 23 as libc::c_int {
            y = 22 as libc::c_int;
        }
        if stextscrl != 0 && y < 21 as libc::c_int && stext[y as usize]._ssel == 0 {
            if stext[(y - 2 as libc::c_int) as usize]._ssel != 0 {
                y -= 2 as libc::c_int;
            } else if stext[(y - 1 as libc::c_int) as usize]._ssel != 0 {
                y -= 1;
                y;
            }
        }
        if stext[y as usize]._ssel != 0 || stextscrl != 0 && y == 22 as libc::c_int {
            stextsel = y;
            STextEnter();
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn ReleaseStoreBtn() {
    stextscrlubtn = -(1 as libc::c_int) as int8_t;
    stextscrldbtn = -(1 as libc::c_int) as int8_t;
}
