use ::libc;
extern "C" {
    fn NewCursor(i: libc::c_int);
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn gamemenu_off();
    fn RemoveScroll(_: libc::c_int);
    fn UseStaffCharge(_: libc::c_int);
    fn CalcPlrInv(_: libc::c_int, _: bool32_t);
    fn AddMissile(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: int8_t,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
    ) -> libc::c_int;
    fn GetSpellLevel(_: libc::c_int, _: libc::c_int) -> libc::c_int;
    fn ClrPlrPath(_: libc::c_int);
    fn PosOkPlayer(_: libc::c_int, _: libc::c_int, _: libc::c_int) -> bool32_t;
    fn SetPlayerHitPoints(pnum: libc::c_int, newhp: libc::c_int);
    fn StartStand(pnum: libc::c_int, dir: libc::c_int);
    static mut drawhpflag: bool32_t;
    static mut drawmanaflag: bool32_t;
    static mut curs: libc::c_int;
    static mut cheatflag: bool32_t;
    static mut currlevel: uint8_t;
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut dPlayer: [[int8_t; 112]; 112];
    static mut monster: [MonsterStruct; 200];
    static mut plrxoff2: [libc::c_int; 9];
    static mut plryoff2: [libc::c_int; 9];
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut deathflag: bool32_t;
    static mut spelldata: [SpellData; 37];
}
pub type C2RustUnnamed = libc::c_uint;
pub const CHEATS: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const MA_MAX: C2RustUnnamed_0 = 255;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const VIEW_CURSOR: C2RustUnnamed_1 = 1;
pub const ICSTART: C2RustUnnamed_1 = 12;
pub const WATCH_CURS: C2RustUnnamed_1 = 11;
pub const HEALOTHER_CURS: C2RustUnnamed_1 = 10;
pub const TARGET_CURS: C2RustUnnamed_1 = 9;
pub const RESURRECT_CURS: C2RustUnnamed_1 = 8;
pub const TELE_CURS: C2RustUnnamed_1 = 7;
pub const OIL_CURS: C2RustUnnamed_1 = 6;
pub const DISARM_CURS: C2RustUnnamed_1 = 5;
pub const RECHARGE_CURS: C2RustUnnamed_1 = 4;
pub const REPAIR_CURS: C2RustUnnamed_1 = 3;
pub const IDENTIFY_CURS: C2RustUnnamed_1 = 2;
pub const GLOVE_CURS: C2RustUnnamed_1 = 1;
pub const NO_CURSOR: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const MI_ENEMYBOTH: C2RustUnnamed_2 = 2;
pub const MI_ENEMYPLR: C2RustUnnamed_2 = 1;
pub const MI_ENEMYMONST: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const MIT_DIABAPOCA: C2RustUnnamed_3 = 67;
pub const MIT_FIREPLAR: C2RustUnnamed_3 = 66;
pub const MIT_RPORTAL: C2RustUnnamed_3 = 65;
pub const MIT_WEAPEXP: C2RustUnnamed_3 = 64;
pub const MIT_BONESPIRIT: C2RustUnnamed_3 = 63;
pub const MIT_RESURRECTBEAM: C2RustUnnamed_3 = 62;
pub const MIT_ELEMENT: C2RustUnnamed_3 = 61;
pub const MIT_HEALOTHER: C2RustUnnamed_3 = 60;
pub const MIT_ACIDPUD: C2RustUnnamed_3 = 59;
pub const MIT_ACIDSPLAT: C2RustUnnamed_3 = 58;
pub const MIT_ACID: C2RustUnnamed_3 = 57;
pub const MIT_LARROW: C2RustUnnamed_3 = 56;
pub const MIT_TELEKINESIS: C2RustUnnamed_3 = 55;
pub const MIT_RESURRECT: C2RustUnnamed_3 = 54;
pub const MIT_HBOLT: C2RustUnnamed_3 = 53;
pub const MIT_CBOLT: C2RustUnnamed_3 = 52;
pub const MIT_KRULL: C2RustUnnamed_3 = 51;
pub const MIT_FIREMAN: C2RustUnnamed_3 = 50;
pub const MIT_FLAMEC: C2RustUnnamed_3 = 49;
pub const MIT_FLAME: C2RustUnnamed_3 = 48;
pub const MIT_DISARM: C2RustUnnamed_3 = 47;
pub const MIT_RECHARGE: C2RustUnnamed_3 = 46;
pub const MIT_REPAIR: C2RustUnnamed_3 = 45;
pub const MIT_APOCA: C2RustUnnamed_3 = 44;
pub const MIT_BLDBOIL: C2RustUnnamed_3 = 43;
pub const MIT_NOVA: C2RustUnnamed_3 = 42;
pub const MIT_WAVE: C2RustUnnamed_3 = 41;
pub const MIT_IDENTIFY: C2RustUnnamed_3 = 40;
pub const MIT_INFRA: C2RustUnnamed_3 = 39;
pub const MIT_FIREWALLC: C2RustUnnamed_3 = 38;
pub const MIT_HEAL: C2RustUnnamed_3 = 37;
pub const MIT_BOOM: C2RustUnnamed_3 = 36;
pub const MIT_SPURT: C2RustUnnamed_3 = 35;
pub const MIT_ETHER: C2RustUnnamed_3 = 34;
pub const MIT_GOLEM: C2RustUnnamed_3 = 33;
pub const MIT_INVIS: C2RustUnnamed_3 = 32;
pub const MIT_BLOODR: C2RustUnnamed_3 = 31;
pub const MIT_STONE: C2RustUnnamed_3 = 30;
pub const MIT_FIREONLY: C2RustUnnamed_3 = 29;
pub const MIT_DOOM: C2RustUnnamed_3 = 28;
pub const MIT_FARROW: C2RustUnnamed_3 = 27;
pub const MIT_TELE: C2RustUnnamed_3 = 26;
pub const MIT_FLAREXP: C2RustUnnamed_3 = 25;
pub const MIT_FLARE: C2RustUnnamed_3 = 24;
pub const MIT_THINLIGHT: C2RustUnnamed_3 = 23;
pub const MIT_THINLIGHTCTRL: C2RustUnnamed_3 = 22;
pub const MIT_MAGMABALL: C2RustUnnamed_3 = 21;
pub const MIT_RHINO: C2RustUnnamed_3 = 20;
pub const MIT_METAL: C2RustUnnamed_3 = 19;
pub const MIT_BONE: C2RustUnnamed_3 = 18;
pub const MIT_BLOOD: C2RustUnnamed_3 = 17;
pub const MIT_CHAINBALL: C2RustUnnamed_3 = 16;
pub const MIT_CHAIN: C2RustUnnamed_3 = 15;
pub const MIT_FIREMOVE: C2RustUnnamed_3 = 14;
pub const MIT_MANASHIELD: C2RustUnnamed_3 = 13;
pub const MIT_FLASH2: C2RustUnnamed_3 = 12;
pub const MIT_FLASH: C2RustUnnamed_3 = 11;
pub const MIT_TOWN: C2RustUnnamed_3 = 10;
pub const MIT_MISEXP: C2RustUnnamed_3 = 9;
pub const MIT_LIGHTNING: C2RustUnnamed_3 = 8;
pub const MIT_LIGHTCTRL: C2RustUnnamed_3 = 7;
pub const MIT_FIREBALL: C2RustUnnamed_3 = 6;
pub const MIT_FIREWALL: C2RustUnnamed_3 = 5;
pub const MIT_LIGHTBALL: C2RustUnnamed_3 = 4;
pub const MIT_PHASE: C2RustUnnamed_3 = 3;
pub const MIT_GUARDIAN: C2RustUnnamed_3 = 2;
pub const MIT_FIREBOLT: C2RustUnnamed_3 = 1;
pub const MIT_ARROW: C2RustUnnamed_3 = 0;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
pub type C2RustUnnamed_4 = libc::c_uint;
pub const CLASS_SORCEROR: C2RustUnnamed_4 = 2;
pub const CLASS_ROGUE: C2RustUnnamed_4 = 1;
pub const CLASS_WARRIOR: C2RustUnnamed_4 = 0;
pub type C2RustUnnamed_5 = libc::c_int;
pub const PCMD_SPELLXYD: C2RustUnnamed_5 = 26;
pub const PCMD_SPELLPID: C2RustUnnamed_5 = 25;
pub const PCMD_SPELLID: C2RustUnnamed_5 = 24;
pub const PCMD_RATTACKPID: C2RustUnnamed_5 = 23;
pub const PCMD_RATTACKID: C2RustUnnamed_5 = 22;
pub const PCMD_ATTACKPID: C2RustUnnamed_5 = 21;
pub const PCMD_ATTACKID: C2RustUnnamed_5 = 20;
pub const PCMD_TELEK: C2RustUnnamed_5 = 18;
pub const PCMD_TALK: C2RustUnnamed_5 = 17;
pub const PCMD_REQAGETITEM: C2RustUnnamed_5 = 16;
pub const PCMD_REQGETITEM: C2RustUnnamed_5 = 15;
pub const PCMD_DISARM: C2RustUnnamed_5 = 14;
pub const PCMD_OPOBJ: C2RustUnnamed_5 = 13;
pub const PCMD_SPELL: C2RustUnnamed_5 = 12;
pub const PCMD_BLOCK: C2RustUnnamed_5 = 11;
pub const PCMD_RATTACK: C2RustUnnamed_5 = 10;
pub const PCMD_ATTACK: C2RustUnnamed_5 = 9;
pub const PCMD_WALKL: C2RustUnnamed_5 = 8;
pub const PCMD_WALKD: C2RustUnnamed_5 = 7;
pub const PCMD_WALKR: C2RustUnnamed_5 = 6;
pub const PCMD_WALKU: C2RustUnnamed_5 = 5;
pub const PCMD_WALKDL: C2RustUnnamed_5 = 4;
pub const PCMD_WALKDR: C2RustUnnamed_5 = 3;
pub const PCMD_WALKUL: C2RustUnnamed_5 = 2;
pub const PCMD_WALKUR: C2RustUnnamed_5 = 1;
pub const PCMD_STAND: C2RustUnnamed_5 = 0;
pub const PCMD_NOTHING: C2RustUnnamed_5 = -1;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const PM_QUIT: C2RustUnnamed_6 = 11;
pub const PM_NEWLVL: C2RustUnnamed_6 = 10;
pub const PM_SPELL: C2RustUnnamed_6 = 9;
pub const PM_DEATH: C2RustUnnamed_6 = 8;
pub const PM_GOTHIT: C2RustUnnamed_6 = 7;
pub const PM_BLOCK: C2RustUnnamed_6 = 6;
pub const PM_RATTACK: C2RustUnnamed_6 = 5;
pub const PM_ATTACK: C2RustUnnamed_6 = 4;
pub const PM_WALK3: C2RustUnnamed_6 = 3;
pub const PM_WALK2: C2RustUnnamed_6 = 2;
pub const PM_WALK: C2RustUnnamed_6 = 1;
pub const PM_STAND: C2RustUnnamed_6 = 0;
pub type C2RustUnnamed_7 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_7 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_7 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_7 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_7 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_7 = 32;
pub const MAXSPD: C2RustUnnamed_7 = 8;
pub const MAXINV: C2RustUnnamed_7 = 40;
pub const MAXPATHLEN: C2RustUnnamed_7 = 25;
pub const MANA_SHIFT: C2RustUnnamed_7 = 6;
pub const HP_SHIFT: C2RustUnnamed_7 = 6;
pub const NUM_CLASSES: C2RustUnnamed_7 = 3;
pub const MAXPACKLEN: C2RustUnnamed_7 = 256;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
pub const SPL_CBOLT: C2RustUnnamed_9 = 30;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SpellData {
    pub sName: uint8_t,
    pub sManaCost: uint8_t,
    pub sType: uint8_t,
    pub sNameText: *const libc::c_char,
    pub sSkillText: *const libc::c_char,
    pub sBookLvl: libc::c_int,
    pub sStaffLvl: libc::c_int,
    pub sTargeted: bool32_t,
    pub sTownSpell: bool32_t,
    pub sMinInt: libc::c_int,
    pub sSFX: uint8_t,
    pub sMissiles: [uint8_t; 3],
    pub sManaAdj: uint8_t,
    pub sMinMana: uint8_t,
    pub sStaffMin: libc::c_int,
    pub sStaffMax: libc::c_int,
    pub sBookCost: libc::c_int,
    pub sStaffCost: libc::c_int,
}
pub const SPL_RESURRECT: C2RustUnnamed_9 = 32;
pub const SPL_HEAL: C2RustUnnamed_9 = 2;
pub const SPL_HEALOTHER: C2RustUnnamed_9 = 34;
pub const SPL_FIREBOLT: C2RustUnnamed_9 = 1;
pub const SPT_MEMORIZED: C2RustUnnamed_10 = 1;
pub const SPT_ITEM: C2RustUnnamed_10 = 3;
pub const SPT_SCROLL: C2RustUnnamed_10 = 2;
pub const SPT_NONE: C2RustUnnamed_10 = 4;
pub const SPT_ABILITY: C2RustUnnamed_10 = 0;
pub const SPL_TOWN: C2RustUnnamed_9 = 7;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterStruct {
    pub _mMTidx: libc::c_int,
    pub _mmode: libc::c_int,
    pub _mgoal: uint8_t,
    pub _mgoalvar1: libc::c_int,
    pub _mgoalvar2: libc::c_int,
    pub _mgoalvar3: libc::c_int,
    pub _mgoalvar4: libc::c_int,
    pub _pathcount: uint8_t,
    pub _mx: libc::c_int,
    pub _my: libc::c_int,
    pub _mfutx: libc::c_int,
    pub _mfuty: libc::c_int,
    pub _moldx: libc::c_int,
    pub _moldy: libc::c_int,
    pub _mxoff: int32_t,
    pub _myoff: int32_t,
    pub _mxvel: int32_t,
    pub _myvel: int32_t,
    pub _mdir: libc::c_int,
    pub _menemy: libc::c_int,
    pub _menemyx: uint8_t,
    pub _menemyy: uint8_t,
    pub _mAnimData: *mut uint8_t,
    pub _mAnimDelay: libc::c_int,
    pub _mAnimCnt: libc::c_int,
    pub _mAnimLen: libc::c_int,
    pub _mAnimFrame: libc::c_int,
    pub _meflag: libc::c_int,
    pub _mDelFlag: bool32_t,
    pub _mVar1: int32_t,
    pub _mVar2: int32_t,
    pub _mVar3: int32_t,
    pub _mVar4: int32_t,
    pub _mVar5: int32_t,
    pub _mVar6: int32_t,
    pub _mVar7: int32_t,
    pub _mVar8: int32_t,
    pub _mmaxhp: int32_t,
    pub _mhitpoints: int32_t,
    pub _mAi: uint8_t,
    pub _mint: uint8_t,
    pub _mFlags: uint32_t,
    pub _msquelch: uint8_t,
    pub _mAFNum: libc::c_int,
    pub _lastx: libc::c_int,
    pub _lasty: libc::c_int,
    pub _mRndSeed: libc::c_int,
    pub _mAISeed: libc::c_int,
    pub _Wandering: bool32_t,
    pub _uniqtype: uint8_t,
    pub _uniqtrans: uint8_t,
    pub _udeadval: int8_t,
    pub mWhoHit: int8_t,
    pub mLevel: int8_t,
    pub mExp: uint16_t,
    pub mHit: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMagicRes: uint16_t,
    pub mtalkmsg: libc::c_int,
    pub leader: uint8_t,
    pub leaderflag: uint8_t,
    pub packsize: uint8_t,
    pub mlid: uint8_t,
    pub mName: *const libc::c_char,
    pub MType: *mut CMonster,
    pub MData: *mut MonsterData,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
pub const MI_MONST: C2RustUnnamed_8 = 1;
pub const SPL_WALL: C2RustUnnamed_9 = 6;
pub const MI_PLR: C2RustUnnamed_8 = 0;
pub type C2RustUnnamed_8 = libc::c_uint;
pub type C2RustUnnamed_9 = libc::c_uint;
pub const SPL_LAST: C2RustUnnamed_9 = 37;
pub const SPL_BONESPIRIT: C2RustUnnamed_9 = 36;
pub const SPL_BSTAR: C2RustUnnamed_9 = 35;
pub const SPL_TELEKINESIS: C2RustUnnamed_9 = 33;
pub const SPL_HBOLT: C2RustUnnamed_9 = 31;
pub const SPL_ELEMENT: C2RustUnnamed_9 = 29;
pub const SPL_DISARM: C2RustUnnamed_9 = 28;
pub const SPL_RECHARGE: C2RustUnnamed_9 = 27;
pub const SPL_REPAIR: C2RustUnnamed_9 = 26;
pub const SPL_ETHER: C2RustUnnamed_9 = 25;
pub const SPL_APOCA: C2RustUnnamed_9 = 24;
pub const SPL_TELE: C2RustUnnamed_9 = 23;
pub const SPL_BLOODB: C2RustUnnamed_9 = 22;
pub const SPL_GOLEM: C2RustUnnamed_9 = 21;
pub const SPL_FLAME: C2RustUnnamed_9 = 20;
pub const SPL_INVIS: C2RustUnnamed_9 = 19;
pub const SPL_NOVA: C2RustUnnamed_9 = 18;
pub const SPL_BLOODR: C2RustUnnamed_9 = 17;
pub const SPL_DOOM: C2RustUnnamed_9 = 16;
pub const SPL_WAVE: C2RustUnnamed_9 = 15;
pub const SPL_CHAIN: C2RustUnnamed_9 = 14;
pub const SPL_GUARDIAN: C2RustUnnamed_9 = 13;
pub const SPL_FIREBALL: C2RustUnnamed_9 = 12;
pub const SPL_MANASHLD: C2RustUnnamed_9 = 11;
pub const SPL_PHASE: C2RustUnnamed_9 = 10;
pub const SPL_INFRA: C2RustUnnamed_9 = 9;
pub const SPL_STONE: C2RustUnnamed_9 = 8;
pub const SPL_IDENTIFY: C2RustUnnamed_9 = 5;
pub const SPL_FLASH: C2RustUnnamed_9 = 4;
pub const SPL_LIGHTNING: C2RustUnnamed_9 = 3;
pub const SPL_NONE: C2RustUnnamed_9 = 0;
pub type C2RustUnnamed_10 = libc::c_uint;
#[no_mangle]
pub unsafe extern "C" fn GetManaAmount(
    mut id: libc::c_int,
    mut sn: libc::c_int,
) -> libc::c_int {
    let mut i: libc::c_int = 0;
    let mut sl: libc::c_int = 0;
    let mut ma: libc::c_int = 0;
    let mut adj: libc::c_int = 0;
    adj = 0 as libc::c_int;
    sl = plr[id as usize]._pSplLvl[sn as usize] as libc::c_int
        + plr[id as usize]._pISplLvlAdd as libc::c_int - 1 as libc::c_int;
    if sl < 0 as libc::c_int {
        sl = 0 as libc::c_int;
    }
    i = sl;
    while i > 0 as libc::c_int {
        adj += spelldata[sn as usize].sManaAdj as libc::c_int;
        i -= 1;
        i;
    }
    if sn == SPL_FIREBOLT as libc::c_int {
        adj = adj >> 1 as libc::c_int;
    }
    if sn == SPL_RESURRECT as libc::c_int && sl > 0 as libc::c_int {
        adj = 0 as libc::c_int;
        i = sl;
        while i > 0 as libc::c_int {
            adj += spelldata[sn as usize].sManaCost as libc::c_int >> 3 as libc::c_int;
            i -= 1;
            i;
        }
    }
    if spelldata[sn as usize].sManaCost as libc::c_int == MA_MAX as libc::c_int {
        ma = plr[id as usize]._pMaxManaBase as uint8_t as libc::c_int - adj
            << MANA_SHIFT as libc::c_int;
    } else {
        ma = spelldata[sn as usize].sManaCost as libc::c_int - adj
            << MANA_SHIFT as libc::c_int;
    }
    if sn == SPL_HEAL as libc::c_int {
        ma = ((plr[id as usize]._pLevel as libc::c_int) << 1 as libc::c_int)
            + spelldata[SPL_HEAL as libc::c_int as usize].sManaCost as libc::c_int - adj
            << MANA_SHIFT as libc::c_int;
    }
    if sn == SPL_HEALOTHER as libc::c_int {
        ma = ((plr[id as usize]._pLevel as libc::c_int) << 1 as libc::c_int)
            + spelldata[SPL_HEAL as libc::c_int as usize].sManaCost as libc::c_int - adj
            << MANA_SHIFT as libc::c_int;
    }
    if sn == SPL_RESURRECT as libc::c_int {
        adj = 0 as libc::c_int;
        i = sl;
        while i > 0 as libc::c_int {
            adj += spelldata[sn as usize].sManaCost as libc::c_int;
            i -= 1;
            i;
        }
    }
    if plr[id as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        ma -= ma >> 2 as libc::c_int;
    }
    if spelldata[sn as usize].sMinMana as libc::c_int > ma >> MANA_SHIFT as libc::c_int {
        ma = (spelldata[sn as usize].sMinMana as libc::c_int)
            << MANA_SHIFT as libc::c_int;
    }
    ma = ma * (100 as libc::c_int - plr[id as usize]._pISplCost as libc::c_int)
        / 100 as libc::c_int;
    return ma;
}
#[no_mangle]
pub unsafe extern "C" fn UseMana(mut id: libc::c_int, mut sn: libc::c_int) {
    let mut ma: libc::c_int = 0;
    let mut use_mana: bool32_t = 0;
    if id != myplr {
        return;
    }
    match plr[id as usize]._pSplType as libc::c_int {
        2 => {
            RemoveScroll(id);
        }
        3 => {
            UseStaffCharge(id);
        }
        1 => {
            use_mana = 1 as libc::c_int as bool32_t;
            if CHEATS as libc::c_int != 0 && cheatflag != 0 {
                use_mana = 0 as libc::c_int as bool32_t;
            }
            if use_mana != 0 {
                ma = GetManaAmount(id, sn);
                plr[id as usize]._pMana -= ma;
                plr[id as usize]._pManaBase -= ma;
                drawmanaflag = 1 as libc::c_int as bool32_t;
            }
        }
        0 | 4 | _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn CheckSpell(
    mut id: libc::c_int,
    mut sn: libc::c_int,
    mut st: int8_t,
    mut manaonly: bool32_t,
) -> bool32_t {
    let mut ma: libc::c_int = 0;
    if CHEATS as libc::c_int != 0 {
        if cheatflag != 0 {
            return 1 as libc::c_int as bool32_t;
        }
    }
    if manaonly == 0 && curs != GLOVE_CURS as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if st as libc::c_int == SPT_ABILITY as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    if GetSpellLevel(id, sn) <= 0 as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    ma = GetManaAmount(id, sn);
    if plr[id as usize]._pMana < ma {
        return 0 as libc::c_int as bool32_t;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn CastSpell(
    mut id: libc::c_int,
    mut spl: libc::c_int,
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut dx: libc::c_int,
    mut dy: libc::c_int,
    mut caster: libc::c_int,
    mut spllvl: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut dir: libc::c_int = 0;
    match caster {
        0 => {
            dir = plr[id as usize]._pdir;
            caster = MI_ENEMYMONST as libc::c_int;
            if spl == SPL_WALL as libc::c_int {
                dir = plr[id as usize]._pVar3;
            }
        }
        1 => {
            dir = monster[id as usize]._mdir;
        }
        _ => {}
    }
    i = 0 as libc::c_int;
    while spelldata[spl as usize].sMissiles[i as usize] as libc::c_int
        != 0 as libc::c_int && i < 3 as libc::c_int
    {
        AddMissile(
            sx,
            sy,
            dx,
            dy,
            dir,
            spelldata[spl as usize].sMissiles[i as usize] as libc::c_int,
            caster as int8_t,
            id,
            0 as libc::c_int,
            spllvl,
        );
        i += 1;
        i;
    }
    if spelldata[spl as usize].sMissiles[0 as libc::c_int as usize] as libc::c_int
        == MIT_TOWN as libc::c_int
    {
        UseMana(id, SPL_TOWN as libc::c_int);
    }
    if spelldata[spl as usize].sMissiles[0 as libc::c_int as usize] as libc::c_int
        == MIT_CBOLT as libc::c_int
    {
        UseMana(id, SPL_CBOLT as libc::c_int);
        i = (spllvl >> 1 as libc::c_int) + 3 as libc::c_int;
        while i > 0 as libc::c_int {
            AddMissile(
                sx,
                sy,
                dx,
                dy,
                dir,
                MIT_CBOLT as libc::c_int,
                caster as int8_t,
                id,
                0 as libc::c_int,
                spllvl,
            );
            i -= 1;
            i;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoResurrect(mut pnum: libc::c_int, mut rid: libc::c_int) {
    if rid as int8_t as libc::c_int != -(1 as libc::c_int) {
        AddMissile(
            plr[rid as usize]._px,
            plr[rid as usize]._py,
            plr[rid as usize]._px,
            plr[rid as usize]._py,
            0 as libc::c_int,
            MIT_RESURRECTBEAM as libc::c_int,
            MI_PLR as libc::c_int as int8_t,
            pnum,
            0 as libc::c_int,
            0 as libc::c_int,
        );
    }
    if pnum == myplr {
        NewCursor(GLOVE_CURS as libc::c_int);
    }
    if rid as int8_t as libc::c_int != -(1 as libc::c_int) {
        if plr[rid as usize]._pHitPoints != 0 as libc::c_int {
            return;
        }
        if rid == myplr {
            deathflag = 0 as libc::c_int as bool32_t;
            gamemenu_off();
            drawhpflag = 1 as libc::c_int as bool32_t;
            drawmanaflag = 1 as libc::c_int as bool32_t;
        }
        ClrPlrPath(rid);
        plr[rid as usize].destAction = PCMD_NOTHING as libc::c_int;
        plr[rid as usize]._pInvincible = 0 as libc::c_int as uint8_t;
        PlacePlayer(rid);
        let mut hp: libc::c_int = (10 as libc::c_int) << HP_SHIFT as libc::c_int;
        if plr[rid as usize]._pMaxHPBase < (10 as libc::c_int) << HP_SHIFT as libc::c_int
        {
            hp = plr[rid as usize]._pMaxHPBase;
        }
        SetPlayerHitPoints(rid, hp);
        plr[rid as usize]
            ._pHPBase = plr[rid as usize]._pHitPoints
            - (plr[rid as usize]._pMaxHP - plr[rid as usize]._pMaxHPBase);
        plr[rid as usize]._pMana = 0 as libc::c_int;
        plr[rid as usize]
            ._pManaBase = plr[rid as usize]._pMana
            - (plr[rid as usize]._pMaxMana - plr[rid as usize]._pMaxManaBase);
        CalcPlrInv(rid, 1 as libc::c_int as bool32_t);
        if plr[rid as usize].plrlevel == currlevel as libc::c_int {
            StartStand(rid, plr[rid as usize]._pdir);
        } else {
            plr[rid as usize]._pmode = PM_STAND as libc::c_int;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn PlacePlayer(mut pnum: libc::c_int) {
    if plr[pnum as usize].plrlevel == currlevel as libc::c_int {
        let mut nx: libc::c_int = 0;
        let mut ny: libc::c_int = 0;
        let mut i: libc::c_int = 0 as libc::c_int;
        while (i as libc::c_ulong)
            < (::core::mem::size_of::<[libc::c_int; 9]>() as libc::c_ulong)
                .wrapping_div(::core::mem::size_of::<libc::c_int>() as libc::c_ulong)
                .wrapping_sub(1 as libc::c_int as libc::c_ulong)
        {
            nx = plr[pnum as usize]._px + plrxoff2[i as usize];
            ny = plr[pnum as usize]._py + plryoff2[i as usize];
            if PosOkPlayer(pnum, nx, ny) != 0 {
                break;
            }
            i += 1;
            i;
        }
        if PosOkPlayer(pnum, nx, ny) == 0 {
            let mut done: bool32_t = 0 as libc::c_int as bool32_t;
            let mut max: libc::c_int = 0;
            let mut min: libc::c_int = 0;
            max = 1 as libc::c_int;
            min = -(1 as libc::c_int);
            while min > -(50 as libc::c_int) && done == 0 {
                let mut y: libc::c_int = min;
                while y <= max && done == 0 {
                    ny = plr[pnum as usize]._py + y;
                    let mut x: libc::c_int = min;
                    while x <= max && done == 0 {
                        nx = plr[pnum as usize]._px + x;
                        if PosOkPlayer(pnum, nx, ny) != 0 {
                            done = 1 as libc::c_int as bool32_t;
                        }
                        x += 1;
                        x;
                    }
                    y += 1;
                    y;
                }
                max += 1;
                max;
                min -= 1;
                min;
            }
        }
        plr[pnum as usize]._px = nx;
        plr[pnum as usize]._py = ny;
        dPlayer[nx as usize][ny as usize] = (pnum + 1 as libc::c_int) as int8_t;
        if pnum == myplr {
            ViewX = nx;
            ViewY = ny;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoHealOther(mut pnum: libc::c_int, mut rid: libc::c_int) {
    let mut i: libc::c_int = 0;
    let mut l: int32_t = 0;
    if pnum == myplr {
        NewCursor(GLOVE_CURS as libc::c_int);
    }
    if rid as int8_t as libc::c_int != -(1 as libc::c_int) {
        if plr[rid as usize]._pHitPoints >> HP_SHIFT as libc::c_int <= 0 as libc::c_int {
            return;
        }
        l = (random_(
            b"src/spells.c\0" as *const u8 as *const libc::c_char,
            281 as libc::c_int,
            57 as libc::c_int as uint8_t,
            10 as libc::c_int,
        ) + 1 as libc::c_int) << HP_SHIFT as libc::c_int;
        i = 0 as libc::c_int;
        while i < plr[pnum as usize]._pLevel as libc::c_int {
            l
                += (random_(
                    b"src/spells.c\0" as *const u8 as *const libc::c_char,
                    283 as libc::c_int,
                    57 as libc::c_int as uint8_t,
                    4 as libc::c_int,
                ) + 1 as libc::c_int) << HP_SHIFT as libc::c_int;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < GetSpellLevel(pnum, SPL_HEALOTHER as libc::c_int) {
            l
                += (random_(
                    b"src/spells.c\0" as *const u8 as *const libc::c_char,
                    286 as libc::c_int,
                    57 as libc::c_int as uint8_t,
                    6 as libc::c_int,
                ) + 1 as libc::c_int) << HP_SHIFT as libc::c_int;
            i += 1;
            i;
        }
        if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            l = l << 1 as libc::c_int;
        }
        if plr[pnum as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
            l += l >> 1 as libc::c_int;
        }
        plr[rid as usize]._pHitPoints += l;
        if plr[rid as usize]._pHitPoints > plr[rid as usize]._pMaxHP {
            plr[rid as usize]._pHitPoints = plr[rid as usize]._pMaxHP;
        }
        plr[rid as usize]._pHPBase += l;
        if plr[rid as usize]._pHPBase > plr[rid as usize]._pMaxHPBase {
            plr[rid as usize]._pHPBase = plr[rid as usize]._pMaxHPBase;
        }
        drawhpflag = 1 as libc::c_int as bool32_t;
    }
}
