use ::libc;
extern "C" {
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn SFileCloseFile(handle: HSFILE) -> bool32_t;
    fn SFileDdaEnd(handle: HSFILE) -> bool32_t;
    fn SFileDdaSetVolume(handle: HSFILE, volume: int32_t, pan: int32_t) -> bool32_t;
}
pub type C2RustUnnamed = libc::c_int;
pub const NUM_MUSIC: C2RustUnnamed = 6;
pub const VOLUME_TICKS: C2RustUnnamed = 17;
pub const VOLUME_STEP: C2RustUnnamed = 100;
pub const VOLUME_MAX: C2RustUnnamed = 0;
pub const VOLUME_MIN: C2RustUnnamed = -1600;
pub const VOLUME_READ: C2RustUnnamed = 1;
pub const DDA_BUF_SIZE: C2RustUnnamed = 262144;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int32_t = __int32_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_0 {
    pub unused: libc::c_int,
}
pub type HSFILE = *mut C2RustUnnamed_0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
static mut sglMusicVolume: int32_t = VOLUME_MAX as libc::c_int;
static mut sglSoundVolume: int32_t = VOLUME_MAX as libc::c_int;
static mut sgnMusicTrack: libc::c_int = NUM_MUSIC as libc::c_int;
static mut sghMusic: HSFILE = 0 as *const C2RustUnnamed_0 as HSFILE;
#[no_mangle]
pub unsafe extern "C" fn snd_update(mut bStopAll: bool32_t) {}
#[no_mangle]
pub unsafe extern "C" fn snd_stop_snd(mut pSnd: *mut TSnd) {}
#[no_mangle]
pub unsafe extern "C" fn snd_playing(mut pSnd: *mut TSnd) -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn snd_play_snd(
    mut pSnd: *mut TSnd,
    mut lVolume: int32_t,
    mut lPan: int32_t,
) {}
#[no_mangle]
pub unsafe extern "C" fn snd_load_snd(mut pszName: *const libc::c_char) -> *mut TSnd {
    return 0 as *mut TSnd;
}
#[no_mangle]
pub unsafe extern "C" fn snd_free_snd(mut pSnd: *mut TSnd) {}
#[no_mangle]
pub unsafe extern "C" fn snd_init() {}
#[no_mangle]
pub unsafe extern "C" fn snd_exit() {}
#[no_mangle]
pub unsafe extern "C" fn music_stop() {
    if !sghMusic.is_null() {
        SFileDdaEnd(sghMusic);
        SFileCloseFile(sghMusic);
        sghMusic = 0 as HSFILE;
        sgnMusicTrack = NUM_MUSIC as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn music_start(mut nTrack: libc::c_int) {}
#[no_mangle]
pub unsafe extern "C" fn music_pause(mut bPause: bool32_t) {
    if bPause != 0 {
        music_stop();
    } else if sgnMusicTrack != NUM_MUSIC as libc::c_int {
        music_start(sgnMusicTrack);
    }
}
#[no_mangle]
pub unsafe extern "C" fn music_volume(mut lVolume: int32_t) -> int32_t {
    if lVolume == VOLUME_READ as libc::c_int {
        return sglMusicVolume;
    }
    if !(lVolume >= VOLUME_MIN as libc::c_int) {
        assert_fail(
            420 as libc::c_int,
            b"src/sound.c\0" as *const u8 as *const libc::c_char,
            b"lVolume >= VOLUME_MIN\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(lVolume <= VOLUME_MAX as libc::c_int) {
        assert_fail(
            421 as libc::c_int,
            b"src/sound.c\0" as *const u8 as *const libc::c_char,
            b"lVolume <= VOLUME_MAX\0" as *const u8 as *const libc::c_char,
        );
    }
    sglMusicVolume = lVolume;
    if !sghMusic.is_null() {
        SFileDdaSetVolume(sghMusic, sglMusicVolume, 0 as libc::c_int);
    }
    return sglMusicVolume;
}
#[no_mangle]
pub unsafe extern "C" fn sound_volume(mut lVolume: int32_t) -> int32_t {
    if lVolume == VOLUME_READ as libc::c_int {
        return sglSoundVolume;
    }
    if !(lVolume >= VOLUME_MIN as libc::c_int) {
        assert_fail(
            435 as libc::c_int,
            b"src/sound.c\0" as *const u8 as *const libc::c_char,
            b"lVolume >= VOLUME_MIN\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(lVolume <= VOLUME_MAX as libc::c_int) {
        assert_fail(
            436 as libc::c_int,
            b"src/sound.c\0" as *const u8 as *const libc::c_char,
            b"lVolume <= VOLUME_MAX\0" as *const u8 as *const libc::c_char,
        );
    }
    sglSoundVolume = lVolume;
    return sglSoundVolume;
}
