use ::libc;
extern "C" {
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn LoadPreL1Dungeon(
        sFileName: *const libc::c_char,
        vx: libc::c_int,
        vy: libc::c_int,
    );
    fn LoadL1Dungeon(sFileName: *const libc::c_char, vx: libc::c_int, vy: libc::c_int);
    fn LoadL2Dungeon(sFileName: *const libc::c_char, vx: libc::c_int, vy: libc::c_int);
    fn LoadPreL2Dungeon(
        sFileName: *const libc::c_char,
        vx: libc::c_int,
        vy: libc::c_int,
    );
    fn LoadPreL3Dungeon(
        sFileName: *const libc::c_char,
        vx: libc::c_int,
        vy: libc::c_int,
    );
    fn LoadL3Dungeon(sFileName: *const libc::c_char, vx: libc::c_int, vy: libc::c_int);
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn DRLG_ListTrans(_: libc::c_int, _: *mut uint8_t);
    fn DRLG_AreaTrans(_: libc::c_int, _: *mut uint8_t);
    fn AddL1Objs(_: libc::c_int, _: libc::c_int, _: libc::c_int, _: libc::c_int);
    fn AddL2Objs(_: libc::c_int, _: libc::c_int, _: libc::c_int, _: libc::c_int);
    fn SetObjMapRange(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
    );
    fn LoadPalette(pszFileName: *const libc::c_char);
    fn InitSKingTriggers();
    fn InitSChambTriggers();
    fn InitPWaterTriggers();
    fn InitNoTriggers();
    static mut setlvlnum: uint8_t;
    static mut dTransVal: [[int8_t; 112]; 112];
    static mut object: [ObjectStruct; 127];
    static mut numobjects: int32_t;
    static mut objectactive: [libc::c_int; 127];
    static mut quests: [QuestStruct; 16];
}
pub type C2RustUnnamed = libc::c_uint;
pub const QS_VBRP4: C2RustUnnamed = 4;
pub const QS_VBRP3: C2RustUnnamed = 3;
pub const QS_VBRP2: C2RustUnnamed = 2;
pub const QS_VBRP1: C2RustUnnamed = 1;
pub const QS_VBRPOFF: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const Q_BETRAYER: C2RustUnnamed_0 = 15;
pub const Q_SCHAMB: C2RustUnnamed_0 = 14;
pub const Q_PWATER: C2RustUnnamed_0 = 13;
pub const Q_SKELKING: C2RustUnnamed_0 = 12;
pub const Q_WARLORD: C2RustUnnamed_0 = 11;
pub const Q_ANVIL: C2RustUnnamed_0 = 10;
pub const Q_BLOOD: C2RustUnnamed_0 = 9;
pub const Q_BLIND: C2RustUnnamed_0 = 8;
pub const Q_LTBANNER: C2RustUnnamed_0 = 7;
pub const Q_BUTCHER: C2RustUnnamed_0 = 6;
pub const Q_DIABLO: C2RustUnnamed_0 = 5;
pub const Q_VEIL: C2RustUnnamed_0 = 4;
pub const Q_ZHAR: C2RustUnnamed_0 = 3;
pub const Q_GARBUD: C2RustUnnamed_0 = 2;
pub const Q_BKMUSHRM: C2RustUnnamed_0 = 1;
pub const Q_ROCK: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const QUEST_DONE: C2RustUnnamed_1 = 3;
pub const QUEST_NOTDONE: C2RustUnnamed_1 = 2;
pub const QUEST_NOTACTIVE: C2RustUnnamed_1 = 1;
pub const QUEST_NOTAVAIL: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const SL_VILEBETRAYER: C2RustUnnamed_2 = 5;
pub const SL_POISONWATER: C2RustUnnamed_2 = 4;
pub const SL_MAZE: C2RustUnnamed_2 = 3;
pub const SL_BONECHAMB: C2RustUnnamed_2 = 2;
pub const SL_SKELKING: C2RustUnnamed_2 = 1;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ObjectStruct {
    pub _otype: libc::c_int,
    pub _ox: libc::c_int,
    pub _oy: libc::c_int,
    pub _oLight: bool32_t,
    pub _oAnimFlag: bool32_t,
    pub _oAnimData: *mut uint8_t,
    pub _oAnimDelay: libc::c_int,
    pub _oAnimCnt: libc::c_int,
    pub _oAnimLen: libc::c_int,
    pub _oAnimFrame: libc::c_int,
    pub _oAnimWidth: int32_t,
    pub _oAnimWidth2: int32_t,
    pub _oDelFlag: bool32_t,
    pub _oBreak: int8_t,
    pub _oSolidFlag: bool32_t,
    pub _oMissFlag: bool32_t,
    pub _oSelFlag: int8_t,
    pub _oPreFlag: bool32_t,
    pub _oTrapFlag: bool32_t,
    pub _oDoorFlag: bool32_t,
    pub _olid: libc::c_int,
    pub _oRndSeed: libc::c_int,
    pub _oVar1: int32_t,
    pub _oVar2: int32_t,
    pub _oVar3: int32_t,
    pub _oVar4: int32_t,
    pub _oVar5: int32_t,
    pub _oVar6: int32_t,
    pub _oVar7: int32_t,
    pub _oVar8: int32_t,
}
pub type C2RustUnnamed_3 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_3 = 32;
pub const MAXMICRO: C2RustUnnamed_3 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_3 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_3 = 64;
pub const MAXMREND: C2RustUnnamed_3 = 128;
pub const MAXTILES: C2RustUnnamed_3 = 2048;
pub const MDMAXY: C2RustUnnamed_3 = 40;
pub const MDMAXX: C2RustUnnamed_3 = 40;
pub const MAXDUNY: C2RustUnnamed_3 = 112;
pub const MAXDUNX: C2RustUnnamed_3 = 112;
pub const DMAXY: C2RustUnnamed_3 = 112;
pub const DMAXX: C2RustUnnamed_3 = 112;
pub const DIRTEDGED2: C2RustUnnamed_3 = 16;
pub const DIRTEDGE: C2RustUnnamed_3 = 32;
pub const NUMSLEVELS: C2RustUnnamed_3 = 10;
pub const NUMLEVELS: C2RustUnnamed_3 = 17;
pub const LVL4_START: C2RustUnnamed_3 = 13;
pub const LVL3_START: C2RustUnnamed_3 = 9;
pub const LVL2_START: C2RustUnnamed_3 = 5;
pub const LVL1_START: C2RustUnnamed_3 = 1;
pub const TLVL_START: C2RustUnnamed_3 = 0;
pub const LVLLENGTH: C2RustUnnamed_3 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct QuestStruct {
    pub _qlevel: uint8_t,
    pub _qtype: uint8_t,
    pub _qactive: uint8_t,
    pub _qlvltype: uint8_t,
    pub _qtx: libc::c_int,
    pub _qty: libc::c_int,
    pub _qslvl: uint8_t,
    pub _qidx: uint8_t,
    pub _qmsg: uint8_t,
    pub _qvar1: uint8_t,
    pub _qvar2: uint8_t,
    pub align_0011: [uint8_t; 3],
    pub _qlog: bool32_t,
}
static mut SkelKingTrans1: [uint8_t; 8] = [
    19 as libc::c_int as uint8_t,
    47 as libc::c_int as uint8_t,
    26 as libc::c_int as uint8_t,
    55 as libc::c_int as uint8_t,
    26 as libc::c_int as uint8_t,
    49 as libc::c_int as uint8_t,
    30 as libc::c_int as uint8_t,
    53 as libc::c_int as uint8_t,
];
static mut SkelKingTrans2: [uint8_t; 8] = [
    33 as libc::c_int as uint8_t,
    19 as libc::c_int as uint8_t,
    47 as libc::c_int as uint8_t,
    29 as libc::c_int as uint8_t,
    37 as libc::c_int as uint8_t,
    29 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    39 as libc::c_int as uint8_t,
];
static mut SkelKingTrans3: [uint8_t; 20] = [
    27 as libc::c_int as uint8_t,
    53 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    61 as libc::c_int as uint8_t,
    27 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    34 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
    45 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    53 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    45 as libc::c_int as uint8_t,
    53 as libc::c_int as uint8_t,
    53 as libc::c_int as uint8_t,
    61 as libc::c_int as uint8_t,
    31 as libc::c_int as uint8_t,
    39 as libc::c_int as uint8_t,
    49 as libc::c_int as uint8_t,
    57 as libc::c_int as uint8_t,
];
static mut SkelKingTrans4: [uint8_t; 28] = [
    49 as libc::c_int as uint8_t,
    45 as libc::c_int as uint8_t,
    58 as libc::c_int as uint8_t,
    51 as libc::c_int as uint8_t,
    57 as libc::c_int as uint8_t,
    31 as libc::c_int as uint8_t,
    62 as libc::c_int as uint8_t,
    37 as libc::c_int as uint8_t,
    63 as libc::c_int as uint8_t,
    31 as libc::c_int as uint8_t,
    69 as libc::c_int as uint8_t,
    40 as libc::c_int as uint8_t,
    59 as libc::c_int as uint8_t,
    41 as libc::c_int as uint8_t,
    73 as libc::c_int as uint8_t,
    55 as libc::c_int as uint8_t,
    63 as libc::c_int as uint8_t,
    55 as libc::c_int as uint8_t,
    69 as libc::c_int as uint8_t,
    65 as libc::c_int as uint8_t,
    73 as libc::c_int as uint8_t,
    45 as libc::c_int as uint8_t,
    78 as libc::c_int as uint8_t,
    51 as libc::c_int as uint8_t,
    79 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    89 as libc::c_int as uint8_t,
    53 as libc::c_int as uint8_t,
];
static mut SkelChamTrans1: [uint8_t; 20] = [
    43 as libc::c_int as uint8_t,
    19 as libc::c_int as uint8_t,
    50 as libc::c_int as uint8_t,
    26 as libc::c_int as uint8_t,
    51 as libc::c_int as uint8_t,
    19 as libc::c_int as uint8_t,
    59 as libc::c_int as uint8_t,
    26 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    27 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
    34 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    27 as libc::c_int as uint8_t,
    49 as libc::c_int as uint8_t,
    34 as libc::c_int as uint8_t,
    50 as libc::c_int as uint8_t,
    27 as libc::c_int as uint8_t,
    59 as libc::c_int as uint8_t,
    34 as libc::c_int as uint8_t,
];
static mut SkelChamTrans2: [uint8_t; 8] = [
    19 as libc::c_int as uint8_t,
    31 as libc::c_int as uint8_t,
    34 as libc::c_int as uint8_t,
    47 as libc::c_int as uint8_t,
    34 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
];
static mut SkelChamTrans3: [uint8_t; 36] = [
    43 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    50 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
    51 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    62 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
    63 as libc::c_int as uint8_t,
    31 as libc::c_int as uint8_t,
    66 as libc::c_int as uint8_t,
    46 as libc::c_int as uint8_t,
    67 as libc::c_int as uint8_t,
    31 as libc::c_int as uint8_t,
    78 as libc::c_int as uint8_t,
    34 as libc::c_int as uint8_t,
    67 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    78 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
    67 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    78 as libc::c_int as uint8_t,
    46 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
    51 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    49 as libc::c_int as uint8_t,
    51 as libc::c_int as uint8_t,
    50 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    59 as libc::c_int as uint8_t,
    51 as libc::c_int as uint8_t,
];
#[no_mangle]
pub unsafe extern "C" fn ObjIndex(
    mut x: libc::c_int,
    mut y: libc::c_int,
) -> libc::c_int {
    let mut i: libc::c_int = 0;
    let mut oi: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < numobjects {
        oi = objectactive[i as usize];
        if object[oi as usize]._ox == x && object[oi as usize]._oy == y {
            return oi;
        }
        i += 1;
        i;
    }
    app_fatal_(
        b"src/setmaps.c\0" as *const u8 as *const libc::c_char,
        82 as libc::c_int,
        b"ObjIndex: Active object not found at (%d,%d)\0" as *const u8
            as *const libc::c_char,
        x,
        y,
    );
    return -(1 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn AddSKingObjs() {
    SetObjMapRange(
        ObjIndex(64 as libc::c_int, 34 as libc::c_int),
        20 as libc::c_int,
        7 as libc::c_int,
        23 as libc::c_int,
        10 as libc::c_int,
        1 as libc::c_int,
    );
    SetObjMapRange(
        ObjIndex(64 as libc::c_int, 59 as libc::c_int),
        20 as libc::c_int,
        14 as libc::c_int,
        21 as libc::c_int,
        16 as libc::c_int,
        2 as libc::c_int,
    );
    SetObjMapRange(
        ObjIndex(27 as libc::c_int, 37 as libc::c_int),
        8 as libc::c_int,
        1 as libc::c_int,
        15 as libc::c_int,
        11 as libc::c_int,
        3 as libc::c_int,
    );
    SetObjMapRange(
        ObjIndex(46 as libc::c_int, 35 as libc::c_int),
        8 as libc::c_int,
        1 as libc::c_int,
        15 as libc::c_int,
        11 as libc::c_int,
        3 as libc::c_int,
    );
    SetObjMapRange(
        ObjIndex(49 as libc::c_int, 53 as libc::c_int),
        8 as libc::c_int,
        1 as libc::c_int,
        15 as libc::c_int,
        11 as libc::c_int,
        3 as libc::c_int,
    );
    SetObjMapRange(
        ObjIndex(27 as libc::c_int, 53 as libc::c_int),
        8 as libc::c_int,
        1 as libc::c_int,
        15 as libc::c_int,
        11 as libc::c_int,
        3 as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn AddSChamObjs() {
    SetObjMapRange(
        ObjIndex(37 as libc::c_int, 30 as libc::c_int),
        17 as libc::c_int,
        0 as libc::c_int,
        21 as libc::c_int,
        5 as libc::c_int,
        1 as libc::c_int,
    );
    SetObjMapRange(
        ObjIndex(37 as libc::c_int, 46 as libc::c_int),
        13 as libc::c_int,
        0 as libc::c_int,
        16 as libc::c_int,
        5 as libc::c_int,
        2 as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn AddVileObjs() {
    SetObjMapRange(
        ObjIndex(26 as libc::c_int, 45 as libc::c_int),
        1 as libc::c_int,
        1 as libc::c_int,
        9 as libc::c_int,
        10 as libc::c_int,
        1 as libc::c_int,
    );
    SetObjMapRange(
        ObjIndex(45 as libc::c_int, 46 as libc::c_int),
        11 as libc::c_int,
        1 as libc::c_int,
        20 as libc::c_int,
        10 as libc::c_int,
        2 as libc::c_int,
    );
    SetObjMapRange(
        ObjIndex(35 as libc::c_int, 36 as libc::c_int),
        7 as libc::c_int,
        11 as libc::c_int,
        13 as libc::c_int,
        18 as libc::c_int,
        3 as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_SetMapTrans(mut sFileName: *const libc::c_char) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut rw: libc::c_int = 0;
    let mut rh: libc::c_int = 0;
    let mut pLevelMap: *mut uint8_t = 0 as *mut uint8_t;
    let mut lm: *mut uint8_t = 0 as *mut uint8_t;
    let mut mapoff: int32_t = 0;
    pLevelMap = LoadFileInMem(sFileName, 0 as *mut uint32_t);
    lm = pLevelMap;
    rw = *lm as libc::c_int;
    lm = lm.offset(2 as libc::c_int as isize);
    rh = *lm as libc::c_int;
    mapoff = (rw * rh << 1 as libc::c_int) + 2 as libc::c_int;
    rw = rw << 1 as libc::c_int;
    rh = rh << 1 as libc::c_int;
    mapoff += (rw * rh << 1 as libc::c_int) * 3 as libc::c_int;
    lm = lm.offset(mapoff as isize);
    j = 0 as libc::c_int;
    while j < rh {
        i = 0 as libc::c_int;
        while i < rw {
            dTransVal[(i + DIRTEDGED2 as libc::c_int)
                as usize][(j + DIRTEDGED2 as libc::c_int) as usize] = *lm as int8_t;
            lm = lm.offset(2 as libc::c_int as isize);
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    let mut p__p: *mut libc::c_void = pLevelMap as *mut libc::c_void;
    pLevelMap = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
}
#[no_mangle]
pub unsafe extern "C" fn LoadSetMap() {
    match setlvlnum as libc::c_int {
        1 => {
            if quests[Q_SKELKING as libc::c_int as usize]._qactive as libc::c_int
                == QUEST_NOTACTIVE as libc::c_int
            {
                quests[Q_SKELKING as libc::c_int as usize]
                    ._qactive = QUEST_NOTDONE as libc::c_int as uint8_t;
                quests[Q_SKELKING as libc::c_int as usize]
                    ._qvar1 = 1 as libc::c_int as uint8_t;
            }
            LoadPreL1Dungeon(
                b"Levels\\L1Data\\SklKng1.DUN\0" as *const u8 as *const libc::c_char,
                83 as libc::c_int,
                45 as libc::c_int,
            );
            LoadL1Dungeon(
                b"Levels\\L1Data\\SklKng2.DUN\0" as *const u8 as *const libc::c_char,
                83 as libc::c_int,
                45 as libc::c_int,
            );
            LoadPalette(
                b"Levels\\L1Data\\L1_2.pal\0" as *const u8 as *const libc::c_char,
            );
            DRLG_AreaTrans(
                2 as libc::c_int,
                &mut *SkelKingTrans1.as_mut_ptr().offset(0 as libc::c_int as isize),
            );
            DRLG_ListTrans(
                2 as libc::c_int,
                &mut *SkelKingTrans2.as_mut_ptr().offset(0 as libc::c_int as isize),
            );
            DRLG_AreaTrans(
                5 as libc::c_int,
                &mut *SkelKingTrans3.as_mut_ptr().offset(0 as libc::c_int as isize),
            );
            DRLG_ListTrans(
                7 as libc::c_int,
                &mut *SkelKingTrans4.as_mut_ptr().offset(0 as libc::c_int as isize),
            );
            AddL1Objs(
                0 as libc::c_int,
                0 as libc::c_int,
                DMAXX as libc::c_int,
                DMAXY as libc::c_int,
            );
            AddSKingObjs();
            InitSKingTriggers();
        }
        2 => {
            LoadPreL2Dungeon(
                b"Levels\\L2Data\\Bonecha2.DUN\0" as *const u8 as *const libc::c_char,
                69 as libc::c_int,
                39 as libc::c_int,
            );
            LoadL2Dungeon(
                b"Levels\\L2Data\\Bonecha1.DUN\0" as *const u8 as *const libc::c_char,
                69 as libc::c_int,
                39 as libc::c_int,
            );
            LoadPalette(
                b"Levels\\L2Data\\L2_2.pal\0" as *const u8 as *const libc::c_char,
            );
            DRLG_ListTrans(
                5 as libc::c_int,
                &mut *SkelChamTrans1.as_mut_ptr().offset(0 as libc::c_int as isize),
            );
            DRLG_AreaTrans(
                2 as libc::c_int,
                &mut *SkelChamTrans2.as_mut_ptr().offset(0 as libc::c_int as isize),
            );
            DRLG_ListTrans(
                9 as libc::c_int,
                &mut *SkelChamTrans3.as_mut_ptr().offset(0 as libc::c_int as isize),
            );
            AddL2Objs(
                0 as libc::c_int,
                0 as libc::c_int,
                DMAXX as libc::c_int,
                DMAXY as libc::c_int,
            );
            AddSChamObjs();
            InitSChambTriggers();
        }
        3 => {
            LoadPreL1Dungeon(
                b"Levels\\L1Data\\Lv1MazeA.DUN\0" as *const u8 as *const libc::c_char,
                20 as libc::c_int,
                50 as libc::c_int,
            );
            LoadL1Dungeon(
                b"Levels\\L1Data\\Lv1MazeB.DUN\0" as *const u8 as *const libc::c_char,
                20 as libc::c_int,
                50 as libc::c_int,
            );
            LoadPalette(
                b"Levels\\L1Data\\L1_5.pal\0" as *const u8 as *const libc::c_char,
            );
            AddL1Objs(
                0 as libc::c_int,
                0 as libc::c_int,
                DMAXX as libc::c_int,
                DMAXY as libc::c_int,
            );
            DRLG_SetMapTrans(
                b"Levels\\L1Data\\Lv1MazeA.DUN\0" as *const u8 as *const libc::c_char,
            );
        }
        4 => {
            if quests[Q_PWATER as libc::c_int as usize]._qactive as libc::c_int
                == QUEST_NOTACTIVE as libc::c_int
            {
                quests[Q_PWATER as libc::c_int as usize]
                    ._qactive = QUEST_NOTDONE as libc::c_int as uint8_t;
            }
            LoadPreL3Dungeon(
                b"Levels\\L3Data\\Foulwatr.DUN\0" as *const u8 as *const libc::c_char,
                19 as libc::c_int,
                50 as libc::c_int,
            );
            LoadL3Dungeon(
                b"Levels\\L3Data\\Foulwatr.DUN\0" as *const u8 as *const libc::c_char,
                20 as libc::c_int,
                50 as libc::c_int,
            );
            LoadPalette(
                b"Levels\\L3Data\\L3pfoul.pal\0" as *const u8 as *const libc::c_char,
            );
            InitPWaterTriggers();
        }
        5 => {
            if quests[Q_BETRAYER as libc::c_int as usize]._qactive as libc::c_int
                == QUEST_DONE as libc::c_int
            {
                quests[Q_BETRAYER as libc::c_int as usize]
                    ._qvar2 = QS_VBRP4 as libc::c_int as uint8_t;
            } else if quests[Q_BETRAYER as libc::c_int as usize]._qactive as libc::c_int
                == QUEST_NOTDONE as libc::c_int
            {
                quests[Q_BETRAYER as libc::c_int as usize]
                    ._qvar2 = QS_VBRP3 as libc::c_int as uint8_t;
            }
            LoadPreL1Dungeon(
                b"Levels\\L1Data\\Vile1.DUN\0" as *const u8 as *const libc::c_char,
                35 as libc::c_int,
                36 as libc::c_int,
            );
            LoadL1Dungeon(
                b"Levels\\L1Data\\Vile2.DUN\0" as *const u8 as *const libc::c_char,
                35 as libc::c_int,
                36 as libc::c_int,
            );
            LoadPalette(
                b"Levels\\L1Data\\L1_2.pal\0" as *const u8 as *const libc::c_char,
            );
            AddL1Objs(
                0 as libc::c_int,
                0 as libc::c_int,
                DMAXX as libc::c_int,
                DMAXY as libc::c_int,
            );
            AddVileObjs();
            DRLG_SetMapTrans(
                b"Levels\\L1Data\\Vile1.DUN\0" as *const u8 as *const libc::c_char,
            );
            InitNoTriggers();
        }
        _ => {}
    };
}
