use ::libc;
extern "C" {
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn DrawAutomap();
    fn DrawGoldBox(gold: libc::c_int);
    fn DrawTalkBox();
    fn DrawSpellBook();
    fn DrawPause();
    fn RedBack();
    fn DrawDurIcon();
    fn DrawButtons();
    fn DrawLevelUpIcon();
    fn DrawChr();
    fn DrawSpellList();
    fn DrawInfoBox();
    fn DrawManaBar();
    fn DrawManaTop();
    fn DrawHealthBar();
    fn DrawHealthTop();
    fn DrawCtrlPan();
    fn SDL_GetTicks() -> Uint32;
    fn abs(_: libc::c_int) -> libc::c_int;
    fn ConsolePrintXY(
        x: libc::c_int,
        y: libc::c_int,
        ralign: bool32_t,
        fmt: *const libc::c_char,
        _: ...
    );
    fn DrawMapOfDoom();
    fn DrawCel(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn DrawCelL(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn DrawCelI(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
        loff: int8_t,
    );
    fn OutlineCel(
        ocolor: uint8_t,
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn DrawUnitOutline(
        ocolor: uint8_t,
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn DrawInfraUnit(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
        loff: int8_t,
    );
    fn DrawLitUnit(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn DrawUnit(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn TDrawCelL(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn DrawDiabloMsg();
    fn GetDungeonMicros(pn: libc::c_int) -> *mut uint16_t;
    fn gmenu_draw();
    fn DrawHelp();
    fn DrawInv();
    fn DrawSpdBar();
    fn GetItemStr(i: libc::c_int) -> *const libc::c_char;
    fn DrawUniqueInfo();
    fn DrawQText();
    fn MakeLitPal(sr: libc::c_int, sg: libc::c_int, sb: libc::c_int);
    fn plrmsg_draw();
    fn DrawQuestLog();
    fn DecodeMicroTile(pDecodeTo: *mut uint32_t);
    fn DrawBlankMini(pDecodeTo: *mut uint32_t);
    fn DrawSText();
    static mut automapflag: bool32_t;
    static mut spselflag: bool32_t;
    static mut chrflag: bool32_t;
    static mut sbookflag: bool32_t;
    static mut talkflag: bool32_t;
    static mut drawhpflag: bool32_t;
    static mut drawmanaflag: bool32_t;
    static mut drawbtnflag: bool32_t;
    static mut dropGoldFlag: bool32_t;
    static mut dropGoldValue: libc::c_int;
    static mut curs: libc::c_int;
    static mut cursW: libc::c_int;
    static mut cursH: libc::c_int;
    static mut cursmonst: libc::c_int;
    static mut cursobj: int8_t;
    static mut cursitem: int8_t;
    static mut cursplr: int8_t;
    static mut pCursCels: *mut uint8_t;
    static mut dead: [DeadStruct; 31];
    static mut pSquareCel: *mut uint8_t;
    static mut MouseX: libc::c_int;
    static mut MouseY: libc::c_int;
    static mut svgamode: bool32_t;
    static mut visiondebug: bool32_t;
    static mut PauseMode: libc::c_int;
    static mut force_redraw: libc::c_int;
    static mut gbRunGame: bool32_t;
    static mut msgflag: int8_t;
    static mut dFlags: [[int8_t; 112]; 112];
    static mut currlevel: uint8_t;
    static mut setlevel: uint8_t;
    static mut pSpecialCels: *mut uint8_t;
    static mut pDungeonCels: *mut uint8_t;
    static mut nTransTable: [uint8_t; 2049];
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut ScrollInfo: ScrollStruct;
    static mut MicroTileLen: libc::c_int;
    static mut TransList: [uint8_t; 256];
    static mut dPiece: [[libc::c_int; 112]; 112];
    static mut dTransVal: [[int8_t; 112]; 112];
    static mut dLight: [[int8_t; 112]; 112];
    static mut leveltype: uint8_t;
    static mut dPlayer: [[int8_t; 112]; 112];
    static mut dMonster: [[libc::c_int; 112]; 112];
    static mut dDead: [[int8_t; 112]; 112];
    static mut dObject: [[int8_t; 112]; 112];
    static mut dItem: [[int8_t; 112]; 112];
    static mut dMissile: [[*mut MissileNode; 112]; 112];
    static mut dSpecial: [[int8_t; 112]; 112];
    static mut dung_map_r: [[uint8_t; 112]; 112];
    static mut dung_map_g: [[uint8_t; 112]; 112];
    static mut dung_map_b: [[uint8_t; 112]; 112];
    static mut helpflag: bool32_t;
    static mut bActive: bool32_t;
    static mut invflag: bool32_t;
    static mut drawsbarflag: bool32_t;
    static mut item: [ItemStruct; 128];
    static mut numitems: int32_t;
    static mut uitemflag: bool32_t;
    static mut lightflag: libc::c_int;
    static mut numlights: libc::c_int;
    static mut numvision: libc::c_int;
    static mut qtextflag: uint8_t;
    static mut misfiledata: [MisFileData; 47];
    static mut missile: [MissileStruct; 125];
    static mut nummissiles: libc::c_int;
    static mut MissilePreFlag: bool32_t;
    static mut monster: [MonsterStruct; 200];
    static mut nummonsters: int32_t;
    static mut gbMaxPlayers: uint8_t;
    static mut gbActivePlayers: uint8_t;
    static mut object: [ObjectStruct; 127];
    static mut numobjects: int32_t;
    static mut gpPalette: [uint32_t; 256];
    static mut gpLitPal: [uint32_t; 256];
    static mut deathflag: bool32_t;
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut questlog: bool32_t;
    static mut nTrans: bool32_t;
    static mut nLVal: int32_t;
    static mut gnPieceNum: libc::c_int;
    static mut gbPartialTrans: int8_t;
    static mut gdwPNum: uint32_t;
    static mut glClipY: *mut uint32_t;
    static mut nBuffWTbl: [int32_t; 1024];
    static mut stextflag: int8_t;
    static mut numthemes: libc::c_int;
    static mut towner: [TownerStruct; 16];
    static mut numtrigs: libc::c_int;
    static mut gpBuffer: *mut uint32_t;
    fn SdlSysBlit(dwX: uint32_t, dwY: uint32_t, dwWdt: uint32_t, dwHgt: uint32_t);
    fn lock_buf(bFcn: uint8_t);
    fn unlock_buf(bFcn: uint8_t);
    fn MakeVals();
    fn DrawCelG(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
        sx: libc::c_int,
        sy: libc::c_int,
    );
    static mut tile_height: libc::c_int;
    static mut tile_skip: libc::c_int;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type C2RustUnnamed = libc::c_uint;
pub const DEBUG: C2RustUnnamed = 1;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const G_BRIGHT_LIGHTS: C2RustUnnamed_0 = 0;
pub const USE_GOURAUD: C2RustUnnamed_0 = 0;
pub const ORIG_LIGHTING: C2RustUnnamed_0 = 1;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const NBUFFWSL5: C2RustUnnamed_1 = 24576;
pub const NBUFFWSL4: C2RustUnnamed_1 = 12288;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const MAX_FRAMES: C2RustUnnamed_2 = 50;
pub const LOCK_SLEEP: C2RustUnnamed_2 = 1;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const VIEW_CURSOR: C2RustUnnamed_3 = 1;
pub const ICSTART: C2RustUnnamed_3 = 12;
pub const WATCH_CURS: C2RustUnnamed_3 = 11;
pub const HEALOTHER_CURS: C2RustUnnamed_3 = 10;
pub const TARGET_CURS: C2RustUnnamed_3 = 9;
pub const RESURRECT_CURS: C2RustUnnamed_3 = 8;
pub const TELE_CURS: C2RustUnnamed_3 = 7;
pub const OIL_CURS: C2RustUnnamed_3 = 6;
pub const DISARM_CURS: C2RustUnnamed_3 = 5;
pub const RECHARGE_CURS: C2RustUnnamed_3 = 4;
pub const REPAIR_CURS: C2RustUnnamed_3 = 3;
pub const IDENTIFY_CURS: C2RustUnnamed_3 = 2;
pub const GLOVE_CURS: C2RustUnnamed_3 = 1;
pub const NO_CURSOR: C2RustUnnamed_3 = 0;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed_4 = 191;
pub const SETP_TEMP: C2RustUnnamed_4 = 64;
pub const SETP_MASK: C2RustUnnamed_4 = 127;
pub const SETP_BIT: C2RustUnnamed_4 = 128;
pub const BFMASK_MISSILE: C2RustUnnamed_4 = 254;
pub const BFMASK_SETPC: C2RustUnnamed_4 = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed_4 = 239;
pub const BFMASK_PLRLR: C2RustUnnamed_4 = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed_4 = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed_4 = 127;
pub const BFLAG_MISSILE: C2RustUnnamed_4 = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed_4 = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed_4 = 4;
pub const BFLAG_SETPC: C2RustUnnamed_4 = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed_4 = 16;
pub const BFLAG_PLRLR: C2RustUnnamed_4 = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed_4 = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed_4 = 128;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_5 = 255;
pub const VIEWDRAW: C2RustUnnamed_5 = 1;
pub const NODRAW: C2RustUnnamed_5 = 0;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const SCRL_UL: C2RustUnnamed_6 = 8;
pub const SCRL_L: C2RustUnnamed_6 = 7;
pub const SCRL_DL: C2RustUnnamed_6 = 6;
pub const SCRL_D: C2RustUnnamed_6 = 5;
pub const SCRL_DR: C2RustUnnamed_6 = 4;
pub const SCRL_R: C2RustUnnamed_6 = 3;
pub const SCRL_UR: C2RustUnnamed_6 = 2;
pub const SCRL_U: C2RustUnnamed_6 = 1;
pub const SCRL_NONE: C2RustUnnamed_6 = 0;
pub type C2RustUnnamed_7 = libc::c_uint;
pub const LIGHT_U: C2RustUnnamed_7 = 4;
pub const LIGHT_GREY: C2RustUnnamed_7 = 3;
pub const LIGHT_STONE: C2RustUnnamed_7 = 2;
pub const LIGHT_INFRA: C2RustUnnamed_7 = 1;
pub const LIGHT_NORM: C2RustUnnamed_7 = 0;
pub type C2RustUnnamed_8 = libc::c_uint;
pub const MF_STARTLOAD: C2RustUnnamed_8 = 0;
pub const MF_NONE: C2RustUnnamed_8 = 46;
pub const MF_DFLAREXP: C2RustUnnamed_8 = 45;
pub const MF_DFLARE: C2RustUnnamed_8 = 44;
pub const MF_CFLAREXP: C2RustUnnamed_8 = 43;
pub const MF_CFLARE: C2RustUnnamed_8 = 42;
pub const MF_BFLAREXP: C2RustUnnamed_8 = 41;
pub const MF_BFLARE: C2RustUnnamed_8 = 40;
pub const MF_FIREPLAR: C2RustUnnamed_8 = 39;
pub const MF_RPORTAL: C2RustUnnamed_8 = 38;
pub const MF_BONESPIRIT: C2RustUnnamed_8 = 37;
pub const MF_RESURRECT: C2RustUnnamed_8 = 36;
pub const MF_FIRERUN: C2RustUnnamed_8 = 35;
pub const MF_ETHER: C2RustUnnamed_8 = 34;
pub const MF_ACIDPUD: C2RustUnnamed_8 = 33;
pub const MF_ACIDSPLAT: C2RustUnnamed_8 = 32;
pub const MF_ACID: C2RustUnnamed_8 = 31;
pub const MF_FAEXP: C2RustUnnamed_8 = 30;
pub const MF_LARROW: C2RustUnnamed_8 = 29;
pub const MF_HEXPL: C2RustUnnamed_8 = 28;
pub const MF_HBOLT: C2RustUnnamed_8 = 27;
pub const MF_CBOLT: C2RustUnnamed_8 = 26;
pub const MF_KRULL: C2RustUnnamed_8 = 25;
pub const MF_MAGBALL: C2RustUnnamed_8 = 24;
pub const MF_FLAREXP: C2RustUnnamed_8 = 23;
pub const MF_FLARE: C2RustUnnamed_8 = 22;
pub const MF_THINLIGHT: C2RustUnnamed_8 = 21;
pub const MF_FLAMES: C2RustUnnamed_8 = 20;
pub const MF_BIGEXP: C2RustUnnamed_8 = 19;
pub const MF_STONE: C2RustUnnamed_8 = 18;
pub const MF_BOOM: C2RustUnnamed_8 = 17;
pub const MF_SPURT: C2RustUnnamed_8 = 16;
pub const MF_GOLEM: C2RustUnnamed_8 = 15;
pub const MF_DOOM: C2RustUnnamed_8 = 14;
pub const MF_FARROW: C2RustUnnamed_8 = 13;
pub const MF_METAL: C2RustUnnamed_8 = 12;
pub const MF_BONE: C2RustUnnamed_8 = 11;
pub const MF_BLOOD: C2RustUnnamed_8 = 10;
pub const MF_MANASHLD: C2RustUnnamed_8 = 9;
pub const MF_FLASH2: C2RustUnnamed_8 = 8;
pub const MF_FLASH1: C2RustUnnamed_8 = 7;
pub const MF_TOWN: C2RustUnnamed_8 = 6;
pub const MF_EXP1: C2RustUnnamed_8 = 5;
pub const MF_FIRE: C2RustUnnamed_8 = 4;
pub const MF_LIGHTNING: C2RustUnnamed_8 = 3;
pub const MF_GUARDIAN: C2RustUnnamed_8 = 2;
pub const MF_FIREBOLT: C2RustUnnamed_8 = 1;
pub const MF_ARROW: C2RustUnnamed_8 = 0;
pub type C2RustUnnamed_9 = libc::c_uint;
pub const MFLAG_NOENEMY: C2RustUnnamed_9 = 1024;
pub const MFLAG_CHECKDOORS: C2RustUnnamed_9 = 512;
pub const MFLAG_PATH: C2RustUnnamed_9 = 256;
pub const MFLAG_KNOCKBACK: C2RustUnnamed_9 = 128;
pub const MFLAG_DROP: C2RustUnnamed_9 = 64;
pub const MFLAG_MKILLER: C2RustUnnamed_9 = 32;
pub const MFLAG_MID: C2RustUnnamed_9 = 16;
pub const MFLAG_NOHEAL: C2RustUnnamed_9 = 8;
pub const MFLAG_STILL: C2RustUnnamed_9 = 4;
pub const MFLAG_BACKWARDS: C2RustUnnamed_9 = 2;
pub const MFLAG_INVISIBLE: C2RustUnnamed_9 = 1;
pub type C2RustUnnamed_10 = libc::c_uint;
pub const MM_TALK: C2RustUnnamed_10 = 17;
pub const MM_HEAL: C2RustUnnamed_10 = 16;
pub const MM_STONE: C2RustUnnamed_10 = 15;
pub const MM_MISSILE: C2RustUnnamed_10 = 14;
pub const MM_DELAY: C2RustUnnamed_10 = 13;
pub const MM_RSATTACK: C2RustUnnamed_10 = 12;
pub const MM_SPSTAND: C2RustUnnamed_10 = 11;
pub const MM_RATTACK: C2RustUnnamed_10 = 10;
pub const MM_FADEOUT: C2RustUnnamed_10 = 9;
pub const MM_FADEIN: C2RustUnnamed_10 = 8;
pub const MM_SATTACK: C2RustUnnamed_10 = 7;
pub const MM_DEATH: C2RustUnnamed_10 = 6;
pub const MM_GOTHIT: C2RustUnnamed_10 = 5;
pub const MM_ATTACK: C2RustUnnamed_10 = 4;
pub const MM_WALK3: C2RustUnnamed_10 = 3;
pub const MM_WALK2: C2RustUnnamed_10 = 2;
pub const MM_WALK: C2RustUnnamed_10 = 1;
pub const MM_STAND: C2RustUnnamed_10 = 0;
pub type C2RustUnnamed_11 = libc::c_uint;
pub const PART_TRANS_RIGHT: C2RustUnnamed_11 = 2;
pub const PART_TRANS_LEFT: C2RustUnnamed_11 = 1;
pub const PART_TRANS_NONE: C2RustUnnamed_11 = 0;
pub type C2RustUnnamed_12 = libc::c_uint;
pub const TOUTC: C2RustUnnamed_12 = 165;
pub const POUTC: C2RustUnnamed_12 = 165;
pub const OOUTC: C2RustUnnamed_12 = 194;
pub const IOUTC: C2RustUnnamed_12 = 181;
pub const MOUTC: C2RustUnnamed_12 = 233;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type bool32_t = uint32_t;
pub type Uint32 = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
pub type C2RustUnnamed_13 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_13 = 32;
pub const MAXMICRO: C2RustUnnamed_13 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_13 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_13 = 64;
pub const MAXMREND: C2RustUnnamed_13 = 128;
pub const MAXTILES: C2RustUnnamed_13 = 2048;
pub const MDMAXY: C2RustUnnamed_13 = 40;
pub const MDMAXX: C2RustUnnamed_13 = 40;
pub const MAXDUNY: C2RustUnnamed_13 = 112;
pub const MAXDUNX: C2RustUnnamed_13 = 112;
pub const DMAXY: C2RustUnnamed_13 = 112;
pub const DMAXX: C2RustUnnamed_13 = 112;
pub const DIRTEDGED2: C2RustUnnamed_13 = 16;
pub const DIRTEDGE: C2RustUnnamed_13 = 32;
pub const NUMSLEVELS: C2RustUnnamed_13 = 10;
pub const NUMLEVELS: C2RustUnnamed_13 = 17;
pub const LVL4_START: C2RustUnnamed_13 = 13;
pub const LVL3_START: C2RustUnnamed_13 = 9;
pub const LVL2_START: C2RustUnnamed_13 = 5;
pub const LVL1_START: C2RustUnnamed_13 = 1;
pub const TLVL_START: C2RustUnnamed_13 = 0;
pub const LVLLENGTH: C2RustUnnamed_13 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct DeadStruct {
    pub _deadData: [*mut uint8_t; 8],
    pub _deadFrame: libc::c_int,
    pub _deadWidth: int32_t,
    pub _deadWidth2: int32_t,
    pub _deadtrans: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ScrollStruct {
    pub _sxoff: libc::c_int,
    pub _syoff: libc::c_int,
    pub _sdx: libc::c_int,
    pub _sdy: libc::c_int,
    pub _sdir: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MissileNode {
    pub missile_num: int8_t,
    pub next: *mut MissileNode,
}
pub type C2RustUnnamed_14 = libc::c_int;
pub const ITEMFTYPES: C2RustUnnamed_14 = 35;
pub const RESIST_MAX: C2RustUnnamed_14 = 75;
pub const GOLD_VMAX: C2RustUnnamed_14 = 5000;
pub const GOLD_VT2: C2RustUnnamed_14 = 2500;
pub const GOLD_VT1: C2RustUnnamed_14 = 1000;
pub const INFINITE_DUR: C2RustUnnamed_14 = 255;
pub const ITEM_RND: C2RustUnnamed_14 = -1;
pub const TEMPAVAIL: C2RustUnnamed_14 = 127;
pub const MAXUITEMS: C2RustUnnamed_14 = 128;
pub const MAXITEMS: C2RustUnnamed_14 = 127;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MisFileData {
    pub mAnimName: uint8_t,
    pub mAnimFAmt: uint8_t,
    pub mAnimPath: *const libc::c_char,
    pub mFlags: bool32_t,
    pub mAnimData: [*mut uint8_t; 16],
    pub mAnimDelay: [uint8_t; 16],
    pub mAnimLen: [uint8_t; 16],
    pub mAnimWidth: [int32_t; 16],
    pub mAnimWidth2: [int32_t; 16],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MissileStruct {
    pub _mitype: libc::c_int,
    pub _mix: libc::c_int,
    pub _miy: libc::c_int,
    pub _mixoff: int32_t,
    pub _miyoff: int32_t,
    pub _mixvel: int32_t,
    pub _miyvel: int32_t,
    pub _misx: libc::c_int,
    pub _misy: libc::c_int,
    pub _mitxoff: int32_t,
    pub _mityoff: int32_t,
    pub _mimfnum: libc::c_int,
    pub _mispllvl: libc::c_int,
    pub _miDelFlag: bool32_t,
    pub _miAnimType: uint8_t,
    pub _miAnimFlags: bool32_t,
    pub _miAnimData: *mut uint8_t,
    pub _miAnimDelay: libc::c_int,
    pub _miAnimLen: libc::c_int,
    pub _miAnimWidth: int32_t,
    pub _miAnimWidth2: int32_t,
    pub _miAnimCnt: libc::c_int,
    pub _miAnimAdd: libc::c_int,
    pub _miAnimFrame: libc::c_int,
    pub _miDrawFlag: bool32_t,
    pub _miLightFlag: bool32_t,
    pub _miPreFlag: bool32_t,
    pub _miUniqTrans: bool32_t,
    pub _mirange: libc::c_int,
    pub _misource: libc::c_int,
    pub _micaster: libc::c_int,
    pub _midam: libc::c_int,
    pub _miHitFlag: bool32_t,
    pub _midist: libc::c_int,
    pub _mlid: libc::c_int,
    pub _mirnd: libc::c_int,
    pub _miVar1: int32_t,
    pub _miVar2: int32_t,
    pub _miVar3: int32_t,
    pub _miVar4: int32_t,
    pub _miVar5: int32_t,
    pub _miVar6: int32_t,
    pub _miVar7: int32_t,
    pub _miVar8: int32_t,
}
pub type C2RustUnnamed_15 = libc::c_uint;
pub const INITMONSTRAD: C2RustUnnamed_15 = 15;
pub const MAX_MS: C2RustUnnamed_15 = 4;
pub const IMG_MAX: C2RustUnnamed_15 = 4000;
pub const MAX_ANIMTYPE: C2RustUnnamed_15 = 6;
pub const MONSTDENSITY: C2RustUnnamed_15 = 30;
pub const MAX_LVLMTYPES: C2RustUnnamed_15 = 16;
pub const MONSTERTYPES: C2RustUnnamed_15 = 200;
pub const MAXMONSTERS: C2RustUnnamed_15 = 200;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterStruct {
    pub _mMTidx: libc::c_int,
    pub _mmode: libc::c_int,
    pub _mgoal: uint8_t,
    pub _mgoalvar1: libc::c_int,
    pub _mgoalvar2: libc::c_int,
    pub _mgoalvar3: libc::c_int,
    pub _mgoalvar4: libc::c_int,
    pub _pathcount: uint8_t,
    pub _mx: libc::c_int,
    pub _my: libc::c_int,
    pub _mfutx: libc::c_int,
    pub _mfuty: libc::c_int,
    pub _moldx: libc::c_int,
    pub _moldy: libc::c_int,
    pub _mxoff: int32_t,
    pub _myoff: int32_t,
    pub _mxvel: int32_t,
    pub _myvel: int32_t,
    pub _mdir: libc::c_int,
    pub _menemy: libc::c_int,
    pub _menemyx: uint8_t,
    pub _menemyy: uint8_t,
    pub _mAnimData: *mut uint8_t,
    pub _mAnimDelay: libc::c_int,
    pub _mAnimCnt: libc::c_int,
    pub _mAnimLen: libc::c_int,
    pub _mAnimFrame: libc::c_int,
    pub _meflag: libc::c_int,
    pub _mDelFlag: bool32_t,
    pub _mVar1: int32_t,
    pub _mVar2: int32_t,
    pub _mVar3: int32_t,
    pub _mVar4: int32_t,
    pub _mVar5: int32_t,
    pub _mVar6: int32_t,
    pub _mVar7: int32_t,
    pub _mVar8: int32_t,
    pub _mmaxhp: int32_t,
    pub _mhitpoints: int32_t,
    pub _mAi: uint8_t,
    pub _mint: uint8_t,
    pub _mFlags: uint32_t,
    pub _msquelch: uint8_t,
    pub _mAFNum: libc::c_int,
    pub _lastx: libc::c_int,
    pub _lasty: libc::c_int,
    pub _mRndSeed: libc::c_int,
    pub _mAISeed: libc::c_int,
    pub _Wandering: bool32_t,
    pub _uniqtype: uint8_t,
    pub _uniqtrans: uint8_t,
    pub _udeadval: int8_t,
    pub mWhoHit: int8_t,
    pub mLevel: int8_t,
    pub mExp: uint16_t,
    pub mHit: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMagicRes: uint16_t,
    pub mtalkmsg: libc::c_int,
    pub leader: uint8_t,
    pub leaderflag: uint8_t,
    pub packsize: uint8_t,
    pub mlid: uint8_t,
    pub mName: *const libc::c_char,
    pub MType: *mut CMonster,
    pub MData: *mut MonsterData,
}
pub type C2RustUnnamed_16 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_16 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_16 = 92160;
pub const BTMBUFFY: C2RustUnnamed_16 = 144;
pub const BTMBUFFX: C2RustUnnamed_16 = 640;
pub const BUFFERSIZE: C2RustUnnamed_16 = 503808;
pub const BUFFERY: C2RustUnnamed_16 = 656;
pub const BUFFERX: C2RustUnnamed_16 = 768;
pub const GAMEY: C2RustUnnamed_16 = 352;
pub const CTRLPANY: C2RustUnnamed_16 = 128;
pub const TOTALY: C2RustUnnamed_16 = 480;
pub const TOTALX: C2RustUnnamed_16 = 640;
pub const MAX_PLRS: C2RustUnnamed_16 = 4;
pub type C2RustUnnamed_17 = libc::c_uint;
pub const TOTAL_FOUNTAINS: C2RustUnnamed_17 = 4;
pub const MAXLVLOBJS: C2RustUnnamed_17 = 40;
pub const MAXOBJECTS: C2RustUnnamed_17 = 127;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ObjectStruct {
    pub _otype: libc::c_int,
    pub _ox: libc::c_int,
    pub _oy: libc::c_int,
    pub _oLight: bool32_t,
    pub _oAnimFlag: bool32_t,
    pub _oAnimData: *mut uint8_t,
    pub _oAnimDelay: libc::c_int,
    pub _oAnimCnt: libc::c_int,
    pub _oAnimLen: libc::c_int,
    pub _oAnimFrame: libc::c_int,
    pub _oAnimWidth: int32_t,
    pub _oAnimWidth2: int32_t,
    pub _oDelFlag: bool32_t,
    pub _oBreak: int8_t,
    pub _oSolidFlag: bool32_t,
    pub _oMissFlag: bool32_t,
    pub _oSelFlag: int8_t,
    pub _oPreFlag: bool32_t,
    pub _oTrapFlag: bool32_t,
    pub _oDoorFlag: bool32_t,
    pub _olid: libc::c_int,
    pub _oRndSeed: libc::c_int,
    pub _oVar1: int32_t,
    pub _oVar2: int32_t,
    pub _oVar3: int32_t,
    pub _oVar4: int32_t,
    pub _oVar5: int32_t,
    pub _oVar6: int32_t,
    pub _oVar7: int32_t,
    pub _oVar8: int32_t,
}
pub type C2RustUnnamed_18 = libc::c_uint;
pub const PM_QUIT: C2RustUnnamed_18 = 11;
pub const PM_NEWLVL: C2RustUnnamed_18 = 10;
pub const PM_SPELL: C2RustUnnamed_18 = 9;
pub const PM_DEATH: C2RustUnnamed_18 = 8;
pub const PM_GOTHIT: C2RustUnnamed_18 = 7;
pub const PM_BLOCK: C2RustUnnamed_18 = 6;
pub const PM_RATTACK: C2RustUnnamed_18 = 5;
pub const PM_ATTACK: C2RustUnnamed_18 = 4;
pub const PM_WALK3: C2RustUnnamed_18 = 3;
pub const PM_WALK2: C2RustUnnamed_18 = 2;
pub const PM_WALK: C2RustUnnamed_18 = 1;
pub const PM_STAND: C2RustUnnamed_18 = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TNQ {
    pub _qsttype: uint8_t,
    pub _qstmsg: uint8_t,
    pub _qstmsgact: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TownerStruct {
    pub _tmode: libc::c_int,
    pub _ttype: libc::c_int,
    pub _tx: libc::c_int,
    pub _ty: libc::c_int,
    pub _txoff: int32_t,
    pub _tyoff: int32_t,
    pub _txvel: int32_t,
    pub _tyvel: int32_t,
    pub _tdir: libc::c_int,
    pub _tAnimData: *mut uint8_t,
    pub _tAnimDelay: libc::c_int,
    pub _tAnimCnt: libc::c_int,
    pub _tAnimLen: libc::c_int,
    pub _tAnimFrame: libc::c_int,
    pub _tAnimFrameCnt: libc::c_int,
    pub _tAnimOrder: int8_t,
    pub _tAnimWidth: int32_t,
    pub _tAnimWidth2: int32_t,
    pub _tTenPer: libc::c_int,
    pub _teflag: libc::c_int,
    pub _tbtcnt: libc::c_int,
    pub _tSelFlag: bool32_t,
    pub _tMsgSaid: bool32_t,
    pub qsts: [TNQ; 16],
    pub _tSeed: libc::c_int,
    pub _tVar1: int32_t,
    pub _tVar2: int32_t,
    pub _tVar3: int32_t,
    pub _tVar4: int32_t,
    pub _tName: [libc::c_char; 32],
    pub _tNAnim: [*mut uint8_t; 8],
    pub _tNFrames: libc::c_int,
    pub _tNData: *mut uint8_t,
}
#[no_mangle]
pub static mut sgszUnknownAction: [libc::c_char; 15] = unsafe {
    *::core::mem::transmute::<&[u8; 15], &[libc::c_char; 15]>(b"unknown action\0")
};
#[no_mangle]
pub static mut gnMI: libc::c_int = 0;
static mut sgnLastFrame: uint32_t = 0;
static mut sgfFrameCounterEnabled: uint8_t = 0 as libc::c_int as uint8_t;
static mut sgSaveBack: [uint8_t; 32768] = [0; 32768];
static mut sgdwCursX: uint32_t = 0;
static mut sgdwCursY: uint32_t = 0;
static mut sgdwCursWdt: uint32_t = 0;
static mut sgdwCursHgt: uint32_t = 0;
static mut sgdwOldX: uint32_t = 0;
static mut sgdwOldY: uint32_t = 0;
static mut sgdwOldWdt: uint32_t = 0;
static mut sgdwOldHgt: uint32_t = 0;
static mut snFrameCount: libc::c_int = 0 as libc::c_int;
static mut nFrameRate: libc::c_int = 0 as libc::c_int;
#[no_mangle]
pub static mut sgszPlayerAction: [*const libc::c_char; 12] = [
    b"standing\0" as *const u8 as *const libc::c_char,
    b"walking (1)\0" as *const u8 as *const libc::c_char,
    b"walking (2)\0" as *const u8 as *const libc::c_char,
    b"walking (3)\0" as *const u8 as *const libc::c_char,
    b"attacking (melee)\0" as *const u8 as *const libc::c_char,
    b"attacking (ranged)\0" as *const u8 as *const libc::c_char,
    b"blocking\0" as *const u8 as *const libc::c_char,
    b"getting hit\0" as *const u8 as *const libc::c_char,
    b"dying\0" as *const u8 as *const libc::c_char,
    b"casting a spell\0" as *const u8 as *const libc::c_char,
    b"changing levels\0" as *const u8 as *const libc::c_char,
    b"quitting\0" as *const u8 as *const libc::c_char,
];
#[no_mangle]
pub static mut sgszMonsterAction: [*const libc::c_char; 18] = [
    b"standing\0" as *const u8 as *const libc::c_char,
    b"walking (1)\0" as *const u8 as *const libc::c_char,
    b"walking (2)\0" as *const u8 as *const libc::c_char,
    b"walking (3)\0" as *const u8 as *const libc::c_char,
    b"attacking\0" as *const u8 as *const libc::c_char,
    b"getting hit\0" as *const u8 as *const libc::c_char,
    b"dying\0" as *const u8 as *const libc::c_char,
    b"attacking (special)\0" as *const u8 as *const libc::c_char,
    b"fading in\0" as *const u8 as *const libc::c_char,
    b"fading out\0" as *const u8 as *const libc::c_char,
    b"attacking (ranged)\0" as *const u8 as *const libc::c_char,
    b"standing (special)\0" as *const u8 as *const libc::c_char,
    b"attacking (special ranged)\0" as *const u8 as *const libc::c_char,
    b"delaying\0" as *const u8 as *const libc::c_char,
    b"charging\0" as *const u8 as *const libc::c_char,
    b"stoned\0" as *const u8 as *const libc::c_char,
    b"healing\0" as *const u8 as *const libc::c_char,
    b"talking\0" as *const u8 as *const libc::c_char,
];
#[no_mangle]
pub unsafe extern "C" fn savecrsr_reset() {
    sgdwCursWdt = 0 as libc::c_int as uint32_t;
    sgdwOldWdt = 0 as libc::c_int as uint32_t;
}
unsafe extern "C" fn savecrsr_hide() {
    if sgdwCursWdt == 0 {
        return;
    }
    if gpBuffer.is_null() {
        assert_fail(
            142 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut pbDst: *mut uint32_t = gpBuffer
        .offset(
            (sgdwCursY.wrapping_add(160 as libc::c_int as uint32_t)
                * 768 as libc::c_int as uint32_t) as isize,
        )
        .offset(sgdwCursX as isize)
        .offset(64 as libc::c_int as isize);
    let mut pbSrc: *const uint32_t = sgSaveBack.as_mut_ptr() as *mut uint32_t;
    let mut hgt: uint32_t = sgdwCursHgt;
    loop {
        let fresh0 = hgt;
        hgt = hgt.wrapping_sub(1);
        if !(fresh0 != 0) {
            break;
        }
        memcpy(
            pbDst as *mut libc::c_void,
            pbSrc as *const libc::c_void,
            (sgdwCursWdt * 4 as libc::c_int as uint32_t) as libc::c_ulong,
        );
        pbSrc = pbSrc.offset(sgdwCursWdt as isize);
        pbDst = pbDst.offset(768 as libc::c_int as isize);
    }
    sgdwOldX = sgdwCursX;
    sgdwOldY = sgdwCursY;
    sgdwOldWdt = sgdwCursWdt;
    sgdwOldHgt = sgdwCursHgt;
    sgdwCursWdt = 0 as libc::c_int as uint32_t;
}
#[no_mangle]
pub unsafe extern "C" fn DrawDead(
    mut bDead: int8_t,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
) {
    let mut pxp: libc::c_int = 0;
    let mut pDeadGuy: *mut DeadStruct = &mut *dead
        .as_mut_ptr()
        .offset(
            ((bDead as libc::c_int & 0x1f as libc::c_int) - 1 as libc::c_int) as isize,
        ) as *mut DeadStruct;
    let mut dd: int8_t = ((bDead as libc::c_int & 0xe0 as libc::c_int)
        >> 5 as libc::c_int) as int8_t;
    pxp = xp - (*pDeadGuy)._deadWidth2;
    if ((*pDeadGuy)._deadData[dd as usize]).is_null() {
        assert_fail(
            165 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"pDeadGuy->_deadData[dd] != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if (*pDeadGuy)._deadFrame < 1 as libc::c_int
        || *((*pDeadGuy)._deadData[dd as usize] as *mut uint32_t)
            > MAX_FRAMES as libc::c_int as uint32_t
        || (*pDeadGuy)._deadFrame > *((*pDeadGuy)._deadData[dd as usize] as *mut int32_t)
    {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            172 as libc::c_int,
            b"draw dead: frame %d of %d, deadnum==%d\0" as *const u8
                as *const libc::c_char,
            (*pDeadGuy)._deadFrame,
            *((*pDeadGuy)._deadData[dd as usize] as *mut int32_t),
            (bDead as libc::c_int & 0x1f as libc::c_int) - 1 as libc::c_int,
        );
    }
    if (*pDeadGuy)._deadtrans != 0 {
        DrawInfraUnit(
            pxp,
            yp,
            (*pDeadGuy)._deadData[dd as usize],
            (*pDeadGuy)._deadFrame,
            (*pDeadGuy)._deadWidth,
            (*pDeadGuy)._deadtrans,
        );
    } else {
        DrawLitUnit(
            pxp,
            yp,
            (*pDeadGuy)._deadData[dd as usize],
            (*pDeadGuy)._deadFrame,
            (*pDeadGuy)._deadWidth,
        );
    };
}
#[no_mangle]
pub unsafe extern "C" fn DrawItem(
    mut bItem: int8_t,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
    mut post: bool32_t,
) {
    let mut pxp: libc::c_int = 0;
    let mut pItem: *mut ItemStruct = &mut *item
        .as_mut_ptr()
        .offset((bItem as libc::c_int - 1 as libc::c_int) as isize) as *mut ItemStruct;
    if (*pItem)._iPostDraw != post {
        return;
    }
    if !(bItem as uint8_t as libc::c_int <= MAXITEMS as libc::c_int) {
        assert_fail(
            200 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"(uint8_t)bItem <= MAXITEMS\0" as *const u8 as *const libc::c_char,
        );
    }
    if ((*pItem)._iAnimData).is_null() {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            202 as libc::c_int,
            b"Draw Item \"%s\": NULL Cel Buffer\0" as *const u8 as *const libc::c_char,
            GetItemStr(bItem as libc::c_int - 1 as libc::c_int),
        );
    }
    if (*pItem)._iAnimFrame < 1 as libc::c_int
        || *((*pItem)._iAnimData as *mut uint32_t)
            > MAX_FRAMES as libc::c_int as uint32_t
        || (*pItem)._iAnimFrame > *((*pItem)._iAnimData as *mut int32_t)
    {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            211 as libc::c_int,
            b"Draw \"%s\" Item: frame %d of %d, item type==%d\0" as *const u8
                as *const libc::c_char,
            GetItemStr(bItem as libc::c_int - 1 as libc::c_int),
            (*pItem)._iAnimFrame,
            *((*pItem)._iAnimData as *mut int32_t),
            (*pItem)._itype,
        );
    }
    pxp = xp - (*pItem)._iAnimWidth2;
    if bItem as libc::c_int - 1 as libc::c_int == cursitem as libc::c_int {
        OutlineCel(
            IOUTC as libc::c_int as uint8_t,
            pxp,
            yp,
            (*pItem)._iAnimData,
            (*pItem)._iAnimFrame,
            (*pItem)._iAnimWidth,
        );
    }
    DrawCelL(pxp, yp, (*pItem)._iAnimData, (*pItem)._iAnimFrame, (*pItem)._iAnimWidth);
}
#[no_mangle]
pub unsafe extern "C" fn DrawPlayer(
    mut nPlayer: libc::c_int,
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
) {
    let mut pxp: libc::c_int = 0;
    let mut pyp: libc::c_int = 0;
    if nPlayer as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            237 as libc::c_int,
            b"draw player: tried to draw illegal player %d\0" as *const u8
                as *const libc::c_char,
            nPlayer,
        );
    }
    let mut pPlayer: *mut PlayerStruct = &mut *plr.as_mut_ptr().offset(nPlayer as isize)
        as *mut PlayerStruct;
    pxp = (*pPlayer)._pxoff + xp - (*pPlayer)._pAnimWidth2;
    pyp = (*pPlayer)._pyoff + yp;
    DrawPCelL(
        nPlayer,
        sx,
        sy,
        pxp,
        pyp,
        (*pPlayer)._pAnimData,
        (*pPlayer)._pAnimFrame,
        (*pPlayer)._pAnimWidth,
    );
}
#[no_mangle]
pub unsafe extern "C" fn DrawMonster(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
) {
    let mut pxp: libc::c_int = 0;
    let mut pyp: libc::c_int = 0;
    if gnMI as uint32_t >= MAXMONSTERS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            258 as libc::c_int,
            b"Draw Monster: tried to draw illegal monster %d\0" as *const u8
                as *const libc::c_char,
            gnMI,
        );
    }
    let mut pMonster: *mut MonsterStruct = &mut *monster
        .as_mut_ptr()
        .offset(gnMI as isize) as *mut MonsterStruct;
    if (*pMonster)._mFlags & MFLAG_INVISIBLE as libc::c_int as uint32_t != 0 {
        return;
    }
    if ((*pMonster).MType).is_null() {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            265 as libc::c_int,
            b"Draw Monster \"%s\": uninitialized monster\0" as *const u8
                as *const libc::c_char,
            (*pMonster).mName,
        );
    }
    pxp = (*pMonster)._mxoff + xp - (*(*pMonster).MType).mAnimWidth2;
    pyp = (*pMonster)._myoff + yp;
    if gnMI == cursmonst {
        DrawUnitOutline(
            MOUTC as libc::c_int as uint8_t,
            pxp,
            pyp,
            (*pMonster)._mAnimData,
            (*pMonster)._mAnimFrame,
            (*(*pMonster).MType).mAnimWidth,
        );
    }
    DrawMCelL(sx, sy, pxp, pyp, gnMI);
}
#[no_mangle]
pub unsafe extern "C" fn DrawTowner(
    mut mi: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
) {
    let mut pxp: libc::c_int = 0;
    let mut pyp: libc::c_int = 0;
    pxp = xp - towner[mi as usize]._tAnimWidth2;
    pyp = yp;
    if mi == cursmonst {
        OutlineCel(
            TOUTC as libc::c_int as uint8_t,
            pxp,
            pyp,
            towner[mi as usize]._tAnimData,
            towner[mi as usize]._tAnimFrame,
            towner[mi as usize]._tAnimWidth,
        );
    }
    if (towner[mi as usize]._tAnimData).is_null() {
        assert_fail(
            291 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"towner[mi]._tAnimData\0" as *const u8 as *const libc::c_char,
        );
    }
    DrawCel(
        pxp,
        pyp,
        towner[mi as usize]._tAnimData,
        towner[mi as usize]._tAnimFrame,
        towner[mi as usize]._tAnimWidth,
    );
}
unsafe extern "C" fn savecrsr_show() {
    if sgdwCursWdt != 0 {
        assert_fail(
            299 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"!sgdwCursWdt\0" as *const u8 as *const libc::c_char,
        );
    }
    if curs <= 0 as libc::c_int {
        return;
    }
    if cursW == 0 || cursH == 0 {
        return;
    }
    let mut cursX: libc::c_int = MouseX - 1 as libc::c_int;
    if cursX < 0 as libc::c_int {
        cursX = 0 as libc::c_int;
    } else if cursX > 639 as libc::c_int {
        return
    }
    let mut cursY: libc::c_int = MouseY - 1 as libc::c_int;
    if cursY < 0 as libc::c_int {
        cursY = 0 as libc::c_int;
    } else if cursY > 479 as libc::c_int {
        return
    }
    sgdwCursX = cursX as uint32_t;
    sgdwCursWdt = (cursX + cursW + 2 as libc::c_int - 1 as libc::c_int) as uint32_t;
    if sgdwCursWdt > 639 as libc::c_int as uint32_t {
        sgdwCursWdt = 639 as libc::c_int as uint32_t;
    }
    sgdwCursX &= !(3 as libc::c_int) as uint32_t;
    sgdwCursWdt |= 3 as libc::c_int as uint32_t;
    sgdwCursWdt = sgdwCursWdt
        .wrapping_add((1 as libc::c_int as uint32_t).wrapping_sub(sgdwCursX));
    sgdwCursY = cursY as uint32_t;
    sgdwCursHgt = (cursY + cursH + 2 as libc::c_int - 1 as libc::c_int) as uint32_t;
    if sgdwCursHgt > 479 as libc::c_int as uint32_t {
        sgdwCursHgt = 479 as libc::c_int as uint32_t;
    }
    sgdwCursHgt = sgdwCursHgt
        .wrapping_add((1 as libc::c_int as uint32_t).wrapping_sub(sgdwCursY));
    if !(((sgdwCursWdt * sgdwCursHgt * 4 as libc::c_int as uint32_t) as libc::c_ulong)
        < ::core::mem::size_of::<[uint8_t; 32768]>() as libc::c_ulong)
    {
        assert_fail(
            338 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"sgdwCursWdt * sgdwCursHgt * PIXEL_SIZE < sizeof(sgSaveBack)\0" as *const u8
                as *const libc::c_char,
        );
    }
    if gpBuffer.is_null() {
        assert_fail(
            341 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut pbSrc: *const uint32_t = gpBuffer
        .offset(
            (sgdwCursY.wrapping_add(160 as libc::c_int as uint32_t)
                * 768 as libc::c_int as uint32_t) as isize,
        )
        .offset(sgdwCursX as isize)
        .offset(64 as libc::c_int as isize);
    let mut pbDst: *mut uint32_t = sgSaveBack.as_mut_ptr() as *mut uint32_t;
    let mut hgt: uint32_t = sgdwCursHgt;
    loop {
        let fresh1 = hgt;
        hgt = hgt.wrapping_sub(1);
        if !(fresh1 != 0) {
            break;
        }
        memcpy(
            pbDst as *mut libc::c_void,
            pbSrc as *const libc::c_void,
            (sgdwCursWdt * 4 as libc::c_int as uint32_t) as libc::c_ulong,
        );
        pbDst = pbDst.offset(sgdwCursWdt as isize);
        pbSrc = pbSrc.offset(768 as libc::c_int as isize);
    }
    cursX += 1 as libc::c_int;
    cursY += 1 as libc::c_int;
    glClipY = gpBuffer
        .offset(nBuffWTbl[(480 as libc::c_int + 160 as libc::c_int) as usize] as isize)
        .offset(-((cursW + 2 as libc::c_int) as isize));
    if curs >= ICSTART as libc::c_int {
        let mut oc: libc::c_int = 197 as libc::c_int;
        if plr[myplr as usize].HoldItem._iMagical != 0 {
            oc = 181 as libc::c_int;
        }
        if plr[myplr as usize].HoldItem._iStatFlag == 0 {
            oc = 229 as libc::c_int;
        }
        OutlineCel(
            oc as uint8_t,
            cursX + 64 as libc::c_int,
            cursY + 160 as libc::c_int + cursH - 1 as libc::c_int,
            pCursCels,
            curs,
            cursW,
        );
        if oc != 229 as libc::c_int {
            DrawCel(
                cursX + 64 as libc::c_int,
                cursY + 160 as libc::c_int + cursH - 1 as libc::c_int,
                pCursCels,
                curs,
                cursW,
            );
        } else {
            DrawCelI(
                cursX + 64 as libc::c_int,
                cursY + 160 as libc::c_int + cursH - 1 as libc::c_int,
                pCursCels,
                curs,
                cursW,
                LIGHT_INFRA as libc::c_int as int8_t,
            );
        }
    } else {
        DrawCel(
            cursX + 64 as libc::c_int,
            cursY + 160 as libc::c_int + cursH - 1 as libc::c_int,
            pCursCels,
            curs,
            cursW,
        );
    };
}
#[no_mangle]
pub unsafe extern "C" fn DrawMissile(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
    mut pre: bool32_t,
) {
    let mut mx: libc::c_int = 0;
    let mut my: libc::c_int = 0;
    let mut node: *mut MissileNode = dMissile[sx as usize][sy as usize];
    while !node.is_null() {
        let mut pMiss: *mut MissileStruct = &mut *missile
            .as_mut_ptr()
            .offset((*node).missile_num as isize) as *mut MissileStruct;
        if (*pMiss)._miPreFlag != pre {
            return;
        }
        if (*pMiss)._miDrawFlag == 0 {
            return;
        }
        if ((*pMiss)._miAnimData).is_null() {
            app_fatal_(
                b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
                386 as libc::c_int,
                b"Draw Missile 2 type %d: NULL Cel Buffer\0" as *const u8
                    as *const libc::c_char,
                (*pMiss)._mitype,
            );
        }
        if (*pMiss)._miAnimFrame < 1 as libc::c_int
            || *((*pMiss)._miAnimData as *mut uint32_t)
                > MAX_FRAMES as libc::c_int as uint32_t
            || (*pMiss)._miAnimFrame > *((*pMiss)._miAnimData as *mut int32_t)
        {
            app_fatal_(
                b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
                394 as libc::c_int,
                b"Draw Missile 2: frame %d of %d, missile type==%d\0" as *const u8
                    as *const libc::c_char,
                (*pMiss)._miAnimFrame,
                *((*pMiss)._miAnimData as *mut int32_t),
                (*pMiss)._mitype,
            );
        }
        mx = (*pMiss)._mixoff + xp - (*pMiss)._miAnimWidth2;
        my = (*pMiss)._miyoff + yp;
        if (*pMiss)._miUniqTrans != 0 {
            DrawInfraUnit(
                mx,
                my,
                (*pMiss)._miAnimData,
                (*pMiss)._miAnimFrame,
                (*pMiss)._miAnimWidth,
                (LIGHT_U as libc::c_int as bool32_t)
                    .wrapping_add((*pMiss)._miUniqTrans)
                    .wrapping_sub(1 as libc::c_int as bool32_t) as int8_t,
            );
        } else if (*pMiss)._miLightFlag != 0 {
            DrawLitUnit(
                mx,
                my,
                (*pMiss)._miAnimData,
                (*pMiss)._miAnimFrame,
                (*pMiss)._miAnimWidth,
            );
        } else {
            DrawUnit(
                mx,
                my,
                (*pMiss)._miAnimData,
                (*pMiss)._miAnimFrame,
                (*pMiss)._miAnimWidth,
            );
        }
        node = (*node).next;
    }
}
#[no_mangle]
pub unsafe extern "C" fn MonsterActionString(
    mut dwAction: uint32_t,
) -> *const libc::c_char {
    if dwAction <= MM_TALK as libc::c_int as uint32_t {
        return sgszMonsterAction[dwAction as usize];
    }
    return sgszUnknownAction.as_ptr();
}
unsafe extern "C" fn DrawMCelL(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
    mut gnMI_0: libc::c_int,
) {
    if gnMI_0 as uint32_t >= MAXMONSTERS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            422 as libc::c_int,
            b"Draw Monster: tried to draw illegal monster %d\0" as *const u8
                as *const libc::c_char,
            gnMI_0,
        );
    }
    if (monster[gnMI_0 as usize]._mAnimData).is_null() {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            425 as libc::c_int,
            b"Draw Monster \"%s\": NULL Cel Buffer\0" as *const u8
                as *const libc::c_char,
            monster[gnMI_0 as usize].mName,
        );
    }
    if monster[gnMI_0 as usize]._mAnimFrame < 1 as libc::c_int
        || *(monster[gnMI_0 as usize]._mAnimData as *mut uint32_t)
            > MAX_FRAMES as libc::c_int as uint32_t
        || monster[gnMI_0 as usize]._mAnimFrame
            > *(monster[gnMI_0 as usize]._mAnimData as *mut int32_t)
    {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            435 as libc::c_int,
            b"Draw Monster \"%s\" %s: facing %d, frame %d of %d\0" as *const u8
                as *const libc::c_char,
            monster[gnMI_0 as usize].mName,
            MonsterActionString(monster[gnMI_0 as usize]._mmode as uint32_t),
            monster[gnMI_0 as usize]._mdir,
            monster[gnMI_0 as usize]._mAnimFrame,
            *(monster[gnMI_0 as usize]._mAnimData as *mut int32_t),
        );
    }
    if dFlags[sx as usize][sy as usize] as libc::c_int & BFLAG_VISIBLE as libc::c_int
        == 0
    {
        DrawInfraUnit(
            xp,
            yp,
            monster[gnMI_0 as usize]._mAnimData,
            monster[gnMI_0 as usize]._mAnimFrame,
            (*monster[gnMI_0 as usize].MType).mAnimWidth,
            LIGHT_INFRA as libc::c_int as int8_t,
        );
        return;
    }
    let mut dinfra: int8_t = LIGHT_NORM as libc::c_int as int8_t;
    if monster[gnMI_0 as usize]._uniqtype != 0 {
        dinfra = (LIGHT_U as libc::c_int
            + monster[gnMI_0 as usize]._uniqtrans as libc::c_int) as int8_t;
    }
    if monster[gnMI_0 as usize]._mmode == MM_STONE as libc::c_int {
        dinfra = LIGHT_STONE as libc::c_int as int8_t;
    }
    if plr[myplr as usize]._pInfraFlag != 0 && nLVal > 8 as libc::c_int {
        dinfra = LIGHT_INFRA as libc::c_int as int8_t;
    }
    if dinfra as libc::c_int != LIGHT_NORM as libc::c_int {
        DrawInfraUnit(
            xp,
            yp,
            monster[gnMI_0 as usize]._mAnimData,
            monster[gnMI_0 as usize]._mAnimFrame,
            (*monster[gnMI_0 as usize].MType).mAnimWidth,
            dinfra,
        );
    } else {
        DrawLitUnit(
            xp,
            yp,
            monster[gnMI_0 as usize]._mAnimData,
            monster[gnMI_0 as usize]._mAnimFrame,
            (*monster[gnMI_0 as usize].MType).mAnimWidth,
        );
    };
}
#[no_mangle]
pub unsafe extern "C" fn PlayerActionString(
    mut dwAction: uint32_t,
) -> *const libc::c_char {
    if dwAction <= PM_QUIT as libc::c_int as uint32_t {
        return sgszPlayerAction[dwAction as usize];
    }
    return sgszUnknownAction.as_ptr();
}
unsafe extern "C" fn DrawPCelL(
    mut nPlayer: libc::c_int,
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    if dFlags[sx as usize][sy as usize] as libc::c_int & BFLAG_VISIBLE as libc::c_int
        == 0 && plr[myplr as usize]._pInfraFlag == 0
        && (setlevel as libc::c_int != 0 || currlevel as libc::c_int != 0)
    {
        return;
    }
    if pCelBuff.is_null() {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            487 as libc::c_int,
            b"Drawing player %d \"%s\": NULL Cel Buffer\0" as *const u8
                as *const libc::c_char,
            nPlayer,
            (plr[nPlayer as usize]._pName).as_mut_ptr(),
        );
    }
    if nCel < 1 as libc::c_int
        || *(pCelBuff as *mut uint32_t) > MAX_FRAMES as libc::c_int as uint32_t
        || nCel > *(pCelBuff as *mut int32_t)
    {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            497 as libc::c_int,
            b"Drawing player %d \"%s\" %s: facing %d, frame %d of %d\0" as *const u8
                as *const libc::c_char,
            nPlayer,
            (plr[nPlayer as usize]._pName).as_mut_ptr(),
            PlayerActionString(plr[nPlayer as usize]._pmode as uint32_t),
            plr[nPlayer as usize]._pdir,
            nCel,
            *(pCelBuff as *mut int32_t),
        );
    }
    if nPlayer == cursplr as libc::c_int {
        DrawUnitOutline(POUTC as libc::c_int as uint8_t, xp, yp, pCelBuff, nCel, nCelW);
    }
    if nPlayer == myplr {
        DrawUnit(xp, yp, pCelBuff, nCel, nCelW);
        if plr[nPlayer as usize].pManaShield != 0 {
            DrawUnit(
                xp + plr[nPlayer as usize]._pAnimWidth2
                    - misfiledata[MF_MANASHLD as libc::c_int as usize]
                        .mAnimWidth2[0 as libc::c_int as usize],
                yp,
                misfiledata[MF_MANASHLD as libc::c_int as usize]
                    .mAnimData[0 as libc::c_int as usize],
                1 as libc::c_int,
                misfiledata[MF_MANASHLD as libc::c_int as usize]
                    .mAnimWidth[0 as libc::c_int as usize],
            );
        }
    } else if dFlags[sx as usize][sy as usize] as libc::c_int
        & BFLAG_VISIBLE as libc::c_int == 0
    {
        DrawInfraUnit(
            xp,
            yp,
            pCelBuff,
            nCel,
            nCelW,
            LIGHT_INFRA as libc::c_int as int8_t,
        );
        if plr[nPlayer as usize].pManaShield != 0 {
            DrawInfraUnit(
                xp + plr[nPlayer as usize]._pAnimWidth2
                    - misfiledata[MF_MANASHLD as libc::c_int as usize]
                        .mAnimWidth2[0 as libc::c_int as usize],
                yp,
                misfiledata[MF_MANASHLD as libc::c_int as usize]
                    .mAnimData[0 as libc::c_int as usize],
                1 as libc::c_int,
                misfiledata[MF_MANASHLD as libc::c_int as usize]
                    .mAnimWidth[0 as libc::c_int as usize],
                LIGHT_INFRA as libc::c_int as int8_t,
            );
        }
    } else {
        DrawLitUnit(xp, yp, pCelBuff, nCel, nCelW);
        if plr[nPlayer as usize].pManaShield != 0 {
            DrawLitUnit(
                xp + plr[nPlayer as usize]._pAnimWidth2
                    - misfiledata[MF_MANASHLD as libc::c_int as usize]
                        .mAnimWidth2[0 as libc::c_int as usize],
                yp,
                misfiledata[MF_MANASHLD as libc::c_int as usize]
                    .mAnimData[0 as libc::c_int as usize],
                1 as libc::c_int,
                misfiledata[MF_MANASHLD as libc::c_int as usize]
                    .mAnimWidth[0 as libc::c_int as usize],
            );
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn DrawDeadPlr(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
) {
    let mut pnum: libc::c_int = 0;
    let mut pPlayer: *mut PlayerStruct = 0 as *mut PlayerStruct;
    dFlags[sx
        as usize][sy
        as usize] = (dFlags[sx as usize][sy as usize] as libc::c_int
        & !(BFLAG_DEADPLR as libc::c_int)) as int8_t;
    pnum = 0 as libc::c_int;
    while pnum < MAX_PLRS as libc::c_int {
        pPlayer = &mut *plr.as_mut_ptr().offset(pnum as isize) as *mut PlayerStruct;
        if !((*pPlayer).plractive == 0 || (*pPlayer)._pHitPoints != 0
            || (*pPlayer).plrlevel != currlevel as libc::c_int || (*pPlayer)._px != sx
            || (*pPlayer)._py != sy)
        {
            if ((*pPlayer)._pAnimData).is_null() {
                app_fatal_(
                    b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
                    563 as libc::c_int,
                    b"Drawing dead player %d \"%s\": NULL Cel Buffer\0" as *const u8
                        as *const libc::c_char,
                    pnum,
                    ((*pPlayer)._pName).as_mut_ptr(),
                );
            }
            if (*pPlayer)._pAnimFrame < 1 as libc::c_int
                || *((*pPlayer)._pAnimData as *mut uint32_t)
                    > MAX_FRAMES as libc::c_int as uint32_t
                || (*pPlayer)._pAnimFrame > *((*pPlayer)._pAnimData as *mut int32_t)
            {
                app_fatal_(
                    b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
                    573 as libc::c_int,
                    b"Drawing dead player %d \"%s\": facing %d, frame %d of %d\0"
                        as *const u8 as *const libc::c_char,
                    pnum,
                    ((*pPlayer)._pName).as_mut_ptr(),
                    (*pPlayer)._pdir,
                    (*pPlayer)._pAnimFrame,
                    *((*pPlayer)._pAnimData as *mut int32_t),
                );
            }
            dFlags[sx
                as usize][sy
                as usize] = (dFlags[sx as usize][sy as usize] as libc::c_int
                | BFLAG_DEADPLR as libc::c_int) as int8_t;
            DrawPCelL(
                pnum,
                sx,
                sy,
                (*pPlayer)._pxoff + xp - (*pPlayer)._pAnimWidth2,
                (*pPlayer)._pyoff + yp,
                (*pPlayer)._pAnimData,
                (*pPlayer)._pAnimFrame,
                (*pPlayer)._pAnimWidth,
            );
        }
        pnum += 1;
        pnum;
    }
}
unsafe extern "C" fn DrawObjCel(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
    mut pre: bool32_t,
) {
    let mut bv: int8_t = 0;
    let mut pxp: libc::c_int = 0;
    let mut pyp: libc::c_int = 0;
    let mut odx: libc::c_int = 0;
    let mut ody: libc::c_int = 0;
    if dObject[sx as usize][sy as usize] as libc::c_int > 0 as libc::c_int {
        bv = (dObject[sx as usize][sy as usize] as libc::c_int - 1 as libc::c_int)
            as int8_t;
        if object[bv as usize]._oPreFlag != pre {
            return;
        }
        pxp = xp - object[bv as usize]._oAnimWidth2;
        pyp = yp;
    } else {
        bv = -(dObject[sx as usize][sy as usize] as libc::c_int + 1 as libc::c_int)
            as int8_t;
        if object[bv as usize]._oPreFlag != pre {
            return;
        }
        odx = object[bv as usize]._ox - sx;
        ody = object[bv as usize]._oy - sy;
        pxp = xp - object[bv as usize]._oAnimWidth2 + (odx << 5 as libc::c_int)
            - (ody << 5 as libc::c_int);
        pyp = yp + (odx << 4 as libc::c_int) + (ody << 4 as libc::c_int);
    }
    if !((bv as uint8_t as libc::c_int) < MAXOBJECTS as libc::c_int) {
        assert_fail(
            605 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"(uint8_t)bv < MAXOBJECTS\0" as *const u8 as *const libc::c_char,
        );
    }
    if (object[bv as usize]._oAnimData).is_null() {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            607 as libc::c_int,
            b"Draw Object type %d: NULL Cel Buffer\0" as *const u8
                as *const libc::c_char,
            object[bv as usize]._otype,
        );
    }
    if object[bv as usize]._oAnimFrame < 1 as libc::c_int
        || *(object[bv as usize]._oAnimData as *mut uint32_t)
            > MAX_FRAMES as libc::c_int as uint32_t
        || object[bv as usize]._oAnimFrame
            > *(object[bv as usize]._oAnimData as *mut int32_t)
    {
        app_fatal_(
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            615 as libc::c_int,
            b"Draw Object: frame %d of %d, object type==%d\0" as *const u8
                as *const libc::c_char,
            object[bv as usize]._oAnimFrame,
            *(object[bv as usize]._oAnimData as *mut int32_t),
            object[bv as usize]._otype,
        );
    }
    if bv as libc::c_int == cursobj as libc::c_int {
        OutlineCel(
            OOUTC as libc::c_int as uint8_t,
            pxp,
            pyp,
            object[bv as usize]._oAnimData,
            object[bv as usize]._oAnimFrame,
            object[bv as usize]._oAnimWidth,
        );
    }
    if object[bv as usize]._oLight != 0 {
        DrawCelL(
            pxp,
            pyp,
            object[bv as usize]._oAnimData,
            object[bv as usize]._oAnimFrame,
            object[bv as usize]._oAnimWidth,
        );
    } else {
        if (object[bv as usize]._oAnimData).is_null() {
            assert_fail(
                623 as libc::c_int,
                b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
                b"object[bv]._oAnimData\0" as *const u8 as *const libc::c_char,
            );
        }
        DrawCel(
            pxp,
            pyp,
            object[bv as usize]._oAnimData,
            object[bv as usize]._oAnimFrame,
            object[bv as usize]._oAnimWidth,
        );
    };
}
unsafe extern "C" fn DrawHTLXsub(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
) {
    let mut bFlags: int8_t = 0;
    let mut bDead: int8_t = 0;
    let mut bObject: int8_t = 0;
    let mut bItem: int8_t = 0;
    let mut bPlayer: int8_t = 0;
    let mut bSpecial: int8_t = 0;
    let mut bPlayerAbove: int8_t = 0;
    let mut bTransVal: int8_t = 0;
    let mut nMonster: libc::c_int = 0;
    let mut nMonsterAbove: libc::c_int = 0;
    if !((sx as uint32_t) < MAXDUNX as libc::c_int as uint32_t) {
        assert_fail(
            633 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)sx < MAXDUNX\0" as *const u8 as *const libc::c_char,
        );
    }
    if !((sy as uint32_t) < MAXDUNY as libc::c_int as uint32_t) {
        assert_fail(
            634 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)sy < MAXDUNY\0" as *const u8 as *const libc::c_char,
        );
    }
    bFlags = dFlags[sx as usize][sy as usize];
    bDead = dDead[sx as usize][sy as usize];
    bObject = dObject[sx as usize][sy as usize];
    bItem = dItem[sx as usize][sy as usize];
    bPlayer = dPlayer[sx as usize][sy as usize];
    bSpecial = dSpecial[sx as usize][sy as usize];
    bTransVal = dTransVal[sx as usize][sy as usize];
    nMonster = dMonster[sx as usize][sy as usize];
    if leveltype != 0 {
        if !(((sy - 1 as libc::c_int) as uint32_t) < MAXDUNY as libc::c_int as uint32_t)
        {
            assert_fail(
                645 as libc::c_int,
                b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
                b"(uint32_t)(sy - 1) < MAXDUNY\0" as *const u8 as *const libc::c_char,
            );
        }
    }
    bPlayerAbove = dPlayer[sx as usize][(sy - 1 as libc::c_int) as usize];
    nMonsterAbove = dMonster[sx as usize][(sy - 1 as libc::c_int) as usize];
    if visiondebug != 0 && bFlags as libc::c_int & BFLAG_VISIBLE as libc::c_int != 0 {
        DrawCel(xp, yp, pSquareCel, 1 as libc::c_int, 64 as libc::c_int);
    }
    if MissilePreFlag != 0 && bFlags as libc::c_int & BFLAG_MISSILE as libc::c_int != 0 {
        DrawMissile(sx, sy, xp, yp, 1 as libc::c_int as bool32_t);
    }
    if leveltype != 0 {
        if bDead != 0 {
            DrawDead(bDead, xp, yp);
        }
        if bObject != 0 {
            DrawObjCel(sx, sy, xp, yp, 1 as libc::c_int as bool32_t);
        }
    }
    if bItem != 0 {
        DrawItem(bItem, xp, yp, 0 as libc::c_int as bool32_t);
    }
    if bFlags as libc::c_int & BFLAG_PLRLR as libc::c_int != 0 {
        DrawPlayer(
            -(bPlayerAbove as libc::c_int + 1 as libc::c_int),
            sx,
            sy - 1 as libc::c_int,
            xp,
            yp,
        );
    }
    if bFlags as libc::c_int & BFLAG_MONSTLR as libc::c_int != 0 {
        gnMI = -(nMonsterAbove + 1 as libc::c_int);
        if leveltype != 0 {
            if (bFlags as libc::c_int & BFLAG_VISIBLE as libc::c_int != 0
                || plr[myplr as usize]._pInfraFlag != 0)
                && nMonsterAbove < 0 as libc::c_int
            {
                DrawMonster(sx, sy, xp, yp);
            }
        } else {
            DrawTowner(gnMI, xp, yp);
        }
    }
    if bFlags as libc::c_int & BFLAG_DEADPLR as libc::c_int != 0 {
        DrawDeadPlr(sx, sy, xp, yp);
    }
    if bPlayer as libc::c_int > 0 as libc::c_int {
        DrawPlayer(bPlayer as libc::c_int - 1 as libc::c_int, sx, sy, xp, yp);
    }
    if nMonster > 0 as libc::c_int {
        gnMI = nMonster - 1 as libc::c_int;
        if leveltype != 0 {
            if bFlags as libc::c_int & BFLAG_VISIBLE as libc::c_int != 0
                || plr[myplr as usize]._pInfraFlag != 0
            {
                DrawMonster(sx, sy, xp, yp);
            }
        } else {
            DrawTowner(gnMI, xp, yp);
        }
    }
    if bFlags as libc::c_int & BFLAG_MISSILE as libc::c_int != 0 {
        DrawMissile(sx, sy, xp, yp, 0 as libc::c_int as bool32_t);
    }
    if bObject as libc::c_int != 0 && leveltype as libc::c_int != 0 {
        DrawObjCel(sx, sy, xp, yp, 0 as libc::c_int as bool32_t);
    }
    if bItem != 0 {
        DrawItem(bItem, xp, yp, 1 as libc::c_int as bool32_t);
    }
    if bSpecial != 0 {
        if leveltype != 0 {
            nTrans = TransList[bTransVal as usize] as bool32_t;
            if USE_GOURAUD as libc::c_int != 0 {
                if nTrans != 0 {
                    nTrans = 0 as libc::c_int as bool32_t;
                    let mut dx: libc::c_int = abs(sx - plr[myplr as usize]._px);
                    let mut dy: libc::c_int = abs(sy - plr[myplr as usize]._py);
                    if dx < 4 as libc::c_int && dy < 4 as libc::c_int {
                        nTrans = 1 as libc::c_int as bool32_t;
                    }
                }
            }
            TDrawCelL(xp, yp, pSpecialCels, bSpecial as int32_t, 64 as libc::c_int);
        }
    }
}
unsafe extern "C" fn DrawHTileLineX(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut xp: libc::c_int,
    mut yp: libc::c_int,
    mut nd: libc::c_int,
    mut ev: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut t: libc::c_int = 0;
    let mut mt: *mut uint16_t = 0 as *mut uint16_t;
    if gpBuffer.is_null() {
        assert_fail(
            732 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    i = 0 as libc::c_int;
    while i < nd {
        if sy >= 0 as libc::c_int && sy < DMAXY as libc::c_int && sx >= 0 as libc::c_int
            && sx < DMAXX as libc::c_int
        {
            gnPieceNum = dPiece[sx as usize][sy as usize];
            if ORIG_LIGHTING as libc::c_int != 0 {
                if leveltype as libc::c_int == 0 as libc::c_int {
                    nLVal = 0 as libc::c_int;
                } else {
                    nLVal = dLight[sx as usize][sy as usize] as int32_t;
                }
            }
            if gnPieceNum != 0 as libc::c_int {
                pTo = gpBuffer
                    .offset(nBuffWTbl[yp as usize] as isize)
                    .offset(xp as isize);
                nTrans = (if leveltype as libc::c_int != 0 {
                    TransList[dTransVal[sx as usize][sy as usize] as usize]
                        as libc::c_int & nTransTable[gnPieceNum as usize] as libc::c_int
                } else {
                    0 as libc::c_int
                }) as bool32_t;
                if USE_GOURAUD as libc::c_int != 0 {
                    if nTrans != 0 {
                        nTrans = 0 as libc::c_int as bool32_t;
                        let mut dx: libc::c_int = abs(sx - plr[myplr as usize]._px);
                        let mut dy: libc::c_int = abs(sy - plr[myplr as usize]._py);
                        if dx < 4 as libc::c_int && dy < 4 as libc::c_int {
                            nTrans = 1 as libc::c_int as bool32_t;
                        }
                    }
                }
                mt = GetDungeonMicros(gnPieceNum);
                if leveltype as libc::c_int != 0 && lightflag == 0 {
                    MakeLitPal(
                        dung_map_r[sx as usize][sy as usize] as libc::c_int,
                        dung_map_g[sx as usize][sy as usize] as libc::c_int,
                        dung_map_b[sx as usize][sy as usize] as libc::c_int,
                    );
                } else {
                    memcpy(
                        gpLitPal.as_mut_ptr() as *mut libc::c_void,
                        gpPalette.as_mut_ptr() as *const libc::c_void,
                        (256 as libc::c_int * 4 as libc::c_int) as libc::c_ulong,
                    );
                }
                if USE_GOURAUD as libc::c_int != 0 {
                    let mut total: libc::c_int = if leveltype as libc::c_int != 0 {
                        (MicroTileLen >> 1 as libc::c_int) - 1 as libc::c_int
                    } else {
                        MicroTileLen >> 1 as libc::c_int
                    };
                    let mut last: libc::c_int = 0 as libc::c_int;
                    let mut first: libc::c_int = -(1 as libc::c_int);
                    t = 0 as libc::c_int;
                    while t < total {
                        if first == -(1 as libc::c_int) {
                            if *mt.offset(0 as libc::c_int as isize) as libc::c_int != 0
                                || *mt.offset(1 as libc::c_int as isize) as libc::c_int != 0
                            {
                                first = t;
                            }
                        }
                        if *mt.offset(0 as libc::c_int as isize) as libc::c_int != 0
                            || *mt.offset(1 as libc::c_int as isize) as libc::c_int != 0
                        {
                            last = t;
                        }
                        mt = mt.offset(-(2 as libc::c_int as isize));
                        t += 1;
                        t;
                    }
                    tile_skip = first * 32 as libc::c_int;
                    tile_height = (last + 1 as libc::c_int) * 32 as libc::c_int;
                    static mut made: bool32_t = 0 as libc::c_int as bool32_t;
                    if made == 0 {
                        MakeVals();
                        made = 1 as libc::c_int as bool32_t;
                    }
                    if leveltype != 0 {
                        if nTrans != 0 {
                            let mut type_0: libc::c_int = 2 as libc::c_int;
                            if leveltype as libc::c_int == 3 as libc::c_int {
                                type_0 = 27 as libc::c_int;
                            }
                            if leveltype as libc::c_int == 4 as libc::c_int {
                                type_0 = 17 as libc::c_int;
                            }
                            DrawCelL(xp, yp, pDungeonCels, type_0, 64 as libc::c_int);
                        }
                        DrawCelG(
                            xp,
                            yp,
                            pDungeonCels,
                            gnPieceNum,
                            64 as libc::c_int,
                            sx,
                            sy,
                        );
                    } else {
                        DrawCel(xp, yp, pDungeonCels, gnPieceNum, 64 as libc::c_int);
                    }
                } else {
                    gbPartialTrans = PART_TRANS_LEFT as libc::c_int as int8_t;
                    gdwPNum = *mt.offset(0 as libc::c_int as isize) as uint32_t;
                    if gdwPNum != 0 {
                        DecodeMicroTile(pTo);
                    }
                    gbPartialTrans = PART_TRANS_RIGHT as libc::c_int as int8_t;
                    gdwPNum = *mt.offset(1 as libc::c_int as isize) as uint32_t;
                    if gdwPNum != 0 {
                        DecodeMicroTile(pTo.offset(32 as libc::c_int as isize));
                    }
                    mt = mt.offset(-(2 as libc::c_int as isize));
                    gbPartialTrans = PART_TRANS_NONE as libc::c_int as int8_t;
                    let mut total_0: libc::c_int = if leveltype as libc::c_int != 0 {
                        (MicroTileLen >> 1 as libc::c_int) - 1 as libc::c_int
                    } else {
                        MicroTileLen >> 1 as libc::c_int
                    };
                    t = 1 as libc::c_int;
                    while t < total_0 {
                        pTo = pTo.offset(-(NBUFFWSL5 as libc::c_int as isize));
                        if ev >= t {
                            gdwPNum = *mt.offset(0 as libc::c_int as isize) as uint32_t;
                            if gdwPNum != 0 {
                                DecodeMicroTile(pTo);
                            }
                            gdwPNum = *mt.offset(1 as libc::c_int as isize) as uint32_t;
                            if gdwPNum != 0 {
                                DecodeMicroTile(pTo.offset(32 as libc::c_int as isize));
                            }
                            mt = mt.offset(-(2 as libc::c_int as isize));
                        }
                        t += 1;
                        t;
                    }
                }
                DrawHTLXsub(sx, sy, xp, yp);
            } else {
                pTo = gpBuffer
                    .offset(nBuffWTbl[yp as usize] as isize)
                    .offset(xp as isize);
                DrawBlankMini(pTo);
            }
        } else if leveltype == 0 {
            pTo = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
            DrawBlankMini(pTo);
        }
        sx += 1;
        sx;
        sy -= 1;
        sy;
        xp += 64 as libc::c_int;
        i += 1;
        i;
    }
}
unsafe extern "C" fn VGADraw() {
    let mut i: libc::c_int = 0;
    let mut csrc: int32_t = 0;
    let mut cdest: int32_t = 0;
    let mut cw: int32_t = 0;
    let mut ch: int32_t = 0;
    let mut pFrom: *mut uint32_t = 0 as *mut uint32_t;
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pTo2: *mut uint32_t = 0 as *mut uint32_t;
    if chrflag != 0 || questlog != 0 {
        csrc = 245168 as libc::c_int;
        cdest = 392064 as libc::c_int;
        cw = 160 as libc::c_int;
    } else if invflag != 0 || sbookflag != 0 {
        csrc = 245168 as libc::c_int;
        cdest = 391744 as libc::c_int;
        cw = 160 as libc::c_int;
    } else {
        csrc = 245088 as libc::c_int;
        cdest = 391744 as libc::c_int;
        cw = 320 as libc::c_int;
    }
    ch = 176 as libc::c_int;
    if gpBuffer.is_null() {
        assert_fail(
            875 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = &mut *gpBuffer.offset(csrc as isize) as *mut uint32_t;
    pTo = &mut *gpBuffer.offset(cdest as isize) as *mut uint32_t;
    pTo2 = &mut *gpBuffer.offset((cdest + 768 as libc::c_int) as isize) as *mut uint32_t;
    loop {
        let fresh2 = ch;
        ch = ch - 1;
        if !(fresh2 != 0) {
            break;
        }
        i = cw;
        loop {
            let fresh3 = i;
            i = i - 1;
            if !(fresh3 != 0) {
                break;
            }
            let fresh4 = pTo;
            pTo = pTo.offset(1);
            *fresh4 = *pFrom;
            let fresh5 = pTo;
            pTo = pTo.offset(1);
            *fresh5 = *pFrom;
            let fresh6 = pTo2;
            pTo2 = pTo2.offset(1);
            *fresh6 = *pFrom;
            let fresh7 = pTo2;
            pTo2 = pTo2.offset(1);
            *fresh7 = *pFrom;
            pFrom = pFrom.offset(1);
            pFrom;
        }
        pFrom = pFrom.offset(-((768 as libc::c_int + cw) as isize));
        pTo = pTo.offset(-((2 as libc::c_int * (768 as libc::c_int + cw)) as isize));
        pTo2 = pTo2.offset(-((2 as libc::c_int * (768 as libc::c_int + cw)) as isize));
    };
}
unsafe extern "C" fn DrawMap(mut StartX: libc::c_int, mut StartY: libc::c_int) {
    let mut xpos: libc::c_int = 0;
    let mut ypos: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut width: libc::c_int = 0;
    let mut height: libc::c_int = 0;
    if svgamode != 0 {
        xpos = 64 as libc::c_int + ScrollInfo._sxoff;
        ypos = 175 as libc::c_int + ScrollInfo._syoff;
        StartX -= 10 as libc::c_int;
        StartY -= 1 as libc::c_int;
        width = 10 as libc::c_int;
        height = if leveltype as libc::c_int != 0 {
            16 as libc::c_int
        } else {
            19 as libc::c_int
        };
        if chrflag != 0 || questlog != 0 {
            StartX += 2 as libc::c_int;
            StartY -= 2 as libc::c_int;
            xpos += 288 as libc::c_int;
            width = 6 as libc::c_int;
        }
        if invflag != 0 || sbookflag != 0 {
            StartX += 2 as libc::c_int;
            StartY -= 2 as libc::c_int;
            xpos -= 32 as libc::c_int;
            width = 6 as libc::c_int;
        }
    } else {
        xpos = 64 as libc::c_int + ScrollInfo._sxoff;
        ypos = 143 as libc::c_int + ScrollInfo._syoff;
        StartX -= 6 as libc::c_int;
        StartY -= 1 as libc::c_int;
        width = 6 as libc::c_int;
        height = if leveltype as libc::c_int != 0 {
            11 as libc::c_int
        } else {
            14 as libc::c_int
        };
    }
    let mut current_block_44: u64;
    match ScrollInfo._sdir {
        2 => {
            width += 1;
            width;
            current_block_44 = 2499330056484162728;
        }
        1 => {
            current_block_44 = 2499330056484162728;
        }
        4 => {
            height += 1;
            height;
            current_block_44 = 4209605825518586371;
        }
        3 => {
            current_block_44 = 4209605825518586371;
        }
        5 => {
            height += 1;
            height;
            current_block_44 = 10692455896603418738;
        }
        6 => {
            height += 1;
            height;
            current_block_44 = 4681807859281808438;
        }
        7 => {
            current_block_44 = 4681807859281808438;
        }
        8 => {
            xpos -= 64 as libc::c_int;
            ypos -= 32 as libc::c_int;
            StartX -= 2 as libc::c_int;
            width += 1;
            width;
            height += 1;
            height;
            current_block_44 = 10692455896603418738;
        }
        _ => {
            current_block_44 = 10692455896603418738;
        }
    }
    match current_block_44 {
        4681807859281808438 => {
            xpos -= 64 as libc::c_int;
            StartX -= 1;
            StartX;
            StartY += 1;
            StartY;
            width += 1;
            width;
        }
        2499330056484162728 => {
            ypos -= 32 as libc::c_int;
            StartX -= 1;
            StartX;
            StartY -= 1;
            StartY;
            height += 1;
            height;
        }
        4209605825518586371 => {
            width += 1;
            width;
        }
        _ => {}
    }
    i = 0 as libc::c_int;
    while i < height {
        DrawHTileLineX(StartX, StartY, xpos, ypos, width, i);
        StartY += 1;
        StartY;
        xpos -= 32 as libc::c_int;
        ypos += 16 as libc::c_int;
        DrawHTileLineX(StartX, StartY, xpos, ypos, width + 1 as libc::c_int, i);
        StartX += 1;
        StartX;
        xpos += 32 as libc::c_int;
        ypos += 16 as libc::c_int;
        i += 1;
        i;
    }
    if svgamode == 0 {
        VGADraw();
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawView(mut StartX: libc::c_int, mut StartY: libc::c_int) {
    if gpBuffer.is_null() {
        assert_fail(
            985 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    DrawMap(StartX, StartY);
    if automapflag != 0 {
        DrawAutomap();
    }
    if stextflag as libc::c_int != 0 && qtextflag == 0 {
        DrawSText();
    }
    if invflag != 0 {
        DrawInv();
    } else if sbookflag != 0 {
        DrawSpellBook();
    }
    DrawDurIcon();
    if chrflag != 0 {
        DrawChr();
    } else if questlog != 0 {
        DrawQuestLog();
    } else if plr[myplr as usize]._pStatPts != 0 as libc::c_int && spselflag == 0 {
        DrawLevelUpIcon();
    }
    if uitemflag != 0 {
        DrawUniqueInfo();
    }
    if qtextflag != 0 {
        DrawQText();
    }
    if spselflag != 0 {
        DrawSpellList();
    }
    if dropGoldFlag != 0 {
        DrawGoldBox(dropGoldValue);
    }
    if helpflag != 0 {
        DrawHelp();
    }
    if msgflag != 0 {
        DrawDiabloMsg();
    }
    if deathflag != 0 {
        RedBack();
    } else if PauseMode != 0 {
        DrawPause();
    }
    plrmsg_draw();
    gmenu_draw();
    DrawMapOfDoom();
    DrawInfoBox();
    DrawHealthTop();
    DrawManaTop();
}
#[no_mangle]
pub unsafe extern "C" fn ClrDraw() {
    let mut i: libc::c_int = 0;
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    lock_buf(3 as libc::c_int as uint8_t);
    if gpBuffer.is_null() {
        assert_fail(
            1054 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    pTo = &mut *gpBuffer
        .offset(
            (0 as libc::c_int + 64 as libc::c_int
                + (0 as libc::c_int + 160 as libc::c_int) * 768 as libc::c_int) as isize,
        ) as *mut uint32_t;
    i = 0 as libc::c_int;
    while i < 480 as libc::c_int {
        memset(
            pTo as *mut libc::c_void,
            0 as libc::c_int,
            (640 as libc::c_int * 4 as libc::c_int) as libc::c_ulong,
        );
        pTo = pTo.offset(768 as libc::c_int as isize);
        i += 1;
        i;
    }
    unlock_buf(3 as libc::c_int as uint8_t);
}
#[no_mangle]
pub unsafe extern "C" fn CheckForScroll() {
    if curs >= ICSTART as libc::c_int {
        return;
    }
    let mut dminx: libc::c_int = 0;
    let mut dminy: libc::c_int = 0;
    let mut dmaxx: libc::c_int = 0;
    let mut dmaxy: libc::c_int = 0;
    if leveltype != 0 {
        dminx = DIRTEDGED2 as libc::c_int;
        dminy = DIRTEDGED2 as libc::c_int;
        dmaxx = DMAXX as libc::c_int - DIRTEDGED2 as libc::c_int;
        dmaxy = DMAXY as libc::c_int - DIRTEDGED2 as libc::c_int;
    } else {
        dminx = 10 as libc::c_int;
        dminy = 10 as libc::c_int;
        dmaxx = 84 as libc::c_int;
        dmaxy = 84 as libc::c_int;
    }
    let mut bScrollUpdate: bool32_t = 0 as libc::c_int as bool32_t;
    if MouseX < 20 as libc::c_int {
        if ViewY < dmaxy - 1 as libc::c_int && ViewX > dminx {
            ViewY += 1;
            ViewY;
            ViewX -= 1;
            ViewX;
            bScrollUpdate = 1 as libc::c_int as bool32_t;
        } else {
            if ViewY < dmaxy - 1 as libc::c_int {
                ViewY += 1;
                ViewY;
                bScrollUpdate = 1 as libc::c_int as bool32_t;
            }
            if ViewX > dminx {
                ViewX -= 1;
                ViewX;
                bScrollUpdate = 1 as libc::c_int as bool32_t;
            }
        }
    }
    if MouseX > 620 as libc::c_int {
        if ViewX < dmaxx - 1 as libc::c_int && ViewY > dminy {
            ViewY -= 1;
            ViewY;
            ViewX += 1;
            ViewX;
            bScrollUpdate = 1 as libc::c_int as bool32_t;
        } else {
            if ViewX < dmaxx - 1 as libc::c_int {
                ViewX += 1;
                ViewX;
                bScrollUpdate = 1 as libc::c_int as bool32_t;
            }
            if ViewY > dminy {
                ViewY -= 1;
                ViewY;
                bScrollUpdate = 1 as libc::c_int as bool32_t;
            }
        }
    }
    if MouseY < 20 as libc::c_int {
        if ViewY > dminy && ViewX > dminx {
            ViewX -= 1;
            ViewX;
            ViewY -= 1;
            ViewY;
            bScrollUpdate = 1 as libc::c_int as bool32_t;
        } else {
            if ViewY > dminy {
                ViewY -= 1;
                ViewY;
                bScrollUpdate = 1 as libc::c_int as bool32_t;
            }
            if ViewX > dminx {
                ViewX -= 1;
                ViewX;
                bScrollUpdate = 1 as libc::c_int as bool32_t;
            }
        }
    }
    if MouseY > 460 as libc::c_int {
        if ViewY < dmaxy - 1 as libc::c_int && ViewX < dmaxx - 1 as libc::c_int {
            ViewX += 1;
            ViewX;
            ViewY += 1;
            ViewY;
            bScrollUpdate = 1 as libc::c_int as bool32_t;
        } else {
            if ViewY < dmaxy - 1 as libc::c_int {
                ViewY += 1;
                ViewY;
                bScrollUpdate = 1 as libc::c_int as bool32_t;
            }
            if ViewX < dmaxx - 1 as libc::c_int {
                ViewX += 1;
                ViewX;
                bScrollUpdate = 1 as libc::c_int as bool32_t;
            }
        }
    }
    if bScrollUpdate != 0 {
        ScrollInfo._sdir = SCRL_NONE as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn toggle_frame_counter() {
    if DEBUG as libc::c_int == 0 {
        return;
    }
    sgfFrameCounterEnabled = (sgfFrameCounterEnabled == 0) as libc::c_int as uint8_t;
    sgnLastFrame = SDL_GetTicks();
}
unsafe extern "C" fn draw_frame_rate() {
    if DEBUG as libc::c_int == 0 {
        return;
    }
    if sgfFrameCounterEnabled == 0 {
        return;
    }
    let mut nTimeSpent: libc::c_int = 0;
    let mut nThisFrame: uint32_t = 0;
    snFrameCount += 1;
    snFrameCount;
    nThisFrame = SDL_GetTicks();
    if nThisFrame.wrapping_sub(sgnLastFrame) >= 1000 as libc::c_int as uint32_t {
        nTimeSpent = nThisFrame.wrapping_sub(sgnLastFrame) as libc::c_int;
        sgnLastFrame = nThisFrame;
        nFrameRate = snFrameCount * 1000 as libc::c_int / nTimeSpent;
        snFrameCount = 0 as libc::c_int;
    }
    ConsolePrintXY(
        640 as libc::c_int,
        0 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"%d FPS\0" as *const u8 as *const libc::c_char,
        nFrameRate,
    );
    ConsolePrintXY(
        160 as libc::c_int,
        0 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Objects: %d\0" as *const u8 as *const libc::c_char,
        numobjects,
    );
    ConsolePrintXY(
        160 as libc::c_int,
        12 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Monsters: %d\0" as *const u8 as *const libc::c_char,
        nummonsters,
    );
    ConsolePrintXY(
        160 as libc::c_int,
        24 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Triggers: %d\0" as *const u8 as *const libc::c_char,
        numtrigs,
    );
    ConsolePrintXY(
        280 as libc::c_int,
        0 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Items: %d\0" as *const u8 as *const libc::c_char,
        numitems,
    );
    ConsolePrintXY(
        280 as libc::c_int,
        12 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Missiles: %d\0" as *const u8 as *const libc::c_char,
        nummissiles,
    );
    ConsolePrintXY(
        280 as libc::c_int,
        24 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Themes: %d\0" as *const u8 as *const libc::c_char,
        numthemes,
    );
    ConsolePrintXY(
        400 as libc::c_int,
        0 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Lights: %d\0" as *const u8 as *const libc::c_char,
        numlights,
    );
    ConsolePrintXY(
        400 as libc::c_int,
        12 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Vision: %d\0" as *const u8 as *const libc::c_char,
        numvision,
    );
    ConsolePrintXY(
        400 as libc::c_int,
        24 as libc::c_int,
        0 as libc::c_int as bool32_t,
        b"Players: %d\0" as *const u8 as *const libc::c_char,
        gbActivePlayers as libc::c_int,
    );
}
unsafe extern "C" fn ScreenBlt(
    mut ysize: int32_t,
    mut tbox: bool32_t,
    mut hp: bool32_t,
    mut mana: bool32_t,
    mut spdbar: bool32_t,
    mut btns: bool32_t,
) {
    if bActive == 0 {
        return;
    }
    if DEBUG as libc::c_int != 0 {
        lock_buf(0 as libc::c_int as uint8_t);
        draw_frame_rate();
        unlock_buf(0 as libc::c_int as uint8_t);
    }
    if !(ysize >= 0 as libc::c_int && ysize <= 480 as libc::c_int) {
        assert_fail(
            1222 as libc::c_int,
            b"src/scrollrt.c\0" as *const u8 as *const libc::c_char,
            b"ysize >= 0 && ysize <= 480\0" as *const u8 as *const libc::c_char,
        );
    }
    if ysize > 0 as libc::c_int {
        SdlSysBlit(
            0 as libc::c_int as uint32_t,
            0 as libc::c_int as uint32_t,
            (160 as libc::c_int * 4 as libc::c_int) as uint32_t,
            ysize as uint32_t,
        );
    }
    if ysize < TOTALY as libc::c_int {
        if spdbar != 0 {
            SdlSysBlit(
                204 as libc::c_int as uint32_t,
                357 as libc::c_int as uint32_t,
                (58 as libc::c_int * 4 as libc::c_int) as uint32_t,
                28 as libc::c_int as uint32_t,
            );
        }
        if tbox != 0 {
            SdlSysBlit(
                176 as libc::c_int as uint32_t,
                392 as libc::c_int as uint32_t,
                (72 as libc::c_int * 4 as libc::c_int) as uint32_t,
                70 as libc::c_int as uint32_t,
            );
        }
        if mana != 0 {
            SdlSysBlit(
                460 as libc::c_int as uint32_t,
                352 as libc::c_int as uint32_t,
                (22 as libc::c_int * 4 as libc::c_int) as uint32_t,
                72 as libc::c_int as uint32_t,
            );
            SdlSysBlit(
                564 as libc::c_int as uint32_t,
                416 as libc::c_int as uint32_t,
                (14 as libc::c_int * 4 as libc::c_int) as uint32_t,
                56 as libc::c_int as uint32_t,
            );
        }
        if hp != 0 {
            SdlSysBlit(
                96 as libc::c_int as uint32_t,
                352 as libc::c_int as uint32_t,
                (22 as libc::c_int * 4 as libc::c_int) as uint32_t,
                72 as libc::c_int as uint32_t,
            );
        }
        if btns != 0 {
            SdlSysBlit(
                8 as libc::c_int as uint32_t,
                357 as libc::c_int as uint32_t,
                (18 as libc::c_int * 4 as libc::c_int) as uint32_t,
                119 as libc::c_int as uint32_t,
            );
            SdlSysBlit(
                556 as libc::c_int as uint32_t,
                357 as libc::c_int as uint32_t,
                (18 as libc::c_int * 4 as libc::c_int) as uint32_t,
                48 as libc::c_int as uint32_t,
            );
            if gbMaxPlayers as libc::c_int > 1 as libc::c_int {
                SdlSysBlit(
                    84 as libc::c_int as uint32_t,
                    443 as libc::c_int as uint32_t,
                    (9 as libc::c_int * 4 as libc::c_int) as uint32_t,
                    32 as libc::c_int as uint32_t,
                );
                SdlSysBlit(
                    524 as libc::c_int as uint32_t,
                    443 as libc::c_int as uint32_t,
                    (9 as libc::c_int * 4 as libc::c_int) as uint32_t,
                    32 as libc::c_int as uint32_t,
                );
            }
        }
        if sgdwOldWdt != 0 {
            SdlSysBlit(sgdwOldX, sgdwOldY, sgdwOldWdt, sgdwOldHgt);
        }
        if sgdwCursWdt != 0 {
            SdlSysBlit(sgdwCursX, sgdwCursY, sgdwCursWdt, sgdwCursHgt);
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn FullBlit(mut bArrow: bool32_t) {
    let mut y: libc::c_int = 0;
    if force_redraw == FULLDRAW as libc::c_int {
        force_redraw = NODRAW as libc::c_int;
        y = TOTALY as libc::c_int;
    } else {
        y = 0 as libc::c_int;
    }
    if bArrow != 0 {
        lock_buf(0 as libc::c_int as uint8_t);
        savecrsr_show();
        unlock_buf(0 as libc::c_int as uint8_t);
    }
    ScreenBlt(
        y,
        0 as libc::c_int as bool32_t,
        0 as libc::c_int as bool32_t,
        0 as libc::c_int as bool32_t,
        0 as libc::c_int as bool32_t,
        0 as libc::c_int as bool32_t,
    );
    if bArrow != 0 {
        lock_buf(0 as libc::c_int as uint8_t);
        savecrsr_hide();
        unlock_buf(0 as libc::c_int as uint8_t);
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawAndBlit() {
    let mut tBox: bool32_t = 0;
    let mut ctrlPan: bool32_t = 0;
    let mut ysize: int32_t = 0;
    if gbRunGame == 0 {
        return;
    }
    if force_redraw == FULLDRAW as libc::c_int {
        drawhpflag = 1 as libc::c_int as bool32_t;
        drawmanaflag = 1 as libc::c_int as bool32_t;
        drawbtnflag = 1 as libc::c_int as bool32_t;
        drawsbarflag = 1 as libc::c_int as bool32_t;
        tBox = 0 as libc::c_int as bool32_t;
        ctrlPan = 1 as libc::c_int as bool32_t;
        ysize = TOTALY as libc::c_int;
    } else if force_redraw == VIEWDRAW as libc::c_int {
        tBox = 1 as libc::c_int as bool32_t;
        ctrlPan = 0 as libc::c_int as bool32_t;
        ysize = GAMEY as libc::c_int;
    } else {
        return
    }
    force_redraw = NODRAW as libc::c_int;
    lock_buf(0 as libc::c_int as uint8_t);
    glClipY = gpBuffer
        .offset(nBuffWTbl[(352 as libc::c_int + 160 as libc::c_int) as usize] as isize);
    DrawView(ViewX, ViewY);
    glClipY = gpBuffer
        .offset(nBuffWTbl[(480 as libc::c_int + 160 as libc::c_int) as usize] as isize);
    if ctrlPan != 0 {
        DrawCtrlPan();
    }
    if drawhpflag != 0 {
        DrawHealthBar();
    }
    if drawmanaflag != 0 {
        DrawManaBar();
    }
    if drawbtnflag != 0 {
        DrawButtons();
    }
    if drawsbarflag != 0 {
        DrawSpdBar();
    }
    if talkflag != 0 {
        DrawTalkBox();
        ysize = TOTALY as libc::c_int;
    }
    savecrsr_show();
    unlock_buf(0 as libc::c_int as uint8_t);
    ScreenBlt(ysize, tBox, drawhpflag, drawmanaflag, drawsbarflag, drawbtnflag);
    lock_buf(0 as libc::c_int as uint8_t);
    savecrsr_hide();
    unlock_buf(0 as libc::c_int as uint8_t);
    drawhpflag = 0 as libc::c_int as bool32_t;
    drawmanaflag = 0 as libc::c_int as bool32_t;
    drawbtnflag = 0 as libc::c_int as bool32_t;
    drawsbarflag = 0 as libc::c_int as bool32_t;
}
