use ::libc;
extern "C" {
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    static mut gpBuffer: *mut uint32_t;
    static mut svgamode: bool32_t;
    static mut pDungeonCels: *mut uint8_t;
    static mut nWTypeTable: [uint8_t; 2049];
    static mut lightmax: int8_t;
    static mut pLightTbl: *mut uint8_t;
    static mut gpPalette: [uint32_t; 256];
    static mut gpLitPal: [uint32_t; 256];
    static mut nTrans: bool32_t;
    static mut nLVal: int32_t;
    static mut gnPieceNum: libc::c_int;
    static mut gbPartialTrans: int8_t;
    static mut gdwPNum: uint32_t;
    static mut glClipY: *mut uint32_t;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed = 92160;
pub const BTMBUFFY: C2RustUnnamed = 144;
pub const BTMBUFFX: C2RustUnnamed = 640;
pub const BUFFERSIZE: C2RustUnnamed = 503808;
pub const BUFFERY: C2RustUnnamed = 656;
pub const BUFFERX: C2RustUnnamed = 768;
pub const GAMEY: C2RustUnnamed = 352;
pub const CTRLPANY: C2RustUnnamed = 128;
pub const TOTALY: C2RustUnnamed = 480;
pub const TOTALX: C2RustUnnamed = 640;
pub const MAX_PLRS: C2RustUnnamed = 4;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const G_BRIGHT_LIGHTS: C2RustUnnamed_0 = 0;
pub const USE_GOURAUD: C2RustUnnamed_0 = 0;
pub const ORIG_LIGHTING: C2RustUnnamed_0 = 1;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const NBUFFW64: C2RustUnnamed_1 = 832;
pub const NBUFFW32: C2RustUnnamed_1 = 800;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const WTYPE_LRC: C2RustUnnamed_2 = 4;
pub const WTYPE_ULC: C2RustUnnamed_2 = 3;
pub const WTYPE_RIGHT: C2RustUnnamed_2 = 2;
pub const WTYPE_LEFT: C2RustUnnamed_2 = 1;
pub const WTYPE_NONE: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const PART_TRANS_RIGHT: C2RustUnnamed_3 = 2;
pub const PART_TRANS_LEFT: C2RustUnnamed_3 = 1;
pub const PART_TRANS_NONE: C2RustUnnamed_3 = 0;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const MICRO_RTWALL: C2RustUnnamed_4 = 5;
pub const MICRO_LTWALL: C2RustUnnamed_4 = 4;
pub const MICRO_RIGHT: C2RustUnnamed_4 = 3;
pub const MICRO_LEFT: C2RustUnnamed_4 = 2;
pub const MICRO_HOLES: C2RustUnnamed_4 = 1;
pub const MICRO_SOLID: C2RustUnnamed_4 = 0;
static mut sgRightMask: [uint32_t; 32] = [
    0xc0000000 as libc::c_uint,
    0xf0000000 as libc::c_uint,
    0xfc000000 as libc::c_uint,
    0xff000000 as libc::c_uint,
    0xffc00000 as libc::c_uint,
    0xfff00000 as libc::c_uint,
    0xfffc0000 as libc::c_uint,
    0xffff0000 as libc::c_uint,
    0xffffc000 as libc::c_uint,
    0xfffff000 as libc::c_uint,
    0xfffffc00 as libc::c_uint,
    0xffffff00 as libc::c_uint,
    0xffffffc0 as libc::c_uint,
    0xfffffff0 as libc::c_uint,
    0xfffffffc as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
];
static mut sgLeftMask: [uint32_t; 32] = [
    0x3 as libc::c_int as uint32_t,
    0xf as libc::c_int as uint32_t,
    0x3f as libc::c_int as uint32_t,
    0xff as libc::c_int as uint32_t,
    0x3ff as libc::c_int as uint32_t,
    0xfff as libc::c_int as uint32_t,
    0x3fff as libc::c_int as uint32_t,
    0xffff as libc::c_int as uint32_t,
    0x3ffff as libc::c_int as uint32_t,
    0xfffff as libc::c_int as uint32_t,
    0x3fffff as libc::c_int as uint32_t,
    0xffffff as libc::c_int as uint32_t,
    0x3ffffff as libc::c_int as uint32_t,
    0xfffffff as libc::c_int as uint32_t,
    0x3fffffff as libc::c_int as uint32_t,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
];
static mut sgFullMask: [uint32_t; 32] = [
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
    0 as libc::c_int as uint32_t,
];
static mut sgNoMask: [uint32_t; 32] = [
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
    0xffffffff as libc::c_uint,
];
unsafe extern "C" fn DecodeLine(
    mut dst: *mut *mut uint32_t,
    mut src: *mut *mut uint8_t,
    mut nWidth: libc::c_int,
    mut mask: uint32_t,
) {
    let mut i: libc::c_int = 0;
    let mut s: *mut uint8_t = 0 as *mut uint8_t;
    let mut d: *mut uint32_t = 0 as *mut uint32_t;
    let mut tbl: *mut uint8_t = &mut *pLightTbl
        .offset((nLVal << 8 as libc::c_int) as isize) as *mut uint8_t;
    s = *src;
    d = *dst;
    *src = (*src).offset(nWidth as isize);
    *dst = (*dst).offset(nWidth as isize);
    if svgamode != 0 {
        if d
            < &mut *gpBuffer
                .offset(
                    ((0 as libc::c_int + 160 as libc::c_int) * BUFFERX as libc::c_int)
                        as isize,
                ) as *mut uint32_t
            || d
                > &mut *gpBuffer
                    .offset(
                        ((352 as libc::c_int + 160 as libc::c_int)
                            * BUFFERX as libc::c_int) as isize,
                    ) as *mut uint32_t
        {
            return;
        }
    } else if d
        < &mut *gpBuffer
            .offset(
                ((-(17 as libc::c_int) + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
        || d
            > &mut *gpBuffer
                .offset(
                    ((160 as libc::c_int + 160 as libc::c_int) * BUFFERX as libc::c_int)
                        as isize,
                ) as *mut uint32_t
    {
        return
    }
    if mask == 0xffffffff as libc::c_uint {
        if ORIG_LIGHTING as libc::c_int != 0 {
            if nLVal == lightmax as libc::c_int {
                memset(
                    d as *mut libc::c_void,
                    0 as libc::c_int,
                    (nWidth * 4 as libc::c_int) as libc::c_ulong,
                );
            } else if nLVal == 0 as libc::c_int {
                i = 0 as libc::c_int;
                while i < nWidth {
                    let mut color: uint32_t = gpPalette[*s.offset(i as isize) as usize];
                    *d.offset(i as isize) = color;
                    i += 1;
                    i;
                }
            } else {
                i = 0 as libc::c_int;
                while i < nWidth {
                    let mut color_0: uint32_t = gpPalette[*tbl
                        .offset(*s.offset(i as isize) as isize) as usize];
                    *d.offset(i as isize) = color_0;
                    i += 1;
                    i;
                }
            }
        } else {
            i = 0 as libc::c_int;
            while i < nWidth {
                *d.offset(i as isize) = gpLitPal[*s.offset(i as isize) as usize];
                i += 1;
                i;
            }
        }
    } else if ORIG_LIGHTING as libc::c_int != 0 {
        if nLVal == lightmax as libc::c_int {
            i = 0 as libc::c_int;
            while i < nWidth {
                if mask & 0x80000000 as libc::c_uint != 0 {
                    *d.offset(i as isize) = 0 as libc::c_int as uint32_t;
                }
                mask <<= 1 as libc::c_int;
                i += 1;
                i;
            }
        } else if nLVal == 0 as libc::c_int {
            i = 0 as libc::c_int;
            while i < nWidth {
                if mask & 0x80000000 as libc::c_uint != 0 {
                    *d.offset(i as isize) = gpPalette[*s.offset(i as isize) as usize];
                }
                mask <<= 1 as libc::c_int;
                i += 1;
                i;
            }
        } else {
            i = 0 as libc::c_int;
            while i < nWidth {
                if mask & 0x80000000 as libc::c_uint != 0 {
                    *d
                        .offset(
                            i as isize,
                        ) = gpPalette[*tbl.offset(*s.offset(i as isize) as isize)
                        as usize];
                }
                mask <<= 1 as libc::c_int;
                i += 1;
                i;
            }
        }
    } else {
        i = 0 as libc::c_int;
        while i < nWidth {
            let mut color_1: uint32_t = gpLitPal[*s.offset(i as isize) as usize];
            if mask & 0x80000000 as libc::c_uint != 0 {
                *d.offset(i as isize) = color_1;
            } else {
                *d
                    .offset(
                        i as isize,
                    ) = (*d.offset(i as isize) & 0xfefefe as libc::c_int as uint32_t)
                    .wrapping_add(color_1 & 0xfefefe as libc::c_int as uint32_t)
                    >> 1 as libc::c_int;
            }
            mask <<= 1 as libc::c_int;
            i += 1;
            i;
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn DecodeMicroTile(mut pDecodeTo: *mut uint32_t) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut bBlock: int8_t = 0;
    let mut mt: uint8_t = 0;
    let mut wt: uint8_t = 0;
    let mut src: *mut uint8_t = 0 as *mut uint8_t;
    let mut dst: *mut uint32_t = 0 as *mut uint32_t;
    let mut cm: uint32_t = 0;
    let mut mask: *mut uint32_t = 0 as *mut uint32_t;
    dst = pDecodeTo;
    src = &mut *pDungeonCels
        .offset(
            *(pDungeonCels as *mut uint32_t)
                .offset((gdwPNum & 0xfff as libc::c_int as uint32_t) as isize) as isize,
        ) as *mut uint8_t;
    mt = ((gdwPNum & 0x7000 as libc::c_int as uint32_t) >> 12 as libc::c_int) as uint8_t;
    mask = &mut *sgNoMask.as_mut_ptr().offset(31 as libc::c_int as isize)
        as *mut uint32_t;
    if nTrans != 0 {
        if gbPartialTrans as libc::c_int == PART_TRANS_NONE as libc::c_int {
            mask = &mut *sgFullMask.as_mut_ptr().offset(31 as libc::c_int as isize)
                as *mut uint32_t;
        }
        if gbPartialTrans as libc::c_int == PART_TRANS_LEFT as libc::c_int
            && mt as libc::c_int != MICRO_LEFT as libc::c_int
        {
            wt = nWTypeTable[gnPieceNum as usize];
            if wt as libc::c_int == WTYPE_LEFT as libc::c_int
                || wt as libc::c_int == WTYPE_ULC as libc::c_int
            {
                mask = &mut *sgLeftMask.as_mut_ptr().offset(31 as libc::c_int as isize)
                    as *mut uint32_t;
            }
        }
        if gbPartialTrans as libc::c_int == PART_TRANS_RIGHT as libc::c_int
            && mt as libc::c_int != MICRO_RIGHT as libc::c_int
        {
            wt = nWTypeTable[gnPieceNum as usize];
            if wt as libc::c_int == WTYPE_RIGHT as libc::c_int
                || wt as libc::c_int == WTYPE_ULC as libc::c_int
            {
                mask = &mut *sgRightMask.as_mut_ptr().offset(31 as libc::c_int as isize)
                    as *mut uint32_t;
            }
        }
    }
    match mt as libc::c_int {
        0 => {
            i = 32 as libc::c_int;
            while i != 0 as libc::c_int {
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int, *mask);
                i -= 1;
                i;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
        }
        1 => {
            i = 32 as libc::c_int;
            while i != 0 as libc::c_int {
                cm = *mask;
                j = 32 as libc::c_int;
                while j != 0 as libc::c_int {
                    bBlock = *src as int8_t;
                    src = src.offset(1);
                    src;
                    if bBlock as libc::c_int >= 0 as libc::c_int {
                        DecodeLine(&mut dst, &mut src, bBlock as libc::c_int, cm);
                    } else {
                        bBlock = -(bBlock as libc::c_int) as int8_t;
                        dst = dst.offset(bBlock as libc::c_int as isize);
                    }
                    if bBlock as libc::c_int >= 32 as libc::c_int {
                        cm = 0 as libc::c_int as uint32_t;
                    } else {
                        cm <<= bBlock as libc::c_int;
                    }
                    j -= bBlock as libc::c_int;
                }
                i -= 1;
                i;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
        }
        2 => {
            i = 30 as libc::c_int;
            while i >= 0 as libc::c_int {
                src = src.offset((i & 2 as libc::c_int) as isize);
                dst = dst.offset(i as isize);
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int - i, *mask);
                i -= 2 as libc::c_int;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
            i = 2 as libc::c_int;
            while i != 32 as libc::c_int {
                src = src.offset((i & 2 as libc::c_int) as isize);
                dst = dst.offset(i as isize);
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int - i, *mask);
                i += 2 as libc::c_int;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
        }
        3 => {
            i = 30 as libc::c_int;
            while i >= 0 as libc::c_int {
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int - i, *mask);
                src = src.offset((i & 2 as libc::c_int) as isize);
                dst = dst.offset(i as isize);
                i -= 2 as libc::c_int;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
            i = 2 as libc::c_int;
            while i != 32 as libc::c_int {
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int - i, *mask);
                src = src.offset((i & 2 as libc::c_int) as isize);
                dst = dst.offset(i as isize);
                i += 2 as libc::c_int;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
        }
        4 => {
            i = 30 as libc::c_int;
            while i >= 0 as libc::c_int {
                src = src.offset((i & 2 as libc::c_int) as isize);
                dst = dst.offset(i as isize);
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int - i, *mask);
                i -= 2 as libc::c_int;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
            i = 16 as libc::c_int;
            while i != 0 as libc::c_int {
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int, *mask);
                i -= 1;
                i;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
        }
        5 => {
            i = 30 as libc::c_int;
            while i >= 0 as libc::c_int {
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int - i, *mask);
                src = src.offset((i & 2 as libc::c_int) as isize);
                dst = dst.offset(i as isize);
                i -= 2 as libc::c_int;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
            i = 16 as libc::c_int;
            while i != 0 as libc::c_int {
                DecodeLine(&mut dst, &mut src, 32 as libc::c_int, *mask);
                i -= 1;
                i;
                dst = dst.offset(-(NBUFFW32 as libc::c_int as isize));
                mask = mask.offset(-1);
                mask;
            }
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn DrawBlankMini(mut pDecodeTo: *mut uint32_t) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut k: libc::c_int = 0;
    let mut dst: *mut uint32_t = 0 as *mut uint32_t;
    dst = pDecodeTo;
    i = 30 as libc::c_int;
    j = 1 as libc::c_int;
    while i >= 0 as libc::c_int {
        if dst < glClipY {
            dst = dst.offset(i as isize);
            k = 0 as libc::c_int;
            while k < j * 4 as libc::c_int {
                let fresh0 = dst;
                dst = dst.offset(1);
                *fresh0 = 0 as libc::c_int as uint32_t;
                k += 1;
                k;
            }
            dst = dst.offset(i as isize);
        } else {
            dst = dst.offset(64 as libc::c_int as isize);
        }
        i -= 2 as libc::c_int;
        j += 1;
        j;
        dst = dst.offset(-(NBUFFW64 as libc::c_int as isize));
    }
    i = 2 as libc::c_int;
    j = 15 as libc::c_int;
    while i != 32 as libc::c_int {
        if dst < glClipY {
            dst = dst.offset(i as isize);
            k = 0 as libc::c_int;
            while k < j * 4 as libc::c_int {
                let fresh1 = dst;
                dst = dst.offset(1);
                *fresh1 = 0 as libc::c_int as uint32_t;
                k += 1;
                k;
            }
            dst = dst.offset(i as isize);
        } else {
            dst = dst.offset(64 as libc::c_int as isize);
        }
        i += 2 as libc::c_int;
        j -= 1;
        j;
        dst = dst.offset(-(NBUFFW64 as libc::c_int as isize));
    }
}
