use ::libc;
extern "C" {
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn vsprintf(
        _: *mut libc::c_char,
        _: *const libc::c_char,
        _: ::core::ffi::VaList,
    ) -> libc::c_int;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn strncpy(
        _: *mut libc::c_char,
        _: *const libc::c_char,
        _: libc::c_ulong,
    ) -> *mut libc::c_char;
    fn strlen(_: *const libc::c_char) -> libc::c_ulong;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn DrawPanelFont(poffset: int32_t, nCel: int32_t, clr: int8_t);
    fn SDL_GetTicks() -> Uint32;
    static gbFontTransTbl: [uint8_t; 256];
    static fonttrans: [uint8_t; 128];
    static fontkern: [uint8_t; 68];
    static mut chrflag: bool32_t;
    static mut sbookflag: bool32_t;
    static mut invflag: bool32_t;
    static mut plr: [PlayerStruct; 4];
    static mut sgMsgs: [TMsg; 8];
    static mut sgbNextMsg: uint8_t;
    static mut questlog: bool32_t;
    static mut nBuffWTbl: [int32_t; 1024];
}
pub type __builtin_va_list = [__va_list_tag; 1];
#[derive(Copy, Clone)]
#[repr(C)]
pub struct __va_list_tag {
    pub gp_offset: libc::c_uint,
    pub fp_offset: libc::c_uint,
    pub overflow_arg_area: *mut libc::c_void,
    pub reg_save_area: *mut libc::c_void,
}
pub type __gnuc_va_list = __builtin_va_list;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type va_list = __gnuc_va_list;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type C2RustUnnamed = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed = 92160;
pub const BTMBUFFY: C2RustUnnamed = 144;
pub const BTMBUFFX: C2RustUnnamed = 640;
pub const BUFFERSIZE: C2RustUnnamed = 503808;
pub const BUFFERY: C2RustUnnamed = 656;
pub const BUFFERX: C2RustUnnamed = 768;
pub const GAMEY: C2RustUnnamed = 352;
pub const CTRLPANY: C2RustUnnamed = 128;
pub const TOTALY: C2RustUnnamed = 480;
pub const TOTALX: C2RustUnnamed = 640;
pub const MAX_PLRS: C2RustUnnamed = 4;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const ICOLOR_GOLD: C2RustUnnamed_0 = 3;
pub const ICOLOR_RED: C2RustUnnamed_0 = 2;
pub const ICOLOR_BLUE: C2RustUnnamed_0 = 1;
pub const ICOLOR_WHITE: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const MAX_MSGS_MASK: C2RustUnnamed_1 = 7;
pub const MAX_MSGS: C2RustUnnamed_1 = 8;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const MAX_MSG_LINES: C2RustUnnamed_2 = 3;
pub const MSG_YDELTA: C2RustUnnamed_2 = 35;
pub const MSG_YFONT: C2RustUnnamed_2 = 10;
pub const MSG_YOFF: C2RustUnnamed_2 = 70;
pub const MSG_XOFF: C2RustUnnamed_2 = 10;
pub const MSG_TIME: C2RustUnnamed_2 = 10000;
pub type bool32_t = uint32_t;
pub type Uint32 = uint32_t;
pub type C2RustUnnamed_3 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_3 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_3 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_3 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_3 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_3 = 32;
pub const MAXSPD: C2RustUnnamed_3 = 8;
pub const MAXINV: C2RustUnnamed_3 = 40;
pub const MAXPATHLEN: C2RustUnnamed_3 = 25;
pub const MANA_SHIFT: C2RustUnnamed_3 = 6;
pub const HP_SHIFT: C2RustUnnamed_3 = 6;
pub const NUM_CLASSES: C2RustUnnamed_3 = 3;
pub const MAXPACKLEN: C2RustUnnamed_3 = 256;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
pub type C2RustUnnamed_4 = libc::c_uint;
pub const MAX_MSG_SIZE: C2RustUnnamed_4 = 512;
pub const MIN_MSG_SIZE: C2RustUnnamed_4 = 128;
pub const SEND_ALL_MASK: C2RustUnnamed_4 = 4294967295;
pub const MAX_SEND_STR_LEN: C2RustUnnamed_4 = 80;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TMsg {
    pub lMsgTime: int32_t,
    pub bPlr: uint8_t,
    pub str_0: [libc::c_char; 144],
}
static mut slStartTime: int32_t = 0;
#[no_mangle]
pub unsafe extern "C" fn plrmsg_hold(mut bStart: bool32_t) {
    if bStart != 0 {
        slStartTime = -(SDL_GetTicks() as int32_t);
    } else {
        slStartTime += SDL_GetTicks() as int32_t;
        let mut pMsg: *mut TMsg = sgMsgs.as_mut_ptr();
        let mut i: libc::c_int = MAX_MSGS as libc::c_int;
        loop {
            let fresh0 = i;
            i = i - 1;
            if !(fresh0 != 0) {
                break;
            }
            (*pMsg).lMsgTime += slStartTime;
            pMsg = pMsg.offset(1);
            pMsg;
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn sysmsg_add_string(mut pszMsg: *const libc::c_char) {
    if pszMsg.is_null() {
        assert_fail(
            37 as libc::c_int,
            b"src/plrmsg.c\0" as *const u8 as *const libc::c_char,
            b"pszMsg\0" as *const u8 as *const libc::c_char,
        );
    }
    let fresh1 = sgbNextMsg;
    sgbNextMsg = sgbNextMsg.wrapping_add(1);
    let mut pMsg: *mut TMsg = &mut *sgMsgs.as_mut_ptr().offset(fresh1 as isize)
        as *mut TMsg;
    sgbNextMsg = (sgbNextMsg as libc::c_int & MAX_MSGS_MASK as libc::c_int) as uint8_t;
    (*pMsg).bPlr = MAX_PLRS as libc::c_int as uint8_t;
    (*pMsg).lMsgTime = SDL_GetTicks() as int32_t;
    strncpy(
        ((*pMsg).str_0).as_mut_ptr(),
        pszMsg,
        ::core::mem::size_of::<[libc::c_char; 144]>() as libc::c_ulong,
    );
    (*pMsg)
        .str_0[(::core::mem::size_of::<[libc::c_char; 144]>() as libc::c_ulong)
        .wrapping_sub(1 as libc::c_int as libc::c_ulong)
        as usize] = 0 as libc::c_int as libc::c_char;
}
#[no_mangle]
pub unsafe extern "C" fn sysmsg_add(mut pszFmt: *const libc::c_char, mut args: ...) {
    if pszFmt.is_null() {
        assert_fail(
            49 as libc::c_int,
            b"src/plrmsg.c\0" as *const u8 as *const libc::c_char,
            b"pszFmt\0" as *const u8 as *const libc::c_char,
        );
    }
    let fresh2 = sgbNextMsg;
    sgbNextMsg = sgbNextMsg.wrapping_add(1);
    let mut pMsg: *mut TMsg = &mut *sgMsgs.as_mut_ptr().offset(fresh2 as isize)
        as *mut TMsg;
    sgbNextMsg = (sgbNextMsg as libc::c_int & MAX_MSGS_MASK as libc::c_int) as uint8_t;
    (*pMsg).bPlr = MAX_PLRS as libc::c_int as uint8_t;
    (*pMsg).lMsgTime = SDL_GetTicks() as int32_t;
    let mut args_0: ::core::ffi::VaListImpl;
    args_0 = args.clone();
    vsprintf(((*pMsg).str_0).as_mut_ptr(), pszFmt, args_0.as_va_list());
    if !(strlen(((*pMsg).str_0).as_mut_ptr())
        < ::core::mem::size_of::<[libc::c_char; 144]>() as libc::c_ulong)
    {
        assert_fail(
            60 as libc::c_int,
            b"src/plrmsg.c\0" as *const u8 as *const libc::c_char,
            b"strlen(pMsg->str) < sizeof(pMsg->str)\0" as *const u8
                as *const libc::c_char,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn plrmsg_add(
    mut pnum: libc::c_int,
    mut pszStr: *const libc::c_char,
) {
    if !((pnum as uint32_t) < MAX_PLRS as libc::c_int as uint32_t) {
        assert_fail(
            64 as libc::c_int,
            b"src/plrmsg.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)pnum < MAX_PLRS\0" as *const u8 as *const libc::c_char,
        );
    }
    if pszStr.is_null() {
        assert_fail(
            65 as libc::c_int,
            b"src/plrmsg.c\0" as *const u8 as *const libc::c_char,
            b"pszStr\0" as *const u8 as *const libc::c_char,
        );
    }
    let fresh3 = sgbNextMsg;
    sgbNextMsg = sgbNextMsg.wrapping_add(1);
    let mut pMsg: *mut TMsg = &mut *sgMsgs.as_mut_ptr().offset(fresh3 as isize)
        as *mut TMsg;
    sgbNextMsg = (sgbNextMsg as libc::c_int & MAX_MSGS_MASK as libc::c_int) as uint8_t;
    (*pMsg).bPlr = pnum as uint8_t;
    (*pMsg).lMsgTime = SDL_GetTicks() as int32_t;
    if !(strlen((plr[pnum as usize]._pName).as_mut_ptr())
        < PLR_NAME_LEN as libc::c_int as libc::c_ulong)
    {
        assert_fail(
            73 as libc::c_int,
            b"src/plrmsg.c\0" as *const u8 as *const libc::c_char,
            b"strlen(plr[pnum]._pName) < PLR_NAME_LEN\0" as *const u8
                as *const libc::c_char,
        );
    }
    if !(strlen(pszStr) < MAX_SEND_STR_LEN as libc::c_int as libc::c_ulong) {
        assert_fail(
            74 as libc::c_int,
            b"src/plrmsg.c\0" as *const u8 as *const libc::c_char,
            b"strlen(pszStr) < MAX_SEND_STR_LEN\0" as *const u8 as *const libc::c_char,
        );
    }
    sprintf(
        ((*pMsg).str_0).as_mut_ptr(),
        b"%s (lvl %d): %s\0" as *const u8 as *const libc::c_char,
        (plr[pnum as usize]._pName).as_mut_ptr(),
        plr[pnum as usize]._pLevel as libc::c_int,
        pszStr,
    );
}
#[no_mangle]
pub unsafe extern "C" fn plrmsg_update() {
    let mut pMsg: *mut TMsg = sgMsgs.as_mut_ptr();
    let mut lCurrTime: int32_t = SDL_GetTicks() as int32_t;
    let mut i: libc::c_int = MAX_MSGS as libc::c_int;
    loop {
        let fresh4 = i;
        i = i - 1;
        if !(fresh4 != 0) {
            break;
        }
        if lCurrTime - (*pMsg).lMsgTime > MSG_TIME as libc::c_int {
            (*pMsg).str_0[0 as libc::c_int as usize] = 0 as libc::c_int as libc::c_char;
        }
        pMsg = pMsg.offset(1);
        pMsg;
    };
}
#[no_mangle]
pub unsafe extern "C" fn plrmsg_init() {
    memset(
        &mut *sgMsgs.as_mut_ptr().offset(0 as libc::c_int as isize) as *mut TMsg
            as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[TMsg; 8]>() as libc::c_ulong,
    );
    sgbNextMsg = 0 as libc::c_int as uint8_t;
}
unsafe extern "C" fn draw_str(
    mut x: uint32_t,
    mut y: uint32_t,
    mut wdt: uint32_t,
    mut pszStr: *const libc::c_char,
    mut cColor: int8_t,
) {
    let mut dwLines: uint32_t = 0 as libc::c_int as uint32_t;
    while *pszStr != 0 {
        let mut dwOffset: uint32_t = (nBuffWTbl[y as usize] as uint32_t).wrapping_add(x);
        let mut dwLineWdt: uint32_t = 0 as libc::c_int as uint32_t;
        let mut pszLine: *const libc::c_char = pszStr;
        let mut pszEOL: *const libc::c_char = pszStr;
        loop {
            if *pszLine == 0 {
                pszEOL = pszLine;
                break;
            } else {
                let fresh5 = pszLine;
                pszLine = pszLine.offset(1);
                let mut c: uint8_t = gbFontTransTbl[*fresh5 as uint8_t as usize];
                c = fonttrans[c as usize];
                dwLineWdt = dwLineWdt
                    .wrapping_add(
                        (fontkern[c as usize] as libc::c_int + 1 as libc::c_int)
                            as uint32_t,
                    );
                if c == 0 {
                    pszEOL = pszLine;
                } else if dwLineWdt >= wdt {
                    break;
                }
            }
        }
        while pszStr < pszEOL {
            let fresh6 = pszStr;
            pszStr = pszStr.offset(1);
            let mut c_0: uint8_t = gbFontTransTbl[*fresh6 as uint8_t as usize];
            c_0 = fonttrans[c_0 as usize];
            if c_0 != 0 {
                DrawPanelFont(dwOffset as int32_t, c_0 as int32_t, cColor);
            }
            dwOffset = dwOffset
                .wrapping_add(
                    (fontkern[c_0 as usize] as libc::c_int + 1 as libc::c_int)
                        as uint32_t,
                );
        }
        y = y.wrapping_add(MSG_YFONT as libc::c_int as uint32_t);
        dwLines = dwLines.wrapping_add(1);
        if dwLines == MAX_MSG_LINES as libc::c_int as uint32_t {
            break;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn plrmsg_draw() {
    static mut scColorTbl: [libc::c_char; 5] = [
        ICOLOR_WHITE as libc::c_int as libc::c_char,
        ICOLOR_WHITE as libc::c_int as libc::c_char,
        ICOLOR_WHITE as libc::c_int as libc::c_char,
        ICOLOR_WHITE as libc::c_int as libc::c_char,
        ICOLOR_GOLD as libc::c_int as libc::c_char,
    ];
    let mut x: uint32_t = (MSG_XOFF as libc::c_int
        + (BUFFERX as libc::c_int - TOTALX as libc::c_int) / 2 as libc::c_int)
        as uint32_t;
    let mut y: uint32_t = (MSG_YOFF as libc::c_int + 160 as libc::c_int) as uint32_t;
    let mut wdt: uint32_t = (TOTALX as libc::c_int
        - MSG_XOFF as libc::c_int * 2 as libc::c_int) as uint32_t;
    if chrflag != 0 || questlog != 0 {
        if invflag != 0 || sbookflag != 0 {
            return;
        }
        x = x.wrapping_add((TOTALX as libc::c_int / 2 as libc::c_int) as uint32_t);
        wdt = wdt.wrapping_sub((TOTALX as libc::c_int / 2 as libc::c_int) as uint32_t);
    } else if invflag != 0 || sbookflag != 0 {
        wdt = wdt.wrapping_sub((TOTALX as libc::c_int / 2 as libc::c_int) as uint32_t);
    }
    let mut pMsg: *mut TMsg = sgMsgs.as_mut_ptr();
    let mut i: libc::c_int = MAX_MSGS as libc::c_int;
    loop {
        let fresh7 = i;
        i = i - 1;
        if !(fresh7 != 0) {
            break;
        }
        if !((*pMsg).str_0[0 as libc::c_int as usize] == 0) {
            draw_str(
                x,
                y,
                wdt,
                ((*pMsg).str_0).as_mut_ptr(),
                scColorTbl[(*pMsg).bPlr as usize] as int8_t,
            );
        }
        pMsg = pMsg.offset(1);
        pMsg;
        y = y.wrapping_add(MSG_YDELTA as libc::c_int as uint32_t);
    };
}
