use ::libc;
extern "C" {
    pub type SDL_SysWMmsg;
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn abs(_: libc::c_int) -> libc::c_int;
    fn SDL_GetTicks() -> Uint32;
    fn SDL_PushEvent(event: *mut SDL_Event) -> libc::c_int;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn NewCursor(i: libc::c_int);
    fn AddDead(_: libc::c_int, _: libc::c_int, _: int8_t, _: libc::c_int);
    fn stream_stop();
    fn PlaySFX(_: libc::c_int);
    fn PlaySfxLoc(psfx: libc::c_int, x: libc::c_int, y: libc::c_int);
    fn GetDirection(
        x1: libc::c_int,
        y1: libc::c_int,
        x2: libc::c_int,
        y2: libc::c_int,
    ) -> libc::c_int;
    fn SetRndSeed(file: *const libc::c_char, line: libc::c_int, s: int32_t);
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn DiabloAllocPtr(dwBytes: uint32_t) -> *mut uint8_t;
    fn LoadFileWithMem(pszName: *const libc::c_char, pbMem: *mut uint8_t) -> uint32_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn gamemenu_on();
    fn FindGetItem(_: libc::c_int, _: uint16_t, _: libc::c_int) -> libc::c_int;
    fn SyncGetItem(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: uint16_t,
        _: libc::c_int,
    );
    fn RemoveInvItem(_: libc::c_int, _: libc::c_int);
    fn UseScroll() -> bool32_t;
    fn UseStaff() -> bool32_t;
    fn CalculateGold(pnum: libc::c_int) -> int32_t;
    fn RemoveSpdBarItem(pnum: libc::c_int, iv: libc::c_int);
    fn ShowDupString(lpszMessage: *const libc::c_char);
    fn ItemSpaceOk(_: libc::c_int, _: libc::c_int) -> bool32_t;
    fn RespawnItem(ii: libc::c_int, FlipFlag: bool32_t);
    fn CalcPlrInv(_: libc::c_int, _: bool32_t);
    fn CreatePlrItems(_: libc::c_int);
    fn SetPlrHandItem(h: *mut ItemStruct, idata: libc::c_int);
    fn GetGoldSeed(pnum: libc::c_int, h: *mut ItemStruct);
    fn SetPlrHandGoldCurs(h: *mut ItemStruct);
    fn AddLight(_: libc::c_int, _: libc::c_int, _: libc::c_int) -> libc::c_int;
    fn ChangeLightXY(_: libc::c_int, _: libc::c_int, _: libc::c_int);
    fn ChangeLightOff(id: libc::c_int, x: libc::c_int, y: libc::c_int);
    fn AddVision(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: bool32_t,
    ) -> libc::c_int;
    fn ChangeVisionXY(_: libc::c_int, _: libc::c_int, _: libc::c_int);
    fn AddMissile(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: int8_t,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
    ) -> libc::c_int;
    fn GetSpellLevel(_: libc::c_int, _: libc::c_int) -> libc::c_int;
    fn ClearMissileSpot(mi: libc::c_int);
    fn DeleteMissile(mi: libc::c_int, i: libc::c_int);
    fn TalktoMonster(i: libc::c_int);
    fn M_StartKill(_: libc::c_int, _: libc::c_int);
    fn M_StartHit(_: libc::c_int, _: libc::c_int, _: libc::c_int);
    fn M_GetKnockback(i: libc::c_int);
    fn DeleteMonsterList();
    fn CanTalkToMonst(m: libc::c_int) -> bool32_t;
    fn CheckMonsterHit(m: libc::c_int, ret: *mut bool32_t) -> bool32_t;
    fn NetSendCmdLocParam3(
        bHiPri: bool32_t,
        bCmd: uint8_t,
        x: uint8_t,
        y: uint8_t,
        wParam1: uint16_t,
        wParam2: uint16_t,
        wParam3: uint16_t,
    );
    fn NetSendCmdLocParam2(
        bHiPri: bool32_t,
        bCmd: uint8_t,
        x: uint8_t,
        y: uint8_t,
        wParam1: uint16_t,
        wParam2: uint16_t,
    );
    fn NetSendCmdParam1(bHiPri: bool32_t, bCmd: uint8_t, wParam1: uint16_t);
    fn NetSendCmdParam2(
        bHiPri: bool32_t,
        bCmd: uint8_t,
        wParam1: uint16_t,
        wParam2: uint16_t,
    );
    fn NetSendCmdParam3(
        bHiPri: bool32_t,
        bCmd: uint8_t,
        wParam1: uint16_t,
        wParam2: uint16_t,
        wParam3: uint16_t,
    );
    fn NetSendCmdGItem(
        bHiPri: bool32_t,
        bCmd: uint8_t,
        mast: uint8_t,
        pnum: uint8_t,
        bCursitem: uint8_t,
    );
    fn NetSendCmdPItem(bHiPri: bool32_t, bCmd: uint8_t, x: uint8_t, y: uint8_t);
    fn NetSendCmdDelItem(bHiPri: bool32_t, bLoc: uint8_t);
    fn NetSendCmdDamage(bHiPri: bool32_t, bPlr: uint8_t, dwDam: uint32_t);
    fn BreakObject(_: libc::c_int, _: libc::c_int);
    fn OperateObject(_: libc::c_int, _: libc::c_int, _: bool32_t);
    fn TryDisarm(_: libc::c_int, _: libc::c_int);
    fn FindPath(
        PosOk: CHECKFUNC1,
        PosOkArg: libc::c_int,
        sx: libc::c_int,
        sy: libc::c_int,
        dx: libc::c_int,
        dy: libc::c_int,
        path: *mut int8_t,
    ) -> libc::c_int;
    fn SetCurrentPortal(p: libc::c_int);
    fn PosOkPortal(lvl: libc::c_int, x: libc::c_int, y: libc::c_int) -> bool32_t;
    fn CastSpell(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
    );
    fn CheckSpell(_: libc::c_int, _: libc::c_int, _: int8_t, _: bool32_t) -> bool32_t;
    fn SetGoldCurs(_: libc::c_int, _: libc::c_int);
    fn SetSpdbarGoldCurs(pnum: libc::c_int, i: libc::c_int);
    fn TalkToTowner(_: libc::c_int, _: libc::c_int);
    fn SFileCloseFile(handle: HSFILE) -> bool32_t;
    fn SFileGetFileSize(handle: HSFILE) -> uint32_t;
    fn patSFileOpenFile(
        filename: *const libc::c_char,
        handle: *mut HSFILE,
        bCanFail: bool32_t,
    ) -> bool32_t;
    static mut chrflag: bool32_t;
    static mut drawhpflag: bool32_t;
    static mut drawmanaflag: bool32_t;
    static mut curs: libc::c_int;
    static mut cursmonst: libc::c_int;
    static mut cursmx: libc::c_int;
    static mut cursmy: libc::c_int;
    static mut cursplr: int8_t;
    static mut MouseX: libc::c_int;
    static mut MouseY: libc::c_int;
    static mut svgamode: bool32_t;
    static mut FriendlyMode: bool32_t;
    static mut force_redraw: libc::c_int;
    static mut cheatflag: bool32_t;
    static mut simplecheat: bool32_t;
    static mut sfxdelay: libc::c_int;
    static mut sfxdnum: libc::c_int;
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut setlvlnum: uint8_t;
    static mut nSolidTable: [uint8_t; 2049];
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut ScrollInfo: ScrollStruct;
    static mut TransList: [uint8_t; 256];
    static mut dPiece: [[libc::c_int; 112]; 112];
    static mut dTransVal: [[int8_t; 112]; 112];
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dPlayer: [[int8_t; 112]; 112];
    static mut dMonster: [[libc::c_int; 112]; 112];
    static mut dObject: [[int8_t; 112]; 112];
    static mut dItem: [[int8_t; 112]; 112];
    static mut invflag: bool32_t;
    static mut item: [ItemStruct; 128];
    static mut numitems: int32_t;
    static mut itemactive: [libc::c_int; 127];
    static mut itemavail: [libc::c_int; 127];
    static mut LightList: [LightListStruct; 32];
    static mut qtextflag: uint8_t;
    static mut missile: [MissileStruct; 125];
    static mut nummissiles: libc::c_int;
    static mut missileactive: [libc::c_int; 125];
    static mut offset_x: [libc::c_int; 8];
    static mut offset_y: [libc::c_int; 8];
    static mut monster: [MonsterStruct; 200];
    static mut gbMaxPlayers: uint8_t;
    static mut object: [ObjectStruct; 127];
    static mut StrengthTbl: [libc::c_int; 3];
    static mut MagicTbl: [libc::c_int; 3];
    static mut DexterityTbl: [libc::c_int; 3];
    static mut VitalityTbl: [libc::c_int; 3];
    static mut MaxStats: [[libc::c_int; 4]; 3];
    static mut PlrGFXAnimLens: [[int8_t; 11]; 3];
    static mut plrxoff2: [libc::c_int; 9];
    static mut plryoff2: [libc::c_int; 9];
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut deathdelay: libc::c_int;
    static mut deathflag: bool32_t;
    static mut portal: [PortalStruct; 4];
    static mut spelldata: [SpellData; 37];
    static mut set_player_seed: libc::c_int;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int16_t = libc::c_short;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int16_t = __int16_t;
pub type int32_t = __int32_t;
pub type int64_t = __int64_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type C2RustUnnamed = libc::c_uint;
pub const CHEATS: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const DUNGMSG_8: C2RustUnnamed_0 = 128;
pub const DUNGMSG_7: C2RustUnnamed_0 = 64;
pub const DUNGMSG_6: C2RustUnnamed_0 = 32;
pub const DUNGMSG_5: C2RustUnnamed_0 = 16;
pub const DUNGMSG_4: C2RustUnnamed_0 = 8;
pub const DUNGMSG_3: C2RustUnnamed_0 = 4;
pub const DUNGMSG_2: C2RustUnnamed_0 = 2;
pub const DUNGMSG_1: C2RustUnnamed_0 = 1;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const NUM_INVLOC: C2RustUnnamed_1 = 7;
pub const INVLOC_BODY: C2RustUnnamed_1 = 6;
pub const INVLOC_HAND2: C2RustUnnamed_1 = 5;
pub const INVLOC_HAND1: C2RustUnnamed_1 = 4;
pub const INVLOC_NECK: C2RustUnnamed_1 = 3;
pub const INVLOC_RING2: C2RustUnnamed_1 = 2;
pub const INVLOC_RING1: C2RustUnnamed_1 = 1;
pub const INVLOC_HEAD: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const LVLCHANGE_TIME: C2RustUnnamed_2 = 10;
pub const LVLCHANGE_OFF: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const PGL_ALL: C2RustUnnamed_3 = 383;
pub const PGL_BLOCK: C2RustUnnamed_3 = 256;
pub const PGL_DEAD: C2RustUnnamed_3 = 128;
pub const PGL_TMAG: C2RustUnnamed_3 = 64;
pub const PGL_FMAG: C2RustUnnamed_3 = 32;
pub const PGL_LMAG: C2RustUnnamed_3 = 16;
pub const PGL_HIT: C2RustUnnamed_3 = 8;
pub const PGL_ATTACK: C2RustUnnamed_3 = 4;
pub const PGL_WALK: C2RustUnnamed_3 = 2;
pub const PGL_STAND: C2RustUnnamed_3 = 1;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const PGFX_CSHIFT: C2RustUnnamed_4 = 4;
pub const PGFX_CMASK: C2RustUnnamed_4 = 240;
pub const PGFX_MASK: C2RustUnnamed_4 = 15;
pub const PGFX_THGUY: C2RustUnnamed_4 = 40;
pub const PGFX_CHGUY: C2RustUnnamed_4 = 39;
pub const PGFX_ZHGUY: C2RustUnnamed_4 = 38;
pub const PGFX_FHGUY: C2RustUnnamed_4 = 37;
pub const PGFX_BHGUY: C2RustUnnamed_4 = 36;
pub const PGFX_HGUY: C2RustUnnamed_4 = 35;
pub const PGFX_XHGUY: C2RustUnnamed_4 = 34;
pub const PGFX_SHGUY: C2RustUnnamed_4 = 33;
pub const PGFX_NHGUY: C2RustUnnamed_4 = 32;
pub const PGFX_TMGUY: C2RustUnnamed_4 = 24;
pub const PGFX_CMGUY: C2RustUnnamed_4 = 23;
pub const PGFX_ZMGUY: C2RustUnnamed_4 = 22;
pub const PGFX_FMGUY: C2RustUnnamed_4 = 21;
pub const PGFX_BMGUY: C2RustUnnamed_4 = 20;
pub const PGFX_MGUY: C2RustUnnamed_4 = 19;
pub const PGFX_XMGUY: C2RustUnnamed_4 = 18;
pub const PGFX_SMGUY: C2RustUnnamed_4 = 17;
pub const PGFX_NMGUY: C2RustUnnamed_4 = 16;
pub const PGFX_TGUY: C2RustUnnamed_4 = 8;
pub const PGFX_CGUY: C2RustUnnamed_4 = 7;
pub const PGFX_ZGUY: C2RustUnnamed_4 = 6;
pub const PGFX_FGUY: C2RustUnnamed_4 = 5;
pub const PGFX_BGUY: C2RustUnnamed_4 = 4;
pub const PGFX_GUY: C2RustUnnamed_4 = 3;
pub const PGFX_XGUY: C2RustUnnamed_4 = 2;
pub const PGFX_SGUY: C2RustUnnamed_4 = 1;
pub const PGFX_NGUY: C2RustUnnamed_4 = 0;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const CLASS_SORCEROR: C2RustUnnamed_5 = 2;
pub const CLASS_ROGUE: C2RustUnnamed_5 = 1;
pub const CLASS_WARRIOR: C2RustUnnamed_5 = 0;
pub type C2RustUnnamed_6 = libc::c_int;
pub const PCMD_SPELLXYD: C2RustUnnamed_6 = 26;
pub const PCMD_SPELLPID: C2RustUnnamed_6 = 25;
pub const PCMD_SPELLID: C2RustUnnamed_6 = 24;
pub const PCMD_RATTACKPID: C2RustUnnamed_6 = 23;
pub const PCMD_RATTACKID: C2RustUnnamed_6 = 22;
pub const PCMD_ATTACKPID: C2RustUnnamed_6 = 21;
pub const PCMD_ATTACKID: C2RustUnnamed_6 = 20;
pub const PCMD_TELEK: C2RustUnnamed_6 = 18;
pub const PCMD_TALK: C2RustUnnamed_6 = 17;
pub const PCMD_REQAGETITEM: C2RustUnnamed_6 = 16;
pub const PCMD_REQGETITEM: C2RustUnnamed_6 = 15;
pub const PCMD_DISARM: C2RustUnnamed_6 = 14;
pub const PCMD_OPOBJ: C2RustUnnamed_6 = 13;
pub const PCMD_SPELL: C2RustUnnamed_6 = 12;
pub const PCMD_BLOCK: C2RustUnnamed_6 = 11;
pub const PCMD_RATTACK: C2RustUnnamed_6 = 10;
pub const PCMD_ATTACK: C2RustUnnamed_6 = 9;
pub const PCMD_WALKL: C2RustUnnamed_6 = 8;
pub const PCMD_WALKD: C2RustUnnamed_6 = 7;
pub const PCMD_WALKR: C2RustUnnamed_6 = 6;
pub const PCMD_WALKU: C2RustUnnamed_6 = 5;
pub const PCMD_WALKDL: C2RustUnnamed_6 = 4;
pub const PCMD_WALKDR: C2RustUnnamed_6 = 3;
pub const PCMD_WALKUL: C2RustUnnamed_6 = 2;
pub const PCMD_WALKUR: C2RustUnnamed_6 = 1;
pub const PCMD_STAND: C2RustUnnamed_6 = 0;
pub const PCMD_NOTHING: C2RustUnnamed_6 = -1;
pub type C2RustUnnamed_7 = libc::c_uint;
pub const PM_QUIT: C2RustUnnamed_7 = 11;
pub const PM_NEWLVL: C2RustUnnamed_7 = 10;
pub const PM_SPELL: C2RustUnnamed_7 = 9;
pub const PM_DEATH: C2RustUnnamed_7 = 8;
pub const PM_GOTHIT: C2RustUnnamed_7 = 7;
pub const PM_BLOCK: C2RustUnnamed_7 = 6;
pub const PM_RATTACK: C2RustUnnamed_7 = 5;
pub const PM_ATTACK: C2RustUnnamed_7 = 4;
pub const PM_WALK3: C2RustUnnamed_7 = 3;
pub const PM_WALK2: C2RustUnnamed_7 = 2;
pub const PM_WALK: C2RustUnnamed_7 = 1;
pub const PM_STAND: C2RustUnnamed_7 = 0;
pub type C2RustUnnamed_8 = libc::c_uint;
pub const WEAP_RANGE: C2RustUnnamed_8 = 1;
pub const WEAP_H2H: C2RustUnnamed_8 = 0;
pub type C2RustUnnamed_9 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_9 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_9 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_9 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_9 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_9 = 32;
pub const MAXSPD: C2RustUnnamed_9 = 8;
pub const MAXINV: C2RustUnnamed_9 = 40;
pub const MAXPATHLEN: C2RustUnnamed_9 = 25;
pub const MANA_SHIFT: C2RustUnnamed_9 = 6;
pub const HP_SHIFT: C2RustUnnamed_9 = 6;
pub const NUM_CLASSES: C2RustUnnamed_9 = 3;
pub const MAXPACKLEN: C2RustUnnamed_9 = 256;
pub type C2RustUnnamed_10 = libc::c_uint;
pub const MAX_MANA: C2RustUnnamed_10 = 128000;
pub const MAX_HP: C2RustUnnamed_10 = 128000;
pub type C2RustUnnamed_11 = libc::c_uint;
pub const MI_MONST: C2RustUnnamed_11 = 1;
pub const MI_PLR: C2RustUnnamed_11 = 0;
pub type C2RustUnnamed_12 = libc::c_uint;
pub const SF_FLAG8: C2RustUnnamed_12 = 128;
pub const SF_FLAG7: C2RustUnnamed_12 = 64;
pub const SF_FLAG6: C2RustUnnamed_12 = 32;
pub const SF_FLAG5: C2RustUnnamed_12 = 16;
pub const SF_FLAG4: C2RustUnnamed_12 = 8;
pub const SF_FLAG3: C2RustUnnamed_12 = 4;
pub const SF_FLAG2: C2RustUnnamed_12 = 2;
pub const SF_ETHER: C2RustUnnamed_12 = 1;
pub type C2RustUnnamed_13 = libc::c_uint;
pub const SPL_FROMSB: C2RustUnnamed_13 = 3;
pub const SPL_FROMT: C2RustUnnamed_13 = 2;
pub const SPL_FROMBK: C2RustUnnamed_13 = 1;
pub const SPL_FROMR: C2RustUnnamed_13 = 0;
pub type C2RustUnnamed_14 = libc::c_uint;
pub const SPL_LAST: C2RustUnnamed_14 = 37;
pub const SPL_BONESPIRIT: C2RustUnnamed_14 = 36;
pub const SPL_BSTAR: C2RustUnnamed_14 = 35;
pub const SPL_HEALOTHER: C2RustUnnamed_14 = 34;
pub const SPL_TELEKINESIS: C2RustUnnamed_14 = 33;
pub const SPL_RESURRECT: C2RustUnnamed_14 = 32;
pub const SPL_HBOLT: C2RustUnnamed_14 = 31;
pub const SPL_CBOLT: C2RustUnnamed_14 = 30;
pub const SPL_ELEMENT: C2RustUnnamed_14 = 29;
pub const SPL_DISARM: C2RustUnnamed_14 = 28;
pub const SPL_RECHARGE: C2RustUnnamed_14 = 27;
pub const SPL_REPAIR: C2RustUnnamed_14 = 26;
pub const SPL_ETHER: C2RustUnnamed_14 = 25;
pub const SPL_APOCA: C2RustUnnamed_14 = 24;
pub const SPL_TELE: C2RustUnnamed_14 = 23;
pub const SPL_BLOODB: C2RustUnnamed_14 = 22;
pub const SPL_GOLEM: C2RustUnnamed_14 = 21;
pub const SPL_FLAME: C2RustUnnamed_14 = 20;
pub const SPL_INVIS: C2RustUnnamed_14 = 19;
pub const SPL_NOVA: C2RustUnnamed_14 = 18;
pub const SPL_BLOODR: C2RustUnnamed_14 = 17;
pub const SPL_DOOM: C2RustUnnamed_14 = 16;
pub const SPL_WAVE: C2RustUnnamed_14 = 15;
pub const SPL_CHAIN: C2RustUnnamed_14 = 14;
pub const SPL_GUARDIAN: C2RustUnnamed_14 = 13;
pub const SPL_FIREBALL: C2RustUnnamed_14 = 12;
pub const SPL_MANASHLD: C2RustUnnamed_14 = 11;
pub const SPL_PHASE: C2RustUnnamed_14 = 10;
pub const SPL_INFRA: C2RustUnnamed_14 = 9;
pub const SPL_STONE: C2RustUnnamed_14 = 8;
pub const SPL_TOWN: C2RustUnnamed_14 = 7;
pub const SPL_WALL: C2RustUnnamed_14 = 6;
pub const SPL_IDENTIFY: C2RustUnnamed_14 = 5;
pub const SPL_FLASH: C2RustUnnamed_14 = 4;
pub const SPL_LIGHTNING: C2RustUnnamed_14 = 3;
pub const SPL_HEAL: C2RustUnnamed_14 = 2;
pub const SPL_FIREBOLT: C2RustUnnamed_14 = 1;
pub const SPL_NONE: C2RustUnnamed_14 = 0;
pub type C2RustUnnamed_15 = libc::c_uint;
pub const SPT_NONE: C2RustUnnamed_15 = 4;
pub const SPT_ITEM: C2RustUnnamed_15 = 3;
pub const SPT_SCROLL: C2RustUnnamed_15 = 2;
pub const SPT_MEMORIZED: C2RustUnnamed_15 = 1;
pub const SPT_ABILITY: C2RustUnnamed_15 = 0;
pub type C2RustUnnamed_16 = libc::c_uint;
pub const SPELLCAP: C2RustUnnamed_16 = 15;
pub const MAXSPELLS: C2RustUnnamed_16 = 37;
pub type C2RustUnnamed_17 = libc::c_uint;
pub const VIEW_CURSOR: C2RustUnnamed_17 = 1;
pub const ICSTART: C2RustUnnamed_17 = 12;
pub const WATCH_CURS: C2RustUnnamed_17 = 11;
pub const HEALOTHER_CURS: C2RustUnnamed_17 = 10;
pub const TARGET_CURS: C2RustUnnamed_17 = 9;
pub const RESURRECT_CURS: C2RustUnnamed_17 = 8;
pub const TELE_CURS: C2RustUnnamed_17 = 7;
pub const OIL_CURS: C2RustUnnamed_17 = 6;
pub const DISARM_CURS: C2RustUnnamed_17 = 5;
pub const RECHARGE_CURS: C2RustUnnamed_17 = 4;
pub const REPAIR_CURS: C2RustUnnamed_17 = 3;
pub const IDENTIFY_CURS: C2RustUnnamed_17 = 2;
pub const GLOVE_CURS: C2RustUnnamed_17 = 1;
pub const NO_CURSOR: C2RustUnnamed_17 = 0;
pub type Uint8 = uint8_t;
pub type Sint16 = int16_t;
pub type Uint16 = uint16_t;
pub type Sint32 = int32_t;
pub type Uint32 = uint32_t;
pub type Sint64 = int64_t;
pub type Uint64 = uint64_t;
pub type SDL_Scancode = libc::c_uint;
pub const SDL_NUM_SCANCODES: SDL_Scancode = 512;
pub const SDL_SCANCODE_ENDCALL: SDL_Scancode = 290;
pub const SDL_SCANCODE_CALL: SDL_Scancode = 289;
pub const SDL_SCANCODE_SOFTRIGHT: SDL_Scancode = 288;
pub const SDL_SCANCODE_SOFTLEFT: SDL_Scancode = 287;
pub const SDL_SCANCODE_AUDIOFASTFORWARD: SDL_Scancode = 286;
pub const SDL_SCANCODE_AUDIOREWIND: SDL_Scancode = 285;
pub const SDL_SCANCODE_APP2: SDL_Scancode = 284;
pub const SDL_SCANCODE_APP1: SDL_Scancode = 283;
pub const SDL_SCANCODE_SLEEP: SDL_Scancode = 282;
pub const SDL_SCANCODE_EJECT: SDL_Scancode = 281;
pub const SDL_SCANCODE_KBDILLUMUP: SDL_Scancode = 280;
pub const SDL_SCANCODE_KBDILLUMDOWN: SDL_Scancode = 279;
pub const SDL_SCANCODE_KBDILLUMTOGGLE: SDL_Scancode = 278;
pub const SDL_SCANCODE_DISPLAYSWITCH: SDL_Scancode = 277;
pub const SDL_SCANCODE_BRIGHTNESSUP: SDL_Scancode = 276;
pub const SDL_SCANCODE_BRIGHTNESSDOWN: SDL_Scancode = 275;
pub const SDL_SCANCODE_AC_BOOKMARKS: SDL_Scancode = 274;
pub const SDL_SCANCODE_AC_REFRESH: SDL_Scancode = 273;
pub const SDL_SCANCODE_AC_STOP: SDL_Scancode = 272;
pub const SDL_SCANCODE_AC_FORWARD: SDL_Scancode = 271;
pub const SDL_SCANCODE_AC_BACK: SDL_Scancode = 270;
pub const SDL_SCANCODE_AC_HOME: SDL_Scancode = 269;
pub const SDL_SCANCODE_AC_SEARCH: SDL_Scancode = 268;
pub const SDL_SCANCODE_COMPUTER: SDL_Scancode = 267;
pub const SDL_SCANCODE_CALCULATOR: SDL_Scancode = 266;
pub const SDL_SCANCODE_MAIL: SDL_Scancode = 265;
pub const SDL_SCANCODE_WWW: SDL_Scancode = 264;
pub const SDL_SCANCODE_MEDIASELECT: SDL_Scancode = 263;
pub const SDL_SCANCODE_AUDIOMUTE: SDL_Scancode = 262;
pub const SDL_SCANCODE_AUDIOPLAY: SDL_Scancode = 261;
pub const SDL_SCANCODE_AUDIOSTOP: SDL_Scancode = 260;
pub const SDL_SCANCODE_AUDIOPREV: SDL_Scancode = 259;
pub const SDL_SCANCODE_AUDIONEXT: SDL_Scancode = 258;
pub const SDL_SCANCODE_MODE: SDL_Scancode = 257;
pub const SDL_SCANCODE_RGUI: SDL_Scancode = 231;
pub const SDL_SCANCODE_RALT: SDL_Scancode = 230;
pub const SDL_SCANCODE_RSHIFT: SDL_Scancode = 229;
pub const SDL_SCANCODE_RCTRL: SDL_Scancode = 228;
pub const SDL_SCANCODE_LGUI: SDL_Scancode = 227;
pub const SDL_SCANCODE_LALT: SDL_Scancode = 226;
pub const SDL_SCANCODE_LSHIFT: SDL_Scancode = 225;
pub const SDL_SCANCODE_LCTRL: SDL_Scancode = 224;
pub const SDL_SCANCODE_KP_HEXADECIMAL: SDL_Scancode = 221;
pub const SDL_SCANCODE_KP_DECIMAL: SDL_Scancode = 220;
pub const SDL_SCANCODE_KP_OCTAL: SDL_Scancode = 219;
pub const SDL_SCANCODE_KP_BINARY: SDL_Scancode = 218;
pub const SDL_SCANCODE_KP_CLEARENTRY: SDL_Scancode = 217;
pub const SDL_SCANCODE_KP_CLEAR: SDL_Scancode = 216;
pub const SDL_SCANCODE_KP_PLUSMINUS: SDL_Scancode = 215;
pub const SDL_SCANCODE_KP_MEMDIVIDE: SDL_Scancode = 214;
pub const SDL_SCANCODE_KP_MEMMULTIPLY: SDL_Scancode = 213;
pub const SDL_SCANCODE_KP_MEMSUBTRACT: SDL_Scancode = 212;
pub const SDL_SCANCODE_KP_MEMADD: SDL_Scancode = 211;
pub const SDL_SCANCODE_KP_MEMCLEAR: SDL_Scancode = 210;
pub const SDL_SCANCODE_KP_MEMRECALL: SDL_Scancode = 209;
pub const SDL_SCANCODE_KP_MEMSTORE: SDL_Scancode = 208;
pub const SDL_SCANCODE_KP_EXCLAM: SDL_Scancode = 207;
pub const SDL_SCANCODE_KP_AT: SDL_Scancode = 206;
pub const SDL_SCANCODE_KP_SPACE: SDL_Scancode = 205;
pub const SDL_SCANCODE_KP_HASH: SDL_Scancode = 204;
pub const SDL_SCANCODE_KP_COLON: SDL_Scancode = 203;
pub const SDL_SCANCODE_KP_DBLVERTICALBAR: SDL_Scancode = 202;
pub const SDL_SCANCODE_KP_VERTICALBAR: SDL_Scancode = 201;
pub const SDL_SCANCODE_KP_DBLAMPERSAND: SDL_Scancode = 200;
pub const SDL_SCANCODE_KP_AMPERSAND: SDL_Scancode = 199;
pub const SDL_SCANCODE_KP_GREATER: SDL_Scancode = 198;
pub const SDL_SCANCODE_KP_LESS: SDL_Scancode = 197;
pub const SDL_SCANCODE_KP_PERCENT: SDL_Scancode = 196;
pub const SDL_SCANCODE_KP_POWER: SDL_Scancode = 195;
pub const SDL_SCANCODE_KP_XOR: SDL_Scancode = 194;
pub const SDL_SCANCODE_KP_F: SDL_Scancode = 193;
pub const SDL_SCANCODE_KP_E: SDL_Scancode = 192;
pub const SDL_SCANCODE_KP_D: SDL_Scancode = 191;
pub const SDL_SCANCODE_KP_C: SDL_Scancode = 190;
pub const SDL_SCANCODE_KP_B: SDL_Scancode = 189;
pub const SDL_SCANCODE_KP_A: SDL_Scancode = 188;
pub const SDL_SCANCODE_KP_BACKSPACE: SDL_Scancode = 187;
pub const SDL_SCANCODE_KP_TAB: SDL_Scancode = 186;
pub const SDL_SCANCODE_KP_RIGHTBRACE: SDL_Scancode = 185;
pub const SDL_SCANCODE_KP_LEFTBRACE: SDL_Scancode = 184;
pub const SDL_SCANCODE_KP_RIGHTPAREN: SDL_Scancode = 183;
pub const SDL_SCANCODE_KP_LEFTPAREN: SDL_Scancode = 182;
pub const SDL_SCANCODE_CURRENCYSUBUNIT: SDL_Scancode = 181;
pub const SDL_SCANCODE_CURRENCYUNIT: SDL_Scancode = 180;
pub const SDL_SCANCODE_DECIMALSEPARATOR: SDL_Scancode = 179;
pub const SDL_SCANCODE_THOUSANDSSEPARATOR: SDL_Scancode = 178;
pub const SDL_SCANCODE_KP_000: SDL_Scancode = 177;
pub const SDL_SCANCODE_KP_00: SDL_Scancode = 176;
pub const SDL_SCANCODE_EXSEL: SDL_Scancode = 164;
pub const SDL_SCANCODE_CRSEL: SDL_Scancode = 163;
pub const SDL_SCANCODE_CLEARAGAIN: SDL_Scancode = 162;
pub const SDL_SCANCODE_OPER: SDL_Scancode = 161;
pub const SDL_SCANCODE_OUT: SDL_Scancode = 160;
pub const SDL_SCANCODE_SEPARATOR: SDL_Scancode = 159;
pub const SDL_SCANCODE_RETURN2: SDL_Scancode = 158;
pub const SDL_SCANCODE_PRIOR: SDL_Scancode = 157;
pub const SDL_SCANCODE_CLEAR: SDL_Scancode = 156;
pub const SDL_SCANCODE_CANCEL: SDL_Scancode = 155;
pub const SDL_SCANCODE_SYSREQ: SDL_Scancode = 154;
pub const SDL_SCANCODE_ALTERASE: SDL_Scancode = 153;
pub const SDL_SCANCODE_LANG9: SDL_Scancode = 152;
pub const SDL_SCANCODE_LANG8: SDL_Scancode = 151;
pub const SDL_SCANCODE_LANG7: SDL_Scancode = 150;
pub const SDL_SCANCODE_LANG6: SDL_Scancode = 149;
pub const SDL_SCANCODE_LANG5: SDL_Scancode = 148;
pub const SDL_SCANCODE_LANG4: SDL_Scancode = 147;
pub const SDL_SCANCODE_LANG3: SDL_Scancode = 146;
pub const SDL_SCANCODE_LANG2: SDL_Scancode = 145;
pub const SDL_SCANCODE_LANG1: SDL_Scancode = 144;
pub const SDL_SCANCODE_INTERNATIONAL9: SDL_Scancode = 143;
pub const SDL_SCANCODE_INTERNATIONAL8: SDL_Scancode = 142;
pub const SDL_SCANCODE_INTERNATIONAL7: SDL_Scancode = 141;
pub const SDL_SCANCODE_INTERNATIONAL6: SDL_Scancode = 140;
pub const SDL_SCANCODE_INTERNATIONAL5: SDL_Scancode = 139;
pub const SDL_SCANCODE_INTERNATIONAL4: SDL_Scancode = 138;
pub const SDL_SCANCODE_INTERNATIONAL3: SDL_Scancode = 137;
pub const SDL_SCANCODE_INTERNATIONAL2: SDL_Scancode = 136;
pub const SDL_SCANCODE_INTERNATIONAL1: SDL_Scancode = 135;
pub const SDL_SCANCODE_KP_EQUALSAS400: SDL_Scancode = 134;
pub const SDL_SCANCODE_KP_COMMA: SDL_Scancode = 133;
pub const SDL_SCANCODE_VOLUMEDOWN: SDL_Scancode = 129;
pub const SDL_SCANCODE_VOLUMEUP: SDL_Scancode = 128;
pub const SDL_SCANCODE_MUTE: SDL_Scancode = 127;
pub const SDL_SCANCODE_FIND: SDL_Scancode = 126;
pub const SDL_SCANCODE_PASTE: SDL_Scancode = 125;
pub const SDL_SCANCODE_COPY: SDL_Scancode = 124;
pub const SDL_SCANCODE_CUT: SDL_Scancode = 123;
pub const SDL_SCANCODE_UNDO: SDL_Scancode = 122;
pub const SDL_SCANCODE_AGAIN: SDL_Scancode = 121;
pub const SDL_SCANCODE_STOP: SDL_Scancode = 120;
pub const SDL_SCANCODE_SELECT: SDL_Scancode = 119;
pub const SDL_SCANCODE_MENU: SDL_Scancode = 118;
pub const SDL_SCANCODE_HELP: SDL_Scancode = 117;
pub const SDL_SCANCODE_EXECUTE: SDL_Scancode = 116;
pub const SDL_SCANCODE_F24: SDL_Scancode = 115;
pub const SDL_SCANCODE_F23: SDL_Scancode = 114;
pub const SDL_SCANCODE_F22: SDL_Scancode = 113;
pub const SDL_SCANCODE_F21: SDL_Scancode = 112;
pub const SDL_SCANCODE_F20: SDL_Scancode = 111;
pub const SDL_SCANCODE_F19: SDL_Scancode = 110;
pub const SDL_SCANCODE_F18: SDL_Scancode = 109;
pub const SDL_SCANCODE_F17: SDL_Scancode = 108;
pub const SDL_SCANCODE_F16: SDL_Scancode = 107;
pub const SDL_SCANCODE_F15: SDL_Scancode = 106;
pub const SDL_SCANCODE_F14: SDL_Scancode = 105;
pub const SDL_SCANCODE_F13: SDL_Scancode = 104;
pub const SDL_SCANCODE_KP_EQUALS: SDL_Scancode = 103;
pub const SDL_SCANCODE_POWER: SDL_Scancode = 102;
pub const SDL_SCANCODE_APPLICATION: SDL_Scancode = 101;
pub const SDL_SCANCODE_NONUSBACKSLASH: SDL_Scancode = 100;
pub const SDL_SCANCODE_KP_PERIOD: SDL_Scancode = 99;
pub const SDL_SCANCODE_KP_0: SDL_Scancode = 98;
pub const SDL_SCANCODE_KP_9: SDL_Scancode = 97;
pub const SDL_SCANCODE_KP_8: SDL_Scancode = 96;
pub const SDL_SCANCODE_KP_7: SDL_Scancode = 95;
pub const SDL_SCANCODE_KP_6: SDL_Scancode = 94;
pub const SDL_SCANCODE_KP_5: SDL_Scancode = 93;
pub const SDL_SCANCODE_KP_4: SDL_Scancode = 92;
pub const SDL_SCANCODE_KP_3: SDL_Scancode = 91;
pub const SDL_SCANCODE_KP_2: SDL_Scancode = 90;
pub const SDL_SCANCODE_KP_1: SDL_Scancode = 89;
pub const SDL_SCANCODE_KP_ENTER: SDL_Scancode = 88;
pub const SDL_SCANCODE_KP_PLUS: SDL_Scancode = 87;
pub const SDL_SCANCODE_KP_MINUS: SDL_Scancode = 86;
pub const SDL_SCANCODE_KP_MULTIPLY: SDL_Scancode = 85;
pub const SDL_SCANCODE_KP_DIVIDE: SDL_Scancode = 84;
pub const SDL_SCANCODE_NUMLOCKCLEAR: SDL_Scancode = 83;
pub const SDL_SCANCODE_UP: SDL_Scancode = 82;
pub const SDL_SCANCODE_DOWN: SDL_Scancode = 81;
pub const SDL_SCANCODE_LEFT: SDL_Scancode = 80;
pub const SDL_SCANCODE_RIGHT: SDL_Scancode = 79;
pub const SDL_SCANCODE_PAGEDOWN: SDL_Scancode = 78;
pub const SDL_SCANCODE_END: SDL_Scancode = 77;
pub const SDL_SCANCODE_DELETE: SDL_Scancode = 76;
pub const SDL_SCANCODE_PAGEUP: SDL_Scancode = 75;
pub const SDL_SCANCODE_HOME: SDL_Scancode = 74;
pub const SDL_SCANCODE_INSERT: SDL_Scancode = 73;
pub const SDL_SCANCODE_PAUSE: SDL_Scancode = 72;
pub const SDL_SCANCODE_SCROLLLOCK: SDL_Scancode = 71;
pub const SDL_SCANCODE_PRINTSCREEN: SDL_Scancode = 70;
pub const SDL_SCANCODE_F12: SDL_Scancode = 69;
pub const SDL_SCANCODE_F11: SDL_Scancode = 68;
pub const SDL_SCANCODE_F10: SDL_Scancode = 67;
pub const SDL_SCANCODE_F9: SDL_Scancode = 66;
pub const SDL_SCANCODE_F8: SDL_Scancode = 65;
pub const SDL_SCANCODE_F7: SDL_Scancode = 64;
pub const SDL_SCANCODE_F6: SDL_Scancode = 63;
pub const SDL_SCANCODE_F5: SDL_Scancode = 62;
pub const SDL_SCANCODE_F4: SDL_Scancode = 61;
pub const SDL_SCANCODE_F3: SDL_Scancode = 60;
pub const SDL_SCANCODE_F2: SDL_Scancode = 59;
pub const SDL_SCANCODE_F1: SDL_Scancode = 58;
pub const SDL_SCANCODE_CAPSLOCK: SDL_Scancode = 57;
pub const SDL_SCANCODE_SLASH: SDL_Scancode = 56;
pub const SDL_SCANCODE_PERIOD: SDL_Scancode = 55;
pub const SDL_SCANCODE_COMMA: SDL_Scancode = 54;
pub const SDL_SCANCODE_GRAVE: SDL_Scancode = 53;
pub const SDL_SCANCODE_APOSTROPHE: SDL_Scancode = 52;
pub const SDL_SCANCODE_SEMICOLON: SDL_Scancode = 51;
pub const SDL_SCANCODE_NONUSHASH: SDL_Scancode = 50;
pub const SDL_SCANCODE_BACKSLASH: SDL_Scancode = 49;
pub const SDL_SCANCODE_RIGHTBRACKET: SDL_Scancode = 48;
pub const SDL_SCANCODE_LEFTBRACKET: SDL_Scancode = 47;
pub const SDL_SCANCODE_EQUALS: SDL_Scancode = 46;
pub const SDL_SCANCODE_MINUS: SDL_Scancode = 45;
pub const SDL_SCANCODE_SPACE: SDL_Scancode = 44;
pub const SDL_SCANCODE_TAB: SDL_Scancode = 43;
pub const SDL_SCANCODE_BACKSPACE: SDL_Scancode = 42;
pub const SDL_SCANCODE_ESCAPE: SDL_Scancode = 41;
pub const SDL_SCANCODE_RETURN: SDL_Scancode = 40;
pub const SDL_SCANCODE_0: SDL_Scancode = 39;
pub const SDL_SCANCODE_9: SDL_Scancode = 38;
pub const SDL_SCANCODE_8: SDL_Scancode = 37;
pub const SDL_SCANCODE_7: SDL_Scancode = 36;
pub const SDL_SCANCODE_6: SDL_Scancode = 35;
pub const SDL_SCANCODE_5: SDL_Scancode = 34;
pub const SDL_SCANCODE_4: SDL_Scancode = 33;
pub const SDL_SCANCODE_3: SDL_Scancode = 32;
pub const SDL_SCANCODE_2: SDL_Scancode = 31;
pub const SDL_SCANCODE_1: SDL_Scancode = 30;
pub const SDL_SCANCODE_Z: SDL_Scancode = 29;
pub const SDL_SCANCODE_Y: SDL_Scancode = 28;
pub const SDL_SCANCODE_X: SDL_Scancode = 27;
pub const SDL_SCANCODE_W: SDL_Scancode = 26;
pub const SDL_SCANCODE_V: SDL_Scancode = 25;
pub const SDL_SCANCODE_U: SDL_Scancode = 24;
pub const SDL_SCANCODE_T: SDL_Scancode = 23;
pub const SDL_SCANCODE_S: SDL_Scancode = 22;
pub const SDL_SCANCODE_R: SDL_Scancode = 21;
pub const SDL_SCANCODE_Q: SDL_Scancode = 20;
pub const SDL_SCANCODE_P: SDL_Scancode = 19;
pub const SDL_SCANCODE_O: SDL_Scancode = 18;
pub const SDL_SCANCODE_N: SDL_Scancode = 17;
pub const SDL_SCANCODE_M: SDL_Scancode = 16;
pub const SDL_SCANCODE_L: SDL_Scancode = 15;
pub const SDL_SCANCODE_K: SDL_Scancode = 14;
pub const SDL_SCANCODE_J: SDL_Scancode = 13;
pub const SDL_SCANCODE_I: SDL_Scancode = 12;
pub const SDL_SCANCODE_H: SDL_Scancode = 11;
pub const SDL_SCANCODE_G: SDL_Scancode = 10;
pub const SDL_SCANCODE_F: SDL_Scancode = 9;
pub const SDL_SCANCODE_E: SDL_Scancode = 8;
pub const SDL_SCANCODE_D: SDL_Scancode = 7;
pub const SDL_SCANCODE_C: SDL_Scancode = 6;
pub const SDL_SCANCODE_B: SDL_Scancode = 5;
pub const SDL_SCANCODE_A: SDL_Scancode = 4;
pub const SDL_SCANCODE_UNKNOWN: SDL_Scancode = 0;
pub type SDL_Keycode = Sint32;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_Keysym {
    pub scancode: SDL_Scancode,
    pub sym: SDL_Keycode,
    pub mod_0: Uint16,
    pub unused: Uint32,
}
pub type SDL_JoystickID = Sint32;
pub type SDL_JoystickPowerLevel = libc::c_int;
pub const SDL_JOYSTICK_POWER_MAX: SDL_JoystickPowerLevel = 5;
pub const SDL_JOYSTICK_POWER_WIRED: SDL_JoystickPowerLevel = 4;
pub const SDL_JOYSTICK_POWER_FULL: SDL_JoystickPowerLevel = 3;
pub const SDL_JOYSTICK_POWER_MEDIUM: SDL_JoystickPowerLevel = 2;
pub const SDL_JOYSTICK_POWER_LOW: SDL_JoystickPowerLevel = 1;
pub const SDL_JOYSTICK_POWER_EMPTY: SDL_JoystickPowerLevel = 0;
pub const SDL_JOYSTICK_POWER_UNKNOWN: SDL_JoystickPowerLevel = -1;
pub type SDL_TouchID = Sint64;
pub type SDL_FingerID = Sint64;
pub type SDL_GestureID = Sint64;
pub type C2RustUnnamed_18 = libc::c_uint;
pub const SDL_LASTEVENT: C2RustUnnamed_18 = 65535;
pub const SDL_USEREVENT: C2RustUnnamed_18 = 32768;
pub const SDL_POLLSENTINEL: C2RustUnnamed_18 = 32512;
pub const SDL_RENDER_DEVICE_RESET: C2RustUnnamed_18 = 8193;
pub const SDL_RENDER_TARGETS_RESET: C2RustUnnamed_18 = 8192;
pub const SDL_SENSORUPDATE: C2RustUnnamed_18 = 4608;
pub const SDL_AUDIODEVICEREMOVED: C2RustUnnamed_18 = 4353;
pub const SDL_AUDIODEVICEADDED: C2RustUnnamed_18 = 4352;
pub const SDL_DROPCOMPLETE: C2RustUnnamed_18 = 4099;
pub const SDL_DROPBEGIN: C2RustUnnamed_18 = 4098;
pub const SDL_DROPTEXT: C2RustUnnamed_18 = 4097;
pub const SDL_DROPFILE: C2RustUnnamed_18 = 4096;
pub const SDL_CLIPBOARDUPDATE: C2RustUnnamed_18 = 2304;
pub const SDL_MULTIGESTURE: C2RustUnnamed_18 = 2050;
pub const SDL_DOLLARRECORD: C2RustUnnamed_18 = 2049;
pub const SDL_DOLLARGESTURE: C2RustUnnamed_18 = 2048;
pub const SDL_FINGERMOTION: C2RustUnnamed_18 = 1794;
pub const SDL_FINGERUP: C2RustUnnamed_18 = 1793;
pub const SDL_FINGERDOWN: C2RustUnnamed_18 = 1792;
pub const SDL_CONTROLLERSENSORUPDATE: C2RustUnnamed_18 = 1625;
pub const SDL_CONTROLLERTOUCHPADUP: C2RustUnnamed_18 = 1624;
pub const SDL_CONTROLLERTOUCHPADMOTION: C2RustUnnamed_18 = 1623;
pub const SDL_CONTROLLERTOUCHPADDOWN: C2RustUnnamed_18 = 1622;
pub const SDL_CONTROLLERDEVICEREMAPPED: C2RustUnnamed_18 = 1621;
pub const SDL_CONTROLLERDEVICEREMOVED: C2RustUnnamed_18 = 1620;
pub const SDL_CONTROLLERDEVICEADDED: C2RustUnnamed_18 = 1619;
pub const SDL_CONTROLLERBUTTONUP: C2RustUnnamed_18 = 1618;
pub const SDL_CONTROLLERBUTTONDOWN: C2RustUnnamed_18 = 1617;
pub const SDL_CONTROLLERAXISMOTION: C2RustUnnamed_18 = 1616;
pub const SDL_JOYBATTERYUPDATED: C2RustUnnamed_18 = 1543;
pub const SDL_JOYDEVICEREMOVED: C2RustUnnamed_18 = 1542;
pub const SDL_JOYDEVICEADDED: C2RustUnnamed_18 = 1541;
pub const SDL_JOYBUTTONUP: C2RustUnnamed_18 = 1540;
pub const SDL_JOYBUTTONDOWN: C2RustUnnamed_18 = 1539;
pub const SDL_JOYHATMOTION: C2RustUnnamed_18 = 1538;
pub const SDL_JOYBALLMOTION: C2RustUnnamed_18 = 1537;
pub const SDL_JOYAXISMOTION: C2RustUnnamed_18 = 1536;
pub const SDL_MOUSEWHEEL: C2RustUnnamed_18 = 1027;
pub const SDL_MOUSEBUTTONUP: C2RustUnnamed_18 = 1026;
pub const SDL_MOUSEBUTTONDOWN: C2RustUnnamed_18 = 1025;
pub const SDL_MOUSEMOTION: C2RustUnnamed_18 = 1024;
pub const SDL_TEXTEDITING_EXT: C2RustUnnamed_18 = 773;
pub const SDL_KEYMAPCHANGED: C2RustUnnamed_18 = 772;
pub const SDL_TEXTINPUT: C2RustUnnamed_18 = 771;
pub const SDL_TEXTEDITING: C2RustUnnamed_18 = 770;
pub const SDL_KEYUP: C2RustUnnamed_18 = 769;
pub const SDL_KEYDOWN: C2RustUnnamed_18 = 768;
pub const SDL_SYSWMEVENT: C2RustUnnamed_18 = 513;
pub const SDL_WINDOWEVENT: C2RustUnnamed_18 = 512;
pub const SDL_DISPLAYEVENT: C2RustUnnamed_18 = 336;
pub const SDL_LOCALECHANGED: C2RustUnnamed_18 = 263;
pub const SDL_APP_DIDENTERFOREGROUND: C2RustUnnamed_18 = 262;
pub const SDL_APP_WILLENTERFOREGROUND: C2RustUnnamed_18 = 261;
pub const SDL_APP_DIDENTERBACKGROUND: C2RustUnnamed_18 = 260;
pub const SDL_APP_WILLENTERBACKGROUND: C2RustUnnamed_18 = 259;
pub const SDL_APP_LOWMEMORY: C2RustUnnamed_18 = 258;
pub const SDL_APP_TERMINATING: C2RustUnnamed_18 = 257;
pub const SDL_QUIT: C2RustUnnamed_18 = 256;
pub const SDL_FIRSTEVENT: C2RustUnnamed_18 = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_CommonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DisplayEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub display: Uint32,
    pub event: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub data1: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_WindowEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub event: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub data1: Sint32,
    pub data2: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_KeyboardEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub state: Uint8,
    pub repeat: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub keysym: SDL_Keysym,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextEditingEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: [libc::c_char; 32],
    pub start: Sint32,
    pub length: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextEditingExtEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: *mut libc::c_char,
    pub start: Sint32,
    pub length: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextInputEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: [libc::c_char; 32],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseMotionEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub state: Uint32,
    pub x: Sint32,
    pub y: Sint32,
    pub xrel: Sint32,
    pub yrel: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub button: Uint8,
    pub state: Uint8,
    pub clicks: Uint8,
    pub padding1: Uint8,
    pub x: Sint32,
    pub y: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseWheelEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub x: Sint32,
    pub y: Sint32,
    pub direction: Uint32,
    pub preciseX: libc::c_float,
    pub preciseY: libc::c_float,
    pub mouseX: Sint32,
    pub mouseY: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyAxisEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub axis: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub value: Sint16,
    pub padding4: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyBallEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub ball: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub xrel: Sint16,
    pub yrel: Sint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyHatEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub hat: Uint8,
    pub value: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub button: Uint8,
    pub state: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyBatteryEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub level: SDL_JoystickPowerLevel,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerAxisEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub axis: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub value: Sint16,
    pub padding4: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub button: Uint8,
    pub state: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerTouchpadEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub touchpad: Sint32,
    pub finger: Sint32,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub pressure: libc::c_float,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerSensorEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub sensor: Sint32,
    pub data: [libc::c_float; 3],
    pub timestamp_us: Uint64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_AudioDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Uint32,
    pub iscapture: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TouchFingerEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub fingerId: SDL_FingerID,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub dx: libc::c_float,
    pub dy: libc::c_float,
    pub pressure: libc::c_float,
    pub windowID: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MultiGestureEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub dTheta: libc::c_float,
    pub dDist: libc::c_float,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub numFingers: Uint16,
    pub padding: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DollarGestureEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub gestureId: SDL_GestureID,
    pub numFingers: Uint32,
    pub error: libc::c_float,
    pub x: libc::c_float,
    pub y: libc::c_float,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DropEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub file: *mut libc::c_char,
    pub windowID: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_SensorEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
    pub data: [libc::c_float; 6],
    pub timestamp_us: Uint64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_QuitEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_UserEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub code: Sint32,
    pub data1: *mut libc::c_void,
    pub data2: *mut libc::c_void,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_SysWMEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub msg: *mut SDL_SysWMmsg,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union SDL_Event {
    pub type_0: Uint32,
    pub common: SDL_CommonEvent,
    pub display: SDL_DisplayEvent,
    pub window: SDL_WindowEvent,
    pub key: SDL_KeyboardEvent,
    pub edit: SDL_TextEditingEvent,
    pub editExt: SDL_TextEditingExtEvent,
    pub text: SDL_TextInputEvent,
    pub motion: SDL_MouseMotionEvent,
    pub button: SDL_MouseButtonEvent,
    pub wheel: SDL_MouseWheelEvent,
    pub jaxis: SDL_JoyAxisEvent,
    pub jball: SDL_JoyBallEvent,
    pub jhat: SDL_JoyHatEvent,
    pub jbutton: SDL_JoyButtonEvent,
    pub jdevice: SDL_JoyDeviceEvent,
    pub jbattery: SDL_JoyBatteryEvent,
    pub caxis: SDL_ControllerAxisEvent,
    pub cbutton: SDL_ControllerButtonEvent,
    pub cdevice: SDL_ControllerDeviceEvent,
    pub ctouchpad: SDL_ControllerTouchpadEvent,
    pub csensor: SDL_ControllerSensorEvent,
    pub adevice: SDL_AudioDeviceEvent,
    pub sensor: SDL_SensorEvent,
    pub quit: SDL_QuitEvent,
    pub user: SDL_UserEvent,
    pub syswm: SDL_SysWMEvent,
    pub tfinger: SDL_TouchFingerEvent,
    pub mgesture: SDL_MultiGestureEvent,
    pub dgesture: SDL_DollarGestureEvent,
    pub drop: SDL_DropEvent,
    pub padding: [Uint8; 56],
}
pub type C2RustUnnamed_19 = libc::c_uint;
pub const EVENT_DIABLOADGAME: C2RustUnnamed_19 = 32779;
pub const EVENT_DIABNEWGAME: C2RustUnnamed_19 = 32778;
pub const EVENT_DIABRETOWN: C2RustUnnamed_19 = 32777;
pub const EVENT_DIABTWARPUP: C2RustUnnamed_19 = 32776;
pub const EVENT_DIABTOWNWARP: C2RustUnnamed_19 = 32775;
pub const EVENT_DIABWARPLVL: C2RustUnnamed_19 = 32774;
pub const EVENT_DIABSETLVL: C2RustUnnamed_19 = 32773;
pub const EVENT_DIABRTNLVL: C2RustUnnamed_19 = 32772;
pub const EVENT_DIABPREVLVL: C2RustUnnamed_19 = 32771;
pub const EVENT_DIABNEXTLVL: C2RustUnnamed_19 = 32770;
pub type C2RustUnnamed_20 = libc::c_uint;
pub const RUN_AGAIN: C2RustUnnamed_20 = 1;
pub const RUN_DONE: C2RustUnnamed_20 = 0;
pub type C2RustUnnamed_21 = libc::c_uint;
pub const M_DIRUL: C2RustUnnamed_21 = 3;
pub const M_DIRL: C2RustUnnamed_21 = 2;
pub const M_DIRDL: C2RustUnnamed_21 = 1;
pub const M_DIRD: C2RustUnnamed_21 = 0;
pub const M_DIRDR: C2RustUnnamed_21 = 7;
pub const M_DIRR: C2RustUnnamed_21 = 6;
pub const M_DIRUR: C2RustUnnamed_21 = 5;
pub const M_DIRU: C2RustUnnamed_21 = 4;
pub const DIR_UL: C2RustUnnamed_21 = 3;
pub const DIR_L: C2RustUnnamed_21 = 2;
pub const DIR_DL: C2RustUnnamed_21 = 1;
pub const DIR_D: C2RustUnnamed_21 = 0;
pub const DIR_DR: C2RustUnnamed_21 = 7;
pub const DIR_R: C2RustUnnamed_21 = 6;
pub const DIR_UR: C2RustUnnamed_21 = 5;
pub const DIR_U: C2RustUnnamed_21 = 4;
pub type C2RustUnnamed_22 = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed_22 = 191;
pub const SETP_TEMP: C2RustUnnamed_22 = 64;
pub const SETP_MASK: C2RustUnnamed_22 = 127;
pub const SETP_BIT: C2RustUnnamed_22 = 128;
pub const BFMASK_MISSILE: C2RustUnnamed_22 = 254;
pub const BFMASK_SETPC: C2RustUnnamed_22 = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed_22 = 239;
pub const BFMASK_PLRLR: C2RustUnnamed_22 = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed_22 = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed_22 = 127;
pub const BFLAG_MISSILE: C2RustUnnamed_22 = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed_22 = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed_22 = 4;
pub const BFLAG_SETPC: C2RustUnnamed_22 = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed_22 = 16;
pub const BFLAG_PLRLR: C2RustUnnamed_22 = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed_22 = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed_22 = 128;
pub type C2RustUnnamed_23 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_23 = 255;
pub const VIEWDRAW: C2RustUnnamed_23 = 1;
pub const NODRAW: C2RustUnnamed_23 = 0;
pub type C2RustUnnamed_24 = libc::c_uint;
pub const SCRL_UL: C2RustUnnamed_24 = 8;
pub const SCRL_L: C2RustUnnamed_24 = 7;
pub const SCRL_DL: C2RustUnnamed_24 = 6;
pub const SCRL_D: C2RustUnnamed_24 = 5;
pub const SCRL_DR: C2RustUnnamed_24 = 4;
pub const SCRL_R: C2RustUnnamed_24 = 3;
pub const SCRL_UR: C2RustUnnamed_24 = 2;
pub const SCRL_U: C2RustUnnamed_24 = 1;
pub const SCRL_NONE: C2RustUnnamed_24 = 0;
pub type C2RustUnnamed_25 = libc::c_uint;
pub const MI_ENEMYBOTH: C2RustUnnamed_25 = 2;
pub const MI_ENEMYPLR: C2RustUnnamed_25 = 1;
pub const MI_ENEMYMONST: C2RustUnnamed_25 = 0;
pub type C2RustUnnamed_26 = libc::c_uint;
pub const MIT_DIABAPOCA: C2RustUnnamed_26 = 67;
pub const MIT_FIREPLAR: C2RustUnnamed_26 = 66;
pub const MIT_RPORTAL: C2RustUnnamed_26 = 65;
pub const MIT_WEAPEXP: C2RustUnnamed_26 = 64;
pub const MIT_BONESPIRIT: C2RustUnnamed_26 = 63;
pub const MIT_RESURRECTBEAM: C2RustUnnamed_26 = 62;
pub const MIT_ELEMENT: C2RustUnnamed_26 = 61;
pub const MIT_HEALOTHER: C2RustUnnamed_26 = 60;
pub const MIT_ACIDPUD: C2RustUnnamed_26 = 59;
pub const MIT_ACIDSPLAT: C2RustUnnamed_26 = 58;
pub const MIT_ACID: C2RustUnnamed_26 = 57;
pub const MIT_LARROW: C2RustUnnamed_26 = 56;
pub const MIT_TELEKINESIS: C2RustUnnamed_26 = 55;
pub const MIT_RESURRECT: C2RustUnnamed_26 = 54;
pub const MIT_HBOLT: C2RustUnnamed_26 = 53;
pub const MIT_CBOLT: C2RustUnnamed_26 = 52;
pub const MIT_KRULL: C2RustUnnamed_26 = 51;
pub const MIT_FIREMAN: C2RustUnnamed_26 = 50;
pub const MIT_FLAMEC: C2RustUnnamed_26 = 49;
pub const MIT_FLAME: C2RustUnnamed_26 = 48;
pub const MIT_DISARM: C2RustUnnamed_26 = 47;
pub const MIT_RECHARGE: C2RustUnnamed_26 = 46;
pub const MIT_REPAIR: C2RustUnnamed_26 = 45;
pub const MIT_APOCA: C2RustUnnamed_26 = 44;
pub const MIT_BLDBOIL: C2RustUnnamed_26 = 43;
pub const MIT_NOVA: C2RustUnnamed_26 = 42;
pub const MIT_WAVE: C2RustUnnamed_26 = 41;
pub const MIT_IDENTIFY: C2RustUnnamed_26 = 40;
pub const MIT_INFRA: C2RustUnnamed_26 = 39;
pub const MIT_FIREWALLC: C2RustUnnamed_26 = 38;
pub const MIT_HEAL: C2RustUnnamed_26 = 37;
pub const MIT_BOOM: C2RustUnnamed_26 = 36;
pub const MIT_SPURT: C2RustUnnamed_26 = 35;
pub const MIT_ETHER: C2RustUnnamed_26 = 34;
pub const MIT_GOLEM: C2RustUnnamed_26 = 33;
pub const MIT_INVIS: C2RustUnnamed_26 = 32;
pub const MIT_BLOODR: C2RustUnnamed_26 = 31;
pub const MIT_STONE: C2RustUnnamed_26 = 30;
pub const MIT_FIREONLY: C2RustUnnamed_26 = 29;
pub const MIT_DOOM: C2RustUnnamed_26 = 28;
pub const MIT_FARROW: C2RustUnnamed_26 = 27;
pub const MIT_TELE: C2RustUnnamed_26 = 26;
pub const MIT_FLAREXP: C2RustUnnamed_26 = 25;
pub const MIT_FLARE: C2RustUnnamed_26 = 24;
pub const MIT_THINLIGHT: C2RustUnnamed_26 = 23;
pub const MIT_THINLIGHTCTRL: C2RustUnnamed_26 = 22;
pub const MIT_MAGMABALL: C2RustUnnamed_26 = 21;
pub const MIT_RHINO: C2RustUnnamed_26 = 20;
pub const MIT_METAL: C2RustUnnamed_26 = 19;
pub const MIT_BONE: C2RustUnnamed_26 = 18;
pub const MIT_BLOOD: C2RustUnnamed_26 = 17;
pub const MIT_CHAINBALL: C2RustUnnamed_26 = 16;
pub const MIT_CHAIN: C2RustUnnamed_26 = 15;
pub const MIT_FIREMOVE: C2RustUnnamed_26 = 14;
pub const MIT_MANASHIELD: C2RustUnnamed_26 = 13;
pub const MIT_FLASH2: C2RustUnnamed_26 = 12;
pub const MIT_FLASH: C2RustUnnamed_26 = 11;
pub const MIT_TOWN: C2RustUnnamed_26 = 10;
pub const MIT_MISEXP: C2RustUnnamed_26 = 9;
pub const MIT_LIGHTNING: C2RustUnnamed_26 = 8;
pub const MIT_LIGHTCTRL: C2RustUnnamed_26 = 7;
pub const MIT_FIREBALL: C2RustUnnamed_26 = 6;
pub const MIT_FIREWALL: C2RustUnnamed_26 = 5;
pub const MIT_LIGHTBALL: C2RustUnnamed_26 = 4;
pub const MIT_PHASE: C2RustUnnamed_26 = 3;
pub const MIT_GUARDIAN: C2RustUnnamed_26 = 2;
pub const MIT_FIREBOLT: C2RustUnnamed_26 = 1;
pub const MIT_ARROW: C2RustUnnamed_26 = 0;
pub type C2RustUnnamed_27 = libc::c_uint;
pub const MC_ANIMAL: C2RustUnnamed_27 = 2;
pub const MC_DEMON: C2RustUnnamed_27 = 1;
pub const MC_UNDEAD: C2RustUnnamed_27 = 0;
pub type C2RustUnnamed_28 = libc::c_uint;
pub const LASTMT: C2RustUnnamed_28 = 111;
pub const MT_DARKMAGE: C2RustUnnamed_28 = 111;
pub const MT_DIABLO: C2RustUnnamed_28 = 110;
pub const MT_GOLEM: C2RustUnnamed_28 = 109;
pub const MT_ADVOCATE: C2RustUnnamed_28 = 108;
pub const MT_CABALIST: C2RustUnnamed_28 = 107;
pub const MT_MAGISTR: C2RustUnnamed_28 = 106;
pub const MT_COUNSLR: C2RustUnnamed_28 = 105;
pub const MT_SOLBRNR: C2RustUnnamed_28 = 104;
pub const MT_HLSPWN: C2RustUnnamed_28 = 103;
pub const MT_SNOWWICH: C2RustUnnamed_28 = 102;
pub const MT_SUCCUBUS: C2RustUnnamed_28 = 101;
pub const MT_REALWEAV: C2RustUnnamed_28 = 100;
pub const MT_PAINMSTR: C2RustUnnamed_28 = 99;
pub const MT_HOLOWONE: C2RustUnnamed_28 = 98;
pub const MT_UNRAV: C2RustUnnamed_28 = 97;
pub const MT_RBLACK: C2RustUnnamed_28 = 96;
pub const MT_BTBLACK: C2RustUnnamed_28 = 95;
pub const MT_RTBLACK: C2RustUnnamed_28 = 94;
pub const MT_NBLACK: C2RustUnnamed_28 = 93;
pub const MT_GSNAKE: C2RustUnnamed_28 = 92;
pub const MT_BSNAKE: C2RustUnnamed_28 = 91;
pub const MT_RSNAKE: C2RustUnnamed_28 = 90;
pub const MT_NSNAKE: C2RustUnnamed_28 = 89;
pub const MT_BALROG: C2RustUnnamed_28 = 88;
pub const MT_VTEXLRD: C2RustUnnamed_28 = 87;
pub const MT_GUARD: C2RustUnnamed_28 = 86;
pub const MT_MEGA: C2RustUnnamed_28 = 85;
pub const MT_DEATHW: C2RustUnnamed_28 = 84;
pub const MT_BLOODCLW: C2RustUnnamed_28 = 83;
pub const MT_GARGOYLE: C2RustUnnamed_28 = 82;
pub const MT_WINGED: C2RustUnnamed_28 = 81;
pub const MT_BIGFALL: C2RustUnnamed_28 = 80;
pub const MT_MAEL: C2RustUnnamed_28 = 79;
pub const MT_STORML: C2RustUnnamed_28 = 78;
pub const MT_RSTORM: C2RustUnnamed_28 = 77;
pub const MT_STORM: C2RustUnnamed_28 = 76;
pub const MT_HELLBURN: C2RustUnnamed_28 = 75;
pub const MT_DOOMFIRE: C2RustUnnamed_28 = 74;
pub const MT_FLAMLRD: C2RustUnnamed_28 = 73;
pub const MT_INCIN: C2RustUnnamed_28 = 72;
pub const MT_UDEDBLRG: C2RustUnnamed_28 = 71;
pub const MT_LTCHDMN: C2RustUnnamed_28 = 70;
pub const MT_REDDTH: C2RustUnnamed_28 = 69;
pub const MT_BONEDMN: C2RustUnnamed_28 = 68;
pub const MT_OBLORD: C2RustUnnamed_28 = 67;
pub const MT_FROSTC: C2RustUnnamed_28 = 66;
pub const MT_MUDRUN: C2RustUnnamed_28 = 65;
pub const MT_HORNED: C2RustUnnamed_28 = 64;
pub const MT_WMAGMA: C2RustUnnamed_28 = 63;
pub const MT_BMAGMA: C2RustUnnamed_28 = 62;
pub const MT_YMAGMA: C2RustUnnamed_28 = 61;
pub const MT_NMAGMA: C2RustUnnamed_28 = 60;
pub const MT_DEVOUR: C2RustUnnamed_28 = 59;
pub const MT_DVLWYRM: C2RustUnnamed_28 = 58;
pub const MT_CAVSLUG: C2RustUnnamed_28 = 57;
pub const MT_WYRM: C2RustUnnamed_28 = 56;
pub const MT_FLAYED: C2RustUnnamed_28 = 55;
pub const MT_TOAD: C2RustUnnamed_28 = 54;
pub const MT_MUDMAN: C2RustUnnamed_28 = 53;
pub const MT_FAT: C2RustUnnamed_28 = 52;
pub const MT_CLEAVER: C2RustUnnamed_28 = 51;
pub const MT_SKING: C2RustUnnamed_28 = 50;
pub const MT_XACID: C2RustUnnamed_28 = 49;
pub const MT_BACID: C2RustUnnamed_28 = 48;
pub const MT_RACID: C2RustUnnamed_28 = 47;
pub const MT_NACID: C2RustUnnamed_28 = 46;
pub const MT_GGOATBW: C2RustUnnamed_28 = 45;
pub const MT_RGOATBW: C2RustUnnamed_28 = 44;
pub const MT_BGOATBW: C2RustUnnamed_28 = 43;
pub const MT_NGOATBW: C2RustUnnamed_28 = 42;
pub const MT_FAMILIAR: C2RustUnnamed_28 = 41;
pub const MT_GLOOM: C2RustUnnamed_28 = 40;
pub const MT_BLINK: C2RustUnnamed_28 = 39;
pub const MT_FIEND: C2RustUnnamed_28 = 38;
pub const MT_GGOATMC: C2RustUnnamed_28 = 37;
pub const MT_RGOATMC: C2RustUnnamed_28 = 36;
pub const MT_BGOATMC: C2RustUnnamed_28 = 35;
pub const MT_NGOATMC: C2RustUnnamed_28 = 34;
pub const MT_LRDSAYTR: C2RustUnnamed_28 = 33;
pub const MT_ILLWEAV: C2RustUnnamed_28 = 32;
pub const MT_UNSEEN: C2RustUnnamed_28 = 31;
pub const MT_STALKER: C2RustUnnamed_28 = 30;
pub const MT_SNEAK: C2RustUnnamed_28 = 29;
pub const MT_INVILORD: C2RustUnnamed_28 = 28;
pub const MT_XSKELSD: C2RustUnnamed_28 = 27;
pub const MT_RSKELSD: C2RustUnnamed_28 = 26;
pub const MT_TSKELSD: C2RustUnnamed_28 = 25;
pub const MT_WSKELSD: C2RustUnnamed_28 = 24;
pub const MT_XSKELBW: C2RustUnnamed_28 = 23;
pub const MT_RSKELBW: C2RustUnnamed_28 = 22;
pub const MT_TSKELBW: C2RustUnnamed_28 = 21;
pub const MT_WSKELBW: C2RustUnnamed_28 = 20;
pub const MT_YSCAV: C2RustUnnamed_28 = 19;
pub const MT_WSCAV: C2RustUnnamed_28 = 18;
pub const MT_BSCAV: C2RustUnnamed_28 = 17;
pub const MT_NSCAV: C2RustUnnamed_28 = 16;
pub const MT_BFALLSD: C2RustUnnamed_28 = 15;
pub const MT_YFALLSD: C2RustUnnamed_28 = 14;
pub const MT_DFALLSD: C2RustUnnamed_28 = 13;
pub const MT_RFALLSD: C2RustUnnamed_28 = 12;
pub const MT_XSKELAX: C2RustUnnamed_28 = 11;
pub const MT_RSKELAX: C2RustUnnamed_28 = 10;
pub const MT_TSKELAX: C2RustUnnamed_28 = 9;
pub const MT_WSKELAX: C2RustUnnamed_28 = 8;
pub const MT_BFALLSP: C2RustUnnamed_28 = 7;
pub const MT_YFALLSP: C2RustUnnamed_28 = 6;
pub const MT_DFALLSP: C2RustUnnamed_28 = 5;
pub const MT_RFALLSP: C2RustUnnamed_28 = 4;
pub const MT_YZOMBIE: C2RustUnnamed_28 = 3;
pub const MT_GZOMBIE: C2RustUnnamed_28 = 2;
pub const MT_BZOMBIE: C2RustUnnamed_28 = 1;
pub const MT_NZOMBIE: C2RustUnnamed_28 = 0;
pub type C2RustUnnamed_29 = libc::c_uint;
pub const MFLAG_NOENEMY: C2RustUnnamed_29 = 1024;
pub const MFLAG_CHECKDOORS: C2RustUnnamed_29 = 512;
pub const MFLAG_PATH: C2RustUnnamed_29 = 256;
pub const MFLAG_KNOCKBACK: C2RustUnnamed_29 = 128;
pub const MFLAG_DROP: C2RustUnnamed_29 = 64;
pub const MFLAG_MKILLER: C2RustUnnamed_29 = 32;
pub const MFLAG_MID: C2RustUnnamed_29 = 16;
pub const MFLAG_NOHEAL: C2RustUnnamed_29 = 8;
pub const MFLAG_STILL: C2RustUnnamed_29 = 4;
pub const MFLAG_BACKWARDS: C2RustUnnamed_29 = 2;
pub const MFLAG_INVISIBLE: C2RustUnnamed_29 = 1;
pub type C2RustUnnamed_30 = libc::c_uint;
pub const MG_WAITTOTALK: C2RustUnnamed_30 = 7;
pub const MG_TALK: C2RustUnnamed_30 = 6;
pub const MG_ATTACK2: C2RustUnnamed_30 = 5;
pub const MG_WALK_AROUND1: C2RustUnnamed_30 = 4;
pub const MG_EAT: C2RustUnnamed_30 = 3;
pub const MG_RUN_AWAY: C2RustUnnamed_30 = 2;
pub const MG_ATTACK: C2RustUnnamed_30 = 1;
pub type C2RustUnnamed_31 = libc::c_uint;
pub const MM_TALK: C2RustUnnamed_31 = 17;
pub const MM_HEAL: C2RustUnnamed_31 = 16;
pub const MM_STONE: C2RustUnnamed_31 = 15;
pub const MM_MISSILE: C2RustUnnamed_31 = 14;
pub const MM_DELAY: C2RustUnnamed_31 = 13;
pub const MM_RSATTACK: C2RustUnnamed_31 = 12;
pub const MM_SPSTAND: C2RustUnnamed_31 = 11;
pub const MM_RATTACK: C2RustUnnamed_31 = 10;
pub const MM_FADEOUT: C2RustUnnamed_31 = 9;
pub const MM_FADEIN: C2RustUnnamed_31 = 8;
pub const MM_SATTACK: C2RustUnnamed_31 = 7;
pub const MM_DEATH: C2RustUnnamed_31 = 6;
pub const MM_GOTHIT: C2RustUnnamed_31 = 5;
pub const MM_ATTACK: C2RustUnnamed_31 = 4;
pub const MM_WALK3: C2RustUnnamed_31 = 3;
pub const MM_WALK2: C2RustUnnamed_31 = 2;
pub const MM_WALK: C2RustUnnamed_31 = 1;
pub const MM_STAND: C2RustUnnamed_31 = 0;
pub type C2RustUnnamed_32 = libc::c_uint;
pub const NUM_CMDS: C2RustUnnamed_32 = 96;
pub const FAKE_CMD_DROPID: C2RustUnnamed_32 = 95;
pub const FAKE_CMD_SETID: C2RustUnnamed_32 = 94;
pub const CMD_REMSHIELD: C2RustUnnamed_32 = 93;
pub const CMD_SETSHIELD: C2RustUnnamed_32 = 92;
pub const CMD_NOVA: C2RustUnnamed_32 = 91;
pub const CMD_AWAKEGOLEM: C2RustUnnamed_32 = 90;
pub const CMD_ENDSHIELD: C2RustUnnamed_32 = 89;
pub const CMD_SYNCQUEST: C2RustUnnamed_32 = 88;
pub const CMD_KILLGOLEM: C2RustUnnamed_32 = 87;
pub const CMD_SYNCPUTITEM: C2RustUnnamed_32 = 86;
pub const CMD_ITEMEXTRA: C2RustUnnamed_32 = 85;
pub const CMD_SPELLXYD: C2RustUnnamed_32 = 84;
pub const CMD_RETOWN: C2RustUnnamed_32 = 83;
pub const CMD_SETVIT: C2RustUnnamed_32 = 82;
pub const CMD_SETDEX: C2RustUnnamed_32 = 81;
pub const CMD_SETMAG: C2RustUnnamed_32 = 80;
pub const CMD_SETSTR: C2RustUnnamed_32 = 79;
pub const CMD_STRING: C2RustUnnamed_32 = 78;
pub const CMD_HEALOTHER: C2RustUnnamed_32 = 77;
pub const CMD_DLEVEL_END: C2RustUnnamed_32 = 76;
pub const CMD_DLEVEL_JUNK: C2RustUnnamed_32 = 75;
pub const CMD_DLEVEL_16: C2RustUnnamed_32 = 74;
pub const CMD_DLEVEL_15: C2RustUnnamed_32 = 73;
pub const CMD_DLEVEL_14: C2RustUnnamed_32 = 72;
pub const CMD_DLEVEL_13: C2RustUnnamed_32 = 71;
pub const CMD_DLEVEL_12: C2RustUnnamed_32 = 70;
pub const CMD_DLEVEL_11: C2RustUnnamed_32 = 69;
pub const CMD_DLEVEL_10: C2RustUnnamed_32 = 68;
pub const CMD_DLEVEL_9: C2RustUnnamed_32 = 67;
pub const CMD_DLEVEL_8: C2RustUnnamed_32 = 66;
pub const CMD_DLEVEL_7: C2RustUnnamed_32 = 65;
pub const CMD_DLEVEL_6: C2RustUnnamed_32 = 64;
pub const CMD_DLEVEL_5: C2RustUnnamed_32 = 63;
pub const CMD_DLEVEL_4: C2RustUnnamed_32 = 62;
pub const CMD_DLEVEL_3: C2RustUnnamed_32 = 61;
pub const CMD_DLEVEL_2: C2RustUnnamed_32 = 60;
pub const CMD_DLEVEL_1: C2RustUnnamed_32 = 59;
pub const CMD_DLEVEL_0: C2RustUnnamed_32 = 58;
pub const CMD_DEACTIVATEPORTAL: C2RustUnnamed_32 = 57;
pub const CMD_ACTIVATEPORTAL: C2RustUnnamed_32 = 56;
pub const CMD_SATTACKXY: C2RustUnnamed_32 = 55;
pub const CMD_SEND_PLRINFO: C2RustUnnamed_32 = 54;
pub const CMD_PLAYER_JOINLEVEL: C2RustUnnamed_32 = 53;
pub const CMD_DROPITEM: C2RustUnnamed_32 = 52;
pub const CMD_PLRLEVEL: C2RustUnnamed_32 = 51;
pub const CMD_PLRDAMAGE: C2RustUnnamed_32 = 50;
pub const CMD_DELPLRITEMS: C2RustUnnamed_32 = 49;
pub const CMD_CHANGEPLRITEMS: C2RustUnnamed_32 = 48;
pub const CMD_BREAKOBJ: C2RustUnnamed_32 = 47;
pub const CMD_PLROPOBJ: C2RustUnnamed_32 = 46;
pub const CMD_OPERATEOBJ: C2RustUnnamed_32 = 45;
pub const CMD_CLOSEDOOR: C2RustUnnamed_32 = 44;
pub const CMD_OPENDOOR: C2RustUnnamed_32 = 43;
pub const CMD_GOTOAGETITEM: C2RustUnnamed_32 = 42;
pub const CMD_GOTOGETITEM: C2RustUnnamed_32 = 41;
pub const CMD_REQUESTAGITEM: C2RustUnnamed_32 = 40;
pub const CMD_REQUESTGITEM: C2RustUnnamed_32 = 39;
pub const CMD_PLRDEAD: C2RustUnnamed_32 = 38;
pub const CMD_MONSTDAMAGE: C2RustUnnamed_32 = 37;
pub const CMD_MONSTDEATH: C2RustUnnamed_32 = 36;
pub const CMD_SYNCDATA: C2RustUnnamed_32 = 35;
pub const CMD_DEBUG: C2RustUnnamed_32 = 34;
pub const CMD_CHEAT_SPELL_LEVEL: C2RustUnnamed_32 = 33;
pub const CMD_CHEAT_EXPERIENCE: C2RustUnnamed_32 = 32;
pub const CMD_WARP: C2RustUnnamed_32 = 31;
pub const CMD_NEWLVL: C2RustUnnamed_32 = 30;
pub const CMD_TALKXY: C2RustUnnamed_32 = 29;
pub const CMD_KNOCKBACK: C2RustUnnamed_32 = 28;
pub const CMD_OPOBJT: C2RustUnnamed_32 = 27;
pub const CMD_RESURRECT: C2RustUnnamed_32 = 26;
pub const CMD_TSPELLPID: C2RustUnnamed_32 = 25;
pub const CMD_TSPELLID: C2RustUnnamed_32 = 24;
pub const CMD_SPELLPID: C2RustUnnamed_32 = 23;
pub const CMD_SPELLID: C2RustUnnamed_32 = 22;
pub const CMD_RATTACKPID: C2RustUnnamed_32 = 21;
pub const CMD_RATTACKID: C2RustUnnamed_32 = 20;
pub const CMD_ATTACKPID: C2RustUnnamed_32 = 19;
pub const CMD_ATTACKID: C2RustUnnamed_32 = 18;
pub const CMD_DISARMXY: C2RustUnnamed_32 = 17;
pub const CMD_OPOBJXY: C2RustUnnamed_32 = 16;
pub const CMD_TSPELLXY: C2RustUnnamed_32 = 15;
pub const CMD_SPELLXY: C2RustUnnamed_32 = 14;
pub const CMD_RATTACKXY: C2RustUnnamed_32 = 13;
pub const CMD_ATTACKXY: C2RustUnnamed_32 = 12;
pub const CMD_RESPAWNITEM: C2RustUnnamed_32 = 11;
pub const CMD_PUTITEM: C2RustUnnamed_32 = 10;
pub const CMD_AGETITEM: C2RustUnnamed_32 = 9;
pub const CMD_GETITEM: C2RustUnnamed_32 = 8;
pub const CMD_SBSPELL: C2RustUnnamed_32 = 7;
pub const CMD_ADDVIT: C2RustUnnamed_32 = 6;
pub const CMD_ADDDEX: C2RustUnnamed_32 = 5;
pub const CMD_ADDMAG: C2RustUnnamed_32 = 4;
pub const CMD_ADDSTR: C2RustUnnamed_32 = 3;
pub const CMD_ACK_PLRINFO: C2RustUnnamed_32 = 2;
pub const CMD_WALKXY: C2RustUnnamed_32 = 1;
pub const CMD_STAND: C2RustUnnamed_32 = 0;
pub type C2RustUnnamed_33 = libc::c_int;
pub const OBJ_BROKEN: C2RustUnnamed_33 = -1;
pub const OBJ_BREAKABLE: C2RustUnnamed_33 = 1;
pub const OBJ_NOBREAK: C2RustUnnamed_33 = 0;
pub type C2RustUnnamed_34 = libc::c_uint;
pub const USFX_DIABLOD: C2RustUnnamed_34 = 857;
pub const USFX_ZHAR2: C2RustUnnamed_34 = 856;
pub const USFX_ZHAR1: C2RustUnnamed_34 = 855;
pub const USFX_WLOCK1: C2RustUnnamed_34 = 854;
pub const USFX_WARLRD1: C2RustUnnamed_34 = 853;
pub const USFX_SNOT3: C2RustUnnamed_34 = 852;
pub const USFX_SNOT2: C2RustUnnamed_34 = 851;
pub const USFX_SNOT1: C2RustUnnamed_34 = 850;
pub const USFX_SKING1: C2RustUnnamed_34 = 849;
pub const USFX_LAZ2: C2RustUnnamed_34 = 848;
pub const USFX_LAZ1: C2RustUnnamed_34 = 847;
pub const USFX_LACH3: C2RustUnnamed_34 = 846;
pub const USFX_LACH2: C2RustUnnamed_34 = 845;
pub const USFX_LACH1: C2RustUnnamed_34 = 844;
pub const USFX_IZUAL1: C2RustUnnamed_34 = 843;
pub const USFX_GARBUD4: C2RustUnnamed_34 = 842;
pub const USFX_GARBUD3: C2RustUnnamed_34 = 841;
pub const USFX_GARBUD2: C2RustUnnamed_34 = 840;
pub const USFX_GARBUD1: C2RustUnnamed_34 = 839;
pub const USFX_CLEAVER: C2RustUnnamed_34 = 838;
pub const PS_DIABLVLINT: C2RustUnnamed_34 = 837;
pub const PS_NAR9: C2RustUnnamed_34 = 836;
pub const PS_NAR8: C2RustUnnamed_34 = 835;
pub const PS_NAR7: C2RustUnnamed_34 = 834;
pub const PS_NAR6: C2RustUnnamed_34 = 833;
pub const PS_NAR5: C2RustUnnamed_34 = 832;
pub const PS_NAR4: C2RustUnnamed_34 = 831;
pub const PS_NAR3: C2RustUnnamed_34 = 830;
pub const PS_NAR2: C2RustUnnamed_34 = 829;
pub const PS_NAR1: C2RustUnnamed_34 = 828;
pub const PS_WARR102: C2RustUnnamed_34 = 827;
pub const PS_WARR101: C2RustUnnamed_34 = 826;
pub const PS_WARR100: C2RustUnnamed_34 = 825;
pub const PS_WARR99: C2RustUnnamed_34 = 824;
pub const PS_WARR98: C2RustUnnamed_34 = 823;
pub const PS_WARR97: C2RustUnnamed_34 = 822;
pub const PS_WARR96B: C2RustUnnamed_34 = 821;
pub const PS_WARR95F: C2RustUnnamed_34 = 820;
pub const PS_WARR95E: C2RustUnnamed_34 = 819;
pub const PS_WARR95D: C2RustUnnamed_34 = 818;
pub const PS_WARR95C: C2RustUnnamed_34 = 817;
pub const PS_WARR95B: C2RustUnnamed_34 = 816;
pub const PS_WARR95: C2RustUnnamed_34 = 815;
pub const PS_WARR94: C2RustUnnamed_34 = 814;
pub const PS_WARR93: C2RustUnnamed_34 = 813;
pub const PS_WARR92: C2RustUnnamed_34 = 812;
pub const PS_WARR91: C2RustUnnamed_34 = 811;
pub const PS_WARR90: C2RustUnnamed_34 = 810;
pub const PS_WARR89: C2RustUnnamed_34 = 809;
pub const PS_WARR88: C2RustUnnamed_34 = 808;
pub const PS_WARR87: C2RustUnnamed_34 = 807;
pub const PS_WARR86: C2RustUnnamed_34 = 806;
pub const PS_WARR85: C2RustUnnamed_34 = 805;
pub const PS_WARR84: C2RustUnnamed_34 = 804;
pub const PS_WARR83: C2RustUnnamed_34 = 803;
pub const PS_WARR82: C2RustUnnamed_34 = 802;
pub const PS_WARR81: C2RustUnnamed_34 = 801;
pub const PS_WARR80: C2RustUnnamed_34 = 800;
pub const PS_WARR79: C2RustUnnamed_34 = 799;
pub const PS_WARR78: C2RustUnnamed_34 = 798;
pub const PS_WARR77: C2RustUnnamed_34 = 797;
pub const PS_WARR76: C2RustUnnamed_34 = 796;
pub const PS_WARR75: C2RustUnnamed_34 = 795;
pub const PS_WARR74: C2RustUnnamed_34 = 794;
pub const PS_WARR73: C2RustUnnamed_34 = 793;
pub const PS_WARR72: C2RustUnnamed_34 = 792;
pub const PS_WARR71: C2RustUnnamed_34 = 791;
pub const PS_WARR70: C2RustUnnamed_34 = 790;
pub const PS_WARR69B: C2RustUnnamed_34 = 789;
pub const PS_WARR69: C2RustUnnamed_34 = 788;
pub const PS_WARR68: C2RustUnnamed_34 = 787;
pub const PS_WARR67: C2RustUnnamed_34 = 786;
pub const PS_WARR66: C2RustUnnamed_34 = 785;
pub const PS_WARR65: C2RustUnnamed_34 = 784;
pub const PS_WARR64: C2RustUnnamed_34 = 783;
pub const PS_WARR63: C2RustUnnamed_34 = 782;
pub const PS_WARR62: C2RustUnnamed_34 = 781;
pub const PS_WARR61: C2RustUnnamed_34 = 780;
pub const PS_WARR60: C2RustUnnamed_34 = 779;
pub const PS_WARR59: C2RustUnnamed_34 = 778;
pub const PS_WARR58: C2RustUnnamed_34 = 777;
pub const PS_WARR57: C2RustUnnamed_34 = 776;
pub const PS_WARR56: C2RustUnnamed_34 = 775;
pub const PS_WARR55: C2RustUnnamed_34 = 774;
pub const PS_WARR54: C2RustUnnamed_34 = 773;
pub const PS_WARR53: C2RustUnnamed_34 = 772;
pub const PS_WARR52: C2RustUnnamed_34 = 771;
pub const PS_WARR51: C2RustUnnamed_34 = 770;
pub const PS_WARR50: C2RustUnnamed_34 = 769;
pub const PS_WARR49: C2RustUnnamed_34 = 768;
pub const PS_WARR48: C2RustUnnamed_34 = 767;
pub const PS_WARR47: C2RustUnnamed_34 = 766;
pub const PS_WARR46: C2RustUnnamed_34 = 765;
pub const PS_WARR45: C2RustUnnamed_34 = 764;
pub const PS_WARR44: C2RustUnnamed_34 = 763;
pub const PS_WARR43: C2RustUnnamed_34 = 762;
pub const PS_WARR42: C2RustUnnamed_34 = 761;
pub const PS_WARR41: C2RustUnnamed_34 = 760;
pub const PS_WARR40: C2RustUnnamed_34 = 759;
pub const PS_WARR39: C2RustUnnamed_34 = 758;
pub const PS_WARR38: C2RustUnnamed_34 = 757;
pub const PS_WARR37: C2RustUnnamed_34 = 756;
pub const PS_WARR36: C2RustUnnamed_34 = 755;
pub const PS_WARR35: C2RustUnnamed_34 = 754;
pub const PS_WARR34: C2RustUnnamed_34 = 753;
pub const PS_WARR33: C2RustUnnamed_34 = 752;
pub const PS_WARR32: C2RustUnnamed_34 = 751;
pub const PS_WARR31: C2RustUnnamed_34 = 750;
pub const PS_WARR30: C2RustUnnamed_34 = 749;
pub const PS_WARR29: C2RustUnnamed_34 = 748;
pub const PS_WARR28: C2RustUnnamed_34 = 747;
pub const PS_WARR27: C2RustUnnamed_34 = 746;
pub const PS_WARR26: C2RustUnnamed_34 = 745;
pub const PS_WARR25: C2RustUnnamed_34 = 744;
pub const PS_WARR24: C2RustUnnamed_34 = 743;
pub const PS_WARR23: C2RustUnnamed_34 = 742;
pub const PS_WARR22: C2RustUnnamed_34 = 741;
pub const PS_WARR21: C2RustUnnamed_34 = 740;
pub const PS_WARR20: C2RustUnnamed_34 = 739;
pub const PS_WARR19: C2RustUnnamed_34 = 738;
pub const PS_WARR18: C2RustUnnamed_34 = 737;
pub const PS_WARR17: C2RustUnnamed_34 = 736;
pub const PS_WARR16C: C2RustUnnamed_34 = 735;
pub const PS_WARR16B: C2RustUnnamed_34 = 734;
pub const PS_WARR16: C2RustUnnamed_34 = 733;
pub const PS_WARR15C: C2RustUnnamed_34 = 732;
pub const PS_WARR15B: C2RustUnnamed_34 = 731;
pub const PS_WARR15: C2RustUnnamed_34 = 730;
pub const PS_WARR14C: C2RustUnnamed_34 = 729;
pub const PS_WARR14B: C2RustUnnamed_34 = 728;
pub const PS_WARR14: C2RustUnnamed_34 = 727;
pub const PS_WARR13: C2RustUnnamed_34 = 726;
pub const PS_WARR12: C2RustUnnamed_34 = 725;
pub const PS_WARR11: C2RustUnnamed_34 = 724;
pub const PS_WARR10: C2RustUnnamed_34 = 723;
pub const PS_WARR9: C2RustUnnamed_34 = 722;
pub const PS_WARR8: C2RustUnnamed_34 = 721;
pub const PS_WARR7: C2RustUnnamed_34 = 720;
pub const PS_WARR6: C2RustUnnamed_34 = 719;
pub const PS_WARR5: C2RustUnnamed_34 = 718;
pub const PS_WARR4: C2RustUnnamed_34 = 717;
pub const PS_WARR3: C2RustUnnamed_34 = 716;
pub const PS_WARR2: C2RustUnnamed_34 = 715;
pub const PS_WARR1: C2RustUnnamed_34 = 714;
pub const PS_ROGUE102: C2RustUnnamed_34 = 713;
pub const PS_ROGUE101: C2RustUnnamed_34 = 712;
pub const PS_ROGUE100: C2RustUnnamed_34 = 711;
pub const PS_ROGUE99: C2RustUnnamed_34 = 710;
pub const PS_ROGUE98: C2RustUnnamed_34 = 709;
pub const PS_ROGUE97: C2RustUnnamed_34 = 708;
pub const PS_ROGUE96: C2RustUnnamed_34 = 707;
pub const PS_ROGUE95: C2RustUnnamed_34 = 706;
pub const PS_ROGUE94: C2RustUnnamed_34 = 705;
pub const PS_ROGUE93: C2RustUnnamed_34 = 704;
pub const PS_ROGUE92: C2RustUnnamed_34 = 703;
pub const PS_ROGUE91: C2RustUnnamed_34 = 702;
pub const PS_ROGUE90: C2RustUnnamed_34 = 701;
pub const PS_ROGUE89: C2RustUnnamed_34 = 700;
pub const PS_ROGUE88: C2RustUnnamed_34 = 699;
pub const PS_ROGUE87: C2RustUnnamed_34 = 698;
pub const PS_ROGUE86: C2RustUnnamed_34 = 697;
pub const PS_ROGUE85: C2RustUnnamed_34 = 696;
pub const PS_ROGUE84: C2RustUnnamed_34 = 695;
pub const PS_ROGUE83: C2RustUnnamed_34 = 694;
pub const PS_ROGUE82: C2RustUnnamed_34 = 693;
pub const PS_ROGUE81: C2RustUnnamed_34 = 692;
pub const PS_ROGUE80: C2RustUnnamed_34 = 691;
pub const PS_ROGUE79: C2RustUnnamed_34 = 690;
pub const PS_ROGUE78: C2RustUnnamed_34 = 689;
pub const PS_ROGUE77: C2RustUnnamed_34 = 688;
pub const PS_ROGUE76: C2RustUnnamed_34 = 687;
pub const PS_ROGUE75: C2RustUnnamed_34 = 686;
pub const PS_ROGUE74: C2RustUnnamed_34 = 685;
pub const PS_ROGUE73: C2RustUnnamed_34 = 684;
pub const PS_ROGUE72: C2RustUnnamed_34 = 683;
pub const PS_ROGUE71: C2RustUnnamed_34 = 682;
pub const PS_ROGUE70: C2RustUnnamed_34 = 681;
pub const PS_ROGUE69B: C2RustUnnamed_34 = 680;
pub const PS_ROGUE69: C2RustUnnamed_34 = 679;
pub const PS_ROGUE68: C2RustUnnamed_34 = 678;
pub const PS_ROGUE67: C2RustUnnamed_34 = 677;
pub const PS_ROGUE66: C2RustUnnamed_34 = 676;
pub const PS_ROGUE65: C2RustUnnamed_34 = 675;
pub const PS_ROGUE64: C2RustUnnamed_34 = 674;
pub const PS_ROGUE63: C2RustUnnamed_34 = 673;
pub const PS_ROGUE62: C2RustUnnamed_34 = 672;
pub const PS_ROGUE61: C2RustUnnamed_34 = 671;
pub const PS_ROGUE60: C2RustUnnamed_34 = 670;
pub const PS_ROGUE59: C2RustUnnamed_34 = 669;
pub const PS_ROGUE58: C2RustUnnamed_34 = 668;
pub const PS_ROGUE57: C2RustUnnamed_34 = 667;
pub const PS_ROGUE56: C2RustUnnamed_34 = 666;
pub const PS_ROGUE55: C2RustUnnamed_34 = 665;
pub const PS_ROGUE54: C2RustUnnamed_34 = 664;
pub const PS_ROGUE53: C2RustUnnamed_34 = 663;
pub const PS_ROGUE52: C2RustUnnamed_34 = 662;
pub const PS_ROGUE51: C2RustUnnamed_34 = 661;
pub const PS_ROGUE50: C2RustUnnamed_34 = 660;
pub const PS_ROGUE49: C2RustUnnamed_34 = 659;
pub const PS_ROGUE48: C2RustUnnamed_34 = 658;
pub const PS_ROGUE47: C2RustUnnamed_34 = 657;
pub const PS_ROGUE46: C2RustUnnamed_34 = 656;
pub const PS_ROGUE45: C2RustUnnamed_34 = 655;
pub const PS_ROGUE44: C2RustUnnamed_34 = 654;
pub const PS_ROGUE43: C2RustUnnamed_34 = 653;
pub const PS_ROGUE42: C2RustUnnamed_34 = 652;
pub const PS_ROGUE41: C2RustUnnamed_34 = 651;
pub const PS_ROGUE40: C2RustUnnamed_34 = 650;
pub const PS_ROGUE39: C2RustUnnamed_34 = 649;
pub const PS_ROGUE38: C2RustUnnamed_34 = 648;
pub const PS_ROGUE37: C2RustUnnamed_34 = 647;
pub const PS_ROGUE36: C2RustUnnamed_34 = 646;
pub const PS_ROGUE35: C2RustUnnamed_34 = 645;
pub const PS_ROGUE34: C2RustUnnamed_34 = 644;
pub const PS_ROGUE33: C2RustUnnamed_34 = 643;
pub const PS_ROGUE32: C2RustUnnamed_34 = 642;
pub const PS_ROGUE31: C2RustUnnamed_34 = 641;
pub const PS_ROGUE30: C2RustUnnamed_34 = 640;
pub const PS_ROGUE29: C2RustUnnamed_34 = 639;
pub const PS_ROGUE28: C2RustUnnamed_34 = 638;
pub const PS_ROGUE27: C2RustUnnamed_34 = 637;
pub const PS_ROGUE26: C2RustUnnamed_34 = 636;
pub const PS_ROGUE25: C2RustUnnamed_34 = 635;
pub const PS_ROGUE24: C2RustUnnamed_34 = 634;
pub const PS_ROGUE23: C2RustUnnamed_34 = 633;
pub const PS_ROGUE22: C2RustUnnamed_34 = 632;
pub const PS_ROGUE21: C2RustUnnamed_34 = 631;
pub const PS_ROGUE20: C2RustUnnamed_34 = 630;
pub const PS_ROGUE19: C2RustUnnamed_34 = 629;
pub const PS_ROGUE18: C2RustUnnamed_34 = 628;
pub const PS_ROGUE17: C2RustUnnamed_34 = 627;
pub const PS_ROGUE16: C2RustUnnamed_34 = 626;
pub const PS_ROGUE15: C2RustUnnamed_34 = 625;
pub const PS_ROGUE14: C2RustUnnamed_34 = 624;
pub const PS_ROGUE13: C2RustUnnamed_34 = 623;
pub const PS_ROGUE12: C2RustUnnamed_34 = 622;
pub const PS_ROGUE11: C2RustUnnamed_34 = 621;
pub const PS_ROGUE10: C2RustUnnamed_34 = 620;
pub const PS_ROGUE9: C2RustUnnamed_34 = 619;
pub const PS_ROGUE8: C2RustUnnamed_34 = 618;
pub const PS_ROGUE7: C2RustUnnamed_34 = 617;
pub const PS_ROGUE6: C2RustUnnamed_34 = 616;
pub const PS_ROGUE5: C2RustUnnamed_34 = 615;
pub const PS_ROGUE4: C2RustUnnamed_34 = 614;
pub const PS_ROGUE3: C2RustUnnamed_34 = 613;
pub const PS_ROGUE2: C2RustUnnamed_34 = 612;
pub const PS_ROGUE1: C2RustUnnamed_34 = 611;
pub const PS_MAGE102: C2RustUnnamed_34 = 610;
pub const PS_MAGE101: C2RustUnnamed_34 = 609;
pub const PS_MAGE100: C2RustUnnamed_34 = 608;
pub const PS_MAGE99: C2RustUnnamed_34 = 607;
pub const PS_MAGE98: C2RustUnnamed_34 = 606;
pub const PS_MAGE97: C2RustUnnamed_34 = 605;
pub const PS_MAGE96: C2RustUnnamed_34 = 604;
pub const PS_MAGE95: C2RustUnnamed_34 = 603;
pub const PS_MAGE94: C2RustUnnamed_34 = 602;
pub const PS_MAGE93: C2RustUnnamed_34 = 601;
pub const PS_MAGE92: C2RustUnnamed_34 = 600;
pub const PS_MAGE91: C2RustUnnamed_34 = 599;
pub const PS_MAGE90: C2RustUnnamed_34 = 598;
pub const PS_MAGE89: C2RustUnnamed_34 = 597;
pub const PS_MAGE88: C2RustUnnamed_34 = 596;
pub const PS_MAGE87: C2RustUnnamed_34 = 595;
pub const PS_MAGE86: C2RustUnnamed_34 = 594;
pub const PS_MAGE85: C2RustUnnamed_34 = 593;
pub const PS_MAGE84: C2RustUnnamed_34 = 592;
pub const PS_MAGE83: C2RustUnnamed_34 = 591;
pub const PS_MAGE82: C2RustUnnamed_34 = 590;
pub const PS_MAGE81: C2RustUnnamed_34 = 589;
pub const PS_MAGE80: C2RustUnnamed_34 = 588;
pub const PS_MAGE79: C2RustUnnamed_34 = 587;
pub const PS_MAGE78: C2RustUnnamed_34 = 586;
pub const PS_MAGE77: C2RustUnnamed_34 = 585;
pub const PS_MAGE76: C2RustUnnamed_34 = 584;
pub const PS_MAGE75: C2RustUnnamed_34 = 583;
pub const PS_MAGE74: C2RustUnnamed_34 = 582;
pub const PS_MAGE73: C2RustUnnamed_34 = 581;
pub const PS_MAGE72: C2RustUnnamed_34 = 580;
pub const PS_MAGE71: C2RustUnnamed_34 = 579;
pub const PS_MAGE70: C2RustUnnamed_34 = 578;
pub const PS_MAGE69B: C2RustUnnamed_34 = 577;
pub const PS_MAGE69: C2RustUnnamed_34 = 576;
pub const PS_MAGE68: C2RustUnnamed_34 = 575;
pub const PS_MAGE67: C2RustUnnamed_34 = 574;
pub const PS_MAGE66: C2RustUnnamed_34 = 573;
pub const PS_MAGE65: C2RustUnnamed_34 = 572;
pub const PS_MAGE64: C2RustUnnamed_34 = 571;
pub const PS_MAGE63: C2RustUnnamed_34 = 570;
pub const PS_MAGE62: C2RustUnnamed_34 = 569;
pub const PS_MAGE61: C2RustUnnamed_34 = 568;
pub const PS_MAGE60: C2RustUnnamed_34 = 567;
pub const PS_MAGE59: C2RustUnnamed_34 = 566;
pub const PS_MAGE58: C2RustUnnamed_34 = 565;
pub const PS_MAGE57: C2RustUnnamed_34 = 564;
pub const PS_MAGE56: C2RustUnnamed_34 = 563;
pub const PS_MAGE55: C2RustUnnamed_34 = 562;
pub const PS_MAGE54: C2RustUnnamed_34 = 561;
pub const PS_MAGE53: C2RustUnnamed_34 = 560;
pub const PS_MAGE52: C2RustUnnamed_34 = 559;
pub const PS_MAGE51: C2RustUnnamed_34 = 558;
pub const PS_MAGE50: C2RustUnnamed_34 = 557;
pub const PS_MAGE49: C2RustUnnamed_34 = 556;
pub const PS_MAGE48: C2RustUnnamed_34 = 555;
pub const PS_MAGE47: C2RustUnnamed_34 = 554;
pub const PS_MAGE46: C2RustUnnamed_34 = 553;
pub const PS_MAGE45: C2RustUnnamed_34 = 552;
pub const PS_MAGE44: C2RustUnnamed_34 = 551;
pub const PS_MAGE43: C2RustUnnamed_34 = 550;
pub const PS_MAGE42: C2RustUnnamed_34 = 549;
pub const PS_MAGE41: C2RustUnnamed_34 = 548;
pub const PS_MAGE40: C2RustUnnamed_34 = 547;
pub const PS_MAGE39: C2RustUnnamed_34 = 546;
pub const PS_MAGE38: C2RustUnnamed_34 = 545;
pub const PS_MAGE37: C2RustUnnamed_34 = 544;
pub const PS_MAGE36: C2RustUnnamed_34 = 543;
pub const PS_MAGE35: C2RustUnnamed_34 = 542;
pub const PS_MAGE34: C2RustUnnamed_34 = 541;
pub const PS_MAGE33: C2RustUnnamed_34 = 540;
pub const PS_MAGE32: C2RustUnnamed_34 = 539;
pub const PS_MAGE31: C2RustUnnamed_34 = 538;
pub const PS_MAGE30: C2RustUnnamed_34 = 537;
pub const PS_MAGE29: C2RustUnnamed_34 = 536;
pub const PS_MAGE28: C2RustUnnamed_34 = 535;
pub const PS_MAGE27: C2RustUnnamed_34 = 534;
pub const PS_MAGE26: C2RustUnnamed_34 = 533;
pub const PS_MAGE25: C2RustUnnamed_34 = 532;
pub const PS_MAGE24: C2RustUnnamed_34 = 531;
pub const PS_MAGE23: C2RustUnnamed_34 = 530;
pub const PS_MAGE22: C2RustUnnamed_34 = 529;
pub const PS_MAGE21: C2RustUnnamed_34 = 528;
pub const PS_MAGE20: C2RustUnnamed_34 = 527;
pub const PS_MAGE19: C2RustUnnamed_34 = 526;
pub const PS_MAGE18: C2RustUnnamed_34 = 525;
pub const PS_MAGE17: C2RustUnnamed_34 = 524;
pub const PS_MAGE16: C2RustUnnamed_34 = 523;
pub const PS_MAGE15: C2RustUnnamed_34 = 522;
pub const PS_MAGE14: C2RustUnnamed_34 = 521;
pub const PS_MAGE13: C2RustUnnamed_34 = 520;
pub const PS_MAGE12: C2RustUnnamed_34 = 519;
pub const PS_MAGE11: C2RustUnnamed_34 = 518;
pub const PS_MAGE10: C2RustUnnamed_34 = 517;
pub const PS_MAGE9: C2RustUnnamed_34 = 516;
pub const PS_MAGE8: C2RustUnnamed_34 = 515;
pub const PS_MAGE7: C2RustUnnamed_34 = 514;
pub const PS_MAGE6: C2RustUnnamed_34 = 513;
pub const PS_MAGE5: C2RustUnnamed_34 = 512;
pub const PS_MAGE4: C2RustUnnamed_34 = 511;
pub const PS_MAGE3: C2RustUnnamed_34 = 510;
pub const PS_MAGE2: C2RustUnnamed_34 = 509;
pub const PS_MAGE1: C2RustUnnamed_34 = 508;
pub const TSFX_WOUND: C2RustUnnamed_34 = 507;
pub const TSFX_WITCH50: C2RustUnnamed_34 = 506;
pub const TSFX_WITCH49: C2RustUnnamed_34 = 505;
pub const TSFX_WITCH48: C2RustUnnamed_34 = 504;
pub const TSFX_WITCH47: C2RustUnnamed_34 = 503;
pub const TSFX_WITCH46: C2RustUnnamed_34 = 502;
pub const TSFX_WITCH45: C2RustUnnamed_34 = 501;
pub const TSFX_WITCH44: C2RustUnnamed_34 = 500;
pub const TSFX_WITCH43: C2RustUnnamed_34 = 499;
pub const TSFX_WITCH42: C2RustUnnamed_34 = 498;
pub const TSFX_WITCH41: C2RustUnnamed_34 = 497;
pub const TSFX_WITCH40: C2RustUnnamed_34 = 496;
pub const TSFX_WITCH39: C2RustUnnamed_34 = 495;
pub const TSFX_WITCH38: C2RustUnnamed_34 = 494;
pub const TSFX_WITCH37: C2RustUnnamed_34 = 493;
pub const TSFX_WITCH36: C2RustUnnamed_34 = 492;
pub const TSFX_WITCH35: C2RustUnnamed_34 = 491;
pub const TSFX_WITCH34: C2RustUnnamed_34 = 490;
pub const TSFX_WITCH33: C2RustUnnamed_34 = 489;
pub const TSFX_WITCH32: C2RustUnnamed_34 = 488;
pub const TSFX_WITCH31: C2RustUnnamed_34 = 487;
pub const TSFX_WITCH30: C2RustUnnamed_34 = 486;
pub const TSFX_WITCH29: C2RustUnnamed_34 = 485;
pub const TSFX_WITCH28: C2RustUnnamed_34 = 484;
pub const TSFX_WITCH27: C2RustUnnamed_34 = 483;
pub const TSFX_WITCH26: C2RustUnnamed_34 = 482;
pub const TSFX_WITCH25: C2RustUnnamed_34 = 481;
pub const TSFX_WITCH24: C2RustUnnamed_34 = 480;
pub const TSFX_WITCH23: C2RustUnnamed_34 = 479;
pub const TSFX_WITCH22: C2RustUnnamed_34 = 478;
pub const TSFX_WITCH21: C2RustUnnamed_34 = 477;
pub const TSFX_WITCH20: C2RustUnnamed_34 = 476;
pub const TSFX_WITCH19: C2RustUnnamed_34 = 475;
pub const TSFX_WITCH18: C2RustUnnamed_34 = 474;
pub const TSFX_WITCH17: C2RustUnnamed_34 = 473;
pub const TSFX_WITCH16: C2RustUnnamed_34 = 472;
pub const TSFX_WITCH15: C2RustUnnamed_34 = 471;
pub const TSFX_WITCH14: C2RustUnnamed_34 = 470;
pub const TSFX_WITCH13: C2RustUnnamed_34 = 469;
pub const TSFX_WITCH12: C2RustUnnamed_34 = 468;
pub const TSFX_WITCH11: C2RustUnnamed_34 = 467;
pub const TSFX_WITCH10: C2RustUnnamed_34 = 466;
pub const TSFX_WITCH9: C2RustUnnamed_34 = 465;
pub const TSFX_WITCH8: C2RustUnnamed_34 = 464;
pub const TSFX_WITCH7: C2RustUnnamed_34 = 463;
pub const TSFX_WITCH6: C2RustUnnamed_34 = 462;
pub const TSFX_WITCH5: C2RustUnnamed_34 = 461;
pub const TSFX_WITCH4: C2RustUnnamed_34 = 460;
pub const TSFX_WITCH3: C2RustUnnamed_34 = 459;
pub const TSFX_WITCH2: C2RustUnnamed_34 = 458;
pub const TSFX_WITCH1: C2RustUnnamed_34 = 457;
pub const TSFX_TAVERN45: C2RustUnnamed_34 = 456;
pub const TSFX_TAVERN44: C2RustUnnamed_34 = 455;
pub const TSFX_TAVERN43: C2RustUnnamed_34 = 454;
pub const TSFX_TAVERN42: C2RustUnnamed_34 = 453;
pub const TSFX_TAVERN41: C2RustUnnamed_34 = 452;
pub const TSFX_TAVERN40: C2RustUnnamed_34 = 451;
pub const TSFX_TAVERN39: C2RustUnnamed_34 = 450;
pub const TSFX_TAVERN38: C2RustUnnamed_34 = 449;
pub const TSFX_TAVERN37: C2RustUnnamed_34 = 448;
pub const TSFX_TAVERN36: C2RustUnnamed_34 = 447;
pub const TSFX_TAVERN35: C2RustUnnamed_34 = 446;
pub const TSFX_TAVERN34: C2RustUnnamed_34 = 445;
pub const TSFX_TAVERN33: C2RustUnnamed_34 = 444;
pub const TSFX_TAVERN32: C2RustUnnamed_34 = 443;
pub const TSFX_TAVERN31: C2RustUnnamed_34 = 442;
pub const TSFX_TAVERN30: C2RustUnnamed_34 = 441;
pub const TSFX_TAVERN29: C2RustUnnamed_34 = 440;
pub const TSFX_TAVERN28: C2RustUnnamed_34 = 439;
pub const TSFX_TAVERN27: C2RustUnnamed_34 = 438;
pub const TSFX_TAVERN26: C2RustUnnamed_34 = 437;
pub const TSFX_TAVERN25: C2RustUnnamed_34 = 436;
pub const TSFX_TAVERN24: C2RustUnnamed_34 = 435;
pub const TSFX_TAVERN23: C2RustUnnamed_34 = 434;
pub const TSFX_TAVERN22: C2RustUnnamed_34 = 433;
pub const TSFX_TAVERN21: C2RustUnnamed_34 = 432;
pub const TSFX_TAVERN20: C2RustUnnamed_34 = 431;
pub const TSFX_TAVERN19: C2RustUnnamed_34 = 430;
pub const TSFX_TAVERN18: C2RustUnnamed_34 = 429;
pub const TSFX_TAVERN17: C2RustUnnamed_34 = 428;
pub const TSFX_TAVERN16: C2RustUnnamed_34 = 427;
pub const TSFX_TAVERN15: C2RustUnnamed_34 = 426;
pub const TSFX_TAVERN14: C2RustUnnamed_34 = 425;
pub const TSFX_TAVERN13: C2RustUnnamed_34 = 424;
pub const TSFX_TAVERN12: C2RustUnnamed_34 = 423;
pub const TSFX_TAVERN11: C2RustUnnamed_34 = 422;
pub const TSFX_TAVERN10: C2RustUnnamed_34 = 421;
pub const TSFX_TAVERN9: C2RustUnnamed_34 = 420;
pub const TSFX_TAVERN8: C2RustUnnamed_34 = 419;
pub const TSFX_TAVERN7: C2RustUnnamed_34 = 418;
pub const TSFX_TAVERN6: C2RustUnnamed_34 = 417;
pub const TSFX_TAVERN5: C2RustUnnamed_34 = 416;
pub const TSFX_TAVERN4: C2RustUnnamed_34 = 415;
pub const TSFX_TAVERN3: C2RustUnnamed_34 = 414;
pub const TSFX_TAVERN2: C2RustUnnamed_34 = 413;
pub const TSFX_TAVERN1: C2RustUnnamed_34 = 412;
pub const TSFX_TAVERN0: C2RustUnnamed_34 = 411;
pub const TSFX_STORY38: C2RustUnnamed_34 = 410;
pub const TSFX_STORY37: C2RustUnnamed_34 = 409;
pub const TSFX_STORY36: C2RustUnnamed_34 = 408;
pub const TSFX_STORY35: C2RustUnnamed_34 = 407;
pub const TSFX_STORY34: C2RustUnnamed_34 = 406;
pub const TSFX_STORY33: C2RustUnnamed_34 = 405;
pub const TSFX_STORY32: C2RustUnnamed_34 = 404;
pub const TSFX_STORY31: C2RustUnnamed_34 = 403;
pub const TSFX_STORY30: C2RustUnnamed_34 = 402;
pub const TSFX_STORY29: C2RustUnnamed_34 = 401;
pub const TSFX_STORY28: C2RustUnnamed_34 = 400;
pub const TSFX_STORY27: C2RustUnnamed_34 = 399;
pub const TSFX_STORY26: C2RustUnnamed_34 = 398;
pub const TSFX_STORY25: C2RustUnnamed_34 = 397;
pub const TSFX_STORY24: C2RustUnnamed_34 = 396;
pub const TSFX_STORY23: C2RustUnnamed_34 = 395;
pub const TSFX_STORY22: C2RustUnnamed_34 = 394;
pub const TSFX_STORY21: C2RustUnnamed_34 = 393;
pub const TSFX_STORY20: C2RustUnnamed_34 = 392;
pub const TSFX_STORY19: C2RustUnnamed_34 = 391;
pub const TSFX_STORY18: C2RustUnnamed_34 = 390;
pub const TSFX_STORY17: C2RustUnnamed_34 = 389;
pub const TSFX_STORY16: C2RustUnnamed_34 = 388;
pub const TSFX_STORY15: C2RustUnnamed_34 = 387;
pub const TSFX_STORY14: C2RustUnnamed_34 = 386;
pub const TSFX_STORY13: C2RustUnnamed_34 = 385;
pub const TSFX_STORY12: C2RustUnnamed_34 = 384;
pub const TSFX_STORY11: C2RustUnnamed_34 = 383;
pub const TSFX_STORY10: C2RustUnnamed_34 = 382;
pub const TSFX_STORY9: C2RustUnnamed_34 = 381;
pub const TSFX_STORY8: C2RustUnnamed_34 = 380;
pub const TSFX_STORY7: C2RustUnnamed_34 = 379;
pub const TSFX_STORY6: C2RustUnnamed_34 = 378;
pub const TSFX_STORY5: C2RustUnnamed_34 = 377;
pub const TSFX_STORY4: C2RustUnnamed_34 = 376;
pub const TSFX_STORY3: C2RustUnnamed_34 = 375;
pub const TSFX_STORY2: C2RustUnnamed_34 = 374;
pub const TSFX_STORY1: C2RustUnnamed_34 = 373;
pub const TSFX_STORY0: C2RustUnnamed_34 = 372;
pub const TSFX_PRIEST7: C2RustUnnamed_34 = 371;
pub const TSFX_PRIEST6: C2RustUnnamed_34 = 370;
pub const TSFX_PRIEST5: C2RustUnnamed_34 = 369;
pub const TSFX_PRIEST4: C2RustUnnamed_34 = 368;
pub const TSFX_PRIEST3: C2RustUnnamed_34 = 367;
pub const TSFX_PRIEST2: C2RustUnnamed_34 = 366;
pub const TSFX_PRIEST1: C2RustUnnamed_34 = 365;
pub const TSFX_PRIEST0: C2RustUnnamed_34 = 364;
pub const TSFX_PEGBOY43: C2RustUnnamed_34 = 363;
pub const TSFX_PEGBOY42: C2RustUnnamed_34 = 362;
pub const TSFX_PEGBOY41: C2RustUnnamed_34 = 361;
pub const TSFX_PEGBOY40: C2RustUnnamed_34 = 360;
pub const TSFX_PEGBOY39: C2RustUnnamed_34 = 359;
pub const TSFX_PEGBOY38: C2RustUnnamed_34 = 358;
pub const TSFX_PEGBOY37: C2RustUnnamed_34 = 357;
pub const TSFX_PEGBOY36: C2RustUnnamed_34 = 356;
pub const TSFX_PEGBOY35: C2RustUnnamed_34 = 355;
pub const TSFX_PEGBOY34: C2RustUnnamed_34 = 354;
pub const TSFX_PEGBOY33: C2RustUnnamed_34 = 353;
pub const TSFX_PEGBOY32: C2RustUnnamed_34 = 352;
pub const TSFX_PEGBOY31: C2RustUnnamed_34 = 351;
pub const TSFX_PEGBOY30: C2RustUnnamed_34 = 350;
pub const TSFX_PEGBOY29: C2RustUnnamed_34 = 349;
pub const TSFX_PEGBOY28: C2RustUnnamed_34 = 348;
pub const TSFX_PEGBOY27: C2RustUnnamed_34 = 347;
pub const TSFX_PEGBOY26: C2RustUnnamed_34 = 346;
pub const TSFX_PEGBOY25: C2RustUnnamed_34 = 345;
pub const TSFX_PEGBOY24: C2RustUnnamed_34 = 344;
pub const TSFX_PEGBOY23: C2RustUnnamed_34 = 343;
pub const TSFX_PEGBOY22: C2RustUnnamed_34 = 342;
pub const TSFX_PEGBOY21: C2RustUnnamed_34 = 341;
pub const TSFX_PEGBOY20: C2RustUnnamed_34 = 340;
pub const TSFX_PEGBOY19: C2RustUnnamed_34 = 339;
pub const TSFX_PEGBOY18: C2RustUnnamed_34 = 338;
pub const TSFX_PEGBOY17: C2RustUnnamed_34 = 337;
pub const TSFX_PEGBOY16: C2RustUnnamed_34 = 336;
pub const TSFX_PEGBOY15: C2RustUnnamed_34 = 335;
pub const TSFX_PEGBOY14: C2RustUnnamed_34 = 334;
pub const TSFX_PEGBOY13: C2RustUnnamed_34 = 333;
pub const TSFX_PEGBOY12: C2RustUnnamed_34 = 332;
pub const TSFX_PEGBOY11: C2RustUnnamed_34 = 331;
pub const TSFX_PEGBOY10: C2RustUnnamed_34 = 330;
pub const TSFX_PEGBOY9: C2RustUnnamed_34 = 329;
pub const TSFX_PEGBOY8: C2RustUnnamed_34 = 328;
pub const TSFX_PEGBOY7: C2RustUnnamed_34 = 327;
pub const TSFX_PEGBOY6: C2RustUnnamed_34 = 326;
pub const TSFX_PEGBOY5: C2RustUnnamed_34 = 325;
pub const TSFX_PEGBOY4: C2RustUnnamed_34 = 324;
pub const TSFX_PEGBOY3: C2RustUnnamed_34 = 323;
pub const TSFX_PEGBOY2: C2RustUnnamed_34 = 322;
pub const TSFX_PEGBOY1: C2RustUnnamed_34 = 321;
pub const TSFX_HEALER47: C2RustUnnamed_34 = 320;
pub const TSFX_HEALER46: C2RustUnnamed_34 = 319;
pub const TSFX_HEALER45: C2RustUnnamed_34 = 318;
pub const TSFX_HEALER44: C2RustUnnamed_34 = 317;
pub const TSFX_HEALER43: C2RustUnnamed_34 = 316;
pub const TSFX_HEALER42: C2RustUnnamed_34 = 315;
pub const TSFX_HEALER41: C2RustUnnamed_34 = 314;
pub const TSFX_HEALER40: C2RustUnnamed_34 = 313;
pub const TSFX_HEALER39: C2RustUnnamed_34 = 312;
pub const TSFX_HEALER38: C2RustUnnamed_34 = 311;
pub const TSFX_HEALER37: C2RustUnnamed_34 = 310;
pub const TSFX_HEALER36: C2RustUnnamed_34 = 309;
pub const TSFX_HEALER35: C2RustUnnamed_34 = 308;
pub const TSFX_HEALER34: C2RustUnnamed_34 = 307;
pub const TSFX_HEALER33: C2RustUnnamed_34 = 306;
pub const TSFX_HEALER32: C2RustUnnamed_34 = 305;
pub const TSFX_HEALER31: C2RustUnnamed_34 = 304;
pub const TSFX_HEALER30: C2RustUnnamed_34 = 303;
pub const TSFX_HEALER29: C2RustUnnamed_34 = 302;
pub const TSFX_HEALER28: C2RustUnnamed_34 = 301;
pub const TSFX_HEALER27: C2RustUnnamed_34 = 300;
pub const TSFX_HEALER26: C2RustUnnamed_34 = 299;
pub const TSFX_HEALER25: C2RustUnnamed_34 = 298;
pub const TSFX_HEALER24: C2RustUnnamed_34 = 297;
pub const TSFX_HEALER23: C2RustUnnamed_34 = 296;
pub const TSFX_HEALER22: C2RustUnnamed_34 = 295;
pub const TSFX_HEALER21: C2RustUnnamed_34 = 294;
pub const TSFX_HEALER20: C2RustUnnamed_34 = 293;
pub const TSFX_HEALER19: C2RustUnnamed_34 = 292;
pub const TSFX_HEALER18: C2RustUnnamed_34 = 291;
pub const TSFX_HEALER17: C2RustUnnamed_34 = 290;
pub const TSFX_HEALER16: C2RustUnnamed_34 = 289;
pub const TSFX_HEALER15: C2RustUnnamed_34 = 288;
pub const TSFX_HEALER14: C2RustUnnamed_34 = 287;
pub const TSFX_HEALER13: C2RustUnnamed_34 = 286;
pub const TSFX_HEALER12: C2RustUnnamed_34 = 285;
pub const TSFX_HEALER11: C2RustUnnamed_34 = 284;
pub const TSFX_HEALER10: C2RustUnnamed_34 = 283;
pub const TSFX_HEALER9: C2RustUnnamed_34 = 282;
pub const TSFX_HEALER8: C2RustUnnamed_34 = 281;
pub const TSFX_HEALER7: C2RustUnnamed_34 = 280;
pub const TSFX_HEALER6: C2RustUnnamed_34 = 279;
pub const TSFX_HEALER5: C2RustUnnamed_34 = 278;
pub const TSFX_HEALER4: C2RustUnnamed_34 = 277;
pub const TSFX_HEALER3: C2RustUnnamed_34 = 276;
pub const TSFX_HEALER2: C2RustUnnamed_34 = 275;
pub const TSFX_HEALER1: C2RustUnnamed_34 = 274;
pub const TSFX_DRUNK35: C2RustUnnamed_34 = 273;
pub const TSFX_DRUNK34: C2RustUnnamed_34 = 272;
pub const TSFX_DRUNK33: C2RustUnnamed_34 = 271;
pub const TSFX_DRUNK32: C2RustUnnamed_34 = 270;
pub const TSFX_DRUNK31: C2RustUnnamed_34 = 269;
pub const TSFX_DRUNK30: C2RustUnnamed_34 = 268;
pub const TSFX_DRUNK29: C2RustUnnamed_34 = 267;
pub const TSFX_DRUNK28: C2RustUnnamed_34 = 266;
pub const TSFX_DRUNK27: C2RustUnnamed_34 = 265;
pub const TSFX_DRUNK26: C2RustUnnamed_34 = 264;
pub const TSFX_DRUNK25: C2RustUnnamed_34 = 263;
pub const TSFX_DRUNK24: C2RustUnnamed_34 = 262;
pub const TSFX_DRUNK23: C2RustUnnamed_34 = 261;
pub const TSFX_DRUNK22: C2RustUnnamed_34 = 260;
pub const TSFX_DRUNK21: C2RustUnnamed_34 = 259;
pub const TSFX_DRUNK20: C2RustUnnamed_34 = 258;
pub const TSFX_DRUNK19: C2RustUnnamed_34 = 257;
pub const TSFX_DRUNK18: C2RustUnnamed_34 = 256;
pub const TSFX_DRUNK17: C2RustUnnamed_34 = 255;
pub const TSFX_DRUNK16: C2RustUnnamed_34 = 254;
pub const TSFX_DRUNK15: C2RustUnnamed_34 = 253;
pub const TSFX_DRUNK14: C2RustUnnamed_34 = 252;
pub const TSFX_DRUNK13: C2RustUnnamed_34 = 251;
pub const TSFX_DRUNK12: C2RustUnnamed_34 = 250;
pub const TSFX_DRUNK11: C2RustUnnamed_34 = 249;
pub const TSFX_DRUNK10: C2RustUnnamed_34 = 248;
pub const TSFX_DRUNK9: C2RustUnnamed_34 = 247;
pub const TSFX_DRUNK8: C2RustUnnamed_34 = 246;
pub const TSFX_DRUNK7: C2RustUnnamed_34 = 245;
pub const TSFX_DRUNK6: C2RustUnnamed_34 = 244;
pub const TSFX_DRUNK5: C2RustUnnamed_34 = 243;
pub const TSFX_DRUNK4: C2RustUnnamed_34 = 242;
pub const TSFX_DRUNK3: C2RustUnnamed_34 = 241;
pub const TSFX_DRUNK2: C2RustUnnamed_34 = 240;
pub const TSFX_DRUNK1: C2RustUnnamed_34 = 239;
pub const TSFX_DEADGUY: C2RustUnnamed_34 = 238;
pub const TSFX_COW2: C2RustUnnamed_34 = 237;
pub const TSFX_COW1: C2RustUnnamed_34 = 236;
pub const TSFX_SMITH56: C2RustUnnamed_34 = 235;
pub const TSFX_SMITH55: C2RustUnnamed_34 = 234;
pub const TSFX_SMITH54: C2RustUnnamed_34 = 233;
pub const TSFX_SMITH53: C2RustUnnamed_34 = 232;
pub const TSFX_SMITH52: C2RustUnnamed_34 = 231;
pub const TSFX_SMITH51: C2RustUnnamed_34 = 230;
pub const TSFX_SMITH50: C2RustUnnamed_34 = 229;
pub const TSFX_SMITH49: C2RustUnnamed_34 = 228;
pub const TSFX_SMITH48: C2RustUnnamed_34 = 227;
pub const TSFX_SMITH47: C2RustUnnamed_34 = 226;
pub const TSFX_SMITH46: C2RustUnnamed_34 = 225;
pub const TSFX_SMITH45: C2RustUnnamed_34 = 224;
pub const TSFX_SMITH44: C2RustUnnamed_34 = 223;
pub const TSFX_SMITH43: C2RustUnnamed_34 = 222;
pub const TSFX_SMITH42: C2RustUnnamed_34 = 221;
pub const TSFX_SMITH41: C2RustUnnamed_34 = 220;
pub const TSFX_SMITH40: C2RustUnnamed_34 = 219;
pub const TSFX_SMITH39: C2RustUnnamed_34 = 218;
pub const TSFX_SMITH38: C2RustUnnamed_34 = 217;
pub const TSFX_SMITH37: C2RustUnnamed_34 = 216;
pub const TSFX_SMITH36: C2RustUnnamed_34 = 215;
pub const TSFX_SMITH35: C2RustUnnamed_34 = 214;
pub const TSFX_SMITH34: C2RustUnnamed_34 = 213;
pub const TSFX_SMITH33: C2RustUnnamed_34 = 212;
pub const TSFX_SMITH32: C2RustUnnamed_34 = 211;
pub const TSFX_SMITH31: C2RustUnnamed_34 = 210;
pub const TSFX_SMITH30: C2RustUnnamed_34 = 209;
pub const TSFX_SMITH29: C2RustUnnamed_34 = 208;
pub const TSFX_SMITH28: C2RustUnnamed_34 = 207;
pub const TSFX_SMITH27: C2RustUnnamed_34 = 206;
pub const TSFX_SMITH26: C2RustUnnamed_34 = 205;
pub const TSFX_SMITH25: C2RustUnnamed_34 = 204;
pub const TSFX_SMITH24: C2RustUnnamed_34 = 203;
pub const TSFX_SMITH23: C2RustUnnamed_34 = 202;
pub const TSFX_SMITH22: C2RustUnnamed_34 = 201;
pub const TSFX_SMITH21: C2RustUnnamed_34 = 200;
pub const TSFX_SMITH20: C2RustUnnamed_34 = 199;
pub const TSFX_SMITH19: C2RustUnnamed_34 = 198;
pub const TSFX_SMITH18: C2RustUnnamed_34 = 197;
pub const TSFX_SMITH17: C2RustUnnamed_34 = 196;
pub const TSFX_SMITH16: C2RustUnnamed_34 = 195;
pub const TSFX_SMITH15: C2RustUnnamed_34 = 194;
pub const TSFX_SMITH14: C2RustUnnamed_34 = 193;
pub const TSFX_SMITH13: C2RustUnnamed_34 = 192;
pub const TSFX_SMITH12: C2RustUnnamed_34 = 191;
pub const TSFX_SMITH11: C2RustUnnamed_34 = 190;
pub const TSFX_SMITH10: C2RustUnnamed_34 = 189;
pub const TSFX_SMITH9: C2RustUnnamed_34 = 188;
pub const TSFX_SMITH8: C2RustUnnamed_34 = 187;
pub const TSFX_SMITH7: C2RustUnnamed_34 = 186;
pub const TSFX_SMITH6: C2RustUnnamed_34 = 185;
pub const TSFX_SMITH5: C2RustUnnamed_34 = 184;
pub const TSFX_SMITH4: C2RustUnnamed_34 = 183;
pub const TSFX_SMITH3: C2RustUnnamed_34 = 182;
pub const TSFX_SMITH2: C2RustUnnamed_34 = 181;
pub const TSFX_SMITH1: C2RustUnnamed_34 = 180;
pub const TSFX_BMAID40: C2RustUnnamed_34 = 179;
pub const TSFX_BMAID39: C2RustUnnamed_34 = 178;
pub const TSFX_BMAID38: C2RustUnnamed_34 = 177;
pub const TSFX_BMAID37: C2RustUnnamed_34 = 176;
pub const TSFX_BMAID36: C2RustUnnamed_34 = 175;
pub const TSFX_BMAID35: C2RustUnnamed_34 = 174;
pub const TSFX_BMAID34: C2RustUnnamed_34 = 173;
pub const TSFX_BMAID33: C2RustUnnamed_34 = 172;
pub const TSFX_BMAID32: C2RustUnnamed_34 = 171;
pub const TSFX_BMAID31: C2RustUnnamed_34 = 170;
pub const TSFX_BMAID30: C2RustUnnamed_34 = 169;
pub const TSFX_BMAID29: C2RustUnnamed_34 = 168;
pub const TSFX_BMAID28: C2RustUnnamed_34 = 167;
pub const TSFX_BMAID27: C2RustUnnamed_34 = 166;
pub const TSFX_BMAID26: C2RustUnnamed_34 = 165;
pub const TSFX_BMAID25: C2RustUnnamed_34 = 164;
pub const TSFX_BMAID24: C2RustUnnamed_34 = 163;
pub const TSFX_BMAID23: C2RustUnnamed_34 = 162;
pub const TSFX_BMAID22: C2RustUnnamed_34 = 161;
pub const TSFX_BMAID21: C2RustUnnamed_34 = 160;
pub const TSFX_BMAID20: C2RustUnnamed_34 = 159;
pub const TSFX_BMAID19: C2RustUnnamed_34 = 158;
pub const TSFX_BMAID18: C2RustUnnamed_34 = 157;
pub const TSFX_BMAID17: C2RustUnnamed_34 = 156;
pub const TSFX_BMAID16: C2RustUnnamed_34 = 155;
pub const TSFX_BMAID15: C2RustUnnamed_34 = 154;
pub const TSFX_BMAID14: C2RustUnnamed_34 = 153;
pub const TSFX_BMAID13: C2RustUnnamed_34 = 152;
pub const TSFX_BMAID12: C2RustUnnamed_34 = 151;
pub const TSFX_BMAID11: C2RustUnnamed_34 = 150;
pub const TSFX_BMAID10: C2RustUnnamed_34 = 149;
pub const TSFX_BMAID9: C2RustUnnamed_34 = 148;
pub const TSFX_BMAID8: C2RustUnnamed_34 = 147;
pub const TSFX_BMAID7: C2RustUnnamed_34 = 146;
pub const TSFX_BMAID6: C2RustUnnamed_34 = 145;
pub const TSFX_BMAID5: C2RustUnnamed_34 = 144;
pub const TSFX_BMAID4: C2RustUnnamed_34 = 143;
pub const TSFX_BMAID3: C2RustUnnamed_34 = 142;
pub const TSFX_BMAID2: C2RustUnnamed_34 = 141;
pub const TSFX_BMAID1: C2RustUnnamed_34 = 140;
pub const LS_WALLSTRT: C2RustUnnamed_34 = 139;
pub const LS_WALLLOOP: C2RustUnnamed_34 = 138;
pub const LS_VTHEFT: C2RustUnnamed_34 = 137;
pub const LS_TELEPORT: C2RustUnnamed_34 = 136;
pub const LS_TRAPDIS: C2RustUnnamed_34 = 135;
pub const LS_STORM: C2RustUnnamed_34 = 134;
pub const LS_SPOUTSTR: C2RustUnnamed_34 = 133;
pub const LS_SPOUTLOP: C2RustUnnamed_34 = 132;
pub const LS_SOULFIRE: C2RustUnnamed_34 = 131;
pub const LS_SHATTER: C2RustUnnamed_34 = 130;
pub const LS_SENTINEL: C2RustUnnamed_34 = 129;
pub const LS_SCURIMP: C2RustUnnamed_34 = 128;
pub const LS_SCURSE: C2RustUnnamed_34 = 127;
pub const LS_RESUR: C2RustUnnamed_34 = 126;
pub const LS_PUDDLE: C2RustUnnamed_34 = 125;
pub const LS_PORTAL: C2RustUnnamed_34 = 124;
pub const LS_NOVA: C2RustUnnamed_34 = 123;
pub const LS_MSHIELD: C2RustUnnamed_34 = 122;
pub const LS_LTNING: C2RustUnnamed_34 = 121;
pub const LS_LNING1: C2RustUnnamed_34 = 120;
pub const LS_INVPOT: C2RustUnnamed_34 = 119;
pub const LS_INVISIBL: C2RustUnnamed_34 = 118;
pub const LS_INFRAVIS: C2RustUnnamed_34 = 117;
pub const LS_HYPER: C2RustUnnamed_34 = 116;
pub const LS_HOLYBOLT: C2RustUnnamed_34 = 115;
pub const LS_GUARDLAN: C2RustUnnamed_34 = 114;
pub const LS_GUARD: C2RustUnnamed_34 = 113;
pub const LS_GSHRINE: C2RustUnnamed_34 = 112;
pub const LS_GOLUMDED: C2RustUnnamed_34 = 111;
pub const LS_GOLUM: C2RustUnnamed_34 = 110;
pub const LS_FOUNTAIN: C2RustUnnamed_34 = 109;
pub const LS_FLASH: C2RustUnnamed_34 = 108;
pub const LS_FLAMWAVE: C2RustUnnamed_34 = 107;
pub const LS_FIRIMP2: C2RustUnnamed_34 = 106;
pub const LS_FIRIMP1: C2RustUnnamed_34 = 105;
pub const LS_FBOLT2: C2RustUnnamed_34 = 104;
pub const LS_FBOLT1: C2RustUnnamed_34 = 103;
pub const LS_FBALL: C2RustUnnamed_34 = 102;
pub const LS_ETHEREAL: C2RustUnnamed_34 = 101;
pub const LS_ELEMENTL: C2RustUnnamed_34 = 100;
pub const LS_ELECIMP1: C2RustUnnamed_34 = 99;
pub const LS_DSERP: C2RustUnnamed_34 = 98;
pub const LS_CHLTNING: C2RustUnnamed_34 = 97;
pub const LS_CBOLT: C2RustUnnamed_34 = 96;
pub const LS_CALDRON: C2RustUnnamed_34 = 95;
pub const LS_BSIMPCT: C2RustUnnamed_34 = 94;
pub const LS_BONESP: C2RustUnnamed_34 = 93;
pub const LS_BLSIMPT: C2RustUnnamed_34 = 92;
pub const LS_BLODSTAR: C2RustUnnamed_34 = 91;
pub const LS_BLODBOIL: C2RustUnnamed_34 = 90;
pub const LS_ARROWALL: C2RustUnnamed_34 = 89;
pub const LS_APOC: C2RustUnnamed_34 = 88;
pub const LS_ACIDS: C2RustUnnamed_34 = 87;
pub const LS_ACID: C2RustUnnamed_34 = 86;
pub const IS_REPAIR: C2RustUnnamed_34 = 85;
pub const LS_HEALING: C2RustUnnamed_34 = 84;
pub const IS_CAST9: C2RustUnnamed_34 = 83;
pub const IS_CAST8: C2RustUnnamed_34 = 82;
pub const IS_CAST7: C2RustUnnamed_34 = 81;
pub const IS_CAST6: C2RustUnnamed_34 = 80;
pub const IS_CAST5: C2RustUnnamed_34 = 79;
pub const IS_CAST4: C2RustUnnamed_34 = 78;
pub const IS_CAST3: C2RustUnnamed_34 = 77;
pub const IS_CAST2: C2RustUnnamed_34 = 76;
pub const IS_CAST12: C2RustUnnamed_34 = 75;
pub const IS_CAST10: C2RustUnnamed_34 = 74;
pub const IS_CAST1: C2RustUnnamed_34 = 73;
pub const IS_TRAP: C2RustUnnamed_34 = 72;
pub const SFX_SILENCE: C2RustUnnamed_34 = 71;
pub const IS_TITLSLCT: C2RustUnnamed_34 = 70;
pub const IS_TITLEMOV: C2RustUnnamed_34 = 69;
pub const IS_SWRDFKD: C2RustUnnamed_34 = 68;
pub const IS_SHLDFKD: C2RustUnnamed_34 = 67;
pub const IS_SARC: C2RustUnnamed_34 = 66;
pub const IS_RBOOK: C2RustUnnamed_34 = 65;
pub const IS_MAGIC1: C2RustUnnamed_34 = 64;
pub const IS_MAGIC: C2RustUnnamed_34 = 63;
pub const IS_LEVER: C2RustUnnamed_34 = 62;
pub const IS_ISWORD: C2RustUnnamed_34 = 61;
pub const IS_ISTAF: C2RustUnnamed_34 = 60;
pub const IS_ISIGN: C2RustUnnamed_34 = 59;
pub const IS_ISHIEL: C2RustUnnamed_34 = 58;
pub const IS_ISCROL: C2RustUnnamed_34 = 57;
pub const IS_IROCK: C2RustUnnamed_34 = 56;
pub const IS_IRING: C2RustUnnamed_34 = 55;
pub const IS_IPOT: C2RustUnnamed_34 = 54;
pub const IS_IMUSH: C2RustUnnamed_34 = 53;
pub const IS_ILARM: C2RustUnnamed_34 = 52;
pub const IS_IHARM: C2RustUnnamed_34 = 51;
pub const IS_IGRAB: C2RustUnnamed_34 = 50;
pub const IS_ICAP: C2RustUnnamed_34 = 49;
pub const IS_IBOW: C2RustUnnamed_34 = 48;
pub const IS_IBOOK: C2RustUnnamed_34 = 47;
pub const IS_IBODY: C2RustUnnamed_34 = 46;
pub const IS_IBLST: C2RustUnnamed_34 = 45;
pub const IS_IAXE: C2RustUnnamed_34 = 44;
pub const IS_IANVL: C2RustUnnamed_34 = 43;
pub const IS_HLMTFKD: C2RustUnnamed_34 = 42;
pub const IS_GOLD: C2RustUnnamed_34 = 41;
pub const IS_FSWOR: C2RustUnnamed_34 = 40;
pub const IS_FSTAF: C2RustUnnamed_34 = 39;
pub const IS_FSIGN: C2RustUnnamed_34 = 38;
pub const IS_FSHLD: C2RustUnnamed_34 = 37;
pub const IS_FSCRL: C2RustUnnamed_34 = 36;
pub const IS_FROCK: C2RustUnnamed_34 = 35;
pub const IS_FRING: C2RustUnnamed_34 = 34;
pub const IS_FPOT: C2RustUnnamed_34 = 33;
pub const IS_FMUSH: C2RustUnnamed_34 = 32;
pub const IS_FMAG1: C2RustUnnamed_34 = 31;
pub const IS_FMAG: C2RustUnnamed_34 = 30;
pub const IS_FLARM: C2RustUnnamed_34 = 29;
pub const IS_FHARM: C2RustUnnamed_34 = 28;
pub const IS_FCAP: C2RustUnnamed_34 = 27;
pub const IS_FBOW: C2RustUnnamed_34 = 26;
pub const IS_FBOOK: C2RustUnnamed_34 = 25;
pub const IS_FBODY: C2RustUnnamed_34 = 24;
pub const IS_FBLST: C2RustUnnamed_34 = 23;
pub const IS_FAXE: C2RustUnnamed_34 = 22;
pub const IS_FANVL: C2RustUnnamed_34 = 21;
pub const IS_DOOROPEN: C2RustUnnamed_34 = 20;
pub const IS_DOORCLOS: C2RustUnnamed_34 = 19;
pub const IS_CHEST: C2RustUnnamed_34 = 18;
pub const IS_BHIT1: C2RustUnnamed_34 = 17;
pub const IS_BHIT: C2RustUnnamed_34 = 16;
pub const IS_BARREL: C2RustUnnamed_34 = 15;
pub const IS_BARLFIRE: C2RustUnnamed_34 = 14;
pub const IS_ARMRFKD: C2RustUnnamed_34 = 13;
pub const IS_QUESTDN: C2RustUnnamed_34 = 12;
pub const PS_DEAD: C2RustUnnamed_34 = 11;
pub const PS_SWING2: C2RustUnnamed_34 = 10;
pub const PS_SWING: C2RustUnnamed_34 = 9;
pub const PS_LGHIT1: C2RustUnnamed_34 = 8;
pub const PS_LGHIT: C2RustUnnamed_34 = 7;
pub const PS_TMAG: C2RustUnnamed_34 = 6;
pub const PS_FMAG: C2RustUnnamed_34 = 5;
pub const PS_BFIRE: C2RustUnnamed_34 = 4;
pub const PS_WALK4: C2RustUnnamed_34 = 3;
pub const PS_WALK3: C2RustUnnamed_34 = 2;
pub const PS_WALK2: C2RustUnnamed_34 = 1;
pub const PS_WALK1: C2RustUnnamed_34 = 0;
pub type C2RustUnnamed_35 = libc::c_uint;
pub const ST_MISC: C2RustUnnamed_35 = 2;
pub const ST_LIGHT: C2RustUnnamed_35 = 1;
pub const ST_FIRE: C2RustUnnamed_35 = 0;
pub type C2RustUnnamed_36 = libc::c_uint;
pub const TXT_INTRO: C2RustUnnamed_36 = 258;
pub const TXT_BOOK33: C2RustUnnamed_36 = 257;
pub const TXT_BOOK32: C2RustUnnamed_36 = 256;
pub const TXT_BOOK31: C2RustUnnamed_36 = 255;
pub const TXT_BOOK23: C2RustUnnamed_36 = 254;
pub const TXT_BOOK22: C2RustUnnamed_36 = 253;
pub const TXT_BOOK21: C2RustUnnamed_36 = 252;
pub const TXT_BOOK13: C2RustUnnamed_36 = 251;
pub const TXT_BOOK12: C2RustUnnamed_36 = 250;
pub const TXT_BOOK11: C2RustUnnamed_36 = 249;
pub const TXT_COW2: C2RustUnnamed_36 = 248;
pub const TXT_COW1: C2RustUnnamed_36 = 247;
pub const TXT_ROGLORD: C2RustUnnamed_36 = 246;
pub const TXT_ROGBLIND: C2RustUnnamed_36 = 245;
pub const TXT_ROGBLOOD: C2RustUnnamed_36 = 244;
pub const TXT_ROGBONE: C2RustUnnamed_36 = 243;
pub const TXT_SORLORD: C2RustUnnamed_36 = 242;
pub const TXT_SORBLIND: C2RustUnnamed_36 = 241;
pub const TXT_SORBLOOD: C2RustUnnamed_36 = 240;
pub const TXT_SORBONE: C2RustUnnamed_36 = 239;
pub const TXT_WARLORD: C2RustUnnamed_36 = 238;
pub const TXT_WARBLIND: C2RustUnnamed_36 = 237;
pub const TXT_WARBLOOD: C2RustUnnamed_36 = 236;
pub const TXT_WARBONE: C2RustUnnamed_36 = 235;
pub const TXT_WIRT12: C2RustUnnamed_36 = 234;
pub const TXT_WIRT11: C2RustUnnamed_36 = 233;
pub const TXT_WIRT9: C2RustUnnamed_36 = 232;
pub const TXT_WIRT8: C2RustUnnamed_36 = 231;
pub const TXT_WIRT7: C2RustUnnamed_36 = 230;
pub const TXT_WIRT6: C2RustUnnamed_36 = 229;
pub const TXT_WIRT5: C2RustUnnamed_36 = 228;
pub const TXT_WIRT4: C2RustUnnamed_36 = 227;
pub const TXT_WIRT3: C2RustUnnamed_36 = 226;
pub const TXT_WIRT2: C2RustUnnamed_36 = 225;
pub const TXT_WIRT1: C2RustUnnamed_36 = 224;
pub const TXT_ADRIA13: C2RustUnnamed_36 = 223;
pub const TXT_ADRIA12: C2RustUnnamed_36 = 222;
pub const TXT_ADRIA10: C2RustUnnamed_36 = 221;
pub const TXT_ADRIA9: C2RustUnnamed_36 = 220;
pub const TXT_ADRIA8: C2RustUnnamed_36 = 219;
pub const TXT_ADRIA7: C2RustUnnamed_36 = 218;
pub const TXT_ADRIA6: C2RustUnnamed_36 = 217;
pub const TXT_ADRIA5: C2RustUnnamed_36 = 216;
pub const TXT_ADRIA4: C2RustUnnamed_36 = 215;
pub const TXT_ADRIA3: C2RustUnnamed_36 = 214;
pub const TXT_ADRIA2: C2RustUnnamed_36 = 213;
pub const TXT_ADRIA1: C2RustUnnamed_36 = 212;
pub const TXT_FARN13: C2RustUnnamed_36 = 211;
pub const TXT_FARN12: C2RustUnnamed_36 = 210;
pub const TXT_FARN11: C2RustUnnamed_36 = 209;
pub const TXT_FARN10: C2RustUnnamed_36 = 208;
pub const TXT_FARN9: C2RustUnnamed_36 = 207;
pub const TXT_FARN8: C2RustUnnamed_36 = 206;
pub const TXT_FARN6: C2RustUnnamed_36 = 205;
pub const TXT_FARN5: C2RustUnnamed_36 = 204;
pub const TXT_FARN4: C2RustUnnamed_36 = 203;
pub const TXT_FARN3: C2RustUnnamed_36 = 202;
pub const TXT_FARN2: C2RustUnnamed_36 = 201;
pub const TXT_FARN1: C2RustUnnamed_36 = 200;
pub const TXT_GRIS13: C2RustUnnamed_36 = 199;
pub const TXT_GRIS12: C2RustUnnamed_36 = 198;
pub const TXT_GRIS10: C2RustUnnamed_36 = 197;
pub const TXT_GRIS9: C2RustUnnamed_36 = 196;
pub const TXT_GRIS8: C2RustUnnamed_36 = 195;
pub const TXT_GRIS7: C2RustUnnamed_36 = 194;
pub const TXT_GRIS6: C2RustUnnamed_36 = 193;
pub const TXT_GRIS5: C2RustUnnamed_36 = 192;
pub const TXT_GRIS4: C2RustUnnamed_36 = 191;
pub const TXT_GRIS3: C2RustUnnamed_36 = 190;
pub const TXT_GRIS2: C2RustUnnamed_36 = 189;
pub const TXT_GRIS1: C2RustUnnamed_36 = 188;
pub const TXT_GILIAN10: C2RustUnnamed_36 = 187;
pub const TXT_GILIAN9: C2RustUnnamed_36 = 186;
pub const TXT_GILIAN7: C2RustUnnamed_36 = 185;
pub const TXT_GILIAN6: C2RustUnnamed_36 = 184;
pub const TXT_GILIAN5: C2RustUnnamed_36 = 183;
pub const TXT_GILIAN4: C2RustUnnamed_36 = 182;
pub const TXT_GILIAN3: C2RustUnnamed_36 = 181;
pub const TXT_GILIAN2: C2RustUnnamed_36 = 180;
pub const TXT_GILIAN1: C2RustUnnamed_36 = 179;
pub const TXT_PEPIN11: C2RustUnnamed_36 = 178;
pub const TXT_PEPIN10: C2RustUnnamed_36 = 177;
pub const TXT_PEPIN9: C2RustUnnamed_36 = 176;
pub const TXT_PEPIN7: C2RustUnnamed_36 = 175;
pub const TXT_PEPIN6: C2RustUnnamed_36 = 174;
pub const TXT_PEPIN5: C2RustUnnamed_36 = 173;
pub const TXT_PEPIN4: C2RustUnnamed_36 = 172;
pub const TXT_PEPIN3: C2RustUnnamed_36 = 171;
pub const TXT_PEPIN2: C2RustUnnamed_36 = 170;
pub const TXT_PEPIN1: C2RustUnnamed_36 = 169;
pub const TXT_OGDEN10: C2RustUnnamed_36 = 168;
pub const TXT_OGDEN9: C2RustUnnamed_36 = 167;
pub const TXT_OGDEN8: C2RustUnnamed_36 = 166;
pub const TXT_OGDEN6: C2RustUnnamed_36 = 165;
pub const TXT_OGDEN5: C2RustUnnamed_36 = 164;
pub const TXT_OGDEN4: C2RustUnnamed_36 = 163;
pub const TXT_OGDEN3: C2RustUnnamed_36 = 162;
pub const TXT_OGDEN2: C2RustUnnamed_36 = 161;
pub const TXT_OGDEN1: C2RustUnnamed_36 = 160;
pub const TXT_STORY11: C2RustUnnamed_36 = 159;
pub const TXT_STORY10: C2RustUnnamed_36 = 158;
pub const TXT_STORY9: C2RustUnnamed_36 = 157;
pub const TXT_STORY7: C2RustUnnamed_36 = 156;
pub const TXT_STORY6: C2RustUnnamed_36 = 155;
pub const TXT_STORY5: C2RustUnnamed_36 = 154;
pub const TXT_STORY4: C2RustUnnamed_36 = 153;
pub const TXT_STORY3: C2RustUnnamed_36 = 152;
pub const TXT_STORY2: C2RustUnnamed_36 = 151;
pub const TXT_STORY1: C2RustUnnamed_36 = 150;
pub const TXT_ZHAR2: C2RustUnnamed_36 = 149;
pub const TXT_ZHAR1: C2RustUnnamed_36 = 148;
pub const TXT_GARB4: C2RustUnnamed_36 = 147;
pub const TXT_GARB3: C2RustUnnamed_36 = 146;
pub const TXT_GARB2: C2RustUnnamed_36 = 145;
pub const TXT_GARB1: C2RustUnnamed_36 = 144;
pub const TXT_MODPB1: C2RustUnnamed_36 = 143;
pub const TXT_MODW1: C2RustUnnamed_36 = 142;
pub const TXT_MODTD1: C2RustUnnamed_36 = 141;
pub const TXT_MODBS1: C2RustUnnamed_36 = 140;
pub const TXT_MODBM1: C2RustUnnamed_36 = 139;
pub const TXT_MODH1: C2RustUnnamed_36 = 138;
pub const TXT_MODTO1: C2RustUnnamed_36 = 137;
pub const TXT_MODST3: C2RustUnnamed_36 = 136;
pub const TXT_MODST2: C2RustUnnamed_36 = 135;
pub const TXT_MODST1: C2RustUnnamed_36 = 134;
pub const TXT_BLKMPB1: C2RustUnnamed_36 = 133;
pub const TXT_BLKMW5: C2RustUnnamed_36 = 132;
pub const TXT_BLKMW4: C2RustUnnamed_36 = 131;
pub const TXT_BLKMW3: C2RustUnnamed_36 = 130;
pub const TXT_BLKMW2: C2RustUnnamed_36 = 129;
pub const TXT_BLKMW1: C2RustUnnamed_36 = 128;
pub const TXT_BLKMTD1: C2RustUnnamed_36 = 127;
pub const TXT_BLKMBS1: C2RustUnnamed_36 = 126;
pub const TXT_BLKMBM1: C2RustUnnamed_36 = 125;
pub const TXT_BLKMH2: C2RustUnnamed_36 = 124;
pub const TXT_BLKMH1: C2RustUnnamed_36 = 123;
pub const TXT_BLKMTO1: C2RustUnnamed_36 = 122;
pub const TXT_BLKMST1: C2RustUnnamed_36 = 121;
pub const TXT_INFRAPB1: C2RustUnnamed_36 = 120;
pub const TXT_INFRAW1: C2RustUnnamed_36 = 119;
pub const TXT_INFRATD1: C2RustUnnamed_36 = 118;
pub const TXT_INFRABS3: C2RustUnnamed_36 = 117;
pub const TXT_INFRABS2: C2RustUnnamed_36 = 116;
pub const TXT_INFRABS1: C2RustUnnamed_36 = 115;
pub const TXT_INFRABM1: C2RustUnnamed_36 = 114;
pub const TXT_INFRAH1: C2RustUnnamed_36 = 113;
pub const TXT_INFRATO1: C2RustUnnamed_36 = 112;
pub const TXT_INFRAST1: C2RustUnnamed_36 = 111;
pub const TXT_WARLRD1: C2RustUnnamed_36 = 110;
pub const TXT_WARLRDPB1: C2RustUnnamed_36 = 109;
pub const TXT_WARLRDW1: C2RustUnnamed_36 = 108;
pub const TXT_WARLRDTD1: C2RustUnnamed_36 = 107;
pub const TXT_WARLRDBS1: C2RustUnnamed_36 = 106;
pub const TXT_WARLRDBM1: C2RustUnnamed_36 = 105;
pub const TXT_WARLRDH1: C2RustUnnamed_36 = 104;
pub const TXT_WARLRDTO1: C2RustUnnamed_36 = 103;
pub const TXT_WARLRDST1: C2RustUnnamed_36 = 102;
pub const TXT_BLOODPB1: C2RustUnnamed_36 = 101;
pub const TXT_BLOODW1: C2RustUnnamed_36 = 100;
pub const TXT_BLOODTD1: C2RustUnnamed_36 = 99;
pub const TXT_BLOODBS1: C2RustUnnamed_36 = 98;
pub const TXT_BLOODBM1: C2RustUnnamed_36 = 97;
pub const TXT_BLOODH1: C2RustUnnamed_36 = 96;
pub const TXT_BLOODTO1: C2RustUnnamed_36 = 95;
pub const TXT_BLOODST1: C2RustUnnamed_36 = 94;
pub const TXT_ANVILPB1: C2RustUnnamed_36 = 93;
pub const TXT_ANVILW1: C2RustUnnamed_36 = 92;
pub const TXT_ANVILTD1: C2RustUnnamed_36 = 91;
pub const TXT_ANVILBS3: C2RustUnnamed_36 = 90;
pub const TXT_ANVILBS2: C2RustUnnamed_36 = 89;
pub const TXT_ANVILBS1: C2RustUnnamed_36 = 88;
pub const TXT_ANVILBM1: C2RustUnnamed_36 = 87;
pub const TXT_ANVILH1: C2RustUnnamed_36 = 86;
pub const TXT_ANVILTO1: C2RustUnnamed_36 = 85;
pub const TXT_ANVILST1: C2RustUnnamed_36 = 84;
pub const TXT_VEIL3: C2RustUnnamed_36 = 83;
pub const TXT_VEIL2: C2RustUnnamed_36 = 82;
pub const TXT_VEIL1: C2RustUnnamed_36 = 81;
pub const TXT_VEILPB1: C2RustUnnamed_36 = 80;
pub const TXT_VEILW1: C2RustUnnamed_36 = 79;
pub const TXT_VEILTD1: C2RustUnnamed_36 = 78;
pub const TXT_VEILBS1: C2RustUnnamed_36 = 77;
pub const TXT_VEILBM1: C2RustUnnamed_36 = 76;
pub const TXT_VEILH1: C2RustUnnamed_36 = 75;
pub const TXT_VEILTO1: C2RustUnnamed_36 = 74;
pub const TXT_VEILST1: C2RustUnnamed_36 = 73;
pub const TXT_BLINDPB1: C2RustUnnamed_36 = 72;
pub const TXT_BLINDW1: C2RustUnnamed_36 = 71;
pub const TXT_BLINDTD1: C2RustUnnamed_36 = 70;
pub const TXT_BLINDBS1: C2RustUnnamed_36 = 69;
pub const TXT_BLINDBM1: C2RustUnnamed_36 = 68;
pub const TXT_BLINDH1: C2RustUnnamed_36 = 67;
pub const TXT_BLINDTO1: C2RustUnnamed_36 = 66;
pub const TXT_BLINDST1: C2RustUnnamed_36 = 65;
pub const TXT_BUTCH2: C2RustUnnamed_36 = 64;
pub const TXT_BUTCH1: C2RustUnnamed_36 = 63;
pub const TXT_BUTCHPB1: C2RustUnnamed_36 = 62;
pub const TXT_BUTCHW1: C2RustUnnamed_36 = 61;
pub const TXT_BUTCHTD1: C2RustUnnamed_36 = 60;
pub const TXT_BUTCHBS1: C2RustUnnamed_36 = 59;
pub const TXT_BUTCHBM1: C2RustUnnamed_36 = 58;
pub const TXT_BUTCHH1: C2RustUnnamed_36 = 57;
pub const TXT_BUTCHTO1: C2RustUnnamed_36 = 56;
pub const TXT_BUTCHST1: C2RustUnnamed_36 = 55;
pub const TXT_BONEPB1: C2RustUnnamed_36 = 54;
pub const TXT_BONEW1: C2RustUnnamed_36 = 53;
pub const TXT_BONETD1: C2RustUnnamed_36 = 52;
pub const TXT_BONEBS1: C2RustUnnamed_36 = 51;
pub const TXT_BONEBM1: C2RustUnnamed_36 = 50;
pub const TXT_BONEH1: C2RustUnnamed_36 = 49;
pub const TXT_BONETO1: C2RustUnnamed_36 = 48;
pub const TXT_BONEST1: C2RustUnnamed_36 = 47;
pub const TXT_PWPB1: C2RustUnnamed_36 = 46;
pub const TXT_PWW1: C2RustUnnamed_36 = 45;
pub const TXT_PWTD1: C2RustUnnamed_36 = 44;
pub const TXT_PWBS1: C2RustUnnamed_36 = 43;
pub const TXT_PWBM1: C2RustUnnamed_36 = 42;
pub const TXT_PWH3: C2RustUnnamed_36 = 41;
pub const TXT_PWH2: C2RustUnnamed_36 = 40;
pub const TXT_PWH1: C2RustUnnamed_36 = 39;
pub const TXT_PWTO1: C2RustUnnamed_36 = 38;
pub const TXT_PWST1: C2RustUnnamed_36 = 37;
pub const TXT_VB2: C2RustUnnamed_36 = 36;
pub const TXT_VB1: C2RustUnnamed_36 = 35;
pub const TXT_VBPB1: C2RustUnnamed_36 = 34;
pub const TXT_VBW1: C2RustUnnamed_36 = 33;
pub const TXT_VBTD1: C2RustUnnamed_36 = 32;
pub const TXT_VBBS1: C2RustUnnamed_36 = 31;
pub const TXT_VBBM1: C2RustUnnamed_36 = 30;
pub const TXT_VBH1: C2RustUnnamed_36 = 29;
pub const TXT_VBP4: C2RustUnnamed_36 = 28;
pub const TXT_VBP3: C2RustUnnamed_36 = 27;
pub const TXT_VBTO1: C2RustUnnamed_36 = 26;
pub const TXT_VBST3: C2RustUnnamed_36 = 25;
pub const TXT_VBST2: C2RustUnnamed_36 = 24;
pub const TXT_VBST1: C2RustUnnamed_36 = 23;
pub const TXT_BOL3: C2RustUnnamed_36 = 22;
pub const TXT_BOL2: C2RustUnnamed_36 = 21;
pub const TXT_BOL1: C2RustUnnamed_36 = 20;
pub const TXT_BOLPB1: C2RustUnnamed_36 = 19;
pub const TXT_BOLW1: C2RustUnnamed_36 = 18;
pub const TXT_BOLTD1: C2RustUnnamed_36 = 17;
pub const TXT_BOLBS1: C2RustUnnamed_36 = 16;
pub const TXT_BOLBM1: C2RustUnnamed_36 = 15;
pub const TXT_BOLH1: C2RustUnnamed_36 = 14;
pub const TXT_BOLTO2: C2RustUnnamed_36 = 13;
pub const TXT_BOLTO1: C2RustUnnamed_36 = 12;
pub const TXT_BOLST1: C2RustUnnamed_36 = 11;
pub const TXT_KING1: C2RustUnnamed_36 = 10;
pub const TXT_KINGPB1: C2RustUnnamed_36 = 9;
pub const TXT_KINGW1: C2RustUnnamed_36 = 8;
pub const TXT_KINGTD1: C2RustUnnamed_36 = 7;
pub const TXT_KINGBS1: C2RustUnnamed_36 = 6;
pub const TXT_KINGBM1: C2RustUnnamed_36 = 5;
pub const TXT_KINGH1: C2RustUnnamed_36 = 4;
pub const TXT_KINGTO3: C2RustUnnamed_36 = 3;
pub const TXT_KINGTO2: C2RustUnnamed_36 = 2;
pub const TXT_KINGTO1: C2RustUnnamed_36 = 1;
pub const TXT_KINGST1: C2RustUnnamed_36 = 0;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
pub type C2RustUnnamed_37 = libc::c_uint;
pub const INITMONSTRAD: C2RustUnnamed_37 = 15;
pub const MAX_MS: C2RustUnnamed_37 = 4;
pub const IMG_MAX: C2RustUnnamed_37 = 4000;
pub const MAX_ANIMTYPE: C2RustUnnamed_37 = 6;
pub const MONSTDENSITY: C2RustUnnamed_37 = 30;
pub const MAX_LVLMTYPES: C2RustUnnamed_37 = 16;
pub const MONSTERTYPES: C2RustUnnamed_37 = 200;
pub const MAXMONSTERS: C2RustUnnamed_37 = 200;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterStruct {
    pub _mMTidx: libc::c_int,
    pub _mmode: libc::c_int,
    pub _mgoal: uint8_t,
    pub _mgoalvar1: libc::c_int,
    pub _mgoalvar2: libc::c_int,
    pub _mgoalvar3: libc::c_int,
    pub _mgoalvar4: libc::c_int,
    pub _pathcount: uint8_t,
    pub _mx: libc::c_int,
    pub _my: libc::c_int,
    pub _mfutx: libc::c_int,
    pub _mfuty: libc::c_int,
    pub _moldx: libc::c_int,
    pub _moldy: libc::c_int,
    pub _mxoff: int32_t,
    pub _myoff: int32_t,
    pub _mxvel: int32_t,
    pub _myvel: int32_t,
    pub _mdir: libc::c_int,
    pub _menemy: libc::c_int,
    pub _menemyx: uint8_t,
    pub _menemyy: uint8_t,
    pub _mAnimData: *mut uint8_t,
    pub _mAnimDelay: libc::c_int,
    pub _mAnimCnt: libc::c_int,
    pub _mAnimLen: libc::c_int,
    pub _mAnimFrame: libc::c_int,
    pub _meflag: libc::c_int,
    pub _mDelFlag: bool32_t,
    pub _mVar1: int32_t,
    pub _mVar2: int32_t,
    pub _mVar3: int32_t,
    pub _mVar4: int32_t,
    pub _mVar5: int32_t,
    pub _mVar6: int32_t,
    pub _mVar7: int32_t,
    pub _mVar8: int32_t,
    pub _mmaxhp: int32_t,
    pub _mhitpoints: int32_t,
    pub _mAi: uint8_t,
    pub _mint: uint8_t,
    pub _mFlags: uint32_t,
    pub _msquelch: uint8_t,
    pub _mAFNum: libc::c_int,
    pub _lastx: libc::c_int,
    pub _lasty: libc::c_int,
    pub _mRndSeed: libc::c_int,
    pub _mAISeed: libc::c_int,
    pub _Wandering: bool32_t,
    pub _uniqtype: uint8_t,
    pub _uniqtrans: uint8_t,
    pub _udeadval: int8_t,
    pub mWhoHit: int8_t,
    pub mLevel: int8_t,
    pub mExp: uint16_t,
    pub mHit: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMagicRes: uint16_t,
    pub mtalkmsg: libc::c_int,
    pub leader: uint8_t,
    pub leaderflag: uint8_t,
    pub packsize: uint8_t,
    pub mlid: uint8_t,
    pub mName: *const libc::c_char,
    pub MType: *mut CMonster,
    pub MData: *mut MonsterData,
}
pub type CHECKFUNC1 = Option::<
    unsafe extern "C" fn(libc::c_int, libc::c_int, libc::c_int) -> bool32_t,
>;
pub type C2RustUnnamed_38 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_38 = 32;
pub const MAXMICRO: C2RustUnnamed_38 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_38 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_38 = 64;
pub const MAXMREND: C2RustUnnamed_38 = 128;
pub const MAXTILES: C2RustUnnamed_38 = 2048;
pub const MDMAXY: C2RustUnnamed_38 = 40;
pub const MDMAXX: C2RustUnnamed_38 = 40;
pub const MAXDUNY: C2RustUnnamed_38 = 112;
pub const MAXDUNX: C2RustUnnamed_38 = 112;
pub const DMAXY: C2RustUnnamed_38 = 112;
pub const DMAXX: C2RustUnnamed_38 = 112;
pub const DIRTEDGED2: C2RustUnnamed_38 = 16;
pub const DIRTEDGE: C2RustUnnamed_38 = 32;
pub const NUMSLEVELS: C2RustUnnamed_38 = 10;
pub const NUMLEVELS: C2RustUnnamed_38 = 17;
pub const LVL4_START: C2RustUnnamed_38 = 13;
pub const LVL3_START: C2RustUnnamed_38 = 9;
pub const LVL2_START: C2RustUnnamed_38 = 5;
pub const LVL1_START: C2RustUnnamed_38 = 1;
pub const TLVL_START: C2RustUnnamed_38 = 0;
pub const LVLLENGTH: C2RustUnnamed_38 = 4;
pub type C2RustUnnamed_39 = libc::c_int;
pub const ITEMFTYPES: C2RustUnnamed_39 = 35;
pub const RESIST_MAX: C2RustUnnamed_39 = 75;
pub const GOLD_VMAX: C2RustUnnamed_39 = 5000;
pub const GOLD_VT2: C2RustUnnamed_39 = 2500;
pub const GOLD_VT1: C2RustUnnamed_39 = 1000;
pub const INFINITE_DUR: C2RustUnnamed_39 = 255;
pub const ITEM_RND: C2RustUnnamed_39 = -1;
pub const TEMPAVAIL: C2RustUnnamed_39 = 127;
pub const MAXUITEMS: C2RustUnnamed_39 = 128;
pub const MAXITEMS: C2RustUnnamed_39 = 127;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
pub type HSFILE = *mut C2RustUnnamed_40;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_40 {
    pub unused: libc::c_int,
}
pub const MAX_PLRS: C2RustUnnamed_47 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ScrollStruct {
    pub _sxoff: libc::c_int,
    pub _syoff: libc::c_int,
    pub _sdx: libc::c_int,
    pub _sdy: libc::c_int,
    pub _sdir: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ObjectStruct {
    pub _otype: libc::c_int,
    pub _ox: libc::c_int,
    pub _oy: libc::c_int,
    pub _oLight: bool32_t,
    pub _oAnimFlag: bool32_t,
    pub _oAnimData: *mut uint8_t,
    pub _oAnimDelay: libc::c_int,
    pub _oAnimCnt: libc::c_int,
    pub _oAnimLen: libc::c_int,
    pub _oAnimFrame: libc::c_int,
    pub _oAnimWidth: int32_t,
    pub _oAnimWidth2: int32_t,
    pub _oDelFlag: bool32_t,
    pub _oBreak: int8_t,
    pub _oSolidFlag: bool32_t,
    pub _oMissFlag: bool32_t,
    pub _oSelFlag: int8_t,
    pub _oPreFlag: bool32_t,
    pub _oTrapFlag: bool32_t,
    pub _oDoorFlag: bool32_t,
    pub _olid: libc::c_int,
    pub _oRndSeed: libc::c_int,
    pub _oVar1: int32_t,
    pub _oVar2: int32_t,
    pub _oVar3: int32_t,
    pub _oVar4: int32_t,
    pub _oVar5: int32_t,
    pub _oVar6: int32_t,
    pub _oVar7: int32_t,
    pub _oVar8: int32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SpellData {
    pub sName: uint8_t,
    pub sManaCost: uint8_t,
    pub sType: uint8_t,
    pub sNameText: *const libc::c_char,
    pub sSkillText: *const libc::c_char,
    pub sBookLvl: libc::c_int,
    pub sStaffLvl: libc::c_int,
    pub sTargeted: bool32_t,
    pub sTownSpell: bool32_t,
    pub sMinInt: libc::c_int,
    pub sSFX: uint8_t,
    pub sMissiles: [uint8_t; 3],
    pub sManaAdj: uint8_t,
    pub sMinMana: uint8_t,
    pub sStaffMin: libc::c_int,
    pub sStaffMax: libc::c_int,
    pub sBookCost: libc::c_int,
    pub sStaffCost: libc::c_int,
}
pub const IDI_EAR: C2RustUnnamed_44 = 23;
pub const ITEM_EAR3: C2RustUnnamed_43 = 21;
pub const ITEM_EAR2: C2RustUnnamed_43 = 20;
pub const ITEM_EAR1: C2RustUnnamed_43 = 19;
pub const IDI_GOLD: C2RustUnnamed_44 = 0;
pub const IT_GOLD: C2RustUnnamed_45 = 11;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MissileStruct {
    pub _mitype: libc::c_int,
    pub _mix: libc::c_int,
    pub _miy: libc::c_int,
    pub _mixoff: int32_t,
    pub _miyoff: int32_t,
    pub _mixvel: int32_t,
    pub _miyvel: int32_t,
    pub _misx: libc::c_int,
    pub _misy: libc::c_int,
    pub _mitxoff: int32_t,
    pub _mityoff: int32_t,
    pub _mimfnum: libc::c_int,
    pub _mispllvl: libc::c_int,
    pub _miDelFlag: bool32_t,
    pub _miAnimType: uint8_t,
    pub _miAnimFlags: bool32_t,
    pub _miAnimData: *mut uint8_t,
    pub _miAnimDelay: libc::c_int,
    pub _miAnimLen: libc::c_int,
    pub _miAnimWidth: int32_t,
    pub _miAnimWidth2: int32_t,
    pub _miAnimCnt: libc::c_int,
    pub _miAnimAdd: libc::c_int,
    pub _miAnimFrame: libc::c_int,
    pub _miDrawFlag: bool32_t,
    pub _miLightFlag: bool32_t,
    pub _miPreFlag: bool32_t,
    pub _miUniqTrans: bool32_t,
    pub _mirange: libc::c_int,
    pub _misource: libc::c_int,
    pub _micaster: libc::c_int,
    pub _midam: libc::c_int,
    pub _miHitFlag: bool32_t,
    pub _midist: libc::c_int,
    pub _mlid: libc::c_int,
    pub _mirnd: libc::c_int,
    pub _miVar1: int32_t,
    pub _miVar2: int32_t,
    pub _miVar3: int32_t,
    pub _miVar4: int32_t,
    pub _miVar5: int32_t,
    pub _miVar6: int32_t,
    pub _miVar7: int32_t,
    pub _miVar8: int32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct LightListStruct {
    pub _lx: libc::c_int,
    pub _ly: libc::c_int,
    pub _lradius: libc::c_int,
    pub _lid: libc::c_int,
    pub _ldel: bool32_t,
    pub _lunflag: bool32_t,
    pub _lneg: bool32_t,
    pub _lunx: libc::c_int,
    pub _luny: libc::c_int,
    pub _lunr: libc::c_int,
    pub _xoff: libc::c_int,
    pub _yoff: libc::c_int,
    pub _lflags: bool32_t,
}
pub const IAF_HTANIM3: C2RustUnnamed_41 = 8388608;
pub const IAF_HTANIM2: C2RustUnnamed_41 = 4194304;
pub const IAF_HTANIM1: C2RustUnnamed_41 = 2097152;
pub const IT_SHIELD: C2RustUnnamed_45 = 5;
pub const IAF_BLANIM: C2RustUnnamed_41 = 16777216;
pub const IC_WEAP: C2RustUnnamed_42 = 1;
pub const IAF_LARROW: C2RustUnnamed_41 = 33554432;
pub const IAF_FIREARROW: C2RustUnnamed_41 = 8;
pub const IAF_ATANIM2: C2RustUnnamed_41 = 262144;
pub const IAF_ATANIM1: C2RustUnnamed_41 = 131072;
pub const IAF_SKING: C2RustUnnamed_41 = 2;
pub const IAF_KNOCKBACK: C2RustUnnamed_41 = 2048;
pub const IAF_NOHEAL: C2RustUnnamed_41 = 256;
pub const IAF_LEECH20: C2RustUnnamed_41 = 65536;
pub const IAF_LEECH10: C2RustUnnamed_41 = 32768;
pub const IAF_ALLLEECH: C2RustUnnamed_41 = 98304;
pub const IAF_BAT20: C2RustUnnamed_41 = 16384;
pub const IAF_BAT10: C2RustUnnamed_41 = 8192;
pub const IAF_LMANA: C2RustUnnamed_41 = 134217728;
pub const IAF_ALLBAT: C2RustUnnamed_41 = 24576;
pub const IAF_DAMDEMON: C2RustUnnamed_41 = 1073741824;
pub const IT_SWORD: C2RustUnnamed_45 = 1;
pub const IT_MACE: C2RustUnnamed_45 = 4;
pub const IAF_LIGHTHIT: C2RustUnnamed_41 = 32;
pub const IAF_FIREHIT: C2RustUnnamed_41 = 16;
pub const IAF_ATANIM4: C2RustUnnamed_41 = 1048576;
pub const IAF_ATANIM3: C2RustUnnamed_41 = 524288;
pub const IAF_CONSTRICT: C2RustUnnamed_41 = 64;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PortalStruct {
    pub open: bool32_t,
    pub x: libc::c_int,
    pub y: libc::c_int,
    pub level: libc::c_int,
    pub ltype: libc::c_int,
    pub setlvl: bool32_t,
}
pub const PLRLRAD: C2RustUnnamed_46 = 10;
pub type C2RustUnnamed_41 = libc::c_uint;
pub const IAF_ZERORES: C2RustUnnamed_41 = 2147483648;
pub const IAF_OMEHAND: C2RustUnnamed_41 = 536870912;
pub const IAF_TRAPDAM: C2RustUnnamed_41 = 268435456;
pub const IAF_THORN: C2RustUnnamed_41 = 67108864;
pub const IAF_ALLHTANIM: C2RustUnnamed_41 = 14680064;
pub const IAF_ALLATANIM: C2RustUnnamed_41 = 1966080;
pub const IAF_MNOHEAL: C2RustUnnamed_41 = 4096;
pub const IAF_HALFTRAP: C2RustUnnamed_41 = 1024;
pub const IAF_RABID: C2RustUnnamed_41 = 512;
pub const IAF_NOMANA: C2RustUnnamed_41 = 128;
pub const IAF_RNDARROW: C2RustUnnamed_41 = 4;
pub const IAF_INFRAVISION: C2RustUnnamed_41 = 1;
pub type C2RustUnnamed_42 = libc::c_uint;
pub const IC_SPECIAL: C2RustUnnamed_42 = 5;
pub const IC_GOLD: C2RustUnnamed_42 = 4;
pub const IC_ITEM: C2RustUnnamed_42 = 3;
pub const IC_ARMOR: C2RustUnnamed_42 = 2;
pub type C2RustUnnamed_43 = libc::c_uint;
pub const ITEM_GOLD: C2RustUnnamed_43 = 168;
pub const ITEM_SBATLBOW: C2RustUnnamed_43 = 167;
pub const ITEM_COMPSTF: C2RustUnnamed_43 = 166;
pub const ITEM_SWARBOW: C2RustUnnamed_43 = 165;
pub const ITEM_WINDFOR: C2RustUnnamed_43 = 164;
pub const ITEM_REAVER: C2RustUnnamed_43 = 163;
pub const ITEM_PROTECT: C2RustUnnamed_43 = 162;
pub const ITEM_GRANDPA: C2RustUnnamed_43 = 161;
pub const ITEM_GRIZZLY: C2RustUnnamed_43 = 160;
pub const ITEM_NAJARMOR: C2RustUnnamed_43 = 159;
pub const ITEM_CROSBOW: C2RustUnnamed_43 = 158;
pub const ITEM_ARKARMOR: C2RustUnnamed_43 = 157;
pub const ITEM_GEMGRTAXE: C2RustUnnamed_43 = 156;
pub const ITEM_BISHOPSTF: C2RustUnnamed_43 = 155;
pub const ITEM_RINGMAIL: C2RustUnnamed_43 = 154;
pub const ITEM_BPLATE: C2RustUnnamed_43 = 153;
pub const ITEM_PARMOR3: C2RustUnnamed_43 = 152;
pub const ITEM_PARMOR2: C2RustUnnamed_43 = 151;
pub const ITEM_CAPE: C2RustUnnamed_43 = 150;
pub const ITEM_CLOAK: C2RustUnnamed_43 = 149;
pub const ITEM_LRGSHLD: C2RustUnnamed_43 = 148;
pub const ITEM_KITESHLD: C2RustUnnamed_43 = 147;
pub const ITEM_IRONSHLD: C2RustUnnamed_43 = 146;
pub const ITEM_GREATAXE: C2RustUnnamed_43 = 145;
pub const ITEM_HANDAXE: C2RustUnnamed_43 = 144;
pub const ITEM_WICKAXE: C2RustUnnamed_43 = 143;
pub const ITEM_LRGAXE: C2RustUnnamed_43 = 142;
pub const ITEM_BROADAXE: C2RustUnnamed_43 = 141;
pub const ITEM_ANVIL: C2RustUnnamed_43 = 140;
pub const ITEM_RINGARMOR: C2RustUnnamed_43 = 139;
pub const ITEM_HVYROBE: C2RustUnnamed_43 = 138;
pub const ITEM_ROBE: C2RustUnnamed_43 = 137;
pub const ITEM_SPLTARMOR: C2RustUnnamed_43 = 136;
pub const ITEM_LARMOR: C2RustUnnamed_43 = 135;
pub const ITEM_GRTSWORD: C2RustUnnamed_43 = 134;
pub const ITEM_HNTRBOW: C2RustUnnamed_43 = 133;
pub const ITEM_TSHIELD: C2RustUnnamed_43 = 132;
pub const ITEM_FLAIL: C2RustUnnamed_43 = 131;
pub const ITEM_BALLNCHN: C2RustUnnamed_43 = 130;
pub const ITEM_QARMOR: C2RustUnnamed_43 = 129;
pub const ITEM_RAGS: C2RustUnnamed_43 = 128;
pub const ITEM_HLARMOR: C2RustUnnamed_43 = 127;
pub const ITEM_INNSIGN: C2RustUnnamed_43 = 126;
pub const ITEM_LONGSTAFF: C2RustUnnamed_43 = 125;
pub const ITEM_STLSTAFF: C2RustUnnamed_43 = 124;
pub const ITEM_IRONSTAFF: C2RustUnnamed_43 = 123;
pub const ITEM_MAUL: C2RustUnnamed_43 = 122;
pub const ITEM_SMLWARHAM: C2RustUnnamed_43 = 121;
pub const ITEM_STLSHRTBOW: C2RustUnnamed_43 = 120;
pub const ITEM_STLLONGBOW: C2RustUnnamed_43 = 119;
pub const ITEM_SHORTBOW: C2RustUnnamed_43 = 118;
pub const ITEM_WOLFSHLD: C2RustUnnamed_43 = 117;
pub const ITEM_SKULLSHLD: C2RustUnnamed_43 = 116;
pub const ITEM_SMLSHLD: C2RustUnnamed_43 = 115;
pub const ITEM_SCLARMOR: C2RustUnnamed_43 = 114;
pub const ITEM_HVYSHIELD: C2RustUnnamed_43 = 113;
pub const ITEM_SMALLAXE: C2RustUnnamed_43 = 112;
pub const ITEM_CHARMOR: C2RustUnnamed_43 = 111;
pub const ITEM_2HSWORD: C2RustUnnamed_43 = 110;
pub const ITEM_SHRTSTAFF: C2RustUnnamed_43 = 109;
pub const ITEM_COMPBOW: C2RustUnnamed_43 = 108;
pub const ITEM_STDARMOR: C2RustUnnamed_43 = 107;
pub const ITEM_CLEAVER: C2RustUnnamed_43 = 106;
pub const ITEM_WSHIELD: C2RustUnnamed_43 = 105;
pub const ITEM_AXE: C2RustUnnamed_43 = 104;
pub const ITEM_PARMOR: C2RustUnnamed_43 = 103;
pub const ITEM_LONGBOW: C2RustUnnamed_43 = 102;
pub const ITEM_BTLAXE: C2RustUnnamed_43 = 101;
pub const ITEM_COMPSHLD: C2RustUnnamed_43 = 100;
pub const ITEM_SAMHELM: C2RustUnnamed_43 = 99;
pub const ITEM_FHELM3: C2RustUnnamed_43 = 98;
pub const ITEM_BOOK4: C2RustUnnamed_43 = 97;
pub const ITEM_MAP: C2RustUnnamed_43 = 96;
pub const ITEM_CROWN2: C2RustUnnamed_43 = 95;
pub const ITEM_CLOTHES: C2RustUnnamed_43 = 94;
pub const ITEM_SKLCAP2: C2RustUnnamed_43 = 93;
pub const ITEM_FLESH: C2RustUnnamed_43 = 92;
pub const ITEM_LCAP: C2RustUnnamed_43 = 91;
pub const ITEM_SKLCAP: C2RustUnnamed_43 = 90;
pub const ITEM_MUSHROOM: C2RustUnnamed_43 = 89;
pub const ITEM_BOOK: C2RustUnnamed_43 = 88;
pub const ITEM_BOOK3: C2RustUnnamed_43 = 87;
pub const ITEM_BOOK2: C2RustUnnamed_43 = 86;
pub const ITEM_GRTHELM: C2RustUnnamed_43 = 85;
pub const ITEM_FHELM2: C2RustUnnamed_43 = 84;
pub const ITEM_BUCKLER: C2RustUnnamed_43 = 83;
pub const ITEM_FHELM: C2RustUnnamed_43 = 82;
pub const ITEM_HARLEQ: C2RustUnnamed_43 = 81;
pub const ITEM_JESTER: C2RustUnnamed_43 = 80;
pub const ITEM_MCROWN: C2RustUnnamed_43 = 79;
pub const ITEM_SKCROWN: C2RustUnnamed_43 = 78;
pub const ITEM_CROWN: C2RustUnnamed_43 = 77;
pub const ITEM_ROCK: C2RustUnnamed_43 = 76;
pub const ITEM_HELM: C2RustUnnamed_43 = 75;
pub const ITEM_SKULSWORD: C2RustUnnamed_43 = 74;
pub const ITEM_MAGSWORD: C2RustUnnamed_43 = 73;
pub const ITEM_SCIMITAR2: C2RustUnnamed_43 = 72;
pub const ITEM_CLUB3: C2RustUnnamed_43 = 71;
pub const ITEM_CLUB2: C2RustUnnamed_43 = 70;
pub const ITEM_CLUB1: C2RustUnnamed_43 = 69;
pub const ITEM_KNTSWORD: C2RustUnnamed_43 = 68;
pub const ITEM_SABRE: C2RustUnnamed_43 = 67;
pub const ITEM_CLUB: C2RustUnnamed_43 = 66;
pub const ITEM_CLAYMORE: C2RustUnnamed_43 = 65;
pub const ITEM_SHORTSRD: C2RustUnnamed_43 = 64;
pub const ITEM_MORNSTAR: C2RustUnnamed_43 = 63;
pub const ITEM_SCIMITAR: C2RustUnnamed_43 = 62;
pub const ITEM_BROADSRD: C2RustUnnamed_43 = 61;
pub const ITEM_LONGSRD: C2RustUnnamed_43 = 60;
pub const ITEM_MACE: C2RustUnnamed_43 = 59;
pub const ITEM_FALCHION: C2RustUnnamed_43 = 58;
pub const ITEM_BASTSRD: C2RustUnnamed_43 = 57;
pub const ITEM_BLADE: C2RustUnnamed_43 = 56;
pub const ITEM_DAGGER5: C2RustUnnamed_43 = 55;
pub const ITEM_DAGGER4: C2RustUnnamed_43 = 54;
pub const ITEM_DAGGER3: C2RustUnnamed_43 = 53;
pub const ITEM_BIGBOTTLE: C2RustUnnamed_43 = 52;
pub const ITEM_DAGGER2: C2RustUnnamed_43 = 51;
pub const ITEM_DAGGER1: C2RustUnnamed_43 = 50;
pub const ITEM_POUCH1: C2RustUnnamed_43 = 49;
pub const ITEM_AMULET4: C2RustUnnamed_43 = 48;
pub const ITEM_AMULET3: C2RustUnnamed_43 = 47;
pub const ITEM_AMULET2: C2RustUnnamed_43 = 46;
pub const ITEM_AMULET1: C2RustUnnamed_43 = 45;
pub const ITEM_AMULET: C2RustUnnamed_43 = 44;
pub const ITEM_BREAD: C2RustUnnamed_43 = 43;
pub const ITEM_FANG: C2RustUnnamed_43 = 42;
pub const ITEM_CLAW: C2RustUnnamed_43 = 41;
pub const ITEM_BRAIN: C2RustUnnamed_43 = 40;
pub const ITEM_BLUEBTL2: C2RustUnnamed_43 = 39;
pub const ITEM_LTBLUEBTL: C2RustUnnamed_43 = 38;
pub const ITEM_GOLDBTL: C2RustUnnamed_43 = 37;
pub const ITEM_BLKBTL2: C2RustUnnamed_43 = 36;
pub const ITEM_BREDBTL: C2RustUnnamed_43 = 35;
pub const ITEM_ORGBTL: C2RustUnnamed_43 = 34;
pub const ITEM_YELBTL: C2RustUnnamed_43 = 33;
pub const ITEM_REDBTL: C2RustUnnamed_43 = 32;
pub const ITEM_WHTEBTL: C2RustUnnamed_43 = 31;
pub const ITEM_BLKBTL: C2RustUnnamed_43 = 30;
pub const ITEM_VILE: C2RustUnnamed_43 = 29;
pub const ITEM_JPYRIMID: C2RustUnnamed_43 = 28;
pub const ITEM_JCUBE: C2RustUnnamed_43 = 27;
pub const ITEM_JSPHERE: C2RustUnnamed_43 = 26;
pub const ITEM_BLOODGEM: C2RustUnnamed_43 = 25;
pub const ITEM_PYRIMID: C2RustUnnamed_43 = 24;
pub const ITEM_CUBE: C2RustUnnamed_43 = 23;
pub const ITEM_SPHERE: C2RustUnnamed_43 = 22;
pub const ITEM_EMPYBAND: C2RustUnnamed_43 = 18;
pub const ITEM_GOLDENELIX: C2RustUnnamed_43 = 17;
pub const ITEM_3COLORPOT: C2RustUnnamed_43 = 16;
pub const ITEM_SPECTRAL: C2RustUnnamed_43 = 15;
pub const ITEM_BRNRING: C2RustUnnamed_43 = 14;
pub const ITEM_MJRING: C2RustUnnamed_43 = 13;
pub const ITEM_SLVRRING: C2RustUnnamed_43 = 12;
pub const ITEM_3JRING: C2RustUnnamed_43 = 11;
pub const ITEM_BLUERING: C2RustUnnamed_43 = 10;
pub const ITEM_WOODRING: C2RustUnnamed_43 = 9;
pub const ITEM_1JRING: C2RustUnnamed_43 = 8;
pub const ITEM_GOLDRING: C2RustUnnamed_43 = 7;
pub const ITEM_5GOLD: C2RustUnnamed_43 = 6;
pub const ITEM_3GOLD: C2RustUnnamed_43 = 5;
pub const ITEM_1GOLD: C2RustUnnamed_43 = 4;
pub const ITEM_SCROLL3: C2RustUnnamed_43 = 3;
pub const ITEM_SCROLL2: C2RustUnnamed_43 = 2;
pub const ITEM_SCROLL: C2RustUnnamed_43 = 1;
pub const ITEM_BLUEBTL: C2RustUnnamed_43 = 0;
pub type C2RustUnnamed_44 = libc::c_uint;
pub const IDI_LASTQUEST: C2RustUnnamed_44 = 22;
pub const IDI_FIRSTQUEST: C2RustUnnamed_44 = 6;
pub const IDI_RESURRECT: C2RustUnnamed_44 = 34;
pub const IDI_LAZSTAFF: C2RustUnnamed_44 = 33;
pub const IDI_LGTFORGE: C2RustUnnamed_44 = 32;
pub const IDI_GRISWOLD: C2RustUnnamed_44 = 31;
pub const IDI_FULLMANA: C2RustUnnamed_44 = 30;
pub const IDI_FULLHEAL: C2RustUnnamed_44 = 29;
pub const IDI_ARMOFVAL: C2RustUnnamed_44 = 28;
pub const IDI_PORTAL: C2RustUnnamed_44 = 27;
pub const IDI_IDENTIFY: C2RustUnnamed_44 = 26;
pub const IDI_MANA: C2RustUnnamed_44 = 25;
pub const IDI_HEAL: C2RustUnnamed_44 = 24;
pub const IDI_MAPOFDOOM: C2RustUnnamed_44 = 22;
pub const IDI_BLDSTONE: C2RustUnnamed_44 = 21;
pub const IDI_SPECELIX: C2RustUnnamed_44 = 20;
pub const IDI_FUNGALTM: C2RustUnnamed_44 = 19;
pub const IDI_BRAIN: C2RustUnnamed_44 = 18;
pub const IDI_MUSHROOM: C2RustUnnamed_44 = 17;
pub const IDI_ANVIL: C2RustUnnamed_44 = 16;
pub const IDI_GLDNELIX: C2RustUnnamed_44 = 15;
pub const IDI_STEELVEIL: C2RustUnnamed_44 = 14;
pub const IDI_HARCREST: C2RustUnnamed_44 = 13;
pub const IDI_BANNER: C2RustUnnamed_44 = 12;
pub const IDI_TRING: C2RustUnnamed_44 = 11;
pub const IDI_OPTAMULET: C2RustUnnamed_44 = 10;
pub const IDI_ROCK: C2RustUnnamed_44 = 9;
pub const IDI_INFRARING: C2RustUnnamed_44 = 8;
pub const IDI_SKCROWN: C2RustUnnamed_44 = 7;
pub const IDI_CLEAVER: C2RustUnnamed_44 = 6;
pub const IDI_SORCEROR: C2RustUnnamed_44 = 5;
pub const IDI_ROGUE: C2RustUnnamed_44 = 4;
pub const IDI_WARRCLUB: C2RustUnnamed_44 = 3;
pub const IDI_WARRSHLD: C2RustUnnamed_44 = 2;
pub const IDI_WARRIOR: C2RustUnnamed_44 = 1;
pub type C2RustUnnamed_45 = libc::c_uint;
pub const IT_FOOD: C2RustUnnamed_45 = 14;
pub const IT_AMULET: C2RustUnnamed_45 = 13;
pub const IT_RING: C2RustUnnamed_45 = 12;
pub const IT_STAFF: C2RustUnnamed_45 = 10;
pub const IT_HARMOR: C2RustUnnamed_45 = 9;
pub const IT_MARMOR: C2RustUnnamed_45 = 8;
pub const IT_HELM: C2RustUnnamed_45 = 7;
pub const IT_ARMOR: C2RustUnnamed_45 = 6;
pub const IT_BOW: C2RustUnnamed_45 = 3;
pub const IT_AXE: C2RustUnnamed_45 = 2;
pub const IT_MISC: C2RustUnnamed_45 = 0;
pub type C2RustUnnamed_46 = libc::c_uint;
pub const PLRVRAD: C2RustUnnamed_46 = 10;
pub const MAXTRANS: C2RustUnnamed_46 = 32;
pub const MAXVISION: C2RustUnnamed_46 = 32;
pub const MAXLIGHTS: C2RustUnnamed_46 = 32;
pub const LIGHTSIZE: C2RustUnnamed_46 = 6912;
pub type C2RustUnnamed_47 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_47 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_47 = 92160;
pub const BTMBUFFY: C2RustUnnamed_47 = 144;
pub const BTMBUFFX: C2RustUnnamed_47 = 640;
pub const BUFFERSIZE: C2RustUnnamed_47 = 503808;
pub const BUFFERY: C2RustUnnamed_47 = 656;
pub const BUFFERX: C2RustUnnamed_47 = 768;
pub const GAMEY: C2RustUnnamed_47 = 352;
pub const CTRLPANY: C2RustUnnamed_47 = 128;
pub const TOTALY: C2RustUnnamed_47 = 480;
pub const TOTALX: C2RustUnnamed_47 = 640;
#[no_mangle]
pub static mut PlrWalkTbl: [[libc::c_int; 3]; 3] = [
    [2048 as libc::c_int, 1024 as libc::c_int, 512 as libc::c_int],
    [2048 as libc::c_int, 1024 as libc::c_int, 512 as libc::c_int],
    [2048 as libc::c_int, 1024 as libc::c_int, 512 as libc::c_int],
];
#[no_mangle]
pub static mut PlrWalkLenTbl: [libc::c_int; 3] = [
    8 as libc::c_int,
    8 as libc::c_int,
    8 as libc::c_int,
];
#[no_mangle]
pub static mut ToBlkTbl: [libc::c_int; 3] = [
    30 as libc::c_int,
    20 as libc::c_int,
    10 as libc::c_int,
];
#[no_mangle]
pub static mut ClassStrTbl: [*const libc::c_char; 3] = [
    b"Warrior\0" as *const u8 as *const libc::c_char,
    b"Rogue\0" as *const u8 as *const libc::c_char,
    b"Sorceror\0" as *const u8 as *const libc::c_char,
];
#[no_mangle]
pub static mut ExpLvlsTbl: [int32_t; 51] = [
    0 as libc::c_int,
    2000 as libc::c_int,
    4620 as libc::c_int,
    8040 as libc::c_int,
    12489 as libc::c_int,
    18258 as libc::c_int,
    25712 as libc::c_int,
    35309 as libc::c_int,
    47622 as libc::c_int,
    63364 as libc::c_int,
    83419 as libc::c_int,
    108879 as libc::c_int,
    141086 as libc::c_int,
    181683 as libc::c_int,
    231075 as libc::c_int,
    313656 as libc::c_int,
    424067 as libc::c_int,
    571190 as libc::c_int,
    766569 as libc::c_int,
    1025154 as libc::c_int,
    1366227 as libc::c_int,
    1814568 as libc::c_int,
    2401895 as libc::c_int,
    3168651 as libc::c_int,
    4166200 as libc::c_int,
    5459523 as libc::c_int,
    7130496 as libc::c_int,
    9281874 as libc::c_int,
    12042092 as libc::c_int,
    15571031 as libc::c_int,
    20066900 as libc::c_int,
    25774405 as libc::c_int,
    32994399 as libc::c_int,
    42095202 as libc::c_int,
    53525811 as libc::c_int,
    67831218 as libc::c_int,
    85670061 as libc::c_int,
    107834823 as libc::c_int,
    135274799 as libc::c_int,
    169122009 as libc::c_int,
    210720231 as libc::c_int,
    261657253 as libc::c_int,
    323800420 as libc::c_int,
    399335440 as libc::c_int,
    490808349 as libc::c_int,
    601170414 as libc::c_int,
    733825617 as libc::c_int,
    892680222 as libc::c_int,
    1082908612 as libc::c_int,
    1310707109 as libc::c_int,
    1583495809 as libc::c_int,
];
static mut plrgfxlmh: [libc::c_char; 4] = unsafe {
    *::core::mem::transmute::<&[u8; 4], &[libc::c_char; 4]>(b"LMH\0")
};
static mut plrgfxweap: [libc::c_char; 10] = unsafe {
    *::core::mem::transmute::<&[u8; 10], &[libc::c_char; 10]>(b"NUSDBAMHT\0")
};
static mut sgcCharClass: [libc::c_char; 3] = [
    'W' as i32 as libc::c_char,
    'R' as i32 as libc::c_char,
    'S' as i32 as libc::c_char,
];
static mut sgpszCharDir: [*const libc::c_char; 3] = [
    b"Warrior\0" as *const u8 as *const libc::c_char,
    b"Rogue\0" as *const u8 as *const libc::c_char,
    b"Sorceror\0" as *const u8 as *const libc::c_char,
];
#[no_mangle]
pub unsafe extern "C" fn SetAnimPtrs(
    mut pData: *mut uint8_t,
    mut pAnim: *mut *mut uint8_t,
) {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 8 as libc::c_int {
        let ref mut fresh0 = *pAnim.offset(i as isize);
        *fresh0 = pData.offset(*(pData as *mut uint32_t).offset(i as isize) as isize);
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn LoadPlrGFX(mut pnum: libc::c_int, mut dwLoad: uint32_t) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            155 as libc::c_int,
            b"LoadPlrGFX: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    let mut pPlayer: *mut PlayerStruct = &mut *plr.as_mut_ptr().offset(pnum as isize)
        as *mut PlayerStruct;
    if !((*pPlayer)._pClass as uint32_t <= NUM_CLASSES as libc::c_int as uint32_t) {
        assert_fail(
            161 as libc::c_int,
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)pPlayer->_pClass <= NUM_CLASSES\0" as *const u8
                as *const libc::c_char,
        );
    }
    let mut szPlrType: [libc::c_char; 16] = [0; 16];
    let mut pszPlrPath: *const libc::c_char = b"\0" as *const u8 as *const libc::c_char;
    sprintf(
        szPlrType.as_mut_ptr(),
        b"%c%c%c\0" as *const u8 as *const libc::c_char,
        sgcCharClass[(*pPlayer)._pClass as usize] as libc::c_int,
        plrgfxlmh[((*pPlayer)._pgfxnum >> PGFX_CSHIFT as libc::c_int) as usize]
            as libc::c_int,
        plrgfxweap[((*pPlayer)._pgfxnum & PGFX_MASK as libc::c_int) as usize]
            as libc::c_int,
    );
    pszPlrPath = sgpszCharDir[(*pPlayer)._pClass as usize];
    let mut pData: *mut uint8_t = 0 as *mut uint8_t;
    let mut ppAnim: *mut *mut uint8_t = 0 as *mut *mut uint8_t;
    let mut pszAnim: *const libc::c_char = 0 as *const libc::c_char;
    let mut current_block_44: u64;
    let mut dwBit: uint32_t = 1 as libc::c_int as uint32_t;
    while dwBit <= PGL_ALL as libc::c_int as uint32_t {
        if !(dwBit & dwLoad == 0) {
            match dwBit {
                1 => {
                    pszAnim = if leveltype as libc::c_int != 0 {
                        b"AS\0" as *const u8 as *const libc::c_char
                    } else {
                        b"ST\0" as *const u8 as *const libc::c_char
                    };
                    pData = (*pPlayer)._pNData;
                    ppAnim = ((*pPlayer)._pNAnim).as_mut_ptr();
                    current_block_44 = 6476622998065200121;
                }
                2 => {
                    pszAnim = if leveltype as libc::c_int != 0 {
                        b"AW\0" as *const u8 as *const libc::c_char
                    } else {
                        b"WL\0" as *const u8 as *const libc::c_char
                    };
                    pData = (*pPlayer)._pWData;
                    ppAnim = ((*pPlayer)._pWAnim).as_mut_ptr();
                    current_block_44 = 6476622998065200121;
                }
                128 => {
                    if (*pPlayer)._pgfxnum & PGFX_MASK as libc::c_int
                        != PGFX_NGUY as libc::c_int
                    {
                        current_block_44 = 1394248824506584008;
                    } else {
                        pszAnim = b"DT\0" as *const u8 as *const libc::c_char;
                        pData = (*pPlayer)._pDData;
                        ppAnim = ((*pPlayer)._pDAnim).as_mut_ptr();
                        current_block_44 = 6476622998065200121;
                    }
                }
                4 => {
                    if leveltype == 0 {
                        current_block_44 = 1394248824506584008;
                    } else {
                        pszAnim = b"AT\0" as *const u8 as *const libc::c_char;
                        pData = (*pPlayer)._pAData;
                        ppAnim = ((*pPlayer)._pAAnim).as_mut_ptr();
                        current_block_44 = 6476622998065200121;
                    }
                }
                8 => {
                    if leveltype == 0 {
                        current_block_44 = 1394248824506584008;
                    } else {
                        pszAnim = b"HT\0" as *const u8 as *const libc::c_char;
                        pData = (*pPlayer)._pHData;
                        ppAnim = ((*pPlayer)._pHAnim).as_mut_ptr();
                        current_block_44 = 6476622998065200121;
                    }
                }
                16 => {
                    if leveltype == 0 {
                        current_block_44 = 1394248824506584008;
                    } else {
                        pszAnim = b"LM\0" as *const u8 as *const libc::c_char;
                        pData = (*pPlayer)._pLData;
                        ppAnim = ((*pPlayer)._pLAnim).as_mut_ptr();
                        current_block_44 = 6476622998065200121;
                    }
                }
                32 => {
                    if leveltype == 0 {
                        current_block_44 = 1394248824506584008;
                    } else {
                        pszAnim = b"FM\0" as *const u8 as *const libc::c_char;
                        pData = (*pPlayer)._pFData;
                        ppAnim = ((*pPlayer)._pFAnim).as_mut_ptr();
                        current_block_44 = 6476622998065200121;
                    }
                }
                64 => {
                    if leveltype == 0 {
                        current_block_44 = 1394248824506584008;
                    } else {
                        pszAnim = b"QM\0" as *const u8 as *const libc::c_char;
                        pData = (*pPlayer)._pTData;
                        ppAnim = ((*pPlayer)._pTAnim).as_mut_ptr();
                        current_block_44 = 6476622998065200121;
                    }
                }
                256 => {
                    if leveltype == 0 {
                        current_block_44 = 1394248824506584008;
                    } else if (*pPlayer)._pBlockFlag == 0 {
                        current_block_44 = 1394248824506584008;
                    } else {
                        pszAnim = b"BL\0" as *const u8 as *const libc::c_char;
                        pData = (*pPlayer)._pBData;
                        ppAnim = ((*pPlayer)._pBAnim).as_mut_ptr();
                        current_block_44 = 6476622998065200121;
                    }
                }
                _ => {
                    app_fatal_(
                        b"src/player.c\0" as *const u8 as *const libc::c_char,
                        269 as libc::c_int,
                        b"PLR:2\0" as *const u8 as *const libc::c_char,
                    );
                    current_block_44 = 6476622998065200121;
                }
            }
            match current_block_44 {
                1394248824506584008 => {}
                _ => {
                    let mut szBuf: [libc::c_char; 256] = [0; 256];
                    sprintf(
                        szBuf.as_mut_ptr(),
                        b"PlrGFX\\%s\\%s\\%s%s.CL2\0" as *const u8
                            as *const libc::c_char,
                        pszPlrPath,
                        szPlrType.as_mut_ptr(),
                        szPlrType.as_mut_ptr(),
                        pszAnim,
                    );
                    if pData.is_null() {
                        assert_fail(
                            282 as libc::c_int,
                            b"src/player.c\0" as *const u8 as *const libc::c_char,
                            b"pData\0" as *const u8 as *const libc::c_char,
                        );
                    }
                    LoadFileWithMem(szBuf.as_mut_ptr(), pData);
                    SetAnimPtrs(pData, ppAnim);
                    (*pPlayer)
                        ._pGFXLoad = ((*pPlayer)._pGFXLoad as uint32_t | dwBit)
                        as libc::c_int;
                }
            }
        }
        dwBit <<= 1 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn InitPlayerGFX(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            292 as libc::c_int,
            b"InitPlayerGFX: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pHitPoints >> HP_SHIFT as libc::c_int == 0 as libc::c_int {
        plr[pnum as usize]._pgfxnum = PGFX_NGUY as libc::c_int;
        LoadPlrGFX(pnum, PGL_DEAD as libc::c_int as uint32_t);
    } else {
        LoadPlrGFX(pnum, PGL_ALL as libc::c_int as uint32_t);
    };
}
unsafe extern "C" fn calc_plr_mem(mut pszAnim: *const libc::c_char) -> uint32_t {
    let mut dwMax: uint32_t = 0 as libc::c_int as uint32_t;
    let mut dwClass: uint32_t = 0 as libc::c_int as uint32_t;
    while dwClass < NUM_CLASSES as libc::c_int as uint32_t {
        let mut pszArmor: *const libc::c_char = plrgfxlmh.as_ptr();
        while *pszArmor != 0 {
            let mut pszWeap: *const libc::c_char = plrgfxweap.as_ptr();
            while *pszWeap != 0 {
                let mut szPlrType: [libc::c_char; 16] = [0; 16];
                let mut szBuf: [libc::c_char; 256] = [0; 256];
                sprintf(
                    szPlrType.as_mut_ptr(),
                    b"%c%c%c\0" as *const u8 as *const libc::c_char,
                    sgcCharClass[dwClass as usize] as libc::c_int,
                    *pszArmor as libc::c_int,
                    *pszWeap as libc::c_int,
                );
                sprintf(
                    szBuf.as_mut_ptr(),
                    b"PlrGFX\\%s\\%s\\%s%s.CL2\0" as *const u8 as *const libc::c_char,
                    sgpszCharDir[dwClass as usize],
                    szPlrType.as_mut_ptr(),
                    szPlrType.as_mut_ptr(),
                    pszAnim,
                );
                let mut hsFile: HSFILE = 0 as *mut C2RustUnnamed_40;
                if !(patSFileOpenFile(
                    szBuf.as_mut_ptr(),
                    &mut hsFile,
                    1 as libc::c_int as bool32_t,
                ) == 0)
                {
                    if hsFile.is_null() {
                        assert_fail(
                            331 as libc::c_int,
                            b"src/player.c\0" as *const u8 as *const libc::c_char,
                            b"hsFile\0" as *const u8 as *const libc::c_char,
                        );
                    }
                    let mut dwSize: uint32_t = SFileGetFileSize(hsFile);
                    SFileCloseFile(hsFile);
                    dwMax = if dwMax > dwSize { dwMax } else { dwSize };
                }
                pszWeap = pszWeap.offset(1);
                pszWeap;
            }
            pszArmor = pszArmor.offset(1);
            pszArmor;
        }
        dwClass = dwClass.wrapping_add(1);
        dwClass;
    }
    return dwMax;
}
#[no_mangle]
pub unsafe extern "C" fn InitPlrGFXMem(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            344 as libc::c_int,
            b"InitPlrGFXMem: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if !(plr[pnum as usize]._pNData).is_null() {
        assert_fail(
            346 as libc::c_int,
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            b"!plr[pnum]._pNData\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut dwMem: uint32_t = if calc_plr_mem(
        b"AS\0" as *const u8 as *const libc::c_char,
    ) > calc_plr_mem(b"ST\0" as *const u8 as *const libc::c_char)
    {
        calc_plr_mem(b"AS\0" as *const u8 as *const libc::c_char)
    } else {
        calc_plr_mem(b"ST\0" as *const u8 as *const libc::c_char)
    };
    plr[pnum as usize]._pNData = DiabloAllocPtr(dwMem);
    let mut dwMem_0: uint32_t = if calc_plr_mem(
        b"AW\0" as *const u8 as *const libc::c_char,
    ) > calc_plr_mem(b"WL\0" as *const u8 as *const libc::c_char)
    {
        calc_plr_mem(b"AW\0" as *const u8 as *const libc::c_char)
    } else {
        calc_plr_mem(b"WL\0" as *const u8 as *const libc::c_char)
    };
    plr[pnum as usize]._pWData = DiabloAllocPtr(dwMem_0);
    let mut dwMem_1: uint32_t = calc_plr_mem(
        b"AT\0" as *const u8 as *const libc::c_char,
    );
    plr[pnum as usize]._pAData = DiabloAllocPtr(dwMem_1);
    let mut dwMem_2: uint32_t = calc_plr_mem(
        b"HT\0" as *const u8 as *const libc::c_char,
    );
    plr[pnum as usize]._pHData = DiabloAllocPtr(dwMem_2);
    let mut dwMem_3: uint32_t = calc_plr_mem(
        b"LM\0" as *const u8 as *const libc::c_char,
    );
    plr[pnum as usize]._pLData = DiabloAllocPtr(dwMem_3);
    let mut dwMem_4: uint32_t = calc_plr_mem(
        b"FM\0" as *const u8 as *const libc::c_char,
    );
    plr[pnum as usize]._pFData = DiabloAllocPtr(dwMem_4);
    let mut dwMem_5: uint32_t = calc_plr_mem(
        b"QM\0" as *const u8 as *const libc::c_char,
    );
    plr[pnum as usize]._pTData = DiabloAllocPtr(dwMem_5);
    let mut dwMem_6: uint32_t = calc_plr_mem(
        b"DT\0" as *const u8 as *const libc::c_char,
    );
    plr[pnum as usize]._pDData = DiabloAllocPtr(dwMem_6);
    let mut dwMem_7: uint32_t = calc_plr_mem(
        b"BL\0" as *const u8 as *const libc::c_char,
    );
    plr[pnum as usize]._pBData = DiabloAllocPtr(dwMem_7);
    plr[pnum as usize]._pGFXLoad = 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn FreePlayerGFX(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            391 as libc::c_int,
            b"FreePlayerGFX: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    let mut p__p: *mut libc::c_void = plr[pnum as usize]._pNData as *mut libc::c_void;
    plr[pnum as usize]._pNData = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    let mut p__p_0: *mut libc::c_void = plr[pnum as usize]._pWData as *mut libc::c_void;
    plr[pnum as usize]._pWData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_0);
    let mut p__p_1: *mut libc::c_void = plr[pnum as usize]._pAData as *mut libc::c_void;
    plr[pnum as usize]._pAData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_1);
    let mut p__p_2: *mut libc::c_void = plr[pnum as usize]._pHData as *mut libc::c_void;
    plr[pnum as usize]._pHData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_2);
    let mut p__p_3: *mut libc::c_void = plr[pnum as usize]._pLData as *mut libc::c_void;
    plr[pnum as usize]._pLData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_3);
    let mut p__p_4: *mut libc::c_void = plr[pnum as usize]._pFData as *mut libc::c_void;
    plr[pnum as usize]._pFData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_4);
    let mut p__p_5: *mut libc::c_void = plr[pnum as usize]._pTData as *mut libc::c_void;
    plr[pnum as usize]._pTData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_5);
    let mut p__p_6: *mut libc::c_void = plr[pnum as usize]._pDData as *mut libc::c_void;
    plr[pnum as usize]._pDData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_6);
    let mut p__p_7: *mut libc::c_void = plr[pnum as usize]._pBData as *mut libc::c_void;
    plr[pnum as usize]._pBData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_7);
    plr[pnum as usize]._pGFXLoad = 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn NewPlrAnim(
    mut pnum: libc::c_int,
    mut pAnim: *mut uint8_t,
    mut numFrames: libc::c_int,
    mut Delay: libc::c_int,
    mut width: int32_t,
) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            407 as libc::c_int,
            b"NewPlrAnim: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pAnimData = pAnim;
    plr[pnum as usize]._pAnimLen = numFrames;
    plr[pnum as usize]._pAnimFrame = 1 as libc::c_int;
    plr[pnum as usize]._pAnimCnt = 0 as libc::c_int;
    plr[pnum as usize]._pAnimDelay = Delay;
    plr[pnum as usize]._pAnimWidth = width;
    plr[pnum as usize]._pAnimWidth2 = width - 64 as libc::c_int >> 1 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn ClearPlrPVars(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            420 as libc::c_int,
            b"ClearPlrPVars: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pVar1 = 0 as libc::c_int;
    plr[pnum as usize]._pVar2 = 0 as libc::c_int;
    plr[pnum as usize]._pVar3 = 0 as libc::c_int;
    plr[pnum as usize]._pVar4 = 0 as libc::c_int;
    plr[pnum as usize]._pVar5 = 0 as libc::c_int;
    plr[pnum as usize]._pVar6 = 0 as libc::c_int;
    plr[pnum as usize]._pVar7 = 0 as libc::c_int;
    plr[pnum as usize]._pVar8 = 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn SetPlrAnims(mut pnum: libc::c_int) {
    let mut gn: libc::c_int = 0;
    let mut pc: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            436 as libc::c_int,
            b"SetPlrAnims: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pNWidth = 96 as libc::c_int;
    plr[pnum as usize]._pWWidth = 96 as libc::c_int;
    plr[pnum as usize]._pAWidth = 128 as libc::c_int;
    plr[pnum as usize]._pHWidth = 96 as libc::c_int;
    plr[pnum as usize]._pSWidth = 96 as libc::c_int;
    plr[pnum as usize]._pDWidth = 128 as libc::c_int;
    plr[pnum as usize]._pBWidth = 96 as libc::c_int;
    pc = plr[pnum as usize]._pClass as libc::c_int;
    if leveltype as libc::c_int == 0 as libc::c_int {
        plr[pnum as usize]
            ._pNFrames = PlrGFXAnimLens[pc as usize][7 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pWFrames = PlrGFXAnimLens[pc as usize][8 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pDFrames = PlrGFXAnimLens[pc as usize][4 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pSFrames = PlrGFXAnimLens[pc as usize][5 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pSFNum = PlrGFXAnimLens[pc as usize][10 as libc::c_int as usize]
            as libc::c_int;
    } else {
        plr[pnum as usize]
            ._pNFrames = PlrGFXAnimLens[pc as usize][0 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pWFrames = PlrGFXAnimLens[pc as usize][2 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pAFrames = PlrGFXAnimLens[pc as usize][1 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pHFrames = PlrGFXAnimLens[pc as usize][6 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pSFrames = PlrGFXAnimLens[pc as usize][5 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pDFrames = PlrGFXAnimLens[pc as usize][4 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pBFrames = PlrGFXAnimLens[pc as usize][3 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pAFNum = PlrGFXAnimLens[pc as usize][9 as libc::c_int as usize]
            as libc::c_int;
        plr[pnum as usize]
            ._pSFNum = PlrGFXAnimLens[pc as usize][10 as libc::c_int as usize]
            as libc::c_int;
    }
    gn = plr[pnum as usize]._pgfxnum & PGFX_MASK as libc::c_int;
    if pc == CLASS_WARRIOR as libc::c_int {
        if gn == PGFX_BGUY as libc::c_int {
            if leveltype as libc::c_int != 0 as libc::c_int {
                plr[pnum as usize]._pNFrames = 8 as libc::c_int;
            }
            plr[pnum as usize]._pAWidth = 96 as libc::c_int;
            plr[pnum as usize]._pAFNum = 11 as libc::c_int;
        } else if gn == PGFX_FGUY as libc::c_int {
            plr[pnum as usize]._pAFrames = 20 as libc::c_int;
            plr[pnum as usize]._pAFNum = 10 as libc::c_int;
        } else if gn == PGFX_TGUY as libc::c_int {
            plr[pnum as usize]._pAFrames = 16 as libc::c_int;
            plr[pnum as usize]._pAFNum = 11 as libc::c_int;
        }
    } else if pc == CLASS_ROGUE as libc::c_int {
        if gn == PGFX_FGUY as libc::c_int {
            plr[pnum as usize]._pAFrames = 22 as libc::c_int;
            plr[pnum as usize]._pAFNum = 13 as libc::c_int;
        } else if gn == PGFX_BGUY as libc::c_int {
            plr[pnum as usize]._pAFrames = 12 as libc::c_int;
            plr[pnum as usize]._pAFNum = 7 as libc::c_int;
        } else if gn == PGFX_TGUY as libc::c_int {
            plr[pnum as usize]._pAFrames = 16 as libc::c_int;
            plr[pnum as usize]._pAFNum = 11 as libc::c_int;
        }
    } else if pc == CLASS_SORCEROR as libc::c_int {
        plr[pnum as usize]._pSWidth = 128 as libc::c_int;
        if gn == PGFX_NGUY as libc::c_int {
            plr[pnum as usize]._pAFrames = 20 as libc::c_int;
        } else if gn == PGFX_SGUY as libc::c_int {
            plr[pnum as usize]._pAFNum = 9 as libc::c_int;
        } else if gn == PGFX_BGUY as libc::c_int {
            plr[pnum as usize]._pAFrames = 20 as libc::c_int;
            plr[pnum as usize]._pAFNum = 16 as libc::c_int;
        } else if gn == PGFX_FGUY as libc::c_int {
            plr[pnum as usize]._pAFrames = 24 as libc::c_int;
            plr[pnum as usize]._pAFNum = 16 as libc::c_int;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn PlrInitReserved(mut p: *mut PlayerStruct) {
    if p.is_null() {
        assert_fail(
            509 as libc::c_int,
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            b"p != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    (*p).bReserved6 = 0 as libc::c_int as uint8_t;
    (*p).bReserved7 = 0 as libc::c_int as uint8_t;
    (*p).bReserved8 = 0 as libc::c_int as uint8_t;
    (*p).wReserved1 = 0 as libc::c_int as uint16_t;
    (*p).wReserved2 = 0 as libc::c_int as uint16_t;
    (*p).wReserved3 = 0 as libc::c_int as uint16_t;
    (*p).wReserved4 = 0 as libc::c_int as uint16_t;
    (*p).wReserved5 = 0 as libc::c_int as uint16_t;
    (*p).wReserved6 = 0 as libc::c_int as uint16_t;
    (*p).wReserved7 = 0 as libc::c_int as uint16_t;
    (*p).wReserved8 = 0 as libc::c_int as uint16_t;
    (*p).dwReserved2 = 0 as libc::c_int as uint32_t;
    (*p).dwReserved3 = 0 as libc::c_int as uint32_t;
    (*p).dwReserved4 = 0 as libc::c_int as uint32_t;
    (*p).dwReserved5 = 0 as libc::c_int as uint32_t;
    (*p).dwReserved6 = 0 as libc::c_int as uint32_t;
    (*p).dwReserved7 = 0 as libc::c_int as uint32_t;
    (*p).dwReserved8 = 0 as libc::c_int as uint32_t;
}
#[no_mangle]
pub unsafe extern "C" fn CreatePlayer(mut pnum: libc::c_int, mut c: int8_t) {
    PlrInitReserved(&mut *plr.as_mut_ptr().offset(pnum as isize));
    let mut i: libc::c_int = 0;
    let mut vc: int8_t = 0;
    if set_player_seed != 0 as libc::c_int {
        SetRndSeed(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            551 as libc::c_int,
            set_player_seed,
        );
    } else {
        SetRndSeed(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            553 as libc::c_int,
            SDL_GetTicks() as libc::c_int,
        );
    }
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            559 as libc::c_int,
            b"CreatePlayer: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pClass = c;
    vc = StrengthTbl[c as usize] as int8_t;
    if (vc as libc::c_int) < 0 as libc::c_int {
        vc = 0 as libc::c_int as int8_t;
    }
    plr[pnum as usize]._pStrength = vc as libc::c_int;
    plr[pnum as usize]._pBaseStr = vc as libc::c_int;
    vc = MagicTbl[c as usize] as int8_t;
    if (vc as libc::c_int) < 0 as libc::c_int {
        vc = 0 as libc::c_int as int8_t;
    }
    plr[pnum as usize]._pMagic = vc as libc::c_int;
    plr[pnum as usize]._pBaseMag = vc as libc::c_int;
    vc = DexterityTbl[c as usize] as int8_t;
    if (vc as libc::c_int) < 0 as libc::c_int {
        vc = 0 as libc::c_int as int8_t;
    }
    plr[pnum as usize]._pDexterity = vc as libc::c_int;
    plr[pnum as usize]._pBaseDex = vc as libc::c_int;
    vc = VitalityTbl[c as usize] as int8_t;
    if (vc as libc::c_int) < 0 as libc::c_int {
        vc = 0 as libc::c_int as int8_t;
    }
    plr[pnum as usize]._pVitality = vc as libc::c_int;
    plr[pnum as usize]._pBaseVit = vc as libc::c_int;
    plr[pnum as usize]._pStatPts = 0 as libc::c_int;
    plr[pnum as usize].pTownWarps = 0 as libc::c_int as uint8_t;
    plr[pnum as usize].pDungMsgs = 0 as libc::c_int as uint8_t;
    plr[pnum as usize].pLvlLoad = 0 as libc::c_int as uint8_t;
    plr[pnum as usize].pDiabloKillLevel = 0 as libc::c_int as uint32_t;
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[pnum as usize]
            ._pDamageMod = (plr[pnum as usize]._pStrength
            + plr[pnum as usize]._pDexterity) * plr[pnum as usize]._pLevel as libc::c_int
            / 200 as libc::c_int;
    } else {
        plr[pnum as usize]
            ._pDamageMod = plr[pnum as usize]._pStrength
            * plr[pnum as usize]._pLevel as libc::c_int / 100 as libc::c_int;
    }
    plr[pnum as usize]._pBaseToBlk = ToBlkTbl[c as usize];
    plr[pnum as usize]
        ._pHitPoints = (plr[pnum as usize]._pVitality + 10 as libc::c_int)
        << HP_SHIFT as libc::c_int;
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        plr[pnum as usize]
            ._pHitPoints = plr[pnum as usize]._pHitPoints << 1 as libc::c_int;
    }
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[pnum as usize]._pHitPoints
            += plr[pnum as usize]._pHitPoints >> 1 as libc::c_int;
    }
    plr[pnum as usize]._pMaxHP = plr[pnum as usize]._pHitPoints;
    plr[pnum as usize]._pHPBase = plr[pnum as usize]._pHitPoints;
    plr[pnum as usize]._pMaxHPBase = plr[pnum as usize]._pHitPoints;
    plr[pnum as usize]._pMana = plr[pnum as usize]._pMagic << MANA_SHIFT as libc::c_int;
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int {
        plr[pnum as usize]._pMana = plr[pnum as usize]._pMana << 1 as libc::c_int;
    }
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[pnum as usize]._pMana += plr[pnum as usize]._pMana >> 1 as libc::c_int;
    }
    plr[pnum as usize]._pMaxMana = plr[pnum as usize]._pMana;
    plr[pnum as usize]._pManaBase = plr[pnum as usize]._pMana;
    plr[pnum as usize]._pMaxManaBase = plr[pnum as usize]._pMana;
    plr[pnum as usize]._pLevel = 1 as libc::c_int as int8_t;
    plr[pnum as usize]._pMaxLvl = plr[pnum as usize]._pLevel;
    plr[pnum as usize]._pExperience = 0 as libc::c_int;
    plr[pnum as usize]._pMaxExp = plr[pnum as usize]._pExperience;
    plr[pnum as usize]._pNextExper = ExpLvlsTbl[1 as libc::c_int as usize];
    plr[pnum as usize]._pArmorClass = 0 as libc::c_int as int8_t;
    plr[pnum as usize]._pMagResist = 0 as libc::c_int as int8_t;
    plr[pnum as usize]._pFireResist = 0 as libc::c_int as int8_t;
    plr[pnum as usize]._pLghtResist = 0 as libc::c_int as int8_t;
    plr[pnum as usize]._pLightRad = PLRLRAD as libc::c_int as int8_t;
    plr[pnum as usize]._pInfraFlag = 0 as libc::c_int as bool32_t;
    if c as libc::c_int == CLASS_WARRIOR as libc::c_int {
        plr[pnum as usize]
            ._pAblSpells = (1 as libc::c_int as uint64_t)
            << SPL_REPAIR as libc::c_int - 1 as libc::c_int;
    } else if c as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[pnum as usize]
            ._pAblSpells = (1 as libc::c_int as uint64_t)
            << SPL_DISARM as libc::c_int - 1 as libc::c_int;
    } else if c as libc::c_int == CLASS_SORCEROR as libc::c_int {
        plr[pnum as usize]
            ._pAblSpells = (1 as libc::c_int as uint64_t)
            << SPL_RECHARGE as libc::c_int - 1 as libc::c_int;
    }
    if c as libc::c_int == CLASS_SORCEROR as libc::c_int {
        plr[pnum as usize]
            ._pMemSpells = (1 as libc::c_int as uint64_t)
            << SPL_FIREBOLT as libc::c_int - 1 as libc::c_int;
    } else {
        plr[pnum as usize]._pMemSpells = 0 as libc::c_int as uint64_t;
    }
    i = 0 as libc::c_int;
    while i < 64 as libc::c_int {
        plr[pnum as usize]._pSplLvl[i as usize] = 0 as libc::c_int as int8_t;
        i += 1;
        i;
    }
    plr[pnum as usize]._pSpellFlags = 0 as libc::c_int as int8_t;
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int {
        plr[pnum as usize]
            ._pSplLvl[SPL_FIREBOLT as libc::c_int as usize] = 2 as libc::c_int as int8_t;
    }
    i = 0 as libc::c_int;
    while i < 3 as libc::c_int {
        plr[pnum as usize]._pSplHotKey[i as usize] = -(1 as libc::c_int);
        i += 1;
        i;
    }
    if c as libc::c_int == CLASS_WARRIOR as libc::c_int {
        plr[pnum as usize]._pgfxnum = PGFX_GUY as libc::c_int;
    } else if c as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[pnum as usize]._pgfxnum = PGFX_BGUY as libc::c_int;
    } else if c as libc::c_int == CLASS_SORCEROR as libc::c_int {
        plr[pnum as usize]._pgfxnum = PGFX_TGUY as libc::c_int;
    }
    i = 0 as libc::c_int;
    while i < NUMLEVELS as libc::c_int {
        plr[pnum as usize]._pLvlVisited[i as usize] = 0 as libc::c_int as uint8_t;
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < NUMSLEVELS as libc::c_int {
        plr[pnum as usize]._pSLvlVisited[i as usize] = 0 as libc::c_int as uint8_t;
        i += 1;
        i;
    }
    plr[pnum as usize]._pLvlChanging = 0 as libc::c_int as uint8_t;
    plr[pnum as usize].pTownWarps = 0 as libc::c_int as uint8_t;
    plr[pnum as usize].pLvlLoad = 0 as libc::c_int as uint8_t;
    plr[pnum as usize].pBattleNet = 0 as libc::c_int as uint8_t;
    plr[pnum as usize].pManaShield = 0 as libc::c_int as uint8_t;
    InitDungMsgs(pnum);
    CreatePlrItems(pnum);
    SetRndSeed(
        b"src/player.c\0" as *const u8 as *const libc::c_char,
        692 as libc::c_int,
        0 as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn CalcStatDiff(mut pnum: libc::c_int) -> libc::c_int {
    let mut c: libc::c_int = plr[pnum as usize]._pClass as libc::c_int;
    let mut d: libc::c_int = MaxStats[c as usize][0 as libc::c_int as usize]
        - plr[pnum as usize]._pBaseStr;
    d += MaxStats[c as usize][1 as libc::c_int as usize] - plr[pnum as usize]._pBaseMag;
    d += MaxStats[c as usize][2 as libc::c_int as usize] - plr[pnum as usize]._pBaseDex;
    d += MaxStats[c as usize][3 as libc::c_int as usize] - plr[pnum as usize]._pBaseVit;
    return d;
}
#[no_mangle]
pub unsafe extern "C" fn NextPlrLevel(mut pnum: libc::c_int) {
    let mut l: int32_t = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            710 as libc::c_int,
            b"NextPlrLevel: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pLevel += 1;
    plr[pnum as usize]._pLevel;
    plr[pnum as usize]._pMaxLvl += 1;
    plr[pnum as usize]._pMaxLvl;
    if CalcStatDiff(pnum) < 5 as libc::c_int {
        plr[pnum as usize]._pStatPts = CalcStatDiff(pnum);
    } else {
        plr[pnum as usize]._pStatPts += 5 as libc::c_int;
    }
    plr[pnum as usize]._pNextExper = ExpLvlsTbl[plr[pnum as usize]._pLevel as usize];
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int {
        l = (1 as libc::c_int) << HP_SHIFT as libc::c_int;
    } else {
        l = (2 as libc::c_int) << HP_SHIFT as libc::c_int;
    }
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        l += 1;
        l;
    }
    plr[pnum as usize]._pMaxHP += l;
    plr[pnum as usize]._pHitPoints = plr[pnum as usize]._pMaxHP;
    plr[pnum as usize]._pMaxHPBase += l;
    plr[pnum as usize]._pHPBase = plr[pnum as usize]._pMaxHPBase;
    if pnum == myplr {
        drawhpflag = 1 as libc::c_int as bool32_t;
    }
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        l = (1 as libc::c_int) << MANA_SHIFT as libc::c_int;
    } else {
        l = (2 as libc::c_int) << MANA_SHIFT as libc::c_int;
    }
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        l += 1;
        l;
    }
    plr[pnum as usize]._pMaxMana += l;
    plr[pnum as usize]._pMaxManaBase += l;
    if plr[pnum as usize]._pIFlags & IAF_LMANA as libc::c_int == 0 {
        plr[pnum as usize]._pMana = plr[pnum as usize]._pMaxMana;
        plr[pnum as usize]._pManaBase = plr[pnum as usize]._pMaxManaBase;
    }
    if pnum == myplr {
        drawmanaflag = 1 as libc::c_int as bool32_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn AddPlrExperience(
    mut pnum: libc::c_int,
    mut lvl: libc::c_int,
    mut exp: int32_t,
) {
    if pnum != myplr {
        return;
    }
    if myplr as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            768 as libc::c_int,
            b"AddPlrExperience: illegal player %d\0" as *const u8 as *const libc::c_char,
            myplr,
        );
    }
    if plr[myplr as usize]._pHitPoints <= 0 as libc::c_int {
        return;
    }
    let mut v: libc::c_double = (1 as libc::c_int as libc::c_double
        + (lvl as libc::c_double - plr[pnum as usize]._pLevel as libc::c_double)
            * 0.1f64) * exp as libc::c_double;
    let mut e: int32_t = v as int32_t;
    if e < 0 as libc::c_int {
        e = 0 as libc::c_int;
    }
    if gbMaxPlayers as libc::c_int > 1 as libc::c_int {
        let mut lLevel: int32_t = if 0 as libc::c_int
            > plr[pnum as usize]._pLevel as libc::c_int
        {
            0 as libc::c_int
        } else {
            plr[pnum as usize]._pLevel as libc::c_int
        };
        lLevel = if lLevel < MAX_EXPLVLS as libc::c_int {
            lLevel
        } else {
            MAX_EXPLVLS as libc::c_int
        };
        let mut lMax: int32_t = ExpLvlsTbl[lLevel as usize] / 20 as libc::c_int;
        e = if e < lMax { e } else { lMax };
        lMax = lLevel * 200 as libc::c_int;
        e = if e < lMax { e } else { lMax };
    }
    plr[pnum as usize]._pExperience += e;
    if plr[pnum as usize]._pExperience as uint32_t
        > 2000000000 as libc::c_int as uint32_t
    {
        plr[pnum as usize]._pExperience = 2000000000 as libc::c_int;
    }
    if plr[pnum as usize]._pExperience
        >= ExpLvlsTbl[(MAX_EXPLVLS as libc::c_int - 1 as libc::c_int) as usize]
    {
        plr[pnum as usize]._pLevel = MAX_EXPLVLS as libc::c_int as int8_t;
    } else {
        let mut l: libc::c_int = 0;
        l = 0 as libc::c_int;
        while plr[pnum as usize]._pExperience >= ExpLvlsTbl[l as usize] {
            l += 1;
            l;
        }
        if l != plr[pnum as usize]._pLevel as libc::c_int {
            l -= plr[pnum as usize]._pLevel as libc::c_int;
            let mut i: libc::c_int = 0 as libc::c_int;
            while i < l {
                NextPlrLevel(pnum);
                i += 1;
                i;
            }
        }
        NetSendCmdParam1(
            0 as libc::c_int as bool32_t,
            CMD_PLRLEVEL as libc::c_int as uint8_t,
            plr[myplr as usize]._pLevel as uint16_t,
        );
    };
}
#[no_mangle]
pub unsafe extern "C" fn AddPlrMonstExper(
    mut lvl: libc::c_int,
    mut exp: int32_t,
    mut pmask: uint8_t,
) {
    let mut totplrs: libc::c_int = 0 as libc::c_int;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAX_PLRS as libc::c_int {
        if pmask as libc::c_int & (1 as libc::c_int) << i != 0 {
            totplrs += 1;
            totplrs;
        }
        i += 1;
        i;
    }
    if totplrs != 0 {
        let mut myexp: int32_t = exp / totplrs;
        if pmask as libc::c_int & (1 as libc::c_int) << myplr != 0 {
            AddPlrExperience(myplr, lvl, myexp);
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn InitPlayer(mut pnum: libc::c_int, mut FirstTime: bool32_t) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            831 as libc::c_int,
            b"InitPlayer: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    PlrInitReserved(&mut *plr.as_mut_ptr().offset(pnum as isize));
    if FirstTime != 0 {
        plr[pnum as usize]._pRSplType = SPT_NONE as libc::c_int as int8_t;
        plr[pnum as usize]._pRSpell = -(1 as libc::c_int);
        plr[pnum as usize]._pSBkSpell = -(1 as libc::c_int);
        plr[pnum as usize]._pSpell = plr[pnum as usize]._pRSpell;
        plr[pnum as usize]._pSplType = plr[pnum as usize]._pRSplType;
        if plr[pnum as usize]._pgfxnum & PGFX_MASK as libc::c_int
            == PGFX_BGUY as libc::c_int
        {
            plr[pnum as usize]._pwtype = WEAP_RANGE as libc::c_int;
        } else {
            plr[pnum as usize]._pwtype = WEAP_H2H as libc::c_int;
        }
        plr[pnum as usize].pManaShield = 0 as libc::c_int as uint8_t;
    }
    if plr[pnum as usize].plrlevel == currlevel as libc::c_int {
        SetPlrAnims(pnum);
        plr[pnum as usize]._pxoff = 0 as libc::c_int;
        plr[pnum as usize]._pyoff = 0 as libc::c_int;
        plr[pnum as usize]._pxvel = 0 as libc::c_int;
        plr[pnum as usize]._pyvel = 0 as libc::c_int;
        ClearPlrPVars(pnum);
        if plr[pnum as usize]._pHitPoints >> HP_SHIFT as libc::c_int > 0 as libc::c_int {
            plr[pnum as usize]._pmode = PM_STAND as libc::c_int;
            NewPlrAnim(
                pnum,
                plr[pnum as usize]._pNAnim[DIR_D as libc::c_int as usize],
                plr[pnum as usize]._pNFrames,
                3 as libc::c_int,
                plr[pnum as usize]._pNWidth,
            );
            plr[pnum as usize]
                ._pAnimFrame = random_(
                b"src/player.c\0" as *const u8 as *const libc::c_char,
                862 as libc::c_int,
                2 as libc::c_int as uint8_t,
                plr[pnum as usize]._pNFrames - 1 as libc::c_int,
            ) + 1 as libc::c_int;
            plr[pnum as usize]
                ._pAnimCnt = random_(
                b"src/player.c\0" as *const u8 as *const libc::c_char,
                863 as libc::c_int,
                2 as libc::c_int as uint8_t,
                3 as libc::c_int,
            );
        } else {
            plr[pnum as usize]._pmode = PM_DEATH as libc::c_int;
            NewPlrAnim(
                pnum,
                plr[pnum as usize]._pDAnim[DIR_D as libc::c_int as usize],
                plr[pnum as usize]._pDFrames,
                1 as libc::c_int,
                plr[pnum as usize]._pDWidth,
            );
            plr[pnum as usize]
                ._pAnimFrame = plr[pnum as usize]._pAnimLen - 1 as libc::c_int;
            plr[pnum as usize]._pVar8 = plr[pnum as usize]._pAnimLen << 1 as libc::c_int;
        }
        plr[pnum as usize]._pdir = DIR_D as libc::c_int;
        plr[pnum as usize]._peflag = 0 as libc::c_int;
        if pnum == myplr {
            if FirstTime == 0 || currlevel as libc::c_int != 0 as libc::c_int {
                plr[pnum as usize]._px = ViewX;
                plr[pnum as usize]._py = ViewY;
            }
            plr[pnum as usize]._ptargx = plr[pnum as usize]._px;
            plr[pnum as usize]._ptargy = plr[pnum as usize]._py;
        } else {
            plr[pnum as usize]._ptargx = plr[pnum as usize]._px;
            plr[pnum as usize]._ptargy = plr[pnum as usize]._py;
            let mut i: libc::c_int = 0;
            i = 0 as libc::c_int;
            while (i as libc::c_ulong)
                < (::core::mem::size_of::<[libc::c_int; 9]>() as libc::c_ulong)
                    .wrapping_div(::core::mem::size_of::<libc::c_int>() as libc::c_ulong)
                    .wrapping_sub(1 as libc::c_int as libc::c_ulong)
            {
                if PosOkPlayer(
                    pnum,
                    plr[pnum as usize]._px + plrxoff2[i as usize],
                    plr[pnum as usize]._py + plryoff2[i as usize],
                ) != 0
                {
                    break;
                }
                i += 1;
                i;
            }
            plr[pnum as usize]._px += plrxoff2[i as usize];
            plr[pnum as usize]._py += plryoff2[i as usize];
        }
        plr[pnum as usize]._pfutx = plr[pnum as usize]._px;
        plr[pnum as usize]._pfuty = plr[pnum as usize]._py;
        plr[pnum as usize]
            .walkpath[0 as libc::c_int as usize] = PCMD_NOTHING as libc::c_int as int8_t;
        plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
        if pnum == myplr {
            plr[pnum as usize]
                ._plid = AddLight(
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
                plr[pnum as usize]._pLightRad as libc::c_int,
            );
        } else {
            plr[pnum as usize]._plid = -(1 as libc::c_int);
        }
        plr[pnum as usize]
            ._pvid = AddVision(
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
            plr[pnum as usize]._pLightRad as libc::c_int,
            (pnum == myplr) as libc::c_int as bool32_t,
        );
    }
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        plr[pnum as usize]
            ._pAblSpells = (1 as libc::c_int as uint64_t)
            << SPL_REPAIR as libc::c_int - 1 as libc::c_int;
    } else if plr[pnum as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[pnum as usize]
            ._pAblSpells = (1 as libc::c_int as uint64_t)
            << SPL_DISARM as libc::c_int - 1 as libc::c_int;
    } else if plr[pnum as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int
    {
        plr[pnum as usize]
            ._pAblSpells = (1 as libc::c_int as uint64_t)
            << SPL_RECHARGE as libc::c_int - 1 as libc::c_int;
    }
    if CHEATS as libc::c_int != 0 {
        if simplecheat != 0 && FirstTime != 0 {
            plr[pnum as usize]._pMemSpells
                |= (1 as libc::c_int as uint64_t) << SPL_TELE as libc::c_int;
            if plr[myplr as usize]._pSplLvl[SPL_TELE as libc::c_int as usize] == 0 {
                plr[myplr as usize]
                    ._pSplLvl[SPL_TELE as libc::c_int
                    as usize] = 1 as libc::c_int as int8_t;
            }
        }
        if cheatflag != 0 && FirstTime != 0 {
            plr[pnum as usize]
                ._pMemSpells = 0xfffffffffffffff as libc::c_long as uint64_t;
        }
    }
    plr[pnum as usize]._pNextExper = ExpLvlsTbl[plr[pnum as usize]._pLevel as usize];
    plr[pnum as usize]._pInvincible = 0 as libc::c_int as uint8_t;
    if pnum == myplr {
        deathdelay = 0 as libc::c_int;
        deathflag = 0 as libc::c_int as bool32_t;
        ScrollInfo._sxoff = 0 as libc::c_int;
        ScrollInfo._syoff = 0 as libc::c_int;
        ScrollInfo._sdir = SCRL_NONE as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn InitMultiView() {
    if myplr as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            952 as libc::c_int,
            b"InitPlayer: illegal player %d\0" as *const u8 as *const libc::c_char,
            myplr,
        );
    }
    ViewX = plr[myplr as usize]._px;
    ViewY = plr[myplr as usize]._py;
}
#[no_mangle]
pub unsafe extern "C" fn PlrGetDir(
    mut pnum: libc::c_int,
    mut i: libc::c_int,
) -> libc::c_int {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            960 as libc::c_int,
            b"PlrGetDir: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    return GetDirection(
        plr[pnum as usize]._px,
        plr[pnum as usize]._py,
        monster[i as usize]._mx,
        monster[i as usize]._my,
    );
}
#[no_mangle]
pub unsafe extern "C" fn PlrGetDirXY(
    mut pnum: libc::c_int,
    mut xx: libc::c_int,
    mut yy: libc::c_int,
) -> libc::c_int {
    let mut d: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            969 as libc::c_int,
            b"PlrGetDirXY: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    d = GetDirection(plr[pnum as usize]._px, plr[pnum as usize]._py, xx, yy);
    if plr[pnum as usize]._px == xx && plr[pnum as usize]._py == yy {
        d = plr[pnum as usize]._pdir;
    }
    return d;
}
#[no_mangle]
pub unsafe extern "C" fn SolidLoc(mut x: libc::c_int, mut y: libc::c_int) -> bool32_t {
    if x < 0 as libc::c_int || y < 0 as libc::c_int || x >= MAXDUNX as libc::c_int
        || y >= MAXDUNY as libc::c_int
    {
        return 0 as libc::c_int as bool32_t;
    }
    return nSolidTable[dPiece[x as usize][y as usize] as usize] as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn PlrDirOK(
    mut i: libc::c_int,
    mut pdir: libc::c_int,
) -> bool32_t {
    if i as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            987 as libc::c_int,
            b"PlrDirOK: illegal player %d\0" as *const u8 as *const libc::c_char,
            i,
        );
    }
    let mut fx: int32_t = plr[i as usize]._px + offset_x[pdir as usize];
    let mut fy: int32_t = plr[i as usize]._py + offset_y[pdir as usize];
    if fx < 0 as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if dPiece[fx as usize][fy as usize] == 0 as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if PosOkPlayer(i, fx, fy) == 0 {
        return 0 as libc::c_int as bool32_t;
    }
    let mut ret: bool32_t = 1 as libc::c_int as bool32_t;
    if ret != 0 && pdir == DIR_R as libc::c_int {
        ret = (SolidLoc(fx, fy + 1 as libc::c_int) == 0
            && dFlags[fx as usize][(fy + 1 as libc::c_int) as usize] as libc::c_int
                & BFLAG_PLRLR as libc::c_int == 0) as libc::c_int as bool32_t;
    }
    if ret != 0 && pdir == DIR_L as libc::c_int {
        ret = (SolidLoc(fx + 1 as libc::c_int, fy) == 0
            && dFlags[(fx + 1 as libc::c_int) as usize][fy as usize] as libc::c_int
                & BFLAG_PLRLR as libc::c_int == 0) as libc::c_int as bool32_t;
    }
    return ret;
}
#[no_mangle]
pub unsafe extern "C" fn PlrClrTrans(mut x: libc::c_int, mut y: libc::c_int) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut v: int8_t = 0;
    j = y - 1 as libc::c_int;
    while j <= y + 1 as libc::c_int {
        i = x - 1 as libc::c_int;
        while i <= x + 1 as libc::c_int {
            v = dTransVal[i as usize][j as usize];
            TransList[v as usize] = 0 as libc::c_int as uint8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn PlrDoTrans(mut x: libc::c_int, mut y: libc::c_int) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut v: int8_t = 0;
    if leveltype as libc::c_int == 1 as libc::c_int
        || leveltype as libc::c_int == 2 as libc::c_int
    {
        j = y - 1 as libc::c_int;
        while j <= y + 1 as libc::c_int {
            i = x - 1 as libc::c_int;
            while i <= x + 1 as libc::c_int {
                if nSolidTable[dPiece[i as usize][j as usize] as usize] == 0 {
                    v = dTransVal[i as usize][j as usize];
                    if v as libc::c_int != 0 as libc::c_int {
                        TransList[v as usize] = 1 as libc::c_int as uint8_t;
                    }
                }
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    } else {
        TransList[1 as libc::c_int as usize] = 1 as libc::c_int as uint8_t;
    };
}
#[no_mangle]
pub unsafe extern "C" fn SetPlayerOld(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1047 as libc::c_int,
            b"SetPlayerOld: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._poldx = plr[pnum as usize]._px;
    plr[pnum as usize]._poldy = plr[pnum as usize]._py;
}
#[no_mangle]
pub unsafe extern "C" fn FixPlayerLocation(
    mut pnum: libc::c_int,
    mut bDir: libc::c_int,
) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1055 as libc::c_int,
            b"FixPlayerLocation: illegal player %d\0" as *const u8
                as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pfutx = plr[pnum as usize]._px;
    plr[pnum as usize]._pfuty = plr[pnum as usize]._py;
    plr[pnum as usize]._ptargx = plr[pnum as usize]._px;
    plr[pnum as usize]._ptargy = plr[pnum as usize]._py;
    plr[pnum as usize]._pxoff = 0 as libc::c_int;
    plr[pnum as usize]._pyoff = 0 as libc::c_int;
    plr[pnum as usize]._pdir = bDir;
    if pnum == myplr {
        ScrollInfo._sxoff = 0 as libc::c_int;
        ScrollInfo._syoff = 0 as libc::c_int;
        ScrollInfo._sdir = SCRL_NONE as libc::c_int;
        ViewX = plr[pnum as usize]._px;
        ViewY = plr[pnum as usize]._py;
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartStand(mut pnum: libc::c_int, mut dir: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1078 as libc::c_int,
            b"StartStand: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    if plr[pnum as usize]._pGFXLoad & PGL_STAND as libc::c_int == 0 as libc::c_int {
        LoadPlrGFX(pnum, PGL_STAND as libc::c_int as uint32_t);
    }
    NewPlrAnim(
        pnum,
        plr[pnum as usize]._pNAnim[dir as usize],
        plr[pnum as usize]._pNFrames,
        3 as libc::c_int,
        plr[pnum as usize]._pNWidth,
    );
    plr[pnum as usize]._pmode = PM_STAND as libc::c_int;
    FixPlayerLocation(pnum, dir);
    FixPlrWalkTags(pnum);
    dPlayer[plr[pnum as usize]._px
        as usize][plr[pnum as usize]._py
        as usize] = (1 as libc::c_int + pnum as int8_t as libc::c_int) as int8_t;
    SetPlayerOld(pnum);
}
#[no_mangle]
pub unsafe extern "C" fn StartWalkStand(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1098 as libc::c_int,
            b"StartWalkStand: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pmode = PM_STAND as libc::c_int;
    plr[pnum as usize]._pfutx = plr[pnum as usize]._px;
    plr[pnum as usize]._pfuty = plr[pnum as usize]._py;
    plr[pnum as usize]._pxoff = 0 as libc::c_int;
    plr[pnum as usize]._pyoff = 0 as libc::c_int;
    if pnum == myplr {
        ScrollInfo._sxoff = 0 as libc::c_int;
        ScrollInfo._syoff = 0 as libc::c_int;
        ScrollInfo._sdir = SCRL_NONE as libc::c_int;
        ViewX = plr[pnum as usize]._px;
        ViewY = plr[pnum as usize]._py;
    }
}
#[no_mangle]
pub unsafe extern "C" fn PM_ChangeLightOff(mut pnum: libc::c_int) {
    let mut lx: libc::c_int = 0;
    let mut ly: libc::c_int = 0;
    let mut signx: libc::c_int = 0;
    let mut signy: libc::c_int = 0;
    let mut totx: libc::c_int = 0;
    let mut toty: libc::c_int = 0;
    let mut oldtotx: libc::c_int = 0;
    let mut oldtoty: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1121 as libc::c_int,
            b"PM_ChangeLightOff: illegal player %d\0" as *const u8
                as *const libc::c_char,
            pnum,
        );
    }
    let mut light: *mut LightListStruct = &mut *LightList
        .as_mut_ptr()
        .offset((*plr.as_mut_ptr().offset(pnum as isize))._plid as isize)
        as *mut LightListStruct;
    lx = plr[pnum as usize]._pxoff + (plr[pnum as usize]._pyoff << 1 as libc::c_int);
    ly = (plr[pnum as usize]._pyoff << 1 as libc::c_int) - plr[pnum as usize]._pxoff;
    if lx < 0 as libc::c_int {
        signx = -(1 as libc::c_int);
        lx = -lx;
    } else {
        signx = 1 as libc::c_int;
    }
    if ly < 0 as libc::c_int {
        signy = -(1 as libc::c_int);
        ly = -ly;
    } else {
        signy = 1 as libc::c_int;
    }
    lx = lx >> 3 as libc::c_int;
    ly = ly >> 3 as libc::c_int;
    lx *= signx;
    ly *= signy;
    totx = ((*light)._lx << 3 as libc::c_int) + lx;
    toty = ((*light)._ly << 3 as libc::c_int) + ly;
    oldtotx = ((*light)._lx << 3 as libc::c_int) + (*light)._xoff;
    oldtoty = ((*light)._ly << 3 as libc::c_int) + (*light)._yoff;
    if abs(totx - oldtotx) >= 3 as libc::c_int || abs(toty - oldtoty) >= 3 as libc::c_int
    {
        ChangeLightOff(plr[pnum as usize]._plid, lx, ly);
    }
}
#[no_mangle]
pub unsafe extern "C" fn PM_ChangeOffset(mut pnum: libc::c_int) {
    let mut xo: int32_t = 0;
    let mut yo: int32_t = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1172 as libc::c_int,
            b"PM_ChangeOffset: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pVar8 += 1;
    plr[pnum as usize]._pVar8;
    xo = plr[pnum as usize]._pVar6 >> 8 as libc::c_int;
    yo = plr[pnum as usize]._pVar7 >> 8 as libc::c_int;
    plr[pnum as usize]._pVar6 += plr[pnum as usize]._pxvel;
    plr[pnum as usize]._pVar7 += plr[pnum as usize]._pyvel;
    plr[pnum as usize]._pxoff = plr[pnum as usize]._pVar6 >> 8 as libc::c_int;
    plr[pnum as usize]._pyoff = plr[pnum as usize]._pVar7 >> 8 as libc::c_int;
    xo -= plr[pnum as usize]._pVar6 >> 8 as libc::c_int;
    yo -= plr[pnum as usize]._pVar7 >> 8 as libc::c_int;
    if pnum == myplr && ScrollInfo._sdir != SCRL_NONE as libc::c_int {
        ScrollInfo._sxoff += xo;
        ScrollInfo._syoff += yo;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        PM_ChangeLightOff(pnum);
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartWalk(
    mut pnum: libc::c_int,
    mut xvel: libc::c_int,
    mut yvel: libc::c_int,
    mut xadd: libc::c_int,
    mut yadd: libc::c_int,
    mut EndDir: libc::c_int,
    mut scrldir: libc::c_int,
) {
    let mut fx: int32_t = 0;
    let mut fy: int32_t = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1204 as libc::c_int,
            b"StartWalk: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    SetPlayerOld(pnum);
    fx = plr[pnum as usize]._px + xadd;
    fy = plr[pnum as usize]._py + yadd;
    if PlrDirOK(pnum, EndDir) != 0 {
        plr[pnum as usize]._pfutx = fx;
        plr[pnum as usize]._pfuty = fy;
        if pnum == myplr {
            ScrollInfo._sdx = plr[pnum as usize]._px - ViewX;
            ScrollInfo._sdy = plr[pnum as usize]._py - ViewY;
        }
        dPlayer[fx
            as usize][fy
            as usize] = (-(1 as libc::c_int) - pnum as int8_t as libc::c_int) as int8_t;
        plr[pnum as usize]._pmode = PM_WALK as libc::c_int;
        plr[pnum as usize]._pxvel = xvel;
        plr[pnum as usize]._pyvel = yvel;
        plr[pnum as usize]._pxoff = 0 as libc::c_int;
        plr[pnum as usize]._pyoff = 0 as libc::c_int;
        plr[pnum as usize]._pVar1 = xadd;
        plr[pnum as usize]._pVar2 = yadd;
        plr[pnum as usize]._pVar3 = EndDir;
        if plr[pnum as usize]._pGFXLoad & PGL_WALK as libc::c_int == 0 as libc::c_int {
            LoadPlrGFX(pnum, PGL_WALK as libc::c_int as uint32_t);
        }
        NewPlrAnim(
            pnum,
            plr[pnum as usize]._pWAnim[EndDir as usize],
            plr[pnum as usize]._pWFrames,
            0 as libc::c_int,
            plr[pnum as usize]._pWWidth,
        );
        plr[pnum as usize]._pdir = EndDir;
        plr[pnum as usize]._pVar6 = 0 as libc::c_int;
        plr[pnum as usize]._pVar7 = 0 as libc::c_int;
        plr[pnum as usize]._pVar8 = 0 as libc::c_int;
        if pnum == myplr {
            if svgamode != 0 {
                if abs(ScrollInfo._sdx) < 3 as libc::c_int
                    && abs(ScrollInfo._sdy) < 3 as libc::c_int
                {
                    ScrollInfo._sdir = scrldir;
                } else {
                    ScrollInfo._sdir = SCRL_NONE as libc::c_int;
                }
            } else if abs(ScrollInfo._sdx) < 2 as libc::c_int
                && abs(ScrollInfo._sdy) < 2 as libc::c_int
            {
                ScrollInfo._sdir = scrldir;
            } else {
                ScrollInfo._sdir = SCRL_NONE as libc::c_int;
            }
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartWalk2(
    mut pnum: libc::c_int,
    mut xvel: libc::c_int,
    mut yvel: libc::c_int,
    mut xoff: libc::c_int,
    mut yoff: libc::c_int,
    mut xadd: libc::c_int,
    mut yadd: libc::c_int,
    mut EndDir: libc::c_int,
    mut scrldir: libc::c_int,
) {
    let mut fx: int32_t = 0;
    let mut fy: int32_t = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1263 as libc::c_int,
            b"StartWalk2: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    SetPlayerOld(pnum);
    fx = plr[pnum as usize]._px + xadd;
    fy = plr[pnum as usize]._py + yadd;
    if PlrDirOK(pnum, EndDir) != 0 {
        plr[pnum as usize]._pfutx = fx;
        plr[pnum as usize]._pfuty = fy;
        if pnum == myplr {
            ScrollInfo._sdx = plr[pnum as usize]._px - ViewX;
            ScrollInfo._sdy = plr[pnum as usize]._py - ViewY;
        }
        dPlayer[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py
            as usize] = (-(1 as libc::c_int) - pnum as int8_t as libc::c_int) as int8_t;
        plr[pnum as usize]._pVar1 = plr[pnum as usize]._px;
        plr[pnum as usize]._pVar2 = plr[pnum as usize]._py;
        plr[pnum as usize]._px = fx;
        plr[pnum as usize]._py = fy;
        dPlayer[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py
            as usize] = (1 as libc::c_int + pnum as int8_t as libc::c_int) as int8_t;
        plr[pnum as usize]._pxoff = xoff;
        plr[pnum as usize]._pyoff = yoff;
        if leveltype as libc::c_int != 0 as libc::c_int {
            ChangeLightXY(
                plr[pnum as usize]._plid,
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
            );
            PM_ChangeLightOff(pnum);
        }
        plr[pnum as usize]._pmode = PM_WALK2 as libc::c_int;
        plr[pnum as usize]._pxvel = xvel;
        plr[pnum as usize]._pyvel = yvel;
        plr[pnum as usize]._pVar6 = xoff << 8 as libc::c_int;
        plr[pnum as usize]._pVar7 = yoff << 8 as libc::c_int;
        plr[pnum as usize]._pVar3 = EndDir;
        if plr[pnum as usize]._pGFXLoad & PGL_WALK as libc::c_int == 0 as libc::c_int {
            LoadPlrGFX(pnum, PGL_WALK as libc::c_int as uint32_t);
        }
        NewPlrAnim(
            pnum,
            plr[pnum as usize]._pWAnim[EndDir as usize],
            plr[pnum as usize]._pWFrames,
            0 as libc::c_int,
            plr[pnum as usize]._pWWidth,
        );
        plr[pnum as usize]._pdir = EndDir;
        plr[pnum as usize]._pVar8 = 0 as libc::c_int;
        if pnum == myplr {
            if svgamode != 0 {
                if abs(ScrollInfo._sdx) < 3 as libc::c_int
                    && abs(ScrollInfo._sdy) < 3 as libc::c_int
                {
                    ScrollInfo._sdir = scrldir;
                } else {
                    ScrollInfo._sdir = SCRL_NONE as libc::c_int;
                }
            } else if abs(ScrollInfo._sdx) < 2 as libc::c_int
                && abs(ScrollInfo._sdy) < 2 as libc::c_int
            {
                ScrollInfo._sdir = scrldir;
            } else {
                ScrollInfo._sdir = SCRL_NONE as libc::c_int;
            }
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartWalk3(
    mut pnum: libc::c_int,
    mut xvel: libc::c_int,
    mut yvel: libc::c_int,
    mut xoff: libc::c_int,
    mut yoff: libc::c_int,
    mut xadd: libc::c_int,
    mut yadd: libc::c_int,
    mut txa: libc::c_int,
    mut tya: libc::c_int,
    mut EndDir: libc::c_int,
    mut scrldir: libc::c_int,
) {
    let mut fx: int32_t = 0;
    let mut fy: int32_t = 0;
    let mut tx: int32_t = 0;
    let mut ty: int32_t = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1336 as libc::c_int,
            b"StartWalk3: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    SetPlayerOld(pnum);
    fx = plr[pnum as usize]._px + xadd;
    fy = plr[pnum as usize]._py + yadd;
    tx = plr[pnum as usize]._px + txa;
    ty = plr[pnum as usize]._py + tya;
    if PlrDirOK(pnum, EndDir) != 0 {
        plr[pnum as usize]._pfutx = fx;
        plr[pnum as usize]._pfuty = fy;
        if pnum == myplr {
            ScrollInfo._sdx = plr[pnum as usize]._px - ViewX;
            ScrollInfo._sdy = plr[pnum as usize]._py - ViewY;
        }
        dPlayer[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py
            as usize] = (-(1 as libc::c_int) - pnum as int8_t as libc::c_int) as int8_t;
        dPlayer[fx
            as usize][fy
            as usize] = (-(1 as libc::c_int) - pnum as int8_t as libc::c_int) as int8_t;
        plr[pnum as usize]._pVar4 = tx;
        plr[pnum as usize]._pVar5 = ty;
        dFlags[tx
            as usize][ty
            as usize] = (dFlags[tx as usize][ty as usize] as libc::c_int
            | BFLAG_PLRLR as libc::c_int) as int8_t;
        plr[pnum as usize]._pxoff = xoff;
        plr[pnum as usize]._pyoff = yoff;
        if leveltype != 0 {
            ChangeLightXY(plr[pnum as usize]._plid, tx, ty);
            PM_ChangeLightOff(pnum);
        }
        plr[pnum as usize]._pmode = PM_WALK3 as libc::c_int;
        plr[pnum as usize]._pxvel = xvel;
        plr[pnum as usize]._pyvel = yvel;
        plr[pnum as usize]._pVar1 = fx;
        plr[pnum as usize]._pVar2 = fy;
        plr[pnum as usize]._pVar6 = xoff << 8 as libc::c_int;
        plr[pnum as usize]._pVar7 = yoff << 8 as libc::c_int;
        plr[pnum as usize]._pVar3 = EndDir;
        if plr[pnum as usize]._pGFXLoad & PGL_WALK as libc::c_int == 0 as libc::c_int {
            LoadPlrGFX(pnum, PGL_WALK as libc::c_int as uint32_t);
        }
        NewPlrAnim(
            pnum,
            plr[pnum as usize]._pWAnim[EndDir as usize],
            plr[pnum as usize]._pWFrames,
            0 as libc::c_int,
            plr[pnum as usize]._pWWidth,
        );
        plr[pnum as usize]._pdir = EndDir;
        plr[pnum as usize]._pVar8 = 0 as libc::c_int;
        if pnum == myplr {
            if svgamode != 0 {
                if abs(ScrollInfo._sdx) < 3 as libc::c_int
                    && abs(ScrollInfo._sdy) < 3 as libc::c_int
                {
                    ScrollInfo._sdir = scrldir;
                } else {
                    ScrollInfo._sdir = SCRL_NONE as libc::c_int;
                }
            } else if abs(ScrollInfo._sdx) < 2 as libc::c_int
                && abs(ScrollInfo._sdy) < 2 as libc::c_int
            {
                ScrollInfo._sdir = scrldir;
            } else {
                ScrollInfo._sdir = SCRL_NONE as libc::c_int;
            }
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartAttack(mut pnum: libc::c_int, mut d: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1402 as libc::c_int,
            b"StartAttack: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    if plr[pnum as usize]._pGFXLoad & PGL_ATTACK as libc::c_int == 0 as libc::c_int {
        LoadPlrGFX(pnum, PGL_ATTACK as libc::c_int as uint32_t);
    }
    NewPlrAnim(
        pnum,
        plr[pnum as usize]._pAAnim[d as usize],
        plr[pnum as usize]._pAFrames,
        0 as libc::c_int,
        plr[pnum as usize]._pAWidth,
    );
    plr[pnum as usize]._pmode = PM_ATTACK as libc::c_int;
    FixPlayerLocation(pnum, d);
    SetPlayerOld(pnum);
}
#[no_mangle]
pub unsafe extern "C" fn StartRangeAttack(
    mut pnum: libc::c_int,
    mut d: libc::c_int,
    mut dx: libc::c_int,
    mut dy: libc::c_int,
) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1421 as libc::c_int,
            b"StartRangeAttack: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    if plr[pnum as usize]._pGFXLoad & PGL_ATTACK as libc::c_int == 0 as libc::c_int {
        LoadPlrGFX(pnum, PGL_ATTACK as libc::c_int as uint32_t);
    }
    NewPlrAnim(
        pnum,
        plr[pnum as usize]._pAAnim[d as usize],
        plr[pnum as usize]._pAFrames,
        0 as libc::c_int,
        plr[pnum as usize]._pAWidth,
    );
    plr[pnum as usize]._pmode = PM_RATTACK as libc::c_int;
    FixPlayerLocation(pnum, d);
    SetPlayerOld(pnum);
    plr[pnum as usize]._pVar1 = dx;
    plr[pnum as usize]._pVar2 = dy;
}
#[no_mangle]
pub unsafe extern "C" fn StartPlrBlock(mut pnum: libc::c_int, mut dir: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1442 as libc::c_int,
            b"StartPlrBlock: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    PlaySfxLoc(IS_ISWORD as libc::c_int, plr[pnum as usize]._px, plr[pnum as usize]._py);
    if plr[pnum as usize]._pGFXLoad & PGL_BLOCK as libc::c_int == 0 as libc::c_int {
        LoadPlrGFX(pnum, PGL_BLOCK as libc::c_int as uint32_t);
    }
    NewPlrAnim(
        pnum,
        plr[pnum as usize]._pBAnim[dir as usize],
        plr[pnum as usize]._pBFrames,
        2 as libc::c_int,
        plr[pnum as usize]._pBWidth,
    );
    plr[pnum as usize]._pmode = PM_BLOCK as libc::c_int;
    FixPlayerLocation(pnum, dir);
    SetPlayerOld(pnum);
}
#[no_mangle]
pub unsafe extern "C" fn StartSpell(
    mut pnum: libc::c_int,
    mut d: libc::c_int,
    mut cx: libc::c_int,
    mut cy: libc::c_int,
) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1462 as libc::c_int,
            b"StartSpell: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        match spelldata[plr[pnum as usize]._pSpell as usize].sType as libc::c_int {
            0 => {
                if plr[pnum as usize]._pGFXLoad & PGL_FMAG as libc::c_int
                    == 0 as libc::c_int
                {
                    LoadPlrGFX(pnum, PGL_FMAG as libc::c_int as uint32_t);
                }
                NewPlrAnim(
                    pnum,
                    plr[pnum as usize]._pFAnim[d as usize],
                    plr[pnum as usize]._pSFrames,
                    0 as libc::c_int,
                    plr[pnum as usize]._pSWidth,
                );
            }
            1 => {
                if plr[pnum as usize]._pGFXLoad & PGL_LMAG as libc::c_int
                    == 0 as libc::c_int
                {
                    LoadPlrGFX(pnum, PGL_LMAG as libc::c_int as uint32_t);
                }
                NewPlrAnim(
                    pnum,
                    plr[pnum as usize]._pLAnim[d as usize],
                    plr[pnum as usize]._pSFrames,
                    0 as libc::c_int,
                    plr[pnum as usize]._pSWidth,
                );
            }
            2 => {
                if plr[pnum as usize]._pGFXLoad & PGL_TMAG as libc::c_int
                    == 0 as libc::c_int
                {
                    LoadPlrGFX(pnum, PGL_TMAG as libc::c_int as uint32_t);
                }
                NewPlrAnim(
                    pnum,
                    plr[pnum as usize]._pTAnim[d as usize],
                    plr[pnum as usize]._pSFrames,
                    0 as libc::c_int,
                    plr[pnum as usize]._pSWidth,
                );
            }
            _ => {}
        }
    }
    PlaySfxLoc(
        spelldata[plr[pnum as usize]._pSpell as usize].sSFX as libc::c_int,
        plr[pnum as usize]._px,
        plr[pnum as usize]._py,
    );
    plr[pnum as usize]._pmode = PM_SPELL as libc::c_int;
    FixPlayerLocation(pnum, d);
    SetPlayerOld(pnum);
    plr[pnum as usize]._pVar1 = cx;
    plr[pnum as usize]._pVar2 = cy;
    plr[pnum as usize]._pVar4 = GetSpellLevel(pnum, plr[pnum as usize]._pSpell);
    plr[pnum as usize]._pVar8 = 1 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn FixPlrWalkTags(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1508 as libc::c_int,
            b"FixPlrWalkTags: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    let mut pp: libc::c_int = pnum + 1 as libc::c_int;
    let mut pn: libc::c_int = -(1 as libc::c_int) - pnum;
    let mut px: libc::c_int = plr[pnum as usize]._poldx;
    let mut py: libc::c_int = plr[pnum as usize]._poldy;
    let mut y: libc::c_int = py - 1 as libc::c_int;
    while y <= py + 1 as libc::c_int {
        let mut x: libc::c_int = px - 1 as libc::c_int;
        while x <= px + 1 as libc::c_int {
            if !(x < 0 as libc::c_int || x >= DMAXX as libc::c_int) {
                if !(y < 0 as libc::c_int || y >= DMAXY as libc::c_int) {
                    if dPlayer[x as usize][y as usize] as libc::c_int == pp
                        || dPlayer[x as usize][y as usize] as libc::c_int == pn
                    {
                        dPlayer[x as usize][y as usize] = 0 as libc::c_int as int8_t;
                    }
                }
            }
            x += 1;
            x;
        }
        y += 1;
        y;
    }
    if px < 0 as libc::c_int || px >= DMAXX as libc::c_int - 1 as libc::c_int {
        return;
    }
    if py < 0 as libc::c_int || py >= DMAXY as libc::c_int - 1 as libc::c_int {
        return;
    }
    dFlags[(px + 1 as libc::c_int)
        as usize][(py + 0 as libc::c_int)
        as usize] = (dFlags[(px + 1 as libc::c_int)
        as usize][(py + 0 as libc::c_int) as usize] as libc::c_int
        & BFMASK_PLRLR as libc::c_int) as int8_t;
    dFlags[(px + 0 as libc::c_int)
        as usize][(py + 1 as libc::c_int)
        as usize] = (dFlags[(px + 0 as libc::c_int)
        as usize][(py + 1 as libc::c_int) as usize] as libc::c_int
        & BFMASK_PLRLR as libc::c_int) as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn RemovePlrFromMap(mut pnum: libc::c_int) {
    let mut pp: libc::c_int = pnum + 1 as libc::c_int;
    let mut pn: libc::c_int = -(1 as libc::c_int) - pnum;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    y = 1 as libc::c_int;
    while y < DMAXY as libc::c_int {
        x = 1 as libc::c_int;
        while x < DMAXX as libc::c_int {
            if (dPlayer[x as usize][(y - 1 as libc::c_int) as usize] as libc::c_int == pn
                || dPlayer[(x - 1 as libc::c_int) as usize][y as usize] as libc::c_int
                    == pn)
                && dFlags[x as usize][y as usize] as libc::c_int
                    & BFLAG_PLRLR as libc::c_int != 0
            {
                dFlags[x
                    as usize][y
                    as usize] = (dFlags[x as usize][y as usize] as libc::c_int
                    & BFMASK_PLRLR as libc::c_int) as int8_t;
            }
            x += 1;
            x;
        }
        y += 1;
        y;
    }
    y = 0 as libc::c_int;
    while y < DMAXY as libc::c_int {
        x = 0 as libc::c_int;
        while x < DMAXX as libc::c_int {
            if dPlayer[x as usize][y as usize] as libc::c_int == pp
                || dPlayer[x as usize][y as usize] as libc::c_int == pn
            {
                dPlayer[x as usize][y as usize] = 0 as libc::c_int as int8_t;
            }
            x += 1;
            x;
        }
        y += 1;
        y;
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartPlrHit(
    mut pnum: libc::c_int,
    mut dam: libc::c_int,
    mut forcehit: bool32_t,
) {
    let mut pd: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1563 as libc::c_int,
            b"StartPlrHit: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pInvincible as libc::c_int != 0
        && plr[pnum as usize]._pHitPoints == 0 as libc::c_int && pnum == myplr
    {
        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
        return;
    }
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        PlaySfxLoc(
            PS_WARR69 as libc::c_int,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
        );
    } else if plr[pnum as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        PlaySfxLoc(
            PS_ROGUE69 as libc::c_int,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
        );
    } else if plr[pnum as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int
    {
        PlaySfxLoc(
            PS_MAGE69 as libc::c_int,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
        );
    }
    drawhpflag = 1 as libc::c_int as bool32_t;
    if (dam >> HP_SHIFT as libc::c_int) < plr[pnum as usize]._pLevel as libc::c_int
        && forcehit == 0
    {
        return;
    }
    pd = plr[pnum as usize]._pdir;
    if plr[pnum as usize]._pGFXLoad & PGL_HIT as libc::c_int == 0 as libc::c_int {
        LoadPlrGFX(pnum, PGL_HIT as libc::c_int as uint32_t);
    }
    NewPlrAnim(
        pnum,
        plr[pnum as usize]._pHAnim[pd as usize],
        plr[pnum as usize]._pHFrames,
        0 as libc::c_int,
        plr[pnum as usize]._pHWidth,
    );
    plr[pnum as usize]._pmode = PM_GOTHIT as libc::c_int;
    FixPlayerLocation(pnum, pd);
    plr[pnum as usize]._pVar8 = 1 as libc::c_int;
    FixPlrWalkTags(pnum);
    dPlayer[plr[pnum as usize]._px
        as usize][plr[pnum as usize]._py
        as usize] = (1 as libc::c_int + pnum as int8_t as libc::c_int) as int8_t;
    SetPlayerOld(pnum);
}
#[no_mangle]
pub unsafe extern "C" fn RespawnDeadItem(
    mut itm: *mut ItemStruct,
    mut x: libc::c_int,
    mut y: libc::c_int,
) {
    let mut ii: libc::c_int = 0;
    if numitems < MAXITEMS as libc::c_int {
        if FindGetItem((*itm).IDidx, (*itm)._iCreateInfo, (*itm)._iSeed)
            >= 0 as libc::c_int
        {
            ShowDupString(
                b"A duplicate item has been detected.  Destroying duplicate...\0"
                    as *const u8 as *const libc::c_char,
            );
            SyncGetItem(x, y, (*itm).IDidx, (*itm)._iCreateInfo, (*itm)._iSeed);
        }
        ii = itemavail[0 as libc::c_int as usize];
        dItem[x as usize][y as usize] = (ii + 1 as libc::c_int) as int8_t;
        itemavail[0 as libc::c_int
            as usize] = itemavail[(MAXITEMS as libc::c_int - numitems - 1 as libc::c_int)
            as usize];
        itemactive[numitems as usize] = ii;
        item[ii as usize] = *itm;
        item[ii as usize]._ix = x;
        item[ii as usize]._iy = y;
        RespawnItem(ii, 1 as libc::c_int as bool32_t);
        numitems += 1;
        numitems;
        (*itm)._itype = -(1 as libc::c_int);
    }
}
unsafe extern "C" fn PlrDeadItem(
    mut pnum: libc::c_int,
    mut itm: *mut ItemStruct,
    mut xx: libc::c_int,
    mut yy: libc::c_int,
) {
    if (*itm)._itype == -(1 as libc::c_int) {
        return;
    }
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1638 as libc::c_int,
            b"PlrDeadItem: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    let mut x: libc::c_int = plr[pnum as usize]._px + xx;
    let mut y: libc::c_int = plr[pnum as usize]._py + yy;
    if xx != 0 as libc::c_int || yy != 0 as libc::c_int {
        if ItemSpaceOk(x, y) != 0 {
            RespawnDeadItem(itm, x, y);
            plr[pnum as usize].HoldItem = *itm;
            NetSendCmdPItem(
                0 as libc::c_int as bool32_t,
                CMD_RESPAWNITEM as libc::c_int as uint8_t,
                x as uint8_t,
                y as uint8_t,
            );
            return;
        }
    }
    let mut l: libc::c_int = 1 as libc::c_int;
    while l < 50 as libc::c_int {
        let mut j: libc::c_int = -l;
        while j <= l {
            y = plr[pnum as usize]._py + j;
            let mut i: libc::c_int = -l;
            while i <= l {
                x = plr[pnum as usize]._px + i;
                if ItemSpaceOk(x, y) == 0 {
                    i += 1;
                    i;
                } else {
                    RespawnDeadItem(itm, x, y);
                    plr[pnum as usize].HoldItem = *itm;
                    NetSendCmdPItem(
                        0 as libc::c_int as bool32_t,
                        CMD_RESPAWNITEM as libc::c_int as uint8_t,
                        x as uint8_t,
                        y as uint8_t,
                    );
                    return;
                }
            }
            j += 1;
            j;
        }
        l += 1;
        l;
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartPlayerKill(mut pnum: libc::c_int, mut earflag: int8_t) {
    let mut pi: *mut ItemStruct = 0 as *mut ItemStruct;
    let mut p: *mut PlayerStruct = &mut *plr.as_mut_ptr().offset(pnum as isize)
        as *mut PlayerStruct;
    let mut ear: ItemStruct = ItemStruct {
        _iSeed: 0,
        _iCreateInfo: 0,
        _itype: 0,
        _ix: 0,
        _iy: 0,
        _iAnimFlag: 0,
        _iAnimData: 0 as *const uint8_t as *mut uint8_t,
        _iAnimLen: 0,
        _iAnimFrame: 0,
        _iAnimWidth: 0,
        _iAnimWidth2: 0,
        _iInvalid: 0,
        _iSelFlag: 0,
        _iPostDraw: 0,
        _iIdentified: 0,
        _iMagical: 0,
        _iName: [0; 64],
        _iIName: [0; 64],
        _iLoc: 0,
        _iClass: 0,
        _iCurs: 0,
        _ivalue: 0,
        _iIvalue: 0,
        _iMinDam: 0,
        _iMaxDam: 0,
        _iAC: 0,
        _iFlags: 0,
        _iMiscId: 0,
        _iSpell: 0,
        _iCharges: 0,
        _iMaxCharges: 0,
        _iDurability: 0,
        _iMaxDur: 0,
        _iPLDam: 0,
        _iPLToHit: 0,
        _iPLAC: 0,
        _iPLStr: 0,
        _iPLMag: 0,
        _iPLDex: 0,
        _iPLVit: 0,
        _iPLFR: 0,
        _iPLLR: 0,
        _iPLMR: 0,
        _iPLMana: 0,
        _iPLHP: 0,
        _iPLDamMod: 0,
        _iPLGetHit: 0,
        _iPLLight: 0,
        _iSplLvlAdd: 0,
        _iRequest: 0,
        _iUid: 0,
        _iFMinDam: 0,
        _iFMaxDam: 0,
        _iLMinDam: 0,
        _iLMaxDam: 0,
        _iPLEnAc: 0,
        _iPrePower: 0,
        _iSufPower: 0,
        _iVAdd1: 0,
        _iVMult1: 0,
        _iVAdd2: 0,
        _iVMult2: 0,
        _iMinStr: 0,
        _iMinMag: 0,
        _iMinDex: 0,
        _iStatFlag: 0,
        IDidx: 0,
        _oldlight: 0,
    };
    let mut i: libc::c_int = 0;
    if plr[pnum as usize]._pHitPoints <= 0 as libc::c_int
        && plr[pnum as usize]._pmode == PM_DEATH as libc::c_int
    {
        return;
    }
    if myplr == pnum {
        NetSendCmdParam1(
            1 as libc::c_int as bool32_t,
            CMD_PLRDEAD as libc::c_int as uint8_t,
            earflag as uint16_t,
        );
    }
    let mut diablolevel: bool32_t = (gbMaxPlayers as libc::c_int > 1 as libc::c_int
        && plr[pnum as usize].plrlevel == 16 as libc::c_int) as libc::c_int as bool32_t;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1694 as libc::c_int,
            b"StartPlayerKill: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        PlaySfxLoc(PS_DEAD as libc::c_int, (*p)._px, (*p)._py);
    } else if plr[pnum as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        PlaySfxLoc(PS_ROGUE71 as libc::c_int, (*p)._px, (*p)._py);
    } else if plr[pnum as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int
    {
        PlaySfxLoc(PS_MAGE71 as libc::c_int, (*p)._px, (*p)._py);
    }
    if (*p)._pgfxnum != PGFX_NGUY as libc::c_int {
        (*p)._pgfxnum = PGFX_NGUY as libc::c_int;
        (*p)._pGFXLoad = 0 as libc::c_int;
        SetPlrAnims(pnum);
    }
    if (*p)._pGFXLoad & PGL_DEAD as libc::c_int == 0 as libc::c_int {
        LoadPlrGFX(pnum, PGL_DEAD as libc::c_int as uint32_t);
    }
    NewPlrAnim(
        pnum,
        (*p)._pDAnim[(*p)._pdir as usize],
        (*p)._pDFrames,
        1 as libc::c_int,
        (*p)._pDWidth,
    );
    (*p)._pmode = PM_DEATH as libc::c_int;
    (*p)._pBlockFlag = 0 as libc::c_int as uint8_t;
    (*p)._pInvincible = 1 as libc::c_int as uint8_t;
    SetPlayerHitPoints(pnum, 0 as libc::c_int);
    (*p)._pVar8 = 1 as libc::c_int;
    if pnum != myplr && earflag as libc::c_int == 0 as libc::c_int && diablolevel == 0 {
        pi = &mut *((*p).InvBody).as_mut_ptr().offset(0 as libc::c_int as isize)
            as *mut ItemStruct;
        i = NUM_INVLOC as libc::c_int;
        loop {
            let fresh1 = i;
            i = i - 1;
            if !(fresh1 != 0) {
                break;
            }
            (*pi)._itype = -(1 as libc::c_int);
            pi = pi.offset(1);
            pi;
        }
        CalcPlrInv(pnum, 0 as libc::c_int as bool32_t);
    }
    if plr[pnum as usize].plrlevel != currlevel as libc::c_int {
        SetPlayerHitPoints(pnum, 0 as libc::c_int);
        return;
    }
    FixPlayerLocation(pnum, (*p)._pdir);
    RemovePlrFromMap(pnum);
    dFlags[(*p)._px
        as usize][(*p)._py
        as usize] = (dFlags[(*p)._px as usize][(*p)._py as usize] as libc::c_int
        | BFLAG_DEADPLR as libc::c_int) as int8_t;
    SetPlayerOld(pnum);
    if pnum != myplr {
        SetPlayerHitPoints(pnum, 0 as libc::c_int);
        return;
    }
    drawhpflag = 1 as libc::c_int as bool32_t;
    deathdelay = 30 as libc::c_int;
    if curs >= ICSTART as libc::c_int {
        PlrDeadItem(pnum, &mut (*p).HoldItem, 0 as libc::c_int, 0 as libc::c_int);
        NewCursor(GLOVE_CURS as libc::c_int);
    }
    if diablolevel != 0 {
        SetPlayerHitPoints(pnum, 0 as libc::c_int);
        return;
    }
    DropHalfPlayersGold(pnum);
    if earflag as libc::c_int == KILL_UNKNOWN as libc::c_int {
        SetPlayerHitPoints(pnum, 0 as libc::c_int);
        return;
    }
    if earflag != 0 {
        SetPlrHandItem(&mut ear, IDI_EAR as libc::c_int);
        sprintf(
            (ear._iName).as_mut_ptr(),
            b"Ear of %s\0" as *const u8 as *const libc::c_char,
            (plr[pnum as usize]._pName).as_mut_ptr(),
        );
        if plr[pnum as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int {
            ear._iCurs = ITEM_EAR1 as libc::c_int;
        } else if plr[pnum as usize]._pClass as libc::c_int
            == CLASS_WARRIOR as libc::c_int
        {
            ear._iCurs = ITEM_EAR2 as libc::c_int;
        } else if plr[pnum as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int
        {
            ear._iCurs = ITEM_EAR3 as libc::c_int;
        }
        ear
            ._iCreateInfo = ((plr[pnum as usize]._pName[0 as libc::c_int as usize]
            as libc::c_int) << 8 as libc::c_int
            | plr[pnum as usize]._pName[1 as libc::c_int as usize] as libc::c_int)
            as uint16_t;
        ear
            ._iSeed = (plr[pnum as usize]._pName[2 as libc::c_int as usize]
            as libc::c_int) << 24 as libc::c_int
            | (plr[pnum as usize]._pName[3 as libc::c_int as usize] as libc::c_int)
                << 16 as libc::c_int
            | (plr[pnum as usize]._pName[4 as libc::c_int as usize] as libc::c_int)
                << 8 as libc::c_int
            | plr[pnum as usize]._pName[5 as libc::c_int as usize] as libc::c_int;
        ear._ivalue = plr[pnum as usize]._pLevel as libc::c_int;
        let mut ii: libc::c_int = FindGetItem(
            IDI_EAR as libc::c_int,
            ear._iCreateInfo,
            ear._iSeed,
        );
        if ii == -(1 as libc::c_int) {
            PlrDeadItem(pnum, &mut ear, 0 as libc::c_int, 0 as libc::c_int);
        }
    } else {
        pi = &mut *((*p).InvBody).as_mut_ptr().offset(0 as libc::c_int as isize)
            as *mut ItemStruct;
        i = NUM_INVLOC as libc::c_int;
        loop {
            let fresh2 = i;
            i = i - 1;
            if !(fresh2 != 0) {
                break;
            }
            let mut pdd: libc::c_int = (*p)._pdir + i & 0x7 as libc::c_int;
            PlrDeadItem(pnum, pi, offset_x[pdd as usize], offset_y[pdd as usize]);
            pi = pi.offset(1);
            pi;
        }
        CalcPlrInv(pnum, 0 as libc::c_int as bool32_t);
    }
    SetPlayerHitPoints(pnum, 0 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn DropHalfPlayersGold(mut pnum: libc::c_int) {
    let mut i: libc::c_int = 0;
    let mut hGold: int32_t = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            1805 as libc::c_int,
            b"DropHalfPlayersGold: illegal player %d\0" as *const u8
                as *const libc::c_char,
            pnum,
        );
    }
    hGold = plr[pnum as usize]._pGold >> 1 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXSPD as libc::c_int && hGold > 0 as libc::c_int {
        if plr[pnum as usize].SpdList[i as usize]._itype == IT_GOLD as libc::c_int
            && plr[pnum as usize].SpdList[i as usize]._ivalue != GOLD_VMAX as libc::c_int
        {
            if hGold < plr[pnum as usize].SpdList[i as usize]._ivalue {
                plr[pnum as usize].SpdList[i as usize]._ivalue -= hGold;
                SetSpdbarGoldCurs(pnum, i);
                SetPlrHandItem(
                    &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    IDI_GOLD as libc::c_int,
                );
                GetGoldSeed(
                    pnum,
                    &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                );
                SetPlrHandGoldCurs(
                    &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                );
                plr[pnum as usize].HoldItem._ivalue = hGold;
                PlrDeadItem(
                    pnum,
                    &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    0 as libc::c_int,
                    0 as libc::c_int,
                );
                hGold = 0 as libc::c_int;
            } else {
                hGold -= plr[pnum as usize].SpdList[i as usize]._ivalue;
                RemoveSpdBarItem(pnum, i);
                SetPlrHandItem(
                    &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    IDI_GOLD as libc::c_int,
                );
                GetGoldSeed(
                    pnum,
                    &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                );
                SetPlrHandGoldCurs(
                    &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                );
                plr[pnum as usize]
                    .HoldItem
                    ._ivalue = plr[pnum as usize].SpdList[i as usize]._ivalue;
                PlrDeadItem(
                    pnum,
                    &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    0 as libc::c_int,
                    0 as libc::c_int,
                );
                i = -(1 as libc::c_int);
            }
        }
        i += 1;
        i;
    }
    if hGold > 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXSPD as libc::c_int && hGold > 0 as libc::c_int {
            if plr[pnum as usize].SpdList[i as usize]._itype == IT_GOLD as libc::c_int {
                if hGold < plr[pnum as usize].SpdList[i as usize]._ivalue {
                    plr[pnum as usize].SpdList[i as usize]._ivalue -= hGold;
                    SetSpdbarGoldCurs(pnum, i);
                    SetPlrHandItem(
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        IDI_GOLD as libc::c_int,
                    );
                    GetGoldSeed(
                        pnum,
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    );
                    SetPlrHandGoldCurs(
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    );
                    plr[pnum as usize].HoldItem._ivalue = hGold;
                    PlrDeadItem(
                        pnum,
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        0 as libc::c_int,
                        0 as libc::c_int,
                    );
                    hGold = 0 as libc::c_int;
                } else {
                    hGold -= plr[pnum as usize].SpdList[i as usize]._ivalue;
                    RemoveSpdBarItem(pnum, i);
                    SetPlrHandItem(
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        IDI_GOLD as libc::c_int,
                    );
                    GetGoldSeed(
                        pnum,
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    );
                    SetPlrHandGoldCurs(
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    );
                    plr[pnum as usize]
                        .HoldItem
                        ._ivalue = plr[pnum as usize].SpdList[i as usize]._ivalue;
                    PlrDeadItem(
                        pnum,
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        0 as libc::c_int,
                        0 as libc::c_int,
                    );
                    i = -(1 as libc::c_int);
                }
            }
            i += 1;
            i;
        }
    }
    force_redraw = FULLDRAW as libc::c_int;
    if hGold > 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < plr[pnum as usize]._pNumInv && hGold > 0 as libc::c_int {
            if plr[pnum as usize].InvList[i as usize]._itype == IT_GOLD as libc::c_int
                && plr[pnum as usize].InvList[i as usize]._ivalue
                    != GOLD_VMAX as libc::c_int
            {
                if hGold < plr[pnum as usize].InvList[i as usize]._ivalue {
                    plr[pnum as usize].InvList[i as usize]._ivalue -= hGold;
                    SetGoldCurs(pnum, i);
                    SetPlrHandItem(
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        IDI_GOLD as libc::c_int,
                    );
                    GetGoldSeed(
                        pnum,
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    );
                    SetPlrHandGoldCurs(
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    );
                    plr[pnum as usize].HoldItem._ivalue = hGold;
                    PlrDeadItem(
                        pnum,
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        0 as libc::c_int,
                        0 as libc::c_int,
                    );
                    hGold = 0 as libc::c_int;
                } else {
                    hGold -= plr[pnum as usize].InvList[i as usize]._ivalue;
                    RemoveInvItem(pnum, i);
                    SetPlrHandItem(
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        IDI_GOLD as libc::c_int,
                    );
                    GetGoldSeed(
                        pnum,
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    );
                    SetPlrHandGoldCurs(
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                    );
                    plr[pnum as usize]
                        .HoldItem
                        ._ivalue = plr[pnum as usize].InvList[i as usize]._ivalue;
                    PlrDeadItem(
                        pnum,
                        &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        0 as libc::c_int,
                        0 as libc::c_int,
                    );
                    i = -(1 as libc::c_int);
                }
            }
            i += 1;
            i;
        }
        if hGold > 0 as libc::c_int {
            i = 0 as libc::c_int;
            while i < plr[pnum as usize]._pNumInv && hGold > 0 as libc::c_int {
                if plr[pnum as usize].InvList[i as usize]._itype
                    == IT_GOLD as libc::c_int
                {
                    if hGold < plr[pnum as usize].InvList[i as usize]._ivalue {
                        plr[pnum as usize].InvList[i as usize]._ivalue -= hGold;
                        SetGoldCurs(pnum, i);
                        SetPlrHandItem(
                            &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                            IDI_GOLD as libc::c_int,
                        );
                        GetGoldSeed(
                            pnum,
                            &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        );
                        SetPlrHandGoldCurs(
                            &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        );
                        plr[pnum as usize].HoldItem._ivalue = hGold;
                        PlrDeadItem(
                            pnum,
                            &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                            0 as libc::c_int,
                            0 as libc::c_int,
                        );
                        hGold = 0 as libc::c_int;
                    } else {
                        hGold -= plr[pnum as usize].InvList[i as usize]._ivalue;
                        RemoveInvItem(pnum, i);
                        SetPlrHandItem(
                            &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                            IDI_GOLD as libc::c_int,
                        );
                        GetGoldSeed(
                            pnum,
                            &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        );
                        SetPlrHandGoldCurs(
                            &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                        );
                        plr[pnum as usize]
                            .HoldItem
                            ._ivalue = plr[pnum as usize].InvList[i as usize]._ivalue;
                        PlrDeadItem(
                            pnum,
                            &mut (*plr.as_mut_ptr().offset(pnum as isize)).HoldItem,
                            0 as libc::c_int,
                            0 as libc::c_int,
                        );
                        i = -(1 as libc::c_int);
                    }
                }
                i += 1;
                i;
            }
        }
    }
    plr[pnum as usize]._pGold = CalculateGold(pnum);
}
#[no_mangle]
pub unsafe extern "C" fn StartPlrKill(mut pnum: libc::c_int, mut earflag: int8_t) {
    let mut i: libc::c_int = 0;
    let mut mx: libc::c_int = 0;
    if plr[pnum as usize]._pHitPoints == 0 as libc::c_int
        && currlevel as libc::c_int == 0 as libc::c_int
    {
        SetPlayerHitPoints(pnum, (1 as libc::c_int) << HP_SHIFT as libc::c_int);
        return;
    }
    i = 0 as libc::c_int;
    while i < nummissiles {
        mx = missileactive[i as usize];
        if missile[mx as usize]._mitype == MIT_MANASHIELD as libc::c_int
            && missile[mx as usize]._misource == pnum
            && missile[mx as usize]._miDelFlag == 0
        {
            if earflag as libc::c_int != KILL_UNKNOWN as libc::c_int {
                missile[mx as usize]._miVar8 = earflag as int32_t;
            }
            return;
        }
        i += 1;
        i;
    }
    SetPlayerHitPoints(pnum, 0 as libc::c_int);
    StartPlayerKill(pnum, earflag);
}
#[no_mangle]
pub unsafe extern "C" fn SyncPlrKill(mut pnum: libc::c_int, mut earflag: int8_t) {
    if !((pnum as uint32_t) < MAX_PLRS as libc::c_int as uint32_t) {
        assert_fail(
            1995 as libc::c_int,
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)pnum < MAX_PLRS\0" as *const u8 as *const libc::c_char,
        );
    }
    StartPlayerKill(pnum, earflag);
}
#[no_mangle]
pub unsafe extern "C" fn RemovePlrMissiles(mut pnum: libc::c_int) {
    let mut i: libc::c_int = 0;
    let mut mx: libc::c_int = 0;
    if currlevel as libc::c_int != 0 as libc::c_int && pnum == myplr
        && (monster[myplr as usize]._mx != 1 as libc::c_int
            || monster[myplr as usize]._my != 0 as libc::c_int)
    {
        M_StartKill(myplr, myplr);
        AddDead(
            monster[myplr as usize]._mx,
            monster[myplr as usize]._my,
            (*monster[myplr as usize].MType).mdeadval,
            monster[myplr as usize]._mdir,
        );
        dMonster[monster[myplr as usize]._mx
            as usize][monster[myplr as usize]._my as usize] = 0 as libc::c_int;
        monster[myplr as usize]._mDelFlag = 1 as libc::c_int as bool32_t;
        DeleteMonsterList();
    }
    i = 0 as libc::c_int;
    while i < nummissiles {
        mx = missileactive[i as usize];
        if missile[mx as usize]._mitype == MIT_STONE as libc::c_int
            && missile[mx as usize]._misource == pnum
        {
            monster[missile[mx as usize]._miVar2 as usize]
                ._mmode = missile[mx as usize]._miVar1;
        }
        if missile[mx as usize]._mitype == MIT_MANASHIELD as libc::c_int
            && missile[mx as usize]._misource == pnum
        {
            ClearMissileSpot(mx);
            DeleteMissile(mx, i);
        }
        if missile[mx as usize]._mitype == MIT_ETHER as libc::c_int
            && missile[mx as usize]._misource == pnum
        {
            ClearMissileSpot(mx);
            DeleteMissile(mx, i);
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn InitLevelChange(mut pnum: libc::c_int) {
    RemovePlrMissiles(pnum);
    if pnum == myplr && qtextflag as libc::c_int != 0 {
        qtextflag = 0 as libc::c_int as uint8_t;
        stream_stop();
    }
    RemovePlrFromMap(pnum);
    SetPlayerOld(pnum);
    if pnum == myplr {
        dPlayer[plr[myplr as usize]._px
            as usize][plr[myplr as usize]._py
            as usize] = (1 as libc::c_int + myplr) as int8_t;
    } else {
        plr[pnum as usize]
            ._pLvlVisited[plr[pnum as usize].plrlevel
            as usize] = 1 as libc::c_int as uint8_t;
    }
    ClrPlrPath(pnum);
    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
    plr[pnum as usize]._pLvlChanging = 1 as libc::c_int as uint8_t;
    if pnum == myplr {
        plr[pnum as usize].pLvlLoad = LVLCHANGE_TIME as libc::c_int as uint8_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn PostLevelChange(mut fom: libc::c_int) {
    let mut event: SDL_Event = SDL_Event { type_0: 0 };
    memset(
        &mut event as *mut SDL_Event as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<SDL_Event>() as libc::c_ulong,
    );
    event.type_0 = SDL_USEREVENT as libc::c_int as Uint32;
    event.user.code = fom;
    SDL_PushEvent(&mut event);
}
#[no_mangle]
pub unsafe extern "C" fn StartNewLvl(
    mut pnum: libc::c_int,
    mut fom: libc::c_int,
    mut lvl: libc::c_int,
) {
    InitLevelChange(pnum);
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2064 as libc::c_int,
            b"StartNewLvl: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    match fom {
        32770 | 32771 | 32775 => {
            plr[pnum as usize].plrlevel = lvl;
        }
        32776 => {
            plr[myplr as usize]
                .pTownWarps = (plr[myplr as usize].pTownWarps as libc::c_int
                | (1 as libc::c_int) << leveltype as libc::c_int - 2 as libc::c_int)
                as uint8_t;
            plr[pnum as usize].plrlevel = lvl;
        }
        32777 => {}
        32772 => {
            if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
                assert_fail(
                    2086 as libc::c_int,
                    b"src/player.c\0" as *const u8 as *const libc::c_char,
                    b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
                );
            }
            plr[pnum as usize].plrlevel = lvl;
        }
        32773 => {
            setlvlnum = lvl as uint8_t;
            if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
                assert_fail(
                    2092 as libc::c_int,
                    b"src/player.c\0" as *const u8 as *const libc::c_char,
                    b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
                );
            }
        }
        _ => {
            app_fatal_(
                b"src/player.c\0" as *const u8 as *const libc::c_char,
                2096 as libc::c_int,
                b"StartNewLvl\0" as *const u8 as *const libc::c_char,
            );
        }
    }
    if pnum == myplr {
        plr[pnum as usize]._pmode = PM_NEWLVL as libc::c_int;
        plr[pnum as usize]._pInvincible = 1 as libc::c_int as uint8_t;
        PostLevelChange(fom);
        if gbMaxPlayers as libc::c_int > 1 as libc::c_int {
            NetSendCmdParam2(
                1 as libc::c_int as bool32_t,
                CMD_NEWLVL as libc::c_int as uint8_t,
                fom as uint16_t,
                lvl as uint16_t,
            );
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn RestartTownLvl(mut pnum: libc::c_int) {
    InitLevelChange(pnum);
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2114 as libc::c_int,
            b"RestartTownLvl: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize].plrlevel = 0 as libc::c_int;
    plr[pnum as usize]._pInvincible = 0 as libc::c_int as uint8_t;
    SetPlayerHitPoints(pnum, (1 as libc::c_int) << HP_SHIFT as libc::c_int);
    plr[pnum as usize]._pMana = 0 as libc::c_int;
    plr[pnum as usize]
        ._pManaBase = plr[pnum as usize]._pMana
        - (plr[pnum as usize]._pMaxMana - plr[pnum as usize]._pMaxManaBase);
    CalcPlrInv(pnum, 0 as libc::c_int as bool32_t);
    if pnum == myplr {
        plr[pnum as usize]._pmode = PM_NEWLVL as libc::c_int;
        plr[pnum as usize]._pInvincible = 1 as libc::c_int as uint8_t;
        PostLevelChange(EVENT_DIABRETOWN as libc::c_int);
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartWarpLvl(mut pnum: libc::c_int, mut pidx: libc::c_int) {
    InitLevelChange(pnum);
    if gbMaxPlayers as libc::c_int != 1 as libc::c_int {
        if plr[pnum as usize].plrlevel != 0 as libc::c_int {
            plr[pnum as usize].plrlevel = 0 as libc::c_int;
        } else {
            plr[pnum as usize].plrlevel = portal[pidx as usize].level;
        }
    }
    if pnum == myplr {
        SetCurrentPortal(pidx);
        plr[pnum as usize]._pmode = PM_NEWLVL as libc::c_int;
        plr[pnum as usize]._pInvincible = 1 as libc::c_int as uint8_t;
        PostLevelChange(EVENT_DIABWARPLVL as libc::c_int);
    }
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoStand(mut pnum: libc::c_int) -> libc::c_int {
    return RUN_DONE as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoWalk(mut pnum: libc::c_int) -> libc::c_int {
    let mut rv: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2160 as libc::c_int,
            b"PM_DoWalk: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pAnimFrame == 3 as libc::c_int
        || plr[pnum as usize]._pWFrames == 8 as libc::c_int
            && plr[pnum as usize]._pAnimFrame == 7 as libc::c_int
        || plr[pnum as usize]._pWFrames != 8 as libc::c_int
            && plr[pnum as usize]._pAnimFrame == 4 as libc::c_int
    {
        PlaySfxLoc(
            PS_WALK1 as libc::c_int,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
        );
    }
    let mut l: libc::c_int = 8 as libc::c_int;
    if currlevel as libc::c_int != 0 as libc::c_int {
        l = PlrWalkLenTbl[plr[pnum as usize]._pClass as usize];
    }
    if plr[pnum as usize]._pVar8 == l {
        dPlayer[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py as usize] = 0 as libc::c_int as int8_t;
        plr[pnum as usize]._px += plr[pnum as usize]._pVar1;
        plr[pnum as usize]._py += plr[pnum as usize]._pVar2;
        dPlayer[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py
            as usize] = (1 as libc::c_int + pnum as int8_t as libc::c_int) as int8_t;
        if leveltype as libc::c_int != 0 as libc::c_int {
            ChangeLightXY(
                plr[pnum as usize]._plid,
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
            );
            ChangeVisionXY(
                plr[pnum as usize]._pvid,
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
            );
        }
        if pnum == myplr {
            if ScrollInfo._sdir != SCRL_NONE as libc::c_int {
                ViewX = plr[pnum as usize]._px - ScrollInfo._sdx;
                ViewY = plr[pnum as usize]._py - ScrollInfo._sdy;
            }
        }
        if plr[pnum as usize].walkpath[0 as libc::c_int as usize] as libc::c_int
            != PCMD_NOTHING as libc::c_int
        {
            StartWalkStand(pnum);
        } else {
            StartStand(pnum, plr[pnum as usize]._pVar3);
        }
        ClearPlrPVars(pnum);
        if leveltype as libc::c_int != 0 as libc::c_int {
            ChangeLightOff(plr[pnum as usize]._plid, 0 as libc::c_int, 0 as libc::c_int);
        }
        rv = RUN_AGAIN as libc::c_int;
    } else {
        PM_ChangeOffset(pnum);
        rv = RUN_DONE as libc::c_int;
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoWalk2(mut pnum: libc::c_int) -> libc::c_int {
    let mut rv: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2213 as libc::c_int,
            b"PM_DoWalk2: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pAnimFrame == 3 as libc::c_int
        || plr[pnum as usize]._pWFrames == 8 as libc::c_int
            && plr[pnum as usize]._pAnimFrame == 7 as libc::c_int
        || plr[pnum as usize]._pWFrames != 8 as libc::c_int
            && plr[pnum as usize]._pAnimFrame == 4 as libc::c_int
    {
        PlaySfxLoc(
            PS_WALK1 as libc::c_int,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
        );
    }
    let mut l: libc::c_int = 8 as libc::c_int;
    if currlevel as libc::c_int != 0 as libc::c_int {
        l = PlrWalkLenTbl[plr[pnum as usize]._pClass as usize];
    }
    if plr[pnum as usize]._pVar8 == l {
        dPlayer[plr[pnum as usize]._pVar1
            as usize][plr[pnum as usize]._pVar2 as usize] = 0 as libc::c_int as int8_t;
        if leveltype as libc::c_int != 0 as libc::c_int {
            ChangeLightXY(
                plr[pnum as usize]._plid,
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
            );
            ChangeVisionXY(
                plr[pnum as usize]._pvid,
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
            );
        }
        if pnum == myplr {
            if ScrollInfo._sdir != SCRL_NONE as libc::c_int {
                ViewX = plr[pnum as usize]._px - ScrollInfo._sdx;
                ViewY = plr[pnum as usize]._py - ScrollInfo._sdy;
            }
        }
        if plr[pnum as usize].walkpath[0 as libc::c_int as usize] as libc::c_int
            != PCMD_NOTHING as libc::c_int
        {
            StartWalkStand(pnum);
        } else {
            StartStand(pnum, plr[pnum as usize]._pVar3);
        }
        ClearPlrPVars(pnum);
        if leveltype as libc::c_int != 0 as libc::c_int {
            ChangeLightOff(plr[pnum as usize]._plid, 0 as libc::c_int, 0 as libc::c_int);
        }
        rv = RUN_AGAIN as libc::c_int;
    } else {
        PM_ChangeOffset(pnum);
        rv = RUN_DONE as libc::c_int;
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoWalk3(mut pnum: libc::c_int) -> libc::c_int {
    let mut rv: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2263 as libc::c_int,
            b"PM_DoWalk3: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pAnimFrame == 3 as libc::c_int
        || plr[pnum as usize]._pWFrames == 8 as libc::c_int
            && plr[pnum as usize]._pAnimFrame == 7 as libc::c_int
        || plr[pnum as usize]._pWFrames != 8 as libc::c_int
            && plr[pnum as usize]._pAnimFrame == 4 as libc::c_int
    {
        PlaySfxLoc(
            PS_WALK1 as libc::c_int,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
        );
    }
    let mut l: libc::c_int = 8 as libc::c_int;
    if currlevel as libc::c_int != 0 as libc::c_int {
        l = PlrWalkLenTbl[plr[pnum as usize]._pClass as usize];
    }
    if plr[pnum as usize]._pVar8 == l {
        dPlayer[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py as usize] = 0 as libc::c_int as int8_t;
        dFlags[plr[pnum as usize]._pVar4
            as usize][plr[pnum as usize]._pVar5
            as usize] = (dFlags[plr[pnum as usize]._pVar4
            as usize][plr[pnum as usize]._pVar5 as usize] as libc::c_int
            & BFMASK_PLRLR as libc::c_int) as int8_t;
        plr[pnum as usize]._px = plr[pnum as usize]._pVar1;
        plr[pnum as usize]._py = plr[pnum as usize]._pVar2;
        dPlayer[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py
            as usize] = (1 as libc::c_int + pnum as int8_t as libc::c_int) as int8_t;
        if leveltype as libc::c_int != 0 as libc::c_int {
            ChangeLightXY(
                plr[pnum as usize]._plid,
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
            );
            ChangeVisionXY(
                plr[pnum as usize]._pvid,
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
            );
        }
        if pnum == myplr {
            if ScrollInfo._sdir != SCRL_NONE as libc::c_int {
                ViewX = plr[pnum as usize]._px - ScrollInfo._sdx;
                ViewY = plr[pnum as usize]._py - ScrollInfo._sdy;
            }
        }
        if plr[pnum as usize].walkpath[0 as libc::c_int as usize] as libc::c_int
            != PCMD_NOTHING as libc::c_int
        {
            StartWalkStand(pnum);
        } else {
            StartStand(pnum, plr[pnum as usize]._pVar3);
        }
        ClearPlrPVars(pnum);
        if leveltype as libc::c_int != 0 as libc::c_int {
            ChangeLightOff(plr[pnum as usize]._plid, 0 as libc::c_int, 0 as libc::c_int);
        }
        rv = RUN_AGAIN as libc::c_int;
    } else {
        PM_ChangeOffset(pnum);
        rv = RUN_DONE as libc::c_int;
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn WeaponDur(
    mut pnum: libc::c_int,
    mut durrnd: libc::c_int,
) -> bool32_t {
    if pnum != myplr {
        return 0 as libc::c_int as bool32_t;
    }
    if random_(
        b"src/player.c\0" as *const u8 as *const libc::c_char,
        2319 as libc::c_int,
        3 as libc::c_int as uint8_t,
        durrnd,
    ) != 0
    {
        return 0 as libc::c_int as bool32_t;
    }
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2324 as libc::c_int,
            b"WeaponDur: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._itype
        != -(1 as libc::c_int)
        && plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iClass
            as libc::c_int == IC_WEAP as libc::c_int
    {
        if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            == INFINITE_DUR as libc::c_int
        {
            return 0 as libc::c_int as bool32_t;
        }
        plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            -= 1;
        plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability;
        if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            == 0 as libc::c_int
        {
            NetSendCmdDelItem(
                1 as libc::c_int as bool32_t,
                INVLOC_HAND1 as libc::c_int as uint8_t,
            );
            plr[pnum as usize]
                .InvBody[INVLOC_HAND1 as libc::c_int as usize]
                ._itype = -(1 as libc::c_int);
            CalcPlrInv(pnum, 1 as libc::c_int as bool32_t);
            return 1 as libc::c_int as bool32_t;
        }
    }
    if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._itype
        != -(1 as libc::c_int)
        && plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iClass
            as libc::c_int == IC_WEAP as libc::c_int
    {
        if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            == INFINITE_DUR as libc::c_int
        {
            return 0 as libc::c_int as bool32_t;
        }
        plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            -= 1;
        plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability;
        if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            == 0 as libc::c_int
        {
            NetSendCmdDelItem(
                1 as libc::c_int as bool32_t,
                INVLOC_HAND2 as libc::c_int as uint8_t,
            );
            plr[pnum as usize]
                .InvBody[INVLOC_HAND2 as libc::c_int as usize]
                ._itype = -(1 as libc::c_int);
            CalcPlrInv(pnum, 1 as libc::c_int as bool32_t);
            return 1 as libc::c_int as bool32_t;
        }
    }
    if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._itype
        == -(1 as libc::c_int)
        && plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._itype
            == IT_SHIELD as libc::c_int
    {
        if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            == INFINITE_DUR as libc::c_int
        {
            return 0 as libc::c_int as bool32_t;
        }
        plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            -= 1;
        plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability;
        if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            == 0 as libc::c_int
        {
            NetSendCmdDelItem(
                1 as libc::c_int as bool32_t,
                INVLOC_HAND2 as libc::c_int as uint8_t,
            );
            plr[pnum as usize]
                .InvBody[INVLOC_HAND2 as libc::c_int as usize]
                ._itype = -(1 as libc::c_int);
            CalcPlrInv(pnum, 1 as libc::c_int as bool32_t);
            return 1 as libc::c_int as bool32_t;
        }
    }
    if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._itype
        == -(1 as libc::c_int)
        && plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._itype
            == IT_SHIELD as libc::c_int
    {
        if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            == INFINITE_DUR as libc::c_int
        {
            return 0 as libc::c_int as bool32_t;
        }
        plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            -= 1;
        plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability;
        if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            == 0 as libc::c_int
        {
            NetSendCmdDelItem(
                1 as libc::c_int as bool32_t,
                INVLOC_HAND1 as libc::c_int as uint8_t,
            );
            plr[pnum as usize]
                .InvBody[INVLOC_HAND1 as libc::c_int as usize]
                ._itype = -(1 as libc::c_int);
            CalcPlrInv(pnum, 1 as libc::c_int as bool32_t);
            return 1 as libc::c_int as bool32_t;
        }
    }
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn PlrHitMonst(
    mut pnum: libc::c_int,
    mut m: libc::c_int,
) -> bool32_t {
    let mut hit: libc::c_int = 0;
    let mut hper: libc::c_int = 0 as libc::c_int;
    let mut mind: libc::c_int = 0;
    let mut maxd: libc::c_int = 0;
    let mut dam: int32_t = 0;
    let mut skdam: int32_t = 0;
    let mut phanditype: libc::c_int = 0;
    let mut tmac: libc::c_int = 0;
    let mut rv: bool32_t = 0;
    let mut ret: bool32_t = 0;
    if m as uint32_t >= MAXMONSTERS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2388 as libc::c_int,
            b"PlrHitMonst: illegal monster %d\0" as *const u8 as *const libc::c_char,
            m,
        );
    }
    if monster[m as usize]._mhitpoints >> HP_SHIFT as libc::c_int <= 0 as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if (*monster[m as usize].MType).mtype as libc::c_int == MT_ILLWEAV as libc::c_int
        && monster[m as usize]._mgoal as libc::c_int == MG_RUN_AWAY as libc::c_int
    {
        return 0 as libc::c_int as bool32_t;
    }
    if monster[m as usize]._mmode == MM_MISSILE as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2404 as libc::c_int,
            b"PlrHitMonst: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    rv = 0 as libc::c_int as bool32_t;
    hit = random_(
        b"src/player.c\0" as *const u8 as *const libc::c_char,
        2409 as libc::c_int,
        4 as libc::c_int as uint8_t,
        100 as libc::c_int,
    );
    if monster[m as usize]._mmode == MM_STONE as libc::c_int {
        hit = 0 as libc::c_int;
    }
    tmac = monster[m as usize].mArmorClass as libc::c_int - plr[pnum as usize]._pIEnAc;
    hper = BASE_TO_HIT as libc::c_int + plr[pnum as usize]._pLevel as libc::c_int - tmac
        + (plr[pnum as usize]._pDexterity >> 1 as libc::c_int);
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        hper += 20 as libc::c_int;
    }
    hper += plr[pnum as usize]._pIBonusToHit;
    if hper < 5 as libc::c_int {
        hper = 5 as libc::c_int;
    }
    if hper > 95 as libc::c_int {
        hper = 95 as libc::c_int;
    }
    let mut cond: bool32_t = (hit < hper) as libc::c_int as bool32_t;
    if CHEATS as libc::c_int != 0 {
        cond = (cond != 0 || cheatflag != 0 || simplecheat != 0) as libc::c_int
            as bool32_t;
    }
    if CheckMonsterHit(m, &mut ret) != 0 {
        return ret
    } else if cond != 0 {
        mind = plr[pnum as usize]._pIMinDam;
        maxd = plr[pnum as usize]._pIMaxDam;
        dam = random_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2434 as libc::c_int,
            5 as libc::c_int as uint8_t,
            maxd - mind + 1 as libc::c_int,
        ) + mind;
        dam += dam * plr[pnum as usize]._pIBonusDam / 100 as libc::c_int;
        dam += plr[pnum as usize]._pIBonusDamMod;
        dam += plr[pnum as usize]._pDamageMod;
        if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            let mut ddp: libc::c_int = plr[pnum as usize]._pLevel as libc::c_int;
            let mut doubledam: libc::c_int = random_(
                b"src/player.c\0" as *const u8 as *const libc::c_char,
                2441 as libc::c_int,
                6 as libc::c_int as uint8_t,
                100 as libc::c_int,
            );
            if doubledam < ddp {
                dam = dam << 1 as libc::c_int;
            }
        }
        phanditype = -(1 as libc::c_int);
        if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._itype
            == IT_SWORD as libc::c_int
            || plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._itype
                == IT_SWORD as libc::c_int
        {
            phanditype = IT_SWORD as libc::c_int;
        }
        if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._itype
            == IT_MACE as libc::c_int
            || plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._itype
                == IT_MACE as libc::c_int
        {
            phanditype = IT_MACE as libc::c_int;
        }
        match (*monster[m as usize].MData).mMonstClass as libc::c_int {
            0 => {
                if phanditype == IT_SWORD as libc::c_int {
                    dam -= dam >> 1 as libc::c_int;
                }
                if phanditype == IT_MACE as libc::c_int {
                    dam += dam >> 1 as libc::c_int;
                }
            }
            2 => {
                if phanditype == IT_MACE as libc::c_int {
                    dam -= dam >> 1 as libc::c_int;
                }
                if phanditype == IT_SWORD as libc::c_int {
                    dam += dam >> 1 as libc::c_int;
                }
            }
            _ => {}
        }
        if plr[pnum as usize]._pIFlags & IAF_DAMDEMON as libc::c_int != 0
            && (*monster[m as usize].MData).mMonstClass as libc::c_int
                == MC_DEMON as libc::c_int
        {
            dam += dam << 1 as libc::c_int;
        }
        dam = dam << HP_SHIFT as libc::c_int;
        if pnum == myplr {
            monster[m as usize]._mhitpoints -= dam;
        }
        if plr[pnum as usize]._pIFlags & IAF_SKING as libc::c_int != 0 {
            skdam = random_(
                b"src/player.c\0" as *const u8 as *const libc::c_char,
                2482 as libc::c_int,
                7 as libc::c_int as uint8_t,
                dam >> 3 as libc::c_int,
            );
            plr[pnum as usize]._pHitPoints += skdam;
            if plr[pnum as usize]._pHitPoints > plr[pnum as usize]._pMaxHP {
                plr[pnum as usize]._pHitPoints = plr[pnum as usize]._pMaxHP;
            }
            plr[pnum as usize]._pHPBase += skdam;
            if plr[pnum as usize]._pHPBase > plr[pnum as usize]._pMaxHPBase {
                plr[pnum as usize]._pHPBase = plr[pnum as usize]._pMaxHPBase;
            }
            drawhpflag = 1 as libc::c_int as bool32_t;
        }
        if plr[pnum as usize]._pIFlags & IAF_ALLBAT as libc::c_int != 0
            && plr[pnum as usize]._pIFlags & IAF_LMANA as libc::c_int == 0
        {
            if plr[pnum as usize]._pIFlags & IAF_BAT10 as libc::c_int != 0 {
                skdam = dam * 3 as libc::c_int / 100 as libc::c_int;
            }
            if plr[pnum as usize]._pIFlags & IAF_BAT20 as libc::c_int != 0 {
                skdam = dam * 5 as libc::c_int / 100 as libc::c_int;
            }
            plr[pnum as usize]._pMana += skdam;
            if plr[pnum as usize]._pMana > plr[pnum as usize]._pMaxMana {
                plr[pnum as usize]._pMana = plr[pnum as usize]._pMaxMana;
            }
            plr[pnum as usize]._pManaBase += skdam;
            if plr[pnum as usize]._pManaBase > plr[pnum as usize]._pMaxManaBase {
                plr[pnum as usize]._pManaBase = plr[pnum as usize]._pMaxManaBase;
            }
            drawmanaflag = 1 as libc::c_int as bool32_t;
        }
        if plr[pnum as usize]._pIFlags & IAF_ALLLEECH as libc::c_int != 0 {
            if plr[pnum as usize]._pIFlags & IAF_LEECH10 as libc::c_int != 0 {
                skdam = dam * 3 as libc::c_int / 100 as libc::c_int;
            }
            if plr[pnum as usize]._pIFlags & IAF_LEECH20 as libc::c_int != 0 {
                skdam = dam * 5 as libc::c_int / 100 as libc::c_int;
            }
            plr[pnum as usize]._pHitPoints += skdam;
            if plr[pnum as usize]._pHitPoints > plr[pnum as usize]._pMaxHP {
                plr[pnum as usize]._pHitPoints = plr[pnum as usize]._pMaxHP;
            }
            plr[pnum as usize]._pHPBase += skdam;
            if plr[pnum as usize]._pHPBase > plr[pnum as usize]._pMaxHPBase {
                plr[pnum as usize]._pHPBase = plr[pnum as usize]._pMaxHPBase;
            }
            drawhpflag = 1 as libc::c_int as bool32_t;
        }
        if plr[pnum as usize]._pIFlags & IAF_NOHEAL as libc::c_int != 0 {
            monster[m as usize]._mFlags |= MFLAG_NOHEAL as libc::c_int as uint32_t;
        }
        if CHEATS as libc::c_int != 0 {
            if simplecheat != 0 || cheatflag != 0 {
                monster[m as usize]._mhitpoints = 0 as libc::c_int;
            }
        }
        if monster[m as usize]._mhitpoints >> HP_SHIFT as libc::c_int <= 0 as libc::c_int
        {
            if monster[m as usize]._mmode == MM_STONE as libc::c_int {
                M_StartKill(m, pnum);
                monster[m as usize]._mmode = MM_STONE as libc::c_int;
            } else {
                M_StartKill(m, pnum);
            }
        } else if monster[m as usize]._mmode == MM_STONE as libc::c_int {
            M_StartHit(m, pnum, dam);
            monster[m as usize]._mmode = MM_STONE as libc::c_int;
        } else {
            if plr[pnum as usize]._pIFlags & IAF_KNOCKBACK as libc::c_int != 0 {
                M_GetKnockback(m);
            }
            M_StartHit(m, pnum, dam);
        }
        rv = 1 as libc::c_int as bool32_t;
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn PlrHitPlr(mut pnum: libc::c_int, mut p: int8_t) -> bool32_t {
    let mut hit: libc::c_int = 0;
    let mut hper: libc::c_int = 0;
    let mut mind: libc::c_int = 0;
    let mut maxd: libc::c_int = 0;
    let mut doubledam: libc::c_int = 0;
    let mut ddp: libc::c_int = 0;
    let mut dam: int32_t = 0;
    let mut skdam: int32_t = 0;
    let mut tac: libc::c_int = 0;
    let mut blk: libc::c_int = 0;
    let mut blkper: libc::c_int = 0;
    let mut blkdir: libc::c_int = 0;
    let mut rv: bool32_t = 0;
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2569 as libc::c_int,
            b"PlrHitPlr: illegal target player %d\0" as *const u8 as *const libc::c_char,
            p as libc::c_int,
        );
    }
    rv = 0 as libc::c_int as bool32_t;
    if plr[p as usize]._pInvincible != 0 {
        return rv;
    }
    if plr[p as usize]._pSpellFlags as libc::c_int & SF_ETHER as libc::c_int
        != 0 as libc::c_int
    {
        return rv;
    }
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2581 as libc::c_int,
            b"PlrHitPlr: illegal attacking player %d\0" as *const u8
                as *const libc::c_char,
            pnum,
        );
    }
    hit = random_(
        b"src/player.c\0" as *const u8 as *const libc::c_char,
        2585 as libc::c_int,
        4 as libc::c_int as uint8_t,
        100 as libc::c_int,
    );
    tac = plr[p as usize]._pIAC + plr[p as usize]._pIBonusAC;
    tac += plr[p as usize]._pDexterity / 5 as libc::c_int;
    hper = BASE_TO_HIT as libc::c_int + plr[pnum as usize]._pLevel as libc::c_int - tac
        + (plr[pnum as usize]._pDexterity >> 1 as libc::c_int);
    if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        hper += 20 as libc::c_int;
    }
    hper += plr[pnum as usize]._pIBonusToHit;
    if hper < 5 as libc::c_int {
        hper = 5 as libc::c_int;
    }
    if hper > 95 as libc::c_int {
        hper = 95 as libc::c_int;
    }
    if (plr[p as usize]._pmode == PM_STAND as libc::c_int
        || plr[p as usize]._pmode == PM_ATTACK as libc::c_int)
        && plr[p as usize]._pBlockFlag as libc::c_int != 0
    {
        blk = random_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2601 as libc::c_int,
            5 as libc::c_int as uint8_t,
            100 as libc::c_int,
        );
    } else {
        blk = 100 as libc::c_int;
    }
    blkper = plr[p as usize]._pBaseToBlk + plr[p as usize]._pDexterity
        - ((plr[pnum as usize]._pLevel as libc::c_int
            - plr[p as usize]._pLevel as libc::c_int) << 1 as libc::c_int);
    if blkper < 0 as libc::c_int {
        blkper = 0 as libc::c_int;
    }
    if blkper > 100 as libc::c_int {
        blkper = 100 as libc::c_int;
    }
    if hit < hper {
        if blk < blkper {
            blkdir = GetDirection(
                plr[p as usize]._px,
                plr[p as usize]._py,
                plr[pnum as usize]._px,
                plr[pnum as usize]._py,
            );
            StartPlrBlock(p as libc::c_int, blkdir);
        } else {
            mind = plr[pnum as usize]._pIMinDam;
            maxd = plr[pnum as usize]._pIMaxDam;
            dam = random_(
                b"src/player.c\0" as *const u8 as *const libc::c_char,
                2619 as libc::c_int,
                5 as libc::c_int as uint8_t,
                maxd - mind + 1 as libc::c_int,
            ) + mind;
            dam += dam * plr[pnum as usize]._pIBonusDam / 100 as libc::c_int;
            dam += plr[pnum as usize]._pIBonusDamMod + plr[pnum as usize]._pDamageMod;
            if plr[pnum as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int
            {
                ddp = plr[pnum as usize]._pLevel as libc::c_int;
                doubledam = random_(
                    b"src/player.c\0" as *const u8 as *const libc::c_char,
                    2625 as libc::c_int,
                    6 as libc::c_int as uint8_t,
                    100 as libc::c_int,
                );
                if doubledam < ddp {
                    dam = dam << 1 as libc::c_int;
                }
            }
            dam = dam << HP_SHIFT as libc::c_int;
            if plr[pnum as usize]._pIFlags & IAF_SKING as libc::c_int != 0 {
                skdam = random_(
                    b"src/player.c\0" as *const u8 as *const libc::c_char,
                    2632 as libc::c_int,
                    7 as libc::c_int as uint8_t,
                    dam >> 3 as libc::c_int,
                );
                plr[pnum as usize]._pHitPoints += skdam;
                if plr[pnum as usize]._pHitPoints > plr[pnum as usize]._pMaxHP {
                    plr[pnum as usize]._pHitPoints = plr[pnum as usize]._pMaxHP;
                }
                plr[pnum as usize]._pHPBase += skdam;
                if plr[pnum as usize]._pHPBase > plr[pnum as usize]._pMaxHPBase {
                    plr[pnum as usize]._pHPBase = plr[pnum as usize]._pMaxHPBase;
                }
                drawhpflag = 1 as libc::c_int as bool32_t;
            }
            if pnum == myplr {
                NetSendCmdDamage(
                    1 as libc::c_int as bool32_t,
                    p as uint8_t,
                    dam as uint32_t,
                );
            }
            StartPlrHit(p as libc::c_int, dam, 0 as libc::c_int as bool32_t);
        }
        rv = 1 as libc::c_int as bool32_t;
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn PlrHitObj(
    mut pnum: libc::c_int,
    mut mx: libc::c_int,
    mut my: libc::c_int,
) -> bool32_t {
    let mut oi: libc::c_int = 0;
    if dObject[mx as usize][my as usize] as libc::c_int > 0 as libc::c_int {
        oi = dObject[mx as usize][my as usize] as libc::c_int - 1 as libc::c_int;
    } else {
        oi = -(dObject[mx as usize][my as usize] as libc::c_int + 1 as libc::c_int);
    }
    if object[oi as usize]._oBreak as libc::c_int == OBJ_BREAKABLE as libc::c_int {
        BreakObject(pnum, oi);
        return 1 as libc::c_int as bool32_t;
    } else {
        return 0 as libc::c_int as bool32_t
    };
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoAttack(mut pnum: libc::c_int) -> libc::c_int {
    let mut dx: libc::c_int = 0;
    let mut dy: libc::c_int = 0;
    let mut m: libc::c_int = 0;
    let mut p: int8_t = 0;
    let mut didhit: bool32_t = 0 as libc::c_int as bool32_t;
    let mut frame: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2676 as libc::c_int,
            b"PM_DoAttack: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    frame = plr[pnum as usize]._pAnimFrame;
    if plr[pnum as usize]._pIFlags & IAF_ATANIM1 as libc::c_int != 0
        && frame == 1 as libc::c_int
    {
        plr[pnum as usize]._pAnimFrame += 1;
        plr[pnum as usize]._pAnimFrame;
    }
    if plr[pnum as usize]._pIFlags & IAF_ATANIM2 as libc::c_int != 0
        && (frame == 1 as libc::c_int || frame == 3 as libc::c_int)
    {
        plr[pnum as usize]._pAnimFrame += 1;
        plr[pnum as usize]._pAnimFrame;
    }
    if plr[pnum as usize]._pIFlags & IAF_ATANIM3 as libc::c_int != 0
        && (frame == 1 as libc::c_int || frame == 3 as libc::c_int
            || frame == 5 as libc::c_int)
    {
        plr[pnum as usize]._pAnimFrame += 1;
        plr[pnum as usize]._pAnimFrame;
    }
    if plr[pnum as usize]._pIFlags & IAF_ATANIM4 as libc::c_int != 0
        && (frame == 1 as libc::c_int || frame == 4 as libc::c_int)
    {
        plr[pnum as usize]._pAnimFrame += 2 as libc::c_int;
    }
    if plr[pnum as usize]._pAnimFrame == plr[pnum as usize]._pAFNum - 1 as libc::c_int {
        PlaySfxLoc(
            PS_SWING as libc::c_int,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
        );
    }
    if plr[pnum as usize]._pAnimFrame == plr[pnum as usize]._pAFNum {
        dx = plr[pnum as usize]._px + offset_x[plr[pnum as usize]._pdir as usize];
        dy = plr[pnum as usize]._py + offset_y[plr[pnum as usize]._pdir as usize];
        if dMonster[dx as usize][dy as usize] != 0 as libc::c_int {
            if dMonster[dx as usize][dy as usize] > 0 as libc::c_int {
                m = dMonster[dx as usize][dy as usize] - 1 as libc::c_int;
            } else {
                m = -(dMonster[dx as usize][dy as usize] + 1 as libc::c_int);
            }
            if CanTalkToMonst(m) != 0 {
                plr[pnum as usize]._pVar1 = 0 as libc::c_int;
                return RUN_DONE as libc::c_int;
            }
        }
        if plr[pnum as usize]._pIFlags & IAF_FIREHIT as libc::c_int != 0 {
            AddMissile(
                dx,
                dy,
                1 as libc::c_int,
                0 as libc::c_int,
                0 as libc::c_int,
                MIT_WEAPEXP as libc::c_int,
                MI_ENEMYMONST as libc::c_int as int8_t,
                pnum,
                0 as libc::c_int,
                0 as libc::c_int,
            );
        }
        if plr[pnum as usize]._pIFlags & IAF_LIGHTHIT as libc::c_int != 0 {
            AddMissile(
                dx,
                dy,
                2 as libc::c_int,
                0 as libc::c_int,
                0 as libc::c_int,
                MIT_WEAPEXP as libc::c_int,
                MI_ENEMYMONST as libc::c_int as int8_t,
                pnum,
                0 as libc::c_int,
                0 as libc::c_int,
            );
        }
        if dMonster[dx as usize][dy as usize] != 0 as libc::c_int {
            if dMonster[dx as usize][dy as usize] > 0 as libc::c_int {
                m = dMonster[dx as usize][dy as usize] - 1 as libc::c_int;
            } else {
                m = -(dMonster[dx as usize][dy as usize] + 1 as libc::c_int);
            }
            didhit = PlrHitMonst(pnum, m);
        } else if dPlayer[dx as usize][dy as usize] as libc::c_int != 0 as libc::c_int
            && FriendlyMode == 0
        {
            if dPlayer[dx as usize][dy as usize] as libc::c_int > 0 as libc::c_int {
                p = (dPlayer[dx as usize][dy as usize] as libc::c_int - 1 as libc::c_int)
                    as int8_t;
            } else {
                p = -(dPlayer[dx as usize][dy as usize] as libc::c_int
                    + 1 as libc::c_int) as int8_t;
            }
            didhit = PlrHitPlr(pnum, p);
        } else if dObject[dx as usize][dy as usize] as libc::c_int > 0 as libc::c_int {
            didhit = PlrHitObj(pnum, dx, dy);
        }
        if didhit != 0 {
            if WeaponDur(pnum, 30 as libc::c_int) != 0 {
                StartStand(pnum, plr[pnum as usize]._pdir);
                ClearPlrPVars(pnum);
                return RUN_AGAIN as libc::c_int;
            }
        }
    }
    if plr[pnum as usize]._pAnimFrame == plr[pnum as usize]._pAFrames {
        StartStand(pnum, plr[pnum as usize]._pdir);
        ClearPlrPVars(pnum);
        return RUN_AGAIN as libc::c_int;
    } else {
        return RUN_DONE as libc::c_int
    };
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoRangeAttack(mut pnum: libc::c_int) -> libc::c_int {
    let mut mistype: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2767 as libc::c_int,
            b"PM_DoRangeAttack: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    let mut origFrame: libc::c_int = plr[pnum as usize]._pAnimFrame;
    if plr[pnum as usize]._pIFlags & IAF_ATANIM1 as libc::c_int != 0
        && origFrame == 1 as libc::c_int
    {
        plr[pnum as usize]._pAnimFrame += 1;
        plr[pnum as usize]._pAnimFrame;
    }
    if plr[pnum as usize]._pIFlags & IAF_ATANIM2 as libc::c_int != 0
        && (origFrame == 1 as libc::c_int || origFrame == 3 as libc::c_int)
    {
        plr[pnum as usize]._pAnimFrame += 1;
        plr[pnum as usize]._pAnimFrame;
    }
    if plr[pnum as usize]._pAnimFrame == plr[pnum as usize]._pAFNum {
        mistype = MIT_ARROW as libc::c_int;
        if plr[pnum as usize]._pIFlags & IAF_FIREARROW as libc::c_int != 0 {
            mistype = MIT_FARROW as libc::c_int;
        }
        if plr[pnum as usize]._pIFlags & IAF_LARROW as libc::c_int != 0 {
            mistype = MIT_LARROW as libc::c_int;
        }
        AddMissile(
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
            plr[pnum as usize]._pVar1,
            plr[pnum as usize]._pVar2,
            plr[pnum as usize]._pdir,
            mistype,
            MI_ENEMYMONST as libc::c_int as int8_t,
            pnum,
            4 as libc::c_int,
            0 as libc::c_int,
        );
        PlaySfxLoc(
            PS_BFIRE as libc::c_int,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
        );
        if WeaponDur(pnum, 40 as libc::c_int) != 0 {
            StartStand(pnum, plr[pnum as usize]._pdir);
            ClearPlrPVars(pnum);
            return RUN_AGAIN as libc::c_int;
        }
    }
    if plr[pnum as usize]._pAnimFrame >= plr[pnum as usize]._pAFrames {
        StartStand(pnum, plr[pnum as usize]._pdir);
        ClearPlrPVars(pnum);
        return RUN_AGAIN as libc::c_int;
    } else {
        return RUN_DONE as libc::c_int
    };
}
#[no_mangle]
pub unsafe extern "C" fn ShieldDur(mut pnum: libc::c_int) {
    if pnum != myplr {
        return;
    }
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2811 as libc::c_int,
            b"ShieldDur: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._itype
        == IT_SHIELD as libc::c_int
    {
        if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            == INFINITE_DUR as libc::c_int
        {
            return;
        }
        plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            -= 1;
        plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability;
        if plr[pnum as usize].InvBody[INVLOC_HAND1 as libc::c_int as usize]._iDurability
            == 0 as libc::c_int
        {
            NetSendCmdDelItem(
                1 as libc::c_int as bool32_t,
                INVLOC_HAND1 as libc::c_int as uint8_t,
            );
            plr[pnum as usize]
                .InvBody[INVLOC_HAND1 as libc::c_int as usize]
                ._itype = -(1 as libc::c_int);
            CalcPlrInv(pnum, 1 as libc::c_int as bool32_t);
        }
    }
    if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._itype
        == IT_SHIELD as libc::c_int
    {
        if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            == INFINITE_DUR as libc::c_int
        {
            return;
        }
        plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            -= 1;
        plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability;
        if plr[pnum as usize].InvBody[INVLOC_HAND2 as libc::c_int as usize]._iDurability
            == 0 as libc::c_int
        {
            NetSendCmdDelItem(
                1 as libc::c_int as bool32_t,
                INVLOC_HAND2 as libc::c_int as uint8_t,
            );
            plr[pnum as usize]
                .InvBody[INVLOC_HAND2 as libc::c_int as usize]
                ._itype = -(1 as libc::c_int);
            CalcPlrInv(pnum, 1 as libc::c_int as bool32_t);
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoBlock(mut pnum: libc::c_int) -> libc::c_int {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2841 as libc::c_int,
            b"PM_DoBlock: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pIFlags & IAF_BLANIM as libc::c_int != 0
        && plr[pnum as usize]._pAnimFrame != 1 as libc::c_int
    {
        plr[pnum as usize]._pAnimFrame = plr[pnum as usize]._pBFrames;
    }
    if plr[pnum as usize]._pAnimFrame >= plr[pnum as usize]._pBFrames {
        StartStand(pnum, plr[pnum as usize]._pdir);
        ClearPlrPVars(pnum);
        if random_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2850 as libc::c_int,
            3 as libc::c_int as uint8_t,
            10 as libc::c_int,
        ) == 0 as libc::c_int
        {
            ShieldDur(pnum);
        }
        return RUN_AGAIN as libc::c_int;
    } else {
        return RUN_DONE as libc::c_int
    };
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoSpell(mut pnum: libc::c_int) -> libc::c_int {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2861 as libc::c_int,
            b"PM_DoSpell: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pVar8 == plr[pnum as usize]._pSFNum {
        CastSpell(
            pnum,
            plr[pnum as usize]._pSpell,
            plr[pnum as usize]._px,
            plr[pnum as usize]._py,
            plr[pnum as usize]._pVar1,
            plr[pnum as usize]._pVar2,
            MI_PLR as libc::c_int,
            plr[pnum as usize]._pVar4,
        );
        if plr[pnum as usize]._pSplFrom as libc::c_int == SPL_FROMR as libc::c_int {
            if plr[pnum as usize]._pRSplType as libc::c_int == SPT_SCROLL as libc::c_int
            {
                if plr[pnum as usize]._pScrlSpells
                    & (1 as libc::c_int as uint64_t)
                        << plr[pnum as usize]._pRSpell - 1 as libc::c_int
                    == 0 as libc::c_int as uint64_t
                {
                    plr[pnum as usize]._pRSpell = -(1 as libc::c_int);
                    plr[pnum as usize]._pRSplType = SPT_NONE as libc::c_int as int8_t;
                    force_redraw = FULLDRAW as libc::c_int;
                }
            }
            if plr[pnum as usize]._pRSplType as libc::c_int == SPT_ITEM as libc::c_int {
                if plr[pnum as usize]._pISpells
                    & (1 as libc::c_int as uint64_t)
                        << plr[pnum as usize]._pRSpell - 1 as libc::c_int
                    == 0 as libc::c_int as uint64_t
                {
                    plr[pnum as usize]._pRSpell = -(1 as libc::c_int);
                    plr[pnum as usize]._pRSplType = SPT_NONE as libc::c_int as int8_t;
                    force_redraw = FULLDRAW as libc::c_int;
                }
            }
        }
    }
    plr[pnum as usize]._pVar8 += 1;
    plr[pnum as usize]._pVar8;
    if leveltype as libc::c_int == 0 as libc::c_int {
        if plr[pnum as usize]._pVar8 > plr[pnum as usize]._pSFrames {
            StartWalkStand(pnum);
            ClearPlrPVars(pnum);
            return RUN_AGAIN as libc::c_int;
        } else {
            return RUN_DONE as libc::c_int
        }
    } else if plr[pnum as usize]._pAnimFrame == plr[pnum as usize]._pSFrames {
        StartStand(pnum, plr[pnum as usize]._pdir);
        ClearPlrPVars(pnum);
        return RUN_AGAIN as libc::c_int;
    } else {
        return RUN_DONE as libc::c_int
    };
}
unsafe extern "C" fn ArmorDur(mut pnum: libc::c_int) {
    if pnum != myplr {
        return;
    }
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2909 as libc::c_int,
            b"ArmorDur: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    let mut p: *mut PlayerStruct = &mut *plr.as_mut_ptr().offset(pnum as isize)
        as *mut PlayerStruct;
    if (*p).InvBody[INVLOC_BODY as libc::c_int as usize]._itype == -(1 as libc::c_int)
        && (*p).InvBody[INVLOC_HEAD as libc::c_int as usize]._itype
            == -(1 as libc::c_int)
    {
        return;
    }
    let mut a: libc::c_int = random_(
        b"src/player.c\0" as *const u8 as *const libc::c_char,
        2918 as libc::c_int,
        8 as libc::c_int as uint8_t,
        3 as libc::c_int,
    );
    if (*p).InvBody[INVLOC_BODY as libc::c_int as usize]._itype != -(1 as libc::c_int)
        && (*p).InvBody[INVLOC_HEAD as libc::c_int as usize]._itype
            == -(1 as libc::c_int)
    {
        a = 1 as libc::c_int;
    }
    if (*p).InvBody[INVLOC_BODY as libc::c_int as usize]._itype == -(1 as libc::c_int)
        && (*p).InvBody[INVLOC_HEAD as libc::c_int as usize]._itype
            != -(1 as libc::c_int)
    {
        a = 0 as libc::c_int;
    }
    let mut pi: *mut ItemStruct = if a != 0 {
        &mut *((*p).InvBody).as_mut_ptr().offset(INVLOC_BODY as libc::c_int as isize)
            as *mut ItemStruct
    } else {
        &mut *((*p).InvBody).as_mut_ptr().offset(INVLOC_HEAD as libc::c_int as isize)
            as *mut ItemStruct
    };
    if (*pi)._iDurability == INFINITE_DUR as libc::c_int {
        return;
    }
    (*pi)._iDurability -= 1;
    (*pi)._iDurability;
    if (*pi)._iDurability == 0 as libc::c_int {
        if a != 0 {
            NetSendCmdDelItem(
                1 as libc::c_int as bool32_t,
                INVLOC_BODY as libc::c_int as uint8_t,
            );
        } else {
            NetSendCmdDelItem(
                1 as libc::c_int as bool32_t,
                INVLOC_HEAD as libc::c_int as uint8_t,
            );
        }
        (*pi)._itype = -(1 as libc::c_int);
        CalcPlrInv(pnum, 1 as libc::c_int as bool32_t);
    }
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoGotHit(mut pnum: libc::c_int) -> libc::c_int {
    let mut frame: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2948 as libc::c_int,
            b"PM_DoGotHit: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    frame = plr[pnum as usize]._pAnimFrame;
    if plr[pnum as usize]._pIFlags & IAF_HTANIM1 as libc::c_int != 0
        && frame == 3 as libc::c_int
    {
        plr[pnum as usize]._pAnimFrame += 1;
        plr[pnum as usize]._pAnimFrame;
    }
    if plr[pnum as usize]._pIFlags & IAF_HTANIM2 as libc::c_int != 0
        && (frame == 3 as libc::c_int || frame == 5 as libc::c_int)
    {
        plr[pnum as usize]._pAnimFrame += 1;
        plr[pnum as usize]._pAnimFrame;
    }
    if plr[pnum as usize]._pIFlags & IAF_HTANIM3 as libc::c_int != 0
        && (frame == 1 as libc::c_int || frame == 3 as libc::c_int
            || frame == 5 as libc::c_int)
    {
        plr[pnum as usize]._pAnimFrame += 1;
        plr[pnum as usize]._pAnimFrame;
    }
    if plr[pnum as usize]._pAnimFrame >= plr[pnum as usize]._pHFrames {
        StartStand(pnum, plr[pnum as usize]._pdir);
        ClearPlrPVars(pnum);
        if random_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2965 as libc::c_int,
            3 as libc::c_int as uint8_t,
            4 as libc::c_int,
        ) != 0
        {
            ArmorDur(pnum);
        }
        return RUN_AGAIN as libc::c_int;
    }
    return RUN_DONE as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoDeath(mut pnum: libc::c_int) -> libc::c_int {
    let mut rv: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            2977 as libc::c_int,
            b"PM_DoDeath: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize]._pVar8 >= plr[pnum as usize]._pDFrames << 1 as libc::c_int {
        if deathdelay > 1 as libc::c_int && pnum == myplr {
            deathdelay -= 1;
            deathdelay;
            if deathdelay == 1 as libc::c_int {
                deathflag = 1 as libc::c_int as bool32_t;
                if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                    gamemenu_on();
                }
            }
        }
        plr[pnum as usize]._pAnimDelay = 10000 as libc::c_int;
        plr[pnum as usize]._pAnimFrame = plr[pnum as usize]._pAnimLen;
        dFlags[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py
            as usize] = (dFlags[plr[pnum as usize]._px
            as usize][plr[pnum as usize]._py as usize] as libc::c_int
            | BFLAG_DEADPLR as libc::c_int) as int8_t;
    }
    if plr[pnum as usize]._pVar8 < 100 as libc::c_int {
        plr[pnum as usize]._pVar8 += 1;
        plr[pnum as usize]._pVar8;
    }
    rv = RUN_DONE as libc::c_int;
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn PM_DoNewLvl(mut pnum: libc::c_int) -> libc::c_int {
    return RUN_DONE as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn CheckNewPath(mut pnum: libc::c_int) {
    let mut i: libc::c_int = 0;
    let mut dx: libc::c_int = 0;
    let mut dy: libc::c_int = 0;
    let mut d: libc::c_int = 0;
    let mut oi: libc::c_int = 0;
    let mut v1: libc::c_int = 0;
    let mut v2: libc::c_int = 0;
    let mut v3: libc::c_int = 0;
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3012 as libc::c_int,
            b"CheckNewPath: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    if plr[pnum as usize].destAction == PCMD_ATTACKID as libc::c_int {
        i = plr[pnum as usize].destParam1;
        MakePlrPath(
            pnum,
            monster[i as usize]._mfutx,
            monster[i as usize]._mfuty,
            0 as libc::c_int as bool32_t,
        );
    }
    if plr[pnum as usize].destAction == PCMD_ATTACKPID as libc::c_int {
        i = plr[pnum as usize].destParam1;
        MakePlrPath(
            pnum,
            plr[i as usize]._pfutx,
            plr[i as usize]._pfuty,
            0 as libc::c_int as bool32_t,
        );
    }
    if plr[pnum as usize].walkpath[0 as libc::c_int as usize] as libc::c_int
        != PCMD_NOTHING as libc::c_int
    {
        if plr[pnum as usize]._pmode == PM_STAND as libc::c_int {
            if pnum == myplr {
                if plr[pnum as usize].destAction == PCMD_ATTACKID as libc::c_int
                    || plr[pnum as usize].destAction == PCMD_ATTACKPID as libc::c_int
                {
                    i = plr[pnum as usize].destParam1;
                    if plr[pnum as usize].destAction == PCMD_ATTACKID as libc::c_int {
                        dx = abs(plr[pnum as usize]._pfutx - monster[i as usize]._mfutx);
                        dy = abs(plr[pnum as usize]._pfuty - monster[i as usize]._mfuty);
                        d = GetDirection(
                            plr[pnum as usize]._pfutx,
                            plr[pnum as usize]._pfuty,
                            monster[i as usize]._mfutx,
                            monster[i as usize]._mfuty,
                        );
                    } else {
                        dx = abs(plr[pnum as usize]._pfutx - plr[i as usize]._pfutx);
                        dy = abs(plr[pnum as usize]._pfuty - plr[i as usize]._pfuty);
                        d = GetDirection(
                            plr[pnum as usize]._pfutx,
                            plr[pnum as usize]._pfuty,
                            plr[i as usize]._pfutx,
                            plr[i as usize]._pfuty,
                        );
                    }
                    if dx < 2 as libc::c_int && dy < 2 as libc::c_int {
                        ClrPlrPath(pnum);
                        if monster[i as usize].mtalkmsg != 0 as libc::c_int
                            && monster[i as usize].mtalkmsg != TXT_VB2 as libc::c_int
                        {
                            TalktoMonster(i);
                        } else {
                            StartAttack(pnum, d);
                        }
                        plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                    }
                }
            }
            if currlevel as libc::c_int != 0 as libc::c_int {
                v1 = PlrWalkTbl[plr[pnum as usize]._pClass
                    as usize][0 as libc::c_int as usize];
                v2 = PlrWalkTbl[plr[pnum as usize]._pClass
                    as usize][1 as libc::c_int as usize];
                v3 = PlrWalkTbl[plr[pnum as usize]._pClass
                    as usize][2 as libc::c_int as usize];
            } else {
                v1 = 2048 as libc::c_int;
                v2 = 1024 as libc::c_int;
                v3 = 512 as libc::c_int;
            }
            match plr[pnum as usize].walkpath[0 as libc::c_int as usize] as libc::c_int {
                5 => {
                    StartWalk(
                        pnum,
                        0 as libc::c_int,
                        -v2,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        DIR_U as libc::c_int,
                        SCRL_U as libc::c_int,
                    );
                }
                1 => {
                    StartWalk(
                        pnum,
                        v2,
                        -v3,
                        0 as libc::c_int,
                        -(1 as libc::c_int),
                        DIR_UR as libc::c_int,
                        SCRL_UR as libc::c_int,
                    );
                }
                6 => {
                    StartWalk3(
                        pnum,
                        v1,
                        0 as libc::c_int,
                        -(32 as libc::c_int),
                        -(16 as libc::c_int),
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        1 as libc::c_int,
                        0 as libc::c_int,
                        DIR_R as libc::c_int,
                        SCRL_R as libc::c_int,
                    );
                }
                3 => {
                    StartWalk2(
                        pnum,
                        v2,
                        v3,
                        -(32 as libc::c_int),
                        -(16 as libc::c_int),
                        1 as libc::c_int,
                        0 as libc::c_int,
                        DIR_DR as libc::c_int,
                        SCRL_DR as libc::c_int,
                    );
                }
                7 => {
                    StartWalk2(
                        pnum,
                        0 as libc::c_int,
                        v2,
                        0 as libc::c_int,
                        -(32 as libc::c_int),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        DIR_D as libc::c_int,
                        SCRL_D as libc::c_int,
                    );
                }
                4 => {
                    StartWalk2(
                        pnum,
                        -v2,
                        v3,
                        32 as libc::c_int,
                        -(16 as libc::c_int),
                        0 as libc::c_int,
                        1 as libc::c_int,
                        DIR_DL as libc::c_int,
                        SCRL_DL as libc::c_int,
                    );
                }
                8 => {
                    StartWalk3(
                        pnum,
                        -v1,
                        0 as libc::c_int,
                        32 as libc::c_int,
                        -(16 as libc::c_int),
                        -(1 as libc::c_int),
                        1 as libc::c_int,
                        0 as libc::c_int,
                        1 as libc::c_int,
                        DIR_L as libc::c_int,
                        SCRL_L as libc::c_int,
                    );
                }
                2 => {
                    StartWalk(
                        pnum,
                        -v2,
                        -v3,
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        DIR_UL as libc::c_int,
                        SCRL_UL as libc::c_int,
                    );
                }
                _ => {}
            }
            i = 1 as libc::c_int;
            while i < MAXPATHLEN as libc::c_int {
                plr[pnum as usize]
                    .walkpath[(i - 1 as libc::c_int)
                    as usize] = plr[pnum as usize].walkpath[i as usize];
                i += 1;
                i;
            }
            plr[pnum as usize]
                .walkpath[(MAXPATHLEN as libc::c_int - 1 as libc::c_int)
                as usize] = PCMD_NOTHING as libc::c_int as int8_t;
            if plr[pnum as usize]._pmode == PM_STAND as libc::c_int {
                StartStand(pnum, plr[pnum as usize]._pdir);
                plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
            }
        }
    } else if plr[pnum as usize].destAction != PCMD_NOTHING as libc::c_int {
        if plr[pnum as usize]._pmode == PM_STAND as libc::c_int {
            match plr[pnum as usize].destAction {
                9 => {
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    StartAttack(pnum, d);
                }
                20 => {
                    i = plr[pnum as usize].destParam1;
                    dx = abs(plr[pnum as usize]._px - monster[i as usize]._mfutx);
                    dy = abs(plr[pnum as usize]._py - monster[i as usize]._mfuty);
                    if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int {
                        d = GetDirection(
                            plr[pnum as usize]._pfutx,
                            plr[pnum as usize]._pfuty,
                            monster[i as usize]._mfutx,
                            monster[i as usize]._mfuty,
                        );
                        if monster[i as usize].mtalkmsg != 0 as libc::c_int
                            && monster[i as usize].mtalkmsg != TXT_VB2 as libc::c_int
                        {
                            TalktoMonster(i);
                        } else {
                            StartAttack(pnum, d);
                        }
                    }
                }
                21 => {
                    i = plr[pnum as usize].destParam1;
                    dx = abs(plr[pnum as usize]._px - plr[i as usize]._pfutx);
                    dy = abs(plr[pnum as usize]._py - plr[i as usize]._pfuty);
                    if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int {
                        d = GetDirection(
                            plr[pnum as usize]._pfutx,
                            plr[pnum as usize]._pfuty,
                            plr[i as usize]._pfutx,
                            plr[i as usize]._pfuty,
                        );
                        StartAttack(pnum, d);
                    }
                }
                10 => {
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    StartRangeAttack(
                        pnum,
                        d,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                }
                22 => {
                    i = plr[pnum as usize].destParam1;
                    d = GetDirection(
                        plr[pnum as usize]._pfutx,
                        plr[pnum as usize]._pfuty,
                        monster[i as usize]._mfutx,
                        monster[i as usize]._mfuty,
                    );
                    if monster[i as usize].mtalkmsg != 0 as libc::c_int
                        && monster[i as usize].mtalkmsg != TXT_VB2 as libc::c_int
                    {
                        TalktoMonster(i);
                    } else {
                        StartRangeAttack(
                            pnum,
                            d,
                            monster[i as usize]._mfutx,
                            monster[i as usize]._mfuty,
                        );
                    }
                }
                23 => {
                    i = plr[pnum as usize].destParam1;
                    d = GetDirection(
                        plr[pnum as usize]._pfutx,
                        plr[pnum as usize]._pfuty,
                        plr[i as usize]._pfutx,
                        plr[i as usize]._pfuty,
                    );
                    StartRangeAttack(
                        pnum,
                        d,
                        plr[i as usize]._pfutx,
                        plr[i as usize]._pfuty,
                    );
                }
                12 => {
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    StartSpell(
                        pnum,
                        d,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    plr[pnum as usize]._pVar4 = plr[pnum as usize].destParam3;
                }
                26 => {
                    StartSpell(
                        pnum,
                        plr[pnum as usize].destParam3,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    plr[pnum as usize]._pVar3 = plr[pnum as usize].destParam3;
                    plr[pnum as usize]._pVar4 = plr[pnum as usize].destParam4;
                }
                24 => {
                    i = plr[pnum as usize].destParam1;
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        monster[i as usize]._mfutx,
                        monster[i as usize]._mfuty,
                    );
                    StartSpell(
                        pnum,
                        d,
                        monster[i as usize]._mfutx,
                        monster[i as usize]._mfuty,
                    );
                    plr[pnum as usize]._pVar4 = plr[pnum as usize].destParam2;
                }
                25 => {
                    i = plr[pnum as usize].destParam1;
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        plr[i as usize]._pfutx,
                        plr[i as usize]._pfuty,
                    );
                    StartSpell(pnum, d, plr[i as usize]._pfutx, plr[i as usize]._pfuty);
                    plr[pnum as usize]._pVar4 = plr[pnum as usize].destParam2;
                }
                13 => {
                    oi = plr[pnum as usize].destParam1;
                    dx = abs(plr[pnum as usize]._px - object[oi as usize]._ox);
                    dy = abs(plr[pnum as usize]._py - object[oi as usize]._oy);
                    if dy > 1 as libc::c_int
                        && dObject[object[oi as usize]._ox
                            as usize][(object[oi as usize]._oy - 1 as libc::c_int)
                            as usize] as libc::c_int == -(1 as libc::c_int) - oi
                    {
                        dy = abs(
                            plr[pnum as usize]._py - object[oi as usize]._oy
                                + 1 as libc::c_int,
                        );
                    }
                    if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int {
                        if object[oi as usize]._oBreak as libc::c_int
                            == OBJ_BREAKABLE as libc::c_int
                        {
                            d = GetDirection(
                                plr[pnum as usize]._px,
                                plr[pnum as usize]._py,
                                object[oi as usize]._ox,
                                object[oi as usize]._oy,
                            );
                            StartAttack(pnum, d);
                        } else {
                            OperateObject(pnum, oi, 0 as libc::c_int as bool32_t);
                        }
                    }
                }
                14 => {
                    oi = plr[pnum as usize].destParam1;
                    dx = abs(plr[pnum as usize]._px - object[oi as usize]._ox);
                    dy = abs(plr[pnum as usize]._py - object[oi as usize]._oy);
                    if dy > 1 as libc::c_int
                        && dObject[object[oi as usize]._ox
                            as usize][(object[oi as usize]._oy - 1 as libc::c_int)
                            as usize] as libc::c_int == -(1 as libc::c_int) - oi
                    {
                        dy = abs(
                            plr[pnum as usize]._py - object[oi as usize]._oy
                                + 1 as libc::c_int,
                        );
                    }
                    if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int {
                        if object[oi as usize]._oBreak as libc::c_int
                            == OBJ_BREAKABLE as libc::c_int
                        {
                            d = GetDirection(
                                plr[pnum as usize]._px,
                                plr[pnum as usize]._py,
                                object[oi as usize]._ox,
                                object[oi as usize]._oy,
                            );
                            StartAttack(pnum, d);
                        } else {
                            TryDisarm(pnum, oi);
                            OperateObject(pnum, oi, 0 as libc::c_int as bool32_t);
                        }
                    }
                }
                18 => {
                    oi = plr[pnum as usize].destParam1;
                    if object[oi as usize]._oBreak as libc::c_int
                        != OBJ_BREAKABLE as libc::c_int
                    {
                        OperateObject(pnum, oi, 1 as libc::c_int as bool32_t);
                    }
                }
                15 => {
                    if pnum == myplr {
                        i = plr[pnum as usize].destParam1;
                        dx = abs(plr[pnum as usize]._px - item[i as usize]._ix);
                        dy = abs(plr[pnum as usize]._py - item[i as usize]._iy);
                        if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int
                            && curs == GLOVE_CURS as libc::c_int
                            && item[i as usize]._iRequest == 0
                        {
                            NetSendCmdGItem(
                                1 as libc::c_int as bool32_t,
                                CMD_REQUESTGITEM as libc::c_int as uint8_t,
                                myplr as uint8_t,
                                myplr as uint8_t,
                                i as uint8_t,
                            );
                            item[i as usize]._iRequest = 1 as libc::c_int as int8_t;
                        }
                    }
                }
                16 => {
                    if pnum == myplr {
                        i = plr[pnum as usize].destParam1;
                        dx = abs(plr[pnum as usize]._px - item[i as usize]._ix);
                        dy = abs(plr[pnum as usize]._py - item[i as usize]._iy);
                        if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int
                            && curs == GLOVE_CURS as libc::c_int
                        {
                            NetSendCmdGItem(
                                1 as libc::c_int as bool32_t,
                                CMD_REQUESTAGITEM as libc::c_int as uint8_t,
                                myplr as uint8_t,
                                myplr as uint8_t,
                                i as uint8_t,
                            );
                        }
                    }
                }
                17 => {
                    if pnum == myplr {
                        TalkToTowner(pnum, plr[pnum as usize].destParam1);
                    }
                }
                _ => {}
            }
            FixPlayerLocation(pnum, plr[pnum as usize]._pdir);
            plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
        } else {
            if plr[pnum as usize]._pmode == PM_ATTACK as libc::c_int
                && plr[pnum as usize]._pAnimFrame > plr[myplr as usize]._pAFNum
            {
                if plr[pnum as usize].destAction == PCMD_ATTACK as libc::c_int {
                    d = GetDirection(
                        plr[pnum as usize]._pfutx,
                        plr[pnum as usize]._pfuty,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    StartAttack(pnum, d);
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                } else if plr[pnum as usize].destAction == PCMD_ATTACKID as libc::c_int {
                    i = plr[pnum as usize].destParam1;
                    dx = abs(plr[pnum as usize]._px - monster[i as usize]._mfutx);
                    dy = abs(plr[pnum as usize]._py - monster[i as usize]._mfuty);
                    if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int {
                        d = GetDirection(
                            plr[pnum as usize]._pfutx,
                            plr[pnum as usize]._pfuty,
                            monster[i as usize]._mfutx,
                            monster[i as usize]._mfuty,
                        );
                        StartAttack(pnum, d);
                    }
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                } else if plr[pnum as usize].destAction == PCMD_ATTACKPID as libc::c_int
                {
                    i = plr[pnum as usize].destParam1;
                    dx = abs(plr[pnum as usize]._px - plr[i as usize]._pfutx);
                    dy = abs(plr[pnum as usize]._py - plr[i as usize]._pfuty);
                    if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int {
                        d = GetDirection(
                            plr[pnum as usize]._pfutx,
                            plr[pnum as usize]._pfuty,
                            plr[i as usize]._pfutx,
                            plr[i as usize]._pfuty,
                        );
                        StartAttack(pnum, d);
                    }
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                } else if plr[pnum as usize].destAction == PCMD_OPOBJ as libc::c_int {
                    oi = plr[pnum as usize].destParam1;
                    dx = abs(plr[pnum as usize]._px - object[oi as usize]._ox);
                    dy = abs(plr[pnum as usize]._py - object[oi as usize]._oy);
                    if dy > 1 as libc::c_int
                        && dObject[object[oi as usize]._ox
                            as usize][(object[oi as usize]._oy - 1 as libc::c_int)
                            as usize] as libc::c_int == -(1 as libc::c_int) - oi
                    {
                        dy = abs(
                            plr[pnum as usize]._py - object[oi as usize]._oy
                                + 1 as libc::c_int,
                        );
                    }
                    if dx <= 1 as libc::c_int && dy <= 1 as libc::c_int {
                        if object[oi as usize]._oBreak as libc::c_int
                            == OBJ_BREAKABLE as libc::c_int
                        {
                            d = GetDirection(
                                plr[pnum as usize]._px,
                                plr[pnum as usize]._py,
                                object[oi as usize]._ox,
                                object[oi as usize]._oy,
                            );
                            StartAttack(pnum, d);
                        } else {
                            OperateObject(pnum, oi, 0 as libc::c_int as bool32_t);
                        }
                    }
                }
            }
            if plr[pnum as usize]._pmode == PM_RATTACK as libc::c_int
                && plr[pnum as usize]._pAnimFrame > plr[myplr as usize]._pAFNum
            {
                if plr[pnum as usize].destAction == PCMD_RATTACK as libc::c_int {
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    StartRangeAttack(
                        pnum,
                        d,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                } else if plr[pnum as usize].destAction == PCMD_RATTACKID as libc::c_int
                {
                    i = plr[pnum as usize].destParam1;
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        monster[i as usize]._mfutx,
                        monster[i as usize]._mfuty,
                    );
                    StartRangeAttack(
                        pnum,
                        d,
                        monster[i as usize]._mfutx,
                        monster[i as usize]._mfuty,
                    );
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                } else if plr[pnum as usize].destAction == PCMD_RATTACKPID as libc::c_int
                {
                    i = plr[pnum as usize].destParam1;
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        plr[i as usize]._pfutx,
                        plr[i as usize]._pfuty,
                    );
                    StartRangeAttack(
                        pnum,
                        d,
                        plr[i as usize]._pfutx,
                        plr[i as usize]._pfuty,
                    );
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                }
            }
            if plr[pnum as usize]._pmode == PM_SPELL as libc::c_int
                && plr[pnum as usize]._pAnimFrame > plr[pnum as usize]._pSFNum
            {
                if plr[pnum as usize].destAction == PCMD_SPELL as libc::c_int {
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    StartSpell(
                        pnum,
                        d,
                        plr[pnum as usize].destParam1,
                        plr[pnum as usize].destParam2,
                    );
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                } else if plr[pnum as usize].destAction == PCMD_SPELLID as libc::c_int {
                    i = plr[pnum as usize].destParam1;
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        monster[i as usize]._mfutx,
                        monster[i as usize]._mfuty,
                    );
                    StartSpell(
                        pnum,
                        d,
                        monster[i as usize]._mfutx,
                        monster[i as usize]._mfuty,
                    );
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                } else if plr[pnum as usize].destAction == PCMD_SPELLPID as libc::c_int {
                    i = plr[pnum as usize].destParam1;
                    d = GetDirection(
                        plr[pnum as usize]._px,
                        plr[pnum as usize]._py,
                        plr[i as usize]._pfutx,
                        plr[i as usize]._pfuty,
                    );
                    StartSpell(pnum, d, plr[i as usize]._pfutx, plr[i as usize]._pfuty);
                    plr[pnum as usize].destAction = PCMD_NOTHING as libc::c_int;
                }
            }
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn PlrDeathModeOK(mut p: libc::c_int) -> bool32_t {
    if p != myplr {
        return 1 as libc::c_int as bool32_t;
    }
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3321 as libc::c_int,
            b"PlrDeathModeOK: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    if plr[p as usize]._pmode == PM_DEATH as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    if plr[p as usize]._pmode == PM_QUIT as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    if plr[p as usize]._pmode == PM_NEWLVL as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn ValidatePlayer() {
    let mut i: libc::c_int = 0;
    let mut gt: libc::c_int = 0;
    let mut pc: libc::c_int = 0;
    let mut msk: uint64_t = 0 as libc::c_int as uint64_t;
    let mut b: uint64_t = 1 as libc::c_int as uint64_t;
    if myplr as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3344 as libc::c_int,
            b"ValidatePlayer: illegal player %d\0" as *const u8 as *const libc::c_char,
            myplr,
        );
    }
    if plr[myplr as usize]._pLevel as libc::c_int > 50 as libc::c_int {
        plr[myplr as usize]._pLevel = 50 as libc::c_int as int8_t;
    }
    if plr[myplr as usize]._pExperience > plr[myplr as usize]._pNextExper {
        plr[myplr as usize]._pExperience = plr[myplr as usize]._pNextExper;
    }
    gt = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < plr[myplr as usize]._pNumInv {
        if plr[myplr as usize].InvList[i as usize]._itype == IT_GOLD as libc::c_int {
            if plr[myplr as usize].InvList[i as usize]._ivalue > GOLD_VMAX as libc::c_int
            {
                plr[myplr as usize]
                    .InvList[i as usize]
                    ._ivalue = GOLD_VMAX as libc::c_int;
            }
            gt += plr[myplr as usize].InvList[i as usize]._ivalue;
        }
        i += 1;
        i;
    }
    if gt != plr[myplr as usize]._pGold {
        plr[myplr as usize]._pGold = gt;
    }
    pc = plr[myplr as usize]._pClass as libc::c_int;
    if plr[myplr as usize]._pBaseStr > MaxStats[pc as usize][0 as libc::c_int as usize] {
        plr[myplr as usize]._pBaseStr = MaxStats[pc as usize][0 as libc::c_int as usize];
    }
    if plr[myplr as usize]._pBaseMag > MaxStats[pc as usize][1 as libc::c_int as usize] {
        plr[myplr as usize]._pBaseMag = MaxStats[pc as usize][1 as libc::c_int as usize];
    }
    if plr[myplr as usize]._pBaseDex > MaxStats[pc as usize][2 as libc::c_int as usize] {
        plr[myplr as usize]._pBaseDex = MaxStats[pc as usize][2 as libc::c_int as usize];
    }
    if plr[myplr as usize]._pBaseVit > MaxStats[pc as usize][3 as libc::c_int as usize] {
        plr[myplr as usize]._pBaseVit = MaxStats[pc as usize][3 as libc::c_int as usize];
    }
    i = SPL_FIREBOLT as libc::c_int;
    while i < SPL_LAST as libc::c_int {
        if spelldata[i as usize].sBookLvl != -(1 as libc::c_int) {
            msk |= b << i - 1 as libc::c_int;
            if plr[myplr as usize]._pSplLvl[i as usize] as libc::c_int
                > SPELLCAP as libc::c_int
            {
                plr[myplr as usize]
                    ._pSplLvl[i as usize] = SPELLCAP as libc::c_int as int8_t;
            }
        }
        i += 1;
        i;
    }
    plr[myplr as usize]._pMemSpells &= msk;
}
unsafe extern "C" fn CheckCheatStats(mut pnum: libc::c_int) {
    if plr[pnum as usize]._pStrength > MAX_STAT as libc::c_int {
        plr[pnum as usize]._pStrength = MAX_STAT as libc::c_int;
    }
    if plr[pnum as usize]._pDexterity > MAX_STAT as libc::c_int {
        plr[pnum as usize]._pDexterity = MAX_STAT as libc::c_int;
    }
    if plr[pnum as usize]._pMagic > MAX_STAT as libc::c_int {
        plr[pnum as usize]._pMagic = MAX_STAT as libc::c_int;
    }
    if plr[pnum as usize]._pVitality > MAX_STAT as libc::c_int {
        plr[pnum as usize]._pVitality = MAX_STAT as libc::c_int;
    }
    if plr[pnum as usize]._pHitPoints > MAX_HP as libc::c_int {
        plr[pnum as usize]._pHitPoints = MAX_HP as libc::c_int;
    }
    if plr[pnum as usize]._pMana > MAX_MANA as libc::c_int {
        plr[pnum as usize]._pMana = MAX_MANA as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ProcessPlayers() {
    let mut raflag: libc::c_int = 0;
    let mut pnum: libc::c_int = 0;
    if myplr as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3421 as libc::c_int,
            b"ProcessPlayers: illegal player %d\0" as *const u8 as *const libc::c_char,
            myplr,
        );
    }
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAXINV as libc::c_int {
        if plr[myplr as usize].InvGrid[i as usize] as libc::c_int > 0 as libc::c_int {
            if !(plr[myplr as usize].InvGrid[i as usize] as libc::c_int
                <= plr[myplr as usize]._pNumInv)
            {
                assert_fail(
                    3427 as libc::c_int,
                    b"src/player.c\0" as *const u8 as *const libc::c_char,
                    b"plr[myplr].InvGrid[i] <= plr[myplr]._pNumInv\0" as *const u8
                        as *const libc::c_char,
                );
            }
        }
        i += 1;
        i;
    }
    if plr[myplr as usize].pLvlLoad as libc::c_int > 0 as libc::c_int {
        plr[myplr as usize].pLvlLoad = (plr[myplr as usize].pLvlLoad).wrapping_sub(1);
        plr[myplr as usize].pLvlLoad;
    }
    if sfxdelay > 0 as libc::c_int {
        sfxdelay -= 1;
        sfxdelay;
        if sfxdelay == 0 as libc::c_int {
            PlaySFX(sfxdnum);
        }
    }
    ValidatePlayer();
    pnum = 0 as libc::c_int;
    while pnum < MAX_PLRS as libc::c_int {
        if !(plr[pnum as usize].plractive == 0) {
            if !(currlevel as libc::c_int != plr[pnum as usize].plrlevel) {
                if !(pnum != myplr
                    && plr[pnum as usize]._pLvlChanging as libc::c_int != 0)
                {
                    CheckCheatStats(pnum);
                    if PlrDeathModeOK(pnum) == 0
                        && plr[pnum as usize]._pHitPoints >> HP_SHIFT as libc::c_int
                            <= 0 as libc::c_int
                    {
                        StartPlrKill(pnum, KILL_UNKNOWN as libc::c_int as int8_t);
                    }
                    if pnum == myplr {
                        if plr[pnum as usize]._pIFlags & IAF_CONSTRICT as libc::c_int
                            != 0 && currlevel as libc::c_int != 0 as libc::c_int
                        {
                            plr[pnum as usize]._pHitPoints -= 4 as libc::c_int;
                            plr[pnum as usize]._pHPBase -= 4 as libc::c_int;
                            if plr[pnum as usize]._pHitPoints >> HP_SHIFT as libc::c_int
                                <= 0 as libc::c_int
                            {
                                StartPlrKill(pnum, 0 as libc::c_int as int8_t);
                            }
                            drawhpflag = 1 as libc::c_int as bool32_t;
                        }
                        if plr[pnum as usize]._pIFlags & IAF_LMANA as libc::c_int != 0 {
                            if plr[pnum as usize]._pManaBase > 0 as libc::c_int {
                                plr[pnum as usize]._pManaBase -= plr[pnum as usize]._pMana;
                                plr[pnum as usize]._pMana = 0 as libc::c_int;
                                drawmanaflag = 1 as libc::c_int as bool32_t;
                            }
                        }
                    }
                    raflag = RUN_DONE as libc::c_int;
                    loop {
                        match plr[pnum as usize]._pmode {
                            0 => {
                                raflag = PM_DoStand(pnum);
                            }
                            1 => {
                                raflag = PM_DoWalk(pnum);
                            }
                            2 => {
                                raflag = PM_DoWalk2(pnum);
                            }
                            3 => {
                                raflag = PM_DoWalk3(pnum);
                            }
                            4 => {
                                raflag = PM_DoAttack(pnum);
                            }
                            5 => {
                                raflag = PM_DoRangeAttack(pnum);
                            }
                            6 => {
                                raflag = PM_DoBlock(pnum);
                            }
                            9 => {
                                raflag = PM_DoSpell(pnum);
                            }
                            7 => {
                                raflag = PM_DoGotHit(pnum);
                            }
                            8 => {
                                raflag = PM_DoDeath(pnum);
                            }
                            10 => {
                                raflag = PM_DoNewLvl(pnum);
                            }
                            _ => {}
                        }
                        CheckNewPath(pnum);
                        if !(raflag != RUN_DONE as libc::c_int) {
                            break;
                        }
                    }
                    plr[pnum as usize]._pAnimCnt += 1;
                    plr[pnum as usize]._pAnimCnt;
                    if plr[pnum as usize]._pAnimCnt > plr[pnum as usize]._pAnimDelay {
                        plr[pnum as usize]._pAnimCnt = 0 as libc::c_int;
                        plr[pnum as usize]._pAnimFrame += 1;
                        plr[pnum as usize]._pAnimFrame;
                        if plr[pnum as usize]._pAnimFrame > plr[pnum as usize]._pAnimLen
                        {
                            plr[pnum as usize]._pAnimFrame = 1 as libc::c_int;
                        }
                    }
                }
            }
        }
        pnum += 1;
        pnum;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ClrPlrPath(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3545 as libc::c_int,
            b"ClrPlrPath: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    memset(
        (plr[pnum as usize].walkpath).as_mut_ptr() as *mut libc::c_void,
        PCMD_NOTHING as libc::c_int,
        MAXPATHLEN as libc::c_int as libc::c_ulong,
    );
}
#[no_mangle]
pub unsafe extern "C" fn PosOkPlayer(
    mut pnum: libc::c_int,
    mut px: libc::c_int,
    mut py: libc::c_int,
) -> bool32_t {
    let mut mi: libc::c_int = 0;
    let mut p: uint32_t = 0;
    let mut bv: int8_t = 0;
    let mut ret: bool32_t = 0 as libc::c_int as bool32_t;
    if px >= 0 as libc::c_int && px < MAXDUNX as libc::c_int && py >= 0 as libc::c_int
        && py < MAXDUNY as libc::c_int
    {
        if SolidLoc(px, py) != 0 {
            return 0 as libc::c_int as bool32_t;
        }
        if dPiece[px as usize][py as usize] == 0 as libc::c_int {
            return 0 as libc::c_int as bool32_t;
        }
        if dPlayer[px as usize][py as usize] != 0 {
            if dPlayer[px as usize][py as usize] as libc::c_int > 0 as libc::c_int {
                p = (dPlayer[px as usize][py as usize] as libc::c_int - 1 as libc::c_int)
                    as uint32_t;
            } else {
                p = -(dPlayer[px as usize][py as usize] as libc::c_int
                    + 1 as libc::c_int) as uint32_t;
            }
            if p != pnum as uint32_t && p < MAX_PLRS as libc::c_int as uint32_t
                && plr[p as usize]._pHitPoints != 0 as libc::c_int
            {
                return 0 as libc::c_int as bool32_t;
            }
        }
        if dMonster[px as usize][py as usize] != 0 {
            if currlevel as libc::c_int == 0 as libc::c_int {
                return 0 as libc::c_int as bool32_t;
            }
            if dMonster[px as usize][py as usize] > 0 as libc::c_int {
                mi = dMonster[px as usize][py as usize] - 1 as libc::c_int;
                if monster[mi as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                    > 0 as libc::c_int
                {
                    return 0 as libc::c_int as bool32_t;
                }
            } else {
                return 0 as libc::c_int as bool32_t
            }
        }
        if dObject[px as usize][py as usize] != 0 {
            if dObject[px as usize][py as usize] as libc::c_int > 0 as libc::c_int {
                bv = (dObject[px as usize][py as usize] as libc::c_int
                    - 1 as libc::c_int) as int8_t;
            } else {
                bv = -(dObject[px as usize][py as usize] as libc::c_int
                    + 1 as libc::c_int) as int8_t;
            }
            if object[bv as usize]._oSolidFlag != 0 {
                return 0 as libc::c_int as bool32_t;
            }
        }
        ret = 1 as libc::c_int as bool32_t;
    }
    if ret == 0 {
        return 0 as libc::c_int as bool32_t;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn MakePlrPath(
    mut pnum: libc::c_int,
    mut xx: libc::c_int,
    mut yy: libc::c_int,
    mut endspace: bool32_t,
) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3606 as libc::c_int,
            b"MakePlrPath: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._ptargx = xx;
    plr[pnum as usize]._ptargy = yy;
    if plr[pnum as usize]._pfutx == xx && plr[pnum as usize]._pfuty == yy {
        return;
    }
    let mut pathlen: libc::c_int = FindPath(
        Some(
            PosOkPlayer
                as unsafe extern "C" fn(
                    libc::c_int,
                    libc::c_int,
                    libc::c_int,
                ) -> bool32_t,
        ),
        pnum,
        plr[pnum as usize]._pfutx,
        plr[pnum as usize]._pfuty,
        xx,
        yy,
        (plr[pnum as usize].walkpath).as_mut_ptr(),
    );
    if pathlen != 0 {
        if endspace == 0 {
            pathlen -= 1;
            pathlen;
            match plr[pnum as usize].walkpath[pathlen as usize] as libc::c_int {
                1 => {
                    yy += 1;
                    yy;
                }
                2 => {
                    xx += 1;
                    xx;
                }
                3 => {
                    xx -= 1;
                    xx;
                }
                4 => {
                    yy -= 1;
                    yy;
                }
                5 => {
                    xx += 1;
                    xx;
                    yy += 1;
                    yy;
                }
                6 => {
                    xx -= 1;
                    xx;
                    yy += 1;
                    yy;
                }
                7 => {
                    xx -= 1;
                    xx;
                    yy -= 1;
                    yy;
                }
                8 => {
                    xx += 1;
                    xx;
                    yy -= 1;
                    yy;
                }
                _ => {}
            }
            plr[pnum as usize]._ptargx = xx;
            plr[pnum as usize]._ptargy = yy;
        }
        plr[pnum as usize]
            .walkpath[pathlen as usize] = PCMD_NOTHING as libc::c_int as int8_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn CheckPlrSpell() {
    let mut sd: libc::c_int = 0;
    let mut addflag: bool32_t = 0 as libc::c_int as bool32_t;
    if myplr as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3663 as libc::c_int,
            b"CheckPlrSpell: illegal player %d\0" as *const u8 as *const libc::c_char,
            myplr,
        );
    }
    let mut rspell: libc::c_int = plr[myplr as usize]._pRSpell;
    if rspell == -(1 as libc::c_int) {
        if plr[myplr as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            PlaySFX(PS_WARR34 as libc::c_int);
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_ROGUE as libc::c_int
        {
            PlaySFX(PS_ROGUE34 as libc::c_int);
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_SORCEROR as libc::c_int
        {
            PlaySFX(PS_MAGE34 as libc::c_int);
        }
        return;
    }
    if leveltype as libc::c_int == 0 as libc::c_int
        && spelldata[plr[myplr as usize]._pRSpell as usize].sTownSpell
            == 0 as libc::c_int as bool32_t
    {
        if plr[myplr as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            PlaySFX(PS_WARR27 as libc::c_int);
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_ROGUE as libc::c_int
        {
            PlaySFX(PS_ROGUE27 as libc::c_int);
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_SORCEROR as libc::c_int
        {
            PlaySFX(PS_MAGE27 as libc::c_int);
        }
        return;
    }
    if curs != GLOVE_CURS as libc::c_int {
        return;
    }
    if !(MouseY < 352 as libc::c_int && !(chrflag != 0 && MouseX < 320 as libc::c_int)
        && !(invflag != 0 && MouseX > 320 as libc::c_int)
        || MouseY < 352 as libc::c_int
            && (rspell == SPL_HEAL as libc::c_int
                || rspell == SPL_IDENTIFY as libc::c_int
                || rspell == SPL_REPAIR as libc::c_int
                || rspell == SPL_INFRA as libc::c_int
                || rspell == SPL_RECHARGE as libc::c_int))
    {
        return;
    }
    match plr[myplr as usize]._pRSplType as libc::c_int {
        0 | 1 => {
            addflag = CheckSpell(
                myplr,
                plr[myplr as usize]._pRSpell,
                plr[myplr as usize]._pRSplType,
                0 as libc::c_int as bool32_t,
            );
        }
        2 => {
            addflag = UseScroll();
        }
        3 => {
            addflag = UseStaff();
        }
        _ => {}
    }
    if addflag != 0 {
        if plr[myplr as usize]._pRSpell == SPL_WALL as libc::c_int {
            sd = GetDirection(
                plr[myplr as usize]._px,
                plr[myplr as usize]._py,
                cursmx,
                cursmy,
            );
            NetSendCmdLocParam3(
                1 as libc::c_int as bool32_t,
                CMD_SPELLXYD as libc::c_int as uint8_t,
                cursmx as uint8_t,
                cursmy as uint8_t,
                plr[myplr as usize]._pRSpell as uint16_t,
                sd as uint16_t,
                GetSpellLevel(myplr, plr[myplr as usize]._pRSpell) as uint16_t,
            );
        } else if cursmonst != -(1 as libc::c_int) {
            NetSendCmdParam3(
                1 as libc::c_int as bool32_t,
                CMD_SPELLID as libc::c_int as uint8_t,
                cursmonst as uint16_t,
                plr[myplr as usize]._pRSpell as uint16_t,
                GetSpellLevel(myplr, plr[myplr as usize]._pRSpell) as uint16_t,
            );
        } else if cursplr as libc::c_int != -(1 as libc::c_int) {
            NetSendCmdParam3(
                1 as libc::c_int as bool32_t,
                CMD_SPELLPID as libc::c_int as uint8_t,
                cursplr as uint16_t,
                plr[myplr as usize]._pRSpell as uint16_t,
                GetSpellLevel(myplr, plr[myplr as usize]._pRSpell) as uint16_t,
            );
        } else {
            NetSendCmdLocParam2(
                1 as libc::c_int as bool32_t,
                CMD_SPELLXY as libc::c_int as uint8_t,
                cursmx as uint8_t,
                cursmy as uint8_t,
                plr[myplr as usize]._pRSpell as uint16_t,
                GetSpellLevel(myplr, plr[myplr as usize]._pRSpell) as uint16_t,
            );
        }
    } else if plr[myplr as usize]._pRSplType as libc::c_int
        == SPT_MEMORIZED as libc::c_int
    {
        if plr[myplr as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            PlaySFX(PS_WARR35 as libc::c_int);
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_ROGUE as libc::c_int
        {
            PlaySFX(PS_ROGUE35 as libc::c_int);
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_SORCEROR as libc::c_int
        {
            PlaySFX(PS_MAGE35 as libc::c_int);
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn SyncPlrAnim(mut p: libc::c_int) {
    let mut dir: libc::c_int = 0;
    let mut s: libc::c_int = 0;
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3746 as libc::c_int,
            b"SyncPlrAnim: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    dir = plr[p as usize]._pdir;
    match plr[p as usize]._pmode {
        0 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pNAnim[dir as usize];
        }
        1 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pWAnim[dir as usize];
        }
        2 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pWAnim[dir as usize];
        }
        3 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pWAnim[dir as usize];
        }
        4 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pAAnim[dir as usize];
        }
        5 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pAAnim[dir as usize];
        }
        6 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pBAnim[dir as usize];
        }
        9 => {
            if p == myplr {
                s = spelldata[plr[p as usize]._pSpell as usize].sType as libc::c_int;
            } else {
                s = ST_FIRE as libc::c_int;
            }
            if s == ST_FIRE as libc::c_int {
                plr[p as usize]._pAnimData = plr[p as usize]._pFAnim[dir as usize];
            }
            if s == ST_LIGHT as libc::c_int {
                plr[p as usize]._pAnimData = plr[p as usize]._pLAnim[dir as usize];
            }
            if s == ST_MISC as libc::c_int {
                plr[p as usize]._pAnimData = plr[p as usize]._pTAnim[dir as usize];
            }
        }
        7 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pHAnim[dir as usize];
        }
        8 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pDAnim[dir as usize];
        }
        10 | 11 => {
            plr[p as usize]._pAnimData = plr[p as usize]._pNAnim[dir as usize];
        }
        _ => {
            app_fatal_(
                b"src/player.c\0" as *const u8 as *const libc::c_char,
                3802 as libc::c_int,
                b"SyncPlrAnim\0" as *const u8 as *const libc::c_char,
            );
        }
    }
    if (plr[p as usize]._pAnimData).is_null() {
        assert_fail(
            3806 as libc::c_int,
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            b"plr[p]._pAnimData\0" as *const u8 as *const libc::c_char,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn SyncInitPlrPos(mut pnum: libc::c_int) {
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    plr[pnum as usize]._ptargx = plr[pnum as usize]._px;
    plr[pnum as usize]._ptargy = plr[pnum as usize]._py;
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        return;
    }
    if plr[pnum as usize].plrlevel == currlevel as libc::c_int {
        let mut i: libc::c_int = 0 as libc::c_int;
        while (i as libc::c_ulong)
            < (::core::mem::size_of::<[libc::c_int; 9]>() as libc::c_ulong)
                .wrapping_div(::core::mem::size_of::<libc::c_int>() as libc::c_ulong)
                .wrapping_sub(1 as libc::c_int as libc::c_ulong)
        {
            x = plr[pnum as usize]._px + plrxoff2[i as usize];
            y = plr[pnum as usize]._py + plryoff2[i as usize];
            if PosOkPlayer(pnum, x, y) != 0 {
                break;
            }
            i += 1;
            i;
        }
        if PosOkPlayer(pnum, x, y) == 0 {
            let mut posOk: bool32_t = 0 as libc::c_int as bool32_t;
            let mut range: libc::c_int = 1 as libc::c_int;
            while range < 50 as libc::c_int && posOk == 0 {
                let mut yy: libc::c_int = -range;
                while yy <= range && posOk == 0 {
                    y = yy + plr[pnum as usize]._py;
                    let mut xx: libc::c_int = -range;
                    while xx <= range && posOk == 0 {
                        x = xx + plr[pnum as usize]._px;
                        if PosOkPlayer(pnum, x, y) != 0
                            && PosOkPortal(currlevel as libc::c_int, x, y) == 0
                        {
                            posOk = 1 as libc::c_int as bool32_t;
                        }
                        xx += 1;
                        xx;
                    }
                    yy += 1;
                    yy;
                }
                range += 1;
                range;
            }
        }
        plr[pnum as usize]._px = x;
        plr[pnum as usize]._py = y;
        dPlayer[x as usize][y as usize] = (pnum + 1 as libc::c_int) as int8_t;
        if pnum == myplr {
            plr[pnum as usize]._pfutx = x;
            plr[pnum as usize]._pfuty = y;
            plr[pnum as usize]._ptargx = x;
            plr[pnum as usize]._ptargy = y;
            ViewX = x;
            ViewY = y;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn SyncInitPlr(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3874 as libc::c_int,
            b"SyncInitPlr: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    SetPlrAnims(pnum);
    SyncInitPlrPos(pnum);
}
#[no_mangle]
pub unsafe extern "C" fn CheckStats(mut p: libc::c_int) {
    let mut c: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3893 as libc::c_int,
            b"CheckStats: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    if plr[p as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        c = 0 as libc::c_int;
    } else if plr[p as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        c = 1 as libc::c_int;
    } else if plr[p as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int {
        c = 2 as libc::c_int;
    }
    i = 0 as libc::c_int;
    while i < 4 as libc::c_int {
        match i {
            0 => {
                if plr[p as usize]._pBaseStr
                    > MaxStats[c as usize][0 as libc::c_int as usize]
                {
                    plr[p as usize]
                        ._pBaseStr = MaxStats[c as usize][0 as libc::c_int as usize];
                } else if plr[p as usize]._pBaseStr < 0 as libc::c_int {
                    plr[p as usize]._pBaseStr = 0 as libc::c_int;
                }
            }
            1 => {
                if plr[p as usize]._pBaseMag
                    > MaxStats[c as usize][1 as libc::c_int as usize]
                {
                    plr[p as usize]
                        ._pBaseMag = MaxStats[c as usize][1 as libc::c_int as usize];
                } else if plr[p as usize]._pBaseMag < 0 as libc::c_int {
                    plr[p as usize]._pBaseMag = 0 as libc::c_int;
                }
            }
            2 => {
                if plr[p as usize]._pBaseDex
                    > MaxStats[c as usize][2 as libc::c_int as usize]
                {
                    plr[p as usize]
                        ._pBaseDex = MaxStats[c as usize][2 as libc::c_int as usize];
                } else if plr[p as usize]._pBaseDex < 0 as libc::c_int {
                    plr[p as usize]._pBaseDex = 0 as libc::c_int;
                }
            }
            3 => {
                if plr[p as usize]._pBaseVit
                    > MaxStats[c as usize][3 as libc::c_int as usize]
                {
                    plr[p as usize]
                        ._pBaseVit = MaxStats[c as usize][3 as libc::c_int as usize];
                } else if plr[p as usize]._pBaseVit < 0 as libc::c_int {
                    plr[p as usize]._pBaseVit = 0 as libc::c_int;
                }
            }
            _ => {}
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ModifyPlrStr(mut p: libc::c_int, mut l: libc::c_int) {
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3945 as libc::c_int,
            b"ModifyPlrStr: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    let mut ms: libc::c_int = MaxStats[plr[p as usize]._pClass
        as usize][0 as libc::c_int as usize];
    if plr[p as usize]._pBaseStr + l > ms {
        l = ms - plr[p as usize]._pBaseStr;
    }
    plr[p as usize]._pStrength += l;
    plr[p as usize]._pBaseStr += l;
    if plr[p as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[p as usize]
            ._pDamageMod = (plr[p as usize]._pStrength + plr[p as usize]._pDexterity)
            * plr[p as usize]._pLevel as libc::c_int / 200 as libc::c_int;
    } else {
        plr[p as usize]
            ._pDamageMod = plr[p as usize]._pStrength
            * plr[p as usize]._pLevel as libc::c_int / 100 as libc::c_int;
    }
    CalcPlrInv(p, 1 as libc::c_int as bool32_t);
    if p == myplr {
        NetSendCmdParam1(
            0 as libc::c_int as bool32_t,
            CMD_SETSTR as libc::c_int as uint8_t,
            plr[p as usize]._pBaseStr as uint16_t,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn ModifyPlrMag(mut p: libc::c_int, mut l: libc::c_int) {
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3966 as libc::c_int,
            b"ModifyPlrMag: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    let mut ms: libc::c_int = MaxStats[plr[p as usize]._pClass
        as usize][1 as libc::c_int as usize];
    if plr[p as usize]._pBaseMag + l > ms {
        l = ms - plr[p as usize]._pBaseMag;
    }
    plr[p as usize]._pMagic += l;
    plr[p as usize]._pBaseMag += l;
    l = l << MANA_SHIFT as libc::c_int;
    if plr[p as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int {
        l = l << 1 as libc::c_int;
    }
    plr[p as usize]._pMaxManaBase += l;
    plr[p as usize]._pMaxMana += l;
    if plr[p as usize]._pIFlags & IAF_LMANA as libc::c_int == 0 {
        plr[p as usize]._pManaBase += l;
        plr[p as usize]._pMana += l;
    }
    CalcPlrInv(p, 1 as libc::c_int as bool32_t);
    if p == myplr {
        NetSendCmdParam1(
            0 as libc::c_int as bool32_t,
            CMD_SETMAG as libc::c_int as uint8_t,
            plr[p as usize]._pBaseMag as uint16_t,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn ModifyPlrDex(mut p: libc::c_int, mut l: libc::c_int) {
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            3993 as libc::c_int,
            b"ModifyPlrDex: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    let mut ms: libc::c_int = MaxStats[plr[p as usize]._pClass
        as usize][2 as libc::c_int as usize];
    if plr[p as usize]._pBaseDex + l > ms {
        l = ms - plr[p as usize]._pBaseDex;
    }
    plr[p as usize]._pDexterity += l;
    plr[p as usize]._pBaseDex += l;
    CalcPlrInv(p, 1 as libc::c_int as bool32_t);
    if plr[p as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[p as usize]
            ._pDamageMod = (plr[p as usize]._pStrength + plr[p as usize]._pDexterity)
            * plr[p as usize]._pLevel as libc::c_int / 200 as libc::c_int;
    }
    if p == myplr {
        NetSendCmdParam1(
            0 as libc::c_int as bool32_t,
            CMD_SETDEX as libc::c_int as uint8_t,
            plr[p as usize]._pBaseDex as uint16_t,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn ModifyPlrVit(mut p: libc::c_int, mut l: libc::c_int) {
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            4012 as libc::c_int,
            b"ModifyPlrVit: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    let mut ms: libc::c_int = MaxStats[plr[p as usize]._pClass
        as usize][3 as libc::c_int as usize];
    if plr[p as usize]._pBaseVit + l > ms {
        l = ms - plr[p as usize]._pBaseVit;
    }
    plr[p as usize]._pVitality += l;
    plr[p as usize]._pBaseVit += l;
    l = l << HP_SHIFT as libc::c_int;
    if plr[p as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        l = l << 1 as libc::c_int;
    }
    plr[p as usize]._pHPBase += l;
    plr[p as usize]._pMaxHPBase += l;
    plr[p as usize]._pHitPoints += l;
    plr[p as usize]._pMaxHP += l;
    CalcPlrInv(p, 1 as libc::c_int as bool32_t);
    if p == myplr {
        NetSendCmdParam1(
            0 as libc::c_int as bool32_t,
            CMD_SETVIT as libc::c_int as uint8_t,
            plr[p as usize]._pBaseVit as uint16_t,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn SetPlayerHitPoints(
    mut pnum: libc::c_int,
    mut newhp: libc::c_int,
) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            4036 as libc::c_int,
            b"SetPlayerHitPoints: illegal player %d\0" as *const u8
                as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize]._pHitPoints = newhp;
    plr[pnum as usize]
        ._pHPBase = newhp
        - (plr[pnum as usize]._pMaxHP - plr[pnum as usize]._pMaxHPBase);
    if pnum == myplr {
        drawhpflag = 1 as libc::c_int as bool32_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn SetPlrStr(mut p: libc::c_int, mut v: libc::c_int) {
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            4047 as libc::c_int,
            b"SetPlrStr: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    plr[p as usize]._pBaseStr = v;
    CalcPlrInv(p, 1 as libc::c_int as bool32_t);
    if plr[p as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[p as usize]
            ._pDamageMod = (plr[p as usize]._pStrength + plr[p as usize]._pDexterity)
            * plr[p as usize]._pLevel as libc::c_int / 200 as libc::c_int;
    } else {
        plr[p as usize]
            ._pDamageMod = plr[p as usize]._pStrength
            * plr[p as usize]._pLevel as libc::c_int / 100 as libc::c_int;
    };
}
#[no_mangle]
pub unsafe extern "C" fn SetPlrMag(mut p: libc::c_int, mut v: libc::c_int) {
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            4060 as libc::c_int,
            b"SetPlrMag: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    plr[p as usize]._pBaseMag = v;
    v = v << MANA_SHIFT as libc::c_int;
    if plr[p as usize]._pClass as libc::c_int == CLASS_SORCEROR as libc::c_int {
        v = v << 1 as libc::c_int;
    }
    plr[p as usize]._pMaxManaBase = v;
    plr[p as usize]._pMaxMana = v;
    CalcPlrInv(p, 1 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn SetPlrDex(mut p: libc::c_int, mut v: libc::c_int) {
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            4074 as libc::c_int,
            b"SetPlrDex: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    plr[p as usize]._pBaseDex = v;
    CalcPlrInv(p, 1 as libc::c_int as bool32_t);
    if plr[p as usize]._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        plr[p as usize]
            ._pDamageMod = (plr[p as usize]._pStrength + plr[p as usize]._pDexterity)
            * plr[p as usize]._pLevel as libc::c_int / 200 as libc::c_int;
    } else {
        plr[p as usize]
            ._pDamageMod = plr[p as usize]._pStrength
            * plr[p as usize]._pLevel as libc::c_int / 100 as libc::c_int;
    };
}
#[no_mangle]
pub unsafe extern "C" fn SetPlrVit(mut p: libc::c_int, mut v: libc::c_int) {
    if p as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            4087 as libc::c_int,
            b"SetPlrVit: illegal player %d\0" as *const u8 as *const libc::c_char,
            p,
        );
    }
    plr[p as usize]._pBaseVit = v;
    v = v << HP_SHIFT as libc::c_int;
    if plr[p as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        v = v << 1 as libc::c_int;
    }
    plr[p as usize]._pHPBase = v;
    plr[p as usize]._pMaxHPBase = v;
    CalcPlrInv(p, 1 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn InitDungMsgs(mut pnum: libc::c_int) {
    if pnum as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            4101 as libc::c_int,
            b"InitDungMsgs: illegal player %d\0" as *const u8 as *const libc::c_char,
            pnum,
        );
    }
    plr[pnum as usize].pDungMsgs = 0 as libc::c_int as uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn PlayDungMsgs() {
    if myplr as uint32_t >= MAX_PLRS as libc::c_int as uint32_t {
        app_fatal_(
            b"src/player.c\0" as *const u8 as *const libc::c_char,
            4108 as libc::c_int,
            b"PlayDungMsgs: illegal player %d\0" as *const u8 as *const libc::c_char,
            myplr,
        );
    }
    if currlevel as libc::c_int == 1 as libc::c_int
        && plr[myplr as usize]._pLvlVisited[1 as libc::c_int as usize] == 0
        && gbMaxPlayers as libc::c_int == 1 as libc::c_int
        && plr[myplr as usize].pDungMsgs as libc::c_int & DUNGMSG_1 as libc::c_int == 0
    {
        sfxdelay = 40 as libc::c_int;
        if plr[myplr as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            sfxdnum = PS_WARR97 as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_ROGUE as libc::c_int
        {
            sfxdnum = PS_ROGUE97 as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_SORCEROR as libc::c_int
        {
            sfxdnum = PS_MAGE97 as libc::c_int;
        }
        plr[myplr as usize]
            .pDungMsgs = (plr[myplr as usize].pDungMsgs as libc::c_int
            | DUNGMSG_1 as libc::c_int) as uint8_t;
    } else if currlevel as libc::c_int == 5 as libc::c_int
        && plr[myplr as usize]._pLvlVisited[5 as libc::c_int as usize] == 0
        && gbMaxPlayers as libc::c_int == 1 as libc::c_int
        && plr[myplr as usize].pDungMsgs as libc::c_int & DUNGMSG_2 as libc::c_int == 0
    {
        sfxdelay = 40 as libc::c_int;
        if plr[myplr as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            sfxdnum = PS_WARR96B as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_ROGUE as libc::c_int
        {
            sfxdnum = PS_ROGUE96 as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_SORCEROR as libc::c_int
        {
            sfxdnum = PS_MAGE96 as libc::c_int;
        }
        plr[myplr as usize]
            .pDungMsgs = (plr[myplr as usize].pDungMsgs as libc::c_int
            | DUNGMSG_2 as libc::c_int) as uint8_t;
    } else if currlevel as libc::c_int == 9 as libc::c_int
        && plr[myplr as usize]._pLvlVisited[9 as libc::c_int as usize] == 0
        && gbMaxPlayers as libc::c_int == 1 as libc::c_int
        && plr[myplr as usize].pDungMsgs as libc::c_int & DUNGMSG_3 as libc::c_int == 0
    {
        sfxdelay = 40 as libc::c_int;
        if plr[myplr as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            sfxdnum = PS_WARR98 as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_ROGUE as libc::c_int
        {
            sfxdnum = PS_ROGUE98 as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_SORCEROR as libc::c_int
        {
            sfxdnum = PS_MAGE98 as libc::c_int;
        }
        plr[myplr as usize]
            .pDungMsgs = (plr[myplr as usize].pDungMsgs as libc::c_int
            | DUNGMSG_3 as libc::c_int) as uint8_t;
    } else if currlevel as libc::c_int == 13 as libc::c_int
        && plr[myplr as usize]._pLvlVisited[13 as libc::c_int as usize] == 0
        && gbMaxPlayers as libc::c_int == 1 as libc::c_int
        && plr[myplr as usize].pDungMsgs as libc::c_int & DUNGMSG_4 as libc::c_int == 0
    {
        sfxdelay = 40 as libc::c_int;
        if plr[myplr as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            sfxdnum = PS_WARR99 as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_ROGUE as libc::c_int
        {
            sfxdnum = PS_ROGUE99 as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_SORCEROR as libc::c_int
        {
            sfxdnum = PS_MAGE99 as libc::c_int;
        }
        plr[myplr as usize]
            .pDungMsgs = (plr[myplr as usize].pDungMsgs as libc::c_int
            | DUNGMSG_4 as libc::c_int) as uint8_t;
    } else if currlevel as libc::c_int == 16 as libc::c_int
        && plr[myplr as usize]._pLvlVisited[15 as libc::c_int as usize] == 0
        && gbMaxPlayers as libc::c_int == 1 as libc::c_int
        && plr[myplr as usize].pDungMsgs as libc::c_int & DUNGMSG_5 as libc::c_int == 0
    {
        sfxdelay = 40 as libc::c_int;
        if plr[myplr as usize]._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
            sfxdnum = PS_DIABLVLINT as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_ROGUE as libc::c_int
        {
            sfxdnum = PS_DIABLVLINT as libc::c_int;
        } else if plr[myplr as usize]._pClass as libc::c_int
            == CLASS_SORCEROR as libc::c_int
        {
            sfxdnum = PS_DIABLVLINT as libc::c_int;
        }
        plr[myplr as usize]
            .pDungMsgs = (plr[myplr as usize].pDungMsgs as libc::c_int
            | DUNGMSG_5 as libc::c_int) as uint8_t;
    } else {
        sfxdelay = 0 as libc::c_int;
    };
}
