use ::libc;
extern "C" {
    pub type _IO_wide_data;
    pub type _IO_codecvt;
    pub type _IO_marker;
    fn stricmp_(str1: *const libc::c_char, str2: *const libc::c_char) -> libc::c_int;
    fn SDL_GetTicks() -> Uint32;
    fn strncpy(
        _: *mut libc::c_char,
        _: *const libc::c_char,
        _: libc::c_ulong,
    ) -> *mut libc::c_char;
    fn strcpy(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn ftell(__stream: *mut FILE) -> libc::c_long;
    fn fseek(
        __stream: *mut FILE,
        __off: libc::c_long,
        __whence: libc::c_int,
    ) -> libc::c_int;
    fn fwrite(
        _: *const libc::c_void,
        _: libc::c_ulong,
        _: libc::c_ulong,
        _: *mut FILE,
    ) -> libc::c_ulong;
    fn fread(
        _: *mut libc::c_void,
        _: libc::c_ulong,
        _: libc::c_ulong,
        _: *mut FILE,
    ) -> libc::c_ulong;
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn fopen(_: *const libc::c_char, _: *const libc::c_char) -> *mut FILE;
    fn fclose(__stream: *mut FILE) -> libc::c_int;
    fn mkdir(__path: *const libc::c_char, __mode: __mode_t) -> libc::c_int;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn DiabloAllocPtr(dwBytes: uint32_t) -> *mut uint8_t;
    fn AddLight(_: libc::c_int, _: libc::c_int, _: libc::c_int) -> libc::c_int;
    fn AddVision(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: bool32_t,
    ) -> libc::c_int;
    fn PackPlayer(p: *mut PkPlayerStruct, pnum: libc::c_int, manashield: bool32_t);
    fn UnPackPlayer(pPack: *const PkPlayerStruct, pnum: libc::c_int, killok: bool32_t);
    fn CreatePlayer(_: libc::c_int, _: int8_t);
    static mut leveltype: uint8_t;
    static mut setlevel: uint8_t;
    static mut setlvlnum: uint8_t;
    static mut currlevel: uint8_t;
    static mut gszHero: [libc::c_char; 16];
    static mut gbMaxPlayers: uint8_t;
    static mut gbValidSaveFile: bool32_t;
    static mut StrengthTbl: [libc::c_int; 3];
    static mut MagicTbl: [libc::c_int; 3];
    static mut DexterityTbl: [libc::c_int; 3];
    static mut VitalityTbl: [libc::c_int; 3];
    static mut PlrGFXAnimLens: [[int8_t; 11]; 3];
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type __mode_t = libc::c_uint;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type size_t = libc::c_ulong;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _IO_FILE {
    pub _flags: libc::c_int,
    pub _IO_read_ptr: *mut libc::c_char,
    pub _IO_read_end: *mut libc::c_char,
    pub _IO_read_base: *mut libc::c_char,
    pub _IO_write_base: *mut libc::c_char,
    pub _IO_write_ptr: *mut libc::c_char,
    pub _IO_write_end: *mut libc::c_char,
    pub _IO_buf_base: *mut libc::c_char,
    pub _IO_buf_end: *mut libc::c_char,
    pub _IO_save_base: *mut libc::c_char,
    pub _IO_backup_base: *mut libc::c_char,
    pub _IO_save_end: *mut libc::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: libc::c_int,
    pub _flags2: libc::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: libc::c_ushort,
    pub _vtable_offset: libc::c_schar,
    pub _shortbuf: [libc::c_char; 1],
    pub _lock: *mut libc::c_void,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut libc::c_void,
    pub __pad5: size_t,
    pub _mode: libc::c_int,
    pub _unused2: [libc::c_char; 20],
}
pub type _IO_lock_t = ();
pub type FILE = _IO_FILE;
pub type Uint32 = uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const MAX_CHARACTERS: C2RustUnnamed = 10;
pub const SAVE_TICKS: C2RustUnnamed = 60000;
pub const ARCHIVE_PRIORITY: C2RustUnnamed = 28672;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const CLASS_SORCEROR: C2RustUnnamed_0 = 2;
pub const CLASS_ROGUE: C2RustUnnamed_0 = 1;
pub const CLASS_WARRIOR: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_1 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_1 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_1 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_1 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_1 = 32;
pub const MAXSPD: C2RustUnnamed_1 = 8;
pub const MAXINV: C2RustUnnamed_1 = 40;
pub const MAXPATHLEN: C2RustUnnamed_1 = 25;
pub const MANA_SHIFT: C2RustUnnamed_1 = 6;
pub const HP_SHIFT: C2RustUnnamed_1 = 6;
pub const NUM_CLASSES: C2RustUnnamed_1 = 3;
pub const MAXPACKLEN: C2RustUnnamed_1 = 256;
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct PkItemStruct {
    pub iSeed: libc::c_int,
    pub iCreateInfo: uint16_t,
    pub idx: uint16_t,
    pub bId: uint8_t,
    pub bDur: uint8_t,
    pub bMDur: uint8_t,
    pub bCh: uint8_t,
    pub bMCh: uint8_t,
    pub wValue: uint16_t,
    pub dwBuff: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct PkPlayerStruct {
    pub archiveTime: uint64_t,
    pub destAction: uint8_t,
    pub destParam1: uint8_t,
    pub destParam2: uint8_t,
    pub plrlevel: uint8_t,
    pub px: uint8_t,
    pub py: uint8_t,
    pub targx: uint8_t,
    pub targy: uint8_t,
    pub pName: [libc::c_char; 32],
    pub pClass: uint8_t,
    pub pBaseStr: uint8_t,
    pub pBaseMag: uint8_t,
    pub pBaseDex: uint8_t,
    pub pBaseVit: uint8_t,
    pub pLevel: uint8_t,
    pub pStatPts: uint8_t,
    pub pExperience: int32_t,
    pub pGold: int32_t,
    pub pHPBase: int32_t,
    pub pMaxHPBase: int32_t,
    pub pManaBase: int32_t,
    pub pMaxManaBase: int32_t,
    pub pSplLvl: [uint8_t; 37],
    pub pMemSpells: uint64_t,
    pub InvBody: [PkItemStruct; 7],
    pub InvList: [PkItemStruct; 40],
    pub InvGrid: [int8_t; 40],
    pub _pNumInv: uint8_t,
    pub SpdList: [PkItemStruct; 8],
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
pub type _ui_classes = libc::c_uint;
pub const UI_NUM_CLASSES: _ui_classes = 3;
pub const UI_SORCERER: _ui_classes = 2;
pub const UI_ROGUE: _ui_classes = 1;
pub const UI_WARRIOR: _ui_classes = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TUIDEFSTATS {
    pub strength: uint16_t,
    pub magic: uint16_t,
    pub dexterity: uint16_t,
    pub vitality: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TUIHEROINFO {
    pub next: *mut TUIHEROINFO,
    pub name: [libc::c_char; 16],
    pub level: uint16_t,
    pub heroclass: uint8_t,
    pub herorank: uint8_t,
    pub strength: uint16_t,
    pub magic: uint16_t,
    pub dexterity: uint16_t,
    pub vitality: uint16_t,
    pub gold: uint32_t,
    pub hassaved: bool32_t,
    pub spawned: bool32_t,
}
pub type ENUMHEROPROC = Option::<unsafe extern "C" fn(*mut TUIHEROINFO) -> bool32_t>;
pub const MAX_PLRS: C2RustUnnamed_3 = 4;
pub const MINE: C2RustUnnamed_2 = 1;
pub const LIGHT_RADIUS: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_3 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_3 = 92160;
pub const BTMBUFFY: C2RustUnnamed_3 = 144;
pub const BTMBUFFX: C2RustUnnamed_3 = 640;
pub const BUFFERSIZE: C2RustUnnamed_3 = 503808;
pub const BUFFERY: C2RustUnnamed_3 = 656;
pub const BUFFERX: C2RustUnnamed_3 = 768;
pub const GAMEY: C2RustUnnamed_3 = 352;
pub const CTRLPANY: C2RustUnnamed_3 = 128;
pub const TOTALY: C2RustUnnamed_3 = 480;
pub const TOTALX: C2RustUnnamed_3 = 640;
static mut sgszCharNames: [[libc::c_char; 32]; 10] = [[0; 32]; 10];
static mut sgszSaveGame: [libc::c_char; 5] = unsafe {
    *::core::mem::transmute::<&[u8; 5], &[libc::c_char; 5]>(b"game\0")
};
static mut sgszSaveChar: [libc::c_char; 5] = unsafe {
    *::core::mem::transmute::<&[u8; 5], &[libc::c_char; 5]>(b"hero\0")
};
static mut sgszPermSaveLevel_d: [libc::c_char; 10] = unsafe {
    *::core::mem::transmute::<&[u8; 10], &[libc::c_char; 10]>(b"perml%02d\0")
};
static mut sgszPermSaveSLevel_d: [libc::c_char; 10] = unsafe {
    *::core::mem::transmute::<&[u8; 10], &[libc::c_char; 10]>(b"perms%02d\0")
};
static mut slSaveTime: int32_t = 0 as libc::c_int;
#[no_mangle]
pub static mut dwCharLoadChar: uint32_t = 0;
unsafe extern "C" fn name_2_file_index(mut pszName: *const libc::c_char) -> uint32_t {
    let mut d: uint32_t = 0;
    d = 0 as libc::c_int as uint32_t;
    while d < MAX_CHARACTERS as libc::c_int as uint32_t {
        if stricmp_((sgszCharNames[d as usize]).as_mut_ptr(), pszName) == 0 {
            break;
        }
        d = d.wrapping_add(1);
        d;
    }
    return d;
}
unsafe extern "C" fn LoadCharacter(
    mut dst_pack_player: *mut PkPlayerStruct,
) -> bool32_t {
    if dst_pack_player.is_null() {
        assert_fail(
            54 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dst_pack_player\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut szPath: [libc::c_char; 260] = [0; 260];
    sprintf(
        szPath.as_mut_ptr(),
        b"save/hero_%d/%s\0" as *const u8 as *const libc::c_char,
        dwCharLoadChar,
        sgszSaveChar.as_ptr(),
    );
    let mut f: *mut FILE = fopen(
        szPath.as_mut_ptr(),
        b"rb\0" as *const u8 as *const libc::c_char,
    );
    if f.is_null() {
        return 0 as libc::c_int as bool32_t;
    }
    let mut size: libc::c_int = ::core::mem::size_of::<PkPlayerStruct>() as libc::c_ulong
        as libc::c_int;
    if fread(
        dst_pack_player as *mut libc::c_void,
        1 as libc::c_int as libc::c_ulong,
        size as libc::c_ulong,
        f,
    ) != size as libc::c_ulong
    {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            65 as libc::c_int,
            b"unable to read contents (%d bytes) of file '%s'\0" as *const u8
                as *const libc::c_char,
            size,
            szPath.as_mut_ptr(),
        );
    }
    if fclose(f) != 0 as libc::c_int {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            68 as libc::c_int,
            b"unable to close file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn SaveCharacter(mut src_pack_player: *const PkPlayerStruct) {
    let mut szPath: [libc::c_char; 260] = [0; 260];
    mkdir(
        b"save\0" as *const u8 as *const libc::c_char,
        0o755 as libc::c_int as __mode_t,
    );
    sprintf(
        szPath.as_mut_ptr(),
        b"save/hero_%d\0" as *const u8 as *const libc::c_char,
        name_2_file_index((plr[0 as libc::c_int as usize]._pName).as_mut_ptr()),
    );
    mkdir(szPath.as_mut_ptr(), 0o755 as libc::c_int as __mode_t);
    sprintf(
        szPath.as_mut_ptr(),
        b"save/hero_%d/%s\0" as *const u8 as *const libc::c_char,
        name_2_file_index((plr[0 as libc::c_int as usize]._pName).as_mut_ptr()),
        sgszSaveChar.as_ptr(),
    );
    let mut f: *mut FILE = fopen(
        szPath.as_mut_ptr(),
        b"wb\0" as *const u8 as *const libc::c_char,
    );
    if f.is_null() {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            83 as libc::c_int,
            b"unable to open file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
    let mut size: libc::c_int = ::core::mem::size_of::<PkPlayerStruct>() as libc::c_ulong
        as libc::c_int;
    if fwrite(
        src_pack_player as *const libc::c_void,
        1 as libc::c_int as libc::c_ulong,
        size as libc::c_ulong,
        f,
    ) != size as libc::c_ulong
    {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            87 as libc::c_int,
            b"unable to write contents (%d bytes) to file '%s'\0" as *const u8
                as *const libc::c_char,
            size,
            szPath.as_mut_ptr(),
        );
    }
    if fclose(f) != 0 as libc::c_int {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            90 as libc::c_int,
            b"unable to close file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
}
unsafe extern "C" fn check_valid_save(mut dwChar: uint32_t) -> bool32_t {
    if !(dwChar < MAX_CHARACTERS as libc::c_int as uint32_t) {
        assert_fail(
            96 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dwChar < MAX_CHARACTERS\0" as *const u8 as *const libc::c_char,
        );
    }
    if gbMaxPlayers as libc::c_int != 1 as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    let mut szPath: [libc::c_char; 260] = [0; 260];
    sprintf(
        szPath.as_mut_ptr(),
        b"save/hero_%d/%s\0" as *const u8 as *const libc::c_char,
        dwChar,
        sgszSaveGame.as_ptr(),
    );
    let mut f: *mut FILE = fopen(
        szPath.as_mut_ptr(),
        b"rb\0" as *const u8 as *const libc::c_char,
    );
    if f.is_null() {
        return 0 as libc::c_int as bool32_t;
    }
    fclose(f);
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn UpdatePlayerFile() {
    if !(myplr >= 0 as libc::c_int && myplr < MAX_PLRS as libc::c_int) {
        assert_fail(
            116 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"myplr >= 0 && myplr < MAX_PLRS\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut pack: PkPlayerStruct = PkPlayerStruct {
        archiveTime: 0,
        destAction: 0,
        destParam1: 0,
        destParam2: 0,
        plrlevel: 0,
        px: 0,
        py: 0,
        targx: 0,
        targy: 0,
        pName: [0; 32],
        pClass: 0,
        pBaseStr: 0,
        pBaseMag: 0,
        pBaseDex: 0,
        pBaseVit: 0,
        pLevel: 0,
        pStatPts: 0,
        pExperience: 0,
        pGold: 0,
        pHPBase: 0,
        pMaxHPBase: 0,
        pManaBase: 0,
        pMaxManaBase: 0,
        pSplLvl: [0; 37],
        pMemSpells: 0,
        InvBody: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 7],
        InvList: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 40],
        InvGrid: [0; 40],
        _pNumInv: 0,
        SpdList: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 8],
        pTownWarps: 0,
        pDungMsgs: 0,
        pLvlLoad: 0,
        pBattleNet: 0,
        pManaShield: 0,
        bReserved6: 0,
        bReserved7: 0,
        bReserved8: 0,
        wReserved1: 0,
        wReserved2: 0,
        wReserved3: 0,
        wReserved4: 0,
        wReserved5: 0,
        wReserved6: 0,
        wReserved7: 0,
        wReserved8: 0,
        pDiabloKillLevel: 0,
        dwReserved2: 0,
        dwReserved3: 0,
        dwReserved4: 0,
        dwReserved5: 0,
        dwReserved6: 0,
        dwReserved7: 0,
        dwReserved8: 0,
    };
    PackPlayer(
        &mut pack,
        myplr,
        (gbMaxPlayers as libc::c_int == 1 as libc::c_int) as libc::c_int as bool32_t,
    );
    SaveCharacter(&mut pack);
}
#[no_mangle]
pub unsafe extern "C" fn pfile_create_player_description() -> bool32_t {
    let mut heroinfo: TUIHEROINFO = TUIHEROINFO {
        next: 0 as *mut TUIHEROINFO,
        name: [0; 16],
        level: 0,
        heroclass: 0,
        herorank: 0,
        strength: 0,
        magic: 0,
        dexterity: 0,
        vitality: 0,
        gold: 0,
        hassaved: 0,
        spawned: 0,
    };
    myplr = 0 as libc::c_int;
    SetupLocalPlayer();
    game_2_ui_player(
        &mut *plr.as_mut_ptr().offset(0 as libc::c_int as isize),
        &mut heroinfo,
        gbValidSaveFile,
    );
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn ui_2_game_class(mut heroclass: libc::c_int) -> libc::c_char {
    if heroclass == UI_WARRIOR as libc::c_int {
        return CLASS_WARRIOR as libc::c_int as libc::c_char;
    }
    if heroclass == UI_ROGUE as libc::c_int {
        return CLASS_ROGUE as libc::c_int as libc::c_char;
    }
    return CLASS_SORCEROR as libc::c_int as libc::c_char;
}
unsafe extern "C" fn game_2_ui_class(mut p: *const PlayerStruct) -> uint8_t {
    if (*p)._pClass as libc::c_int == CLASS_WARRIOR as libc::c_int {
        return UI_WARRIOR as libc::c_int as uint8_t;
    }
    if (*p)._pClass as libc::c_int == CLASS_ROGUE as libc::c_int {
        return UI_ROGUE as libc::c_int as uint8_t;
    }
    return UI_SORCERER as libc::c_int as uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn game_2_ui_player(
    mut p: *const PlayerStruct,
    mut heroinfo: *mut TUIHEROINFO,
    mut bHasSaveFile: bool32_t,
) {
    memset(
        heroinfo as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<TUIHEROINFO>() as libc::c_ulong,
    );
    strncpy(
        ((*heroinfo).name).as_mut_ptr(),
        ((*p)._pName).as_ptr(),
        (16 as libc::c_int - 1 as libc::c_int) as libc::c_ulong,
    );
    (*heroinfo)
        .name[(16 as libc::c_int - 1 as libc::c_int)
        as usize] = 0 as libc::c_int as libc::c_char;
    (*heroinfo).level = (*p)._pLevel as uint16_t;
    (*heroinfo).heroclass = game_2_ui_class(p);
    (*heroinfo).strength = (*p)._pStrength as uint16_t;
    (*heroinfo).magic = (*p)._pMagic as uint16_t;
    (*heroinfo).dexterity = (*p)._pDexterity as uint16_t;
    (*heroinfo).vitality = (*p)._pVitality as uint16_t;
    (*heroinfo).gold = (*p)._pGold as uint32_t;
    (*heroinfo).hassaved = bHasSaveFile;
    (*heroinfo).herorank = (*p).pDiabloKillLevel as uint8_t;
    (*heroinfo).spawned = 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn HeroInfoFromHero(
    mut src: *const PkPlayerStruct,
    mut dst: *mut TUIHEROINFO,
    mut has_save_file: bool32_t,
) {
    memset(
        dst as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<TUIHEROINFO>() as libc::c_ulong,
    );
    strncpy(
        ((*dst).name).as_mut_ptr(),
        ((*src).pName).as_ptr(),
        (16 as libc::c_int - 1 as libc::c_int) as libc::c_ulong,
    );
    (*dst)
        .name[(16 as libc::c_int - 1 as libc::c_int)
        as usize] = '\0' as i32 as libc::c_char;
    (*dst).level = (*src).pLevel as uint16_t;
    (*dst).heroclass = (*src).pClass;
    (*dst).strength = (*src).pBaseStr as uint16_t;
    (*dst).magic = (*src).pBaseMag as uint16_t;
    (*dst).dexterity = (*src).pBaseDex as uint16_t;
    (*dst).vitality = (*src).pBaseVit as uint16_t;
    (*dst).gold = (*src).pGold as uint32_t;
    (*dst).hassaved = has_save_file;
    (*dst).herorank = (*src).pDiabloKillLevel as uint8_t;
    (*dst).spawned = 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn UiEnumHeroes(mut enumproc: ENUMHEROPROC) -> bool32_t {
    memset(
        sgszCharNames.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[libc::c_char; 32]; 10]>() as libc::c_ulong,
    );
    let mut dwChar: uint32_t = 0 as libc::c_int as uint32_t;
    while dwChar < MAX_CHARACTERS as libc::c_int as uint32_t {
        let mut pack: PkPlayerStruct = PkPlayerStruct {
            archiveTime: 0,
            destAction: 0,
            destParam1: 0,
            destParam2: 0,
            plrlevel: 0,
            px: 0,
            py: 0,
            targx: 0,
            targy: 0,
            pName: [0; 32],
            pClass: 0,
            pBaseStr: 0,
            pBaseMag: 0,
            pBaseDex: 0,
            pBaseVit: 0,
            pLevel: 0,
            pStatPts: 0,
            pExperience: 0,
            pGold: 0,
            pHPBase: 0,
            pMaxHPBase: 0,
            pManaBase: 0,
            pMaxManaBase: 0,
            pSplLvl: [0; 37],
            pMemSpells: 0,
            InvBody: [PkItemStruct {
                iSeed: 0,
                iCreateInfo: 0,
                idx: 0,
                bId: 0,
                bDur: 0,
                bMDur: 0,
                bCh: 0,
                bMCh: 0,
                wValue: 0,
                dwBuff: 0,
            }; 7],
            InvList: [PkItemStruct {
                iSeed: 0,
                iCreateInfo: 0,
                idx: 0,
                bId: 0,
                bDur: 0,
                bMDur: 0,
                bCh: 0,
                bMCh: 0,
                wValue: 0,
                dwBuff: 0,
            }; 40],
            InvGrid: [0; 40],
            _pNumInv: 0,
            SpdList: [PkItemStruct {
                iSeed: 0,
                iCreateInfo: 0,
                idx: 0,
                bId: 0,
                bDur: 0,
                bMDur: 0,
                bCh: 0,
                bMCh: 0,
                wValue: 0,
                dwBuff: 0,
            }; 8],
            pTownWarps: 0,
            pDungMsgs: 0,
            pLvlLoad: 0,
            pBattleNet: 0,
            pManaShield: 0,
            bReserved6: 0,
            bReserved7: 0,
            bReserved8: 0,
            wReserved1: 0,
            wReserved2: 0,
            wReserved3: 0,
            wReserved4: 0,
            wReserved5: 0,
            wReserved6: 0,
            wReserved7: 0,
            wReserved8: 0,
            pDiabloKillLevel: 0,
            dwReserved2: 0,
            dwReserved3: 0,
            dwReserved4: 0,
            dwReserved5: 0,
            dwReserved6: 0,
            dwReserved7: 0,
            dwReserved8: 0,
        };
        let mut heroinfo: TUIHEROINFO = TUIHEROINFO {
            next: 0 as *mut TUIHEROINFO,
            name: [0; 16],
            level: 0,
            heroclass: 0,
            herorank: 0,
            strength: 0,
            magic: 0,
            dexterity: 0,
            vitality: 0,
            gold: 0,
            hassaved: 0,
            spawned: 0,
        };
        dwCharLoadChar = dwChar;
        let mut bResult: bool32_t = LoadCharacter(&mut pack);
        if bResult != 0 {
            if !(::core::mem::size_of::<[libc::c_char; 32]>() as libc::c_ulong
                == ::core::mem::size_of::<[libc::c_char; 32]>() as libc::c_ulong)
            {
                assert_fail(
                    199 as libc::c_int,
                    b"src/pfile.c\0" as *const u8 as *const libc::c_char,
                    b"sizeof(sgszCharNames[dwChar]) == sizeof(pack.pName)\0" as *const u8
                        as *const libc::c_char,
                );
            }
            strcpy(
                (sgszCharNames[dwChar as usize]).as_mut_ptr(),
                (pack.pName).as_mut_ptr(),
            );
            HeroInfoFromHero(&mut pack, &mut heroinfo, check_valid_save(dwChar));
            if pack.pHPBase >> HP_SHIFT as libc::c_int > 0 as libc::c_int {
                let mut stand_nframes: libc::c_int = 0;
                if leveltype as libc::c_int == 0 as libc::c_int {
                    stand_nframes = PlrGFXAnimLens[pack.pClass
                        as usize][7 as libc::c_int as usize] as libc::c_int;
                } else {
                    stand_nframes = PlrGFXAnimLens[pack.pClass
                        as usize][0 as libc::c_int as usize] as libc::c_int;
                }
                random_(
                    b"src/pfile.c\0" as *const u8 as *const libc::c_char,
                    225 as libc::c_int,
                    2 as libc::c_int as uint8_t,
                    stand_nframes - 1 as libc::c_int,
                );
                random_(
                    b"src/pfile.c\0" as *const u8 as *const libc::c_char,
                    226 as libc::c_int,
                    2 as libc::c_int as uint8_t,
                    3 as libc::c_int,
                );
            }
            AddLight(
                pack.px as libc::c_int,
                pack.py as libc::c_int,
                LIGHT_RADIUS as libc::c_int,
            );
            AddVision(
                pack.px as libc::c_int,
                pack.py as libc::c_int,
                LIGHT_RADIUS as libc::c_int,
                MINE as libc::c_int as bool32_t,
            );
            enumproc.expect("non-null function pointer")(&mut heroinfo);
        }
        dwChar = dwChar.wrapping_add(1);
        dwChar;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn UiGetDefaultCharStats(
    mut heroclass: libc::c_int,
    mut defaultstats: *mut TUIDEFSTATS,
) -> bool32_t {
    let mut nClass: libc::c_int = ui_2_game_class(heroclass) as libc::c_int;
    (*defaultstats).strength = StrengthTbl[nClass as usize] as uint16_t;
    (*defaultstats).magic = MagicTbl[nClass as usize] as uint16_t;
    (*defaultstats).dexterity = DexterityTbl[nClass as usize] as uint16_t;
    (*defaultstats).vitality = VitalityTbl[nClass as usize] as uint16_t;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn UiCreateHero(mut heroinfo: *mut TUIHEROINFO) -> bool32_t {
    if (*heroinfo).name[0 as libc::c_int as usize] == 0 {
        assert_fail(
            264 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"heroinfo->name[0]\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut dwChar: uint32_t = name_2_file_index(((*heroinfo).name).as_mut_ptr());
    if dwChar == MAX_CHARACTERS as libc::c_int as uint32_t {
        dwChar = 0 as libc::c_int as uint32_t;
        while dwChar < MAX_CHARACTERS as libc::c_int as uint32_t {
            if sgszCharNames[dwChar as usize][0 as libc::c_int as usize] == 0 {
                break;
            }
            dwChar = dwChar.wrapping_add(1);
            dwChar;
        }
    }
    if dwChar == MAX_CHARACTERS as libc::c_int as uint32_t {
        return 0 as libc::c_int as bool32_t;
    }
    strncpy(
        (sgszCharNames[dwChar as usize]).as_mut_ptr(),
        ((*heroinfo).name).as_mut_ptr(),
        PLR_NAME_LEN as libc::c_int as libc::c_ulong,
    );
    sgszCharNames[dwChar
        as usize][(PLR_NAME_LEN as libc::c_int - 1 as libc::c_int)
        as usize] = '\0' as i32 as libc::c_char;
    CreatePlayer(
        0 as libc::c_int,
        ui_2_game_class((*heroinfo).heroclass as libc::c_int) as int8_t,
    );
    strncpy(
        (plr[0 as libc::c_int as usize]._pName).as_mut_ptr(),
        ((*heroinfo).name).as_mut_ptr(),
        PLR_NAME_LEN as libc::c_int as libc::c_ulong,
    );
    plr[0 as libc::c_int as usize]
        ._pName[(PLR_NAME_LEN as libc::c_int - 1 as libc::c_int)
        as usize] = '\0' as i32 as libc::c_char;
    let mut pack: PkPlayerStruct = PkPlayerStruct {
        archiveTime: 0,
        destAction: 0,
        destParam1: 0,
        destParam2: 0,
        plrlevel: 0,
        px: 0,
        py: 0,
        targx: 0,
        targy: 0,
        pName: [0; 32],
        pClass: 0,
        pBaseStr: 0,
        pBaseMag: 0,
        pBaseDex: 0,
        pBaseVit: 0,
        pLevel: 0,
        pStatPts: 0,
        pExperience: 0,
        pGold: 0,
        pHPBase: 0,
        pMaxHPBase: 0,
        pManaBase: 0,
        pMaxManaBase: 0,
        pSplLvl: [0; 37],
        pMemSpells: 0,
        InvBody: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 7],
        InvList: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 40],
        InvGrid: [0; 40],
        _pNumInv: 0,
        SpdList: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 8],
        pTownWarps: 0,
        pDungMsgs: 0,
        pLvlLoad: 0,
        pBattleNet: 0,
        pManaShield: 0,
        bReserved6: 0,
        bReserved7: 0,
        bReserved8: 0,
        wReserved1: 0,
        wReserved2: 0,
        wReserved3: 0,
        wReserved4: 0,
        wReserved5: 0,
        wReserved6: 0,
        wReserved7: 0,
        wReserved8: 0,
        pDiabloKillLevel: 0,
        dwReserved2: 0,
        dwReserved3: 0,
        dwReserved4: 0,
        dwReserved5: 0,
        dwReserved6: 0,
        dwReserved7: 0,
        dwReserved8: 0,
    };
    PackPlayer(&mut pack, 0 as libc::c_int, 1 as libc::c_int as bool32_t);
    SaveCharacter(&mut pack);
    game_2_ui_player(
        &mut *plr.as_mut_ptr().offset(0 as libc::c_int as isize),
        heroinfo,
        0 as libc::c_int as bool32_t,
    );
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn UiDeleteHero(mut heroinfo: *mut TUIHEROINFO) -> bool32_t {
    let mut dwChar: uint32_t = name_2_file_index(((*heroinfo).name).as_mut_ptr());
    if dwChar >= MAX_CHARACTERS as libc::c_int as uint32_t {
        return 1 as libc::c_int as bool32_t;
    }
    sgszCharNames[dwChar
        as usize][0 as libc::c_int as usize] = '\0' as i32 as libc::c_char;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SetupLocalPlayer() {
    if !(myplr >= 0 as libc::c_int && myplr < MAX_PLRS as libc::c_int) {
        assert_fail(
            317 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"myplr >= 0 && myplr < MAX_PLRS\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut dwChar: uint32_t = name_2_file_index(gszHero.as_mut_ptr());
    if !(dwChar != MAX_CHARACTERS as libc::c_int as uint32_t) {
        assert_fail(
            319 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dwChar != MAX_CHARACTERS\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut pack: PkPlayerStruct = PkPlayerStruct {
        archiveTime: 0,
        destAction: 0,
        destParam1: 0,
        destParam2: 0,
        plrlevel: 0,
        px: 0,
        py: 0,
        targx: 0,
        targy: 0,
        pName: [0; 32],
        pClass: 0,
        pBaseStr: 0,
        pBaseMag: 0,
        pBaseDex: 0,
        pBaseVit: 0,
        pLevel: 0,
        pStatPts: 0,
        pExperience: 0,
        pGold: 0,
        pHPBase: 0,
        pMaxHPBase: 0,
        pManaBase: 0,
        pMaxManaBase: 0,
        pSplLvl: [0; 37],
        pMemSpells: 0,
        InvBody: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 7],
        InvList: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 40],
        InvGrid: [0; 40],
        _pNumInv: 0,
        SpdList: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 8],
        pTownWarps: 0,
        pDungMsgs: 0,
        pLvlLoad: 0,
        pBattleNet: 0,
        pManaShield: 0,
        bReserved6: 0,
        bReserved7: 0,
        bReserved8: 0,
        wReserved1: 0,
        wReserved2: 0,
        wReserved3: 0,
        wReserved4: 0,
        wReserved5: 0,
        wReserved6: 0,
        wReserved7: 0,
        wReserved8: 0,
        pDiabloKillLevel: 0,
        dwReserved2: 0,
        dwReserved3: 0,
        dwReserved4: 0,
        dwReserved5: 0,
        dwReserved6: 0,
        dwReserved7: 0,
        dwReserved8: 0,
    };
    dwCharLoadChar = dwChar;
    if LoadCharacter(&mut pack) == 0 {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            327 as libc::c_int,
            b"Unable to load character\0" as *const u8 as *const libc::c_char,
        );
    }
    UnPackPlayer(&mut pack, myplr, 0 as libc::c_int as bool32_t);
    gbValidSaveFile = check_valid_save(dwChar);
}
#[no_mangle]
pub unsafe extern "C" fn CreateSaveLevelName(mut szName: *mut libc::c_char) {
    let mut dwChar: uint32_t = name_2_file_index(
        (plr[myplr as usize]._pName).as_mut_ptr(),
    );
    if !(dwChar < MAX_CHARACTERS as libc::c_int as uint32_t) {
        assert_fail(
            336 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dwChar < MAX_CHARACTERS\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
        assert_fail(
            337 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
        );
    }
    if setlevel != 0 {
        sprintf(szName, sgszPermSaveSLevel_d.as_ptr(), setlvlnum as libc::c_int);
    } else {
        sprintf(szName, sgszPermSaveLevel_d.as_ptr(), currlevel as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn CreateLoadLevelName(mut szName: *mut libc::c_char) {
    let mut dwChar: uint32_t = name_2_file_index(
        (plr[myplr as usize]._pName).as_mut_ptr(),
    );
    if !(dwChar < MAX_CHARACTERS as libc::c_int as uint32_t) {
        assert_fail(
            352 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dwChar < MAX_CHARACTERS\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
        assert_fail(
            353 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
        );
    }
    if setlevel != 0 {
        sprintf(szName, sgszPermSaveSLevel_d.as_ptr(), setlvlnum as libc::c_int);
    } else {
        sprintf(szName, sgszPermSaveLevel_d.as_ptr(), currlevel as libc::c_int);
    };
}
#[no_mangle]
pub unsafe extern "C" fn CreateSaveGameName(mut szName: *mut libc::c_char) {
    let mut dwChar: uint32_t = name_2_file_index(
        (plr[myplr as usize]._pName).as_mut_ptr(),
    );
    if !(dwChar < MAX_CHARACTERS as libc::c_int as uint32_t) {
        assert_fail(
            365 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dwChar < MAX_CHARACTERS\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
        assert_fail(
            366 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
        );
    }
    strcpy(szName, sgszSaveGame.as_ptr());
}
#[no_mangle]
pub unsafe extern "C" fn WriteSaveFile(
    mut pszName: *const libc::c_char,
    mut pbData: *mut uint8_t,
    mut dwLen: uint32_t,
    mut dwDstBytes: uint32_t,
) {
    if pszName.is_null() {
        assert_fail(
            371 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"pszName\0" as *const u8 as *const libc::c_char,
        );
    }
    if pbData.is_null() {
        assert_fail(
            372 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"pbData\0" as *const u8 as *const libc::c_char,
        );
    }
    if dwLen == 0 {
        assert_fail(
            373 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dwLen\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
        assert_fail(
            374 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut dwChar: uint32_t = name_2_file_index(
        (plr[myplr as usize]._pName).as_mut_ptr(),
    );
    if !(dwChar < MAX_CHARACTERS as libc::c_int as uint32_t) {
        assert_fail(
            377 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dwChar < MAX_CHARACTERS\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut szPath: [libc::c_char; 260] = [0; 260];
    sprintf(
        szPath.as_mut_ptr(),
        b"save/hero_%d/%s\0" as *const u8 as *const libc::c_char,
        dwChar,
        pszName,
    );
    let mut f: *mut FILE = fopen(
        szPath.as_mut_ptr(),
        b"wb\0" as *const u8 as *const libc::c_char,
    );
    if f.is_null() {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            384 as libc::c_int,
            b"unable to open file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
    if fwrite(
        pbData as *const libc::c_void,
        1 as libc::c_int as libc::c_ulong,
        dwLen as libc::c_ulong,
        f,
    ) != dwLen as libc::c_ulong
    {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            387 as libc::c_int,
            b"unable to write contents (%d bytes) to file '%s'\0" as *const u8
                as *const libc::c_char,
            dwLen,
            szPath.as_mut_ptr(),
        );
    }
    if fclose(f) != 0 as libc::c_int {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            390 as libc::c_int,
            b"unable to close file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn ReadSaveFile(
    mut pszName: *const libc::c_char,
    mut pdwLen: *mut uint32_t,
) -> *mut uint8_t {
    if pszName.is_null() {
        assert_fail(
            396 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"pszName\0" as *const u8 as *const libc::c_char,
        );
    }
    if pdwLen.is_null() {
        assert_fail(
            397 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"pdwLen\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
        assert_fail(
            398 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut dwChar: uint32_t = name_2_file_index(
        (plr[myplr as usize]._pName).as_mut_ptr(),
    );
    if !(dwChar < MAX_CHARACTERS as libc::c_int as uint32_t) {
        assert_fail(
            401 as libc::c_int,
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            b"dwChar < MAX_CHARACTERS\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut szPath: [libc::c_char; 260] = [0; 260];
    sprintf(
        szPath.as_mut_ptr(),
        b"save/hero_%d/%s\0" as *const u8 as *const libc::c_char,
        dwChar,
        pszName,
    );
    let mut f: *mut FILE = fopen(
        szPath.as_mut_ptr(),
        b"rb\0" as *const u8 as *const libc::c_char,
    );
    if f.is_null() {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            408 as libc::c_int,
            b"unable to open file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
    if fseek(f, 0 as libc::c_int as libc::c_long, 2 as libc::c_int)
        == -(1 as libc::c_int)
    {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            411 as libc::c_int,
            b"unable to seek in file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
    *pdwLen = ftell(f) as uint32_t;
    if *pdwLen == -(1 as libc::c_int) as uint32_t {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            415 as libc::c_int,
            b"unable to tell current offset of file '%s'\0" as *const u8
                as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
    if fseek(f, 0 as libc::c_int as libc::c_long, 0 as libc::c_int)
        == -(1 as libc::c_int)
    {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            418 as libc::c_int,
            b"unable to seek in file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
    let mut data: *mut uint8_t = DiabloAllocPtr(*pdwLen);
    if fread(
        data as *mut libc::c_void,
        1 as libc::c_int as libc::c_ulong,
        *pdwLen as libc::c_ulong,
        f,
    ) != *pdwLen as libc::c_ulong
    {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            422 as libc::c_int,
            b"unable to read contents (%d bytes) of file '%s'\0" as *const u8
                as *const libc::c_char,
            *pdwLen,
            szPath.as_mut_ptr(),
        );
    }
    if fclose(f) != 0 as libc::c_int {
        app_fatal_(
            b"src/pfile.c\0" as *const u8 as *const libc::c_char,
            425 as libc::c_int,
            b"unable to close file '%s'\0" as *const u8 as *const libc::c_char,
            szPath.as_mut_ptr(),
        );
    }
    return data;
}
#[no_mangle]
pub unsafe extern "C" fn TimedUpdatePlayerFile(mut bForce: bool32_t) {
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        return;
    }
    let mut lCurrTime: int32_t = SDL_GetTicks() as int32_t;
    if bForce != 0 || lCurrTime - slSaveTime > SAVE_TICKS as libc::c_int {
        slSaveTime = lCurrTime;
        UpdatePlayerFile();
    }
}
