use ::libc;
extern "C" {
    fn abs(_: libc::c_int) -> libc::c_int;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    static mut nSolidTable: [uint8_t; 2049];
    static mut dPiece: [[libc::c_int; 112]; 112];
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint32_t = libc::c_uint;
pub type int8_t = __int8_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type C2RustUnnamed = libc::c_int;
pub const PCMD_SPELLXYD: C2RustUnnamed = 26;
pub const PCMD_SPELLPID: C2RustUnnamed = 25;
pub const PCMD_SPELLID: C2RustUnnamed = 24;
pub const PCMD_RATTACKPID: C2RustUnnamed = 23;
pub const PCMD_RATTACKID: C2RustUnnamed = 22;
pub const PCMD_ATTACKPID: C2RustUnnamed = 21;
pub const PCMD_ATTACKID: C2RustUnnamed = 20;
pub const PCMD_TELEK: C2RustUnnamed = 18;
pub const PCMD_TALK: C2RustUnnamed = 17;
pub const PCMD_REQAGETITEM: C2RustUnnamed = 16;
pub const PCMD_REQGETITEM: C2RustUnnamed = 15;
pub const PCMD_DISARM: C2RustUnnamed = 14;
pub const PCMD_OPOBJ: C2RustUnnamed = 13;
pub const PCMD_SPELL: C2RustUnnamed = 12;
pub const PCMD_BLOCK: C2RustUnnamed = 11;
pub const PCMD_RATTACK: C2RustUnnamed = 10;
pub const PCMD_ATTACK: C2RustUnnamed = 9;
pub const PCMD_WALKL: C2RustUnnamed = 8;
pub const PCMD_WALKD: C2RustUnnamed = 7;
pub const PCMD_WALKR: C2RustUnnamed = 6;
pub const PCMD_WALKU: C2RustUnnamed = 5;
pub const PCMD_WALKDL: C2RustUnnamed = 4;
pub const PCMD_WALKDR: C2RustUnnamed = 3;
pub const PCMD_WALKUL: C2RustUnnamed = 2;
pub const PCMD_WALKUR: C2RustUnnamed = 1;
pub const PCMD_STAND: C2RustUnnamed = 0;
pub const PCMD_NOTHING: C2RustUnnamed = -1;
pub type C2RustUnnamed_0 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_0 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_0 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_0 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_0 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_0 = 32;
pub const MAXSPD: C2RustUnnamed_0 = 8;
pub const MAXINV: C2RustUnnamed_0 = 40;
pub const MAXPATHLEN: C2RustUnnamed_0 = 25;
pub const MANA_SHIFT: C2RustUnnamed_0 = 6;
pub const HP_SHIFT: C2RustUnnamed_0 = 6;
pub const NUM_CLASSES: C2RustUnnamed_0 = 3;
pub const MAXPACKLEN: C2RustUnnamed_0 = 256;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct tagPATHNODE {
    pub f: int8_t,
    pub h: int8_t,
    pub g: int8_t,
    pub x: libc::c_int,
    pub y: libc::c_int,
    pub Parent: *mut tagPATHNODE,
    pub Child: [*mut tagPATHNODE; 8],
    pub NextNode: *mut tagPATHNODE,
}
pub type PATHNODE = tagPATHNODE;
pub type CHECKFUNC1 = Option::<
    unsafe extern "C" fn(libc::c_int, libc::c_int, libc::c_int) -> bool32_t,
>;
#[no_mangle]
pub static mut PNodePool: [PATHNODE; 300] = [tagPATHNODE {
    f: 0,
    h: 0,
    g: 0,
    x: 0,
    y: 0,
    Parent: 0 as *const tagPATHNODE as *mut tagPATHNODE,
    Child: [0 as *const tagPATHNODE as *mut tagPATHNODE; 8],
    NextNode: 0 as *const tagPATHNODE as *mut tagPATHNODE,
}; 300];
#[no_mangle]
pub static mut OPEN: *mut PATHNODE = 0 as *const PATHNODE as *mut PATHNODE;
#[no_mangle]
pub static mut CLOSED: *mut PATHNODE = 0 as *const PATHNODE as *mut PATHNODE;
#[no_mangle]
pub static mut tempath: [libc::c_int; 25] = [0; 25];
#[no_mangle]
pub static mut pathnodes: [PATHNODE; 300] = [tagPATHNODE {
    f: 0,
    h: 0,
    g: 0,
    x: 0,
    y: 0,
    Parent: 0 as *const tagPATHNODE as *mut tagPATHNODE,
    Child: [0 as *const tagPATHNODE as *mut tagPATHNODE; 8],
    NextNode: 0 as *const tagPATHNODE as *mut tagPATHNODE,
}; 300];
#[no_mangle]
pub static mut numpnodes: libc::c_int = 0;
#[no_mangle]
pub static mut Stack: [*mut PATHNODE; 300] = [0 as *const PATHNODE
    as *mut PATHNODE; 300];
#[no_mangle]
pub static mut numstack: libc::c_int = 0;
static mut DirCmd: [int8_t; 9] = [
    PCMD_WALKU as libc::c_int as int8_t,
    PCMD_WALKUR as libc::c_int as int8_t,
    PCMD_WALKR as libc::c_int as int8_t,
    PCMD_WALKUL as libc::c_int as int8_t,
    0 as libc::c_int as int8_t,
    PCMD_WALKDR as libc::c_int as int8_t,
    PCMD_WALKL as libc::c_int as int8_t,
    PCMD_WALKDL as libc::c_int as int8_t,
    PCMD_WALKD as libc::c_int as int8_t,
];
#[no_mangle]
pub unsafe extern "C" fn FindPath(
    mut PosOk: CHECKFUNC1,
    mut PosOkArg: libc::c_int,
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut dx: libc::c_int,
    mut dy: libc::c_int,
    mut path: *mut int8_t,
) -> libc::c_int {
    let mut Node: *mut PATHNODE = 0 as *mut PATHNODE;
    let mut BestNode: *mut PATHNODE = 0 as *mut PATHNODE;
    let mut i: libc::c_int = 0;
    let mut len: libc::c_int = 0;
    numpnodes = 0 as libc::c_int;
    OPEN = GetPathNode();
    CLOSED = GetPathNode();
    numstack = 0 as libc::c_int;
    Node = GetPathNode();
    (*Node).g = 0 as libc::c_int as int8_t;
    (*Node).h = PATHDIST(sx, sy, dx, dy) as int8_t;
    (*Node).f = ((*Node).g as libc::c_int + (*Node).h as libc::c_int) as int8_t;
    (*Node).x = sx;
    (*Node).y = sy;
    (*OPEN).NextNode = Node;
    loop {
        BestNode = ReturnBestNode();
        if BestNode.is_null() {
            return 0 as libc::c_int;
        }
        if (*BestNode).x == dx && (*BestNode).y == dy {
            break;
        }
        if GenerateSuccessors(PosOk, PosOkArg, BestNode, dx, dy) == 0 {
            return 0 as libc::c_int;
        }
    }
    Node = BestNode;
    len = 0 as libc::c_int;
    while !((*Node).Parent).is_null() && len < MAXPATHLEN as libc::c_int {
        let fresh0 = len;
        len = len + 1;
        tempath[fresh0
            as usize] = DirCmd[((*Node).x - (*(*Node).Parent).x + 1 as libc::c_int
            + ((*Node).y - (*(*Node).Parent).y + 1 as libc::c_int) * 3 as libc::c_int)
            as usize] as libc::c_int;
        Node = (*Node).Parent;
    }
    if len == MAXPATHLEN as libc::c_int {
        return 0 as libc::c_int;
    }
    i = 0 as libc::c_int;
    while i < len {
        *path
            .offset(
                i as isize,
            ) = tempath[(len - i - 1 as libc::c_int) as usize] as int8_t;
        i += 1;
        i;
    }
    return i;
}
#[no_mangle]
pub unsafe extern "C" fn PATHDIST(
    mut x1: libc::c_int,
    mut y1: libc::c_int,
    mut x2: libc::c_int,
    mut y2: libc::c_int,
) -> libc::c_int {
    let mut dx: libc::c_int = 0;
    let mut dy: libc::c_int = 0;
    let mut mind: libc::c_int = 0;
    let mut maxd: libc::c_int = 0;
    dx = abs(x1 - x2);
    dy = abs(y1 - y2);
    mind = if dx < dy { dx } else { dy };
    maxd = if dx > dy { dx } else { dy };
    return mind + maxd << 1 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn PathVal(
    mut Node: *mut PATHNODE,
    mut x: libc::c_int,
    mut y: libc::c_int,
) -> libc::c_int {
    if (*Node).x == x || (*Node).y == y {
        return 2 as libc::c_int;
    }
    return 3 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn ReturnBestNode() -> *mut PATHNODE {
    let mut tmp: *mut PATHNODE = 0 as *mut PATHNODE;
    if ((*OPEN).NextNode).is_null() {
        return 0 as *mut PATHNODE;
    }
    tmp = (*OPEN).NextNode;
    (*OPEN).NextNode = (*tmp).NextNode;
    (*tmp).NextNode = (*CLOSED).NextNode;
    (*CLOSED).NextNode = tmp;
    return tmp;
}
#[no_mangle]
pub unsafe extern "C" fn PathDirOk(
    mut Node: *mut PATHNODE,
    mut x: libc::c_int,
    mut y: libc::c_int,
) -> bool32_t {
    let mut ok: bool32_t = 1 as libc::c_int as bool32_t;
    match DirCmd[(x - (*Node).x + 1 as libc::c_int
        + (y - (*Node).y + 1 as libc::c_int) * 3 as libc::c_int) as usize] as libc::c_int
    {
        5 => {
            ok = !(nSolidTable[dPiece[x as usize][(y + 1 as libc::c_int) as usize]
                as usize] as libc::c_int != 0
                || nSolidTable[dPiece[(x + 1 as libc::c_int) as usize][y as usize]
                    as usize] as libc::c_int != 0) as libc::c_int as bool32_t;
        }
        6 => {
            ok = !(nSolidTable[dPiece[x as usize][(y + 1 as libc::c_int) as usize]
                as usize] as libc::c_int != 0
                || nSolidTable[dPiece[(x - 1 as libc::c_int) as usize][y as usize]
                    as usize] as libc::c_int != 0) as libc::c_int as bool32_t;
        }
        7 => {
            ok = !(nSolidTable[dPiece[x as usize][(y - 1 as libc::c_int) as usize]
                as usize] as libc::c_int != 0
                || nSolidTable[dPiece[(x - 1 as libc::c_int) as usize][y as usize]
                    as usize] as libc::c_int != 0) as libc::c_int as bool32_t;
        }
        8 => {
            ok = !(nSolidTable[dPiece[(x + 1 as libc::c_int) as usize][y as usize]
                as usize] as libc::c_int != 0
                || nSolidTable[dPiece[x as usize][(y - 1 as libc::c_int) as usize]
                    as usize] as libc::c_int != 0) as libc::c_int as bool32_t;
        }
        _ => {}
    }
    return ok;
}
#[no_mangle]
pub unsafe extern "C" fn GenerateSuccessors(
    mut PosOk: CHECKFUNC1,
    mut PosOkArg: libc::c_int,
    mut BestNode: *mut PATHNODE,
    mut dx: libc::c_int,
    mut dy: libc::c_int,
) -> bool32_t {
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut posok: bool32_t = 0;
    static mut nextx: [int8_t; 8] = [
        -(1 as libc::c_int) as int8_t,
        -(1 as libc::c_int) as int8_t,
        1 as libc::c_int as int8_t,
        1 as libc::c_int as int8_t,
        -(1 as libc::c_int) as int8_t,
        0 as libc::c_int as int8_t,
        1 as libc::c_int as int8_t,
        0 as libc::c_int as int8_t,
    ];
    static mut nexty: [int8_t; 8] = [
        -(1 as libc::c_int) as int8_t,
        1 as libc::c_int as int8_t,
        -(1 as libc::c_int) as int8_t,
        1 as libc::c_int as int8_t,
        0 as libc::c_int as int8_t,
        -(1 as libc::c_int) as int8_t,
        0 as libc::c_int as int8_t,
        1 as libc::c_int as int8_t,
    ];
    i = 0 as libc::c_int;
    while i < 8 as libc::c_int {
        x = (*BestNode).x + nextx[i as usize] as libc::c_int;
        y = (*BestNode).y + nexty[i as usize] as libc::c_int;
        posok = PosOk.expect("non-null function pointer")(PosOkArg, x, y);
        if posok != 0 && PathDirOk(BestNode, x, y) != 0
            || posok == 0 && x == dx && y == dy
        {
            if GenerateSucc(BestNode, x, y, dx, dy) == 0 {
                return 0 as libc::c_int as bool32_t;
            }
        }
        i += 1;
        i;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn GenerateSucc(
    mut BestNode: *mut PATHNODE,
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut dx: libc::c_int,
    mut dy: libc::c_int,
) -> bool32_t {
    let mut g: libc::c_int = 0;
    let mut c: libc::c_int = 0 as libc::c_int;
    let mut Old: *mut PATHNODE = 0 as *mut PATHNODE;
    let mut Successor: *mut PATHNODE = 0 as *mut PATHNODE;
    g = (*BestNode).g as libc::c_int + PathVal(BestNode, x, y);
    Old = CheckOPEN(x, y);
    if !Old.is_null() {
        c = 0 as libc::c_int;
        while c < 8 as libc::c_int {
            if ((*BestNode).Child[c as usize]).is_null() {
                break;
            }
            c += 1;
            c;
        }
        (*BestNode).Child[c as usize] = Old;
        if g < (*Old).g as libc::c_int && PathDirOk(BestNode, x, y) != 0 {
            (*Old).Parent = BestNode;
            (*Old).g = g as int8_t;
            (*Old).f = (g + (*Old).h as libc::c_int) as int8_t;
        }
    } else {
        Old = CheckCLOSED(x, y);
        if !Old.is_null() {
            c = 0 as libc::c_int;
            while c < 8 as libc::c_int {
                if ((*BestNode).Child[c as usize]).is_null() {
                    break;
                }
                c += 1;
                c;
            }
            (*BestNode).Child[c as usize] = Old;
            if g < (*Old).g as libc::c_int && PathDirOk(BestNode, x, y) != 0 {
                (*Old).Parent = BestNode;
                (*Old).g = g as int8_t;
                (*Old).f = (g + (*Old).h as libc::c_int) as int8_t;
                PropagateDown(Old);
            }
        } else {
            Successor = GetPathNode();
            if Successor.is_null() {
                return 0 as libc::c_int as bool32_t
            } else {
                (*Successor).Parent = BestNode;
                (*Successor).g = g as int8_t;
                (*Successor).h = PATHDIST(x, y, dx, dy) as int8_t;
                (*Successor).f = (g + (*Successor).h as libc::c_int) as int8_t;
                (*Successor).x = x;
                (*Successor).y = y;
                Insert(Successor);
                c = 0 as libc::c_int;
                while c < 8 as libc::c_int {
                    if ((*BestNode).Child[c as usize]).is_null() {
                        break;
                    }
                    c += 1;
                    c;
                }
                (*BestNode).Child[c as usize] = Successor;
            }
        }
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn CheckOPEN(
    mut x: libc::c_int,
    mut y: libc::c_int,
) -> *mut PATHNODE {
    let mut tmp: *mut PATHNODE = 0 as *mut PATHNODE;
    tmp = (*OPEN).NextNode;
    while !tmp.is_null() {
        if (*tmp).x == x && (*tmp).y == y {
            return tmp
        } else {
            tmp = (*tmp).NextNode;
        }
    }
    return 0 as *mut PATHNODE;
}
#[no_mangle]
pub unsafe extern "C" fn CheckCLOSED(
    mut x: libc::c_int,
    mut y: libc::c_int,
) -> *mut PATHNODE {
    let mut tmp: *mut PATHNODE = 0 as *mut PATHNODE;
    tmp = (*CLOSED).NextNode;
    while !tmp.is_null() {
        if (*tmp).x == x && (*tmp).y == y {
            return tmp
        } else {
            tmp = (*tmp).NextNode;
        }
    }
    return 0 as *mut PATHNODE;
}
#[no_mangle]
pub unsafe extern "C" fn Insert(mut Successor: *mut PATHNODE) {
    let mut tmp1: *mut PATHNODE = 0 as *mut PATHNODE;
    let mut tmp2: *mut PATHNODE = 0 as *mut PATHNODE;
    let mut f: libc::c_int = 0;
    if ((*OPEN).NextNode).is_null() {
        (*OPEN).NextNode = Successor;
        return;
    }
    f = (*Successor).f as libc::c_int;
    tmp1 = OPEN;
    tmp2 = (*OPEN).NextNode;
    while !tmp2.is_null() && ((*tmp2).f as libc::c_int) < f {
        tmp1 = tmp2;
        tmp2 = (*tmp2).NextNode;
    }
    (*Successor).NextNode = tmp2;
    (*tmp1).NextNode = Successor;
}
#[no_mangle]
pub unsafe extern "C" fn PropagateDown(mut Old: *mut PATHNODE) {
    let mut c: libc::c_int = 0;
    let mut Child: *mut PATHNODE = 0 as *mut PATHNODE;
    let mut Father: *mut PATHNODE = 0 as *mut PATHNODE;
    Push(Old);
    while numstack != 0 {
        Father = Pop();
        c = 0 as libc::c_int;
        while c < 8 as libc::c_int {
            Child = (*Father).Child[c as usize];
            if Child.is_null() {
                break;
            }
            if (*Father).g as libc::c_int + PathVal(Father, (*Child).x, (*Child).y)
                < (*Child).g as libc::c_int
                && PathDirOk(Father, (*Child).x, (*Child).y) != 0
            {
                (*Child).Parent = Father;
                (*Child)
                    .g = ((*Father).g as libc::c_int
                    + PathVal(Father, (*Child).x, (*Child).y)) as int8_t;
                (*Child)
                    .f = ((*Child).g as libc::c_int + (*Child).h as libc::c_int)
                    as int8_t;
                Push(Child);
            }
            c += 1;
            c;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn Push(mut Node: *mut PATHNODE) {
    let fresh1 = numstack;
    numstack = numstack + 1;
    Stack[fresh1 as usize] = Node;
}
#[no_mangle]
pub unsafe extern "C" fn Pop() -> *mut PATHNODE {
    numstack -= 1;
    return Stack[numstack as usize];
}
#[no_mangle]
pub unsafe extern "C" fn GetPathNode() -> *mut PATHNODE {
    let mut Node: *mut PATHNODE = 0 as *mut PATHNODE;
    if numpnodes == 300 as libc::c_int {
        return 0 as *mut PATHNODE
    } else {
        let fresh2 = numpnodes;
        numpnodes = numpnodes + 1;
        Node = &mut *pathnodes.as_mut_ptr().offset(fresh2 as isize) as *mut PATHNODE;
        memset(
            Node as *mut libc::c_void,
            0 as libc::c_int,
            ::core::mem::size_of::<PATHNODE>() as libc::c_ulong,
        );
        return Node;
    };
}
