use ::libc;
extern "C" {
    fn pow(_: libc::c_double, _: libc::c_double) -> libc::c_double;
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn SFileCloseFile(handle: HSFILE) -> bool32_t;
    fn SRegSaveValue(
        keyname: *const libc::c_char,
        valuename: *const libc::c_char,
        value: uint32_t,
    ) -> bool32_t;
    fn SRegLoadValue(
        keyname: *const libc::c_char,
        valuename: *const libc::c_char,
        value: *mut uint32_t,
    ) -> bool32_t;
    fn patSFileOpenFile(
        filename: *const libc::c_char,
        handle: *mut HSFILE,
        bCanFail: bool32_t,
    ) -> bool32_t;
    fn patSFileReadFile(
        handle: HSFILE,
        buffer: *mut libc::c_void,
        bytestoread: uint32_t,
    );
    static mut gszProgKey: *const libc::c_char;
    static mut force_redraw: libc::c_int;
    static mut leveltype: uint8_t;
    static mut sgCurr: [PaletteStruct; 256];
    static mut gpPalette: [uint32_t; 256];
    static mut gpLitPal: [uint32_t; 256];
    static mut sgLoad: [PaletteStruct; 256];
    fn MakeTTbls(range: libc::c_int);
}
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const lGAMMA_TICKS: C2RustUnnamed = 15;
pub const lGAMMA_STEP: C2RustUnnamed = 5;
pub const lGAMMA_MAX: C2RustUnnamed = 100;
pub const lGAMMA_MIN: C2RustUnnamed = 30;
pub const lGAMMA_READ: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_0 = 255;
pub const VIEWDRAW: C2RustUnnamed_0 = 1;
pub const NODRAW: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const G_BRIGHT_LIGHTS: C2RustUnnamed_1 = 0;
pub const USE_GOURAUD: C2RustUnnamed_1 = 0;
pub const ORIG_LIGHTING: C2RustUnnamed_1 = 1;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_2 {
    pub unused: libc::c_int,
}
pub type HSFILE = *mut C2RustUnnamed_2;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PaletteStruct {
    pub peBlue: uint8_t,
    pub peGreen: uint8_t,
    pub peRed: uint8_t,
    pub peFlags: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct RGB {
    pub red: uint8_t,
    pub green: uint8_t,
    pub blue: uint8_t,
}
static mut sglGamma: int32_t = lGAMMA_MAX as libc::c_int;
static mut sgBase: [PaletteStruct; 256] = [PaletteStruct {
    peBlue: 0,
    peGreen: 0,
    peRed: 0,
    peFlags: 0,
}; 256];
static mut sgszGamma: [libc::c_char; 17] = unsafe {
    *::core::mem::transmute::<&[u8; 17], &[libc::c_char; 17]>(b"Gamma Correction\0")
};
static mut sgszColorCycling: [libc::c_char; 14] = unsafe {
    *::core::mem::transmute::<&[u8; 14], &[libc::c_char; 14]>(b"Color Cycling\0")
};
static mut sgbFadedIn: uint8_t = 1 as libc::c_int as uint8_t;
static mut sbColorCyclingEnabled: bool32_t = 1 as libc::c_int as bool32_t;
unsafe extern "C" fn SetCurrentPalette() {
    sgCurr[0 as libc::c_int as usize].peRed = 0 as libc::c_int as uint8_t;
    sgCurr[0 as libc::c_int as usize].peGreen = 0 as libc::c_int as uint8_t;
    sgCurr[0 as libc::c_int as usize].peBlue = 0 as libc::c_int as uint8_t;
    sgCurr[255 as libc::c_int as usize].peRed = 0xff as libc::c_int as uint8_t;
    sgCurr[255 as libc::c_int as usize].peGreen = 0xff as libc::c_int as uint8_t;
    sgCurr[255 as libc::c_int as usize].peBlue = 0xff as libc::c_int as uint8_t;
    memcpy(
        gpPalette.as_mut_ptr() as *mut libc::c_void,
        sgCurr.as_mut_ptr() as *const libc::c_void,
        ::core::mem::size_of::<[PaletteStruct; 256]>() as libc::c_ulong,
    );
}
unsafe extern "C" fn GammaPalette(
    mut pDst: *mut PaletteStruct,
    mut pSrc: *const PaletteStruct,
    mut nNum: libc::c_int,
) {
    let mut gamma: libc::c_double = sglGamma as libc::c_double / 100.0f64;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < nNum {
        (*pDst)
            .peRed = (256.0f64 * pow((*pSrc).peRed as libc::c_double / 256.0f64, gamma))
            as uint8_t;
        (*pDst)
            .peGreen = (256.0f64
            * pow((*pSrc).peGreen as libc::c_double / 256.0f64, gamma)) as uint8_t;
        (*pDst)
            .peBlue = (256.0f64
            * pow((*pSrc).peBlue as libc::c_double / 256.0f64, gamma)) as uint8_t;
        i += 1;
        i;
        pDst = pDst.offset(1);
        pDst;
        pSrc = pSrc.offset(1);
        pSrc;
    }
}
#[no_mangle]
pub unsafe extern "C" fn SavePaletteSettings() {
    SRegSaveValue(gszProgKey, sgszGamma.as_ptr(), sglGamma as uint32_t);
    SRegSaveValue(gszProgKey, sgszColorCycling.as_ptr(), sbColorCyclingEnabled);
}
unsafe extern "C" fn GetPaletteSettings() {
    let mut dwTemp: uint32_t = sglGamma as uint32_t;
    if SRegLoadValue(gszProgKey, sgszGamma.as_ptr(), &mut dwTemp) == 0 {
        dwTemp = lGAMMA_MAX as libc::c_int as uint32_t;
    }
    sglGamma = dwTemp as int32_t;
    if sglGamma < lGAMMA_MIN as libc::c_int {
        sglGamma = lGAMMA_MIN as libc::c_int;
    } else if sglGamma > lGAMMA_MAX as libc::c_int {
        sglGamma = lGAMMA_MAX as libc::c_int;
    }
    sglGamma -= sglGamma % lGAMMA_STEP as libc::c_int;
    if SRegLoadValue(gszProgKey, sgszColorCycling.as_ptr(), &mut dwTemp) == 0 {
        dwTemp = 1 as libc::c_int as uint32_t;
    }
    sbColorCyclingEnabled = dwTemp;
}
#[no_mangle]
pub unsafe extern "C" fn MakeLitPal(
    mut sr: libc::c_int,
    mut sg: libc::c_int,
    mut sb: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut dst: *mut PaletteStruct = 0 as *mut PaletteStruct;
    dst = gpLitPal.as_mut_ptr() as *mut PaletteStruct;
    if USE_GOURAUD as libc::c_int != 0 {
        if leveltype as libc::c_int == 3 as libc::c_int {
            i = 0 as libc::c_int;
            while i < 32 as libc::c_int {
                (*dst.offset(i as isize)).peRed = sgCurr[i as usize].peRed;
                (*dst.offset(i as isize)).peGreen = sgCurr[i as usize].peGreen;
                (*dst.offset(i as isize)).peBlue = sgCurr[i as usize].peBlue;
                i += 1;
                i;
            }
            i = 32 as libc::c_int;
            while i < 256 as libc::c_int {
                if G_BRIGHT_LIGHTS as libc::c_int == 0 {
                    (*dst.offset(i as isize))
                        .peRed = (sr * sgCurr[i as usize].peRed as libc::c_int
                        >> 8 as libc::c_int) as uint8_t;
                    (*dst.offset(i as isize))
                        .peGreen = (sg * sgCurr[i as usize].peGreen as libc::c_int
                        >> 8 as libc::c_int) as uint8_t;
                    (*dst.offset(i as isize))
                        .peBlue = (sb * sgCurr[i as usize].peBlue as libc::c_int
                        >> 8 as libc::c_int) as uint8_t;
                } else {
                    let mut tr: uint32_t = 0;
                    tr = (sr * sgCurr[i as usize].peRed as libc::c_int
                        >> 7 as libc::c_int) as uint32_t;
                    if tr > 255 as libc::c_int as uint32_t {
                        tr = 255 as libc::c_int as uint32_t;
                    }
                    (*dst.offset(i as isize)).peRed = tr as uint8_t;
                    tr = (sg * sgCurr[i as usize].peGreen as libc::c_int
                        >> 7 as libc::c_int) as uint32_t;
                    if tr > 255 as libc::c_int as uint32_t {
                        tr = 255 as libc::c_int as uint32_t;
                    }
                    (*dst.offset(i as isize)).peGreen = tr as uint8_t;
                    tr = (sb * sgCurr[i as usize].peBlue as libc::c_int
                        >> 7 as libc::c_int) as uint32_t;
                    if tr > 255 as libc::c_int as uint32_t {
                        tr = 255 as libc::c_int as uint32_t;
                    }
                    (*dst.offset(i as isize)).peBlue = tr as uint8_t;
                }
                i += 1;
                i;
            }
        } else {
            i = 0 as libc::c_int;
            while i < 256 as libc::c_int {
                if G_BRIGHT_LIGHTS as libc::c_int == 0 {
                    (*dst.offset(i as isize))
                        .peRed = (sr * sgCurr[i as usize].peRed as libc::c_int
                        >> 8 as libc::c_int) as uint8_t;
                    (*dst.offset(i as isize))
                        .peGreen = (sg * sgCurr[i as usize].peGreen as libc::c_int
                        >> 8 as libc::c_int) as uint8_t;
                    (*dst.offset(i as isize))
                        .peBlue = (sb * sgCurr[i as usize].peBlue as libc::c_int
                        >> 8 as libc::c_int) as uint8_t;
                } else {
                    let mut tr_0: uint32_t = 0;
                    tr_0 = (sr * sgCurr[i as usize].peRed as libc::c_int
                        >> 7 as libc::c_int) as uint32_t;
                    if tr_0 > 255 as libc::c_int as uint32_t {
                        tr_0 = 255 as libc::c_int as uint32_t;
                    }
                    (*dst.offset(i as isize)).peRed = tr_0 as uint8_t;
                    tr_0 = (sg * sgCurr[i as usize].peGreen as libc::c_int
                        >> 7 as libc::c_int) as uint32_t;
                    if tr_0 > 255 as libc::c_int as uint32_t {
                        tr_0 = 255 as libc::c_int as uint32_t;
                    }
                    (*dst.offset(i as isize)).peGreen = tr_0 as uint8_t;
                    tr_0 = (sb * sgCurr[i as usize].peBlue as libc::c_int
                        >> 7 as libc::c_int) as uint32_t;
                    if tr_0 > 255 as libc::c_int as uint32_t {
                        tr_0 = 255 as libc::c_int as uint32_t;
                    }
                    (*dst.offset(i as isize)).peBlue = tr_0 as uint8_t;
                }
                i += 1;
                i;
            }
        }
    } else {
        i = 0 as libc::c_int;
        while i < 256 as libc::c_int {
            (*dst.offset(i as isize))
                .peRed = (sr * sgCurr[i as usize].peRed as libc::c_int
                >> 8 as libc::c_int) as uint8_t;
            (*dst.offset(i as isize))
                .peGreen = (sg * sgCurr[i as usize].peGreen as libc::c_int
                >> 8 as libc::c_int) as uint8_t;
            (*dst.offset(i as isize))
                .peBlue = (sb * sgCurr[i as usize].peBlue as libc::c_int
                >> 8 as libc::c_int) as uint8_t;
            i += 1;
            i;
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn InitPalette() {
    GetPaletteSettings();
    memcpy(
        sgCurr.as_mut_ptr() as *mut libc::c_void,
        sgLoad.as_mut_ptr() as *const libc::c_void,
        ::core::mem::size_of::<[PaletteStruct; 256]>() as libc::c_ulong,
    );
}
#[no_mangle]
pub unsafe extern "C" fn LoadPalette(mut pszFileName: *const libc::c_char) {
    let mut pal: [RGB; 256] = [RGB { red: 0, green: 0, blue: 0 }; 256];
    let mut hFile: HSFILE = 0 as *mut C2RustUnnamed_2;
    if pszFileName.is_null() {
        assert_fail(
            172 as libc::c_int,
            b"src/palette.c\0" as *const u8 as *const libc::c_char,
            b"pszFileName\0" as *const u8 as *const libc::c_char,
        );
    }
    patSFileOpenFile(pszFileName, &mut hFile, 0 as libc::c_int as bool32_t);
    patSFileReadFile(
        hFile,
        &mut *pal.as_mut_ptr().offset(0 as libc::c_int as isize) as *mut RGB
            as *mut libc::c_void,
        ::core::mem::size_of::<[RGB; 256]>() as libc::c_ulong as uint32_t,
    );
    SFileCloseFile(hFile);
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 256 as libc::c_int {
        sgLoad[i as usize].peRed = pal[i as usize].red;
        sgLoad[i as usize].peGreen = pal[i as usize].green;
        sgLoad[i as usize].peBlue = pal[i as usize].blue;
        sgLoad[i as usize].peFlags = 0 as libc::c_int as uint8_t;
        i += 1;
        i;
    }
    if USE_GOURAUD as libc::c_int != 0 {
        MakeTTbls(256 as libc::c_int);
    }
    memcpy(
        gpPalette.as_mut_ptr() as *mut libc::c_void,
        sgLoad.as_mut_ptr() as *const libc::c_void,
        ::core::mem::size_of::<[PaletteStruct; 256]>() as libc::c_ulong,
    );
}
#[no_mangle]
pub unsafe extern "C" fn LoadRndLvlPal(mut l: libc::c_int) {
    if l == 0 as libc::c_int {
        LoadPalette(b"Levels\\TownData\\Town.pal\0" as *const u8 as *const libc::c_char);
    } else {
        let mut filestr: [libc::c_char; 260] = [0; 260];
        let mut palnum: libc::c_int = random_(
            b"src/palette.c\0" as *const u8 as *const libc::c_char,
            197 as libc::c_int,
            0 as libc::c_int as uint8_t,
            4 as libc::c_int,
        ) + 1 as libc::c_int;
        sprintf(
            filestr.as_mut_ptr(),
            b"Levels\\L%dData\\L%d_%d.PAL\0" as *const u8 as *const libc::c_char,
            l,
            l,
            palnum,
        );
        LoadPalette(filestr.as_mut_ptr());
    };
}
#[no_mangle]
pub unsafe extern "C" fn GammaUp() {
    if sglGamma < lGAMMA_MAX as libc::c_int {
        sglGamma += lGAMMA_STEP as libc::c_int;
        if sglGamma > lGAMMA_MAX as libc::c_int {
            sglGamma = lGAMMA_MAX as libc::c_int;
        }
        GammaPalette(sgCurr.as_mut_ptr(), sgBase.as_mut_ptr(), 256 as libc::c_int);
        SetCurrentPalette();
        force_redraw = FULLDRAW as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn GammaDown() {
    if sglGamma > lGAMMA_MIN as libc::c_int {
        sglGamma -= lGAMMA_STEP as libc::c_int;
        if sglGamma < lGAMMA_MIN as libc::c_int {
            sglGamma = lGAMMA_MIN as libc::c_int;
        }
        GammaPalette(sgCurr.as_mut_ptr(), sgBase.as_mut_ptr(), 256 as libc::c_int);
        SetCurrentPalette();
        force_redraw = FULLDRAW as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn GammaLevel(mut lGamma: int32_t) -> int32_t {
    if lGamma != lGAMMA_READ as libc::c_int {
        sglGamma = lGAMMA_MAX as libc::c_int - lGamma + lGAMMA_MIN as libc::c_int;
        GammaPalette(sgCurr.as_mut_ptr(), sgBase.as_mut_ptr(), 256 as libc::c_int);
        SetCurrentPalette();
        force_redraw = FULLDRAW as libc::c_int;
    }
    return lGAMMA_MAX as libc::c_int - sglGamma + lGAMMA_MIN as libc::c_int;
}
unsafe extern "C" fn SetFadeLevel(mut fadeval: libc::c_int) {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 255 as libc::c_int {
        let mut pv: uint32_t = 0;
        pv = (sgBase[i as usize].peRed as libc::c_int * fadeval) as uint32_t;
        sgCurr[i as usize].peRed = (pv / 256 as libc::c_int as uint32_t) as uint8_t;
        pv = (sgBase[i as usize].peGreen as libc::c_int * fadeval) as uint32_t;
        sgCurr[i as usize].peGreen = (pv / 256 as libc::c_int as uint32_t) as uint8_t;
        pv = (sgBase[i as usize].peBlue as libc::c_int * fadeval) as uint32_t;
        sgCurr[i as usize].peBlue = (pv / 256 as libc::c_int as uint32_t) as uint8_t;
        i += 1;
        i;
    }
    if USE_GOURAUD as libc::c_int != 0 {
        MakeTTbls(256 as libc::c_int);
    }
    SetCurrentPalette();
    force_redraw = FULLDRAW as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn BlackPalette() {
    SetFadeLevel(0 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn PaletteFadeIn(mut faderate: libc::c_int) {
    GammaPalette(sgBase.as_mut_ptr(), sgLoad.as_mut_ptr(), 256 as libc::c_int);
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 256 as libc::c_int {
        SetFadeLevel(i);
        i += faderate;
    }
    SetFadeLevel(256 as libc::c_int);
    memcpy(
        sgBase.as_mut_ptr() as *mut libc::c_void,
        sgLoad.as_mut_ptr() as *const libc::c_void,
        ::core::mem::size_of::<[PaletteStruct; 256]>() as libc::c_ulong,
    );
    sgbFadedIn = 1 as libc::c_int as uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn PaletteFadeOut(mut faderate: libc::c_int) {
    if sgbFadedIn == 0 {
        return;
    }
    let mut i: libc::c_int = 256 as libc::c_int;
    while i > 0 as libc::c_int {
        SetFadeLevel(i);
        i -= faderate;
    }
    SetFadeLevel(0 as libc::c_int);
    sgbFadedIn = 0 as libc::c_int as uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn LavaCycle() {
    let mut temp: PaletteStruct = sgCurr[1 as libc::c_int as usize];
    let mut i: libc::c_int = 0;
    i = 1 as libc::c_int;
    while i < 31 as libc::c_int {
        sgCurr[i as usize].peRed = sgCurr[(i + 1 as libc::c_int) as usize].peRed;
        sgCurr[i as usize].peGreen = sgCurr[(i + 1 as libc::c_int) as usize].peGreen;
        sgCurr[i as usize].peBlue = sgCurr[(i + 1 as libc::c_int) as usize].peBlue;
        i += 1;
        i;
    }
    sgCurr[i as usize].peRed = temp.peRed;
    sgCurr[i as usize].peGreen = temp.peGreen;
    sgCurr[i as usize].peBlue = temp.peBlue;
    if USE_GOURAUD as libc::c_int != 0 {
        MakeTTbls(32 as libc::c_int);
    }
    SetCurrentPalette();
}
#[no_mangle]
pub unsafe extern "C" fn UpdateLavaPalette() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 32 as libc::c_int {
        sgBase[i as usize] = sgLoad[i as usize];
        i += 1;
        i;
    }
    GammaPalette(sgCurr.as_mut_ptr(), sgBase.as_mut_ptr(), 32 as libc::c_int);
    SetCurrentPalette();
}
#[no_mangle]
pub unsafe extern "C" fn MeshLavaPalette(mut fadeval: libc::c_int) {
    let mut i: libc::c_int = 0;
    i = 32 as libc::c_int - fadeval;
    while i >= 0 as libc::c_int {
        sgBase[i as usize] = sgLoad[i as usize];
        i -= 1;
        i;
    }
    GammaPalette(sgCurr.as_mut_ptr(), sgBase.as_mut_ptr(), 32 as libc::c_int);
    SetCurrentPalette();
}
#[no_mangle]
pub unsafe extern "C" fn GetColorCycling() -> bool32_t {
    return sbColorCyclingEnabled;
}
#[no_mangle]
pub unsafe extern "C" fn SetColorCycling(mut enabled: bool32_t) -> bool32_t {
    sbColorCyclingEnabled = enabled;
    return enabled;
}
