use ::libc;
extern "C" {
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn strcpy(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn GetRndSeed(file: *const libc::c_char, line: libc::c_int) -> int32_t;
    fn RecreateItem(
        _: libc::c_int,
        _: libc::c_int,
        _: uint16_t,
        _: libc::c_int,
        _: libc::c_int,
    );
    fn RecreateEar(
        _: libc::c_int,
        _: uint16_t,
        _: libc::c_int,
        _: bool32_t,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
    );
    fn CalcPlrInv(_: libc::c_int, _: bool32_t);
    fn InitPlayer(_: libc::c_int, _: bool32_t);
    fn ClrPlrPath(_: libc::c_int);
    fn PlrInitReserved(p: *mut PlayerStruct);
    static mut item: [ItemStruct; 128];
    static mut gbMaxPlayers: uint8_t;
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut witchitem: [ItemStruct; 20];
}
pub type C2RustUnnamed = libc::c_uint;
pub const INVALID_ITEM: C2RustUnnamed = 65535;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const SPELLCAP: C2RustUnnamed_0 = 15;
pub const MAXSPELLS: C2RustUnnamed_0 = 37;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const ITEM_GOLD: C2RustUnnamed_1 = 168;
pub const ITEM_SBATLBOW: C2RustUnnamed_1 = 167;
pub const ITEM_COMPSTF: C2RustUnnamed_1 = 166;
pub const ITEM_SWARBOW: C2RustUnnamed_1 = 165;
pub const ITEM_WINDFOR: C2RustUnnamed_1 = 164;
pub const ITEM_REAVER: C2RustUnnamed_1 = 163;
pub const ITEM_PROTECT: C2RustUnnamed_1 = 162;
pub const ITEM_GRANDPA: C2RustUnnamed_1 = 161;
pub const ITEM_GRIZZLY: C2RustUnnamed_1 = 160;
pub const ITEM_NAJARMOR: C2RustUnnamed_1 = 159;
pub const ITEM_CROSBOW: C2RustUnnamed_1 = 158;
pub const ITEM_ARKARMOR: C2RustUnnamed_1 = 157;
pub const ITEM_GEMGRTAXE: C2RustUnnamed_1 = 156;
pub const ITEM_BISHOPSTF: C2RustUnnamed_1 = 155;
pub const ITEM_RINGMAIL: C2RustUnnamed_1 = 154;
pub const ITEM_BPLATE: C2RustUnnamed_1 = 153;
pub const ITEM_PARMOR3: C2RustUnnamed_1 = 152;
pub const ITEM_PARMOR2: C2RustUnnamed_1 = 151;
pub const ITEM_CAPE: C2RustUnnamed_1 = 150;
pub const ITEM_CLOAK: C2RustUnnamed_1 = 149;
pub const ITEM_LRGSHLD: C2RustUnnamed_1 = 148;
pub const ITEM_KITESHLD: C2RustUnnamed_1 = 147;
pub const ITEM_IRONSHLD: C2RustUnnamed_1 = 146;
pub const ITEM_GREATAXE: C2RustUnnamed_1 = 145;
pub const ITEM_HANDAXE: C2RustUnnamed_1 = 144;
pub const ITEM_WICKAXE: C2RustUnnamed_1 = 143;
pub const ITEM_LRGAXE: C2RustUnnamed_1 = 142;
pub const ITEM_BROADAXE: C2RustUnnamed_1 = 141;
pub const ITEM_ANVIL: C2RustUnnamed_1 = 140;
pub const ITEM_RINGARMOR: C2RustUnnamed_1 = 139;
pub const ITEM_HVYROBE: C2RustUnnamed_1 = 138;
pub const ITEM_ROBE: C2RustUnnamed_1 = 137;
pub const ITEM_SPLTARMOR: C2RustUnnamed_1 = 136;
pub const ITEM_LARMOR: C2RustUnnamed_1 = 135;
pub const ITEM_GRTSWORD: C2RustUnnamed_1 = 134;
pub const ITEM_HNTRBOW: C2RustUnnamed_1 = 133;
pub const ITEM_TSHIELD: C2RustUnnamed_1 = 132;
pub const ITEM_FLAIL: C2RustUnnamed_1 = 131;
pub const ITEM_BALLNCHN: C2RustUnnamed_1 = 130;
pub const ITEM_QARMOR: C2RustUnnamed_1 = 129;
pub const ITEM_RAGS: C2RustUnnamed_1 = 128;
pub const ITEM_HLARMOR: C2RustUnnamed_1 = 127;
pub const ITEM_INNSIGN: C2RustUnnamed_1 = 126;
pub const ITEM_LONGSTAFF: C2RustUnnamed_1 = 125;
pub const ITEM_STLSTAFF: C2RustUnnamed_1 = 124;
pub const ITEM_IRONSTAFF: C2RustUnnamed_1 = 123;
pub const ITEM_MAUL: C2RustUnnamed_1 = 122;
pub const ITEM_SMLWARHAM: C2RustUnnamed_1 = 121;
pub const ITEM_STLSHRTBOW: C2RustUnnamed_1 = 120;
pub const ITEM_STLLONGBOW: C2RustUnnamed_1 = 119;
pub const ITEM_SHORTBOW: C2RustUnnamed_1 = 118;
pub const ITEM_WOLFSHLD: C2RustUnnamed_1 = 117;
pub const ITEM_SKULLSHLD: C2RustUnnamed_1 = 116;
pub const ITEM_SMLSHLD: C2RustUnnamed_1 = 115;
pub const ITEM_SCLARMOR: C2RustUnnamed_1 = 114;
pub const ITEM_HVYSHIELD: C2RustUnnamed_1 = 113;
pub const ITEM_SMALLAXE: C2RustUnnamed_1 = 112;
pub const ITEM_CHARMOR: C2RustUnnamed_1 = 111;
pub const ITEM_2HSWORD: C2RustUnnamed_1 = 110;
pub const ITEM_SHRTSTAFF: C2RustUnnamed_1 = 109;
pub const ITEM_COMPBOW: C2RustUnnamed_1 = 108;
pub const ITEM_STDARMOR: C2RustUnnamed_1 = 107;
pub const ITEM_CLEAVER: C2RustUnnamed_1 = 106;
pub const ITEM_WSHIELD: C2RustUnnamed_1 = 105;
pub const ITEM_AXE: C2RustUnnamed_1 = 104;
pub const ITEM_PARMOR: C2RustUnnamed_1 = 103;
pub const ITEM_LONGBOW: C2RustUnnamed_1 = 102;
pub const ITEM_BTLAXE: C2RustUnnamed_1 = 101;
pub const ITEM_COMPSHLD: C2RustUnnamed_1 = 100;
pub const ITEM_SAMHELM: C2RustUnnamed_1 = 99;
pub const ITEM_FHELM3: C2RustUnnamed_1 = 98;
pub const ITEM_BOOK4: C2RustUnnamed_1 = 97;
pub const ITEM_MAP: C2RustUnnamed_1 = 96;
pub const ITEM_CROWN2: C2RustUnnamed_1 = 95;
pub const ITEM_CLOTHES: C2RustUnnamed_1 = 94;
pub const ITEM_SKLCAP2: C2RustUnnamed_1 = 93;
pub const ITEM_FLESH: C2RustUnnamed_1 = 92;
pub const ITEM_LCAP: C2RustUnnamed_1 = 91;
pub const ITEM_SKLCAP: C2RustUnnamed_1 = 90;
pub const ITEM_MUSHROOM: C2RustUnnamed_1 = 89;
pub const ITEM_BOOK: C2RustUnnamed_1 = 88;
pub const ITEM_BOOK3: C2RustUnnamed_1 = 87;
pub const ITEM_BOOK2: C2RustUnnamed_1 = 86;
pub const ITEM_GRTHELM: C2RustUnnamed_1 = 85;
pub const ITEM_FHELM2: C2RustUnnamed_1 = 84;
pub const ITEM_BUCKLER: C2RustUnnamed_1 = 83;
pub const ITEM_FHELM: C2RustUnnamed_1 = 82;
pub const ITEM_HARLEQ: C2RustUnnamed_1 = 81;
pub const ITEM_JESTER: C2RustUnnamed_1 = 80;
pub const ITEM_MCROWN: C2RustUnnamed_1 = 79;
pub const ITEM_SKCROWN: C2RustUnnamed_1 = 78;
pub const ITEM_CROWN: C2RustUnnamed_1 = 77;
pub const ITEM_ROCK: C2RustUnnamed_1 = 76;
pub const ITEM_HELM: C2RustUnnamed_1 = 75;
pub const ITEM_SKULSWORD: C2RustUnnamed_1 = 74;
pub const ITEM_MAGSWORD: C2RustUnnamed_1 = 73;
pub const ITEM_SCIMITAR2: C2RustUnnamed_1 = 72;
pub const ITEM_CLUB3: C2RustUnnamed_1 = 71;
pub const ITEM_CLUB2: C2RustUnnamed_1 = 70;
pub const ITEM_CLUB1: C2RustUnnamed_1 = 69;
pub const ITEM_KNTSWORD: C2RustUnnamed_1 = 68;
pub const ITEM_SABRE: C2RustUnnamed_1 = 67;
pub const ITEM_CLUB: C2RustUnnamed_1 = 66;
pub const ITEM_CLAYMORE: C2RustUnnamed_1 = 65;
pub const ITEM_SHORTSRD: C2RustUnnamed_1 = 64;
pub const ITEM_MORNSTAR: C2RustUnnamed_1 = 63;
pub const ITEM_SCIMITAR: C2RustUnnamed_1 = 62;
pub const ITEM_BROADSRD: C2RustUnnamed_1 = 61;
pub const ITEM_LONGSRD: C2RustUnnamed_1 = 60;
pub const ITEM_MACE: C2RustUnnamed_1 = 59;
pub const ITEM_FALCHION: C2RustUnnamed_1 = 58;
pub const ITEM_BASTSRD: C2RustUnnamed_1 = 57;
pub const ITEM_BLADE: C2RustUnnamed_1 = 56;
pub const ITEM_DAGGER5: C2RustUnnamed_1 = 55;
pub const ITEM_DAGGER4: C2RustUnnamed_1 = 54;
pub const ITEM_DAGGER3: C2RustUnnamed_1 = 53;
pub const ITEM_BIGBOTTLE: C2RustUnnamed_1 = 52;
pub const ITEM_DAGGER2: C2RustUnnamed_1 = 51;
pub const ITEM_DAGGER1: C2RustUnnamed_1 = 50;
pub const ITEM_POUCH1: C2RustUnnamed_1 = 49;
pub const ITEM_AMULET4: C2RustUnnamed_1 = 48;
pub const ITEM_AMULET3: C2RustUnnamed_1 = 47;
pub const ITEM_AMULET2: C2RustUnnamed_1 = 46;
pub const ITEM_AMULET1: C2RustUnnamed_1 = 45;
pub const ITEM_AMULET: C2RustUnnamed_1 = 44;
pub const ITEM_BREAD: C2RustUnnamed_1 = 43;
pub const ITEM_FANG: C2RustUnnamed_1 = 42;
pub const ITEM_CLAW: C2RustUnnamed_1 = 41;
pub const ITEM_BRAIN: C2RustUnnamed_1 = 40;
pub const ITEM_BLUEBTL2: C2RustUnnamed_1 = 39;
pub const ITEM_LTBLUEBTL: C2RustUnnamed_1 = 38;
pub const ITEM_GOLDBTL: C2RustUnnamed_1 = 37;
pub const ITEM_BLKBTL2: C2RustUnnamed_1 = 36;
pub const ITEM_BREDBTL: C2RustUnnamed_1 = 35;
pub const ITEM_ORGBTL: C2RustUnnamed_1 = 34;
pub const ITEM_YELBTL: C2RustUnnamed_1 = 33;
pub const ITEM_REDBTL: C2RustUnnamed_1 = 32;
pub const ITEM_WHTEBTL: C2RustUnnamed_1 = 31;
pub const ITEM_BLKBTL: C2RustUnnamed_1 = 30;
pub const ITEM_VILE: C2RustUnnamed_1 = 29;
pub const ITEM_JPYRIMID: C2RustUnnamed_1 = 28;
pub const ITEM_JCUBE: C2RustUnnamed_1 = 27;
pub const ITEM_JSPHERE: C2RustUnnamed_1 = 26;
pub const ITEM_BLOODGEM: C2RustUnnamed_1 = 25;
pub const ITEM_PYRIMID: C2RustUnnamed_1 = 24;
pub const ITEM_CUBE: C2RustUnnamed_1 = 23;
pub const ITEM_SPHERE: C2RustUnnamed_1 = 22;
pub const ITEM_EAR3: C2RustUnnamed_1 = 21;
pub const ITEM_EAR2: C2RustUnnamed_1 = 20;
pub const ITEM_EAR1: C2RustUnnamed_1 = 19;
pub const ITEM_EMPYBAND: C2RustUnnamed_1 = 18;
pub const ITEM_GOLDENELIX: C2RustUnnamed_1 = 17;
pub const ITEM_3COLORPOT: C2RustUnnamed_1 = 16;
pub const ITEM_SPECTRAL: C2RustUnnamed_1 = 15;
pub const ITEM_BRNRING: C2RustUnnamed_1 = 14;
pub const ITEM_MJRING: C2RustUnnamed_1 = 13;
pub const ITEM_SLVRRING: C2RustUnnamed_1 = 12;
pub const ITEM_3JRING: C2RustUnnamed_1 = 11;
pub const ITEM_BLUERING: C2RustUnnamed_1 = 10;
pub const ITEM_WOODRING: C2RustUnnamed_1 = 9;
pub const ITEM_1JRING: C2RustUnnamed_1 = 8;
pub const ITEM_GOLDRING: C2RustUnnamed_1 = 7;
pub const ITEM_5GOLD: C2RustUnnamed_1 = 6;
pub const ITEM_3GOLD: C2RustUnnamed_1 = 5;
pub const ITEM_1GOLD: C2RustUnnamed_1 = 4;
pub const ITEM_SCROLL3: C2RustUnnamed_1 = 3;
pub const ITEM_SCROLL2: C2RustUnnamed_1 = 2;
pub const ITEM_SCROLL: C2RustUnnamed_1 = 1;
pub const ITEM_BLUEBTL: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const IDI_LASTQUEST: C2RustUnnamed_2 = 22;
pub const IDI_FIRSTQUEST: C2RustUnnamed_2 = 6;
pub const IDI_RESURRECT: C2RustUnnamed_2 = 34;
pub const IDI_LAZSTAFF: C2RustUnnamed_2 = 33;
pub const IDI_LGTFORGE: C2RustUnnamed_2 = 32;
pub const IDI_GRISWOLD: C2RustUnnamed_2 = 31;
pub const IDI_FULLMANA: C2RustUnnamed_2 = 30;
pub const IDI_FULLHEAL: C2RustUnnamed_2 = 29;
pub const IDI_ARMOFVAL: C2RustUnnamed_2 = 28;
pub const IDI_PORTAL: C2RustUnnamed_2 = 27;
pub const IDI_IDENTIFY: C2RustUnnamed_2 = 26;
pub const IDI_MANA: C2RustUnnamed_2 = 25;
pub const IDI_HEAL: C2RustUnnamed_2 = 24;
pub const IDI_EAR: C2RustUnnamed_2 = 23;
pub const IDI_MAPOFDOOM: C2RustUnnamed_2 = 22;
pub const IDI_BLDSTONE: C2RustUnnamed_2 = 21;
pub const IDI_SPECELIX: C2RustUnnamed_2 = 20;
pub const IDI_FUNGALTM: C2RustUnnamed_2 = 19;
pub const IDI_BRAIN: C2RustUnnamed_2 = 18;
pub const IDI_MUSHROOM: C2RustUnnamed_2 = 17;
pub const IDI_ANVIL: C2RustUnnamed_2 = 16;
pub const IDI_GLDNELIX: C2RustUnnamed_2 = 15;
pub const IDI_STEELVEIL: C2RustUnnamed_2 = 14;
pub const IDI_HARCREST: C2RustUnnamed_2 = 13;
pub const IDI_BANNER: C2RustUnnamed_2 = 12;
pub const IDI_TRING: C2RustUnnamed_2 = 11;
pub const IDI_OPTAMULET: C2RustUnnamed_2 = 10;
pub const IDI_ROCK: C2RustUnnamed_2 = 9;
pub const IDI_INFRARING: C2RustUnnamed_2 = 8;
pub const IDI_SKCROWN: C2RustUnnamed_2 = 7;
pub const IDI_CLEAVER: C2RustUnnamed_2 = 6;
pub const IDI_SORCEROR: C2RustUnnamed_2 = 5;
pub const IDI_ROGUE: C2RustUnnamed_2 = 4;
pub const IDI_WARRCLUB: C2RustUnnamed_2 = 3;
pub const IDI_WARRSHLD: C2RustUnnamed_2 = 2;
pub const IDI_WARRIOR: C2RustUnnamed_2 = 1;
pub const IDI_GOLD: C2RustUnnamed_2 = 0;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
pub type C2RustUnnamed_3 = libc::c_uint;
pub const NUM_INVLOC: C2RustUnnamed_3 = 7;
pub const INVLOC_BODY: C2RustUnnamed_3 = 6;
pub const INVLOC_HAND2: C2RustUnnamed_3 = 5;
pub const INVLOC_HAND1: C2RustUnnamed_3 = 4;
pub const INVLOC_NECK: C2RustUnnamed_3 = 3;
pub const INVLOC_RING2: C2RustUnnamed_3 = 2;
pub const INVLOC_RING1: C2RustUnnamed_3 = 1;
pub const INVLOC_HEAD: C2RustUnnamed_3 = 0;
pub type C2RustUnnamed_4 = libc::c_int;
pub const PCMD_SPELLXYD: C2RustUnnamed_4 = 26;
pub const PCMD_SPELLPID: C2RustUnnamed_4 = 25;
pub const PCMD_SPELLID: C2RustUnnamed_4 = 24;
pub const PCMD_RATTACKPID: C2RustUnnamed_4 = 23;
pub const PCMD_RATTACKID: C2RustUnnamed_4 = 22;
pub const PCMD_ATTACKPID: C2RustUnnamed_4 = 21;
pub const PCMD_ATTACKID: C2RustUnnamed_4 = 20;
pub const PCMD_TELEK: C2RustUnnamed_4 = 18;
pub const PCMD_TALK: C2RustUnnamed_4 = 17;
pub const PCMD_REQAGETITEM: C2RustUnnamed_4 = 16;
pub const PCMD_REQGETITEM: C2RustUnnamed_4 = 15;
pub const PCMD_DISARM: C2RustUnnamed_4 = 14;
pub const PCMD_OPOBJ: C2RustUnnamed_4 = 13;
pub const PCMD_SPELL: C2RustUnnamed_4 = 12;
pub const PCMD_BLOCK: C2RustUnnamed_4 = 11;
pub const PCMD_RATTACK: C2RustUnnamed_4 = 10;
pub const PCMD_ATTACK: C2RustUnnamed_4 = 9;
pub const PCMD_WALKL: C2RustUnnamed_4 = 8;
pub const PCMD_WALKD: C2RustUnnamed_4 = 7;
pub const PCMD_WALKR: C2RustUnnamed_4 = 6;
pub const PCMD_WALKU: C2RustUnnamed_4 = 5;
pub const PCMD_WALKDL: C2RustUnnamed_4 = 4;
pub const PCMD_WALKDR: C2RustUnnamed_4 = 3;
pub const PCMD_WALKUL: C2RustUnnamed_4 = 2;
pub const PCMD_WALKUR: C2RustUnnamed_4 = 1;
pub const PCMD_STAND: C2RustUnnamed_4 = 0;
pub const PCMD_NOTHING: C2RustUnnamed_4 = -1;
pub type C2RustUnnamed_5 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_5 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_5 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_5 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_5 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_5 = 32;
pub const MAXSPD: C2RustUnnamed_5 = 8;
pub const MAXINV: C2RustUnnamed_5 = 40;
pub const MAXPATHLEN: C2RustUnnamed_5 = 25;
pub const MANA_SHIFT: C2RustUnnamed_5 = 6;
pub const HP_SHIFT: C2RustUnnamed_5 = 6;
pub const NUM_CLASSES: C2RustUnnamed_5 = 3;
pub const MAXPACKLEN: C2RustUnnamed_5 = 256;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
pub type C2RustUnnamed_6 = libc::c_int;
pub const ITEMFTYPES: C2RustUnnamed_6 = 35;
pub const RESIST_MAX: C2RustUnnamed_6 = 75;
pub const GOLD_VMAX: C2RustUnnamed_6 = 5000;
pub const GOLD_VT2: C2RustUnnamed_6 = 2500;
pub const GOLD_VT1: C2RustUnnamed_6 = 1000;
pub const INFINITE_DUR: C2RustUnnamed_6 = 255;
pub const ITEM_RND: C2RustUnnamed_6 = -1;
pub const TEMPAVAIL: C2RustUnnamed_6 = 127;
pub const MAXUITEMS: C2RustUnnamed_6 = 128;
pub const MAXITEMS: C2RustUnnamed_6 = 127;
pub type C2RustUnnamed_7 = libc::c_uint;
pub const STOREIDCOST: C2RustUnnamed_7 = 100;
pub const MAXHOLDITEMS: C2RustUnnamed_7 = 48;
pub const NUMSTLINES: C2RustUnnamed_7 = 24;
pub const MAXPREMIUM: C2RustUnnamed_7 = 6;
pub const MAXHEALITEMS: C2RustUnnamed_7 = 20;
pub const MAXWITCHITEMS: C2RustUnnamed_7 = 20;
pub const MAXSMITHITEMS: C2RustUnnamed_7 = 20;
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct PkItemStruct {
    pub iSeed: libc::c_int,
    pub iCreateInfo: uint16_t,
    pub idx: uint16_t,
    pub bId: uint8_t,
    pub bDur: uint8_t,
    pub bMDur: uint8_t,
    pub bCh: uint8_t,
    pub bMCh: uint8_t,
    pub wValue: uint16_t,
    pub dwBuff: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct PkPlayerStruct {
    pub archiveTime: uint64_t,
    pub destAction: uint8_t,
    pub destParam1: uint8_t,
    pub destParam2: uint8_t,
    pub plrlevel: uint8_t,
    pub px: uint8_t,
    pub py: uint8_t,
    pub targx: uint8_t,
    pub targy: uint8_t,
    pub pName: [libc::c_char; 32],
    pub pClass: uint8_t,
    pub pBaseStr: uint8_t,
    pub pBaseMag: uint8_t,
    pub pBaseDex: uint8_t,
    pub pBaseVit: uint8_t,
    pub pLevel: uint8_t,
    pub pStatPts: uint8_t,
    pub pExperience: int32_t,
    pub pGold: int32_t,
    pub pHPBase: int32_t,
    pub pMaxHPBase: int32_t,
    pub pManaBase: int32_t,
    pub pMaxManaBase: int32_t,
    pub pSplLvl: [uint8_t; 37],
    pub pMemSpells: uint64_t,
    pub InvBody: [PkItemStruct; 7],
    pub InvList: [PkItemStruct; 40],
    pub InvGrid: [int8_t; 40],
    pub _pNumInv: uint8_t,
    pub SpdList: [PkItemStruct; 8],
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
}
unsafe extern "C" fn PackItem(mut id: *mut PkItemStruct, mut is: *const ItemStruct) {
    if (*is)._itype == -(1 as libc::c_int) {
        (*id).idx = INVALID_ITEM as libc::c_int as uint16_t;
    } else {
        (*id).idx = (*is).IDidx as uint16_t;
        if (*is).IDidx == IDI_EAR as libc::c_int {
            (*id)
                .iCreateInfo = (((*is)._iName[7 as libc::c_int as usize] as libc::c_int)
                << 8 as libc::c_int
                | (*is)._iName[8 as libc::c_int as usize] as libc::c_int) as uint16_t;
            (*id)
                .iSeed = ((*is)._iName[9 as libc::c_int as usize] as libc::c_int)
                << 24 as libc::c_int
                | ((*is)._iName[10 as libc::c_int as usize] as libc::c_int)
                    << 16 as libc::c_int
                | ((*is)._iName[11 as libc::c_int as usize] as libc::c_int)
                    << 8 as libc::c_int
                | (*is)._iName[12 as libc::c_int as usize] as libc::c_int;
            (*id).bId = (*is)._iName[13 as libc::c_int as usize] as uint8_t;
            (*id).bDur = (*is)._iName[14 as libc::c_int as usize] as uint8_t;
            (*id).bMDur = (*is)._iName[15 as libc::c_int as usize] as uint8_t;
            (*id).bCh = (*is)._iName[16 as libc::c_int as usize] as uint8_t;
            (*id).bMCh = (*is)._iName[17 as libc::c_int as usize] as uint8_t;
            (*id)
                .wValue = (((*is)._iName[18 as libc::c_int as usize] as libc::c_int)
                << 8 as libc::c_int
                | ((*is)._iCurs - ITEM_EAR1 as libc::c_int) << 6 as libc::c_int
                | (*is)._ivalue) as uint16_t;
            (*id)
                .dwBuff = (((*is)._iName[19 as libc::c_int as usize] as libc::c_int)
                << 24 as libc::c_int
                | ((*is)._iName[20 as libc::c_int as usize] as libc::c_int)
                    << 16 as libc::c_int
                | ((*is)._iName[21 as libc::c_int as usize] as libc::c_int)
                    << 8 as libc::c_int
                | (*is)._iName[22 as libc::c_int as usize] as libc::c_int) as uint32_t;
        } else {
            (*id).iSeed = (*is)._iSeed;
            (*id).iCreateInfo = (*is)._iCreateInfo;
            (*id)
                .bId = ((*is)._iIdentified)
                .wrapping_add(
                    (((*is)._iMagical as libc::c_int) << 1 as libc::c_int) as bool32_t,
                ) as uint8_t;
            (*id).bDur = (*is)._iDurability as uint8_t;
            (*id).bMDur = (*is)._iMaxDur as uint8_t;
            (*id).bCh = (*is)._iCharges as uint8_t;
            (*id).bMCh = (*is)._iMaxCharges as uint8_t;
            if (*is).IDidx == IDI_GOLD as libc::c_int {
                (*id).wValue = (*is)._ivalue as uint16_t;
            }
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn PackPlayer(
    mut pPack: *mut PkPlayerStruct,
    mut pnum: libc::c_int,
    mut manashield: bool32_t,
) {
    memset(
        pPack as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<PkPlayerStruct>() as libc::c_ulong,
    );
    let mut i: libc::c_int = 0;
    let mut pki: *mut PkItemStruct = 0 as *mut PkItemStruct;
    let mut pi: *const ItemStruct = 0 as *const ItemStruct;
    let mut pPlayer: *const PlayerStruct = &mut *plr.as_mut_ptr().offset(pnum as isize)
        as *mut PlayerStruct;
    (*pPack).destAction = (*pPlayer).destAction as uint8_t;
    (*pPack).destParam1 = (*pPlayer).destParam1 as uint8_t;
    (*pPack).destParam2 = (*pPlayer).destParam2 as uint8_t;
    (*pPack).plrlevel = (*pPlayer).plrlevel as uint8_t;
    (*pPack).px = (*pPlayer)._px as uint8_t;
    (*pPack).py = (*pPlayer)._py as uint8_t;
    (*pPack).targx = (*pPlayer)._ptargx as uint8_t;
    (*pPack).targy = (*pPlayer)._ptargy as uint8_t;
    strcpy(((*pPack).pName).as_mut_ptr(), ((*pPlayer)._pName).as_ptr());
    (*pPack).pClass = (*pPlayer)._pClass as uint8_t;
    (*pPack).pBaseStr = (*pPlayer)._pBaseStr as uint8_t;
    (*pPack).pBaseMag = (*pPlayer)._pBaseMag as uint8_t;
    (*pPack).pBaseDex = (*pPlayer)._pBaseDex as uint8_t;
    (*pPack).pBaseVit = (*pPlayer)._pBaseVit as uint8_t;
    (*pPack).pLevel = (*pPlayer)._pLevel as uint8_t;
    (*pPack).pStatPts = (*pPlayer)._pStatPts as uint8_t;
    (*pPack).pExperience = (*pPlayer)._pExperience;
    (*pPack).pGold = (*pPlayer)._pGold;
    (*pPack).pHPBase = (*pPlayer)._pHPBase;
    (*pPack).pMaxHPBase = (*pPlayer)._pMaxHPBase;
    (*pPack).pManaBase = (*pPlayer)._pManaBase;
    (*pPack).pMaxManaBase = (*pPlayer)._pMaxManaBase;
    (*pPack).pMemSpells = (*pPlayer)._pMemSpells;
    i = 0 as libc::c_int;
    while i < MAXSPELLS as libc::c_int {
        (*pPack).pSplLvl[i as usize] = (*pPlayer)._pSplLvl[i as usize] as uint8_t;
        i += 1;
        i;
    }
    pki = &mut *((*pPack).InvBody).as_mut_ptr().offset(0 as libc::c_int as isize)
        as *mut PkItemStruct;
    pi = &*((*pPlayer).InvBody).as_ptr().offset(0 as libc::c_int as isize)
        as *const ItemStruct;
    i = NUM_INVLOC as libc::c_int;
    loop {
        let fresh0 = i;
        i = i - 1;
        if !(fresh0 != 0) {
            break;
        }
        PackItem(pki, pi);
        pki = pki.offset(1);
        pki;
        pi = pi.offset(1);
        pi;
    }
    pki = &mut *((*pPack).InvList).as_mut_ptr().offset(0 as libc::c_int as isize)
        as *mut PkItemStruct;
    pi = &*((*pPlayer).InvList).as_ptr().offset(0 as libc::c_int as isize)
        as *const ItemStruct;
    i = MAXINV as libc::c_int;
    loop {
        let fresh1 = i;
        i = i - 1;
        if !(fresh1 != 0) {
            break;
        }
        PackItem(pki, pi);
        pki = pki.offset(1);
        pki;
        pi = pi.offset(1);
        pi;
    }
    i = 0 as libc::c_int;
    while i < MAXINV as libc::c_int {
        (*pPack).InvGrid[i as usize] = (*pPlayer).InvGrid[i as usize];
        i += 1;
        i;
    }
    (*pPack)._pNumInv = (*pPlayer)._pNumInv as uint8_t;
    pki = &mut *((*pPack).SpdList).as_mut_ptr().offset(0 as libc::c_int as isize)
        as *mut PkItemStruct;
    pi = &*((*pPlayer).SpdList).as_ptr().offset(0 as libc::c_int as isize)
        as *const ItemStruct;
    i = MAXSPD as libc::c_int;
    loop {
        let fresh2 = i;
        i = i - 1;
        if !(fresh2 != 0) {
            break;
        }
        PackItem(pki, pi);
        pki = pki.offset(1);
        pki;
        pi = pi.offset(1);
        pi;
    }
    (*pPack).pDiabloKillLevel = (*pPlayer).pDiabloKillLevel;
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int || manashield != 0 {
        (*pPack).pManaShield = (*pPlayer).pManaShield;
    } else {
        (*pPack).pManaShield = 0 as libc::c_int as uint8_t;
    };
}
unsafe extern "C" fn UnPackItem(mut is: *const PkItemStruct, mut id: *mut ItemStruct) {
    if (*is).idx as libc::c_int == INVALID_ITEM as libc::c_int {
        (*id)._itype = -(1 as libc::c_int);
    } else {
        if (*is).idx as libc::c_int == IDI_EAR as libc::c_int {
            RecreateEar(
                TEMPAVAIL as libc::c_int,
                (*is).iCreateInfo,
                (*is).iSeed,
                (*is).bId as bool32_t,
                (*is).bDur as libc::c_int,
                (*is).bMDur as libc::c_int,
                (*is).bCh as libc::c_int,
                (*is).bMCh as libc::c_int,
                (*is).wValue as libc::c_int,
                (*is).dwBuff as libc::c_int,
            );
        } else {
            RecreateItem(
                TEMPAVAIL as libc::c_int,
                (*is).idx as libc::c_int,
                (*is).iCreateInfo,
                (*is).iSeed,
                (*is).wValue as libc::c_int,
            );
            item[TEMPAVAIL as libc::c_int as usize]
                ._iMagical = ((*is).bId as libc::c_int >> 1 as libc::c_int) as int8_t;
            item[TEMPAVAIL as libc::c_int as usize]
                ._iIdentified = ((*is).bId as libc::c_int & 1 as libc::c_int)
                as bool32_t;
            item[TEMPAVAIL as libc::c_int as usize]
                ._iDurability = (*is).bDur as libc::c_int;
            item[TEMPAVAIL as libc::c_int as usize]
                ._iMaxDur = (*is).bMDur as libc::c_int;
            item[TEMPAVAIL as libc::c_int as usize]._iCharges = (*is).bCh as libc::c_int;
            item[TEMPAVAIL as libc::c_int as usize]
                ._iMaxCharges = (*is).bMCh as libc::c_int;
        }
        *id = item[TEMPAVAIL as libc::c_int as usize];
    };
}
#[no_mangle]
pub unsafe extern "C" fn VerifyGoldSeeds(mut pPlayer: *mut PlayerStruct) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < (*pPlayer)._pNumInv {
        if (*pPlayer).InvList[i as usize].IDidx == IDI_GOLD as libc::c_int {
            j = 0 as libc::c_int;
            while j < (*pPlayer)._pNumInv {
                if i != j
                    && (*pPlayer).InvList[j as usize].IDidx == IDI_GOLD as libc::c_int
                    && (*pPlayer).InvList[i as usize]._iSeed
                        == (*pPlayer).InvList[j as usize]._iSeed
                {
                    (*pPlayer)
                        .InvList[i as usize]
                        ._iSeed = GetRndSeed(
                        b"src/packplr.c\0" as *const u8 as *const libc::c_char,
                        156 as libc::c_int,
                    );
                    j = -(1 as libc::c_int);
                }
                j += 1;
                j;
            }
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn UnPackPlayer(
    mut pPack: *const PkPlayerStruct,
    mut pnum: libc::c_int,
    mut killok: bool32_t,
) {
    let mut pi: *mut ItemStruct = 0 as *mut ItemStruct;
    let mut pki: *const PkItemStruct = 0 as *const PkItemStruct;
    let mut pPlayer: *mut PlayerStruct = &mut *plr.as_mut_ptr().offset(pnum as isize)
        as *mut PlayerStruct;
    PlrInitReserved(pPlayer);
    (*pPlayer)._px = (*pPack).px as libc::c_int;
    (*pPlayer)._py = (*pPack).py as libc::c_int;
    (*pPlayer)._pfutx = (*pPack).px as libc::c_int;
    (*pPlayer)._pfuty = (*pPack).py as libc::c_int;
    (*pPlayer)._ptargx = (*pPack).targx as libc::c_int;
    (*pPlayer)._ptargy = (*pPack).targy as libc::c_int;
    (*pPlayer).plrlevel = (*pPack).plrlevel as libc::c_int;
    ClrPlrPath(pnum);
    (*pPlayer).destAction = PCMD_NOTHING as libc::c_int;
    strcpy(((*pPlayer)._pName).as_mut_ptr(), ((*pPack).pName).as_ptr());
    (*pPlayer)._pClass = (*pPack).pClass as int8_t;
    InitPlayer(pnum, 1 as libc::c_int as bool32_t);
    (*pPlayer)._pBaseStr = (*pPack).pBaseStr as libc::c_int;
    (*pPlayer)._pStrength = (*pPack).pBaseStr as libc::c_int;
    (*pPlayer)._pBaseMag = (*pPack).pBaseMag as libc::c_int;
    (*pPlayer)._pMagic = (*pPack).pBaseMag as libc::c_int;
    (*pPlayer)._pBaseDex = (*pPack).pBaseDex as libc::c_int;
    (*pPlayer)._pDexterity = (*pPack).pBaseDex as libc::c_int;
    (*pPlayer)._pBaseVit = (*pPack).pBaseVit as libc::c_int;
    (*pPlayer)._pVitality = (*pPack).pBaseVit as libc::c_int;
    (*pPlayer)._pLevel = (*pPack).pLevel as int8_t;
    (*pPlayer)._pStatPts = (*pPack).pStatPts as libc::c_int;
    (*pPlayer)._pExperience = (*pPack).pExperience;
    (*pPlayer)._pGold = (*pPack).pGold;
    (*pPlayer)._pMaxHPBase = (*pPack).pMaxHPBase;
    (*pPlayer)._pHPBase = (*pPack).pHPBase;
    if killok == 0 && ((*pPlayer)._pHPBase >> HP_SHIFT as libc::c_int) < 1 as libc::c_int
    {
        (*pPlayer)._pHPBase = (1 as libc::c_int) << HP_SHIFT as libc::c_int;
    }
    (*pPlayer)._pMaxManaBase = (*pPack).pMaxManaBase;
    (*pPlayer)._pManaBase = (*pPack).pManaBase;
    (*pPlayer)._pMemSpells = (*pPack).pMemSpells;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAXSPELLS as libc::c_int {
        (*pPlayer)._pSplLvl[i as usize] = (*pPack).pSplLvl[i as usize] as int8_t;
        i += 1;
        i;
    }
    pki = &*((*pPack).InvBody).as_ptr().offset(0 as libc::c_int as isize)
        as *const PkItemStruct;
    pi = &mut *((*pPlayer).InvBody).as_mut_ptr().offset(0 as libc::c_int as isize)
        as *mut ItemStruct;
    let mut i_0: libc::c_int = NUM_INVLOC as libc::c_int;
    loop {
        let fresh3 = i_0;
        i_0 = i_0 - 1;
        if !(fresh3 != 0) {
            break;
        }
        UnPackItem(pki, pi);
        pki = pki.offset(1);
        pki;
        pi = pi.offset(1);
        pi;
    }
    pki = &*((*pPack).InvList).as_ptr().offset(0 as libc::c_int as isize)
        as *const PkItemStruct;
    pi = &mut *((*pPlayer).InvList).as_mut_ptr().offset(0 as libc::c_int as isize)
        as *mut ItemStruct;
    let mut i_1: libc::c_int = MAXINV as libc::c_int;
    loop {
        let fresh4 = i_1;
        i_1 = i_1 - 1;
        if !(fresh4 != 0) {
            break;
        }
        UnPackItem(pki, pi);
        pki = pki.offset(1);
        pki;
        pi = pi.offset(1);
        pi;
    }
    let mut i_2: libc::c_int = 0 as libc::c_int;
    while i_2 < MAXINV as libc::c_int {
        (*pPlayer).InvGrid[i_2 as usize] = (*pPack).InvGrid[i_2 as usize];
        i_2 += 1;
        i_2;
    }
    (*pPlayer)._pNumInv = (*pPack)._pNumInv as libc::c_int;
    VerifyGoldSeeds(pPlayer);
    pki = &*((*pPack).SpdList).as_ptr().offset(0 as libc::c_int as isize)
        as *const PkItemStruct;
    pi = &mut *((*pPlayer).SpdList).as_mut_ptr().offset(0 as libc::c_int as isize)
        as *mut ItemStruct;
    let mut i_3: libc::c_int = MAXSPD as libc::c_int;
    loop {
        let fresh5 = i_3;
        i_3 = i_3 - 1;
        if !(fresh5 != 0) {
            break;
        }
        UnPackItem(pki, pi);
        pki = pki.offset(1);
        pki;
        pi = pi.offset(1);
        pi;
    }
    if pnum == myplr {
        let mut i_4: libc::c_int = 0 as libc::c_int;
        while i_4 < MAXWITCHITEMS as libc::c_int {
            witchitem[i_4 as usize]._itype = -(1 as libc::c_int);
            i_4 += 1;
            i_4;
        }
    }
    CalcPlrInv(pnum, 0 as libc::c_int as bool32_t);
    (*pPlayer).pTownWarps = 0 as libc::c_int as uint8_t;
    (*pPlayer).pDungMsgs = 0 as libc::c_int as uint8_t;
    (*pPlayer).pLvlLoad = 0 as libc::c_int as uint8_t;
    (*pPlayer).pDiabloKillLevel = (*pPack).pDiabloKillLevel;
    (*pPlayer).pBattleNet = (*pPack).pBattleNet;
    (*pPlayer).pManaShield = (*pPack).pManaShield;
}
