use ::libc;
extern "C" {
    pub type SDL_mutex;
    fn SDL_CreateMutex() -> *mut SDL_mutex;
    fn SDL_GetTicks() -> Uint32;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn process_turn();
    static mut GAME_FRAMES_PER_SECOND: libc::c_int;
    static mut gbMaxPlayers: uint8_t;
    static mut gbGameDestroyed: uint8_t;
    static mut gdwNormalMsgSize: uint32_t;
    static mut gdwLargestMsgSize: uint32_t;
    static mut gbGameLoopsPerPacket: uint8_t;
    static mut gdwTurnsInTransit: uint32_t;
    static mut gdwDeltaBytesSec: uint32_t;
    static mut gdwMsgLenTbl: [uint32_t; 4];
    static mut gdwMsgStatTbl: [uint32_t; 4];
    static mut glpMsgTbl: [*mut libc::c_void; 4];
    fn SErrGetLastError() -> uint32_t;
    fn SNetSendTurn(data: *mut libc::c_void, databytes: uint32_t) -> bool32_t;
    fn SNetReceiveTurns(
        firstplayerid: uint32_t,
        arraysize: uint32_t,
        arraydata: *mut *mut libc::c_void,
        arraydatabytes: *mut uint32_t,
        arrayplayerstatus: *mut uint32_t,
    ) -> bool32_t;
    fn SNetGetProviderCaps(caps: *mut SNETCAPS) -> bool32_t;
    fn SNetGetTurnsInTransit(turns: *mut uint32_t) -> bool32_t;
    fn _logf(format: *const libc::c_char, _: ...);
}
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type Uint32 = uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const TURN_COUNTER_RESET_MASK: C2RustUnnamed = 65535;
pub const TURN_COUNTER_MASK: C2RustUnnamed = 2147483647;
pub const TURN_REQUEST_DELTA_FLAG: C2RustUnnamed = 2147483648;
pub const STARTY: C2RustUnnamed = 68;
pub const STARTX: C2RustUnnamed = 75;
pub const ASYNC_CYCLES_PER_SYNC: C2RustUnnamed = 4;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const CATCH_UP_DELTA: C2RustUnnamed_0 = 500;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const MAX_MSG_SIZE: C2RustUnnamed_1 = 512;
pub const MIN_MSG_SIZE: C2RustUnnamed_1 = 128;
pub const SEND_ALL_MASK: C2RustUnnamed_1 = 4294967295;
pub const MAX_SEND_STR_LEN: C2RustUnnamed_1 = 80;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_2 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_2 = 92160;
pub const BTMBUFFY: C2RustUnnamed_2 = 144;
pub const BTMBUFFX: C2RustUnnamed_2 = 640;
pub const BUFFERSIZE: C2RustUnnamed_2 = 503808;
pub const BUFFERY: C2RustUnnamed_2 = 656;
pub const BUFFERX: C2RustUnnamed_2 = 768;
pub const GAMEY: C2RustUnnamed_2 = 352;
pub const CTRLPANY: C2RustUnnamed_2 = 128;
pub const TOTALY: C2RustUnnamed_2 = 480;
pub const TOTALX: C2RustUnnamed_2 = 640;
pub const MAX_PLRS: C2RustUnnamed_2 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SNETCAPS {
    pub size: uint32_t,
    pub flags: uint32_t,
    pub maxmessagesize: uint32_t,
    pub maxqueuesize: uint32_t,
    pub maxplayers: uint32_t,
    pub bytessec: uint32_t,
    pub latencyms: uint32_t,
    pub defaultturnssec: uint32_t,
    pub defaultturnsintransit: uint32_t,
}
static mut sgdwRequestDeltaFlag: uint32_t = 0;
static mut sgbRunThread: uint8_t = 0 as libc::c_int as uint8_t;
static mut sgCrit: *mut SDL_mutex = 0 as *const SDL_mutex as *mut SDL_mutex;
static mut sgbGotPacketOK: uint8_t = 0;
static mut sgbPacketCountdown: uint8_t = 0 as libc::c_int as uint8_t;
static mut sgbSyncCountdown: uint8_t = 0;
static mut sglGameClock: int32_t = 0 as libc::c_int;
#[no_mangle]
pub unsafe extern "C" fn nthread_check_snet_error(mut pszFcn: *const libc::c_char) {
    if pszFcn.is_null() {
        assert_fail(
            48 as libc::c_int,
            b"src/nthread.c\0" as *const u8 as *const libc::c_char,
            b"pszFcn\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut dwErr: uint32_t = SErrGetLastError();
    if !(dwErr
        == 0x80000000 as libc::c_uint
            | ((0x510 as libc::c_int) << 16 as libc::c_int) as libc::c_uint
            | (106 as libc::c_int & 0xffff as libc::c_int) as libc::c_uint)
    {
        if dwErr
            == 0x80000000 as libc::c_uint
                | ((0x510 as libc::c_int) << 16 as libc::c_int) as libc::c_uint
                | (105 as libc::c_int & 0xffff as libc::c_int) as libc::c_uint
        {
            gbGameDestroyed = 1 as libc::c_int as uint8_t;
        } else if dwErr
            == 0x80000000 as libc::c_uint
                | ((0x510 as libc::c_int) << 16 as libc::c_int) as libc::c_uint
                | (112 as libc::c_int & 0xffff as libc::c_int) as libc::c_uint
        {
            gbGameDestroyed = 1 as libc::c_int as uint8_t;
        } else {
            app_fatal_(
                b"src/nthread.c\0" as *const u8 as *const libc::c_char,
                59 as libc::c_int,
                b"%s error\0" as *const u8 as *const libc::c_char,
                pszFcn,
            );
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn nthread_fill_sync_queue(
    mut dwCounter: uint32_t,
    mut dwIncrement: uint32_t,
) -> uint32_t {
    let mut turns: uint32_t = 0;
    if SNetGetTurnsInTransit(&mut turns) == 0 {
        nthread_check_snet_error(
            b"SNetGetTurnsInTransit\0" as *const u8 as *const libc::c_char,
        );
        return 0 as libc::c_int as uint32_t;
    }
    if gdwTurnsInTransit == 0 {
        assert_fail(
            72 as libc::c_int,
            b"src/nthread.c\0" as *const u8 as *const libc::c_char,
            b"gdwTurnsInTransit\0" as *const u8 as *const libc::c_char,
        );
    }
    loop {
        let fresh0 = turns;
        turns = turns.wrapping_add(1);
        if !(fresh0 < gdwTurnsInTransit) {
            break;
        }
        let mut dwTemp: uint32_t = dwCounter
            & TURN_COUNTER_MASK as libc::c_int as uint32_t;
        dwTemp |= sgdwRequestDeltaFlag;
        sgdwRequestDeltaFlag = 0 as libc::c_int as uint32_t;
        if SNetSendTurn(
            &mut dwTemp as *mut uint32_t as *mut libc::c_void,
            ::core::mem::size_of::<uint32_t>() as libc::c_ulong as uint32_t,
        ) == 0
        {
            nthread_check_snet_error(
                b"SNetSendTurn\0" as *const u8 as *const libc::c_char,
            );
            return 0 as libc::c_int as uint32_t;
        }
        dwCounter = dwCounter.wrapping_add(dwIncrement);
        if dwCounter >= TURN_COUNTER_MASK as libc::c_int as uint32_t {
            dwCounter &= TURN_COUNTER_RESET_MASK as libc::c_int as uint32_t;
        }
    }
    return dwCounter;
}
#[no_mangle]
pub unsafe extern "C" fn nthread_msg_check(mut pfSendAsync: *mut bool32_t) -> bool32_t {
    if pfSendAsync.is_null() {
        assert_fail(
            99 as libc::c_int,
            b"src/nthread.c\0" as *const u8 as *const libc::c_char,
            b"pfSendAsync\0" as *const u8 as *const libc::c_char,
        );
    }
    *pfSendAsync = 0 as libc::c_int as bool32_t;
    if sgbPacketCountdown == 0 {
        assert_fail(
            103 as libc::c_int,
            b"src/nthread.c\0" as *const u8 as *const libc::c_char,
            b"sgbPacketCountdown\0" as *const u8 as *const libc::c_char,
        );
    }
    sgbPacketCountdown = sgbPacketCountdown.wrapping_sub(1);
    if sgbPacketCountdown != 0 {
        sglGameClock += 1000 as libc::c_int / GAME_FRAMES_PER_SECOND;
        return 1 as libc::c_int as bool32_t;
    }
    sgbPacketCountdown = gbGameLoopsPerPacket;
    if sgbSyncCountdown == 0 {
        assert_fail(
            115 as libc::c_int,
            b"src/nthread.c\0" as *const u8 as *const libc::c_char,
            b"sgbSyncCountdown\0" as *const u8 as *const libc::c_char,
        );
    }
    sgbSyncCountdown = sgbSyncCountdown.wrapping_sub(1);
    if sgbSyncCountdown == 0 {
        if SNetReceiveTurns(
            0 as libc::c_int as uint32_t,
            MAX_PLRS as libc::c_int as uint32_t,
            glpMsgTbl.as_mut_ptr(),
            gdwMsgLenTbl.as_mut_ptr(),
            gdwMsgStatTbl.as_mut_ptr(),
        ) == 0
        {
            let mut dwErr: uint32_t = SErrGetLastError();
            if dwErr
                != 0x80000000 as libc::c_uint
                    | ((0x510 as libc::c_int) << 16 as libc::c_int) as libc::c_uint
                    | (107 as libc::c_int & 0xffff as libc::c_int) as libc::c_uint
            {
                nthread_check_snet_error(
                    b"SNetReceiveTurns\0" as *const u8 as *const libc::c_char,
                );
            }
            sgbSyncCountdown = 1 as libc::c_int as uint8_t;
            sgbPacketCountdown = sgbSyncCountdown;
            sgbGotPacketOK = 0 as libc::c_int as uint8_t;
            return 0 as libc::c_int as bool32_t;
        } else if sgbGotPacketOK == 0 {
            sgbGotPacketOK = 1 as libc::c_int as uint8_t;
            sglGameClock = SDL_GetTicks() as int32_t;
        }
        sgbSyncCountdown = ASYNC_CYCLES_PER_SYNC as libc::c_int as uint8_t;
        process_turn();
    }
    *pfSendAsync = 1 as libc::c_int as bool32_t;
    sglGameClock += 1000 as libc::c_int / GAME_FRAMES_PER_SECOND;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn nthread_set_delta_request() {
    sgdwRequestDeltaFlag = TURN_REQUEST_DELTA_FLAG as libc::c_uint;
}
#[no_mangle]
pub unsafe extern "C" fn nthread_init(mut bRequestDelta: bool32_t) {
    sgCrit = SDL_CreateMutex();
    sglGameClock = SDL_GetTicks() as int32_t;
    sgbPacketCountdown = 1 as libc::c_int as uint8_t;
    sgbSyncCountdown = 1 as libc::c_int as uint8_t;
    sgbGotPacketOK = 1 as libc::c_int as uint8_t;
    if bRequestDelta != 0 {
        nthread_set_delta_request();
    } else {
        sgdwRequestDeltaFlag = 0 as libc::c_int as uint32_t;
    }
    let mut caps: SNETCAPS = SNETCAPS {
        size: 0,
        flags: 0,
        maxmessagesize: 0,
        maxqueuesize: 0,
        maxplayers: 0,
        bytessec: 0,
        latencyms: 0,
        defaultturnssec: 0,
        defaultturnsintransit: 0,
    };
    caps.size = ::core::mem::size_of::<SNETCAPS>() as libc::c_ulong as uint32_t;
    if SNetGetProviderCaps(&mut caps) == 0 {
        app_fatal_(
            b"src/nthread.c\0" as *const u8 as *const libc::c_char,
            216 as libc::c_int,
            b"error invoking SNetGetProviderCaps\0" as *const u8 as *const libc::c_char,
        );
    }
    if caps.defaultturnsintransit != 0 {
        gdwTurnsInTransit = caps.defaultturnsintransit;
    } else {
        gdwTurnsInTransit = 1 as libc::c_int as uint32_t;
    }
    if caps.defaultturnssec > GAME_FRAMES_PER_SECOND as uint32_t
        || caps.defaultturnssec == 0
    {
        gbGameLoopsPerPacket = 1 as libc::c_int as uint8_t;
    } else {
        gbGameLoopsPerPacket = (GAME_FRAMES_PER_SECOND as uint32_t
            / caps.defaultturnssec) as uint8_t;
    }
    gdwLargestMsgSize = if caps.maxmessagesize < MAX_MSG_SIZE as libc::c_int as uint32_t
    {
        caps.maxmessagesize
    } else {
        MAX_MSG_SIZE as libc::c_int as uint32_t
    };
    if !(gdwLargestMsgSize >= MIN_MSG_SIZE as libc::c_int as uint32_t) {
        assert_fail(
            236 as libc::c_int,
            b"src/nthread.c\0" as *const u8 as *const libc::c_char,
            b"gdwLargestMsgSize >= MIN_MSG_SIZE\0" as *const u8 as *const libc::c_char,
        );
    }
    gdwNormalMsgSize = caps.bytessec * gbGameLoopsPerPacket as uint32_t
        / GAME_FRAMES_PER_SECOND as uint32_t;
    gdwDeltaBytesSec = caps.bytessec * 1 as libc::c_int as uint32_t
        / 4 as libc::c_int as uint32_t;
    gdwNormalMsgSize = gdwNormalMsgSize * 3 as libc::c_int as uint32_t;
    gdwNormalMsgSize = gdwNormalMsgSize / 4 as libc::c_int as uint32_t;
    if caps.maxplayers == 0 {
        assert_fail(
            254 as libc::c_int,
            b"src/nthread.c\0" as *const u8 as *const libc::c_char,
            b"caps.maxplayers\0" as *const u8 as *const libc::c_char,
        );
    }
    if caps.maxplayers > MAX_PLRS as libc::c_int as uint32_t {
        caps.maxplayers = MAX_PLRS as libc::c_int as uint32_t;
    }
    gdwNormalMsgSize = gdwNormalMsgSize / caps.maxplayers;
    while gdwNormalMsgSize < MIN_MSG_SIZE as libc::c_int as uint32_t {
        gdwNormalMsgSize = gdwNormalMsgSize * 2 as libc::c_int as uint32_t;
        gbGameLoopsPerPacket = (gbGameLoopsPerPacket as libc::c_int * 2 as libc::c_int)
            as uint8_t;
    }
    if gdwNormalMsgSize > gdwLargestMsgSize {
        gdwNormalMsgSize = gdwLargestMsgSize;
    }
    gbMaxPlayers as libc::c_int > 1 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn nthread_free() {
    sgbRunThread = 0 as libc::c_int as uint8_t;
    gdwTurnsInTransit = 0 as libc::c_int as uint32_t;
    gdwNormalMsgSize = 0 as libc::c_int as uint32_t;
    gdwLargestMsgSize = 0 as libc::c_int as uint32_t;
}
#[no_mangle]
pub unsafe extern "C" fn nthread_perform_keepalive(mut bStart: bool32_t) {}
#[no_mangle]
pub unsafe extern "C" fn nthread_run_gameloop(mut bReloop: bool32_t) -> bool32_t {
    let mut lRealClock: int32_t = SDL_GetTicks() as int32_t;
    let mut lDelta: int32_t = lRealClock - sglGameClock;
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int
        && lDelta > CATCH_UP_DELTA as libc::c_int
    {
        _logf(b"500 ms passed\0" as *const u8 as *const libc::c_char);
        sglGameClock = lRealClock;
        lDelta = 0 as libc::c_int;
    }
    return (lDelta >= 0 as libc::c_int) as libc::c_int as bool32_t;
}
