use ::libc;
extern "C" {
    fn rotr_(v: uint32_t, nbits: libc::c_int) -> uint32_t;
    fn memmove(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn time(__timer: *mut time_t) -> time_t;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn dthread_SendPlayerInfoChunk(
        pnum: libc::c_int,
        bCmd: uint8_t,
        pbSrc: *const uint8_t,
        dwLen: uint32_t,
    );
    fn dthread_init();
    fn dthread_free();
    fn dthread_remove_player(pnum: libc::c_int);
    fn GetRndSeed(file: *const libc::c_char, line: libc::c_int) -> int32_t;
    fn SetRndSeed(file: *const libc::c_char, line: libc::c_int, s: int32_t);
    fn abs(_: libc::c_int) -> libc::c_int;
    fn free(_: *mut libc::c_void);
    fn SDL_GetTicks() -> Uint32;
    fn SDL_Delay(ms: Uint32);
    fn SErrGetLastError() -> uint32_t;
    fn SNetCreateGame(
        gamename: *const libc::c_char,
        gamepassword: *const libc::c_char,
        gamedescription: *const libc::c_char,
        gamecategorybits: uint32_t,
        initdata: *mut libc::c_void,
        initdatabytes: uint32_t,
        maxplayers: uint32_t,
        playername: *const libc::c_char,
        playerdescription: *const libc::c_char,
        playerid: *mut uint32_t,
    ) -> bool32_t;
    fn SNetLeaveGame(exitcode: uint32_t) -> bool32_t;
    fn SNetSendMessage(
        targetplayerid: uint32_t,
        data: *mut libc::c_void,
        databytes: uint32_t,
    ) -> bool32_t;
    fn SNetReceiveMessage(
        senderplayerid: *mut uint32_t,
        data: *mut *mut libc::c_void,
        databytes: *mut uint32_t,
    ) -> bool32_t;
    fn SNetRegisterEventHandler(eventid: uint32_t, callback: SNETEVENTPROC) -> bool32_t;
    fn SNetUnregisterEventHandler(
        eventid: uint32_t,
        callback: SNETEVENTPROC,
    ) -> bool32_t;
    fn SNetDropPlayer(playerid: uint32_t, exitcode: uint32_t) -> bool32_t;
    fn SNetGetGameInfo(
        index: uint32_t,
        buffer: *mut libc::c_void,
        buffersize: uint32_t,
        byteswritten: *mut uint32_t,
    ) -> bool32_t;
    fn UiSelectHero() -> bool32_t;
    fn DeltaSendAllLevels(pnum: libc::c_int);
    fn ParseCmd(pnum: libc::c_int, pCmd: *const TCmd) -> uint32_t;
    fn wait_delta_info() -> bool32_t;
    fn delta_init();
    fn buffer_drop_player(pnum: libc::c_int, dwReason: uint32_t);
    fn delta_close_portal(pnum: libc::c_int);
    fn nthread_init(bRequestDelta: bool32_t);
    fn nthread_free();
    fn nthread_fill_sync_queue(dwCounter: uint32_t, dwIncrement: uint32_t) -> uint32_t;
    fn nthread_msg_check(pfSendAsync: *mut bool32_t) -> bool32_t;
    fn nthread_check_snet_error(pszFcn: *const libc::c_char);
    fn PackPlayer(p: *mut PkPlayerStruct, pnum: libc::c_int, manashield: bool32_t);
    fn UnPackPlayer(pPack: *const PkPlayerStruct, pnum: libc::c_int, killok: bool32_t);
    fn LoadPlrGFX(_: libc::c_int, _: uint32_t);
    fn SyncInitPlr(_: libc::c_int);
    fn MakePlrPath(_: libc::c_int, _: libc::c_int, _: libc::c_int, _: bool32_t);
    fn FixPlrWalkTags(pnum: libc::c_int);
    fn NewPlrAnim(
        pnum: libc::c_int,
        pAnim: *mut uint8_t,
        numFrames: libc::c_int,
        Delay: libc::c_int,
        width: int32_t,
    );
    fn StartStand(pnum: libc::c_int, dir: libc::c_int);
    fn RemovePlrFromMap(pnum: libc::c_int);
    fn RemovePlrMissiles(pnum: libc::c_int);
    fn sysmsg_add_string(pszMsg: *const libc::c_char);
    fn sysmsg_add(pszFmt: *const libc::c_char, _: ...);
    fn plrmsg_init();
    fn DeactivatePortal(i: libc::c_int);
    fn RemovePortalMissile(i: libc::c_int);
    fn sync_init();
    fn sync_get(pbBuf: *mut uint8_t, dwMaxLen: uint32_t) -> uint32_t;
    fn tmsg_init();
    fn tmsg_free();
    fn tmsg_get(pbMsg: *mut uint8_t, dwMaxLen: uint32_t) -> uint32_t;
    fn tmsg_add(pbMsg: *const uint8_t, bLen: uint8_t);
    static mut davedebug: bool32_t;
    static mut cheatflag: bool32_t;
    static mut gbNoDropInactive: bool32_t;
    static mut gbRunGame: bool32_t;
    static mut glSeedTbl: [uint32_t; 17];
    static mut gnLevelTypeTbl: [libc::c_int; 17];
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut setlevel: uint8_t;
    static mut gnDifficulty: libc::c_int;
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dPlayer: [[int8_t; 112]; 112];
    static mut monster: [MonsterStruct; 200];
    static mut gbBufferMsgs: uint8_t;
    static mut dwRecCount: uint32_t;
    static mut gbMaxPlayers: uint8_t;
    static mut gbActivePlayers: uint8_t;
    static mut gbGameDestroyed: uint8_t;
    static mut gbDeltaSender: uint8_t;
    static mut gbSomebodyWonGameKludge: uint8_t;
    static mut sgdwGameLoops: uint32_t;
    static mut gszGameName: [libc::c_char; 128];
    static mut gszGamePass: [libc::c_char; 128];
    static mut sgwPackPlrOffsetTbl: [uint16_t; 4];
    static mut gdwNormalMsgSize: uint32_t;
    static mut gdwLargestMsgSize: uint32_t;
    static mut gbGameLoopsPerPacket: uint8_t;
    static mut gdwTurnsInTransit: uint32_t;
    static mut gdwMsgLenTbl: [uint32_t; 4];
    static mut gdwMsgStatTbl: [uint32_t; 4];
    static mut glpMsgTbl: [*mut libc::c_void; 4];
    static mut plrxoff: [libc::c_int; 9];
    static mut plryoff: [libc::c_int; 9];
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut set_game_seed: libc::c_int;
    fn _logf(format: *const libc::c_char, _: ...);
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type __time_t = libc::c_long;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type time_t = __time_t;
pub type C2RustUnnamed = libc::c_uint;
pub const CHEATS: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const NO_STORM_NETWORK: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const TURN_COUNTER_RESET_MASK: C2RustUnnamed_1 = 65535;
pub const TURN_COUNTER_MASK: C2RustUnnamed_1 = 2147483647;
pub const TURN_REQUEST_DELTA_FLAG: C2RustUnnamed_1 = 2147483648;
pub const STARTY: C2RustUnnamed_1 = 68;
pub const STARTX: C2RustUnnamed_1 = 75;
pub const ASYNC_CYCLES_PER_SYNC: C2RustUnnamed_1 = 4;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const LEAVE_GAME_DELAY: C2RustUnnamed_2 = 20000;
pub const DROP_NOTRESPONDING_DELAY: C2RustUnnamed_2 = 10000;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const MAX_BUF_DATA: C2RustUnnamed_3 = 4096;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const M_DIRUL: C2RustUnnamed_4 = 3;
pub const M_DIRL: C2RustUnnamed_4 = 2;
pub const M_DIRDL: C2RustUnnamed_4 = 1;
pub const M_DIRD: C2RustUnnamed_4 = 0;
pub const M_DIRDR: C2RustUnnamed_4 = 7;
pub const M_DIRR: C2RustUnnamed_4 = 6;
pub const M_DIRUR: C2RustUnnamed_4 = 5;
pub const M_DIRU: C2RustUnnamed_4 = 4;
pub const DIR_UL: C2RustUnnamed_4 = 3;
pub const DIR_L: C2RustUnnamed_4 = 2;
pub const DIR_DL: C2RustUnnamed_4 = 1;
pub const DIR_D: C2RustUnnamed_4 = 0;
pub const DIR_DR: C2RustUnnamed_4 = 7;
pub const DIR_R: C2RustUnnamed_4 = 6;
pub const DIR_UR: C2RustUnnamed_4 = 5;
pub const DIR_U: C2RustUnnamed_4 = 4;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed_5 = 191;
pub const SETP_TEMP: C2RustUnnamed_5 = 64;
pub const SETP_MASK: C2RustUnnamed_5 = 127;
pub const SETP_BIT: C2RustUnnamed_5 = 128;
pub const BFMASK_MISSILE: C2RustUnnamed_5 = 254;
pub const BFMASK_SETPC: C2RustUnnamed_5 = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed_5 = 239;
pub const BFMASK_PLRLR: C2RustUnnamed_5 = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed_5 = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed_5 = 127;
pub const BFLAG_MISSILE: C2RustUnnamed_5 = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed_5 = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed_5 = 4;
pub const BFLAG_SETPC: C2RustUnnamed_5 = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed_5 = 16;
pub const BFLAG_PLRLR: C2RustUnnamed_5 = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed_5 = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed_5 = 128;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const NUM_CMDS: C2RustUnnamed_6 = 96;
pub const FAKE_CMD_DROPID: C2RustUnnamed_6 = 95;
pub const FAKE_CMD_SETID: C2RustUnnamed_6 = 94;
pub const CMD_REMSHIELD: C2RustUnnamed_6 = 93;
pub const CMD_SETSHIELD: C2RustUnnamed_6 = 92;
pub const CMD_NOVA: C2RustUnnamed_6 = 91;
pub const CMD_AWAKEGOLEM: C2RustUnnamed_6 = 90;
pub const CMD_ENDSHIELD: C2RustUnnamed_6 = 89;
pub const CMD_SYNCQUEST: C2RustUnnamed_6 = 88;
pub const CMD_KILLGOLEM: C2RustUnnamed_6 = 87;
pub const CMD_SYNCPUTITEM: C2RustUnnamed_6 = 86;
pub const CMD_ITEMEXTRA: C2RustUnnamed_6 = 85;
pub const CMD_SPELLXYD: C2RustUnnamed_6 = 84;
pub const CMD_RETOWN: C2RustUnnamed_6 = 83;
pub const CMD_SETVIT: C2RustUnnamed_6 = 82;
pub const CMD_SETDEX: C2RustUnnamed_6 = 81;
pub const CMD_SETMAG: C2RustUnnamed_6 = 80;
pub const CMD_SETSTR: C2RustUnnamed_6 = 79;
pub const CMD_STRING: C2RustUnnamed_6 = 78;
pub const CMD_HEALOTHER: C2RustUnnamed_6 = 77;
pub const CMD_DLEVEL_END: C2RustUnnamed_6 = 76;
pub const CMD_DLEVEL_JUNK: C2RustUnnamed_6 = 75;
pub const CMD_DLEVEL_16: C2RustUnnamed_6 = 74;
pub const CMD_DLEVEL_15: C2RustUnnamed_6 = 73;
pub const CMD_DLEVEL_14: C2RustUnnamed_6 = 72;
pub const CMD_DLEVEL_13: C2RustUnnamed_6 = 71;
pub const CMD_DLEVEL_12: C2RustUnnamed_6 = 70;
pub const CMD_DLEVEL_11: C2RustUnnamed_6 = 69;
pub const CMD_DLEVEL_10: C2RustUnnamed_6 = 68;
pub const CMD_DLEVEL_9: C2RustUnnamed_6 = 67;
pub const CMD_DLEVEL_8: C2RustUnnamed_6 = 66;
pub const CMD_DLEVEL_7: C2RustUnnamed_6 = 65;
pub const CMD_DLEVEL_6: C2RustUnnamed_6 = 64;
pub const CMD_DLEVEL_5: C2RustUnnamed_6 = 63;
pub const CMD_DLEVEL_4: C2RustUnnamed_6 = 62;
pub const CMD_DLEVEL_3: C2RustUnnamed_6 = 61;
pub const CMD_DLEVEL_2: C2RustUnnamed_6 = 60;
pub const CMD_DLEVEL_1: C2RustUnnamed_6 = 59;
pub const CMD_DLEVEL_0: C2RustUnnamed_6 = 58;
pub const CMD_DEACTIVATEPORTAL: C2RustUnnamed_6 = 57;
pub const CMD_ACTIVATEPORTAL: C2RustUnnamed_6 = 56;
pub const CMD_SATTACKXY: C2RustUnnamed_6 = 55;
pub const CMD_SEND_PLRINFO: C2RustUnnamed_6 = 54;
pub const CMD_PLAYER_JOINLEVEL: C2RustUnnamed_6 = 53;
pub const CMD_DROPITEM: C2RustUnnamed_6 = 52;
pub const CMD_PLRLEVEL: C2RustUnnamed_6 = 51;
pub const CMD_PLRDAMAGE: C2RustUnnamed_6 = 50;
pub const CMD_DELPLRITEMS: C2RustUnnamed_6 = 49;
pub const CMD_CHANGEPLRITEMS: C2RustUnnamed_6 = 48;
pub const CMD_BREAKOBJ: C2RustUnnamed_6 = 47;
pub const CMD_PLROPOBJ: C2RustUnnamed_6 = 46;
pub const CMD_OPERATEOBJ: C2RustUnnamed_6 = 45;
pub const CMD_CLOSEDOOR: C2RustUnnamed_6 = 44;
pub const CMD_OPENDOOR: C2RustUnnamed_6 = 43;
pub const CMD_GOTOAGETITEM: C2RustUnnamed_6 = 42;
pub const CMD_GOTOGETITEM: C2RustUnnamed_6 = 41;
pub const CMD_REQUESTAGITEM: C2RustUnnamed_6 = 40;
pub const CMD_REQUESTGITEM: C2RustUnnamed_6 = 39;
pub const CMD_PLRDEAD: C2RustUnnamed_6 = 38;
pub const CMD_MONSTDAMAGE: C2RustUnnamed_6 = 37;
pub const CMD_MONSTDEATH: C2RustUnnamed_6 = 36;
pub const CMD_SYNCDATA: C2RustUnnamed_6 = 35;
pub const CMD_DEBUG: C2RustUnnamed_6 = 34;
pub const CMD_CHEAT_SPELL_LEVEL: C2RustUnnamed_6 = 33;
pub const CMD_CHEAT_EXPERIENCE: C2RustUnnamed_6 = 32;
pub const CMD_WARP: C2RustUnnamed_6 = 31;
pub const CMD_NEWLVL: C2RustUnnamed_6 = 30;
pub const CMD_TALKXY: C2RustUnnamed_6 = 29;
pub const CMD_KNOCKBACK: C2RustUnnamed_6 = 28;
pub const CMD_OPOBJT: C2RustUnnamed_6 = 27;
pub const CMD_RESURRECT: C2RustUnnamed_6 = 26;
pub const CMD_TSPELLPID: C2RustUnnamed_6 = 25;
pub const CMD_TSPELLID: C2RustUnnamed_6 = 24;
pub const CMD_SPELLPID: C2RustUnnamed_6 = 23;
pub const CMD_SPELLID: C2RustUnnamed_6 = 22;
pub const CMD_RATTACKPID: C2RustUnnamed_6 = 21;
pub const CMD_RATTACKID: C2RustUnnamed_6 = 20;
pub const CMD_ATTACKPID: C2RustUnnamed_6 = 19;
pub const CMD_ATTACKID: C2RustUnnamed_6 = 18;
pub const CMD_DISARMXY: C2RustUnnamed_6 = 17;
pub const CMD_OPOBJXY: C2RustUnnamed_6 = 16;
pub const CMD_TSPELLXY: C2RustUnnamed_6 = 15;
pub const CMD_SPELLXY: C2RustUnnamed_6 = 14;
pub const CMD_RATTACKXY: C2RustUnnamed_6 = 13;
pub const CMD_ATTACKXY: C2RustUnnamed_6 = 12;
pub const CMD_RESPAWNITEM: C2RustUnnamed_6 = 11;
pub const CMD_PUTITEM: C2RustUnnamed_6 = 10;
pub const CMD_AGETITEM: C2RustUnnamed_6 = 9;
pub const CMD_GETITEM: C2RustUnnamed_6 = 8;
pub const CMD_SBSPELL: C2RustUnnamed_6 = 7;
pub const CMD_ADDVIT: C2RustUnnamed_6 = 6;
pub const CMD_ADDDEX: C2RustUnnamed_6 = 5;
pub const CMD_ADDMAG: C2RustUnnamed_6 = 4;
pub const CMD_ADDSTR: C2RustUnnamed_6 = 3;
pub const CMD_ACK_PLRINFO: C2RustUnnamed_6 = 2;
pub const CMD_WALKXY: C2RustUnnamed_6 = 1;
pub const CMD_STAND: C2RustUnnamed_6 = 0;
pub type C2RustUnnamed_7 = libc::c_uint;
pub const BUFFER_PROCESS: C2RustUnnamed_7 = 2;
pub const BUFFER_ON: C2RustUnnamed_7 = 1;
pub const BUFFER_OFF: C2RustUnnamed_7 = 0;
pub type bool32_t = uint32_t;
pub type Uint32 = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SNETEVENT {
    pub eventid: uint32_t,
    pub playerid: uint32_t,
    pub data: *mut libc::c_void,
    pub databytes: uint32_t,
}
pub type SNETEVENTPROC = Option::<unsafe extern "C" fn(*mut SNETEVENT) -> ()>;
pub type C2RustUnnamed_8 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_8 = 32;
pub const MAXMICRO: C2RustUnnamed_8 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_8 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_8 = 64;
pub const MAXMREND: C2RustUnnamed_8 = 128;
pub const MAXTILES: C2RustUnnamed_8 = 2048;
pub const MDMAXY: C2RustUnnamed_8 = 40;
pub const MDMAXX: C2RustUnnamed_8 = 40;
pub const MAXDUNY: C2RustUnnamed_8 = 112;
pub const MAXDUNX: C2RustUnnamed_8 = 112;
pub const DMAXY: C2RustUnnamed_8 = 112;
pub const DMAXX: C2RustUnnamed_8 = 112;
pub const DIRTEDGED2: C2RustUnnamed_8 = 16;
pub const DIRTEDGE: C2RustUnnamed_8 = 32;
pub const NUMSLEVELS: C2RustUnnamed_8 = 10;
pub const NUMLEVELS: C2RustUnnamed_8 = 17;
pub const LVL4_START: C2RustUnnamed_8 = 13;
pub const LVL3_START: C2RustUnnamed_8 = 9;
pub const LVL2_START: C2RustUnnamed_8 = 5;
pub const LVL1_START: C2RustUnnamed_8 = 1;
pub const TLVL_START: C2RustUnnamed_8 = 0;
pub const LVLLENGTH: C2RustUnnamed_8 = 4;
pub type C2RustUnnamed_9 = libc::c_uint;
pub const INITMONSTRAD: C2RustUnnamed_9 = 15;
pub const MAX_MS: C2RustUnnamed_9 = 4;
pub const IMG_MAX: C2RustUnnamed_9 = 4000;
pub const MAX_ANIMTYPE: C2RustUnnamed_9 = 6;
pub const MONSTDENSITY: C2RustUnnamed_9 = 30;
pub const MAX_LVLMTYPES: C2RustUnnamed_9 = 16;
pub const MONSTERTYPES: C2RustUnnamed_9 = 200;
pub const MAXMONSTERS: C2RustUnnamed_9 = 200;
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct TCmd {
    pub bCmd: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct TCmdPlrInfoHdr {
    pub bCmd: uint8_t,
    pub wOffset: uint16_t,
    pub wBytes: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct TPktHdr {
    pub px: uint8_t,
    pub py: uint8_t,
    pub targx: uint8_t,
    pub targy: uint8_t,
    pub php: uint32_t,
    pub pmhp: uint32_t,
    pub bstr: uint8_t,
    pub bmag: uint8_t,
    pub bdex: uint8_t,
    pub wCheck: uint16_t,
    pub wLen: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct TPkt {
    pub hdr: TPktHdr,
    pub body: [uint8_t; 493],
}
pub type C2RustUnnamed_10 = libc::c_uint;
pub const PGL_ALL: C2RustUnnamed_10 = 383;
pub const PGL_BLOCK: C2RustUnnamed_10 = 256;
pub const PGL_DEAD: C2RustUnnamed_10 = 128;
pub const PGL_TMAG: C2RustUnnamed_10 = 64;
pub const PGL_FMAG: C2RustUnnamed_10 = 32;
pub const PGL_LMAG: C2RustUnnamed_10 = 16;
pub const PGL_HIT: C2RustUnnamed_10 = 8;
pub const PGL_ATTACK: C2RustUnnamed_10 = 4;
pub const PGL_WALK: C2RustUnnamed_10 = 2;
pub const PGL_STAND: C2RustUnnamed_10 = 1;
pub type C2RustUnnamed_11 = libc::c_uint;
pub const PGFX_CSHIFT: C2RustUnnamed_11 = 4;
pub const PGFX_CMASK: C2RustUnnamed_11 = 240;
pub const PGFX_MASK: C2RustUnnamed_11 = 15;
pub const PGFX_THGUY: C2RustUnnamed_11 = 40;
pub const PGFX_CHGUY: C2RustUnnamed_11 = 39;
pub const PGFX_ZHGUY: C2RustUnnamed_11 = 38;
pub const PGFX_FHGUY: C2RustUnnamed_11 = 37;
pub const PGFX_BHGUY: C2RustUnnamed_11 = 36;
pub const PGFX_HGUY: C2RustUnnamed_11 = 35;
pub const PGFX_XHGUY: C2RustUnnamed_11 = 34;
pub const PGFX_SHGUY: C2RustUnnamed_11 = 33;
pub const PGFX_NHGUY: C2RustUnnamed_11 = 32;
pub const PGFX_TMGUY: C2RustUnnamed_11 = 24;
pub const PGFX_CMGUY: C2RustUnnamed_11 = 23;
pub const PGFX_ZMGUY: C2RustUnnamed_11 = 22;
pub const PGFX_FMGUY: C2RustUnnamed_11 = 21;
pub const PGFX_BMGUY: C2RustUnnamed_11 = 20;
pub const PGFX_MGUY: C2RustUnnamed_11 = 19;
pub const PGFX_XMGUY: C2RustUnnamed_11 = 18;
pub const PGFX_SMGUY: C2RustUnnamed_11 = 17;
pub const PGFX_NMGUY: C2RustUnnamed_11 = 16;
pub const PGFX_TGUY: C2RustUnnamed_11 = 8;
pub const PGFX_CGUY: C2RustUnnamed_11 = 7;
pub const PGFX_ZGUY: C2RustUnnamed_11 = 6;
pub const PGFX_FGUY: C2RustUnnamed_11 = 5;
pub const PGFX_BGUY: C2RustUnnamed_11 = 4;
pub const PGFX_GUY: C2RustUnnamed_11 = 3;
pub const PGFX_XGUY: C2RustUnnamed_11 = 2;
pub const PGFX_SGUY: C2RustUnnamed_11 = 1;
pub const PGFX_NGUY: C2RustUnnamed_11 = 0;
pub type C2RustUnnamed_12 = libc::c_int;
pub const PCMD_SPELLXYD: C2RustUnnamed_12 = 26;
pub const PCMD_SPELLPID: C2RustUnnamed_12 = 25;
pub const PCMD_SPELLID: C2RustUnnamed_12 = 24;
pub const PCMD_RATTACKPID: C2RustUnnamed_12 = 23;
pub const PCMD_RATTACKID: C2RustUnnamed_12 = 22;
pub const PCMD_ATTACKPID: C2RustUnnamed_12 = 21;
pub const PCMD_ATTACKID: C2RustUnnamed_12 = 20;
pub const PCMD_TELEK: C2RustUnnamed_12 = 18;
pub const PCMD_TALK: C2RustUnnamed_12 = 17;
pub const PCMD_REQAGETITEM: C2RustUnnamed_12 = 16;
pub const PCMD_REQGETITEM: C2RustUnnamed_12 = 15;
pub const PCMD_DISARM: C2RustUnnamed_12 = 14;
pub const PCMD_OPOBJ: C2RustUnnamed_12 = 13;
pub const PCMD_SPELL: C2RustUnnamed_12 = 12;
pub const PCMD_BLOCK: C2RustUnnamed_12 = 11;
pub const PCMD_RATTACK: C2RustUnnamed_12 = 10;
pub const PCMD_ATTACK: C2RustUnnamed_12 = 9;
pub const PCMD_WALKL: C2RustUnnamed_12 = 8;
pub const PCMD_WALKD: C2RustUnnamed_12 = 7;
pub const PCMD_WALKR: C2RustUnnamed_12 = 6;
pub const PCMD_WALKU: C2RustUnnamed_12 = 5;
pub const PCMD_WALKDL: C2RustUnnamed_12 = 4;
pub const PCMD_WALKDR: C2RustUnnamed_12 = 3;
pub const PCMD_WALKUL: C2RustUnnamed_12 = 2;
pub const PCMD_WALKUR: C2RustUnnamed_12 = 1;
pub const PCMD_STAND: C2RustUnnamed_12 = 0;
pub const PCMD_NOTHING: C2RustUnnamed_12 = -1;
pub type C2RustUnnamed_13 = libc::c_uint;
pub const PM_QUIT: C2RustUnnamed_13 = 11;
pub const PM_NEWLVL: C2RustUnnamed_13 = 10;
pub const PM_SPELL: C2RustUnnamed_13 = 9;
pub const PM_DEATH: C2RustUnnamed_13 = 8;
pub const PM_GOTHIT: C2RustUnnamed_13 = 7;
pub const PM_BLOCK: C2RustUnnamed_13 = 6;
pub const PM_RATTACK: C2RustUnnamed_13 = 5;
pub const PM_ATTACK: C2RustUnnamed_13 = 4;
pub const PM_WALK3: C2RustUnnamed_13 = 3;
pub const PM_WALK2: C2RustUnnamed_13 = 2;
pub const PM_WALK: C2RustUnnamed_13 = 1;
pub const PM_STAND: C2RustUnnamed_13 = 0;
pub type C2RustUnnamed_14 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_14 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_14 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_14 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_14 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_14 = 32;
pub const MAXSPD: C2RustUnnamed_14 = 8;
pub const MAXINV: C2RustUnnamed_14 = 40;
pub const MAXPATHLEN: C2RustUnnamed_14 = 25;
pub const MANA_SHIFT: C2RustUnnamed_14 = 6;
pub const HP_SHIFT: C2RustUnnamed_14 = 6;
pub const NUM_CLASSES: C2RustUnnamed_14 = 3;
pub const MAXPACKLEN: C2RustUnnamed_14 = 256;
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct PkItemStruct {
    pub iSeed: libc::c_int,
    pub iCreateInfo: uint16_t,
    pub idx: uint16_t,
    pub bId: uint8_t,
    pub bDur: uint8_t,
    pub bMDur: uint8_t,
    pub bCh: uint8_t,
    pub bMCh: uint8_t,
    pub wValue: uint16_t,
    pub dwBuff: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C, packed)]
pub struct PkPlayerStruct {
    pub archiveTime: uint64_t,
    pub destAction: uint8_t,
    pub destParam1: uint8_t,
    pub destParam2: uint8_t,
    pub plrlevel: uint8_t,
    pub px: uint8_t,
    pub py: uint8_t,
    pub targx: uint8_t,
    pub targy: uint8_t,
    pub pName: [libc::c_char; 32],
    pub pClass: uint8_t,
    pub pBaseStr: uint8_t,
    pub pBaseMag: uint8_t,
    pub pBaseDex: uint8_t,
    pub pBaseVit: uint8_t,
    pub pLevel: uint8_t,
    pub pStatPts: uint8_t,
    pub pExperience: int32_t,
    pub pGold: int32_t,
    pub pHPBase: int32_t,
    pub pMaxHPBase: int32_t,
    pub pManaBase: int32_t,
    pub pMaxManaBase: int32_t,
    pub pSplLvl: [uint8_t; 37],
    pub pMemSpells: uint64_t,
    pub InvBody: [PkItemStruct; 7],
    pub InvList: [PkItemStruct; 40],
    pub InvGrid: [int8_t; 40],
    pub _pNumInv: uint8_t,
    pub SpdList: [PkItemStruct; 8],
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TGAMEDATA {
    pub dwSeed: uint32_t,
    pub bDiff: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterStruct {
    pub _mMTidx: libc::c_int,
    pub _mmode: libc::c_int,
    pub _mgoal: uint8_t,
    pub _mgoalvar1: libc::c_int,
    pub _mgoalvar2: libc::c_int,
    pub _mgoalvar3: libc::c_int,
    pub _mgoalvar4: libc::c_int,
    pub _pathcount: uint8_t,
    pub _mx: libc::c_int,
    pub _my: libc::c_int,
    pub _mfutx: libc::c_int,
    pub _mfuty: libc::c_int,
    pub _moldx: libc::c_int,
    pub _moldy: libc::c_int,
    pub _mxoff: int32_t,
    pub _myoff: int32_t,
    pub _mxvel: int32_t,
    pub _myvel: int32_t,
    pub _mdir: libc::c_int,
    pub _menemy: libc::c_int,
    pub _menemyx: uint8_t,
    pub _menemyy: uint8_t,
    pub _mAnimData: *mut uint8_t,
    pub _mAnimDelay: libc::c_int,
    pub _mAnimCnt: libc::c_int,
    pub _mAnimLen: libc::c_int,
    pub _mAnimFrame: libc::c_int,
    pub _meflag: libc::c_int,
    pub _mDelFlag: bool32_t,
    pub _mVar1: int32_t,
    pub _mVar2: int32_t,
    pub _mVar3: int32_t,
    pub _mVar4: int32_t,
    pub _mVar5: int32_t,
    pub _mVar6: int32_t,
    pub _mVar7: int32_t,
    pub _mVar8: int32_t,
    pub _mmaxhp: int32_t,
    pub _mhitpoints: int32_t,
    pub _mAi: uint8_t,
    pub _mint: uint8_t,
    pub _mFlags: uint32_t,
    pub _msquelch: uint8_t,
    pub _mAFNum: libc::c_int,
    pub _lastx: libc::c_int,
    pub _lasty: libc::c_int,
    pub _mRndSeed: libc::c_int,
    pub _mAISeed: libc::c_int,
    pub _Wandering: bool32_t,
    pub _uniqtype: uint8_t,
    pub _uniqtrans: uint8_t,
    pub _udeadval: int8_t,
    pub mWhoHit: int8_t,
    pub mLevel: int8_t,
    pub mExp: uint16_t,
    pub mHit: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMagicRes: uint16_t,
    pub mtalkmsg: libc::c_int,
    pub leader: uint8_t,
    pub leaderflag: uint8_t,
    pub packsize: uint8_t,
    pub mlid: uint8_t,
    pub mName: *const libc::c_char,
    pub MType: *mut CMonster,
    pub MData: *mut MonsterData,
}
pub type C2RustUnnamed_15 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_15 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_15 = 92160;
pub const BTMBUFFY: C2RustUnnamed_15 = 144;
pub const BTMBUFFX: C2RustUnnamed_15 = 640;
pub const BUFFERSIZE: C2RustUnnamed_15 = 503808;
pub const BUFFERY: C2RustUnnamed_15 = 656;
pub const BUFFERX: C2RustUnnamed_15 = 768;
pub const GAMEY: C2RustUnnamed_15 = 352;
pub const CTRLPANY: C2RustUnnamed_15 = 128;
pub const TOTALY: C2RustUnnamed_15 = 480;
pub const TOTALX: C2RustUnnamed_15 = 640;
pub const MAX_PLRS: C2RustUnnamed_15 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TBuffer {
    pub dwNextWriteOffset: uint32_t,
    pub bData: [uint8_t; 4096],
}
static mut sgbNetInited: bool32_t = 0 as libc::c_int as bool32_t;
static mut sgbSentThisCycle: bool32_t = 0;
static mut sgdwSyncMsgs: uint32_t = 0;
static mut sgPackPlr: [PkPlayerStruct; 4] = [PkPlayerStruct {
    archiveTime: 0,
    destAction: 0,
    destParam1: 0,
    destParam2: 0,
    plrlevel: 0,
    px: 0,
    py: 0,
    targx: 0,
    targy: 0,
    pName: [0; 32],
    pClass: 0,
    pBaseStr: 0,
    pBaseMag: 0,
    pBaseDex: 0,
    pBaseVit: 0,
    pLevel: 0,
    pStatPts: 0,
    pExperience: 0,
    pGold: 0,
    pHPBase: 0,
    pMaxHPBase: 0,
    pManaBase: 0,
    pMaxManaBase: 0,
    pSplLvl: [0; 37],
    pMemSpells: 0,
    InvBody: [PkItemStruct {
        iSeed: 0,
        iCreateInfo: 0,
        idx: 0,
        bId: 0,
        bDur: 0,
        bMDur: 0,
        bCh: 0,
        bMCh: 0,
        wValue: 0,
        dwBuff: 0,
    }; 7],
    InvList: [PkItemStruct {
        iSeed: 0,
        iCreateInfo: 0,
        idx: 0,
        bId: 0,
        bDur: 0,
        bMDur: 0,
        bCh: 0,
        bMCh: 0,
        wValue: 0,
        dwBuff: 0,
    }; 40],
    InvGrid: [0; 40],
    _pNumInv: 0,
    SpdList: [PkItemStruct {
        iSeed: 0,
        iCreateInfo: 0,
        idx: 0,
        bId: 0,
        bDur: 0,
        bMDur: 0,
        bCh: 0,
        bMCh: 0,
        wValue: 0,
        dwBuff: 0,
    }; 8],
    pTownWarps: 0,
    pDungMsgs: 0,
    pLvlLoad: 0,
    pBattleNet: 0,
    pManaShield: 0,
    bReserved6: 0,
    bReserved7: 0,
    bReserved8: 0,
    wReserved1: 0,
    wReserved2: 0,
    wReserved3: 0,
    wReserved4: 0,
    wReserved5: 0,
    wReserved6: 0,
    wReserved7: 0,
    wReserved8: 0,
    pDiabloKillLevel: 0,
    dwReserved2: 0,
    dwReserved3: 0,
    dwReserved4: 0,
    dwReserved5: 0,
    dwReserved6: 0,
    dwReserved7: 0,
    dwReserved8: 0,
}; 4];
static mut sgbPlayerLeftGameTbl: [uint8_t; 4] = [0; 4];
static mut sgdwPlayerLeftReasonTbl: [uint32_t; 4] = [0; 4];
static mut sgbSendDeltaTbl: [uint8_t; 4] = [0; 4];
static mut sgGameInitInfo: TGAMEDATA = TGAMEDATA { dwSeed: 0, bDiff: 0 };
static mut sgbGameJoiner: [uint8_t; 4] = [0; 4];
static mut sgbTimeout: uint8_t = 0;
static mut sglTimeoutStart: int32_t = 0;
static mut sgLoPriBuf: TBuffer = TBuffer {
    dwNextWriteOffset: 0,
    bData: [0; 4096],
};
static mut sgHiPriBuf: TBuffer = TBuffer {
    dwNextWriteOffset: 0,
    bData: [0; 4096],
};
unsafe extern "C" fn buffer_init(mut pBuf: *mut TBuffer) {
    (*pBuf).dwNextWriteOffset = 0 as libc::c_int as uint32_t;
    (*pBuf).bData[0 as libc::c_int as usize] = 0 as libc::c_int as uint8_t;
}
unsafe extern "C" fn buffer_empty(mut pBuf: *mut TBuffer) -> bool32_t {
    return ((*pBuf).dwNextWriteOffset == 0 as libc::c_int as uint32_t) as libc::c_int
        as bool32_t;
}
unsafe extern "C" fn buffer_add(
    mut pBuf: *mut TBuffer,
    mut pbMsg: *const uint8_t,
    mut bLen: uint8_t,
) {
    if ((*pBuf).dwNextWriteOffset)
        .wrapping_add(bLen as uint32_t)
        .wrapping_add(2 as libc::c_int as uint32_t)
        > MAX_BUF_DATA as libc::c_int as uint32_t
    {
        app_fatal_(
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            91 as libc::c_int,
            b"msg buffer failure\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut pbData: *mut uint8_t = &mut *((*pBuf).bData)
        .as_mut_ptr()
        .offset((*pBuf).dwNextWriteOffset as isize) as *mut uint8_t;
    (*pBuf)
        .dwNextWriteOffset = ((*pBuf).dwNextWriteOffset)
        .wrapping_add((bLen as libc::c_int + 1 as libc::c_int) as uint32_t);
    let fresh0 = pbData;
    pbData = pbData.offset(1);
    *fresh0 = bLen;
    memcpy(
        pbData as *mut libc::c_void,
        pbMsg as *const libc::c_void,
        bLen as libc::c_ulong,
    );
    pbData = pbData.offset(bLen as libc::c_int as isize);
    *pbData = 0 as libc::c_int as uint8_t;
}
unsafe extern "C" fn buffer_get(
    mut pBuf: *mut TBuffer,
    mut pbMsg: *mut uint8_t,
    mut pdwMaxLen: *mut uint32_t,
) -> *mut uint8_t {
    if (*pBuf).dwNextWriteOffset == 0 {
        return pbMsg;
    }
    let mut pbData: *mut uint8_t = ((*pBuf).bData).as_mut_ptr();
    loop {
        let mut bLen: uint8_t = *pbData;
        if bLen == 0 {
            break;
        }
        if bLen as uint32_t > *pdwMaxLen {
            break;
        }
        pbData = pbData.offset(1);
        memcpy(
            pbMsg as *mut libc::c_void,
            pbData as *const libc::c_void,
            bLen as libc::c_ulong,
        );
        pbData = pbData.offset(bLen as libc::c_int as isize);
        pbMsg = pbMsg.offset(bLen as libc::c_int as isize);
        *pdwMaxLen = (*pdwMaxLen).wrapping_sub(bLen as uint32_t);
    }
    memmove(
        ((*pBuf).bData).as_mut_ptr() as *mut libc::c_void,
        pbData as *const libc::c_void,
        ((*pBuf).dwNextWriteOffset as libc::c_long
            - pbData.offset_from(((*pBuf).bData).as_mut_ptr()) as libc::c_long
            + 1 as libc::c_int as libc::c_long) as libc::c_ulong,
    );
    (*pBuf)
        .dwNextWriteOffset = ((*pBuf).dwNextWriteOffset as libc::c_long
        - pbData.offset_from(((*pBuf).bData).as_mut_ptr()) as libc::c_long) as uint32_t;
    return pbMsg;
}
unsafe extern "C" fn build_pkt_hdr(mut pkt: *mut TPkt) {
    if pkt.is_null() {
        assert_fail(
            143 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"pkt\0" as *const u8 as *const libc::c_char,
        );
    }
    (*pkt).hdr.wCheck = 0x6970 as libc::c_int as uint16_t;
    (*pkt).hdr.px = plr[myplr as usize]._px as uint8_t;
    (*pkt).hdr.py = plr[myplr as usize]._py as uint8_t;
    (*pkt).hdr.targx = plr[myplr as usize]._ptargx as uint8_t;
    (*pkt).hdr.targy = plr[myplr as usize]._ptargy as uint8_t;
    (*pkt).hdr.php = plr[myplr as usize]._pHitPoints as uint32_t;
    (*pkt).hdr.pmhp = plr[myplr as usize]._pMaxHP as uint32_t;
    (*pkt).hdr.bstr = plr[myplr as usize]._pBaseStr as uint8_t;
    (*pkt).hdr.bmag = plr[myplr as usize]._pBaseMag as uint8_t;
    (*pkt).hdr.bdex = plr[myplr as usize]._pBaseDex as uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn NetSendMyselfPri(mut pbMsg: *const uint8_t, mut bLen: uint8_t) {
    if sgbNetInited == 0 {
        assert_fail(
            157 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"sgbNetInited\0" as *const u8 as *const libc::c_char,
        );
    }
    if pbMsg.is_null() {
        return;
    }
    if bLen == 0 {
        return;
    }
    if !(bLen as libc::c_ulong
        <= (gdwNormalMsgSize as libc::c_ulong)
            .wrapping_sub(::core::mem::size_of::<TPktHdr>() as libc::c_ulong))
    {
        assert_fail(
            164 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"bLen <= gdwNormalMsgSize - sizeof(TPktHdr)\0" as *const u8
                as *const libc::c_char,
        );
    }
    tmsg_add(pbMsg, bLen);
}
unsafe extern "C" fn NetSendLocal(mut pbMsg: *const uint8_t, mut bLen: uint8_t) {
    if sgbNetInited == 0 {
        assert_fail(
            169 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"sgbNetInited\0" as *const u8 as *const libc::c_char,
        );
    }
    if pbMsg.is_null() {
        assert_fail(
            170 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"pbMsg\0" as *const u8 as *const libc::c_char,
        );
    }
    if bLen == 0 {
        assert_fail(
            171 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"bLen\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(bLen as libc::c_ulong
        <= (gdwNormalMsgSize as libc::c_ulong)
            .wrapping_sub(::core::mem::size_of::<TPktHdr>() as libc::c_ulong))
    {
        assert_fail(
            172 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"bLen <= gdwNormalMsgSize - sizeof(TPktHdr)\0" as *const u8
                as *const libc::c_char,
        );
    }
    let mut pkt: TPkt = TPkt {
        hdr: TPktHdr {
            px: 0,
            py: 0,
            targx: 0,
            targy: 0,
            php: 0,
            pmhp: 0,
            bstr: 0,
            bmag: 0,
            bdex: 0,
            wCheck: 0,
            wLen: 0,
        },
        body: [0; 493],
    };
    build_pkt_hdr(&mut pkt);
    pkt
        .hdr
        .wLen = (::core::mem::size_of::<TPktHdr>() as libc::c_ulong)
        .wrapping_add(bLen as libc::c_ulong) as uint16_t;
    memcpy(
        (pkt.body).as_mut_ptr() as *mut libc::c_void,
        pbMsg as *const libc::c_void,
        bLen as libc::c_ulong,
    );
    if SNetSendMessage(
        myplr as uint32_t,
        &mut pkt as *mut TPkt as *mut libc::c_void,
        pkt.hdr.wLen as uint32_t,
    ) == 0
    {
        nthread_check_snet_error(
            b"SNetSendMessage0\0" as *const u8 as *const libc::c_char,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn NetSendLoPri(mut pbMsg: *const uint8_t, mut bLen: uint8_t) {
    if sgbNetInited == 0 {
        assert_fail(
            187 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"sgbNetInited\0" as *const u8 as *const libc::c_char,
        );
    }
    if pbMsg.is_null() {
        return;
    }
    if bLen == 0 {
        return;
    }
    if !(bLen as libc::c_ulong
        <= (gdwNormalMsgSize as libc::c_ulong)
            .wrapping_sub(::core::mem::size_of::<TPktHdr>() as libc::c_ulong))
    {
        assert_fail(
            194 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"bLen <= gdwNormalMsgSize - sizeof(TPktHdr)\0" as *const u8
                as *const libc::c_char,
        );
    }
    if NO_STORM_NETWORK as libc::c_int != 0 {
        ParseCmd(myplr, pbMsg as *const TCmd);
        return;
    }
    buffer_add(&mut sgLoPriBuf, pbMsg, bLen);
    NetSendLocal(pbMsg, bLen);
}
#[no_mangle]
pub unsafe extern "C" fn NetSendHiPri(mut pbMsg: *const uint8_t, mut bLen: uint8_t) {
    if NO_STORM_NETWORK as libc::c_int != 0 {
        NetSendLoPri(pbMsg, bLen);
        return;
    }
    if sgbNetInited == 0 {
        assert_fail(
            211 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"sgbNetInited\0" as *const u8 as *const libc::c_char,
        );
    }
    if !pbMsg.is_null() && bLen as libc::c_int != 0 {
        if !(bLen as libc::c_ulong
            <= (gdwNormalMsgSize as libc::c_ulong)
                .wrapping_sub(::core::mem::size_of::<TPktHdr>() as libc::c_ulong))
        {
            assert_fail(
                213 as libc::c_int,
                b"src/multi.c\0" as *const u8 as *const libc::c_char,
                b"bLen <= gdwNormalMsgSize - sizeof(TPktHdr)\0" as *const u8
                    as *const libc::c_char,
            );
        }
        buffer_add(&mut sgHiPriBuf, pbMsg, bLen);
        NetSendLocal(pbMsg, bLen);
    }
    if sgbSentThisCycle != 0 {
        return;
    }
    sgbSentThisCycle = 1 as libc::c_int as bool32_t;
    if !((myplr as uint32_t) < MAX_PLRS as libc::c_int as uint32_t) {
        assert_fail(
            225 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)myplr < MAX_PLRS\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut pkt: TPkt = TPkt {
        hdr: TPktHdr {
            px: 0,
            py: 0,
            targx: 0,
            targy: 0,
            php: 0,
            pmhp: 0,
            bstr: 0,
            bmag: 0,
            bdex: 0,
            wCheck: 0,
            wLen: 0,
        },
        body: [0; 493],
    };
    build_pkt_hdr(&mut pkt);
    let mut pbBody: *mut uint8_t = (pkt.body).as_mut_ptr();
    let mut dwBytesLeft: uint32_t = (gdwNormalMsgSize as libc::c_ulong)
        .wrapping_sub(::core::mem::size_of::<TPktHdr>() as libc::c_ulong) as uint32_t;
    pbBody = buffer_get(&mut sgHiPriBuf, pbBody, &mut dwBytesLeft);
    pbBody = buffer_get(&mut sgLoPriBuf, pbBody, &mut dwBytesLeft);
    dwBytesLeft = sync_get(pbBody, dwBytesLeft);
    let mut dwSendBytes: uint32_t = gdwNormalMsgSize.wrapping_sub(dwBytesLeft);
    pkt.hdr.wLen = dwSendBytes as uint16_t;
    if SNetSendMessage(
        0xfffffffe as libc::c_uint,
        &mut pkt as *mut TPkt as *mut libc::c_void,
        dwSendBytes,
    ) == 0
    {
        nthread_check_snet_error(
            b"SNetSendMessage\0" as *const u8 as *const libc::c_char,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn NetSendMask(
    mut dwSendMask: uint32_t,
    mut pbMsg: *const uint8_t,
    mut bLen: uint8_t,
) {
    if NO_STORM_NETWORK as libc::c_int != 0 {
        NetSendLoPri(pbMsg, bLen);
        return;
    }
    if sgbNetInited == 0 {
        assert_fail(
            251 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"sgbNetInited\0" as *const u8 as *const libc::c_char,
        );
    }
    if pbMsg.is_null() {
        assert_fail(
            252 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"pbMsg\0" as *const u8 as *const libc::c_char,
        );
    }
    if bLen == 0 {
        assert_fail(
            253 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"bLen\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut pkt: TPkt = TPkt {
        hdr: TPktHdr {
            px: 0,
            py: 0,
            targx: 0,
            targy: 0,
            php: 0,
            pmhp: 0,
            bstr: 0,
            bmag: 0,
            bdex: 0,
            wCheck: 0,
            wLen: 0,
        },
        body: [0; 493],
    };
    build_pkt_hdr(&mut pkt);
    let mut dwSendBytes: uint32_t = (::core::mem::size_of::<TPktHdr>() as libc::c_ulong)
        .wrapping_add(bLen as libc::c_ulong) as uint32_t;
    if !(dwSendBytes < gdwNormalMsgSize) {
        assert_fail(
            261 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"dwSendBytes < gdwNormalMsgSize\0" as *const u8 as *const libc::c_char,
        );
    }
    pkt.hdr.wLen = dwSendBytes as uint16_t;
    memcpy(
        (pkt.body).as_mut_ptr() as *mut libc::c_void,
        pbMsg as *const libc::c_void,
        bLen as libc::c_ulong,
    );
    let mut dwMaskFlag: uint32_t = 0x1 as libc::c_int as uint32_t;
    let mut dwID: uint32_t = 0 as libc::c_int as uint32_t;
    while dwID < MAX_PLRS as libc::c_int as uint32_t {
        if !(dwMaskFlag & dwSendMask == 0) {
            let mut bSent: bool32_t = SNetSendMessage(
                dwID,
                &mut pkt as *mut TPkt as *mut libc::c_void,
                dwSendBytes,
            );
            if !(bSent != 0) {
                if !(SErrGetLastError()
                    == 0x80000000 as libc::c_uint
                        | ((0x510 as libc::c_int) << 16 as libc::c_int) as libc::c_uint
                        | (106 as libc::c_int & 0xffff as libc::c_int) as libc::c_uint)
                {
                    nthread_check_snet_error(
                        b"SNetSendMessage\0" as *const u8 as *const libc::c_char,
                    );
                    break;
                }
            }
        }
        dwID = dwID.wrapping_add(1);
        dwID;
        dwMaskFlag <<= 1 as libc::c_int;
    }
}
unsafe extern "C" fn NetResync() {
    sgdwGameLoops = sgdwGameLoops.wrapping_add(1);
    sgdwGameLoops;
    let mut dwSeed: uint32_t = rotr_(sgdwGameLoops, 8 as libc::c_int);
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAXMONSTERS as libc::c_int {
        monster[i as usize]
            ._mAISeed = (i as uint32_t).wrapping_add(dwSeed) as libc::c_int;
        i += 1;
        i;
    }
}
unsafe extern "C" fn check_DeltaSendAllLevels(mut nReceiver: libc::c_int) {
    let mut nSender: libc::c_int = 0;
    nSender = 0 as libc::c_int;
    while nSender < MAX_PLRS as libc::c_int {
        if !(gdwMsgStatTbl[nSender as usize] & 0x10000 as libc::c_int as uint32_t == 0) {
            if !(nSender == nReceiver) {
                break;
            }
        }
        nSender += 1;
        nSender;
    }
    if myplr == nSender {
        sgbSendDeltaTbl[nReceiver as usize] = 1 as libc::c_int as uint8_t;
    } else if myplr == nReceiver {
        gbDeltaSender = nSender as uint8_t;
    }
}
unsafe extern "C" fn check_sync(mut pnum: libc::c_int, mut dwSyncMsgs: uint32_t) {
    if dwSyncMsgs & TURN_REQUEST_DELTA_FLAG as libc::c_uint != 0 {
        check_DeltaSendAllLevels(pnum);
    }
    dwSyncMsgs &= TURN_COUNTER_MASK as libc::c_int as uint32_t;
    if sgdwSyncMsgs < dwSyncMsgs.wrapping_add(gdwTurnsInTransit) {
        if dwSyncMsgs >= TURN_COUNTER_MASK as libc::c_int as uint32_t {
            dwSyncMsgs &= TURN_COUNTER_RESET_MASK as libc::c_int as uint32_t;
        }
        sgdwSyncMsgs = dwSyncMsgs.wrapping_add(gdwTurnsInTransit);
        dwSyncMsgs = dwSyncMsgs * ASYNC_CYCLES_PER_SYNC as libc::c_int as uint32_t;
        dwSyncMsgs = dwSyncMsgs * gbGameLoopsPerPacket as uint32_t;
        sgdwGameLoops = dwSyncMsgs;
    }
}
#[no_mangle]
pub unsafe extern "C" fn process_turn() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAX_PLRS as libc::c_int {
        if gdwMsgStatTbl[i as usize] & 0x20000 as libc::c_int as uint32_t != 0 {
            if (glpMsgTbl[i as usize]).is_null() {
                assert_fail(
                    357 as libc::c_int,
                    b"src/multi.c\0" as *const u8 as *const libc::c_char,
                    b"glpMsgTbl[i]\0" as *const u8 as *const libc::c_char,
                );
            }
            if !(gdwMsgLenTbl[i as usize] as libc::c_ulong
                != ::core::mem::size_of::<uint32_t>() as libc::c_ulong)
            {
                check_sync(i, *(glpMsgTbl[i as usize] as *mut uint32_t));
            }
        }
        i += 1;
        i;
    }
}
unsafe extern "C" fn remove_active_player(mut i: libc::c_int, mut bMsg: bool32_t) {
    if plr[i as usize].plractive == 0 {
        return;
    }
    RemovePlrFromMap(i);
    RemovePortalMissile(i);
    DeactivatePortal(i);
    delta_close_portal(i);
    RemovePlrMissiles(i);
    if bMsg != 0 {
        let mut pszMsg_s: *const libc::c_char = b"Player '%s' just left the game\0"
            as *const u8 as *const libc::c_char;
        match sgdwPlayerLeftReasonTbl[i as usize] {
            1073741830 => {
                pszMsg_s = b"Player '%s' dropped due to timeout\0" as *const u8
                    as *const libc::c_char;
            }
            1073741828 => {
                pszMsg_s = b"Player '%s' killed Diablo and left the game!\0" as *const u8
                    as *const libc::c_char;
                gbSomebodyWonGameKludge = 1 as libc::c_int as uint8_t;
            }
            _ => {}
        }
        sysmsg_add(pszMsg_s, (plr[i as usize]._pName).as_mut_ptr());
    }
    plr[i as usize].plractive = 0 as libc::c_int as uint8_t;
    plr[i as usize]._pName[0 as libc::c_int as usize] = 0 as libc::c_int as libc::c_char;
    gbActivePlayers = gbActivePlayers.wrapping_sub(1);
    gbActivePlayers;
}
unsafe extern "C" fn update_players() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAX_PLRS as libc::c_int {
        if !(sgbPlayerLeftGameTbl[i as usize] == 0) {
            if gbBufferMsgs as libc::c_int == BUFFER_ON as libc::c_int {
                buffer_drop_player(i, sgdwPlayerLeftReasonTbl[i as usize]);
            } else {
                remove_active_player(i, 1 as libc::c_int as bool32_t);
            }
            sgbPlayerLeftGameTbl[i as usize] = 0 as libc::c_int as uint8_t;
            sgdwPlayerLeftReasonTbl[i as usize] = 0 as libc::c_int as uint32_t;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn unbuffer_remove_player(
    mut pnum: libc::c_int,
    mut dwReason: uint32_t,
) {
    sgbPlayerLeftGameTbl[pnum as usize] = 1 as libc::c_int as uint8_t;
    sgdwPlayerLeftReasonTbl[pnum as usize] = dwReason;
    update_players();
}
#[no_mangle]
pub unsafe extern "C" fn NetStartTimeout() {
    sgbTimeout = 1 as libc::c_int as uint8_t;
    sglTimeoutStart = SDL_GetTicks() as int32_t;
}
unsafe extern "C" fn drop_players() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAX_PLRS as libc::c_int {
        if !(gdwMsgStatTbl[i as usize] & 0x40000 as libc::c_int as uint32_t != 0) {
            if !(gdwMsgStatTbl[i as usize] & 0x10000 as libc::c_int as uint32_t == 0) {
                SNetDropPlayer(i as uint32_t, 0x40000006 as libc::c_int as uint32_t);
            }
        }
        i += 1;
        i;
    }
}
unsafe extern "C" fn drop_inactive_players() {
    if sgbTimeout == 0 {
        return;
    }
    if CHEATS as libc::c_int != 0 {
        if gbNoDropInactive != 0 {
            return;
        }
    }
    let mut lCurrTime: int32_t = SDL_GetTicks() as int32_t;
    lCurrTime -= sglTimeoutStart;
    if lCurrTime > LEAVE_GAME_DELAY as libc::c_int {
        gbRunGame = 0 as libc::c_int as bool32_t;
        return;
    }
    if lCurrTime < DROP_NOTRESPONDING_DELAY as libc::c_int {
        return;
    }
    let mut nLowestActive: libc::c_int = -(1 as libc::c_int);
    let mut nLowestPlayer: libc::c_int = -(1 as libc::c_int);
    let mut bGroupPlayers: uint8_t = 0 as libc::c_int as uint8_t;
    let mut bNonGroupPlayers: uint8_t = 0 as libc::c_int as uint8_t;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAX_PLRS as libc::c_int {
        if !(gdwMsgStatTbl[i as usize] & 0x10000 as libc::c_int as uint32_t == 0) {
            if nLowestPlayer == -(1 as libc::c_int) {
                nLowestPlayer = i;
            }
            if gdwMsgStatTbl[i as usize] & 0x40000 as libc::c_int as uint32_t != 0 {
                bGroupPlayers = bGroupPlayers.wrapping_add(1);
                bGroupPlayers;
                if nLowestActive == -(1 as libc::c_int) {
                    nLowestActive = i;
                }
            } else {
                bNonGroupPlayers = bNonGroupPlayers.wrapping_add(1);
                bNonGroupPlayers;
            }
        }
        i += 1;
        i;
    }
    if bGroupPlayers == 0 {
        assert_fail(
            513 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"bGroupPlayers\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(nLowestActive != -(1 as libc::c_int)) {
        assert_fail(
            514 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"nLowestActive != -1\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(nLowestPlayer != -(1 as libc::c_int)) {
        assert_fail(
            515 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"nLowestPlayer != -1\0" as *const u8 as *const libc::c_char,
        );
    }
    if (bGroupPlayers as libc::c_int) < bNonGroupPlayers as libc::c_int {
        gbGameDestroyed = 1 as libc::c_int as uint8_t;
    } else if bGroupPlayers as libc::c_int == bNonGroupPlayers as libc::c_int {
        if nLowestPlayer != nLowestActive {
            gbGameDestroyed = 1 as libc::c_int as uint8_t;
        } else if nLowestActive == myplr {
            drop_players();
        }
    } else if nLowestActive == myplr {
        drop_players();
    }
}
#[no_mangle]
pub unsafe extern "C" fn NetEndSendCycle() -> bool32_t {
    if sgbNetInited == 0 {
        assert_fail(
            533 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"sgbNetInited\0" as *const u8 as *const libc::c_char,
        );
    }
    if gbGameDestroyed != 0 {
        gbRunGame = 0 as libc::c_int as bool32_t;
        return 0 as libc::c_int as bool32_t;
    }
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAX_PLRS as libc::c_int {
        if !(sgbSendDeltaTbl[i as usize] == 0) {
            sgbSendDeltaTbl[i as usize] = 0 as libc::c_int as uint8_t;
            DeltaSendAllLevels(i);
        }
        i += 1;
        i;
    }
    let mut bSendAsync: bool32_t = 0;
    sgdwSyncMsgs = nthread_fill_sync_queue(sgdwSyncMsgs, 1 as libc::c_int as uint32_t);
    if nthread_msg_check(&mut bSendAsync) == 0 {
        drop_inactive_players();
        return 0 as libc::c_int as bool32_t;
    }
    sgbTimeout = 0 as libc::c_int as uint8_t;
    if !(bSendAsync == 0) {
        if sgbSentThisCycle == 0 {
            NetSendHiPri(0 as *const uint8_t, 0 as libc::c_int as uint8_t);
            sgbSentThisCycle = 0 as libc::c_int as bool32_t;
        } else {
            sgbSentThisCycle = 0 as libc::c_int as bool32_t;
            if buffer_empty(&mut sgHiPriBuf) == 0 {
                NetSendHiPri(0 as *const uint8_t, 0 as libc::c_int as uint8_t);
            }
        }
    }
    NetResync();
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn process_msg_body(
    mut dwID: uint32_t,
    mut pbCmd: *const uint8_t,
    mut dwBytes: uint32_t,
) {
    while dwBytes != 0 {
        let mut dwCmdLen: uint32_t = ParseCmd(dwID as libc::c_int, pbCmd as *const TCmd);
        if dwCmdLen == 0 as libc::c_int as uint32_t {
            return;
        }
        pbCmd = pbCmd.offset(dwCmdLen as isize);
        dwBytes = dwBytes.wrapping_sub(dwCmdLen);
    }
}
unsafe extern "C" fn handle_local_msgs() {
    let mut dwLen: uint32_t = 0;
    let mut msg: [uint8_t; 512] = [0; 512];
    loop {
        dwLen = tmsg_get(
            msg.as_mut_ptr(),
            ::core::mem::size_of::<[uint8_t; 512]>() as libc::c_ulong as uint32_t,
        );
        if !(0 as libc::c_int as uint32_t != dwLen) {
            break;
        }
        process_msg_body(myplr as uint32_t, msg.as_mut_ptr(), dwLen);
    };
}
#[no_mangle]
pub unsafe extern "C" fn NetReceivePackets() {
    let mut dwID: uint32_t = 0;
    let mut lpMsg: *mut libc::c_void = 0 as *mut libc::c_void;
    let mut dwMsgSize: uint32_t = 0;
    update_players();
    handle_local_msgs();
    if sgbNetInited == 0 {
        assert_fail(
            619 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"sgbNetInited\0" as *const u8 as *const libc::c_char,
        );
    }
    while SNetReceiveMessage(&mut dwID, &mut lpMsg, &mut dwMsgSize) != 0 {
        dwRecCount = dwRecCount.wrapping_add(1);
        dwRecCount;
        update_players();
        let mut pkt: *const TPkt = lpMsg as *const TPkt;
        if (dwMsgSize as libc::c_ulong)
            < ::core::mem::size_of::<TPktHdr>() as libc::c_ulong
        {
            continue;
        }
        if dwID >= MAX_PLRS as libc::c_int as uint32_t {
            continue;
        }
        if (*pkt).hdr.wCheck as libc::c_int != 0x6970 as libc::c_int {
            continue;
        }
        if (*pkt).hdr.wLen as uint32_t != dwMsgSize {
            continue;
        }
        plr[dwID as usize]._pownerx = (*pkt).hdr.px as libc::c_int;
        plr[dwID as usize]._pownery = (*pkt).hdr.py as libc::c_int;
        if dwID != myplr as uint32_t {
            if !(gbBufferMsgs as libc::c_int != BUFFER_PROCESS as libc::c_int) {
                assert_fail(
                    654 as libc::c_int,
                    b"src/multi.c\0" as *const u8 as *const libc::c_char,
                    b"gbBufferMsgs != BUFFER_PROCESS\0" as *const u8
                        as *const libc::c_char,
                );
            }
            plr[dwID as usize]._pHitPoints = (*pkt).hdr.php as int32_t;
            plr[dwID as usize]._pMaxHP = (*pkt).hdr.pmhp as int32_t;
            plr[dwID as usize]._pBaseStr = (*pkt).hdr.bstr as libc::c_int;
            plr[dwID as usize]._pBaseMag = (*pkt).hdr.bmag as libc::c_int;
            plr[dwID as usize]._pBaseDex = (*pkt).hdr.bdex as libc::c_int;
            if !(gbBufferMsgs as libc::c_int == BUFFER_ON as libc::c_int) {
                if !(plr[dwID as usize].plractive == 0) {
                    if !(plr[dwID as usize]._pHitPoints == 0 as libc::c_int) {
                        if currlevel as libc::c_int == plr[dwID as usize].plrlevel
                            && plr[dwID as usize]._pLvlChanging == 0
                        {
                            let mut dx: libc::c_int = abs(
                                plr[dwID as usize]._px - (*pkt).hdr.px as libc::c_int,
                            );
                            let mut dy: libc::c_int = abs(
                                plr[dwID as usize]._py - (*pkt).hdr.py as libc::c_int,
                            );
                            if (dx > 3 as libc::c_int || dy > 3 as libc::c_int)
                                && dPlayer[(*pkt).hdr.px as usize][(*pkt).hdr.py as usize]
                                    == 0
                            {
                                FixPlrWalkTags(dwID as libc::c_int);
                                plr[dwID as usize]._poldx = plr[dwID as usize]._px;
                                plr[dwID as usize]._poldy = plr[dwID as usize]._py;
                                FixPlrWalkTags(dwID as libc::c_int);
                                plr[dwID as usize]._px = (*pkt).hdr.px as libc::c_int;
                                plr[dwID as usize]._py = (*pkt).hdr.py as libc::c_int;
                                plr[dwID as usize]._pfutx = (*pkt).hdr.px as libc::c_int;
                                plr[dwID as usize]._pfuty = (*pkt).hdr.py as libc::c_int;
                                dPlayer[plr[dwID as usize]._px
                                    as usize][plr[dwID as usize]._py
                                    as usize] = (1 as libc::c_int
                                    + dwID as int8_t as libc::c_int) as int8_t;
                            }
                            dx = abs(plr[dwID as usize]._pfutx - plr[dwID as usize]._px);
                            dy = abs(plr[dwID as usize]._pfuty - plr[dwID as usize]._py);
                            if dx > 1 as libc::c_int || dy > 1 as libc::c_int {
                                plr[dwID as usize]._pfutx = plr[dwID as usize]._px;
                                plr[dwID as usize]._pfuty = plr[dwID as usize]._py;
                            }
                            MakePlrPath(
                                dwID as libc::c_int,
                                (*pkt).hdr.targx as libc::c_int,
                                (*pkt).hdr.targy as libc::c_int,
                                1 as libc::c_int as bool32_t,
                            );
                        } else {
                            plr[dwID as usize]._px = (*pkt).hdr.px as libc::c_int;
                            plr[dwID as usize]._py = (*pkt).hdr.py as libc::c_int;
                            plr[dwID as usize]._pfutx = (*pkt).hdr.px as libc::c_int;
                            plr[dwID as usize]._pfuty = (*pkt).hdr.py as libc::c_int;
                            plr[dwID as usize]._ptargx = (*pkt).hdr.targx as libc::c_int;
                            plr[dwID as usize]._ptargy = (*pkt).hdr.targy as libc::c_int;
                        }
                    }
                }
            }
        }
        process_msg_body(
            dwID,
            ((*pkt).body).as_ptr(),
            (dwMsgSize as libc::c_ulong)
                .wrapping_sub(::core::mem::size_of::<TPktHdr>() as libc::c_ulong)
                as uint32_t,
        );
        free(lpMsg);
    }
    if SErrGetLastError()
        != 0x80000000 as libc::c_uint
            | ((0x510 as libc::c_int) << 16 as libc::c_int) as libc::c_uint
            | (107 as libc::c_int & 0xffff as libc::c_int) as libc::c_uint
    {
        nthread_check_snet_error(
            b"SNetReceiveMsg\0" as *const u8 as *const libc::c_char,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn SendPlayerInfoChunk(
    mut pnum: libc::c_int,
    mut bCmd: uint8_t,
    mut pbSrc: *const uint8_t,
    mut dwLen: uint32_t,
) {
    if !(pnum != myplr) {
        assert_fail(
            713 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"pnum != myplr\0" as *const u8 as *const libc::c_char,
        );
    }
    if pbSrc.is_null() {
        assert_fail(
            716 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"pbSrc\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(dwLen <= 0xffff as libc::c_int as uint32_t) {
        assert_fail(
            717 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"dwLen <= 0x0ffff\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut dwOffset: uint32_t = 0 as libc::c_int as uint32_t;
    while dwLen != 0 {
        let mut pkt: TPkt = TPkt {
            hdr: TPktHdr {
                px: 0,
                py: 0,
                targx: 0,
                targy: 0,
                php: 0,
                pmhp: 0,
                bstr: 0,
                bmag: 0,
                bdex: 0,
                wCheck: 0,
                wLen: 0,
            },
            body: [0; 493],
        };
        pkt.hdr.wCheck = 0x6970 as libc::c_int as uint16_t;
        pkt.hdr.px = 0 as libc::c_int as uint8_t;
        pkt.hdr.py = 0 as libc::c_int as uint8_t;
        pkt.hdr.targx = 0 as libc::c_int as uint8_t;
        pkt.hdr.targy = 0 as libc::c_int as uint8_t;
        pkt.hdr.php = 0 as libc::c_int as uint32_t;
        pkt.hdr.pmhp = 0 as libc::c_int as uint32_t;
        pkt.hdr.bstr = 0 as libc::c_int as uint8_t;
        pkt.hdr.bmag = 0 as libc::c_int as uint8_t;
        pkt.hdr.bdex = 0 as libc::c_int as uint8_t;
        let mut p: *mut TCmdPlrInfoHdr = &mut *(pkt.body)
            .as_mut_ptr()
            .offset(0 as libc::c_int as isize) as *mut uint8_t as *mut TCmdPlrInfoHdr;
        (*p).bCmd = bCmd;
        (*p).wOffset = dwOffset as uint16_t;
        let mut dwBody: uint32_t = (gdwLargestMsgSize as libc::c_ulong)
            .wrapping_sub(::core::mem::size_of::<TPktHdr>() as libc::c_ulong)
            .wrapping_sub(::core::mem::size_of::<TCmdPlrInfoHdr>() as libc::c_ulong)
            as uint32_t;
        dwBody = if dwLen < dwBody { dwLen } else { dwBody };
        if !(dwBody <= 0xffff as libc::c_int as uint32_t) {
            assert_fail(
                741 as libc::c_int,
                b"src/multi.c\0" as *const u8 as *const libc::c_char,
                b"dwBody <= 0x0ffff\0" as *const u8 as *const libc::c_char,
            );
        }
        (*p).wBytes = dwBody as uint16_t;
        memcpy(
            &mut *(pkt.body)
                .as_mut_ptr()
                .offset(
                    ::core::mem::size_of::<TCmdPlrInfoHdr>() as libc::c_ulong as isize,
                ) as *mut uint8_t as *mut libc::c_void,
            pbSrc as *const libc::c_void,
            (*p).wBytes as libc::c_ulong,
        );
        let mut dwSendBytes: uint32_t = ::core::mem::size_of::<TPktHdr>()
            as libc::c_ulong as uint32_t;
        dwSendBytes = (dwSendBytes as libc::c_ulong)
            .wrapping_add(::core::mem::size_of::<TCmdPlrInfoHdr>() as libc::c_ulong)
            as uint32_t as uint32_t;
        dwSendBytes = dwSendBytes.wrapping_add((*p).wBytes as uint32_t);
        pkt.hdr.wLen = dwSendBytes as uint16_t;
        if SNetSendMessage(
            pnum as uint32_t,
            &mut pkt as *mut TPkt as *mut libc::c_void,
            dwSendBytes,
        ) == 0
        {
            nthread_check_snet_error(
                b"SNetSendMessage2\0" as *const u8 as *const libc::c_char,
            );
            break;
        } else {
            pbSrc = pbSrc.offset((*p).wBytes as libc::c_int as isize);
            dwLen = dwLen.wrapping_sub((*p).wBytes as uint32_t);
            dwOffset = dwOffset.wrapping_add((*p).wBytes as uint32_t);
        }
    }
}
unsafe extern "C" fn SendLocalPlayerInfo(mut pnum: libc::c_int, mut bCmd: uint8_t) {
    let mut pack: PkPlayerStruct = PkPlayerStruct {
        archiveTime: 0,
        destAction: 0,
        destParam1: 0,
        destParam2: 0,
        plrlevel: 0,
        px: 0,
        py: 0,
        targx: 0,
        targy: 0,
        pName: [0; 32],
        pClass: 0,
        pBaseStr: 0,
        pBaseMag: 0,
        pBaseDex: 0,
        pBaseVit: 0,
        pLevel: 0,
        pStatPts: 0,
        pExperience: 0,
        pGold: 0,
        pHPBase: 0,
        pMaxHPBase: 0,
        pManaBase: 0,
        pMaxManaBase: 0,
        pSplLvl: [0; 37],
        pMemSpells: 0,
        InvBody: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 7],
        InvList: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 40],
        InvGrid: [0; 40],
        _pNumInv: 0,
        SpdList: [PkItemStruct {
            iSeed: 0,
            iCreateInfo: 0,
            idx: 0,
            bId: 0,
            bDur: 0,
            bMDur: 0,
            bCh: 0,
            bMCh: 0,
            wValue: 0,
            dwBuff: 0,
        }; 8],
        pTownWarps: 0,
        pDungMsgs: 0,
        pLvlLoad: 0,
        pBattleNet: 0,
        pManaShield: 0,
        bReserved6: 0,
        bReserved7: 0,
        bReserved8: 0,
        wReserved1: 0,
        wReserved2: 0,
        wReserved3: 0,
        wReserved4: 0,
        wReserved5: 0,
        wReserved6: 0,
        wReserved7: 0,
        wReserved8: 0,
        pDiabloKillLevel: 0,
        dwReserved2: 0,
        dwReserved3: 0,
        dwReserved4: 0,
        dwReserved5: 0,
        dwReserved6: 0,
        dwReserved7: 0,
        dwReserved8: 0,
    };
    PackPlayer(&mut pack, myplr, 1 as libc::c_int as bool32_t);
    dthread_SendPlayerInfoChunk(
        pnum,
        bCmd,
        &mut pack as *mut PkPlayerStruct as *const uint8_t,
        ::core::mem::size_of::<PkPlayerStruct>() as libc::c_ulong as uint32_t,
    );
}
#[no_mangle]
pub unsafe extern "C" fn InitLevelType(mut l: libc::c_int) -> libc::c_int {
    if l == 0 as libc::c_int {
        return 0 as libc::c_int;
    }
    if l >= 1 as libc::c_int && l <= 4 as libc::c_int {
        return 1 as libc::c_int;
    }
    if l >= 5 as libc::c_int && l <= 8 as libc::c_int {
        return 2 as libc::c_int;
    }
    if l >= 9 as libc::c_int && l <= 12 as libc::c_int {
        return 3 as libc::c_int;
    }
    return 4 as libc::c_int;
}
unsafe extern "C" fn SetupLocalCoords() {
    currlevel = 0 as libc::c_int as uint8_t;
    leveltype = 0 as libc::c_int as uint8_t;
    setlevel = 0 as libc::c_int as uint8_t;
    let mut x: libc::c_int = STARTX as libc::c_int;
    let mut y: libc::c_int = STARTY as libc::c_int;
    if CHEATS as libc::c_int != 0 {
        if cheatflag != 0 || davedebug != 0 {
            x = 49 as libc::c_int;
            y = 23 as libc::c_int;
        }
    }
    x += plrxoff[myplr as usize];
    y += plryoff[myplr as usize];
    plr[myplr as usize]._px = x;
    plr[myplr as usize]._py = y;
    plr[myplr as usize]._pfutx = x;
    plr[myplr as usize]._pfuty = y;
    plr[myplr as usize]._ptargx = x;
    plr[myplr as usize]._ptargy = y;
    plr[myplr as usize].plrlevel = currlevel as libc::c_int;
    plr[myplr as usize]._pLvlChanging = 1 as libc::c_int as uint8_t;
    plr[myplr as usize].pLvlLoad = 0 as libc::c_int as uint8_t;
    plr[myplr as usize]._pmode = PM_NEWLVL as libc::c_int;
    plr[myplr as usize].destAction = PCMD_NOTHING as libc::c_int;
}
unsafe extern "C" fn net_callback(mut pEvt: *mut SNETEVENT) {
    let mut dwReason: uint32_t = 0;
    let mut pGameData: *mut TGAMEDATA = 0 as *mut TGAMEDATA;
    match (*pEvt).eventid {
        1 => {
            if ((*pEvt).data).is_null() {
                assert_fail(
                    840 as libc::c_int,
                    b"src/multi.c\0" as *const u8 as *const libc::c_char,
                    b"pEvt->data\0" as *const u8 as *const libc::c_char,
                );
            }
            if !((*pEvt).databytes as libc::c_ulong
                >= ::core::mem::size_of::<uint32_t>() as libc::c_ulong)
            {
                assert_fail(
                    841 as libc::c_int,
                    b"src/multi.c\0" as *const u8 as *const libc::c_char,
                    b"pEvt->databytes >= sizeof(uint32_t)\0" as *const u8
                        as *const libc::c_char,
                );
            }
            pGameData = (*pEvt).data as *mut TGAMEDATA;
            sgGameInitInfo.dwSeed = (*pGameData).dwSeed;
            sgGameInitInfo.bDiff = (*pGameData).bDiff;
            sgbGameJoiner[(*pEvt).playerid as usize] = 1 as libc::c_int as uint8_t;
        }
        3 => {
            if !((*pEvt).playerid >= 0 as libc::c_int as uint32_t
                && (*pEvt).playerid < MAX_PLRS as libc::c_int as uint32_t)
            {
                assert_fail(
                    854 as libc::c_int,
                    b"src/multi.c\0" as *const u8 as *const libc::c_char,
                    b"pEvt->playerid >= 0 && pEvt->playerid < MAX_PLRS\0" as *const u8
                        as *const libc::c_char,
                );
            }
            sgbPlayerLeftGameTbl[(*pEvt).playerid
                as usize] = 1 as libc::c_int as uint8_t;
            sgbGameJoiner[(*pEvt).playerid as usize] = 0 as libc::c_int as uint8_t;
            dwReason = 0 as libc::c_int as uint32_t;
            if !((*pEvt).data).is_null()
                && (*pEvt).databytes as libc::c_ulong
                    >= ::core::mem::size_of::<uint32_t>() as libc::c_ulong
            {
                dwReason = *((*pEvt).data as *mut uint32_t);
            }
            sgdwPlayerLeftReasonTbl[(*pEvt).playerid as usize] = dwReason;
            if dwReason == 0x40000004 as libc::c_int as uint32_t {
                gbSomebodyWonGameKludge = 1 as libc::c_int as uint8_t;
            }
            sgbSendDeltaTbl[(*pEvt).playerid as usize] = 0 as libc::c_int as uint8_t;
            dthread_remove_player((*pEvt).playerid as libc::c_int);
            if gbDeltaSender as uint32_t == (*pEvt).playerid {
                gbDeltaSender = MAX_PLRS as libc::c_int as uint8_t;
            }
        }
        4 => {
            if ((*pEvt).data).is_null() {
                assert_fail(
                    880 as libc::c_int,
                    b"src/multi.c\0" as *const u8 as *const libc::c_char,
                    b"pEvt->data\0" as *const u8 as *const libc::c_char,
                );
            }
            sysmsg_add_string((*pEvt).data as *const libc::c_char);
        }
        _ => {}
    };
}
unsafe extern "C" fn RegisterEventHandler(mut bRegister: bool32_t) {
    static mut sdwEventTbl: [uint32_t; 3] = [
        3 as libc::c_int as uint32_t,
        1 as libc::c_int as uint32_t,
        4 as libc::c_int as uint32_t,
    ];
    let mut fnReg: Option::<unsafe extern "C" fn(uint32_t, SNETEVENTPROC) -> bool32_t> = if bRegister
        != 0
    {
        Some(
            SNetRegisterEventHandler
                as unsafe extern "C" fn(uint32_t, SNETEVENTPROC) -> bool32_t,
        )
    } else {
        Some(
            SNetUnregisterEventHandler
                as unsafe extern "C" fn(uint32_t, SNETEVENTPROC) -> bool32_t,
        )
    };
    let mut i: libc::c_int = 0 as libc::c_int;
    while (i as libc::c_ulong)
        < (::core::mem::size_of::<[uint32_t; 3]>() as libc::c_ulong)
            .wrapping_div(::core::mem::size_of::<uint32_t>() as libc::c_ulong)
    {
        if fnReg
            .expect(
                "non-null function pointer",
            )(
            sdwEventTbl[i as usize],
            Some(net_callback as unsafe extern "C" fn(*mut SNETEVENT) -> ()),
        ) == 0 && bRegister != 0
        {
            app_fatal_(
                b"src/multi.c\0" as *const u8 as *const libc::c_char,
                897 as libc::c_int,
                b"error invoking SNetRegisterEventHandler\0" as *const u8
                    as *const libc::c_char,
            );
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn NetClose() {
    if sgbNetInited != 0 {
        sgbNetInited = 0 as libc::c_int as bool32_t;
        nthread_free();
        dthread_free();
        tmsg_free();
        RegisterEventHandler(0 as libc::c_int as bool32_t);
        SNetLeaveGame(0x3 as libc::c_int as uint32_t);
        if gbMaxPlayers as libc::c_int > 1 as libc::c_int {
            SDL_Delay(2000 as libc::c_int as Uint32);
        }
    }
}
unsafe extern "C" fn InitSingleGame() -> bool32_t {
    gbMaxPlayers = 1 as libc::c_int as uint8_t;
    if UiSelectHero() == 0 {
        return 0 as libc::c_int as bool32_t;
    }
    let mut dwID: uint32_t = 0 as libc::c_int as uint32_t;
    if SNetCreateGame(
        b"local\0" as *const u8 as *const libc::c_char,
        b"local\0" as *const u8 as *const libc::c_char,
        b"local\0" as *const u8 as *const libc::c_char,
        0 as libc::c_int as uint32_t,
        &mut sgGameInitInfo as *mut TGAMEDATA as *mut libc::c_void,
        ::core::mem::size_of::<TGAMEDATA>() as libc::c_ulong as uint32_t,
        1 as libc::c_int as uint32_t,
        b"local\0" as *const u8 as *const libc::c_char,
        b"local\0" as *const u8 as *const libc::c_char,
        &mut dwID,
    ) == 0
    {
        app_fatal_(
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            941 as libc::c_int,
            b"SNetCreateGame error\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(dwID == 0 as libc::c_int as uint32_t) {
        assert_fail(
            943 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"dwID == 0\0" as *const u8 as *const libc::c_char,
        );
    }
    myplr = 0 as libc::c_int;
    gbMaxPlayers = 1 as libc::c_int as uint8_t;
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn InitMultiGame() -> bool32_t {
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn NetInit(mut bSinglePlayer: bool32_t) -> bool32_t {
    SetRndSeed(
        b"src/multi.c\0" as *const u8 as *const libc::c_char,
        1012 as libc::c_int,
        0 as libc::c_int,
    );
    if set_game_seed != 0 as libc::c_int {
        sgGameInitInfo.dwSeed = set_game_seed as uint32_t;
    } else {
        sgGameInitInfo.dwSeed = time(0 as *mut time_t) as uint32_t;
    }
    sgGameInitInfo.bDiff = gnDifficulty as uint8_t;
    memset(
        sgbGameJoiner.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 4]>() as libc::c_ulong,
    );
    gbGameDestroyed = 0 as libc::c_int as uint8_t;
    memset(
        sgbPlayerLeftGameTbl.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 4]>() as libc::c_ulong,
    );
    memset(
        sgdwPlayerLeftReasonTbl.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint32_t; 4]>() as libc::c_ulong,
    );
    memset(
        sgbSendDeltaTbl.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 4]>() as libc::c_ulong,
    );
    memset(
        plr.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        (::core::mem::size_of::<PlayerStruct>() as libc::c_ulong)
            .wrapping_mul(MAX_PLRS as libc::c_int as libc::c_ulong),
    );
    memset(
        sgwPackPlrOffsetTbl.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint16_t; 4]>() as libc::c_ulong,
    );
    if bSinglePlayer != 0 {
        if InitSingleGame() == 0 {
            return 0 as libc::c_int as bool32_t;
        }
    } else if InitMultiGame() == 0 {
        return 0 as libc::c_int as bool32_t
    }
    sgbNetInited = 1 as libc::c_int as bool32_t;
    sgbTimeout = 0 as libc::c_int as uint8_t;
    delta_init();
    plrmsg_init();
    buffer_init(&mut sgHiPriBuf);
    buffer_init(&mut sgLoPriBuf);
    sgbSentThisCycle = 0 as libc::c_int as bool32_t;
    sync_init();
    nthread_init(sgbGameJoiner[myplr as usize] as bool32_t);
    dthread_init();
    tmsg_init();
    sgdwGameLoops = 0 as libc::c_int as uint32_t;
    sgdwSyncMsgs = 0 as libc::c_int as uint32_t;
    gbDeltaSender = myplr as uint8_t;
    gbSomebodyWonGameKludge = 0 as libc::c_int as uint8_t;
    nthread_fill_sync_queue(0 as libc::c_int as uint32_t, 0 as libc::c_int as uint32_t);
    SetupLocalCoords();
    SendLocalPlayerInfo(
        0xfffffffe as libc::c_uint as libc::c_int,
        CMD_SEND_PLRINFO as libc::c_int as uint8_t,
    );
    plr[myplr as usize].plractive = 1 as libc::c_int as uint8_t;
    gbActivePlayers = 1 as libc::c_int as uint8_t;
    if sgbGameJoiner[myplr as usize] as libc::c_int != 0 && wait_delta_info() == 0 {
        NetClose();
        return 0 as libc::c_int as bool32_t;
    }
    gnDifficulty = sgGameInitInfo.bDiff as libc::c_int;
    _logf(
        b"d1.GameInitInfo.Seed: 0x%08X\0" as *const u8 as *const libc::c_char,
        sgGameInitInfo.dwSeed,
    );
    SetRndSeed(
        b"src/multi.c\0" as *const u8 as *const libc::c_char,
        1094 as libc::c_int,
        sgGameInitInfo.dwSeed as int32_t,
    );
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < NUMLEVELS as libc::c_int {
        glSeedTbl[i
            as usize] = GetRndSeed(
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            1096 as libc::c_int,
        ) as uint32_t;
        gnLevelTypeTbl[i as usize] = InitLevelType(i);
        i += 1;
        i;
    }
    _logf(b"d1.SeedFromDLvl\0" as *const u8 as *const libc::c_char);
    let mut dlvl: libc::c_int = 0 as libc::c_int;
    while dlvl < NUMLEVELS as libc::c_int {
        _logf(
            b"   dlvl=%d, seed=0x%08X\0" as *const u8 as *const libc::c_char,
            dlvl,
            glSeedTbl[dlvl as usize],
        );
        dlvl += 1;
        dlvl;
    }
    let mut dwTemp: uint32_t = 0;
    if SNetGetGameInfo(
        1 as libc::c_int as uint32_t,
        gszGameName.as_mut_ptr() as *mut libc::c_void,
        128 as libc::c_int as uint32_t,
        &mut dwTemp,
    ) == 0
    {
        nthread_check_snet_error(
            b"SNetGetGameInfo1\0" as *const u8 as *const libc::c_char,
        );
    }
    if SNetGetGameInfo(
        2 as libc::c_int as uint32_t,
        gszGamePass.as_mut_ptr() as *mut libc::c_void,
        128 as libc::c_int as uint32_t,
        &mut dwTemp,
    ) == 0
    {
        nthread_check_snet_error(
            b"SNetGetGameInfo2\0" as *const u8 as *const libc::c_char,
        );
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn recv_plrinfo(
    mut pnum: libc::c_int,
    mut p: *const TCmdPlrInfoHdr,
    mut bAck: bool32_t,
) {
    if myplr == pnum {
        return;
    }
    if !((pnum as uint32_t) < MAX_PLRS as libc::c_int as uint32_t) {
        assert_fail(
            1123 as libc::c_int,
            b"src/multi.c\0" as *const u8 as *const libc::c_char,
            b"(uint32_t)pnum < MAX_PLRS\0" as *const u8 as *const libc::c_char,
        );
    }
    if sgwPackPlrOffsetTbl[pnum as usize] as libc::c_int != (*p).wOffset as libc::c_int {
        sgwPackPlrOffsetTbl[pnum as usize] = 0 as libc::c_int as uint16_t;
        if (*p).wOffset as libc::c_int != 0 as libc::c_int {
            return;
        }
    }
    if bAck == 0 && sgwPackPlrOffsetTbl[pnum as usize] == 0 {
        SendLocalPlayerInfo(pnum, CMD_ACK_PLRINFO as libc::c_int as uint8_t);
    }
    memcpy(
        (&mut *sgPackPlr.as_mut_ptr().offset(pnum as isize) as *mut PkPlayerStruct
            as *mut uint8_t)
            .offset((*p).wOffset as libc::c_int as isize) as *mut libc::c_void,
        (p as *mut uint8_t)
            .offset(::core::mem::size_of::<TCmdPlrInfoHdr>() as libc::c_ulong as isize)
            as *const libc::c_void,
        (*p).wBytes as libc::c_ulong,
    );
    sgwPackPlrOffsetTbl[pnum
        as usize] = (sgwPackPlrOffsetTbl[pnum as usize] as libc::c_int
        + (*p).wBytes as libc::c_int) as uint16_t;
    if sgwPackPlrOffsetTbl[pnum as usize] as libc::c_ulong
        != ::core::mem::size_of::<PkPlayerStruct>() as libc::c_ulong
    {
        return;
    }
    sgwPackPlrOffsetTbl[pnum as usize] = 0 as libc::c_int as uint16_t;
    remove_active_player(pnum, 0 as libc::c_int as bool32_t);
    plr[pnum as usize]._pGFXLoad = 0 as libc::c_int;
    UnPackPlayer(
        &mut *sgPackPlr.as_mut_ptr().offset(pnum as isize),
        pnum,
        1 as libc::c_int as bool32_t,
    );
    if bAck != 0 {
        plr[pnum as usize].plractive = 1 as libc::c_int as uint8_t;
        gbActivePlayers = gbActivePlayers.wrapping_add(1);
        gbActivePlayers;
        sysmsg_add(
            if sgbGameJoiner[pnum as usize] as libc::c_int != 0 {
                b"Player '%s' (level %d) just joined the game\0" as *const u8
                    as *const libc::c_char
            } else {
                b"Player '%s' (level %d) is already in the game\0" as *const u8
                    as *const libc::c_char
            },
            (plr[pnum as usize]._pName).as_mut_ptr(),
            plr[pnum as usize]._pLevel as libc::c_int,
        );
        LoadPlrGFX(pnum, PGL_STAND as libc::c_int as uint32_t);
        SyncInitPlr(pnum);
        if plr[pnum as usize].plrlevel == currlevel as libc::c_int {
            if plr[pnum as usize]._pHitPoints >> HP_SHIFT as libc::c_int
                > 0 as libc::c_int
            {
                StartStand(pnum, 0 as libc::c_int);
            } else {
                plr[pnum as usize]._pgfxnum = PGFX_NGUY as libc::c_int;
                LoadPlrGFX(pnum, PGL_DEAD as libc::c_int as uint32_t);
                plr[pnum as usize]._pmode = PM_DEATH as libc::c_int;
                NewPlrAnim(
                    pnum,
                    plr[pnum as usize]._pDAnim[DIR_D as libc::c_int as usize],
                    plr[pnum as usize]._pDFrames,
                    1 as libc::c_int,
                    plr[pnum as usize]._pDWidth,
                );
                plr[pnum as usize]
                    ._pAnimFrame = plr[pnum as usize]._pAnimLen - 1 as libc::c_int;
                plr[pnum as usize]
                    ._pVar8 = plr[pnum as usize]._pAnimLen << 1 as libc::c_int;
                dFlags[plr[pnum as usize]._px
                    as usize][plr[pnum as usize]._py
                    as usize] = (dFlags[plr[pnum as usize]._px
                    as usize][plr[pnum as usize]._py as usize] as libc::c_int
                    | BFLAG_DEADPLR as libc::c_int) as int8_t;
            }
        }
    }
}
