use ::libc;
extern "C" {
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn StartGame(bNewGame: bool32_t, bSinglePlayer: bool32_t) -> bool32_t;
    fn play_movie(pszMovie: *const libc::c_char, bAllowCancel: bool32_t);
    fn BlackPalette();
    fn pfile_create_player_description() -> bool32_t;
    fn UiSelHeroMultDialog(
        selection: *mut uint32_t,
        dst_heroname: *mut libc::c_char,
    ) -> bool32_t;
    fn UiInitialize();
    fn UiTitleDialog(timeoutseconds: uint32_t) -> bool32_t;
    fn UiCreditsDialog(pixelspersec: uint32_t) -> bool32_t;
    fn UiMainMenuDialog(
        version_str: *const libc::c_char,
        selection: *mut uint32_t,
        attracttimeoutseconds: uint32_t,
    ) -> bool32_t;
    fn UiSelHeroSingDialog(
        selection: *mut uint32_t,
        dst_heroname: *mut libc::c_char,
        difficulty: *mut libc::c_int,
    ) -> bool32_t;
    fn music_start(nTrack: libc::c_int);
    fn music_stop();
    static mut cineflag: bool32_t;
    static mut gbLoadGame: bool32_t;
    static mut gnDifficulty: libc::c_int;
    static mut bActive: bool32_t;
    static mut gszPrintVersion: [libc::c_char; 260];
    static mut gszHero: [libc::c_char; 16];
    static mut gbMaxPlayers: uint8_t;
}
pub type C2RustUnnamed = libc::c_uint;
pub const DEFAULT_ATTRACT_TIMEOUT: C2RustUnnamed = 30;
pub const PIXELS_PER_SEC: C2RustUnnamed = 16;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const MUSIC_LAST: C2RustUnnamed_0 = 5;
pub const MUSIC_INTRO: C2RustUnnamed_0 = 5;
pub const MUSIC_L4: C2RustUnnamed_0 = 4;
pub const MUSIC_L3: C2RustUnnamed_0 = 3;
pub const MUSIC_L2: C2RustUnnamed_0 = 2;
pub const MUSIC_L1: C2RustUnnamed_0 = 1;
pub const MUSIC_TOWN: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_int;
pub const NUM_MUSIC: C2RustUnnamed_1 = 6;
pub const VOLUME_TICKS: C2RustUnnamed_1 = 17;
pub const VOLUME_STEP: C2RustUnnamed_1 = 100;
pub const VOLUME_MAX: C2RustUnnamed_1 = 0;
pub const VOLUME_MIN: C2RustUnnamed_1 = -1600;
pub const VOLUME_READ: C2RustUnnamed_1 = 1;
pub const DDA_BUF_SIZE: C2RustUnnamed_1 = 262144;
pub type __uint8_t = libc::c_uchar;
pub type __uint32_t = libc::c_uint;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
pub type _mainmenu_selections = libc::c_uint;
pub const MAINMENU_ATTRACT_MODE: _mainmenu_selections = 6;
pub const MAINMENU_EXIT_DIABLO: _mainmenu_selections = 5;
pub const MAINMENU_SHOW_CREDITS: _mainmenu_selections = 4;
pub const MAINMENU_REPLAY_INTRO: _mainmenu_selections = 3;
pub const MAINMENU_MULTIPLAYER: _mainmenu_selections = 2;
pub const MAINMENU_SINGLE_PLAYER: _mainmenu_selections = 1;
pub type _selhero_selections = libc::c_uint;
pub const SELHERO_PREVIOUS: _selhero_selections = 4;
pub const SELHERO_CONNECT: _selhero_selections = 3;
pub const SELHERO_CONTINUE: _selhero_selections = 2;
pub const SELHERO_NEW_DUNGEON: _selhero_selections = 1;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_2 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_2 = 92160;
pub const BTMBUFFY: C2RustUnnamed_2 = 144;
pub const BTMBUFFX: C2RustUnnamed_2 = 640;
pub const BUFFERSIZE: C2RustUnnamed_2 = 503808;
pub const BUFFERY: C2RustUnnamed_2 = 656;
pub const BUFFERX: C2RustUnnamed_2 = 768;
pub const GAMEY: C2RustUnnamed_2 = 352;
pub const CTRLPANY: C2RustUnnamed_2 = 128;
pub const TOTALY: C2RustUnnamed_2 = 480;
pub const TOTALX: C2RustUnnamed_2 = 640;
pub const MAX_PLRS: C2RustUnnamed_2 = 4;
#[no_mangle]
pub unsafe extern "C" fn menu_music() {
    static mut snMusic: libc::c_int = MUSIC_INTRO as libc::c_int;
    music_start(snMusic);
    loop {
        snMusic += 1;
        snMusic;
        if snMusic == NUM_MUSIC as libc::c_int {
            snMusic = 0 as libc::c_int;
        }
        if !(snMusic == MUSIC_TOWN as libc::c_int || snMusic == MUSIC_L1 as libc::c_int)
        {
            break;
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn UiSelectHero() -> bool32_t {
    let mut selection: uint32_t = 0 as libc::c_int as uint32_t;
    if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
        if UiSelHeroSingDialog(&mut selection, gszHero.as_mut_ptr(), &mut gnDifficulty)
            == 0
        {
            app_fatal_(
                b"src/mainmenu.c\0" as *const u8 as *const libc::c_char,
                39 as libc::c_int,
                b"unable to select single player hero\0" as *const u8
                    as *const libc::c_char,
            );
        }
        if selection == SELHERO_CONTINUE as libc::c_int as uint32_t {
            gbLoadGame = 1 as libc::c_int as bool32_t;
        } else {
            gbLoadGame = 0 as libc::c_int as bool32_t;
        }
    } else if UiSelHeroMultDialog(&mut selection, gszHero.as_mut_ptr()) == 0 {
        app_fatal_(
            b"src/mainmenu.c\0" as *const u8 as *const libc::c_char,
            49 as libc::c_int,
            b"unable to select multi player hero\0" as *const u8 as *const libc::c_char,
        );
    }
    if selection == SELHERO_PREVIOUS as libc::c_int as uint32_t {
        return 0 as libc::c_int as bool32_t;
    }
    pfile_create_player_description();
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn do_menu(mut selection: uint32_t) -> bool32_t {
    if selection == SELHERO_PREVIOUS as libc::c_int as uint32_t {
        return 1 as libc::c_int as bool32_t;
    }
    music_stop();
    let mut bResult: bool32_t = StartGame(
        (selection != SELHERO_CONTINUE as libc::c_int as uint32_t) as libc::c_int
            as bool32_t,
        (selection != SELHERO_CONNECT as libc::c_int as uint32_t) as libc::c_int
            as bool32_t,
    );
    if bResult != 0 {
        UiInitialize();
        menu_music();
    }
    return bResult;
}
unsafe extern "C" fn DoSinglePlayer() -> bool32_t {
    gbMaxPlayers = 1 as libc::c_int as uint8_t;
    return do_menu(SELHERO_NEW_DUNGEON as libc::c_int as uint32_t);
}
unsafe extern "C" fn DoMultiPlayer() -> bool32_t {
    gbMaxPlayers = MAX_PLRS as libc::c_int as uint8_t;
    return do_menu(SELHERO_CONNECT as libc::c_int as uint32_t);
}
unsafe extern "C" fn play_intro() {
    music_stop();
    play_movie(
        b"gendata\\diablo1.smk\0" as *const u8 as *const libc::c_char,
        1 as libc::c_int as bool32_t,
    );
    menu_music();
}
#[no_mangle]
pub unsafe extern "C" fn DiabloMenu() {
    menu_music();
    if cineflag != 0 {
        UiTitleDialog(7 as libc::c_int as uint32_t);
        BlackPalette();
    }
    let mut bDone: bool32_t = 0 as libc::c_int as bool32_t;
    while bDone == 0 {
        let mut selection: uint32_t = 0 as libc::c_int as uint32_t;
        if UiMainMenuDialog(
            gszPrintVersion.as_mut_ptr(),
            &mut selection,
            DEFAULT_ATTRACT_TIMEOUT as libc::c_int as uint32_t,
        ) == 0
        {
            app_fatal_(
                b"src/mainmenu.c\0" as *const u8 as *const libc::c_char,
                118 as libc::c_int,
                b"Unable to display mainmenu\0" as *const u8 as *const libc::c_char,
            );
        }
        match selection {
            1 => {
                if DoSinglePlayer() == 0 {
                    bDone = 1 as libc::c_int as bool32_t;
                }
            }
            2 => {
                if DoMultiPlayer() == 0 {
                    bDone = 1 as libc::c_int as bool32_t;
                }
            }
            6 | 3 => {
                if !(bActive == 0) {
                    play_intro();
                }
            }
            4 => {
                UiCreditsDialog(PIXELS_PER_SEC as libc::c_int as uint32_t);
            }
            5 => {
                bDone = 1 as libc::c_int as bool32_t;
            }
            _ => {}
        }
    }
    music_stop();
}
