use ::libc;
extern "C" {
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn SyncAutomap();
    fn SetCursor_(i: libc::c_int);
    fn FreeGameMem();
    fn LoadGameLevel(_: bool32_t, _: libc::c_int);
    fn GetRndSeed(file: *const libc::c_char, line: libc::c_int) -> int32_t;
    fn DiabloAllocPtr(dwBytes: uint32_t) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn append_missile(x: libc::c_int, y: libc::c_int, missile_num: libc::c_int);
    fn SyncItemAnim(_: libc::c_int);
    fn ProcessLightList();
    fn ProcessVisionList();
    fn SyncMissAnim();
    fn SyncMonsterAnim(_: libc::c_int);
    fn SyncObjectAnim(_: libc::c_int);
    fn UpdatePlayerFile();
    fn ReadSaveFile(pszName: *const libc::c_char, pdwLen: *mut uint32_t) -> *mut uint8_t;
    fn CreateLoadLevelName(szName: *mut libc::c_char);
    fn CreateSaveLevelName(szName: *mut libc::c_char);
    fn CreateSaveGameName(szName: *mut libc::c_char);
    fn WriteSaveFile(
        pszName: *const libc::c_char,
        pbData: *mut uint8_t,
        dwLen: uint32_t,
        dwDstBytes: uint32_t,
    );
    fn SyncInitPlr(_: libc::c_int);
    fn SyncPlrAnim(p: libc::c_int);
    fn RedoPlayerVision();
    fn SyncPortals();
    fn ResyncQuests();
    static mut automapflag: bool32_t;
    static mut automapscale: libc::c_int;
    static mut automapview: [[uint8_t; 40]; 40];
    static mut chrflag: bool32_t;
    static mut gbProcessPlayers: bool32_t;
    static mut glSeedTbl: [uint32_t; 17];
    static mut gnLevelTypeTbl: [libc::c_int; 17];
    static mut doomtime: libc::c_int;
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut setlevel: uint8_t;
    static mut setlvlnum: uint8_t;
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut dLight: [[int8_t; 112]; 112];
    static mut dSaveLight: [[int8_t; 112]; 112];
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dPlayer: [[int8_t; 112]; 112];
    static mut dMonster: [[libc::c_int; 112]; 112];
    static mut dDead: [[int8_t; 112]; 112];
    static mut dObject: [[int8_t; 112]; 112];
    static mut dItem: [[int8_t; 112]; 112];
    static mut dMissile: [[*mut MissileNode; 112]; 112];
    static mut invflag: bool32_t;
    static mut item: [ItemStruct; 128];
    static mut numitems: int32_t;
    static mut itemactive: [libc::c_int; 127];
    static mut itemavail: [libc::c_int; 127];
    static mut UniqueItemFlag: [bool32_t; 128];
    static mut LightList: [LightListStruct; 32];
    static mut lightactive: [uint8_t; 32];
    static mut numlights: libc::c_int;
    static mut dolighting: bool32_t;
    static mut VisionList: [LightListStruct; 32];
    static mut numvision: libc::c_int;
    static mut visionid: libc::c_int;
    static mut missile: [MissileStruct; 125];
    static mut nummissiles: libc::c_int;
    static mut missileactive: [libc::c_int; 125];
    static mut missileavail: [libc::c_int; 125];
    static mut monster: [MonsterStruct; 200];
    static mut nummonsters: int32_t;
    static mut monstactive: [libc::c_int; 200];
    static mut monstkills: [libc::c_int; 200];
    static mut gbMaxPlayers: uint8_t;
    static mut object: [ObjectStruct; 127];
    static mut numobjects: int32_t;
    static mut objectactive: [libc::c_int; 127];
    static mut objectavail: [libc::c_int; 127];
    static mut gbValidSaveFile: bool32_t;
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut portal: [PortalStruct; 4];
    static mut quests: [QuestStruct; 16];
    static mut ReturnLvlX: libc::c_int;
    static mut ReturnLvlY: libc::c_int;
    static mut ReturnLvl: libc::c_int;
    static mut ReturnLvlT: libc::c_int;
    static mut premiumitem: [ItemStruct; 6];
    static mut numpremium: libc::c_int;
    static mut premiumlevel: libc::c_int;
    static mut towner: [TownerStruct; 16];
    static mut numtowners: libc::c_int;
    static mut cowoffx: [libc::c_int; 8];
    static mut cowoffy: [libc::c_int; 8];
}
pub type C2RustUnnamed = libc::c_uint;
pub const G_BRIGHT_LIGHTS: C2RustUnnamed = 0;
pub const USE_GOURAUD: C2RustUnnamed = 0;
pub const ORIG_LIGHTING: C2RustUnnamed = 1;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const BFLAG_SAVEMASK: C2RustUnnamed_0 = 248;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const FILEBUFF: C2RustUnnamed_1 = 262147;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const RETAIL_ID: C2RustUnnamed_2 = 1380275276;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const VIEW_CURSOR: C2RustUnnamed_3 = 1;
pub const ICSTART: C2RustUnnamed_3 = 12;
pub const WATCH_CURS: C2RustUnnamed_3 = 11;
pub const HEALOTHER_CURS: C2RustUnnamed_3 = 10;
pub const TARGET_CURS: C2RustUnnamed_3 = 9;
pub const RESURRECT_CURS: C2RustUnnamed_3 = 8;
pub const TELE_CURS: C2RustUnnamed_3 = 7;
pub const OIL_CURS: C2RustUnnamed_3 = 6;
pub const DISARM_CURS: C2RustUnnamed_3 = 5;
pub const RECHARGE_CURS: C2RustUnnamed_3 = 4;
pub const REPAIR_CURS: C2RustUnnamed_3 = 3;
pub const IDENTIFY_CURS: C2RustUnnamed_3 = 2;
pub const GLOVE_CURS: C2RustUnnamed_3 = 1;
pub const NO_CURSOR: C2RustUnnamed_3 = 0;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const TWN_COW: C2RustUnnamed_4 = 9;
pub const TWN_BOY: C2RustUnnamed_4 = 8;
pub const TWN_BARMAID: C2RustUnnamed_4 = 7;
pub const TWN_WITCH: C2RustUnnamed_4 = 6;
pub const TWN_DRUNK: C2RustUnnamed_4 = 5;
pub const TWN_TELLER: C2RustUnnamed_4 = 4;
pub const TWN_BAROWNER: C2RustUnnamed_4 = 3;
pub const TWN_DEAD: C2RustUnnamed_4 = 2;
pub const TWN_HEALER: C2RustUnnamed_4 = 1;
pub const TWN_BLKSMITH: C2RustUnnamed_4 = 0;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const LVL_TWARPUP: C2RustUnnamed_5 = 7;
pub const LVL_TWARPDN: C2RustUnnamed_5 = 6;
pub const LVL_WARP: C2RustUnnamed_5 = 5;
pub const LVL_NODIR: C2RustUnnamed_5 = 4;
pub const LVL_RTN: C2RustUnnamed_5 = 3;
pub const LVL_SET: C2RustUnnamed_5 = 2;
pub const LVL_UP: C2RustUnnamed_5 = 1;
pub const LVL_DOWN: C2RustUnnamed_5 = 0;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type uintptr_t = libc::c_ulong;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
pub type C2RustUnnamed_6 = libc::c_uint;
pub const INITMONSTRAD: C2RustUnnamed_6 = 15;
pub const MAX_MS: C2RustUnnamed_6 = 4;
pub const IMG_MAX: C2RustUnnamed_6 = 4000;
pub const MAX_ANIMTYPE: C2RustUnnamed_6 = 6;
pub const MONSTDENSITY: C2RustUnnamed_6 = 30;
pub const MAX_LVLMTYPES: C2RustUnnamed_6 = 16;
pub const MONSTERTYPES: C2RustUnnamed_6 = 200;
pub const MAXMONSTERS: C2RustUnnamed_6 = 200;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterStruct {
    pub _mMTidx: libc::c_int,
    pub _mmode: libc::c_int,
    pub _mgoal: uint8_t,
    pub _mgoalvar1: libc::c_int,
    pub _mgoalvar2: libc::c_int,
    pub _mgoalvar3: libc::c_int,
    pub _mgoalvar4: libc::c_int,
    pub _pathcount: uint8_t,
    pub _mx: libc::c_int,
    pub _my: libc::c_int,
    pub _mfutx: libc::c_int,
    pub _mfuty: libc::c_int,
    pub _moldx: libc::c_int,
    pub _moldy: libc::c_int,
    pub _mxoff: int32_t,
    pub _myoff: int32_t,
    pub _mxvel: int32_t,
    pub _myvel: int32_t,
    pub _mdir: libc::c_int,
    pub _menemy: libc::c_int,
    pub _menemyx: uint8_t,
    pub _menemyy: uint8_t,
    pub _mAnimData: *mut uint8_t,
    pub _mAnimDelay: libc::c_int,
    pub _mAnimCnt: libc::c_int,
    pub _mAnimLen: libc::c_int,
    pub _mAnimFrame: libc::c_int,
    pub _meflag: libc::c_int,
    pub _mDelFlag: bool32_t,
    pub _mVar1: int32_t,
    pub _mVar2: int32_t,
    pub _mVar3: int32_t,
    pub _mVar4: int32_t,
    pub _mVar5: int32_t,
    pub _mVar6: int32_t,
    pub _mVar7: int32_t,
    pub _mVar8: int32_t,
    pub _mmaxhp: int32_t,
    pub _mhitpoints: int32_t,
    pub _mAi: uint8_t,
    pub _mint: uint8_t,
    pub _mFlags: uint32_t,
    pub _msquelch: uint8_t,
    pub _mAFNum: libc::c_int,
    pub _lastx: libc::c_int,
    pub _lasty: libc::c_int,
    pub _mRndSeed: libc::c_int,
    pub _mAISeed: libc::c_int,
    pub _Wandering: bool32_t,
    pub _uniqtype: uint8_t,
    pub _uniqtrans: uint8_t,
    pub _udeadval: int8_t,
    pub mWhoHit: int8_t,
    pub mLevel: int8_t,
    pub mExp: uint16_t,
    pub mHit: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMagicRes: uint16_t,
    pub mtalkmsg: libc::c_int,
    pub leader: uint8_t,
    pub leaderflag: uint8_t,
    pub packsize: uint8_t,
    pub mlid: uint8_t,
    pub mName: *const libc::c_char,
    pub MType: *mut CMonster,
    pub MData: *mut MonsterData,
}
pub type C2RustUnnamed_7 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_7 = 32;
pub const MAXMICRO: C2RustUnnamed_7 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_7 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_7 = 64;
pub const MAXMREND: C2RustUnnamed_7 = 128;
pub const MAXTILES: C2RustUnnamed_7 = 2048;
pub const MDMAXY: C2RustUnnamed_7 = 40;
pub const MDMAXX: C2RustUnnamed_7 = 40;
pub const MAXDUNY: C2RustUnnamed_7 = 112;
pub const MAXDUNX: C2RustUnnamed_7 = 112;
pub const DMAXY: C2RustUnnamed_7 = 112;
pub const DMAXX: C2RustUnnamed_7 = 112;
pub const DIRTEDGED2: C2RustUnnamed_7 = 16;
pub const DIRTEDGE: C2RustUnnamed_7 = 32;
pub const NUMSLEVELS: C2RustUnnamed_7 = 10;
pub const NUMLEVELS: C2RustUnnamed_7 = 17;
pub const LVL4_START: C2RustUnnamed_7 = 13;
pub const LVL3_START: C2RustUnnamed_7 = 9;
pub const LVL2_START: C2RustUnnamed_7 = 5;
pub const LVL1_START: C2RustUnnamed_7 = 1;
pub const TLVL_START: C2RustUnnamed_7 = 0;
pub const LVLLENGTH: C2RustUnnamed_7 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
pub type C2RustUnnamed_8 = libc::c_uint;
pub const AUTOMAPY: C2RustUnnamed_8 = 40;
pub const AUTOMAPX: C2RustUnnamed_8 = 40;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MissileNode {
    pub missile_num: int8_t,
    pub next: *mut MissileNode,
}
pub type C2RustUnnamed_9 = libc::c_int;
pub const ITEMFTYPES: C2RustUnnamed_9 = 35;
pub const RESIST_MAX: C2RustUnnamed_9 = 75;
pub const GOLD_VMAX: C2RustUnnamed_9 = 5000;
pub const GOLD_VT2: C2RustUnnamed_9 = 2500;
pub const GOLD_VT1: C2RustUnnamed_9 = 1000;
pub const INFINITE_DUR: C2RustUnnamed_9 = 255;
pub const ITEM_RND: C2RustUnnamed_9 = -1;
pub const TEMPAVAIL: C2RustUnnamed_9 = 127;
pub const MAXUITEMS: C2RustUnnamed_9 = 128;
pub const MAXITEMS: C2RustUnnamed_9 = 127;
pub type C2RustUnnamed_10 = libc::c_uint;
pub const PLRVRAD: C2RustUnnamed_10 = 10;
pub const PLRLRAD: C2RustUnnamed_10 = 10;
pub const MAXTRANS: C2RustUnnamed_10 = 32;
pub const MAXVISION: C2RustUnnamed_10 = 32;
pub const MAXLIGHTS: C2RustUnnamed_10 = 32;
pub const LIGHTSIZE: C2RustUnnamed_10 = 6912;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct LightListStruct {
    pub _lx: libc::c_int,
    pub _ly: libc::c_int,
    pub _lradius: libc::c_int,
    pub _lid: libc::c_int,
    pub _ldel: bool32_t,
    pub _lunflag: bool32_t,
    pub _lneg: bool32_t,
    pub _lunx: libc::c_int,
    pub _luny: libc::c_int,
    pub _lunr: libc::c_int,
    pub _xoff: libc::c_int,
    pub _yoff: libc::c_int,
    pub _lflags: bool32_t,
}
pub type C2RustUnnamed_11 = libc::c_uint;
pub const MAXMISSILES: C2RustUnnamed_11 = 125;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MissileStruct {
    pub _mitype: libc::c_int,
    pub _mix: libc::c_int,
    pub _miy: libc::c_int,
    pub _mixoff: int32_t,
    pub _miyoff: int32_t,
    pub _mixvel: int32_t,
    pub _miyvel: int32_t,
    pub _misx: libc::c_int,
    pub _misy: libc::c_int,
    pub _mitxoff: int32_t,
    pub _mityoff: int32_t,
    pub _mimfnum: libc::c_int,
    pub _mispllvl: libc::c_int,
    pub _miDelFlag: bool32_t,
    pub _miAnimType: uint8_t,
    pub _miAnimFlags: bool32_t,
    pub _miAnimData: *mut uint8_t,
    pub _miAnimDelay: libc::c_int,
    pub _miAnimLen: libc::c_int,
    pub _miAnimWidth: int32_t,
    pub _miAnimWidth2: int32_t,
    pub _miAnimCnt: libc::c_int,
    pub _miAnimAdd: libc::c_int,
    pub _miAnimFrame: libc::c_int,
    pub _miDrawFlag: bool32_t,
    pub _miLightFlag: bool32_t,
    pub _miPreFlag: bool32_t,
    pub _miUniqTrans: bool32_t,
    pub _mirange: libc::c_int,
    pub _misource: libc::c_int,
    pub _micaster: libc::c_int,
    pub _midam: libc::c_int,
    pub _miHitFlag: bool32_t,
    pub _midist: libc::c_int,
    pub _mlid: libc::c_int,
    pub _mirnd: libc::c_int,
    pub _miVar1: int32_t,
    pub _miVar2: int32_t,
    pub _miVar3: int32_t,
    pub _miVar4: int32_t,
    pub _miVar5: int32_t,
    pub _miVar6: int32_t,
    pub _miVar7: int32_t,
    pub _miVar8: int32_t,
}
pub type C2RustUnnamed_12 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_12 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_12 = 92160;
pub const BTMBUFFY: C2RustUnnamed_12 = 144;
pub const BTMBUFFX: C2RustUnnamed_12 = 640;
pub const BUFFERSIZE: C2RustUnnamed_12 = 503808;
pub const BUFFERY: C2RustUnnamed_12 = 656;
pub const BUFFERX: C2RustUnnamed_12 = 768;
pub const GAMEY: C2RustUnnamed_12 = 352;
pub const CTRLPANY: C2RustUnnamed_12 = 128;
pub const TOTALY: C2RustUnnamed_12 = 480;
pub const TOTALX: C2RustUnnamed_12 = 640;
pub const MAX_PLRS: C2RustUnnamed_12 = 4;
pub type C2RustUnnamed_13 = libc::c_uint;
pub const TOTAL_FOUNTAINS: C2RustUnnamed_13 = 4;
pub const MAXLVLOBJS: C2RustUnnamed_13 = 40;
pub const MAXOBJECTS: C2RustUnnamed_13 = 127;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ObjectStruct {
    pub _otype: libc::c_int,
    pub _ox: libc::c_int,
    pub _oy: libc::c_int,
    pub _oLight: bool32_t,
    pub _oAnimFlag: bool32_t,
    pub _oAnimData: *mut uint8_t,
    pub _oAnimDelay: libc::c_int,
    pub _oAnimCnt: libc::c_int,
    pub _oAnimLen: libc::c_int,
    pub _oAnimFrame: libc::c_int,
    pub _oAnimWidth: int32_t,
    pub _oAnimWidth2: int32_t,
    pub _oDelFlag: bool32_t,
    pub _oBreak: int8_t,
    pub _oSolidFlag: bool32_t,
    pub _oMissFlag: bool32_t,
    pub _oSelFlag: int8_t,
    pub _oPreFlag: bool32_t,
    pub _oTrapFlag: bool32_t,
    pub _oDoorFlag: bool32_t,
    pub _olid: libc::c_int,
    pub _oRndSeed: libc::c_int,
    pub _oVar1: int32_t,
    pub _oVar2: int32_t,
    pub _oVar3: int32_t,
    pub _oVar4: int32_t,
    pub _oVar5: int32_t,
    pub _oVar6: int32_t,
    pub _oVar7: int32_t,
    pub _oVar8: int32_t,
}
pub type C2RustUnnamed_14 = libc::c_uint;
pub const MAXPORTAL: C2RustUnnamed_14 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PortalStruct {
    pub open: bool32_t,
    pub x: libc::c_int,
    pub y: libc::c_int,
    pub level: libc::c_int,
    pub ltype: libc::c_int,
    pub setlvl: bool32_t,
}
pub type C2RustUnnamed_15 = libc::c_uint;
pub const QUEST_OFFSETS: C2RustUnnamed_15 = 7;
pub const MAXMULTIQUESTS: C2RustUnnamed_15 = 4;
pub const MAXQUESTS: C2RustUnnamed_15 = 16;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct QuestStruct {
    pub _qlevel: uint8_t,
    pub _qtype: uint8_t,
    pub _qactive: uint8_t,
    pub _qlvltype: uint8_t,
    pub _qtx: libc::c_int,
    pub _qty: libc::c_int,
    pub _qslvl: uint8_t,
    pub _qidx: uint8_t,
    pub _qmsg: uint8_t,
    pub _qvar1: uint8_t,
    pub _qvar2: uint8_t,
    pub align_0011: [uint8_t; 3],
    pub _qlog: bool32_t,
}
pub type C2RustUnnamed_16 = libc::c_uint;
pub const STOREIDCOST: C2RustUnnamed_16 = 100;
pub const MAXHOLDITEMS: C2RustUnnamed_16 = 48;
pub const NUMSTLINES: C2RustUnnamed_16 = 24;
pub const MAXPREMIUM: C2RustUnnamed_16 = 6;
pub const MAXHEALITEMS: C2RustUnnamed_16 = 20;
pub const MAXWITCHITEMS: C2RustUnnamed_16 = 20;
pub const MAXSMITHITEMS: C2RustUnnamed_16 = 20;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TNQ {
    pub _qsttype: uint8_t,
    pub _qstmsg: uint8_t,
    pub _qstmsgact: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TownerStruct {
    pub _tmode: libc::c_int,
    pub _ttype: libc::c_int,
    pub _tx: libc::c_int,
    pub _ty: libc::c_int,
    pub _txoff: int32_t,
    pub _tyoff: int32_t,
    pub _txvel: int32_t,
    pub _tyvel: int32_t,
    pub _tdir: libc::c_int,
    pub _tAnimData: *mut uint8_t,
    pub _tAnimDelay: libc::c_int,
    pub _tAnimCnt: libc::c_int,
    pub _tAnimLen: libc::c_int,
    pub _tAnimFrame: libc::c_int,
    pub _tAnimFrameCnt: libc::c_int,
    pub _tAnimOrder: int8_t,
    pub _tAnimWidth: int32_t,
    pub _tAnimWidth2: int32_t,
    pub _tTenPer: libc::c_int,
    pub _teflag: libc::c_int,
    pub _tbtcnt: libc::c_int,
    pub _tSelFlag: bool32_t,
    pub _tMsgSaid: bool32_t,
    pub qsts: [TNQ; 16],
    pub _tSeed: libc::c_int,
    pub _tVar1: int32_t,
    pub _tVar2: int32_t,
    pub _tVar3: int32_t,
    pub _tVar4: int32_t,
    pub _tName: [libc::c_char; 32],
    pub _tNAnim: [*mut uint8_t; 8],
    pub _tNFrames: libc::c_int,
    pub _tNData: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GameState {
    pub buf: *mut uint8_t,
    pub len: libc::c_int,
}
static mut tbuff: *mut uint8_t = 0 as *const uint8_t as *mut uint8_t;
unsafe extern "C" fn BLoad() -> uint8_t {
    let fresh0 = tbuff;
    tbuff = tbuff.offset(1);
    return *fresh0;
}
unsafe extern "C" fn ILoad() -> libc::c_int {
    let mut rv: libc::c_int = 0;
    let fresh1 = tbuff;
    tbuff = tbuff.offset(1);
    rv = (*fresh1 as libc::c_int) << 24 as libc::c_int;
    let fresh2 = tbuff;
    tbuff = tbuff.offset(1);
    rv |= (*fresh2 as libc::c_int) << 16 as libc::c_int;
    let fresh3 = tbuff;
    tbuff = tbuff.offset(1);
    rv |= (*fresh3 as libc::c_int) << 8 as libc::c_int;
    let fresh4 = tbuff;
    tbuff = tbuff.offset(1);
    rv |= *fresh4 as libc::c_int;
    return rv;
}
unsafe extern "C" fn LLoad() -> int32_t {
    let mut rv: int32_t = 0;
    let fresh5 = tbuff;
    tbuff = tbuff.offset(1);
    rv = (*fresh5 as libc::c_int) << 24 as libc::c_int;
    let fresh6 = tbuff;
    tbuff = tbuff.offset(1);
    rv |= (*fresh6 as libc::c_int) << 16 as libc::c_int;
    let fresh7 = tbuff;
    tbuff = tbuff.offset(1);
    rv |= (*fresh7 as libc::c_int) << 8 as libc::c_int;
    let fresh8 = tbuff;
    tbuff = tbuff.offset(1);
    rv |= *fresh8 as libc::c_int;
    return rv;
}
unsafe extern "C" fn OLoad() -> bool32_t {
    let fresh9 = tbuff;
    tbuff = tbuff.offset(1);
    if *fresh9 as libc::c_int == 1 as libc::c_int {
        return 1 as libc::c_int as bool32_t
    } else {
        return 0 as libc::c_int as bool32_t
    };
}
unsafe extern "C" fn LoadPlr(mut i: libc::c_int) {
    memcpy(
        &mut *plr.as_mut_ptr().offset(i as isize) as *mut PlayerStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        (::core::mem::size_of::<PlayerStruct>() as libc::c_ulong)
            .wrapping_sub(
                (9 as libc::c_int as libc::c_ulong)
                    .wrapping_mul(::core::mem::size_of::<uintptr_t>() as libc::c_ulong),
            ),
    );
    tbuff = tbuff
        .offset(
            (::core::mem::size_of::<PlayerStruct>() as libc::c_ulong)
                .wrapping_sub(
                    (9 as libc::c_int as libc::c_ulong)
                        .wrapping_mul(
                            ::core::mem::size_of::<uintptr_t>() as libc::c_ulong,
                        ),
                ) as isize,
        );
}
unsafe extern "C" fn LoadMonst(mut i: libc::c_int) {
    memcpy(
        &mut *monster.as_mut_ptr().offset(i as isize) as *mut MonsterStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        (::core::mem::size_of::<MonsterStruct>() as libc::c_ulong)
            .wrapping_sub(
                (3 as libc::c_int as libc::c_ulong)
                    .wrapping_mul(::core::mem::size_of::<uintptr_t>() as libc::c_ulong),
            ),
    );
    tbuff = tbuff
        .offset(
            (::core::mem::size_of::<MonsterStruct>() as libc::c_ulong)
                .wrapping_sub(
                    (3 as libc::c_int as libc::c_ulong)
                        .wrapping_mul(
                            ::core::mem::size_of::<uintptr_t>() as libc::c_ulong,
                        ),
                ) as isize,
        );
    SyncMonsterAnim(i);
}
unsafe extern "C" fn LoadMissile(mut i: libc::c_int) {
    memcpy(
        &mut *missile.as_mut_ptr().offset(i as isize) as *mut MissileStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        ::core::mem::size_of::<MissileStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<MissileStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn LoadObject(mut i: libc::c_int) {
    memcpy(
        &mut *object.as_mut_ptr().offset(i as isize) as *mut ObjectStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        ::core::mem::size_of::<ObjectStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<ObjectStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn LoadItem(mut i: libc::c_int) {
    memcpy(
        &mut *item.as_mut_ptr().offset(i as isize) as *mut ItemStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        ::core::mem::size_of::<ItemStruct>() as libc::c_ulong,
    );
    tbuff = tbuff.offset(::core::mem::size_of::<ItemStruct>() as libc::c_ulong as isize);
    SyncItemAnim(i);
}
unsafe extern "C" fn LoadPremium(mut i: libc::c_int) {
    memcpy(
        &mut *premiumitem.as_mut_ptr().offset(i as isize) as *mut ItemStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        ::core::mem::size_of::<ItemStruct>() as libc::c_ulong,
    );
    tbuff = tbuff.offset(::core::mem::size_of::<ItemStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn LoadQuest(mut i: libc::c_int) {
    memcpy(
        &mut *quests.as_mut_ptr().offset(i as isize) as *mut QuestStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        ::core::mem::size_of::<QuestStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<QuestStruct>() as libc::c_ulong as isize);
    ReturnLvlX = ILoad();
    ReturnLvlY = ILoad();
    ReturnLvl = ILoad();
    ReturnLvlT = ILoad();
    doomtime = ILoad();
}
unsafe extern "C" fn LoadLight(mut i: libc::c_int) {
    memcpy(
        &mut *LightList.as_mut_ptr().offset(i as isize) as *mut LightListStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        ::core::mem::size_of::<LightListStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<LightListStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn LoadVision(mut i: libc::c_int) {
    memcpy(
        &mut *VisionList.as_mut_ptr().offset(i as isize) as *mut LightListStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        ::core::mem::size_of::<LightListStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<LightListStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn LoadPortal(mut i: libc::c_int) {
    memcpy(
        &mut *portal.as_mut_ptr().offset(i as isize) as *mut PortalStruct
            as *mut libc::c_void,
        tbuff as *const libc::c_void,
        ::core::mem::size_of::<PortalStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<PortalStruct>() as libc::c_ulong as isize);
}
#[no_mangle]
pub unsafe extern "C" fn GM_LoadGame(mut firstflag: bool32_t) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut hvx: libc::c_int = 0;
    let mut hvy: libc::c_int = 0;
    let mut hnummonsters: libc::c_int = 0;
    let mut hnumitems: libc::c_int = 0;
    let mut hnummissiles: libc::c_int = 0;
    let mut hnumobjects: libc::c_int = 0;
    if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
        assert_fail(
            152 as libc::c_int,
            b"src/loadsave.c\0" as *const u8 as *const libc::c_char,
            b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
        );
    }
    FreeGameMem();
    let mut dwLen: uint32_t = 0;
    let mut szName: [libc::c_char; 260] = [0; 260];
    CreateSaveGameName(szName.as_mut_ptr());
    let mut LoadBuff: *mut uint8_t = ReadSaveFile(szName.as_mut_ptr(), &mut dwLen);
    tbuff = LoadBuff;
    let mut dwVersion: uint32_t = LLoad() as uint32_t;
    if dwVersion != RETAIL_ID as libc::c_int as uint32_t {
        app_fatal_(
            b"src/loadsave.c\0" as *const u8 as *const libc::c_char,
            163 as libc::c_int,
            b"Invalid save file\0" as *const u8 as *const libc::c_char,
        );
    }
    setlevel = OLoad() as uint8_t;
    setlvlnum = ILoad() as uint8_t;
    currlevel = ILoad() as uint8_t;
    leveltype = ILoad() as uint8_t;
    hvx = ILoad();
    hvy = ILoad();
    invflag = OLoad();
    chrflag = OLoad();
    hnummonsters = ILoad();
    hnumitems = ILoad();
    hnummissiles = ILoad();
    hnumobjects = ILoad();
    i = 0 as libc::c_int;
    while i < NUMLEVELS as libc::c_int {
        glSeedTbl[i as usize] = LLoad() as uint32_t;
        gnLevelTypeTbl[i as usize] = ILoad();
        i += 1;
        i;
    }
    LoadPlr(myplr);
    i = 0 as libc::c_int;
    while i < MAXQUESTS as libc::c_int {
        LoadQuest(i);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXPORTAL as libc::c_int {
        LoadPortal(i);
        i += 1;
        i;
    }
    LoadGameLevel(firstflag, LVL_NODIR as libc::c_int);
    SyncInitPlr(myplr);
    SyncPlrAnim(myplr);
    ViewX = hvx;
    ViewY = hvy;
    nummonsters = hnummonsters;
    numitems = hnumitems;
    nummissiles = hnummissiles;
    numobjects = hnumobjects;
    i = 0 as libc::c_int;
    while i < MONSTERTYPES as libc::c_int {
        monstkills[i as usize] = LLoad();
        i += 1;
        i;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXMONSTERS as libc::c_int {
            monstactive[i as usize] = ILoad();
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < nummonsters {
            LoadMonst(monstactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXMISSILES as libc::c_int {
            missileactive[i as usize] = BLoad() as libc::c_int;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXMISSILES as libc::c_int {
            missileavail[i as usize] = BLoad() as libc::c_int;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < nummissiles {
            LoadMissile(missileactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXOBJECTS as libc::c_int {
            objectactive[i as usize] = BLoad() as libc::c_int;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXOBJECTS as libc::c_int {
            objectavail[i as usize] = BLoad() as libc::c_int;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numobjects {
            LoadObject(objectactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numobjects {
            SyncObjectAnim(objectactive[i as usize]);
            i += 1;
            i;
        }
        numlights = ILoad();
        i = 0 as libc::c_int;
        while i < MAXLIGHTS as libc::c_int {
            lightactive[i as usize] = BLoad();
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numlights {
            LoadLight(lightactive[i as usize] as libc::c_int);
            i += 1;
            i;
        }
        visionid = ILoad();
        numvision = ILoad();
        i = 0 as libc::c_int;
        while i < numvision {
            LoadVision(i);
            i += 1;
            i;
        }
    }
    i = 0 as libc::c_int;
    while i < MAXITEMS as libc::c_int {
        itemactive[i as usize] = BLoad() as libc::c_int;
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXITEMS as libc::c_int {
        itemavail[i as usize] = BLoad() as libc::c_int;
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < numitems {
        LoadItem(itemactive[i as usize]);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXUITEMS as libc::c_int {
        UniqueItemFlag[i as usize] = OLoad();
        i += 1;
        i;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            dLight[i as usize][j as usize] = BLoad() as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            dFlags[i as usize][j as usize] = BLoad() as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            dPlayer[i as usize][j as usize] = BLoad() as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            dItem[i as usize][j as usize] = BLoad() as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dMonster[i as usize][j as usize] = ILoad();
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dDead[i as usize][j as usize] = BLoad() as int8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dObject[i as usize][j as usize] = BLoad() as int8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dLight[i as usize][j as usize] = BLoad() as int8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dSaveLight[i as usize][j as usize] = BLoad() as int8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < AUTOMAPY as libc::c_int {
            i = 0 as libc::c_int;
            while i < AUTOMAPX as libc::c_int {
                automapview[i as usize][j as usize] = OLoad() as uint8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BLoad();
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    }
    if leveltype as libc::c_int == 0 as libc::c_int {
        addTownersToMap();
    } else {
        addMonstersToMap();
    }
    addMissilesToMap();
    numpremium = ILoad();
    premiumlevel = ILoad();
    i = 0 as libc::c_int;
    while i < MAXPREMIUM as libc::c_int {
        LoadPremium(i);
        i += 1;
        i;
    }
    automapflag = OLoad();
    automapscale = ILoad();
    let mut p__p: *mut libc::c_void = LoadBuff as *mut libc::c_void;
    LoadBuff = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    SyncAutomap();
    ResyncQuests();
    if leveltype != 0 {
        ProcessLightList();
    }
    RedoPlayerVision();
    ProcessVisionList();
    SyncMissAnim();
    SetCursor_(GLOVE_CURS as libc::c_int);
    gbProcessPlayers = 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn BSave(mut v: uint8_t) {
    let fresh10 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh10 = v;
}
unsafe extern "C" fn ISave(mut v: libc::c_int) {
    let fresh11 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh11 = (v >> 24 as libc::c_int) as uint8_t;
    let fresh12 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh12 = (v >> 16 as libc::c_int) as uint8_t;
    let fresh13 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh13 = (v >> 8 as libc::c_int) as uint8_t;
    let fresh14 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh14 = (v >> 0 as libc::c_int) as uint8_t;
}
unsafe extern "C" fn LSave(mut v: int32_t) {
    let fresh15 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh15 = (v >> 24 as libc::c_int) as uint8_t;
    let fresh16 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh16 = (v >> 16 as libc::c_int) as uint8_t;
    let fresh17 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh17 = (v >> 8 as libc::c_int) as uint8_t;
    let fresh18 = tbuff;
    tbuff = tbuff.offset(1);
    *fresh18 = (v >> 0 as libc::c_int) as uint8_t;
}
unsafe extern "C" fn OSave(mut v: bool32_t) {
    if v != 0 {
        let fresh19 = tbuff;
        tbuff = tbuff.offset(1);
        *fresh19 = 1 as libc::c_int as uint8_t;
    } else {
        let fresh20 = tbuff;
        tbuff = tbuff.offset(1);
        *fresh20 = 0 as libc::c_int as uint8_t;
    };
}
unsafe extern "C" fn SavePlr(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *plr.as_mut_ptr().offset(i as isize) as *mut PlayerStruct
            as *const libc::c_void,
        (::core::mem::size_of::<PlayerStruct>() as libc::c_ulong)
            .wrapping_sub(
                (9 as libc::c_int as libc::c_ulong)
                    .wrapping_mul(::core::mem::size_of::<uintptr_t>() as libc::c_ulong),
            ),
    );
    tbuff = tbuff
        .offset(
            (::core::mem::size_of::<PlayerStruct>() as libc::c_ulong)
                .wrapping_sub(
                    (9 as libc::c_int as libc::c_ulong)
                        .wrapping_mul(
                            ::core::mem::size_of::<uintptr_t>() as libc::c_ulong,
                        ),
                ) as isize,
        );
}
unsafe extern "C" fn SaveMonst(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *monster.as_mut_ptr().offset(i as isize) as *mut MonsterStruct
            as *const libc::c_void,
        (::core::mem::size_of::<MonsterStruct>() as libc::c_ulong)
            .wrapping_sub(
                (3 as libc::c_int as libc::c_ulong)
                    .wrapping_mul(::core::mem::size_of::<uintptr_t>() as libc::c_ulong),
            ),
    );
    tbuff = tbuff
        .offset(
            (::core::mem::size_of::<MonsterStruct>() as libc::c_ulong)
                .wrapping_sub(
                    (3 as libc::c_int as libc::c_ulong)
                        .wrapping_mul(
                            ::core::mem::size_of::<uintptr_t>() as libc::c_ulong,
                        ),
                ) as isize,
        );
}
unsafe extern "C" fn SaveMissile(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *missile.as_mut_ptr().offset(i as isize) as *mut MissileStruct
            as *const libc::c_void,
        ::core::mem::size_of::<MissileStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<MissileStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn SaveObject(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *object.as_mut_ptr().offset(i as isize) as *mut ObjectStruct
            as *const libc::c_void,
        ::core::mem::size_of::<ObjectStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<ObjectStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn SaveItem(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *item.as_mut_ptr().offset(i as isize) as *mut ItemStruct
            as *const libc::c_void,
        ::core::mem::size_of::<ItemStruct>() as libc::c_ulong,
    );
    tbuff = tbuff.offset(::core::mem::size_of::<ItemStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn SavePremium(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *premiumitem.as_mut_ptr().offset(i as isize) as *mut ItemStruct
            as *const libc::c_void,
        ::core::mem::size_of::<ItemStruct>() as libc::c_ulong,
    );
    tbuff = tbuff.offset(::core::mem::size_of::<ItemStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn SaveQuest(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *quests.as_mut_ptr().offset(i as isize) as *mut QuestStruct
            as *const libc::c_void,
        ::core::mem::size_of::<QuestStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<QuestStruct>() as libc::c_ulong as isize);
    ISave(ReturnLvlX);
    ISave(ReturnLvlY);
    ISave(ReturnLvl);
    ISave(ReturnLvlT);
    ISave(doomtime);
}
unsafe extern "C" fn SaveLight(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *LightList.as_mut_ptr().offset(i as isize) as *mut LightListStruct
            as *const libc::c_void,
        ::core::mem::size_of::<LightListStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<LightListStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn SaveVision(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *VisionList.as_mut_ptr().offset(i as isize) as *mut LightListStruct
            as *const libc::c_void,
        ::core::mem::size_of::<LightListStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<LightListStruct>() as libc::c_ulong as isize);
}
unsafe extern "C" fn SavePortal(mut i: libc::c_int) {
    memcpy(
        tbuff as *mut libc::c_void,
        &mut *portal.as_mut_ptr().offset(i as isize) as *mut PortalStruct
            as *const libc::c_void,
        ::core::mem::size_of::<PortalStruct>() as libc::c_ulong,
    );
    tbuff = tbuff
        .offset(::core::mem::size_of::<PortalStruct>() as libc::c_ulong as isize);
}
#[no_mangle]
pub unsafe extern "C" fn GetGameState() -> GameState {
    let mut SaveBuff: *mut uint8_t = 0 as *mut uint8_t;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
        assert_fail(
            453 as libc::c_int,
            b"src/loadsave.c\0" as *const u8 as *const libc::c_char,
            b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
        );
    }
    SaveBuff = DiabloAllocPtr(FILEBUFF as libc::c_int as uint32_t);
    tbuff = SaveBuff;
    LSave(RETAIL_ID as libc::c_int);
    OSave(setlevel as bool32_t);
    ISave(setlvlnum as libc::c_int);
    ISave(currlevel as libc::c_int);
    ISave(leveltype as libc::c_int);
    ISave(ViewX);
    ISave(ViewY);
    OSave(invflag);
    OSave(chrflag);
    ISave(nummonsters);
    ISave(numitems);
    ISave(nummissiles);
    ISave(numobjects);
    i = 0 as libc::c_int;
    while i < NUMLEVELS as libc::c_int {
        LSave(glSeedTbl[i as usize] as int32_t);
        ISave(gnLevelTypeTbl[i as usize]);
        i += 1;
        i;
    }
    SavePlr(myplr);
    i = 0 as libc::c_int;
    while i < MAXQUESTS as libc::c_int {
        SaveQuest(i);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXPORTAL as libc::c_int {
        SavePortal(i);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MONSTERTYPES as libc::c_int {
        LSave(monstkills[i as usize]);
        i += 1;
        i;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXMONSTERS as libc::c_int {
            ISave(monstactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < nummonsters {
            SaveMonst(monstactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXMISSILES as libc::c_int {
            BSave(missileactive[i as usize] as uint8_t);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXMISSILES as libc::c_int {
            BSave(missileavail[i as usize] as uint8_t);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < nummissiles {
            SaveMissile(missileactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXOBJECTS as libc::c_int {
            BSave(objectactive[i as usize] as uint8_t);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXOBJECTS as libc::c_int {
            BSave(objectavail[i as usize] as uint8_t);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numobjects {
            SaveObject(objectactive[i as usize]);
            i += 1;
            i;
        }
        ISave(numlights);
        i = 0 as libc::c_int;
        while i < MAXLIGHTS as libc::c_int {
            BSave(lightactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numlights {
            SaveLight(lightactive[i as usize] as libc::c_int);
            i += 1;
            i;
        }
        ISave(visionid);
        ISave(numvision);
        i = 0 as libc::c_int;
        while i < numvision {
            SaveVision(i);
            i += 1;
            i;
        }
    }
    i = 0 as libc::c_int;
    while i < MAXITEMS as libc::c_int {
        BSave(itemactive[i as usize] as uint8_t);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXITEMS as libc::c_int {
        BSave(itemavail[i as usize] as uint8_t);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < numitems {
        SaveItem(itemactive[i as usize]);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXUITEMS as libc::c_int {
        OSave(UniqueItemFlag[i as usize]);
        i += 1;
        i;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            BSave(dLight[i as usize][j as usize] as uint8_t);
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            BSave(
                (dFlags[i as usize][j as usize] as libc::c_int
                    & BFLAG_SAVEMASK as libc::c_int) as uint8_t,
            );
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            BSave(dPlayer[i as usize][j as usize] as uint8_t);
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            BSave(dItem[i as usize][j as usize] as uint8_t);
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                ISave(dMonster[i as usize][j as usize]);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(dDead[i as usize][j as usize] as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(dObject[i as usize][j as usize] as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(dLight[i as usize][j as usize] as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(dSaveLight[i as usize][j as usize] as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < AUTOMAPY as libc::c_int {
            i = 0 as libc::c_int;
            while i < AUTOMAPX as libc::c_int {
                OSave(automapview[i as usize][j as usize] as bool32_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(0 as libc::c_int as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    }
    ISave(numpremium);
    ISave(premiumlevel);
    i = 0 as libc::c_int;
    while i < MAXPREMIUM as libc::c_int {
        SavePremium(i);
        i += 1;
        i;
    }
    OSave(automapflag);
    ISave(automapscale);
    let mut game_state: GameState = {
        let mut init = GameState {
            buf: 0 as *mut uint8_t,
            len: 0,
        };
        init
    };
    game_state.buf = SaveBuff;
    game_state.len = tbuff.offset_from(SaveBuff) as libc::c_long as libc::c_int;
    return game_state;
}
#[no_mangle]
pub unsafe extern "C" fn GM_SaveGame() {
    let mut game_state: GameState = GetGameState();
    let mut szName: [libc::c_char; 260] = [0; 260];
    CreateSaveGameName(szName.as_mut_ptr());
    WriteSaveFile(
        szName.as_mut_ptr(),
        game_state.buf,
        game_state.len as uint32_t,
        game_state.len as uint32_t,
    );
    let mut p__p: *mut libc::c_void = game_state.buf as *mut libc::c_void;
    game_state.buf = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    gbValidSaveFile = 1 as libc::c_int as bool32_t;
    UpdatePlayerFile();
}
#[no_mangle]
pub unsafe extern "C" fn SaveLevel() {
    let mut SaveBuff: *mut uint8_t = 0 as *mut uint8_t;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
        assert_fail(
            651 as libc::c_int,
            b"src/loadsave.c\0" as *const u8 as *const libc::c_char,
            b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
        );
    }
    if currlevel as libc::c_int == 0 as libc::c_int {
        glSeedTbl[0 as libc::c_int
            as usize] = GetRndSeed(
            b"src/loadsave.c\0" as *const u8 as *const libc::c_char,
            653 as libc::c_int,
        ) as uint32_t;
    }
    SaveBuff = DiabloAllocPtr(FILEBUFF as libc::c_int as uint32_t);
    tbuff = SaveBuff;
    if leveltype as libc::c_int != 0 as libc::c_int {
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(dDead[i as usize][j as usize] as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    }
    ISave(nummonsters);
    ISave(numitems);
    ISave(numobjects);
    if leveltype as libc::c_int != 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXMONSTERS as libc::c_int {
            ISave(monstactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < nummonsters {
            SaveMonst(monstactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXOBJECTS as libc::c_int {
            BSave(objectactive[i as usize] as uint8_t);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXOBJECTS as libc::c_int {
            BSave(objectavail[i as usize] as uint8_t);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numobjects {
            let mut _object: *mut ObjectStruct = &mut *object
                .as_mut_ptr()
                .offset(*objectactive.as_mut_ptr().offset(i as isize) as isize)
                as *mut ObjectStruct;
            (*_object)._olid = -(1 as libc::c_int);
            SaveObject(objectactive[i as usize]);
            i += 1;
            i;
        }
    }
    i = 0 as libc::c_int;
    while i < MAXITEMS as libc::c_int {
        BSave(itemactive[i as usize] as uint8_t);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXITEMS as libc::c_int {
        BSave(itemavail[i as usize] as uint8_t);
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < numitems {
        SaveItem(itemactive[i as usize]);
        i += 1;
        i;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            BSave(
                (dFlags[i as usize][j as usize] as libc::c_int
                    & BFLAG_SAVEMASK as libc::c_int) as uint8_t,
            );
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            BSave(dItem[i as usize][j as usize] as uint8_t);
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                ISave(dMonster[i as usize][j as usize]);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(dObject[i as usize][j as usize] as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(dLight[i as usize][j as usize] as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(dSaveLight[i as usize][j as usize] as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < AUTOMAPY as libc::c_int {
            i = 0 as libc::c_int;
            while i < AUTOMAPX as libc::c_int {
                OSave(automapview[i as usize][j as usize] as bool32_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                BSave(0 as libc::c_int as uint8_t);
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    }
    if !(FILEBUFF as libc::c_int as libc::c_long
        >= tbuff.offset_from(SaveBuff) as libc::c_long)
    {
        assert_fail(
            753 as libc::c_int,
            b"src/loadsave.c\0" as *const u8 as *const libc::c_char,
            b"FILEBUFF >= tbuff - SaveBuff\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut szName: [libc::c_char; 260] = [0; 260];
    CreateSaveLevelName(szName.as_mut_ptr());
    WriteSaveFile(
        szName.as_mut_ptr(),
        SaveBuff,
        tbuff.offset_from(SaveBuff) as libc::c_long as uint32_t,
        tbuff.offset_from(SaveBuff) as libc::c_long as uint32_t,
    );
    let mut p__p: *mut libc::c_void = SaveBuff as *mut libc::c_void;
    SaveBuff = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    if setlevel == 0 {
        plr[myplr as usize]
            ._pLvlVisited[currlevel as usize] = 1 as libc::c_int as uint8_t;
    } else {
        plr[myplr as usize]
            ._pSLvlVisited[setlvlnum as usize] = 1 as libc::c_int as uint8_t;
    };
}
#[no_mangle]
pub unsafe extern "C" fn LoadLevel() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut LoadSize: uint32_t = 0;
    let mut szName: [libc::c_char; 260] = [0; 260];
    CreateLoadLevelName(szName.as_mut_ptr());
    let mut LoadBuff: *mut uint8_t = ReadSaveFile(szName.as_mut_ptr(), &mut LoadSize);
    tbuff = LoadBuff;
    if leveltype as libc::c_int != 0 as libc::c_int {
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dDead[i as usize][j as usize] = BLoad() as int8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    }
    nummonsters = ILoad();
    numitems = ILoad();
    numobjects = ILoad();
    if leveltype as libc::c_int != 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXMONSTERS as libc::c_int {
            monstactive[i as usize] = ILoad();
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < nummonsters {
            LoadMonst(monstactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXOBJECTS as libc::c_int {
            objectactive[i as usize] = BLoad() as libc::c_int;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < MAXOBJECTS as libc::c_int {
            objectavail[i as usize] = BLoad() as libc::c_int;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numobjects {
            let mut _object: *mut ObjectStruct = &mut *object
                .as_mut_ptr()
                .offset(*objectactive.as_mut_ptr().offset(i as isize) as isize)
                as *mut ObjectStruct;
            (*_object)._olid = -(1 as libc::c_int);
            LoadObject(objectactive[i as usize]);
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numobjects {
            SyncObjectAnim(objectactive[i as usize]);
            i += 1;
            i;
        }
    }
    i = 0 as libc::c_int;
    while i < MAXITEMS as libc::c_int {
        itemactive[i as usize] = BLoad() as libc::c_int;
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < MAXITEMS as libc::c_int {
        itemavail[i as usize] = BLoad() as libc::c_int;
        i += 1;
        i;
    }
    i = 0 as libc::c_int;
    while i < numitems {
        LoadItem(itemactive[i as usize]);
        i += 1;
        i;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            dFlags[i as usize][j as usize] = BLoad() as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            dItem[i as usize][j as usize] = BLoad() as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dMonster[i as usize][j as usize] = ILoad();
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dObject[i as usize][j as usize] = BLoad() as int8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dLight[i as usize][j as usize] = BLoad() as int8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < MAXDUNY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MAXDUNX as libc::c_int {
                dSaveLight[i as usize][j as usize] = BLoad() as int8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < AUTOMAPY as libc::c_int {
            i = 0 as libc::c_int;
            while i < AUTOMAPX as libc::c_int {
                automapview[i as usize][j as usize] = OLoad() as uint8_t;
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    }
    if leveltype as libc::c_int == 0 as libc::c_int {
        addTownersToMap();
    } else {
        addMonstersToMap();
    }
    addMissilesToMap();
    SyncAutomap();
    ResyncQuests();
    SyncPortals();
    if ORIG_LIGHTING as libc::c_int != 0 {
        dolighting = 1 as libc::c_int as bool32_t;
    }
    i = 0 as libc::c_int;
    while i < MAX_PLRS as libc::c_int {
        if plr[i as usize].plractive as libc::c_int != 0
            && currlevel as libc::c_int == plr[i as usize].plrlevel
        {
            if !(plr[i as usize]._plid == -(1 as libc::c_int)) {
                LightList[plr[i as usize]._plid as usize]
                    ._lunflag = 1 as libc::c_int as bool32_t;
            }
        }
        i += 1;
        i;
    }
    let mut p__p: *mut libc::c_void = LoadBuff as *mut libc::c_void;
    LoadBuff = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
}
#[no_mangle]
pub unsafe extern "C" fn addMonstersToMap() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            dMonster[i as usize][j as usize] = 0 as libc::c_int;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    i = 0 as libc::c_int;
    while i < nummonsters {
        let mut mi: libc::c_int = monstactive[i as usize];
        let mut _monster: *mut MonsterStruct = &mut *monster
            .as_mut_ptr()
            .offset(mi as isize) as *mut MonsterStruct;
        dMonster[(*_monster)._mx
            as usize][(*_monster)._my as usize] = mi + 1 as libc::c_int;
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn addTownersToMap() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < MAXDUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MAXDUNX as libc::c_int {
            dMonster[i as usize][j as usize] = 0 as libc::c_int;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    let mut t: libc::c_int = 0 as libc::c_int;
    while t < numtowners {
        let mut _towner: *mut TownerStruct = &mut *towner.as_mut_ptr().offset(t as isize)
            as *mut TownerStruct;
        dMonster[(*_towner)._tx
            as usize][(*_towner)._ty as usize] = t + 1 as libc::c_int;
        if (*_towner)._ttype == TWN_COW as libc::c_int {
            let mut x: libc::c_int = (*_towner)._tx;
            let mut y: libc::c_int = (*_towner)._ty;
            let mut dir: libc::c_int = (*_towner)._tdir;
            let mut x2: libc::c_int = x + cowoffx[dir as usize];
            let mut y2: libc::c_int = y + cowoffy[dir as usize];
            if dMonster[x as usize][y2 as usize] == 0 as libc::c_int {
                dMonster[x as usize][y2 as usize] = -(t + 1 as libc::c_int);
            }
            if dMonster[x2 as usize][y as usize] == 0 as libc::c_int {
                dMonster[x2 as usize][y as usize] = -(t + 1 as libc::c_int);
            }
            if dMonster[x2 as usize][y2 as usize] == 0 as libc::c_int {
                dMonster[x2 as usize][y2 as usize] = -(t + 1 as libc::c_int);
            }
        }
        t += 1;
        t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn addMissilesToMap() {
    let mut y: libc::c_int = 0 as libc::c_int;
    while y < MAXDUNY as libc::c_int {
        let mut x: libc::c_int = 0 as libc::c_int;
        while x < MAXDUNX as libc::c_int {
            dMissile[x as usize][y as usize] = 0 as *mut MissileNode;
            x += 1;
            x;
        }
        y += 1;
        y;
    }
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < nummissiles {
        let mut missile_num: libc::c_int = missileactive[i as usize];
        let mut _missile: *mut MissileStruct = &mut *missile
            .as_mut_ptr()
            .offset(missile_num as isize) as *mut MissileStruct;
        append_missile((*_missile)._mix, (*_missile)._miy, missile_num);
        i += 1;
        i;
    }
}
