use ::libc;
extern "C" {
    fn sqrt(_: libc::c_double) -> libc::c_double;
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn SetAutomapView(x: libc::c_int, y: libc::c_int);
    fn DiabloAllocPtr(dwBytes: uint32_t) -> *mut uint8_t;
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    static mut light4flag: bool32_t;
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut setlevel: uint8_t;
    static mut nBlockTable: [uint8_t; 2049];
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut TransVal: int8_t;
    static mut TransList: [uint8_t; 256];
    static mut dPiece: [[libc::c_int; 112]; 112];
    static mut dTransVal: [[int8_t; 112]; 112];
    static mut dLight: [[int8_t; 112]; 112];
    static mut dSaveLight: [[int8_t; 112]; 112];
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dung_map_r: [[uint8_t; 112]; 112];
    static mut dung_map_g: [[uint8_t; 112]; 112];
    static mut dung_map_b: [[uint8_t; 112]; 112];
    static mut vCrawlTable: [[uint8_t; 30]; 23];
    static mut RadiusAdj: [uint8_t; 23];
    static mut lightflag: libc::c_int;
    static mut LightList: [LightListStruct; 32];
    static mut lightactive: [uint8_t; 32];
    static mut restore_g: libc::c_int;
    static mut restore_b: libc::c_int;
    static mut VisionList: [LightListStruct; 32];
    static mut numvision: libc::c_int;
    static mut dovision: bool32_t;
    static mut visionid: libc::c_int;
    static mut lightmax: int8_t;
    static mut pLightTbl: *mut uint8_t;
    static mut numlights: libc::c_int;
    static mut dolighting: bool32_t;
    static mut restore_r: libc::c_int;
    static mut plr: [PlayerStruct; 4];
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type C2RustUnnamed = libc::c_uint;
pub const PLRVRAD: C2RustUnnamed = 10;
pub const PLRLRAD: C2RustUnnamed = 10;
pub const MAXTRANS: C2RustUnnamed = 32;
pub const MAXVISION: C2RustUnnamed = 32;
pub const MAXLIGHTS: C2RustUnnamed = 32;
pub const LIGHTSIZE: C2RustUnnamed = 6912;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const PAUSEBANDE: C2RustUnnamed_0 = 239;
pub const PAUSEBANDS: C2RustUnnamed_0 = 224;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed_1 = 191;
pub const SETP_TEMP: C2RustUnnamed_1 = 64;
pub const SETP_MASK: C2RustUnnamed_1 = 127;
pub const SETP_BIT: C2RustUnnamed_1 = 128;
pub const BFMASK_MISSILE: C2RustUnnamed_1 = 254;
pub const BFMASK_SETPC: C2RustUnnamed_1 = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed_1 = 239;
pub const BFMASK_PLRLR: C2RustUnnamed_1 = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed_1 = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed_1 = 127;
pub const BFLAG_MISSILE: C2RustUnnamed_1 = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed_1 = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed_1 = 4;
pub const BFLAG_SETPC: C2RustUnnamed_1 = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed_1 = 16;
pub const BFLAG_PLRLR: C2RustUnnamed_1 = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed_1 = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed_1 = 128;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const LFLAG_MINE: C2RustUnnamed_2 = 1;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const G_BRIGHT_LIGHTS: C2RustUnnamed_3 = 0;
pub const USE_GOURAUD: C2RustUnnamed_3 = 0;
pub const ORIG_LIGHTING: C2RustUnnamed_3 = 1;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_4 = 32;
pub const MAXMICRO: C2RustUnnamed_4 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_4 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_4 = 64;
pub const MAXMREND: C2RustUnnamed_4 = 128;
pub const MAXTILES: C2RustUnnamed_4 = 2048;
pub const MDMAXY: C2RustUnnamed_4 = 40;
pub const MDMAXX: C2RustUnnamed_4 = 40;
pub const MAXDUNY: C2RustUnnamed_4 = 112;
pub const MAXDUNX: C2RustUnnamed_4 = 112;
pub const DMAXY: C2RustUnnamed_4 = 112;
pub const DMAXX: C2RustUnnamed_4 = 112;
pub const DIRTEDGED2: C2RustUnnamed_4 = 16;
pub const DIRTEDGE: C2RustUnnamed_4 = 32;
pub const NUMSLEVELS: C2RustUnnamed_4 = 10;
pub const NUMLEVELS: C2RustUnnamed_4 = 17;
pub const LVL4_START: C2RustUnnamed_4 = 13;
pub const LVL3_START: C2RustUnnamed_4 = 9;
pub const LVL2_START: C2RustUnnamed_4 = 5;
pub const LVL1_START: C2RustUnnamed_4 = 1;
pub const TLVL_START: C2RustUnnamed_4 = 0;
pub const LVLLENGTH: C2RustUnnamed_4 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct LightListStruct {
    pub _lx: libc::c_int,
    pub _ly: libc::c_int,
    pub _lradius: libc::c_int,
    pub _lid: libc::c_int,
    pub _ldel: bool32_t,
    pub _lunflag: bool32_t,
    pub _lneg: bool32_t,
    pub _lunx: libc::c_int,
    pub _luny: libc::c_int,
    pub _lunr: libc::c_int,
    pub _xoff: libc::c_int,
    pub _yoff: libc::c_int,
    pub _lflags: bool32_t,
}
pub type C2RustUnnamed_5 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_5 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_5 = 92160;
pub const BTMBUFFY: C2RustUnnamed_5 = 144;
pub const BTMBUFFX: C2RustUnnamed_5 = 640;
pub const BUFFERSIZE: C2RustUnnamed_5 = 503808;
pub const BUFFERY: C2RustUnnamed_5 = 656;
pub const BUFFERX: C2RustUnnamed_5 = 768;
pub const GAMEY: C2RustUnnamed_5 = 352;
pub const CTRLPANY: C2RustUnnamed_5 = 128;
pub const TOTALY: C2RustUnnamed_5 = 480;
pub const TOTALX: C2RustUnnamed_5 = 640;
pub const MAX_PLRS: C2RustUnnamed_5 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
#[no_mangle]
pub static mut LightLvls: [[uint8_t; 128]; 16] = [[0; 128]; 16];
#[no_mangle]
pub static mut LightLvls4: [[uint8_t; 18]; 18] = [
    [
        0 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        3 as libc::c_int as uint8_t,
    ],
    [
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        0 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        1 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
        2 as libc::c_int as uint8_t,
    ],
];
#[no_mangle]
pub static mut Dist: [[uint8_t; 256]; 64] = [[0; 256]; 64];
static mut radius_tab: [int8_t; 16] = [
    -(1 as libc::c_int) as int8_t,
    24 as libc::c_int as int8_t,
    26 as libc::c_int as int8_t,
    29 as libc::c_int as int8_t,
    32 as libc::c_int as int8_t,
    35 as libc::c_int as int8_t,
    37 as libc::c_int as int8_t,
    40 as libc::c_int as int8_t,
    43 as libc::c_int as int8_t,
    46 as libc::c_int as int8_t,
    49 as libc::c_int as int8_t,
    51 as libc::c_int as int8_t,
    54 as libc::c_int as int8_t,
    57 as libc::c_int as int8_t,
    60 as libc::c_int as int8_t,
    64 as libc::c_int as int8_t,
];
static mut bright_tab: [int8_t; 16] = [
    -(1 as libc::c_int) as int8_t,
    2 as libc::c_int as int8_t,
    2 as libc::c_int as int8_t,
    2 as libc::c_int as int8_t,
    3 as libc::c_int as int8_t,
    3 as libc::c_int as int8_t,
    4 as libc::c_int as int8_t,
    4 as libc::c_int as int8_t,
    4 as libc::c_int as int8_t,
    4 as libc::c_int as int8_t,
    3 as libc::c_int as int8_t,
    3 as libc::c_int as int8_t,
    3 as libc::c_int as int8_t,
    2 as libc::c_int as int8_t,
    2 as libc::c_int as int8_t,
    2 as libc::c_int as int8_t,
];
#[no_mangle]
pub unsafe extern "C" fn veclen2(
    mut ix: libc::c_int,
    mut iy: libc::c_int,
) -> libc::c_int {
    let mut t: libc::c_int = 0;
    ix = if ix < 0 as libc::c_int { -ix } else { ix };
    iy = if iy < 0 as libc::c_int { -iy } else { iy };
    if ix < iy {
        ix ^= iy;
        iy ^= ix;
        ix ^= iy;
    }
    t = iy + (iy >> 1 as libc::c_int);
    return ix - (ix >> 5 as libc::c_int) - (ix >> 7 as libc::c_int)
        + (t >> 2 as libc::c_int) + (t >> 6 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn set_restore_lighting() {
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    y = 0 as libc::c_int;
    while y < MAXDUNY as libc::c_int {
        x = 0 as libc::c_int;
        while x < MAXDUNX as libc::c_int {
            dung_map_r[x as usize][y as usize] = restore_r as uint8_t;
            dung_map_g[x as usize][y as usize] = restore_g as uint8_t;
            dung_map_b[x as usize][y as usize] = restore_b as uint8_t;
            x += 1;
            x;
        }
        y += 1;
        y;
    }
}
#[no_mangle]
pub unsafe extern "C" fn RotateOffset(
    mut x: *mut libc::c_int,
    mut y: *mut libc::c_int,
    mut rx: *mut libc::c_int,
    mut ry: *mut libc::c_int,
    mut ox: *mut libc::c_int,
    mut oy: *mut libc::c_int,
    mut ax: *mut libc::c_int,
    mut ay: *mut libc::c_int,
) {
    let mut tmp: libc::c_int = 0;
    *ax = 0 as libc::c_int;
    *ay = 0 as libc::c_int;
    tmp = *rx;
    *rx = 7 as libc::c_int - *ry;
    *ry = tmp;
    tmp = *ox;
    *ox = 7 as libc::c_int - *oy;
    *oy = tmp;
    *x = *rx - *ox;
    *y = *ry - *oy;
    if *x < 0 as libc::c_int {
        *x += 8 as libc::c_int;
        *ax = 1 as libc::c_int;
    }
    if *y < 0 as libc::c_int {
        *y += 8 as libc::c_int;
        *ay = 1 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoLighting_orig_lighting(
    mut nXPos: libc::c_int,
    mut nYPos: libc::c_int,
    mut nRadius: libc::c_int,
    mut Lnum: libc::c_int,
) {
    let mut LightVal: libc::c_int = 0;
    let mut nCrawlX: libc::c_int = 0;
    let mut nCrawlY: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut dist: libc::c_int = 0;
    let mut xoff: libc::c_int = 0 as libc::c_int;
    let mut yoff: libc::c_int = 0 as libc::c_int;
    let mut rxoff: libc::c_int = 0;
    let mut ryoff: libc::c_int = 0;
    let mut orgx: libc::c_int = 0 as libc::c_int;
    let mut orgy: libc::c_int = 0 as libc::c_int;
    let mut addx: libc::c_int = 0 as libc::c_int;
    let mut addy: libc::c_int = 0 as libc::c_int;
    let mut dtab: libc::c_int = 0;
    let mut maxleft: libc::c_int = 0;
    let mut maxright: libc::c_int = 0;
    let mut maxup: libc::c_int = 0;
    let mut maxdown: libc::c_int = 0;
    if Lnum >= 0 as libc::c_int {
        xoff = LightList[Lnum as usize]._xoff;
        yoff = LightList[Lnum as usize]._yoff;
        if xoff < 0 as libc::c_int {
            xoff += 8 as libc::c_int;
            nXPos -= 1;
            nXPos;
        }
        if yoff < 0 as libc::c_int {
            yoff += 8 as libc::c_int;
            nYPos -= 1;
            nYPos;
        }
    }
    rxoff = xoff;
    ryoff = yoff;
    if (nXPos - 15 as libc::c_int) < 0 as libc::c_int {
        maxleft = nXPos + 1 as libc::c_int;
    } else {
        maxleft = 15 as libc::c_int;
    }
    if nXPos + 15 as libc::c_int > MAXDUNX as libc::c_int {
        maxright = MAXDUNX as libc::c_int - nXPos;
    } else {
        maxright = 15 as libc::c_int;
    }
    if (nYPos - 15 as libc::c_int) < 0 as libc::c_int {
        maxup = nYPos + 1 as libc::c_int;
    } else {
        maxup = 15 as libc::c_int;
    }
    if nYPos + 15 as libc::c_int > MAXDUNY as libc::c_int {
        maxdown = MAXDUNY as libc::c_int - nYPos;
    } else {
        maxdown = 15 as libc::c_int;
    }
    if nXPos >= 0 as libc::c_int && nXPos < MAXDUNX as libc::c_int
        && nYPos >= 0 as libc::c_int && nYPos < MAXDUNY as libc::c_int
    {
        dLight[nXPos as usize][nYPos as usize] = 0 as libc::c_int as int8_t;
    }
    dtab = xoff + 8 as libc::c_int * yoff;
    j = 0 as libc::c_int;
    while j < maxup {
        i = 1 as libc::c_int;
        while i < maxright {
            dist = Dist[dtab as usize][(i + j * 16 as libc::c_int) as usize]
                as libc::c_int;
            if dist < 128 as libc::c_int {
                nCrawlX = nXPos + i;
                nCrawlY = nYPos + j;
                LightVal = LightLvls[nRadius as usize][dist as usize] as libc::c_int;
                if nCrawlX >= 0 as libc::c_int && nCrawlX < MAXDUNX as libc::c_int
                    && nCrawlY >= 0 as libc::c_int && nCrawlY < MAXDUNY as libc::c_int
                {
                    if LightVal
                        < dLight[nCrawlX as usize][nCrawlY as usize] as libc::c_int
                    {
                        dLight[nCrawlX as usize][nCrawlY as usize] = LightVal as int8_t;
                    }
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    RotateOffset(
        &mut xoff,
        &mut yoff,
        &mut rxoff,
        &mut ryoff,
        &mut orgx,
        &mut orgy,
        &mut addx,
        &mut addy,
    );
    dtab = xoff + 8 as libc::c_int * yoff;
    j = 0 as libc::c_int;
    while j < maxdown {
        i = 1 as libc::c_int;
        while i < maxright {
            dist = Dist[dtab
                as usize][(i + addx + (j + addy) * 16 as libc::c_int) as usize]
                as libc::c_int;
            if dist < 128 as libc::c_int {
                nCrawlX = nXPos + j;
                nCrawlY = nYPos - i;
                LightVal = LightLvls[nRadius as usize][dist as usize] as libc::c_int;
                if nCrawlX >= 0 as libc::c_int && nCrawlX < MAXDUNX as libc::c_int
                    && nCrawlY >= 0 as libc::c_int && nCrawlY < MAXDUNY as libc::c_int
                {
                    if LightVal
                        < dLight[nCrawlX as usize][nCrawlY as usize] as libc::c_int
                    {
                        dLight[nCrawlX as usize][nCrawlY as usize] = LightVal as int8_t;
                    }
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    RotateOffset(
        &mut xoff,
        &mut yoff,
        &mut rxoff,
        &mut ryoff,
        &mut orgx,
        &mut orgy,
        &mut addx,
        &mut addy,
    );
    dtab = xoff + 8 as libc::c_int * yoff;
    j = 0 as libc::c_int;
    while j < maxdown {
        i = 1 as libc::c_int;
        while i < maxleft {
            dist = Dist[dtab
                as usize][(i + addx + (j + addy) * 16 as libc::c_int) as usize]
                as libc::c_int;
            if dist < 128 as libc::c_int {
                nCrawlX = nXPos - i;
                nCrawlY = nYPos - j;
                LightVal = LightLvls[nRadius as usize][dist as usize] as libc::c_int;
                if nCrawlX >= 0 as libc::c_int && nCrawlX < MAXDUNX as libc::c_int
                    && nCrawlY >= 0 as libc::c_int && nCrawlY < MAXDUNY as libc::c_int
                {
                    if LightVal
                        < dLight[nCrawlX as usize][nCrawlY as usize] as libc::c_int
                    {
                        dLight[nCrawlX as usize][nCrawlY as usize] = LightVal as int8_t;
                    }
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    RotateOffset(
        &mut xoff,
        &mut yoff,
        &mut rxoff,
        &mut ryoff,
        &mut orgx,
        &mut orgy,
        &mut addx,
        &mut addy,
    );
    dtab = xoff + 8 as libc::c_int * yoff;
    j = 0 as libc::c_int;
    while j < maxup {
        i = 1 as libc::c_int;
        while i < maxleft {
            dist = Dist[dtab
                as usize][(i + addx + (j + addy) * 16 as libc::c_int) as usize]
                as libc::c_int;
            if dist < 128 as libc::c_int {
                nCrawlX = nXPos - j;
                nCrawlY = nYPos + i;
                LightVal = LightLvls[nRadius as usize][dist as usize] as libc::c_int;
                if nCrawlX >= 0 as libc::c_int && nCrawlX < MAXDUNX as libc::c_int
                    && nCrawlY >= 0 as libc::c_int && nCrawlY < MAXDUNY as libc::c_int
                {
                    if LightVal
                        < dLight[nCrawlX as usize][nCrawlY as usize] as libc::c_int
                    {
                        dLight[nCrawlX as usize][nCrawlY as usize] = LightVal as int8_t;
                    }
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoLighting_gouraud(
    mut nXPos: libc::c_int,
    mut nYPos: libc::c_int,
    mut nRadius: libc::c_int,
    mut Lnum: libc::c_int,
) {
    let mut xoff: libc::c_int = 0;
    let mut yoff: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut v: libc::c_int = 0;
    let mut light_x: libc::c_int = 0;
    let mut light_y: libc::c_int = 0;
    let mut block_x: libc::c_int = 0;
    let mut block_y: libc::c_int = 0;
    let mut dist_x: libc::c_int = 0;
    let mut dist_y: libc::c_int = 0;
    let mut mult: libc::c_int = 0;
    let mut radius: libc::c_int = 0;
    let mut bright: libc::c_int = 0;
    let mut max_bright: libc::c_int = 0;
    let mut radius_block: libc::c_int = 0;
    let mut r: uint8_t = 0;
    let mut g: uint8_t = 0;
    let mut b: uint8_t = 0;
    radius = radius_tab[nRadius as usize] as libc::c_int;
    bright = bright_tab[nRadius as usize] as libc::c_int;
    if Lnum == -(1 as libc::c_int) {
        bright = 1 as libc::c_int;
    } else {
        bright = 4 as libc::c_int;
    }
    max_bright = 0xff as libc::c_int;
    if Lnum != -(1 as libc::c_int) {
        xoff = LightList[Lnum as usize]._xoff;
        yoff = LightList[Lnum as usize]._yoff;
    } else {
        xoff = 0 as libc::c_int;
        yoff = 0 as libc::c_int;
    }
    light_x = (nXPos << 3 as libc::c_int) + xoff;
    light_y = (nYPos << 3 as libc::c_int) + yoff;
    block_x = nXPos - (radius >> 3 as libc::c_int);
    block_y = nYPos - (radius >> 3 as libc::c_int);
    if nXPos < ViewX - 25 as libc::c_int || nXPos > ViewX + 25 as libc::c_int
        || nYPos < ViewY - 25 as libc::c_int || nYPos > ViewY + 25 as libc::c_int
    {
        return;
    }
    radius_block = radius >> 2 as libc::c_int;
    r = 255 as libc::c_int as uint8_t;
    g = 222 as libc::c_int as uint8_t;
    b = 128 as libc::c_int as uint8_t;
    y = block_y;
    while y <= block_y + radius_block {
        if !(y < 0 as libc::c_int || y >= MAXDUNY as libc::c_int) {
            dist_y = light_y - (y << 3 as libc::c_int);
            x = block_x;
            while x <= block_x + radius_block {
                if !(x < 0 as libc::c_int || x >= MAXDUNX as libc::c_int) {
                    dist_x = light_x - (x << 3 as libc::c_int);
                    mult = (radius - veclen2(dist_x, dist_y)) * bright;
                    if !(mult <= 0 as libc::c_int) {
                        if G_BRIGHT_LIGHTS as libc::c_int != 0 {
                            mult >>= 1 as libc::c_int;
                        }
                        if r as libc::c_int != 0 as libc::c_int {
                            v = dung_map_r[x as usize][y as usize] as libc::c_int;
                            v += r as libc::c_int * mult >> 8 as libc::c_int;
                            if v > max_bright {
                                v = max_bright;
                            }
                            dung_map_r[x as usize][y as usize] = v as uint8_t;
                        }
                        if g as libc::c_int != 0 as libc::c_int {
                            v = dung_map_g[x as usize][y as usize] as libc::c_int;
                            v += g as libc::c_int * mult >> 8 as libc::c_int;
                            if v > max_bright {
                                v = max_bright;
                            }
                            dung_map_g[x as usize][y as usize] = v as uint8_t;
                        }
                        if b as libc::c_int != 0 as libc::c_int {
                            v = dung_map_b[x as usize][y as usize] as libc::c_int;
                            v += b as libc::c_int * mult >> 8 as libc::c_int;
                            if v > max_bright {
                                v = max_bright;
                            }
                            dung_map_b[x as usize][y as usize] = v as uint8_t;
                        }
                    }
                }
                x += 1;
                x;
            }
        }
        y += 1;
        y;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoLighting(
    mut nXPos: libc::c_int,
    mut nYPos: libc::c_int,
    mut nRadius: libc::c_int,
    mut Lnum: libc::c_int,
) {
    if ORIG_LIGHTING as libc::c_int != 0 {
        DoLighting_orig_lighting(nXPos, nYPos, nRadius, Lnum);
    } else {
        DoLighting_gouraud(nXPos, nYPos, nRadius, Lnum);
    };
}
#[no_mangle]
pub unsafe extern "C" fn DoUnLight_orig_lighting(
    mut nXPos: libc::c_int,
    mut nYPos: libc::c_int,
    mut nRadius: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut x1: libc::c_int = 0;
    let mut y1: libc::c_int = 0;
    let mut x2: libc::c_int = 0;
    let mut y2: libc::c_int = 0;
    nRadius += 1;
    nRadius;
    y1 = nYPos - nRadius;
    y2 = nYPos + nRadius;
    x1 = nXPos - nRadius;
    x2 = nXPos + nRadius;
    if y1 < 0 as libc::c_int {
        y1 = 0 as libc::c_int;
    }
    if y2 > DMAXY as libc::c_int {
        y2 = DMAXY as libc::c_int;
    }
    if x1 < 0 as libc::c_int {
        x1 = 0 as libc::c_int;
    }
    if x2 > DMAXX as libc::c_int {
        x2 = DMAXX as libc::c_int;
    }
    j = y1;
    while j < y2 {
        i = x1;
        while i < x2 {
            if i >= 0 as libc::c_int && i < DMAXX as libc::c_int && j >= 0 as libc::c_int
                && j < DMAXY as libc::c_int
            {
                dLight[i as usize][j as usize] = dSaveLight[i as usize][j as usize];
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoUnLight_gouraud() {
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut block_x: libc::c_int = 0;
    let mut block_y: libc::c_int = 0;
    let mut radius_block: libc::c_int = 0;
    block_x = ViewX - 25 as libc::c_int;
    block_y = ViewY - 25 as libc::c_int;
    radius_block = 50 as libc::c_int;
    y = block_y;
    while y <= block_y + radius_block {
        if !(y < 0 as libc::c_int || y >= MAXDUNY as libc::c_int) {
            x = block_x;
            while x <= block_x + radius_block {
                if !(x < 0 as libc::c_int || x >= MAXDUNX as libc::c_int) {
                    dung_map_r[x as usize][y as usize] = restore_r as uint8_t;
                    dung_map_g[x as usize][y as usize] = restore_g as uint8_t;
                    dung_map_b[x as usize][y as usize] = restore_b as uint8_t;
                }
                x += 1;
                x;
            }
        }
        y += 1;
        y;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoUnLight(
    mut nXPos: libc::c_int,
    mut nYPos: libc::c_int,
    mut nRadius: libc::c_int,
) {
    if ORIG_LIGHTING as libc::c_int != 0 {
        DoUnLight_orig_lighting(nXPos, nYPos, nRadius);
    } else {
        DoUnLight_gouraud();
    };
}
#[no_mangle]
pub unsafe extern "C" fn DoLavaLight() {
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut block_x: libc::c_int = 0;
    let mut block_y: libc::c_int = 0;
    let mut radius_block: libc::c_int = 0;
    block_x = ViewX - 25 as libc::c_int;
    block_y = ViewY - 25 as libc::c_int;
    radius_block = 50 as libc::c_int;
    y = block_y;
    while y <= block_y + radius_block {
        if !(y < 0 as libc::c_int || y >= MAXDUNY as libc::c_int) {
            x = block_x;
            while x <= block_x + radius_block {
                if !(x < 0 as libc::c_int || x >= MAXDUNX as libc::c_int) {
                    if dPiece[x as usize][y as usize] >= 56 as libc::c_int
                        && dPiece[x as usize][y as usize] <= 147 as libc::c_int
                    {
                        DoLighting(x, y, 2 as libc::c_int, -(1 as libc::c_int));
                    } else if dPiece[x as usize][y as usize] >= 154 as libc::c_int
                        && dPiece[x as usize][y as usize] <= 161 as libc::c_int
                    {
                        DoLighting(x, y, 2 as libc::c_int, -(1 as libc::c_int));
                    } else if dPiece[x as usize][y as usize] == 150 as libc::c_int {
                        DoLighting(x, y, 2 as libc::c_int, -(1 as libc::c_int));
                    } else if dPiece[x as usize][y as usize] == 152 as libc::c_int {
                        DoLighting(x, y, 2 as libc::c_int, -(1 as libc::c_int));
                    }
                }
                x += 1;
                x;
            }
        }
        y += 1;
        y;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoUnVision(
    mut nXPos: libc::c_int,
    mut nYPos: libc::c_int,
    mut nRadius: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut x1: libc::c_int = 0;
    let mut y1: libc::c_int = 0;
    let mut x2: libc::c_int = 0;
    let mut y2: libc::c_int = 0;
    nRadius += 1;
    nRadius;
    y1 = nYPos - nRadius;
    y2 = nYPos + nRadius;
    x1 = nXPos - nRadius;
    x2 = nXPos + nRadius;
    if y1 < 0 as libc::c_int {
        y1 = 0 as libc::c_int;
    }
    if y2 > DMAXY as libc::c_int {
        y2 = DMAXY as libc::c_int;
    }
    if x1 < 0 as libc::c_int {
        x1 = 0 as libc::c_int;
    }
    if x2 > DMAXX as libc::c_int {
        x2 = DMAXX as libc::c_int;
    }
    i = x1;
    while i < x2 {
        j = y1;
        while j < y2 {
            dFlags[i
                as usize][j
                as usize] = (dFlags[i as usize][j as usize] as libc::c_int
                & !(BFLAG_VISIBLE as libc::c_int | BFLAG_MONSTACTIVE as libc::c_int))
                as int8_t;
            j += 1;
            j;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DoVision(
    mut nXPos: libc::c_int,
    mut nYPos: libc::c_int,
    mut nRadius: libc::c_int,
    mut doautomap: bool32_t,
    mut visible: bool32_t,
) {
    let mut nCrawlX: libc::c_int = 0;
    let mut nCrawlY: libc::c_int = 0;
    let mut nLineLen: libc::c_int = 0;
    let mut nBlockerFlag: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut k: libc::c_int = 0;
    let mut v: libc::c_int = 0;
    let mut x1adj: libc::c_int = 0;
    let mut x2adj: libc::c_int = 0;
    let mut y1adj: libc::c_int = 0;
    let mut y2adj: libc::c_int = 0;
    if nXPos >= 0 as libc::c_int && nXPos <= DMAXX as libc::c_int
        && nYPos >= 0 as libc::c_int && nYPos <= DMAXY as libc::c_int
    {
        if doautomap != 0 {
            if dFlags[nXPos as usize][nYPos as usize] as libc::c_int >= 0 as libc::c_int
            {
                SetAutomapView(nXPos, nXPos);
            }
            dFlags[nXPos
                as usize][nYPos
                as usize] = (dFlags[nXPos as usize][nYPos as usize] as libc::c_int
                | BFLAG_AUTOMAP as libc::c_int) as int8_t;
        }
        if visible != 0 {
            dFlags[nXPos
                as usize][nYPos
                as usize] = (dFlags[nXPos as usize][nYPos as usize] as libc::c_int
                | BFLAG_VISIBLE as libc::c_int) as int8_t;
        }
        dFlags[nXPos
            as usize][nYPos
            as usize] = (dFlags[nXPos as usize][nYPos as usize] as libc::c_int
            | BFLAG_MONSTACTIVE as libc::c_int) as int8_t;
    }
    k = 0 as libc::c_int;
    while k < 4 as libc::c_int {
        j = 0 as libc::c_int;
        while j < 23 as libc::c_int {
            nBlockerFlag = 0 as libc::c_int;
            nLineLen = (nRadius - RadiusAdj[j as usize] as libc::c_int)
                << 1 as libc::c_int;
            i = 0 as libc::c_int;
            while i < nLineLen && nBlockerFlag == 0 {
                x1adj = 0 as libc::c_int;
                x2adj = 0 as libc::c_int;
                y1adj = 0 as libc::c_int;
                y2adj = 0 as libc::c_int;
                match k {
                    0 => {
                        nCrawlX = nXPos
                            + vCrawlTable[j as usize][i as usize] as libc::c_int;
                        nCrawlY = nYPos
                            + vCrawlTable[j as usize][(i + 1 as libc::c_int) as usize]
                                as libc::c_int;
                        if vCrawlTable[j as usize][i as usize] as libc::c_int
                            > 0 as libc::c_int
                            && vCrawlTable[j as usize][(i + 1 as libc::c_int) as usize]
                                as libc::c_int > 0 as libc::c_int
                        {
                            x1adj = -(1 as libc::c_int);
                            y2adj = -(1 as libc::c_int);
                        }
                    }
                    1 => {
                        nCrawlX = nXPos
                            - vCrawlTable[j as usize][i as usize] as libc::c_int;
                        nCrawlY = nYPos
                            - vCrawlTable[j as usize][(i + 1 as libc::c_int) as usize]
                                as libc::c_int;
                        if vCrawlTable[j as usize][i as usize] as libc::c_int
                            > 0 as libc::c_int
                            && vCrawlTable[j as usize][(i + 1 as libc::c_int) as usize]
                                as libc::c_int > 0 as libc::c_int
                        {
                            y1adj = 1 as libc::c_int;
                            x2adj = 1 as libc::c_int;
                        }
                    }
                    2 => {
                        nCrawlX = nXPos
                            + vCrawlTable[j as usize][i as usize] as libc::c_int;
                        nCrawlY = nYPos
                            - vCrawlTable[j as usize][(i + 1 as libc::c_int) as usize]
                                as libc::c_int;
                        if vCrawlTable[j as usize][i as usize] as libc::c_int
                            > 0 as libc::c_int
                            && vCrawlTable[j as usize][(i + 1 as libc::c_int) as usize]
                                as libc::c_int > 0 as libc::c_int
                        {
                            x1adj = -(1 as libc::c_int);
                            y2adj = 1 as libc::c_int;
                        }
                    }
                    3 => {
                        nCrawlX = nXPos
                            - vCrawlTable[j as usize][i as usize] as libc::c_int;
                        nCrawlY = nYPos
                            + vCrawlTable[j as usize][(i + 1 as libc::c_int) as usize]
                                as libc::c_int;
                        if vCrawlTable[j as usize][i as usize] as libc::c_int
                            > 0 as libc::c_int
                            && vCrawlTable[j as usize][(i + 1 as libc::c_int) as usize]
                                as libc::c_int > 0 as libc::c_int
                        {
                            y1adj = -(1 as libc::c_int);
                            x2adj = 1 as libc::c_int;
                        }
                    }
                    _ => {}
                }
                if nCrawlX >= 0 as libc::c_int && nCrawlX <= DMAXX as libc::c_int
                    && nCrawlY >= 0 as libc::c_int && nCrawlY <= DMAXY as libc::c_int
                {
                    nBlockerFlag = nBlockTable[dPiece[nCrawlX as usize][nCrawlY as usize]
                        as usize] as libc::c_int;
                    if nBlockTable[dPiece[(nCrawlX + x1adj)
                        as usize][(nCrawlY + y1adj) as usize] as usize] == 0
                        || nBlockTable[dPiece[(nCrawlX + x2adj)
                            as usize][(nCrawlY + y2adj) as usize] as usize] == 0
                    {
                        if doautomap != 0 {
                            if dFlags[nCrawlX as usize][nCrawlY as usize] as libc::c_int
                                >= 0 as libc::c_int
                            {
                                SetAutomapView(nCrawlX, nCrawlY);
                            }
                            dFlags[nCrawlX
                                as usize][nCrawlY
                                as usize] = (dFlags[nCrawlX as usize][nCrawlY as usize]
                                as libc::c_int | BFLAG_AUTOMAP as libc::c_int) as int8_t;
                        }
                        if visible != 0 {
                            dFlags[nCrawlX
                                as usize][nCrawlY
                                as usize] = (dFlags[nCrawlX as usize][nCrawlY as usize]
                                as libc::c_int | BFLAG_VISIBLE as libc::c_int) as int8_t;
                        }
                        dFlags[nCrawlX
                            as usize][nCrawlY
                            as usize] = (dFlags[nCrawlX as usize][nCrawlY as usize]
                            as libc::c_int | BFLAG_MONSTACTIVE as libc::c_int) as int8_t;
                        if nBlockerFlag == 0 {
                            v = dTransVal[nCrawlX as usize][nCrawlY as usize]
                                as libc::c_int;
                            if v != 0 as libc::c_int {
                                TransList[v as usize] = 1 as libc::c_int as uint8_t;
                            }
                        }
                    }
                }
                i += 2 as libc::c_int;
            }
            j += 1;
            j;
        }
        k += 1;
        k;
    }
}
#[no_mangle]
pub unsafe extern "C" fn FreeLightTable() {
    let mut p__p: *mut libc::c_void = pLightTbl as *mut libc::c_void;
    pLightTbl = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
}
#[no_mangle]
pub unsafe extern "C" fn InitLightTable() {
    if !pLightTbl.is_null() {
        assert_fail(
            644 as libc::c_int,
            b"src/lighting.c\0" as *const u8 as *const libc::c_char,
            b"!pLightTbl\0" as *const u8 as *const libc::c_char,
        );
    }
    pLightTbl = DiabloAllocPtr(LIGHTSIZE as libc::c_int as uint32_t);
}
#[no_mangle]
pub unsafe extern "C" fn MakeLightTable_orig_lighting() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut k: libc::c_int = 0;
    let mut idx: libc::c_int = 0;
    let mut tlen: libc::c_int = 0;
    let mut ev: uint8_t = 0;
    let mut sv: uint8_t = 0;
    let mut InfraTemp: *mut uint8_t = 0 as *mut uint8_t;
    let mut itp: *mut uint8_t = 0 as *mut uint8_t;
    let mut pLT: *mut uint8_t = 0 as *mut uint8_t;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut rad: libc::c_int = 0;
    let mut d: libc::c_int = 0;
    let mut a: libc::c_int = 0;
    let mut b: libc::c_int = 0;
    let mut ftmp: libc::c_double = 0.;
    pLT = pLightTbl;
    idx = 0 as libc::c_int;
    if light4flag != 0 {
        tlen = 3 as libc::c_int;
    } else {
        tlen = 15 as libc::c_int;
    }
    i = 0 as libc::c_int;
    while i < tlen {
        let fresh0 = pLT;
        pLT = pLT.offset(1);
        *fresh0 = 0 as libc::c_int as uint8_t;
        j = 0 as libc::c_int;
        while j < 8 as libc::c_int {
            sv = (idx + j * 16 as libc::c_int) as uint8_t;
            ev = (15 as libc::c_int + j * 16 as libc::c_int) as uint8_t;
            k = 0 as libc::c_int;
            while k < 16 as libc::c_int {
                if k != 0 as libc::c_int || j != 0 as libc::c_int {
                    let fresh1 = pLT;
                    pLT = pLT.offset(1);
                    *fresh1 = sv;
                }
                if (sv as libc::c_int) < ev as libc::c_int {
                    sv = sv.wrapping_add(1);
                    sv;
                } else {
                    ev = 0 as libc::c_int as uint8_t;
                    sv = ev;
                }
                k += 1;
                k;
            }
            j += 1;
            j;
        }
        j = 16 as libc::c_int;
        while j < 20 as libc::c_int {
            sv = ((idx >> 1 as libc::c_int) + j * 8 as libc::c_int) as uint8_t;
            ev = (7 as libc::c_int + j * 8 as libc::c_int) as uint8_t;
            k = 0 as libc::c_int;
            while k < 8 as libc::c_int {
                let fresh2 = pLT;
                pLT = pLT.offset(1);
                *fresh2 = sv;
                if (sv as libc::c_int) < ev as libc::c_int {
                    sv = sv.wrapping_add(1);
                    sv;
                } else {
                    ev = 0 as libc::c_int as uint8_t;
                    sv = ev;
                }
                k += 1;
                k;
            }
            j += 1;
            j;
        }
        j = 10 as libc::c_int;
        while j < 16 as libc::c_int {
            sv = (idx + j * 16 as libc::c_int) as uint8_t;
            ev = (15 as libc::c_int + j * 16 as libc::c_int) as uint8_t;
            k = 0 as libc::c_int;
            while k < 16 as libc::c_int {
                let fresh3 = pLT;
                pLT = pLT.offset(1);
                *fresh3 = sv;
                if (sv as libc::c_int) < ev as libc::c_int {
                    sv = sv.wrapping_add(1);
                    sv;
                } else {
                    ev = 0 as libc::c_int as uint8_t;
                    sv = ev;
                }
                if sv as libc::c_int == 255 as libc::c_int {
                    ev = 0 as libc::c_int as uint8_t;
                    sv = ev;
                }
                k += 1;
                k;
            }
            j += 1;
            j;
        }
        if light4flag != 0 {
            idx += 5 as libc::c_int;
        } else {
            idx += 1;
            idx;
        }
        i += 1;
        i;
    }
    j = 0 as libc::c_int;
    while j < 256 as libc::c_int {
        let fresh4 = pLT;
        pLT = pLT.offset(1);
        *fresh4 = 0 as libc::c_int as uint8_t;
        j += 1;
        j;
    }
    if leveltype as libc::c_int == 4 as libc::c_int {
        let mut bloodfadehold: [uint8_t; 16] = [0; 16];
        pLT = pLightTbl;
        i = 0 as libc::c_int;
        while i < tlen {
            let mut d_0: libc::c_int = tlen - i;
            let mut a_0: libc::c_int = tlen / d_0;
            let mut r: libc::c_int = tlen % d_0;
            let mut tr: libc::c_int = d_0;
            let mut ta: libc::c_int = 0 as libc::c_int;
            sv = 1 as libc::c_int as uint8_t;
            bloodfadehold[0 as libc::c_int as usize] = 0 as libc::c_int as uint8_t;
            k = 1 as libc::c_int;
            while k < 16 as libc::c_int {
                bloodfadehold[k as usize] = sv;
                tr += r;
                if tr > d_0 && k < 15 as libc::c_int {
                    k += 1;
                    k;
                    tr -= d_0;
                    bloodfadehold[k as usize] = sv;
                }
                ta += 1;
                ta;
                if ta == a_0 {
                    sv = sv.wrapping_add(1);
                    sv;
                    ta = 0 as libc::c_int;
                }
                k += 1;
                k;
            }
            let fresh5 = pLT;
            pLT = pLT.offset(1);
            *fresh5 = 0 as libc::c_int as uint8_t;
            k = 1 as libc::c_int;
            while k < 16 as libc::c_int {
                let fresh6 = pLT;
                pLT = pLT.offset(1);
                *fresh6 = bloodfadehold[k as usize];
                k += 1;
                k;
            }
            k = 15 as libc::c_int;
            while k > 0 as libc::c_int {
                let fresh7 = pLT;
                pLT = pLT.offset(1);
                *fresh7 = bloodfadehold[k as usize];
                k -= 1;
                k;
            }
            *pLT = 1 as libc::c_int as uint8_t;
            pLT = pLT.offset(225 as libc::c_int as isize);
            i += 1;
            i;
        }
        let fresh8 = pLT;
        pLT = pLT.offset(1);
        *fresh8 = 0 as libc::c_int as uint8_t;
        j = 1 as libc::c_int;
        while j < 32 as libc::c_int {
            let fresh9 = pLT;
            pLT = pLT.offset(1);
            *fresh9 = 1 as libc::c_int as uint8_t;
            j += 1;
            j;
        }
        pLT = pLT.offset(224 as libc::c_int as isize);
    }
    InfraTemp = LoadFileInMem(
        b"PlrGFX\\Infra.TRN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    itp = InfraTemp;
    j = 0 as libc::c_int;
    while j < 256 as libc::c_int {
        *pLT = *itp;
        pLT = pLT.offset(1);
        pLT;
        itp = itp.offset(1);
        itp;
        j += 1;
        j;
    }
    let mut p__p: *mut libc::c_void = InfraTemp as *mut libc::c_void;
    InfraTemp = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    InfraTemp = LoadFileInMem(
        b"PlrGFX\\Stone.TRN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    itp = InfraTemp;
    j = 0 as libc::c_int;
    while j < 256 as libc::c_int {
        *pLT = *itp;
        pLT = pLT.offset(1);
        pLT;
        itp = itp.offset(1);
        itp;
        j += 1;
        j;
    }
    let mut p__p_0: *mut libc::c_void = InfraTemp as *mut libc::c_void;
    InfraTemp = 0 as *mut uint8_t;
    mem_free_dbg(p__p_0);
    j = 0 as libc::c_int;
    while j < 8 as libc::c_int {
        sv = (PAUSEBANDS as libc::c_int + 2 as libc::c_int) as uint8_t;
        while (sv as libc::c_int) < PAUSEBANDE as libc::c_int {
            if j == 0 as libc::c_int
                && sv as libc::c_int == PAUSEBANDS as libc::c_int + 2 as libc::c_int
            {
                let fresh10 = pLT;
                pLT = pLT.offset(1);
                *fresh10 = 0 as libc::c_int as uint8_t;
            } else {
                let fresh11 = pLT;
                pLT = pLT.offset(1);
                *fresh11 = sv;
            }
            sv = sv.wrapping_add(1);
            sv;
        }
        let fresh12 = pLT;
        pLT = pLT.offset(1);
        *fresh12 = 0 as libc::c_int as uint8_t;
        let fresh13 = pLT;
        pLT = pLT.offset(1);
        *fresh13 = 0 as libc::c_int as uint8_t;
        let fresh14 = pLT;
        pLT = pLT.offset(1);
        *fresh14 = 0 as libc::c_int as uint8_t;
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < 4 as libc::c_int {
        sv = PAUSEBANDS as libc::c_int as uint8_t;
        i = PAUSEBANDS as libc::c_int;
        while i < PAUSEBANDE as libc::c_int {
            let fresh15 = pLT;
            pLT = pLT.offset(1);
            *fresh15 = sv;
            sv = (sv as libc::c_int + 2 as libc::c_int) as uint8_t;
            i += 2 as libc::c_int;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < 6 as libc::c_int {
        sv = PAUSEBANDS as libc::c_int as uint8_t;
        while (sv as libc::c_int) < PAUSEBANDE as libc::c_int {
            let fresh16 = pLT;
            pLT = pLT.offset(1);
            *fresh16 = sv;
            sv = sv.wrapping_add(1);
            sv;
        }
        let fresh17 = pLT;
        pLT = pLT.offset(1);
        *fresh17 = 0 as libc::c_int as uint8_t;
        j += 1;
        j;
    }
    rad = 0 as libc::c_int;
    while rad < 16 as libc::c_int {
        i = 0 as libc::c_int;
        while i < 128 as libc::c_int {
            if i > 8 as libc::c_int * (rad + 1 as libc::c_int) {
                LightLvls[rad as usize][i as usize] = 15 as libc::c_int as uint8_t;
            } else {
                ftmp = 15 as libc::c_int as libc::c_double * i as libc::c_double
                    / (8 as libc::c_int as libc::c_double
                        * (rad + 1 as libc::c_int) as libc::c_double);
                LightLvls[rad as usize][i as usize] = (ftmp + 0.5f64) as uint8_t;
            }
            i += 1;
            i;
        }
        rad += 1;
        rad;
    }
    j = 0 as libc::c_int;
    while j < 8 as libc::c_int {
        i = 0 as libc::c_int;
        while i < 8 as libc::c_int {
            d = i + j * 8 as libc::c_int;
            y = 0 as libc::c_int;
            while y < 16 as libc::c_int {
                x = 0 as libc::c_int;
                while x < 16 as libc::c_int {
                    a = (x << 3 as libc::c_int) - i;
                    b = (y << 3 as libc::c_int) - j;
                    ftmp = sqrt((a * a + b * b) as libc::c_double) as uint8_t
                        as libc::c_double;
                    if ftmp < 0 as libc::c_int as libc::c_double {
                        ftmp -= 0.5f64;
                    } else {
                        ftmp += 0.5f64;
                    }
                    Dist[d
                        as usize][(x + 16 as libc::c_int * y)
                        as usize] = ftmp as uint8_t;
                    x += 1;
                    x;
                }
                y += 1;
                y;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn MakeLightTable_gouraud() {
    let mut j: libc::c_int = 0;
    let mut InfraTemp: *mut uint8_t = 0 as *mut uint8_t;
    let mut itp: *mut uint8_t = 0 as *mut uint8_t;
    let mut pLT: *mut uint8_t = 0 as *mut uint8_t;
    pLT = pLightTbl;
    pLT = pLT.offset((16 as libc::c_int * 256 as libc::c_int) as isize);
    InfraTemp = LoadFileInMem(
        b"PlrGFX\\Infra.TRN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    itp = InfraTemp;
    j = 0 as libc::c_int;
    while j < 256 as libc::c_int {
        let fresh18 = itp;
        itp = itp.offset(1);
        let fresh19 = pLT;
        pLT = pLT.offset(1);
        *fresh19 = *fresh18;
        j += 1;
        j;
    }
    let mut p__p: *mut libc::c_void = InfraTemp as *mut libc::c_void;
    InfraTemp = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    InfraTemp = LoadFileInMem(
        b"PlrGFX\\Stone.TRN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    itp = InfraTemp;
    j = 0 as libc::c_int;
    while j < 256 as libc::c_int {
        let fresh20 = itp;
        itp = itp.offset(1);
        let fresh21 = pLT;
        pLT = pLT.offset(1);
        *fresh21 = *fresh20;
        j += 1;
        j;
    }
    let mut p__p_0: *mut libc::c_void = InfraTemp as *mut libc::c_void;
    InfraTemp = 0 as *mut uint8_t;
    mem_free_dbg(p__p_0);
}
#[no_mangle]
pub unsafe extern "C" fn MakeLightTable() {
    if ORIG_LIGHTING as libc::c_int != 0 {
        MakeLightTable_orig_lighting();
    } else {
        MakeLightTable_gouraud();
    };
}
#[no_mangle]
pub unsafe extern "C" fn ResetLight() {
    if lightflag == 0 as libc::c_int {
        memset(
            dLight.as_mut_ptr() as *mut libc::c_void,
            lightmax as libc::c_int,
            ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
        );
        let mut i: libc::c_int = 0 as libc::c_int;
        while i < MAX_PLRS as libc::c_int {
            if !(plr[i as usize].plractive == 0) {
                if !(currlevel as libc::c_int != plr[i as usize].plrlevel) {
                    DoLighting(
                        plr[i as usize]._px,
                        plr[i as usize]._py,
                        plr[i as usize]._pLightRad as libc::c_int,
                        -(1 as libc::c_int),
                    );
                }
            }
            i += 1;
            i;
        }
    } else {
        memset(
            dLight.as_mut_ptr() as *mut libc::c_void,
            0 as libc::c_int,
            ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
        );
    };
}
#[no_mangle]
pub unsafe extern "C" fn ToggleLight() {
    lightflag ^= 1 as libc::c_int;
    if ORIG_LIGHTING as libc::c_int != 0 {
        if lightflag == 0 as libc::c_int {
            memcpy(
                dLight.as_mut_ptr() as *mut libc::c_void,
                dSaveLight.as_mut_ptr() as *const libc::c_void,
                ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
            );
            let mut i: libc::c_int = 0 as libc::c_int;
            while i < MAX_PLRS as libc::c_int {
                if !(plr[i as usize].plractive == 0) {
                    if !(currlevel as libc::c_int != plr[i as usize].plrlevel) {
                        DoLighting(
                            plr[i as usize]._px,
                            plr[i as usize]._py,
                            plr[i as usize]._pLightRad as libc::c_int,
                            -(1 as libc::c_int),
                        );
                    }
                }
                i += 1;
                i;
            }
        } else {
            memset(
                dLight.as_mut_ptr() as *mut libc::c_void,
                0 as libc::c_int,
                ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
            );
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn InitLightMax() {
    if light4flag != 0 {
        lightmax = 3 as libc::c_int as int8_t;
    } else {
        lightmax = 15 as libc::c_int as int8_t;
    };
}
#[no_mangle]
pub unsafe extern "C" fn InitLighting() {
    let mut i: libc::c_int = 0;
    numlights = 0 as libc::c_int;
    if ORIG_LIGHTING as libc::c_int != 0 {
        dolighting = 0 as libc::c_int as bool32_t;
    }
    lightflag = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < MAXLIGHTS as libc::c_int {
        lightactive[i as usize] = i as uint8_t;
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn AddLight(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut r: libc::c_int,
) -> libc::c_int {
    let mut lid: libc::c_int = 0;
    if lightflag != 0 as libc::c_int {
        return -(1 as libc::c_int);
    }
    lid = -(1 as libc::c_int);
    if numlights < MAXLIGHTS as libc::c_int {
        let fresh22 = numlights;
        numlights = numlights + 1;
        lid = lightactive[fresh22 as usize] as libc::c_int;
        memset(
            &mut *LightList.as_mut_ptr().offset(lid as isize) as *mut LightListStruct
                as *mut libc::c_void,
            0 as libc::c_int,
            ::core::mem::size_of::<LightListStruct>() as libc::c_ulong,
        );
        LightList[lid as usize]._lx = x;
        LightList[lid as usize]._ly = y;
        LightList[lid as usize]._lradius = r;
        LightList[lid as usize]._xoff = 0 as libc::c_int;
        LightList[lid as usize]._yoff = 0 as libc::c_int;
        LightList[lid as usize]._ldel = 0 as libc::c_int as bool32_t;
        LightList[lid as usize]._lunflag = 0 as libc::c_int as bool32_t;
        if ORIG_LIGHTING as libc::c_int != 0 {
            dolighting = 1 as libc::c_int as bool32_t;
        }
    }
    return lid;
}
#[no_mangle]
pub unsafe extern "C" fn AddUnLight(mut i: libc::c_int) {
    if lightflag != 0 as libc::c_int {
        return;
    }
    if i == -(1 as libc::c_int) {
        return;
    }
    LightList[i as usize]._ldel = 1 as libc::c_int as bool32_t;
    if ORIG_LIGHTING as libc::c_int != 0 {
        dolighting = 1 as libc::c_int as bool32_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ChangeLightRadius(mut i: libc::c_int, mut r: libc::c_int) {
    if lightflag != 0 as libc::c_int {
        return;
    }
    if i == -(1 as libc::c_int) {
        return;
    }
    LightList[i as usize]._lunflag = 1 as libc::c_int as bool32_t;
    LightList[i as usize]._lunx = LightList[i as usize]._lx;
    LightList[i as usize]._luny = LightList[i as usize]._ly;
    LightList[i as usize]._lunr = LightList[i as usize]._lradius;
    LightList[i as usize]._lradius = r;
    if ORIG_LIGHTING as libc::c_int != 0 {
        dolighting = 1 as libc::c_int as bool32_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ChangeLightXY(
    mut i: libc::c_int,
    mut x: libc::c_int,
    mut y: libc::c_int,
) {
    if lightflag != 0 as libc::c_int {
        return;
    }
    if i == -(1 as libc::c_int) {
        return;
    }
    LightList[i as usize]._lunflag = 1 as libc::c_int as bool32_t;
    LightList[i as usize]._lunx = LightList[i as usize]._lx;
    LightList[i as usize]._luny = LightList[i as usize]._ly;
    LightList[i as usize]._lunr = LightList[i as usize]._lradius;
    LightList[i as usize]._lx = x;
    LightList[i as usize]._ly = y;
    if ORIG_LIGHTING as libc::c_int != 0 {
        dolighting = 1 as libc::c_int as bool32_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ChangeLightOff(
    mut i: libc::c_int,
    mut x: libc::c_int,
    mut y: libc::c_int,
) {
    if lightflag != 0 as libc::c_int {
        return;
    }
    if i == -(1 as libc::c_int) {
        return;
    }
    LightList[i as usize]._lunflag = 1 as libc::c_int as bool32_t;
    LightList[i as usize]._lunx = LightList[i as usize]._lx;
    LightList[i as usize]._luny = LightList[i as usize]._ly;
    LightList[i as usize]._lunr = LightList[i as usize]._lradius;
    LightList[i as usize]._xoff = x;
    LightList[i as usize]._yoff = y;
    if ORIG_LIGHTING as libc::c_int != 0 {
        dolighting = 1 as libc::c_int as bool32_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ChangeLight(
    mut i: libc::c_int,
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut r: libc::c_int,
) {
    if lightflag != 0 as libc::c_int {
        return;
    }
    if i == -(1 as libc::c_int) {
        return;
    }
    LightList[i as usize]._lunflag = 1 as libc::c_int as bool32_t;
    LightList[i as usize]._lunx = LightList[i as usize]._lx;
    LightList[i as usize]._luny = LightList[i as usize]._ly;
    LightList[i as usize]._lunr = LightList[i as usize]._lradius;
    LightList[i as usize]._lx = x;
    LightList[i as usize]._ly = y;
    LightList[i as usize]._lradius = r;
    if ORIG_LIGHTING as libc::c_int != 0 {
        dolighting = 1 as libc::c_int as bool32_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ProcessLightList_orig_lighting() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut temp: uint8_t = 0;
    if lightflag != 0 as libc::c_int {
        return;
    }
    if dolighting != 0 {
        j = 0 as libc::c_int;
        while j < numlights {
            i = lightactive[j as usize] as libc::c_int;
            if LightList[i as usize]._ldel != 0 {
                DoUnLight(
                    LightList[i as usize]._lx,
                    LightList[i as usize]._ly,
                    LightList[i as usize]._lradius,
                );
            }
            if LightList[i as usize]._lunflag != 0 {
                DoUnLight(
                    LightList[i as usize]._lunx,
                    LightList[i as usize]._luny,
                    LightList[i as usize]._lunr,
                );
                LightList[i as usize]._lunflag = 0 as libc::c_int as bool32_t;
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < numlights {
            i = lightactive[j as usize] as libc::c_int;
            if LightList[i as usize]._ldel == 0 {
                DoLighting(
                    LightList[i as usize]._lx,
                    LightList[i as usize]._ly,
                    LightList[i as usize]._lradius,
                    i,
                );
            }
            j += 1;
            j;
        }
        j = 0 as libc::c_int;
        while j < numlights {
            i = lightactive[j as usize] as libc::c_int;
            if LightList[i as usize]._ldel != 0 {
                numlights -= 1;
                temp = lightactive[numlights as usize];
                lightactive[numlights as usize] = lightactive[j as usize];
                lightactive[j as usize] = temp;
            } else {
                j += 1;
                j;
            }
        }
    }
    dolighting = 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn ProcessLightList_gouraud() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut temp: uint8_t = 0;
    if lightflag != 0 as libc::c_int {
        return;
    }
    DoUnLight_gouraud();
    if leveltype as libc::c_int == 3 as libc::c_int && setlevel == 0 {
        DoLavaLight();
    }
    j = 0 as libc::c_int;
    while j < numlights {
        i = lightactive[j as usize] as libc::c_int;
        if LightList[i as usize]._ldel == 0 {
            DoLighting(
                LightList[i as usize]._lx,
                LightList[i as usize]._ly,
                LightList[i as usize]._lradius,
                i,
            );
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < numlights {
        i = lightactive[j as usize] as libc::c_int;
        if LightList[i as usize]._ldel != 0 {
            numlights -= 1;
            temp = lightactive[numlights as usize];
            lightactive[numlights as usize] = lightactive[j as usize];
            lightactive[j as usize] = temp;
        } else {
            j += 1;
            j;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn ProcessLightList() {
    if ORIG_LIGHTING as libc::c_int != 0 {
        ProcessLightList_orig_lighting();
    } else {
        ProcessLightList_gouraud();
    };
}
#[no_mangle]
pub unsafe extern "C" fn SavePreLighting() {
    memcpy(
        dSaveLight.as_mut_ptr() as *mut libc::c_void,
        dLight.as_mut_ptr() as *const libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
    );
}
#[no_mangle]
pub unsafe extern "C" fn InitVision() {
    let mut i: libc::c_int = 0;
    numvision = 0 as libc::c_int;
    dovision = 0 as libc::c_int as bool32_t;
    visionid = 1 as libc::c_int;
    i = 0 as libc::c_int;
    while i < TransVal as libc::c_int {
        TransList[i as usize] = 0 as libc::c_int as uint8_t;
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn AddVision(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut r: libc::c_int,
    mut mine: bool32_t,
) -> libc::c_int {
    let mut vid: libc::c_int = -(1 as libc::c_int);
    if numvision < MAXVISION as libc::c_int {
        memset(
            &mut *VisionList.as_mut_ptr().offset(numvision as isize)
                as *mut LightListStruct as *mut libc::c_void,
            0 as libc::c_int,
            ::core::mem::size_of::<LightListStruct>() as libc::c_ulong,
        );
        VisionList[numvision as usize]._lx = x;
        VisionList[numvision as usize]._ly = y;
        VisionList[numvision as usize]._lradius = r;
        let fresh23 = visionid;
        visionid = visionid + 1;
        vid = fresh23;
        VisionList[numvision as usize]._lid = vid;
        VisionList[numvision as usize]._ldel = 0 as libc::c_int as bool32_t;
        VisionList[numvision as usize]._lunflag = 0 as libc::c_int as bool32_t;
        VisionList[numvision as usize]
            ._lflags = (if mine != 0 {
            LFLAG_MINE as libc::c_int
        } else {
            0 as libc::c_int
        }) as bool32_t;
        numvision += 1;
        numvision;
        dovision = 1 as libc::c_int as bool32_t;
    }
    return vid;
}
#[no_mangle]
pub unsafe extern "C" fn AddUnVision(mut id: libc::c_int) {
    let mut i: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < numvision {
        if VisionList[i as usize]._lid == id {
            VisionList[i as usize]._ldel = 1 as libc::c_int as bool32_t;
            dovision = 1 as libc::c_int as bool32_t;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ChangeVisionRadius(mut id: libc::c_int, mut r: libc::c_int) {
    let mut i: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < numvision {
        if VisionList[i as usize]._lid == id {
            VisionList[i as usize]._lunflag = 1 as libc::c_int as bool32_t;
            VisionList[i as usize]._lunx = VisionList[i as usize]._lx;
            VisionList[i as usize]._luny = VisionList[i as usize]._ly;
            VisionList[i as usize]._lunr = VisionList[i as usize]._lradius;
            VisionList[i as usize]._lradius = r;
            dovision = 1 as libc::c_int as bool32_t;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ChangeVisionXY(
    mut id: libc::c_int,
    mut x: libc::c_int,
    mut y: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < numvision {
        if VisionList[i as usize]._lid == id {
            VisionList[i as usize]._lunflag = 1 as libc::c_int as bool32_t;
            VisionList[i as usize]._lunx = VisionList[i as usize]._lx;
            VisionList[i as usize]._luny = VisionList[i as usize]._ly;
            VisionList[i as usize]._lunr = VisionList[i as usize]._lradius;
            VisionList[i as usize]._lx = x;
            VisionList[i as usize]._ly = y;
            dovision = 1 as libc::c_int as bool32_t;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ChangeVision(
    mut id: libc::c_int,
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut r: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < numvision {
        if VisionList[i as usize]._lid == id {
            VisionList[i as usize]._lunflag = 1 as libc::c_int as bool32_t;
            VisionList[i as usize]._lunx = VisionList[i as usize]._lx;
            VisionList[i as usize]._luny = VisionList[i as usize]._ly;
            VisionList[i as usize]._lunr = VisionList[i as usize]._lradius;
            VisionList[i as usize]._lx = x;
            VisionList[i as usize]._ly = y;
            VisionList[i as usize]._lradius = r;
            dovision = 1 as libc::c_int as bool32_t;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn ProcessVisionList() {
    let mut i: libc::c_int = 0;
    let mut delflag: bool32_t = 0;
    if dovision != 0 {
        i = 0 as libc::c_int;
        while i < numvision {
            if VisionList[i as usize]._ldel != 0 {
                DoUnVision(
                    VisionList[i as usize]._lx,
                    VisionList[i as usize]._ly,
                    VisionList[i as usize]._lradius,
                );
            }
            if VisionList[i as usize]._lunflag != 0 {
                DoUnVision(
                    VisionList[i as usize]._lunx,
                    VisionList[i as usize]._luny,
                    VisionList[i as usize]._lunr,
                );
                VisionList[i as usize]._lunflag = 0 as libc::c_int as bool32_t;
            }
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < TransVal as libc::c_int {
            TransList[i as usize] = 0 as libc::c_int as uint8_t;
            i += 1;
            i;
        }
        i = 0 as libc::c_int;
        while i < numvision {
            if VisionList[i as usize]._ldel == 0 {
                DoVision(
                    VisionList[i as usize]._lx,
                    VisionList[i as usize]._ly,
                    VisionList[i as usize]._lradius,
                    VisionList[i as usize]._lflags
                        & LFLAG_MINE as libc::c_int as bool32_t,
                    VisionList[i as usize]._lflags
                        & LFLAG_MINE as libc::c_int as bool32_t,
                );
            }
            i += 1;
            i;
        }
        loop {
            delflag = 0 as libc::c_int as bool32_t;
            i = 0 as libc::c_int;
            while i < numvision {
                if VisionList[i as usize]._ldel != 0 {
                    numvision -= 1;
                    numvision;
                    if numvision > 0 as libc::c_int && i != numvision {
                        VisionList[i as usize] = VisionList[numvision as usize];
                    }
                    delflag = 1 as libc::c_int as bool32_t;
                }
                i += 1;
                i;
            }
            if !(delflag != 0) {
                break;
            }
        }
    }
    dovision = 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn BloodCycle() {
    let mut i: libc::c_int = 0;
    let mut k: libc::c_int = 0;
    let mut tlen: libc::c_int = 0;
    let mut h: uint8_t = 0;
    let mut pLT: *mut uint8_t = 0 as *mut uint8_t;
    pLT = pLightTbl;
    if light4flag != 0 {
        tlen = 4 as libc::c_int;
    } else {
        tlen = 16 as libc::c_int;
    }
    if leveltype as libc::c_int == 4 as libc::c_int {
        pLT = pLightTbl;
        i = 0 as libc::c_int;
        while i < tlen {
            pLT = pLT.offset(1);
            pLT;
            h = *pLT;
            k = 0 as libc::c_int;
            while k < 30 as libc::c_int {
                *pLT = *pLT.offset(1 as libc::c_int as isize);
                pLT = pLT.offset(1);
                pLT;
                k += 1;
                k;
            }
            *pLT = h;
            pLT = pLT.offset(225 as libc::c_int as isize);
            i += 1;
            i;
        }
    }
}
