use ::libc;
extern "C" {
    pub type SDL_SysWMmsg;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn LoadGameLevel(_: bool32_t, _: libc::c_int);
    fn FreeGameMem();
    fn DisableInputWndProc(event: *mut SDL_Event);
    fn sound_init();
    fn DrawCel(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn HandleEvent(event: *mut SDL_Event);
    fn my_SetWindowProc(wndProc: SDLPROC) -> SDLPROC;
    fn GM_LoadGame(firstflag: bool32_t);
    fn SaveLevel();
    fn PrepDoEnding();
    fn DeltaSaveLevel();
    fn NetSendCmdLocParam1(
        bHiPri: bool32_t,
        bCmd: uint8_t,
        x: uint8_t,
        y: uint8_t,
        wParam1: uint16_t,
    );
    fn LoadPalette(pszFileName: *const libc::c_char);
    fn PaletteFadeIn(faderate: libc::c_int);
    fn PaletteFadeOut(faderate: libc::c_int);
    fn BlackPalette();
    fn plrmsg_hold(bStart: bool32_t);
    fn GetPortalLevel();
    fn SetReturnLvlPos();
    fn GetReturnLvlPos();
    fn FullBlit(bArrow: bool32_t);
    fn ClrDraw();
    static mut force_redraw: libc::c_int;
    static mut gnLevelTypeTbl: [libc::c_int; 17];
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut setlevel: uint8_t;
    static mut setlvlnum: uint8_t;
    static mut setlvltype: uint8_t;
    static mut gbMaxPlayers: uint8_t;
    static mut gbSomebodyWonGameKludge: uint8_t;
    static mut gpPalette: [uint32_t; 256];
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut nBuffWTbl: [int32_t; 1024];
    static mut gpBuffer: *mut uint32_t;
    fn inputPollEvent(event: *mut SDL_Event) -> bool32_t;
    fn lock_buf(bFcn: uint8_t);
    fn unlock_buf(bFcn: uint8_t);
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int16_t = libc::c_short;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int16_t = __int16_t;
pub type int32_t = __int32_t;
pub type int64_t = __int64_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type Uint8 = uint8_t;
pub type Sint16 = int16_t;
pub type Uint16 = uint16_t;
pub type Sint32 = int32_t;
pub type Uint32 = uint32_t;
pub type Sint64 = int64_t;
pub type Uint64 = uint64_t;
pub type SDL_Scancode = libc::c_uint;
pub const SDL_NUM_SCANCODES: SDL_Scancode = 512;
pub const SDL_SCANCODE_ENDCALL: SDL_Scancode = 290;
pub const SDL_SCANCODE_CALL: SDL_Scancode = 289;
pub const SDL_SCANCODE_SOFTRIGHT: SDL_Scancode = 288;
pub const SDL_SCANCODE_SOFTLEFT: SDL_Scancode = 287;
pub const SDL_SCANCODE_AUDIOFASTFORWARD: SDL_Scancode = 286;
pub const SDL_SCANCODE_AUDIOREWIND: SDL_Scancode = 285;
pub const SDL_SCANCODE_APP2: SDL_Scancode = 284;
pub const SDL_SCANCODE_APP1: SDL_Scancode = 283;
pub const SDL_SCANCODE_SLEEP: SDL_Scancode = 282;
pub const SDL_SCANCODE_EJECT: SDL_Scancode = 281;
pub const SDL_SCANCODE_KBDILLUMUP: SDL_Scancode = 280;
pub const SDL_SCANCODE_KBDILLUMDOWN: SDL_Scancode = 279;
pub const SDL_SCANCODE_KBDILLUMTOGGLE: SDL_Scancode = 278;
pub const SDL_SCANCODE_DISPLAYSWITCH: SDL_Scancode = 277;
pub const SDL_SCANCODE_BRIGHTNESSUP: SDL_Scancode = 276;
pub const SDL_SCANCODE_BRIGHTNESSDOWN: SDL_Scancode = 275;
pub const SDL_SCANCODE_AC_BOOKMARKS: SDL_Scancode = 274;
pub const SDL_SCANCODE_AC_REFRESH: SDL_Scancode = 273;
pub const SDL_SCANCODE_AC_STOP: SDL_Scancode = 272;
pub const SDL_SCANCODE_AC_FORWARD: SDL_Scancode = 271;
pub const SDL_SCANCODE_AC_BACK: SDL_Scancode = 270;
pub const SDL_SCANCODE_AC_HOME: SDL_Scancode = 269;
pub const SDL_SCANCODE_AC_SEARCH: SDL_Scancode = 268;
pub const SDL_SCANCODE_COMPUTER: SDL_Scancode = 267;
pub const SDL_SCANCODE_CALCULATOR: SDL_Scancode = 266;
pub const SDL_SCANCODE_MAIL: SDL_Scancode = 265;
pub const SDL_SCANCODE_WWW: SDL_Scancode = 264;
pub const SDL_SCANCODE_MEDIASELECT: SDL_Scancode = 263;
pub const SDL_SCANCODE_AUDIOMUTE: SDL_Scancode = 262;
pub const SDL_SCANCODE_AUDIOPLAY: SDL_Scancode = 261;
pub const SDL_SCANCODE_AUDIOSTOP: SDL_Scancode = 260;
pub const SDL_SCANCODE_AUDIOPREV: SDL_Scancode = 259;
pub const SDL_SCANCODE_AUDIONEXT: SDL_Scancode = 258;
pub const SDL_SCANCODE_MODE: SDL_Scancode = 257;
pub const SDL_SCANCODE_RGUI: SDL_Scancode = 231;
pub const SDL_SCANCODE_RALT: SDL_Scancode = 230;
pub const SDL_SCANCODE_RSHIFT: SDL_Scancode = 229;
pub const SDL_SCANCODE_RCTRL: SDL_Scancode = 228;
pub const SDL_SCANCODE_LGUI: SDL_Scancode = 227;
pub const SDL_SCANCODE_LALT: SDL_Scancode = 226;
pub const SDL_SCANCODE_LSHIFT: SDL_Scancode = 225;
pub const SDL_SCANCODE_LCTRL: SDL_Scancode = 224;
pub const SDL_SCANCODE_KP_HEXADECIMAL: SDL_Scancode = 221;
pub const SDL_SCANCODE_KP_DECIMAL: SDL_Scancode = 220;
pub const SDL_SCANCODE_KP_OCTAL: SDL_Scancode = 219;
pub const SDL_SCANCODE_KP_BINARY: SDL_Scancode = 218;
pub const SDL_SCANCODE_KP_CLEARENTRY: SDL_Scancode = 217;
pub const SDL_SCANCODE_KP_CLEAR: SDL_Scancode = 216;
pub const SDL_SCANCODE_KP_PLUSMINUS: SDL_Scancode = 215;
pub const SDL_SCANCODE_KP_MEMDIVIDE: SDL_Scancode = 214;
pub const SDL_SCANCODE_KP_MEMMULTIPLY: SDL_Scancode = 213;
pub const SDL_SCANCODE_KP_MEMSUBTRACT: SDL_Scancode = 212;
pub const SDL_SCANCODE_KP_MEMADD: SDL_Scancode = 211;
pub const SDL_SCANCODE_KP_MEMCLEAR: SDL_Scancode = 210;
pub const SDL_SCANCODE_KP_MEMRECALL: SDL_Scancode = 209;
pub const SDL_SCANCODE_KP_MEMSTORE: SDL_Scancode = 208;
pub const SDL_SCANCODE_KP_EXCLAM: SDL_Scancode = 207;
pub const SDL_SCANCODE_KP_AT: SDL_Scancode = 206;
pub const SDL_SCANCODE_KP_SPACE: SDL_Scancode = 205;
pub const SDL_SCANCODE_KP_HASH: SDL_Scancode = 204;
pub const SDL_SCANCODE_KP_COLON: SDL_Scancode = 203;
pub const SDL_SCANCODE_KP_DBLVERTICALBAR: SDL_Scancode = 202;
pub const SDL_SCANCODE_KP_VERTICALBAR: SDL_Scancode = 201;
pub const SDL_SCANCODE_KP_DBLAMPERSAND: SDL_Scancode = 200;
pub const SDL_SCANCODE_KP_AMPERSAND: SDL_Scancode = 199;
pub const SDL_SCANCODE_KP_GREATER: SDL_Scancode = 198;
pub const SDL_SCANCODE_KP_LESS: SDL_Scancode = 197;
pub const SDL_SCANCODE_KP_PERCENT: SDL_Scancode = 196;
pub const SDL_SCANCODE_KP_POWER: SDL_Scancode = 195;
pub const SDL_SCANCODE_KP_XOR: SDL_Scancode = 194;
pub const SDL_SCANCODE_KP_F: SDL_Scancode = 193;
pub const SDL_SCANCODE_KP_E: SDL_Scancode = 192;
pub const SDL_SCANCODE_KP_D: SDL_Scancode = 191;
pub const SDL_SCANCODE_KP_C: SDL_Scancode = 190;
pub const SDL_SCANCODE_KP_B: SDL_Scancode = 189;
pub const SDL_SCANCODE_KP_A: SDL_Scancode = 188;
pub const SDL_SCANCODE_KP_BACKSPACE: SDL_Scancode = 187;
pub const SDL_SCANCODE_KP_TAB: SDL_Scancode = 186;
pub const SDL_SCANCODE_KP_RIGHTBRACE: SDL_Scancode = 185;
pub const SDL_SCANCODE_KP_LEFTBRACE: SDL_Scancode = 184;
pub const SDL_SCANCODE_KP_RIGHTPAREN: SDL_Scancode = 183;
pub const SDL_SCANCODE_KP_LEFTPAREN: SDL_Scancode = 182;
pub const SDL_SCANCODE_CURRENCYSUBUNIT: SDL_Scancode = 181;
pub const SDL_SCANCODE_CURRENCYUNIT: SDL_Scancode = 180;
pub const SDL_SCANCODE_DECIMALSEPARATOR: SDL_Scancode = 179;
pub const SDL_SCANCODE_THOUSANDSSEPARATOR: SDL_Scancode = 178;
pub const SDL_SCANCODE_KP_000: SDL_Scancode = 177;
pub const SDL_SCANCODE_KP_00: SDL_Scancode = 176;
pub const SDL_SCANCODE_EXSEL: SDL_Scancode = 164;
pub const SDL_SCANCODE_CRSEL: SDL_Scancode = 163;
pub const SDL_SCANCODE_CLEARAGAIN: SDL_Scancode = 162;
pub const SDL_SCANCODE_OPER: SDL_Scancode = 161;
pub const SDL_SCANCODE_OUT: SDL_Scancode = 160;
pub const SDL_SCANCODE_SEPARATOR: SDL_Scancode = 159;
pub const SDL_SCANCODE_RETURN2: SDL_Scancode = 158;
pub const SDL_SCANCODE_PRIOR: SDL_Scancode = 157;
pub const SDL_SCANCODE_CLEAR: SDL_Scancode = 156;
pub const SDL_SCANCODE_CANCEL: SDL_Scancode = 155;
pub const SDL_SCANCODE_SYSREQ: SDL_Scancode = 154;
pub const SDL_SCANCODE_ALTERASE: SDL_Scancode = 153;
pub const SDL_SCANCODE_LANG9: SDL_Scancode = 152;
pub const SDL_SCANCODE_LANG8: SDL_Scancode = 151;
pub const SDL_SCANCODE_LANG7: SDL_Scancode = 150;
pub const SDL_SCANCODE_LANG6: SDL_Scancode = 149;
pub const SDL_SCANCODE_LANG5: SDL_Scancode = 148;
pub const SDL_SCANCODE_LANG4: SDL_Scancode = 147;
pub const SDL_SCANCODE_LANG3: SDL_Scancode = 146;
pub const SDL_SCANCODE_LANG2: SDL_Scancode = 145;
pub const SDL_SCANCODE_LANG1: SDL_Scancode = 144;
pub const SDL_SCANCODE_INTERNATIONAL9: SDL_Scancode = 143;
pub const SDL_SCANCODE_INTERNATIONAL8: SDL_Scancode = 142;
pub const SDL_SCANCODE_INTERNATIONAL7: SDL_Scancode = 141;
pub const SDL_SCANCODE_INTERNATIONAL6: SDL_Scancode = 140;
pub const SDL_SCANCODE_INTERNATIONAL5: SDL_Scancode = 139;
pub const SDL_SCANCODE_INTERNATIONAL4: SDL_Scancode = 138;
pub const SDL_SCANCODE_INTERNATIONAL3: SDL_Scancode = 137;
pub const SDL_SCANCODE_INTERNATIONAL2: SDL_Scancode = 136;
pub const SDL_SCANCODE_INTERNATIONAL1: SDL_Scancode = 135;
pub const SDL_SCANCODE_KP_EQUALSAS400: SDL_Scancode = 134;
pub const SDL_SCANCODE_KP_COMMA: SDL_Scancode = 133;
pub const SDL_SCANCODE_VOLUMEDOWN: SDL_Scancode = 129;
pub const SDL_SCANCODE_VOLUMEUP: SDL_Scancode = 128;
pub const SDL_SCANCODE_MUTE: SDL_Scancode = 127;
pub const SDL_SCANCODE_FIND: SDL_Scancode = 126;
pub const SDL_SCANCODE_PASTE: SDL_Scancode = 125;
pub const SDL_SCANCODE_COPY: SDL_Scancode = 124;
pub const SDL_SCANCODE_CUT: SDL_Scancode = 123;
pub const SDL_SCANCODE_UNDO: SDL_Scancode = 122;
pub const SDL_SCANCODE_AGAIN: SDL_Scancode = 121;
pub const SDL_SCANCODE_STOP: SDL_Scancode = 120;
pub const SDL_SCANCODE_SELECT: SDL_Scancode = 119;
pub const SDL_SCANCODE_MENU: SDL_Scancode = 118;
pub const SDL_SCANCODE_HELP: SDL_Scancode = 117;
pub const SDL_SCANCODE_EXECUTE: SDL_Scancode = 116;
pub const SDL_SCANCODE_F24: SDL_Scancode = 115;
pub const SDL_SCANCODE_F23: SDL_Scancode = 114;
pub const SDL_SCANCODE_F22: SDL_Scancode = 113;
pub const SDL_SCANCODE_F21: SDL_Scancode = 112;
pub const SDL_SCANCODE_F20: SDL_Scancode = 111;
pub const SDL_SCANCODE_F19: SDL_Scancode = 110;
pub const SDL_SCANCODE_F18: SDL_Scancode = 109;
pub const SDL_SCANCODE_F17: SDL_Scancode = 108;
pub const SDL_SCANCODE_F16: SDL_Scancode = 107;
pub const SDL_SCANCODE_F15: SDL_Scancode = 106;
pub const SDL_SCANCODE_F14: SDL_Scancode = 105;
pub const SDL_SCANCODE_F13: SDL_Scancode = 104;
pub const SDL_SCANCODE_KP_EQUALS: SDL_Scancode = 103;
pub const SDL_SCANCODE_POWER: SDL_Scancode = 102;
pub const SDL_SCANCODE_APPLICATION: SDL_Scancode = 101;
pub const SDL_SCANCODE_NONUSBACKSLASH: SDL_Scancode = 100;
pub const SDL_SCANCODE_KP_PERIOD: SDL_Scancode = 99;
pub const SDL_SCANCODE_KP_0: SDL_Scancode = 98;
pub const SDL_SCANCODE_KP_9: SDL_Scancode = 97;
pub const SDL_SCANCODE_KP_8: SDL_Scancode = 96;
pub const SDL_SCANCODE_KP_7: SDL_Scancode = 95;
pub const SDL_SCANCODE_KP_6: SDL_Scancode = 94;
pub const SDL_SCANCODE_KP_5: SDL_Scancode = 93;
pub const SDL_SCANCODE_KP_4: SDL_Scancode = 92;
pub const SDL_SCANCODE_KP_3: SDL_Scancode = 91;
pub const SDL_SCANCODE_KP_2: SDL_Scancode = 90;
pub const SDL_SCANCODE_KP_1: SDL_Scancode = 89;
pub const SDL_SCANCODE_KP_ENTER: SDL_Scancode = 88;
pub const SDL_SCANCODE_KP_PLUS: SDL_Scancode = 87;
pub const SDL_SCANCODE_KP_MINUS: SDL_Scancode = 86;
pub const SDL_SCANCODE_KP_MULTIPLY: SDL_Scancode = 85;
pub const SDL_SCANCODE_KP_DIVIDE: SDL_Scancode = 84;
pub const SDL_SCANCODE_NUMLOCKCLEAR: SDL_Scancode = 83;
pub const SDL_SCANCODE_UP: SDL_Scancode = 82;
pub const SDL_SCANCODE_DOWN: SDL_Scancode = 81;
pub const SDL_SCANCODE_LEFT: SDL_Scancode = 80;
pub const SDL_SCANCODE_RIGHT: SDL_Scancode = 79;
pub const SDL_SCANCODE_PAGEDOWN: SDL_Scancode = 78;
pub const SDL_SCANCODE_END: SDL_Scancode = 77;
pub const SDL_SCANCODE_DELETE: SDL_Scancode = 76;
pub const SDL_SCANCODE_PAGEUP: SDL_Scancode = 75;
pub const SDL_SCANCODE_HOME: SDL_Scancode = 74;
pub const SDL_SCANCODE_INSERT: SDL_Scancode = 73;
pub const SDL_SCANCODE_PAUSE: SDL_Scancode = 72;
pub const SDL_SCANCODE_SCROLLLOCK: SDL_Scancode = 71;
pub const SDL_SCANCODE_PRINTSCREEN: SDL_Scancode = 70;
pub const SDL_SCANCODE_F12: SDL_Scancode = 69;
pub const SDL_SCANCODE_F11: SDL_Scancode = 68;
pub const SDL_SCANCODE_F10: SDL_Scancode = 67;
pub const SDL_SCANCODE_F9: SDL_Scancode = 66;
pub const SDL_SCANCODE_F8: SDL_Scancode = 65;
pub const SDL_SCANCODE_F7: SDL_Scancode = 64;
pub const SDL_SCANCODE_F6: SDL_Scancode = 63;
pub const SDL_SCANCODE_F5: SDL_Scancode = 62;
pub const SDL_SCANCODE_F4: SDL_Scancode = 61;
pub const SDL_SCANCODE_F3: SDL_Scancode = 60;
pub const SDL_SCANCODE_F2: SDL_Scancode = 59;
pub const SDL_SCANCODE_F1: SDL_Scancode = 58;
pub const SDL_SCANCODE_CAPSLOCK: SDL_Scancode = 57;
pub const SDL_SCANCODE_SLASH: SDL_Scancode = 56;
pub const SDL_SCANCODE_PERIOD: SDL_Scancode = 55;
pub const SDL_SCANCODE_COMMA: SDL_Scancode = 54;
pub const SDL_SCANCODE_GRAVE: SDL_Scancode = 53;
pub const SDL_SCANCODE_APOSTROPHE: SDL_Scancode = 52;
pub const SDL_SCANCODE_SEMICOLON: SDL_Scancode = 51;
pub const SDL_SCANCODE_NONUSHASH: SDL_Scancode = 50;
pub const SDL_SCANCODE_BACKSLASH: SDL_Scancode = 49;
pub const SDL_SCANCODE_RIGHTBRACKET: SDL_Scancode = 48;
pub const SDL_SCANCODE_LEFTBRACKET: SDL_Scancode = 47;
pub const SDL_SCANCODE_EQUALS: SDL_Scancode = 46;
pub const SDL_SCANCODE_MINUS: SDL_Scancode = 45;
pub const SDL_SCANCODE_SPACE: SDL_Scancode = 44;
pub const SDL_SCANCODE_TAB: SDL_Scancode = 43;
pub const SDL_SCANCODE_BACKSPACE: SDL_Scancode = 42;
pub const SDL_SCANCODE_ESCAPE: SDL_Scancode = 41;
pub const SDL_SCANCODE_RETURN: SDL_Scancode = 40;
pub const SDL_SCANCODE_0: SDL_Scancode = 39;
pub const SDL_SCANCODE_9: SDL_Scancode = 38;
pub const SDL_SCANCODE_8: SDL_Scancode = 37;
pub const SDL_SCANCODE_7: SDL_Scancode = 36;
pub const SDL_SCANCODE_6: SDL_Scancode = 35;
pub const SDL_SCANCODE_5: SDL_Scancode = 34;
pub const SDL_SCANCODE_4: SDL_Scancode = 33;
pub const SDL_SCANCODE_3: SDL_Scancode = 32;
pub const SDL_SCANCODE_2: SDL_Scancode = 31;
pub const SDL_SCANCODE_1: SDL_Scancode = 30;
pub const SDL_SCANCODE_Z: SDL_Scancode = 29;
pub const SDL_SCANCODE_Y: SDL_Scancode = 28;
pub const SDL_SCANCODE_X: SDL_Scancode = 27;
pub const SDL_SCANCODE_W: SDL_Scancode = 26;
pub const SDL_SCANCODE_V: SDL_Scancode = 25;
pub const SDL_SCANCODE_U: SDL_Scancode = 24;
pub const SDL_SCANCODE_T: SDL_Scancode = 23;
pub const SDL_SCANCODE_S: SDL_Scancode = 22;
pub const SDL_SCANCODE_R: SDL_Scancode = 21;
pub const SDL_SCANCODE_Q: SDL_Scancode = 20;
pub const SDL_SCANCODE_P: SDL_Scancode = 19;
pub const SDL_SCANCODE_O: SDL_Scancode = 18;
pub const SDL_SCANCODE_N: SDL_Scancode = 17;
pub const SDL_SCANCODE_M: SDL_Scancode = 16;
pub const SDL_SCANCODE_L: SDL_Scancode = 15;
pub const SDL_SCANCODE_K: SDL_Scancode = 14;
pub const SDL_SCANCODE_J: SDL_Scancode = 13;
pub const SDL_SCANCODE_I: SDL_Scancode = 12;
pub const SDL_SCANCODE_H: SDL_Scancode = 11;
pub const SDL_SCANCODE_G: SDL_Scancode = 10;
pub const SDL_SCANCODE_F: SDL_Scancode = 9;
pub const SDL_SCANCODE_E: SDL_Scancode = 8;
pub const SDL_SCANCODE_D: SDL_Scancode = 7;
pub const SDL_SCANCODE_C: SDL_Scancode = 6;
pub const SDL_SCANCODE_B: SDL_Scancode = 5;
pub const SDL_SCANCODE_A: SDL_Scancode = 4;
pub const SDL_SCANCODE_UNKNOWN: SDL_Scancode = 0;
pub type SDL_Keycode = Sint32;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_Keysym {
    pub scancode: SDL_Scancode,
    pub sym: SDL_Keycode,
    pub mod_0: Uint16,
    pub unused: Uint32,
}
pub type SDL_JoystickID = Sint32;
pub type SDL_JoystickPowerLevel = libc::c_int;
pub const SDL_JOYSTICK_POWER_MAX: SDL_JoystickPowerLevel = 5;
pub const SDL_JOYSTICK_POWER_WIRED: SDL_JoystickPowerLevel = 4;
pub const SDL_JOYSTICK_POWER_FULL: SDL_JoystickPowerLevel = 3;
pub const SDL_JOYSTICK_POWER_MEDIUM: SDL_JoystickPowerLevel = 2;
pub const SDL_JOYSTICK_POWER_LOW: SDL_JoystickPowerLevel = 1;
pub const SDL_JOYSTICK_POWER_EMPTY: SDL_JoystickPowerLevel = 0;
pub const SDL_JOYSTICK_POWER_UNKNOWN: SDL_JoystickPowerLevel = -1;
pub type SDL_TouchID = Sint64;
pub type SDL_FingerID = Sint64;
pub type SDL_GestureID = Sint64;
pub type C2RustUnnamed = libc::c_uint;
pub const SDL_LASTEVENT: C2RustUnnamed = 65535;
pub const SDL_USEREVENT: C2RustUnnamed = 32768;
pub const SDL_POLLSENTINEL: C2RustUnnamed = 32512;
pub const SDL_RENDER_DEVICE_RESET: C2RustUnnamed = 8193;
pub const SDL_RENDER_TARGETS_RESET: C2RustUnnamed = 8192;
pub const SDL_SENSORUPDATE: C2RustUnnamed = 4608;
pub const SDL_AUDIODEVICEREMOVED: C2RustUnnamed = 4353;
pub const SDL_AUDIODEVICEADDED: C2RustUnnamed = 4352;
pub const SDL_DROPCOMPLETE: C2RustUnnamed = 4099;
pub const SDL_DROPBEGIN: C2RustUnnamed = 4098;
pub const SDL_DROPTEXT: C2RustUnnamed = 4097;
pub const SDL_DROPFILE: C2RustUnnamed = 4096;
pub const SDL_CLIPBOARDUPDATE: C2RustUnnamed = 2304;
pub const SDL_MULTIGESTURE: C2RustUnnamed = 2050;
pub const SDL_DOLLARRECORD: C2RustUnnamed = 2049;
pub const SDL_DOLLARGESTURE: C2RustUnnamed = 2048;
pub const SDL_FINGERMOTION: C2RustUnnamed = 1794;
pub const SDL_FINGERUP: C2RustUnnamed = 1793;
pub const SDL_FINGERDOWN: C2RustUnnamed = 1792;
pub const SDL_CONTROLLERSENSORUPDATE: C2RustUnnamed = 1625;
pub const SDL_CONTROLLERTOUCHPADUP: C2RustUnnamed = 1624;
pub const SDL_CONTROLLERTOUCHPADMOTION: C2RustUnnamed = 1623;
pub const SDL_CONTROLLERTOUCHPADDOWN: C2RustUnnamed = 1622;
pub const SDL_CONTROLLERDEVICEREMAPPED: C2RustUnnamed = 1621;
pub const SDL_CONTROLLERDEVICEREMOVED: C2RustUnnamed = 1620;
pub const SDL_CONTROLLERDEVICEADDED: C2RustUnnamed = 1619;
pub const SDL_CONTROLLERBUTTONUP: C2RustUnnamed = 1618;
pub const SDL_CONTROLLERBUTTONDOWN: C2RustUnnamed = 1617;
pub const SDL_CONTROLLERAXISMOTION: C2RustUnnamed = 1616;
pub const SDL_JOYBATTERYUPDATED: C2RustUnnamed = 1543;
pub const SDL_JOYDEVICEREMOVED: C2RustUnnamed = 1542;
pub const SDL_JOYDEVICEADDED: C2RustUnnamed = 1541;
pub const SDL_JOYBUTTONUP: C2RustUnnamed = 1540;
pub const SDL_JOYBUTTONDOWN: C2RustUnnamed = 1539;
pub const SDL_JOYHATMOTION: C2RustUnnamed = 1538;
pub const SDL_JOYBALLMOTION: C2RustUnnamed = 1537;
pub const SDL_JOYAXISMOTION: C2RustUnnamed = 1536;
pub const SDL_MOUSEWHEEL: C2RustUnnamed = 1027;
pub const SDL_MOUSEBUTTONUP: C2RustUnnamed = 1026;
pub const SDL_MOUSEBUTTONDOWN: C2RustUnnamed = 1025;
pub const SDL_MOUSEMOTION: C2RustUnnamed = 1024;
pub const SDL_TEXTEDITING_EXT: C2RustUnnamed = 773;
pub const SDL_KEYMAPCHANGED: C2RustUnnamed = 772;
pub const SDL_TEXTINPUT: C2RustUnnamed = 771;
pub const SDL_TEXTEDITING: C2RustUnnamed = 770;
pub const SDL_KEYUP: C2RustUnnamed = 769;
pub const SDL_KEYDOWN: C2RustUnnamed = 768;
pub const SDL_SYSWMEVENT: C2RustUnnamed = 513;
pub const SDL_WINDOWEVENT: C2RustUnnamed = 512;
pub const SDL_DISPLAYEVENT: C2RustUnnamed = 336;
pub const SDL_LOCALECHANGED: C2RustUnnamed = 263;
pub const SDL_APP_DIDENTERFOREGROUND: C2RustUnnamed = 262;
pub const SDL_APP_WILLENTERFOREGROUND: C2RustUnnamed = 261;
pub const SDL_APP_DIDENTERBACKGROUND: C2RustUnnamed = 260;
pub const SDL_APP_WILLENTERBACKGROUND: C2RustUnnamed = 259;
pub const SDL_APP_LOWMEMORY: C2RustUnnamed = 258;
pub const SDL_APP_TERMINATING: C2RustUnnamed = 257;
pub const SDL_QUIT: C2RustUnnamed = 256;
pub const SDL_FIRSTEVENT: C2RustUnnamed = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_CommonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DisplayEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub display: Uint32,
    pub event: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub data1: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_WindowEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub event: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub data1: Sint32,
    pub data2: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_KeyboardEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub state: Uint8,
    pub repeat: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub keysym: SDL_Keysym,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextEditingEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: [libc::c_char; 32],
    pub start: Sint32,
    pub length: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextEditingExtEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: *mut libc::c_char,
    pub start: Sint32,
    pub length: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextInputEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: [libc::c_char; 32],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseMotionEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub state: Uint32,
    pub x: Sint32,
    pub y: Sint32,
    pub xrel: Sint32,
    pub yrel: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub button: Uint8,
    pub state: Uint8,
    pub clicks: Uint8,
    pub padding1: Uint8,
    pub x: Sint32,
    pub y: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseWheelEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub x: Sint32,
    pub y: Sint32,
    pub direction: Uint32,
    pub preciseX: libc::c_float,
    pub preciseY: libc::c_float,
    pub mouseX: Sint32,
    pub mouseY: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyAxisEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub axis: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub value: Sint16,
    pub padding4: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyBallEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub ball: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub xrel: Sint16,
    pub yrel: Sint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyHatEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub hat: Uint8,
    pub value: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub button: Uint8,
    pub state: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyBatteryEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub level: SDL_JoystickPowerLevel,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerAxisEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub axis: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub value: Sint16,
    pub padding4: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub button: Uint8,
    pub state: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerTouchpadEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub touchpad: Sint32,
    pub finger: Sint32,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub pressure: libc::c_float,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerSensorEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub sensor: Sint32,
    pub data: [libc::c_float; 3],
    pub timestamp_us: Uint64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_AudioDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Uint32,
    pub iscapture: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TouchFingerEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub fingerId: SDL_FingerID,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub dx: libc::c_float,
    pub dy: libc::c_float,
    pub pressure: libc::c_float,
    pub windowID: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MultiGestureEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub dTheta: libc::c_float,
    pub dDist: libc::c_float,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub numFingers: Uint16,
    pub padding: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DollarGestureEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub gestureId: SDL_GestureID,
    pub numFingers: Uint32,
    pub error: libc::c_float,
    pub x: libc::c_float,
    pub y: libc::c_float,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DropEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub file: *mut libc::c_char,
    pub windowID: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_SensorEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
    pub data: [libc::c_float; 6],
    pub timestamp_us: Uint64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_QuitEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_UserEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub code: Sint32,
    pub data1: *mut libc::c_void,
    pub data2: *mut libc::c_void,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_SysWMEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub msg: *mut SDL_SysWMmsg,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union SDL_Event {
    pub type_0: Uint32,
    pub common: SDL_CommonEvent,
    pub display: SDL_DisplayEvent,
    pub window: SDL_WindowEvent,
    pub key: SDL_KeyboardEvent,
    pub edit: SDL_TextEditingEvent,
    pub editExt: SDL_TextEditingExtEvent,
    pub text: SDL_TextInputEvent,
    pub motion: SDL_MouseMotionEvent,
    pub button: SDL_MouseButtonEvent,
    pub wheel: SDL_MouseWheelEvent,
    pub jaxis: SDL_JoyAxisEvent,
    pub jball: SDL_JoyBallEvent,
    pub jhat: SDL_JoyHatEvent,
    pub jbutton: SDL_JoyButtonEvent,
    pub jdevice: SDL_JoyDeviceEvent,
    pub jbattery: SDL_JoyBatteryEvent,
    pub caxis: SDL_ControllerAxisEvent,
    pub cbutton: SDL_ControllerButtonEvent,
    pub cdevice: SDL_ControllerDeviceEvent,
    pub ctouchpad: SDL_ControllerTouchpadEvent,
    pub csensor: SDL_ControllerSensorEvent,
    pub adevice: SDL_AudioDeviceEvent,
    pub sensor: SDL_SensorEvent,
    pub quit: SDL_QuitEvent,
    pub user: SDL_UserEvent,
    pub syswm: SDL_SysWMEvent,
    pub tfinger: SDL_TouchFingerEvent,
    pub mgesture: SDL_MultiGestureEvent,
    pub dgesture: SDL_DollarGestureEvent,
    pub drop: SDL_DropEvent,
    pub padding: [Uint8; 56],
}
pub type C2RustUnnamed_0 = libc::c_uint;
pub const MAX_PROGRESS: C2RustUnnamed_0 = 534;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const EVENT_DIABLOADGAME: C2RustUnnamed_1 = 32779;
pub const EVENT_DIABNEWGAME: C2RustUnnamed_1 = 32778;
pub const EVENT_DIABRETOWN: C2RustUnnamed_1 = 32777;
pub const EVENT_DIABTWARPUP: C2RustUnnamed_1 = 32776;
pub const EVENT_DIABTOWNWARP: C2RustUnnamed_1 = 32775;
pub const EVENT_DIABWARPLVL: C2RustUnnamed_1 = 32774;
pub const EVENT_DIABSETLVL: C2RustUnnamed_1 = 32773;
pub const EVENT_DIABRTNLVL: C2RustUnnamed_1 = 32772;
pub const EVENT_DIABPREVLVL: C2RustUnnamed_1 = 32771;
pub const EVENT_DIABNEXTLVL: C2RustUnnamed_1 = 32770;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_2 = 255;
pub const VIEWDRAW: C2RustUnnamed_2 = 1;
pub const NODRAW: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const NUM_CMDS: C2RustUnnamed_3 = 96;
pub const FAKE_CMD_DROPID: C2RustUnnamed_3 = 95;
pub const FAKE_CMD_SETID: C2RustUnnamed_3 = 94;
pub const CMD_REMSHIELD: C2RustUnnamed_3 = 93;
pub const CMD_SETSHIELD: C2RustUnnamed_3 = 92;
pub const CMD_NOVA: C2RustUnnamed_3 = 91;
pub const CMD_AWAKEGOLEM: C2RustUnnamed_3 = 90;
pub const CMD_ENDSHIELD: C2RustUnnamed_3 = 89;
pub const CMD_SYNCQUEST: C2RustUnnamed_3 = 88;
pub const CMD_KILLGOLEM: C2RustUnnamed_3 = 87;
pub const CMD_SYNCPUTITEM: C2RustUnnamed_3 = 86;
pub const CMD_ITEMEXTRA: C2RustUnnamed_3 = 85;
pub const CMD_SPELLXYD: C2RustUnnamed_3 = 84;
pub const CMD_RETOWN: C2RustUnnamed_3 = 83;
pub const CMD_SETVIT: C2RustUnnamed_3 = 82;
pub const CMD_SETDEX: C2RustUnnamed_3 = 81;
pub const CMD_SETMAG: C2RustUnnamed_3 = 80;
pub const CMD_SETSTR: C2RustUnnamed_3 = 79;
pub const CMD_STRING: C2RustUnnamed_3 = 78;
pub const CMD_HEALOTHER: C2RustUnnamed_3 = 77;
pub const CMD_DLEVEL_END: C2RustUnnamed_3 = 76;
pub const CMD_DLEVEL_JUNK: C2RustUnnamed_3 = 75;
pub const CMD_DLEVEL_16: C2RustUnnamed_3 = 74;
pub const CMD_DLEVEL_15: C2RustUnnamed_3 = 73;
pub const CMD_DLEVEL_14: C2RustUnnamed_3 = 72;
pub const CMD_DLEVEL_13: C2RustUnnamed_3 = 71;
pub const CMD_DLEVEL_12: C2RustUnnamed_3 = 70;
pub const CMD_DLEVEL_11: C2RustUnnamed_3 = 69;
pub const CMD_DLEVEL_10: C2RustUnnamed_3 = 68;
pub const CMD_DLEVEL_9: C2RustUnnamed_3 = 67;
pub const CMD_DLEVEL_8: C2RustUnnamed_3 = 66;
pub const CMD_DLEVEL_7: C2RustUnnamed_3 = 65;
pub const CMD_DLEVEL_6: C2RustUnnamed_3 = 64;
pub const CMD_DLEVEL_5: C2RustUnnamed_3 = 63;
pub const CMD_DLEVEL_4: C2RustUnnamed_3 = 62;
pub const CMD_DLEVEL_3: C2RustUnnamed_3 = 61;
pub const CMD_DLEVEL_2: C2RustUnnamed_3 = 60;
pub const CMD_DLEVEL_1: C2RustUnnamed_3 = 59;
pub const CMD_DLEVEL_0: C2RustUnnamed_3 = 58;
pub const CMD_DEACTIVATEPORTAL: C2RustUnnamed_3 = 57;
pub const CMD_ACTIVATEPORTAL: C2RustUnnamed_3 = 56;
pub const CMD_SATTACKXY: C2RustUnnamed_3 = 55;
pub const CMD_SEND_PLRINFO: C2RustUnnamed_3 = 54;
pub const CMD_PLAYER_JOINLEVEL: C2RustUnnamed_3 = 53;
pub const CMD_DROPITEM: C2RustUnnamed_3 = 52;
pub const CMD_PLRLEVEL: C2RustUnnamed_3 = 51;
pub const CMD_PLRDAMAGE: C2RustUnnamed_3 = 50;
pub const CMD_DELPLRITEMS: C2RustUnnamed_3 = 49;
pub const CMD_CHANGEPLRITEMS: C2RustUnnamed_3 = 48;
pub const CMD_BREAKOBJ: C2RustUnnamed_3 = 47;
pub const CMD_PLROPOBJ: C2RustUnnamed_3 = 46;
pub const CMD_OPERATEOBJ: C2RustUnnamed_3 = 45;
pub const CMD_CLOSEDOOR: C2RustUnnamed_3 = 44;
pub const CMD_OPENDOOR: C2RustUnnamed_3 = 43;
pub const CMD_GOTOAGETITEM: C2RustUnnamed_3 = 42;
pub const CMD_GOTOGETITEM: C2RustUnnamed_3 = 41;
pub const CMD_REQUESTAGITEM: C2RustUnnamed_3 = 40;
pub const CMD_REQUESTGITEM: C2RustUnnamed_3 = 39;
pub const CMD_PLRDEAD: C2RustUnnamed_3 = 38;
pub const CMD_MONSTDAMAGE: C2RustUnnamed_3 = 37;
pub const CMD_MONSTDEATH: C2RustUnnamed_3 = 36;
pub const CMD_SYNCDATA: C2RustUnnamed_3 = 35;
pub const CMD_DEBUG: C2RustUnnamed_3 = 34;
pub const CMD_CHEAT_SPELL_LEVEL: C2RustUnnamed_3 = 33;
pub const CMD_CHEAT_EXPERIENCE: C2RustUnnamed_3 = 32;
pub const CMD_WARP: C2RustUnnamed_3 = 31;
pub const CMD_NEWLVL: C2RustUnnamed_3 = 30;
pub const CMD_TALKXY: C2RustUnnamed_3 = 29;
pub const CMD_KNOCKBACK: C2RustUnnamed_3 = 28;
pub const CMD_OPOBJT: C2RustUnnamed_3 = 27;
pub const CMD_RESURRECT: C2RustUnnamed_3 = 26;
pub const CMD_TSPELLPID: C2RustUnnamed_3 = 25;
pub const CMD_TSPELLID: C2RustUnnamed_3 = 24;
pub const CMD_SPELLPID: C2RustUnnamed_3 = 23;
pub const CMD_SPELLID: C2RustUnnamed_3 = 22;
pub const CMD_RATTACKPID: C2RustUnnamed_3 = 21;
pub const CMD_RATTACKID: C2RustUnnamed_3 = 20;
pub const CMD_ATTACKPID: C2RustUnnamed_3 = 19;
pub const CMD_ATTACKID: C2RustUnnamed_3 = 18;
pub const CMD_DISARMXY: C2RustUnnamed_3 = 17;
pub const CMD_OPOBJXY: C2RustUnnamed_3 = 16;
pub const CMD_TSPELLXY: C2RustUnnamed_3 = 15;
pub const CMD_SPELLXY: C2RustUnnamed_3 = 14;
pub const CMD_RATTACKXY: C2RustUnnamed_3 = 13;
pub const CMD_ATTACKXY: C2RustUnnamed_3 = 12;
pub const CMD_RESPAWNITEM: C2RustUnnamed_3 = 11;
pub const CMD_PUTITEM: C2RustUnnamed_3 = 10;
pub const CMD_AGETITEM: C2RustUnnamed_3 = 9;
pub const CMD_GETITEM: C2RustUnnamed_3 = 8;
pub const CMD_SBSPELL: C2RustUnnamed_3 = 7;
pub const CMD_ADDVIT: C2RustUnnamed_3 = 6;
pub const CMD_ADDDEX: C2RustUnnamed_3 = 5;
pub const CMD_ADDMAG: C2RustUnnamed_3 = 4;
pub const CMD_ADDSTR: C2RustUnnamed_3 = 3;
pub const CMD_ACK_PLRINFO: C2RustUnnamed_3 = 2;
pub const CMD_WALKXY: C2RustUnnamed_3 = 1;
pub const CMD_STAND: C2RustUnnamed_3 = 0;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const FADE_VFAST: C2RustUnnamed_4 = 128;
pub const FADE_FAST: C2RustUnnamed_4 = 8;
pub const FADE_MED: C2RustUnnamed_4 = 16;
pub const FADE_SLOW: C2RustUnnamed_4 = 8;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const SL_VILEBETRAYER: C2RustUnnamed_5 = 5;
pub const SL_POISONWATER: C2RustUnnamed_5 = 4;
pub const SL_MAZE: C2RustUnnamed_5 = 3;
pub const SL_BONECHAMB: C2RustUnnamed_5 = 2;
pub const SL_SKELKING: C2RustUnnamed_5 = 1;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const LVL_TWARPUP: C2RustUnnamed_6 = 7;
pub const LVL_TWARPDN: C2RustUnnamed_6 = 6;
pub const LVL_WARP: C2RustUnnamed_6 = 5;
pub const LVL_NODIR: C2RustUnnamed_6 = 4;
pub const LVL_RTN: C2RustUnnamed_6 = 3;
pub const LVL_SET: C2RustUnnamed_6 = 2;
pub const LVL_UP: C2RustUnnamed_6 = 1;
pub const LVL_DOWN: C2RustUnnamed_6 = 0;
pub type bool32_t = uint32_t;
pub type SDLPROC = Option::<unsafe extern "C" fn(*mut SDL_Event) -> ()>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
static mut sgpBackCel: *mut uint8_t = 0 as *const uint8_t as *mut uint8_t;
static mut sgdwProgress: uint32_t = 0;
static mut sgdwXY: uint32_t = 0;
unsafe extern "C" fn ProgressFree() {
    let mut p__p: *mut libc::c_void = sgpBackCel as *mut libc::c_void;
    sgpBackCel = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
}
unsafe extern "C" fn ProgressLoad(mut uMsg: uint32_t) {
    if !sgpBackCel.is_null() {
        assert_fail(
            47 as libc::c_int,
            b"src/interfac.c\0" as *const u8 as *const libc::c_char,
            b"!sgpBackCel\0" as *const u8 as *const libc::c_char,
        );
    }
    match uMsg {
        32770 => {
            match gnLevelTypeTbl[currlevel as usize] {
                0 => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cuttt.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cuttt.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 1 as libc::c_int as uint32_t;
                }
                1 => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cutl1d.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cutl1d.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 0 as libc::c_int as uint32_t;
                }
                2 => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cut2.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cut2.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 2 as libc::c_int as uint32_t;
                }
                3 => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cut3.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cut3.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 1 as libc::c_int as uint32_t;
                }
                4 => {
                    if (currlevel as libc::c_int) < 15 as libc::c_int {
                        sgpBackCel = LoadFileInMem(
                            b"Gendata\\Cut4.CEL\0" as *const u8 as *const libc::c_char,
                            0 as *mut uint32_t,
                        );
                        LoadPalette(
                            b"Gendata\\Cut4.pal\0" as *const u8 as *const libc::c_char,
                        );
                        sgdwXY = 1 as libc::c_int as uint32_t;
                    } else {
                        sgpBackCel = LoadFileInMem(
                            b"Gendata\\Cutgate.CEL\0" as *const u8
                                as *const libc::c_char,
                            0 as *mut uint32_t,
                        );
                        LoadPalette(
                            b"Gendata\\Cutgate.pal\0" as *const u8 as *const libc::c_char,
                        );
                        sgdwXY = 1 as libc::c_int as uint32_t;
                    }
                }
                _ => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cutl1d.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cutl1d.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 0 as libc::c_int as uint32_t;
                }
            }
        }
        32771 => {
            if gnLevelTypeTbl[(currlevel as libc::c_int - 1 as libc::c_int) as usize]
                == 0 as libc::c_int
            {
                sgpBackCel = LoadFileInMem(
                    b"Gendata\\Cuttt.CEL\0" as *const u8 as *const libc::c_char,
                    0 as *mut uint32_t,
                );
                LoadPalette(b"Gendata\\Cuttt.pal\0" as *const u8 as *const libc::c_char);
                sgdwXY = 1 as libc::c_int as uint32_t;
            } else {
                match gnLevelTypeTbl[currlevel as usize] {
                    0 => {
                        sgpBackCel = LoadFileInMem(
                            b"Gendata\\Cuttt.CEL\0" as *const u8 as *const libc::c_char,
                            0 as *mut uint32_t,
                        );
                        LoadPalette(
                            b"Gendata\\Cuttt.pal\0" as *const u8 as *const libc::c_char,
                        );
                        sgdwXY = 1 as libc::c_int as uint32_t;
                    }
                    1 => {
                        sgpBackCel = LoadFileInMem(
                            b"Gendata\\Cutl1d.CEL\0" as *const u8 as *const libc::c_char,
                            0 as *mut uint32_t,
                        );
                        LoadPalette(
                            b"Gendata\\Cutl1d.pal\0" as *const u8 as *const libc::c_char,
                        );
                        sgdwXY = 0 as libc::c_int as uint32_t;
                    }
                    2 => {
                        sgpBackCel = LoadFileInMem(
                            b"Gendata\\Cut2.CEL\0" as *const u8 as *const libc::c_char,
                            0 as *mut uint32_t,
                        );
                        LoadPalette(
                            b"Gendata\\Cut2.pal\0" as *const u8 as *const libc::c_char,
                        );
                        sgdwXY = 2 as libc::c_int as uint32_t;
                    }
                    3 => {
                        sgpBackCel = LoadFileInMem(
                            b"Gendata\\Cut3.CEL\0" as *const u8 as *const libc::c_char,
                            0 as *mut uint32_t,
                        );
                        LoadPalette(
                            b"Gendata\\Cut3.pal\0" as *const u8 as *const libc::c_char,
                        );
                        sgdwXY = 1 as libc::c_int as uint32_t;
                    }
                    4 => {
                        sgpBackCel = LoadFileInMem(
                            b"Gendata\\Cut4.CEL\0" as *const u8 as *const libc::c_char,
                            0 as *mut uint32_t,
                        );
                        LoadPalette(
                            b"Gendata\\Cut4.pal\0" as *const u8 as *const libc::c_char,
                        );
                        sgdwXY = 1 as libc::c_int as uint32_t;
                    }
                    _ => {
                        sgpBackCel = LoadFileInMem(
                            b"Gendata\\Cutl1d.CEL\0" as *const u8 as *const libc::c_char,
                            0 as *mut uint32_t,
                        );
                        LoadPalette(
                            b"Gendata\\Cutl1d.pal\0" as *const u8 as *const libc::c_char,
                        );
                        sgdwXY = 0 as libc::c_int as uint32_t;
                    }
                }
            }
        }
        32773 => {
            if setlvlnum as libc::c_int == SL_BONECHAMB as libc::c_int {
                sgpBackCel = LoadFileInMem(
                    b"Gendata\\Cut2.CEL\0" as *const u8 as *const libc::c_char,
                    0 as *mut uint32_t,
                );
                LoadPalette(b"Gendata\\Cut2.pal\0" as *const u8 as *const libc::c_char);
                sgdwXY = 2 as libc::c_int as uint32_t;
            } else if setlvlnum as libc::c_int == SL_VILEBETRAYER as libc::c_int {
                sgpBackCel = LoadFileInMem(
                    b"Gendata\\Cutportr.CEL\0" as *const u8 as *const libc::c_char,
                    0 as *mut uint32_t,
                );
                LoadPalette(
                    b"Gendata\\Cutportr.pal\0" as *const u8 as *const libc::c_char,
                );
                sgdwXY = 1 as libc::c_int as uint32_t;
            } else {
                sgpBackCel = LoadFileInMem(
                    b"Gendata\\Cutl1d.CEL\0" as *const u8 as *const libc::c_char,
                    0 as *mut uint32_t,
                );
                LoadPalette(
                    b"Gendata\\Cutl1d.pal\0" as *const u8 as *const libc::c_char,
                );
                sgdwXY = 0 as libc::c_int as uint32_t;
            }
        }
        32772 => {
            if setlvlnum as libc::c_int == SL_BONECHAMB as libc::c_int {
                sgpBackCel = LoadFileInMem(
                    b"Gendata\\Cut2.CEL\0" as *const u8 as *const libc::c_char,
                    0 as *mut uint32_t,
                );
                LoadPalette(b"Gendata\\Cut2.pal\0" as *const u8 as *const libc::c_char);
                sgdwXY = 2 as libc::c_int as uint32_t;
            } else if setlvlnum as libc::c_int == SL_VILEBETRAYER as libc::c_int {
                sgpBackCel = LoadFileInMem(
                    b"Gendata\\Cutportr.CEL\0" as *const u8 as *const libc::c_char,
                    0 as *mut uint32_t,
                );
                LoadPalette(
                    b"Gendata\\Cutportr.pal\0" as *const u8 as *const libc::c_char,
                );
                sgdwXY = 1 as libc::c_int as uint32_t;
            } else {
                sgpBackCel = LoadFileInMem(
                    b"Gendata\\Cutl1d.CEL\0" as *const u8 as *const libc::c_char,
                    0 as *mut uint32_t,
                );
                LoadPalette(
                    b"Gendata\\Cutl1d.pal\0" as *const u8 as *const libc::c_char,
                );
                sgdwXY = 0 as libc::c_int as uint32_t;
            }
        }
        32774 => {
            sgpBackCel = LoadFileInMem(
                b"Gendata\\Cutportl.CEL\0" as *const u8 as *const libc::c_char,
                0 as *mut uint32_t,
            );
            LoadPalette(b"Gendata\\Cutportl.pal\0" as *const u8 as *const libc::c_char);
            sgdwXY = 1 as libc::c_int as uint32_t;
        }
        32779 => {
            sgpBackCel = LoadFileInMem(
                b"Gendata\\Cutstart.CEL\0" as *const u8 as *const libc::c_char,
                0 as *mut uint32_t,
            );
            LoadPalette(b"Gendata\\Cutstart.pal\0" as *const u8 as *const libc::c_char);
            sgdwXY = 1 as libc::c_int as uint32_t;
        }
        32778 => {
            sgpBackCel = LoadFileInMem(
                b"Gendata\\Cutstart.CEL\0" as *const u8 as *const libc::c_char,
                0 as *mut uint32_t,
            );
            LoadPalette(b"Gendata\\Cutstart.pal\0" as *const u8 as *const libc::c_char);
            sgdwXY = 1 as libc::c_int as uint32_t;
        }
        32775 | 32776 => {
            match gnLevelTypeTbl[plr[myplr as usize].plrlevel as usize] {
                0 => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cuttt.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cuttt.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 1 as libc::c_int as uint32_t;
                }
                2 => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cut2.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cut2.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 2 as libc::c_int as uint32_t;
                }
                3 => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cut3.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cut3.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 1 as libc::c_int as uint32_t;
                }
                4 => {
                    sgpBackCel = LoadFileInMem(
                        b"Gendata\\Cut4.CEL\0" as *const u8 as *const libc::c_char,
                        0 as *mut uint32_t,
                    );
                    LoadPalette(
                        b"Gendata\\Cut4.pal\0" as *const u8 as *const libc::c_char,
                    );
                    sgdwXY = 1 as libc::c_int as uint32_t;
                }
                _ => {}
            }
        }
        32777 => {
            sgpBackCel = LoadFileInMem(
                b"Gendata\\Cuttt.CEL\0" as *const u8 as *const libc::c_char,
                0 as *mut uint32_t,
            );
            LoadPalette(b"Gendata\\Cuttt.pal\0" as *const u8 as *const libc::c_char);
            sgdwXY = 1 as libc::c_int as uint32_t;
        }
        _ => {
            app_fatal_(
                b"src/interfac.c\0" as *const u8 as *const libc::c_char,
                214 as libc::c_int,
                b"Unknown progress mode\0" as *const u8 as *const libc::c_char,
            );
        }
    }
    sgdwProgress = 0 as libc::c_int as uint32_t;
}
unsafe extern "C" fn DrawBarXY(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut v2: libc::c_int,
) {
    if gpBuffer.is_null() {
        assert_fail(
            223 as libc::c_int,
            b"src/interfac.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    static mut pixel: [uint8_t; 3] = [
        0x8a as libc::c_int as uint8_t,
        0x2b as libc::c_int as uint8_t,
        0xfe as libc::c_int as uint8_t,
    ];
    let mut pto: *mut uint32_t = gpBuffer
        .offset(nBuffWTbl[y as usize] as isize)
        .offset(x as isize);
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 22 as libc::c_int {
        *pto = gpPalette[pixel[v2 as usize] as usize];
        pto = pto.offset(768 as libc::c_int as isize);
        i += 1;
        i;
    }
}
unsafe extern "C" fn ProgressIntDraw() {
    static mut xytable: [[libc::c_int; 2]; 3] = [
        [53 as libc::c_int, 37 as libc::c_int],
        [53 as libc::c_int, 421 as libc::c_int],
        [53 as libc::c_int, 37 as libc::c_int],
    ];
    lock_buf(1 as libc::c_int as uint8_t);
    if sgpBackCel.is_null() {
        assert_fail(
            237 as libc::c_int,
            b"src/interfac.c\0" as *const u8 as *const libc::c_char,
            b"sgpBackCel\0" as *const u8 as *const libc::c_char,
        );
    }
    DrawCel(
        64 as libc::c_int,
        639 as libc::c_int,
        sgpBackCel,
        1 as libc::c_int,
        640 as libc::c_int,
    );
    let mut i: uint32_t = 0 as libc::c_int as uint32_t;
    while i < sgdwProgress {
        DrawBarXY(
            ((64 as libc::c_int + xytable[sgdwXY as usize][0 as libc::c_int as usize])
                as uint32_t)
                .wrapping_add(i) as libc::c_int,
            xytable[sgdwXY as usize][1 as libc::c_int as usize] + 160 as libc::c_int,
            sgdwXY as libc::c_int,
        );
        i = i.wrapping_add(1);
        i;
    }
    unlock_buf(1 as libc::c_int as uint8_t);
    force_redraw = FULLDRAW as libc::c_int;
    FullBlit(0 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn interface_msg_pump() {
    let mut event: SDL_Event = SDL_Event { type_0: 0 };
    while inputPollEvent(&mut event) != 0 {
        if event.type_0 != SDL_QUIT as libc::c_int as Uint32 {
            HandleEvent(&mut event);
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn IntCheck() -> bool32_t {
    interface_msg_pump();
    sgdwProgress = sgdwProgress.wrapping_add(15 as libc::c_int as uint32_t);
    if sgdwProgress > MAX_PROGRESS as libc::c_int as uint32_t {
        sgdwProgress = MAX_PROGRESS as libc::c_int as uint32_t;
    }
    if !sgpBackCel.is_null() {
        ProgressIntDraw();
    }
    return (sgdwProgress >= MAX_PROGRESS as libc::c_int as uint32_t) as libc::c_int
        as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn ShowProgress(mut uMsg: uint32_t) {
    gbSomebodyWonGameKludge = 0 as libc::c_int as uint8_t;
    plrmsg_hold(1 as libc::c_int as bool32_t);
    let mut saveProc: SDLPROC = my_SetWindowProc(
        Some(DisableInputWndProc as unsafe extern "C" fn(*mut SDL_Event) -> ()),
    );
    interface_msg_pump();
    ClrDraw();
    FullBlit(1 as libc::c_int as bool32_t);
    ProgressLoad(uMsg);
    BlackPalette();
    ProgressIntDraw();
    PaletteFadeIn(FADE_FAST as libc::c_int);
    IntCheck();
    sound_init();
    IntCheck();
    match uMsg {
        32779 => {
            IntCheck();
            GM_LoadGame(1 as libc::c_int as bool32_t);
            IntCheck();
        }
        32778 => {
            IntCheck();
            FreeGameMem();
            IntCheck();
            LoadGameLevel(1 as libc::c_int as bool32_t, LVL_DOWN as libc::c_int);
            IntCheck();
        }
        32770 => {
            IntCheck();
            if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                SaveLevel();
            } else {
                DeltaSaveLevel();
            }
            FreeGameMem();
            currlevel = currlevel.wrapping_add(1);
            currlevel;
            leveltype = gnLevelTypeTbl[currlevel as usize] as uint8_t;
            if !(plr[myplr as usize].plrlevel == currlevel as libc::c_int) {
                assert_fail(
                    323 as libc::c_int,
                    b"src/interfac.c\0" as *const u8 as *const libc::c_char,
                    b"plr[myplr].plrlevel == currlevel\0" as *const u8
                        as *const libc::c_char,
                );
            }
            IntCheck();
            LoadGameLevel(0 as libc::c_int as bool32_t, LVL_DOWN as libc::c_int);
            IntCheck();
        }
        32771 => {
            IntCheck();
            if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                SaveLevel();
            } else {
                DeltaSaveLevel();
            }
            IntCheck();
            FreeGameMem();
            currlevel = currlevel.wrapping_sub(1);
            currlevel;
            leveltype = gnLevelTypeTbl[currlevel as usize] as uint8_t;
            if !(plr[myplr as usize].plrlevel == currlevel as libc::c_int) {
                assert_fail(
                    341 as libc::c_int,
                    b"src/interfac.c\0" as *const u8 as *const libc::c_char,
                    b"plr[myplr].plrlevel == currlevel\0" as *const u8
                        as *const libc::c_char,
                );
            }
            IntCheck();
            LoadGameLevel(0 as libc::c_int as bool32_t, LVL_UP as libc::c_int);
            IntCheck();
        }
        32773 => {
            SetReturnLvlPos();
            if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                SaveLevel();
            } else {
                DeltaSaveLevel();
            }
            setlevel = 1 as libc::c_int as uint8_t;
            leveltype = setlvltype;
            FreeGameMem();
            IntCheck();
            LoadGameLevel(0 as libc::c_int as bool32_t, LVL_SET as libc::c_int);
            IntCheck();
        }
        32772 => {
            if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                SaveLevel();
            } else {
                DeltaSaveLevel();
            }
            setlevel = 0 as libc::c_int as uint8_t;
            FreeGameMem();
            IntCheck();
            GetReturnLvlPos();
            LoadGameLevel(0 as libc::c_int as bool32_t, LVL_RTN as libc::c_int);
            IntCheck();
        }
        32774 => {
            IntCheck();
            if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                SaveLevel();
            } else {
                DeltaSaveLevel();
            }
            FreeGameMem();
            GetPortalLevel();
            IntCheck();
            LoadGameLevel(0 as libc::c_int as bool32_t, LVL_WARP as libc::c_int);
            IntCheck();
        }
        32775 => {
            IntCheck();
            if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                SaveLevel();
            } else {
                DeltaSaveLevel();
            }
            FreeGameMem();
            currlevel = plr[myplr as usize].plrlevel as uint8_t;
            leveltype = gnLevelTypeTbl[currlevel as usize] as uint8_t;
            if !(plr[myplr as usize].plrlevel == currlevel as libc::c_int) {
                assert_fail(
                    402 as libc::c_int,
                    b"src/interfac.c\0" as *const u8 as *const libc::c_char,
                    b"plr[myplr].plrlevel == currlevel\0" as *const u8
                        as *const libc::c_char,
                );
            }
            IntCheck();
            LoadGameLevel(0 as libc::c_int as bool32_t, LVL_TWARPDN as libc::c_int);
            IntCheck();
        }
        32776 => {
            IntCheck();
            if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                SaveLevel();
            } else {
                DeltaSaveLevel();
            }
            FreeGameMem();
            currlevel = plr[myplr as usize].plrlevel as uint8_t;
            leveltype = gnLevelTypeTbl[currlevel as usize] as uint8_t;
            if !(plr[myplr as usize].plrlevel == currlevel as libc::c_int) {
                assert_fail(
                    419 as libc::c_int,
                    b"src/interfac.c\0" as *const u8 as *const libc::c_char,
                    b"plr[myplr].plrlevel == currlevel\0" as *const u8
                        as *const libc::c_char,
                );
            }
            IntCheck();
            LoadGameLevel(0 as libc::c_int as bool32_t, LVL_TWARPUP as libc::c_int);
            IntCheck();
        }
        32777 => {
            IntCheck();
            if gbMaxPlayers as libc::c_int == 1 as libc::c_int {
                SaveLevel();
            } else {
                DeltaSaveLevel();
            }
            FreeGameMem();
            currlevel = plr[myplr as usize].plrlevel as uint8_t;
            leveltype = gnLevelTypeTbl[currlevel as usize] as uint8_t;
            if !(plr[myplr as usize].plrlevel == currlevel as libc::c_int) {
                assert_fail(
                    436 as libc::c_int,
                    b"src/interfac.c\0" as *const u8 as *const libc::c_char,
                    b"plr[myplr].plrlevel == currlevel\0" as *const u8
                        as *const libc::c_char,
                );
            }
            IntCheck();
            LoadGameLevel(0 as libc::c_int as bool32_t, LVL_DOWN as libc::c_int);
            IntCheck();
        }
        _ => {}
    }
    PaletteFadeOut(FADE_FAST as libc::c_int);
    ProgressFree();
    saveProc = my_SetWindowProc(saveProc);
    if !(saveProc
        == Some(DisableInputWndProc as unsafe extern "C" fn(*mut SDL_Event) -> ()))
    {
        assert_fail(
            449 as libc::c_int,
            b"src/interfac.c\0" as *const u8 as *const libc::c_char,
            b"saveProc == DisableInputWndProc\0" as *const u8 as *const libc::c_char,
        );
    }
    NetSendCmdLocParam1(
        1 as libc::c_int as bool32_t,
        CMD_PLAYER_JOINLEVEL as libc::c_int as uint8_t,
        plr[myplr as usize]._px as uint8_t,
        plr[myplr as usize]._py as uint8_t,
        plr[myplr as usize].plrlevel as uint16_t,
    );
    plrmsg_hold(0 as libc::c_int as bool32_t);
    if gbSomebodyWonGameKludge as libc::c_int != 0
        && plr[myplr as usize].plrlevel == 16 as libc::c_int
    {
        PrepDoEnding();
    }
    gbSomebodyWonGameKludge = 0 as libc::c_int as uint8_t;
}
