use ::libc;
extern "C" {
    fn DrawPanelFont(poffset: int32_t, nCel: int32_t, clr: int8_t);
    fn DrawQTextBack();
    fn PrintSString(
        x: libc::c_int,
        y: libc::c_int,
        cjustflag: bool32_t,
        str: *const libc::c_char,
        col: int8_t,
        val: libc::c_int,
    );
    fn DrawSLine(y: libc::c_int);
    fn SetupSTextLWin();
    static gbFontTransTbl: [uint8_t; 256];
    static fonttrans: [uint8_t; 128];
    static fontkern: [uint8_t; 68];
    static mut tempstr: [libc::c_char; 256];
    static mut helpflag: bool32_t;
    static mut nBuffWTbl: [int32_t; 1024];
    static mut SStringY: [libc::c_int; 24];
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const ICOLOR_GOLD: C2RustUnnamed = 3;
pub const ICOLOR_RED: C2RustUnnamed = 2;
pub const ICOLOR_BLUE: C2RustUnnamed = 1;
pub const ICOLOR_WHITE: C2RustUnnamed = 0;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct HelpStrStruct {
    pub hsx: libc::c_int,
    pub hsy: libc::c_int,
    pub hstr: [libc::c_char; 128],
    pub hclr: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct HelpLineStruct {
    pub hlx1: libc::c_int,
    pub hly1: libc::c_int,
    pub hlx2: libc::c_int,
    pub hly2: libc::c_int,
    pub hlclr: uint8_t,
}
#[no_mangle]
pub static mut helpstr: [HelpStrStruct; 8] = [HelpStrStruct {
    hsx: 0,
    hsy: 0,
    hstr: [0; 128],
    hclr: 0,
}; 8];
#[no_mangle]
pub static mut helpline: [HelpLineStruct; 4] = [HelpLineStruct {
    hlx1: 0,
    hly1: 0,
    hlx2: 0,
    hly2: 0,
    hlclr: 0,
}; 4];
#[no_mangle]
pub static mut numhelpstrs: libc::c_int = 0;
#[no_mangle]
pub static mut numhelplines: libc::c_int = 0;
#[no_mangle]
pub static mut helpx: libc::c_int = 0;
#[no_mangle]
pub static mut helpy: libc::c_int = 0;
#[no_mangle]
pub static mut help_cy: libc::c_int = 0;
#[no_mangle]
pub static mut help_end: libc::c_int = 0;
static mut helpdata: [libc::c_char; 2268] = unsafe {
    *::core::mem::transmute::<
        &[u8; 2268],
        &[libc::c_char; 2268],
    >(
        b"$Keyboard Shortcuts:|F1:    Open Help Screen|Esc:   Display Main Menu|Tab:   Display Auto-map|Space: Hide all info screens|S: Open Speedbook|B: Open Spellbook|I: Open Inventory screen|C: Open Character screen|Q: Open Quest log|F: Reduce screen brightness|G: Increase screen brightness|Z: Zoom Game Screen|+ / -: Zoom Automap|1 - 8: Use Belt item|F5, F6, F7, F8:     Set hot key for skill or spell|Shift + Left Click: Attack without moving||$Movement:|If you hold the mouse button down while moving, the character will continue to move in that direction.||$Combat:|Holding down the shift key and then left-clicking allows the character to attack without moving.||$Auto-map:|To access the auto-map, click the 'MAP' button on the Information Bar or press 'TAB' on the keyboard. Zooming in and out of the map is done with the + and - keys. Scrolling the map uses the arrow keys.||$Picking up Objects:|Useable items that are small in size, such as potions or scrolls, are automatically placed in your 'belt' located at the top of the Interface bar . When an item is placed in the belt, a small number appears in that box. Items may be used by either pressing the corresponding number or right-clicking on the item.||$Gold|You can select a specific amount of gold to drop by right clicking on a pile of gold in your inventory.||$Skills & Spells:|You can access your list of skills and spells by left-clicking on the 'SPELLS' button in the interface bar. Memorized spells and those available through staffs are listed here. Left-clicking on the spell you wish to cast will ready the spell. A readied spell may be cast by simply right-clicking in the play area.||$Using the Speedbook for Spells|Left-clicking on the 'readied spell' button will open the 'Speedbook' which allows you to select a skill or spell for immediate use.  To use a readied skill or spell, simply right-click in the main play area.||$Setting Spell Hotkeys|You can assign up to four Hot Keys for skills, spells or scrolls.  Start by opening the 'speedbook' as described in the section above. Press the F5, F6, F7 or F8 keys after highlighting the spell you wish to assign.||$Spell Books|Reading more than one book increases your knowledge of that spell, allowing you to cast the spell more effectively.|&\0",
    )
};
#[no_mangle]
pub unsafe extern "C" fn InitHelpSys() {
    helpflag = 0 as libc::c_int as bool32_t;
    numhelpstrs = 0 as libc::c_int;
    numhelplines = 0 as libc::c_int;
}
unsafe extern "C" fn PrintHelpStr(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut pszStr: *const libc::c_char,
    mut col: int8_t,
) {
    let mut boffset: int32_t = nBuffWTbl[(SStringY[y as usize] + 204 as libc::c_int)
        as usize] + x + 96 as libc::c_int;
    let mut aw: libc::c_int = 577 as libc::c_int;
    let mut w: libc::c_int = 0 as libc::c_int;
    while *pszStr != 0 {
        let fresh0 = pszStr;
        pszStr = pszStr.offset(1);
        let mut c: uint8_t = gbFontTransTbl[*fresh0 as uint8_t as usize];
        c = fonttrans[c as usize];
        w += fontkern[c as usize] as libc::c_int + 1 as libc::c_int;
        if c as libc::c_int != 0 && w <= aw {
            DrawPanelFont(boffset, c as int32_t, col);
        }
        boffset += fontkern[c as usize] as libc::c_int + 1 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawHelp() {
    let mut y: libc::c_int = 0;
    let mut w: libc::c_int = 0;
    let mut t: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut lc: int8_t = 0;
    let mut p: *const libc::c_char = 0 as *const libc::c_char;
    SetupSTextLWin();
    DrawQTextBack();
    PrintSString(
        0 as libc::c_int,
        2 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Diablo Help\0" as *const u8 as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int,
    );
    DrawSLine(5 as libc::c_int);
    p = &*helpdata.as_ptr().offset(0 as libc::c_int as isize) as *const libc::c_char;
    i = 0 as libc::c_int;
    while i < help_cy {
        t = 0 as libc::c_int;
        w = 0 as libc::c_int;
        while *p as libc::c_int == 0 as libc::c_int {
            p = p.offset(1);
            p;
        }
        if *p as libc::c_int == '$' as i32 {
            p = p.offset(1);
            p;
        }
        if *p as libc::c_int != '&' as i32 {
            while *p as libc::c_int != '|' as i32 && w < 577 as libc::c_int {
                while *p as libc::c_int == 0 as libc::c_int {
                    p = p.offset(1);
                    p;
                }
                tempstr[t as usize] = *p;
                let mut c: uint8_t = gbFontTransTbl[tempstr[t as usize] as uint8_t
                    as usize];
                c = fonttrans[c as usize];
                w += fontkern[c as usize] as libc::c_int + 1 as libc::c_int;
                t += 1;
                t;
                p = p.offset(1);
                p;
            }
            if w >= 577 as libc::c_int {
                loop {
                    t -= 1;
                    if !(tempstr[t as usize] as libc::c_int != ' ' as i32) {
                        break;
                    }
                    p = p.offset(-1);
                    p;
                }
            }
            if *p as libc::c_int == '|' as i32 {
                p = p.offset(1);
                p;
            }
        }
        i += 1;
        i;
    }
    y = 7 as libc::c_int;
    while y < 22 as libc::c_int {
        t = 0 as libc::c_int;
        w = 0 as libc::c_int;
        while *p as libc::c_int == 0 as libc::c_int {
            p = p.offset(1);
            p;
        }
        if *p as libc::c_int == '$' as i32 {
            p = p.offset(1);
            p;
            lc = ICOLOR_RED as libc::c_int as int8_t;
        } else {
            lc = ICOLOR_WHITE as libc::c_int as int8_t;
        }
        if *p as libc::c_int == '&' as i32 {
            help_end = help_cy;
        } else {
            while *p as libc::c_int != '|' as i32 && w < 577 as libc::c_int {
                while *p as libc::c_int == 0 as libc::c_int {
                    p = p.offset(1);
                    p;
                }
                tempstr[t as usize] = *p;
                let mut c_0: uint8_t = gbFontTransTbl[tempstr[t as usize] as uint8_t
                    as usize];
                c_0 = fonttrans[c_0 as usize];
                w += fontkern[c_0 as usize] as libc::c_int + 1 as libc::c_int;
                t += 1;
                t;
                p = p.offset(1);
                p;
            }
            if w >= 577 as libc::c_int {
                loop {
                    t -= 1;
                    if !(tempstr[t as usize] as libc::c_int != ' ' as i32) {
                        break;
                    }
                    p = p.offset(-1);
                    p;
                }
            }
            if t != 0 as libc::c_int {
                tempstr[t as usize] = 0 as libc::c_int as libc::c_char;
                PrintHelpStr(0 as libc::c_int, y, tempstr.as_mut_ptr(), lc);
            }
            if *p as libc::c_int == '|' as i32 {
                p = p.offset(1);
                p;
            }
        }
        y += 1;
        y;
    }
    PrintSString(
        0 as libc::c_int,
        23 as libc::c_int,
        1 as libc::c_int as bool32_t,
        b"Press ESC to end or the arrow keys to scroll.\0" as *const u8
            as *const libc::c_char,
        ICOLOR_GOLD as libc::c_int as int8_t,
        0 as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn StartHelp() {
    helpflag = 1 as libc::c_int as bool32_t;
    help_cy = 0 as libc::c_int;
    help_end = 5000 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn HelpScrollUp() {
    if help_cy > 0 as libc::c_int {
        help_cy -= 1;
        help_cy;
    }
}
#[no_mangle]
pub unsafe extern "C" fn HelpScrollDown() {
    if help_cy < help_end {
        help_cy += 1;
        help_cy;
    }
}
