use ::libc;
extern "C" {
    fn calloc(_: libc::c_ulong, _: libc::c_ulong) -> *mut libc::c_void;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut setlevel: uint8_t;
    static mut dungeon: [[uint8_t; 40]; 40];
    static mut dflags: [[uint8_t; 40]; 40];
    static mut setpc_x: libc::c_int;
    static mut setpc_y: libc::c_int;
    static mut setpc_w: libc::c_int;
    static mut setpc_h: libc::c_int;
    static mut pMegaTiles: *mut uint8_t;
    static mut pMiniTiles: *mut uint8_t;
    static mut nWTypeTable: [uint8_t; 2049];
    static mut nBlockTable: [uint8_t; 2049];
    static mut nSolidTable: [uint8_t; 2049];
    static mut nTransTable: [uint8_t; 2049];
    static mut nMissileTable: [uint8_t; 2049];
    static mut nTrapTable: [uint8_t; 2049];
    static mut MicroTileLen: libc::c_int;
    static mut TransVal: int8_t;
    static mut TransList: [uint8_t; 256];
    static mut dTransVal: [[int8_t; 112]; 112];
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dMissile: [[*mut MissileNode; 112]; 112];
    static mut themeCount: libc::c_int;
    static mut themeLoc: [THEME_LOC; 50];
    static mut gpPalette: [uint32_t; 256];
    static mut plr: [PlayerStruct; 4];
    static mut gpBuffer: *mut uint32_t;
    fn MegaTileMapContains(xx: libc::c_int, yy: libc::c_int) -> bool;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed = 191;
pub const SETP_TEMP: C2RustUnnamed = 64;
pub const SETP_MASK: C2RustUnnamed = 127;
pub const SETP_BIT: C2RustUnnamed = 128;
pub const BFMASK_MISSILE: C2RustUnnamed = 254;
pub const BFMASK_SETPC: C2RustUnnamed = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed = 239;
pub const BFMASK_PLRLR: C2RustUnnamed = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed = 127;
pub const BFLAG_MISSILE: C2RustUnnamed = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed = 4;
pub const BFLAG_SETPC: C2RustUnnamed = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed = 16;
pub const BFLAG_PLRLR: C2RustUnnamed = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed = 128;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type bool32_t = uint32_t;
pub const DIRTEDGED2: C2RustUnnamed_0 = 16;
pub const MDMAXY: C2RustUnnamed_0 = 40;
pub const MDMAXX: C2RustUnnamed_0 = 40;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
pub const MAX_PLRS: C2RustUnnamed_1 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct THEME_LOC {
    pub x: libc::c_int,
    pub y: libc::c_int,
    pub ttval: libc::c_int,
    pub width: libc::c_int,
    pub height: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MissileNode {
    pub missile_num: int8_t,
    pub next: *mut MissileNode,
}
pub type C2RustUnnamed_0 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_0 = 32;
pub const MAXMICRO: C2RustUnnamed_0 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_0 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_0 = 64;
pub const MAXMREND: C2RustUnnamed_0 = 128;
pub const MAXTILES: C2RustUnnamed_0 = 2048;
pub const MAXDUNY: C2RustUnnamed_0 = 112;
pub const MAXDUNX: C2RustUnnamed_0 = 112;
pub const DMAXY: C2RustUnnamed_0 = 112;
pub const DMAXX: C2RustUnnamed_0 = 112;
pub const DIRTEDGE: C2RustUnnamed_0 = 32;
pub const NUMSLEVELS: C2RustUnnamed_0 = 10;
pub const NUMLEVELS: C2RustUnnamed_0 = 17;
pub const LVL4_START: C2RustUnnamed_0 = 13;
pub const LVL3_START: C2RustUnnamed_0 = 9;
pub const LVL2_START: C2RustUnnamed_0 = 5;
pub const LVL1_START: C2RustUnnamed_0 = 1;
pub const TLVL_START: C2RustUnnamed_0 = 0;
pub const LVLLENGTH: C2RustUnnamed_0 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MICROS {
    pub mt: [uint16_t; 16],
}
pub type C2RustUnnamed_1 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_1 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_1 = 92160;
pub const BTMBUFFY: C2RustUnnamed_1 = 144;
pub const BTMBUFFX: C2RustUnnamed_1 = 640;
pub const BUFFERSIZE: C2RustUnnamed_1 = 503808;
pub const BUFFERY: C2RustUnnamed_1 = 656;
pub const BUFFERX: C2RustUnnamed_1 = 768;
pub const GAMEY: C2RustUnnamed_1 = 352;
pub const CTRLPANY: C2RustUnnamed_1 = 128;
pub const TOTALY: C2RustUnnamed_1 = 480;
pub const TOTALX: C2RustUnnamed_1 = 640;
#[no_mangle]
pub static mut microoffset: [[int32_t; 16]; 128] = [[0; 16]; 128];
#[no_mangle]
pub static mut mcount: [libc::c_int; 2048] = [0; 2048];
#[no_mangle]
pub static mut mlist: [libc::c_int; 2048] = [0; 2048];
#[no_mangle]
pub static mut mtype: [uint16_t; 2048] = [0; 2048];
#[no_mangle]
pub static mut msize: [libc::c_int; 2048] = [0; 2048];
#[no_mangle]
pub static mut nummicros: libc::c_int = 0;
#[no_mangle]
pub static mut ViewDX: libc::c_int = 0;
#[no_mangle]
pub static mut ViewDY: libc::c_int = 0;
#[no_mangle]
pub static mut ViewBX: libc::c_int = 0;
#[no_mangle]
pub static mut ViewBY: libc::c_int = 0;
#[no_mangle]
pub static mut btmbx: libc::c_int = 0;
#[no_mangle]
pub static mut btmby: libc::c_int = 0;
#[no_mangle]
pub static mut btmdx: libc::c_int = 0;
#[no_mangle]
pub static mut btmdy: libc::c_int = 0;
#[no_mangle]
pub static mut dMT: [[MICROS; 112]; 112] = [[MICROS { mt: [0; 16] }; 112]; 112];
#[no_mangle]
pub static mut dMT2: [MICROS; 12544] = [MICROS { mt: [0; 16] }; 12544];
#[no_mangle]
pub unsafe extern "C" fn FillSolidBlockTbls() {
    let mut dwTiles: uint32_t = 0;
    let mut pSBFile: *mut uint8_t = 0 as *mut uint8_t;
    memset(
        nBlockTable.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 2049]>() as libc::c_ulong,
    );
    memset(
        nSolidTable.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 2049]>() as libc::c_ulong,
    );
    memset(
        nTransTable.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 2049]>() as libc::c_ulong,
    );
    memset(
        nMissileTable.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 2049]>() as libc::c_ulong,
    );
    memset(
        nTrapTable.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 2049]>() as libc::c_ulong,
    );
    match leveltype as libc::c_int {
        0 => {
            pSBFile = LoadFileInMem(
                b"Levels\\TownData\\Town.SOL\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
        }
        1 => {
            pSBFile = LoadFileInMem(
                b"Levels\\L1Data\\L1.SOL\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
        }
        2 => {
            pSBFile = LoadFileInMem(
                b"Levels\\L2Data\\L2.SOL\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
        }
        3 => {
            pSBFile = LoadFileInMem(
                b"Levels\\L3Data\\L3.SOL\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
        }
        4 => {
            pSBFile = LoadFileInMem(
                b"Levels\\L4Data\\L4.SOL\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
        }
        _ => {
            app_fatal_(
                b"src/gendung.c\0" as *const u8 as *const libc::c_char,
                65 as libc::c_int,
                b"FillSolidBlockTbls\0" as *const u8 as *const libc::c_char,
            );
        }
    }
    let mut pTmp: *mut uint8_t = pSBFile;
    let mut d: uint32_t = 1 as libc::c_int as uint32_t;
    while d <= dwTiles {
        let fresh0 = pTmp;
        pTmp = pTmp.offset(1);
        let mut bv: uint8_t = *fresh0;
        if bv as libc::c_int & 0x1 as libc::c_int != 0 as libc::c_int {
            nSolidTable[d as usize] = 1 as libc::c_int as uint8_t;
        }
        if bv as libc::c_int & 0x2 as libc::c_int != 0 as libc::c_int {
            nBlockTable[d as usize] = 1 as libc::c_int as uint8_t;
        }
        if bv as libc::c_int & 0x4 as libc::c_int != 0 as libc::c_int {
            nMissileTable[d as usize] = 1 as libc::c_int as uint8_t;
        }
        if bv as libc::c_int & 0x8 as libc::c_int != 0 as libc::c_int {
            nTransTable[d as usize] = 1 as libc::c_int as uint8_t;
        }
        if bv as libc::c_int & 0x80 as libc::c_int != 0 as libc::c_int {
            nTrapTable[d as usize] = 1 as libc::c_int as uint8_t;
        }
        nWTypeTable[d
            as usize] = ((bv as libc::c_int & 0x70 as libc::c_int) >> 4 as libc::c_int)
            as uint8_t;
        d = d.wrapping_add(1);
        d;
    }
    let mut p__p: *mut libc::c_void = pSBFile as *mut libc::c_void;
    pSBFile = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
}
#[no_mangle]
pub unsafe extern "C" fn GetDungeonMicros(mut pn: libc::c_int) -> *mut uint16_t {
    let mut mtsource: *mut uint16_t = 0 as *mut uint16_t;
    let mut tlen: libc::c_int = 0;
    if leveltype as libc::c_int == 0 as libc::c_int {
        MicroTileLen = 16 as libc::c_int;
        tlen = 16 as libc::c_int;
    } else if leveltype as libc::c_int == 4 as libc::c_int {
        MicroTileLen = 12 as libc::c_int;
        tlen = 16 as libc::c_int;
    } else {
        MicroTileLen = 10 as libc::c_int;
        tlen = 10 as libc::c_int;
    }
    pn -= 1;
    pn;
    mtsource = (pMiniTiles as *mut uint16_t).offset((tlen * pn) as isize);
    return &mut *mtsource.offset((tlen - 2 as libc::c_int) as isize) as *mut uint16_t;
}
#[no_mangle]
pub unsafe extern "C" fn GetMiniTiles(
    mut lv: int32_t,
    mut v1: *mut int32_t,
    mut v2: *mut int32_t,
    mut v3: *mut int32_t,
    mut v4: *mut int32_t,
) {
    let mut mt: *mut uint16_t = 0 as *mut uint16_t;
    lv -= 1;
    lv;
    if leveltype as libc::c_int != 0 as libc::c_int {
        if !(lv >= 0 as libc::c_int) {
            assert_fail(
                122 as libc::c_int,
                b"src/gendung.c\0" as *const u8 as *const libc::c_char,
                b"lv >= 0\0" as *const u8 as *const libc::c_char,
            );
        }
    }
    if lv < 0 as libc::c_int {
        *v1 = 0 as libc::c_int;
        *v2 = 0 as libc::c_int;
        *v3 = 0 as libc::c_int;
        *v4 = 0 as libc::c_int;
        return;
    }
    mt = &mut *pMegaTiles.offset((lv << 3 as libc::c_int) as isize) as *mut uint8_t
        as *mut uint16_t;
    *v1 = *mt.offset(0 as libc::c_int as isize) as libc::c_int + 1 as libc::c_int;
    *v2 = *mt.offset(1 as libc::c_int as isize) as libc::c_int + 1 as libc::c_int;
    *v3 = *mt.offset(2 as libc::c_int as isize) as libc::c_int + 1 as libc::c_int;
    *v4 = *mt.offset(3 as libc::c_int as isize) as libc::c_int + 1 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_InitTrans() {
    memset(
        dTransVal.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong,
    );
    memset(
        TransList.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint8_t; 256]>() as libc::c_ulong,
    );
    TransVal = 1 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_MRectTrans(
    mut x1: libc::c_int,
    mut y1: libc::c_int,
    mut x2: libc::c_int,
    mut y2: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    x1 = (x1 << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int + 1 as libc::c_int;
    y1 = (y1 << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int + 1 as libc::c_int;
    x2 = (x2 << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    y2 = (y2 << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    j = y1;
    while j <= y2 {
        i = x1;
        while i <= x2 {
            dTransVal[i as usize][j as usize] = TransVal;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    TransVal += 1;
    TransVal;
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_MCopyTrans(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut dx: libc::c_int,
    mut dy: libc::c_int,
    mut ul: bool32_t,
    mut ur: bool32_t,
    mut ll: bool32_t,
    mut lr: bool32_t,
) {
    let mut v: int8_t = 0;
    sx = (sx << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    sy = (sy << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    v = dTransVal[sx as usize][sy as usize];
    dx = (dx << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    dy = (dy << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    if ul != 0 {
        dTransVal[dx as usize][dy as usize] = v;
    }
    if ur != 0 {
        dTransVal[(dx + 1 as libc::c_int) as usize][dy as usize] = v;
    }
    if ll != 0 {
        dTransVal[dx as usize][(dy + 1 as libc::c_int) as usize] = v;
    }
    if lr != 0 {
        dTransVal[(dx + 1 as libc::c_int)
            as usize][(dy + 1 as libc::c_int) as usize] = v;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_RectTrans(
    mut x1: libc::c_int,
    mut y1: libc::c_int,
    mut x2: libc::c_int,
    mut y2: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = y1;
    while j <= y2 {
        i = x1;
        while i <= x2 {
            dTransVal[i as usize][j as usize] = TransVal;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    TransVal += 1;
    TransVal;
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_CopyTrans(
    mut sx: libc::c_int,
    mut sy: libc::c_int,
    mut dx: libc::c_int,
    mut dy: libc::c_int,
) {
    dTransVal[dx as usize][dy as usize] = dTransVal[sx as usize][sy as usize];
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_ListTrans(mut num: libc::c_int, mut List: *mut uint8_t) {
    let mut i: libc::c_int = 0;
    let mut x1: uint8_t = 0;
    let mut y1: uint8_t = 0;
    let mut x2: uint8_t = 0;
    let mut y2: uint8_t = 0;
    i = 0 as libc::c_int;
    while i < num {
        let fresh1 = List;
        List = List.offset(1);
        x1 = *fresh1;
        let fresh2 = List;
        List = List.offset(1);
        y1 = *fresh2;
        let fresh3 = List;
        List = List.offset(1);
        x2 = *fresh3;
        let fresh4 = List;
        List = List.offset(1);
        y2 = *fresh4;
        DRLG_RectTrans(
            x1 as libc::c_int,
            y1 as libc::c_int,
            x2 as libc::c_int,
            y2 as libc::c_int,
        );
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_AreaTrans(mut num: libc::c_int, mut List: *mut uint8_t) {
    let mut i: libc::c_int = 0;
    let mut x1: uint8_t = 0;
    let mut y1: uint8_t = 0;
    let mut x2: uint8_t = 0;
    let mut y2: uint8_t = 0;
    i = 0 as libc::c_int;
    while i < num {
        let fresh5 = List;
        List = List.offset(1);
        x1 = *fresh5;
        let fresh6 = List;
        List = List.offset(1);
        y1 = *fresh6;
        let fresh7 = List;
        List = List.offset(1);
        x2 = *fresh7;
        let fresh8 = List;
        List = List.offset(1);
        y2 = *fresh8;
        DRLG_RectTrans(
            x1 as libc::c_int,
            y1 as libc::c_int,
            x2 as libc::c_int,
            y2 as libc::c_int,
        );
        TransVal -= 1;
        TransVal;
        i += 1;
        i;
    }
    TransVal += 1;
    TransVal;
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_InitSetPC() {
    setpc_x = 0 as libc::c_int;
    setpc_y = 0 as libc::c_int;
    setpc_w = 0 as libc::c_int;
    setpc_h = 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_SetPC() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut w: libc::c_int = 0;
    let mut h: libc::c_int = 0;
    w = setpc_w << 1 as libc::c_int;
    h = setpc_h << 1 as libc::c_int;
    x = (setpc_x << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    y = (setpc_y << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    j = 0 as libc::c_int;
    while j < h {
        i = 0 as libc::c_int;
        while i < w {
            dFlags[(x + i)
                as usize][(y + j)
                as usize] = (dFlags[(x + i) as usize][(y + j) as usize] as libc::c_int
                | BFLAG_SETPC as libc::c_int) as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn Make_SetPC(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut w: libc::c_int,
    mut h: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut dx: libc::c_int = 0;
    let mut dy: libc::c_int = 0;
    let mut dh: libc::c_int = 0;
    let mut dw: libc::c_int = 0;
    dw = w << 1 as libc::c_int;
    dh = h << 1 as libc::c_int;
    dx = (x << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    dy = (y << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
    j = 0 as libc::c_int;
    while j < dh {
        i = 0 as libc::c_int;
        while i < dw {
            dFlags[(dx + i)
                as usize][(dy + j)
                as usize] = (dFlags[(dx + i) as usize][(dy + j) as usize] as libc::c_int
                | BFLAG_SETPC as libc::c_int) as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawDungMiniMap(mut floor: uint8_t) {
    let mut i: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut pX: libc::c_int = 0;
    let mut pY: libc::c_int = 0;
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pTo2: *mut uint32_t = 0 as *mut uint32_t;
    let mut clr: uint8_t = 0;
    if gpBuffer.is_null() {
        assert_fail(
            279 as libc::c_int,
            b"src/gendung.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    pTo = &mut *gpBuffer
        .offset(
            (16 as libc::c_int + 64 as libc::c_int
                + (16 as libc::c_int + 160 as libc::c_int) * 768 as libc::c_int) as isize,
        ) as *mut uint32_t;
    x = MDMAXX as libc::c_int;
    while x != 0 as libc::c_int {
        pTo2 = pTo;
        y = MDMAXY as libc::c_int;
        while y != 0 as libc::c_int {
            if dungeon[(MDMAXX as libc::c_int - x)
                as usize][(MDMAXY as libc::c_int - y) as usize] as libc::c_int
                != floor as libc::c_int
            {
                clr = 131 as libc::c_int as uint8_t;
                *pTo.offset(0 as libc::c_int as isize) = gpPalette[clr as usize];
                *pTo.offset(1 as libc::c_int as isize) = gpPalette[clr as usize];
                *pTo.offset(768 as libc::c_int as isize) = gpPalette[clr as usize];
                *pTo
                    .offset(
                        (768 as libc::c_int + 1 as libc::c_int) as isize,
                    ) = gpPalette[clr as usize];
            }
            i = 0 as libc::c_int;
            while i < MAX_PLRS as libc::c_int {
                pX = plr[i as usize]._px;
                pY = plr[i as usize]._py;
                if !(pX == 0 as libc::c_int && pY == 0 as libc::c_int) {
                    if x
                        == MDMAXX as libc::c_int
                            - (pX - 16 as libc::c_int >> 1 as libc::c_int)
                        && y
                            == MDMAXY as libc::c_int
                                - (pY - 16 as libc::c_int >> 1 as libc::c_int)
                    {
                        if i == 0 as libc::c_int {
                            clr = 240 as libc::c_int as uint8_t;
                        } else if i == 1 as libc::c_int {
                            clr = 139 as libc::c_int as uint8_t;
                        } else if i == 2 as libc::c_int {
                            clr = 154 as libc::c_int as uint8_t;
                        } else {
                            clr = 147 as libc::c_int as uint8_t;
                        }
                        *pTo.offset(0 as libc::c_int as isize) = gpPalette[clr as usize];
                        *pTo.offset(1 as libc::c_int as isize) = gpPalette[clr as usize];
                        *pTo
                            .offset(
                                768 as libc::c_int as isize,
                            ) = gpPalette[clr as usize];
                        *pTo
                            .offset(
                                (768 as libc::c_int + 1 as libc::c_int) as isize,
                            ) = gpPalette[clr as usize];
                        break;
                    }
                }
                i += 1;
                i;
            }
            pTo = pTo.offset((2 as libc::c_int * 768 as libc::c_int) as isize);
            y -= 1;
            y;
        }
        pTo = pTo2.offset(2 as libc::c_int as isize);
        x -= 1;
        x;
    }
    pTo = &mut *gpBuffer
        .offset(
            (16 as libc::c_int + 64 as libc::c_int
                + (120 as libc::c_int + 160 as libc::c_int) * 768 as libc::c_int)
                as isize,
        ) as *mut uint32_t;
    x = MDMAXX as libc::c_int;
    while x != 0 as libc::c_int {
        pTo2 = pTo;
        y = MDMAXY as libc::c_int;
        while y != 0 as libc::c_int {
            if dungeon[(MDMAXX as libc::c_int - x)
                as usize][(MDMAXY as libc::c_int - y) as usize] as libc::c_int
                != 0 as libc::c_int
            {
                *pTo = gpPalette[229 as libc::c_int as usize];
            }
            pTo = pTo.offset(768 as libc::c_int as isize);
            y -= 1;
            y;
        }
        pTo = pTo2.offset(1 as libc::c_int as isize);
        x -= 1;
        x;
    }
    pTo = &mut *gpBuffer
        .offset(
            (16 as libc::c_int + 64 as libc::c_int
                + (120 as libc::c_int + 160 as libc::c_int) * 768 as libc::c_int)
                as isize,
        ) as *mut uint32_t;
    x = MDMAXX as libc::c_int;
    while x != 0 as libc::c_int {
        pTo2 = pTo;
        y = MDMAXY as libc::c_int;
        while y != 0 as libc::c_int {
            if dflags[(MDMAXX as libc::c_int - x)
                as usize][(MDMAXY as libc::c_int - y) as usize] as libc::c_int
                != 0 as libc::c_int
            {
                *pTo = gpPalette[146 as libc::c_int as usize];
            }
            pTo = pTo.offset(768 as libc::c_int as isize);
            y -= 1;
            y;
        }
        pTo = pTo2.offset(1 as libc::c_int as isize);
        x -= 1;
        x;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_WillThemeRoomFit(
    mut floor: libc::c_int,
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut minSize: libc::c_int,
    mut maxSize: libc::c_int,
    mut width: *mut libc::c_int,
    mut height: *mut libc::c_int,
) -> bool32_t {
    let mut ii: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    let mut xSmallest: libc::c_int = 0;
    let mut ySmallest: libc::c_int = 0;
    let mut xArray: [libc::c_int; 20] = [0; 20];
    let mut yArray: [libc::c_int; 20] = [0; 20];
    let mut xCount: libc::c_int = 0 as libc::c_int;
    let mut yCount: libc::c_int = 0 as libc::c_int;
    let mut yFlag: bool32_t = 1 as libc::c_int as bool32_t;
    let mut xFlag: bool32_t = 1 as libc::c_int as bool32_t;
    if SkipThemeRoom(x, y) == 0 {
        return 0 as libc::c_int as bool32_t;
    }
    memset(
        xArray.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[libc::c_int; 20]>() as libc::c_ulong,
    );
    memset(
        yArray.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[libc::c_int; 20]>() as libc::c_ulong,
    );
    ii = 0 as libc::c_int;
    while ii < maxSize {
        if xFlag != 0 {
            xx = x;
            while xx < x + maxSize {
                let mut yy_0: libc::c_int = y + ii;
                if MegaTileMapContains(xx, yy_0) {
                    if dungeon[xx as usize][yy_0 as usize] as libc::c_int != floor {
                        if !(xx < minSize) {
                            break;
                        }
                        xFlag = 0 as libc::c_int as bool32_t;
                    } else {
                        xCount += 1;
                        xCount;
                    }
                }
                xx += 1;
                xx;
            }
            if xFlag != 0 {
                xArray[ii as usize] = xCount;
                xCount = 0 as libc::c_int;
            }
        }
        if yFlag != 0 {
            yy = y;
            while yy < y + maxSize {
                let mut xx_0: libc::c_int = x + ii;
                if MegaTileMapContains(xx_0, yy) {
                    if dungeon[xx_0 as usize][yy as usize] as libc::c_int != floor {
                        if !(yy < minSize) {
                            break;
                        }
                        yFlag = 0 as libc::c_int as bool32_t;
                    } else {
                        yCount += 1;
                        yCount;
                    }
                }
                yy += 1;
                yy;
            }
            if yFlag != 0 {
                yArray[ii as usize] = yCount;
                yCount = 0 as libc::c_int;
            }
        }
        ii += 1;
        ii;
    }
    ii = 0 as libc::c_int;
    while ii < minSize {
        if xArray[ii as usize] < minSize || yArray[ii as usize] < minSize {
            return 0 as libc::c_int as bool32_t;
        }
        ii += 1;
        ii;
    }
    xSmallest = xArray[0 as libc::c_int as usize];
    ySmallest = yArray[0 as libc::c_int as usize];
    ii = 0 as libc::c_int;
    while ii < maxSize {
        if !(xArray[ii as usize] >= minSize && yArray[ii as usize] >= minSize) {
            break;
        }
        if xArray[ii as usize] < xSmallest {
            xSmallest = xArray[ii as usize];
        }
        if yArray[ii as usize] < ySmallest {
            ySmallest = yArray[ii as usize];
        }
        ii += 1;
        ii;
    }
    *width = xSmallest - 2 as libc::c_int;
    *height = ySmallest - 2 as libc::c_int;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_CreateThemeRoom(mut themeIndex: libc::c_int) {
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    yy = themeLoc[themeIndex as usize].y;
    while yy < themeLoc[themeIndex as usize].y + themeLoc[themeIndex as usize].height {
        xx = themeLoc[themeIndex as usize].x;
        while xx < themeLoc[themeIndex as usize].x + themeLoc[themeIndex as usize].width
        {
            if leveltype as libc::c_int == 2 as libc::c_int {
                if yy == themeLoc[themeIndex as usize].y
                    && (xx >= themeLoc[themeIndex as usize].x
                        && xx
                            <= themeLoc[themeIndex as usize].x
                                + themeLoc[themeIndex as usize].width)
                    || yy
                        == themeLoc[themeIndex as usize].y
                            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int)
                        && (xx >= themeLoc[themeIndex as usize].x
                            && xx
                                <= themeLoc[themeIndex as usize].x
                                    + themeLoc[themeIndex as usize].width)
                {
                    dungeon[xx as usize][yy as usize] = 2 as libc::c_int as uint8_t;
                } else if xx == themeLoc[themeIndex as usize].x
                    && (yy >= themeLoc[themeIndex as usize].y
                        && yy
                            <= themeLoc[themeIndex as usize].y
                                + themeLoc[themeIndex as usize].height)
                    || xx
                        == themeLoc[themeIndex as usize].x
                            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int)
                        && (yy >= themeLoc[themeIndex as usize].y
                            && yy
                                <= themeLoc[themeIndex as usize].y
                                    + themeLoc[themeIndex as usize].height)
                {
                    dungeon[xx as usize][yy as usize] = 1 as libc::c_int as uint8_t;
                } else {
                    dungeon[xx as usize][yy as usize] = 3 as libc::c_int as uint8_t;
                }
            }
            if leveltype as libc::c_int == 3 as libc::c_int {
                if yy == themeLoc[themeIndex as usize].y
                    && (xx >= themeLoc[themeIndex as usize].x
                        && xx
                            <= themeLoc[themeIndex as usize].x
                                + themeLoc[themeIndex as usize].width)
                    || yy
                        == themeLoc[themeIndex as usize].y
                            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int)
                        && (xx >= themeLoc[themeIndex as usize].x
                            && xx
                                <= themeLoc[themeIndex as usize].x
                                    + themeLoc[themeIndex as usize].width)
                {
                    dungeon[xx as usize][yy as usize] = 134 as libc::c_int as uint8_t;
                } else if xx == themeLoc[themeIndex as usize].x
                    && (yy >= themeLoc[themeIndex as usize].y
                        && yy
                            <= themeLoc[themeIndex as usize].y
                                + themeLoc[themeIndex as usize].height)
                    || xx
                        == themeLoc[themeIndex as usize].x
                            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int)
                        && (yy >= themeLoc[themeIndex as usize].y
                            && yy
                                <= themeLoc[themeIndex as usize].y
                                    + themeLoc[themeIndex as usize].height)
                {
                    dungeon[xx as usize][yy as usize] = 137 as libc::c_int as uint8_t;
                } else {
                    dungeon[xx as usize][yy as usize] = 7 as libc::c_int as uint8_t;
                }
            }
            if leveltype as libc::c_int == 4 as libc::c_int {
                if yy == themeLoc[themeIndex as usize].y
                    && (xx >= themeLoc[themeIndex as usize].x
                        && xx
                            <= themeLoc[themeIndex as usize].x
                                + themeLoc[themeIndex as usize].width)
                    || yy
                        == themeLoc[themeIndex as usize].y
                            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int)
                        && (xx >= themeLoc[themeIndex as usize].x
                            && xx
                                <= themeLoc[themeIndex as usize].x
                                    + themeLoc[themeIndex as usize].width)
                {
                    dungeon[xx as usize][yy as usize] = 2 as libc::c_int as uint8_t;
                } else if xx == themeLoc[themeIndex as usize].x
                    && (yy >= themeLoc[themeIndex as usize].y
                        && yy
                            <= themeLoc[themeIndex as usize].y
                                + themeLoc[themeIndex as usize].height)
                    || xx
                        == themeLoc[themeIndex as usize].x
                            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int)
                        && (yy >= themeLoc[themeIndex as usize].y
                            && yy
                                <= themeLoc[themeIndex as usize].y
                                    + themeLoc[themeIndex as usize].height)
                {
                    dungeon[xx as usize][yy as usize] = 1 as libc::c_int as uint8_t;
                } else {
                    dungeon[xx as usize][yy as usize] = 6 as libc::c_int as uint8_t;
                }
            }
            xx += 1;
            xx;
        }
        yy += 1;
        yy;
    }
    if leveltype as libc::c_int == 2 as libc::c_int {
        dungeon[themeLoc[themeIndex as usize].x
            as usize][themeLoc[themeIndex as usize].y
            as usize] = 8 as libc::c_int as uint8_t;
        dungeon[(themeLoc[themeIndex as usize].x
            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
            as usize][themeLoc[themeIndex as usize].y
            as usize] = 7 as libc::c_int as uint8_t;
        dungeon[themeLoc[themeIndex as usize].x
            as usize][(themeLoc[themeIndex as usize].y
            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
            as usize] = 9 as libc::c_int as uint8_t;
        dungeon[(themeLoc[themeIndex as usize].x
            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
            as usize][(themeLoc[themeIndex as usize].y
            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
            as usize] = 6 as libc::c_int as uint8_t;
    }
    if leveltype as libc::c_int == 3 as libc::c_int {
        dungeon[themeLoc[themeIndex as usize].x
            as usize][themeLoc[themeIndex as usize].y
            as usize] = 150 as libc::c_int as uint8_t;
        dungeon[(themeLoc[themeIndex as usize].x
            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
            as usize][themeLoc[themeIndex as usize].y
            as usize] = 151 as libc::c_int as uint8_t;
        dungeon[themeLoc[themeIndex as usize].x
            as usize][(themeLoc[themeIndex as usize].y
            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
            as usize] = 152 as libc::c_int as uint8_t;
        dungeon[(themeLoc[themeIndex as usize].x
            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
            as usize][(themeLoc[themeIndex as usize].y
            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
            as usize] = 138 as libc::c_int as uint8_t;
    }
    if leveltype as libc::c_int == 4 as libc::c_int {
        dungeon[themeLoc[themeIndex as usize].x
            as usize][themeLoc[themeIndex as usize].y
            as usize] = 9 as libc::c_int as uint8_t;
        dungeon[(themeLoc[themeIndex as usize].x
            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
            as usize][themeLoc[themeIndex as usize].y
            as usize] = 16 as libc::c_int as uint8_t;
        dungeon[themeLoc[themeIndex as usize].x
            as usize][(themeLoc[themeIndex as usize].y
            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
            as usize] = 15 as libc::c_int as uint8_t;
        dungeon[(themeLoc[themeIndex as usize].x
            + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
            as usize][(themeLoc[themeIndex as usize].y
            + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
            as usize] = 12 as libc::c_int as uint8_t;
    }
    if leveltype as libc::c_int == 2 as libc::c_int {
        match random_(
            b"src/gendung.c\0" as *const u8 as *const libc::c_char,
            544 as libc::c_int,
            0 as libc::c_int as uint8_t,
            2 as libc::c_int,
        ) {
            0 => {
                dungeon[(themeLoc[themeIndex as usize].x
                    + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
                    as usize][(themeLoc[themeIndex as usize].y
                    + themeLoc[themeIndex as usize].height / 2 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            1 => {
                dungeon[(themeLoc[themeIndex as usize].x
                    + themeLoc[themeIndex as usize].width / 2 as libc::c_int)
                    as usize][(themeLoc[themeIndex as usize].y
                    + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
                    as usize] = 5 as libc::c_int as uint8_t;
            }
            _ => {}
        }
    }
    if leveltype as libc::c_int == 3 as libc::c_int {
        match random_(
            b"src/gendung.c\0" as *const u8 as *const libc::c_char,
            556 as libc::c_int,
            0 as libc::c_int as uint8_t,
            2 as libc::c_int,
        ) {
            0 => {
                dungeon[(themeLoc[themeIndex as usize].x
                    + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
                    as usize][(themeLoc[themeIndex as usize].y
                    + themeLoc[themeIndex as usize].height / 2 as libc::c_int)
                    as usize] = 147 as libc::c_int as uint8_t;
            }
            1 => {
                dungeon[(themeLoc[themeIndex as usize].x
                    + themeLoc[themeIndex as usize].width / 2 as libc::c_int)
                    as usize][(themeLoc[themeIndex as usize].y
                    + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
                    as usize] = 146 as libc::c_int as uint8_t;
            }
            _ => {}
        }
    }
    if leveltype as libc::c_int == 4 as libc::c_int {
        match random_(
            b"src/gendung.c\0" as *const u8 as *const libc::c_char,
            568 as libc::c_int,
            0 as libc::c_int as uint8_t,
            2 as libc::c_int,
        ) {
            0 => {
                dungeon[(themeLoc[themeIndex as usize].x
                    + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
                    as usize][(themeLoc[themeIndex as usize].y
                    + themeLoc[themeIndex as usize].height / 2 as libc::c_int
                    - 1 as libc::c_int) as usize] = 53 as libc::c_int as uint8_t;
                dungeon[(themeLoc[themeIndex as usize].x
                    + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
                    as usize][(themeLoc[themeIndex as usize].y
                    + themeLoc[themeIndex as usize].height / 2 as libc::c_int)
                    as usize] = 6 as libc::c_int as uint8_t;
                dungeon[(themeLoc[themeIndex as usize].x
                    + (themeLoc[themeIndex as usize].width - 1 as libc::c_int))
                    as usize][(themeLoc[themeIndex as usize].y
                    + themeLoc[themeIndex as usize].height / 2 as libc::c_int
                    + 1 as libc::c_int) as usize] = 52 as libc::c_int as uint8_t;
                dungeon[(themeLoc[themeIndex as usize].x
                    + (themeLoc[themeIndex as usize].width - 2 as libc::c_int))
                    as usize][(themeLoc[themeIndex as usize].y
                    + themeLoc[themeIndex as usize].height / 2 as libc::c_int
                    - 1 as libc::c_int) as usize] = 54 as libc::c_int as uint8_t;
            }
            1 => {
                dungeon[(themeLoc[themeIndex as usize].x
                    + themeLoc[themeIndex as usize].width / 2 as libc::c_int
                    - 1 as libc::c_int)
                    as usize][(themeLoc[themeIndex as usize].y
                    + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
                    as usize] = 57 as libc::c_int as uint8_t;
                dungeon[(themeLoc[themeIndex as usize].x
                    + themeLoc[themeIndex as usize].width / 2 as libc::c_int)
                    as usize][(themeLoc[themeIndex as usize].y
                    + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
                    as usize] = 6 as libc::c_int as uint8_t;
                dungeon[(themeLoc[themeIndex as usize].x
                    + themeLoc[themeIndex as usize].width / 2 as libc::c_int
                    + 1 as libc::c_int)
                    as usize][(themeLoc[themeIndex as usize].y
                    + (themeLoc[themeIndex as usize].height - 1 as libc::c_int))
                    as usize] = 56 as libc::c_int as uint8_t;
                dungeon[(themeLoc[themeIndex as usize].x
                    + themeLoc[themeIndex as usize].width / 2 as libc::c_int)
                    as usize][(themeLoc[themeIndex as usize].y
                    + (themeLoc[themeIndex as usize].height - 2 as libc::c_int))
                    as usize] = 59 as libc::c_int as uint8_t;
                dungeon[(themeLoc[themeIndex as usize].x
                    + themeLoc[themeIndex as usize].width / 2 as libc::c_int
                    - 1 as libc::c_int)
                    as usize][(themeLoc[themeIndex as usize].y
                    + (themeLoc[themeIndex as usize].height - 2 as libc::c_int))
                    as usize] = 58 as libc::c_int as uint8_t;
            }
            _ => {}
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_PlaceThemeRooms(
    mut minSize: libc::c_int,
    mut maxSize: libc::c_int,
    mut floor: libc::c_int,
    mut freq: libc::c_int,
    mut rndSize: bool32_t,
) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut themeW: libc::c_int = 0;
    let mut themeH: libc::c_int = 0;
    themeCount = 0 as libc::c_int;
    memset(
        themeLoc.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<THEME_LOC>() as libc::c_ulong,
    );
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == floor
                && random_(
                    b"src/gendung.c\0" as *const u8 as *const libc::c_char,
                    617 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    freq,
                ) == 0
            {
                if DRLG_WillThemeRoomFit(
                    floor,
                    i,
                    j,
                    minSize,
                    maxSize,
                    &mut themeW,
                    &mut themeH,
                ) != 0
                {
                    if rndSize != 0 {
                        let mut rv1: libc::c_int = 0;
                        let mut rv2: libc::c_int = 0;
                        let mut min: libc::c_int = 0;
                        let mut max: libc::c_int = 0;
                        min = minSize - 2 as libc::c_int;
                        max = maxSize - 2 as libc::c_int;
                        rv1 = random_(
                            b"src/gendung.c\0" as *const u8 as *const libc::c_char,
                            626 as libc::c_int,
                            0 as libc::c_int as uint8_t,
                            themeW - min + 1 as libc::c_int,
                        );
                        rv2 = min
                            + random_(
                                b"src/gendung.c\0" as *const u8 as *const libc::c_char,
                                627 as libc::c_int,
                                0 as libc::c_int as uint8_t,
                                rv1,
                            );
                        if rv2 < min || rv2 > max {
                            themeW = min;
                        } else {
                            themeW = rv2;
                        }
                        rv1 = random_(
                            b"src/gendung.c\0" as *const u8 as *const libc::c_char,
                            634 as libc::c_int,
                            0 as libc::c_int as uint8_t,
                            themeH - min + 1 as libc::c_int,
                        );
                        rv2 = min
                            + random_(
                                b"src/gendung.c\0" as *const u8 as *const libc::c_char,
                                635 as libc::c_int,
                                0 as libc::c_int as uint8_t,
                                rv1,
                            );
                        if rv2 < min || rv2 > max {
                            themeH = min;
                        } else {
                            themeH = rv2;
                        }
                    }
                    themeLoc[themeCount as usize].x = i + 1 as libc::c_int;
                    themeLoc[themeCount as usize].y = j + 1 as libc::c_int;
                    themeLoc[themeCount as usize].width = themeW;
                    themeLoc[themeCount as usize].height = themeH;
                    if leveltype as libc::c_int == 3 as libc::c_int {
                        DRLG_RectTrans(
                            ((i + 2 as libc::c_int) << 1 as libc::c_int)
                                + DIRTEDGED2 as libc::c_int,
                            ((j + 2 as libc::c_int) << 1 as libc::c_int)
                                + DIRTEDGED2 as libc::c_int,
                            ((i + themeW - 1 as libc::c_int) << 1 as libc::c_int)
                                + DIRTEDGED2 as libc::c_int + 1 as libc::c_int,
                            ((j + themeH - 1 as libc::c_int) << 1 as libc::c_int)
                                + DIRTEDGED2 as libc::c_int + 1 as libc::c_int,
                        );
                    } else {
                        DRLG_MRectTrans(
                            i + 1 as libc::c_int,
                            j + 1 as libc::c_int,
                            i + themeW,
                            j + themeH,
                        );
                    }
                    themeLoc[themeCount as usize]
                        .ttval = TransVal as libc::c_int - 1 as libc::c_int;
                    DRLG_CreateThemeRoom(themeCount);
                    themeCount += 1;
                    themeCount;
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_HoldThemeRooms() {
    let mut i: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    if themeCount > 0 as libc::c_int {
        i = 0 as libc::c_int;
        while i < themeCount {
            y = themeLoc[i as usize].y;
            while y
                < themeLoc[i as usize].y + themeLoc[i as usize].height - 1 as libc::c_int
            {
                x = themeLoc[i as usize].x;
                while x
                    < themeLoc[i as usize].x + themeLoc[i as usize].width
                        - 1 as libc::c_int
                {
                    xx = (x << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
                    yy = (y << 1 as libc::c_int) + DIRTEDGED2 as libc::c_int;
                    dFlags[xx
                        as usize][yy
                        as usize] = (dFlags[xx as usize][yy as usize] as libc::c_int
                        | BFLAG_SETPC as libc::c_int) as int8_t;
                    dFlags[(xx + 1 as libc::c_int)
                        as usize][yy
                        as usize] = (dFlags[(xx + 1 as libc::c_int)
                        as usize][yy as usize] as libc::c_int
                        | BFLAG_SETPC as libc::c_int) as int8_t;
                    dFlags[xx
                        as usize][(yy + 1 as libc::c_int)
                        as usize] = (dFlags[xx
                        as usize][(yy + 1 as libc::c_int) as usize] as libc::c_int
                        | BFLAG_SETPC as libc::c_int) as int8_t;
                    dFlags[(xx + 1 as libc::c_int)
                        as usize][(yy + 1 as libc::c_int)
                        as usize] = (dFlags[(xx + 1 as libc::c_int)
                        as usize][(yy + 1 as libc::c_int) as usize] as libc::c_int
                        | BFLAG_SETPC as libc::c_int) as int8_t;
                    x += 1;
                    x;
                }
                y += 1;
                y;
            }
            i += 1;
            i;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn SkipThemeRoom(
    mut x: libc::c_int,
    mut y: libc::c_int,
) -> bool32_t {
    let mut i: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < themeCount {
        if x >= themeLoc[i as usize].x - 2 as libc::c_int
            && x
                <= themeLoc[i as usize].x + themeLoc[i as usize].width + 2 as libc::c_int
            && (y >= themeLoc[i as usize].y - 2 as libc::c_int
                && y
                    <= themeLoc[i as usize].y + themeLoc[i as usize].height
                        + 2 as libc::c_int)
        {
            return 0 as libc::c_int as bool32_t;
        }
        i += 1;
        i;
    }
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn InitLevels() {
    currlevel = 0 as libc::c_int as uint8_t;
    leveltype = 0 as libc::c_int as uint8_t;
    setlevel = 0 as libc::c_int as uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn append_missile(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut missile_num: libc::c_int,
) {
    let mut new_node: *mut MissileNode = calloc(
        1 as libc::c_int as libc::c_ulong,
        ::core::mem::size_of::<MissileNode>() as libc::c_ulong,
    ) as *mut MissileNode;
    (*new_node).missile_num = missile_num as int8_t;
    (*new_node).next = 0 as *mut MissileNode;
    let mut head: *mut MissileNode = dMissile[x as usize][y as usize];
    if head.is_null() {
        dMissile[x as usize][y as usize] = new_node;
        return;
    }
    let mut node: *mut MissileNode = head;
    while !((*node).next).is_null() {
        node = (*node).next;
    }
    (*node).next = new_node;
}
