use ::libc;
extern "C" {
    fn strcpy(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn strlen(_: *const libc::c_char) -> libc::c_ulong;
    fn DrawPanelFont(poffset: int32_t, nCel: int32_t, clr: int8_t);
    fn DrawCel(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn TDrawRect(x: libc::c_int, y: libc::c_int, w: libc::c_int, h: libc::c_int);
    static gbFontTransTbl: [uint8_t; 256];
    static fonttrans: [uint8_t; 128];
    static fontkern: [uint8_t; 68];
    static mut tempstr: [libc::c_char; 256];
    static mut msgdelay: int8_t;
    static mut msgflag: int8_t;
    static mut nBuffWTbl: [int32_t; 1024];
    static mut pSTextSlidCels: *mut uint8_t;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type C2RustUnnamed = libc::c_uint;
pub const ICOLOR_GOLD: C2RustUnnamed = 3;
pub const ICOLOR_RED: C2RustUnnamed = 2;
pub const ICOLOR_BLUE: C2RustUnnamed = 1;
pub const ICOLOR_WHITE: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const MSGCNT: C2RustUnnamed_0 = 70;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const MSG_INBONE: C2RustUnnamed_1 = 43;
pub const MSG_TRIG3: C2RustUnnamed_1 = 42;
pub const MSG_TRIG2: C2RustUnnamed_1 = 41;
pub const MSG_TRIG1: C2RustUnnamed_1 = 40;
pub const SHRINE_26B: C2RustUnnamed_1 = 39;
pub const SHRINE_26: C2RustUnnamed_1 = 38;
pub const SHRINE_25: C2RustUnnamed_1 = 37;
pub const SHRINE_24: C2RustUnnamed_1 = 36;
pub const SHRINE_23: C2RustUnnamed_1 = 35;
pub const SHRINE_22: C2RustUnnamed_1 = 34;
pub const SHRINE_21: C2RustUnnamed_1 = 33;
pub const SHRINE_20: C2RustUnnamed_1 = 32;
pub const SHRINE_19B: C2RustUnnamed_1 = 31;
pub const SHRINE_19: C2RustUnnamed_1 = 30;
pub const SHRINE_18: C2RustUnnamed_1 = 29;
pub const SHRINE_17: C2RustUnnamed_1 = 28;
pub const SHRINE_16: C2RustUnnamed_1 = 27;
pub const SHRINE_15: C2RustUnnamed_1 = 26;
pub const SHRINE_14: C2RustUnnamed_1 = 25;
pub const SHRINE_13: C2RustUnnamed_1 = 24;
pub const SHRINE_12: C2RustUnnamed_1 = 23;
pub const SHRINE_11: C2RustUnnamed_1 = 22;
pub const SHRINE_10: C2RustUnnamed_1 = 21;
pub const SHRINE_9: C2RustUnnamed_1 = 20;
pub const SHRINE_8: C2RustUnnamed_1 = 19;
pub const SHRINE_7: C2RustUnnamed_1 = 18;
pub const SHRINE_6: C2RustUnnamed_1 = 17;
pub const SHRINE_5: C2RustUnnamed_1 = 16;
pub const SHRINE_4: C2RustUnnamed_1 = 15;
pub const SHRINE_3: C2RustUnnamed_1 = 14;
pub const SHRINE_2: C2RustUnnamed_1 = 13;
pub const SHRINE_1: C2RustUnnamed_1 = 12;
pub const MSG_SAVEGAME: C2RustUnnamed_1 = 11;
pub const MSG_LOADGAME: C2RustUnnamed_1 = 10;
pub const MSG_MULTIPAUSE: C2RustUnnamed_1 = 9;
pub const MSG_SYNC: C2RustUnnamed_1 = 8;
pub const MSG_HDRIVE: C2RustUnnamed_1 = 7;
pub const MSG_NOPAUSE: C2RustUnnamed_1 = 6;
pub const MSG_SAVESIZE: C2RustUnnamed_1 = 5;
pub const MSG_SHAREWARE: C2RustUnnamed_1 = 4;
pub const MSG_SOUND: C2RustUnnamed_1 = 3;
pub const MSG_MULTIBTN: C2RustUnnamed_1 = 2;
pub const MSG_AMAPTWN: C2RustUnnamed_1 = 1;
pub const MSG_NONE: C2RustUnnamed_1 = 0;
#[no_mangle]
pub static mut MsgStrings: [*const libc::c_char; 44] = [
    b"\0" as *const u8 as *const libc::c_char,
    b"No automap available in town\0" as *const u8 as *const libc::c_char,
    b"No multiplayer functions in demo\0" as *const u8 as *const libc::c_char,
    b"Direct Sound Creation Failed\0" as *const u8 as *const libc::c_char,
    b"Not available in shareware version\0" as *const u8 as *const libc::c_char,
    b"Not enough space to save\0" as *const u8 as *const libc::c_char,
    b"No Pause in town\0" as *const u8 as *const libc::c_char,
    b"Copying to a hard disk is recommended\0" as *const u8 as *const libc::c_char,
    b"Multiplayer sync problem\0" as *const u8 as *const libc::c_char,
    b"No pause in multiplayer\0" as *const u8 as *const libc::c_char,
    b"Loading...\0" as *const u8 as *const libc::c_char,
    b"Saving...\0" as *const u8 as *const libc::c_char,
    b"Some are weakened as one grows strong\0" as *const u8 as *const libc::c_char,
    b"New strength is forged through destruction\0" as *const u8 as *const libc::c_char,
    b"Those who defend seldom attack\0" as *const u8 as *const libc::c_char,
    b"The sword of justice is swift and sharp\0" as *const u8 as *const libc::c_char,
    b"While the spirit is vigilant the body thrives\0" as *const u8
        as *const libc::c_char,
    b"The powers of mana refocused renews\0" as *const u8 as *const libc::c_char,
    b"Time cannot diminish the power of steel\0" as *const u8 as *const libc::c_char,
    b"Magic is not always what it seems to be\0" as *const u8 as *const libc::c_char,
    b"What once was opened now is closed\0" as *const u8 as *const libc::c_char,
    b"Intensity comes at the cost of wisdom\0" as *const u8 as *const libc::c_char,
    b"Arcane power brings destruction\0" as *const u8 as *const libc::c_char,
    b"That which cannot be held cannot be harmed\0" as *const u8 as *const libc::c_char,
    b"Crimson and Azure become as the sun\0" as *const u8 as *const libc::c_char,
    b"Knowledge and wisdom at the cost of self\0" as *const u8 as *const libc::c_char,
    b"Drink and be refreshed\0" as *const u8 as *const libc::c_char,
    b"Wherever you go, there you are\0" as *const u8 as *const libc::c_char,
    b"Energy comes at the cost of wisdom\0" as *const u8 as *const libc::c_char,
    b"Riches abound when least expected\0" as *const u8 as *const libc::c_char,
    b"Where avarice fails, patience gains reward\0" as *const u8 as *const libc::c_char,
    b"Blessed by a benevolent companion!\0" as *const u8 as *const libc::c_char,
    b"The hands of men may be guided by fate\0" as *const u8 as *const libc::c_char,
    b"Strength is bolstered by heavenly faith\0" as *const u8 as *const libc::c_char,
    b"The essence of life flows from within\0" as *const u8 as *const libc::c_char,
    b"The way is made clear when viewed from above\0" as *const u8
        as *const libc::c_char,
    b"Salvation comes at the cost of wisdom\0" as *const u8 as *const libc::c_char,
    b"Mysteries are revealed in the light of reason\0" as *const u8
        as *const libc::c_char,
    b"Those who are last may yet be first\0" as *const u8 as *const libc::c_char,
    b"Generosity brings its own rewards\0" as *const u8 as *const libc::c_char,
    b"You must be at least level 8 to use this.\0" as *const u8 as *const libc::c_char,
    b"You must be at least level 13 to use this.\0" as *const u8 as *const libc::c_char,
    b"You must be at least level 17 to use this.\0" as *const u8 as *const libc::c_char,
    b"Arcane knowledge gained!\0" as *const u8 as *const libc::c_char,
];
#[no_mangle]
pub static mut msgtable: [int8_t; 80] = [0; 80];
#[no_mangle]
pub static mut msgcnt: int8_t = 0 as libc::c_int as int8_t;
#[no_mangle]
pub unsafe extern "C" fn InitDiabloMsg(mut e: int8_t) {
    let mut i: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < msgcnt as libc::c_int {
        if msgtable[i as usize] as libc::c_int == e as libc::c_int {
            return;
        }
        i += 1;
        i;
    }
    msgtable[msgcnt as usize] = e;
    if (msgcnt as libc::c_int) < 80 as libc::c_int {
        msgcnt += 1;
        msgcnt;
    }
    msgflag = msgtable[0 as libc::c_int as usize];
    msgdelay = MSGCNT as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn ClrDiabloMsg() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 80 as libc::c_int {
        msgtable[i as usize] = MSG_NONE as libc::c_int as int8_t;
        i += 1;
        i;
    }
    msgflag = MSG_NONE as libc::c_int as int8_t;
    msgcnt = 0 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn DrawDiabloMsg() {
    let mut i: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut boffset: int32_t = 0;
    let mut sl: libc::c_int = 0;
    let mut tw: libc::c_int = 0;
    DrawCel(
        165 as libc::c_int,
        318 as libc::c_int,
        pSTextSlidCels,
        1 as libc::c_int,
        12 as libc::c_int,
    );
    DrawCel(
        591 as libc::c_int,
        318 as libc::c_int,
        pSTextSlidCels,
        4 as libc::c_int,
        12 as libc::c_int,
    );
    DrawCel(
        165 as libc::c_int,
        366 as libc::c_int,
        pSTextSlidCels,
        2 as libc::c_int,
        12 as libc::c_int,
    );
    DrawCel(
        591 as libc::c_int,
        366 as libc::c_int,
        pSTextSlidCels,
        3 as libc::c_int,
        12 as libc::c_int,
    );
    x = 173 as libc::c_int;
    i = 0 as libc::c_int;
    while i < 35 as libc::c_int {
        DrawCel(
            x,
            318 as libc::c_int,
            pSTextSlidCels,
            5 as libc::c_int,
            12 as libc::c_int,
        );
        DrawCel(
            x,
            366 as libc::c_int,
            pSTextSlidCels,
            7 as libc::c_int,
            12 as libc::c_int,
        );
        x += 12 as libc::c_int;
        i += 1;
        i;
    }
    y = 330 as libc::c_int;
    i = 0 as libc::c_int;
    while i < 3 as libc::c_int {
        DrawCel(
            165 as libc::c_int,
            y,
            pSTextSlidCels,
            6 as libc::c_int,
            12 as libc::c_int,
        );
        DrawCel(
            591 as libc::c_int,
            y,
            pSTextSlidCels,
            8 as libc::c_int,
            12 as libc::c_int,
        );
        y += 12 as libc::c_int;
        i += 1;
        i;
    }
    TDrawRect(
        104 as libc::c_int,
        150 as libc::c_int,
        432 as libc::c_int,
        54 as libc::c_int,
    );
    strcpy(tempstr.as_mut_ptr(), MsgStrings[msgflag as usize]);
    boffset = nBuffWTbl[342 as libc::c_int as usize] + 165 as libc::c_int;
    sl = strlen(tempstr.as_mut_ptr()) as libc::c_int;
    tw = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < sl {
        let mut c: uint8_t = gbFontTransTbl[tempstr[i as usize] as uint8_t as usize];
        c = fonttrans[c as usize];
        tw += fontkern[c as usize] as libc::c_int + 1 as libc::c_int;
        i += 1;
        i;
    }
    if tw < 442 as libc::c_int {
        boffset += 442 as libc::c_int - tw >> 1 as libc::c_int;
    }
    i = 0 as libc::c_int;
    while i < sl {
        let mut c_0: uint8_t = gbFontTransTbl[tempstr[i as usize] as uint8_t as usize];
        c_0 = fonttrans[c_0 as usize];
        if c_0 != 0 {
            DrawPanelFont(boffset, c_0 as int32_t, ICOLOR_GOLD as libc::c_int as int8_t);
        }
        boffset += fontkern[c_0 as usize] as libc::c_int + 1 as libc::c_int;
        i += 1;
        i;
    }
    if msgdelay as libc::c_int > 0 as libc::c_int {
        msgdelay -= 1;
        msgdelay;
    }
    if msgdelay as libc::c_int == 0 as libc::c_int {
        msgcnt -= 1;
        msgcnt;
        msgdelay = MSGCNT as libc::c_int as int8_t;
        if msgcnt as libc::c_int == 0 as libc::c_int {
            msgflag = MSG_NONE as libc::c_int as int8_t;
        } else {
            msgflag = msgtable[msgcnt as usize];
        }
    }
}
