use ::libc;
extern "C" {
    pub type SDL_mutex;
    fn abs(_: libc::c_int) -> libc::c_int;
    fn SDL_CreateMutex() -> *mut SDL_mutex;
    fn SDL_LockMutex(mutex: *mut SDL_mutex) -> libc::c_int;
    fn SDL_UnlockMutex(mutex: *mut SDL_mutex) -> libc::c_int;
    fn free(_: *mut libc::c_void);
    fn calloc(_: libc::c_ulong, _: libc::c_ulong) -> *mut libc::c_void;
    static mut gpBuffer: *mut uint32_t;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn play_movie(pszMovie: *const libc::c_char, bAllowCancel: bool32_t);
    fn PaletteFadeIn(faderate: libc::c_int);
    fn PaletteFadeOut(faderate: libc::c_int);
    fn FullBlit(bArrow: bool32_t);
    fn ClrDraw();
    fn SFileCloseFile(handle: HSFILE) -> bool32_t;
    fn SFileGetFileSize(handle: HSFILE) -> uint32_t;
    fn patSFileOpenFile(
        filename: *const libc::c_char,
        handle: *mut HSFILE,
        bCanFail: bool32_t,
    ) -> bool32_t;
    fn patSFileReadFile(
        handle: HSFILE,
        buffer: *mut libc::c_void,
        bytestoread: uint32_t,
    );
    static mut svgamode: bool32_t;
    static mut force_redraw: libc::c_int;
    static mut pLightTbl: *mut uint8_t;
    static mut gpPalette: [uint32_t; 256];
    static mut gpLitPal: [uint32_t; 256];
    static mut nTrans: bool32_t;
    static mut nLVal: int32_t;
    static mut glClipY: *mut uint32_t;
    static mut nBuffWTbl: [int32_t; 1024];
    fn get_uint16(data: *mut libc::c_void) -> uint16_t;
    fn get_uint32(data: *mut libc::c_void) -> uint32_t;
    fn _logf(format: *const libc::c_char, _: ...);
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed = 92160;
pub const BTMBUFFY: C2RustUnnamed = 144;
pub const BTMBUFFX: C2RustUnnamed = 640;
pub const BUFFERSIZE: C2RustUnnamed = 503808;
pub const BUFFERY: C2RustUnnamed = 656;
pub const BUFFERX: C2RustUnnamed = 768;
pub const GAMEY: C2RustUnnamed = 352;
pub const CTRLPANY: C2RustUnnamed = 128;
pub const TOTALY: C2RustUnnamed = 480;
pub const TOTALX: C2RustUnnamed = 640;
pub const MAX_PLRS: C2RustUnnamed = 4;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const MAX_RLE_COPY: C2RustUnnamed_0 = 65;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_1 = 255;
pub const VIEWDRAW: C2RustUnnamed_1 = 1;
pub const NODRAW: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const LIGHT_U: C2RustUnnamed_2 = 4;
pub const LIGHT_GREY: C2RustUnnamed_2 = 3;
pub const LIGHT_STONE: C2RustUnnamed_2 = 2;
pub const LIGHT_INFRA: C2RustUnnamed_2 = 1;
pub const LIGHT_NORM: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const FADE_VFAST: C2RustUnnamed_3 = 128;
pub const FADE_FAST: C2RustUnnamed_3 = 8;
pub const FADE_MED: C2RustUnnamed_3 = 16;
pub const FADE_SLOW: C2RustUnnamed_3 = 8;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const G_BRIGHT_LIGHTS: C2RustUnnamed_4 = 0;
pub const USE_GOURAUD: C2RustUnnamed_4 = 0;
pub const ORIG_LIGHTING: C2RustUnnamed_4 = 1;
pub type bool32_t = uint32_t;
pub type HSFILE = *mut C2RustUnnamed_5;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_5 {
    pub unused: libc::c_int,
}
#[no_mangle]
pub static mut dlreverse: libc::c_int = 0;
#[no_mangle]
pub static mut dlcolor: uint8_t = 0;
#[no_mangle]
pub static mut dlclipflag: bool32_t = 0;
#[no_mangle]
pub static mut sglGameSeed: int32_t = 0;
#[no_mangle]
pub static mut SeedCount: libc::c_int = 0;
#[no_mangle]
pub static mut orgseed: int32_t = 0;
static mut sgMemCrit: *mut SDL_mutex = 0 as *const SDL_mutex as *mut SDL_mutex;
#[no_mangle]
pub unsafe extern "C" fn init_engine_mem_mutex() {
    sgMemCrit = SDL_CreateMutex();
}
#[no_mangle]
pub unsafe extern "C" fn GetCelFrame(
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut frame_size: *mut int32_t,
) -> *mut uint8_t {
    let mut pCel: *mut uint8_t = 0 as *mut uint8_t;
    if !(nCel
        <= get_uint32(
            pCelBuff
                .offset(
                    (0 as libc::c_int as libc::c_ulong)
                        .wrapping_mul(
                            ::core::mem::size_of::<uint32_t>() as libc::c_ulong,
                        ) as isize,
                ) as *mut libc::c_void,
        ) as libc::c_int)
    {
        assert_fail(
            54 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"nCel <= (int)get_uint32(pCelBuff + 0*sizeof(uint32_t))\0" as *const u8
                as *const libc::c_char,
        );
    }
    *frame_size = (get_uint32(
        pCelBuff
            .offset(
                ((nCel + 1 as libc::c_int) as libc::c_ulong)
                    .wrapping_mul(::core::mem::size_of::<uint32_t>() as libc::c_ulong)
                    as isize,
            ) as *mut libc::c_void,
    ))
        .wrapping_sub(
            get_uint32(
                pCelBuff
                    .offset(
                        (nCel as libc::c_ulong)
                            .wrapping_mul(
                                ::core::mem::size_of::<uint32_t>() as libc::c_ulong,
                            ) as isize,
                    ) as *mut libc::c_void,
            ),
        ) as int32_t;
    pCel = pCelBuff
        .offset(
            get_uint32(
                pCelBuff
                    .offset(
                        (nCel as libc::c_ulong)
                            .wrapping_mul(
                                ::core::mem::size_of::<uint32_t>() as libc::c_ulong,
                            ) as isize,
                    ) as *mut libc::c_void,
            ) as isize,
        );
    let mut hdr_size: uint16_t = get_uint16(pCel as *mut libc::c_void);
    if hdr_size as libc::c_int == 0xa as libc::c_int {
        *frame_size -= 10 as libc::c_int;
        pCel = pCel.offset(10 as libc::c_int as isize);
    }
    return pCel;
}
#[no_mangle]
pub unsafe extern "C" fn DecodeFullCel(
    mut pDecodeTo: *mut uint32_t,
    mut pRLEBytes: *mut uint8_t,
    mut frame_size: int32_t,
    mut nWidth: int32_t,
) {
    let mut w: int32_t = 0;
    let mut rle: uint8_t = 0;
    if pDecodeTo.is_null() {
        assert_fail(
            74 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pDecodeTo != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if pRLEBytes.is_null() {
        assert_fail(
            75 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pRLEBytes != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut clip: *mut uint32_t = if svgamode != 0 {
        &mut *gpBuffer
            .offset(
                ((0 as libc::c_int + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    } else {
        &mut *gpBuffer
            .offset(
                ((-(17 as libc::c_int) + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    };
    while frame_size != 0 as libc::c_int {
        w = nWidth;
        while w != 0 as libc::c_int {
            let fresh0 = pRLEBytes;
            pRLEBytes = pRLEBytes.offset(1);
            rle = *fresh0;
            frame_size -= 1;
            frame_size;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                frame_size -= rle as libc::c_int;
                if USE_GOURAUD as libc::c_int != 0 {
                    if pDecodeTo < clip {
                        return;
                    }
                }
                if pDecodeTo < glClipY {
                    loop {
                        let fresh1 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh1 != 0) {
                            break;
                        }
                        *pDecodeTo = gpPalette[*pRLEBytes as usize];
                        pDecodeTo = pDecodeTo.offset(1);
                        pDecodeTo;
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                    }
                } else {
                    pRLEBytes = pRLEBytes.offset(rle as libc::c_int as isize);
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pDecodeTo = pDecodeTo.offset(-((768 as libc::c_int + nWidth) as isize));
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawCel(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pFrom: *mut uint8_t = 0 as *mut uint8_t;
    let mut frame_size: int32_t = 0;
    if gpBuffer.is_null() {
        assert_fail(
            129 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    if pCelBuff.is_null() {
        assert_fail(
            130 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = GetCelFrame(pCelBuff, nCel, &mut frame_size);
    pTo = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    DecodeFullCel(pTo, pFrom, frame_size, nCelW);
}
#[no_mangle]
pub unsafe extern "C" fn DecodeFullCelL(
    mut pDecodeTo: *mut uint32_t,
    mut pRLEBytes: *mut uint8_t,
    mut frame_size: int32_t,
    mut nWidth: int32_t,
) {
    let mut w: int32_t = 0;
    let mut rle: uint8_t = 0;
    if pDecodeTo.is_null() {
        assert_fail(
            146 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pDecodeTo != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if pRLEBytes.is_null() {
        assert_fail(
            147 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pRLEBytes != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut clip: *mut uint32_t = if svgamode != 0 {
        &mut *gpBuffer
            .offset(
                ((0 as libc::c_int + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    } else {
        &mut *gpBuffer
            .offset(
                ((-(17 as libc::c_int) + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    };
    while frame_size != 0 as libc::c_int {
        w = nWidth;
        while w != 0 as libc::c_int {
            let fresh2 = pRLEBytes;
            pRLEBytes = pRLEBytes.offset(1);
            rle = *fresh2;
            frame_size -= 1;
            frame_size;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                frame_size -= rle as libc::c_int;
                if USE_GOURAUD as libc::c_int != 0 {
                    if pDecodeTo < clip {
                        return;
                    }
                }
                if pDecodeTo < glClipY {
                    loop {
                        let fresh3 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh3 != 0) {
                            break;
                        }
                        let fresh4 = pRLEBytes;
                        pRLEBytes = pRLEBytes.offset(1);
                        let fresh5 = pDecodeTo;
                        pDecodeTo = pDecodeTo.offset(1);
                        *fresh5 = gpLitPal[*fresh4 as usize];
                    }
                } else {
                    pRLEBytes = pRLEBytes.offset(rle as libc::c_int as isize);
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pDecodeTo = pDecodeTo.offset(-((768 as libc::c_int + nWidth) as isize));
    }
}
#[no_mangle]
pub unsafe extern "C" fn TDecodeFullCel(
    mut pDecodeTo: *mut uint32_t,
    mut pRLEBytes: *mut uint8_t,
    mut frame_size: int32_t,
    mut nWidth: int32_t,
) {
    let mut w: int32_t = 0;
    let mut rle: uint8_t = 0;
    if pDecodeTo.is_null() {
        assert_fail(
            192 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pDecodeTo != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if pRLEBytes.is_null() {
        assert_fail(
            193 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pRLEBytes != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut clip: *mut uint32_t = if svgamode != 0 {
        &mut *gpBuffer
            .offset(
                ((0 as libc::c_int + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    } else {
        &mut *gpBuffer
            .offset(
                ((-(17 as libc::c_int) + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    };
    while frame_size != 0 as libc::c_int {
        w = nWidth;
        while w != 0 as libc::c_int {
            let fresh6 = pRLEBytes;
            pRLEBytes = pRLEBytes.offset(1);
            rle = *fresh6;
            frame_size -= 1;
            frame_size;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                frame_size -= rle as libc::c_int;
                if USE_GOURAUD as libc::c_int != 0 {
                    if pDecodeTo < clip {
                        return;
                    }
                }
                if pDecodeTo < glClipY {
                    loop {
                        let fresh7 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh7 != 0) {
                            break;
                        }
                        *pDecodeTo = (*pDecodeTo & 0xfefefe as libc::c_int as uint32_t)
                            .wrapping_add(
                                gpPalette[*pRLEBytes as usize]
                                    & 0xfefefe as libc::c_int as uint32_t,
                            ) >> 1 as libc::c_int;
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                        pDecodeTo = pDecodeTo.offset(1);
                        pDecodeTo;
                    }
                } else {
                    pRLEBytes = pRLEBytes.offset(rle as libc::c_int as isize);
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pDecodeTo = pDecodeTo.offset(-((768 as libc::c_int + nWidth) as isize));
    }
}
#[no_mangle]
pub unsafe extern "C" fn TDecodeFullCelL(
    mut pDecodeTo: *mut uint32_t,
    mut pRLEBytes: *mut uint8_t,
    mut frame_size: int32_t,
    mut nWidth: int32_t,
) {
    let mut w: int32_t = 0;
    let mut rle: uint8_t = 0;
    if pDecodeTo.is_null() {
        assert_fail(
            240 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pDecodeTo != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if pRLEBytes.is_null() {
        assert_fail(
            241 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pRLEBytes != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut clip: *mut uint32_t = if svgamode != 0 {
        &mut *gpBuffer
            .offset(
                ((0 as libc::c_int + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    } else {
        &mut *gpBuffer
            .offset(
                ((-(17 as libc::c_int) + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    };
    while frame_size != 0 as libc::c_int {
        w = nWidth;
        while w != 0 as libc::c_int {
            let fresh8 = pRLEBytes;
            pRLEBytes = pRLEBytes.offset(1);
            rle = *fresh8;
            frame_size -= 1;
            frame_size;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                frame_size -= rle as libc::c_int;
                if USE_GOURAUD as libc::c_int != 0 {
                    if pDecodeTo < clip {
                        return;
                    }
                }
                if pDecodeTo < glClipY {
                    loop {
                        let fresh9 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh9 != 0) {
                            break;
                        }
                        *pDecodeTo = (*pDecodeTo & 0xfefefe as libc::c_int as uint32_t)
                            .wrapping_add(
                                gpLitPal[*pRLEBytes as usize]
                                    & 0xfefefe as libc::c_int as uint32_t,
                            ) >> 1 as libc::c_int;
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                        pDecodeTo = pDecodeTo.offset(1);
                        pDecodeTo;
                    }
                } else {
                    pRLEBytes = pRLEBytes.offset(rle as libc::c_int as isize);
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pDecodeTo = pDecodeTo.offset(-((768 as libc::c_int + nWidth) as isize));
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawCelL(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pFrom: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    if gpBuffer.is_null() {
        assert_fail(
            294 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    if pCelBuff.is_null() {
        assert_fail(
            295 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pTo = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    if ORIG_LIGHTING as libc::c_int != 0 {
        if nLVal != 0 {
            DecodeFullCelL(pTo, pFrom, RLELen, nCelW);
        } else {
            DecodeFullCel(pTo, pFrom, RLELen, nCelW);
        }
    } else {
        DecodeFullCelL(pTo, pFrom, RLELen, nCelW);
    };
}
#[no_mangle]
pub unsafe extern "C" fn TDrawCel(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pFrom: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    if pCelBuff.is_null() {
        assert_fail(
            324 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pTo = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    TDecodeFullCel(pTo, pFrom, RLELen, nCelW);
}
#[no_mangle]
pub unsafe extern "C" fn TDrawCelL(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pFrom: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    if pCelBuff.is_null() {
        assert_fail(
            347 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pTo = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    if nTrans != 0 {
        TDecodeFullCelL(pTo, pFrom, RLELen, nCelW);
    } else {
        DecodeFullCelL(pTo, pFrom, RLELen, nCelW);
    };
}
#[no_mangle]
pub unsafe extern "C" fn DrawCelI(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
    mut loff: int8_t,
) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pFrom: *mut uint8_t = 0 as *mut uint8_t;
    let mut pL: *mut uint8_t = 0 as *mut uint8_t;
    let mut rle: uint8_t = 0;
    let mut RLELen: int32_t = 0;
    let mut w: int32_t = 0;
    let mut ltaboff: int32_t = 0;
    if gpBuffer.is_null() {
        assert_fail(
            377 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    if pCelBuff.is_null() {
        assert_fail(
            378 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pTo = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    ltaboff = 4096 as libc::c_int;
    if loff as libc::c_int == LIGHT_STONE as libc::c_int {
        ltaboff += 256 as libc::c_int;
    }
    if loff as libc::c_int >= LIGHT_U as libc::c_int {
        ltaboff
            += ((loff as libc::c_int - LIGHT_U as libc::c_int) << 8 as libc::c_int)
                + 768 as libc::c_int;
    }
    pL = &mut *pLightTbl.offset(ltaboff as isize) as *mut uint8_t;
    while RLELen != 0 as libc::c_int {
        w = nCelW;
        while w != 0 as libc::c_int {
            let fresh10 = pFrom;
            pFrom = pFrom.offset(1);
            rle = *fresh10;
            RLELen -= 1;
            RLELen;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                RLELen -= rle as libc::c_int;
                if pTo < glClipY {
                    loop {
                        let fresh11 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh11 != 0) {
                            break;
                        }
                        let fresh12 = pFrom;
                        pFrom = pFrom.offset(1);
                        let fresh13 = pTo;
                        pTo = pTo.offset(1);
                        *fresh13 = gpPalette[*pL.offset(*fresh12 as isize) as usize];
                    }
                } else {
                    pFrom = pFrom.offset(rle as libc::c_int as isize);
                    pTo = pTo.offset(rle as libc::c_int as isize);
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pTo = pTo.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pTo = pTo.offset(-((768 as libc::c_int + nCelW) as isize));
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawBuffCel(
    mut pBuff: *mut uint8_t,
    mut xp: int32_t,
    mut yp: int32_t,
    mut nBuffW: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pTo: *mut uint8_t = 0 as *mut uint8_t;
    let mut pFrom: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    let mut w: int32_t = 0;
    let mut rle: uint8_t = 0;
    if pCelBuff.is_null() {
        assert_fail(
            435 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if pBuff.is_null() {
        assert_fail(
            436 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pTo = pBuff.offset((nBuffW * yp) as isize).offset(xp as isize);
    while RLELen != 0 as libc::c_int {
        w = nCelW;
        while w != 0 as libc::c_int {
            let fresh14 = pFrom;
            pFrom = pFrom.offset(1);
            rle = *fresh14;
            RLELen -= 1;
            RLELen;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                RLELen -= rle as libc::c_int;
                loop {
                    let fresh15 = rle;
                    rle = rle.wrapping_sub(1);
                    if !(fresh15 != 0) {
                        break;
                    }
                    *pTo = *pFrom;
                    pTo = pTo.offset(1);
                    pTo;
                    pFrom = pFrom.offset(1);
                    pFrom;
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pTo = pTo.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pTo = pTo.offset(-((nBuffW + nCelW) as isize));
    }
}
#[no_mangle]
pub unsafe extern "C" fn OutlineCel(
    mut ocolor: uint8_t,
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pFrom: *mut uint8_t = 0 as *mut uint8_t;
    let mut rle: uint8_t = 0;
    let mut RLELen: int32_t = 0;
    let mut w: int32_t = 0;
    if pCelBuff.is_null() {
        assert_fail(
            477 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if gpBuffer.is_null() {
        assert_fail(
            478 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pTo = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    while RLELen != 0 as libc::c_int {
        w = nCelW;
        while w != 0 as libc::c_int {
            let fresh16 = pFrom;
            pFrom = pFrom.offset(1);
            rle = *fresh16;
            RLELen -= 1;
            RLELen;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                RLELen -= rle as libc::c_int;
                if pTo < glClipY {
                    loop {
                        let fresh17 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh17 != 0) {
                            break;
                        }
                        let fresh18 = pFrom;
                        pFrom = pFrom.offset(1);
                        if *fresh18 != 0 {
                            *pTo
                                .offset(
                                    -(768 as libc::c_int) as isize,
                                ) = gpPalette[ocolor as usize];
                            *pTo
                                .offset(
                                    -(1 as libc::c_int) as isize,
                                ) = gpPalette[ocolor as usize];
                            *pTo
                                .offset(
                                    1 as libc::c_int as isize,
                                ) = gpPalette[ocolor as usize];
                            *pTo
                                .offset(
                                    768 as libc::c_int as isize,
                                ) = gpPalette[ocolor as usize];
                        }
                        pTo = pTo.offset(1);
                        pTo;
                    }
                } else {
                    pFrom = pFrom.offset(rle as libc::c_int as isize);
                    pTo = pTo.offset(rle as libc::c_int as isize);
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pTo = pTo.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pTo = pTo.offset(-((768 as libc::c_int + nCelW) as isize));
    }
}
#[no_mangle]
pub unsafe extern "C" fn TDrawRect(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut w: libc::c_int,
    mut h: libc::c_int,
) {
    if gpBuffer.is_null() {
        assert_fail(
            516 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut pTo: *mut uint32_t = &mut *gpBuffer
        .offset(
            (x + 64 as libc::c_int + (y + 160 as libc::c_int) * 768 as libc::c_int)
                as isize,
        ) as *mut uint32_t;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < h {
        i = 0 as libc::c_int;
        while i < w {
            *pTo = (*pTo & 0xfefefe as libc::c_int as uint32_t) >> 1 as libc::c_int;
            pTo = pTo.offset(1);
            pTo;
            i += 1;
            i;
        }
        pTo = pTo.offset((768 as libc::c_int - w) as isize);
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawPoint(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut c: uint8_t,
) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    if gpBuffer.is_null() {
        assert_fail(
            533 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    if y < 160 as libc::c_int || y >= 640 as libc::c_int {
        return;
    }
    if x < 64 as libc::c_int || x >= 704 as libc::c_int {
        return;
    }
    pTo = gpBuffer.offset(nBuffWTbl[y as usize] as isize).offset(x as isize);
    if pTo < glClipY {
        *pTo = gpPalette[c as usize];
    }
}
#[no_mangle]
pub unsafe extern "C" fn plot(mut x: libc::c_int, mut y: libc::c_int) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    if gpBuffer.is_null() {
        assert_fail(
            552 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    if dlreverse != 0 {
        if dlclipflag != 0 {
            if x < 0 as libc::c_int || x >= 640 as libc::c_int {
                return;
            }
            if y < 64 as libc::c_int || y >= 704 as libc::c_int {
                return;
            }
        }
        pTo = gpBuffer.offset(nBuffWTbl[x as usize] as isize).offset(y as isize);
    } else {
        if dlclipflag != 0 {
            if y < 0 as libc::c_int || y >= 640 as libc::c_int {
                return;
            }
            if x < 64 as libc::c_int || x >= 704 as libc::c_int {
                return;
            }
        }
        pTo = gpBuffer.offset(nBuffWTbl[y as usize] as isize).offset(x as isize);
    }
    let mut dst: *mut uint32_t = pTo;
    if dst < glClipY {
        *dst = gpPalette[dlcolor as usize];
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawLine(
    mut a1: libc::c_int,
    mut b1: libc::c_int,
    mut a2: libc::c_int,
    mut b2: libc::c_int,
    mut clr: uint8_t,
) {
    let mut dx: libc::c_int = 0;
    let mut dy: libc::c_int = 0;
    let mut incr1: libc::c_int = 0;
    let mut incr2: libc::c_int = 0;
    let mut D: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut xend: libc::c_int = 0;
    let mut c: libc::c_int = 0;
    let mut pixels_left: libc::c_int = 0;
    let mut x1: libc::c_int = 0;
    let mut y1: libc::c_int = 0;
    let mut sign_x: libc::c_int = 0;
    let mut sign_y: libc::c_int = 0;
    let mut step: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    dlcolor = clr;
    dlclipflag = 0 as libc::c_int as bool32_t;
    if a1 < 64 as libc::c_int || a1 >= 704 as libc::c_int {
        dlclipflag = 1 as libc::c_int as bool32_t;
    }
    if a2 < 64 as libc::c_int || a2 >= 704 as libc::c_int {
        dlclipflag = 1 as libc::c_int as bool32_t;
    }
    if b1 < 160 as libc::c_int || b1 >= 512 as libc::c_int {
        dlclipflag = 1 as libc::c_int as bool32_t;
    }
    if b2 < 160 as libc::c_int || b2 >= 512 as libc::c_int {
        dlclipflag = 1 as libc::c_int as bool32_t;
    }
    dx = absolute(a2, a1, &mut sign_x);
    dy = absolute(b2, b1, &mut sign_y);
    if sign_x == sign_y {
        step = 1 as libc::c_int;
    } else {
        step = -(1 as libc::c_int);
    }
    if dy > dx {
        dlswap(&mut a1, &mut b1);
        dlswap(&mut a2, &mut b2);
        dlswap(&mut dx, &mut dy);
        dlreverse = 1 as libc::c_int;
    } else {
        dlreverse = 0 as libc::c_int;
    }
    if a1 > a2 {
        x = a2;
        y = b2;
        x1 = a1;
        y1 = b1;
    } else {
        x = a1;
        y = b1;
        x1 = a2;
        y1 = b2;
    }
    xend = (dx - 1 as libc::c_int) / 4 as libc::c_int;
    pixels_left = (dx - 1 as libc::c_int) % 4 as libc::c_int;
    plot(x, y);
    plot(x1, y1);
    incr2 = 4 as libc::c_int * dy - 2 as libc::c_int * dx;
    if incr2 < 0 as libc::c_int {
        c = 2 as libc::c_int * dy;
        incr1 = 2 as libc::c_int * c;
        D = incr1 - dx;
        i = 0 as libc::c_int;
        while i < xend {
            x += 1;
            x;
            x1 -= 1;
            x1;
            if D < 0 as libc::c_int {
                plot(x, y);
                x += 1;
                plot(x, y);
                plot(x1, y1);
                x1 -= 1;
                plot(x1, y1);
                D += incr1;
            } else {
                if D < c {
                    plot(x, y);
                    x += 1;
                    y += step;
                    plot(x, y);
                    plot(x1, y1);
                    x1 -= 1;
                    y1 -= step;
                    plot(x1, y1);
                } else {
                    y += step;
                    plot(x, y);
                    x += 1;
                    plot(x, y);
                    y1 -= step;
                    plot(x1, y1);
                    x1 -= 1;
                    plot(x1, y1);
                }
                D += incr2;
            }
            i += 1;
            i;
        }
        if pixels_left != 0 {
            if D < 0 as libc::c_int {
                x += 1;
                plot(x, y);
                if pixels_left > 1 as libc::c_int {
                    x += 1;
                    plot(x, y);
                }
                if pixels_left > 2 as libc::c_int {
                    x1 -= 1;
                    plot(x1, y1);
                }
            } else if D < c {
                x += 1;
                plot(x, y);
                if pixels_left > 1 as libc::c_int {
                    x += 1;
                    y += step;
                    plot(x, y);
                }
                if pixels_left > 2 as libc::c_int {
                    x1 -= 1;
                    plot(x1, y1);
                }
            } else {
                x += 1;
                y += step;
                plot(x, y);
                if pixels_left > 1 as libc::c_int {
                    x += 1;
                    plot(x, y);
                }
                if pixels_left > 2 as libc::c_int {
                    x1 -= 1;
                    y1 -= step;
                    plot(x1, y1);
                }
            }
        }
    } else {
        c = 2 as libc::c_int * (dy - dx);
        incr1 = 2 as libc::c_int * c;
        D = incr1 + dx;
        i = 0 as libc::c_int;
        while i < xend {
            x += 1;
            x;
            x1 -= 1;
            x1;
            if D > 0 as libc::c_int {
                y += step;
                plot(x, y);
                x += 1;
                y += step;
                plot(x, y);
                y1 -= step;
                plot(x1, y1);
                x1 -= 1;
                y1 -= step;
                plot(x1, y1);
                D += incr1;
            } else {
                if D < c {
                    plot(x, y);
                    x += 1;
                    y += step;
                    plot(x, y);
                    plot(x1, y1);
                    x1 -= 1;
                    y1 -= step;
                    plot(x1, y1);
                } else {
                    y += step;
                    plot(x, y);
                    x += 1;
                    plot(x, y);
                    y1 -= step;
                    plot(x1, y1);
                    x1 -= 1;
                    plot(x1, y1);
                }
                D += incr2;
            }
            i += 1;
            i;
        }
        if pixels_left != 0 {
            if D > 0 as libc::c_int {
                x += 1;
                y += step;
                plot(x, y);
                if pixels_left > 1 as libc::c_int {
                    x += 1;
                    y += step;
                    plot(x, y);
                }
                if pixels_left > 2 as libc::c_int {
                    x1 -= 1;
                    y1 -= step;
                    plot(x1, y1);
                }
            } else if D < c {
                x += 1;
                plot(x, y);
                if pixels_left > 1 as libc::c_int {
                    x += 1;
                    y += step;
                    plot(x, y);
                }
                if pixels_left > 2 as libc::c_int {
                    x1 -= 1;
                    plot(x1, y1);
                }
            } else {
                x += 1;
                y += step;
                plot(x, y);
                if pixels_left > 1 as libc::c_int {
                    x += 1;
                    plot(x, y);
                }
                if pixels_left > 2 as libc::c_int {
                    if D > c {
                        x1 -= 1;
                        y1 -= step;
                        plot(x1, y1);
                    } else {
                        x1 -= 1;
                        plot(x1, y1);
                    }
                }
            }
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn GetDirection(
    mut x1: libc::c_int,
    mut y1: libc::c_int,
    mut x2: libc::c_int,
    mut y2: libc::c_int,
) -> libc::c_int {
    let mut mx: libc::c_int = 0;
    let mut my: libc::c_int = 0;
    let mut md: libc::c_int = 0;
    mx = x2 - x1;
    my = y2 - y1;
    if mx >= 0 as libc::c_int {
        if my >= 0 as libc::c_int {
            md = 0 as libc::c_int;
            if (mx << 1 as libc::c_int) < my {
                md = 1 as libc::c_int;
            }
            if (my << 1 as libc::c_int) < mx {
                md = 7 as libc::c_int;
            }
        } else {
            md = 6 as libc::c_int;
            my = -my;
            if (mx << 1 as libc::c_int) < my {
                md = 5 as libc::c_int;
            }
            if (my << 1 as libc::c_int) < mx {
                md = 7 as libc::c_int;
            }
        }
    } else if my >= 0 as libc::c_int {
        md = 2 as libc::c_int;
        mx = -mx;
        if (mx << 1 as libc::c_int) < my {
            md = 1 as libc::c_int;
        }
        if (my << 1 as libc::c_int) < mx {
            md = 3 as libc::c_int;
        }
    } else {
        md = 4 as libc::c_int;
        mx = -mx;
        my = -my;
        if (mx << 1 as libc::c_int) < my {
            md = 5 as libc::c_int;
        }
        if (my << 1 as libc::c_int) < mx {
            md = 3 as libc::c_int;
        }
    }
    return md;
}
#[no_mangle]
pub unsafe extern "C" fn SetRndSeed(
    mut file: *const libc::c_char,
    mut line: libc::c_int,
    mut s: int32_t,
) {
    _logf(b"caller of SetSeed: %s:%d\0" as *const u8 as *const libc::c_char, file, line);
    _logf(b"SetSeed(0x%08X)\0" as *const u8 as *const libc::c_char, s as uint32_t);
    sglGameSeed = s;
    orgseed = s;
    SeedCount = 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn getRndSeed() -> int32_t {
    SeedCount += 1;
    SeedCount;
    static mut INCREMENT: uint32_t = 1 as libc::c_int as uint32_t;
    static mut MULTIPLIER: uint32_t = 0x15a4e35 as libc::c_long as uint32_t;
    sglGameSeed = MULTIPLIER
        .wrapping_mul(sglGameSeed as libc::c_uint)
        .wrapping_add(INCREMENT) as int32_t;
    let mut ret: int32_t = abs(sglGameSeed);
    return ret;
}
#[no_mangle]
pub unsafe extern "C" fn GetRndSeed(
    mut file: *const libc::c_char,
    mut line: libc::c_int,
) -> int32_t {
    _logf(b"caller of RandInt: %s:%d\0" as *const u8 as *const libc::c_char, file, line);
    let mut ret: int32_t = getRndSeed();
    _logf(b"RandInt() = 0x%08X\0" as *const u8 as *const libc::c_char, ret as uint32_t);
    return ret;
}
#[no_mangle]
pub unsafe extern "C" fn random_(
    mut file: *const libc::c_char,
    mut line: libc::c_int,
    mut idx: uint8_t,
    mut v: int32_t,
) -> int32_t {
    _logf(
        b"caller of RandIntn: %s:%d\0" as *const u8 as *const libc::c_char,
        file,
        line,
    );
    if v <= 0 as libc::c_int {
        _logf(
            b"RandIntn(%d) = 0x%08X (seed=0x%08X)\0" as *const u8 as *const libc::c_char,
            v,
            0 as libc::c_int,
            sglGameSeed as uint32_t,
        );
        return 0 as libc::c_int;
    }
    if v < 0xffff as libc::c_int {
        let mut ret: int32_t = (getRndSeed() >> 16 as libc::c_int) % v;
        _logf(
            b"RandIntn(%d) = 0x%08X (seed=0x%08X)\0" as *const u8 as *const libc::c_char,
            v,
            ret as uint32_t,
            sglGameSeed as uint32_t,
        );
        return ret;
    }
    let mut ret_0: int32_t = getRndSeed() % v;
    _logf(
        b"RandIntn(%d) = 0x%08X (seed=0x%08X)\0" as *const u8 as *const libc::c_char,
        v,
        ret_0 as uint32_t,
        sglGameSeed as uint32_t,
    );
    return ret_0;
}
#[no_mangle]
pub unsafe extern "C" fn DiabloAllocPtr(mut dwBytes: uint32_t) -> *mut uint8_t {
    SDL_LockMutex(sgMemCrit);
    let mut rv: *mut uint8_t = calloc(
        dwBytes as libc::c_ulong,
        1 as libc::c_int as libc::c_ulong,
    ) as *mut uint8_t;
    SDL_UnlockMutex(sgMemCrit);
    if rv.is_null() {
        app_fatal_(
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            869 as libc::c_int,
            b"memory error\0" as *const u8 as *const libc::c_char,
        );
    }
    return rv;
}
#[no_mangle]
pub unsafe extern "C" fn mem_free_dbg(mut p: *mut libc::c_void) {
    if p.is_null() {
        return;
    }
    SDL_LockMutex(sgMemCrit);
    free(p);
    SDL_UnlockMutex(sgMemCrit);
}
#[no_mangle]
pub unsafe extern "C" fn LoadFileInMem(
    mut pszName: *const libc::c_char,
    mut pdwFileLen: *mut uint32_t,
) -> *mut uint8_t {
    let mut hFile: HSFILE = 0 as *mut C2RustUnnamed_5;
    if pszName.is_null() {
        assert_fail(
            894 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pszName\0" as *const u8 as *const libc::c_char,
        );
    }
    patSFileOpenFile(pszName, &mut hFile, 0 as libc::c_int as bool32_t);
    let mut dwFileLen: uint32_t = SFileGetFileSize(hFile);
    if !pdwFileLen.is_null() {
        *pdwFileLen = dwFileLen;
    }
    if dwFileLen == 0 {
        app_fatal_(
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            902 as libc::c_int,
            b"Zero length SFILE:\n%s\0" as *const u8 as *const libc::c_char,
            pszName,
        );
    }
    let mut pbMem: *mut uint8_t = DiabloAllocPtr(dwFileLen);
    patSFileReadFile(hFile, pbMem as *mut libc::c_void, dwFileLen);
    SFileCloseFile(hFile);
    return pbMem;
}
#[no_mangle]
pub unsafe extern "C" fn LoadFileWithMem(
    mut pszName: *const libc::c_char,
    mut pbMem: *mut uint8_t,
) -> uint32_t {
    let mut hFile: HSFILE = 0 as *mut C2RustUnnamed_5;
    if pszName.is_null() {
        assert_fail(
            915 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pszName\0" as *const u8 as *const libc::c_char,
        );
    }
    if pbMem.is_null() {
        app_fatal_(
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            917 as libc::c_int,
            b"LoadFileWithMem(NULL):\n%s\0" as *const u8 as *const libc::c_char,
            pszName,
        );
    }
    patSFileOpenFile(pszName, &mut hFile, 0 as libc::c_int as bool32_t);
    let mut dwFileLen: uint32_t = SFileGetFileSize(hFile);
    if dwFileLen == 0 {
        app_fatal_(
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            923 as libc::c_int,
            b"Zero length SFILE:\n%s\0" as *const u8 as *const libc::c_char,
            pszName,
        );
    }
    patSFileReadFile(hFile, pbMem as *mut libc::c_void, dwFileLen);
    SFileCloseFile(hFile);
    return dwFileLen;
}
#[no_mangle]
pub unsafe extern "C" fn TranslateCels(
    mut p: *mut uint8_t,
    mut ttbl: *mut uint8_t,
    mut nFrames: libc::c_int,
) {
    if p.is_null() {
        assert_fail(
            933 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"p != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if ttbl.is_null() {
        assert_fail(
            934 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"ttbl != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut nDataSize: libc::c_int = 0;
    let mut pImage: *mut uint8_t = 0 as *mut uint8_t;
    let mut bBlock: int8_t = 0;
    let mut j: libc::c_int = 1 as libc::c_int;
    while j <= nFrames {
        pImage = p
            .offset(*(p as *mut uint32_t).offset(j as isize) as isize)
            .offset(
                (::core::mem::size_of::<uint16_t>() as libc::c_ulong)
                    .wrapping_mul(5 as libc::c_int as libc::c_ulong) as isize,
            );
        nDataSize = ((*(p as *mut uint32_t).offset((j + 1 as libc::c_int) as isize))
            .wrapping_sub(*(p as *mut uint32_t).offset(j as isize)) as libc::c_ulong)
            .wrapping_sub(
                (::core::mem::size_of::<uint16_t>() as libc::c_ulong)
                    .wrapping_mul(5 as libc::c_int as libc::c_ulong),
            ) as libc::c_int;
        while nDataSize != 0 {
            let fresh19 = pImage;
            pImage = pImage.offset(1);
            bBlock = *fresh19 as int8_t;
            nDataSize -= 1;
            nDataSize;
            if !(nDataSize >= 0 as libc::c_int) {
                assert_fail(
                    945 as libc::c_int,
                    b"src/engine.c\0" as *const u8 as *const libc::c_char,
                    b"nDataSize >= 0\0" as *const u8 as *const libc::c_char,
                );
            }
            if bBlock as libc::c_int >= 0 as libc::c_int {
                continue;
            }
            bBlock = -(bBlock as libc::c_int) as int8_t;
            if bBlock as libc::c_int > MAX_RLE_COPY as libc::c_int {
                bBlock = (bBlock as libc::c_int - MAX_RLE_COPY as libc::c_int) as int8_t;
                nDataSize -= 1;
                nDataSize;
                if !(nDataSize >= 0 as libc::c_int) {
                    assert_fail(
                        955 as libc::c_int,
                        b"src/engine.c\0" as *const u8 as *const libc::c_char,
                        b"nDataSize >= 0\0" as *const u8 as *const libc::c_char,
                    );
                }
                *pImage = *ttbl.offset(*pImage as isize);
                pImage = pImage.offset(1);
                pImage;
            } else {
                nDataSize -= bBlock as libc::c_int;
                if !(nDataSize >= 0 as libc::c_int) {
                    assert_fail(
                        962 as libc::c_int,
                        b"src/engine.c\0" as *const u8 as *const libc::c_char,
                        b"nDataSize >= 0\0" as *const u8 as *const libc::c_char,
                    );
                }
                loop {
                    let fresh20 = bBlock;
                    bBlock = bBlock - 1;
                    if !(fresh20 != 0) {
                        break;
                    }
                    *pImage = *ttbl.offset(*pImage as isize);
                    pImage = pImage.offset(1);
                    pImage;
                }
            }
        }
        j += 1;
        j;
    }
}
unsafe extern "C" fn RLEDrawUnit(
    mut pDst: *mut uint32_t,
    mut pRLEData: *mut uint8_t,
    mut nDataSize: libc::c_int,
    mut nWidth: libc::c_int,
) {
    let mut w: libc::c_int = 0;
    let mut rle: uint8_t = 0;
    let mut run: uint8_t = 0;
    w = nWidth;
    while nDataSize != 0 as libc::c_int {
        if pDst < gpBuffer {
            break;
        }
        let fresh21 = pRLEData;
        pRLEData = pRLEData.offset(1);
        rle = *fresh21;
        nDataSize -= 1;
        nDataSize;
        if rle as libc::c_int >= 0x80 as libc::c_int {
            rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
            if rle as libc::c_int > MAX_RLE_COPY as libc::c_int {
                rle = (rle as libc::c_int - MAX_RLE_COPY as libc::c_int) as uint8_t;
                nDataSize -= 1;
                nDataSize;
                let fresh22 = pRLEData;
                pRLEData = pRLEData.offset(1);
                run = *fresh22;
                w -= rle as libc::c_int;
                loop {
                    let fresh23 = rle;
                    rle = rle.wrapping_sub(1);
                    if !(fresh23 != 0) {
                        break;
                    }
                    if pDst < glClipY {
                        let fresh24 = pDst;
                        pDst = pDst.offset(1);
                        *fresh24 = gpPalette[run as usize];
                    } else {
                        pDst = pDst.offset(1);
                        pDst;
                    }
                }
            } else {
                nDataSize -= rle as libc::c_int;
                w -= rle as libc::c_int;
                loop {
                    let fresh25 = rle;
                    rle = rle.wrapping_sub(1);
                    if !(fresh25 != 0) {
                        break;
                    }
                    if pDst < glClipY {
                        let fresh26 = pRLEData;
                        pRLEData = pRLEData.offset(1);
                        let fresh27 = pDst;
                        pDst = pDst.offset(1);
                        *fresh27 = gpPalette[*fresh26 as usize];
                    } else {
                        pDst = pDst.offset(1);
                        pDst;
                        pRLEData = pRLEData.offset(1);
                        pRLEData;
                    }
                }
            }
            if w == 0 as libc::c_int {
                w = nWidth;
                pDst = pDst.offset(-((768 as libc::c_int + w) as isize));
            }
        } else {
            while rle as libc::c_int != 0 as libc::c_int {
                if rle as libc::c_int > w {
                    pDst = pDst.offset(w as isize);
                    rle = (rle as libc::c_int - w) as uint8_t;
                    w = 0 as libc::c_int;
                } else {
                    pDst = pDst.offset(rle as libc::c_int as isize);
                    w -= rle as libc::c_int;
                    rle = 0 as libc::c_int as uint8_t;
                }
                if w == 0 as libc::c_int {
                    w = nWidth;
                    pDst = pDst.offset(-((768 as libc::c_int + w) as isize));
                }
            }
        }
    }
}
unsafe extern "C" fn RLEDrawOutline(
    mut pDst: *mut uint32_t,
    mut pRLEData: *mut uint8_t,
    mut nDataSize: libc::c_int,
    mut nWidth: libc::c_int,
    mut bOutLineColor: uint8_t,
) {
    let mut w: libc::c_int = 0;
    let mut rle: uint8_t = 0;
    let mut run: uint8_t = 0;
    w = nWidth;
    while nDataSize != 0 as libc::c_int {
        if pDst < gpBuffer {
            break;
        }
        let fresh28 = pRLEData;
        pRLEData = pRLEData.offset(1);
        rle = *fresh28;
        nDataSize -= 1;
        nDataSize;
        if rle as libc::c_int >= 0x80 as libc::c_int {
            rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
            if rle as libc::c_int > MAX_RLE_COPY as libc::c_int {
                rle = (rle as libc::c_int - MAX_RLE_COPY as libc::c_int) as uint8_t;
                nDataSize -= 1;
                nDataSize;
                let fresh29 = pRLEData;
                pRLEData = pRLEData.offset(1);
                run = *fresh29;
                w -= rle as libc::c_int;
                if run as libc::c_int != 0 as libc::c_int && pDst < glClipY {
                    *pDst
                        .offset(
                            -(1 as libc::c_int) as isize,
                        ) = gpPalette[bOutLineColor as usize];
                    *pDst.offset(rle as isize) = gpPalette[bOutLineColor as usize];
                    loop {
                        let fresh30 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh30 != 0) {
                            break;
                        }
                        *pDst
                            .offset(
                                -(768 as libc::c_int) as isize,
                            ) = gpPalette[bOutLineColor as usize];
                        *pDst
                            .offset(
                                768 as libc::c_int as isize,
                            ) = gpPalette[bOutLineColor as usize];
                        pDst = pDst.offset(1);
                        pDst;
                    }
                } else {
                    pDst = pDst.offset(rle as libc::c_int as isize);
                }
            } else {
                nDataSize -= rle as libc::c_int;
                w -= rle as libc::c_int;
                if pDst < glClipY {
                    loop {
                        let fresh31 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh31 != 0) {
                            break;
                        }
                        let fresh32 = pRLEData;
                        pRLEData = pRLEData.offset(1);
                        if *fresh32 != 0 {
                            *pDst
                                .offset(
                                    -(1 as libc::c_int) as isize,
                                ) = gpPalette[bOutLineColor as usize];
                            *pDst
                                .offset(
                                    1 as libc::c_int as isize,
                                ) = gpPalette[bOutLineColor as usize];
                            *pDst
                                .offset(
                                    -(768 as libc::c_int) as isize,
                                ) = gpPalette[bOutLineColor as usize];
                            *pDst
                                .offset(
                                    768 as libc::c_int as isize,
                                ) = gpPalette[bOutLineColor as usize];
                        }
                        pDst = pDst.offset(1);
                        pDst;
                    }
                } else {
                    pRLEData = pRLEData.offset(rle as libc::c_int as isize);
                    pDst = pDst.offset(rle as libc::c_int as isize);
                }
            }
            if w == 0 as libc::c_int {
                w = nWidth;
                pDst = pDst.offset(-((768 as libc::c_int + w) as isize));
            }
        } else {
            while rle as libc::c_int != 0 as libc::c_int {
                if rle as libc::c_int > w {
                    pDst = pDst.offset(w as isize);
                    rle = (rle as libc::c_int - w) as uint8_t;
                    w = 0 as libc::c_int;
                } else {
                    pDst = pDst.offset(rle as libc::c_int as isize);
                    w -= rle as libc::c_int;
                    rle = 0 as libc::c_int as uint8_t;
                }
                if w == 0 as libc::c_int {
                    w = nWidth;
                    pDst = pDst.offset(-((768 as libc::c_int + w) as isize));
                }
            }
        }
    }
}
unsafe extern "C" fn RLEDrawInfraUnit(
    mut pDst: *mut uint32_t,
    mut pRLEData: *mut uint8_t,
    mut nDataSize: libc::c_int,
    mut nWidth: libc::c_int,
    mut pLightTable: *mut uint8_t,
) {
    let mut w: libc::c_int = 0;
    let mut rle: uint8_t = 0;
    let mut run: uint8_t = 0;
    w = nWidth;
    while nDataSize != 0 as libc::c_int {
        if pDst < gpBuffer {
            break;
        }
        let fresh33 = pRLEData;
        pRLEData = pRLEData.offset(1);
        rle = *fresh33;
        nDataSize -= 1;
        nDataSize;
        if rle as libc::c_int >= 0x80 as libc::c_int {
            rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
            if rle as libc::c_int > MAX_RLE_COPY as libc::c_int {
                rle = (rle as libc::c_int - MAX_RLE_COPY as libc::c_int) as uint8_t;
                nDataSize -= 1;
                nDataSize;
                let fresh34 = pRLEData;
                pRLEData = pRLEData.offset(1);
                run = *pLightTable.offset(*fresh34 as isize);
                w -= rle as libc::c_int;
                loop {
                    let fresh35 = rle;
                    rle = rle.wrapping_sub(1);
                    if !(fresh35 != 0) {
                        break;
                    }
                    if pDst < glClipY {
                        let fresh36 = pDst;
                        pDst = pDst.offset(1);
                        *fresh36 = gpPalette[run as usize];
                    } else {
                        pDst = pDst.offset(1);
                        pDst;
                    }
                }
            } else {
                nDataSize -= rle as libc::c_int;
                w -= rle as libc::c_int;
                loop {
                    let fresh37 = rle;
                    rle = rle.wrapping_sub(1);
                    if !(fresh37 != 0) {
                        break;
                    }
                    if pDst < glClipY {
                        let fresh38 = pRLEData;
                        pRLEData = pRLEData.offset(1);
                        let fresh39 = pDst;
                        pDst = pDst.offset(1);
                        *fresh39 = gpPalette[*pLightTable.offset(*fresh38 as isize)
                            as usize];
                    } else {
                        pDst = pDst.offset(1);
                        pDst;
                        pRLEData = pRLEData.offset(1);
                        pRLEData;
                    }
                }
            }
            if w == 0 as libc::c_int {
                w = nWidth;
                pDst = pDst.offset(-((768 as libc::c_int + w) as isize));
            }
        } else {
            while rle as libc::c_int != 0 as libc::c_int {
                if rle as libc::c_int > w {
                    pDst = pDst.offset(w as isize);
                    rle = (rle as libc::c_int - w) as uint8_t;
                    w = 0 as libc::c_int;
                } else {
                    pDst = pDst.offset(rle as libc::c_int as isize);
                    w -= rle as libc::c_int;
                    rle = 0 as libc::c_int as uint8_t;
                }
                if w == 0 as libc::c_int {
                    w = nWidth;
                    pDst = pDst.offset(-((768 as libc::c_int + w) as isize));
                }
            }
        }
    }
}
unsafe extern "C" fn RLEDrawLitUnit_orig_lighting(
    mut pDst: *mut uint32_t,
    mut pRLEData: *mut uint8_t,
    mut nDataSize: libc::c_int,
    mut nWidth: libc::c_int,
    mut pLightTable: *mut uint8_t,
) {
    let mut src: *mut uint8_t = pRLEData;
    let mut dst: *mut uint32_t = pDst;
    let mut nBufferW: int32_t = BUFFERX as libc::c_int + nWidth;
    let mut end: *mut uint8_t = &mut *src.offset(nDataSize as isize) as *mut uint8_t;
    let mut tbl: *mut uint8_t = pLightTable;
    let mut w: libc::c_int = nWidth;
    while src != end {
        if dst < gpBuffer {
            break;
        }
        let mut c: uint8_t = *src;
        src = src.offset(1);
        src;
        if c as libc::c_int & 0x80 as libc::c_int != 0 as libc::c_int {
            c = -(c as int8_t as libc::c_int) as uint8_t;
            if c as libc::c_int <= MAX_RLE_COPY as libc::c_int {
                w -= c as libc::c_int;
                let mut i: libc::c_int = 0 as libc::c_int;
                while i < c as libc::c_int {
                    if (&mut *dst.offset(i as isize) as *mut uint32_t) < glClipY {
                        *dst
                            .offset(
                                i as isize,
                            ) = gpPalette[*tbl.offset(*src.offset(i as isize) as isize)
                            as usize];
                    }
                    i += 1;
                    i;
                }
                dst = dst.offset(c as libc::c_int as isize);
                src = src.offset(c as libc::c_int as isize);
            } else {
                c = (c as libc::c_int - MAX_RLE_COPY as libc::c_int) as uint8_t;
                w -= c as libc::c_int;
                let mut color: uint32_t = gpPalette[*tbl.offset(*src as isize) as usize];
                src = src.offset(1);
                src;
                let mut i_0: libc::c_int = 0 as libc::c_int;
                while i_0 < c as libc::c_int {
                    if (&mut *dst.offset(i_0 as isize) as *mut uint32_t) < glClipY {
                        *dst.offset(i_0 as isize) = color;
                    }
                    i_0 += 1;
                    i_0;
                }
                dst = dst.offset(c as libc::c_int as isize);
            }
            if w == 0 as libc::c_int {
                w = nWidth;
                dst = dst.offset(-(nBufferW as isize));
            }
        } else {
            while c as libc::c_int != 0 as libc::c_int {
                if c as libc::c_int <= w {
                    dst = dst.offset(c as libc::c_int as isize);
                    w -= c as libc::c_int;
                    c = 0 as libc::c_int as uint8_t;
                } else {
                    dst = dst.offset(w as isize);
                    c = (c as libc::c_int - w) as uint8_t;
                    w = 0 as libc::c_int;
                }
                if w == 0 as libc::c_int {
                    w = nWidth;
                    dst = dst.offset(-(nBufferW as isize));
                }
            }
        }
    }
}
unsafe extern "C" fn RLEDrawLitUnit_gouraud(
    mut pDst: *mut uint32_t,
    mut pRLEData: *mut uint8_t,
    mut nDataSize: libc::c_int,
    mut nWidth: libc::c_int,
) {
    let mut w: libc::c_int = 0;
    let mut rle: uint8_t = 0;
    let mut run: uint8_t = 0;
    w = nWidth;
    while nDataSize != 0 as libc::c_int {
        if pDst < gpBuffer {
            break;
        }
        let fresh40 = pRLEData;
        pRLEData = pRLEData.offset(1);
        rle = *fresh40;
        nDataSize -= 1;
        nDataSize;
        if rle as libc::c_int >= 0x80 as libc::c_int {
            rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
            if rle as libc::c_int > MAX_RLE_COPY as libc::c_int {
                rle = (rle as libc::c_int - MAX_RLE_COPY as libc::c_int) as uint8_t;
                nDataSize -= 1;
                nDataSize;
                let fresh41 = pRLEData;
                pRLEData = pRLEData.offset(1);
                run = *fresh41;
                w -= rle as libc::c_int;
                loop {
                    let fresh42 = rle;
                    rle = rle.wrapping_sub(1);
                    if !(fresh42 != 0) {
                        break;
                    }
                    if pDst < glClipY {
                        let fresh43 = pDst;
                        pDst = pDst.offset(1);
                        *fresh43 = gpLitPal[run as usize];
                    } else {
                        pDst = pDst.offset(1);
                        pDst;
                    }
                }
            } else {
                nDataSize -= rle as libc::c_int;
                w -= rle as libc::c_int;
                loop {
                    let fresh44 = rle;
                    rle = rle.wrapping_sub(1);
                    if !(fresh44 != 0) {
                        break;
                    }
                    if pDst < glClipY {
                        let fresh45 = pRLEData;
                        pRLEData = pRLEData.offset(1);
                        let fresh46 = pDst;
                        pDst = pDst.offset(1);
                        *fresh46 = gpLitPal[*fresh45 as usize];
                    } else {
                        pDst = pDst.offset(1);
                        pDst;
                        pRLEData = pRLEData.offset(1);
                        pRLEData;
                    }
                }
            }
            if w == 0 as libc::c_int {
                w = nWidth;
                pDst = pDst.offset(-((768 as libc::c_int + w) as isize));
            }
        } else {
            while rle as libc::c_int != 0 as libc::c_int {
                if rle as libc::c_int > w {
                    pDst = pDst.offset(w as isize);
                    rle = (rle as libc::c_int - w) as uint8_t;
                    w = 0 as libc::c_int;
                } else {
                    pDst = pDst.offset(rle as libc::c_int as isize);
                    w -= rle as libc::c_int;
                    rle = 0 as libc::c_int as uint8_t;
                }
                if w == 0 as libc::c_int {
                    w = nWidth;
                    pDst = pDst.offset(-((768 as libc::c_int + w) as isize));
                }
            }
        }
    }
}
unsafe extern "C" fn RLEDrawLitUnit(
    mut pDst: *mut uint32_t,
    mut pRLEData: *mut uint8_t,
    mut nDataSize: libc::c_int,
    mut nWidth: libc::c_int,
    mut pLightTable: *mut uint8_t,
) {
    if ORIG_LIGHTING as libc::c_int != 0 {
        RLEDrawLitUnit_orig_lighting(pDst, pRLEData, nDataSize, nWidth, pLightTable);
    } else {
        RLEDrawLitUnit_gouraud(pDst, pRLEData, nDataSize, nWidth);
    };
}
#[no_mangle]
pub unsafe extern "C" fn DrawUnit(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pDst: *mut uint32_t = 0 as *mut uint32_t;
    let mut pSrc: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    if gpBuffer.is_null() {
        assert_fail(
            1325 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if pCelBuff.is_null() {
        assert_fail(
            1326 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(nCel > 0 as libc::c_int) {
        assert_fail(
            1327 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"nCel > 0\0" as *const u8 as *const libc::c_char,
        );
    }
    pSrc = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pDst = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    RLEDrawUnit(pDst, pSrc, RLELen, nCelW);
}
#[no_mangle]
pub unsafe extern "C" fn DrawUnitOutline(
    mut ocolor: uint8_t,
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pDst: *mut uint32_t = 0 as *mut uint32_t;
    let mut pSrc: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    if pCelBuff.is_null() {
        assert_fail(
            1340 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if gpBuffer.is_null() {
        assert_fail(
            1341 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(nCel > 0 as libc::c_int) {
        assert_fail(
            1342 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"nCel > 0\0" as *const u8 as *const libc::c_char,
        );
    }
    pSrc = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pDst = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    RLEDrawOutline(pDst, pSrc, RLELen, nCelW, ocolor);
}
#[no_mangle]
pub unsafe extern "C" fn DrawInfraUnit(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
    mut loff: int8_t,
) {
    let mut pDst: *mut uint32_t = 0 as *mut uint32_t;
    let mut pSrc: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    let mut ltaboff: int32_t = 0;
    if gpBuffer.is_null() {
        assert_fail(
            1355 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if pCelBuff.is_null() {
        assert_fail(
            1356 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(nCel > 0 as libc::c_int) {
        assert_fail(
            1357 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"nCel > 0\0" as *const u8 as *const libc::c_char,
        );
    }
    pSrc = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pDst = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    ltaboff = 4096 as libc::c_int;
    if loff as libc::c_int == LIGHT_STONE as libc::c_int {
        ltaboff += 256 as libc::c_int;
    }
    if loff as libc::c_int >= LIGHT_U as libc::c_int {
        ltaboff
            += ((loff as libc::c_int - LIGHT_U as libc::c_int) << 8 as libc::c_int)
                + 768 as libc::c_int;
    }
    RLEDrawInfraUnit(pDst, pSrc, RLELen, nCelW, pLightTbl.offset(ltaboff as isize));
}
#[no_mangle]
pub unsafe extern "C" fn DrawLitUnit(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
) {
    let mut pDst: *mut uint32_t = 0 as *mut uint32_t;
    let mut pSrc: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    if gpBuffer.is_null() {
        assert_fail(
            1377 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if pCelBuff.is_null() {
        assert_fail(
            1378 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    if !(nCel > 0 as libc::c_int) {
        assert_fail(
            1379 as libc::c_int,
            b"src/engine.c\0" as *const u8 as *const libc::c_char,
            b"nCel > 0\0" as *const u8 as *const libc::c_char,
        );
    }
    pSrc = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pDst = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    if ORIG_LIGHTING as libc::c_int != 0 {
        if nLVal != 0 {
            RLEDrawLitUnit(
                pDst,
                pSrc,
                RLELen,
                nCelW,
                pLightTbl.offset((nLVal << 8 as libc::c_int) as isize),
            );
        } else {
            RLEDrawUnit(pDst, pSrc, RLELen, nCelW);
        }
    } else {
        RLEDrawLitUnit_gouraud(pDst, pSrc, RLELen, nCelW);
    };
}
#[no_mangle]
pub unsafe extern "C" fn PlayInGameMovie(mut pszMovie: *const libc::c_char) {
    PaletteFadeOut(FADE_FAST as libc::c_int);
    play_movie(pszMovie, 0 as libc::c_int as bool32_t);
    ClrDraw();
    force_redraw = FULLDRAW as libc::c_int;
    FullBlit(1 as libc::c_int as bool32_t);
    PaletteFadeIn(FADE_FAST as libc::c_int);
    force_redraw = FULLDRAW as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn dlswap(mut a: *mut libc::c_int, mut b: *mut libc::c_int) {
    let mut tmp: libc::c_int = *b;
    *b = *a;
    *a = tmp;
}
#[no_mangle]
pub unsafe extern "C" fn absolute(
    mut i: libc::c_int,
    mut j: libc::c_int,
    mut sign: *mut libc::c_int,
) -> libc::c_int {
    let mut diff: libc::c_int = i - j;
    if diff < 0 as libc::c_int {
        *sign = -(1 as libc::c_int);
        return -diff;
    }
    *sign = 1 as libc::c_int;
    return diff;
}
