use ::libc;
extern "C" {
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn SetRndSeed(file: *const libc::c_char, line: libc::c_int, s: int32_t);
    fn random_(
        file: *const libc::c_char,
        line: libc::c_int,
        idx: uint8_t,
        v: int32_t,
    ) -> int32_t;
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn DRLG_InitTrans();
    fn DRLG_InitSetPC();
    fn DRLG_SetPC();
    fn Make_SetPC(x: libc::c_int, y: libc::c_int, w: libc::c_int, h: libc::c_int);
    fn DRLG_PlaceThemeRooms(
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: libc::c_int,
        _: bool32_t,
    );
    fn DRLG_Init_Globals();
    fn DRLG_CheckQuests(_: libc::c_int, _: libc::c_int);
    fn QuestStatus(_: libc::c_int) -> bool32_t;
    static mut diabquad1x: libc::c_int;
    static mut diabquad2x: libc::c_int;
    static mut diabquad3x: libc::c_int;
    static mut diabquad4x: libc::c_int;
    static mut diabquad1y: libc::c_int;
    static mut diabquad2y: libc::c_int;
    static mut diabquad3y: libc::c_int;
    static mut diabquad4y: libc::c_int;
    static mut currlevel: uint8_t;
    static mut dungeon: [[uint8_t; 40]; 40];
    static mut pdungeon: [[uint8_t; 40]; 40];
    static mut dflags: [[uint8_t; 40]; 40];
    static mut setpc_x: libc::c_int;
    static mut setpc_y: libc::c_int;
    static mut setpc_w: libc::c_int;
    static mut setpc_h: libc::c_int;
    static mut pSetPiece: *mut uint8_t;
    static mut setloadflag: bool32_t;
    static mut pMegaTiles: *mut uint8_t;
    static mut dminx: libc::c_int;
    static mut dminy: libc::c_int;
    static mut dmaxx: libc::c_int;
    static mut dmaxy: libc::c_int;
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut LvlViewX: libc::c_int;
    static mut LvlViewY: libc::c_int;
    static mut TransVal: int8_t;
    static mut dPiece: [[libc::c_int; 112]; 112];
    static mut dTransVal: [[int8_t; 112]; 112];
    static mut gbMaxPlayers: uint8_t;
    static mut quests: [QuestStruct; 16];
}
pub type C2RustUnnamed = libc::c_uint;
pub const DIABSIZE: C2RustUnnamed = 14;
pub const NUMSPATS: C2RustUnnamed = 37;
pub const NUMBBLOCKS: C2RustUnnamed = 140;
pub const L4_DIRT: C2RustUnnamed = 12;
pub const L4DY: C2RustUnnamed = 80;
pub const L4DX: C2RustUnnamed = 80;
pub const L4MIN_AREA: C2RustUnnamed = 173;
pub const L4DUNY: C2RustUnnamed = 20;
pub const L4DUNX: C2RustUnnamed = 20;
pub const L4ROOM_MAX: C2RustUnnamed = 6;
pub const L4ROOM_MIN: C2RustUnnamed = 2;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const L4_WALLRND: C2RustUnnamed_0 = 100;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const XARCHWALL_PIC: C2RustUnnamed_1 = 57;
pub const YARCHWALL_PIC: C2RustUnnamed_1 = 53;
pub const DIRT_PIC: C2RustUnnamed_1 = 30;
pub const DLRWALL_PIC: C2RustUnnamed_1 = 24;
pub const DLLWALL3_PIC: C2RustUnnamed_1 = 22;
pub const DLLWALL2_PIC: C2RustUnnamed_1 = 26;
pub const DLLWALL_PIC: C2RustUnnamed_1 = 27;
pub const DURWALL3_PIC: C2RustUnnamed_1 = 23;
pub const DURWALL2_PIC: C2RustUnnamed_1 = 28;
pub const DURWALL_PIC: C2RustUnnamed_1 = 25;
pub const DULWALL_PIC: C2RustUnnamed_1 = 21;
pub const DFLOOR_PIC: C2RustUnnamed_1 = 20;
pub const DHWALL_PIC: C2RustUnnamed_1 = 19;
pub const DVWALL_PIC: C2RustUnnamed_1 = 18;
pub const LLWALL_PIC: C2RustUnnamed_1 = 15;
pub const ULWALL_PIC: C2RustUnnamed_1 = 9;
pub const URWALL_PIC: C2RustUnnamed_1 = 16;
pub const FLOOR_PIC: C2RustUnnamed_1 = 6;
pub const LRWALL_PIC: C2RustUnnamed_1 = 12;
pub const HWALL_PIC: C2RustUnnamed_1 = 2;
pub const VWALL_PIC: C2RustUnnamed_1 = 1;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const L4DIR_VERT: C2RustUnnamed_2 = 1;
pub const L4DIR_HORIZ: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed_3 = 191;
pub const SETP_TEMP: C2RustUnnamed_3 = 64;
pub const SETP_MASK: C2RustUnnamed_3 = 127;
pub const SETP_BIT: C2RustUnnamed_3 = 128;
pub const BFMASK_MISSILE: C2RustUnnamed_3 = 254;
pub const BFMASK_SETPC: C2RustUnnamed_3 = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed_3 = 239;
pub const BFMASK_PLRLR: C2RustUnnamed_3 = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed_3 = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed_3 = 127;
pub const BFLAG_MISSILE: C2RustUnnamed_3 = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed_3 = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed_3 = 4;
pub const BFLAG_SETPC: C2RustUnnamed_3 = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed_3 = 16;
pub const BFLAG_PLRLR: C2RustUnnamed_3 = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed_3 = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed_3 = 128;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const Q_BETRAYER: C2RustUnnamed_4 = 15;
pub const Q_SCHAMB: C2RustUnnamed_4 = 14;
pub const Q_PWATER: C2RustUnnamed_4 = 13;
pub const Q_SKELKING: C2RustUnnamed_4 = 12;
pub const Q_WARLORD: C2RustUnnamed_4 = 11;
pub const Q_ANVIL: C2RustUnnamed_4 = 10;
pub const Q_BLOOD: C2RustUnnamed_4 = 9;
pub const Q_BLIND: C2RustUnnamed_4 = 8;
pub const Q_LTBANNER: C2RustUnnamed_4 = 7;
pub const Q_BUTCHER: C2RustUnnamed_4 = 6;
pub const Q_DIABLO: C2RustUnnamed_4 = 5;
pub const Q_VEIL: C2RustUnnamed_4 = 4;
pub const Q_ZHAR: C2RustUnnamed_4 = 3;
pub const Q_GARBUD: C2RustUnnamed_4 = 2;
pub const Q_BKMUSHRM: C2RustUnnamed_4 = 1;
pub const Q_ROCK: C2RustUnnamed_4 = 0;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const QUEST_DONE: C2RustUnnamed_5 = 3;
pub const QUEST_NOTDONE: C2RustUnnamed_5 = 2;
pub const QUEST_NOTACTIVE: C2RustUnnamed_5 = 1;
pub const QUEST_NOTAVAIL: C2RustUnnamed_5 = 0;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const LVL_TWARPUP: C2RustUnnamed_6 = 7;
pub const LVL_TWARPDN: C2RustUnnamed_6 = 6;
pub const LVL_WARP: C2RustUnnamed_6 = 5;
pub const LVL_NODIR: C2RustUnnamed_6 = 4;
pub const LVL_RTN: C2RustUnnamed_6 = 3;
pub const LVL_SET: C2RustUnnamed_6 = 2;
pub const LVL_UP: C2RustUnnamed_6 = 1;
pub const LVL_DOWN: C2RustUnnamed_6 = 0;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_7 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_7 = 32;
pub const MAXMICRO: C2RustUnnamed_7 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_7 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_7 = 64;
pub const MAXMREND: C2RustUnnamed_7 = 128;
pub const MAXTILES: C2RustUnnamed_7 = 2048;
pub const MDMAXY: C2RustUnnamed_7 = 40;
pub const MDMAXX: C2RustUnnamed_7 = 40;
pub const MAXDUNY: C2RustUnnamed_7 = 112;
pub const MAXDUNX: C2RustUnnamed_7 = 112;
pub const DMAXY: C2RustUnnamed_7 = 112;
pub const DMAXX: C2RustUnnamed_7 = 112;
pub const DIRTEDGED2: C2RustUnnamed_7 = 16;
pub const DIRTEDGE: C2RustUnnamed_7 = 32;
pub const NUMSLEVELS: C2RustUnnamed_7 = 10;
pub const NUMLEVELS: C2RustUnnamed_7 = 17;
pub const LVL4_START: C2RustUnnamed_7 = 13;
pub const LVL3_START: C2RustUnnamed_7 = 9;
pub const LVL2_START: C2RustUnnamed_7 = 5;
pub const LVL1_START: C2RustUnnamed_7 = 1;
pub const TLVL_START: C2RustUnnamed_7 = 0;
pub const LVLLENGTH: C2RustUnnamed_7 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct QuestStruct {
    pub _qlevel: uint8_t,
    pub _qtype: uint8_t,
    pub _qactive: uint8_t,
    pub _qlvltype: uint8_t,
    pub _qtx: libc::c_int,
    pub _qty: libc::c_int,
    pub _qslvl: uint8_t,
    pub _qidx: uint8_t,
    pub _qmsg: uint8_t,
    pub _qvar1: uint8_t,
    pub _qvar2: uint8_t,
    pub align_0011: [uint8_t; 3],
    pub _qlog: bool32_t,
}
#[no_mangle]
pub static mut dung: [[uint8_t; 20]; 20] = [[0; 20]; 20];
#[no_mangle]
pub static mut hallok: [bool32_t; 20] = [0; 20];
#[no_mangle]
pub static mut L4dungeon: [[uint8_t; 80]; 80] = [[0; 80]; 80];
static mut L4ConvTbl: [uint8_t; 16] = [
    30 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    9 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    3 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
];
#[no_mangle]
pub static mut SP4x1: libc::c_int = 0;
#[no_mangle]
pub static mut SP4y1: libc::c_int = 0;
#[no_mangle]
pub static mut SP4x2: libc::c_int = 0;
#[no_mangle]
pub static mut SP4y2: libc::c_int = 0;
#[no_mangle]
pub static mut l4holdx: libc::c_int = 0;
#[no_mangle]
pub static mut l4holdy: libc::c_int = 0;
static mut L4USTAIRS: [uint8_t; 42] = [
    4 as libc::c_int as uint8_t,
    5 as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    36 as libc::c_int as uint8_t,
    38 as libc::c_int as uint8_t,
    35 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    37 as libc::c_int as uint8_t,
    34 as libc::c_int as uint8_t,
    33 as libc::c_int as uint8_t,
    32 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    31 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
];
static mut L4TWARP: [uint8_t; 42] = [
    4 as libc::c_int as uint8_t,
    5 as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    134 as libc::c_int as uint8_t,
    136 as libc::c_int as uint8_t,
    133 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    135 as libc::c_int as uint8_t,
    132 as libc::c_int as uint8_t,
    131 as libc::c_int as uint8_t,
    130 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    129 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
];
static mut L4DSTAIRS: [uint8_t; 52] = [
    5 as libc::c_int as uint8_t,
    5 as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    45 as libc::c_int as uint8_t,
    41 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    44 as libc::c_int as uint8_t,
    43 as libc::c_int as uint8_t,
    40 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    46 as libc::c_int as uint8_t,
    42 as libc::c_int as uint8_t,
    39 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
];
static mut L4PENTA: [uint8_t; 52] = [
    5 as libc::c_int as uint8_t,
    5 as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    98 as libc::c_int as uint8_t,
    100 as libc::c_int as uint8_t,
    103 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    99 as libc::c_int as uint8_t,
    102 as libc::c_int as uint8_t,
    105 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    101 as libc::c_int as uint8_t,
    104 as libc::c_int as uint8_t,
    106 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
];
static mut L4PENTA2: [uint8_t; 52] = [
    5 as libc::c_int as uint8_t,
    5 as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    FLOOR_PIC as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    107 as libc::c_int as uint8_t,
    109 as libc::c_int as uint8_t,
    112 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    108 as libc::c_int as uint8_t,
    111 as libc::c_int as uint8_t,
    114 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    110 as libc::c_int as uint8_t,
    113 as libc::c_int as uint8_t,
    115 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
];
static mut L4BTYPES: [uint8_t; 140] = [
    0 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    3 as libc::c_int as uint8_t,
    4 as libc::c_int as uint8_t,
    5 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    7 as libc::c_int as uint8_t,
    8 as libc::c_int as uint8_t,
    9 as libc::c_int as uint8_t,
    10 as libc::c_int as uint8_t,
    11 as libc::c_int as uint8_t,
    12 as libc::c_int as uint8_t,
    13 as libc::c_int as uint8_t,
    14 as libc::c_int as uint8_t,
    15 as libc::c_int as uint8_t,
    16 as libc::c_int as uint8_t,
    17 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    15 as libc::c_int as uint8_t,
    16 as libc::c_int as uint8_t,
    9 as libc::c_int as uint8_t,
    12 as libc::c_int as uint8_t,
    4 as libc::c_int as uint8_t,
    5 as libc::c_int as uint8_t,
    7 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0,
    0,
    0,
];
unsafe extern "C" fn DRLG_L4Shadows() {
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut okflag: bool32_t = 0;
    y = 1 as libc::c_int;
    while y < MDMAXY as libc::c_int {
        x = 1 as libc::c_int;
        while x < MDMAXX as libc::c_int {
            okflag = 0 as libc::c_int as bool32_t;
            if dungeon[x as usize][y as usize] as libc::c_int == 3 as libc::c_int {
                okflag = 1 as libc::c_int as bool32_t;
            }
            if dungeon[x as usize][y as usize] as libc::c_int == 4 as libc::c_int {
                okflag = 1 as libc::c_int as bool32_t;
            }
            if dungeon[x as usize][y as usize] as libc::c_int == 8 as libc::c_int {
                okflag = 1 as libc::c_int as bool32_t;
            }
            if dungeon[x as usize][y as usize] as libc::c_int == 15 as libc::c_int {
                okflag = 1 as libc::c_int as bool32_t;
            }
            if okflag != 0 {
                if dungeon[(x - 1 as libc::c_int) as usize][y as usize] as libc::c_int
                    == 6 as libc::c_int
                {
                    dungeon[(x - 1 as libc::c_int)
                        as usize][y as usize] = 47 as libc::c_int as uint8_t;
                }
                if dungeon[(x - 1 as libc::c_int)
                    as usize][(y - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
                {
                    dungeon[(x - 1 as libc::c_int)
                        as usize][(y - 1 as libc::c_int)
                        as usize] = 48 as libc::c_int as uint8_t;
                }
            }
            x += 1;
            x;
        }
        y += 1;
        y;
    }
}
unsafe extern "C" fn InitL4Dungeon() {
    memset(
        dung.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[uint8_t; 20]; 20]>() as libc::c_ulong,
    );
    memset(
        L4dungeon.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[uint8_t; 80]; 80]>() as libc::c_ulong,
    );
    let mut j: libc::c_int = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        let mut i: libc::c_int = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            dungeon[i as usize][j as usize] = 30 as libc::c_int as uint8_t;
            dflags[i as usize][j as usize] = 0 as libc::c_int as uint8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_LoadL4SP() {
    setloadflag = 0 as libc::c_int as bool32_t;
    if QuestStatus(Q_WARLORD as libc::c_int) != 0 {
        if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
            assert_fail(
                157 as libc::c_int,
                b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
            );
        }
        pSetPiece = LoadFileInMem(
            b"Levels\\L4Data\\Warlord.DUN\0" as *const u8 as *const libc::c_char,
            0 as *mut uint32_t,
        );
        setloadflag = 1 as libc::c_int as bool32_t;
    }
    if currlevel as libc::c_int == 15 as libc::c_int
        && gbMaxPlayers as libc::c_int != 1 as libc::c_int
    {
        pSetPiece = LoadFileInMem(
            b"Levels\\L4Data\\Vile1.DUN\0" as *const u8 as *const libc::c_char,
            0 as *mut uint32_t,
        );
        setloadflag = 1 as libc::c_int as bool32_t;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_FreeL4SP() {
    let mut p__p: *mut libc::c_void = pSetPiece as *mut libc::c_void;
    pSetPiece = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_L4SetSPRoom(mut rx1: libc::c_int, mut ry1: libc::c_int) {
    let mut rw: libc::c_int = 0;
    let mut rh: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut sp: *mut uint8_t = 0 as *mut uint8_t;
    sp = pSetPiece;
    rw = *sp as libc::c_int;
    sp = sp.offset(2 as libc::c_int as isize);
    rh = *sp as libc::c_int;
    sp = sp.offset(2 as libc::c_int as isize);
    setpc_x = rx1;
    setpc_y = ry1;
    setpc_w = rw;
    setpc_h = rh;
    sp = pSetPiece.offset(4 as libc::c_int as isize);
    j = 0 as libc::c_int;
    while j < rh {
        i = 0 as libc::c_int;
        while i < rw {
            if *sp as libc::c_int != 0 as libc::c_int {
                dungeon[(rx1 + i) as usize][(ry1 + j) as usize] = *sp;
                dflags[(rx1 + i)
                    as usize][(ry1 + j)
                    as usize] = (dflags[(rx1 + i) as usize][(ry1 + j) as usize]
                    as libc::c_int | SETP_BIT as libc::c_int) as uint8_t;
            } else {
                dungeon[(rx1 + i)
                    as usize][(ry1 + j) as usize] = FLOOR_PIC as libc::c_int as uint8_t;
            }
            sp = sp.offset(2 as libc::c_int as isize);
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
unsafe extern "C" fn L4makeDmt() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut idx: libc::c_int = 0;
    let mut val: libc::c_int = 0;
    let mut dmtx: libc::c_int = 0;
    let mut dmty: libc::c_int = 0;
    dmty = 0 as libc::c_int;
    j = 1 as libc::c_int;
    while j <= 77 as libc::c_int {
        dmtx = 0 as libc::c_int;
        i = 1 as libc::c_int;
        while i <= 77 as libc::c_int {
            idx = L4dungeon[i as usize][j as usize] as libc::c_int
                + ((L4dungeon[(i + 1 as libc::c_int) as usize][j as usize]
                    as libc::c_int) << 1 as libc::c_int)
                + ((L4dungeon[i as usize][(j + 1 as libc::c_int) as usize]
                    as libc::c_int) << 2 as libc::c_int)
                + ((L4dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int)
                    << 3 as libc::c_int);
            val = L4ConvTbl[idx as usize] as libc::c_int;
            dungeon[dmtx as usize][dmty as usize] = val as uint8_t;
            dmtx += 1;
            dmtx;
            i += 2 as libc::c_int;
        }
        dmty += 1;
        dmty;
        j += 2 as libc::c_int;
    }
}
unsafe extern "C" fn L4HWallOk(mut i: libc::c_int, mut j: libc::c_int) -> libc::c_int {
    let mut x: libc::c_int = 0;
    let mut wallok: bool32_t = 0;
    x = 1 as libc::c_int;
    while dungeon[(i + x) as usize][j as usize] as libc::c_int == 6 as libc::c_int
        && dflags[(i + x) as usize][j as usize] as libc::c_int == 0 as libc::c_int
        && dungeon[(i + x) as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
            == 6 as libc::c_int
        && dungeon[(i + x) as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
            == 6 as libc::c_int
    {
        x += 1;
        x;
    }
    wallok = 0 as libc::c_int as bool32_t;
    if dungeon[(i + x) as usize][j as usize] as libc::c_int == 10 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[(i + x) as usize][j as usize] as libc::c_int == 12 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[(i + x) as usize][j as usize] as libc::c_int == 13 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[(i + x) as usize][j as usize] as libc::c_int == 15 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[(i + x) as usize][j as usize] as libc::c_int == 16 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[(i + x) as usize][j as usize] as libc::c_int == 21 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[(i + x) as usize][j as usize] as libc::c_int == 22 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if x <= 3 as libc::c_int {
        wallok = 0 as libc::c_int as bool32_t;
    }
    if wallok != 0 { return x } else { return -(1 as libc::c_int) };
}
unsafe extern "C" fn L4VWallOk(mut i: libc::c_int, mut j: libc::c_int) -> libc::c_int {
    let mut y: libc::c_int = 0;
    let mut wallok: bool32_t = 0;
    y = 1 as libc::c_int;
    while dungeon[i as usize][(j + y) as usize] as libc::c_int == 6 as libc::c_int
        && dflags[i as usize][(j + y) as usize] as libc::c_int == 0 as libc::c_int
        && dungeon[(i - 1 as libc::c_int) as usize][(j + y) as usize] as libc::c_int
            == 6 as libc::c_int
        && dungeon[(i + 1 as libc::c_int) as usize][(j + y) as usize] as libc::c_int
            == 6 as libc::c_int
    {
        y += 1;
        y;
    }
    wallok = 0 as libc::c_int as bool32_t;
    if dungeon[i as usize][(j + y) as usize] as libc::c_int == 8 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[i as usize][(j + y) as usize] as libc::c_int == 9 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[i as usize][(j + y) as usize] as libc::c_int == 11 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[i as usize][(j + y) as usize] as libc::c_int == 14 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[i as usize][(j + y) as usize] as libc::c_int == 15 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[i as usize][(j + y) as usize] as libc::c_int == 16 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[i as usize][(j + y) as usize] as libc::c_int == 21 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if dungeon[i as usize][(j + y) as usize] as libc::c_int == 23 as libc::c_int {
        wallok = 1 as libc::c_int as bool32_t;
    }
    if y <= 3 as libc::c_int {
        wallok = 0 as libc::c_int as bool32_t;
    }
    if wallok != 0 { return y } else { return -(1 as libc::c_int) };
}
unsafe extern "C" fn L4HorizWall(
    mut i: libc::c_int,
    mut j: libc::c_int,
    mut dx: libc::c_int,
) {
    let mut xx: libc::c_int = 0;
    if dungeon[i as usize][j as usize] as libc::c_int == 13 as libc::c_int {
        dungeon[i as usize][j as usize] = 17 as libc::c_int as uint8_t;
    }
    if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int {
        dungeon[i as usize][j as usize] = 11 as libc::c_int as uint8_t;
    }
    if dungeon[i as usize][j as usize] as libc::c_int == 12 as libc::c_int {
        dungeon[i as usize][j as usize] = 14 as libc::c_int as uint8_t;
    }
    xx = 1 as libc::c_int;
    while xx < dx {
        dungeon[(i + xx) as usize][j as usize] = 2 as libc::c_int as uint8_t;
        xx += 1;
        xx;
    }
    if dungeon[(i + dx) as usize][j as usize] as libc::c_int == 15 as libc::c_int {
        dungeon[(i + dx) as usize][j as usize] = 14 as libc::c_int as uint8_t;
    }
    if dungeon[(i + dx) as usize][j as usize] as libc::c_int == 10 as libc::c_int {
        dungeon[(i + dx) as usize][j as usize] = 17 as libc::c_int as uint8_t;
    }
    if dungeon[(i + dx) as usize][j as usize] as libc::c_int == 21 as libc::c_int {
        dungeon[(i + dx) as usize][j as usize] = 23 as libc::c_int as uint8_t;
    }
    if dungeon[(i + dx) as usize][j as usize] as libc::c_int == 22 as libc::c_int {
        dungeon[(i + dx) as usize][j as usize] = 29 as libc::c_int as uint8_t;
    }
    xx = random_(
        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
        334 as libc::c_int,
        0 as libc::c_int as uint8_t,
        dx - 3 as libc::c_int,
    ) + 1 as libc::c_int;
    dungeon[(i + xx) as usize][j as usize] = 57 as libc::c_int as uint8_t;
    dungeon[(i + xx + 2 as libc::c_int)
        as usize][j as usize] = 56 as libc::c_int as uint8_t;
    dungeon[(i + xx + 1 as libc::c_int)
        as usize][j as usize] = 60 as libc::c_int as uint8_t;
    if dungeon[(i + xx) as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
        == 6 as libc::c_int
    {
        dungeon[(i + xx)
            as usize][(j - 1 as libc::c_int) as usize] = 58 as libc::c_int as uint8_t;
    }
    if dungeon[(i + xx + 1 as libc::c_int) as usize][(j - 1 as libc::c_int) as usize]
        as libc::c_int == 6 as libc::c_int
    {
        dungeon[(i + xx + 1 as libc::c_int)
            as usize][(j - 1 as libc::c_int) as usize] = 59 as libc::c_int as uint8_t;
    }
}
unsafe extern "C" fn L4VertWall(
    mut i: libc::c_int,
    mut j: libc::c_int,
    mut dy: libc::c_int,
) {
    let mut yy: libc::c_int = 0;
    if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int {
        dungeon[i as usize][j as usize] = 17 as libc::c_int as uint8_t;
    }
    if dungeon[i as usize][j as usize] as libc::c_int == 8 as libc::c_int {
        dungeon[i as usize][j as usize] = 9 as libc::c_int as uint8_t;
    }
    if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int {
        dungeon[i as usize][j as usize] = 10 as libc::c_int as uint8_t;
    }
    yy = 1 as libc::c_int;
    while yy < dy {
        dungeon[i as usize][(j + yy) as usize] = 1 as libc::c_int as uint8_t;
        yy += 1;
        yy;
    }
    if dungeon[i as usize][(j + dy) as usize] as libc::c_int == 11 as libc::c_int {
        dungeon[i as usize][(j + dy) as usize] = 17 as libc::c_int as uint8_t;
    }
    if dungeon[i as usize][(j + dy) as usize] as libc::c_int == 9 as libc::c_int {
        dungeon[i as usize][(j + dy) as usize] = 10 as libc::c_int as uint8_t;
    }
    if dungeon[i as usize][(j + dy) as usize] as libc::c_int == 16 as libc::c_int {
        dungeon[i as usize][(j + dy) as usize] = 13 as libc::c_int as uint8_t;
    }
    if dungeon[i as usize][(j + dy) as usize] as libc::c_int == 21 as libc::c_int {
        dungeon[i as usize][(j + dy) as usize] = 22 as libc::c_int as uint8_t;
    }
    if dungeon[i as usize][(j + dy) as usize] as libc::c_int == 23 as libc::c_int {
        dungeon[i as usize][(j + dy) as usize] = 29 as libc::c_int as uint8_t;
    }
    yy = random_(
        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
        381 as libc::c_int,
        0 as libc::c_int as uint8_t,
        dy - 3 as libc::c_int,
    ) + 1 as libc::c_int;
    dungeon[i as usize][(j + yy) as usize] = 53 as libc::c_int as uint8_t;
    dungeon[i
        as usize][(j + yy + 2 as libc::c_int) as usize] = 52 as libc::c_int as uint8_t;
    dungeon[i
        as usize][(j + yy + 1 as libc::c_int) as usize] = 6 as libc::c_int as uint8_t;
    if dungeon[(i - 1 as libc::c_int) as usize][(j + yy) as usize] as libc::c_int
        == 6 as libc::c_int
    {
        dungeon[(i - 1 as libc::c_int)
            as usize][(j + yy) as usize] = 54 as libc::c_int as uint8_t;
    }
    if dungeon[(i - 1 as libc::c_int) as usize][(j + yy - 1 as libc::c_int) as usize]
        as libc::c_int == 6 as libc::c_int
    {
        dungeon[(i - 1 as libc::c_int)
            as usize][(j + yy - 1 as libc::c_int)
            as usize] = 55 as libc::c_int as uint8_t;
    }
}
unsafe extern "C" fn L4AddWall() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dflags[i as usize][j as usize] as libc::c_int == 0 as libc::c_int {
                if dungeon[i as usize][j as usize] as libc::c_int == 10 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        402 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    x = L4HWallOk(i, j);
                    if x != -(1 as libc::c_int) {
                        L4HorizWall(i, j, x);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 12 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        408 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    x = L4HWallOk(i, j);
                    if x != -(1 as libc::c_int) {
                        L4HorizWall(i, j, x);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 13 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        414 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    x = L4HWallOk(i, j);
                    if x != -(1 as libc::c_int) {
                        L4HorizWall(i, j, x);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        420 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    x = L4HWallOk(i, j);
                    if x != -(1 as libc::c_int) {
                        L4HorizWall(i, j, x);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        426 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    x = L4HWallOk(i, j);
                    if x != -(1 as libc::c_int) {
                        L4HorizWall(i, j, x);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        432 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    x = L4HWallOk(i, j);
                    if x != -(1 as libc::c_int) {
                        L4HorizWall(i, j, x);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 22 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        438 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    x = L4HWallOk(i, j);
                    if x != -(1 as libc::c_int) {
                        L4HorizWall(i, j, x);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 8 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        445 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    y = L4VWallOk(i, j);
                    if y != -(1 as libc::c_int) {
                        L4VertWall(i, j, y);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 9 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        451 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    y = L4VWallOk(i, j);
                    if y != -(1 as libc::c_int) {
                        L4VertWall(i, j, y);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 11 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        457 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    y = L4VWallOk(i, j);
                    if y != -(1 as libc::c_int) {
                        L4VertWall(i, j, y);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        463 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    y = L4VWallOk(i, j);
                    if y != -(1 as libc::c_int) {
                        L4VertWall(i, j, y);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        469 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    y = L4VWallOk(i, j);
                    if y != -(1 as libc::c_int) {
                        L4VertWall(i, j, y);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        475 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    y = L4VWallOk(i, j);
                    if y != -(1 as libc::c_int) {
                        L4VertWall(i, j, y);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        481 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    y = L4VWallOk(i, j);
                    if y != -(1 as libc::c_int) {
                        L4VertWall(i, j, y);
                    }
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 23 as libc::c_int
                    && random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        487 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        100 as libc::c_int,
                    ) < L4_WALLRND as libc::c_int
                {
                    y = L4VWallOk(i, j);
                    if y != -(1 as libc::c_int) {
                        L4VertWall(i, j, y);
                    }
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
unsafe extern "C" fn L4tileFix() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 5 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 13 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 14 as libc::c_int as uint8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 2 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 11 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 9 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 13 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 6 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 14 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 6 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 13 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 10 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 6 as libc::c_int
                && dungeon[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[i
                    as usize][(j - 1 as libc::c_int)
                    as usize] = 1 as libc::c_int as uint8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == 13 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 27 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 27 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 27 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 26 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 15 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 14 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 15 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 14 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 22 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 6 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int != 0
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 22 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 22 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 13 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 28 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 6 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 27 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 27 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 6 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 21 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 29 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 9 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 15 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 14 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 29 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 18 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 24 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 9 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 15 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 14 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 24 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 24 as libc::c_int
                && dungeon[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
                && dungeon[i as usize][(j - 2 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[i
                    as usize][(j - 1 as libc::c_int)
                    as usize] = 21 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 28 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 28 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 28 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 18 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 28 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 18 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 22 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 18 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 13 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 18 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 22 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 28 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 23 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 28 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 23 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 29 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 28 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 21 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 24 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 29 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 18 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 25 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 9 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 11 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 10 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 22 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 18 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 18 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 24 as libc::c_int
                && dungeon[(i - 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i - 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 10 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 22 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 18 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 18 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 13 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 22 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 18 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 24 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 9 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 29 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 23 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 23 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 25 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 22 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 11 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 23 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 11 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 11 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 15 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 14 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 23 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 27 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 26 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 18 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 24 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 26 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 29 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 29 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 15 as libc::c_int
            {
                dungeon[i
                    as usize][(j - 1 as libc::c_int)
                    as usize] = 10 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 18 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 23 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 18 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 18 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 10 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 23 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 28 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 23 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 23 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 18 as libc::c_int
                && dungeon[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 24 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 23 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 28 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 28 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 23 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 23 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 29 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 29 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 18 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 26 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 19 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 18 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 13 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 10 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 25 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 30 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 18 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 18 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 15 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 11 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 5 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 11 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 13 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 13 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 24 as libc::c_int
                && dungeon[i as usize][(j + 2 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 16 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 29 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i - 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i - 1 as libc::c_int)
                    as usize][j as usize] = 8 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[i
                    as usize][(j - 1 as libc::c_int)
                    as usize] = 7 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 6 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 10 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 9 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 10 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 13 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 5 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 16 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 13 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 6 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 13 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 25 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 10 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 13 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 5 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 28 as libc::c_int
                && dungeon[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 23 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 10 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 11 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 11 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 5 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 10 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 27 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 11 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 1 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 11 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 5 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 9 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 5 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 14 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 5 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 5 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 5 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 16 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 2 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 9 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 8 as libc::c_int
            {
                dungeon[i
                    as usize][(j - 1 as libc::c_int)
                    as usize] = 9 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 28 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 23 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 10 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 17 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 10 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 4 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 17 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 5 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 29 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 9 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 10 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 13 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 5 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 9 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 16 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 13 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 10 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 16 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 13 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 3 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 11 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 5 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 10 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 3 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 16 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 16 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 5 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 1 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 4 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 13 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 10 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 12 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 10 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 22 as libc::c_int
                && dungeon[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 11 as libc::c_int
            {
                dungeon[i
                    as usize][(j + 1 as libc::c_int)
                    as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 28 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 16 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 23 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 28 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 23 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 1 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 6 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 16 as libc::c_int as uint8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 28 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 16 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 23 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == 21 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 13 as libc::c_int
                && dungeon[(i + 2 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 2 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            if dungeon[i as usize][j as usize] as libc::c_int == 19 as libc::c_int
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 15 as libc::c_int
                && dungeon[(i + 1 as libc::c_int)
                    as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                    == 12 as libc::c_int
            {
                dungeon[(i + 1 as libc::c_int)
                    as usize][j as usize] = 17 as libc::c_int as uint8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
unsafe extern "C" fn DRLG_L4Subs() {
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut rv: libc::c_int = 0;
    let mut c: uint8_t = 0;
    y = 0 as libc::c_int;
    while y < MDMAXY as libc::c_int {
        x = 0 as libc::c_int;
        while x < MDMAXX as libc::c_int {
            rv = random_(
                b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                1031 as libc::c_int,
                0 as libc::c_int as uint8_t,
                3 as libc::c_int,
            );
            if rv == 0 as libc::c_int {
                c = dungeon[x as usize][y as usize];
                c = L4BTYPES[c as usize];
                if c as libc::c_int != 0 as libc::c_int
                    && dflags[x as usize][y as usize] as libc::c_int == 0 as libc::c_int
                {
                    rv = random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        1036 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        16 as libc::c_int,
                    );
                    i = -(1 as libc::c_int);
                    while rv >= 0 as libc::c_int {
                        i += 1;
                        i;
                        if i == NUMBBLOCKS as libc::c_int {
                            i = 0 as libc::c_int;
                        }
                        if c as libc::c_int == L4BTYPES[i as usize] as libc::c_int {
                            rv -= 1;
                            rv;
                        }
                    }
                    dungeon[x as usize][y as usize] = i as uint8_t;
                }
            }
            x += 1;
            x;
        }
        y += 1;
        y;
    }
    y = 0 as libc::c_int;
    while y < MDMAXY as libc::c_int {
        x = 0 as libc::c_int;
        while x < MDMAXX as libc::c_int {
            rv = random_(
                b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                1054 as libc::c_int,
                0 as libc::c_int as uint8_t,
                10 as libc::c_int,
            );
            if rv == 0 as libc::c_int {
                c = dungeon[x as usize][y as usize];
                c = L4BTYPES[c as usize];
                if c as libc::c_int == 6 as libc::c_int
                    && dflags[x as usize][y as usize] as libc::c_int == 0 as libc::c_int
                {
                    dungeon[x
                        as usize][y
                        as usize] = (random_(
                        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                        1059 as libc::c_int,
                        0 as libc::c_int as uint8_t,
                        3 as libc::c_int,
                    ) + 95 as libc::c_int) as uint8_t;
                }
            }
            x += 1;
            x;
        }
        y += 1;
        y;
    }
}
unsafe extern "C" fn L4makeDungeon() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut k: libc::c_int = 0;
    let mut l: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < L4DUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < L4DUNX as libc::c_int {
            k = i << 1 as libc::c_int;
            l = j << 1 as libc::c_int;
            L4dungeon[k as usize][l as usize] = dung[i as usize][j as usize];
            L4dungeon[k
                as usize][(l + 1 as libc::c_int)
                as usize] = dung[i as usize][j as usize];
            L4dungeon[(k + 1 as libc::c_int)
                as usize][l as usize] = dung[i as usize][j as usize];
            L4dungeon[(k + 1 as libc::c_int)
                as usize][(l + 1 as libc::c_int)
                as usize] = dung[i as usize][j as usize];
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < L4DUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < L4DUNX as libc::c_int {
            k = i << 1 as libc::c_int;
            l = j << 1 as libc::c_int;
            L4dungeon[k
                as usize][(L4DUNY as libc::c_int * 2 as libc::c_int + l)
                as usize] = dung[i
                as usize][(L4DUNY as libc::c_int - 1 as libc::c_int - j) as usize];
            L4dungeon[k
                as usize][(L4DUNY as libc::c_int * 2 as libc::c_int + l
                + 1 as libc::c_int)
                as usize] = dung[i
                as usize][(L4DUNY as libc::c_int - 1 as libc::c_int - j) as usize];
            L4dungeon[(k + 1 as libc::c_int)
                as usize][(L4DUNY as libc::c_int * 2 as libc::c_int + l)
                as usize] = dung[i
                as usize][(L4DUNY as libc::c_int - 1 as libc::c_int - j) as usize];
            L4dungeon[(k + 1 as libc::c_int)
                as usize][(L4DUNY as libc::c_int * 2 as libc::c_int + l
                + 1 as libc::c_int)
                as usize] = dung[i
                as usize][(L4DUNY as libc::c_int - 1 as libc::c_int - j) as usize];
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < L4DUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < L4DUNX as libc::c_int {
            k = i << 1 as libc::c_int;
            l = j << 1 as libc::c_int;
            L4dungeon[(k + L4DUNX as libc::c_int * 2 as libc::c_int)
                as usize][l
                as usize] = dung[(L4DUNX as libc::c_int - 1 as libc::c_int - i)
                as usize][j as usize];
            L4dungeon[(k + L4DUNX as libc::c_int * 2 as libc::c_int)
                as usize][(l + 1 as libc::c_int)
                as usize] = dung[(L4DUNX as libc::c_int - 1 as libc::c_int - i)
                as usize][j as usize];
            L4dungeon[(k + L4DUNX as libc::c_int * 2 as libc::c_int + 1 as libc::c_int)
                as usize][l
                as usize] = dung[(L4DUNX as libc::c_int - 1 as libc::c_int - i)
                as usize][j as usize];
            L4dungeon[(k + L4DUNX as libc::c_int * 2 as libc::c_int + 1 as libc::c_int)
                as usize][(l + 1 as libc::c_int)
                as usize] = dung[(L4DUNX as libc::c_int - 1 as libc::c_int - i)
                as usize][j as usize];
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    j = 0 as libc::c_int;
    while j < L4DUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < L4DUNX as libc::c_int {
            k = i << 1 as libc::c_int;
            l = j << 1 as libc::c_int;
            L4dungeon[(L4DUNX as libc::c_int * 2 as libc::c_int + k)
                as usize][(L4DUNY as libc::c_int * 2 as libc::c_int + l)
                as usize] = dung[(L4DUNX as libc::c_int - 1 as libc::c_int - i)
                as usize][(L4DUNY as libc::c_int - 1 as libc::c_int - j) as usize];
            L4dungeon[(L4DUNX as libc::c_int * 2 as libc::c_int + k)
                as usize][(L4DUNY as libc::c_int * 2 as libc::c_int + l
                + 1 as libc::c_int)
                as usize] = dung[(L4DUNX as libc::c_int - 1 as libc::c_int - i)
                as usize][(L4DUNY as libc::c_int - 1 as libc::c_int - j) as usize];
            L4dungeon[(L4DUNX as libc::c_int * 2 as libc::c_int + k + 1 as libc::c_int)
                as usize][(L4DUNY as libc::c_int * 2 as libc::c_int + l)
                as usize] = dung[(L4DUNX as libc::c_int - 1 as libc::c_int - i)
                as usize][(L4DUNY as libc::c_int - 1 as libc::c_int - j) as usize];
            L4dungeon[(L4DUNX as libc::c_int * 2 as libc::c_int + k + 1 as libc::c_int)
                as usize][(L4DUNY as libc::c_int * 2 as libc::c_int + l
                + 1 as libc::c_int)
                as usize] = dung[(L4DUNX as libc::c_int - 1 as libc::c_int - i)
                as usize][(L4DUNY as libc::c_int - 1 as libc::c_int - j) as usize];
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
unsafe extern "C" fn uShape() {
    let mut j: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut rv: libc::c_int = 0;
    j = 19 as libc::c_int;
    while j >= 0 as libc::c_int {
        i = 19 as libc::c_int;
        while i >= 0 as libc::c_int {
            if dung[i as usize][j as usize] as libc::c_int != 1 as libc::c_int {
                hallok[j as usize] = 0 as libc::c_int as bool32_t;
            }
            if dung[i as usize][j as usize] as libc::c_int == 1 as libc::c_int {
                if (i + 1 as libc::c_int) < L4DUNX as libc::c_int
                    && (j + 1 as libc::c_int) < L4DUNY as libc::c_int
                    && dung[i as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                        == 1 as libc::c_int
                    && dung[(i + 1 as libc::c_int)
                        as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                        == 0 as libc::c_int
                {
                    hallok[j as usize] = 1 as libc::c_int as bool32_t;
                } else {
                    hallok[j as usize] = 0 as libc::c_int as bool32_t;
                }
                i = 0 as libc::c_int;
            }
            i -= 1;
            i;
        }
        j -= 1;
        j;
    }
    rv = random_(
        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
        1141 as libc::c_int,
        0 as libc::c_int as uint8_t,
        19 as libc::c_int,
    ) + 1 as libc::c_int;
    loop {
        if hallok[rv as usize] != 0 {
            i = 19 as libc::c_int;
            while i >= 0 as libc::c_int {
                if dung[i as usize][rv as usize] as libc::c_int == 1 as libc::c_int {
                    i = -(1 as libc::c_int);
                    rv = 0 as libc::c_int;
                } else {
                    dung[i as usize][rv as usize] = 1 as libc::c_int as uint8_t;
                    dung[i
                        as usize][(rv + 1 as libc::c_int)
                        as usize] = 1 as libc::c_int as uint8_t;
                }
                i -= 1;
                i;
            }
        } else {
            rv += 1;
            rv;
            if rv == 20 as libc::c_int {
                rv = 1 as libc::c_int;
            }
        }
        if !(rv != 0 as libc::c_int) {
            break;
        }
    }
    i = 19 as libc::c_int;
    while i >= 0 as libc::c_int {
        j = 19 as libc::c_int;
        while j >= 0 as libc::c_int {
            if dung[i as usize][j as usize] as libc::c_int != 1 as libc::c_int {
                hallok[i as usize] = 0 as libc::c_int as bool32_t;
            }
            if dung[i as usize][j as usize] as libc::c_int == 1 as libc::c_int {
                if (i + 1 as libc::c_int) < L4DUNX as libc::c_int
                    && (j + 1 as libc::c_int) < L4DUNY as libc::c_int
                    && dung[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                        == 1 as libc::c_int
                    && dung[(i + 1 as libc::c_int)
                        as usize][(j + 1 as libc::c_int) as usize] as libc::c_int
                        == 0 as libc::c_int
                {
                    hallok[i as usize] = 1 as libc::c_int as bool32_t;
                } else {
                    hallok[i as usize] = 0 as libc::c_int as bool32_t;
                }
                j = 0 as libc::c_int;
            }
            j -= 1;
            j;
        }
        i -= 1;
        i;
    }
    rv = random_(
        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
        1181 as libc::c_int,
        0 as libc::c_int as uint8_t,
        19 as libc::c_int,
    ) + 1 as libc::c_int;
    loop {
        if hallok[rv as usize] != 0 {
            j = 19 as libc::c_int;
            while j >= 0 as libc::c_int {
                if dung[rv as usize][j as usize] as libc::c_int == 1 as libc::c_int {
                    j = -(1 as libc::c_int);
                    rv = 0 as libc::c_int;
                } else {
                    dung[rv as usize][j as usize] = 1 as libc::c_int as uint8_t;
                    dung[(rv + 1 as libc::c_int)
                        as usize][j as usize] = 1 as libc::c_int as uint8_t;
                }
                j -= 1;
                j;
            }
        } else {
            rv += 1;
            rv;
            if rv == 20 as libc::c_int {
                rv = 1 as libc::c_int;
            }
        }
        if !(rv != 0 as libc::c_int) {
            break;
        }
    };
}
unsafe extern "C" fn GetArea() -> int32_t {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut rv: int32_t = 0;
    rv = 0 as libc::c_int;
    j = 0 as libc::c_int;
    while j < L4DUNY as libc::c_int {
        i = 0 as libc::c_int;
        while i < L4DUNX as libc::c_int {
            if dung[i as usize][j as usize] as libc::c_int == 1 as libc::c_int {
                rv += 1;
                rv;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    return rv;
}
unsafe extern "C" fn L4drawRoom(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut width: libc::c_int,
    mut height: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < height {
        i = 0 as libc::c_int;
        while i < width {
            if !(x + i >= L4DUNX as libc::c_int || y + j >= L4DUNY as libc::c_int) {
                dung[(x + i) as usize][(y + j) as usize] = 1 as libc::c_int as uint8_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
unsafe extern "C" fn L4checkRoom(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut width: libc::c_int,
    mut height: libc::c_int,
) -> bool32_t {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    if x <= 0 as libc::c_int || y <= 0 as libc::c_int {
        return 0 as libc::c_int as bool32_t;
    }
    j = 0 as libc::c_int;
    while j < height {
        i = 0 as libc::c_int;
        while i < width {
            if x + i < 0 as libc::c_int || x + i >= L4DUNX as libc::c_int
                || y + j < 0 as libc::c_int || y + j >= L4DUNY as libc::c_int
            {
                return 0 as libc::c_int as bool32_t;
            }
            if dung[(x + i) as usize][(y + j) as usize] as libc::c_int
                != 0 as libc::c_int
            {
                return 0 as libc::c_int as bool32_t;
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn L4roomGen(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut w: libc::c_int,
    mut h: libc::c_int,
    mut dir: libc::c_int,
) {
    let mut rx: libc::c_int = 0;
    let mut ry: libc::c_int = 0;
    let mut rx2: libc::c_int = 0;
    let mut ry2: libc::c_int = 0;
    let mut height: libc::c_int = 0;
    let mut width: libc::c_int = 0;
    let mut cx1: libc::c_int = 0;
    let mut cy1: libc::c_int = 0;
    let mut cw: libc::c_int = 0;
    let mut ch: libc::c_int = 0;
    let mut num: libc::c_int = 0;
    let mut dirProb: libc::c_int = 0;
    let mut ran: libc::c_int = 0;
    let mut c: bool32_t = 0;
    let mut d: bool32_t = 0;
    ran = random_(
        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
        1265 as libc::c_int,
        0 as libc::c_int as uint8_t,
        4 as libc::c_int,
    );
    if dir == L4DIR_VERT as libc::c_int {
        if ran == 0 as libc::c_int {
            dirProb = L4DIR_HORIZ as libc::c_int;
        } else {
            dirProb = L4DIR_VERT as libc::c_int;
        }
    } else if ran == 0 as libc::c_int {
        dirProb = L4DIR_VERT as libc::c_int;
    } else {
        dirProb = L4DIR_HORIZ as libc::c_int;
    }
    match dirProb {
        0 => {
            num = 0 as libc::c_int;
            loop {
                width = (random_(
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    1284 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    L4ROOM_MAX as libc::c_int - L4ROOM_MIN as libc::c_int
                        + 1 as libc::c_int,
                ) + L4ROOM_MIN as libc::c_int >> 1 as libc::c_int) << 1 as libc::c_int;
                height = (random_(
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    1285 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    L4ROOM_MAX as libc::c_int - L4ROOM_MIN as libc::c_int
                        + 1 as libc::c_int,
                ) + L4ROOM_MIN as libc::c_int >> 1 as libc::c_int) << 1 as libc::c_int;
                ry = y + h / 2 as libc::c_int - height / 2 as libc::c_int;
                rx = x - width;
                cx1 = rx - 1 as libc::c_int;
                cy1 = ry - 1 as libc::c_int;
                cw = height + 2 as libc::c_int;
                ch = width + 1 as libc::c_int;
                c = L4checkRoom(cx1, cy1, cw, ch);
                num += 1;
                num;
                if !(c == 0 as libc::c_int as bool32_t && num < 20 as libc::c_int) {
                    break;
                }
            }
            if c == 1 as libc::c_int as bool32_t {
                L4drawRoom(rx, ry, width, height);
            }
            rx2 = x + w;
            cx1 = rx2;
            cy1 = ry - 1 as libc::c_int;
            ch = height + 2 as libc::c_int;
            cw = width + 1 as libc::c_int;
            d = L4checkRoom(cx1, cy1, cw, ch);
            if d == 1 as libc::c_int as bool32_t {
                L4drawRoom(rx2, ry, width, height);
            }
            if c == 1 as libc::c_int as bool32_t {
                L4roomGen(rx, ry, width, height, L4DIR_VERT as libc::c_int);
            }
            if d == 1 as libc::c_int as bool32_t {
                L4roomGen(rx2, ry, width, height, L4DIR_VERT as libc::c_int);
            }
        }
        1 => {
            num = 0 as libc::c_int;
            loop {
                width = (random_(
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    1321 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    L4ROOM_MAX as libc::c_int - L4ROOM_MIN as libc::c_int
                        + 1 as libc::c_int,
                ) + L4ROOM_MIN as libc::c_int >> 1 as libc::c_int) << 1 as libc::c_int;
                height = (random_(
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    1322 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    L4ROOM_MAX as libc::c_int - L4ROOM_MIN as libc::c_int
                        + 1 as libc::c_int,
                ) + L4ROOM_MIN as libc::c_int >> 1 as libc::c_int) << 1 as libc::c_int;
                rx = x + w / 2 as libc::c_int - width / 2 as libc::c_int;
                ry = y - height;
                cx1 = rx - 1 as libc::c_int;
                cy1 = ry - 1 as libc::c_int;
                ch = height + 1 as libc::c_int;
                cw = width + 2 as libc::c_int;
                c = L4checkRoom(cx1, cy1, cw, ch);
                num += 1;
                num;
                if !(c == 0 as libc::c_int as bool32_t && num < 20 as libc::c_int) {
                    break;
                }
            }
            if c == 1 as libc::c_int as bool32_t {
                L4drawRoom(rx, ry, width, height);
            }
            ry2 = y + h;
            cx1 = rx - 1 as libc::c_int;
            cy1 = ry2;
            ch = height + 1 as libc::c_int;
            cw = width + 2 as libc::c_int;
            d = L4checkRoom(cx1, cy1, cw, ch);
            if d == 1 as libc::c_int as bool32_t {
                L4drawRoom(rx, ry2, width, height);
            }
            if c == 1 as libc::c_int as bool32_t {
                L4roomGen(rx, ry, width, height, L4DIR_HORIZ as libc::c_int);
            }
            if d == 1 as libc::c_int as bool32_t {
                L4roomGen(rx, ry2, width, height, L4DIR_HORIZ as libc::c_int);
            }
        }
        _ => {}
    };
}
unsafe extern "C" fn L4firstRoom() {
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut w: libc::c_int = 0;
    let mut h: libc::c_int = 0;
    let mut xstor: libc::c_int = 0;
    let mut ystor: libc::c_int = 0;
    let mut rndx: libc::c_int = 0;
    let mut rndy: libc::c_int = 0;
    let mut xmin: libc::c_int = 0;
    let mut xmax: libc::c_int = 0;
    let mut ymin: libc::c_int = 0;
    let mut ymax: libc::c_int = 0;
    if currlevel as libc::c_int != 16 as libc::c_int {
        if currlevel as libc::c_int
            == quests[Q_WARLORD as libc::c_int as usize]._qlevel as libc::c_int
            && quests[Q_WARLORD as libc::c_int as usize]._qactive as libc::c_int
                != QUEST_NOTAVAIL as libc::c_int
        {
            if !(gbMaxPlayers as libc::c_int == 1 as libc::c_int) {
                assert_fail(
                    1365 as libc::c_int,
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    b"gbMaxPlayers == 1\0" as *const u8 as *const libc::c_char,
                );
            }
            w = 11 as libc::c_int;
            h = 11 as libc::c_int;
        } else if currlevel as libc::c_int
            == quests[Q_BETRAYER as libc::c_int as usize]._qlevel as libc::c_int
            && gbMaxPlayers as libc::c_int != 1 as libc::c_int
        {
            w = 11 as libc::c_int;
            h = 11 as libc::c_int;
        } else {
            w = random_(
                b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                1372 as libc::c_int,
                0 as libc::c_int as uint8_t,
                L4ROOM_MAX as libc::c_int - L4ROOM_MIN as libc::c_int + 1 as libc::c_int,
            ) + L4ROOM_MIN as libc::c_int;
            h = random_(
                b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                1373 as libc::c_int,
                0 as libc::c_int as uint8_t,
                L4ROOM_MAX as libc::c_int - L4ROOM_MIN as libc::c_int + 1 as libc::c_int,
            ) + L4ROOM_MIN as libc::c_int;
        }
    } else {
        w = DIABSIZE as libc::c_int;
        h = DIABSIZE as libc::c_int;
    }
    xmin = 20 as libc::c_int - w >> 1 as libc::c_int;
    xmax = 19 as libc::c_int - w;
    rndx = random_(
        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
        1382 as libc::c_int,
        0 as libc::c_int as uint8_t,
        xmax - xmin + 1 as libc::c_int,
    ) + xmin;
    if w + rndx > 19 as libc::c_int {
        xstor = w + rndx - 19 as libc::c_int;
        x = rndx - xstor + 1 as libc::c_int;
    } else {
        x = rndx;
    }
    ymin = 20 as libc::c_int - h >> 1 as libc::c_int;
    ymax = 19 as libc::c_int - h;
    rndy = random_(
        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
        1392 as libc::c_int,
        0 as libc::c_int as uint8_t,
        ymax - ymin + 1 as libc::c_int,
    ) + ymin;
    if h + rndy > 19 as libc::c_int {
        ystor = h + rndy - 19 as libc::c_int;
        y = rndy - ystor + 1 as libc::c_int;
    } else {
        y = rndy;
    }
    if currlevel as libc::c_int == 16 as libc::c_int {
        l4holdx = x;
        l4holdy = y;
    }
    if QuestStatus(Q_WARLORD as libc::c_int) != 0
        || currlevel as libc::c_int
            == quests[Q_BETRAYER as libc::c_int as usize]._qlevel as libc::c_int
            && gbMaxPlayers as libc::c_int != 1 as libc::c_int
    {
        SP4x1 = x + 1 as libc::c_int;
        SP4y1 = y + 1 as libc::c_int;
        SP4x2 = SP4x1 + w;
        SP4y2 = SP4y1 + h;
    } else {
        SP4x1 = 0 as libc::c_int;
        SP4y1 = 0 as libc::c_int;
        SP4x2 = 0 as libc::c_int;
        SP4y2 = 0 as libc::c_int;
    }
    L4drawRoom(x, y, w, h);
    L4roomGen(
        x,
        y,
        w,
        h,
        random_(
            b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
            1418 as libc::c_int,
            0 as libc::c_int as uint8_t,
            2 as libc::c_int,
        ),
    );
}
#[no_mangle]
pub unsafe extern "C" fn L4SaveQuads() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    x = l4holdx;
    y = l4holdy;
    j = 0 as libc::c_int;
    while j < DIABSIZE as libc::c_int {
        i = 0 as libc::c_int;
        while i < DIABSIZE as libc::c_int {
            dflags[(x + i) as usize][(y + j) as usize] = 1 as libc::c_int as uint8_t;
            dflags[(39 as libc::c_int - x - i)
                as usize][(y + j) as usize] = 1 as libc::c_int as uint8_t;
            dflags[(x + i)
                as usize][(39 as libc::c_int - y - j)
                as usize] = 1 as libc::c_int as uint8_t;
            dflags[(39 as libc::c_int - x - i)
                as usize][(39 as libc::c_int - y - j)
                as usize] = 1 as libc::c_int as uint8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_L4SetRoom(
    mut pSetPiece_0: *mut uint8_t,
    mut rx1: libc::c_int,
    mut ry1: libc::c_int,
) {
    let mut rw: libc::c_int = 0;
    let mut rh: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut sp: *mut uint8_t = 0 as *mut uint8_t;
    sp = pSetPiece_0;
    rw = *sp as libc::c_int;
    sp = sp.offset(2 as libc::c_int as isize);
    rh = *sp as libc::c_int;
    sp = sp.offset(2 as libc::c_int as isize);
    sp = pSetPiece_0.offset(4 as libc::c_int as isize);
    j = 0 as libc::c_int;
    while j < rh {
        i = 0 as libc::c_int;
        while i < rw {
            if *sp as libc::c_int != 0 as libc::c_int {
                dungeon[(rx1 + i) as usize][(ry1 + j) as usize] = *sp;
                dflags[(rx1 + i)
                    as usize][(ry1 + j)
                    as usize] = (dflags[(rx1 + i) as usize][(ry1 + j) as usize]
                    as libc::c_int | SETP_BIT as libc::c_int) as uint8_t;
            } else {
                dungeon[(rx1 + i)
                    as usize][(ry1 + j) as usize] = 6 as libc::c_int as uint8_t;
            }
            sp = sp.offset(2 as libc::c_int as isize);
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_LoadDiabQuads(mut preflag: bool32_t) {
    let mut pSetPiece_0: *mut uint8_t = 0 as *mut uint8_t;
    pSetPiece_0 = LoadFileInMem(
        b"Levels\\L4Data\\diab1.DUN\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    diabquad1x = l4holdx
        + (DIABSIZE as libc::c_int - 6 as libc::c_int >> 1 as libc::c_int);
    diabquad1y = l4holdy
        + (DIABSIZE as libc::c_int - 6 as libc::c_int >> 1 as libc::c_int);
    DRLG_L4SetRoom(pSetPiece_0, diabquad1x, diabquad1y);
    let mut p__p: *mut libc::c_void = pSetPiece_0 as *mut libc::c_void;
    pSetPiece_0 = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    if preflag != 0 {
        pSetPiece_0 = LoadFileInMem(
            b"Levels\\L4Data\\diab2b.DUN\0" as *const u8 as *const libc::c_char,
            0 as *mut uint32_t,
        );
    } else {
        pSetPiece_0 = LoadFileInMem(
            b"Levels\\L4Data\\diab2a.DUN\0" as *const u8 as *const libc::c_char,
            0 as *mut uint32_t,
        );
    }
    diabquad2x = 39 as libc::c_int - 11 as libc::c_int - l4holdx
        - (DIABSIZE as libc::c_int - 11 as libc::c_int >> 1 as libc::c_int);
    diabquad2y = l4holdy
        + (DIABSIZE as libc::c_int - 12 as libc::c_int >> 1 as libc::c_int);
    DRLG_L4SetRoom(pSetPiece_0, diabquad2x, diabquad2y);
    let mut p__p_0: *mut libc::c_void = pSetPiece_0 as *mut libc::c_void;
    pSetPiece_0 = 0 as *mut uint8_t;
    mem_free_dbg(p__p_0);
    if preflag != 0 {
        pSetPiece_0 = LoadFileInMem(
            b"Levels\\L4Data\\diab3b.DUN\0" as *const u8 as *const libc::c_char,
            0 as *mut uint32_t,
        );
    } else {
        pSetPiece_0 = LoadFileInMem(
            b"Levels\\L4Data\\diab3a.DUN\0" as *const u8 as *const libc::c_char,
            0 as *mut uint32_t,
        );
    }
    diabquad3x = l4holdx
        + (DIABSIZE as libc::c_int - 11 as libc::c_int >> 1 as libc::c_int);
    diabquad3y = 39 as libc::c_int - 11 as libc::c_int - l4holdy
        - (DIABSIZE as libc::c_int - 11 as libc::c_int >> 1 as libc::c_int);
    DRLG_L4SetRoom(pSetPiece_0, diabquad3x, diabquad3y);
    let mut p__p_1: *mut libc::c_void = pSetPiece_0 as *mut libc::c_void;
    pSetPiece_0 = 0 as *mut uint8_t;
    mem_free_dbg(p__p_1);
    if preflag != 0 {
        pSetPiece_0 = LoadFileInMem(
            b"Levels\\L4Data\\diab4b.DUN\0" as *const u8 as *const libc::c_char,
            0 as *mut uint32_t,
        );
    } else {
        pSetPiece_0 = LoadFileInMem(
            b"Levels\\L4Data\\diab4a.DUN\0" as *const u8 as *const libc::c_char,
            0 as *mut uint32_t,
        );
    }
    diabquad4x = 39 as libc::c_int - 9 as libc::c_int - l4holdx
        - (DIABSIZE as libc::c_int - 9 as libc::c_int >> 1 as libc::c_int);
    diabquad4y = 39 as libc::c_int - 9 as libc::c_int - l4holdy
        - (DIABSIZE as libc::c_int - 9 as libc::c_int >> 1 as libc::c_int);
    DRLG_L4SetRoom(pSetPiece_0, diabquad4x, diabquad4y);
    let mut p__p_2: *mut libc::c_void = pSetPiece_0 as *mut libc::c_void;
    pSetPiece_0 = 0 as *mut uint8_t;
    mem_free_dbg(p__p_2);
}
unsafe extern "C" fn DRLG_L4PlaceMiniSet(
    mut miniset: *const uint8_t,
    mut tmin: libc::c_int,
    mut tmax: libc::c_int,
    mut cx: libc::c_int,
    mut cy: libc::c_int,
    mut setview: libc::c_int,
    mut ldir: libc::c_int,
) -> bool32_t {
    let mut sx: libc::c_int = 0;
    let mut sy: libc::c_int = 0;
    let mut sw: libc::c_int = 0;
    let mut sh: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut ii: libc::c_int = 0;
    let mut numt: libc::c_int = 0;
    let mut found: libc::c_int = 0;
    let mut bailcnt: libc::c_int = 0;
    sw = *miniset.offset(0 as libc::c_int as isize) as libc::c_int;
    sh = *miniset.offset(1 as libc::c_int as isize) as libc::c_int;
    if tmax - tmin == 0 as libc::c_int {
        numt = 1 as libc::c_int;
    } else {
        numt = random_(
            b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
            1517 as libc::c_int,
            0 as libc::c_int as uint8_t,
            tmax - tmin,
        ) + tmin;
    }
    i = 0 as libc::c_int;
    while i < numt {
        sx = random_(
            b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
            1522 as libc::c_int,
            0 as libc::c_int as uint8_t,
            MDMAXX as libc::c_int - sw,
        );
        sy = random_(
            b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
            1523 as libc::c_int,
            0 as libc::c_int as uint8_t,
            MDMAXY as libc::c_int - sh,
        );
        found = 0 as libc::c_int;
        bailcnt = 0 as libc::c_int;
        while found == 0 as libc::c_int && bailcnt < 200 as libc::c_int {
            found = 1 as libc::c_int;
            if sx >= SP4x1 && sx <= SP4x2 && (sy >= SP4y1 && sy <= SP4y2) {
                found = 0 as libc::c_int;
            }
            if cx != -(1 as libc::c_int) && sx >= cx - sw && sx <= cx + 12 as libc::c_int
            {
                sx = random_(
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    1536 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    MDMAXX as libc::c_int - sw,
                );
                sy = random_(
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    1537 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    MDMAXY as libc::c_int - sh,
                );
                found = 0 as libc::c_int;
            }
            if cy != -(1 as libc::c_int) && sy >= cy - sh && sy <= cy + 12 as libc::c_int
            {
                sx = random_(
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    1541 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    MDMAXX as libc::c_int - sw,
                );
                sy = random_(
                    b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
                    1542 as libc::c_int,
                    0 as libc::c_int as uint8_t,
                    MDMAXY as libc::c_int - sh,
                );
                found = 0 as libc::c_int;
            }
            ii = 2 as libc::c_int;
            yy = 0 as libc::c_int;
            while yy < sh && found == 1 as libc::c_int {
                xx = 0 as libc::c_int;
                while xx < sw && found == 1 as libc::c_int {
                    if *miniset.offset(ii as isize) as libc::c_int != 0 as libc::c_int
                        && dungeon[(sx + xx) as usize][(sy + yy) as usize] as libc::c_int
                            != *miniset.offset(ii as isize) as libc::c_int
                    {
                        found = 0 as libc::c_int;
                    }
                    if dflags[(sx + xx) as usize][(sy + yy) as usize] as libc::c_int
                        != 0 as libc::c_int
                    {
                        found = 0 as libc::c_int;
                    }
                    ii += 1;
                    ii;
                    xx += 1;
                    xx;
                }
                yy += 1;
                yy;
            }
            if found == 0 as libc::c_int {
                sx += 1;
                sx;
                if sx == MDMAXX as libc::c_int - sw {
                    sx = 0 as libc::c_int;
                    sy += 1;
                    sy;
                    if sy == MDMAXY as libc::c_int - sh {
                        sy = 0 as libc::c_int;
                    }
                }
            }
            bailcnt += 1;
            bailcnt;
        }
        if bailcnt >= 200 as libc::c_int {
            return 0 as libc::c_int as bool32_t;
        }
        ii = sh * sw + 2 as libc::c_int;
        yy = 0 as libc::c_int;
        while yy < sh {
            xx = 0 as libc::c_int;
            while xx < sw {
                if *miniset.offset(ii as isize) as libc::c_int != 0 as libc::c_int {
                    dungeon[(sx + xx)
                        as usize][(sy + yy) as usize] = *miniset.offset(ii as isize);
                    dflags[(sx + xx)
                        as usize][(sy + yy)
                        as usize] = (dflags[(sx + xx) as usize][(sy + yy) as usize]
                        as libc::c_int | BFLAG_SETPC as libc::c_int) as uint8_t;
                }
                ii += 1;
                ii;
                xx += 1;
                xx;
            }
            yy += 1;
            yy;
        }
        i += 1;
        i;
    }
    if currlevel as libc::c_int == 15 as libc::c_int {
        quests[Q_BETRAYER as libc::c_int as usize]._qtx = sx + 1 as libc::c_int;
        quests[Q_BETRAYER as libc::c_int as usize]._qty = sy + 1 as libc::c_int;
    }
    if setview == 1 as libc::c_int {
        ViewX = (sx << 1 as libc::c_int) + 3 as libc::c_int + DIRTEDGED2 as libc::c_int
            + 2 as libc::c_int;
        ViewY = (sy << 1 as libc::c_int) + 4 as libc::c_int + DIRTEDGED2 as libc::c_int
            + 2 as libc::c_int;
    }
    if ldir == LVL_DOWN as libc::c_int {
        LvlViewX = (sx << 1 as libc::c_int) + 3 as libc::c_int
            + DIRTEDGED2 as libc::c_int + 2 as libc::c_int;
        LvlViewY = (sy << 1 as libc::c_int) + 4 as libc::c_int
            + DIRTEDGED2 as libc::c_int + 2 as libc::c_int;
    }
    return 1 as libc::c_int as bool32_t;
}
unsafe extern "C" fn DRLG_L4FTVR(
    mut i: libc::c_int,
    mut j: libc::c_int,
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut d: libc::c_int,
) {
    if dTransVal[x as usize][y as usize] as libc::c_int == 0 as libc::c_int
        && dungeon[i as usize][j as usize] as libc::c_int == FLOOR_PIC as libc::c_int
    {
        dTransVal[x as usize][y as usize] = TransVal;
        dTransVal[(x + 1 as libc::c_int) as usize][y as usize] = TransVal;
        dTransVal[x as usize][(y + 1 as libc::c_int) as usize] = TransVal;
        dTransVal[(x + 1 as libc::c_int)
            as usize][(y + 1 as libc::c_int) as usize] = TransVal;
        DRLG_L4FTVR(i + 1 as libc::c_int, j, x + 2 as libc::c_int, y, 1 as libc::c_int);
        DRLG_L4FTVR(i - 1 as libc::c_int, j, x - 2 as libc::c_int, y, 2 as libc::c_int);
        DRLG_L4FTVR(i, j + 1 as libc::c_int, x, y + 2 as libc::c_int, 3 as libc::c_int);
        DRLG_L4FTVR(i, j - 1 as libc::c_int, x, y - 2 as libc::c_int, 4 as libc::c_int);
        DRLG_L4FTVR(
            i - 1 as libc::c_int,
            j - 1 as libc::c_int,
            x - 2 as libc::c_int,
            y - 2 as libc::c_int,
            5 as libc::c_int,
        );
        DRLG_L4FTVR(
            i + 1 as libc::c_int,
            j - 1 as libc::c_int,
            x + 2 as libc::c_int,
            y - 2 as libc::c_int,
            6 as libc::c_int,
        );
        DRLG_L4FTVR(
            i - 1 as libc::c_int,
            j + 1 as libc::c_int,
            x - 2 as libc::c_int,
            y + 2 as libc::c_int,
            7 as libc::c_int,
        );
        DRLG_L4FTVR(
            i + 1 as libc::c_int,
            j + 1 as libc::c_int,
            x + 2 as libc::c_int,
            y + 2 as libc::c_int,
            8 as libc::c_int,
        );
    } else {
        if d == 1 as libc::c_int {
            dTransVal[x as usize][y as usize] = TransVal;
            dTransVal[x as usize][(y + 1 as libc::c_int) as usize] = TransVal;
        }
        if d == 2 as libc::c_int {
            dTransVal[(x + 1 as libc::c_int) as usize][y as usize] = TransVal;
            dTransVal[(x + 1 as libc::c_int)
                as usize][(y + 1 as libc::c_int) as usize] = TransVal;
        }
        if d == 3 as libc::c_int {
            dTransVal[x as usize][y as usize] = TransVal;
            dTransVal[(x + 1 as libc::c_int) as usize][y as usize] = TransVal;
        }
        if d == 4 as libc::c_int {
            dTransVal[x as usize][(y + 1 as libc::c_int) as usize] = TransVal;
            dTransVal[(x + 1 as libc::c_int)
                as usize][(y + 1 as libc::c_int) as usize] = TransVal;
        }
        if d == 5 as libc::c_int {
            dTransVal[(x + 1 as libc::c_int)
                as usize][(y + 1 as libc::c_int) as usize] = TransVal;
        }
        if d == 6 as libc::c_int {
            dTransVal[x as usize][(y + 1 as libc::c_int) as usize] = TransVal;
        }
        if d == 7 as libc::c_int {
            dTransVal[(x + 1 as libc::c_int) as usize][y as usize] = TransVal;
        }
        if d == 8 as libc::c_int {
            dTransVal[x as usize][y as usize] = TransVal;
        }
    };
}
unsafe extern "C" fn DRLG_L4FloodTVal() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    yy = DIRTEDGED2 as libc::c_int;
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        xx = DIRTEDGED2 as libc::c_int;
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == FLOOR_PIC as libc::c_int
                && dTransVal[xx as usize][yy as usize] as libc::c_int == 0 as libc::c_int
            {
                DRLG_L4FTVR(i, j, xx, yy, 0 as libc::c_int);
                TransVal += 1;
                TransVal;
            }
            xx += 2 as libc::c_int;
            i += 1;
            i;
        }
        yy += 2 as libc::c_int;
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn IsDURWall(mut d: int8_t) -> bool32_t {
    if d as libc::c_int == DURWALL_PIC as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    if d as libc::c_int == DURWALL2_PIC as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    if d as libc::c_int == DURWALL3_PIC as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn IsDLLWall(mut dd: int8_t) -> bool32_t {
    if dd as libc::c_int == DLLWALL_PIC as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    if dd as libc::c_int == DLLWALL2_PIC as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    if dd as libc::c_int == DLLWALL3_PIC as libc::c_int {
        return 1 as libc::c_int as bool32_t;
    }
    return 0 as libc::c_int as bool32_t;
}
unsafe extern "C" fn DRLG_L4TransFix() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    yy = DIRTEDGED2 as libc::c_int;
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        xx = DIRTEDGED2 as libc::c_int;
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            if IsDURWall(dungeon[i as usize][j as usize] as int8_t) != 0
                && dungeon[i as usize][(j - 1 as libc::c_int) as usize] as libc::c_int
                    == DVWALL_PIC as libc::c_int
            {
                dTransVal[(xx + 1 as libc::c_int)
                    as usize][yy as usize] = dTransVal[xx as usize][yy as usize];
                dTransVal[(xx + 1 as libc::c_int)
                    as usize][(yy + 1 as libc::c_int)
                    as usize] = dTransVal[xx as usize][yy as usize];
            }
            if IsDLLWall(dungeon[i as usize][j as usize] as int8_t) != 0
                && dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == DHWALL_PIC as libc::c_int
            {
                dTransVal[xx
                    as usize][(yy + 1 as libc::c_int)
                    as usize] = dTransVal[xx as usize][yy as usize];
                dTransVal[(xx + 1 as libc::c_int)
                    as usize][(yy + 1 as libc::c_int)
                    as usize] = dTransVal[xx as usize][yy as usize];
            }
            if dungeon[i as usize][j as usize] as libc::c_int
                == DVWALL_PIC as libc::c_int
            {
                dTransVal[(xx + 1 as libc::c_int)
                    as usize][yy as usize] = dTransVal[xx as usize][yy as usize];
                dTransVal[(xx + 1 as libc::c_int)
                    as usize][(yy + 1 as libc::c_int)
                    as usize] = dTransVal[xx as usize][yy as usize];
            }
            if dungeon[i as usize][j as usize] as libc::c_int
                == DHWALL_PIC as libc::c_int
            {
                dTransVal[xx
                    as usize][(yy + 1 as libc::c_int)
                    as usize] = dTransVal[xx as usize][yy as usize];
                dTransVal[(xx + 1 as libc::c_int)
                    as usize][(yy + 1 as libc::c_int)
                    as usize] = dTransVal[xx as usize][yy as usize];
            }
            if dungeon[i as usize][j as usize] as libc::c_int
                == DLRWALL_PIC as libc::c_int
            {
                dTransVal[(xx + 1 as libc::c_int)
                    as usize][yy as usize] = dTransVal[xx as usize][yy as usize];
                dTransVal[xx
                    as usize][(yy + 1 as libc::c_int)
                    as usize] = dTransVal[xx as usize][yy as usize];
                dTransVal[(xx + 1 as libc::c_int)
                    as usize][(yy + 1 as libc::c_int)
                    as usize] = dTransVal[xx as usize][yy as usize];
            }
            if dungeon[i as usize][j as usize] as libc::c_int
                == XARCHWALL_PIC as libc::c_int
            {
                dTransVal[(xx - 1 as libc::c_int)
                    as usize][yy
                    as usize] = dTransVal[xx as usize][(yy + 1 as libc::c_int) as usize];
                dTransVal[xx
                    as usize][yy
                    as usize] = dTransVal[xx as usize][(yy + 1 as libc::c_int) as usize];
            }
            if dungeon[i as usize][j as usize] as libc::c_int
                == YARCHWALL_PIC as libc::c_int
            {
                dTransVal[xx
                    as usize][(yy - 1 as libc::c_int)
                    as usize] = dTransVal[(xx + 1 as libc::c_int) as usize][yy as usize];
                dTransVal[xx
                    as usize][yy
                    as usize] = dTransVal[(xx + 1 as libc::c_int) as usize][yy as usize];
            }
            xx += 2 as libc::c_int;
            i += 1;
            i;
        }
        yy += 2 as libc::c_int;
        j += 1;
        j;
    }
}
unsafe extern "C" fn DRLG_L4Corners() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = 1 as libc::c_int;
    while j < MDMAXY as libc::c_int - 1 as libc::c_int {
        i = 1 as libc::c_int;
        while i < MDMAXX as libc::c_int - 1 as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int >= 18 as libc::c_int
                && dungeon[i as usize][j as usize] as libc::c_int <= 30 as libc::c_int
            {
                if (dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int)
                    < 18 as libc::c_int
                {
                    dungeon[i
                        as usize][j
                        as usize] = (dungeon[i as usize][j as usize] as libc::c_int
                        + 98 as libc::c_int) as uint8_t;
                } else if (dungeon[i as usize][(j + 1 as libc::c_int) as usize]
                    as libc::c_int) < 18 as libc::c_int
                {
                    dungeon[i
                        as usize][j
                        as usize] = (dungeon[i as usize][j as usize] as libc::c_int
                        + 98 as libc::c_int) as uint8_t;
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn L4FixRim() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < 20 as libc::c_int {
        dung[i as usize][0 as libc::c_int as usize] = 0 as libc::c_int as uint8_t;
        i += 1;
        i;
    }
    let mut j: libc::c_int = 0 as libc::c_int;
    while j < 20 as libc::c_int {
        dung[0 as libc::c_int as usize][j as usize] = 0 as libc::c_int as uint8_t;
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DRLG_L4GeneralFix() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int - 1 as libc::c_int {
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int - 1 as libc::c_int {
            if dungeon[i as usize][j as usize] as libc::c_int == 24 as libc::c_int
                || dungeon[i as usize][j as usize] as libc::c_int == 122 as libc::c_int
            {
                if dungeon[(i + 1 as libc::c_int) as usize][j as usize] as libc::c_int
                    == 2 as libc::c_int
                    && dungeon[i as usize][(j + 1 as libc::c_int) as usize]
                        as libc::c_int == 5 as libc::c_int
                {
                    dungeon[i as usize][j as usize] = 17 as libc::c_int as uint8_t;
                }
            }
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
unsafe extern "C" fn DRLG_L4(mut entry: libc::c_int) {
    let mut area: int32_t = 0;
    let mut doneflag: bool32_t = 0;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut spi: libc::c_int = 0;
    let mut spj: libc::c_int = 0;
    doneflag = 0 as libc::c_int as bool32_t;
    while doneflag == 0 {
        DRLG_InitTrans();
        loop {
            InitL4Dungeon();
            L4firstRoom();
            L4FixRim();
            area = GetArea();
            if area >= L4MIN_AREA as libc::c_int {
                uShape();
            }
            if !(area < L4MIN_AREA as libc::c_int) {
                break;
            }
        }
        L4makeDungeon();
        L4makeDmt();
        L4tileFix();
        if currlevel as libc::c_int == 16 as libc::c_int {
            L4SaveQuads();
        }
        if QuestStatus(Q_WARLORD as libc::c_int) != 0
            || currlevel as libc::c_int
                == quests[Q_BETRAYER as libc::c_int as usize]._qlevel as libc::c_int
                && gbMaxPlayers as libc::c_int != 1 as libc::c_int
        {
            spi = SP4x1;
            while spi < SP4x2 {
                spj = SP4y1;
                while spj < SP4y2 {
                    dflags[spi as usize][spj as usize] = 1 as libc::c_int as uint8_t;
                    spj += 1;
                    spj;
                }
                spi += 1;
                spi;
            }
        }
        L4AddWall();
        DRLG_L4FloodTVal();
        DRLG_L4TransFix();
        if setloadflag != 0 {
            DRLG_L4SetSPRoom(SP4x1, SP4y1);
        }
        if currlevel as libc::c_int == 16 as libc::c_int {
            DRLG_LoadDiabQuads(1 as libc::c_int as bool32_t);
        }
        if QuestStatus(Q_WARLORD as libc::c_int) != 0 {
            if entry == LVL_DOWN as libc::c_int {
                doneflag = DRLG_L4PlaceMiniSet(
                    L4USTAIRS.as_ptr(),
                    1 as libc::c_int,
                    1 as libc::c_int,
                    -(1 as libc::c_int),
                    -(1 as libc::c_int),
                    1 as libc::c_int,
                    LVL_DOWN as libc::c_int,
                );
                if doneflag != 0 && currlevel as libc::c_int == 13 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4TWARP.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        LVL_TWARPDN as libc::c_int,
                    );
                }
                ViewX += 1;
                ViewX;
            } else if entry == LVL_UP as libc::c_int {
                doneflag = DRLG_L4PlaceMiniSet(
                    L4USTAIRS.as_ptr(),
                    1 as libc::c_int,
                    1 as libc::c_int,
                    -(1 as libc::c_int),
                    -(1 as libc::c_int),
                    0 as libc::c_int,
                    LVL_DOWN as libc::c_int,
                );
                if doneflag != 0 && currlevel as libc::c_int == 13 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4TWARP.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        LVL_TWARPDN as libc::c_int,
                    );
                }
                ViewX = (setpc_x << 1 as libc::c_int) + 6 as libc::c_int
                    + DIRTEDGED2 as libc::c_int;
                ViewY = (setpc_y << 1 as libc::c_int) + 6 as libc::c_int
                    + DIRTEDGED2 as libc::c_int;
            } else {
                doneflag = DRLG_L4PlaceMiniSet(
                    L4USTAIRS.as_ptr(),
                    1 as libc::c_int,
                    1 as libc::c_int,
                    -(1 as libc::c_int),
                    -(1 as libc::c_int),
                    0 as libc::c_int,
                    LVL_DOWN as libc::c_int,
                );
                if doneflag != 0 && currlevel as libc::c_int == 13 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4TWARP.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        1 as libc::c_int,
                        LVL_TWARPDN as libc::c_int,
                    );
                }
                ViewX += 1;
                ViewX;
            }
        } else if currlevel as libc::c_int != 15 as libc::c_int {
            if entry == LVL_DOWN as libc::c_int {
                doneflag = DRLG_L4PlaceMiniSet(
                    L4USTAIRS.as_ptr(),
                    1 as libc::c_int,
                    1 as libc::c_int,
                    -(1 as libc::c_int),
                    -(1 as libc::c_int),
                    1 as libc::c_int,
                    LVL_DOWN as libc::c_int,
                );
                if doneflag != 0 && currlevel as libc::c_int != 16 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4DSTAIRS.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        LVL_UP as libc::c_int,
                    );
                }
                if doneflag != 0 && currlevel as libc::c_int == 13 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4TWARP.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        LVL_TWARPDN as libc::c_int,
                    );
                }
                ViewX += 1;
                ViewX;
            } else if entry == LVL_UP as libc::c_int {
                doneflag = DRLG_L4PlaceMiniSet(
                    L4USTAIRS.as_ptr(),
                    1 as libc::c_int,
                    1 as libc::c_int,
                    -(1 as libc::c_int),
                    -(1 as libc::c_int),
                    0 as libc::c_int,
                    LVL_DOWN as libc::c_int,
                );
                if doneflag != 0 && currlevel as libc::c_int != 16 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4DSTAIRS.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        1 as libc::c_int,
                        LVL_UP as libc::c_int,
                    );
                }
                if doneflag != 0 && currlevel as libc::c_int == 13 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4TWARP.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        LVL_TWARPDN as libc::c_int,
                    );
                }
                ViewY += 1;
                ViewY;
            } else {
                doneflag = DRLG_L4PlaceMiniSet(
                    L4USTAIRS.as_ptr(),
                    1 as libc::c_int,
                    1 as libc::c_int,
                    -(1 as libc::c_int),
                    -(1 as libc::c_int),
                    0 as libc::c_int,
                    LVL_DOWN as libc::c_int,
                );
                if doneflag != 0 && currlevel as libc::c_int != 16 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4DSTAIRS.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        LVL_UP as libc::c_int,
                    );
                }
                if doneflag != 0 && currlevel as libc::c_int == 13 as libc::c_int {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4TWARP.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        1 as libc::c_int,
                        LVL_TWARPDN as libc::c_int,
                    );
                }
                ViewX += 1;
                ViewX;
            }
        } else if entry == LVL_DOWN as libc::c_int {
            doneflag = DRLG_L4PlaceMiniSet(
                L4USTAIRS.as_ptr(),
                1 as libc::c_int,
                1 as libc::c_int,
                -(1 as libc::c_int),
                -(1 as libc::c_int),
                1 as libc::c_int,
                LVL_DOWN as libc::c_int,
            );
            if doneflag != 0 {
                if gbMaxPlayers as libc::c_int != 1 as libc::c_int
                    || quests[Q_DIABLO as libc::c_int as usize]._qactive as libc::c_int
                        == QUEST_NOTDONE as libc::c_int
                {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4PENTA2.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        LVL_UP as libc::c_int,
                    );
                } else {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4PENTA.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        0 as libc::c_int,
                        LVL_UP as libc::c_int,
                    );
                }
            }
            ViewX += 1;
            ViewX;
        } else {
            doneflag = DRLG_L4PlaceMiniSet(
                L4USTAIRS.as_ptr(),
                1 as libc::c_int,
                1 as libc::c_int,
                -(1 as libc::c_int),
                -(1 as libc::c_int),
                0 as libc::c_int,
                LVL_DOWN as libc::c_int,
            );
            if doneflag != 0 {
                if gbMaxPlayers as libc::c_int != 1 as libc::c_int
                    || quests[Q_DIABLO as libc::c_int as usize]._qactive as libc::c_int
                        == QUEST_NOTDONE as libc::c_int
                {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4PENTA2.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        1 as libc::c_int,
                        LVL_UP as libc::c_int,
                    );
                } else {
                    doneflag = DRLG_L4PlaceMiniSet(
                        L4PENTA.as_ptr(),
                        1 as libc::c_int,
                        1 as libc::c_int,
                        -(1 as libc::c_int),
                        -(1 as libc::c_int),
                        1 as libc::c_int,
                        LVL_UP as libc::c_int,
                    );
                }
            }
            ViewY += 1;
            ViewY;
        }
    }
    DRLG_L4GeneralFix();
    if currlevel as libc::c_int != 16 as libc::c_int {
        DRLG_PlaceThemeRooms(
            7 as libc::c_int,
            10 as libc::c_int,
            FLOOR_PIC as libc::c_int,
            8 as libc::c_int,
            1 as libc::c_int as bool32_t,
        );
    }
    DRLG_L4Shadows();
    DRLG_L4Corners();
    DRLG_L4Subs();
    DRLG_Init_Globals();
    if QuestStatus(Q_WARLORD as libc::c_int) != 0 {
        j = 0 as libc::c_int;
        while j < MDMAXY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MDMAXX as libc::c_int {
                pdungeon[i as usize][j as usize] = dungeon[i as usize][j as usize];
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    }
    DRLG_CheckQuests(SP4x1, SP4y1);
    if currlevel as libc::c_int == 15 as libc::c_int {
        j = 0 as libc::c_int;
        while j < MDMAXY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MDMAXX as libc::c_int {
                if dungeon[i as usize][j as usize] as libc::c_int == 98 as libc::c_int {
                    Make_SetPC(
                        i - 1 as libc::c_int,
                        j - 1 as libc::c_int,
                        5 as libc::c_int,
                        5 as libc::c_int,
                    );
                }
                if dungeon[i as usize][j as usize] as libc::c_int == 107 as libc::c_int {
                    Make_SetPC(
                        i - 1 as libc::c_int,
                        j - 1 as libc::c_int,
                        5 as libc::c_int,
                        5 as libc::c_int,
                    );
                }
                i += 1;
                i;
            }
            j += 1;
            j;
        }
    }
    if currlevel as libc::c_int == 16 as libc::c_int {
        j = 0 as libc::c_int;
        while j < MDMAXY as libc::c_int {
            i = 0 as libc::c_int;
            while i < MDMAXX as libc::c_int {
                pdungeon[i as usize][j as usize] = dungeon[i as usize][j as usize];
                i += 1;
                i;
            }
            j += 1;
            j;
        }
        DRLG_LoadDiabQuads(0 as libc::c_int as bool32_t);
    }
}
unsafe extern "C" fn DRLG_L4Pass3() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    let mut v1: int32_t = 0;
    let mut v2: int32_t = 0;
    let mut v3: int32_t = 0;
    let mut v4: int32_t = 0;
    let mut lv: int32_t = 0;
    lv = 30 as libc::c_int - 1 as libc::c_int;
    let mut p: *mut uint16_t = &mut *pMegaTiles
        .offset(
            (lv as libc::c_ulong)
                .wrapping_mul(
                    (::core::mem::size_of::<uint16_t>() as libc::c_ulong)
                        .wrapping_mul(4 as libc::c_int as libc::c_ulong),
                ) as isize,
        ) as *mut uint8_t as *mut uint16_t;
    v1 = *p.offset(0 as libc::c_int as isize) as libc::c_int + 1 as libc::c_int;
    v2 = *p.offset(1 as libc::c_int as isize) as libc::c_int + 1 as libc::c_int;
    v3 = *p.offset(2 as libc::c_int as isize) as libc::c_int + 1 as libc::c_int;
    v4 = *p.offset(3 as libc::c_int as isize) as libc::c_int + 1 as libc::c_int;
    yy = 0 as libc::c_int;
    while yy < DMAXY as libc::c_int {
        xx = 0 as libc::c_int;
        while xx < DMAXX as libc::c_int {
            dPiece[xx as usize][yy as usize] = v1;
            dPiece[(xx + 1 as libc::c_int) as usize][yy as usize] = v2;
            dPiece[xx as usize][(yy + 1 as libc::c_int) as usize] = v3;
            dPiece[(xx + 1 as libc::c_int)
                as usize][(yy + 1 as libc::c_int) as usize] = v4;
            xx += 2 as libc::c_int;
        }
        yy += 2 as libc::c_int;
    }
    yy = DIRTEDGED2 as libc::c_int;
    j = 0 as libc::c_int;
    while j < MDMAXY as libc::c_int {
        xx = DIRTEDGED2 as libc::c_int;
        i = 0 as libc::c_int;
        while i < MDMAXX as libc::c_int {
            lv = dungeon[i as usize][j as usize] as int32_t - 1 as libc::c_int;
            if lv >= 0 as libc::c_int {
                let mut p_0: *mut uint16_t = &mut *pMegaTiles
                    .offset(
                        (lv as libc::c_ulong)
                            .wrapping_mul(
                                (::core::mem::size_of::<uint16_t>() as libc::c_ulong)
                                    .wrapping_mul(4 as libc::c_int as libc::c_ulong),
                            ) as isize,
                    ) as *mut uint8_t as *mut uint16_t;
                v1 = *p_0.offset(0 as libc::c_int as isize) as libc::c_int
                    + 1 as libc::c_int;
                v2 = *p_0.offset(1 as libc::c_int as isize) as libc::c_int
                    + 1 as libc::c_int;
                v3 = *p_0.offset(2 as libc::c_int as isize) as libc::c_int
                    + 1 as libc::c_int;
                v4 = *p_0.offset(3 as libc::c_int as isize) as libc::c_int
                    + 1 as libc::c_int;
            } else {
                v1 = 0 as libc::c_int;
                v2 = 0 as libc::c_int;
                v3 = 0 as libc::c_int;
                v4 = 0 as libc::c_int;
            }
            dPiece[xx as usize][yy as usize] = v1;
            dPiece[(xx + 1 as libc::c_int) as usize][yy as usize] = v2;
            dPiece[xx as usize][(yy + 1 as libc::c_int) as usize] = v3;
            dPiece[(xx + 1 as libc::c_int)
                as usize][(yy + 1 as libc::c_int) as usize] = v4;
            xx += 2 as libc::c_int;
            i += 1;
            i;
        }
        yy += 2 as libc::c_int;
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn CreateL4Dungeon(
    mut rseed: libc::c_uint,
    mut entry: libc::c_int,
) {
    SetRndSeed(
        b"src/drlg_l4.c\0" as *const u8 as *const libc::c_char,
        2013 as libc::c_int,
        rseed as int32_t,
    );
    dminx = DIRTEDGED2 as libc::c_int;
    dminy = DIRTEDGED2 as libc::c_int;
    dmaxx = DMAXX as libc::c_int - DIRTEDGED2 as libc::c_int;
    dmaxy = DMAXY as libc::c_int - DIRTEDGED2 as libc::c_int;
    ViewX = 40 as libc::c_int;
    ViewY = 40 as libc::c_int;
    DRLG_InitSetPC();
    DRLG_LoadL4SP();
    DRLG_L4(entry);
    DRLG_L4Pass3();
    DRLG_FreeL4SP();
    DRLG_SetPC();
}
