use ::libc;
extern "C" {
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn strcpy(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn DrawCel(
        xp: int32_t,
        yp: int32_t,
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        nCelW: int32_t,
    );
    fn PlayInGameMovie(pszMovie: *const libc::c_char);
    fn DiabloAllocPtr(dwBytes: uint32_t) -> *mut uint8_t;
    fn LoadFileWithMem(pszName: *const libc::c_char, pbMem: *mut uint8_t) -> uint32_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    static mut tempstr: [libc::c_char; 256];
    static mut drawmapofdoom: bool32_t;
    static mut doomtime: libc::c_int;
}
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type C2RustUnnamed = libc::c_uint;
pub const DOOM_ANIMSPD: C2RustUnnamed = 5;
pub const DOOM_TOTAL: C2RustUnnamed = 36001;
pub const DOOM_TICK: C2RustUnnamed = 1200;
pub const DOOM_ENDFRAME: C2RustUnnamed = 31;
pub const DOOM_NUMFRAMES: C2RustUnnamed = 30;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
static mut pDoomCel: *mut uint8_t = 0 as *const uint8_t as *mut uint8_t;
static mut currdoom: libc::c_int = 0;
static mut animdoomdelay: libc::c_int = 0;
#[no_mangle]
pub unsafe extern "C" fn InitMapOfDoomTime() {
    if doomtime > 0 as libc::c_int {
        return;
    }
    doomtime = 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn DoMapOfDoomTime() {
    if doomtime < DOOM_TOTAL as libc::c_int {
        doomtime += 1;
        doomtime;
        if doomtime == DOOM_TOTAL as libc::c_int {
            PlayInGameMovie(b"gendata\\doom.smk\0" as *const u8 as *const libc::c_char);
            doomtime += 1;
            doomtime;
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn CheckMapOfDoomTime() -> libc::c_int {
    if doomtime == DOOM_TOTAL as libc::c_int {
        return DOOM_ENDFRAME as libc::c_int;
    }
    return doomtime / DOOM_TICK as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn GetDoomMem() {
    pDoomCel = DiabloAllocPtr(
        ((223 as libc::c_int + 1 as libc::c_int) * 1024 as libc::c_int) as uint32_t,
    );
}
#[no_mangle]
pub unsafe extern "C" fn FreeDoomMem() {
    let mut p__p: *mut libc::c_void = pDoomCel as *mut libc::c_void;
    pDoomCel = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
}
#[no_mangle]
pub unsafe extern "C" fn LoadDoomFrame() {
    if currdoom == DOOM_ENDFRAME as libc::c_int {
        strcpy(
            tempstr.as_mut_ptr(),
            b"Items\\Map\\MapZDoom.CEL\0" as *const u8 as *const libc::c_char,
        );
    } else if currdoom < 10 as libc::c_int {
        sprintf(
            tempstr.as_mut_ptr(),
            b"Items\\Map\\MapZ000%d.CEL\0" as *const u8 as *const libc::c_char,
            currdoom,
        );
    } else {
        sprintf(
            tempstr.as_mut_ptr(),
            b"Items\\Map\\MapZ00%d.CEL\0" as *const u8 as *const libc::c_char,
            currdoom,
        );
    }
    LoadFileWithMem(tempstr.as_mut_ptr(), pDoomCel);
}
#[no_mangle]
pub unsafe extern "C" fn InitMapOfDoomView() {
    drawmapofdoom = 1 as libc::c_int as bool32_t;
    GetDoomMem();
    if CheckMapOfDoomTime() == DOOM_ENDFRAME as libc::c_int {
        currdoom = DOOM_ENDFRAME as libc::c_int;
    } else {
        currdoom = 0 as libc::c_int;
    }
    LoadDoomFrame();
}
#[no_mangle]
pub unsafe extern "C" fn EndMapOfDoomView() {
    if drawmapofdoom == 0 {
        return;
    }
    drawmapofdoom = 0 as libc::c_int as bool32_t;
    FreeDoomMem();
}
#[no_mangle]
pub unsafe extern "C" fn DrawMapOfDoom() {
    if drawmapofdoom == 0 {
        return;
    }
    if currdoom != DOOM_ENDFRAME as libc::c_int {
        animdoomdelay += 1;
        animdoomdelay;
        if animdoomdelay >= DOOM_ANIMSPD as libc::c_int {
            animdoomdelay = 0 as libc::c_int;
            currdoom += 1;
            currdoom;
            if currdoom > CheckMapOfDoomTime() {
                currdoom = 0 as libc::c_int;
            }
            LoadDoomFrame();
        }
    }
    DrawCel(
        64 as libc::c_int,
        511 as libc::c_int,
        pDoomCel,
        1 as libc::c_int,
        640 as libc::c_int,
    );
}
