use ::libc;
extern "C" {
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn ChangeLightXY(_: libc::c_int, _: libc::c_int, _: libc::c_int);
    static mut dead: [DeadStruct; 31];
    static mut spurtndx: libc::c_int;
    static mut stonendx: libc::c_int;
    static mut dDead: [[int8_t; 112]; 112];
    static mut misfiledata: [MisFileData; 47];
    static mut monster: [MonsterStruct; 200];
    static mut nummonsters: int32_t;
    static mut monstactive: [libc::c_int; 200];
    static mut nummtypes: libc::c_int;
    static mut Monsters: [CMonster; 16];
}
pub type C2RustUnnamed = libc::c_uint;
pub const LIGHT_U: C2RustUnnamed = 4;
pub const LIGHT_GREY: C2RustUnnamed = 3;
pub const LIGHT_STONE: C2RustUnnamed = 2;
pub const LIGHT_INFRA: C2RustUnnamed = 1;
pub const LIGHT_NORM: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const MF_STARTLOAD: C2RustUnnamed_0 = 0;
pub const MF_NONE: C2RustUnnamed_0 = 46;
pub const MF_DFLAREXP: C2RustUnnamed_0 = 45;
pub const MF_DFLARE: C2RustUnnamed_0 = 44;
pub const MF_CFLAREXP: C2RustUnnamed_0 = 43;
pub const MF_CFLARE: C2RustUnnamed_0 = 42;
pub const MF_BFLAREXP: C2RustUnnamed_0 = 41;
pub const MF_BFLARE: C2RustUnnamed_0 = 40;
pub const MF_FIREPLAR: C2RustUnnamed_0 = 39;
pub const MF_RPORTAL: C2RustUnnamed_0 = 38;
pub const MF_BONESPIRIT: C2RustUnnamed_0 = 37;
pub const MF_RESURRECT: C2RustUnnamed_0 = 36;
pub const MF_FIRERUN: C2RustUnnamed_0 = 35;
pub const MF_ETHER: C2RustUnnamed_0 = 34;
pub const MF_ACIDPUD: C2RustUnnamed_0 = 33;
pub const MF_ACIDSPLAT: C2RustUnnamed_0 = 32;
pub const MF_ACID: C2RustUnnamed_0 = 31;
pub const MF_FAEXP: C2RustUnnamed_0 = 30;
pub const MF_LARROW: C2RustUnnamed_0 = 29;
pub const MF_HEXPL: C2RustUnnamed_0 = 28;
pub const MF_HBOLT: C2RustUnnamed_0 = 27;
pub const MF_CBOLT: C2RustUnnamed_0 = 26;
pub const MF_KRULL: C2RustUnnamed_0 = 25;
pub const MF_MAGBALL: C2RustUnnamed_0 = 24;
pub const MF_FLAREXP: C2RustUnnamed_0 = 23;
pub const MF_FLARE: C2RustUnnamed_0 = 22;
pub const MF_THINLIGHT: C2RustUnnamed_0 = 21;
pub const MF_FLAMES: C2RustUnnamed_0 = 20;
pub const MF_BIGEXP: C2RustUnnamed_0 = 19;
pub const MF_STONE: C2RustUnnamed_0 = 18;
pub const MF_BOOM: C2RustUnnamed_0 = 17;
pub const MF_SPURT: C2RustUnnamed_0 = 16;
pub const MF_GOLEM: C2RustUnnamed_0 = 15;
pub const MF_DOOM: C2RustUnnamed_0 = 14;
pub const MF_FARROW: C2RustUnnamed_0 = 13;
pub const MF_METAL: C2RustUnnamed_0 = 12;
pub const MF_BONE: C2RustUnnamed_0 = 11;
pub const MF_BLOOD: C2RustUnnamed_0 = 10;
pub const MF_MANASHLD: C2RustUnnamed_0 = 9;
pub const MF_FLASH2: C2RustUnnamed_0 = 8;
pub const MF_FLASH1: C2RustUnnamed_0 = 7;
pub const MF_TOWN: C2RustUnnamed_0 = 6;
pub const MF_EXP1: C2RustUnnamed_0 = 5;
pub const MF_FIRE: C2RustUnnamed_0 = 4;
pub const MF_LIGHTNING: C2RustUnnamed_0 = 3;
pub const MF_GUARDIAN: C2RustUnnamed_0 = 2;
pub const MF_FIREBOLT: C2RustUnnamed_0 = 1;
pub const MF_ARROW: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const MA_SPECIAL: C2RustUnnamed_1 = 5;
pub const MA_DEATH: C2RustUnnamed_1 = 4;
pub const MA_GOTHIT: C2RustUnnamed_1 = 3;
pub const MA_ATTACK: C2RustUnnamed_1 = 2;
pub const MA_WALK: C2RustUnnamed_1 = 1;
pub const MA_STAND: C2RustUnnamed_1 = 0;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const MAXDEAD: C2RustUnnamed_2 = 31;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct DeadStruct {
    pub _deadData: [*mut uint8_t; 8],
    pub _deadFrame: libc::c_int,
    pub _deadWidth: int32_t,
    pub _deadWidth2: int32_t,
    pub _deadtrans: int8_t,
}
pub type C2RustUnnamed_3 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_3 = 32;
pub const MAXMICRO: C2RustUnnamed_3 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_3 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_3 = 64;
pub const MAXMREND: C2RustUnnamed_3 = 128;
pub const MAXTILES: C2RustUnnamed_3 = 2048;
pub const MDMAXY: C2RustUnnamed_3 = 40;
pub const MDMAXX: C2RustUnnamed_3 = 40;
pub const MAXDUNY: C2RustUnnamed_3 = 112;
pub const MAXDUNX: C2RustUnnamed_3 = 112;
pub const DMAXY: C2RustUnnamed_3 = 112;
pub const DMAXX: C2RustUnnamed_3 = 112;
pub const DIRTEDGED2: C2RustUnnamed_3 = 16;
pub const DIRTEDGE: C2RustUnnamed_3 = 32;
pub const NUMSLEVELS: C2RustUnnamed_3 = 10;
pub const NUMLEVELS: C2RustUnnamed_3 = 17;
pub const LVL4_START: C2RustUnnamed_3 = 13;
pub const LVL3_START: C2RustUnnamed_3 = 9;
pub const LVL2_START: C2RustUnnamed_3 = 5;
pub const LVL1_START: C2RustUnnamed_3 = 1;
pub const TLVL_START: C2RustUnnamed_3 = 0;
pub const LVLLENGTH: C2RustUnnamed_3 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MisFileData {
    pub mAnimName: uint8_t,
    pub mAnimFAmt: uint8_t,
    pub mAnimPath: *const libc::c_char,
    pub mFlags: bool32_t,
    pub mAnimData: [*mut uint8_t; 16],
    pub mAnimDelay: [uint8_t; 16],
    pub mAnimLen: [uint8_t; 16],
    pub mAnimWidth: [int32_t; 16],
    pub mAnimWidth2: [int32_t; 16],
}
pub type C2RustUnnamed_4 = libc::c_uint;
pub const INITMONSTRAD: C2RustUnnamed_4 = 15;
pub const MAX_MS: C2RustUnnamed_4 = 4;
pub const IMG_MAX: C2RustUnnamed_4 = 4000;
pub const MAX_ANIMTYPE: C2RustUnnamed_4 = 6;
pub const MONSTDENSITY: C2RustUnnamed_4 = 30;
pub const MAX_LVLMTYPES: C2RustUnnamed_4 = 16;
pub const MONSTERTYPES: C2RustUnnamed_4 = 200;
pub const MAXMONSTERS: C2RustUnnamed_4 = 200;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterStruct {
    pub _mMTidx: libc::c_int,
    pub _mmode: libc::c_int,
    pub _mgoal: uint8_t,
    pub _mgoalvar1: libc::c_int,
    pub _mgoalvar2: libc::c_int,
    pub _mgoalvar3: libc::c_int,
    pub _mgoalvar4: libc::c_int,
    pub _pathcount: uint8_t,
    pub _mx: libc::c_int,
    pub _my: libc::c_int,
    pub _mfutx: libc::c_int,
    pub _mfuty: libc::c_int,
    pub _moldx: libc::c_int,
    pub _moldy: libc::c_int,
    pub _mxoff: int32_t,
    pub _myoff: int32_t,
    pub _mxvel: int32_t,
    pub _myvel: int32_t,
    pub _mdir: libc::c_int,
    pub _menemy: libc::c_int,
    pub _menemyx: uint8_t,
    pub _menemyy: uint8_t,
    pub _mAnimData: *mut uint8_t,
    pub _mAnimDelay: libc::c_int,
    pub _mAnimCnt: libc::c_int,
    pub _mAnimLen: libc::c_int,
    pub _mAnimFrame: libc::c_int,
    pub _meflag: libc::c_int,
    pub _mDelFlag: bool32_t,
    pub _mVar1: int32_t,
    pub _mVar2: int32_t,
    pub _mVar3: int32_t,
    pub _mVar4: int32_t,
    pub _mVar5: int32_t,
    pub _mVar6: int32_t,
    pub _mVar7: int32_t,
    pub _mVar8: int32_t,
    pub _mmaxhp: int32_t,
    pub _mhitpoints: int32_t,
    pub _mAi: uint8_t,
    pub _mint: uint8_t,
    pub _mFlags: uint32_t,
    pub _msquelch: uint8_t,
    pub _mAFNum: libc::c_int,
    pub _lastx: libc::c_int,
    pub _lasty: libc::c_int,
    pub _mRndSeed: libc::c_int,
    pub _mAISeed: libc::c_int,
    pub _Wandering: bool32_t,
    pub _uniqtype: uint8_t,
    pub _uniqtrans: uint8_t,
    pub _udeadval: int8_t,
    pub mWhoHit: int8_t,
    pub mLevel: int8_t,
    pub mExp: uint16_t,
    pub mHit: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMagicRes: uint16_t,
    pub mtalkmsg: libc::c_int,
    pub leader: uint8_t,
    pub leaderflag: uint8_t,
    pub packsize: uint8_t,
    pub mlid: uint8_t,
    pub mName: *const libc::c_char,
    pub MType: *mut CMonster,
    pub MData: *mut MonsterData,
}
#[no_mangle]
pub unsafe extern "C" fn InitDead() {
    let mut nd: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut mi: libc::c_int = 0;
    let mut mtypes: [libc::c_int; 200] = [0; 200];
    i = 0 as libc::c_int;
    while i < MONSTERTYPES as libc::c_int {
        mtypes[i as usize] = 0 as libc::c_int;
        i += 1;
        i;
    }
    nd = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < nummtypes {
        if mtypes[Monsters[i as usize].mtype as usize] == 0 as libc::c_int {
            j = 0 as libc::c_int;
            while j < 8 as libc::c_int {
                dead[nd as usize]
                    ._deadData[j
                    as usize] = Monsters[i as usize]
                    .Anims[MA_DEATH as libc::c_int as usize]
                    .Cels[j as usize];
                j += 1;
                j;
            }
            dead[nd as usize]
                ._deadFrame = Monsters[i as usize]
                .Anims[MA_DEATH as libc::c_int as usize]
                .Frames;
            dead[nd as usize]._deadWidth = Monsters[i as usize].mAnimWidth;
            dead[nd as usize]._deadWidth2 = Monsters[i as usize].mAnimWidth2;
            dead[nd as usize]._deadtrans = 0 as libc::c_int as int8_t;
            Monsters[i as usize].mdeadval = (nd + 1 as libc::c_int) as int8_t;
            mtypes[Monsters[i as usize].mtype as usize] = nd + 1 as libc::c_int;
            nd += 1;
            nd;
        }
        i += 1;
        i;
    }
    j = 0 as libc::c_int;
    while j < 8 as libc::c_int {
        dead[nd as usize]
            ._deadData[j
            as usize] = misfiledata[MF_SPURT as libc::c_int as usize]
            .mAnimData[0 as libc::c_int as usize];
        j += 1;
        j;
    }
    dead[nd as usize]._deadFrame = 8 as libc::c_int;
    dead[nd as usize]._deadWidth = 128 as libc::c_int;
    dead[nd as usize]
        ._deadWidth2 = 128 as libc::c_int - 64 as libc::c_int >> 1 as libc::c_int;
    dead[nd as usize]._deadtrans = 0 as libc::c_int as int8_t;
    spurtndx = nd + 1 as libc::c_int;
    nd += 1;
    nd;
    j = 0 as libc::c_int;
    while j < 8 as libc::c_int {
        dead[nd as usize]
            ._deadData[j
            as usize] = misfiledata[MF_STONE as libc::c_int as usize]
            .mAnimData[0 as libc::c_int as usize];
        j += 1;
        j;
    }
    dead[nd as usize]._deadFrame = 12 as libc::c_int;
    dead[nd as usize]._deadWidth = 128 as libc::c_int;
    dead[nd as usize]
        ._deadWidth2 = 128 as libc::c_int - 64 as libc::c_int >> 1 as libc::c_int;
    dead[nd as usize]._deadtrans = 0 as libc::c_int as int8_t;
    stonendx = nd + 1 as libc::c_int;
    nd += 1;
    nd;
    i = 0 as libc::c_int;
    while i < nummonsters {
        mi = monstactive[i as usize];
        if monster[mi as usize]._uniqtype as libc::c_int != 0 as libc::c_int {
            j = 0 as libc::c_int;
            while j < 8 as libc::c_int {
                dead[nd as usize]
                    ._deadData[j
                    as usize] = (*monster[mi as usize].MType)
                    .Anims[MA_DEATH as libc::c_int as usize]
                    .Cels[j as usize];
                j += 1;
                j;
            }
            dead[nd as usize]
                ._deadFrame = (*monster[mi as usize].MType)
                .Anims[MA_DEATH as libc::c_int as usize]
                .Frames;
            dead[nd as usize]._deadWidth = (*monster[mi as usize].MType).mAnimWidth;
            dead[nd as usize]._deadWidth2 = (*monster[mi as usize].MType).mAnimWidth2;
            dead[nd as usize]
                ._deadtrans = (LIGHT_U as libc::c_int
                + monster[mi as usize]._uniqtrans as libc::c_int) as int8_t;
            monster[mi as usize]._udeadval = (nd + 1 as libc::c_int) as int8_t;
            nd += 1;
            nd;
        }
        i += 1;
        i;
    }
    if !(nd <= MAXDEAD as libc::c_int) {
        assert_fail(
            73 as libc::c_int,
            b"src/dead.c\0" as *const u8 as *const libc::c_char,
            b"nd <= MAXDEAD\0" as *const u8 as *const libc::c_char,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn AddDead(
    mut dx: libc::c_int,
    mut dy: libc::c_int,
    mut dv: int8_t,
    mut ddir: libc::c_int,
) {
    let mut tdv: int8_t = 0;
    tdv = ((dv as libc::c_int & 0x1f as libc::c_int)
        + ((ddir & 0x7 as libc::c_int) << 5 as libc::c_int)) as int8_t;
    dDead[dx as usize][dy as usize] = tdv;
}
#[no_mangle]
pub unsafe extern "C" fn SyncUniqDead() {
    let mut i: libc::c_int = 0;
    let mut mi: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < nummonsters {
        mi = monstactive[i as usize];
        if monster[mi as usize]._uniqtype as libc::c_int != 0 as libc::c_int {
            x = 0 as libc::c_int;
            while x < DMAXX as libc::c_int {
                y = 0 as libc::c_int;
                while y < DMAXY as libc::c_int {
                    if dDead[x as usize][y as usize] as libc::c_int & 0x1f as libc::c_int
                        == monster[mi as usize]._udeadval as libc::c_int
                    {
                        ChangeLightXY(monster[mi as usize].mlid as libc::c_int, x, y);
                    }
                    y += 1;
                    y;
                }
                x += 1;
                x;
            }
        }
        i += 1;
        i;
    }
}
