use ::libc;
extern "C" {
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn strcpy(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn AddPanelString(_: *const libc::c_char, _: libc::c_int);
    fn ClearPanel();
    fn CheckPanelInfo();
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn CheckInvHLight() -> int8_t;
    fn savecrsr_reset();
    fn IsTracking() -> bool32_t;
    fn CheckTrigForce();
    static mut spselflag: bool32_t;
    static mut chrflag: bool32_t;
    static mut sbookflag: bool32_t;
    static mut panelflag: bool32_t;
    static mut infostr: [libc::c_char; 256];
    static mut tempstr: [libc::c_char; 256];
    static CursorWidth: [libc::c_int; 180];
    static CursorHeight: [libc::c_int; 180];
    static mut curs: libc::c_int;
    static mut cursW: libc::c_int;
    static mut cursH: libc::c_int;
    static mut icursW: libc::c_int;
    static mut icursH: libc::c_int;
    static mut icursW28: libc::c_int;
    static mut icursH28: libc::c_int;
    static mut cursmx: libc::c_int;
    static mut cursmy: libc::c_int;
    static mut cursmonst: libc::c_int;
    static mut cursobj: int8_t;
    static mut cursitem: int8_t;
    static mut cursinvitem: int8_t;
    static mut cursplr: int8_t;
    static mut pCursCels: *mut uint8_t;
    static mut MouseX: libc::c_int;
    static mut MouseY: libc::c_int;
    static mut svgamode: bool32_t;
    static mut drawmapofdoom: bool32_t;
    static mut leveltype: uint8_t;
    static mut setlevel: uint8_t;
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut ScrollInfo: ScrollStruct;
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dPlayer: [[int8_t; 112]; 112];
    static mut dMonster: [[libc::c_int; 112]; 112];
    static mut dObject: [[int8_t; 112]; 112];
    static mut dItem: [[int8_t; 112]; 112];
    static mut invflag: bool32_t;
    static mut drawsbarflag: bool32_t;
    static mut item: [ItemStruct; 128];
    static mut uitemflag: bool32_t;
    static mut missile: [MissileStruct; 125];
    static mut nummissiles: libc::c_int;
    static mut missileactive: [libc::c_int; 125];
    static mut monster: [MonsterStruct; 200];
    static mut object: [ObjectStruct; 127];
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut questlog: bool32_t;
    static mut towner: [TownerStruct; 16];
    static mut trigflag: bool32_t;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type C2RustUnnamed = libc::c_uint;
pub const TEXT_RIGHT: C2RustUnnamed = 2;
pub const TEXT_CENTER: C2RustUnnamed = 1;
pub const TEXT_LEFT: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const VIEW_CURSOR: C2RustUnnamed_0 = 1;
pub const ICSTART: C2RustUnnamed_0 = 12;
pub const WATCH_CURS: C2RustUnnamed_0 = 11;
pub const HEALOTHER_CURS: C2RustUnnamed_0 = 10;
pub const TARGET_CURS: C2RustUnnamed_0 = 9;
pub const RESURRECT_CURS: C2RustUnnamed_0 = 8;
pub const TELE_CURS: C2RustUnnamed_0 = 7;
pub const OIL_CURS: C2RustUnnamed_0 = 6;
pub const DISARM_CURS: C2RustUnnamed_0 = 5;
pub const RECHARGE_CURS: C2RustUnnamed_0 = 4;
pub const REPAIR_CURS: C2RustUnnamed_0 = 3;
pub const IDENTIFY_CURS: C2RustUnnamed_0 = 2;
pub const GLOVE_CURS: C2RustUnnamed_0 = 1;
pub const NO_CURSOR: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed_1 = 191;
pub const SETP_TEMP: C2RustUnnamed_1 = 64;
pub const SETP_MASK: C2RustUnnamed_1 = 127;
pub const SETP_BIT: C2RustUnnamed_1 = 128;
pub const BFMASK_MISSILE: C2RustUnnamed_1 = 254;
pub const BFMASK_SETPC: C2RustUnnamed_1 = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed_1 = 239;
pub const BFMASK_PLRLR: C2RustUnnamed_1 = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed_1 = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed_1 = 127;
pub const BFLAG_MISSILE: C2RustUnnamed_1 = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed_1 = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed_1 = 4;
pub const BFLAG_SETPC: C2RustUnnamed_1 = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed_1 = 16;
pub const BFLAG_PLRLR: C2RustUnnamed_1 = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed_1 = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed_1 = 128;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const SCRL_UL: C2RustUnnamed_2 = 8;
pub const SCRL_L: C2RustUnnamed_2 = 7;
pub const SCRL_DL: C2RustUnnamed_2 = 6;
pub const SCRL_D: C2RustUnnamed_2 = 5;
pub const SCRL_DR: C2RustUnnamed_2 = 4;
pub const SCRL_R: C2RustUnnamed_2 = 3;
pub const SCRL_UR: C2RustUnnamed_2 = 2;
pub const SCRL_U: C2RustUnnamed_2 = 1;
pub const SCRL_NONE: C2RustUnnamed_2 = 0;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const MIT_DIABAPOCA: C2RustUnnamed_3 = 67;
pub const MIT_FIREPLAR: C2RustUnnamed_3 = 66;
pub const MIT_RPORTAL: C2RustUnnamed_3 = 65;
pub const MIT_WEAPEXP: C2RustUnnamed_3 = 64;
pub const MIT_BONESPIRIT: C2RustUnnamed_3 = 63;
pub const MIT_RESURRECTBEAM: C2RustUnnamed_3 = 62;
pub const MIT_ELEMENT: C2RustUnnamed_3 = 61;
pub const MIT_HEALOTHER: C2RustUnnamed_3 = 60;
pub const MIT_ACIDPUD: C2RustUnnamed_3 = 59;
pub const MIT_ACIDSPLAT: C2RustUnnamed_3 = 58;
pub const MIT_ACID: C2RustUnnamed_3 = 57;
pub const MIT_LARROW: C2RustUnnamed_3 = 56;
pub const MIT_TELEKINESIS: C2RustUnnamed_3 = 55;
pub const MIT_RESURRECT: C2RustUnnamed_3 = 54;
pub const MIT_HBOLT: C2RustUnnamed_3 = 53;
pub const MIT_CBOLT: C2RustUnnamed_3 = 52;
pub const MIT_KRULL: C2RustUnnamed_3 = 51;
pub const MIT_FIREMAN: C2RustUnnamed_3 = 50;
pub const MIT_FLAMEC: C2RustUnnamed_3 = 49;
pub const MIT_FLAME: C2RustUnnamed_3 = 48;
pub const MIT_DISARM: C2RustUnnamed_3 = 47;
pub const MIT_RECHARGE: C2RustUnnamed_3 = 46;
pub const MIT_REPAIR: C2RustUnnamed_3 = 45;
pub const MIT_APOCA: C2RustUnnamed_3 = 44;
pub const MIT_BLDBOIL: C2RustUnnamed_3 = 43;
pub const MIT_NOVA: C2RustUnnamed_3 = 42;
pub const MIT_WAVE: C2RustUnnamed_3 = 41;
pub const MIT_IDENTIFY: C2RustUnnamed_3 = 40;
pub const MIT_INFRA: C2RustUnnamed_3 = 39;
pub const MIT_FIREWALLC: C2RustUnnamed_3 = 38;
pub const MIT_HEAL: C2RustUnnamed_3 = 37;
pub const MIT_BOOM: C2RustUnnamed_3 = 36;
pub const MIT_SPURT: C2RustUnnamed_3 = 35;
pub const MIT_ETHER: C2RustUnnamed_3 = 34;
pub const MIT_GOLEM: C2RustUnnamed_3 = 33;
pub const MIT_INVIS: C2RustUnnamed_3 = 32;
pub const MIT_BLOODR: C2RustUnnamed_3 = 31;
pub const MIT_STONE: C2RustUnnamed_3 = 30;
pub const MIT_FIREONLY: C2RustUnnamed_3 = 29;
pub const MIT_DOOM: C2RustUnnamed_3 = 28;
pub const MIT_FARROW: C2RustUnnamed_3 = 27;
pub const MIT_TELE: C2RustUnnamed_3 = 26;
pub const MIT_FLAREXP: C2RustUnnamed_3 = 25;
pub const MIT_FLARE: C2RustUnnamed_3 = 24;
pub const MIT_THINLIGHT: C2RustUnnamed_3 = 23;
pub const MIT_THINLIGHTCTRL: C2RustUnnamed_3 = 22;
pub const MIT_MAGMABALL: C2RustUnnamed_3 = 21;
pub const MIT_RHINO: C2RustUnnamed_3 = 20;
pub const MIT_METAL: C2RustUnnamed_3 = 19;
pub const MIT_BONE: C2RustUnnamed_3 = 18;
pub const MIT_BLOOD: C2RustUnnamed_3 = 17;
pub const MIT_CHAINBALL: C2RustUnnamed_3 = 16;
pub const MIT_CHAIN: C2RustUnnamed_3 = 15;
pub const MIT_FIREMOVE: C2RustUnnamed_3 = 14;
pub const MIT_MANASHIELD: C2RustUnnamed_3 = 13;
pub const MIT_FLASH2: C2RustUnnamed_3 = 12;
pub const MIT_FLASH: C2RustUnnamed_3 = 11;
pub const MIT_TOWN: C2RustUnnamed_3 = 10;
pub const MIT_MISEXP: C2RustUnnamed_3 = 9;
pub const MIT_LIGHTNING: C2RustUnnamed_3 = 8;
pub const MIT_LIGHTCTRL: C2RustUnnamed_3 = 7;
pub const MIT_FIREBALL: C2RustUnnamed_3 = 6;
pub const MIT_FIREWALL: C2RustUnnamed_3 = 5;
pub const MIT_LIGHTBALL: C2RustUnnamed_3 = 4;
pub const MIT_PHASE: C2RustUnnamed_3 = 3;
pub const MIT_GUARDIAN: C2RustUnnamed_3 = 2;
pub const MIT_FIREBOLT: C2RustUnnamed_3 = 1;
pub const MIT_ARROW: C2RustUnnamed_3 = 0;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const MFLAG_NOENEMY: C2RustUnnamed_4 = 1024;
pub const MFLAG_CHECKDOORS: C2RustUnnamed_4 = 512;
pub const MFLAG_PATH: C2RustUnnamed_4 = 256;
pub const MFLAG_KNOCKBACK: C2RustUnnamed_4 = 128;
pub const MFLAG_DROP: C2RustUnnamed_4 = 64;
pub const MFLAG_MKILLER: C2RustUnnamed_4 = 32;
pub const MFLAG_MID: C2RustUnnamed_4 = 16;
pub const MFLAG_NOHEAL: C2RustUnnamed_4 = 8;
pub const MFLAG_STILL: C2RustUnnamed_4 = 4;
pub const MFLAG_BACKWARDS: C2RustUnnamed_4 = 2;
pub const MFLAG_INVISIBLE: C2RustUnnamed_4 = 1;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const MSEL_BIG: C2RustUnnamed_5 = 7;
pub const MSEL_FLY: C2RustUnnamed_5 = 6;
pub const MSEL_TOP: C2RustUnnamed_5 = 4;
pub const MSEL_REG: C2RustUnnamed_5 = 3;
pub const MSEL_MID: C2RustUnnamed_5 = 2;
pub const MSEL_FLR: C2RustUnnamed_5 = 1;
pub const MSEL_NONE: C2RustUnnamed_5 = 0;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const OSEL_ALL: C2RustUnnamed_6 = 3;
pub const OSEL_TOP: C2RustUnnamed_6 = 2;
pub const OSEL_FLR: C2RustUnnamed_6 = 1;
pub const OSEL_NONE: C2RustUnnamed_6 = 0;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_7 = libc::c_uint;
pub const ISEL_ALL: C2RustUnnamed_7 = 3;
pub const ISEL_TOP: C2RustUnnamed_7 = 2;
pub const ISEL_FLR: C2RustUnnamed_7 = 1;
pub const ISEL_NONE: C2RustUnnamed_7 = 0;
pub type C2RustUnnamed_8 = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed_8 = 32;
pub const MAXMICRO: C2RustUnnamed_8 = 2048;
pub const SPEEDSIZE: C2RustUnnamed_8 = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed_8 = 64;
pub const MAXMREND: C2RustUnnamed_8 = 128;
pub const MAXTILES: C2RustUnnamed_8 = 2048;
pub const MDMAXY: C2RustUnnamed_8 = 40;
pub const MDMAXX: C2RustUnnamed_8 = 40;
pub const MAXDUNY: C2RustUnnamed_8 = 112;
pub const MAXDUNX: C2RustUnnamed_8 = 112;
pub const DMAXY: C2RustUnnamed_8 = 112;
pub const DMAXX: C2RustUnnamed_8 = 112;
pub const DIRTEDGED2: C2RustUnnamed_8 = 16;
pub const DIRTEDGE: C2RustUnnamed_8 = 32;
pub const NUMSLEVELS: C2RustUnnamed_8 = 10;
pub const NUMLEVELS: C2RustUnnamed_8 = 17;
pub const LVL4_START: C2RustUnnamed_8 = 13;
pub const LVL3_START: C2RustUnnamed_8 = 9;
pub const LVL2_START: C2RustUnnamed_8 = 5;
pub const LVL1_START: C2RustUnnamed_8 = 1;
pub const TLVL_START: C2RustUnnamed_8 = 0;
pub const LVLLENGTH: C2RustUnnamed_8 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ScrollStruct {
    pub _sxoff: libc::c_int,
    pub _syoff: libc::c_int,
    pub _sdx: libc::c_int,
    pub _sdy: libc::c_int,
    pub _sdir: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MissileStruct {
    pub _mitype: libc::c_int,
    pub _mix: libc::c_int,
    pub _miy: libc::c_int,
    pub _mixoff: int32_t,
    pub _miyoff: int32_t,
    pub _mixvel: int32_t,
    pub _miyvel: int32_t,
    pub _misx: libc::c_int,
    pub _misy: libc::c_int,
    pub _mitxoff: int32_t,
    pub _mityoff: int32_t,
    pub _mimfnum: libc::c_int,
    pub _mispllvl: libc::c_int,
    pub _miDelFlag: bool32_t,
    pub _miAnimType: uint8_t,
    pub _miAnimFlags: bool32_t,
    pub _miAnimData: *mut uint8_t,
    pub _miAnimDelay: libc::c_int,
    pub _miAnimLen: libc::c_int,
    pub _miAnimWidth: int32_t,
    pub _miAnimWidth2: int32_t,
    pub _miAnimCnt: libc::c_int,
    pub _miAnimAdd: libc::c_int,
    pub _miAnimFrame: libc::c_int,
    pub _miDrawFlag: bool32_t,
    pub _miLightFlag: bool32_t,
    pub _miPreFlag: bool32_t,
    pub _miUniqTrans: bool32_t,
    pub _mirange: libc::c_int,
    pub _misource: libc::c_int,
    pub _micaster: libc::c_int,
    pub _midam: libc::c_int,
    pub _miHitFlag: bool32_t,
    pub _midist: libc::c_int,
    pub _mlid: libc::c_int,
    pub _mirnd: libc::c_int,
    pub _miVar1: int32_t,
    pub _miVar2: int32_t,
    pub _miVar3: int32_t,
    pub _miVar4: int32_t,
    pub _miVar5: int32_t,
    pub _miVar6: int32_t,
    pub _miVar7: int32_t,
    pub _miVar8: int32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CKINFO {
    pub dwSize: uint32_t,
    pub dwOffset: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct WaveFormat {
    pub wFormatTag: uint16_t,
    pub nChannels: uint16_t,
    pub nSamplesPerSec: uint32_t,
    pub nAvgBytesPerSec: uint32_t,
    pub nBlockAlign: uint16_t,
    pub wBitsPerSample: uint16_t,
    pub cbSize: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TSnd {
    pub wfx: WaveFormat,
    pub waveInfo: CKINFO,
    pub pszName: *const libc::c_char,
    pub dwLastPlayTime: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct AnimStruct {
    pub CMem: *mut uint8_t,
    pub Cels: [*mut uint8_t; 8],
    pub Frames: libc::c_int,
    pub Rate: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SndEffectStruct {
    pub effect: [*mut TSnd; 2],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterData {
    pub mAnimWidth: int32_t,
    pub mImgSize: int32_t,
    pub filename: *const libc::c_char,
    pub has_special: bool32_t,
    pub sndfile: *const libc::c_char,
    pub snd_special: bool32_t,
    pub transflag: bool32_t,
    pub TransFile: *const libc::c_char,
    pub Frames: [libc::c_int; 6],
    pub Rate: [libc::c_int; 6],
    pub mName: *const libc::c_char,
    pub mMinDLvl: int8_t,
    pub mMaxDLvl: int8_t,
    pub mLevel: int8_t,
    pub mMinHP: int32_t,
    pub mMaxHP: int32_t,
    pub mAi: uint8_t,
    pub mFlags: uint32_t,
    pub mInt: uint8_t,
    pub mHit: uint8_t,
    pub mAFNum: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mAFNum2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMonstClass: int8_t,
    pub mMagicRes: uint16_t,
    pub mMagicRes2: uint16_t,
    pub mTreasure: uint16_t,
    pub mSelFlag: int8_t,
    pub mExp: uint16_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct CMonster {
    pub mtype: uint8_t,
    pub mPlaceFlags: uint8_t,
    pub Anims: [AnimStruct; 6],
    pub Snds: [SndEffectStruct; 4],
    pub mAnimWidth: int32_t,
    pub mAnimWidth2: int32_t,
    pub mMinHP: uint8_t,
    pub mMaxHP: uint8_t,
    pub has_special: bool32_t,
    pub mAFNum: uint8_t,
    pub mdeadval: int8_t,
    pub MData: *mut MonsterData,
    pub pTrans: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct MonsterStruct {
    pub _mMTidx: libc::c_int,
    pub _mmode: libc::c_int,
    pub _mgoal: uint8_t,
    pub _mgoalvar1: libc::c_int,
    pub _mgoalvar2: libc::c_int,
    pub _mgoalvar3: libc::c_int,
    pub _mgoalvar4: libc::c_int,
    pub _pathcount: uint8_t,
    pub _mx: libc::c_int,
    pub _my: libc::c_int,
    pub _mfutx: libc::c_int,
    pub _mfuty: libc::c_int,
    pub _moldx: libc::c_int,
    pub _moldy: libc::c_int,
    pub _mxoff: int32_t,
    pub _myoff: int32_t,
    pub _mxvel: int32_t,
    pub _myvel: int32_t,
    pub _mdir: libc::c_int,
    pub _menemy: libc::c_int,
    pub _menemyx: uint8_t,
    pub _menemyy: uint8_t,
    pub _mAnimData: *mut uint8_t,
    pub _mAnimDelay: libc::c_int,
    pub _mAnimCnt: libc::c_int,
    pub _mAnimLen: libc::c_int,
    pub _mAnimFrame: libc::c_int,
    pub _meflag: libc::c_int,
    pub _mDelFlag: bool32_t,
    pub _mVar1: int32_t,
    pub _mVar2: int32_t,
    pub _mVar3: int32_t,
    pub _mVar4: int32_t,
    pub _mVar5: int32_t,
    pub _mVar6: int32_t,
    pub _mVar7: int32_t,
    pub _mVar8: int32_t,
    pub _mmaxhp: int32_t,
    pub _mhitpoints: int32_t,
    pub _mAi: uint8_t,
    pub _mint: uint8_t,
    pub _mFlags: uint32_t,
    pub _msquelch: uint8_t,
    pub _mAFNum: libc::c_int,
    pub _lastx: libc::c_int,
    pub _lasty: libc::c_int,
    pub _mRndSeed: libc::c_int,
    pub _mAISeed: libc::c_int,
    pub _Wandering: bool32_t,
    pub _uniqtype: uint8_t,
    pub _uniqtrans: uint8_t,
    pub _udeadval: int8_t,
    pub mWhoHit: int8_t,
    pub mLevel: int8_t,
    pub mExp: uint16_t,
    pub mHit: uint8_t,
    pub mMinDamage: uint8_t,
    pub mMaxDamage: uint8_t,
    pub mHit2: uint8_t,
    pub mMinDamage2: uint8_t,
    pub mMaxDamage2: uint8_t,
    pub mArmorClass: uint8_t,
    pub mMagicRes: uint16_t,
    pub mtalkmsg: libc::c_int,
    pub leader: uint8_t,
    pub leaderflag: uint8_t,
    pub packsize: uint8_t,
    pub mlid: uint8_t,
    pub mName: *const libc::c_char,
    pub MType: *mut CMonster,
    pub MData: *mut MonsterData,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ObjectStruct {
    pub _otype: libc::c_int,
    pub _ox: libc::c_int,
    pub _oy: libc::c_int,
    pub _oLight: bool32_t,
    pub _oAnimFlag: bool32_t,
    pub _oAnimData: *mut uint8_t,
    pub _oAnimDelay: libc::c_int,
    pub _oAnimCnt: libc::c_int,
    pub _oAnimLen: libc::c_int,
    pub _oAnimFrame: libc::c_int,
    pub _oAnimWidth: int32_t,
    pub _oAnimWidth2: int32_t,
    pub _oDelFlag: bool32_t,
    pub _oBreak: int8_t,
    pub _oSolidFlag: bool32_t,
    pub _oMissFlag: bool32_t,
    pub _oSelFlag: int8_t,
    pub _oPreFlag: bool32_t,
    pub _oTrapFlag: bool32_t,
    pub _oDoorFlag: bool32_t,
    pub _olid: libc::c_int,
    pub _oRndSeed: libc::c_int,
    pub _oVar1: int32_t,
    pub _oVar2: int32_t,
    pub _oVar3: int32_t,
    pub _oVar4: int32_t,
    pub _oVar5: int32_t,
    pub _oVar6: int32_t,
    pub _oVar7: int32_t,
    pub _oVar8: int32_t,
}
pub type C2RustUnnamed_9 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_9 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_9 = 92160;
pub const BTMBUFFY: C2RustUnnamed_9 = 144;
pub const BTMBUFFX: C2RustUnnamed_9 = 640;
pub const BUFFERSIZE: C2RustUnnamed_9 = 503808;
pub const BUFFERY: C2RustUnnamed_9 = 656;
pub const BUFFERX: C2RustUnnamed_9 = 768;
pub const GAMEY: C2RustUnnamed_9 = 352;
pub const CTRLPANY: C2RustUnnamed_9 = 128;
pub const TOTALY: C2RustUnnamed_9 = 480;
pub const TOTALX: C2RustUnnamed_9 = 640;
pub const MAX_PLRS: C2RustUnnamed_9 = 4;
pub type C2RustUnnamed_10 = libc::c_int;
pub const MAX_STAT: C2RustUnnamed_10 = 750;
pub const MAX_EXPLVLS: C2RustUnnamed_10 = 50;
pub const KILL_UNKNOWN: C2RustUnnamed_10 = -1;
pub const BASE_TO_HIT: C2RustUnnamed_10 = 50;
pub const PLR_NAME_LEN: C2RustUnnamed_10 = 32;
pub const MAXSPD: C2RustUnnamed_10 = 8;
pub const MAXINV: C2RustUnnamed_10 = 40;
pub const MAXPATHLEN: C2RustUnnamed_10 = 25;
pub const MANA_SHIFT: C2RustUnnamed_10 = 6;
pub const HP_SHIFT: C2RustUnnamed_10 = 6;
pub const NUM_CLASSES: C2RustUnnamed_10 = 3;
pub const MAXPACKLEN: C2RustUnnamed_10 = 256;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TNQ {
    pub _qsttype: uint8_t,
    pub _qstmsg: uint8_t,
    pub _qstmsgact: uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct TownerStruct {
    pub _tmode: libc::c_int,
    pub _ttype: libc::c_int,
    pub _tx: libc::c_int,
    pub _ty: libc::c_int,
    pub _txoff: int32_t,
    pub _tyoff: int32_t,
    pub _txvel: int32_t,
    pub _tyvel: int32_t,
    pub _tdir: libc::c_int,
    pub _tAnimData: *mut uint8_t,
    pub _tAnimDelay: libc::c_int,
    pub _tAnimCnt: libc::c_int,
    pub _tAnimLen: libc::c_int,
    pub _tAnimFrame: libc::c_int,
    pub _tAnimFrameCnt: libc::c_int,
    pub _tAnimOrder: int8_t,
    pub _tAnimWidth: int32_t,
    pub _tAnimWidth2: int32_t,
    pub _tTenPer: libc::c_int,
    pub _teflag: libc::c_int,
    pub _tbtcnt: libc::c_int,
    pub _tSelFlag: bool32_t,
    pub _tMsgSaid: bool32_t,
    pub qsts: [TNQ; 16],
    pub _tSeed: libc::c_int,
    pub _tVar1: int32_t,
    pub _tVar2: int32_t,
    pub _tVar3: int32_t,
    pub _tVar4: int32_t,
    pub _tName: [libc::c_char; 32],
    pub _tNAnim: [*mut uint8_t; 8],
    pub _tNFrames: libc::c_int,
    pub _tNData: *mut uint8_t,
}
static mut oldcursmonst: libc::c_int = 0;
#[no_mangle]
pub unsafe extern "C" fn InitCursor() {
    if !pCursCels.is_null() {
        assert_fail(
            39 as libc::c_int,
            b"src/cursor.c\0" as *const u8 as *const libc::c_char,
            b"!pCursCels\0" as *const u8 as *const libc::c_char,
        );
    }
    pCursCels = LoadFileInMem(
        b"Data\\Inv\\Objcurs.CEL\0" as *const u8 as *const libc::c_char,
        0 as *mut uint32_t,
    );
    savecrsr_reset();
}
#[no_mangle]
pub unsafe extern "C" fn FreeCursor() {
    let mut p__p: *mut libc::c_void = pCursCels as *mut libc::c_void;
    pCursCels = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    savecrsr_reset();
}
#[no_mangle]
pub unsafe extern "C" fn SetICursor(mut i: libc::c_int) {
    icursW = CursorWidth[i as usize];
    icursH = CursorHeight[i as usize];
    icursW28 = icursW / 28 as libc::c_int;
    icursH28 = icursH / 28 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn SetCursor_(mut i: libc::c_int) {
    curs = i;
    cursW = CursorWidth[curs as usize];
    cursH = CursorHeight[curs as usize];
    SetICursor(i);
}
#[no_mangle]
pub unsafe extern "C" fn NewCursor(mut i: libc::c_int) {
    SetCursor_(i);
}
#[no_mangle]
pub unsafe extern "C" fn InitLevelCursor() {
    SetCursor_(GLOVE_CURS as libc::c_int);
    cursmx = ViewX;
    cursmy = ViewY;
    oldcursmonst = -(1 as libc::c_int);
    cursmonst = -(1 as libc::c_int);
    cursobj = -(1 as libc::c_int) as int8_t;
    cursitem = -(1 as libc::c_int) as int8_t;
    cursplr = -(1 as libc::c_int) as int8_t;
    savecrsr_reset();
}
#[no_mangle]
pub unsafe extern "C" fn CheckTown() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < nummissiles {
        let mut mx: libc::c_int = missileactive[i as usize];
        if missile[mx as usize]._mitype == MIT_TOWN as libc::c_int {
            if cursmx == missile[mx as usize]._mix - 1 as libc::c_int
                && cursmy == missile[mx as usize]._miy
                || cursmx == missile[mx as usize]._mix
                    && cursmy == missile[mx as usize]._miy - 1 as libc::c_int
                || cursmx == missile[mx as usize]._mix - 1 as libc::c_int
                    && cursmy == missile[mx as usize]._miy - 1 as libc::c_int
                || cursmx == missile[mx as usize]._mix - 2 as libc::c_int
                    && cursmy == missile[mx as usize]._miy - 1 as libc::c_int
                || cursmx == missile[mx as usize]._mix - 2 as libc::c_int
                    && cursmy == missile[mx as usize]._miy - 2 as libc::c_int
                || cursmx == missile[mx as usize]._mix - 1 as libc::c_int
                    && cursmy == missile[mx as usize]._miy - 2 as libc::c_int
                || cursmx == missile[mx as usize]._mix
                    && cursmy == missile[mx as usize]._miy
            {
                trigflag = 1 as libc::c_int as bool32_t;
                ClearPanel();
                strcpy(
                    infostr.as_mut_ptr(),
                    b"Town Portal\0" as *const u8 as *const libc::c_char,
                );
                sprintf(
                    tempstr.as_mut_ptr(),
                    b"from %s\0" as *const u8 as *const libc::c_char,
                    (plr[missile[mx as usize]._misource as usize]._pName).as_mut_ptr(),
                );
                AddPanelString(tempstr.as_mut_ptr(), TEXT_CENTER as libc::c_int);
                cursmx = missile[mx as usize]._mix;
                cursmy = missile[mx as usize]._miy;
            }
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn CheckRportal() {
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < nummissiles {
        let mut mx: libc::c_int = missileactive[i as usize];
        if missile[mx as usize]._mitype == MIT_RPORTAL as libc::c_int {
            if cursmx == missile[mx as usize]._mix - 1 as libc::c_int
                && cursmy == missile[mx as usize]._miy
                || cursmx == missile[mx as usize]._mix
                    && cursmy == missile[mx as usize]._miy - 1 as libc::c_int
                || cursmx == missile[mx as usize]._mix - 1 as libc::c_int
                    && cursmy == missile[mx as usize]._miy - 1 as libc::c_int
                || cursmx == missile[mx as usize]._mix - 2 as libc::c_int
                    && cursmy == missile[mx as usize]._miy - 1 as libc::c_int
                || cursmx == missile[mx as usize]._mix - 2 as libc::c_int
                    && cursmy == missile[mx as usize]._miy - 2 as libc::c_int
                || cursmx == missile[mx as usize]._mix - 1 as libc::c_int
                    && cursmy == missile[mx as usize]._miy - 2 as libc::c_int
                || cursmx == missile[mx as usize]._mix
                    && cursmy == missile[mx as usize]._miy
            {
                trigflag = 1 as libc::c_int as bool32_t;
                ClearPanel();
                strcpy(
                    infostr.as_mut_ptr(),
                    b"Portal to\0" as *const u8 as *const libc::c_char,
                );
                if setlevel == 0 {
                    strcpy(
                        tempstr.as_mut_ptr(),
                        b"The Unholy Altar\0" as *const u8 as *const libc::c_char,
                    );
                } else {
                    strcpy(
                        tempstr.as_mut_ptr(),
                        b"level 15\0" as *const u8 as *const libc::c_char,
                    );
                }
                AddPanelString(tempstr.as_mut_ptr(), TEXT_CENTER as libc::c_int);
                cursmx = missile[mx as usize]._mix;
                cursmy = missile[mx as usize]._miy;
            }
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn CheckCursMove() {
    let mut mx: libc::c_int = 0;
    let mut my: libc::c_int = 0;
    let mut offsetx: libc::c_int = 0;
    let mut offsety: libc::c_int = 0;
    let mut gridx: libc::c_int = 0;
    let mut gridy: libc::c_int = 0;
    let mut co: int8_t = 0;
    let mut ci: int8_t = 0;
    let mut cp: int8_t = 0;
    let mut cm: libc::c_int = 0;
    let mut minusy: bool32_t = 0;
    let mut plusx: bool32_t = 0;
    let mut lefthalf: bool32_t = 0;
    let mut newMouseX: libc::c_int = 0;
    let mut newMouseY: libc::c_int = 0;
    let mut pvar6tmp: libc::c_int = 0;
    let mut pvar7tmp: libc::c_int = 0;
    let mut xo: int32_t = 0;
    let mut yo: int32_t = 0;
    newMouseX = MouseX;
    newMouseY = MouseY;
    if chrflag != 0 || questlog != 0 {
        if newMouseX >= TOTALX as libc::c_int / 2 as libc::c_int {
            newMouseX -= TOTALX as libc::c_int / 4 as libc::c_int;
        } else {
            newMouseX = 0 as libc::c_int;
        }
    } else if invflag != 0 || sbookflag != 0 {
        if newMouseX <= TOTALX as libc::c_int / 2 as libc::c_int {
            newMouseX += TOTALX as libc::c_int / 4 as libc::c_int;
        } else {
            newMouseX = 0 as libc::c_int;
        }
    }
    if newMouseY > 351 as libc::c_int && IsTracking() != 0 {
        newMouseY = 351 as libc::c_int;
    }
    if svgamode == 0 {
        newMouseX >>= 1 as libc::c_int;
        newMouseY >>= 1 as libc::c_int;
    }
    newMouseX -= ScrollInfo._sxoff;
    newMouseY -= ScrollInfo._syoff;
    xo = plr[myplr as usize]._pVar6 >> 8 as libc::c_int;
    yo = plr[myplr as usize]._pVar7 >> 8 as libc::c_int;
    pvar6tmp = plr[myplr as usize]._pVar6 + plr[myplr as usize]._pxvel;
    pvar7tmp = plr[myplr as usize]._pVar7 + plr[myplr as usize]._pyvel;
    xo -= pvar6tmp >> 8 as libc::c_int;
    yo -= pvar7tmp >> 8 as libc::c_int;
    if ScrollInfo._sdir != SCRL_NONE as libc::c_int {
        newMouseX -= xo;
        newMouseY -= yo;
    }
    if newMouseX < 0 as libc::c_int {
        newMouseX = 0 as libc::c_int;
    }
    if newMouseX >= TOTALX as libc::c_int {
        newMouseX = TOTALX as libc::c_int;
    }
    if newMouseY < 0 as libc::c_int {
        newMouseY = 0 as libc::c_int;
    }
    if newMouseY >= TOTALY as libc::c_int {
        newMouseY = TOTALY as libc::c_int;
    }
    gridx = newMouseX >> 6 as libc::c_int;
    gridy = newMouseY >> 5 as libc::c_int;
    offsetx = newMouseX & 63 as libc::c_int;
    offsety = newMouseY & 31 as libc::c_int;
    mx = gridx + gridy + ViewX
        - (if svgamode != 0 { 10 as libc::c_int } else { 5 as libc::c_int });
    my = gridy - gridx + ViewY;
    minusy = (offsety < offsetx >> 1 as libc::c_int) as libc::c_int as bool32_t;
    if minusy != 0 {
        my -= 1;
        my;
    }
    plusx = (offsety >= 32 as libc::c_int - (offsetx >> 1 as libc::c_int)) as libc::c_int
        as bool32_t;
    if plusx != 0 {
        mx += 1;
        mx;
    }
    if mx < 0 as libc::c_int {
        mx = 0 as libc::c_int;
    }
    if mx >= DMAXX as libc::c_int {
        mx = DMAXX as libc::c_int - 1 as libc::c_int;
    }
    if my < 0 as libc::c_int {
        my = 0 as libc::c_int;
    }
    if my >= DMAXY as libc::c_int {
        my = DMAXY as libc::c_int - 1 as libc::c_int;
    }
    lefthalf = (minusy != 0 && plusx != 0
        || (minusy != 0 || plusx != 0) && offsetx < 32 as libc::c_int) as libc::c_int
        as bool32_t;
    oldcursmonst = cursmonst;
    cursmonst = -(1 as libc::c_int);
    cursobj = -(1 as libc::c_int) as int8_t;
    cursitem = -(1 as libc::c_int) as int8_t;
    if cursinvitem as libc::c_int != -(1 as libc::c_int) {
        drawsbarflag = 1 as libc::c_int as bool32_t;
    }
    cursinvitem = -(1 as libc::c_int) as int8_t;
    cursplr = -(1 as libc::c_int) as int8_t;
    uitemflag = 0 as libc::c_int as bool32_t;
    panelflag = 0 as libc::c_int as bool32_t;
    trigflag = 0 as libc::c_int as bool32_t;
    if plr[myplr as usize]._pInvincible != 0 {
        return;
    }
    if curs >= ICSTART as libc::c_int || spselflag != 0 {
        cursmx = mx;
        cursmy = my;
        return;
    }
    if MouseY > 352 as libc::c_int {
        CheckPanelInfo();
        return;
    }
    if drawmapofdoom != 0 {
        return;
    }
    if invflag != 0 && MouseX > 320 as libc::c_int {
        cursinvitem = CheckInvHLight();
        return;
    }
    if sbookflag != 0 && MouseX > 320 as libc::c_int {
        return;
    }
    if (chrflag != 0 || questlog != 0) && MouseX < 320 as libc::c_int {
        return;
    }
    if leveltype as libc::c_int != 0 as libc::c_int {
        if oldcursmonst != -(1 as libc::c_int) {
            if lefthalf == 0
                && dMonster[(mx + 2 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] != 0 as libc::c_int
                && dFlags[(mx + 2 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                    & BFLAG_VISIBLE as libc::c_int != 0
            {
                if dMonster[(mx + 2 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] > 0 as libc::c_int
                {
                    cm = dMonster[(mx + 2 as libc::c_int)
                        as usize][(my + 1 as libc::c_int) as usize] - 1 as libc::c_int;
                } else {
                    cm = -(dMonster[(mx + 2 as libc::c_int)
                        as usize][(my + 1 as libc::c_int) as usize] + 1 as libc::c_int);
                }
                if cm == oldcursmonst {
                    if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                        > 0 as libc::c_int
                        && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                            & MSEL_TOP as libc::c_int != 0
                    {
                        cursmx = mx + 1 as libc::c_int;
                        cursmy = my + 2 as libc::c_int;
                        cursmonst = cm;
                    }
                }
            }
            if lefthalf != 0
                && dMonster[(mx + 1 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] != 0 as libc::c_int
                && dFlags[(mx + 1 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] as libc::c_int
                    & BFLAG_VISIBLE as libc::c_int != 0
            {
                if dMonster[(mx + 1 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] > 0 as libc::c_int
                {
                    cm = dMonster[(mx + 1 as libc::c_int)
                        as usize][(my + 2 as libc::c_int) as usize] - 1 as libc::c_int;
                } else {
                    cm = -(dMonster[(mx + 1 as libc::c_int)
                        as usize][(my + 2 as libc::c_int) as usize] + 1 as libc::c_int);
                }
                if cm == oldcursmonst {
                    if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                        > 0 as libc::c_int
                        && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                            & MSEL_TOP as libc::c_int != 0
                    {
                        cursmx = mx + 1 as libc::c_int;
                        cursmy = my + 2 as libc::c_int;
                        cursmonst = cm;
                    }
                }
            }
            if dMonster[(mx + 2 as libc::c_int)
                as usize][(my + 2 as libc::c_int) as usize] != 0 as libc::c_int
                && dFlags[(mx + 2 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] as libc::c_int
                    & BFLAG_VISIBLE as libc::c_int != 0
            {
                if dMonster[(mx + 2 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] > 0 as libc::c_int
                {
                    cm = dMonster[(mx + 2 as libc::c_int)
                        as usize][(my + 2 as libc::c_int) as usize] - 1 as libc::c_int;
                } else {
                    cm = -(dMonster[(mx + 2 as libc::c_int)
                        as usize][(my + 2 as libc::c_int) as usize] + 1 as libc::c_int);
                }
                if cm == oldcursmonst {
                    if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                        > 0 as libc::c_int
                        && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                            & MSEL_TOP as libc::c_int != 0
                    {
                        cursmx = mx + 2 as libc::c_int;
                        cursmy = my + 2 as libc::c_int;
                        cursmonst = cm;
                    }
                }
            }
            if lefthalf == 0
                && dMonster[(mx + 1 as libc::c_int) as usize][my as usize]
                    != 0 as libc::c_int
                && dFlags[(mx + 1 as libc::c_int) as usize][my as usize] as libc::c_int
                    & BFLAG_VISIBLE as libc::c_int != 0
            {
                if dMonster[(mx + 1 as libc::c_int) as usize][my as usize]
                    > 0 as libc::c_int
                {
                    cm = dMonster[(mx + 1 as libc::c_int) as usize][my as usize]
                        - 1 as libc::c_int;
                } else {
                    cm = -(dMonster[(mx + 1 as libc::c_int) as usize][my as usize]
                        + 1 as libc::c_int);
                }
                if cm == oldcursmonst {
                    if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                        > 0 as libc::c_int
                        && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                            & MSEL_MID as libc::c_int != 0
                    {
                        cursmx = mx + 1 as libc::c_int;
                        cursmy = my;
                        cursmonst = cm;
                    }
                }
            }
            if lefthalf != 0
                && dMonster[mx as usize][(my + 1 as libc::c_int) as usize]
                    != 0 as libc::c_int
                && dFlags[mx as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                    & BFLAG_VISIBLE as libc::c_int != 0
            {
                if dMonster[mx as usize][(my + 1 as libc::c_int) as usize]
                    > 0 as libc::c_int
                {
                    cm = dMonster[mx as usize][(my + 1 as libc::c_int) as usize]
                        - 1 as libc::c_int;
                } else {
                    cm = -(dMonster[mx as usize][(my + 1 as libc::c_int) as usize]
                        + 1 as libc::c_int);
                }
                if cm == oldcursmonst {
                    if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                        > 0 as libc::c_int
                        && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                            & MSEL_MID as libc::c_int != 0
                    {
                        cursmx = mx;
                        cursmy = my + 1 as libc::c_int;
                        cursmonst = cm;
                    }
                }
            }
            if dMonster[mx as usize][my as usize] != 0 as libc::c_int
                && dFlags[mx as usize][my as usize] as libc::c_int
                    & BFLAG_VISIBLE as libc::c_int != 0
            {
                if dMonster[mx as usize][my as usize] > 0 as libc::c_int {
                    cm = dMonster[mx as usize][my as usize] - 1 as libc::c_int;
                } else {
                    cm = -(dMonster[mx as usize][my as usize] + 1 as libc::c_int);
                }
                if cm == oldcursmonst {
                    if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                        > 0 as libc::c_int
                        && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                            & MSEL_FLR as libc::c_int != 0
                    {
                        cursmx = mx;
                        cursmy = my;
                        cursmonst = cm;
                    }
                }
            }
            if dMonster[(mx + 1 as libc::c_int)
                as usize][(my + 1 as libc::c_int) as usize] != 0 as libc::c_int
                && dFlags[(mx + 1 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                    & BFLAG_VISIBLE as libc::c_int != 0
            {
                if dMonster[(mx + 1 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] > 0 as libc::c_int
                {
                    cm = dMonster[(mx + 1 as libc::c_int)
                        as usize][(my + 1 as libc::c_int) as usize] - 1 as libc::c_int;
                } else {
                    cm = -(dMonster[(mx + 1 as libc::c_int)
                        as usize][(my + 1 as libc::c_int) as usize] + 1 as libc::c_int);
                }
                if cm == oldcursmonst {
                    if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                        > 0 as libc::c_int
                        && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                            & MSEL_MID as libc::c_int != 0
                    {
                        cursmx = mx + 1 as libc::c_int;
                        cursmy = my + 1 as libc::c_int;
                        cursmonst = cm;
                    }
                }
            }
            if cursmonst != -(1 as libc::c_int) {
                if monster[cursmonst as usize]._mFlags
                    & MFLAG_INVISIBLE as libc::c_int as uint32_t != 0
                {
                    cursmonst = -(1 as libc::c_int);
                    cursmx = mx;
                    cursmy = my;
                }
            }
            if cursmonst != -(1 as libc::c_int)
                && monster[cursmonst as usize]._mFlags
                    & MFLAG_MKILLER as libc::c_int as uint32_t
                    != 0 as libc::c_int as uint32_t
            {
                cursmonst = -(1 as libc::c_int);
            }
            if cursmonst != -(1 as libc::c_int) {
                return;
            }
        }
        if lefthalf == 0
            && dMonster[(mx + 2 as libc::c_int)
                as usize][(my + 1 as libc::c_int) as usize] != 0 as libc::c_int
            && dFlags[(mx + 2 as libc::c_int) as usize][(my + 1 as libc::c_int) as usize]
                as libc::c_int & BFLAG_VISIBLE as libc::c_int != 0
        {
            if dMonster[(mx + 2 as libc::c_int)
                as usize][(my + 1 as libc::c_int) as usize] > 0 as libc::c_int
            {
                cm = dMonster[(mx + 2 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] - 1 as libc::c_int;
            } else {
                cm = -(dMonster[(mx + 2 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] + 1 as libc::c_int);
            }
            if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                > 0 as libc::c_int
                && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                    & MSEL_TOP as libc::c_int != 0
            {
                cursmx = mx + 2 as libc::c_int;
                cursmy = my + 1 as libc::c_int;
                cursmonst = cm;
            }
        }
        if lefthalf != 0
            && dMonster[(mx + 1 as libc::c_int)
                as usize][(my + 2 as libc::c_int) as usize] != 0 as libc::c_int
            && dFlags[(mx + 1 as libc::c_int) as usize][(my + 2 as libc::c_int) as usize]
                as libc::c_int & BFLAG_VISIBLE as libc::c_int != 0
        {
            if dMonster[(mx + 1 as libc::c_int)
                as usize][(my + 2 as libc::c_int) as usize] > 0 as libc::c_int
            {
                cm = dMonster[(mx + 1 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] - 1 as libc::c_int;
            } else {
                cm = -(dMonster[(mx + 1 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] + 1 as libc::c_int);
            }
            if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                > 0 as libc::c_int
                && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                    & MSEL_TOP as libc::c_int != 0
            {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my + 2 as libc::c_int;
                cursmonst = cm;
            }
        }
        if dMonster[(mx + 2 as libc::c_int) as usize][(my + 2 as libc::c_int) as usize]
            != 0 as libc::c_int
            && dFlags[(mx + 2 as libc::c_int) as usize][(my + 2 as libc::c_int) as usize]
                as libc::c_int & BFLAG_VISIBLE as libc::c_int != 0
        {
            if dMonster[(mx + 2 as libc::c_int)
                as usize][(my + 2 as libc::c_int) as usize] > 0 as libc::c_int
            {
                cm = dMonster[(mx + 2 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] - 1 as libc::c_int;
            } else {
                cm = -(dMonster[(mx + 2 as libc::c_int)
                    as usize][(my + 2 as libc::c_int) as usize] + 1 as libc::c_int);
            }
            if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                > 0 as libc::c_int
                && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                    & MSEL_TOP as libc::c_int != 0
            {
                cursmx = mx + 2 as libc::c_int;
                cursmy = my + 2 as libc::c_int;
                cursmonst = cm;
            }
        }
        if lefthalf == 0
            && dMonster[(mx + 1 as libc::c_int) as usize][my as usize]
                != 0 as libc::c_int
            && dFlags[(mx + 1 as libc::c_int) as usize][my as usize] as libc::c_int
                & BFLAG_VISIBLE as libc::c_int != 0
        {
            if dMonster[(mx + 1 as libc::c_int) as usize][my as usize] > 0 as libc::c_int
            {
                cm = dMonster[(mx + 1 as libc::c_int) as usize][my as usize]
                    - 1 as libc::c_int;
            } else {
                cm = -(dMonster[(mx + 1 as libc::c_int) as usize][my as usize]
                    + 1 as libc::c_int);
            }
            if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                > 0 as libc::c_int
                && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                    & MSEL_MID as libc::c_int != 0
            {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my;
                cursmonst = cm;
            }
        }
        if lefthalf != 0
            && dMonster[mx as usize][(my + 1 as libc::c_int) as usize]
                != 0 as libc::c_int
            && dFlags[mx as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                & BFLAG_VISIBLE as libc::c_int != 0
        {
            if dMonster[mx as usize][(my + 1 as libc::c_int) as usize] > 0 as libc::c_int
            {
                cm = dMonster[mx as usize][(my + 1 as libc::c_int) as usize]
                    - 1 as libc::c_int;
            } else {
                cm = -(dMonster[mx as usize][(my + 1 as libc::c_int) as usize]
                    + 1 as libc::c_int);
            }
            if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                > 0 as libc::c_int
                && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                    & MSEL_MID as libc::c_int != 0
            {
                cursmx = mx;
                cursmy = my + 1 as libc::c_int;
                cursmonst = cm;
            }
        }
        if dMonster[mx as usize][my as usize] != 0 as libc::c_int
            && dFlags[mx as usize][my as usize] as libc::c_int
                & BFLAG_VISIBLE as libc::c_int != 0
        {
            if dMonster[mx as usize][my as usize] > 0 as libc::c_int {
                cm = dMonster[mx as usize][my as usize] - 1 as libc::c_int;
            } else {
                cm = -(dMonster[mx as usize][my as usize] + 1 as libc::c_int);
            }
            if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                > 0 as libc::c_int
                && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                    & MSEL_FLR as libc::c_int != 0
            {
                cursmx = mx;
                cursmy = my;
                cursmonst = cm;
            }
        }
        if dMonster[(mx + 1 as libc::c_int) as usize][(my + 1 as libc::c_int) as usize]
            != 0 as libc::c_int
            && dFlags[(mx + 1 as libc::c_int) as usize][(my + 1 as libc::c_int) as usize]
                as libc::c_int & BFLAG_VISIBLE as libc::c_int != 0
        {
            if dMonster[(mx + 1 as libc::c_int)
                as usize][(my + 1 as libc::c_int) as usize] > 0 as libc::c_int
            {
                cm = dMonster[(mx + 1 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] - 1 as libc::c_int;
            } else {
                cm = -(dMonster[(mx + 1 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] + 1 as libc::c_int);
            }
            if monster[cm as usize]._mhitpoints >> HP_SHIFT as libc::c_int
                > 0 as libc::c_int
                && (*monster[cm as usize].MData).mSelFlag as libc::c_int
                    & MSEL_MID as libc::c_int != 0
            {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my + 1 as libc::c_int;
                cursmonst = cm;
            }
        }
        if cursmonst != -(1 as libc::c_int) {
            if monster[cursmonst as usize]._mFlags
                & MFLAG_INVISIBLE as libc::c_int as uint32_t != 0
            {
                cursmonst = -(1 as libc::c_int);
                cursmx = mx;
                cursmy = my;
            }
        }
        if cursmonst != -(1 as libc::c_int)
            && monster[cursmonst as usize]._mFlags
                & MFLAG_MKILLER as libc::c_int as uint32_t
                != 0 as libc::c_int as uint32_t
        {
            cursmonst = -(1 as libc::c_int);
        }
    } else {
        if lefthalf == 0
            && dMonster[(mx + 1 as libc::c_int) as usize][my as usize] > 0 as libc::c_int
        {
            cursmonst = dMonster[(mx + 1 as libc::c_int) as usize][my as usize]
                - 1 as libc::c_int;
            cursmx = mx + 1 as libc::c_int;
            cursmy = my;
        }
        if lefthalf != 0
            && dMonster[mx as usize][(my + 1 as libc::c_int) as usize] > 0 as libc::c_int
        {
            cursmonst = dMonster[mx as usize][(my + 1 as libc::c_int) as usize]
                - 1 as libc::c_int;
            cursmx = mx;
            cursmy = my + 1 as libc::c_int;
        }
        if dMonster[mx as usize][my as usize] > 0 as libc::c_int {
            cursmonst = dMonster[mx as usize][my as usize] - 1 as libc::c_int;
            cursmx = mx;
            cursmy = my;
        }
        if dMonster[(mx + 1 as libc::c_int) as usize][(my + 1 as libc::c_int) as usize]
            > 0 as libc::c_int
        {
            cursmonst = dMonster[(mx + 1 as libc::c_int)
                as usize][(my + 1 as libc::c_int) as usize] - 1 as libc::c_int;
            cursmx = mx + 1 as libc::c_int;
            cursmy = my + 1 as libc::c_int;
        }
        if cursmonst != -(1 as libc::c_int) {
            if towner[cursmonst as usize]._tSelFlag == 0 {
                cursmonst = -(1 as libc::c_int);
            }
        }
    }
    if cursmonst == -(1 as libc::c_int) {
        if lefthalf == 0
            && dPlayer[(mx + 1 as libc::c_int) as usize][my as usize] as libc::c_int
                != 0 as libc::c_int
        {
            if dPlayer[(mx + 1 as libc::c_int) as usize][my as usize] as libc::c_int
                > 0 as libc::c_int
            {
                cp = (dPlayer[(mx + 1 as libc::c_int) as usize][my as usize]
                    as libc::c_int - 1 as libc::c_int) as int8_t;
            } else {
                cp = -(dPlayer[(mx + 1 as libc::c_int) as usize][my as usize]
                    as libc::c_int + 1 as libc::c_int) as int8_t;
            }
            if cp as libc::c_int != myplr
                && plr[cp as usize]._pHitPoints != 0 as libc::c_int
            {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my;
                cursplr = cp;
            }
        }
        if lefthalf != 0
            && dPlayer[mx as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                != 0 as libc::c_int
        {
            if dPlayer[mx as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                > 0 as libc::c_int
            {
                cp = (dPlayer[mx as usize][(my + 1 as libc::c_int) as usize]
                    as libc::c_int - 1 as libc::c_int) as int8_t;
            } else {
                cp = -(dPlayer[mx as usize][(my + 1 as libc::c_int) as usize]
                    as libc::c_int + 1 as libc::c_int) as int8_t;
            }
            if cp as libc::c_int != myplr
                && plr[cp as usize]._pHitPoints != 0 as libc::c_int
            {
                cursmx = mx;
                cursmy = my + 1 as libc::c_int;
                cursplr = cp;
            }
        }
        if dPlayer[mx as usize][my as usize] as libc::c_int != 0 as libc::c_int {
            if dPlayer[mx as usize][my as usize] as libc::c_int > 0 as libc::c_int {
                cp = (dPlayer[mx as usize][my as usize] as libc::c_int
                    - 1 as libc::c_int) as int8_t;
            } else {
                cp = -(dPlayer[mx as usize][my as usize] as libc::c_int
                    + 1 as libc::c_int) as int8_t;
            }
            if cp as libc::c_int != myplr {
                cursmx = mx;
                cursmy = my;
                cursplr = cp;
            }
        }
        if dFlags[mx as usize][my as usize] as libc::c_int & BFLAG_DEADPLR as libc::c_int
            != 0
        {
            let mut i: libc::c_int = 0 as libc::c_int;
            while i < MAX_PLRS as libc::c_int {
                if plr[i as usize]._px == mx && plr[i as usize]._py == my && i != myplr {
                    cursmx = mx;
                    cursmy = my;
                    cursplr = i as int8_t;
                }
                i += 1;
                i;
            }
        }
        if curs == RESURRECT_CURS as libc::c_int {
            let mut j: libc::c_int = -(1 as libc::c_int);
            while j < 2 as libc::c_int {
                let mut k: libc::c_int = -(1 as libc::c_int);
                while k < 2 as libc::c_int {
                    if dFlags[(mx + j) as usize][(my + k) as usize] as libc::c_int
                        & BFLAG_DEADPLR as libc::c_int != 0
                    {
                        let mut i_0: libc::c_int = 0 as libc::c_int;
                        while i_0 < MAX_PLRS as libc::c_int {
                            if plr[i_0 as usize]._px == mx + j
                                && plr[i_0 as usize]._py == my + k && i_0 != myplr
                            {
                                cursmx = mx + j;
                                cursmy = my + k;
                                cursplr = i_0 as int8_t;
                            }
                            i_0 += 1;
                            i_0;
                        }
                    }
                    k += 1;
                    k;
                }
                j += 1;
                j;
            }
        }
        if dPlayer[(mx + 1 as libc::c_int) as usize][(my + 1 as libc::c_int) as usize]
            as libc::c_int != 0 as libc::c_int
        {
            if dPlayer[(mx + 1 as libc::c_int)
                as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                > 0 as libc::c_int
            {
                cp = (dPlayer[(mx + 1 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                    - 1 as libc::c_int) as int8_t;
            } else {
                cp = -(dPlayer[(mx + 1 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                    + 1 as libc::c_int) as int8_t;
            }
            if cp as libc::c_int != myplr
                && plr[cp as usize]._pHitPoints != 0 as libc::c_int
            {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my + 1 as libc::c_int;
                cursplr = cp;
            }
        }
    }
    if cursmonst == -(1 as libc::c_int) && cursplr as libc::c_int == -(1 as libc::c_int)
    {
        if lefthalf == 0
            && dObject[(mx + 1 as libc::c_int) as usize][my as usize] as libc::c_int
                != 0 as libc::c_int
        {
            if dObject[(mx + 1 as libc::c_int) as usize][my as usize] as libc::c_int
                > 0 as libc::c_int
            {
                co = (dObject[(mx + 1 as libc::c_int) as usize][my as usize]
                    as libc::c_int - 1 as libc::c_int) as int8_t;
            } else {
                co = -(dObject[(mx + 1 as libc::c_int) as usize][my as usize]
                    as libc::c_int + 1 as libc::c_int) as int8_t;
            }
            if object[co as usize]._oSelFlag as libc::c_int >= OSEL_TOP as libc::c_int {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my;
                cursobj = co;
            }
        }
        if lefthalf != 0
            && dObject[mx as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                != 0 as libc::c_int
        {
            if dObject[mx as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                > 0 as libc::c_int
            {
                co = (dObject[mx as usize][(my + 1 as libc::c_int) as usize]
                    as libc::c_int - 1 as libc::c_int) as int8_t;
            } else {
                co = -(dObject[mx as usize][(my + 1 as libc::c_int) as usize]
                    as libc::c_int + 1 as libc::c_int) as int8_t;
            }
            if object[co as usize]._oSelFlag as libc::c_int >= OSEL_TOP as libc::c_int {
                cursmx = mx;
                cursmy = my + 1 as libc::c_int;
                cursobj = co;
            }
        }
        if dObject[mx as usize][my as usize] as libc::c_int != 0 as libc::c_int {
            if dObject[mx as usize][my as usize] as libc::c_int > 0 as libc::c_int {
                co = (dObject[mx as usize][my as usize] as libc::c_int
                    - 1 as libc::c_int) as int8_t;
            } else {
                co = -(dObject[mx as usize][my as usize] as libc::c_int
                    + 1 as libc::c_int) as int8_t;
            }
            if object[co as usize]._oSelFlag as libc::c_int == OSEL_FLR as libc::c_int
                || object[co as usize]._oSelFlag as libc::c_int
                    == OSEL_ALL as libc::c_int
            {
                cursmx = mx;
                cursmy = my;
                cursobj = co;
            }
        }
        if dObject[(mx + 1 as libc::c_int) as usize][(my + 1 as libc::c_int) as usize]
            as libc::c_int != 0 as libc::c_int
        {
            if dObject[(mx + 1 as libc::c_int)
                as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                > 0 as libc::c_int
            {
                co = (dObject[(mx + 1 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                    - 1 as libc::c_int) as int8_t;
            } else {
                co = -(dObject[(mx + 1 as libc::c_int)
                    as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                    + 1 as libc::c_int) as int8_t;
            }
            if object[co as usize]._oSelFlag as libc::c_int >= OSEL_TOP as libc::c_int {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my + 1 as libc::c_int;
                cursobj = co;
            }
        }
    }
    if cursplr as libc::c_int == -(1 as libc::c_int)
        && cursobj as libc::c_int == -(1 as libc::c_int)
        && cursmonst == -(1 as libc::c_int)
    {
        if lefthalf == 0
            && dItem[(mx + 1 as libc::c_int) as usize][my as usize] as libc::c_int
                > 0 as libc::c_int
        {
            ci = (dItem[(mx + 1 as libc::c_int) as usize][my as usize] as libc::c_int
                - 1 as libc::c_int) as int8_t;
            if item[ci as usize]._iSelFlag as libc::c_int >= ISEL_TOP as libc::c_int {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my;
                cursitem = ci;
            }
        }
        if lefthalf != 0
            && dItem[mx as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                > 0 as libc::c_int
        {
            ci = (dItem[mx as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                - 1 as libc::c_int) as int8_t;
            if item[ci as usize]._iSelFlag as libc::c_int >= ISEL_TOP as libc::c_int {
                cursmx = mx;
                cursmy = my + 1 as libc::c_int;
                cursitem = ci;
            }
        }
        if dItem[mx as usize][my as usize] as libc::c_int > 0 as libc::c_int {
            ci = (dItem[mx as usize][my as usize] as libc::c_int - 1 as libc::c_int)
                as int8_t;
            if item[ci as usize]._iSelFlag as libc::c_int == ISEL_FLR as libc::c_int
                || item[ci as usize]._iSelFlag as libc::c_int == ISEL_ALL as libc::c_int
            {
                cursmx = mx;
                cursmy = my;
                cursitem = ci;
            }
        }
        if dItem[(mx + 1 as libc::c_int) as usize][(my + 1 as libc::c_int) as usize]
            as libc::c_int > 0 as libc::c_int
        {
            ci = (dItem[(mx + 1 as libc::c_int)
                as usize][(my + 1 as libc::c_int) as usize] as libc::c_int
                - 1 as libc::c_int) as int8_t;
            if item[ci as usize]._iSelFlag as libc::c_int >= ISEL_TOP as libc::c_int {
                cursmx = mx + 1 as libc::c_int;
                cursmy = my + 1 as libc::c_int;
                cursitem = ci;
            }
        }
        if cursitem as libc::c_int == -(1 as libc::c_int) {
            cursmx = mx;
            cursmy = my;
            CheckTrigForce();
            CheckTown();
            CheckRportal();
        }
    }
    if curs == IDENTIFY_CURS as libc::c_int {
        cursobj = -(1 as libc::c_int) as int8_t;
        cursmonst = -(1 as libc::c_int);
        cursitem = -(1 as libc::c_int) as int8_t;
        cursmx = mx;
        cursmy = my;
    }
    if cursmonst != -(1 as libc::c_int)
        && monster[cursmonst as usize]._mFlags & MFLAG_MKILLER as libc::c_int as uint32_t
            != 0 as libc::c_int as uint32_t
    {
        cursmonst = -(1 as libc::c_int);
    }
}
