use ::libc;
extern "C" {
    fn sprintf(_: *mut libc::c_char, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn strcpy(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn strcat(_: *mut libc::c_char, _: *const libc::c_char) -> *mut libc::c_char;
    fn PrintStringXY(
        x: libc::c_int,
        y: libc::c_int,
        pszStr: *const libc::c_char,
        col: int8_t,
    );
    fn DrawLine(
        a1: libc::c_int,
        b1: libc::c_int,
        a2: libc::c_int,
        b2: libc::c_int,
        clr: uint8_t,
    );
    fn DrawPoint(x: libc::c_int, y: libc::c_int, c: uint8_t);
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    static mut automapflag: bool32_t;
    static mut automapscale: libc::c_int;
    static mut automapview: [[uint8_t; 40]; 40];
    static mut chrflag: bool32_t;
    static mut sbookflag: bool32_t;
    static mut cursmx: libc::c_int;
    static mut cursmy: libc::c_int;
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut setlevel: uint8_t;
    static mut setlvlnum: uint8_t;
    static mut dungeon: [[uint8_t; 40]; 40];
    static mut ViewX: libc::c_int;
    static mut ViewY: libc::c_int;
    static mut ScrollInfo: ScrollStruct;
    static mut dFlags: [[int8_t; 112]; 112];
    static mut invflag: bool32_t;
    static mut gbMaxPlayers: uint8_t;
    static mut sgdwGameLoops: uint32_t;
    static mut gszGameName: [libc::c_char; 128];
    static mut gszGamePass: [libc::c_char; 128];
    static mut plr: [PlayerStruct; 4];
    static mut myplr: libc::c_int;
    static mut questlog: bool32_t;
    static mut SetLevelName: [*const libc::c_char; 6];
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __uint64_t = libc::c_ulong;
pub type C2RustUnnamed = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed = 32;
pub const MAXMICRO: C2RustUnnamed = 2048;
pub const SPEEDSIZE: C2RustUnnamed = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed = 64;
pub const MAXMREND: C2RustUnnamed = 128;
pub const MAXTILES: C2RustUnnamed = 2048;
pub const MDMAXY: C2RustUnnamed = 40;
pub const MDMAXX: C2RustUnnamed = 40;
pub const MAXDUNY: C2RustUnnamed = 112;
pub const MAXDUNX: C2RustUnnamed = 112;
pub const DMAXY: C2RustUnnamed = 112;
pub const DMAXX: C2RustUnnamed = 112;
pub const DIRTEDGED2: C2RustUnnamed = 16;
pub const DIRTEDGE: C2RustUnnamed = 32;
pub const NUMSLEVELS: C2RustUnnamed = 10;
pub const NUMLEVELS: C2RustUnnamed = 17;
pub const LVL4_START: C2RustUnnamed = 13;
pub const LVL3_START: C2RustUnnamed = 9;
pub const LVL2_START: C2RustUnnamed = 5;
pub const LVL1_START: C2RustUnnamed = 1;
pub const TLVL_START: C2RustUnnamed = 0;
pub const LVLLENGTH: C2RustUnnamed = 4;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const AUTOMAPY: C2RustUnnamed_0 = 40;
pub const AUTOMAPX: C2RustUnnamed_0 = 40;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const AUTOMAPST: C2RustUnnamed_1 = 31;
pub const AUTOMAPADD: C2RustUnnamed_1 = 5;
pub const AUTOMAPMAX: C2RustUnnamed_1 = 200;
pub const AUTOMAPMIN: C2RustUnnamed_1 = 50;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const LINE_HGT: C2RustUnnamed_2 = 15;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const AMPC: C2RustUnnamed_3 = 153;
pub const AMLC: C2RustUnnamed_3 = 200;
pub const AMDC: C2RustUnnamed_3 = 144;
pub type C2RustUnnamed_4 = libc::c_uint;
pub const AMS_NONER: C2RustUnnamed_4 = 42;
pub const AMS_NONEL: C2RustUnnamed_4 = 21;
pub const AMS_STAIRS: C2RustUnnamed_4 = 128;
pub const AMS_DIRT: C2RustUnnamed_4 = 64;
pub const AMS_GRATER: C2RustUnnamed_4 = 32;
pub const AMS_GRATEL: C2RustUnnamed_4 = 16;
pub const AMS_ARCHR: C2RustUnnamed_4 = 8;
pub const AMS_ARCHL: C2RustUnnamed_4 = 4;
pub const AMS_DOORR: C2RustUnnamed_4 = 2;
pub const AMS_DOORL: C2RustUnnamed_4 = 1;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const AMS_DIRTLR: C2RustUnnamed_5 = 16391;
pub const AMS_DIRT8: C2RustUnnamed_5 = 16384;
pub const AutomapTypeWallNeWallNw: C2RustUnnamed_5 = 7;
pub const AutomapTypeWallEndSe: C2RustUnnamed_5 = 6;
pub const AutomapTypeWallEndSw: C2RustUnnamed_5 = 5;
pub const AutomapTypeWallSwWallSe: C2RustUnnamed_5 = 4;
pub const AutomapTypeWallSe: C2RustUnnamed_5 = 3;
pub const AutomapTypeWallSw: C2RustUnnamed_5 = 2;
pub const AutomapTypeColumn: C2RustUnnamed_5 = 1;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const ICOLOR_GOLD: C2RustUnnamed_6 = 3;
pub const ICOLOR_RED: C2RustUnnamed_6 = 2;
pub const ICOLOR_BLUE: C2RustUnnamed_6 = 1;
pub const ICOLOR_WHITE: C2RustUnnamed_6 = 0;
pub type C2RustUnnamed_7 = libc::c_uint;
pub const M_DIRUL: C2RustUnnamed_7 = 3;
pub const M_DIRL: C2RustUnnamed_7 = 2;
pub const M_DIRDL: C2RustUnnamed_7 = 1;
pub const M_DIRD: C2RustUnnamed_7 = 0;
pub const M_DIRDR: C2RustUnnamed_7 = 7;
pub const M_DIRR: C2RustUnnamed_7 = 6;
pub const M_DIRUR: C2RustUnnamed_7 = 5;
pub const M_DIRU: C2RustUnnamed_7 = 4;
pub const DIR_UL: C2RustUnnamed_7 = 3;
pub const DIR_L: C2RustUnnamed_7 = 2;
pub const DIR_DL: C2RustUnnamed_7 = 1;
pub const DIR_D: C2RustUnnamed_7 = 0;
pub const DIR_DR: C2RustUnnamed_7 = 7;
pub const DIR_R: C2RustUnnamed_7 = 6;
pub const DIR_UR: C2RustUnnamed_7 = 5;
pub const DIR_U: C2RustUnnamed_7 = 4;
pub type C2RustUnnamed_8 = libc::c_uint;
pub const SETP_TMASK: C2RustUnnamed_8 = 191;
pub const SETP_TEMP: C2RustUnnamed_8 = 64;
pub const SETP_MASK: C2RustUnnamed_8 = 127;
pub const SETP_BIT: C2RustUnnamed_8 = 128;
pub const BFMASK_MISSILE: C2RustUnnamed_8 = 254;
pub const BFMASK_SETPC: C2RustUnnamed_8 = 247;
pub const BFMASK_MONSTLR: C2RustUnnamed_8 = 239;
pub const BFMASK_PLRLR: C2RustUnnamed_8 = 223;
pub const BFMASK_VISIBLE: C2RustUnnamed_8 = 191;
pub const BFMASK_AUTOMAP: C2RustUnnamed_8 = 127;
pub const BFLAG_MISSILE: C2RustUnnamed_8 = 1;
pub const BFLAG_MONSTACTIVE: C2RustUnnamed_8 = 2;
pub const BFLAG_DEADPLR: C2RustUnnamed_8 = 4;
pub const BFLAG_SETPC: C2RustUnnamed_8 = 8;
pub const BFLAG_MONSTLR: C2RustUnnamed_8 = 16;
pub const BFLAG_PLRLR: C2RustUnnamed_8 = 32;
pub const BFLAG_VISIBLE: C2RustUnnamed_8 = 64;
pub const BFLAG_AUTOMAP: C2RustUnnamed_8 = 128;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ScrollStruct {
    pub _sxoff: libc::c_int,
    pub _syoff: libc::c_int,
    pub _sdx: libc::c_int,
    pub _sdy: libc::c_int,
    pub _sdir: libc::c_int,
}
pub type C2RustUnnamed_9 = libc::c_uint;
pub const PM_QUIT: C2RustUnnamed_9 = 11;
pub const PM_NEWLVL: C2RustUnnamed_9 = 10;
pub const PM_SPELL: C2RustUnnamed_9 = 9;
pub const PM_DEATH: C2RustUnnamed_9 = 8;
pub const PM_GOTHIT: C2RustUnnamed_9 = 7;
pub const PM_BLOCK: C2RustUnnamed_9 = 6;
pub const PM_RATTACK: C2RustUnnamed_9 = 5;
pub const PM_ATTACK: C2RustUnnamed_9 = 4;
pub const PM_WALK3: C2RustUnnamed_9 = 3;
pub const PM_WALK2: C2RustUnnamed_9 = 2;
pub const PM_WALK: C2RustUnnamed_9 = 1;
pub const PM_STAND: C2RustUnnamed_9 = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct ItemStruct {
    pub _iSeed: libc::c_int,
    pub _iCreateInfo: uint16_t,
    pub _itype: libc::c_int,
    pub _ix: libc::c_int,
    pub _iy: libc::c_int,
    pub _iAnimFlag: bool32_t,
    pub _iAnimData: *mut uint8_t,
    pub _iAnimLen: libc::c_int,
    pub _iAnimFrame: libc::c_int,
    pub _iAnimWidth: int32_t,
    pub _iAnimWidth2: int32_t,
    pub _iInvalid: bool32_t,
    pub _iSelFlag: int8_t,
    pub _iPostDraw: bool32_t,
    pub _iIdentified: bool32_t,
    pub _iMagical: int8_t,
    pub _iName: [libc::c_char; 64],
    pub _iIName: [libc::c_char; 64],
    pub _iLoc: int8_t,
    pub _iClass: int8_t,
    pub _iCurs: libc::c_int,
    pub _ivalue: libc::c_int,
    pub _iIvalue: libc::c_int,
    pub _iMinDam: libc::c_int,
    pub _iMaxDam: libc::c_int,
    pub _iAC: libc::c_int,
    pub _iFlags: int32_t,
    pub _iMiscId: libc::c_int,
    pub _iSpell: libc::c_int,
    pub _iCharges: libc::c_int,
    pub _iMaxCharges: libc::c_int,
    pub _iDurability: libc::c_int,
    pub _iMaxDur: libc::c_int,
    pub _iPLDam: libc::c_int,
    pub _iPLToHit: libc::c_int,
    pub _iPLAC: libc::c_int,
    pub _iPLStr: libc::c_int,
    pub _iPLMag: libc::c_int,
    pub _iPLDex: libc::c_int,
    pub _iPLVit: libc::c_int,
    pub _iPLFR: libc::c_int,
    pub _iPLLR: libc::c_int,
    pub _iPLMR: libc::c_int,
    pub _iPLMana: int32_t,
    pub _iPLHP: int32_t,
    pub _iPLDamMod: libc::c_int,
    pub _iPLGetHit: libc::c_int,
    pub _iPLLight: libc::c_int,
    pub _iSplLvlAdd: int8_t,
    pub _iRequest: int8_t,
    pub _iUid: libc::c_int,
    pub _iFMinDam: libc::c_int,
    pub _iFMaxDam: libc::c_int,
    pub _iLMinDam: libc::c_int,
    pub _iLMaxDam: libc::c_int,
    pub _iPLEnAc: libc::c_int,
    pub _iPrePower: int8_t,
    pub _iSufPower: int8_t,
    pub _iVAdd1: libc::c_int,
    pub _iVMult1: libc::c_int,
    pub _iVAdd2: libc::c_int,
    pub _iVMult2: libc::c_int,
    pub _iMinStr: int8_t,
    pub _iMinMag: uint8_t,
    pub _iMinDex: int8_t,
    pub _iStatFlag: bool32_t,
    pub IDidx: libc::c_int,
    pub _oldlight: int8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PlayerStruct {
    pub _pmode: libc::c_int,
    pub walkpath: [int8_t; 25],
    pub plractive: uint8_t,
    pub destAction: libc::c_int,
    pub destParam1: libc::c_int,
    pub destParam2: libc::c_int,
    pub destParam3: libc::c_int,
    pub destParam4: libc::c_int,
    pub plrlevel: libc::c_int,
    pub _px: libc::c_int,
    pub _py: libc::c_int,
    pub _pfutx: libc::c_int,
    pub _pfuty: libc::c_int,
    pub _ptargx: libc::c_int,
    pub _ptargy: libc::c_int,
    pub _pownerx: libc::c_int,
    pub _pownery: libc::c_int,
    pub _poldx: libc::c_int,
    pub _poldy: libc::c_int,
    pub _pxoff: int32_t,
    pub _pyoff: int32_t,
    pub _pxvel: int32_t,
    pub _pyvel: int32_t,
    pub _pdir: libc::c_int,
    pub _nextdir: libc::c_int,
    pub _pgfxnum: libc::c_int,
    pub _pAnimData: *mut uint8_t,
    pub _pAnimDelay: libc::c_int,
    pub _pAnimCnt: libc::c_int,
    pub _pAnimLen: libc::c_int,
    pub _pAnimFrame: libc::c_int,
    pub _pAnimWidth: int32_t,
    pub _pAnimWidth2: int32_t,
    pub _peflag: libc::c_int,
    pub _plid: libc::c_int,
    pub _pvid: libc::c_int,
    pub _pSpell: libc::c_int,
    pub _pSplType: int8_t,
    pub _pSplFrom: int8_t,
    pub _pTSpell: libc::c_int,
    pub _pTSplType: int8_t,
    pub _pRSpell: libc::c_int,
    pub _pRSplType: int8_t,
    pub _pSBkSpell: libc::c_int,
    pub _pSBkSplType: int8_t,
    pub _pSplLvl: [int8_t; 64],
    pub align_0101: [uint8_t; 7],
    pub _pMemSpells: uint64_t,
    pub _pAblSpells: uint64_t,
    pub _pScrlSpells: uint64_t,
    pub _pSpellFlags: int8_t,
    pub _pSplHotKey: [libc::c_int; 4],
    pub _pSplTHotKey: [int8_t; 4],
    pub _pwtype: libc::c_int,
    pub _pBlockFlag: uint8_t,
    pub _pInvincible: uint8_t,
    pub _pLightRad: int8_t,
    pub _pLvlChanging: uint8_t,
    pub _pName: [libc::c_char; 32],
    pub _pClass: int8_t,
    pub _pStrength: libc::c_int,
    pub _pBaseStr: libc::c_int,
    pub _pMagic: libc::c_int,
    pub _pBaseMag: libc::c_int,
    pub _pDexterity: libc::c_int,
    pub _pBaseDex: libc::c_int,
    pub _pVitality: libc::c_int,
    pub _pBaseVit: libc::c_int,
    pub _pStatPts: libc::c_int,
    pub _pDamageMod: libc::c_int,
    pub _pBaseToBlk: libc::c_int,
    pub _pHPBase: int32_t,
    pub _pMaxHPBase: int32_t,
    pub _pHitPoints: int32_t,
    pub _pMaxHP: int32_t,
    pub _pHPPer: libc::c_int,
    pub _pManaBase: int32_t,
    pub _pMaxManaBase: int32_t,
    pub _pMana: int32_t,
    pub _pMaxMana: int32_t,
    pub _pManaPer: libc::c_int,
    pub _pLevel: int8_t,
    pub _pMaxLvl: int8_t,
    pub _pExperience: int32_t,
    pub _pMaxExp: int32_t,
    pub _pNextExper: int32_t,
    pub _pArmorClass: int8_t,
    pub _pMagResist: int8_t,
    pub _pFireResist: int8_t,
    pub _pLghtResist: int8_t,
    pub _pGold: int32_t,
    pub _pInfraFlag: bool32_t,
    pub _pVar1: int32_t,
    pub _pVar2: int32_t,
    pub _pVar3: int32_t,
    pub _pVar4: int32_t,
    pub _pVar5: int32_t,
    pub _pVar6: int32_t,
    pub _pVar7: int32_t,
    pub _pVar8: int32_t,
    pub _pLvlVisited: [uint8_t; 17],
    pub _pSLvlVisited: [uint8_t; 17],
    pub _pGFXLoad: libc::c_int,
    pub _pNAnim: [*mut uint8_t; 8],
    pub _pNFrames: libc::c_int,
    pub _pNWidth: int32_t,
    pub _pWAnim: [*mut uint8_t; 8],
    pub _pWFrames: libc::c_int,
    pub _pWWidth: int32_t,
    pub _pAAnim: [*mut uint8_t; 8],
    pub _pAFrames: libc::c_int,
    pub _pAWidth: int32_t,
    pub _pAFNum: libc::c_int,
    pub _pLAnim: [*mut uint8_t; 8],
    pub _pFAnim: [*mut uint8_t; 8],
    pub _pTAnim: [*mut uint8_t; 8],
    pub _pSFrames: libc::c_int,
    pub _pSWidth: int32_t,
    pub _pSFNum: libc::c_int,
    pub _pHAnim: [*mut uint8_t; 8],
    pub _pHFrames: libc::c_int,
    pub _pHWidth: int32_t,
    pub _pDAnim: [*mut uint8_t; 8],
    pub _pDFrames: libc::c_int,
    pub _pDWidth: int32_t,
    pub _pBAnim: [*mut uint8_t; 8],
    pub _pBFrames: libc::c_int,
    pub _pBWidth: int32_t,
    pub InvBody: [ItemStruct; 7],
    pub InvList: [ItemStruct; 40],
    pub _pNumInv: libc::c_int,
    pub InvGrid: [int8_t; 40],
    pub SpdList: [ItemStruct; 8],
    pub HoldItem: ItemStruct,
    pub _pIMinDam: libc::c_int,
    pub _pIMaxDam: libc::c_int,
    pub _pIAC: libc::c_int,
    pub _pIBonusDam: libc::c_int,
    pub _pIBonusToHit: libc::c_int,
    pub _pIBonusAC: libc::c_int,
    pub _pIBonusDamMod: libc::c_int,
    pub align_5444: [uint8_t; 4],
    pub _pISpells: uint64_t,
    pub _pIFlags: int32_t,
    pub _pIGetHit: libc::c_int,
    pub _pISplLvlAdd: int8_t,
    pub _pISplCost: int8_t,
    pub _pISplDur: libc::c_int,
    pub _pIEnAc: libc::c_int,
    pub _pIFMinDam: libc::c_int,
    pub _pIFMaxDam: libc::c_int,
    pub _pILMinDam: libc::c_int,
    pub _pILMaxDam: libc::c_int,
    pub _pOilType: libc::c_int,
    pub pTownWarps: uint8_t,
    pub pDungMsgs: uint8_t,
    pub pLvlLoad: uint8_t,
    pub pBattleNet: uint8_t,
    pub pManaShield: uint8_t,
    pub bReserved6: uint8_t,
    pub bReserved7: uint8_t,
    pub bReserved8: uint8_t,
    pub wReserved1: uint16_t,
    pub wReserved2: uint16_t,
    pub wReserved3: uint16_t,
    pub wReserved4: uint16_t,
    pub wReserved5: uint16_t,
    pub wReserved6: uint16_t,
    pub wReserved7: uint16_t,
    pub wReserved8: uint16_t,
    pub pDiabloKillLevel: uint32_t,
    pub dwReserved2: uint32_t,
    pub dwReserved3: uint32_t,
    pub dwReserved4: uint32_t,
    pub dwReserved5: uint32_t,
    pub dwReserved6: uint32_t,
    pub dwReserved7: uint32_t,
    pub dwReserved8: uint32_t,
    pub _pNData: *mut uint8_t,
    pub _pWData: *mut uint8_t,
    pub _pAData: *mut uint8_t,
    pub _pLData: *mut uint8_t,
    pub _pFData: *mut uint8_t,
    pub _pTData: *mut uint8_t,
    pub _pHData: *mut uint8_t,
    pub _pDData: *mut uint8_t,
    pub _pBData: *mut uint8_t,
}
#[no_mangle]
pub static mut automaps1: libc::c_int = 0;
#[no_mangle]
pub static mut automaps2: libc::c_int = 0;
#[no_mangle]
pub static mut automaps3: libc::c_int = 0;
#[no_mangle]
pub static mut automaps4: libc::c_int = 0;
#[no_mangle]
pub static mut automaps5: libc::c_int = 0;
#[no_mangle]
pub static mut automapx: libc::c_int = 0;
#[no_mangle]
pub static mut automapy: libc::c_int = 0;
#[no_mangle]
pub static mut amxadd: libc::c_int = 0;
#[no_mangle]
pub static mut amyadd: libc::c_int = 0;
#[no_mangle]
pub static mut automapstbl: [uint8_t; 31] = [0; 31];
#[no_mangle]
pub static mut automaptype: [uint16_t; 512] = [0; 512];
#[no_mangle]
pub unsafe extern "C" fn InitAutomapOnce() {
    automapflag = 0 as libc::c_int as bool32_t;
    automapscale = AUTOMAPMIN as libc::c_int;
    automaps1 = (automapscale << 6 as libc::c_int) / 100 as libc::c_int;
    automaps2 = automaps1 >> 1 as libc::c_int;
    automaps3 = automaps2 >> 1 as libc::c_int;
    automaps4 = automaps3 >> 1 as libc::c_int;
    automaps5 = automaps4 >> 1 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn InitAutomap() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut a: libc::c_int = 0;
    let mut v: libc::c_int = 0;
    let mut dwTiles: uint32_t = 0;
    let mut pAFile: *mut uint8_t = 0 as *mut uint8_t;
    let mut pTmp: *mut uint8_t = 0 as *mut uint8_t;
    a = AUTOMAPMIN as libc::c_int;
    i = 0 as libc::c_int;
    while i < AUTOMAPST as libc::c_int {
        v = (a << 6 as libc::c_int) / 100 as libc::c_int;
        automapstbl[i
            as usize] = ((320 as libc::c_int / v << 1 as libc::c_int) + 1 as libc::c_int)
            as uint8_t;
        if 320 as libc::c_int % v != 0 as libc::c_int {
            automapstbl[i as usize] = (automapstbl[i as usize]).wrapping_add(1);
            automapstbl[i as usize];
        }
        if 320 as libc::c_int % v >= (a << 5 as libc::c_int) / 100 as libc::c_int {
            automapstbl[i as usize] = (automapstbl[i as usize]).wrapping_add(1);
            automapstbl[i as usize];
        }
        a += AUTOMAPADD as libc::c_int;
        i += 1;
        i;
    }
    memset(
        automaptype.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[uint16_t; 512]>() as libc::c_ulong,
    );
    match leveltype as libc::c_int {
        1 => {
            pAFile = LoadFileInMem(
                b"Levels\\L1Data\\L1.AMP\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
            dwTiles = dwTiles / 2 as libc::c_int as uint32_t;
        }
        2 => {
            pAFile = LoadFileInMem(
                b"Levels\\L2Data\\L2.AMP\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
            dwTiles = dwTiles / 2 as libc::c_int as uint32_t;
        }
        3 => {
            pAFile = LoadFileInMem(
                b"Levels\\L3Data\\L3.AMP\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
            dwTiles = dwTiles / 2 as libc::c_int as uint32_t;
        }
        4 => {
            pAFile = LoadFileInMem(
                b"Levels\\L4Data\\L4.AMP\0" as *const u8 as *const libc::c_char,
                &mut dwTiles,
            );
            dwTiles = dwTiles / 2 as libc::c_int as uint32_t;
        }
        _ => return,
    }
    pTmp = pAFile;
    let mut d: uint32_t = 1 as libc::c_int as uint32_t;
    while d <= dwTiles {
        let fresh0 = pTmp;
        pTmp = pTmp.offset(1);
        let mut b1: uint8_t = *fresh0;
        let fresh1 = pTmp;
        pTmp = pTmp.offset(1);
        let mut b2: uint8_t = *fresh1;
        automaptype[d
            as usize] = (b1 as libc::c_int + ((b2 as libc::c_int) << 8 as libc::c_int))
            as uint16_t;
        d = d.wrapping_add(1);
        d;
    }
    let mut p__p: *mut libc::c_void = pAFile as *mut libc::c_void;
    pAFile = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    memset(
        automapview.as_mut_ptr() as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<[[uint8_t; 40]; 40]>() as libc::c_ulong,
    );
    j = 0 as libc::c_int;
    while j < DMAXY as libc::c_int {
        i = 0 as libc::c_int;
        while i < DMAXX as libc::c_int {
            dFlags[i
                as usize][j
                as usize] = (dFlags[i as usize][j as usize] as libc::c_int
                & BFMASK_AUTOMAP as libc::c_int) as int8_t;
            i += 1;
            i;
        }
        j += 1;
        j;
    }
}
#[no_mangle]
pub unsafe extern "C" fn StartAutomap() {
    amxadd = 0 as libc::c_int;
    amyadd = 0 as libc::c_int;
    automapflag = 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn AutomapUp() {
    amxadd -= 1;
    amxadd;
    amyadd -= 1;
    amyadd;
}
#[no_mangle]
pub unsafe extern "C" fn AutomapDown() {
    amxadd += 1;
    amxadd;
    amyadd += 1;
    amyadd;
}
#[no_mangle]
pub unsafe extern "C" fn AutomapLeft() {
    amxadd -= 1;
    amxadd;
    amyadd += 1;
    amyadd;
}
#[no_mangle]
pub unsafe extern "C" fn AutomapRight() {
    amxadd += 1;
    amxadd;
    amyadd -= 1;
    amyadd;
}
#[no_mangle]
pub unsafe extern "C" fn AutomapZoomIn() {
    if automapscale < AUTOMAPMAX as libc::c_int {
        automapscale += AUTOMAPADD as libc::c_int;
        automaps1 = (automapscale << 6 as libc::c_int) / 100 as libc::c_int;
        automaps2 = automaps1 >> 1 as libc::c_int;
        automaps3 = automaps2 >> 1 as libc::c_int;
        automaps4 = automaps3 >> 1 as libc::c_int;
        automaps5 = automaps4 >> 1 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn AutomapZoomOut() {
    if automapscale > AUTOMAPMIN as libc::c_int {
        automapscale -= AUTOMAPADD as libc::c_int;
        automaps1 = (automapscale << 6 as libc::c_int) / 100 as libc::c_int;
        automaps2 = automaps1 >> 1 as libc::c_int;
        automaps3 = automaps2 >> 1 as libc::c_int;
        automaps4 = automaps3 >> 1 as libc::c_int;
        automaps5 = automaps4 >> 1 as libc::c_int;
    }
}
unsafe extern "C" fn DrawAMShape(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut shape: uint16_t,
) {
    let mut x1: libc::c_int = 0;
    let mut y1: libc::c_int = 0;
    let mut x2: libc::c_int = 0;
    let mut y2: libc::c_int = 0;
    let mut f: uint8_t = 0;
    let mut lwf: bool32_t = 0;
    let mut rwf: bool32_t = 0;
    let mut llwf: bool32_t = 0;
    let mut lrwf: bool32_t = 0;
    f = (shape as libc::c_int >> 8 as libc::c_int & 0xff as libc::c_int) as uint8_t;
    if f as libc::c_int & AMS_DIRT as libc::c_int != 0 {
        DrawPoint(x, y, AMLC as libc::c_int as uint8_t);
        DrawPoint(x - automaps4, y - automaps5, AMLC as libc::c_int as uint8_t);
        DrawPoint(x - automaps4, y + automaps5, AMLC as libc::c_int as uint8_t);
        DrawPoint(x + automaps4, y - automaps5, AMLC as libc::c_int as uint8_t);
        DrawPoint(x + automaps4, y + automaps5, AMLC as libc::c_int as uint8_t);
        DrawPoint(x - automaps3, y, AMLC as libc::c_int as uint8_t);
        DrawPoint(x + automaps3, y, AMLC as libc::c_int as uint8_t);
        DrawPoint(x, y - automaps4, AMLC as libc::c_int as uint8_t);
        DrawPoint(x, y + automaps4, AMLC as libc::c_int as uint8_t);
        DrawPoint(
            x - automaps2 + automaps4,
            y + automaps5,
            AMLC as libc::c_int as uint8_t,
        );
        DrawPoint(
            x + automaps2 - automaps4,
            y + automaps5,
            AMLC as libc::c_int as uint8_t,
        );
        DrawPoint(x - automaps3, y + automaps4, AMLC as libc::c_int as uint8_t);
        DrawPoint(x + automaps3, y + automaps4, AMLC as libc::c_int as uint8_t);
        DrawPoint(
            x - automaps4,
            y + automaps3 - automaps5,
            AMLC as libc::c_int as uint8_t,
        );
        DrawPoint(
            x + automaps4,
            y + automaps3 - automaps5,
            AMLC as libc::c_int as uint8_t,
        );
        DrawPoint(x, y + automaps3, AMLC as libc::c_int as uint8_t);
    }
    if f as libc::c_int & AMS_STAIRS as libc::c_int != 0 {
        DrawLine(
            x - automaps4,
            y - automaps4 - automaps5,
            x + automaps3 + automaps4,
            y + automaps5,
            AMDC as libc::c_int as uint8_t,
        );
        DrawLine(
            x - automaps3,
            y - automaps4,
            x + automaps3,
            y + automaps4,
            AMDC as libc::c_int as uint8_t,
        );
        DrawLine(
            x - automaps3 - automaps4,
            y - automaps5,
            x + automaps4,
            y + automaps4 + automaps5,
            AMDC as libc::c_int as uint8_t,
        );
        DrawLine(x - automaps2, y, x, y + automaps3, AMDC as libc::c_int as uint8_t);
    }
    lwf = 0 as libc::c_int as bool32_t;
    rwf = 0 as libc::c_int as bool32_t;
    llwf = 0 as libc::c_int as bool32_t;
    lrwf = 0 as libc::c_int as bool32_t;
    match shape as libc::c_int & 0xf as libc::c_int {
        1 => {
            x1 = x - automaps3;
            y1 = y - automaps3;
            x2 = x1 + automaps2;
            y2 = y - automaps4;
            DrawLine(x, y1, x1, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y1, x2, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y, x1, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y, x2, y2, AMLC as libc::c_int as uint8_t);
        }
        2 | 5 => {
            lwf = 1 as libc::c_int as bool32_t;
        }
        3 | 6 => {
            rwf = 1 as libc::c_int as bool32_t;
        }
        4 => {
            lwf = 1 as libc::c_int as bool32_t;
            rwf = 1 as libc::c_int as bool32_t;
        }
        8 => {
            lwf = 1 as libc::c_int as bool32_t;
            llwf = 1 as libc::c_int as bool32_t;
        }
        9 => {
            rwf = 1 as libc::c_int as bool32_t;
            lrwf = 1 as libc::c_int as bool32_t;
        }
        10 => {
            llwf = 1 as libc::c_int as bool32_t;
        }
        11 => {
            lrwf = 1 as libc::c_int as bool32_t;
        }
        12 => {
            llwf = 1 as libc::c_int as bool32_t;
            lrwf = 1 as libc::c_int as bool32_t;
        }
        _ => {}
    }
    if lwf != 0 {
        if f as libc::c_int & AMS_DOORL as libc::c_int != 0 {
            x1 = x - automaps2;
            x2 = x - automaps3;
            y1 = y - automaps3;
            y2 = y - automaps4;
            DrawLine(
                x,
                y1,
                x - automaps4,
                y1 + automaps5,
                AMLC as libc::c_int as uint8_t,
            );
            DrawLine(
                x1,
                y,
                x1 + automaps4,
                y - automaps5,
                AMLC as libc::c_int as uint8_t,
            );
            DrawLine(x2, y1, x1, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x2, y1, x, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x2, y, x1, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x2, y, x, y2, AMDC as libc::c_int as uint8_t);
        }
        if f as libc::c_int & AMS_GRATEL as libc::c_int != 0 {
            DrawLine(
                x - automaps3,
                y - automaps4,
                x - automaps2,
                y,
                AMLC as libc::c_int as uint8_t,
            );
            f = (f as libc::c_int | AMS_ARCHL as libc::c_int) as uint8_t;
        }
        if f as libc::c_int & AMS_ARCHL as libc::c_int != 0 {
            x1 = x - automaps3;
            y1 = y - automaps3;
            x2 = x1 + automaps2;
            y2 = y - automaps4;
            DrawLine(x, y1, x1, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y1, x2, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y, x1, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y, x2, y2, AMLC as libc::c_int as uint8_t);
        }
        if f as libc::c_int & AMS_NONEL as libc::c_int == 0 as libc::c_int {
            DrawLine(x, y - automaps3, x - automaps2, y, AMLC as libc::c_int as uint8_t);
        }
    }
    if rwf != 0 {
        if f as libc::c_int & AMS_DOORR as libc::c_int != 0 {
            x1 = x + automaps3;
            x2 = x + automaps2;
            y1 = y - automaps3;
            y2 = y - automaps4;
            DrawLine(
                x,
                y1,
                x + automaps4,
                y1 + automaps5,
                AMLC as libc::c_int as uint8_t,
            );
            DrawLine(
                x2,
                y,
                x2 - automaps4,
                y - automaps5,
                AMLC as libc::c_int as uint8_t,
            );
            DrawLine(x1, y1, x, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x1, y1, x2, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x1, y, x, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x1, y, x2, y2, AMDC as libc::c_int as uint8_t);
        }
        if f as libc::c_int & AMS_GRATER as libc::c_int != 0 {
            DrawLine(
                x + automaps3,
                y - automaps4,
                x + automaps2,
                y,
                AMLC as libc::c_int as uint8_t,
            );
            f = (f as libc::c_int | AMS_ARCHR as libc::c_int) as uint8_t;
        }
        if f as libc::c_int & AMS_ARCHR as libc::c_int != 0 {
            x1 = x - automaps3;
            y1 = y - automaps3;
            x2 = x1 + automaps2;
            y2 = y - automaps4;
            DrawLine(x, y1, x1, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y1, x2, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y, x1, y2, AMLC as libc::c_int as uint8_t);
            DrawLine(x, y, x2, y2, AMLC as libc::c_int as uint8_t);
        }
        if f as libc::c_int & AMS_NONER as libc::c_int == 0 as libc::c_int {
            DrawLine(x, y - automaps3, x + automaps2, y, AMLC as libc::c_int as uint8_t);
        }
    }
    if llwf != 0 {
        if f as libc::c_int & AMS_DOORL as libc::c_int != 0 {
            x1 = x - automaps2;
            x2 = x - automaps3;
            y1 = y + automaps3;
            y2 = y + automaps4;
            DrawLine(
                x,
                y1,
                x - automaps4,
                y1 - automaps5,
                AMLC as libc::c_int as uint8_t,
            );
            DrawLine(
                x1,
                y,
                x1 + automaps4,
                y + automaps5,
                AMLC as libc::c_int as uint8_t,
            );
            DrawLine(x2, y1, x1, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x2, y1, x, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x2, y, x1, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x2, y, x, y2, AMDC as libc::c_int as uint8_t);
        } else {
            DrawLine(x, y + automaps3, x - automaps2, y, AMLC as libc::c_int as uint8_t);
        }
    }
    if lrwf != 0 {
        if f as libc::c_int & AMS_DOORR as libc::c_int != 0 {
            x1 = x + automaps3;
            x2 = x + automaps2;
            y1 = y + automaps3;
            y2 = y + automaps4;
            DrawLine(
                x,
                y1,
                x + automaps4,
                y1 - automaps5,
                AMLC as libc::c_int as uint8_t,
            );
            DrawLine(
                x2,
                y,
                x2 - automaps4,
                y + automaps5,
                AMLC as libc::c_int as uint8_t,
            );
            DrawLine(x1, y1, x, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x1, y1, x2, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x1, y, x, y2, AMDC as libc::c_int as uint8_t);
            DrawLine(x1, y, x2, y2, AMDC as libc::c_int as uint8_t);
        } else {
            DrawLine(x, y + automaps3, x + automaps2, y, AMLC as libc::c_int as uint8_t);
        }
    }
}
unsafe extern "C" fn DrawAutomapPlr() {
    let mut px: libc::c_int = 0;
    let mut py: libc::c_int = 0;
    let mut dx: libc::c_int = 0;
    let mut dy: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    if plr[myplr as usize]._pmode == PM_WALK3 as libc::c_int {
        px = plr[myplr as usize]._pfutx;
        py = plr[myplr as usize]._pfuty;
        if plr[myplr as usize]._pdir == DIR_L as libc::c_int {
            px += 1;
            px;
        } else {
            py += 1;
            py;
        }
    } else {
        px = plr[myplr as usize]._px;
        py = plr[myplr as usize]._py;
    }
    dx = px - ViewX - (amxadd << 1 as libc::c_int);
    dy = py - ViewY - (amyadd << 1 as libc::c_int);
    x = 384 as libc::c_int + dx * automaps3 - dy * automaps3;
    y = 336 as libc::c_int + dx * automaps4 + dy * automaps4;
    x
        += plr[myplr as usize]._pxoff * automapscale / 100 as libc::c_int
            >> 1 as libc::c_int;
    y
        += plr[myplr as usize]._pyoff * automapscale / 100 as libc::c_int
            >> 1 as libc::c_int;
    x += ScrollInfo._sxoff * automapscale / 100 as libc::c_int >> 1 as libc::c_int;
    y += ScrollInfo._syoff * automapscale / 100 as libc::c_int >> 1 as libc::c_int;
    if invflag != 0 || sbookflag != 0 {
        x -= 160 as libc::c_int;
    }
    if chrflag != 0 || questlog != 0 {
        x += 160 as libc::c_int;
    }
    y -= automaps4;
    match plr[myplr as usize]._pdir {
        4 => {
            DrawLine(x, y, x, y - automaps3, AMPC as libc::c_int as uint8_t);
            DrawLine(
                x,
                y - automaps3,
                x - automaps5,
                y - automaps4,
                AMPC as libc::c_int as uint8_t,
            );
            DrawLine(
                x,
                y - automaps3,
                x + automaps5,
                y - automaps4,
                AMPC as libc::c_int as uint8_t,
            );
        }
        5 => {
            DrawLine(x, y, x + automaps3, y - automaps4, AMPC as libc::c_int as uint8_t);
            DrawLine(
                x + automaps3,
                y - automaps4,
                x + automaps4,
                y - automaps4,
                AMPC as libc::c_int as uint8_t,
            );
            DrawLine(
                x + automaps3,
                y - automaps4,
                x + automaps4 + automaps5,
                y,
                AMPC as libc::c_int as uint8_t,
            );
        }
        6 => {
            DrawLine(x, y, x + automaps3, y, AMPC as libc::c_int as uint8_t);
            DrawLine(
                x + automaps3,
                y,
                x + automaps4,
                y - automaps5,
                AMPC as libc::c_int as uint8_t,
            );
            DrawLine(
                x + automaps3,
                y,
                x + automaps4,
                y + automaps5,
                AMPC as libc::c_int as uint8_t,
            );
        }
        7 => {
            DrawLine(x, y, x + automaps3, y + automaps4, AMPC as libc::c_int as uint8_t);
            DrawLine(
                x + automaps3,
                y + automaps4,
                x + automaps4 + automaps5,
                y,
                AMPC as libc::c_int as uint8_t,
            );
            DrawLine(
                x + automaps3,
                y + automaps4,
                x + automaps4,
                y + automaps4,
                AMPC as libc::c_int as uint8_t,
            );
        }
        0 => {
            DrawLine(x, y, x, y + automaps3, AMPC as libc::c_int as uint8_t);
            DrawLine(
                x,
                y + automaps3,
                x + automaps5,
                y + automaps4,
                AMPC as libc::c_int as uint8_t,
            );
            DrawLine(
                x,
                y + automaps3,
                x - automaps5,
                y + automaps4,
                AMPC as libc::c_int as uint8_t,
            );
        }
        1 => {
            DrawLine(x, y, x - automaps3, y + automaps4, AMPC as libc::c_int as uint8_t);
            DrawLine(
                x - automaps3,
                y + automaps4,
                x - automaps4 - automaps5,
                y,
                AMPC as libc::c_int as uint8_t,
            );
            DrawLine(
                x - automaps3,
                y + automaps4,
                x - automaps4,
                y + automaps4,
                AMPC as libc::c_int as uint8_t,
            );
        }
        2 => {
            DrawLine(x, y, x - automaps3, y, AMPC as libc::c_int as uint8_t);
            DrawLine(
                x - automaps3,
                y,
                x - automaps4,
                y - automaps5,
                AMPC as libc::c_int as uint8_t,
            );
            DrawLine(
                x - automaps3,
                y,
                x - automaps4,
                y + automaps5,
                AMPC as libc::c_int as uint8_t,
            );
        }
        3 => {
            DrawLine(x, y, x - automaps3, y - automaps4, AMPC as libc::c_int as uint8_t);
            DrawLine(
                x - automaps3,
                y - automaps4,
                x - automaps4,
                y - automaps4,
                AMPC as libc::c_int as uint8_t,
            );
            DrawLine(
                x - automaps3,
                y - automaps4,
                x - automaps4 - automaps5,
                y,
                AMPC as libc::c_int as uint8_t,
            );
        }
        _ => {}
    };
}
unsafe extern "C" fn GetAutomapType(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut view: bool32_t,
) -> uint16_t {
    let mut rv: uint16_t = 0;
    let mut t: uint16_t = 0;
    if view != 0 && x == -(1 as libc::c_int) && y >= 0 as libc::c_int
        && y < AUTOMAPY as libc::c_int
        && automapview[0 as libc::c_int as usize][y as usize] as libc::c_int != 0
    {
        if GetAutomapType(0 as libc::c_int, y, 0 as libc::c_int as bool32_t)
            as libc::c_int & AMS_DIRT8 as libc::c_int != 0
        {
            return 0 as libc::c_int as uint16_t
        } else {
            return 0x4000 as libc::c_int as uint16_t
        }
    }
    if view != 0 && y == -(1 as libc::c_int) && x >= 0 as libc::c_int
        && x < AUTOMAPX as libc::c_int
        && automapview[x as usize][0 as libc::c_int as usize] as libc::c_int != 0
    {
        if GetAutomapType(x, 0 as libc::c_int, 0 as libc::c_int as bool32_t)
            as libc::c_int & AMS_DIRT8 as libc::c_int != 0
        {
            return 0 as libc::c_int as uint16_t
        } else {
            return 0x4000 as libc::c_int as uint16_t
        }
    }
    if x < 0 as libc::c_int || x >= AUTOMAPX as libc::c_int {
        return 0 as libc::c_int as uint16_t;
    }
    if y < 0 as libc::c_int || y >= AUTOMAPY as libc::c_int {
        return 0 as libc::c_int as uint16_t;
    }
    if automapview[x as usize][y as usize] == 0 && view != 0 {
        return 0 as libc::c_int as uint16_t;
    }
    rv = automaptype[dungeon[x as usize][y as usize] as usize];
    if rv as libc::c_int == 7 as libc::c_int {
        t = (GetAutomapType(x - 1 as libc::c_int, y, 0 as libc::c_int as bool32_t)
            as libc::c_int >> 8 as libc::c_int) as uint16_t;
        if t as libc::c_int & AMS_ARCHR as libc::c_int != 0 {
            t = (GetAutomapType(x, y - 1 as libc::c_int, 0 as libc::c_int as bool32_t)
                as libc::c_int >> 8 as libc::c_int) as uint16_t;
            if t as libc::c_int & AMS_ARCHL as libc::c_int != 0 {
                rv = 1 as libc::c_int as uint16_t;
            }
        }
    }
    return rv;
}
unsafe extern "C" fn draw_game_info() {
    let mut szBuf: [libc::c_char; 256] = [0; 256];
    let mut y: libc::c_int = 20 as libc::c_int;
    if gbMaxPlayers as libc::c_int > 1 as libc::c_int {
        strcat(
            strcpy(szBuf.as_mut_ptr(), b"game: \0" as *const u8 as *const libc::c_char),
            gszGameName.as_mut_ptr(),
        );
        PrintStringXY(
            8 as libc::c_int,
            y,
            szBuf.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
        );
        y += LINE_HGT as libc::c_int;
        if gszGamePass[0 as libc::c_int as usize] != 0 {
            strcat(
                strcpy(
                    szBuf.as_mut_ptr(),
                    b"password: \0" as *const u8 as *const libc::c_char,
                ),
                gszGamePass.as_mut_ptr(),
            );
            PrintStringXY(
                8 as libc::c_int,
                y,
                szBuf.as_mut_ptr(),
                ICOLOR_GOLD as libc::c_int as int8_t,
            );
            y += LINE_HGT as libc::c_int;
        }
    }
    if setlevel != 0 {
        PrintStringXY(
            8 as libc::c_int,
            y,
            SetLevelName[setlvlnum as usize],
            ICOLOR_GOLD as libc::c_int as int8_t,
        );
    } else if currlevel != 0 {
        sprintf(
            szBuf.as_mut_ptr(),
            b"Level: %d\0" as *const u8 as *const libc::c_char,
            currlevel as libc::c_int,
        );
        PrintStringXY(
            8 as libc::c_int,
            y,
            szBuf.as_mut_ptr(),
            ICOLOR_GOLD as libc::c_int as int8_t,
        );
    }
    y += LINE_HGT as libc::c_int;
    sprintf(
        szBuf.as_mut_ptr(),
        b"Cursor: (x=%d, y=%d)\0" as *const u8 as *const libc::c_char,
        cursmx,
        cursmy,
    );
    PrintStringXY(
        8 as libc::c_int,
        y,
        szBuf.as_mut_ptr(),
        ICOLOR_WHITE as libc::c_int as int8_t,
    );
    y += LINE_HGT as libc::c_int;
    sprintf(
        szBuf.as_mut_ptr(),
        b"Game loops: %d\0" as *const u8 as *const libc::c_char,
        sgdwGameLoops,
    );
    PrintStringXY(
        8 as libc::c_int,
        y,
        szBuf.as_mut_ptr(),
        ICOLOR_WHITE as libc::c_int as int8_t,
    );
}
#[no_mangle]
pub unsafe extern "C" fn DrawAutomap() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    let mut y: libc::c_int = 0;
    let mut xs: libc::c_int = 0;
    let mut ys: libc::c_int = 0;
    let mut mx: libc::c_int = 0;
    let mut my: libc::c_int = 0;
    let mut ams: libc::c_int = 0;
    let mut s: uint16_t = 0;
    if leveltype as libc::c_int == 0 as libc::c_int {
        draw_game_info();
        return;
    }
    automapx = ViewX - DIRTEDGED2 as libc::c_int >> 1 as libc::c_int;
    while automapx + amxadd < 0 as libc::c_int {
        amxadd += 1;
        amxadd;
    }
    while automapx + amxadd >= AUTOMAPX as libc::c_int {
        amxadd -= 1;
        amxadd;
    }
    automapx += amxadd;
    automapy = ViewY - DIRTEDGED2 as libc::c_int >> 1 as libc::c_int;
    while automapy + amyadd < 0 as libc::c_int {
        amyadd += 1;
        amyadd;
    }
    while automapy + amyadd >= AUTOMAPY as libc::c_int {
        amyadd -= 1;
        amyadd;
    }
    automapy += amyadd;
    ams = automapstbl[((automapscale - AUTOMAPMIN as libc::c_int)
        / AUTOMAPADD as libc::c_int) as usize] as libc::c_int;
    if ScrollInfo._sxoff + ScrollInfo._syoff != 0 as libc::c_int {
        ams += 1;
        ams;
    }
    mx = automapx - ams;
    my = automapy - 1 as libc::c_int;
    if ams & 1 as libc::c_int != 0 {
        xs = 384 as libc::c_int
            - automaps1 * (ams - 1 as libc::c_int >> 1 as libc::c_int);
        ys = 336 as libc::c_int
            - automaps2 * (ams + 1 as libc::c_int >> 1 as libc::c_int);
    } else {
        xs = 384 as libc::c_int - automaps1 * (ams >> 1 as libc::c_int) + automaps2;
        ys = 336 as libc::c_int - automaps2 * (ams >> 1 as libc::c_int) - automaps3;
    }
    if ViewX & 1 as libc::c_int != 0 {
        xs -= automaps3;
        ys -= automaps4;
    }
    if ViewY & 1 as libc::c_int != 0 {
        xs += automaps3;
        ys -= automaps4;
    }
    xs += ScrollInfo._sxoff * automapscale / 100 as libc::c_int >> 1 as libc::c_int;
    ys += ScrollInfo._syoff * automapscale / 100 as libc::c_int >> 1 as libc::c_int;
    if invflag != 0 || sbookflag != 0 {
        xs -= 160 as libc::c_int;
    }
    if chrflag != 0 || questlog != 0 {
        xs += 160 as libc::c_int;
    }
    j = 0 as libc::c_int;
    while j <= ams + 1 as libc::c_int {
        x = xs;
        y = ys;
        i = 0 as libc::c_int;
        while i < ams {
            s = GetAutomapType(mx + i, my - i, 1 as libc::c_int as bool32_t);
            if s as libc::c_int != 0 as libc::c_int {
                DrawAMShape(x, y, s);
            }
            x += automaps1;
            i += 1;
            i;
        }
        my += 1;
        my;
        x = xs - automaps2;
        y = ys + automaps3;
        i = 0 as libc::c_int;
        while i <= ams {
            s = GetAutomapType(mx + i, my - i, 1 as libc::c_int as bool32_t);
            if s as libc::c_int != 0 as libc::c_int {
                DrawAMShape(x, y, s);
            }
            x += automaps1;
            i += 1;
            i;
        }
        mx += 1;
        mx;
        ys = ys + automaps2;
        j += 1;
        j;
    }
    DrawAutomapPlr();
    draw_game_info();
}
#[no_mangle]
pub unsafe extern "C" fn SetAutomapView(mut x: libc::c_int, mut y: libc::c_int) {
    let mut xx: libc::c_int = 0;
    let mut yy: libc::c_int = 0;
    let mut s: uint16_t = 0;
    let mut d: uint16_t = 0;
    xx = x - DIRTEDGED2 as libc::c_int >> 1 as libc::c_int;
    yy = y - DIRTEDGED2 as libc::c_int >> 1 as libc::c_int;
    if xx < 0 as libc::c_int || xx >= AUTOMAPX as libc::c_int {
        return;
    }
    if yy < 0 as libc::c_int || yy >= AUTOMAPY as libc::c_int {
        return;
    }
    automapview[xx as usize][yy as usize] = 1 as libc::c_int as uint8_t;
    s = GetAutomapType(xx, yy, 0 as libc::c_int as bool32_t);
    d = (s as libc::c_int & AMS_DIRT8 as libc::c_int) as uint16_t;
    s = (s as libc::c_int & 0xf as libc::c_int) as uint16_t;
    match s as libc::c_int {
        2 => {
            if d != 0 {
                if GetAutomapType(
                    xx,
                    yy + 1 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int == AMS_DIRTLR as libc::c_int
                {
                    automapview[xx
                        as usize][(yy + 1 as libc::c_int)
                        as usize] = 1 as libc::c_int as uint8_t;
                }
            } else if GetAutomapType(
                xx - 1 as libc::c_int,
                yy,
                0 as libc::c_int as bool32_t,
            ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
            {
                automapview[(xx - 1 as libc::c_int)
                    as usize][yy as usize] = 1 as libc::c_int as uint8_t;
            }
        }
        3 => {
            if d != 0 {
                if GetAutomapType(
                    xx + 1 as libc::c_int,
                    yy,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int == AMS_DIRTLR as libc::c_int
                {
                    automapview[(xx + 1 as libc::c_int)
                        as usize][yy as usize] = 1 as libc::c_int as uint8_t;
                }
            } else if GetAutomapType(
                xx,
                yy - 1 as libc::c_int,
                0 as libc::c_int as bool32_t,
            ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
            {
                automapview[xx
                    as usize][(yy - 1 as libc::c_int)
                    as usize] = 1 as libc::c_int as uint8_t;
            }
        }
        4 => {
            if d != 0 {
                if GetAutomapType(
                    xx,
                    yy + 1 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int == AMS_DIRTLR as libc::c_int
                {
                    automapview[xx
                        as usize][(yy + 1 as libc::c_int)
                        as usize] = 1 as libc::c_int as uint8_t;
                }
                if GetAutomapType(
                    xx + 1 as libc::c_int,
                    yy,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int == AMS_DIRTLR as libc::c_int
                {
                    automapview[(xx + 1 as libc::c_int)
                        as usize][yy as usize] = 1 as libc::c_int as uint8_t;
                }
            } else {
                if GetAutomapType(
                    xx - 1 as libc::c_int,
                    yy,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
                {
                    automapview[(xx - 1 as libc::c_int)
                        as usize][yy as usize] = 1 as libc::c_int as uint8_t;
                }
                if GetAutomapType(
                    xx,
                    yy - 1 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
                {
                    automapview[xx
                        as usize][(yy - 1 as libc::c_int)
                        as usize] = 1 as libc::c_int as uint8_t;
                }
                if GetAutomapType(
                    xx - 1 as libc::c_int,
                    yy - 1 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
                {
                    automapview[(xx - 1 as libc::c_int)
                        as usize][(yy - 1 as libc::c_int)
                        as usize] = 1 as libc::c_int as uint8_t;
                }
            }
        }
        5 => {
            if d != 0 {
                if GetAutomapType(
                    xx,
                    yy - 1 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
                {
                    automapview[xx
                        as usize][(yy - 1 as libc::c_int)
                        as usize] = 1 as libc::c_int as uint8_t;
                }
                if GetAutomapType(
                    xx,
                    yy + 1 as libc::c_int,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int == AMS_DIRTLR as libc::c_int
                {
                    automapview[xx
                        as usize][(yy + 1 as libc::c_int)
                        as usize] = 1 as libc::c_int as uint8_t;
                }
            } else if GetAutomapType(
                xx - 1 as libc::c_int,
                yy,
                0 as libc::c_int as bool32_t,
            ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
            {
                automapview[(xx - 1 as libc::c_int)
                    as usize][yy as usize] = 1 as libc::c_int as uint8_t;
            }
        }
        6 => {
            if d != 0 {
                if GetAutomapType(
                    xx - 1 as libc::c_int,
                    yy,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
                {
                    automapview[(xx - 1 as libc::c_int)
                        as usize][yy as usize] = 1 as libc::c_int as uint8_t;
                }
                if GetAutomapType(
                    xx + 1 as libc::c_int,
                    yy,
                    0 as libc::c_int as bool32_t,
                ) as libc::c_int == AMS_DIRTLR as libc::c_int
                {
                    automapview[(xx + 1 as libc::c_int)
                        as usize][yy as usize] = 1 as libc::c_int as uint8_t;
                }
            } else if GetAutomapType(
                xx,
                yy - 1 as libc::c_int,
                0 as libc::c_int as bool32_t,
            ) as libc::c_int & AMS_DIRT8 as libc::c_int != 0
            {
                automapview[xx
                    as usize][(yy - 1 as libc::c_int)
                    as usize] = 1 as libc::c_int as uint8_t;
            }
        }
        _ => {}
    };
}
#[no_mangle]
pub unsafe extern "C" fn SyncAutomap() {
    automaps1 = (automapscale << 6 as libc::c_int) / 100 as libc::c_int;
    automaps2 = automaps1 >> 1 as libc::c_int;
    automaps3 = automaps2 >> 1 as libc::c_int;
    automaps4 = automaps3 >> 1 as libc::c_int;
    automaps5 = automaps4 >> 1 as libc::c_int;
    amxadd = 0 as libc::c_int;
    amyadd = 0 as libc::c_int;
}
