use ::libc;
extern "C" {
    pub type _IO_wide_data;
    pub type _IO_codecvt;
    pub type _IO_marker;
    pub type SDL_Thread;
    static mut stderr: *mut FILE;
    fn fprintf(_: *mut FILE, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn vfprintf(
        _: *mut FILE,
        _: *const libc::c_char,
        _: ::core::ffi::VaList,
    ) -> libc::c_int;
    fn exit(_: libc::c_int) -> !;
    fn SDL_ShowCursor(toggle: libc::c_int) -> libc::c_int;
    fn cleanup(bNormalExit: bool32_t);
    fn SDL_GetThreadID(thread: *mut SDL_Thread) -> SDL_threadID;
    fn SNetLeaveGame(exitcode: uint32_t) -> bool32_t;
    fn SDL_Delay(ms: Uint32);
    fn SNetDestroy() -> bool32_t;
    static mut gbMaxPlayers: uint8_t;
}
pub type __builtin_va_list = [__va_list_tag; 1];
#[derive(Copy, Clone)]
#[repr(C)]
pub struct __va_list_tag {
    pub gp_offset: libc::c_uint,
    pub fp_offset: libc::c_uint,
    pub overflow_arg_area: *mut libc::c_void,
    pub reg_save_area: *mut libc::c_void,
}
pub type size_t = libc::c_ulong;
pub type __gnuc_va_list = __builtin_va_list;
pub type __uint8_t = libc::c_uchar;
pub type __uint32_t = libc::c_uint;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _IO_FILE {
    pub _flags: libc::c_int,
    pub _IO_read_ptr: *mut libc::c_char,
    pub _IO_read_end: *mut libc::c_char,
    pub _IO_read_base: *mut libc::c_char,
    pub _IO_write_base: *mut libc::c_char,
    pub _IO_write_ptr: *mut libc::c_char,
    pub _IO_write_end: *mut libc::c_char,
    pub _IO_buf_base: *mut libc::c_char,
    pub _IO_buf_end: *mut libc::c_char,
    pub _IO_save_base: *mut libc::c_char,
    pub _IO_backup_base: *mut libc::c_char,
    pub _IO_save_end: *mut libc::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: libc::c_int,
    pub _flags2: libc::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: libc::c_ushort,
    pub _vtable_offset: libc::c_schar,
    pub _shortbuf: [libc::c_char; 1],
    pub _lock: *mut libc::c_void,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut libc::c_void,
    pub __pad5: size_t,
    pub _mode: libc::c_int,
    pub _unused2: [libc::c_char; 20],
}
pub type _IO_lock_t = ();
pub type FILE = _IO_FILE;
pub type va_list = __gnuc_va_list;
pub type C2RustUnnamed = libc::c_uint;
pub const DEBUG: C2RustUnnamed = 1;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const EXTENDED_ASSERT: C2RustUnnamed_0 = 1;
pub type bool32_t = uint32_t;
pub type uint32_t = __uint32_t;
pub type Uint32 = uint32_t;
pub type uint8_t = __uint8_t;
pub type SDL_threadID = libc::c_ulong;
static mut sbInFatal: bool32_t = 0 as libc::c_int as bool32_t;
static mut snThreadID: libc::c_uint = 0 as libc::c_int as libc::c_uint;
#[no_mangle]
pub unsafe extern "C" fn pre_fatal_cleanup() {
    if sbInFatal != 0
        && snThreadID as SDL_threadID != SDL_GetThreadID(0 as *mut SDL_Thread)
    {
        SDL_Delay(20000 as libc::c_int as Uint32);
    }
    sbInFatal = 1 as libc::c_int as bool32_t;
    snThreadID = SDL_GetThreadID(0 as *mut SDL_Thread) as libc::c_uint;
    if gbMaxPlayers as libc::c_int > 1 as libc::c_int {
        if SNetLeaveGame(0x3 as libc::c_int as uint32_t) != 0 {
            SDL_Delay(2000 as libc::c_int as Uint32);
        }
    }
    SNetDestroy();
    SDL_ShowCursor(1 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn app_fatal_(
    mut file: *const libc::c_char,
    mut line: libc::c_int,
    mut pszFmt: *const libc::c_char,
    mut args: ...
) -> ! {
    pre_fatal_cleanup();
    if !pszFmt.is_null() {
        let mut args_0: ::core::ffi::VaListImpl;
        args_0 = args.clone();
        fprintf(stderr, b"%s:%d \0" as *const u8 as *const libc::c_char, file, line);
        vfprintf(stderr, pszFmt, args_0.as_va_list());
    }
    cleanup(0 as libc::c_int as bool32_t);
    exit(1 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn app_warning(mut pszFmt: *const libc::c_char, mut args: ...) {
    if pszFmt.is_null() {
        assert_fail(
            61 as libc::c_int,
            b"src/appfat.c\0" as *const u8 as *const libc::c_char,
            b"pszFmt\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut args_0: ::core::ffi::VaListImpl;
    args_0 = args.clone();
    vfprintf(stderr, pszFmt, args_0.as_va_list());
}
#[no_mangle]
pub unsafe extern "C" fn assert_fail(
    mut nLineNo: libc::c_int,
    mut pszFile: *const libc::c_char,
    mut pszFail: *const libc::c_char,
) {
    if DEBUG as libc::c_int == 0 {
        return;
    }
    if EXTENDED_ASSERT as libc::c_int != 0 {
        app_fatal_(
            b"src/appfat.c\0" as *const u8 as *const libc::c_char,
            74 as libc::c_int,
            b"assertion failed (%d:%s)\n%s\0" as *const u8 as *const libc::c_char,
            nLineNo,
            pszFile,
            pszFail,
        );
        return;
    }
    app_fatal_(
        b"src/appfat.c\0" as *const u8 as *const libc::c_char,
        77 as libc::c_int,
        b"assertion failed (%d:%s)\0" as *const u8 as *const libc::c_char,
        nLineNo,
        pszFile,
    );
}
