#![feature(extern_types)]

extern crate libc;

extern "C" {
    fn main_c(argc: libc::c_int, argv: *mut *mut libc::c_char) -> libc::c_int;
    fn wait_for_continue();
}

extern "C" {
    static INIT_ARRAY: [unsafe extern "C" fn(); 1];
}

pub fn main() {
    #[cfg(debug_assertions)]
    unsafe {
        wait_for_continue();
    }

    // NOTE: initialization required by global_textdat.rs (e.g. init
    // gdwAllTextEntries to len(alltext)).
    unsafe {
        for func in INIT_ARRAY {
            func();
        }
    }

    let mut args: Vec::<*mut libc::c_char> = Vec::new();
    for arg in ::std::env::args() {
        args.push(
            (::std::ffi::CString::new(arg))
                .expect("Failed to convert argument into CString.")
                .into_raw(),
        );
    }
    args.push(::core::ptr::null_mut());
    unsafe {
        ::std::process::exit(
            main_c(
                (args.len() - 1) as libc::c_int,
                args.as_mut_ptr() as *mut *mut libc::c_char,
            ) as i32,
        )
    }
}
