use ::libc;
extern "C" {
    pub type _IO_wide_data;
    pub type _IO_codecvt;
    pub type _IO_marker;
    fn fclose(__stream: *mut FILE) -> libc::c_int;
    fn fopen(_: *const libc::c_char, _: *const libc::c_char) -> *mut FILE;
    fn fread(
        _: *mut libc::c_void,
        _: libc::c_ulong,
        _: libc::c_ulong,
        _: *mut FILE,
    ) -> libc::c_ulong;
    fn fseek(
        __stream: *mut FILE,
        __off: libc::c_long,
        __whence: libc::c_int,
    ) -> libc::c_int;
    fn ftell(__stream: *mut FILE) -> libc::c_long;
    fn calloc(_: libc::c_ulong, _: libc::c_ulong) -> *mut libc::c_void;
    fn nx_json_parse(
        text: *mut libc::c_char,
        encoder: nx_json_unicode_encoder,
    ) -> *const nx_json;
    fn nx_json_get(json: *const nx_json, key: *const libc::c_char) -> *const nx_json;
    fn nx_json_item(json: *const nx_json, idx: libc::c_int) -> *const nx_json;
    static mut events_from_logic_tick: *mut EventsSlice;
    static mut replay_nlogic_ticks: libc::c_int;
    fn _logf(format: *const libc::c_char, _: ...);
}
pub type size_t = libc::c_ulong;
pub type __int32_t = libc::c_int;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _IO_FILE {
    pub _flags: libc::c_int,
    pub _IO_read_ptr: *mut libc::c_char,
    pub _IO_read_end: *mut libc::c_char,
    pub _IO_read_base: *mut libc::c_char,
    pub _IO_write_base: *mut libc::c_char,
    pub _IO_write_ptr: *mut libc::c_char,
    pub _IO_write_end: *mut libc::c_char,
    pub _IO_buf_base: *mut libc::c_char,
    pub _IO_buf_end: *mut libc::c_char,
    pub _IO_save_base: *mut libc::c_char,
    pub _IO_backup_base: *mut libc::c_char,
    pub _IO_save_end: *mut libc::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: libc::c_int,
    pub _flags2: libc::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: libc::c_ushort,
    pub _vtable_offset: libc::c_schar,
    pub _shortbuf: [libc::c_char; 1],
    pub _lock: *mut libc::c_void,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut libc::c_void,
    pub __pad5: size_t,
    pub _mode: libc::c_int,
    pub _unused2: [libc::c_char; 20],
}
pub type _IO_lock_t = ();
pub type FILE = _IO_FILE;
pub type int32_t = __int32_t;
pub type int64_t = __int64_t;
pub type uint64_t = __uint64_t;
pub type nxjson_u64 = uint64_t;
pub type nxjson_s64 = uint64_t;
pub type nx_json_type = libc::c_uint;
pub const NX_JSON_BOOL: nx_json_type = 6;
pub const NX_JSON_DOUBLE: nx_json_type = 5;
pub const NX_JSON_INTEGER: nx_json_type = 4;
pub const NX_JSON_STRING: nx_json_type = 3;
pub const NX_JSON_ARRAY: nx_json_type = 2;
pub const NX_JSON_OBJECT: nx_json_type = 1;
pub const NX_JSON_NULL: nx_json_type = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct nx_json {
    pub type_0: nx_json_type,
    pub key: *const libc::c_char,
    pub c2rust_unnamed: C2RustUnnamed,
    pub next: *mut nx_json,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed {
    pub text_value: *const libc::c_char,
    pub num: C2RustUnnamed_1,
    pub children: C2RustUnnamed_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_0 {
    pub length: libc::c_int,
    pub first: *mut nx_json,
    pub last: *mut nx_json,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_1 {
    pub c2rust_unnamed: C2RustUnnamed_2,
    pub dbl_value: libc::c_double,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_2 {
    pub u_value: nxjson_u64,
    pub s_value: nxjson_s64,
}
pub type nx_json_unicode_encoder = Option::<
    unsafe extern "C" fn(
        libc::c_uint,
        *mut libc::c_char,
        *mut *mut libc::c_char,
    ) -> libc::c_int,
>;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Event {
    pub event_type: int64_t,
    pub key: int64_t,
    pub button: int64_t,
    pub x: int64_t,
    pub y: int64_t,
    pub prev_x: int64_t,
    pub prev_y: int64_t,
    pub mod_0: int64_t,
    pub rune: int64_t,
    pub in_menu: bool,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct EventsSlice {
    pub events: *mut Event,
    pub nevents: libc::c_int,
}
#[no_mangle]
pub unsafe extern "C" fn parse_replay(mut replay_path: *mut libc::c_char) -> bool {
    let mut buf: *mut libc::c_char = read_file(replay_path);
    if buf.is_null() {
        return 0 as libc::c_int != 0;
    }
    let mut json_events_from_logic_tick: *const nx_json = nx_json_parse(buf, None);
    if json_events_from_logic_tick.is_null() {
        _logf(
            b"unable to parse JSON file '%s'\0" as *const u8 as *const libc::c_char,
            replay_path,
        );
        return 0 as libc::c_int != 0;
    }
    let mut nlogic_ticks: libc::c_int = (*json_events_from_logic_tick)
        .c2rust_unnamed
        .children
        .length;
    replay_nlogic_ticks = nlogic_ticks;
    events_from_logic_tick = calloc(
        nlogic_ticks as libc::c_ulong,
        ::core::mem::size_of::<EventsSlice>() as libc::c_ulong,
    ) as *mut EventsSlice;
    let mut logic_tick: libc::c_int = 0 as libc::c_int;
    while logic_tick < nlogic_ticks {
        let mut json_events: *const nx_json = nx_json_item(
            json_events_from_logic_tick,
            logic_tick,
        );
        let mut nevents: libc::c_int = (*json_events).c2rust_unnamed.children.length;
        let mut events_slice: EventsSlice = EventsSlice {
            events: 0 as *mut Event,
            nevents: 0,
        };
        events_slice
            .events = calloc(
            nevents as libc::c_ulong,
            ::core::mem::size_of::<Event>() as libc::c_ulong,
        ) as *mut Event;
        events_slice.nevents = nevents;
        *events_from_logic_tick.offset(logic_tick as isize) = events_slice;
        let mut i: libc::c_int = 0 as libc::c_int;
        while i < nevents {
            let mut json_event: *const nx_json = nx_json_item(json_events, i);
            let mut event: Event = Event {
                event_type: 0,
                key: 0,
                button: 0,
                x: 0,
                y: 0,
                prev_x: 0,
                prev_y: 0,
                mod_0: 0,
                rune: 0,
                in_menu: false,
            };
            event.event_type = 0 as libc::c_int as int64_t;
            event.key = 0 as libc::c_int as int64_t;
            event.button = 0 as libc::c_int as int64_t;
            event.x = 0 as libc::c_int as int64_t;
            event.y = 0 as libc::c_int as int64_t;
            event.prev_x = 0 as libc::c_int as int64_t;
            event.prev_y = 0 as libc::c_int as int64_t;
            event.mod_0 = 0 as libc::c_int as int64_t;
            event.rune = 0 as libc::c_int as int64_t;
            event.in_menu = 0 as libc::c_int != 0;
            let mut json_event_type: *const nx_json = nx_json_get(
                json_event,
                b"t\0" as *const u8 as *const libc::c_char,
            );
            if !json_event_type.is_null() {
                event
                    .event_type = (*json_event_type)
                    .c2rust_unnamed
                    .num
                    .c2rust_unnamed
                    .s_value as int64_t;
            }
            let mut json_key: *const nx_json = nx_json_get(
                json_event,
                b"k\0" as *const u8 as *const libc::c_char,
            );
            if !json_key.is_null() {
                event
                    .key = (*json_key).c2rust_unnamed.num.c2rust_unnamed.s_value
                    as int64_t;
            }
            let mut json_button: *const nx_json = nx_json_get(
                json_event,
                b"b\0" as *const u8 as *const libc::c_char,
            );
            if !json_button.is_null() {
                event
                    .button = (*json_button).c2rust_unnamed.num.c2rust_unnamed.s_value
                    as int64_t;
            }
            let mut json_x: *const nx_json = nx_json_get(
                json_event,
                b"x\0" as *const u8 as *const libc::c_char,
            );
            if !json_x.is_null() {
                event.x = (*json_x).c2rust_unnamed.num.c2rust_unnamed.s_value as int64_t;
            }
            let mut json_y: *const nx_json = nx_json_get(
                json_event,
                b"y\0" as *const u8 as *const libc::c_char,
            );
            if !json_y.is_null() {
                event.y = (*json_y).c2rust_unnamed.num.c2rust_unnamed.s_value as int64_t;
            }
            let mut json_prev_x: *const nx_json = nx_json_get(
                json_event,
                b"px\0" as *const u8 as *const libc::c_char,
            );
            if !json_prev_x.is_null() {
                event
                    .prev_x = (*json_prev_x).c2rust_unnamed.num.c2rust_unnamed.s_value
                    as int64_t;
            }
            let mut json_prev_y: *const nx_json = nx_json_get(
                json_event,
                b"py\0" as *const u8 as *const libc::c_char,
            );
            if !json_prev_y.is_null() {
                event
                    .prev_y = (*json_prev_y).c2rust_unnamed.num.c2rust_unnamed.s_value
                    as int64_t;
            }
            let mut json_mod: *const nx_json = nx_json_get(
                json_event,
                b"m\0" as *const u8 as *const libc::c_char,
            );
            if !json_mod.is_null() {
                event
                    .mod_0 = (*json_mod).c2rust_unnamed.num.c2rust_unnamed.s_value
                    as int64_t;
            }
            let mut json_rune: *const nx_json = nx_json_get(
                json_event,
                b"r\0" as *const u8 as *const libc::c_char,
            );
            if !json_rune.is_null() {
                event
                    .rune = (*json_rune).c2rust_unnamed.num.c2rust_unnamed.s_value
                    as int64_t;
            }
            let mut json_in_menu: *const nx_json = nx_json_get(
                json_event,
                b"in_menu\0" as *const u8 as *const libc::c_char,
            );
            if !json_in_menu.is_null() {
                event
                    .in_menu = if (*json_in_menu)
                    .c2rust_unnamed
                    .num
                    .c2rust_unnamed
                    .s_value != 0
                {
                    1 as libc::c_int
                } else {
                    0 as libc::c_int
                } != 0;
            }
            *(events_slice.events).offset(i as isize) = event;
            i += 1;
            i;
        }
        logic_tick += 1;
        logic_tick;
    }
    return 1 as libc::c_int != 0;
}
#[no_mangle]
pub unsafe extern "C" fn read_file(mut path: *mut libc::c_char) -> *mut libc::c_char {
    let mut f: *mut FILE = fopen(path, b"rb\0" as *const u8 as *const libc::c_char);
    if f.is_null() {
        _logf(b"unable to open '%s'\0" as *const u8 as *const libc::c_char, path);
        return 0 as *mut libc::c_char;
    }
    if fseek(f, 0 as libc::c_int as libc::c_long, 2 as libc::c_int)
        == -(1 as libc::c_int)
    {
        _logf(b"unable to seek in '%s'\0" as *const u8 as *const libc::c_char, path);
        fclose(f);
        return 0 as *mut libc::c_char;
    }
    let mut file_size: int32_t = ftell(f) as int32_t;
    if file_size == -(1 as libc::c_int) {
        _logf(
            b"unable to get file size of '%s'\0" as *const u8 as *const libc::c_char,
            path,
        );
        fclose(f);
        return 0 as *mut libc::c_char;
    }
    if fseek(f, 0 as libc::c_int as libc::c_long, 0 as libc::c_int)
        == -(1 as libc::c_int)
    {
        _logf(b"unable to seek in '%s'\0" as *const u8 as *const libc::c_char, path);
        fclose(f);
        return 0 as *mut libc::c_char;
    }
    let mut buf: *mut libc::c_char = calloc(
        file_size as libc::c_ulong,
        1 as libc::c_int as libc::c_ulong,
    ) as *mut libc::c_char;
    let mut n: libc::c_int = fread(
        buf as *mut libc::c_void,
        1 as libc::c_int as libc::c_ulong,
        file_size as libc::c_ulong,
        f,
    ) as libc::c_int;
    if n != file_size {
        _logf(
            b"unable to read file contents of '%s'; read %d bytes, expected to read %d bytes\0"
                as *const u8 as *const libc::c_char,
            path,
            n,
            file_size,
        );
        fclose(f);
        return 0 as *mut libc::c_char;
    }
    fclose(f);
    return buf;
}
