use ::libc;
extern "C" {
    pub type _IO_wide_data;
    pub type _IO_codecvt;
    pub type _IO_marker;
    fn calloc(_: libc::c_ulong, _: libc::c_ulong) -> *mut libc::c_void;
    fn free(_: *mut libc::c_void);
    fn strncpy(
        _: *mut libc::c_char,
        _: *const libc::c_char,
        _: libc::c_ulong,
    ) -> *mut libc::c_char;
    fn strlen(_: *const libc::c_char) -> libc::c_ulong;
    static mut stderr: *mut FILE;
    fn fclose(__stream: *mut FILE) -> libc::c_int;
    fn fflush(__stream: *mut FILE) -> libc::c_int;
    fn fopen(_: *const libc::c_char, _: *const libc::c_char) -> *mut FILE;
    fn vfprintf(
        _: *mut FILE,
        _: *const libc::c_char,
        _: ::core::ffi::VaList,
    ) -> libc::c_int;
    static mut log_file: *mut FILE;
}
pub type __builtin_va_list = [__va_list_tag; 1];
#[derive(Copy, Clone)]
#[repr(C)]
pub struct __va_list_tag {
    pub gp_offset: libc::c_uint,
    pub fp_offset: libc::c_uint,
    pub overflow_arg_area: *mut libc::c_void,
    pub reg_save_area: *mut libc::c_void,
}
pub type va_list = __builtin_va_list;
pub type size_t = libc::c_ulong;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _IO_FILE {
    pub _flags: libc::c_int,
    pub _IO_read_ptr: *mut libc::c_char,
    pub _IO_read_end: *mut libc::c_char,
    pub _IO_read_base: *mut libc::c_char,
    pub _IO_write_base: *mut libc::c_char,
    pub _IO_write_ptr: *mut libc::c_char,
    pub _IO_write_end: *mut libc::c_char,
    pub _IO_buf_base: *mut libc::c_char,
    pub _IO_buf_end: *mut libc::c_char,
    pub _IO_save_base: *mut libc::c_char,
    pub _IO_backup_base: *mut libc::c_char,
    pub _IO_save_end: *mut libc::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: libc::c_int,
    pub _flags2: libc::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: libc::c_ushort,
    pub _vtable_offset: libc::c_schar,
    pub _shortbuf: [libc::c_char; 1],
    pub _lock: *mut libc::c_void,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut libc::c_void,
    pub __pad5: size_t,
    pub _mode: libc::c_int,
    pub _unused2: [libc::c_char; 20],
}
pub type _IO_lock_t = ();
pub type FILE = _IO_FILE;
pub type C2RustUnnamed = libc::c_uint;
pub const enable_log: C2RustUnnamed = 0;
#[no_mangle]
pub unsafe extern "C" fn init_log(mut log_path: *const libc::c_char) {
    if enable_log as libc::c_int == 0 {
        return;
    }
    log_file = fopen(log_path, b"wb\0" as *const u8 as *const libc::c_char);
    if log_file.is_null() {
        return;
    }
}
#[no_mangle]
pub unsafe extern "C" fn close_log() {
    if enable_log as libc::c_int == 0 {
        return;
    }
    if fclose(log_file) != 0 as libc::c_int {
        return;
    }
}
#[no_mangle]
pub unsafe extern "C" fn _logf(mut format: *const libc::c_char, mut args: ...) {
    if enable_log as libc::c_int == 0 {
        return;
    }
    let mut fmt: *mut libc::c_char = calloc(
        1 as libc::c_int as libc::c_ulong,
        (strlen(format))
            .wrapping_add(1 as libc::c_int as libc::c_ulong)
            .wrapping_add(1 as libc::c_int as libc::c_ulong),
    ) as *mut libc::c_char;
    strncpy(fmt, format, strlen(format));
    *fmt.offset(strlen(fmt) as isize) = '\n' as i32 as libc::c_char;
    let mut va: ::core::ffi::VaListImpl;
    va = args.clone();
    vfprintf(stderr, fmt, va.as_va_list());
    fflush(stderr);
    if !log_file.is_null() {
        va = args.clone();
        vfprintf(log_file, fmt, va.as_va_list());
        fflush(log_file);
    }
    free(fmt as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn bool_str(mut v: bool) -> *const libc::c_char {
    if v {
        return b"true\0" as *const u8 as *const libc::c_char;
    }
    return b"false\0" as *const u8 as *const libc::c_char;
}
