use ::libc;
extern "C" {
    pub type SDL_SysWMmsg;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn snprintf(
        _: *mut libc::c_char,
        _: libc::c_ulong,
        _: *const libc::c_char,
        _: ...
    ) -> libc::c_int;
    fn SDL_SetModState(modstate: SDL_Keymod);
    fn SDL_PollEvent(event: *mut SDL_Event) -> libc::c_int;
    fn SDL_GetTicks() -> Uint32;
    fn SDL_Delay(ms: Uint32);
    static mut sgdwGameLoops: uint32_t;
    static mut replay_started: bool;
    static mut replay_nlogic_ticks: libc::c_int;
    static mut realtime_replay_logic_ticks_offset: libc::c_int;
    static mut events_from_logic_tick: *mut EventsSlice;
    fn parse_replay(replay_path: *mut libc::c_char) -> bool;
    fn _logf(format: *const libc::c_char, _: ...);
}
pub type __uint8_t = libc::c_uchar;
pub type __int16_t = libc::c_short;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type int16_t = __int16_t;
pub type int32_t = __int32_t;
pub type int64_t = __int64_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type Uint8 = uint8_t;
pub type Sint16 = int16_t;
pub type Uint16 = uint16_t;
pub type Sint32 = int32_t;
pub type Uint32 = uint32_t;
pub type Sint64 = int64_t;
pub type Uint64 = uint64_t;
pub type SDL_Scancode = libc::c_uint;
pub const SDL_NUM_SCANCODES: SDL_Scancode = 512;
pub const SDL_SCANCODE_ENDCALL: SDL_Scancode = 290;
pub const SDL_SCANCODE_CALL: SDL_Scancode = 289;
pub const SDL_SCANCODE_SOFTRIGHT: SDL_Scancode = 288;
pub const SDL_SCANCODE_SOFTLEFT: SDL_Scancode = 287;
pub const SDL_SCANCODE_AUDIOFASTFORWARD: SDL_Scancode = 286;
pub const SDL_SCANCODE_AUDIOREWIND: SDL_Scancode = 285;
pub const SDL_SCANCODE_APP2: SDL_Scancode = 284;
pub const SDL_SCANCODE_APP1: SDL_Scancode = 283;
pub const SDL_SCANCODE_SLEEP: SDL_Scancode = 282;
pub const SDL_SCANCODE_EJECT: SDL_Scancode = 281;
pub const SDL_SCANCODE_KBDILLUMUP: SDL_Scancode = 280;
pub const SDL_SCANCODE_KBDILLUMDOWN: SDL_Scancode = 279;
pub const SDL_SCANCODE_KBDILLUMTOGGLE: SDL_Scancode = 278;
pub const SDL_SCANCODE_DISPLAYSWITCH: SDL_Scancode = 277;
pub const SDL_SCANCODE_BRIGHTNESSUP: SDL_Scancode = 276;
pub const SDL_SCANCODE_BRIGHTNESSDOWN: SDL_Scancode = 275;
pub const SDL_SCANCODE_AC_BOOKMARKS: SDL_Scancode = 274;
pub const SDL_SCANCODE_AC_REFRESH: SDL_Scancode = 273;
pub const SDL_SCANCODE_AC_STOP: SDL_Scancode = 272;
pub const SDL_SCANCODE_AC_FORWARD: SDL_Scancode = 271;
pub const SDL_SCANCODE_AC_BACK: SDL_Scancode = 270;
pub const SDL_SCANCODE_AC_HOME: SDL_Scancode = 269;
pub const SDL_SCANCODE_AC_SEARCH: SDL_Scancode = 268;
pub const SDL_SCANCODE_COMPUTER: SDL_Scancode = 267;
pub const SDL_SCANCODE_CALCULATOR: SDL_Scancode = 266;
pub const SDL_SCANCODE_MAIL: SDL_Scancode = 265;
pub const SDL_SCANCODE_WWW: SDL_Scancode = 264;
pub const SDL_SCANCODE_MEDIASELECT: SDL_Scancode = 263;
pub const SDL_SCANCODE_AUDIOMUTE: SDL_Scancode = 262;
pub const SDL_SCANCODE_AUDIOPLAY: SDL_Scancode = 261;
pub const SDL_SCANCODE_AUDIOSTOP: SDL_Scancode = 260;
pub const SDL_SCANCODE_AUDIOPREV: SDL_Scancode = 259;
pub const SDL_SCANCODE_AUDIONEXT: SDL_Scancode = 258;
pub const SDL_SCANCODE_MODE: SDL_Scancode = 257;
pub const SDL_SCANCODE_RGUI: SDL_Scancode = 231;
pub const SDL_SCANCODE_RALT: SDL_Scancode = 230;
pub const SDL_SCANCODE_RSHIFT: SDL_Scancode = 229;
pub const SDL_SCANCODE_RCTRL: SDL_Scancode = 228;
pub const SDL_SCANCODE_LGUI: SDL_Scancode = 227;
pub const SDL_SCANCODE_LALT: SDL_Scancode = 226;
pub const SDL_SCANCODE_LSHIFT: SDL_Scancode = 225;
pub const SDL_SCANCODE_LCTRL: SDL_Scancode = 224;
pub const SDL_SCANCODE_KP_HEXADECIMAL: SDL_Scancode = 221;
pub const SDL_SCANCODE_KP_DECIMAL: SDL_Scancode = 220;
pub const SDL_SCANCODE_KP_OCTAL: SDL_Scancode = 219;
pub const SDL_SCANCODE_KP_BINARY: SDL_Scancode = 218;
pub const SDL_SCANCODE_KP_CLEARENTRY: SDL_Scancode = 217;
pub const SDL_SCANCODE_KP_CLEAR: SDL_Scancode = 216;
pub const SDL_SCANCODE_KP_PLUSMINUS: SDL_Scancode = 215;
pub const SDL_SCANCODE_KP_MEMDIVIDE: SDL_Scancode = 214;
pub const SDL_SCANCODE_KP_MEMMULTIPLY: SDL_Scancode = 213;
pub const SDL_SCANCODE_KP_MEMSUBTRACT: SDL_Scancode = 212;
pub const SDL_SCANCODE_KP_MEMADD: SDL_Scancode = 211;
pub const SDL_SCANCODE_KP_MEMCLEAR: SDL_Scancode = 210;
pub const SDL_SCANCODE_KP_MEMRECALL: SDL_Scancode = 209;
pub const SDL_SCANCODE_KP_MEMSTORE: SDL_Scancode = 208;
pub const SDL_SCANCODE_KP_EXCLAM: SDL_Scancode = 207;
pub const SDL_SCANCODE_KP_AT: SDL_Scancode = 206;
pub const SDL_SCANCODE_KP_SPACE: SDL_Scancode = 205;
pub const SDL_SCANCODE_KP_HASH: SDL_Scancode = 204;
pub const SDL_SCANCODE_KP_COLON: SDL_Scancode = 203;
pub const SDL_SCANCODE_KP_DBLVERTICALBAR: SDL_Scancode = 202;
pub const SDL_SCANCODE_KP_VERTICALBAR: SDL_Scancode = 201;
pub const SDL_SCANCODE_KP_DBLAMPERSAND: SDL_Scancode = 200;
pub const SDL_SCANCODE_KP_AMPERSAND: SDL_Scancode = 199;
pub const SDL_SCANCODE_KP_GREATER: SDL_Scancode = 198;
pub const SDL_SCANCODE_KP_LESS: SDL_Scancode = 197;
pub const SDL_SCANCODE_KP_PERCENT: SDL_Scancode = 196;
pub const SDL_SCANCODE_KP_POWER: SDL_Scancode = 195;
pub const SDL_SCANCODE_KP_XOR: SDL_Scancode = 194;
pub const SDL_SCANCODE_KP_F: SDL_Scancode = 193;
pub const SDL_SCANCODE_KP_E: SDL_Scancode = 192;
pub const SDL_SCANCODE_KP_D: SDL_Scancode = 191;
pub const SDL_SCANCODE_KP_C: SDL_Scancode = 190;
pub const SDL_SCANCODE_KP_B: SDL_Scancode = 189;
pub const SDL_SCANCODE_KP_A: SDL_Scancode = 188;
pub const SDL_SCANCODE_KP_BACKSPACE: SDL_Scancode = 187;
pub const SDL_SCANCODE_KP_TAB: SDL_Scancode = 186;
pub const SDL_SCANCODE_KP_RIGHTBRACE: SDL_Scancode = 185;
pub const SDL_SCANCODE_KP_LEFTBRACE: SDL_Scancode = 184;
pub const SDL_SCANCODE_KP_RIGHTPAREN: SDL_Scancode = 183;
pub const SDL_SCANCODE_KP_LEFTPAREN: SDL_Scancode = 182;
pub const SDL_SCANCODE_CURRENCYSUBUNIT: SDL_Scancode = 181;
pub const SDL_SCANCODE_CURRENCYUNIT: SDL_Scancode = 180;
pub const SDL_SCANCODE_DECIMALSEPARATOR: SDL_Scancode = 179;
pub const SDL_SCANCODE_THOUSANDSSEPARATOR: SDL_Scancode = 178;
pub const SDL_SCANCODE_KP_000: SDL_Scancode = 177;
pub const SDL_SCANCODE_KP_00: SDL_Scancode = 176;
pub const SDL_SCANCODE_EXSEL: SDL_Scancode = 164;
pub const SDL_SCANCODE_CRSEL: SDL_Scancode = 163;
pub const SDL_SCANCODE_CLEARAGAIN: SDL_Scancode = 162;
pub const SDL_SCANCODE_OPER: SDL_Scancode = 161;
pub const SDL_SCANCODE_OUT: SDL_Scancode = 160;
pub const SDL_SCANCODE_SEPARATOR: SDL_Scancode = 159;
pub const SDL_SCANCODE_RETURN2: SDL_Scancode = 158;
pub const SDL_SCANCODE_PRIOR: SDL_Scancode = 157;
pub const SDL_SCANCODE_CLEAR: SDL_Scancode = 156;
pub const SDL_SCANCODE_CANCEL: SDL_Scancode = 155;
pub const SDL_SCANCODE_SYSREQ: SDL_Scancode = 154;
pub const SDL_SCANCODE_ALTERASE: SDL_Scancode = 153;
pub const SDL_SCANCODE_LANG9: SDL_Scancode = 152;
pub const SDL_SCANCODE_LANG8: SDL_Scancode = 151;
pub const SDL_SCANCODE_LANG7: SDL_Scancode = 150;
pub const SDL_SCANCODE_LANG6: SDL_Scancode = 149;
pub const SDL_SCANCODE_LANG5: SDL_Scancode = 148;
pub const SDL_SCANCODE_LANG4: SDL_Scancode = 147;
pub const SDL_SCANCODE_LANG3: SDL_Scancode = 146;
pub const SDL_SCANCODE_LANG2: SDL_Scancode = 145;
pub const SDL_SCANCODE_LANG1: SDL_Scancode = 144;
pub const SDL_SCANCODE_INTERNATIONAL9: SDL_Scancode = 143;
pub const SDL_SCANCODE_INTERNATIONAL8: SDL_Scancode = 142;
pub const SDL_SCANCODE_INTERNATIONAL7: SDL_Scancode = 141;
pub const SDL_SCANCODE_INTERNATIONAL6: SDL_Scancode = 140;
pub const SDL_SCANCODE_INTERNATIONAL5: SDL_Scancode = 139;
pub const SDL_SCANCODE_INTERNATIONAL4: SDL_Scancode = 138;
pub const SDL_SCANCODE_INTERNATIONAL3: SDL_Scancode = 137;
pub const SDL_SCANCODE_INTERNATIONAL2: SDL_Scancode = 136;
pub const SDL_SCANCODE_INTERNATIONAL1: SDL_Scancode = 135;
pub const SDL_SCANCODE_KP_EQUALSAS400: SDL_Scancode = 134;
pub const SDL_SCANCODE_KP_COMMA: SDL_Scancode = 133;
pub const SDL_SCANCODE_VOLUMEDOWN: SDL_Scancode = 129;
pub const SDL_SCANCODE_VOLUMEUP: SDL_Scancode = 128;
pub const SDL_SCANCODE_MUTE: SDL_Scancode = 127;
pub const SDL_SCANCODE_FIND: SDL_Scancode = 126;
pub const SDL_SCANCODE_PASTE: SDL_Scancode = 125;
pub const SDL_SCANCODE_COPY: SDL_Scancode = 124;
pub const SDL_SCANCODE_CUT: SDL_Scancode = 123;
pub const SDL_SCANCODE_UNDO: SDL_Scancode = 122;
pub const SDL_SCANCODE_AGAIN: SDL_Scancode = 121;
pub const SDL_SCANCODE_STOP: SDL_Scancode = 120;
pub const SDL_SCANCODE_SELECT: SDL_Scancode = 119;
pub const SDL_SCANCODE_MENU: SDL_Scancode = 118;
pub const SDL_SCANCODE_HELP: SDL_Scancode = 117;
pub const SDL_SCANCODE_EXECUTE: SDL_Scancode = 116;
pub const SDL_SCANCODE_F24: SDL_Scancode = 115;
pub const SDL_SCANCODE_F23: SDL_Scancode = 114;
pub const SDL_SCANCODE_F22: SDL_Scancode = 113;
pub const SDL_SCANCODE_F21: SDL_Scancode = 112;
pub const SDL_SCANCODE_F20: SDL_Scancode = 111;
pub const SDL_SCANCODE_F19: SDL_Scancode = 110;
pub const SDL_SCANCODE_F18: SDL_Scancode = 109;
pub const SDL_SCANCODE_F17: SDL_Scancode = 108;
pub const SDL_SCANCODE_F16: SDL_Scancode = 107;
pub const SDL_SCANCODE_F15: SDL_Scancode = 106;
pub const SDL_SCANCODE_F14: SDL_Scancode = 105;
pub const SDL_SCANCODE_F13: SDL_Scancode = 104;
pub const SDL_SCANCODE_KP_EQUALS: SDL_Scancode = 103;
pub const SDL_SCANCODE_POWER: SDL_Scancode = 102;
pub const SDL_SCANCODE_APPLICATION: SDL_Scancode = 101;
pub const SDL_SCANCODE_NONUSBACKSLASH: SDL_Scancode = 100;
pub const SDL_SCANCODE_KP_PERIOD: SDL_Scancode = 99;
pub const SDL_SCANCODE_KP_0: SDL_Scancode = 98;
pub const SDL_SCANCODE_KP_9: SDL_Scancode = 97;
pub const SDL_SCANCODE_KP_8: SDL_Scancode = 96;
pub const SDL_SCANCODE_KP_7: SDL_Scancode = 95;
pub const SDL_SCANCODE_KP_6: SDL_Scancode = 94;
pub const SDL_SCANCODE_KP_5: SDL_Scancode = 93;
pub const SDL_SCANCODE_KP_4: SDL_Scancode = 92;
pub const SDL_SCANCODE_KP_3: SDL_Scancode = 91;
pub const SDL_SCANCODE_KP_2: SDL_Scancode = 90;
pub const SDL_SCANCODE_KP_1: SDL_Scancode = 89;
pub const SDL_SCANCODE_KP_ENTER: SDL_Scancode = 88;
pub const SDL_SCANCODE_KP_PLUS: SDL_Scancode = 87;
pub const SDL_SCANCODE_KP_MINUS: SDL_Scancode = 86;
pub const SDL_SCANCODE_KP_MULTIPLY: SDL_Scancode = 85;
pub const SDL_SCANCODE_KP_DIVIDE: SDL_Scancode = 84;
pub const SDL_SCANCODE_NUMLOCKCLEAR: SDL_Scancode = 83;
pub const SDL_SCANCODE_UP: SDL_Scancode = 82;
pub const SDL_SCANCODE_DOWN: SDL_Scancode = 81;
pub const SDL_SCANCODE_LEFT: SDL_Scancode = 80;
pub const SDL_SCANCODE_RIGHT: SDL_Scancode = 79;
pub const SDL_SCANCODE_PAGEDOWN: SDL_Scancode = 78;
pub const SDL_SCANCODE_END: SDL_Scancode = 77;
pub const SDL_SCANCODE_DELETE: SDL_Scancode = 76;
pub const SDL_SCANCODE_PAGEUP: SDL_Scancode = 75;
pub const SDL_SCANCODE_HOME: SDL_Scancode = 74;
pub const SDL_SCANCODE_INSERT: SDL_Scancode = 73;
pub const SDL_SCANCODE_PAUSE: SDL_Scancode = 72;
pub const SDL_SCANCODE_SCROLLLOCK: SDL_Scancode = 71;
pub const SDL_SCANCODE_PRINTSCREEN: SDL_Scancode = 70;
pub const SDL_SCANCODE_F12: SDL_Scancode = 69;
pub const SDL_SCANCODE_F11: SDL_Scancode = 68;
pub const SDL_SCANCODE_F10: SDL_Scancode = 67;
pub const SDL_SCANCODE_F9: SDL_Scancode = 66;
pub const SDL_SCANCODE_F8: SDL_Scancode = 65;
pub const SDL_SCANCODE_F7: SDL_Scancode = 64;
pub const SDL_SCANCODE_F6: SDL_Scancode = 63;
pub const SDL_SCANCODE_F5: SDL_Scancode = 62;
pub const SDL_SCANCODE_F4: SDL_Scancode = 61;
pub const SDL_SCANCODE_F3: SDL_Scancode = 60;
pub const SDL_SCANCODE_F2: SDL_Scancode = 59;
pub const SDL_SCANCODE_F1: SDL_Scancode = 58;
pub const SDL_SCANCODE_CAPSLOCK: SDL_Scancode = 57;
pub const SDL_SCANCODE_SLASH: SDL_Scancode = 56;
pub const SDL_SCANCODE_PERIOD: SDL_Scancode = 55;
pub const SDL_SCANCODE_COMMA: SDL_Scancode = 54;
pub const SDL_SCANCODE_GRAVE: SDL_Scancode = 53;
pub const SDL_SCANCODE_APOSTROPHE: SDL_Scancode = 52;
pub const SDL_SCANCODE_SEMICOLON: SDL_Scancode = 51;
pub const SDL_SCANCODE_NONUSHASH: SDL_Scancode = 50;
pub const SDL_SCANCODE_BACKSLASH: SDL_Scancode = 49;
pub const SDL_SCANCODE_RIGHTBRACKET: SDL_Scancode = 48;
pub const SDL_SCANCODE_LEFTBRACKET: SDL_Scancode = 47;
pub const SDL_SCANCODE_EQUALS: SDL_Scancode = 46;
pub const SDL_SCANCODE_MINUS: SDL_Scancode = 45;
pub const SDL_SCANCODE_SPACE: SDL_Scancode = 44;
pub const SDL_SCANCODE_TAB: SDL_Scancode = 43;
pub const SDL_SCANCODE_BACKSPACE: SDL_Scancode = 42;
pub const SDL_SCANCODE_ESCAPE: SDL_Scancode = 41;
pub const SDL_SCANCODE_RETURN: SDL_Scancode = 40;
pub const SDL_SCANCODE_0: SDL_Scancode = 39;
pub const SDL_SCANCODE_9: SDL_Scancode = 38;
pub const SDL_SCANCODE_8: SDL_Scancode = 37;
pub const SDL_SCANCODE_7: SDL_Scancode = 36;
pub const SDL_SCANCODE_6: SDL_Scancode = 35;
pub const SDL_SCANCODE_5: SDL_Scancode = 34;
pub const SDL_SCANCODE_4: SDL_Scancode = 33;
pub const SDL_SCANCODE_3: SDL_Scancode = 32;
pub const SDL_SCANCODE_2: SDL_Scancode = 31;
pub const SDL_SCANCODE_1: SDL_Scancode = 30;
pub const SDL_SCANCODE_Z: SDL_Scancode = 29;
pub const SDL_SCANCODE_Y: SDL_Scancode = 28;
pub const SDL_SCANCODE_X: SDL_Scancode = 27;
pub const SDL_SCANCODE_W: SDL_Scancode = 26;
pub const SDL_SCANCODE_V: SDL_Scancode = 25;
pub const SDL_SCANCODE_U: SDL_Scancode = 24;
pub const SDL_SCANCODE_T: SDL_Scancode = 23;
pub const SDL_SCANCODE_S: SDL_Scancode = 22;
pub const SDL_SCANCODE_R: SDL_Scancode = 21;
pub const SDL_SCANCODE_Q: SDL_Scancode = 20;
pub const SDL_SCANCODE_P: SDL_Scancode = 19;
pub const SDL_SCANCODE_O: SDL_Scancode = 18;
pub const SDL_SCANCODE_N: SDL_Scancode = 17;
pub const SDL_SCANCODE_M: SDL_Scancode = 16;
pub const SDL_SCANCODE_L: SDL_Scancode = 15;
pub const SDL_SCANCODE_K: SDL_Scancode = 14;
pub const SDL_SCANCODE_J: SDL_Scancode = 13;
pub const SDL_SCANCODE_I: SDL_Scancode = 12;
pub const SDL_SCANCODE_H: SDL_Scancode = 11;
pub const SDL_SCANCODE_G: SDL_Scancode = 10;
pub const SDL_SCANCODE_F: SDL_Scancode = 9;
pub const SDL_SCANCODE_E: SDL_Scancode = 8;
pub const SDL_SCANCODE_D: SDL_Scancode = 7;
pub const SDL_SCANCODE_C: SDL_Scancode = 6;
pub const SDL_SCANCODE_B: SDL_Scancode = 5;
pub const SDL_SCANCODE_A: SDL_Scancode = 4;
pub const SDL_SCANCODE_UNKNOWN: SDL_Scancode = 0;
pub type SDL_Keycode = Sint32;
pub type SDL_KeyCode = libc::c_uint;
pub const SDLK_ENDCALL: SDL_KeyCode = 1073742114;
pub const SDLK_CALL: SDL_KeyCode = 1073742113;
pub const SDLK_SOFTRIGHT: SDL_KeyCode = 1073742112;
pub const SDLK_SOFTLEFT: SDL_KeyCode = 1073742111;
pub const SDLK_AUDIOFASTFORWARD: SDL_KeyCode = 1073742110;
pub const SDLK_AUDIOREWIND: SDL_KeyCode = 1073742109;
pub const SDLK_APP2: SDL_KeyCode = 1073742108;
pub const SDLK_APP1: SDL_KeyCode = 1073742107;
pub const SDLK_SLEEP: SDL_KeyCode = 1073742106;
pub const SDLK_EJECT: SDL_KeyCode = 1073742105;
pub const SDLK_KBDILLUMUP: SDL_KeyCode = 1073742104;
pub const SDLK_KBDILLUMDOWN: SDL_KeyCode = 1073742103;
pub const SDLK_KBDILLUMTOGGLE: SDL_KeyCode = 1073742102;
pub const SDLK_DISPLAYSWITCH: SDL_KeyCode = 1073742101;
pub const SDLK_BRIGHTNESSUP: SDL_KeyCode = 1073742100;
pub const SDLK_BRIGHTNESSDOWN: SDL_KeyCode = 1073742099;
pub const SDLK_AC_BOOKMARKS: SDL_KeyCode = 1073742098;
pub const SDLK_AC_REFRESH: SDL_KeyCode = 1073742097;
pub const SDLK_AC_STOP: SDL_KeyCode = 1073742096;
pub const SDLK_AC_FORWARD: SDL_KeyCode = 1073742095;
pub const SDLK_AC_BACK: SDL_KeyCode = 1073742094;
pub const SDLK_AC_HOME: SDL_KeyCode = 1073742093;
pub const SDLK_AC_SEARCH: SDL_KeyCode = 1073742092;
pub const SDLK_COMPUTER: SDL_KeyCode = 1073742091;
pub const SDLK_CALCULATOR: SDL_KeyCode = 1073742090;
pub const SDLK_MAIL: SDL_KeyCode = 1073742089;
pub const SDLK_WWW: SDL_KeyCode = 1073742088;
pub const SDLK_MEDIASELECT: SDL_KeyCode = 1073742087;
pub const SDLK_AUDIOMUTE: SDL_KeyCode = 1073742086;
pub const SDLK_AUDIOPLAY: SDL_KeyCode = 1073742085;
pub const SDLK_AUDIOSTOP: SDL_KeyCode = 1073742084;
pub const SDLK_AUDIOPREV: SDL_KeyCode = 1073742083;
pub const SDLK_AUDIONEXT: SDL_KeyCode = 1073742082;
pub const SDLK_MODE: SDL_KeyCode = 1073742081;
pub const SDLK_RGUI: SDL_KeyCode = 1073742055;
pub const SDLK_RALT: SDL_KeyCode = 1073742054;
pub const SDLK_RSHIFT: SDL_KeyCode = 1073742053;
pub const SDLK_RCTRL: SDL_KeyCode = 1073742052;
pub const SDLK_LGUI: SDL_KeyCode = 1073742051;
pub const SDLK_LALT: SDL_KeyCode = 1073742050;
pub const SDLK_LSHIFT: SDL_KeyCode = 1073742049;
pub const SDLK_LCTRL: SDL_KeyCode = 1073742048;
pub const SDLK_KP_HEXADECIMAL: SDL_KeyCode = 1073742045;
pub const SDLK_KP_DECIMAL: SDL_KeyCode = 1073742044;
pub const SDLK_KP_OCTAL: SDL_KeyCode = 1073742043;
pub const SDLK_KP_BINARY: SDL_KeyCode = 1073742042;
pub const SDLK_KP_CLEARENTRY: SDL_KeyCode = 1073742041;
pub const SDLK_KP_CLEAR: SDL_KeyCode = 1073742040;
pub const SDLK_KP_PLUSMINUS: SDL_KeyCode = 1073742039;
pub const SDLK_KP_MEMDIVIDE: SDL_KeyCode = 1073742038;
pub const SDLK_KP_MEMMULTIPLY: SDL_KeyCode = 1073742037;
pub const SDLK_KP_MEMSUBTRACT: SDL_KeyCode = 1073742036;
pub const SDLK_KP_MEMADD: SDL_KeyCode = 1073742035;
pub const SDLK_KP_MEMCLEAR: SDL_KeyCode = 1073742034;
pub const SDLK_KP_MEMRECALL: SDL_KeyCode = 1073742033;
pub const SDLK_KP_MEMSTORE: SDL_KeyCode = 1073742032;
pub const SDLK_KP_EXCLAM: SDL_KeyCode = 1073742031;
pub const SDLK_KP_AT: SDL_KeyCode = 1073742030;
pub const SDLK_KP_SPACE: SDL_KeyCode = 1073742029;
pub const SDLK_KP_HASH: SDL_KeyCode = 1073742028;
pub const SDLK_KP_COLON: SDL_KeyCode = 1073742027;
pub const SDLK_KP_DBLVERTICALBAR: SDL_KeyCode = 1073742026;
pub const SDLK_KP_VERTICALBAR: SDL_KeyCode = 1073742025;
pub const SDLK_KP_DBLAMPERSAND: SDL_KeyCode = 1073742024;
pub const SDLK_KP_AMPERSAND: SDL_KeyCode = 1073742023;
pub const SDLK_KP_GREATER: SDL_KeyCode = 1073742022;
pub const SDLK_KP_LESS: SDL_KeyCode = 1073742021;
pub const SDLK_KP_PERCENT: SDL_KeyCode = 1073742020;
pub const SDLK_KP_POWER: SDL_KeyCode = 1073742019;
pub const SDLK_KP_XOR: SDL_KeyCode = 1073742018;
pub const SDLK_KP_F: SDL_KeyCode = 1073742017;
pub const SDLK_KP_E: SDL_KeyCode = 1073742016;
pub const SDLK_KP_D: SDL_KeyCode = 1073742015;
pub const SDLK_KP_C: SDL_KeyCode = 1073742014;
pub const SDLK_KP_B: SDL_KeyCode = 1073742013;
pub const SDLK_KP_A: SDL_KeyCode = 1073742012;
pub const SDLK_KP_BACKSPACE: SDL_KeyCode = 1073742011;
pub const SDLK_KP_TAB: SDL_KeyCode = 1073742010;
pub const SDLK_KP_RIGHTBRACE: SDL_KeyCode = 1073742009;
pub const SDLK_KP_LEFTBRACE: SDL_KeyCode = 1073742008;
pub const SDLK_KP_RIGHTPAREN: SDL_KeyCode = 1073742007;
pub const SDLK_KP_LEFTPAREN: SDL_KeyCode = 1073742006;
pub const SDLK_CURRENCYSUBUNIT: SDL_KeyCode = 1073742005;
pub const SDLK_CURRENCYUNIT: SDL_KeyCode = 1073742004;
pub const SDLK_DECIMALSEPARATOR: SDL_KeyCode = 1073742003;
pub const SDLK_THOUSANDSSEPARATOR: SDL_KeyCode = 1073742002;
pub const SDLK_KP_000: SDL_KeyCode = 1073742001;
pub const SDLK_KP_00: SDL_KeyCode = 1073742000;
pub const SDLK_EXSEL: SDL_KeyCode = 1073741988;
pub const SDLK_CRSEL: SDL_KeyCode = 1073741987;
pub const SDLK_CLEARAGAIN: SDL_KeyCode = 1073741986;
pub const SDLK_OPER: SDL_KeyCode = 1073741985;
pub const SDLK_OUT: SDL_KeyCode = 1073741984;
pub const SDLK_SEPARATOR: SDL_KeyCode = 1073741983;
pub const SDLK_RETURN2: SDL_KeyCode = 1073741982;
pub const SDLK_PRIOR: SDL_KeyCode = 1073741981;
pub const SDLK_CLEAR: SDL_KeyCode = 1073741980;
pub const SDLK_CANCEL: SDL_KeyCode = 1073741979;
pub const SDLK_SYSREQ: SDL_KeyCode = 1073741978;
pub const SDLK_ALTERASE: SDL_KeyCode = 1073741977;
pub const SDLK_KP_EQUALSAS400: SDL_KeyCode = 1073741958;
pub const SDLK_KP_COMMA: SDL_KeyCode = 1073741957;
pub const SDLK_VOLUMEDOWN: SDL_KeyCode = 1073741953;
pub const SDLK_VOLUMEUP: SDL_KeyCode = 1073741952;
pub const SDLK_MUTE: SDL_KeyCode = 1073741951;
pub const SDLK_FIND: SDL_KeyCode = 1073741950;
pub const SDLK_PASTE: SDL_KeyCode = 1073741949;
pub const SDLK_COPY: SDL_KeyCode = 1073741948;
pub const SDLK_CUT: SDL_KeyCode = 1073741947;
pub const SDLK_UNDO: SDL_KeyCode = 1073741946;
pub const SDLK_AGAIN: SDL_KeyCode = 1073741945;
pub const SDLK_STOP: SDL_KeyCode = 1073741944;
pub const SDLK_SELECT: SDL_KeyCode = 1073741943;
pub const SDLK_MENU: SDL_KeyCode = 1073741942;
pub const SDLK_HELP: SDL_KeyCode = 1073741941;
pub const SDLK_EXECUTE: SDL_KeyCode = 1073741940;
pub const SDLK_F24: SDL_KeyCode = 1073741939;
pub const SDLK_F23: SDL_KeyCode = 1073741938;
pub const SDLK_F22: SDL_KeyCode = 1073741937;
pub const SDLK_F21: SDL_KeyCode = 1073741936;
pub const SDLK_F20: SDL_KeyCode = 1073741935;
pub const SDLK_F19: SDL_KeyCode = 1073741934;
pub const SDLK_F18: SDL_KeyCode = 1073741933;
pub const SDLK_F17: SDL_KeyCode = 1073741932;
pub const SDLK_F16: SDL_KeyCode = 1073741931;
pub const SDLK_F15: SDL_KeyCode = 1073741930;
pub const SDLK_F14: SDL_KeyCode = 1073741929;
pub const SDLK_F13: SDL_KeyCode = 1073741928;
pub const SDLK_KP_EQUALS: SDL_KeyCode = 1073741927;
pub const SDLK_POWER: SDL_KeyCode = 1073741926;
pub const SDLK_APPLICATION: SDL_KeyCode = 1073741925;
pub const SDLK_KP_PERIOD: SDL_KeyCode = 1073741923;
pub const SDLK_KP_0: SDL_KeyCode = 1073741922;
pub const SDLK_KP_9: SDL_KeyCode = 1073741921;
pub const SDLK_KP_8: SDL_KeyCode = 1073741920;
pub const SDLK_KP_7: SDL_KeyCode = 1073741919;
pub const SDLK_KP_6: SDL_KeyCode = 1073741918;
pub const SDLK_KP_5: SDL_KeyCode = 1073741917;
pub const SDLK_KP_4: SDL_KeyCode = 1073741916;
pub const SDLK_KP_3: SDL_KeyCode = 1073741915;
pub const SDLK_KP_2: SDL_KeyCode = 1073741914;
pub const SDLK_KP_1: SDL_KeyCode = 1073741913;
pub const SDLK_KP_ENTER: SDL_KeyCode = 1073741912;
pub const SDLK_KP_PLUS: SDL_KeyCode = 1073741911;
pub const SDLK_KP_MINUS: SDL_KeyCode = 1073741910;
pub const SDLK_KP_MULTIPLY: SDL_KeyCode = 1073741909;
pub const SDLK_KP_DIVIDE: SDL_KeyCode = 1073741908;
pub const SDLK_NUMLOCKCLEAR: SDL_KeyCode = 1073741907;
pub const SDLK_UP: SDL_KeyCode = 1073741906;
pub const SDLK_DOWN: SDL_KeyCode = 1073741905;
pub const SDLK_LEFT: SDL_KeyCode = 1073741904;
pub const SDLK_RIGHT: SDL_KeyCode = 1073741903;
pub const SDLK_PAGEDOWN: SDL_KeyCode = 1073741902;
pub const SDLK_END: SDL_KeyCode = 1073741901;
pub const SDLK_DELETE: SDL_KeyCode = 127;
pub const SDLK_PAGEUP: SDL_KeyCode = 1073741899;
pub const SDLK_HOME: SDL_KeyCode = 1073741898;
pub const SDLK_INSERT: SDL_KeyCode = 1073741897;
pub const SDLK_PAUSE: SDL_KeyCode = 1073741896;
pub const SDLK_SCROLLLOCK: SDL_KeyCode = 1073741895;
pub const SDLK_PRINTSCREEN: SDL_KeyCode = 1073741894;
pub const SDLK_F12: SDL_KeyCode = 1073741893;
pub const SDLK_F11: SDL_KeyCode = 1073741892;
pub const SDLK_F10: SDL_KeyCode = 1073741891;
pub const SDLK_F9: SDL_KeyCode = 1073741890;
pub const SDLK_F8: SDL_KeyCode = 1073741889;
pub const SDLK_F7: SDL_KeyCode = 1073741888;
pub const SDLK_F6: SDL_KeyCode = 1073741887;
pub const SDLK_F5: SDL_KeyCode = 1073741886;
pub const SDLK_F4: SDL_KeyCode = 1073741885;
pub const SDLK_F3: SDL_KeyCode = 1073741884;
pub const SDLK_F2: SDL_KeyCode = 1073741883;
pub const SDLK_F1: SDL_KeyCode = 1073741882;
pub const SDLK_CAPSLOCK: SDL_KeyCode = 1073741881;
pub const SDLK_z: SDL_KeyCode = 122;
pub const SDLK_y: SDL_KeyCode = 121;
pub const SDLK_x: SDL_KeyCode = 120;
pub const SDLK_w: SDL_KeyCode = 119;
pub const SDLK_v: SDL_KeyCode = 118;
pub const SDLK_u: SDL_KeyCode = 117;
pub const SDLK_t: SDL_KeyCode = 116;
pub const SDLK_s: SDL_KeyCode = 115;
pub const SDLK_r: SDL_KeyCode = 114;
pub const SDLK_q: SDL_KeyCode = 113;
pub const SDLK_p: SDL_KeyCode = 112;
pub const SDLK_o: SDL_KeyCode = 111;
pub const SDLK_n: SDL_KeyCode = 110;
pub const SDLK_m: SDL_KeyCode = 109;
pub const SDLK_l: SDL_KeyCode = 108;
pub const SDLK_k: SDL_KeyCode = 107;
pub const SDLK_j: SDL_KeyCode = 106;
pub const SDLK_i: SDL_KeyCode = 105;
pub const SDLK_h: SDL_KeyCode = 104;
pub const SDLK_g: SDL_KeyCode = 103;
pub const SDLK_f: SDL_KeyCode = 102;
pub const SDLK_e: SDL_KeyCode = 101;
pub const SDLK_d: SDL_KeyCode = 100;
pub const SDLK_c: SDL_KeyCode = 99;
pub const SDLK_b: SDL_KeyCode = 98;
pub const SDLK_a: SDL_KeyCode = 97;
pub const SDLK_BACKQUOTE: SDL_KeyCode = 96;
pub const SDLK_UNDERSCORE: SDL_KeyCode = 95;
pub const SDLK_CARET: SDL_KeyCode = 94;
pub const SDLK_RIGHTBRACKET: SDL_KeyCode = 93;
pub const SDLK_BACKSLASH: SDL_KeyCode = 92;
pub const SDLK_LEFTBRACKET: SDL_KeyCode = 91;
pub const SDLK_AT: SDL_KeyCode = 64;
pub const SDLK_QUESTION: SDL_KeyCode = 63;
pub const SDLK_GREATER: SDL_KeyCode = 62;
pub const SDLK_EQUALS: SDL_KeyCode = 61;
pub const SDLK_LESS: SDL_KeyCode = 60;
pub const SDLK_SEMICOLON: SDL_KeyCode = 59;
pub const SDLK_COLON: SDL_KeyCode = 58;
pub const SDLK_9: SDL_KeyCode = 57;
pub const SDLK_8: SDL_KeyCode = 56;
pub const SDLK_7: SDL_KeyCode = 55;
pub const SDLK_6: SDL_KeyCode = 54;
pub const SDLK_5: SDL_KeyCode = 53;
pub const SDLK_4: SDL_KeyCode = 52;
pub const SDLK_3: SDL_KeyCode = 51;
pub const SDLK_2: SDL_KeyCode = 50;
pub const SDLK_1: SDL_KeyCode = 49;
pub const SDLK_0: SDL_KeyCode = 48;
pub const SDLK_SLASH: SDL_KeyCode = 47;
pub const SDLK_PERIOD: SDL_KeyCode = 46;
pub const SDLK_MINUS: SDL_KeyCode = 45;
pub const SDLK_COMMA: SDL_KeyCode = 44;
pub const SDLK_PLUS: SDL_KeyCode = 43;
pub const SDLK_ASTERISK: SDL_KeyCode = 42;
pub const SDLK_RIGHTPAREN: SDL_KeyCode = 41;
pub const SDLK_LEFTPAREN: SDL_KeyCode = 40;
pub const SDLK_QUOTE: SDL_KeyCode = 39;
pub const SDLK_AMPERSAND: SDL_KeyCode = 38;
pub const SDLK_DOLLAR: SDL_KeyCode = 36;
pub const SDLK_PERCENT: SDL_KeyCode = 37;
pub const SDLK_HASH: SDL_KeyCode = 35;
pub const SDLK_QUOTEDBL: SDL_KeyCode = 34;
pub const SDLK_EXCLAIM: SDL_KeyCode = 33;
pub const SDLK_SPACE: SDL_KeyCode = 32;
pub const SDLK_TAB: SDL_KeyCode = 9;
pub const SDLK_BACKSPACE: SDL_KeyCode = 8;
pub const SDLK_ESCAPE: SDL_KeyCode = 27;
pub const SDLK_RETURN: SDL_KeyCode = 13;
pub const SDLK_UNKNOWN: SDL_KeyCode = 0;
pub type SDL_Keymod = libc::c_uint;
pub const KMOD_RESERVED: SDL_Keymod = 32768;
pub const KMOD_GUI: SDL_Keymod = 3072;
pub const KMOD_ALT: SDL_Keymod = 768;
pub const KMOD_SHIFT: SDL_Keymod = 3;
pub const KMOD_CTRL: SDL_Keymod = 192;
pub const KMOD_SCROLL: SDL_Keymod = 32768;
pub const KMOD_MODE: SDL_Keymod = 16384;
pub const KMOD_CAPS: SDL_Keymod = 8192;
pub const KMOD_NUM: SDL_Keymod = 4096;
pub const KMOD_RGUI: SDL_Keymod = 2048;
pub const KMOD_LGUI: SDL_Keymod = 1024;
pub const KMOD_RALT: SDL_Keymod = 512;
pub const KMOD_LALT: SDL_Keymod = 256;
pub const KMOD_RCTRL: SDL_Keymod = 128;
pub const KMOD_LCTRL: SDL_Keymod = 64;
pub const KMOD_RSHIFT: SDL_Keymod = 2;
pub const KMOD_LSHIFT: SDL_Keymod = 1;
pub const KMOD_NONE: SDL_Keymod = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_Keysym {
    pub scancode: SDL_Scancode,
    pub sym: SDL_Keycode,
    pub mod_0: Uint16,
    pub unused: Uint32,
}
pub type SDL_JoystickID = Sint32;
pub type SDL_JoystickPowerLevel = libc::c_int;
pub const SDL_JOYSTICK_POWER_MAX: SDL_JoystickPowerLevel = 5;
pub const SDL_JOYSTICK_POWER_WIRED: SDL_JoystickPowerLevel = 4;
pub const SDL_JOYSTICK_POWER_FULL: SDL_JoystickPowerLevel = 3;
pub const SDL_JOYSTICK_POWER_MEDIUM: SDL_JoystickPowerLevel = 2;
pub const SDL_JOYSTICK_POWER_LOW: SDL_JoystickPowerLevel = 1;
pub const SDL_JOYSTICK_POWER_EMPTY: SDL_JoystickPowerLevel = 0;
pub const SDL_JOYSTICK_POWER_UNKNOWN: SDL_JoystickPowerLevel = -1;
pub type SDL_TouchID = Sint64;
pub type SDL_FingerID = Sint64;
pub type SDL_GestureID = Sint64;
pub type C2RustUnnamed = libc::c_uint;
pub const SDL_LASTEVENT: C2RustUnnamed = 65535;
pub const SDL_USEREVENT: C2RustUnnamed = 32768;
pub const SDL_POLLSENTINEL: C2RustUnnamed = 32512;
pub const SDL_RENDER_DEVICE_RESET: C2RustUnnamed = 8193;
pub const SDL_RENDER_TARGETS_RESET: C2RustUnnamed = 8192;
pub const SDL_SENSORUPDATE: C2RustUnnamed = 4608;
pub const SDL_AUDIODEVICEREMOVED: C2RustUnnamed = 4353;
pub const SDL_AUDIODEVICEADDED: C2RustUnnamed = 4352;
pub const SDL_DROPCOMPLETE: C2RustUnnamed = 4099;
pub const SDL_DROPBEGIN: C2RustUnnamed = 4098;
pub const SDL_DROPTEXT: C2RustUnnamed = 4097;
pub const SDL_DROPFILE: C2RustUnnamed = 4096;
pub const SDL_CLIPBOARDUPDATE: C2RustUnnamed = 2304;
pub const SDL_MULTIGESTURE: C2RustUnnamed = 2050;
pub const SDL_DOLLARRECORD: C2RustUnnamed = 2049;
pub const SDL_DOLLARGESTURE: C2RustUnnamed = 2048;
pub const SDL_FINGERMOTION: C2RustUnnamed = 1794;
pub const SDL_FINGERUP: C2RustUnnamed = 1793;
pub const SDL_FINGERDOWN: C2RustUnnamed = 1792;
pub const SDL_CONTROLLERSENSORUPDATE: C2RustUnnamed = 1625;
pub const SDL_CONTROLLERTOUCHPADUP: C2RustUnnamed = 1624;
pub const SDL_CONTROLLERTOUCHPADMOTION: C2RustUnnamed = 1623;
pub const SDL_CONTROLLERTOUCHPADDOWN: C2RustUnnamed = 1622;
pub const SDL_CONTROLLERDEVICEREMAPPED: C2RustUnnamed = 1621;
pub const SDL_CONTROLLERDEVICEREMOVED: C2RustUnnamed = 1620;
pub const SDL_CONTROLLERDEVICEADDED: C2RustUnnamed = 1619;
pub const SDL_CONTROLLERBUTTONUP: C2RustUnnamed = 1618;
pub const SDL_CONTROLLERBUTTONDOWN: C2RustUnnamed = 1617;
pub const SDL_CONTROLLERAXISMOTION: C2RustUnnamed = 1616;
pub const SDL_JOYBATTERYUPDATED: C2RustUnnamed = 1543;
pub const SDL_JOYDEVICEREMOVED: C2RustUnnamed = 1542;
pub const SDL_JOYDEVICEADDED: C2RustUnnamed = 1541;
pub const SDL_JOYBUTTONUP: C2RustUnnamed = 1540;
pub const SDL_JOYBUTTONDOWN: C2RustUnnamed = 1539;
pub const SDL_JOYHATMOTION: C2RustUnnamed = 1538;
pub const SDL_JOYBALLMOTION: C2RustUnnamed = 1537;
pub const SDL_JOYAXISMOTION: C2RustUnnamed = 1536;
pub const SDL_MOUSEWHEEL: C2RustUnnamed = 1027;
pub const SDL_MOUSEBUTTONUP: C2RustUnnamed = 1026;
pub const SDL_MOUSEBUTTONDOWN: C2RustUnnamed = 1025;
pub const SDL_MOUSEMOTION: C2RustUnnamed = 1024;
pub const SDL_TEXTEDITING_EXT: C2RustUnnamed = 773;
pub const SDL_KEYMAPCHANGED: C2RustUnnamed = 772;
pub const SDL_TEXTINPUT: C2RustUnnamed = 771;
pub const SDL_TEXTEDITING: C2RustUnnamed = 770;
pub const SDL_KEYUP: C2RustUnnamed = 769;
pub const SDL_KEYDOWN: C2RustUnnamed = 768;
pub const SDL_SYSWMEVENT: C2RustUnnamed = 513;
pub const SDL_WINDOWEVENT: C2RustUnnamed = 512;
pub const SDL_DISPLAYEVENT: C2RustUnnamed = 336;
pub const SDL_LOCALECHANGED: C2RustUnnamed = 263;
pub const SDL_APP_DIDENTERFOREGROUND: C2RustUnnamed = 262;
pub const SDL_APP_WILLENTERFOREGROUND: C2RustUnnamed = 261;
pub const SDL_APP_DIDENTERBACKGROUND: C2RustUnnamed = 260;
pub const SDL_APP_WILLENTERBACKGROUND: C2RustUnnamed = 259;
pub const SDL_APP_LOWMEMORY: C2RustUnnamed = 258;
pub const SDL_APP_TERMINATING: C2RustUnnamed = 257;
pub const SDL_QUIT: C2RustUnnamed = 256;
pub const SDL_FIRSTEVENT: C2RustUnnamed = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_CommonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DisplayEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub display: Uint32,
    pub event: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub data1: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_WindowEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub event: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub data1: Sint32,
    pub data2: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_KeyboardEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub state: Uint8,
    pub repeat: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub keysym: SDL_Keysym,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextEditingEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: [libc::c_char; 32],
    pub start: Sint32,
    pub length: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextEditingExtEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: *mut libc::c_char,
    pub start: Sint32,
    pub length: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextInputEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: [libc::c_char; 32],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseMotionEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub state: Uint32,
    pub x: Sint32,
    pub y: Sint32,
    pub xrel: Sint32,
    pub yrel: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub button: Uint8,
    pub state: Uint8,
    pub clicks: Uint8,
    pub padding1: Uint8,
    pub x: Sint32,
    pub y: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseWheelEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub x: Sint32,
    pub y: Sint32,
    pub direction: Uint32,
    pub preciseX: libc::c_float,
    pub preciseY: libc::c_float,
    pub mouseX: Sint32,
    pub mouseY: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyAxisEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub axis: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub value: Sint16,
    pub padding4: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyBallEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub ball: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub xrel: Sint16,
    pub yrel: Sint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyHatEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub hat: Uint8,
    pub value: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub button: Uint8,
    pub state: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyBatteryEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub level: SDL_JoystickPowerLevel,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerAxisEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub axis: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub value: Sint16,
    pub padding4: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub button: Uint8,
    pub state: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerTouchpadEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub touchpad: Sint32,
    pub finger: Sint32,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub pressure: libc::c_float,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerSensorEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub sensor: Sint32,
    pub data: [libc::c_float; 3],
    pub timestamp_us: Uint64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_AudioDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Uint32,
    pub iscapture: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TouchFingerEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub fingerId: SDL_FingerID,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub dx: libc::c_float,
    pub dy: libc::c_float,
    pub pressure: libc::c_float,
    pub windowID: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MultiGestureEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub dTheta: libc::c_float,
    pub dDist: libc::c_float,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub numFingers: Uint16,
    pub padding: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DollarGestureEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub gestureId: SDL_GestureID,
    pub numFingers: Uint32,
    pub error: libc::c_float,
    pub x: libc::c_float,
    pub y: libc::c_float,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DropEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub file: *mut libc::c_char,
    pub windowID: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_SensorEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
    pub data: [libc::c_float; 6],
    pub timestamp_us: Uint64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_QuitEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_UserEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub code: Sint32,
    pub data1: *mut libc::c_void,
    pub data2: *mut libc::c_void,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_SysWMEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub msg: *mut SDL_SysWMmsg,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union SDL_Event {
    pub type_0: Uint32,
    pub common: SDL_CommonEvent,
    pub display: SDL_DisplayEvent,
    pub window: SDL_WindowEvent,
    pub key: SDL_KeyboardEvent,
    pub edit: SDL_TextEditingEvent,
    pub editExt: SDL_TextEditingExtEvent,
    pub text: SDL_TextInputEvent,
    pub motion: SDL_MouseMotionEvent,
    pub button: SDL_MouseButtonEvent,
    pub wheel: SDL_MouseWheelEvent,
    pub jaxis: SDL_JoyAxisEvent,
    pub jball: SDL_JoyBallEvent,
    pub jhat: SDL_JoyHatEvent,
    pub jbutton: SDL_JoyButtonEvent,
    pub jdevice: SDL_JoyDeviceEvent,
    pub jbattery: SDL_JoyBatteryEvent,
    pub caxis: SDL_ControllerAxisEvent,
    pub cbutton: SDL_ControllerButtonEvent,
    pub cdevice: SDL_ControllerDeviceEvent,
    pub ctouchpad: SDL_ControllerTouchpadEvent,
    pub csensor: SDL_ControllerSensorEvent,
    pub adevice: SDL_AudioDeviceEvent,
    pub sensor: SDL_SensorEvent,
    pub quit: SDL_QuitEvent,
    pub user: SDL_UserEvent,
    pub syswm: SDL_SysWMEvent,
    pub tfinger: SDL_TouchFingerEvent,
    pub mgesture: SDL_MultiGestureEvent,
    pub dgesture: SDL_DollarGestureEvent,
    pub drop: SDL_DropEvent,
    pub padding: [Uint8; 56],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Event {
    pub event_type: int64_t,
    pub key: int64_t,
    pub button: int64_t,
    pub x: int64_t,
    pub y: int64_t,
    pub prev_x: int64_t,
    pub prev_y: int64_t,
    pub mod_0: int64_t,
    pub rune: int64_t,
    pub in_menu: bool,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct EventsSlice {
    pub events: *mut Event,
    pub nevents: libc::c_int,
}
pub type bool32_t = uint32_t;
pub const EventTypeTypedRune: C2RustUnnamed_0 = 7;
pub const EventTypeQuit: C2RustUnnamed_0 = 6;
pub const MouseButtonMiddle: C2RustUnnamed_1 = 3;
pub const MouseButtonRight: C2RustUnnamed_1 = 2;
pub const MouseButtonLeft: C2RustUnnamed_1 = 1;
pub const EventTypeMouseMove: C2RustUnnamed_0 = 5;
pub const EventTypeMouseButtonRelease: C2RustUnnamed_0 = 4;
pub const EventTypeMouseButtonPress: C2RustUnnamed_0 = 3;
pub const ModFirst: C2RustUnnamed_2 = 1;
pub const ModShift: C2RustUnnamed_2 = 8;
pub const ModMeta: C2RustUnnamed_2 = 4;
pub const ModControl: C2RustUnnamed_2 = 2;
pub const ModAlt: C2RustUnnamed_2 = 1;
pub const ModLast: C2RustUnnamed_2 = 8;
pub const EventTypeKeyRelease: C2RustUnnamed_0 = 2;
pub const EventTypeKeyPress: C2RustUnnamed_0 = 1;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const EventTypeNone: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const MouseButtonUnknown: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const ModNone: C2RustUnnamed_2 = 0;
#[no_mangle]
pub static mut cur_replay_logic_tick: libc::c_int = 0 as libc::c_int;
#[no_mangle]
pub static mut cur_replay_event: libc::c_int = 0 as libc::c_int;
#[no_mangle]
pub unsafe extern "C" fn parse_replay_for_logic_tick(
    mut logic_tick: libc::c_int,
) -> bool {
    let mut replay_path: [libc::c_char; 260] = [0; 260];
    snprintf(
        replay_path.as_mut_ptr(),
        ::core::mem::size_of::<[libc::c_char; 260]>() as libc::c_ulong,
        b"_replay_/replay_%06d.json\0" as *const u8 as *const libc::c_char,
        logic_tick,
    );
    let mut tries: libc::c_int = 0 as libc::c_int;
    while tries < 10000 as libc::c_int {
        if parse_replay(replay_path.as_mut_ptr()) {
            return 1 as libc::c_int != 0;
        }
        SDL_Delay(100 as libc::c_int as Uint32);
        tries += 1;
        tries;
    }
    return 0 as libc::c_int != 0;
}
#[no_mangle]
pub unsafe extern "C" fn inputPollEvent(mut e: *mut SDL_Event) -> bool32_t {
    let mut has_replay: bool = !events_from_logic_tick.is_null()
        && replay_started as libc::c_int != 0;
    if !has_replay {
        return SDL_PollEvent(e) as bool32_t;
    }
    let mut skip: SDL_Event = SDL_Event { type_0: 0 };
    while SDL_PollEvent(&mut skip) != 0 {
        if skip.type_0 >= SDL_USEREVENT as libc::c_int as Uint32 {
            *e = skip;
            _logf(b"forwarding user event\0" as *const u8 as *const libc::c_char);
            _logf(
                b"   forwarded e.type: %d\0" as *const u8 as *const libc::c_char,
                skip.type_0,
            );
            return 1 as libc::c_int as bool32_t;
        } else {
            SDL_PollEvent(&mut skip);
            _logf(b"ignoring event\0" as *const u8 as *const libc::c_char);
            _logf(
                b"   ignored e.type: %d\0" as *const u8 as *const libc::c_char,
                skip.type_0,
            );
        }
    }
    if cur_replay_logic_tick >= realtime_replay_logic_ticks_offset + replay_nlogic_ticks
    {
        realtime_replay_logic_ticks_offset += replay_nlogic_ticks;
        if !parse_replay_for_logic_tick(cur_replay_logic_tick) {
            _logf(
                b"replay finished (cur logic tick=%d, replay logic ticks=%d)\0"
                    as *const u8 as *const libc::c_char,
                cur_replay_logic_tick,
                replay_nlogic_ticks,
            );
            return 0 as libc::c_int as bool32_t;
        }
    }
    if cur_replay_logic_tick < sgdwGameLoops as libc::c_int {
        cur_replay_event = 0 as libc::c_int;
        cur_replay_logic_tick += 1;
        cur_replay_logic_tick;
        if cur_replay_logic_tick != sgdwGameLoops as libc::c_int {
            _logf(
                b"missed emitting replay events between logic tick=%d and logic tick=%d\0"
                    as *const u8 as *const libc::c_char,
                cur_replay_logic_tick,
                sgdwGameLoops,
            );
            cur_replay_logic_tick = sgdwGameLoops as libc::c_int;
        }
    }
    let mut events_slice: EventsSlice = *events_from_logic_tick
        .offset((cur_replay_logic_tick - realtime_replay_logic_ticks_offset) as isize);
    if cur_replay_event >= events_slice.nevents {
        return 0 as libc::c_int as bool32_t;
    }
    let mut event: Event = *(events_slice.events).offset(cur_replay_event as isize);
    _logf(
        b"replaying events[logic tick=%d][event %d of %d]\0" as *const u8
            as *const libc::c_char,
        cur_replay_logic_tick,
        cur_replay_event,
        events_slice.nevents,
    );
    _logf(
        b"      event_type: %d\0" as *const u8 as *const libc::c_char,
        event.event_type,
    );
    _logf(b"      key: %d\0" as *const u8 as *const libc::c_char, event.key);
    _logf(b"      button: %d\0" as *const u8 as *const libc::c_char, event.button);
    _logf(b"      x: %d\0" as *const u8 as *const libc::c_char, event.x);
    _logf(b"      y: %d\0" as *const u8 as *const libc::c_char, event.y);
    _logf(b"      prev_x: %d\0" as *const u8 as *const libc::c_char, event.prev_x);
    _logf(b"      prev_y: %d\0" as *const u8 as *const libc::c_char, event.prev_y);
    _logf(b"      mod: %d\0" as *const u8 as *const libc::c_char, event.mod_0);
    _logf(b"      rune: %d\0" as *const u8 as *const libc::c_char, event.rune);
    _logf(
        b"      in_menu: %d\0" as *const u8 as *const libc::c_char,
        event.in_menu as libc::c_int,
    );
    let mut new_event: SDL_Event = SDL_Event { type_0: 0 };
    memset(
        &mut new_event as *mut SDL_Event as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<SDL_Event>() as libc::c_ulong,
    );
    new_event.common.timestamp = SDL_GetTicks();
    let mut sdl_kmod: SDL_Keymod = sdl_keymod_from_mod(event.mod_0 as libc::c_int);
    SDL_SetModState(sdl_kmod);
    match event.event_type {
        1 => {
            new_event.key.type_0 = SDL_KEYDOWN as libc::c_int as Uint32;
            new_event.key.state = 1 as libc::c_int as Uint8;
            new_event
                .key
                .keysym
                .sym = sdl_keycode_from_key(event.key as libc::c_int) as SDL_Keycode;
            new_event.key.keysym.mod_0 = sdl_kmod as Uint16;
            *e = new_event;
        }
        2 => {
            new_event.key.type_0 = SDL_KEYUP as libc::c_int as Uint32;
            new_event.key.state = 0 as libc::c_int as Uint8;
            new_event
                .key
                .keysym
                .sym = sdl_keycode_from_key(event.key as libc::c_int) as SDL_Keycode;
            new_event.key.keysym.mod_0 = sdl_kmod as Uint16;
            *e = new_event;
        }
        3 => {
            new_event.button.type_0 = SDL_MOUSEBUTTONDOWN as libc::c_int as Uint32;
            new_event.button.state = 1 as libc::c_int as Uint8;
            new_event
                .button
                .button = sdl_mouse_button_from_button(event.button as libc::c_int)
                as Uint8;
            new_event.button.clicks = 1 as libc::c_int as Uint8;
            new_event.button.x = event.x as Sint32;
            new_event.button.y = event.y as Sint32;
            *e = new_event;
        }
        4 => {
            new_event.button.type_0 = SDL_MOUSEBUTTONUP as libc::c_int as Uint32;
            new_event.button.state = 0 as libc::c_int as Uint8;
            new_event
                .button
                .button = sdl_mouse_button_from_button(event.button as libc::c_int)
                as Uint8;
            new_event.button.clicks = 1 as libc::c_int as Uint8;
            new_event.button.x = event.x as Sint32;
            new_event.button.y = event.y as Sint32;
            *e = new_event;
        }
        5 => {
            new_event.motion.type_0 = SDL_MOUSEMOTION as libc::c_int as Uint32;
            match event.button {
                1 => {
                    new_event.motion.state
                        |= ((1 as libc::c_int) << 1 as libc::c_int - 1 as libc::c_int)
                            as Uint32;
                }
                2 => {
                    new_event.motion.state
                        |= ((1 as libc::c_int) << 3 as libc::c_int - 1 as libc::c_int)
                            as Uint32;
                }
                3 => {
                    new_event.motion.state
                        |= ((1 as libc::c_int) << 2 as libc::c_int - 1 as libc::c_int)
                            as Uint32;
                }
                _ => {}
            }
            new_event.motion.x = event.x as Sint32;
            new_event.motion.y = event.y as Sint32;
            new_event.motion.xrel = (event.x - event.prev_x) as Sint32;
            new_event.motion.yrel = (event.y - event.prev_y) as Sint32;
            *e = new_event;
        }
        6 => {
            new_event.quit.type_0 = SDL_QUIT as libc::c_int as Uint32;
            *e = new_event;
        }
        7 => {
            new_event.text.type_0 = SDL_TEXTINPUT as libc::c_int as Uint32;
            new_event.text.text[0 as libc::c_int as usize] = event.rune as libc::c_char;
            new_event.text.text[1 as libc::c_int as usize] = '\0' as i32 as libc::c_char;
            _logf(
                b"event type rune: '%c'\0" as *const u8 as *const libc::c_char,
                new_event.text.text[0 as libc::c_int as usize] as libc::c_int,
            );
            *e = new_event;
        }
        _ => {}
    }
    cur_replay_event += 1;
    cur_replay_event;
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn sdl_keycode_from_key(mut key: libc::c_int) -> SDL_KeyCode {
    match key {
        0 => return SDLK_UNKNOWN,
        48 | 49 | 50 | 51 | 52 | 53 | 54 | 55 | 56 | 57 => return key as SDL_KeyCode,
        97 | 98 | 99 | 100 | 101 | 102 | 103 | 104 | 105 | 106 | 107 | 108 | 109 | 110
        | 111 | 112 | 113 | 114 | 115 | 116 | 117 | 118 | 119 | 120 | 121 | 122 => {
            return (key - 'a' as i32 + 'A' as i32) as SDL_KeyCode;
        }
        45 => return SDLK_MINUS,
        9 => return SDLK_TAB,
        32 => return SDLK_SPACE,
        128 => return SDLK_ESCAPE,
        129 => return SDLK_F1,
        130 => return SDLK_F2,
        131 => return SDLK_F3,
        132 => return SDLK_F4,
        133 => return SDLK_F5,
        134 => return SDLK_F6,
        135 => return SDLK_F7,
        136 => return SDLK_F8,
        137 => return SDLK_F9,
        138 => return SDLK_F10,
        139 => return SDLK_F11,
        140 => return SDLK_F12,
        141 => return SDLK_PRINTSCREEN,
        142 => return SDLK_SCROLLLOCK,
        143 => return SDLK_PAUSE,
        144 => return SDLK_INSERT,
        145 => return SDLK_DELETE,
        146 => return SDLK_HOME,
        147 => return SDLK_END,
        148 => return SDLK_PAGEUP,
        149 => return SDLK_PAGEDOWN,
        150 => return SDLK_BACKSPACE,
        151 => return SDLK_CAPSLOCK,
        152 => return SDLK_RETURN,
        153 => return SDLK_MENU,
        154 => return SDLK_UP,
        155 => return SDLK_DOWN,
        156 => return SDLK_LEFT,
        157 => return SDLK_RIGHT,
        158 => return SDLK_KP_0,
        159 => return SDLK_KP_1,
        160 => return SDLK_KP_2,
        161 => return SDLK_KP_3,
        162 => return SDLK_KP_4,
        163 => return SDLK_KP_5,
        164 => return SDLK_KP_6,
        165 => return SDLK_KP_7,
        166 => return SDLK_KP_8,
        167 => return SDLK_KP_9,
        168 => return SDLK_KP_PLUS,
        169 => return SDLK_KP_PERIOD,
        170 => return SDLK_KP_DIVIDE,
        171 => return SDLK_KP_ENTER,
        173 => return SDLK_KP_MULTIPLY,
        174 => return SDLK_KP_MINUS,
        175 => return SDLK_NUMLOCKCLEAR,
        _ => {}
    }
    _logf(
        b"support for translating key %d not yet implemented\0" as *const u8
            as *const libc::c_char,
        key,
    );
    return SDLK_UNKNOWN;
}
#[no_mangle]
pub unsafe extern "C" fn sdl_keymod_from_mod(mut mod_0: libc::c_int) -> SDL_Keymod {
    let mut sdl_kmod: SDL_Keymod = KMOD_NONE;
    let mut mask: libc::c_int = ModFirst as libc::c_int;
    while mask <= ModLast as libc::c_int {
        if !(mod_0 & mask == 0 as libc::c_int) {
            match mask {
                1 => {
                    sdl_kmod = ::core::mem::transmute::<
                        libc::c_uint,
                        SDL_Keymod,
                    >(
                        sdl_kmod as libc::c_uint
                            | KMOD_ALT as libc::c_int as libc::c_uint,
                    );
                }
                2 => {
                    sdl_kmod = ::core::mem::transmute::<
                        libc::c_uint,
                        SDL_Keymod,
                    >(
                        sdl_kmod as libc::c_uint
                            | KMOD_CTRL as libc::c_int as libc::c_uint,
                    );
                }
                4 => {
                    sdl_kmod = ::core::mem::transmute::<
                        libc::c_uint,
                        SDL_Keymod,
                    >(
                        sdl_kmod as libc::c_uint
                            | KMOD_GUI as libc::c_int as libc::c_uint,
                    );
                }
                8 => {
                    sdl_kmod = ::core::mem::transmute::<
                        libc::c_uint,
                        SDL_Keymod,
                    >(
                        sdl_kmod as libc::c_uint
                            | KMOD_SHIFT as libc::c_int as libc::c_uint,
                    );
                }
                _ => {
                    _logf(
                        b"support for translating modifier %d not yet implemented\0"
                            as *const u8 as *const libc::c_char,
                        mask,
                    );
                }
            }
        }
        mask <<= 1 as libc::c_int;
    }
    return sdl_kmod;
}
#[no_mangle]
pub unsafe extern "C" fn sdl_mouse_button_from_button(
    mut button: libc::c_int,
) -> libc::c_int {
    match button {
        1 => return 1 as libc::c_int,
        2 => return 3 as libc::c_int,
        3 => return 2 as libc::c_int,
        0 => return 0 as libc::c_int,
        _ => {
            _logf(
                b"support for translating button %d not yet implemented\0" as *const u8
                    as *const libc::c_char,
                button,
            );
            return 0 as libc::c_int;
        }
    };
}
