use ::libc;
extern "C" {
    static mut gpBuffer: *mut uint32_t;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn DecodeFullCelL(
        pDecodeTo: *mut uint32_t,
        pRLEBytes: *mut uint8_t,
        frame_size: int32_t,
        nWidth: int32_t,
    );
    fn GetCelFrame(
        pCelBuff: *mut uint8_t,
        nCel: int32_t,
        frame_size: *mut int32_t,
    ) -> *mut uint8_t;
    static mut svgamode: bool32_t;
    static mut leveltype: uint8_t;
    static mut dung_map_r: [[uint8_t; 112]; 112];
    static mut dung_map_g: [[uint8_t; 112]; 112];
    static mut dung_map_b: [[uint8_t; 112]; 112];
    static mut sgCurr: [PaletteStruct; 256];
    static mut gpPalette: [uint32_t; 256];
    static mut nTrans: bool32_t;
    static mut glClipY: *mut uint32_t;
    static mut nBuffWTbl: [int32_t; 1024];
}
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const DEBUG: C2RustUnnamed = 1;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const G_BRIGHT_LIGHTS: C2RustUnnamed_0 = 0;
pub const USE_GOURAUD: C2RustUnnamed_0 = 0;
pub const ORIG_LIGHTING: C2RustUnnamed_0 = 1;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_1 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_1 = 92160;
pub const BTMBUFFY: C2RustUnnamed_1 = 144;
pub const BTMBUFFX: C2RustUnnamed_1 = 640;
pub const BUFFERSIZE: C2RustUnnamed_1 = 503808;
pub const BUFFERY: C2RustUnnamed_1 = 656;
pub const BUFFERX: C2RustUnnamed_1 = 768;
pub const GAMEY: C2RustUnnamed_1 = 352;
pub const CTRLPANY: C2RustUnnamed_1 = 128;
pub const TOTALY: C2RustUnnamed_1 = 480;
pub const TOTALX: C2RustUnnamed_1 = 640;
pub const MAX_PLRS: C2RustUnnamed_1 = 4;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct PaletteStruct {
    pub peBlue: uint8_t,
    pub peGreen: uint8_t,
    pub peRed: uint8_t,
    pub peFlags: uint8_t,
}
pub type C2RustUnnamed_2 = libc::c_uint;
pub const G_THRESHOLD: C2RustUnnamed_2 = 1;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GourColor {
    pub R: [uint8_t; 256],
    pub G: [uint8_t; 256],
    pub B: [uint8_t; 256],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct RgbData {
    pub r1: libc::c_int,
    pub g1: libc::c_int,
    pub b1: libc::c_int,
    pub r2: libc::c_int,
    pub g2: libc::c_int,
    pub b2: libc::c_int,
    pub r3: libc::c_int,
    pub g3: libc::c_int,
    pub b3: libc::c_int,
    pub r4: libc::c_int,
    pub g4: libc::c_int,
    pub b4: libc::c_int,
}
#[no_mangle]
pub static mut tile_height: libc::c_int = 160 as libc::c_int;
#[no_mangle]
pub static mut tile_skip: libc::c_int = 0 as libc::c_int;
#[no_mangle]
pub static mut GColorsTbl: [GourColor; 256] = [GourColor {
    R: [0; 256],
    G: [0; 256],
    B: [0; 256],
}; 256];
#[no_mangle]
pub static mut showlightmap: bool32_t = 0 as libc::c_int as bool32_t;
#[no_mangle]
pub static mut Rgb: RgbData = RgbData {
    r1: 0,
    g1: 0,
    b1: 0,
    r2: 0,
    g2: 0,
    b2: 0,
    r3: 0,
    g3: 0,
    b3: 0,
    r4: 0,
    g4: 0,
    b4: 0,
};
#[no_mangle]
pub static mut RgbVals: [[[uint8_t; 64]; 128]; 128] = [[[0; 64]; 128]; 128];
#[no_mangle]
pub unsafe extern "C" fn MakeTTbls(mut range: libc::c_int) {
    if DEBUG as libc::c_int != 0 {
        if showlightmap != 0 {
            let mut i: libc::c_int = 0 as libc::c_int;
            while i < range {
                let mut j: libc::c_int = 0 as libc::c_int;
                while j < 256 as libc::c_int {
                    GColorsTbl[i as usize].R[j as usize] = j as uint8_t;
                    GColorsTbl[i as usize].G[j as usize] = j as uint8_t;
                    GColorsTbl[i as usize].B[j as usize] = j as uint8_t;
                    j += 1;
                    j;
                }
                i += 1;
                i;
            }
            return;
        }
    }
    let mut i_0: libc::c_int = 0 as libc::c_int;
    while i_0 < range {
        let mut j_0: libc::c_int = 0 as libc::c_int;
        while j_0 < 256 as libc::c_int {
            if leveltype as libc::c_int == 3 as libc::c_int && i_0 < 32 as libc::c_int {
                GColorsTbl[i_0 as usize].R[j_0 as usize] = sgCurr[i_0 as usize].peRed;
                GColorsTbl[i_0 as usize].G[j_0 as usize] = sgCurr[i_0 as usize].peGreen;
                GColorsTbl[i_0 as usize].B[j_0 as usize] = sgCurr[i_0 as usize].peBlue;
            } else if G_BRIGHT_LIGHTS as libc::c_int == 0 {
                GColorsTbl[i_0 as usize]
                    .R[j_0
                    as usize] = (sgCurr[i_0 as usize].peRed as libc::c_int * j_0
                    >> 8 as libc::c_int) as uint8_t;
                GColorsTbl[i_0 as usize]
                    .G[j_0
                    as usize] = (sgCurr[i_0 as usize].peGreen as libc::c_int * j_0
                    >> 8 as libc::c_int) as uint8_t;
                GColorsTbl[i_0 as usize]
                    .B[j_0
                    as usize] = (sgCurr[i_0 as usize].peBlue as libc::c_int * j_0
                    >> 8 as libc::c_int) as uint8_t;
            } else {
                let mut tr: uint32_t = 0;
                tr = (sgCurr[i_0 as usize].peRed as libc::c_int * j_0
                    >> 7 as libc::c_int) as uint32_t;
                if tr > 255 as libc::c_int as uint32_t {
                    tr = 255 as libc::c_int as uint32_t;
                }
                GColorsTbl[i_0 as usize].R[j_0 as usize] = tr as uint8_t;
                tr = (sgCurr[i_0 as usize].peGreen as libc::c_int * j_0
                    >> 7 as libc::c_int) as uint32_t;
                if tr > 255 as libc::c_int as uint32_t {
                    tr = 255 as libc::c_int as uint32_t;
                }
                GColorsTbl[i_0 as usize].G[j_0 as usize] = tr as uint8_t;
                tr = (sgCurr[i_0 as usize].peBlue as libc::c_int * j_0
                    >> 7 as libc::c_int) as uint32_t;
                if tr > 255 as libc::c_int as uint32_t {
                    tr = 255 as libc::c_int as uint32_t;
                }
                GColorsTbl[i_0 as usize].B[j_0 as usize] = tr as uint8_t;
            }
            j_0 += 1;
            j_0;
        }
        i_0 += 1;
        i_0;
    }
}
#[no_mangle]
pub unsafe extern "C" fn MakeVals() {
    let mut i: libc::c_int = 0;
    let mut j: libc::c_int = 0;
    let mut k: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < 256 as libc::c_int >> G_THRESHOLD as libc::c_int {
        j = 0 as libc::c_int;
        while j < 256 as libc::c_int >> G_THRESHOLD as libc::c_int {
            k = 0 as libc::c_int;
            while k < 64 as libc::c_int {
                let mut jdist: libc::c_int = 64 as libc::c_int - k;
                let mut lr2: libc::c_int = (i << G_THRESHOLD as libc::c_int) * jdist
                    + (j << G_THRESHOLD as libc::c_int) * k;
                RgbVals[i
                    as usize][j
                    as usize][k as usize] = (lr2 / 64 as libc::c_int) as uint8_t;
                k += 1;
                k;
            }
            j += 1;
            j;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn GetGCol32_Fast(
    mut i: libc::c_int,
    mut j: libc::c_int,
    mut rrr: *mut libc::c_int,
    mut ggg: *mut libc::c_int,
    mut bbb: *mut libc::c_int,
) {
    let mut dist: libc::c_int = tile_height;
    let mut idist: libc::c_int = dist - i;
    let mut lr2: libc::c_int = RgbVals[Rgb.r1 as usize][Rgb.r2 as usize][j as usize]
        as libc::c_int * idist;
    let mut lg2: libc::c_int = RgbVals[Rgb.g1 as usize][Rgb.g2 as usize][j as usize]
        as libc::c_int * idist;
    let mut lb2: libc::c_int = RgbVals[Rgb.b1 as usize][Rgb.b2 as usize][j as usize]
        as libc::c_int * idist;
    let mut lr3: libc::c_int = RgbVals[Rgb.r3 as usize][Rgb.r4 as usize][j as usize]
        as libc::c_int * i;
    let mut lg3: libc::c_int = RgbVals[Rgb.g3 as usize][Rgb.g4 as usize][j as usize]
        as libc::c_int * i;
    let mut lb3: libc::c_int = RgbVals[Rgb.b3 as usize][Rgb.b4 as usize][j as usize]
        as libc::c_int * i;
    *rrr = (lr2 + lr3) / dist;
    *ggg = (lg2 + lg3) / dist;
    *bbb = (lb2 + lb3) / dist;
}
#[no_mangle]
pub unsafe extern "C" fn DecodeFullCelG_Fast(
    mut pDecodeTo: *mut uint32_t,
    mut pRLEBytes: *mut uint8_t,
    mut lRLECount: int32_t,
    mut nWidth: int32_t,
    mut sx: libc::c_int,
    mut sy: libc::c_int,
) {
    let mut w: int32_t = 0;
    let mut rle: uint8_t = 0;
    let mut clip: *mut uint32_t = if svgamode != 0 {
        &mut *gpBuffer
            .offset(
                ((0 as libc::c_int + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    } else {
        &mut *gpBuffer
            .offset(
                ((-(17 as libc::c_int) + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    };
    let mut x: libc::c_int = sx;
    let mut y: libc::c_int = sy;
    Rgb
        .r1 = dung_map_r[(x - 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .g1 = dung_map_g[(x - 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .b1 = dung_map_b[(x - 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .r2 = dung_map_r[x as usize][(y - 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .g2 = dung_map_g[x as usize][(y - 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .b2 = dung_map_b[x as usize][(y - 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .r3 = dung_map_r[x as usize][(y + 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .g3 = dung_map_g[x as usize][(y + 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .b3 = dung_map_b[x as usize][(y + 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .r4 = dung_map_r[(x + 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .g4 = dung_map_g[(x + 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .b4 = dung_map_b[(x + 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    let mut i: libc::c_int = tile_height;
    if tile_skip != -(1 as libc::c_int) {
        while tile_skip != 0 as libc::c_int {
            w = nWidth;
            while w != 0 as libc::c_int {
                let fresh0 = pRLEBytes;
                pRLEBytes = pRLEBytes.offset(1);
                rle = *fresh0;
                lRLECount -= 1;
                lRLECount;
                if (rle as libc::c_int) < 0x80 as libc::c_int {
                    w -= rle as libc::c_int;
                    lRLECount -= rle as libc::c_int;
                    if pDecodeTo < clip {
                        return;
                    }
                    pRLEBytes = pRLEBytes.offset(rle as libc::c_int as isize);
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                } else {
                    rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                    w -= rle as libc::c_int;
                }
            }
            pDecodeTo = pDecodeTo.offset(-((768 as libc::c_int + nWidth) as isize));
            tile_skip -= 1;
            tile_skip;
            i -= 1;
            i;
        }
    }
    let mut r0: libc::c_int = dung_map_r[sx as usize][sy as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    let mut g0: libc::c_int = dung_map_g[sx as usize][sy as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    let mut b0: libc::c_int = dung_map_b[sx as usize][sy as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    if Rgb.r1 == r0 && Rgb.r2 == r0 && Rgb.r3 == r0 && Rgb.r4 == r0 && Rgb.g1 == g0
        && Rgb.g2 == g0 && Rgb.g3 == g0 && Rgb.g4 == g0 && Rgb.b1 == b0 && Rgb.b2 == b0
        && Rgb.b3 == b0 && Rgb.b4 == b0
    {
        DecodeFullCelL(pDecodeTo, pRLEBytes, lRLECount, nWidth);
        return;
    }
    let mut r1: libc::c_int = 0;
    let mut g1: libc::c_int = 0;
    let mut b1: libc::c_int = 0;
    GetGCol32_Fast(i, 0 as libc::c_int, &mut r1, &mut g1, &mut b1);
    let mut r2: libc::c_int = 0;
    let mut g2: libc::c_int = 0;
    let mut b2: libc::c_int = 0;
    GetGCol32_Fast(i, 63 as libc::c_int, &mut r2, &mut g2, &mut b2);
    while lRLECount != 0 as libc::c_int && i >= 0 as libc::c_int {
        w = nWidth;
        if tile_height == 32 as libc::c_int && i & 3 as libc::c_int == 0
            || i & 0xf as libc::c_int == 0
        {
            GetGCol32_Fast(i, 0 as libc::c_int, &mut r1, &mut g1, &mut b1);
            GetGCol32_Fast(i, 63 as libc::c_int, &mut r2, &mut g2, &mut b2);
        }
        let mut r: *mut uint8_t = (RgbVals[(r1 >> G_THRESHOLD as libc::c_int)
            as usize][(r2 >> G_THRESHOLD as libc::c_int) as usize])
            .as_mut_ptr();
        let mut g: *mut uint8_t = (RgbVals[(g1 >> G_THRESHOLD as libc::c_int)
            as usize][(g2 >> G_THRESHOLD as libc::c_int) as usize])
            .as_mut_ptr();
        let mut b: *mut uint8_t = (RgbVals[(b1 >> G_THRESHOLD as libc::c_int)
            as usize][(b2 >> G_THRESHOLD as libc::c_int) as usize])
            .as_mut_ptr();
        while w != 0 as libc::c_int {
            let fresh1 = pRLEBytes;
            pRLEBytes = pRLEBytes.offset(1);
            rle = *fresh1;
            lRLECount -= 1;
            lRLECount;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                lRLECount -= rle as libc::c_int;
                if pDecodeTo < clip {
                    return;
                }
                if pDecodeTo < glClipY {
                    let mut p2: *mut uint8_t = pDecodeTo as *mut uint8_t;
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                    if rle as libc::c_int & 1 as libc::c_int != 0 {
                        let mut ppp: *mut GourColor = &mut *GColorsTbl
                            .as_mut_ptr()
                            .offset(*pRLEBytes as isize) as *mut GourColor;
                        let fresh2 = b;
                        b = b.offset(1);
                        *p2 = (*ppp).B[*fresh2 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh3 = g;
                        g = g.offset(1);
                        *p2 = (*ppp).G[*fresh3 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh4 = r;
                        r = r.offset(1);
                        *p2 = (*ppp).R[*fresh4 as usize];
                        p2 = p2.offset(2 as libc::c_int as isize);
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                    }
                    rle = (rle as libc::c_int >> 1 as libc::c_int) as uint8_t;
                    if rle as libc::c_int & 1 as libc::c_int != 0 {
                        let mut ppp_0: *mut GourColor = &mut *GColorsTbl
                            .as_mut_ptr()
                            .offset(*pRLEBytes as isize) as *mut GourColor;
                        let fresh5 = b;
                        b = b.offset(1);
                        *p2 = (*ppp_0).B[*fresh5 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh6 = g;
                        g = g.offset(1);
                        *p2 = (*ppp_0).G[*fresh6 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh7 = r;
                        r = r.offset(1);
                        *p2 = (*ppp_0).R[*fresh7 as usize];
                        p2 = p2.offset(2 as libc::c_int as isize);
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                        let mut ppp_1: *mut GourColor = &mut *GColorsTbl
                            .as_mut_ptr()
                            .offset(*pRLEBytes as isize) as *mut GourColor;
                        let fresh8 = b;
                        b = b.offset(1);
                        *p2 = (*ppp_1).B[*fresh8 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh9 = g;
                        g = g.offset(1);
                        *p2 = (*ppp_1).G[*fresh9 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh10 = r;
                        r = r.offset(1);
                        *p2 = (*ppp_1).R[*fresh10 as usize];
                        p2 = p2.offset(2 as libc::c_int as isize);
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                    }
                    rle = (rle as libc::c_int >> 1 as libc::c_int) as uint8_t;
                    loop {
                        let fresh11 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh11 != 0) {
                            break;
                        }
                        let mut ppp_2: *mut GourColor = &mut *GColorsTbl
                            .as_mut_ptr()
                            .offset(*pRLEBytes as isize) as *mut GourColor;
                        let fresh12 = b;
                        b = b.offset(1);
                        *p2 = (*ppp_2).B[*fresh12 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh13 = g;
                        g = g.offset(1);
                        *p2 = (*ppp_2).G[*fresh13 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh14 = r;
                        r = r.offset(1);
                        *p2 = (*ppp_2).R[*fresh14 as usize];
                        p2 = p2.offset(2 as libc::c_int as isize);
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                        let mut ppp_3: *mut GourColor = &mut *GColorsTbl
                            .as_mut_ptr()
                            .offset(*pRLEBytes as isize) as *mut GourColor;
                        let fresh15 = b;
                        b = b.offset(1);
                        *p2 = (*ppp_3).B[*fresh15 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh16 = g;
                        g = g.offset(1);
                        *p2 = (*ppp_3).G[*fresh16 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh17 = r;
                        r = r.offset(1);
                        *p2 = (*ppp_3).R[*fresh17 as usize];
                        p2 = p2.offset(2 as libc::c_int as isize);
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                        let mut ppp_4: *mut GourColor = &mut *GColorsTbl
                            .as_mut_ptr()
                            .offset(*pRLEBytes as isize) as *mut GourColor;
                        let fresh18 = b;
                        b = b.offset(1);
                        *p2 = (*ppp_4).B[*fresh18 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh19 = g;
                        g = g.offset(1);
                        *p2 = (*ppp_4).G[*fresh19 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh20 = r;
                        r = r.offset(1);
                        *p2 = (*ppp_4).R[*fresh20 as usize];
                        p2 = p2.offset(2 as libc::c_int as isize);
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                        let mut ppp_5: *mut GourColor = &mut *GColorsTbl
                            .as_mut_ptr()
                            .offset(*pRLEBytes as isize) as *mut GourColor;
                        let fresh21 = b;
                        b = b.offset(1);
                        *p2 = (*ppp_5).B[*fresh21 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh22 = g;
                        g = g.offset(1);
                        *p2 = (*ppp_5).G[*fresh22 as usize];
                        p2 = p2.offset(1);
                        p2;
                        let fresh23 = r;
                        r = r.offset(1);
                        *p2 = (*ppp_5).R[*fresh23 as usize];
                        p2 = p2.offset(2 as libc::c_int as isize);
                        pRLEBytes = pRLEBytes.offset(1);
                        pRLEBytes;
                    }
                } else {
                    pRLEBytes = pRLEBytes.offset(rle as libc::c_int as isize);
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                    r = r.offset(rle as libc::c_int as isize);
                    g = g.offset(rle as libc::c_int as isize);
                    b = b.offset(rle as libc::c_int as isize);
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                r = r.offset(rle as libc::c_int as isize);
                g = g.offset(rle as libc::c_int as isize);
                b = b.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pDecodeTo = pDecodeTo.offset(-((768 as libc::c_int + nWidth) as isize));
        i -= 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DecodeFullCelG_FastT(
    mut pDecodeTo: *mut uint32_t,
    mut pRLEBytes: *mut uint8_t,
    mut lRLECount: int32_t,
    mut nWidth: int32_t,
    mut sx: libc::c_int,
    mut sy: libc::c_int,
) {
    let mut w: int32_t = 0;
    let mut rle: uint8_t = 0;
    let mut clip: *mut uint32_t = if svgamode != 0 {
        &mut *gpBuffer
            .offset(
                ((0 as libc::c_int + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    } else {
        &mut *gpBuffer
            .offset(
                ((-(17 as libc::c_int) + 160 as libc::c_int) * BUFFERX as libc::c_int)
                    as isize,
            ) as *mut uint32_t
    };
    let mut x: libc::c_int = sx;
    let mut y: libc::c_int = sy;
    Rgb
        .r1 = dung_map_r[(x - 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .g1 = dung_map_g[(x - 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .b1 = dung_map_b[(x - 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .r2 = dung_map_r[x as usize][(y - 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .g2 = dung_map_g[x as usize][(y - 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .b2 = dung_map_b[x as usize][(y - 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .r3 = dung_map_r[x as usize][(y + 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .g3 = dung_map_g[x as usize][(y + 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .b3 = dung_map_b[x as usize][(y + 1 as libc::c_int) as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .r4 = dung_map_r[(x + 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .g4 = dung_map_g[(x + 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    Rgb
        .b4 = dung_map_b[(x + 1 as libc::c_int) as usize][y as usize] as libc::c_int
        >> G_THRESHOLD as libc::c_int;
    let mut i: libc::c_int = tile_height;
    if tile_skip != -(1 as libc::c_int) {
        while tile_skip != 0 as libc::c_int {
            w = nWidth;
            while w != 0 as libc::c_int {
                let fresh24 = pRLEBytes;
                pRLEBytes = pRLEBytes.offset(1);
                rle = *fresh24;
                lRLECount -= 1;
                lRLECount;
                if (rle as libc::c_int) < 0x80 as libc::c_int {
                    w -= rle as libc::c_int;
                    lRLECount -= rle as libc::c_int;
                    if pDecodeTo < clip {
                        return;
                    }
                    pRLEBytes = pRLEBytes.offset(rle as libc::c_int as isize);
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                } else {
                    rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                    w -= rle as libc::c_int;
                }
            }
            pDecodeTo = pDecodeTo.offset(-((768 as libc::c_int + nWidth) as isize));
            tile_skip -= 1;
            tile_skip;
            i -= 1;
            i;
        }
    }
    let mut r1: libc::c_int = 0;
    let mut g1: libc::c_int = 0;
    let mut b1: libc::c_int = 0;
    GetGCol32_Fast(i, 0 as libc::c_int, &mut r1, &mut g1, &mut b1);
    let mut r2: libc::c_int = 0;
    let mut g2: libc::c_int = 0;
    let mut b2: libc::c_int = 0;
    GetGCol32_Fast(i, 63 as libc::c_int, &mut r2, &mut g2, &mut b2);
    while lRLECount != 0 as libc::c_int && i >= 0 as libc::c_int {
        w = nWidth;
        if tile_height == 32 as libc::c_int && i & 3 as libc::c_int == 0
            || i & 0xf as libc::c_int == 0
        {
            GetGCol32_Fast(i, 0 as libc::c_int, &mut r1, &mut g1, &mut b1);
            GetGCol32_Fast(i, 63 as libc::c_int, &mut r2, &mut g2, &mut b2);
        }
        let mut r: *mut uint8_t = (RgbVals[(r1 >> G_THRESHOLD as libc::c_int)
            as usize][(r2 >> G_THRESHOLD as libc::c_int) as usize])
            .as_mut_ptr();
        let mut g: *mut uint8_t = (RgbVals[(g1 >> G_THRESHOLD as libc::c_int)
            as usize][(g2 >> G_THRESHOLD as libc::c_int) as usize])
            .as_mut_ptr();
        let mut b: *mut uint8_t = (RgbVals[(b1 >> G_THRESHOLD as libc::c_int)
            as usize][(b2 >> G_THRESHOLD as libc::c_int) as usize])
            .as_mut_ptr();
        while w != 0 as libc::c_int {
            let fresh25 = pRLEBytes;
            pRLEBytes = pRLEBytes.offset(1);
            rle = *fresh25;
            lRLECount -= 1;
            lRLECount;
            if (rle as libc::c_int) < 0x80 as libc::c_int {
                w -= rle as libc::c_int;
                lRLECount -= rle as libc::c_int;
                if pDecodeTo < clip {
                    return;
                }
                if pDecodeTo < glClipY {
                    loop {
                        let fresh26 = rle;
                        rle = rle.wrapping_sub(1);
                        if !(fresh26 != 0) {
                            break;
                        }
                        let fresh27 = pRLEBytes;
                        pRLEBytes = pRLEBytes.offset(1);
                        let mut p2: *mut uint8_t = &mut *gpPalette
                            .as_mut_ptr()
                            .offset(*fresh27 as isize) as *mut uint32_t as *mut uint8_t;
                        let mut col: uint32_t = 0;
                        let fresh28 = b;
                        b = b.offset(1);
                        col = (*p2 as libc::c_int * *fresh28 as libc::c_int
                            >> 8 as libc::c_int) as uint32_t;
                        p2 = p2.offset(1);
                        p2;
                        let fresh29 = g;
                        g = g.offset(1);
                        col
                            |= ((*p2 as libc::c_int * *fresh29 as libc::c_int
                                >> 8 as libc::c_int) << 8 as libc::c_int) as uint32_t;
                        p2 = p2.offset(1);
                        p2;
                        let fresh30 = r;
                        r = r.offset(1);
                        col
                            |= ((*p2 as libc::c_int * *fresh30 as libc::c_int
                                >> 8 as libc::c_int) << 16 as libc::c_int) as uint32_t;
                        if G_BRIGHT_LIGHTS as libc::c_int == 0 {
                            *pDecodeTo = (*pDecodeTo
                                & 0xfefefe as libc::c_int as uint32_t)
                                .wrapping_add(col & 0xfefefe as libc::c_int as uint32_t)
                                >> 1 as libc::c_int;
                        } else {
                            *pDecodeTo = ((*pDecodeTo
                                & 0xfefefe as libc::c_int as uint32_t) >> 1 as libc::c_int)
                                .wrapping_add(col & 0xfefefe as libc::c_int as uint32_t);
                        }
                        pDecodeTo = pDecodeTo.offset(1);
                        pDecodeTo;
                    }
                } else {
                    pRLEBytes = pRLEBytes.offset(rle as libc::c_int as isize);
                    pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                    r = r.offset(rle as libc::c_int as isize);
                    g = g.offset(rle as libc::c_int as isize);
                    b = b.offset(rle as libc::c_int as isize);
                }
            } else {
                rle = (0x100 as libc::c_int - rle as libc::c_int) as uint8_t;
                pDecodeTo = pDecodeTo.offset(rle as libc::c_int as isize);
                r = r.offset(rle as libc::c_int as isize);
                g = g.offset(rle as libc::c_int as isize);
                b = b.offset(rle as libc::c_int as isize);
                w -= rle as libc::c_int;
            }
        }
        pDecodeTo = pDecodeTo.offset(-((768 as libc::c_int + nWidth) as isize));
        i -= 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawCelG(
    mut xp: int32_t,
    mut yp: int32_t,
    mut pCelBuff: *mut uint8_t,
    mut nCel: int32_t,
    mut nCelW: int32_t,
    mut sx: libc::c_int,
    mut sy: libc::c_int,
) {
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    let mut pFrom: *mut uint8_t = 0 as *mut uint8_t;
    let mut RLELen: int32_t = 0;
    if gpBuffer.is_null() {
        assert_fail(
            501 as libc::c_int,
            b"extra/gouraud.c\0" as *const u8 as *const libc::c_char,
            b"gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    if pCelBuff.is_null() {
        assert_fail(
            502 as libc::c_int,
            b"extra/gouraud.c\0" as *const u8 as *const libc::c_char,
            b"pCelBuff != NULL\0" as *const u8 as *const libc::c_char,
        );
    }
    pFrom = GetCelFrame(pCelBuff, nCel, &mut RLELen);
    pTo = gpBuffer.offset(nBuffWTbl[yp as usize] as isize).offset(xp as isize);
    if nTrans != 0 {
        DecodeFullCelG_FastT(pTo, pFrom, RLELen, nCelW, sx, sy);
    } else {
        DecodeFullCelG_Fast(pTo, pFrom, RLELen, nCelW, sx, sy);
    };
}
