use ::libc;
extern "C" {
    pub type _IO_wide_data;
    pub type _IO_codecvt;
    pub type _IO_marker;
    fn fclose(__stream: *mut FILE) -> libc::c_int;
    fn fopen(_: *const libc::c_char, _: *const libc::c_char) -> *mut FILE;
    fn snprintf(
        _: *mut libc::c_char,
        _: libc::c_ulong,
        _: *const libc::c_char,
        _: ...
    ) -> libc::c_int;
    fn fwrite(
        _: *const libc::c_void,
        _: libc::c_ulong,
        _: libc::c_ulong,
        _: *mut FILE,
    ) -> libc::c_ulong;
    fn LoadLvlGFX();
    fn FreeGameMem();
    fn strlen(_: *const libc::c_char) -> libc::c_ulong;
    fn strchr(_: *const libc::c_char, _: libc::c_int) -> *mut libc::c_char;
    fn strncmp(
        _: *const libc::c_char,
        _: *const libc::c_char,
        _: libc::c_ulong,
    ) -> libc::c_int;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn free(_: *mut libc::c_void);
    fn calloc(_: libc::c_ulong, _: libc::c_ulong) -> *mut libc::c_void;
    fn strtol(
        _: *const libc::c_char,
        _: *mut *mut libc::c_char,
        _: libc::c_int,
    ) -> libc::c_long;
    fn CreateL5Dungeon(_: libc::c_uint, _: libc::c_int);
    fn CreateL2Dungeon(_: libc::c_uint, _: libc::c_int);
    fn CreateL3Dungeon(_: libc::c_uint, _: libc::c_int);
    fn CreateL4Dungeon(_: libc::c_uint, _: libc::c_int);
    fn SetRndSeed(file: *const libc::c_char, line: libc::c_int, s: int32_t);
    fn InitLightTable();
    fn FreeLightTable();
    fn InitLevelMonsters();
    fn FreeMonsterGFX();
    fn FreeObjectGFX();
    fn LoadSetMap();
    static mut GAME_FRAMES_PER_SECOND: libc::c_int;
    static mut leveltype: uint8_t;
    static mut currlevel: uint8_t;
    static mut setlevel: uint8_t;
    static mut setlvlnum: uint8_t;
    static mut setlvltype: uint8_t;
    static mut dungeon: [[uint8_t; 40]; 40];
    static mut pdungeon: [[uint8_t; 40]; 40];
    static mut dflags: [[uint8_t; 40]; 40];
    static mut pDungeonCels: *mut uint8_t;
    static mut dPiece: [[libc::c_int; 112]; 112];
    static mut dTransVal: [[int8_t; 112]; 112];
    static mut dFlags: [[int8_t; 112]; 112];
    static mut dSpecial: [[int8_t; 112]; 112];
    static mut gbMaxPlayers: uint8_t;
    static mut quests: [QuestStruct; 16];
    static mut set_game_seed: libc::c_int;
    static mut set_player_seed: libc::c_int;
    static mut set_stores_seed: libc::c_int;
    static mut replay_path: *mut libc::c_char;
    fn _logf(format: *const libc::c_char, _: ...);
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
pub type int8_t = __int8_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type size_t = libc::c_ulong;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _IO_FILE {
    pub _flags: libc::c_int,
    pub _IO_read_ptr: *mut libc::c_char,
    pub _IO_read_end: *mut libc::c_char,
    pub _IO_read_base: *mut libc::c_char,
    pub _IO_write_base: *mut libc::c_char,
    pub _IO_write_ptr: *mut libc::c_char,
    pub _IO_write_end: *mut libc::c_char,
    pub _IO_buf_base: *mut libc::c_char,
    pub _IO_buf_end: *mut libc::c_char,
    pub _IO_save_base: *mut libc::c_char,
    pub _IO_backup_base: *mut libc::c_char,
    pub _IO_save_end: *mut libc::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: libc::c_int,
    pub _flags2: libc::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: libc::c_ushort,
    pub _vtable_offset: libc::c_schar,
    pub _shortbuf: [libc::c_char; 1],
    pub _lock: *mut libc::c_void,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut libc::c_void,
    pub __pad5: size_t,
    pub _mode: libc::c_int,
    pub _unused2: [libc::c_char; 20],
}
pub type _IO_lock_t = ();
pub type FILE = _IO_FILE;
pub type C2RustUnnamed = libc::c_uint;
pub const Q_BETRAYER: C2RustUnnamed = 15;
pub const Q_SCHAMB: C2RustUnnamed = 14;
pub const Q_PWATER: C2RustUnnamed = 13;
pub const Q_SKELKING: C2RustUnnamed = 12;
pub const Q_WARLORD: C2RustUnnamed = 11;
pub const Q_ANVIL: C2RustUnnamed = 10;
pub const Q_BLOOD: C2RustUnnamed = 9;
pub const Q_BLIND: C2RustUnnamed = 8;
pub const Q_LTBANNER: C2RustUnnamed = 7;
pub const Q_BUTCHER: C2RustUnnamed = 6;
pub const Q_DIABLO: C2RustUnnamed = 5;
pub const Q_VEIL: C2RustUnnamed = 4;
pub const Q_ZHAR: C2RustUnnamed = 3;
pub const Q_GARBUD: C2RustUnnamed = 2;
pub const Q_BKMUSHRM: C2RustUnnamed = 1;
pub const Q_ROCK: C2RustUnnamed = 0;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const QUEST_DONE: C2RustUnnamed_0 = 3;
pub const QUEST_NOTDONE: C2RustUnnamed_0 = 2;
pub const QUEST_NOTACTIVE: C2RustUnnamed_0 = 1;
pub const QUEST_NOTAVAIL: C2RustUnnamed_0 = 0;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const SL_VILEBETRAYER: C2RustUnnamed_1 = 5;
pub const SL_POISONWATER: C2RustUnnamed_1 = 4;
pub const SL_MAZE: C2RustUnnamed_1 = 3;
pub const SL_BONECHAMB: C2RustUnnamed_1 = 2;
pub const SL_SKELKING: C2RustUnnamed_1 = 1;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const LVL_TWARPUP: C2RustUnnamed_2 = 7;
pub const LVL_TWARPDN: C2RustUnnamed_2 = 6;
pub const LVL_WARP: C2RustUnnamed_2 = 5;
pub const LVL_NODIR: C2RustUnnamed_2 = 4;
pub const LVL_RTN: C2RustUnnamed_2 = 3;
pub const LVL_SET: C2RustUnnamed_2 = 2;
pub const LVL_UP: C2RustUnnamed_2 = 1;
pub const LVL_DOWN: C2RustUnnamed_2 = 0;
pub type bool32_t = uint32_t;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const QUEST_OFFSETS: C2RustUnnamed_3 = 7;
pub const MAXMULTIQUESTS: C2RustUnnamed_3 = 4;
pub const MAXQUESTS: C2RustUnnamed_3 = 16;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct QuestStruct {
    pub _qlevel: uint8_t,
    pub _qtype: uint8_t,
    pub _qactive: uint8_t,
    pub _qlvltype: uint8_t,
    pub _qtx: libc::c_int,
    pub _qty: libc::c_int,
    pub _qslvl: uint8_t,
    pub _qidx: uint8_t,
    pub _qmsg: uint8_t,
    pub _qvar1: uint8_t,
    pub _qvar2: uint8_t,
    pub align_0011: [uint8_t; 3],
    pub _qlog: bool32_t,
}
pub type digest32_t = [uint32_t; 5];
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SHA1 {
    pub m_digest: digest32_t,
    pub m_block: [uint8_t; 64],
    pub m_blockByteIndex: size_t,
    pub m_byteCount: size_t,
}
pub type C2RustUnnamed_4 = libc::c_int;
pub const Q_NONE: C2RustUnnamed_4 = -1;
pub type C2RustUnnamed_5 = libc::c_uint;
pub const SL_NONE: C2RustUnnamed_5 = 0;
pub type C2RustUnnamed_6 = libc::c_uint;
pub const DTYPE_HELL: C2RustUnnamed_6 = 4;
pub const DTYPE_CAVES: C2RustUnnamed_6 = 3;
pub const DTYPE_CATACOMBS: C2RustUnnamed_6 = 2;
pub const DTYPE_CATHEDRAL: C2RustUnnamed_6 = 1;
pub const DTYPE_TRISTRAM: C2RustUnnamed_6 = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct Test {
    pub dlvl: libc::c_int,
    pub dtype: libc::c_int,
    pub slvl: libc::c_int,
    pub quest_id: libc::c_int,
    pub seed: uint32_t,
}
#[no_mangle]
pub unsafe extern "C" fn sha1_reset(mut hash: *mut SHA1) {
    (*hash).m_digest[0 as libc::c_int as usize] = 0x67452301 as libc::c_int as uint32_t;
    (*hash).m_digest[1 as libc::c_int as usize] = 0xefcdab89 as libc::c_uint;
    (*hash).m_digest[2 as libc::c_int as usize] = 0x98badcfe as libc::c_uint;
    (*hash).m_digest[3 as libc::c_int as usize] = 0x10325476 as libc::c_int as uint32_t;
    (*hash).m_digest[4 as libc::c_int as usize] = 0xc3d2e1f0 as libc::c_uint;
    (*hash).m_blockByteIndex = 0 as libc::c_int as size_t;
    (*hash).m_byteCount = 0 as libc::c_int as size_t;
}
unsafe extern "C" fn left_rotate(mut value: uint32_t, mut count: size_t) -> uint32_t {
    return value << count ^ value >> (32 as libc::c_int as size_t).wrapping_sub(count);
}
#[no_mangle]
pub unsafe extern "C" fn sha1_process_byte(mut hash: *mut SHA1, mut octet: uint8_t) {
    let fresh0 = (*hash).m_blockByteIndex;
    (*hash).m_blockByteIndex = ((*hash).m_blockByteIndex).wrapping_add(1);
    (*hash).m_block[fresh0 as usize] = octet;
    (*hash).m_byteCount = ((*hash).m_byteCount).wrapping_add(1);
    (*hash).m_byteCount;
    if (*hash).m_blockByteIndex == 64 as libc::c_int as size_t {
        (*hash).m_blockByteIndex = 0 as libc::c_int as size_t;
        sha1_process_block_step(hash);
    }
}
#[no_mangle]
pub unsafe extern "C" fn sha1_process_block(
    mut hash: *mut SHA1,
    mut start: *const uint8_t,
    mut end: *const uint8_t,
) {
    while start != end {
        sha1_process_byte(hash, *start);
        start = start.offset(1);
        start;
    }
}
#[no_mangle]
pub unsafe extern "C" fn sha1_process_bytes(
    mut hash: *mut SHA1,
    mut block: *const uint8_t,
    mut len: size_t,
) {
    sha1_process_block(hash, block, block.offset(len as isize));
}
#[no_mangle]
pub unsafe extern "C" fn sha1_get_digest(
    mut hash: *mut SHA1,
    mut digest: *mut uint32_t,
) -> *const uint32_t {
    let mut bitCount: size_t = (*hash).m_byteCount * 8 as libc::c_int as size_t;
    sha1_process_byte(hash, 0x80 as libc::c_int as uint8_t);
    if (*hash).m_blockByteIndex > 56 as libc::c_int as size_t {
        while (*hash).m_blockByteIndex != 0 as libc::c_int as size_t {
            sha1_process_byte(hash, 0 as libc::c_int as uint8_t);
        }
        while (*hash).m_blockByteIndex < 56 as libc::c_int as size_t {
            sha1_process_byte(hash, 0 as libc::c_int as uint8_t);
        }
    } else {
        while (*hash).m_blockByteIndex < 56 as libc::c_int as size_t {
            sha1_process_byte(hash, 0 as libc::c_int as uint8_t);
        }
    }
    sha1_process_byte(hash, 0 as libc::c_int as uint8_t);
    sha1_process_byte(hash, 0 as libc::c_int as uint8_t);
    sha1_process_byte(hash, 0 as libc::c_int as uint8_t);
    sha1_process_byte(hash, 0 as libc::c_int as uint8_t);
    sha1_process_byte(
        hash,
        ((bitCount >> 24 as libc::c_int) as uint8_t as libc::c_int & 0xff as libc::c_int)
            as uint8_t,
    );
    sha1_process_byte(
        hash,
        ((bitCount >> 16 as libc::c_int) as uint8_t as libc::c_int & 0xff as libc::c_int)
            as uint8_t,
    );
    sha1_process_byte(
        hash,
        ((bitCount >> 8 as libc::c_int) as uint8_t as libc::c_int & 0xff as libc::c_int)
            as uint8_t,
    );
    sha1_process_byte(
        hash,
        (bitCount as uint8_t as libc::c_int & 0xff as libc::c_int) as uint8_t,
    );
    memcpy(
        digest as *mut libc::c_void,
        ((*hash).m_digest).as_mut_ptr() as *const libc::c_void,
        (5 as libc::c_int as libc::c_ulong)
            .wrapping_mul(::core::mem::size_of::<uint32_t>() as libc::c_ulong),
    );
    return digest as *const uint32_t;
}
#[no_mangle]
pub unsafe extern "C" fn sha1_get_digest_bytes(
    mut hash: *mut SHA1,
    mut digest: *mut uint8_t,
) -> *const uint8_t {
    let mut d32: digest32_t = [0; 5];
    sha1_get_digest(hash, d32.as_mut_ptr());
    let mut di: size_t = 0 as libc::c_int as size_t;
    let fresh1 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh1 as isize,
        ) = (d32[0 as libc::c_int as usize] >> 24 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh2 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh2 as isize,
        ) = (d32[0 as libc::c_int as usize] >> 16 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh3 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh3 as isize,
        ) = (d32[0 as libc::c_int as usize] >> 8 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh4 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh4 as isize,
        ) = (d32[0 as libc::c_int as usize] & 0xff as libc::c_int as uint32_t)
        as uint8_t;
    let fresh5 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh5 as isize,
        ) = (d32[1 as libc::c_int as usize] >> 24 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh6 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh6 as isize,
        ) = (d32[1 as libc::c_int as usize] >> 16 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh7 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh7 as isize,
        ) = (d32[1 as libc::c_int as usize] >> 8 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh8 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh8 as isize,
        ) = (d32[1 as libc::c_int as usize] & 0xff as libc::c_int as uint32_t)
        as uint8_t;
    let fresh9 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh9 as isize,
        ) = (d32[2 as libc::c_int as usize] >> 24 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh10 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh10 as isize,
        ) = (d32[2 as libc::c_int as usize] >> 16 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh11 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh11 as isize,
        ) = (d32[2 as libc::c_int as usize] >> 8 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh12 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh12 as isize,
        ) = (d32[2 as libc::c_int as usize] & 0xff as libc::c_int as uint32_t)
        as uint8_t;
    let fresh13 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh13 as isize,
        ) = (d32[3 as libc::c_int as usize] >> 24 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh14 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh14 as isize,
        ) = (d32[3 as libc::c_int as usize] >> 16 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh15 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh15 as isize,
        ) = (d32[3 as libc::c_int as usize] >> 8 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh16 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh16 as isize,
        ) = (d32[3 as libc::c_int as usize] & 0xff as libc::c_int as uint32_t)
        as uint8_t;
    let fresh17 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh17 as isize,
        ) = (d32[4 as libc::c_int as usize] >> 24 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh18 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh18 as isize,
        ) = (d32[4 as libc::c_int as usize] >> 16 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh19 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh19 as isize,
        ) = (d32[4 as libc::c_int as usize] >> 8 as libc::c_int
        & 0xff as libc::c_int as uint32_t) as uint8_t;
    let fresh20 = di;
    di = di.wrapping_add(1);
    *digest
        .offset(
            fresh20 as isize,
        ) = (d32[4 as libc::c_int as usize] & 0xff as libc::c_int as uint32_t)
        as uint8_t;
    return digest as *const uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn sha1_process_block_step(mut hash: *mut SHA1) {
    let mut w: [uint32_t; 80] = [0; 80];
    let mut i: size_t = 0 as libc::c_int as size_t;
    while i < 16 as libc::c_int as size_t {
        w[i
            as usize] = (((*hash)
            .m_block[(i * 4 as libc::c_int as size_t)
            .wrapping_add(0 as libc::c_int as size_t) as usize] as libc::c_int)
            << 24 as libc::c_int) as uint32_t;
        w[i as usize]
            |= (((*hash)
                .m_block[(i * 4 as libc::c_int as size_t)
                .wrapping_add(1 as libc::c_int as size_t) as usize] as libc::c_int)
                << 16 as libc::c_int) as uint32_t;
        w[i as usize]
            |= (((*hash)
                .m_block[(i * 4 as libc::c_int as size_t)
                .wrapping_add(2 as libc::c_int as size_t) as usize] as libc::c_int)
                << 8 as libc::c_int) as uint32_t;
        w[i as usize]
            |= (*hash)
                .m_block[(i * 4 as libc::c_int as size_t)
                .wrapping_add(3 as libc::c_int as size_t) as usize] as uint32_t;
        i = i.wrapping_add(1);
        i;
    }
    let mut j: size_t = 16 as libc::c_int as size_t;
    while j < 80 as libc::c_int as size_t {
        w[j
            as usize] = left_rotate(
            w[j.wrapping_sub(3 as libc::c_int as size_t) as usize]
                ^ w[j.wrapping_sub(8 as libc::c_int as size_t) as usize]
                ^ w[j.wrapping_sub(14 as libc::c_int as size_t) as usize]
                ^ w[j.wrapping_sub(16 as libc::c_int as size_t) as usize],
            1 as libc::c_int as size_t,
        );
        j = j.wrapping_add(1);
        j;
    }
    let mut a: uint32_t = (*hash).m_digest[0 as libc::c_int as usize];
    let mut b: uint32_t = (*hash).m_digest[1 as libc::c_int as usize];
    let mut c: uint32_t = (*hash).m_digest[2 as libc::c_int as usize];
    let mut d: uint32_t = (*hash).m_digest[3 as libc::c_int as usize];
    let mut e: uint32_t = (*hash).m_digest[4 as libc::c_int as usize];
    let mut l: size_t = 0 as libc::c_int as size_t;
    while l < 80 as libc::c_int as size_t {
        let mut f: uint32_t = 0 as libc::c_int as uint32_t;
        let mut k: uint32_t = 0 as libc::c_int as uint32_t;
        if l < 20 as libc::c_int as size_t {
            f = b & c | !b & d;
            k = 0x5a827999 as libc::c_int as uint32_t;
        } else if l < 40 as libc::c_int as size_t {
            f = b ^ c ^ d;
            k = 0x6ed9eba1 as libc::c_int as uint32_t;
        } else if l < 60 as libc::c_int as size_t {
            f = b & c | b & d | c & d;
            k = 0x8f1bbcdc as libc::c_uint;
        } else {
            f = b ^ c ^ d;
            k = 0xca62c1d6 as libc::c_uint;
        }
        let mut temp: uint32_t = (left_rotate(a, 5 as libc::c_int as size_t))
            .wrapping_add(f)
            .wrapping_add(e)
            .wrapping_add(k)
            .wrapping_add(w[l as usize]);
        e = d;
        d = c;
        c = left_rotate(b, 30 as libc::c_int as size_t);
        b = a;
        a = temp;
        l = l.wrapping_add(1);
        l;
    }
    (*hash)
        .m_digest[0 as libc::c_int
        as usize] = ((*hash).m_digest[0 as libc::c_int as usize]).wrapping_add(a);
    (*hash)
        .m_digest[1 as libc::c_int
        as usize] = ((*hash).m_digest[1 as libc::c_int as usize]).wrapping_add(b);
    (*hash)
        .m_digest[2 as libc::c_int
        as usize] = ((*hash).m_digest[2 as libc::c_int as usize]).wrapping_add(c);
    (*hash)
        .m_digest[3 as libc::c_int
        as usize] = ((*hash).m_digest[3 as libc::c_int as usize]).wrapping_add(d);
    (*hash)
        .m_digest[4 as libc::c_int
        as usize] = ((*hash).m_digest[4 as libc::c_int as usize]).wrapping_add(e);
}
#[no_mangle]
pub unsafe extern "C" fn get_active_quest_id(mut dlvl: libc::c_int) -> libc::c_int {
    let mut quest_id: libc::c_int = Q_NONE as libc::c_int;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAXQUESTS as libc::c_int {
        let mut quest: QuestStruct = quests[i as usize];
        if !(quest._qlevel as libc::c_int != dlvl) {
            if !(quest._qactive as libc::c_int == QUEST_NOTAVAIL as libc::c_int) {
                if quest_id != Q_NONE as libc::c_int {
                    _logf(
                        b"found more than one quest on dlvl=%d; prev quest ID=%d, new quest ID=%d\0"
                            as *const u8 as *const libc::c_char,
                        dlvl,
                        quest_id,
                        quest._qidx as libc::c_int,
                    );
                }
                quest_id = quest._qidx as libc::c_int;
            }
        }
        i += 1;
        i;
    }
    return quest_id;
}
#[no_mangle]
pub unsafe extern "C" fn dump_data(
    mut path: *mut libc::c_char,
    mut data: *mut libc::c_void,
    mut size: libc::c_int,
) {
    _logf(b"creating '%s'\0" as *const u8 as *const libc::c_char, path);
    let mut f: *mut FILE = fopen(path, b"wb\0" as *const u8 as *const libc::c_char);
    if f.is_null() {
        _logf(b"unable to open file '%s'\0" as *const u8 as *const libc::c_char, path);
        return;
    }
    let mut n: libc::c_int = fwrite(
        data,
        1 as libc::c_int as libc::c_ulong,
        size as libc::c_ulong,
        f,
    ) as libc::c_int;
    if n != size {
        _logf(
            b"unable to write data to file '%s'; wrote %d bytes, expected to write %d bytes\0"
                as *const u8 as *const libc::c_char,
            path,
            n,
            size,
        );
        return;
    }
    if fclose(f) != 0 as libc::c_int {
        _logf(b"unable to close file '%s'\0" as *const u8 as *const libc::c_char, path);
        return;
    }
}
#[no_mangle]
pub unsafe extern "C" fn get_path(
    mut dtype_name: *const libc::c_char,
    mut data_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) -> *mut libc::c_char {
    let mut path: *mut libc::c_char = calloc(
        1 as libc::c_int as libc::c_ulong,
        260 as libc::c_int as libc::c_ulong,
    ) as *mut libc::c_char;
    let mut quest_id: libc::c_int = get_active_quest_id(dlvl);
    if is_slvl as libc::c_int != 0 && slvl != SL_NONE as libc::c_int {
        snprintf(
            path,
            260 as libc::c_int as libc::c_ulong,
            b"%s_%s_slvl=%d_seed=0x%08X_quest_id=%d.bin\0" as *const u8
                as *const libc::c_char,
            dtype_name,
            data_name,
            slvl,
            seed,
            quest_id,
        );
    } else {
        snprintf(
            path,
            260 as libc::c_int as libc::c_ulong,
            b"%s_%s_dlvl=%d_seed=0x%08X_quest_id=%d.bin\0" as *const u8
                as *const libc::c_char,
            dtype_name,
            data_name,
            dlvl,
            seed,
            quest_id,
        );
    }
    return path;
}
#[no_mangle]
pub unsafe extern "C" fn dump_dungeon(
    mut dtype_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) {
    let mut path: *mut libc::c_char = get_path(
        dtype_name,
        b"dungeon\0" as *const u8 as *const libc::c_char,
        dlvl,
        slvl,
        is_slvl,
        seed,
    );
    dump_data(
        path,
        dungeon.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[uint8_t; 40]; 40]>() as libc::c_ulong as libc::c_int,
    );
    free(path as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn dump_pdungeon(
    mut dtype_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) {
    let mut path: *mut libc::c_char = get_path(
        dtype_name,
        b"pdungeon\0" as *const u8 as *const libc::c_char,
        dlvl,
        slvl,
        is_slvl,
        seed,
    );
    dump_data(
        path,
        pdungeon.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[uint8_t; 40]; 40]>() as libc::c_ulong as libc::c_int,
    );
    free(path as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn dump_dflags(
    mut dtype_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) {
    let mut path: *mut libc::c_char = get_path(
        dtype_name,
        b"dflags_lower\0" as *const u8 as *const libc::c_char,
        dlvl,
        slvl,
        is_slvl,
        seed,
    );
    dump_data(
        path,
        dflags.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[uint8_t; 40]; 40]>() as libc::c_ulong as libc::c_int,
    );
    free(path as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn dump_dTransVal(
    mut dtype_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) {
    let mut path: *mut libc::c_char = get_path(
        dtype_name,
        b"dTransVal\0" as *const u8 as *const libc::c_char,
        dlvl,
        slvl,
        is_slvl,
        seed,
    );
    dump_data(
        path,
        dTransVal.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong as libc::c_int,
    );
    free(path as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn dump_dFlags(
    mut dtype_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) {
    let mut path: *mut libc::c_char = get_path(
        dtype_name,
        b"dFlags\0" as *const u8 as *const libc::c_char,
        dlvl,
        slvl,
        is_slvl,
        seed,
    );
    dump_data(
        path,
        dFlags.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong as libc::c_int,
    );
    free(path as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn dump_dSpecial(
    mut dtype_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) {
    let mut path: *mut libc::c_char = get_path(
        dtype_name,
        b"dSpecial\0" as *const u8 as *const libc::c_char,
        dlvl,
        slvl,
        is_slvl,
        seed,
    );
    dump_data(
        path,
        dSpecial.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong as libc::c_int,
    );
    free(path as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn dump_dPiece(
    mut dtype_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) {
    let mut path: *mut libc::c_char = get_path(
        dtype_name,
        b"dPiece\0" as *const u8 as *const libc::c_char,
        dlvl,
        slvl,
        is_slvl,
        seed,
    );
    dump_data(
        path,
        dPiece.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[libc::c_int; 112]; 112]>() as libc::c_ulong
            as libc::c_int,
    );
    free(path as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn dump_drlg(
    mut dtype_name: *const libc::c_char,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut seed: uint32_t,
) {
    dump_dungeon(dtype_name, dlvl, slvl, is_slvl, seed);
    dump_pdungeon(dtype_name, dlvl, slvl, is_slvl, seed);
    dump_dflags(dtype_name, dlvl, slvl, is_slvl, seed);
    dump_dTransVal(dtype_name, dlvl, slvl, is_slvl, seed);
    dump_dFlags(dtype_name, dlvl, slvl, is_slvl, seed);
    dump_dSpecial(dtype_name, dlvl, slvl, is_slvl, seed);
    dump_dPiece(dtype_name, dlvl, slvl, is_slvl, seed);
}
#[no_mangle]
pub unsafe extern "C" fn get_sha1(
    mut data: *mut libc::c_void,
    mut size: libc::c_int,
) -> *mut libc::c_char {
    let mut hash: SHA1 = SHA1 {
        m_digest: [0; 5],
        m_block: [0; 64],
        m_blockByteIndex: 0,
        m_byteCount: 0,
    };
    sha1_reset(&mut hash);
    sha1_process_bytes(&mut hash, data as *const uint8_t, size as size_t);
    let mut digest: [uint32_t; 5] = [0; 5];
    sha1_get_digest(&mut hash, digest.as_mut_ptr());
    let mut str_size: libc::c_int = 8 as libc::c_int * 5 as libc::c_int
        + 1 as libc::c_int;
    let mut str: *mut libc::c_char = calloc(
        str_size as libc::c_ulong,
        1 as libc::c_int as libc::c_ulong,
    ) as *mut libc::c_char;
    snprintf(
        str,
        str_size as libc::c_ulong,
        b"%08x%08x%08x%08x%08x\0" as *const u8 as *const libc::c_char,
        digest[0 as libc::c_int as usize],
        digest[1 as libc::c_int as usize],
        digest[2 as libc::c_int as usize],
        digest[3 as libc::c_int as usize],
        digest[4 as libc::c_int as usize],
    );
    return str;
}
#[no_mangle]
pub unsafe extern "C" fn print_drlg(
    mut dtype: libc::c_int,
    mut dlvl: libc::c_int,
    mut slvl: libc::c_int,
    mut is_slvl: bool,
    mut quest_id: libc::c_int,
    mut seed: uint32_t,
) {
    let mut dtype_name_string: [*const libc::c_char; 5] = [
        b"Tristram\0" as *const u8 as *const libc::c_char,
        b"Cathedral\0" as *const u8 as *const libc::c_char,
        b"Catacombs\0" as *const u8 as *const libc::c_char,
        b"Caves\0" as *const u8 as *const libc::c_char,
        b"Hell\0" as *const u8 as *const libc::c_char,
    ];
    let mut dtype_name_str: *const libc::c_char = dtype_name_string[dtype as usize];
    let mut dtype_string: [*const libc::c_char; 5] = [
        b"d1enum.DTypeTristram\0" as *const u8 as *const libc::c_char,
        b"d1enum.DTypeCathedral\0" as *const u8 as *const libc::c_char,
        b"d1enum.DTypeCatacombs\0" as *const u8 as *const libc::c_char,
        b"d1enum.DTypeCaves\0" as *const u8 as *const libc::c_char,
        b"d1enum.DTypeHell\0" as *const u8 as *const libc::c_char,
    ];
    let mut dtype_str: *const libc::c_char = dtype_string[dtype as usize];
    let mut quest_id_string: [*const libc::c_char; 16] = [
        b"d1enum.QuestIDTheMagicRock\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDBlackMushroom\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDGharbadTheWeak\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDZharTheMad\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDLachdanan\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDDiablo\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDTheButcher\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDOgdensSign\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDHallsOfTheBlind\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDValor\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDAnvilOfFury\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDWarlordOfBlood\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDTheCurseOfKingLeoric\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDPoisonedWaterSupply\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDTheChamberOfBone\0" as *const u8 as *const libc::c_char,
        b"d1enum.QuestIDArchbishopLazarus\0" as *const u8 as *const libc::c_char,
    ];
    let mut quest_id_str: *const libc::c_char = b"d1enum.QuestIDNone\0" as *const u8
        as *const libc::c_char;
    if quest_id != Q_NONE as libc::c_int {
        quest_id_str = quest_id_string[quest_id as usize];
    }
    let mut slvl_string: [*const libc::c_char; 6] = [
        b"d1enum.SetLevelNone\0" as *const u8 as *const libc::c_char,
        b"d1enum.SetLevelSkeletonKingsLair\0" as *const u8 as *const libc::c_char,
        b"d1enum.SetLevelBoneChamber\0" as *const u8 as *const libc::c_char,
        b"d1enum.SetLevelMaze\0" as *const u8 as *const libc::c_char,
        b"d1enum.SetLevelPoisonedWaterSupply\0" as *const u8 as *const libc::c_char,
        b"d1enum.SetLevelArchbishopLazarusLair\0" as *const u8 as *const libc::c_char,
    ];
    let mut slvl_str: *const libc::c_char = slvl_string[slvl as usize];
    let mut slvl_name_string: [*const libc::c_char; 6] = [
        b"SetLevel(none)\0" as *const u8 as *const libc::c_char,
        b"Skeleton King's Lair\0" as *const u8 as *const libc::c_char,
        b"Bone Chamber\0" as *const u8 as *const libc::c_char,
        b"Maze\0" as *const u8 as *const libc::c_char,
        b"Poisoned Water Supply\0" as *const u8 as *const libc::c_char,
        b"Archbishop Lazarus' Lair\0" as *const u8 as *const libc::c_char,
    ];
    let mut slvl_name_str: *const libc::c_char = slvl_name_string[slvl as usize];
    let mut mega_hash: *mut libc::c_char = get_sha1(
        dungeon.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[uint8_t; 40]; 40]>() as libc::c_ulong as libc::c_int,
    );
    let mut mini_hash: *mut libc::c_char = get_sha1(
        dPiece.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[libc::c_int; 112]; 112]>() as libc::c_ulong
            as libc::c_int,
    );
    let mut special_hash: *mut libc::c_char = get_sha1(
        dSpecial.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong as libc::c_int,
    );
    let mut trans_hash: *mut libc::c_char = get_sha1(
        dTransVal.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong as libc::c_int,
    );
    let mut map_name: [libc::c_char; 128] = *::core::mem::transmute::<
        &[u8; 128],
        &mut [libc::c_char; 128],
    >(
        b"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",
    );
    if is_slvl {
        snprintf(
            map_name.as_mut_ptr(),
            ::core::mem::size_of::<[libc::c_char; 128]>() as libc::c_ulong,
            b"slvl=%s\0" as *const u8 as *const libc::c_char,
            slvl_name_str,
        );
    } else {
        snprintf(
            map_name.as_mut_ptr(),
            ::core::mem::size_of::<[libc::c_char; 128]>() as libc::c_ulong,
            b"dlvl=%d\0" as *const u8 as *const libc::c_char,
            dlvl,
        );
    }
    let mut format: *const libc::c_char = b"\t\t{\n\t\t\tdungeonName:          \"%s (%s)\",\n\t\t\tdlvl:                 %d,\n\t\t\tdtype:                %s,\n\t\t\tquestID:              %s,\n\t\t\tseed:                 0x%08X,\n\t\t\tslvl:                 %s,\n\t\t\twantMegaTiles:        \"%s\",\n\t\t\twantMiniTiles:        \"%s\",\n\t\t\twantSpecialMiniTiles: \"%s\",\n\t\t\twantTransparency:     \"%s\",\n\t\t},\n\0"
        as *const u8 as *const libc::c_char;
    _logf(
        format,
        dtype_name_str,
        map_name.as_mut_ptr(),
        dlvl,
        dtype_str,
        quest_id_str,
        seed,
        slvl_str,
        mega_hash,
        mini_hash,
        special_hash,
        trans_hash,
    );
    free(trans_hash as *mut libc::c_void);
    free(special_hash as *mut libc::c_void);
    free(mini_hash as *mut libc::c_void);
    free(mega_hash as *mut libc::c_void);
}
#[no_mangle]
pub unsafe extern "C" fn reset_data(mut data: *mut libc::c_void, mut size: libc::c_int) {
    memset(data, 0 as libc::c_int, size as libc::c_ulong);
}
#[no_mangle]
pub unsafe extern "C" fn reset_globals() {
    reset_data(
        dungeon.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[uint8_t; 40]; 40]>() as libc::c_ulong as libc::c_int,
    );
    reset_data(
        pdungeon.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[uint8_t; 40]; 40]>() as libc::c_ulong as libc::c_int,
    );
    reset_data(
        dflags.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[uint8_t; 40]; 40]>() as libc::c_ulong as libc::c_int,
    );
    reset_data(
        dTransVal.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong as libc::c_int,
    );
    reset_data(
        dFlags.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong as libc::c_int,
    );
    reset_data(
        dSpecial.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[int8_t; 112]; 112]>() as libc::c_ulong as libc::c_int,
    );
    reset_data(
        dPiece.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[[libc::c_int; 112]; 112]>() as libc::c_ulong
            as libc::c_int,
    );
    reset_data(
        quests.as_mut_ptr() as *mut libc::c_void,
        ::core::mem::size_of::<[QuestStruct; 16]>() as libc::c_ulong as libc::c_int,
    );
}
#[no_mangle]
pub unsafe extern "C" fn dump_test_case(
    mut dlvl: libc::c_int,
    mut dtype: libc::c_int,
    mut slvl: libc::c_int,
    mut quest_id: libc::c_int,
    mut seed: uint32_t,
) {
    reset_globals();
    gbMaxPlayers = 1 as libc::c_int as uint8_t;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < MAXQUESTS as libc::c_int {
        quests[i as usize]._qidx = i as uint8_t;
        quests[i as usize]._qtype = i as uint8_t;
        i += 1;
        i;
    }
    let mut load_level_graphics: bool = dtype != leveltype as libc::c_int;
    currlevel = dlvl as uint8_t;
    leveltype = dtype as uint8_t;
    InitLightTable();
    if load_level_graphics {
        if !pDungeonCels.is_null() {
            FreeGameMem();
        }
        LoadLvlGFX();
    }
    FreeMonsterGFX();
    InitLevelMonsters();
    FreeObjectGFX();
    if slvl != SL_NONE as libc::c_int {
        setlevel = 1 as libc::c_int as uint8_t;
        setlvlnum = slvl as uint8_t;
        setlvltype = dtype as uint8_t;
    } else {
        setlevel = 0 as libc::c_int as uint8_t;
        setlvlnum = SL_NONE as libc::c_int as uint8_t;
    }
    if quest_id != Q_NONE as libc::c_int {
        quests[quest_id as usize]._qactive = QUEST_NOTACTIVE as libc::c_int as uint8_t;
        quests[quest_id as usize]._qlevel = dlvl as uint8_t;
    }
    let mut entry: libc::c_int = LVL_DOWN as libc::c_int;
    let mut dtype_name: *const libc::c_char = 0 as *const libc::c_char;
    if slvl != SL_NONE as libc::c_int {
        SetRndSeed(
            b"extra/dump.c\0" as *const u8 as *const libc::c_char,
            313 as libc::c_int,
            seed as int32_t,
        );
        LoadSetMap();
        dtype_name = b"setmap\0" as *const u8 as *const libc::c_char;
    } else {
        match leveltype as libc::c_int {
            0 => {
                dtype_name = b"l0\0" as *const u8 as *const libc::c_char;
            }
            1 => {
                dtype_name = b"l1\0" as *const u8 as *const libc::c_char;
                CreateL5Dungeon(seed, entry);
            }
            2 => {
                dtype_name = b"l2\0" as *const u8 as *const libc::c_char;
                CreateL2Dungeon(seed, entry);
            }
            3 => {
                dtype_name = b"l3\0" as *const u8 as *const libc::c_char;
                CreateL3Dungeon(seed, entry);
            }
            4 => {
                dtype_name = b"l4\0" as *const u8 as *const libc::c_char;
                CreateL4Dungeon(seed, entry);
            }
            _ => {}
        }
    }
    let mut is_slvl: bool = slvl != SL_NONE as libc::c_int;
    dump_drlg(dtype_name, dlvl, slvl, is_slvl, seed);
    print_drlg(dtype, dlvl, slvl, is_slvl, quest_id, seed);
    FreeLightTable();
}
#[no_mangle]
pub static mut tests: [Test; 25] = [
    {
        let mut init = Test {
            dlvl: 1 as libc::c_int,
            dtype: DTYPE_CATHEDRAL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x23849443 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 2 as libc::c_int,
            dtype: DTYPE_CATHEDRAL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x620e6bf3 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 2 as libc::c_int,
            dtype: DTYPE_CATHEDRAL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_PWATER as libc::c_int,
            seed: 0x222d1be0 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 3 as libc::c_int,
            dtype: DTYPE_CATHEDRAL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x7e950561 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 3 as libc::c_int,
            dtype: DTYPE_CATHEDRAL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_SKELKING as libc::c_int,
            seed: 0x67b19cb0 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 4 as libc::c_int,
            dtype: DTYPE_CATHEDRAL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_LTBANNER as libc::c_int,
            seed: 0x1e6854ea as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 5 as libc::c_int,
            dtype: DTYPE_CATACOMBS as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_BLOOD as libc::c_int,
            seed: 0x26431f8f as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 6 as libc::c_int,
            dtype: DTYPE_CATACOMBS as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_SCHAMB as libc::c_int,
            seed: 0x6c91a9c as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 7 as libc::c_int,
            dtype: DTYPE_CATACOMBS as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x4eb4e70c as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 7 as libc::c_int,
            dtype: DTYPE_CATACOMBS as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_BLIND as libc::c_int,
            seed: 0x5b69f5b3 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 8 as libc::c_int,
            dtype: DTYPE_CATACOMBS as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x49ba680e as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 8 as libc::c_int,
            dtype: DTYPE_CATACOMBS as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_ZHAR as libc::c_int,
            seed: 0x4fee8283 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 9 as libc::c_int,
            dtype: DTYPE_CAVES as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x62cd10e2 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 9 as libc::c_int,
            dtype: DTYPE_CAVES as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_BKMUSHRM as libc::c_int,
            seed: 0x4dc8311b as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 10 as libc::c_int,
            dtype: DTYPE_CAVES as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_ANVIL as libc::c_int,
            seed: 0x77e66498 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 11 as libc::c_int,
            dtype: DTYPE_CAVES as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x536dc87 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 12 as libc::c_int,
            dtype: DTYPE_CAVES as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x25fd360e as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 13 as libc::c_int,
            dtype: DTYPE_HELL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_WARLORD as libc::c_int,
            seed: 0x12d074e7 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 14 as libc::c_int,
            dtype: DTYPE_HELL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x68fc95d4 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 15 as libc::c_int,
            dtype: DTYPE_HELL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_BETRAYER as libc::c_int,
            seed: 0x32799ce5 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 16 as libc::c_int,
            dtype: DTYPE_HELL as libc::c_int,
            slvl: SL_NONE as libc::c_int,
            quest_id: Q_NONE as libc::c_int,
            seed: 0x7182be96 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 2 as libc::c_int,
            dtype: DTYPE_CAVES as libc::c_int,
            slvl: SL_POISONWATER as libc::c_int,
            quest_id: Q_PWATER as libc::c_int,
            seed: 0x222d1be0 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 3 as libc::c_int,
            dtype: DTYPE_CATHEDRAL as libc::c_int,
            slvl: SL_SKELKING as libc::c_int,
            quest_id: Q_SKELKING as libc::c_int,
            seed: 0x67b19cb0 as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 6 as libc::c_int,
            dtype: DTYPE_CATACOMBS as libc::c_int,
            slvl: SL_BONECHAMB as libc::c_int,
            quest_id: Q_SCHAMB as libc::c_int,
            seed: 0x6c91a9c as libc::c_int as uint32_t,
        };
        init
    },
    {
        let mut init = Test {
            dlvl: 15 as libc::c_int,
            dtype: DTYPE_CATHEDRAL as libc::c_int,
            slvl: SL_VILEBETRAYER as libc::c_int,
            quest_id: Q_BETRAYER as libc::c_int,
            seed: 0x32799ce5 as libc::c_int as uint32_t,
        };
        init
    },
];
#[no_mangle]
pub unsafe extern "C" fn parse_cmd_string_arg(
    mut s: *mut libc::c_char,
    mut arg_name: *const libc::c_char,
    mut result: *mut *mut libc::c_char,
) -> libc::c_int {
    let mut arg_name_len: libc::c_int = strlen(arg_name) as libc::c_int;
    if strncmp(s, arg_name, arg_name_len as libc::c_ulong) != 0 as libc::c_int {
        return 0 as libc::c_int;
    }
    let mut p: *mut libc::c_char = s.offset(arg_name_len as isize);
    match *p as libc::c_int {
        32 | 61 => {
            p = p.offset(1);
            p;
            let mut end: *mut libc::c_char = strchr(p, ' ' as i32);
            if !end.is_null() {
                *result = p;
                return end.offset_from(s) as libc::c_long as libc::c_int;
            }
            let mut p_len: libc::c_int = strlen(p) as libc::c_int;
            if p_len > 0 as libc::c_int {
                let mut end_0: *mut libc::c_char = p.offset(p_len as isize);
                *result = p;
                return end_0.offset_from(s) as libc::c_long as libc::c_int;
            }
        }
        _ => {}
    }
    return 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn parse_cmd_int_arg(
    mut s: *mut libc::c_char,
    mut arg_name: *const libc::c_char,
    mut result: *mut libc::c_int,
) -> libc::c_int {
    let mut arg_name_len: libc::c_int = strlen(arg_name) as libc::c_int;
    if strncmp(s, arg_name, arg_name_len as libc::c_ulong) != 0 as libc::c_int {
        return 0 as libc::c_int;
    }
    let mut p: *mut libc::c_char = s.offset(arg_name_len as isize);
    match *p as libc::c_int {
        32 | 61 => {
            p = p.offset(1);
            p;
            let mut end: *mut libc::c_char = 0 as *mut libc::c_char;
            let mut x: libc::c_int = strtol(p, &mut end, 10 as libc::c_int)
                as libc::c_int;
            if !end.is_null() {
                *result = x;
                return end.offset_from(s) as libc::c_long as libc::c_int;
            }
        }
        _ => {}
    }
    return 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn parse_cmd_args(mut cmd_line: *mut libc::c_char) {
    let mut cmd_line_len: libc::c_int = strlen(cmd_line) as libc::c_int;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < cmd_line_len {
        let mut p: *mut libc::c_char = &mut *cmd_line.offset(i as isize)
            as *mut libc::c_char;
        let mut n1: libc::c_int = parse_cmd_int_arg(
            p,
            b"-game_seed\0" as *const u8 as *const libc::c_char,
            &mut set_game_seed,
        );
        if n1 != 0 as libc::c_int {
            i += n1;
            _logf(
                b"set_game_seed: 0x%08X\0" as *const u8 as *const libc::c_char,
                set_game_seed as uint32_t,
            );
        } else {
            let mut n2: libc::c_int = parse_cmd_int_arg(
                p,
                b"-player_seed\0" as *const u8 as *const libc::c_char,
                &mut set_player_seed,
            );
            if n2 != 0 as libc::c_int {
                i += n2;
                _logf(
                    b"set_player_seed: 0x%08X\0" as *const u8 as *const libc::c_char,
                    set_player_seed as uint32_t,
                );
            } else {
                let mut n3: libc::c_int = parse_cmd_int_arg(
                    p,
                    b"-stores_seed\0" as *const u8 as *const libc::c_char,
                    &mut set_stores_seed,
                );
                if n3 != 0 as libc::c_int {
                    i += n3;
                    _logf(
                        b"set_stores_seed: 0x%08X\0" as *const u8 as *const libc::c_char,
                        set_stores_seed as uint32_t,
                    );
                } else {
                    let mut n4: libc::c_int = parse_cmd_string_arg(
                        p,
                        b"-replay\0" as *const u8 as *const libc::c_char,
                        &mut replay_path,
                    );
                    if n4 != 0 as libc::c_int {
                        i += n4;
                        _logf(
                            b"replay_path: %s\0" as *const u8 as *const libc::c_char,
                            replay_path,
                        );
                    } else {
                        let mut n5: libc::c_int = parse_cmd_int_arg(
                            p,
                            b"-game_fps\0" as *const u8 as *const libc::c_char,
                            &mut GAME_FRAMES_PER_SECOND,
                        );
                        if n5 != 0 as libc::c_int {
                            i += n5;
                            _logf(
                                b"game_fps: %d\0" as *const u8 as *const libc::c_char,
                                GAME_FRAMES_PER_SECOND,
                            );
                        } else {
                            i += 1;
                            i;
                        }
                    }
                }
            }
        }
    }
}
#[no_mangle]
pub unsafe extern "C" fn dump_test_cases1() {
    leveltype = DTYPE_TRISTRAM as libc::c_int as uint8_t;
    let mut ntests: libc::c_int = (::core::mem::size_of::<[Test; 25]>() as libc::c_ulong)
        .wrapping_div(::core::mem::size_of::<Test>() as libc::c_ulong) as libc::c_int;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < ntests {
        let mut t: Test = tests[i as usize];
        dump_test_case(t.dlvl, t.dtype, t.slvl, t.quest_id, t.seed);
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn dump_test_cases2() {
    leveltype = DTYPE_TRISTRAM as libc::c_int as uint8_t;
    let mut dlvl: libc::c_int = 1 as libc::c_int;
    let mut dtype: libc::c_int = DTYPE_CATHEDRAL as libc::c_int;
    let mut slvl: libc::c_int = SL_NONE as libc::c_int;
    let mut quest_id: libc::c_int = Q_NONE as libc::c_int;
    let mut seed: uint32_t = 0 as libc::c_int as uint32_t;
    while seed < 100 as libc::c_int as uint32_t {
        dump_test_case(dlvl, dtype, slvl, quest_id, seed);
        seed = seed.wrapping_add(1);
        seed;
    }
}
