use ::libc;
pub type C2RustUnnamed = libc::c_uint;
pub const MAXDIRT: C2RustUnnamed = 32;
pub const MAXMICRO: C2RustUnnamed = 2048;
pub const SPEEDSIZE: C2RustUnnamed = 1048576;
pub const NUMSPEEDCELS: C2RustUnnamed = 64;
pub const MAXMREND: C2RustUnnamed = 128;
pub const MAXTILES: C2RustUnnamed = 2048;
pub const MDMAXY: C2RustUnnamed = 40;
pub const MDMAXX: C2RustUnnamed = 40;
pub const MAXDUNY: C2RustUnnamed = 112;
pub const MAXDUNX: C2RustUnnamed = 112;
pub const DMAXY: C2RustUnnamed = 112;
pub const DMAXX: C2RustUnnamed = 112;
pub const DIRTEDGED2: C2RustUnnamed = 16;
pub const DIRTEDGE: C2RustUnnamed = 32;
pub const NUMSLEVELS: C2RustUnnamed = 10;
pub const NUMLEVELS: C2RustUnnamed = 17;
pub const LVL4_START: C2RustUnnamed = 13;
pub const LVL3_START: C2RustUnnamed = 9;
pub const LVL2_START: C2RustUnnamed = 5;
pub const LVL1_START: C2RustUnnamed = 1;
pub const TLVL_START: C2RustUnnamed = 0;
pub const LVLLENGTH: C2RustUnnamed = 4;
#[no_mangle]
pub unsafe extern "C" fn OuterMapContains(
    mut x: libc::c_int,
    mut y: libc::c_int,
) -> bool {
    return 0 as libc::c_int <= x && x < DMAXX as libc::c_int && 0 as libc::c_int <= y
        && y < DMAXY as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn MegaTileMapContains(
    mut xx: libc::c_int,
    mut yy: libc::c_int,
) -> bool {
    return 0 as libc::c_int <= xx && xx < MDMAXX as libc::c_int && 0 as libc::c_int <= yy
        && yy < MDMAXY as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn EmulateOverflow(
    mut xx: *mut libc::c_int,
    mut yy: *mut libc::c_int,
) {
    while *yy < 0 as libc::c_int {
        *yy += MDMAXY as libc::c_int;
        *xx = *xx - 1 as libc::c_int;
    }
    while *yy >= MDMAXY as libc::c_int {
        *yy -= MDMAXY as libc::c_int;
        *xx = *xx + 1 as libc::c_int;
    }
}
#[no_mangle]
pub unsafe extern "C" fn MegaToMini(mut mega_tile_id: libc::c_int) -> libc::c_int {
    return mega_tile_id * 2 as libc::c_int + DIRTEDGED2 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn MiniToMega(mut mini_tile_id: libc::c_int) -> libc::c_int {
    return (mini_tile_id - DIRTEDGED2 as libc::c_int) / 2 as libc::c_int;
}
