use ::libc;
extern "C" {
    pub type _IO_wide_data;
    pub type _IO_codecvt;
    pub type _IO_marker;
    static mut stderr: *mut FILE;
    fn fprintf(_: *mut FILE, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn strtod(_: *const libc::c_char, _: *mut *mut libc::c_char) -> libc::c_double;
    fn strtol(
        _: *const libc::c_char,
        _: *mut *mut libc::c_char,
        _: libc::c_int,
    ) -> libc::c_long;
    fn strtoul(
        _: *const libc::c_char,
        _: *mut *mut libc::c_char,
        _: libc::c_int,
    ) -> libc::c_ulong;
    fn calloc(_: libc::c_ulong, _: libc::c_ulong) -> *mut libc::c_void;
    fn free(_: *mut libc::c_void);
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn strcmp(_: *const libc::c_char, _: *const libc::c_char) -> libc::c_int;
    fn strncmp(
        _: *const libc::c_char,
        _: *const libc::c_char,
        _: libc::c_ulong,
    ) -> libc::c_int;
    fn strchr(_: *const libc::c_char, _: libc::c_int) -> *mut libc::c_char;
}
pub type __uint8_t = libc::c_uchar;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
pub type int64_t = __int64_t;
pub type uint8_t = __uint8_t;
pub type uint64_t = __uint64_t;
pub type size_t = libc::c_ulong;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _IO_FILE {
    pub _flags: libc::c_int,
    pub _IO_read_ptr: *mut libc::c_char,
    pub _IO_read_end: *mut libc::c_char,
    pub _IO_read_base: *mut libc::c_char,
    pub _IO_write_base: *mut libc::c_char,
    pub _IO_write_ptr: *mut libc::c_char,
    pub _IO_write_end: *mut libc::c_char,
    pub _IO_buf_base: *mut libc::c_char,
    pub _IO_buf_end: *mut libc::c_char,
    pub _IO_save_base: *mut libc::c_char,
    pub _IO_backup_base: *mut libc::c_char,
    pub _IO_save_end: *mut libc::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: libc::c_int,
    pub _flags2: libc::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: libc::c_ushort,
    pub _vtable_offset: libc::c_schar,
    pub _shortbuf: [libc::c_char; 1],
    pub _lock: *mut libc::c_void,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut libc::c_void,
    pub __pad5: size_t,
    pub _mode: libc::c_int,
    pub _unused2: [libc::c_char; 20],
}
pub type _IO_lock_t = ();
pub type FILE = _IO_FILE;
pub type nxjson_u64 = uint64_t;
pub type nxjson_s64 = uint64_t;
pub type nx_json_type = libc::c_uint;
pub const NX_JSON_BOOL: nx_json_type = 6;
pub const NX_JSON_DOUBLE: nx_json_type = 5;
pub const NX_JSON_INTEGER: nx_json_type = 4;
pub const NX_JSON_STRING: nx_json_type = 3;
pub const NX_JSON_ARRAY: nx_json_type = 2;
pub const NX_JSON_OBJECT: nx_json_type = 1;
pub const NX_JSON_NULL: nx_json_type = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct nx_json {
    pub type_0: nx_json_type,
    pub key: *const libc::c_char,
    pub c2rust_unnamed: C2RustUnnamed,
    pub next: *mut nx_json,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed {
    pub text_value: *const libc::c_char,
    pub num: C2RustUnnamed_1,
    pub children: C2RustUnnamed_0,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_0 {
    pub length: libc::c_int,
    pub first: *mut nx_json,
    pub last: *mut nx_json,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_1 {
    pub c2rust_unnamed: C2RustUnnamed_2,
    pub dbl_value: libc::c_double,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed_2 {
    pub u_value: nxjson_u64,
    pub s_value: nxjson_s64,
}
pub type nx_json_unicode_encoder = Option::<
    unsafe extern "C" fn(
        libc::c_uint,
        *mut libc::c_char,
        *mut *mut libc::c_char,
    ) -> libc::c_int,
>;
unsafe extern "C" fn create_json(
    mut type_0: nx_json_type,
    mut key: *const libc::c_char,
    mut parent: *mut nx_json,
) -> *mut nx_json {
    let mut js: *mut nx_json = calloc(
        1 as libc::c_int as libc::c_ulong,
        ::core::mem::size_of::<nx_json>() as libc::c_ulong,
    ) as *mut nx_json;
    memset(
        js as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<nx_json>() as libc::c_ulong,
    );
    (*js).type_0 = type_0;
    (*js).key = key;
    if ((*parent).c2rust_unnamed.children.last).is_null() {
        (*parent).c2rust_unnamed.children.last = js;
        (*parent).c2rust_unnamed.children.first = (*parent).c2rust_unnamed.children.last;
    } else {
        (*(*parent).c2rust_unnamed.children.last).next = js;
        (*parent).c2rust_unnamed.children.last = js;
    }
    (*parent).c2rust_unnamed.children.length += 1;
    (*parent).c2rust_unnamed.children.length;
    return js;
}
#[no_mangle]
pub unsafe extern "C" fn nx_json_free(mut js: *const nx_json) {
    if js.is_null() {
        return;
    }
    if (*js).type_0 as libc::c_uint == NX_JSON_OBJECT as libc::c_int as libc::c_uint
        || (*js).type_0 as libc::c_uint == NX_JSON_ARRAY as libc::c_int as libc::c_uint
    {
        let mut p: *mut nx_json = (*js).c2rust_unnamed.children.first;
        let mut p1: *mut nx_json = 0 as *mut nx_json;
        while !p.is_null() {
            p1 = (*p).next;
            nx_json_free(p);
            p = p1;
        }
    }
    free(js as *mut libc::c_void);
}
unsafe extern "C" fn unicode_to_utf8(
    mut codepoint: libc::c_uint,
    mut p: *mut libc::c_char,
    mut endp: *mut *mut libc::c_char,
) -> libc::c_int {
    if codepoint < 0x80 as libc::c_int as libc::c_uint {
        let fresh0 = p;
        p = p.offset(1);
        *fresh0 = codepoint as libc::c_char;
    } else if codepoint < 0x800 as libc::c_int as libc::c_uint {
        let fresh1 = p;
        p = p.offset(1);
        *fresh1 = (192 as libc::c_int as libc::c_uint)
            .wrapping_add(codepoint.wrapping_div(64 as libc::c_int as libc::c_uint))
            as libc::c_char;
        let fresh2 = p;
        p = p.offset(1);
        *fresh2 = (128 as libc::c_int as libc::c_uint)
            .wrapping_add(codepoint.wrapping_rem(64 as libc::c_int as libc::c_uint))
            as libc::c_char;
    } else if codepoint.wrapping_sub(0xd800 as libc::c_uint)
        < 0x800 as libc::c_int as libc::c_uint
    {
        return 0 as libc::c_int
    } else if codepoint < 0x10000 as libc::c_int as libc::c_uint {
        let fresh3 = p;
        p = p.offset(1);
        *fresh3 = (224 as libc::c_int as libc::c_uint)
            .wrapping_add(codepoint.wrapping_div(4096 as libc::c_int as libc::c_uint))
            as libc::c_char;
        let fresh4 = p;
        p = p.offset(1);
        *fresh4 = (128 as libc::c_int as libc::c_uint)
            .wrapping_add(
                codepoint
                    .wrapping_div(64 as libc::c_int as libc::c_uint)
                    .wrapping_rem(64 as libc::c_int as libc::c_uint),
            ) as libc::c_char;
        let fresh5 = p;
        p = p.offset(1);
        *fresh5 = (128 as libc::c_int as libc::c_uint)
            .wrapping_add(codepoint.wrapping_rem(64 as libc::c_int as libc::c_uint))
            as libc::c_char;
    } else if codepoint < 0x110000 as libc::c_int as libc::c_uint {
        let fresh6 = p;
        p = p.offset(1);
        *fresh6 = (240 as libc::c_int as libc::c_uint)
            .wrapping_add(codepoint.wrapping_div(262144 as libc::c_int as libc::c_uint))
            as libc::c_char;
        let fresh7 = p;
        p = p.offset(1);
        *fresh7 = (128 as libc::c_int as libc::c_uint)
            .wrapping_add(
                codepoint
                    .wrapping_div(4096 as libc::c_int as libc::c_uint)
                    .wrapping_rem(64 as libc::c_int as libc::c_uint),
            ) as libc::c_char;
        let fresh8 = p;
        p = p.offset(1);
        *fresh8 = (128 as libc::c_int as libc::c_uint)
            .wrapping_add(
                codepoint
                    .wrapping_div(64 as libc::c_int as libc::c_uint)
                    .wrapping_rem(64 as libc::c_int as libc::c_uint),
            ) as libc::c_char;
        let fresh9 = p;
        p = p.offset(1);
        *fresh9 = (128 as libc::c_int as libc::c_uint)
            .wrapping_add(codepoint.wrapping_rem(64 as libc::c_int as libc::c_uint))
            as libc::c_char;
    } else {
        return 0 as libc::c_int
    }
    *endp = p;
    return 1 as libc::c_int;
}
#[no_mangle]
pub static mut nx_json_unicode_to_utf8: nx_json_unicode_encoder = unsafe {
    Some(
        unicode_to_utf8
            as unsafe extern "C" fn(
                libc::c_uint,
                *mut libc::c_char,
                *mut *mut libc::c_char,
            ) -> libc::c_int,
    )
};
unsafe extern "C" fn hex_val(mut c: libc::c_char) -> libc::c_int {
    if c as libc::c_int >= '0' as i32 && c as libc::c_int <= '9' as i32 {
        return c as libc::c_int - '0' as i32;
    }
    if c as libc::c_int >= 'a' as i32 && c as libc::c_int <= 'f' as i32 {
        return c as libc::c_int - 'a' as i32 + 10 as libc::c_int;
    }
    if c as libc::c_int >= 'A' as i32 && c as libc::c_int <= 'F' as i32 {
        return c as libc::c_int - 'A' as i32 + 10 as libc::c_int;
    }
    return -(1 as libc::c_int);
}
unsafe extern "C" fn unescape_string(
    mut s: *mut libc::c_char,
    mut end: *mut *mut libc::c_char,
    mut encoder: nx_json_unicode_encoder,
) -> *mut libc::c_char {
    let mut p: *mut libc::c_char = s;
    let mut d: *mut libc::c_char = s;
    let mut c: libc::c_char = 0;
    let mut ps: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut h1: libc::c_int = 0;
    let mut h2: libc::c_int = 0;
    let mut h3: libc::c_int = 0;
    let mut h4: libc::c_int = 0;
    let mut codepoint: libc::c_uint = 0;
    let mut codepoint2: libc::c_uint = 0;
    loop {
        let fresh10 = p;
        p = p.offset(1);
        c = *fresh10;
        if !(c != 0) {
            break;
        }
        if c as libc::c_int == '"' as i32 {
            *d = '\0' as i32 as libc::c_char;
            *end = p;
            return s;
        } else if c as libc::c_int == '\\' as i32 {
            match *p as libc::c_int {
                92 | 47 | 34 => {
                    *d = *p;
                    d = d.offset(1);
                    d;
                    p = p.offset(1);
                    p;
                }
                98 => {
                    let fresh11 = d;
                    d = d.offset(1);
                    *fresh11 = '\u{8}' as i32 as libc::c_char;
                    p = p.offset(1);
                    p;
                }
                102 => {
                    let fresh12 = d;
                    d = d.offset(1);
                    *fresh12 = '\u{c}' as i32 as libc::c_char;
                    p = p.offset(1);
                    p;
                }
                110 => {
                    let fresh13 = d;
                    d = d.offset(1);
                    *fresh13 = '\n' as i32 as libc::c_char;
                    p = p.offset(1);
                    p;
                }
                114 => {
                    let fresh14 = d;
                    d = d.offset(1);
                    *fresh14 = '\r' as i32 as libc::c_char;
                    p = p.offset(1);
                    p;
                }
                116 => {
                    let fresh15 = d;
                    d = d.offset(1);
                    *fresh15 = '\t' as i32 as libc::c_char;
                    p = p.offset(1);
                    p;
                }
                117 => {
                    if encoder.is_none() {
                        let fresh16 = d;
                        d = d.offset(1);
                        *fresh16 = c;
                    } else {
                        ps = p.offset(-(1 as libc::c_int as isize));
                        h1 = hex_val(*p.offset(1 as libc::c_int as isize));
                        if h1 < 0 as libc::c_int
                            || {
                                h2 = hex_val(*p.offset(2 as libc::c_int as isize));
                                h2 < 0 as libc::c_int
                            }
                            || {
                                h3 = hex_val(*p.offset(3 as libc::c_int as isize));
                                h3 < 0 as libc::c_int
                            }
                            || {
                                h4 = hex_val(*p.offset(4 as libc::c_int as isize));
                                h4 < 0 as libc::c_int
                            }
                        {
                            fprintf(
                                stderr,
                                b"NXJSON PARSE ERROR (%d): invalid unicode escape at %s\n\0"
                                    as *const u8 as *const libc::c_char,
                                146 as libc::c_int,
                                p.offset(-(1 as libc::c_int as isize)),
                            );
                            return 0 as *mut libc::c_char;
                        }
                        codepoint = (h1 << 12 as libc::c_int | h2 << 8 as libc::c_int
                            | h3 << 4 as libc::c_int | h4) as libc::c_uint;
                        if codepoint & 0xfc00 as libc::c_int as libc::c_uint
                            == 0xd800 as libc::c_int as libc::c_uint
                        {
                            p = p.offset(6 as libc::c_int as isize);
                            if *p.offset(-(1 as libc::c_int) as isize) as libc::c_int
                                != '\\' as i32 || *p as libc::c_int != 'u' as i32
                                || {
                                    h1 = hex_val(*p.offset(1 as libc::c_int as isize));
                                    h1 < 0 as libc::c_int
                                }
                                || {
                                    h2 = hex_val(*p.offset(2 as libc::c_int as isize));
                                    h2 < 0 as libc::c_int
                                }
                                || {
                                    h3 = hex_val(*p.offset(3 as libc::c_int as isize));
                                    h3 < 0 as libc::c_int
                                }
                                || {
                                    h4 = hex_val(*p.offset(4 as libc::c_int as isize));
                                    h4 < 0 as libc::c_int
                                }
                            {
                                fprintf(
                                    stderr,
                                    b"NXJSON PARSE ERROR (%d): invalid unicode surrogate at %s\n\0"
                                        as *const u8 as *const libc::c_char,
                                    153 as libc::c_int,
                                    ps,
                                );
                                return 0 as *mut libc::c_char;
                            }
                            codepoint2 = (h1 << 12 as libc::c_int
                                | h2 << 8 as libc::c_int | h3 << 4 as libc::c_int | h4)
                                as libc::c_uint;
                            if codepoint2 & 0xfc00 as libc::c_int as libc::c_uint
                                != 0xdc00 as libc::c_int as libc::c_uint
                            {
                                fprintf(
                                    stderr,
                                    b"NXJSON PARSE ERROR (%d): invalid unicode surrogate at %s\n\0"
                                        as *const u8 as *const libc::c_char,
                                    158 as libc::c_int,
                                    ps,
                                );
                                return 0 as *mut libc::c_char;
                            }
                            codepoint = (0x10000 as libc::c_int as libc::c_uint)
                                .wrapping_add(
                                    codepoint
                                        .wrapping_sub(0xd800 as libc::c_int as libc::c_uint)
                                        << 10 as libc::c_int,
                                )
                                .wrapping_add(
                                    codepoint2
                                        .wrapping_sub(0xdc00 as libc::c_int as libc::c_uint),
                                );
                        }
                        if encoder
                            .expect("non-null function pointer")(codepoint, d, &mut d)
                            == 0
                        {
                            fprintf(
                                stderr,
                                b"NXJSON PARSE ERROR (%d): invalid codepoint at %s\n\0"
                                    as *const u8 as *const libc::c_char,
                                164 as libc::c_int,
                                ps,
                            );
                            return 0 as *mut libc::c_char;
                        }
                        p = p.offset(5 as libc::c_int as isize);
                    }
                }
                _ => {
                    let fresh17 = d;
                    d = d.offset(1);
                    *fresh17 = c;
                }
            }
        } else {
            let fresh18 = d;
            d = d.offset(1);
            *fresh18 = c;
        }
    }
    fprintf(
        stderr,
        b"NXJSON PARSE ERROR (%d): no closing quote for string at %s\n\0" as *const u8
            as *const libc::c_char,
        178 as libc::c_int,
        s,
    );
    return 0 as *mut libc::c_char;
}
unsafe extern "C" fn skip_block_comment(mut p: *mut libc::c_char) -> *mut libc::c_char {
    let mut ps: *mut libc::c_char = p.offset(-(2 as libc::c_int as isize));
    if *p == 0 {
        fprintf(
            stderr,
            b"NXJSON PARSE ERROR (%d): endless comment at %s\n\0" as *const u8
                as *const libc::c_char,
            186 as libc::c_int,
            ps,
        );
        return 0 as *mut libc::c_char;
    }
    loop {
        p = strchr(p.offset(1 as libc::c_int as isize), '/' as i32);
        if p.is_null() {
            fprintf(
                stderr,
                b"NXJSON PARSE ERROR (%d): endless comment at %s\n\0" as *const u8
                    as *const libc::c_char,
                192 as libc::c_int,
                ps,
            );
            return 0 as *mut libc::c_char;
        }
        if !(*p.offset(-(1 as libc::c_int) as isize) as libc::c_int != '*' as i32) {
            break;
        }
    }
    return p.offset(1 as libc::c_int as isize);
}
unsafe extern "C" fn parse_key(
    mut key: *mut *const libc::c_char,
    mut p: *mut libc::c_char,
    mut encoder: nx_json_unicode_encoder,
) -> *mut libc::c_char {
    let mut c: libc::c_char = 0;
    loop {
        let fresh19 = p;
        p = p.offset(1);
        c = *fresh19;
        if !(c != 0) {
            break;
        }
        if c as libc::c_int == '"' as i32 {
            *key = unescape_string(p, &mut p, encoder);
            if (*key).is_null() {
                return 0 as *mut libc::c_char;
            }
            while *p as libc::c_int != 0
                && *p as uint8_t as libc::c_int <= ' ' as i32 as uint8_t as libc::c_int
            {
                p = p.offset(1);
                p;
            }
            if *p as libc::c_int == ':' as i32 {
                return p.offset(1 as libc::c_int as isize);
            }
            fprintf(
                stderr,
                b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0" as *const u8
                    as *const libc::c_char,
                216 as libc::c_int,
                p,
            );
            return 0 as *mut libc::c_char;
        } else if !(c as uint8_t as libc::c_int <= ' ' as i32 as uint8_t as libc::c_int
            || c as libc::c_int == ',' as i32)
        {
            if c as libc::c_int == '}' as i32 {
                return p.offset(-(1 as libc::c_int as isize))
            } else if c as libc::c_int == '/' as i32 {
                if *p as libc::c_int == '/' as i32 {
                    let mut ps: *mut libc::c_char = p
                        .offset(-(1 as libc::c_int as isize));
                    p = strchr(p.offset(1 as libc::c_int as isize), '\n' as i32);
                    if p.is_null() {
                        fprintf(
                            stderr,
                            b"NXJSON PARSE ERROR (%d): endless comment at %s\n\0"
                                as *const u8 as *const libc::c_char,
                            227 as libc::c_int,
                            ps,
                        );
                        return 0 as *mut libc::c_char;
                    }
                    p = p.offset(1);
                    p;
                } else if *p as libc::c_int == '*' as i32 {
                    p = skip_block_comment(p.offset(1 as libc::c_int as isize));
                    if p.is_null() {
                        return 0 as *mut libc::c_char;
                    }
                } else {
                    fprintf(
                        stderr,
                        b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0"
                            as *const u8 as *const libc::c_char,
                        237 as libc::c_int,
                        p.offset(-(1 as libc::c_int as isize)),
                    );
                    return 0 as *mut libc::c_char;
                }
            } else {
                fprintf(
                    stderr,
                    b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0" as *const u8
                        as *const libc::c_char,
                    241 as libc::c_int,
                    p.offset(-(1 as libc::c_int as isize)),
                );
                return 0 as *mut libc::c_char;
            }
        }
    }
    fprintf(
        stderr,
        b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0" as *const u8
            as *const libc::c_char,
        245 as libc::c_int,
        p.offset(-(1 as libc::c_int as isize)),
    );
    return 0 as *mut libc::c_char;
}
unsafe extern "C" fn parse_value(
    mut parent: *mut nx_json,
    mut key: *const libc::c_char,
    mut p: *mut libc::c_char,
    mut encoder: nx_json_unicode_encoder,
) -> *mut libc::c_char {
    let mut pe: *mut libc::c_char = 0 as *mut libc::c_char;
    let mut js: *mut nx_json = 0 as *mut nx_json;
    loop {
        match *p as libc::c_int {
            0 => {
                fprintf(
                    stderr,
                    b"NXJSON PARSE ERROR (%d): unexpected end of text at %s\n\0"
                        as *const u8 as *const libc::c_char,
                    255 as libc::c_int,
                    p,
                );
                return 0 as *mut libc::c_char;
            }
            32 | 9 | 10 | 13 | 44 => {
                p = p.offset(1);
                p;
            }
            123 => {
                js = create_json(NX_JSON_OBJECT, key, parent);
                p = p.offset(1);
                p;
                loop {
                    let mut new_key: *const libc::c_char = 0 as *const libc::c_char;
                    p = parse_key(&mut new_key, p, encoder);
                    if p.is_null() {
                        return 0 as *mut libc::c_char;
                    }
                    if *p as libc::c_int == '}' as i32 {
                        return p.offset(1 as libc::c_int as isize);
                    }
                    p = parse_value(js, new_key, p, encoder);
                    if p.is_null() {
                        return 0 as *mut libc::c_char;
                    }
                }
            }
            91 => {
                js = create_json(NX_JSON_ARRAY, key, parent);
                p = p.offset(1);
                p;
                loop {
                    p = parse_value(js, 0 as *const libc::c_char, p, encoder);
                    if p.is_null() {
                        return 0 as *mut libc::c_char;
                    }
                    if *p as libc::c_int == ']' as i32 {
                        return p.offset(1 as libc::c_int as isize);
                    }
                }
            }
            93 => return p,
            34 => {
                p = p.offset(1);
                p;
                js = create_json(NX_JSON_STRING, key, parent);
                (*js).c2rust_unnamed.text_value = unescape_string(p, &mut p, encoder);
                if ((*js).c2rust_unnamed.text_value).is_null() {
                    return 0 as *mut libc::c_char;
                }
                return p;
            }
            45 | 48 | 49 | 50 | 51 | 52 | 53 | 54 | 55 | 56 | 57 => {
                js = create_json(NX_JSON_INTEGER, key, parent);
                if *p as libc::c_int == '-' as i32 {
                    (*js)
                        .c2rust_unnamed
                        .num
                        .c2rust_unnamed
                        .s_value = strtol(p, &mut pe, 0 as libc::c_int) as nxjson_s64;
                } else {
                    (*js)
                        .c2rust_unnamed
                        .num
                        .c2rust_unnamed
                        .u_value = strtoul(p, &mut pe, 0 as libc::c_int);
                }
                if pe == p {
                    fprintf(
                        stderr,
                        b"NXJSON PARSE ERROR (%d): invalid number at %s\n\0" as *const u8
                            as *const libc::c_char,
                        322 as libc::c_int,
                        p,
                    );
                    return 0 as *mut libc::c_char;
                }
                if *pe as libc::c_int == '.' as i32 || *pe as libc::c_int == 'e' as i32
                    || *pe as libc::c_int == 'E' as i32
                {
                    (*js).type_0 = NX_JSON_DOUBLE;
                    (*js).c2rust_unnamed.num.dbl_value = strtod(p, &mut pe);
                    if pe == p {
                        fprintf(
                            stderr,
                            b"NXJSON PARSE ERROR (%d): invalid number at %s\n\0"
                                as *const u8 as *const libc::c_char,
                            329 as libc::c_int,
                            p,
                        );
                        return 0 as *mut libc::c_char;
                    }
                } else if *p as libc::c_int == '-' as i32 {
                    (*js)
                        .c2rust_unnamed
                        .num
                        .dbl_value = (*js).c2rust_unnamed.num.c2rust_unnamed.s_value
                        as int64_t as libc::c_double;
                } else {
                    (*js)
                        .c2rust_unnamed
                        .num
                        .dbl_value = (*js).c2rust_unnamed.num.c2rust_unnamed.u_value
                        as int64_t as libc::c_double;
                }
                return pe;
            }
            116 => {
                if strncmp(
                    p,
                    b"true\0" as *const u8 as *const libc::c_char,
                    4 as libc::c_int as libc::c_ulong,
                ) == 0
                {
                    js = create_json(NX_JSON_BOOL, key, parent);
                    (*js)
                        .c2rust_unnamed
                        .num
                        .c2rust_unnamed
                        .u_value = 1 as libc::c_int as nxjson_u64;
                    return p.offset(4 as libc::c_int as isize);
                }
                fprintf(
                    stderr,
                    b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0" as *const u8
                        as *const libc::c_char,
                    347 as libc::c_int,
                    p,
                );
                return 0 as *mut libc::c_char;
            }
            102 => {
                if strncmp(
                    p,
                    b"false\0" as *const u8 as *const libc::c_char,
                    5 as libc::c_int as libc::c_ulong,
                ) == 0
                {
                    js = create_json(NX_JSON_BOOL, key, parent);
                    (*js)
                        .c2rust_unnamed
                        .num
                        .c2rust_unnamed
                        .u_value = 0 as libc::c_int as nxjson_u64;
                    return p.offset(5 as libc::c_int as isize);
                }
                fprintf(
                    stderr,
                    b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0" as *const u8
                        as *const libc::c_char,
                    355 as libc::c_int,
                    p,
                );
                return 0 as *mut libc::c_char;
            }
            110 => {
                if strncmp(
                    p,
                    b"null\0" as *const u8 as *const libc::c_char,
                    4 as libc::c_int as libc::c_ulong,
                ) == 0
                {
                    create_json(NX_JSON_NULL, key, parent);
                    return p.offset(4 as libc::c_int as isize);
                }
                fprintf(
                    stderr,
                    b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0" as *const u8
                        as *const libc::c_char,
                    362 as libc::c_int,
                    p,
                );
                return 0 as *mut libc::c_char;
            }
            47 => {
                if *p.offset(1 as libc::c_int as isize) as libc::c_int == '/' as i32 {
                    let mut ps: *mut libc::c_char = p;
                    p = strchr(p.offset(2 as libc::c_int as isize), '\n' as i32);
                    if p.is_null() {
                        fprintf(
                            stderr,
                            b"NXJSON PARSE ERROR (%d): endless comment at %s\n\0"
                                as *const u8 as *const libc::c_char,
                            369 as libc::c_int,
                            ps,
                        );
                        return 0 as *mut libc::c_char;
                    }
                    p = p.offset(1);
                    p;
                } else if *p.offset(1 as libc::c_int as isize) as libc::c_int
                    == '*' as i32
                {
                    p = skip_block_comment(p.offset(2 as libc::c_int as isize));
                    if p.is_null() {
                        return 0 as *mut libc::c_char;
                    }
                } else {
                    fprintf(
                        stderr,
                        b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0"
                            as *const u8 as *const libc::c_char,
                        379 as libc::c_int,
                        p,
                    );
                    return 0 as *mut libc::c_char;
                }
            }
            _ => {
                fprintf(
                    stderr,
                    b"NXJSON PARSE ERROR (%d): unexpected chars at %s\n\0" as *const u8
                        as *const libc::c_char,
                    384 as libc::c_int,
                    p,
                );
                return 0 as *mut libc::c_char;
            }
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn nx_json_parse_utf8(
    mut text: *mut libc::c_char,
) -> *const nx_json {
    return nx_json_parse(
        text,
        Some(
            unicode_to_utf8
                as unsafe extern "C" fn(
                    libc::c_uint,
                    *mut libc::c_char,
                    *mut *mut libc::c_char,
                ) -> libc::c_int,
        ),
    );
}
#[no_mangle]
pub unsafe extern "C" fn nx_json_parse(
    mut text: *mut libc::c_char,
    mut encoder: nx_json_unicode_encoder,
) -> *const nx_json {
    let mut js: nx_json = {
        let mut init = nx_json {
            type_0: NX_JSON_NULL,
            key: 0 as *const libc::c_char,
            c2rust_unnamed: C2RustUnnamed {
                text_value: 0 as *const libc::c_char,
            },
            next: 0 as *mut nx_json,
        };
        init
    };
    memset(
        &mut js as *mut nx_json as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<nx_json>() as libc::c_ulong,
    );
    if (parse_value(&mut js, 0 as *const libc::c_char, text, encoder)).is_null() {
        if !(js.c2rust_unnamed.children.first).is_null() {
            nx_json_free(js.c2rust_unnamed.children.first);
        }
        return 0 as *const nx_json;
    }
    return js.c2rust_unnamed.children.first;
}
#[no_mangle]
pub unsafe extern "C" fn nx_json_get(
    mut json: *const nx_json,
    mut key: *const libc::c_char,
) -> *const nx_json {
    let mut js: *mut nx_json = 0 as *mut nx_json;
    js = (*json).c2rust_unnamed.children.first;
    while !js.is_null() {
        if !((*js).key).is_null() && strcmp((*js).key, key) == 0 {
            return js;
        }
        js = (*js).next;
    }
    return 0 as *const nx_json;
}
#[no_mangle]
pub unsafe extern "C" fn nx_json_item(
    mut json: *const nx_json,
    mut idx: libc::c_int,
) -> *const nx_json {
    let mut js: *mut nx_json = 0 as *mut nx_json;
    js = (*json).c2rust_unnamed.children.first;
    while !js.is_null() {
        let fresh20 = idx;
        idx = idx - 1;
        if fresh20 == 0 {
            return js;
        }
        js = (*js).next;
    }
    return 0 as *const nx_json;
}
