use ::libc;
extern "C" {
    pub type _IO_wide_data;
    pub type _IO_codecvt;
    pub type _IO_marker;
    static mut stderr: *mut FILE;
    fn fclose(__stream: *mut FILE) -> libc::c_int;
    fn fopen(_: *const libc::c_char, _: *const libc::c_char) -> *mut FILE;
    fn fprintf(_: *mut FILE, _: *const libc::c_char, _: ...) -> libc::c_int;
    fn fputs(__s: *const libc::c_char, __stream: *mut FILE) -> libc::c_int;
    fn fread(
        _: *mut libc::c_void,
        _: libc::c_ulong,
        _: libc::c_ulong,
        _: *mut FILE,
    ) -> libc::c_ulong;
    fn fseek(
        __stream: *mut FILE,
        __off: libc::c_long,
        __whence: libc::c_int,
    ) -> libc::c_int;
    fn ftell(__stream: *mut FILE) -> libc::c_long;
    fn perror(__s: *const libc::c_char);
    fn malloc(_: libc::c_ulong) -> *mut libc::c_void;
    fn calloc(_: libc::c_ulong, _: libc::c_ulong) -> *mut libc::c_void;
    fn free(_: *mut libc::c_void);
    fn exit(_: libc::c_int) -> !;
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memmove(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int16_t = libc::c_short;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
pub type int8_t = __int8_t;
pub type int16_t = __int16_t;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type size_t = libc::c_ulong;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _IO_FILE {
    pub _flags: libc::c_int,
    pub _IO_read_ptr: *mut libc::c_char,
    pub _IO_read_end: *mut libc::c_char,
    pub _IO_read_base: *mut libc::c_char,
    pub _IO_write_base: *mut libc::c_char,
    pub _IO_write_ptr: *mut libc::c_char,
    pub _IO_write_end: *mut libc::c_char,
    pub _IO_buf_base: *mut libc::c_char,
    pub _IO_buf_end: *mut libc::c_char,
    pub _IO_save_base: *mut libc::c_char,
    pub _IO_backup_base: *mut libc::c_char,
    pub _IO_save_end: *mut libc::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: libc::c_int,
    pub _flags2: libc::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: libc::c_ushort,
    pub _vtable_offset: libc::c_schar,
    pub _shortbuf: [libc::c_char; 1],
    pub _lock: *mut libc::c_void,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut libc::c_void,
    pub __pad5: size_t,
    pub _mode: libc::c_int,
    pub _unused2: [libc::c_char; 20],
}
pub type _IO_lock_t = ();
pub type FILE = _IO_FILE;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct smk_t {
    pub mode: uint8_t,
    pub usf: libc::c_double,
    pub f: uint32_t,
    pub ring_frame: uint8_t,
    pub cur_frame: uint32_t,
    pub source: C2RustUnnamed,
    pub chunk_size: *mut uint32_t,
    pub keyframe: *mut uint8_t,
    pub frame_type: *mut uint8_t,
    pub video: smk_video_t,
    pub audio: [smk_audio_t; 7],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct smk_audio_t {
    pub exists: uint8_t,
    pub enable: uint8_t,
    pub channels: uint8_t,
    pub bitdepth: uint8_t,
    pub rate: uint32_t,
    pub max_buffer: int32_t,
    pub compress: uint8_t,
    pub buffer: *mut libc::c_void,
    pub buffer_size: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct smk_video_t {
    pub enable: uint8_t,
    pub w: uint32_t,
    pub h: uint32_t,
    pub y_scale_mode: uint8_t,
    pub v: uint8_t,
    pub tree_size: [uint32_t; 4],
    pub tree: [smk_huff16_t; 4],
    pub palette: [[uint8_t; 3]; 256],
    pub frame: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct smk_huff16_t {
    pub tree: *mut uint32_t,
    pub size: size_t,
    pub cache: [uint16_t; 3],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union C2RustUnnamed {
    pub file: C2RustUnnamed_0,
    pub chunk_data: *mut *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct C2RustUnnamed_0 {
    pub fp: *mut FILE,
    pub chunk_offset: *mut uint32_t,
}
pub type smk = *mut smk_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub union smk_read_t {
    pub file: *mut FILE,
    pub ram: *mut uint8_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct smk_bit_t {
    pub buffer: *const uint8_t,
    pub end: *const uint8_t,
    pub bit_num: uint32_t,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct smk_huff8_t {
    pub size: size_t,
    pub tree: [uint16_t; 511],
}
unsafe extern "C" fn smk_bs_init(bs: *mut smk_bit_t, b: *const uint8_t, size: size_t) {
    (*bs).buffer = b;
    (*bs).end = b.offset(size as isize);
    (*bs).bit_num = 0 as libc::c_int as uint32_t;
}
unsafe extern "C" fn smk_bs_read_1(bs: *mut smk_bit_t) -> libc::c_int {
    let mut ret: libc::c_int = 0;
    if (*bs).buffer >= (*bs).end {
        fputs(
            b"libsmacker::smk_bs_read_1(): ERROR: bitstream exhausted.\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int);
    }
    ret = *(*bs).buffer as libc::c_int >> (*bs).bit_num & 1 as libc::c_int;
    if (*bs).bit_num >= 7 as libc::c_int as uint32_t {
        (*bs).buffer = ((*bs).buffer).offset(1);
        (*bs).buffer;
        (*bs).bit_num = 0 as libc::c_int as uint32_t;
    } else {
        (*bs).bit_num = ((*bs).bit_num).wrapping_add(1);
        (*bs).bit_num;
    }
    return ret;
}
unsafe extern "C" fn smk_bs_read_8(bs: *mut smk_bit_t) -> libc::c_int {
    if ((*bs).buffer)
        .offset(((*bs).bit_num > 0 as libc::c_int as uint32_t) as libc::c_int as isize)
        >= (*bs).end
    {
        fputs(
            b"libsmacker::smk_bs_read_8(): ERROR: bitstream exhausted.\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int);
    }
    if (*bs).bit_num != 0 {
        let mut ret: libc::c_int = *(*bs).buffer as libc::c_int >> (*bs).bit_num;
        (*bs).buffer = ((*bs).buffer).offset(1);
        (*bs).buffer;
        return ret
            | (*(*bs).buffer as libc::c_int)
                << (8 as libc::c_int as uint32_t).wrapping_sub((*bs).bit_num)
                & 0xff as libc::c_int;
    }
    let fresh0 = (*bs).buffer;
    (*bs).buffer = ((*bs).buffer).offset(1);
    return *fresh0 as libc::c_int;
}
unsafe extern "C" fn _smk_huff8_build_rec(
    t: *mut smk_huff8_t,
    bs: *mut smk_bit_t,
) -> libc::c_int {
    let mut bit: libc::c_int = 0;
    let mut value: libc::c_int = 0;
    if (*t).size >= 511 as libc::c_int as size_t {
        fputs(
            b"libsmacker::_smk_huff8_build_rec() - ERROR: size exceeded\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int;
    }
    bit = smk_bs_read_1(bs);
    if bit < 0 as libc::c_int {
        fputs(
            b"libsmacker::_smk_huff8_build_rec() - ERROR: get_bit returned -1\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int;
    }
    if bit != 0 {
        let fresh1 = (*t).size;
        (*t).size = ((*t).size).wrapping_add(1);
        value = fresh1 as libc::c_int;
        if _smk_huff8_build_rec(t, bs) == 0 {
            fputs(
                b"libsmacker::_smk_huff8_build_rec() - ERROR: failed to build left sub-tree\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
        (*t)
            .tree[value
            as usize] = (0x8000 as libc::c_int as size_t | (*t).size) as uint16_t;
        if _smk_huff8_build_rec(t, bs) == 0 {
            fputs(
                b"libsmacker::_smk_huff8_build_rec() - ERROR: failed to build right sub-tree\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
    } else {
        value = smk_bs_read_8(bs);
        if value < 0 as libc::c_int {
            fputs(
                b"libsmacker::_smk_huff8_build_rec() - ERROR: get_byte returned -1\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
        let fresh2 = (*t).size;
        (*t).size = ((*t).size).wrapping_add(1);
        (*t).tree[fresh2 as usize] = value as uint16_t;
    }
    return 1 as libc::c_int;
}
unsafe extern "C" fn smk_huff8_build(
    t: *mut smk_huff8_t,
    bs: *mut smk_bit_t,
) -> libc::c_int {
    let mut bit: libc::c_int = 0;
    bit = smk_bs_read_1(bs);
    if bit < 0 as libc::c_int {
        fputs(
            b"libsmacker::smk_huff8_build() - ERROR: initial get_bit returned -1\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int;
    }
    (*t).size = 0 as libc::c_int as size_t;
    if bit != 0 {
        if _smk_huff8_build_rec(t, bs) == 0 {
            fputs(
                b"libsmacker::smk_huff8_build() - ERROR: tree build failed\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
    } else {
        (*t).tree[0 as libc::c_int as usize] = 0 as libc::c_int as uint16_t;
    }
    bit = smk_bs_read_1(bs);
    if bit < 0 as libc::c_int {
        fputs(
            b"libsmacker::smk_huff8_build() - ERROR: final get_bit returned -1\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int;
    }
    if bit != 0 {
        fputs(
            b"libsmacker::smk_huff8_build() - ERROR: final get_bit returned 1\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int;
    }
    return 1 as libc::c_int;
}
unsafe extern "C" fn smk_huff8_lookup(
    t: *const smk_huff8_t,
    bs: *mut smk_bit_t,
) -> libc::c_int {
    let mut bit: libc::c_int = 0;
    let mut index: libc::c_int = 0 as libc::c_int;
    while (*t).tree[index as usize] as libc::c_int & 0x8000 as libc::c_int != 0 {
        bit = smk_bs_read_1(bs);
        if bit < 0 as libc::c_int {
            fputs(
                b"libsmacker::smk_huff8_lookup() - ERROR: get_bit returned -1\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return -(1 as libc::c_int);
        }
        if bit != 0 {
            index = (*t).tree[index as usize] as libc::c_int & 0x7fff as libc::c_int;
        } else {
            index += 1;
            index;
        }
    }
    return (*t).tree[index as usize] as libc::c_int;
}
unsafe extern "C" fn _smk_huff16_build_rec(
    t: *mut smk_huff16_t,
    bs: *mut smk_bit_t,
    low8: *const smk_huff8_t,
    hi8: *const smk_huff8_t,
    limit: size_t,
) -> libc::c_int {
    let mut bit: libc::c_int = 0;
    let mut value: libc::c_int = 0;
    if (*t).size >= limit {
        fputs(
            b"libsmacker::_smk_huff16_build_rec() - ERROR: size exceeded\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int;
    }
    bit = smk_bs_read_1(bs);
    if bit < 0 as libc::c_int {
        fputs(
            b"libsmacker::_smk_huff16_build_rec() - ERROR: get_bit returned -1\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int;
    }
    if bit != 0 {
        let fresh3 = (*t).size;
        (*t).size = ((*t).size).wrapping_add(1);
        value = fresh3 as libc::c_int;
        if _smk_huff16_build_rec(t, bs, low8, hi8, limit) == 0 {
            fputs(
                b"libsmacker::_smk_huff16_build_rec() - ERROR: failed to build left sub-tree\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
        *((*t).tree)
            .offset(
                value as isize,
            ) = (0x80000000 as libc::c_uint as size_t | (*t).size) as uint32_t;
        if _smk_huff16_build_rec(t, bs, low8, hi8, limit) == 0 {
            fputs(
                b"libsmacker::_smk_huff16_build_rec() - ERROR: failed to build right sub-tree\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
    } else {
        value = smk_huff8_lookup(low8, bs);
        if value < 0 as libc::c_int {
            fputs(
                b"libsmacker::_smk_huff16_build_rec() - ERROR: get LOW value returned -1\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
        *((*t).tree).offset((*t).size as isize) = value as uint32_t;
        value = smk_huff8_lookup(hi8, bs);
        if value < 0 as libc::c_int {
            fputs(
                b"libsmacker::_smk_huff16_build_rec() - ERROR: get HIGH value returned -1\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
        *((*t).tree).offset((*t).size as isize)
            |= (value << 8 as libc::c_int) as uint32_t;
        if *((*t).tree).offset((*t).size as isize)
            == (*t).cache[0 as libc::c_int as usize] as uint32_t
        {
            *((*t).tree)
                .offset((*t).size as isize) = 0x40000000 as libc::c_int as uint32_t;
        } else if *((*t).tree).offset((*t).size as isize)
            == (*t).cache[1 as libc::c_int as usize] as uint32_t
        {
            *((*t).tree)
                .offset(
                    (*t).size as isize,
                ) = (0x40000000 as libc::c_int | 1 as libc::c_int) as uint32_t;
        } else if *((*t).tree).offset((*t).size as isize)
            == (*t).cache[2 as libc::c_int as usize] as uint32_t
        {
            *((*t).tree)
                .offset(
                    (*t).size as isize,
                ) = (0x40000000 as libc::c_int | 2 as libc::c_int) as uint32_t;
        }
        (*t).size = ((*t).size).wrapping_add(1);
        (*t).size;
    }
    return 1 as libc::c_int;
}
unsafe extern "C" fn smk_huff16_build(
    t: *mut smk_huff16_t,
    bs: *mut smk_bit_t,
    alloc_size: uint32_t,
) -> libc::c_int {
    let mut low8: smk_huff8_t = smk_huff8_t {
        size: 0,
        tree: [0; 511],
    };
    let mut hi8: smk_huff8_t = smk_huff8_t {
        size: 0,
        tree: [0; 511],
    };
    let mut limit: size_t = 0;
    let mut value: libc::c_int = 0;
    let mut i: libc::c_int = 0;
    let mut bit: libc::c_int = 0;
    bit = smk_bs_read_1(bs);
    if bit < 0 as libc::c_int {
        fputs(
            b"libsmacker::smk_huff16_build() - ERROR: initial get_bit returned -1\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int;
    }
    (*t).size = 0 as libc::c_int as size_t;
    if bit != 0 {
        if smk_huff8_build(&mut low8, bs) == 0 {
            fputs(
                b"libsmacker::smk_huff16_build() - ERROR: failed to build LOW tree\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
        if smk_huff8_build(&mut hi8, bs) == 0 {
            fputs(
                b"libsmacker::smk_huff16_build() - ERROR: failed to build HIGH tree\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return 0 as libc::c_int;
        }
        i = 0 as libc::c_int;
        while i < 3 as libc::c_int {
            value = smk_bs_read_8(bs);
            if value < 0 as libc::c_int {
                fprintf(
                    stderr,
                    b"libsmacker::smk_huff16_build() - ERROR: get LOW value for cache %d returned -1\n\0"
                        as *const u8 as *const libc::c_char,
                    i,
                );
                return 0 as libc::c_int;
            }
            (*t).cache[i as usize] = value as uint16_t;
            value = smk_bs_read_8(bs);
            if value < 0 as libc::c_int {
                fprintf(
                    stderr,
                    b"libsmacker::smk_huff16_build() - ERROR: get HIGH value for cache %d returned -1\n\0"
                        as *const u8 as *const libc::c_char,
                    i,
                );
                return 0 as libc::c_int;
            }
            (*t)
                .cache[i
                as usize] = ((*t).cache[i as usize] as libc::c_int
                | value << 8 as libc::c_int) as uint16_t;
            i += 1;
            i;
        }
        if alloc_size < 12 as libc::c_int as uint32_t
            || alloc_size % 4 as libc::c_int as uint32_t != 0
        {
            fprintf(
                stderr,
                b"libsmacker::smk_huff16_build() - ERROR: illegal value %u for alloc_size\n\0"
                    as *const u8 as *const libc::c_char,
                alloc_size,
            );
            return 0 as libc::c_int;
        }
        limit = (alloc_size.wrapping_sub(12 as libc::c_int as uint32_t)
            / 4 as libc::c_int as uint32_t) as size_t;
        (*t)
            .tree = malloc(
            limit.wrapping_mul(::core::mem::size_of::<uint32_t>() as libc::c_ulong),
        ) as *mut uint32_t;
        if ((*t).tree).is_null() {
            perror(
                b"libsmacker::smk_huff16_build() - ERROR: failed to malloc() huff16 tree\0"
                    as *const u8 as *const libc::c_char,
            );
            return 0 as libc::c_int;
        }
        if _smk_huff16_build_rec(t, bs, &mut low8, &mut hi8, limit) == 0 {
            fputs(
                b"libsmacker::smk_huff16_build() - ERROR: failed to build huff16 tree\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            free((*t).tree as *mut libc::c_void);
            (*t).tree = 0 as *mut uint32_t;
            return 0 as libc::c_int;
        }
        if limit != (*t).size {
            fputs(
                b"libsmacker::smk_huff16_build() - ERROR: failed to completely decode huff16 tree\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            free((*t).tree as *mut libc::c_void);
            (*t).tree = 0 as *mut uint32_t;
            return 0 as libc::c_int;
        }
    } else {
        (*t)
            .tree = malloc(::core::mem::size_of::<uint32_t>() as libc::c_ulong)
            as *mut uint32_t;
        if ((*t).tree).is_null() {
            perror(
                b"libsmacker::smk_huff16_build() - ERROR: failed to malloc() huff16 tree\0"
                    as *const u8 as *const libc::c_char,
            );
            return 0 as libc::c_int;
        }
        *((*t).tree).offset(0 as libc::c_int as isize) = 0 as libc::c_int as uint32_t;
    }
    bit = smk_bs_read_1(bs);
    if bit < 0 as libc::c_int {
        fputs(
            b"libsmacker::smk_huff16_build() - ERROR: final get_bit returned -1\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        free((*t).tree as *mut libc::c_void);
        (*t).tree = 0 as *mut uint32_t;
        return 0 as libc::c_int;
    }
    if bit != 0 {
        fputs(
            b"libsmacker::smk_huff16_build() - ERROR: final get_bit returned 1\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        free((*t).tree as *mut libc::c_void);
        (*t).tree = 0 as *mut uint32_t;
        return 0 as libc::c_int;
    }
    return 1 as libc::c_int;
}
unsafe extern "C" fn smk_huff16_lookup(
    t: *mut smk_huff16_t,
    bs: *mut smk_bit_t,
) -> libc::c_int {
    let mut bit: libc::c_int = 0;
    let mut value: libc::c_int = 0;
    let mut index: libc::c_int = 0 as libc::c_int;
    while *((*t).tree).offset(index as isize) & 0x80000000 as libc::c_uint != 0 {
        bit = smk_bs_read_1(bs);
        if bit < 0 as libc::c_int {
            fputs(
                b"libsmacker::smk_huff16_lookup() - ERROR: get_bit returned -1\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return -(1 as libc::c_int);
        }
        if bit != 0 {
            index = (*((*t).tree).offset(index as isize)
                & 0x3fffffff as libc::c_int as uint32_t) as libc::c_int;
        } else {
            index += 1;
            index;
        }
    }
    value = *((*t).tree).offset(index as isize) as libc::c_int;
    if value & 0x40000000 as libc::c_int != 0 {
        value = (*t).cache[(value & 0x3fffffff as libc::c_int) as usize] as libc::c_int;
    }
    if (*t).cache[0 as libc::c_int as usize] as libc::c_int != value {
        (*t).cache[2 as libc::c_int as usize] = (*t).cache[1 as libc::c_int as usize];
        (*t).cache[1 as libc::c_int as usize] = (*t).cache[0 as libc::c_int as usize];
        (*t).cache[0 as libc::c_int as usize] = value as uint16_t;
    }
    return value;
}
unsafe extern "C" fn smk_read_file(
    mut buf: *mut libc::c_void,
    size: size_t,
    mut fp: *mut FILE,
) -> int8_t {
    let mut bytesRead: size_t = fread(buf, 1 as libc::c_int as libc::c_ulong, size, fp);
    if bytesRead != size {
        fprintf(
            stderr,
            b"libsmacker::smk_read_file(buf,%u,fp) - ERROR: Short read, %u bytes returned\n\0"
                as *const u8 as *const libc::c_char,
            size as uint32_t,
            bytesRead as uint32_t,
        );
        perror(b"\tReason\0" as *const u8 as *const libc::c_char);
        return -(1 as libc::c_int) as int8_t;
    }
    return 0 as libc::c_int as int8_t;
}
unsafe extern "C" fn smk_read_memory(
    mut buf: *mut libc::c_void,
    size: uint32_t,
    mut p: *mut *mut uint8_t,
    mut p_size: *mut uint32_t,
) -> int8_t {
    if size > *p_size {
        fprintf(
            stderr,
            b"libsmacker::smk_read_memory(buf,%u,p,%u) - ERROR: Short read\n\0"
                as *const u8 as *const libc::c_char,
            size,
            *p_size,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    memcpy(buf, *p as *const libc::c_void, size as libc::c_ulong);
    *p = (*p).offset(size as isize);
    *p_size = (*p_size).wrapping_sub(size);
    return 0 as libc::c_int as int8_t;
}
unsafe extern "C" fn smk_open_generic(
    m: uint8_t,
    mut fp: smk_read_t,
    mut size: uint32_t,
    process_mode: uint8_t,
) -> smk {
    let mut current_block: u64;
    let mut s: smk = 0 as *mut smk_t;
    let mut temp_l: int32_t = 0;
    let mut temp_u: uint32_t = 0;
    let mut r: int8_t = 0;
    let mut buf: [uint8_t; 4] = ['\0' as i32 as uint8_t, 0, 0, 0];
    let mut hufftree_chunk: *mut uint8_t = 0 as *mut uint8_t;
    let mut tree_size: uint32_t = 0;
    let mut bs: smk_bit_t = smk_bit_t {
        buffer: 0 as *const uint8_t,
        end: 0 as *const uint8_t,
        bit_num: 0,
    };
    s = calloc(
        1 as libc::c_int as libc::c_ulong,
        ::core::mem::size_of::<smk_t>() as libc::c_ulong,
    ) as smk;
    if s.is_null() {
        perror(
            b"libsmacker::smk_open_generic() - ERROR: failed to malloc() smk structure\0"
                as *const u8 as *const libc::c_char,
        );
        return 0 as smk;
    }
    if m != 0 {
        r = smk_read_file(
            buf.as_mut_ptr() as *mut libc::c_void,
            3 as libc::c_int as size_t,
            fp.file,
        );
    } else {
        r = smk_read_memory(
            buf.as_mut_ptr() as *mut libc::c_void,
            3 as libc::c_int as uint32_t,
            &mut fp.ram,
            &mut size,
        );
    }
    if (r as libc::c_int) < 0 as libc::c_int {
        fprintf(
            stderr,
            b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                as *const u8 as *const libc::c_char,
            b"external/libsmacker/smacker.c\0" as *const u8 as *const libc::c_char,
            674 as libc::c_int as uint32_t,
        );
    } else if buf[0 as libc::c_int as usize] as libc::c_int != 'S' as i32
        || buf[1 as libc::c_int as usize] as libc::c_int != 'M' as i32
        || buf[2 as libc::c_int as usize] as libc::c_int != 'K' as i32
    {
        fprintf(
            stderr,
            b"libsmacker::smk_open_generic - ERROR: invalid SMKn signature (got: %s)\n\0"
                as *const u8 as *const libc::c_char,
            buf.as_mut_ptr(),
        );
    } else {
        if m != 0 {
            r = smk_read_file(
                &mut (*s).video.v as *mut uint8_t as *mut libc::c_void,
                1 as libc::c_int as size_t,
                fp.file,
            );
        } else {
            r = smk_read_memory(
                &mut (*s).video.v as *mut uint8_t as *mut libc::c_void,
                1 as libc::c_int as uint32_t,
                &mut fp.ram,
                &mut size,
            );
        }
        if (r as libc::c_int) < 0 as libc::c_int {
            fprintf(
                stderr,
                b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                    as *const u8 as *const libc::c_char,
                b"external/libsmacker/smacker.c\0" as *const u8 as *const libc::c_char,
                682 as libc::c_int as uint32_t,
            );
        } else {
            if (*s).video.v as libc::c_int != '2' as i32
                && (*s).video.v as libc::c_int != '4' as i32
            {
                fprintf(
                    stderr,
                    b"libsmacker::smk_open_generic - Warning: invalid SMK version %c (expected: 2 or 4)\n\0"
                        as *const u8 as *const libc::c_char,
                    (*s).video.v as libc::c_int,
                );
                if ((*s).video.v as libc::c_int) < '4' as i32 {
                    (*s).video.v = '2' as i32 as uint8_t;
                } else {
                    (*s).video.v = '4' as i32 as uint8_t;
                }
                fprintf(
                    stderr,
                    b"\tProcessing will continue as type %c\n\0" as *const u8
                        as *const libc::c_char,
                    (*s).video.v as libc::c_int,
                );
            }
            if m != 0 {
                r = smk_read_file(
                    buf.as_mut_ptr() as *mut libc::c_void,
                    4 as libc::c_int as size_t,
                    fp.file,
                );
            } else {
                r = smk_read_memory(
                    buf.as_mut_ptr() as *mut libc::c_void,
                    4 as libc::c_int as uint32_t,
                    &mut fp.ram,
                    &mut size,
                );
            }
            if (r as libc::c_int) < 0 as libc::c_int {
                fprintf(
                    stderr,
                    b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                        as *const u8 as *const libc::c_char,
                    b"external/libsmacker/smacker.c\0" as *const u8
                        as *const libc::c_char,
                    698 as libc::c_int as uint32_t,
                );
            } else {
                (*s)
                    .video
                    .w = (buf[3 as libc::c_int as usize] as uint32_t)
                    << 24 as libc::c_int
                    | (buf[2 as libc::c_int as usize] as uint32_t) << 16 as libc::c_int
                    | (buf[1 as libc::c_int as usize] as uint32_t) << 8 as libc::c_int
                    | buf[0 as libc::c_int as usize] as uint32_t;
                if m != 0 {
                    r = smk_read_file(
                        buf.as_mut_ptr() as *mut libc::c_void,
                        4 as libc::c_int as size_t,
                        fp.file,
                    );
                } else {
                    r = smk_read_memory(
                        buf.as_mut_ptr() as *mut libc::c_void,
                        4 as libc::c_int as uint32_t,
                        &mut fp.ram,
                        &mut size,
                    );
                }
                if (r as libc::c_int) < 0 as libc::c_int {
                    fprintf(
                        stderr,
                        b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                            as *const u8 as *const libc::c_char,
                        b"external/libsmacker/smacker.c\0" as *const u8
                            as *const libc::c_char,
                        699 as libc::c_int as uint32_t,
                    );
                } else {
                    (*s)
                        .video
                        .h = (buf[3 as libc::c_int as usize] as uint32_t)
                        << 24 as libc::c_int
                        | (buf[2 as libc::c_int as usize] as uint32_t)
                            << 16 as libc::c_int
                        | (buf[1 as libc::c_int as usize] as uint32_t)
                            << 8 as libc::c_int
                        | buf[0 as libc::c_int as usize] as uint32_t;
                    if m != 0 {
                        r = smk_read_file(
                            buf.as_mut_ptr() as *mut libc::c_void,
                            4 as libc::c_int as size_t,
                            fp.file,
                        );
                    } else {
                        r = smk_read_memory(
                            buf.as_mut_ptr() as *mut libc::c_void,
                            4 as libc::c_int as uint32_t,
                            &mut fp.ram,
                            &mut size,
                        );
                    }
                    if (r as libc::c_int) < 0 as libc::c_int {
                        fprintf(
                            stderr,
                            b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                as *const u8 as *const libc::c_char,
                            b"external/libsmacker/smacker.c\0" as *const u8
                                as *const libc::c_char,
                            700 as libc::c_int as uint32_t,
                        );
                    } else {
                        (*s)
                            .f = (buf[3 as libc::c_int as usize] as uint32_t)
                            << 24 as libc::c_int
                            | (buf[2 as libc::c_int as usize] as uint32_t)
                                << 16 as libc::c_int
                            | (buf[1 as libc::c_int as usize] as uint32_t)
                                << 8 as libc::c_int
                            | buf[0 as libc::c_int as usize] as uint32_t;
                        if m != 0 {
                            r = smk_read_file(
                                buf.as_mut_ptr() as *mut libc::c_void,
                                4 as libc::c_int as size_t,
                                fp.file,
                            );
                        } else {
                            r = smk_read_memory(
                                buf.as_mut_ptr() as *mut libc::c_void,
                                4 as libc::c_int as uint32_t,
                                &mut fp.ram,
                                &mut size,
                            );
                        }
                        if (r as libc::c_int) < 0 as libc::c_int {
                            fprintf(
                                stderr,
                                b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                    as *const u8 as *const libc::c_char,
                                b"external/libsmacker/smacker.c\0" as *const u8
                                    as *const libc::c_char,
                                702 as libc::c_int as uint32_t,
                            );
                        } else {
                            temp_u = (buf[3 as libc::c_int as usize] as uint32_t)
                                << 24 as libc::c_int
                                | (buf[2 as libc::c_int as usize] as uint32_t)
                                    << 16 as libc::c_int
                                | (buf[1 as libc::c_int as usize] as uint32_t)
                                    << 8 as libc::c_int
                                | buf[0 as libc::c_int as usize] as uint32_t;
                            temp_l = temp_u as libc::c_int;
                            if temp_l > 0 as libc::c_int {
                                (*s).usf = (temp_l * 1000 as libc::c_int) as libc::c_double;
                            } else if temp_l < 0 as libc::c_int {
                                (*s)
                                    .usf = (temp_l * -(10 as libc::c_int)) as libc::c_double;
                            } else {
                                (*s).usf = 100000 as libc::c_int as libc::c_double;
                            }
                            if m != 0 {
                                r = smk_read_file(
                                    buf.as_mut_ptr() as *mut libc::c_void,
                                    4 as libc::c_int as size_t,
                                    fp.file,
                                );
                            } else {
                                r = smk_read_memory(
                                    buf.as_mut_ptr() as *mut libc::c_void,
                                    4 as libc::c_int as uint32_t,
                                    &mut fp.ram,
                                    &mut size,
                                );
                            }
                            if (r as libc::c_int) < 0 as libc::c_int {
                                fprintf(
                                    stderr,
                                    b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                        as *const u8 as *const libc::c_char,
                                    b"external/libsmacker/smacker.c\0" as *const u8
                                        as *const libc::c_char,
                                    720 as libc::c_int as uint32_t,
                                );
                            } else {
                                temp_u = (buf[3 as libc::c_int as usize] as uint32_t)
                                    << 24 as libc::c_int
                                    | (buf[2 as libc::c_int as usize] as uint32_t)
                                        << 16 as libc::c_int
                                    | (buf[1 as libc::c_int as usize] as uint32_t)
                                        << 8 as libc::c_int
                                    | buf[0 as libc::c_int as usize] as uint32_t;
                                if temp_u & 0x1 as libc::c_int as uint32_t != 0 {
                                    (*s).ring_frame = 1 as libc::c_int as uint8_t;
                                }
                                if temp_u & 0x2 as libc::c_int as uint32_t != 0 {
                                    (*s).video.y_scale_mode = 0x2 as libc::c_int as uint8_t;
                                }
                                if temp_u & 0x4 as libc::c_int as uint32_t != 0 {
                                    if (*s).video.y_scale_mode as libc::c_int
                                        == 0x2 as libc::c_int
                                    {
                                        fputs(
                                            b"libsmacker::smk_open_generic - Warning: SMK file specifies both Y-Double AND Y-Interlace.\n\0"
                                                as *const u8 as *const libc::c_char,
                                            stderr,
                                        );
                                    }
                                    (*s).video.y_scale_mode = 0x1 as libc::c_int as uint8_t;
                                }
                                temp_l = 0 as libc::c_int;
                                loop {
                                    if !(temp_l < 7 as libc::c_int) {
                                        current_block = 722119776535234387;
                                        break;
                                    }
                                    if m != 0 {
                                        r = smk_read_file(
                                            buf.as_mut_ptr() as *mut libc::c_void,
                                            4 as libc::c_int as size_t,
                                            fp.file,
                                        );
                                    } else {
                                        r = smk_read_memory(
                                            buf.as_mut_ptr() as *mut libc::c_void,
                                            4 as libc::c_int as uint32_t,
                                            &mut fp.ram,
                                            &mut size,
                                        );
                                    }
                                    if (r as libc::c_int) < 0 as libc::c_int {
                                        fprintf(
                                            stderr,
                                            b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                as *const u8 as *const libc::c_char,
                                            b"external/libsmacker/smacker.c\0" as *const u8
                                                as *const libc::c_char,
                                            740 as libc::c_int as uint32_t,
                                        );
                                        current_block = 10039308771634094790;
                                        break;
                                    } else {
                                        (*s)
                                            .audio[temp_l as usize]
                                            .max_buffer = ((buf[3 as libc::c_int as usize] as uint32_t)
                                            << 24 as libc::c_int
                                            | (buf[2 as libc::c_int as usize] as uint32_t)
                                                << 16 as libc::c_int
                                            | (buf[1 as libc::c_int as usize] as uint32_t)
                                                << 8 as libc::c_int
                                            | buf[0 as libc::c_int as usize] as uint32_t) as int32_t;
                                        temp_l += 1;
                                        temp_l;
                                    }
                                }
                                match current_block {
                                    10039308771634094790 => {}
                                    _ => {
                                        if m != 0 {
                                            r = smk_read_file(
                                                buf.as_mut_ptr() as *mut libc::c_void,
                                                4 as libc::c_int as size_t,
                                                fp.file,
                                            );
                                        } else {
                                            r = smk_read_memory(
                                                buf.as_mut_ptr() as *mut libc::c_void,
                                                4 as libc::c_int as uint32_t,
                                                &mut fp.ram,
                                                &mut size,
                                            );
                                        }
                                        if (r as libc::c_int) < 0 as libc::c_int {
                                            fprintf(
                                                stderr,
                                                b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                    as *const u8 as *const libc::c_char,
                                                b"external/libsmacker/smacker.c\0" as *const u8
                                                    as *const libc::c_char,
                                                743 as libc::c_int as uint32_t,
                                            );
                                        } else {
                                            tree_size = (buf[3 as libc::c_int as usize] as uint32_t)
                                                << 24 as libc::c_int
                                                | (buf[2 as libc::c_int as usize] as uint32_t)
                                                    << 16 as libc::c_int
                                                | (buf[1 as libc::c_int as usize] as uint32_t)
                                                    << 8 as libc::c_int
                                                | buf[0 as libc::c_int as usize] as uint32_t;
                                            temp_l = 0 as libc::c_int;
                                            loop {
                                                if !(temp_l < 4 as libc::c_int) {
                                                    current_block = 16314074004867283505;
                                                    break;
                                                }
                                                if m != 0 {
                                                    r = smk_read_file(
                                                        buf.as_mut_ptr() as *mut libc::c_void,
                                                        4 as libc::c_int as size_t,
                                                        fp.file,
                                                    );
                                                } else {
                                                    r = smk_read_memory(
                                                        buf.as_mut_ptr() as *mut libc::c_void,
                                                        4 as libc::c_int as uint32_t,
                                                        &mut fp.ram,
                                                        &mut size,
                                                    );
                                                }
                                                if (r as libc::c_int) < 0 as libc::c_int {
                                                    fprintf(
                                                        stderr,
                                                        b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                            as *const u8 as *const libc::c_char,
                                                        b"external/libsmacker/smacker.c\0" as *const u8
                                                            as *const libc::c_char,
                                                        747 as libc::c_int as uint32_t,
                                                    );
                                                    current_block = 10039308771634094790;
                                                    break;
                                                } else {
                                                    (*s)
                                                        .video
                                                        .tree_size[temp_l
                                                        as usize] = (buf[3 as libc::c_int as usize] as uint32_t)
                                                        << 24 as libc::c_int
                                                        | (buf[2 as libc::c_int as usize] as uint32_t)
                                                            << 16 as libc::c_int
                                                        | (buf[1 as libc::c_int as usize] as uint32_t)
                                                            << 8 as libc::c_int
                                                        | buf[0 as libc::c_int as usize] as uint32_t;
                                                    temp_l += 1;
                                                    temp_l;
                                                }
                                            }
                                            match current_block {
                                                10039308771634094790 => {}
                                                _ => {
                                                    temp_l = 0 as libc::c_int;
                                                    loop {
                                                        if !(temp_l < 7 as libc::c_int) {
                                                            current_block = 7627602990488000394;
                                                            break;
                                                        }
                                                        if m != 0 {
                                                            r = smk_read_file(
                                                                buf.as_mut_ptr() as *mut libc::c_void,
                                                                4 as libc::c_int as size_t,
                                                                fp.file,
                                                            );
                                                        } else {
                                                            r = smk_read_memory(
                                                                buf.as_mut_ptr() as *mut libc::c_void,
                                                                4 as libc::c_int as uint32_t,
                                                                &mut fp.ram,
                                                                &mut size,
                                                            );
                                                        }
                                                        if (r as libc::c_int) < 0 as libc::c_int {
                                                            fprintf(
                                                                stderr,
                                                                b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                                    as *const u8 as *const libc::c_char,
                                                                b"external/libsmacker/smacker.c\0" as *const u8
                                                                    as *const libc::c_char,
                                                                751 as libc::c_int as uint32_t,
                                                            );
                                                            current_block = 10039308771634094790;
                                                            break;
                                                        } else {
                                                            temp_u = (buf[3 as libc::c_int as usize] as uint32_t)
                                                                << 24 as libc::c_int
                                                                | (buf[2 as libc::c_int as usize] as uint32_t)
                                                                    << 16 as libc::c_int
                                                                | (buf[1 as libc::c_int as usize] as uint32_t)
                                                                    << 8 as libc::c_int
                                                                | buf[0 as libc::c_int as usize] as uint32_t;
                                                            if temp_u & 0x40000000 as libc::c_int as uint32_t != 0 {
                                                                (*s)
                                                                    .audio[temp_l as usize]
                                                                    .exists = 1 as libc::c_int as uint8_t;
                                                                (*s)
                                                                    .audio[temp_l as usize]
                                                                    .buffer = calloc(
                                                                    1 as libc::c_int as libc::c_ulong,
                                                                    (*s).audio[temp_l as usize].max_buffer as libc::c_ulong,
                                                                );
                                                                if ((*s).audio[temp_l as usize].buffer).is_null() {
                                                                    fprintf(
                                                                        stderr,
                                                                        b"libsmacker::smk_malloc(s->audio[temp_l].buffer, %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                            as *const u8 as *const libc::c_char,
                                                                        (*s).audio[temp_l as usize].max_buffer as uint32_t,
                                                                        b"external/libsmacker/smacker.c\0" as *const u8
                                                                            as *const libc::c_char,
                                                                        757 as libc::c_int as uint32_t,
                                                                    );
                                                                    exit(1 as libc::c_int);
                                                                }
                                                                if temp_u & 0x80000000 as libc::c_uint != 0 {
                                                                    (*s)
                                                                        .audio[temp_l as usize]
                                                                        .compress = 1 as libc::c_int as uint8_t;
                                                                }
                                                                (*s)
                                                                    .audio[temp_l as usize]
                                                                    .bitdepth = (if temp_u
                                                                    & 0x20000000 as libc::c_int as uint32_t != 0
                                                                {
                                                                    16 as libc::c_int
                                                                } else {
                                                                    8 as libc::c_int
                                                                }) as uint8_t;
                                                                (*s)
                                                                    .audio[temp_l as usize]
                                                                    .channels = (if temp_u
                                                                    & 0x10000000 as libc::c_int as uint32_t != 0
                                                                {
                                                                    2 as libc::c_int
                                                                } else {
                                                                    1 as libc::c_int
                                                                }) as uint8_t;
                                                                if temp_u & 0xc000000 as libc::c_int as uint32_t != 0 {
                                                                    fprintf(
                                                                        stderr,
                                                                        b"libsmacker::smk_open_generic - Warning: audio track %d is compressed with Bink (perceptual) Audio Codec: this is currently unsupported by libsmacker\n\0"
                                                                            as *const u8 as *const libc::c_char,
                                                                        temp_l,
                                                                    );
                                                                    (*s)
                                                                        .audio[temp_l as usize]
                                                                        .compress = 2 as libc::c_int as uint8_t;
                                                                }
                                                                (*s)
                                                                    .audio[temp_l as usize]
                                                                    .rate = temp_u & 0xffffff as libc::c_int as uint32_t;
                                                            }
                                                            temp_l += 1;
                                                            temp_l;
                                                        }
                                                    }
                                                    match current_block {
                                                        10039308771634094790 => {}
                                                        _ => {
                                                            if m != 0 {
                                                                r = smk_read_file(
                                                                    buf.as_mut_ptr() as *mut libc::c_void,
                                                                    4 as libc::c_int as size_t,
                                                                    fp.file,
                                                                );
                                                            } else {
                                                                r = smk_read_memory(
                                                                    buf.as_mut_ptr() as *mut libc::c_void,
                                                                    4 as libc::c_int as uint32_t,
                                                                    &mut fp.ram,
                                                                    &mut size,
                                                                );
                                                            }
                                                            if (r as libc::c_int) < 0 as libc::c_int {
                                                                fprintf(
                                                                    stderr,
                                                                    b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                                        as *const u8 as *const libc::c_char,
                                                                    b"external/libsmacker/smacker.c\0" as *const u8
                                                                        as *const libc::c_char,
                                                                    777 as libc::c_int as uint32_t,
                                                                );
                                                            } else {
                                                                temp_u = (buf[3 as libc::c_int as usize] as uint32_t)
                                                                    << 24 as libc::c_int
                                                                    | (buf[2 as libc::c_int as usize] as uint32_t)
                                                                        << 16 as libc::c_int
                                                                    | (buf[1 as libc::c_int as usize] as uint32_t)
                                                                        << 8 as libc::c_int
                                                                    | buf[0 as libc::c_int as usize] as uint32_t;
                                                                (*s)
                                                                    .keyframe = calloc(
                                                                    1 as libc::c_int as libc::c_ulong,
                                                                    ((*s).f).wrapping_add((*s).ring_frame as uint32_t)
                                                                        as libc::c_ulong,
                                                                ) as *mut uint8_t;
                                                                if ((*s).keyframe).is_null() {
                                                                    fprintf(
                                                                        stderr,
                                                                        b"libsmacker::smk_malloc(s->keyframe, %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                            as *const u8 as *const libc::c_char,
                                                                        ((*s).f).wrapping_add((*s).ring_frame as uint32_t),
                                                                        b"external/libsmacker/smacker.c\0" as *const u8
                                                                            as *const libc::c_char,
                                                                        779 as libc::c_int as uint32_t,
                                                                    );
                                                                    exit(1 as libc::c_int);
                                                                }
                                                                (*s)
                                                                    .chunk_size = calloc(
                                                                    1 as libc::c_int as libc::c_ulong,
                                                                    (((*s).f).wrapping_add((*s).ring_frame as uint32_t)
                                                                        as libc::c_ulong)
                                                                        .wrapping_mul(
                                                                            ::core::mem::size_of::<uint32_t>() as libc::c_ulong,
                                                                        ),
                                                                ) as *mut uint32_t;
                                                                if ((*s).chunk_size).is_null() {
                                                                    fprintf(
                                                                        stderr,
                                                                        b"libsmacker::smk_malloc(s->chunk_size, %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                            as *const u8 as *const libc::c_char,
                                                                        (((*s).f).wrapping_add((*s).ring_frame as uint32_t)
                                                                            as libc::c_ulong)
                                                                            .wrapping_mul(
                                                                                ::core::mem::size_of::<uint32_t>() as libc::c_ulong,
                                                                            ) as uint32_t,
                                                                        b"external/libsmacker/smacker.c\0" as *const u8
                                                                            as *const libc::c_char,
                                                                        780 as libc::c_int as uint32_t,
                                                                    );
                                                                    exit(1 as libc::c_int);
                                                                }
                                                                temp_u = 0 as libc::c_int as uint32_t;
                                                                loop {
                                                                    if !(temp_u
                                                                        < ((*s).f).wrapping_add((*s).ring_frame as uint32_t))
                                                                    {
                                                                        current_block = 2346768750020253347;
                                                                        break;
                                                                    }
                                                                    if m != 0 {
                                                                        r = smk_read_file(
                                                                            buf.as_mut_ptr() as *mut libc::c_void,
                                                                            4 as libc::c_int as size_t,
                                                                            fp.file,
                                                                        );
                                                                    } else {
                                                                        r = smk_read_memory(
                                                                            buf.as_mut_ptr() as *mut libc::c_void,
                                                                            4 as libc::c_int as uint32_t,
                                                                            &mut fp.ram,
                                                                            &mut size,
                                                                        );
                                                                    }
                                                                    if (r as libc::c_int) < 0 as libc::c_int {
                                                                        fprintf(
                                                                            stderr,
                                                                            b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                                                as *const u8 as *const libc::c_char,
                                                                            b"external/libsmacker/smacker.c\0" as *const u8
                                                                                as *const libc::c_char,
                                                                            783 as libc::c_int as uint32_t,
                                                                        );
                                                                        current_block = 10039308771634094790;
                                                                        break;
                                                                    } else {
                                                                        *((*s).chunk_size)
                                                                            .offset(
                                                                                temp_u as isize,
                                                                            ) = (buf[3 as libc::c_int as usize] as uint32_t)
                                                                            << 24 as libc::c_int
                                                                            | (buf[2 as libc::c_int as usize] as uint32_t)
                                                                                << 16 as libc::c_int
                                                                            | (buf[1 as libc::c_int as usize] as uint32_t)
                                                                                << 8 as libc::c_int
                                                                            | buf[0 as libc::c_int as usize] as uint32_t;
                                                                        if *((*s).chunk_size).offset(temp_u as isize)
                                                                            & 0x1 as libc::c_int as uint32_t != 0
                                                                        {
                                                                            *((*s).keyframe)
                                                                                .offset(temp_u as isize) = 1 as libc::c_int as uint8_t;
                                                                        }
                                                                        let ref mut fresh4 = *((*s).chunk_size)
                                                                            .offset(temp_u as isize);
                                                                        *fresh4 &= 0xfffffffc as libc::c_uint;
                                                                        temp_u = temp_u.wrapping_add(1);
                                                                        temp_u;
                                                                    }
                                                                }
                                                                match current_block {
                                                                    10039308771634094790 => {}
                                                                    _ => {
                                                                        (*s)
                                                                            .frame_type = calloc(
                                                                            1 as libc::c_int as libc::c_ulong,
                                                                            ((*s).f).wrapping_add((*s).ring_frame as uint32_t)
                                                                                as libc::c_ulong,
                                                                        ) as *mut uint8_t;
                                                                        if ((*s).frame_type).is_null() {
                                                                            fprintf(
                                                                                stderr,
                                                                                b"libsmacker::smk_malloc(s->frame_type, %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                                    as *const u8 as *const libc::c_char,
                                                                                ((*s).f).wrapping_add((*s).ring_frame as uint32_t),
                                                                                b"external/libsmacker/smacker.c\0" as *const u8
                                                                                    as *const libc::c_char,
                                                                                795 as libc::c_int as uint32_t,
                                                                            );
                                                                            exit(1 as libc::c_int);
                                                                        }
                                                                        temp_u = 0 as libc::c_int as uint32_t;
                                                                        loop {
                                                                            if !(temp_u
                                                                                < ((*s).f).wrapping_add((*s).ring_frame as uint32_t))
                                                                            {
                                                                                current_block = 16813369756331276724;
                                                                                break;
                                                                            }
                                                                            if m != 0 {
                                                                                r = smk_read_file(
                                                                                    &mut *((*s).frame_type).offset(temp_u as isize)
                                                                                        as *mut uint8_t as *mut libc::c_void,
                                                                                    1 as libc::c_int as size_t,
                                                                                    fp.file,
                                                                                );
                                                                            } else {
                                                                                r = smk_read_memory(
                                                                                    &mut *((*s).frame_type).offset(temp_u as isize)
                                                                                        as *mut uint8_t as *mut libc::c_void,
                                                                                    1 as libc::c_int as uint32_t,
                                                                                    &mut fp.ram,
                                                                                    &mut size,
                                                                                );
                                                                            }
                                                                            if (r as libc::c_int) < 0 as libc::c_int {
                                                                                fprintf(
                                                                                    stderr,
                                                                                    b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                                                        as *const u8 as *const libc::c_char,
                                                                                    b"external/libsmacker/smacker.c\0" as *const u8
                                                                                        as *const libc::c_char,
                                                                                    798 as libc::c_int as uint32_t,
                                                                                );
                                                                                current_block = 10039308771634094790;
                                                                                break;
                                                                            } else {
                                                                                temp_u = temp_u.wrapping_add(1);
                                                                                temp_u;
                                                                            }
                                                                        }
                                                                        match current_block {
                                                                            10039308771634094790 => {}
                                                                            _ => {
                                                                                hufftree_chunk = calloc(
                                                                                    1 as libc::c_int as libc::c_ulong,
                                                                                    tree_size as libc::c_ulong,
                                                                                ) as *mut uint8_t;
                                                                                if hufftree_chunk.is_null() {
                                                                                    fprintf(
                                                                                        stderr,
                                                                                        b"libsmacker::smk_malloc(hufftree_chunk, %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                                            as *const u8 as *const libc::c_char,
                                                                                        tree_size,
                                                                                        b"external/libsmacker/smacker.c\0" as *const u8
                                                                                            as *const libc::c_char,
                                                                                        803 as libc::c_int as uint32_t,
                                                                                    );
                                                                                    exit(1 as libc::c_int);
                                                                                }
                                                                                if m != 0 {
                                                                                    r = smk_read_file(
                                                                                        hufftree_chunk as *mut libc::c_void,
                                                                                        tree_size as size_t,
                                                                                        fp.file,
                                                                                    );
                                                                                } else {
                                                                                    r = smk_read_memory(
                                                                                        hufftree_chunk as *mut libc::c_void,
                                                                                        tree_size,
                                                                                        &mut fp.ram,
                                                                                        &mut size,
                                                                                    );
                                                                                }
                                                                                if (r as libc::c_int) < 0 as libc::c_int {
                                                                                    fprintf(
                                                                                        stderr,
                                                                                        b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                                                            as *const u8 as *const libc::c_char,
                                                                                        b"external/libsmacker/smacker.c\0" as *const u8
                                                                                            as *const libc::c_char,
                                                                                        804 as libc::c_int as uint32_t,
                                                                                    );
                                                                                } else {
                                                                                    smk_bs_init(&mut bs, hufftree_chunk, tree_size as size_t);
                                                                                    temp_u = 0 as libc::c_int as uint32_t;
                                                                                    loop {
                                                                                        if !(temp_u < 4 as libc::c_int as uint32_t) {
                                                                                            current_block = 11272946706888692785;
                                                                                            break;
                                                                                        }
                                                                                        if smk_huff16_build(
                                                                                            &mut *((*s).video.tree)
                                                                                                .as_mut_ptr()
                                                                                                .offset(temp_u as isize),
                                                                                            &mut bs,
                                                                                            (*s).video.tree_size[temp_u as usize],
                                                                                        ) == 0
                                                                                        {
                                                                                            fprintf(
                                                                                                stderr,
                                                                                                b"libsmacker::smk_open_generic - ERROR: failed to create huff16 tree %u\n\0"
                                                                                                    as *const u8 as *const libc::c_char,
                                                                                                temp_u,
                                                                                            );
                                                                                            current_block = 10039308771634094790;
                                                                                            break;
                                                                                        } else {
                                                                                            temp_u = temp_u.wrapping_add(1);
                                                                                            temp_u;
                                                                                        }
                                                                                    }
                                                                                    match current_block {
                                                                                        10039308771634094790 => {}
                                                                                        _ => {
                                                                                            free(hufftree_chunk as *mut libc::c_void);
                                                                                            hufftree_chunk = 0 as *mut uint8_t;
                                                                                            (*s)
                                                                                                .video
                                                                                                .frame = calloc(
                                                                                                1 as libc::c_int as libc::c_ulong,
                                                                                                ((*s).video.w * (*s).video.h) as libc::c_ulong,
                                                                                            ) as *mut uint8_t;
                                                                                            if ((*s).video.frame).is_null() {
                                                                                                fprintf(
                                                                                                    stderr,
                                                                                                    b"libsmacker::smk_malloc(s->video.frame, %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                                                        as *const u8 as *const libc::c_char,
                                                                                                    (*s).video.w * (*s).video.h,
                                                                                                    b"external/libsmacker/smacker.c\0" as *const u8
                                                                                                        as *const libc::c_char,
                                                                                                    819 as libc::c_int as uint32_t,
                                                                                                );
                                                                                                exit(1 as libc::c_int);
                                                                                            }
                                                                                            (*s).mode = process_mode;
                                                                                            if (*s).mode as libc::c_int == 0x1 as libc::c_int {
                                                                                                (*s)
                                                                                                    .source
                                                                                                    .chunk_data = calloc(
                                                                                                    1 as libc::c_int as libc::c_ulong,
                                                                                                    (((*s).f).wrapping_add((*s).ring_frame as uint32_t)
                                                                                                        as libc::c_ulong)
                                                                                                        .wrapping_mul(
                                                                                                            ::core::mem::size_of::<*mut uint8_t>() as libc::c_ulong,
                                                                                                        ),
                                                                                                ) as *mut *mut uint8_t;
                                                                                                if ((*s).source.chunk_data).is_null() {
                                                                                                    fprintf(
                                                                                                        stderr,
                                                                                                        b"libsmacker::smk_malloc(s->source.chunk_data, %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                                                            as *const u8 as *const libc::c_char,
                                                                                                        (((*s).f).wrapping_add((*s).ring_frame as uint32_t)
                                                                                                            as libc::c_ulong)
                                                                                                            .wrapping_mul(
                                                                                                                ::core::mem::size_of::<*mut uint8_t>() as libc::c_ulong,
                                                                                                            ) as uint32_t,
                                                                                                        b"external/libsmacker/smacker.c\0" as *const u8
                                                                                                            as *const libc::c_char,
                                                                                                        826 as libc::c_int as uint32_t,
                                                                                                    );
                                                                                                    exit(1 as libc::c_int);
                                                                                                }
                                                                                                temp_u = 0 as libc::c_int as uint32_t;
                                                                                                loop {
                                                                                                    if !(temp_u
                                                                                                        < ((*s).f).wrapping_add((*s).ring_frame as uint32_t))
                                                                                                    {
                                                                                                        current_block = 4050268373526174;
                                                                                                        break;
                                                                                                    }
                                                                                                    let ref mut fresh5 = *((*s).source.chunk_data)
                                                                                                        .offset(temp_u as isize);
                                                                                                    *fresh5 = calloc(
                                                                                                        1 as libc::c_int as libc::c_ulong,
                                                                                                        *((*s).chunk_size).offset(temp_u as isize) as libc::c_ulong,
                                                                                                    ) as *mut uint8_t;
                                                                                                    if (*((*s).source.chunk_data).offset(temp_u as isize))
                                                                                                        .is_null()
                                                                                                    {
                                                                                                        fprintf(
                                                                                                            stderr,
                                                                                                            b"libsmacker::smk_malloc(s->source.chunk_data[temp_u], %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                                                                as *const u8 as *const libc::c_char,
                                                                                                            *((*s).chunk_size).offset(temp_u as isize),
                                                                                                            b"external/libsmacker/smacker.c\0" as *const u8
                                                                                                                as *const libc::c_char,
                                                                                                            829 as libc::c_int as uint32_t,
                                                                                                        );
                                                                                                        exit(1 as libc::c_int);
                                                                                                    }
                                                                                                    if m != 0 {
                                                                                                        r = smk_read_file(
                                                                                                            *((*s).source.chunk_data).offset(temp_u as isize)
                                                                                                                as *mut libc::c_void,
                                                                                                            *((*s).chunk_size).offset(temp_u as isize) as size_t,
                                                                                                            fp.file,
                                                                                                        );
                                                                                                    } else {
                                                                                                        r = smk_read_memory(
                                                                                                            *((*s).source.chunk_data).offset(temp_u as isize)
                                                                                                                as *mut libc::c_void,
                                                                                                            *((*s).chunk_size).offset(temp_u as isize),
                                                                                                            &mut fp.ram,
                                                                                                            &mut size,
                                                                                                        );
                                                                                                    }
                                                                                                    if (r as libc::c_int) < 0 as libc::c_int {
                                                                                                        fprintf(
                                                                                                            stderr,
                                                                                                            b"libsmacker::smk_read(...) - Errors encountered on read, bailing out (file: %s, line: %u)\n\0"
                                                                                                                as *const u8 as *const libc::c_char,
                                                                                                            b"external/libsmacker/smacker.c\0" as *const u8
                                                                                                                as *const libc::c_char,
                                                                                                            830 as libc::c_int as uint32_t,
                                                                                                        );
                                                                                                        current_block = 10039308771634094790;
                                                                                                        break;
                                                                                                    } else {
                                                                                                        temp_u = temp_u.wrapping_add(1);
                                                                                                        temp_u;
                                                                                                    }
                                                                                                }
                                                                                            } else {
                                                                                                (*s)
                                                                                                    .source
                                                                                                    .file
                                                                                                    .chunk_offset = calloc(
                                                                                                    1 as libc::c_int as libc::c_ulong,
                                                                                                    (((*s).f).wrapping_add((*s).ring_frame as uint32_t)
                                                                                                        as libc::c_ulong)
                                                                                                        .wrapping_mul(
                                                                                                            ::core::mem::size_of::<uint32_t>() as libc::c_ulong,
                                                                                                        ),
                                                                                                ) as *mut uint32_t;
                                                                                                if ((*s).source.file.chunk_offset).is_null() {
                                                                                                    fprintf(
                                                                                                        stderr,
                                                                                                        b"libsmacker::smk_malloc(s->source.file.chunk_offset, %u) - ERROR: calloc() returned NULL (file: %s, line: %u)\n\0"
                                                                                                            as *const u8 as *const libc::c_char,
                                                                                                        (((*s).f).wrapping_add((*s).ring_frame as uint32_t)
                                                                                                            as libc::c_ulong)
                                                                                                            .wrapping_mul(
                                                                                                                ::core::mem::size_of::<uint32_t>() as libc::c_ulong,
                                                                                                            ) as uint32_t,
                                                                                                        b"external/libsmacker/smacker.c\0" as *const u8
                                                                                                            as *const libc::c_char,
                                                                                                        835 as libc::c_int as uint32_t,
                                                                                                    );
                                                                                                    exit(1 as libc::c_int);
                                                                                                }
                                                                                                temp_u = 0 as libc::c_int as uint32_t;
                                                                                                loop {
                                                                                                    if !(temp_u
                                                                                                        < ((*s).f).wrapping_add((*s).ring_frame as uint32_t))
                                                                                                    {
                                                                                                        current_block = 4050268373526174;
                                                                                                        break;
                                                                                                    }
                                                                                                    *((*s).source.file.chunk_offset)
                                                                                                        .offset(temp_u as isize) = ftell(fp.file) as uint32_t;
                                                                                                    if fseek(
                                                                                                        fp.file,
                                                                                                        *((*s).chunk_size).offset(temp_u as isize) as libc::c_long,
                                                                                                        1 as libc::c_int,
                                                                                                    ) != 0
                                                                                                    {
                                                                                                        fprintf(
                                                                                                            stderr,
                                                                                                            b"libsmacker::smk_open - ERROR: fseek to frame %u not OK.\n\0"
                                                                                                                as *const u8 as *const libc::c_char,
                                                                                                            temp_u,
                                                                                                        );
                                                                                                        perror(
                                                                                                            b"\tError reported was\0" as *const u8
                                                                                                                as *const libc::c_char,
                                                                                                        );
                                                                                                        current_block = 10039308771634094790;
                                                                                                        break;
                                                                                                    } else {
                                                                                                        temp_u = temp_u.wrapping_add(1);
                                                                                                        temp_u;
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            match current_block {
                                                                                                10039308771634094790 => {}
                                                                                                _ => return s,
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    free(hufftree_chunk as *mut libc::c_void);
    hufftree_chunk = 0 as *mut uint8_t;
    smk_close(s);
    return 0 as smk;
}
#[no_mangle]
pub unsafe extern "C" fn smk_open_memory(
    mut buffer: *const uint8_t,
    size: uint32_t,
) -> smk {
    let mut s: smk = 0 as smk;
    let mut fp: smk_read_t = smk_read_t { file: 0 as *mut FILE };
    if buffer.is_null() {
        fputs(
            b"libsmacker::smk_open_memory() - ERROR: buffer pointer is NULL\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as smk;
    }
    fp.ram = buffer as *mut uint8_t;
    s = smk_open_generic(
        0 as libc::c_int as uint8_t,
        fp,
        size,
        0x1 as libc::c_int as uint8_t,
    );
    if s.is_null() {
        fprintf(
            stderr,
            b"libsmacker::smk_open_memory(buffer,%u) - ERROR: Fatal error in smk_open_generic, returning NULL.\n\0"
                as *const u8 as *const libc::c_char,
            size,
        );
    }
    return s;
}
#[no_mangle]
pub unsafe extern "C" fn smk_open_filepointer(
    mut file: *mut FILE,
    mode: uint8_t,
) -> smk {
    let mut s: smk = 0 as smk;
    let mut fp: smk_read_t = smk_read_t { file: 0 as *mut FILE };
    if file.is_null() {
        fputs(
            b"libsmacker::smk_open_filepointer() - ERROR: file pointer is NULL\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return 0 as smk;
    }
    fp.file = file;
    s = smk_open_generic(
        1 as libc::c_int as uint8_t,
        fp,
        0 as libc::c_int as uint32_t,
        mode,
    );
    if s.is_null() {
        fprintf(
            stderr,
            b"libsmacker::smk_open_filepointer(file,%u) - ERROR: Fatal error in smk_open_generic, returning NULL.\n\0"
                as *const u8 as *const libc::c_char,
            mode as libc::c_int,
        );
        fclose(fp.file);
    } else if mode as libc::c_int == 0x1 as libc::c_int {
        fclose(fp.file);
    } else {
        (*s).source.file.fp = fp.file;
    }
    return s;
}
#[no_mangle]
pub unsafe extern "C" fn smk_open_file(
    mut filename: *const libc::c_char,
    mode: uint8_t,
) -> smk {
    let mut fp: *mut FILE = 0 as *mut FILE;
    if filename.is_null() {
        fputs(
            b"libsmacker::smk_open_file() - ERROR: filename is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return 0 as smk;
    }
    fp = fopen(filename, b"rb\0" as *const u8 as *const libc::c_char);
    if fp.is_null() {
        fprintf(
            stderr,
            b"libsmacker::smk_open_file(%s,%u) - ERROR: could not open file\n\0"
                as *const u8 as *const libc::c_char,
            filename,
            mode as libc::c_int,
        );
        perror(b"\tError reported was\0" as *const u8 as *const libc::c_char);
        return 0 as smk;
    } else {
        return smk_open_filepointer(fp, mode)
    };
}
#[no_mangle]
pub unsafe extern "C" fn smk_close(mut s: smk) {
    let mut u: uint32_t = 0;
    if s.is_null() {
        fputs(
            b"libsmacker::smk_close() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return;
    }
    u = 0 as libc::c_int as uint32_t;
    while u < 4 as libc::c_int as uint32_t {
        if !((*s).video.tree[u as usize].tree).is_null() {
            free((*s).video.tree[u as usize].tree as *mut libc::c_void);
        }
        u = u.wrapping_add(1);
        u;
    }
    free((*s).video.frame as *mut libc::c_void);
    (*s).video.frame = 0 as *mut uint8_t;
    u = 0 as libc::c_int as uint32_t;
    while u < 7 as libc::c_int as uint32_t {
        if !((*s).audio[u as usize].buffer).is_null() {
            free((*s).audio[u as usize].buffer);
            (*s).audio[u as usize].buffer = 0 as *mut libc::c_void;
        }
        u = u.wrapping_add(1);
        u;
    }
    free((*s).keyframe as *mut libc::c_void);
    (*s).keyframe = 0 as *mut uint8_t;
    free((*s).frame_type as *mut libc::c_void);
    (*s).frame_type = 0 as *mut uint8_t;
    if (*s).mode as libc::c_int == 0 as libc::c_int {
        if !((*s).source.file.fp).is_null() {
            fclose((*s).source.file.fp);
        }
        free((*s).source.file.chunk_offset as *mut libc::c_void);
        (*s).source.file.chunk_offset = 0 as *mut uint32_t;
    } else if !((*s).source.chunk_data).is_null() {
        u = 0 as libc::c_int as uint32_t;
        while u < ((*s).f).wrapping_add((*s).ring_frame as uint32_t) {
            free(*((*s).source.chunk_data).offset(u as isize) as *mut libc::c_void);
            let ref mut fresh6 = *((*s).source.chunk_data).offset(u as isize);
            *fresh6 = 0 as *mut uint8_t;
            u = u.wrapping_add(1);
            u;
        }
        free((*s).source.chunk_data as *mut libc::c_void);
        (*s).source.chunk_data = 0 as *mut *mut uint8_t;
    }
    free((*s).chunk_size as *mut libc::c_void);
    (*s).chunk_size = 0 as *mut uint32_t;
    free(s as *mut libc::c_void);
    s = 0 as smk;
}
#[no_mangle]
pub unsafe extern "C" fn smk_info_all(
    object: smk,
    mut frame: *mut uint32_t,
    mut frame_count: *mut uint32_t,
    mut usf: *mut libc::c_double,
) -> int8_t {
    if object.is_null() {
        fputs(
            b"libsmacker::smk_info_all() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    if frame.is_null() && frame_count.is_null() && usf.is_null() {
        fputs(
            b"libsmacker::smk_info_all(object,frame,frame_count,usf) - ERROR: Request for info with all-NULL return references\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    } else {
        if !frame.is_null() {
            *frame = (*object).cur_frame % (*object).f;
        }
        if !frame_count.is_null() {
            *frame_count = (*object).f;
        }
        if !usf.is_null() {
            *usf = (*object).usf;
        }
        return 0 as libc::c_int as int8_t;
    };
}
#[no_mangle]
pub unsafe extern "C" fn smk_info_video(
    object: smk,
    mut w: *mut uint32_t,
    mut h: *mut uint32_t,
    mut y_scale_mode: *mut uint8_t,
) -> int8_t {
    if object.is_null() {
        fputs(
            b"libsmacker::smk_info_video() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    if w.is_null() && h.is_null() && y_scale_mode.is_null() {
        fputs(
            b"libsmacker::smk_info_all(object,w,h,y_scale_mode) - ERROR: Request for info with all-NULL return references\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    if !w.is_null() {
        *w = (*object).video.w;
    }
    if !h.is_null() {
        *h = (*object).video.h;
    }
    if !y_scale_mode.is_null() {
        *y_scale_mode = (*object).video.y_scale_mode;
    }
    return 0 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_info_audio(
    object: smk,
    mut track_mask: *mut uint8_t,
    mut channels: *mut uint8_t,
    mut bitdepth: *mut uint8_t,
    mut audio_rate: *mut uint32_t,
) -> int8_t {
    let mut i: uint8_t = 0;
    if object.is_null() {
        fputs(
            b"libsmacker::smk_info_audio() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    if track_mask.is_null() && channels.is_null() && bitdepth.is_null()
        && audio_rate.is_null()
    {
        fputs(
            b"libsmacker::smk_info_audio(object,track_mask,channels,bitdepth,audio_rate) - ERROR: Request for info with all-NULL return references\n\0"
                as *const u8 as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    if !track_mask.is_null() {
        *track_mask = ((*object).audio[0 as libc::c_int as usize].exists as libc::c_int
            | ((*object).audio[1 as libc::c_int as usize].exists as libc::c_int)
                << 1 as libc::c_int
            | ((*object).audio[2 as libc::c_int as usize].exists as libc::c_int)
                << 2 as libc::c_int
            | ((*object).audio[3 as libc::c_int as usize].exists as libc::c_int)
                << 3 as libc::c_int
            | ((*object).audio[4 as libc::c_int as usize].exists as libc::c_int)
                << 4 as libc::c_int
            | ((*object).audio[5 as libc::c_int as usize].exists as libc::c_int)
                << 5 as libc::c_int
            | ((*object).audio[6 as libc::c_int as usize].exists as libc::c_int)
                << 6 as libc::c_int) as uint8_t;
    }
    if !channels.is_null() {
        i = 0 as libc::c_int as uint8_t;
        while (i as libc::c_int) < 7 as libc::c_int {
            *channels.offset(i as isize) = (*object).audio[i as usize].channels;
            i = i.wrapping_add(1);
            i;
        }
    }
    if !bitdepth.is_null() {
        i = 0 as libc::c_int as uint8_t;
        while (i as libc::c_int) < 7 as libc::c_int {
            *bitdepth.offset(i as isize) = (*object).audio[i as usize].bitdepth;
            i = i.wrapping_add(1);
            i;
        }
    }
    if !audio_rate.is_null() {
        i = 0 as libc::c_int as uint8_t;
        while (i as libc::c_int) < 7 as libc::c_int {
            *audio_rate.offset(i as isize) = (*object).audio[i as usize].rate;
            i = i.wrapping_add(1);
            i;
        }
    }
    return 0 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_enable_all(mut object: smk, mask: uint8_t) -> int8_t {
    let mut i: uint8_t = 0;
    if object.is_null() {
        fputs(
            b"libsmacker::smk_enable_all() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    (*object).video.enable = (mask as libc::c_int & 0x80 as libc::c_int) as uint8_t;
    i = 0 as libc::c_int as uint8_t;
    while (i as libc::c_int) < 7 as libc::c_int {
        if (*object).audio[i as usize].exists != 0 {
            (*object)
                .audio[i as usize]
                .enable = (mask as libc::c_int & (1 as libc::c_int) << i as libc::c_int)
                as uint8_t;
        }
        i = i.wrapping_add(1);
        i;
    }
    return 0 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_enable_video(mut object: smk, enable: uint8_t) -> int8_t {
    if object.is_null() {
        fputs(
            b"libsmacker::smk_enable_video() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    (*object).video.enable = enable;
    return 0 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_enable_audio(
    mut object: smk,
    track: uint8_t,
    enable: uint8_t,
) -> int8_t {
    if object.is_null() {
        fputs(
            b"libsmacker::smk_enable_audio() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    (*object).audio[track as usize].enable = enable;
    return 0 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_get_palette(object: smk) -> *const uint8_t {
    if object.is_null() {
        fputs(
            b"libsmacker::smk_get_palette() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return 0 as *const uint8_t;
    }
    return ((*object).video.palette).as_mut_ptr() as *mut uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_get_video(object: smk) -> *const uint8_t {
    if object.is_null() {
        fputs(
            b"libsmacker::smk_get_video() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return 0 as *const uint8_t;
    }
    return (*object).video.frame;
}
#[no_mangle]
pub unsafe extern "C" fn smk_get_audio(object: smk, t: uint8_t) -> *const uint8_t {
    if object.is_null() {
        fputs(
            b"libsmacker::smk_get_audio() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return 0 as *const uint8_t;
    }
    return (*object).audio[t as usize].buffer as *const uint8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_get_audio_size(object: smk, t: uint8_t) -> uint32_t {
    if object.is_null() {
        fputs(
            b"libsmacker::smk_get_audio_size() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return 0 as libc::c_int as uint32_t;
    }
    return (*object).audio[t as usize].buffer_size;
}
unsafe extern "C" fn smk_render_palette(
    mut s: *mut smk_video_t,
    mut p: *mut uint8_t,
    mut size: uint32_t,
) -> int8_t {
    let mut current_block: u64;
    let mut i: uint16_t = 0 as libc::c_int as uint16_t;
    let mut count: uint16_t = 0;
    let mut src: uint16_t = 0;
    static mut oldPalette: [[uint8_t; 3]; 256] = [[0; 3]; 256];
    let palmap: [uint8_t; 64] = [
        0 as libc::c_int as uint8_t,
        0x4 as libc::c_int as uint8_t,
        0x8 as libc::c_int as uint8_t,
        0xc as libc::c_int as uint8_t,
        0x10 as libc::c_int as uint8_t,
        0x14 as libc::c_int as uint8_t,
        0x18 as libc::c_int as uint8_t,
        0x1c as libc::c_int as uint8_t,
        0x20 as libc::c_int as uint8_t,
        0x24 as libc::c_int as uint8_t,
        0x28 as libc::c_int as uint8_t,
        0x2c as libc::c_int as uint8_t,
        0x30 as libc::c_int as uint8_t,
        0x34 as libc::c_int as uint8_t,
        0x38 as libc::c_int as uint8_t,
        0x3c as libc::c_int as uint8_t,
        0x41 as libc::c_int as uint8_t,
        0x45 as libc::c_int as uint8_t,
        0x49 as libc::c_int as uint8_t,
        0x4d as libc::c_int as uint8_t,
        0x51 as libc::c_int as uint8_t,
        0x55 as libc::c_int as uint8_t,
        0x59 as libc::c_int as uint8_t,
        0x5d as libc::c_int as uint8_t,
        0x61 as libc::c_int as uint8_t,
        0x65 as libc::c_int as uint8_t,
        0x69 as libc::c_int as uint8_t,
        0x6d as libc::c_int as uint8_t,
        0x71 as libc::c_int as uint8_t,
        0x75 as libc::c_int as uint8_t,
        0x79 as libc::c_int as uint8_t,
        0x7d as libc::c_int as uint8_t,
        0x82 as libc::c_int as uint8_t,
        0x86 as libc::c_int as uint8_t,
        0x8a as libc::c_int as uint8_t,
        0x8e as libc::c_int as uint8_t,
        0x92 as libc::c_int as uint8_t,
        0x96 as libc::c_int as uint8_t,
        0x9a as libc::c_int as uint8_t,
        0x9e as libc::c_int as uint8_t,
        0xa2 as libc::c_int as uint8_t,
        0xa6 as libc::c_int as uint8_t,
        0xaa as libc::c_int as uint8_t,
        0xae as libc::c_int as uint8_t,
        0xb2 as libc::c_int as uint8_t,
        0xb6 as libc::c_int as uint8_t,
        0xba as libc::c_int as uint8_t,
        0xbe as libc::c_int as uint8_t,
        0xc3 as libc::c_int as uint8_t,
        0xc7 as libc::c_int as uint8_t,
        0xcb as libc::c_int as uint8_t,
        0xcf as libc::c_int as uint8_t,
        0xd3 as libc::c_int as uint8_t,
        0xd7 as libc::c_int as uint8_t,
        0xdb as libc::c_int as uint8_t,
        0xdf as libc::c_int as uint8_t,
        0xe3 as libc::c_int as uint8_t,
        0xe7 as libc::c_int as uint8_t,
        0xeb as libc::c_int as uint8_t,
        0xef as libc::c_int as uint8_t,
        0xf3 as libc::c_int as uint8_t,
        0xf7 as libc::c_int as uint8_t,
        0xfb as libc::c_int as uint8_t,
        0xff as libc::c_int as uint8_t,
    ];
    memcpy(
        oldPalette.as_mut_ptr() as *mut libc::c_void,
        ((*s).palette).as_mut_ptr() as *const libc::c_void,
        (256 as libc::c_int * 3 as libc::c_int) as libc::c_ulong,
    );
    's_12: loop {
        if !((i as libc::c_int) < 256 as libc::c_int
            && size > 0 as libc::c_int as uint32_t)
        {
            current_block = 4488286894823169796;
            break;
        }
        if *p as libc::c_int & 0x80 as libc::c_int != 0 {
            count = ((*p as libc::c_int & 0x7f as libc::c_int) + 1 as libc::c_int)
                as uint16_t;
            p = p.offset(1);
            p;
            size = size.wrapping_sub(1);
            size;
            if i as libc::c_int + count as libc::c_int > 256 as libc::c_int {
                fprintf(
                    stderr,
                    b"libsmacker::palette_render(s,p,size) - ERROR: overflow, 0x80 attempt to skip %d entries from %d\n\0"
                        as *const u8 as *const libc::c_char,
                    count as libc::c_int,
                    i as libc::c_int,
                );
                current_block = 11182247017126455150;
                break;
            } else {
                i = (i as libc::c_int + count as libc::c_int) as uint16_t;
            }
        } else if *p as libc::c_int & 0x40 as libc::c_int != 0 {
            if size < 2 as libc::c_int as uint32_t {
                fputs(
                    b"libsmacker::palette_render(s,p,size) - ERROR: 0x40 ran out of bytes for copy\n\0"
                        as *const u8 as *const libc::c_char,
                    stderr,
                );
                current_block = 11182247017126455150;
                break;
            } else {
                count = ((*p as libc::c_int & 0x3f as libc::c_int) + 1 as libc::c_int)
                    as uint16_t;
                p = p.offset(1);
                p;
                size = size.wrapping_sub(1);
                size;
                src = *p as uint16_t;
                p = p.offset(1);
                p;
                size = size.wrapping_sub(1);
                size;
                if i as libc::c_int + count as libc::c_int > 256 as libc::c_int
                    || src as libc::c_int + count as libc::c_int > 256 as libc::c_int
                {
                    fprintf(
                        stderr,
                        b"libsmacker::palette_render(s,p,size) - ERROR: overflow, 0x40 attempt to copy %d entries from %d to %d\n\0"
                            as *const u8 as *const libc::c_char,
                        count as libc::c_int,
                        src as libc::c_int,
                        i as libc::c_int,
                    );
                    current_block = 11182247017126455150;
                    break;
                } else {
                    memmove(
                        &mut *(*((*s).palette).as_mut_ptr().offset(i as isize))
                            .as_mut_ptr()
                            .offset(0 as libc::c_int as isize) as *mut uint8_t
                            as *mut libc::c_void,
                        &mut *(*oldPalette.as_mut_ptr().offset(src as isize))
                            .as_mut_ptr()
                            .offset(0 as libc::c_int as isize) as *mut uint8_t
                            as *const libc::c_void,
                        (count as libc::c_int * 3 as libc::c_int) as libc::c_ulong,
                    );
                    i = (i as libc::c_int + count as libc::c_int) as uint16_t;
                }
            }
        } else if size < 3 as libc::c_int as uint32_t {
            fprintf(
                stderr,
                b"libsmacker::palette_render - ERROR: 0x3F ran out of bytes for copy, size=%u\n\0"
                    as *const u8 as *const libc::c_char,
                size,
            );
            current_block = 11182247017126455150;
            break;
        } else {
            count = 0 as libc::c_int as uint16_t;
            while (count as libc::c_int) < 3 as libc::c_int {
                if *p as libc::c_int > 0x3f as libc::c_int {
                    fprintf(
                        stderr,
                        b"libsmacker::palette_render - ERROR: palette index exceeds 0x3F (entry [%u][%u])\n\0"
                            as *const u8 as *const libc::c_char,
                        i as libc::c_int,
                        count as libc::c_int,
                    );
                    current_block = 11182247017126455150;
                    break 's_12;
                } else {
                    (*s).palette[i as usize][count as usize] = palmap[*p as usize];
                    p = p.offset(1);
                    p;
                    size = size.wrapping_sub(1);
                    size;
                    count = count.wrapping_add(1);
                    count;
                }
            }
            i = i.wrapping_add(1);
            i;
        }
    }
    match current_block {
        4488286894823169796 => {
            if (i as libc::c_int) < 256 as libc::c_int {
                fprintf(
                    stderr,
                    b"libsmacker::palette_render - ERROR: did not completely fill palette (idx=%u)\n\0"
                        as *const u8 as *const libc::c_char,
                    i as libc::c_int,
                );
            } else {
                return 0 as libc::c_int as int8_t
            }
        }
        _ => {}
    }
    return -(1 as libc::c_int) as int8_t;
}
unsafe extern "C" fn smk_render_video(
    mut s: *mut smk_video_t,
    mut p: *mut uint8_t,
    mut size: uint32_t,
) -> int8_t {
    let mut t: *mut uint8_t = (*s).frame;
    let mut s1: uint8_t = 0;
    let mut s2: uint8_t = 0;
    let mut temp: uint16_t = 0;
    let mut i: uint32_t = 0;
    let mut j: uint32_t = 0;
    let mut k: uint32_t = 0;
    let mut row: uint32_t = 0;
    let mut col: uint32_t = 0;
    let mut skip: uint32_t = 0;
    let mut bs: smk_bit_t = smk_bit_t {
        buffer: 0 as *const uint8_t,
        end: 0 as *const uint8_t,
        bit_num: 0,
    };
    let mut unpack: libc::c_int = 0;
    let mut type_0: uint8_t = 0;
    let mut blocklen: uint8_t = 0;
    let mut typedata: uint8_t = 0;
    let mut bit: int8_t = 0;
    let sizetable: [uint16_t; 64] = [
        1 as libc::c_int as uint16_t,
        2 as libc::c_int as uint16_t,
        3 as libc::c_int as uint16_t,
        4 as libc::c_int as uint16_t,
        5 as libc::c_int as uint16_t,
        6 as libc::c_int as uint16_t,
        7 as libc::c_int as uint16_t,
        8 as libc::c_int as uint16_t,
        9 as libc::c_int as uint16_t,
        10 as libc::c_int as uint16_t,
        11 as libc::c_int as uint16_t,
        12 as libc::c_int as uint16_t,
        13 as libc::c_int as uint16_t,
        14 as libc::c_int as uint16_t,
        15 as libc::c_int as uint16_t,
        16 as libc::c_int as uint16_t,
        17 as libc::c_int as uint16_t,
        18 as libc::c_int as uint16_t,
        19 as libc::c_int as uint16_t,
        20 as libc::c_int as uint16_t,
        21 as libc::c_int as uint16_t,
        22 as libc::c_int as uint16_t,
        23 as libc::c_int as uint16_t,
        24 as libc::c_int as uint16_t,
        25 as libc::c_int as uint16_t,
        26 as libc::c_int as uint16_t,
        27 as libc::c_int as uint16_t,
        28 as libc::c_int as uint16_t,
        29 as libc::c_int as uint16_t,
        30 as libc::c_int as uint16_t,
        31 as libc::c_int as uint16_t,
        32 as libc::c_int as uint16_t,
        33 as libc::c_int as uint16_t,
        34 as libc::c_int as uint16_t,
        35 as libc::c_int as uint16_t,
        36 as libc::c_int as uint16_t,
        37 as libc::c_int as uint16_t,
        38 as libc::c_int as uint16_t,
        39 as libc::c_int as uint16_t,
        40 as libc::c_int as uint16_t,
        41 as libc::c_int as uint16_t,
        42 as libc::c_int as uint16_t,
        43 as libc::c_int as uint16_t,
        44 as libc::c_int as uint16_t,
        45 as libc::c_int as uint16_t,
        46 as libc::c_int as uint16_t,
        47 as libc::c_int as uint16_t,
        48 as libc::c_int as uint16_t,
        49 as libc::c_int as uint16_t,
        50 as libc::c_int as uint16_t,
        51 as libc::c_int as uint16_t,
        52 as libc::c_int as uint16_t,
        53 as libc::c_int as uint16_t,
        54 as libc::c_int as uint16_t,
        55 as libc::c_int as uint16_t,
        56 as libc::c_int as uint16_t,
        57 as libc::c_int as uint16_t,
        58 as libc::c_int as uint16_t,
        59 as libc::c_int as uint16_t,
        128 as libc::c_int as uint16_t,
        256 as libc::c_int as uint16_t,
        512 as libc::c_int as uint16_t,
        1024 as libc::c_int as uint16_t,
        2048 as libc::c_int as uint16_t,
    ];
    row = 0 as libc::c_int as uint32_t;
    col = 0 as libc::c_int as uint32_t;
    smk_bs_init(&mut bs, p, size as size_t);
    i = 0 as libc::c_int as uint32_t;
    while i < 4 as libc::c_int as uint32_t {
        memset(
            &mut (*((*s).tree).as_mut_ptr().offset(i as isize)).cache
                as *mut [uint16_t; 3] as *mut libc::c_void,
            0 as libc::c_int,
            (3 as libc::c_int as libc::c_ulong)
                .wrapping_mul(::core::mem::size_of::<uint16_t>() as libc::c_ulong),
        );
        i = i.wrapping_add(1);
        i;
    }
    while row < (*s).h {
        unpack = smk_huff16_lookup(
            &mut *((*s).tree).as_mut_ptr().offset(3 as libc::c_int as isize),
            &mut bs,
        );
        if unpack < 0 as libc::c_int {
            fputs(
                b"libsmacker::smk_render_video() - ERROR: failed to lookup from TYPE tree.\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            return -(1 as libc::c_int) as int8_t;
        }
        type_0 = (unpack & 0x3 as libc::c_int) as uint8_t;
        blocklen = ((unpack & 0xfc as libc::c_int) >> 2 as libc::c_int) as uint8_t;
        typedata = ((unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int) as uint8_t;
        if type_0 as libc::c_int == 1 as libc::c_int
            && (*s).v as libc::c_int == '4' as i32
        {
            bit = smk_bs_read_1(&mut bs) as int8_t;
            if bit != 0 {
                type_0 = 4 as libc::c_int as uint8_t;
            } else {
                bit = smk_bs_read_1(&mut bs) as int8_t;
                if bit != 0 {
                    type_0 = 5 as libc::c_int as uint8_t;
                }
            }
        }
        j = 0 as libc::c_int as uint32_t;
        while j < sizetable[blocklen as usize] as uint32_t && row < (*s).h {
            skip = (row * (*s).w).wrapping_add(col);
            match type_0 as libc::c_int {
                0 => {
                    unpack = smk_huff16_lookup(
                        &mut *((*s).tree).as_mut_ptr().offset(1 as libc::c_int as isize),
                        &mut bs,
                    );
                    if unpack < 0 as libc::c_int {
                        fputs(
                            b"libsmacker::smk_render_video() - ERROR: failed to lookup from MCLR tree.\n\0"
                                as *const u8 as *const libc::c_char,
                            stderr,
                        );
                        return -(1 as libc::c_int) as int8_t;
                    }
                    s1 = ((unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int)
                        as uint8_t;
                    s2 = (unpack & 0xff as libc::c_int) as uint8_t;
                    unpack = smk_huff16_lookup(
                        &mut *((*s).tree).as_mut_ptr().offset(0 as libc::c_int as isize),
                        &mut bs,
                    );
                    if unpack < 0 as libc::c_int {
                        fputs(
                            b"libsmacker::smk_render_video() - ERROR: failed to lookup from MMAP tree.\n\0"
                                as *const u8 as *const libc::c_char,
                            stderr,
                        );
                        return -(1 as libc::c_int) as int8_t;
                    }
                    temp = 0x1 as libc::c_int as uint16_t;
                    k = 0 as libc::c_int as uint32_t;
                    while k < 4 as libc::c_int as uint32_t {
                        i = 0 as libc::c_int as uint32_t;
                        while i < 4 as libc::c_int as uint32_t {
                            if unpack & temp as libc::c_int != 0 {
                                *t.offset(skip.wrapping_add(i) as isize) = s1;
                            } else {
                                *t.offset(skip.wrapping_add(i) as isize) = s2;
                            }
                            temp = ((temp as libc::c_int) << 1 as libc::c_int)
                                as uint16_t;
                            i = i.wrapping_add(1);
                            i;
                        }
                        skip = skip.wrapping_add((*s).w);
                        k = k.wrapping_add(1);
                        k;
                    }
                }
                1 => {
                    k = 0 as libc::c_int as uint32_t;
                    while k < 4 as libc::c_int as uint32_t {
                        unpack = smk_huff16_lookup(
                            &mut *((*s).tree)
                                .as_mut_ptr()
                                .offset(2 as libc::c_int as isize),
                            &mut bs,
                        );
                        if unpack < 0 as libc::c_int {
                            fputs(
                                b"libsmacker::smk_render_video() - ERROR: failed to lookup from FULL tree.\n\0"
                                    as *const u8 as *const libc::c_char,
                                stderr,
                            );
                            return -(1 as libc::c_int) as int8_t;
                        }
                        *t
                            .offset(
                                skip.wrapping_add(3 as libc::c_int as uint32_t) as isize,
                            ) = ((unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int)
                            as uint8_t;
                        *t
                            .offset(
                                skip.wrapping_add(2 as libc::c_int as uint32_t) as isize,
                            ) = (unpack & 0xff as libc::c_int) as uint8_t;
                        unpack = smk_huff16_lookup(
                            &mut *((*s).tree)
                                .as_mut_ptr()
                                .offset(2 as libc::c_int as isize),
                            &mut bs,
                        );
                        if unpack < 0 as libc::c_int {
                            fputs(
                                b"libsmacker::smk_render_video() - ERROR: failed to lookup from FULL tree.\n\0"
                                    as *const u8 as *const libc::c_char,
                                stderr,
                            );
                            return -(1 as libc::c_int) as int8_t;
                        }
                        *t
                            .offset(
                                skip.wrapping_add(1 as libc::c_int as uint32_t) as isize,
                            ) = ((unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int)
                            as uint8_t;
                        *t
                            .offset(
                                skip as isize,
                            ) = (unpack & 0xff as libc::c_int) as uint8_t;
                        skip = skip.wrapping_add((*s).w);
                        k = k.wrapping_add(1);
                        k;
                    }
                }
                3 => {
                    memset(
                        &mut *t.offset(skip as isize) as *mut uint8_t
                            as *mut libc::c_void,
                        typedata as libc::c_int,
                        4 as libc::c_int as libc::c_ulong,
                    );
                    skip = skip.wrapping_add((*s).w);
                    memset(
                        &mut *t.offset(skip as isize) as *mut uint8_t
                            as *mut libc::c_void,
                        typedata as libc::c_int,
                        4 as libc::c_int as libc::c_ulong,
                    );
                    skip = skip.wrapping_add((*s).w);
                    memset(
                        &mut *t.offset(skip as isize) as *mut uint8_t
                            as *mut libc::c_void,
                        typedata as libc::c_int,
                        4 as libc::c_int as libc::c_ulong,
                    );
                    skip = skip.wrapping_add((*s).w);
                    memset(
                        &mut *t.offset(skip as isize) as *mut uint8_t
                            as *mut libc::c_void,
                        typedata as libc::c_int,
                        4 as libc::c_int as libc::c_ulong,
                    );
                }
                4 => {
                    k = 0 as libc::c_int as uint32_t;
                    while k < 2 as libc::c_int as uint32_t {
                        unpack = smk_huff16_lookup(
                            &mut *((*s).tree)
                                .as_mut_ptr()
                                .offset(2 as libc::c_int as isize),
                            &mut bs,
                        );
                        if unpack < 0 as libc::c_int {
                            fputs(
                                b"libsmacker::smk_render_video() - ERROR: failed to lookup from FULL tree.\n\0"
                                    as *const u8 as *const libc::c_char,
                                stderr,
                            );
                            return -(1 as libc::c_int) as int8_t;
                        }
                        i = 0 as libc::c_int as uint32_t;
                        while i < 2 as libc::c_int as uint32_t {
                            memset(
                                &mut *t
                                    .offset(
                                        skip.wrapping_add(2 as libc::c_int as uint32_t) as isize,
                                    ) as *mut uint8_t as *mut libc::c_void,
                                (unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int,
                                2 as libc::c_int as libc::c_ulong,
                            );
                            memset(
                                &mut *t.offset(skip as isize) as *mut uint8_t
                                    as *mut libc::c_void,
                                unpack & 0xff as libc::c_int,
                                2 as libc::c_int as libc::c_ulong,
                            );
                            skip = skip.wrapping_add((*s).w);
                            i = i.wrapping_add(1);
                            i;
                        }
                        k = k.wrapping_add(1);
                        k;
                    }
                }
                5 => {
                    k = 0 as libc::c_int as uint32_t;
                    while k < 2 as libc::c_int as uint32_t {
                        unpack = smk_huff16_lookup(
                            &mut *((*s).tree)
                                .as_mut_ptr()
                                .offset(2 as libc::c_int as isize),
                            &mut bs,
                        );
                        if unpack < 0 as libc::c_int {
                            fputs(
                                b"libsmacker::smk_render_video() - ERROR: failed to lookup from FULL tree.\n\0"
                                    as *const u8 as *const libc::c_char,
                                stderr,
                            );
                            return -(1 as libc::c_int) as int8_t;
                        }
                        *t
                            .offset(
                                skip.wrapping_add(3 as libc::c_int as uint32_t) as isize,
                            ) = ((unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int)
                            as uint8_t;
                        *t
                            .offset(
                                skip.wrapping_add(2 as libc::c_int as uint32_t) as isize,
                            ) = (unpack & 0xff as libc::c_int) as uint8_t;
                        *t
                            .offset(
                                skip
                                    .wrapping_add((*s).w)
                                    .wrapping_add(3 as libc::c_int as uint32_t) as isize,
                            ) = ((unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int)
                            as uint8_t;
                        *t
                            .offset(
                                skip
                                    .wrapping_add((*s).w)
                                    .wrapping_add(2 as libc::c_int as uint32_t) as isize,
                            ) = (unpack & 0xff as libc::c_int) as uint8_t;
                        unpack = smk_huff16_lookup(
                            &mut *((*s).tree)
                                .as_mut_ptr()
                                .offset(2 as libc::c_int as isize),
                            &mut bs,
                        );
                        if unpack < 0 as libc::c_int {
                            fputs(
                                b"libsmacker::smk_render_video() - ERROR: failed to lookup from FULL tree.\n\0"
                                    as *const u8 as *const libc::c_char,
                                stderr,
                            );
                            return -(1 as libc::c_int) as int8_t;
                        }
                        *t
                            .offset(
                                skip.wrapping_add(1 as libc::c_int as uint32_t) as isize,
                            ) = ((unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int)
                            as uint8_t;
                        *t
                            .offset(
                                skip as isize,
                            ) = (unpack & 0xff as libc::c_int) as uint8_t;
                        *t
                            .offset(
                                skip
                                    .wrapping_add((*s).w)
                                    .wrapping_add(1 as libc::c_int as uint32_t) as isize,
                            ) = ((unpack & 0xff00 as libc::c_int) >> 8 as libc::c_int)
                            as uint8_t;
                        *t
                            .offset(
                                skip.wrapping_add((*s).w) as isize,
                            ) = (unpack & 0xff as libc::c_int) as uint8_t;
                        skip = skip.wrapping_add((*s).w << 1 as libc::c_int);
                        k = k.wrapping_add(1);
                        k;
                    }
                }
                2 | _ => {}
            }
            col = col.wrapping_add(4 as libc::c_int as uint32_t);
            if col >= (*s).w {
                col = 0 as libc::c_int as uint32_t;
                row = row.wrapping_add(4 as libc::c_int as uint32_t);
            }
            j = j.wrapping_add(1);
            j;
        }
    }
    return 0 as libc::c_int as int8_t;
}
unsafe extern "C" fn smk_render_audio(
    mut s: *mut smk_audio_t,
    mut p: *mut uint8_t,
    mut size: uint32_t,
) -> int8_t {
    let mut current_block: u64;
    let mut j: uint32_t = 0;
    let mut k: uint32_t = 0;
    let mut t: *mut uint8_t = (*s).buffer as *mut uint8_t;
    let mut bs: smk_bit_t = smk_bit_t {
        buffer: 0 as *const uint8_t,
        end: 0 as *const uint8_t,
        bit_num: 0,
    };
    let mut bit: int8_t = 0;
    let mut unpack: int16_t = 0;
    let mut unpack2: int16_t = 0;
    let mut aud_tree: [smk_huff8_t; 4] = [smk_huff8_t {
        size: 0,
        tree: [0; 511],
    }; 4];
    if (*s).compress == 0 {
        (*s).buffer_size = size;
        memcpy(t as *mut libc::c_void, p as *const libc::c_void, size as libc::c_ulong);
    } else if (*s).compress as libc::c_int == 1 as libc::c_int {
        if size < 4 as libc::c_int as uint32_t {
            fputs(
                b"libsmacker::smk_render_audio() - ERROR: need 4 bytes to get unpacked output buffer size.\n\0"
                    as *const u8 as *const libc::c_char,
                stderr,
            );
            current_block = 9642700908962554496;
        } else {
            (*s)
                .buffer_size = (*p.offset(3 as libc::c_int as isize) as uint32_t)
                << 24 as libc::c_int
                | (*p.offset(2 as libc::c_int as isize) as uint32_t) << 16 as libc::c_int
                | (*p.offset(1 as libc::c_int as isize) as uint32_t) << 8 as libc::c_int
                | *p.offset(0 as libc::c_int as isize) as uint32_t;
            p = p.offset(4 as libc::c_int as isize);
            size = size.wrapping_sub(4 as libc::c_int as uint32_t);
            smk_bs_init(&mut bs, p, size as size_t);
            bit = smk_bs_read_1(&mut bs) as int8_t;
            if bit == 0 {
                fputs(
                    b"libsmacker::smk_render_audio - ERROR: initial get_bit returned 0\n\0"
                        as *const u8 as *const libc::c_char,
                    stderr,
                );
                current_block = 9642700908962554496;
            } else {
                bit = smk_bs_read_1(&mut bs) as int8_t;
                if (*s).channels as libc::c_int
                    != (if bit as libc::c_int == 1 as libc::c_int {
                        2 as libc::c_int
                    } else {
                        1 as libc::c_int
                    })
                {
                    fputs(
                        b"libsmacker::smk_render - ERROR: mono/stereo mismatch\n\0"
                            as *const u8 as *const libc::c_char,
                        stderr,
                    );
                }
                bit = smk_bs_read_1(&mut bs) as int8_t;
                if (*s).bitdepth as libc::c_int
                    != (if bit as libc::c_int == 1 as libc::c_int {
                        16 as libc::c_int
                    } else {
                        8 as libc::c_int
                    })
                {
                    fputs(
                        b"libsmacker::smk_render - ERROR: 8-/16-bit mismatch\n\0"
                            as *const u8 as *const libc::c_char,
                        stderr,
                    );
                }
                smk_huff8_build(
                    &mut *aud_tree.as_mut_ptr().offset(0 as libc::c_int as isize),
                    &mut bs,
                );
                j = 1 as libc::c_int as uint32_t;
                k = 1 as libc::c_int as uint32_t;
                if (*s).bitdepth as libc::c_int == 16 as libc::c_int {
                    smk_huff8_build(
                        &mut *aud_tree.as_mut_ptr().offset(1 as libc::c_int as isize),
                        &mut bs,
                    );
                    k = 2 as libc::c_int as uint32_t;
                }
                if (*s).channels as libc::c_int == 2 as libc::c_int {
                    smk_huff8_build(
                        &mut *aud_tree.as_mut_ptr().offset(2 as libc::c_int as isize),
                        &mut bs,
                    );
                    j = 2 as libc::c_int as uint32_t;
                    k = 2 as libc::c_int as uint32_t;
                    if (*s).bitdepth as libc::c_int == 16 as libc::c_int {
                        smk_huff8_build(
                            &mut *aud_tree
                                .as_mut_ptr()
                                .offset(3 as libc::c_int as isize),
                            &mut bs,
                        );
                        k = 4 as libc::c_int as uint32_t;
                    }
                }
                if (*s).channels as libc::c_int == 2 as libc::c_int {
                    unpack = smk_bs_read_8(&mut bs) as int16_t;
                    if (*s).bitdepth as libc::c_int == 16 as libc::c_int {
                        *(t as *mut int16_t)
                            .offset(
                                1 as libc::c_int as isize,
                            ) = smk_bs_read_8(&mut bs) as int16_t;
                        let ref mut fresh7 = *(t as *mut int16_t)
                            .offset(1 as libc::c_int as isize);
                        *fresh7 = (*fresh7 as libc::c_int
                            | (unpack as libc::c_int) << 8 as libc::c_int) as int16_t;
                    } else {
                        *t.offset(1 as libc::c_int as isize) = unpack as uint8_t;
                    }
                }
                unpack = smk_bs_read_8(&mut bs) as int16_t;
                if (*s).bitdepth as libc::c_int == 16 as libc::c_int {
                    *(t as *mut int16_t)
                        .offset(
                            0 as libc::c_int as isize,
                        ) = smk_bs_read_8(&mut bs) as int16_t;
                    let ref mut fresh8 = *(t as *mut int16_t)
                        .offset(0 as libc::c_int as isize);
                    *fresh8 = (*fresh8 as libc::c_int
                        | (unpack as libc::c_int) << 8 as libc::c_int) as int16_t;
                } else {
                    *t.offset(0 as libc::c_int as isize) = unpack as uint8_t;
                }
                while k < (*s).buffer_size {
                    if (*s).bitdepth as libc::c_int == 8 as libc::c_int {
                        unpack = smk_huff8_lookup(
                            &mut *aud_tree
                                .as_mut_ptr()
                                .offset(0 as libc::c_int as isize),
                            &mut bs,
                        ) as int16_t;
                        *t
                            .offset(
                                j as isize,
                            ) = (unpack as int8_t as libc::c_int
                            + *t
                                .offset(j.wrapping_sub((*s).channels as uint32_t) as isize)
                                as libc::c_int) as uint8_t;
                        j = j.wrapping_add(1);
                        j;
                        k = k.wrapping_add(1);
                        k;
                    } else {
                        unpack = smk_huff8_lookup(
                            &mut *aud_tree
                                .as_mut_ptr()
                                .offset(0 as libc::c_int as isize),
                            &mut bs,
                        ) as int16_t;
                        unpack2 = smk_huff8_lookup(
                            &mut *aud_tree
                                .as_mut_ptr()
                                .offset(1 as libc::c_int as isize),
                            &mut bs,
                        ) as int16_t;
                        *(t as *mut int16_t)
                            .offset(
                                j as isize,
                            ) = ((unpack as libc::c_int
                            | (unpack2 as libc::c_int) << 8 as libc::c_int) as int16_t
                            as libc::c_int
                            + *(t as *mut int16_t)
                                .offset(j.wrapping_sub((*s).channels as uint32_t) as isize)
                                as libc::c_int) as int16_t;
                        j = j.wrapping_add(1);
                        j;
                        k = k.wrapping_add(2 as libc::c_int as uint32_t);
                    }
                    if (*s).channels as libc::c_int == 2 as libc::c_int {
                        if (*s).bitdepth as libc::c_int == 8 as libc::c_int {
                            unpack = smk_huff8_lookup(
                                &mut *aud_tree
                                    .as_mut_ptr()
                                    .offset(2 as libc::c_int as isize),
                                &mut bs,
                            ) as int16_t;
                            *t
                                .offset(
                                    j as isize,
                                ) = (unpack as int8_t as libc::c_int
                                + *t
                                    .offset(
                                        j.wrapping_sub(2 as libc::c_int as uint32_t) as isize,
                                    ) as libc::c_int) as uint8_t;
                            j = j.wrapping_add(1);
                            j;
                            k = k.wrapping_add(1);
                            k;
                        } else {
                            unpack = smk_huff8_lookup(
                                &mut *aud_tree
                                    .as_mut_ptr()
                                    .offset(2 as libc::c_int as isize),
                                &mut bs,
                            ) as int16_t;
                            unpack2 = smk_huff8_lookup(
                                &mut *aud_tree
                                    .as_mut_ptr()
                                    .offset(3 as libc::c_int as isize),
                                &mut bs,
                            ) as int16_t;
                            *(t as *mut int16_t)
                                .offset(
                                    j as isize,
                                ) = ((unpack as libc::c_int
                                | (unpack2 as libc::c_int) << 8 as libc::c_int) as int16_t
                                as libc::c_int
                                + *(t as *mut int16_t)
                                    .offset(
                                        j.wrapping_sub(2 as libc::c_int as uint32_t) as isize,
                                    ) as libc::c_int) as int16_t;
                            j = j.wrapping_add(1);
                            j;
                            k = k.wrapping_add(2 as libc::c_int as uint32_t);
                        }
                    }
                }
                current_block = 14001958660280927786;
            }
        }
        match current_block {
            14001958660280927786 => {}
            _ => return -(1 as libc::c_int) as int8_t,
        }
    }
    return 0 as libc::c_int as int8_t;
}
unsafe extern "C" fn smk_render(mut s: smk) -> int8_t {
    let mut current_block: u64;
    let mut i: uint32_t = 0;
    let mut size: uint32_t = 0;
    let mut buffer: *mut uint8_t = 0 as *mut uint8_t;
    let mut p: *mut uint8_t = 0 as *mut uint8_t;
    let mut track: uint8_t = 0;
    i = *((*s).chunk_size).offset((*s).cur_frame as isize);
    if i == 0 {
        fprintf(
            stderr,
            b"libsmacker::smk_render(s) - Warning: frame %u: chunk_size is 0.\n\0"
                as *const u8 as *const libc::c_char,
            (*s).cur_frame,
        );
    } else {
        if (*s).mode as libc::c_int == 0 as libc::c_int {
            if fseek(
                (*s).source.file.fp,
                *((*s).source.file.chunk_offset).offset((*s).cur_frame as isize)
                    as libc::c_long,
                0 as libc::c_int,
            ) != 0
            {
                fprintf(
                    stderr,
                    b"libsmacker::smk_render(s) - ERROR: fseek to frame %u (offset %u) failed.\n\0"
                        as *const u8 as *const libc::c_char,
                    (*s).cur_frame,
                    *((*s).source.file.chunk_offset).offset((*s).cur_frame as isize),
                );
                perror(b"\tError reported was\0" as *const u8 as *const libc::c_char);
                current_block = 11146833113371121630;
            } else {
                buffer = malloc(i as libc::c_ulong) as *mut uint8_t;
                if buffer.is_null() {
                    perror(
                        b"libsmacker::smk_render() - ERROR: failed to malloc() buffer\0"
                            as *const u8 as *const libc::c_char,
                    );
                    return -(1 as libc::c_int) as int8_t;
                }
                if (smk_read_file(
                    buffer as *mut libc::c_void,
                    *((*s).chunk_size).offset((*s).cur_frame as isize) as size_t,
                    (*s).source.file.fp,
                ) as libc::c_int) < 0 as libc::c_int
                {
                    fprintf(
                        stderr,
                        b"libsmacker::smk_render(s) - ERROR: frame %u (offset %u): smk_read had errors.\n\0"
                            as *const u8 as *const libc::c_char,
                        (*s).cur_frame,
                        *((*s).source.file.chunk_offset).offset((*s).cur_frame as isize),
                    );
                    current_block = 11146833113371121630;
                } else {
                    current_block = 10048703153582371463;
                }
            }
        } else if (*((*s).source.chunk_data).offset((*s).cur_frame as isize)).is_null() {
            fprintf(
                stderr,
                b"libsmacker::smk_render(s) - ERROR: frame %u: memory chunk is a NULL pointer.\n\0"
                    as *const u8 as *const libc::c_char,
                (*s).cur_frame,
            );
            current_block = 11146833113371121630;
        } else {
            buffer = *((*s).source.chunk_data).offset((*s).cur_frame as isize);
            current_block = 10048703153582371463;
        }
        match current_block {
            11146833113371121630 => {}
            _ => {
                p = buffer;
                if *((*s).frame_type).offset((*s).cur_frame as isize) as libc::c_int
                    & 0x1 as libc::c_int != 0
                {
                    if i == 0 {
                        fprintf(
                            stderr,
                            b"libsmacker::smk_render(s) - ERROR: frame %u: insufficient data for a palette rec.\n\0"
                                as *const u8 as *const libc::c_char,
                            (*s).cur_frame,
                        );
                        current_block = 11146833113371121630;
                    } else {
                        size = (4 as libc::c_int * *p as libc::c_int) as uint32_t;
                        if (*s).video.enable != 0 {
                            smk_render_palette(
                                &mut (*s).video,
                                p.offset(1 as libc::c_int as isize),
                                size.wrapping_sub(1 as libc::c_int as uint32_t),
                            );
                        }
                        p = p.offset(size as isize);
                        i = i.wrapping_sub(size);
                        current_block = 14401909646449704462;
                    }
                } else {
                    current_block = 14401909646449704462;
                }
                match current_block {
                    11146833113371121630 => {}
                    _ => {
                        track = 0 as libc::c_int as uint8_t;
                        loop {
                            if !((track as libc::c_int) < 7 as libc::c_int) {
                                current_block = 11385396242402735691;
                                break;
                            }
                            if *((*s).frame_type).offset((*s).cur_frame as isize)
                                as libc::c_int
                                & (0x2 as libc::c_int) << track as libc::c_int != 0
                            {
                                if i < 4 as libc::c_int as uint32_t {
                                    fprintf(
                                        stderr,
                                        b"libsmacker::smk_render(s) - ERROR: frame %u: insufficient data for audio[%u] rec.\n\0"
                                            as *const u8 as *const libc::c_char,
                                        (*s).cur_frame,
                                        track as libc::c_int,
                                    );
                                    current_block = 11146833113371121630;
                                    break;
                                } else {
                                    size = (*p.offset(3 as libc::c_int as isize) as uint32_t)
                                        << 24 as libc::c_int
                                        | (*p.offset(2 as libc::c_int as isize) as uint32_t)
                                            << 16 as libc::c_int
                                        | (*p.offset(1 as libc::c_int as isize) as uint32_t)
                                            << 8 as libc::c_int
                                        | *p.offset(0 as libc::c_int as isize) as uint32_t;
                                    if (*s).audio[track as usize].enable != 0 {
                                        smk_render_audio(
                                            &mut *((*s).audio).as_mut_ptr().offset(track as isize),
                                            p.offset(4 as libc::c_int as isize),
                                            size.wrapping_sub(4 as libc::c_int as uint32_t),
                                        );
                                    }
                                    p = p.offset(size as isize);
                                    i = i.wrapping_sub(size);
                                }
                            } else {
                                (*s)
                                    .audio[track as usize]
                                    .buffer_size = 0 as libc::c_int as uint32_t;
                            }
                            track = track.wrapping_add(1);
                            track;
                        }
                        match current_block {
                            11146833113371121630 => {}
                            _ => {
                                if (*s).video.enable != 0 {
                                    if (smk_render_video(&mut (*s).video, p, i) as libc::c_int)
                                        < 0 as libc::c_int
                                    {
                                        fprintf(
                                            stderr,
                                            b"libsmacker::smk_render(s) - ERROR: frame %u: failed to render video.\n\0"
                                                as *const u8 as *const libc::c_char,
                                            (*s).cur_frame,
                                        );
                                        current_block = 11146833113371121630;
                                    } else {
                                        current_block = 4090602189656566074;
                                    }
                                } else {
                                    current_block = 4090602189656566074;
                                }
                                match current_block {
                                    11146833113371121630 => {}
                                    _ => {
                                        if (*s).mode as libc::c_int == 0 as libc::c_int {
                                            free(buffer as *mut libc::c_void);
                                            buffer = 0 as *mut uint8_t;
                                        }
                                        return 0 as libc::c_int as int8_t;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (*s).mode as libc::c_int == 0 as libc::c_int {
        free(buffer as *mut libc::c_void);
        buffer = 0 as *mut uint8_t;
    }
    return -(1 as libc::c_int) as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_first(mut s: smk) -> int8_t {
    if s.is_null() {
        fputs(
            b"libsmacker::smk_first() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    (*s).cur_frame = 0 as libc::c_int as uint32_t;
    if (smk_render(s) as libc::c_int) < 0 as libc::c_int {
        fprintf(
            stderr,
            b"libsmacker::smk_first(s) - Warning: frame %u: smk_render returned errors.\n\0"
                as *const u8 as *const libc::c_char,
            (*s).cur_frame,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    if (*s).f == 1 as libc::c_int as uint32_t {
        return 0x2 as libc::c_int as int8_t;
    }
    return 0x1 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_next(mut s: smk) -> int8_t {
    if s.is_null() {
        fputs(
            b"libsmacker::smk_next() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    if ((*s).cur_frame).wrapping_add(1 as libc::c_int as uint32_t)
        < ((*s).f).wrapping_add((*s).ring_frame as uint32_t)
    {
        (*s).cur_frame = ((*s).cur_frame).wrapping_add(1);
        (*s).cur_frame;
        if (smk_render(s) as libc::c_int) < 0 as libc::c_int {
            fprintf(
                stderr,
                b"libsmacker::smk_next(s) - Warning: frame %u: smk_render returned errors.\n\0"
                    as *const u8 as *const libc::c_char,
                (*s).cur_frame,
            );
            return -(1 as libc::c_int) as int8_t;
        }
        if ((*s).cur_frame).wrapping_add(1 as libc::c_int as uint32_t)
            == ((*s).f).wrapping_add((*s).ring_frame as uint32_t)
        {
            return 0x2 as libc::c_int as int8_t;
        }
        return 0x1 as libc::c_int as int8_t;
    } else if (*s).ring_frame != 0 {
        (*s).cur_frame = 1 as libc::c_int as uint32_t;
        if (smk_render(s) as libc::c_int) < 0 as libc::c_int {
            fprintf(
                stderr,
                b"libsmacker::smk_next(s) - Warning: frame %u: smk_render returned errors.\n\0"
                    as *const u8 as *const libc::c_char,
                (*s).cur_frame,
            );
            return -(1 as libc::c_int) as int8_t;
        }
        if ((*s).cur_frame).wrapping_add(1 as libc::c_int as uint32_t)
            == ((*s).f).wrapping_add((*s).ring_frame as uint32_t)
        {
            return 0x2 as libc::c_int as int8_t;
        }
        return 0x1 as libc::c_int as int8_t;
    }
    return 0 as libc::c_int as int8_t;
}
#[no_mangle]
pub unsafe extern "C" fn smk_seek_keyframe(mut s: smk, mut f: uint32_t) -> int8_t {
    if s.is_null() {
        fputs(
            b"libsmacker::smk_seek_keyframe() - ERROR: smk is NULL\n\0" as *const u8
                as *const libc::c_char,
            stderr,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    (*s).cur_frame = f;
    while (*s).cur_frame > 0 as libc::c_int as uint32_t
        && *((*s).keyframe).offset((*s).cur_frame as isize) == 0
    {
        (*s).cur_frame = ((*s).cur_frame).wrapping_sub(1);
        (*s).cur_frame;
    }
    if (smk_render(s) as libc::c_int) < 0 as libc::c_int {
        fprintf(
            stderr,
            b"libsmacker::smk_seek_keyframe(s,%u) - Warning: frame %u: smk_render returned errors.\n\0"
                as *const u8 as *const libc::c_char,
            f,
            (*s).cur_frame,
        );
        return -(1 as libc::c_int) as int8_t;
    }
    return 0 as libc::c_int as int8_t;
}
