use ::libc;
extern "C" {
    static mut MouseX: libc::c_int;
    static mut MouseY: libc::c_int;
    fn DrawArtImage(
        SX: libc::c_int,
        SY: libc::c_int,
        nFrame: libc::c_int,
        pImage: *mut TARTIMAGE,
    );
    fn GetAnimationFrame(frames: libc::c_int, fps: libc::c_int) -> libc::c_int;
    static mut imgFocus: TARTIMAGE;
    fn PrintArtFont(str: *const libc::c_char, x: libc::c_int, y: libc::c_int);
    fn GetFontStrWidth(pszStr: *const libc::c_char) -> libc::c_int;
    fn SetArtFont(font: libc::c_int);
}
pub type __uint8_t = libc::c_uchar;
pub type __uint32_t = libc::c_uint;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _artimage {
    pub pData: *mut uint8_t,
    pub nWidth: libc::c_int,
    pub nHeight: libc::c_int,
    pub nFrames: libc::c_int,
    pub bTrans: bool32_t,
    pub bMask: uint8_t,
}
pub type TARTIMAGE = _artimage;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct UIRECT {
    pub x: libc::c_int,
    pub y: libc::c_int,
    pub w: libc::c_int,
    pub h: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _uibutton {
    pub szName: [libc::c_char; 256],
    pub coords: UIRECT,
    pub font: libc::c_int,
    pub val: libc::c_int,
    pub align: libc::c_int,
}
#[no_mangle]
pub unsafe extern "C" fn IsInRect(
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut coord: *mut UIRECT,
) -> bool32_t {
    if x >= (*coord).x && x <= (*coord).w + (*coord).x && y >= (*coord).y
        && y <= (*coord).h + (*coord).y
    {
        return 1 as libc::c_int as bool32_t;
    }
    return 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn CheckButton(
    mut pButton: *mut _uibutton,
    mut nCount: libc::c_int,
) -> libc::c_int {
    let mut i: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < nCount {
        if IsInRect(MouseX, MouseY, &mut (*pButton.offset(i as isize)).coords) != 0 {
            return (*pButton.offset(i as isize)).val;
        }
        i += 1;
        i;
    }
    return -(1 as libc::c_int);
}
#[no_mangle]
pub unsafe extern "C" fn PrintButton(
    mut pButton: *mut _uibutton,
    mut nCount: libc::c_int,
) {
    let mut i: libc::c_int = 0;
    let mut x: libc::c_int = 0;
    i = 0 as libc::c_int;
    while i < nCount {
        SetArtFont((*pButton.offset(i as isize)).font);
        if (*pButton.offset(i as isize)).align == 1 as libc::c_int {
            x = (*pButton.offset(i as isize)).coords.w / 2 as libc::c_int
                - GetFontStrWidth(((*pButton.offset(i as isize)).szName).as_mut_ptr())
                    / 2 as libc::c_int;
        } else if (*pButton.offset(i as isize)).align == 2 as libc::c_int {
            x = (*pButton.offset(i as isize)).coords.w
                - GetFontStrWidth(((*pButton.offset(i as isize)).szName).as_mut_ptr());
        } else {
            x = 1 as libc::c_int;
        }
        PrintArtFont(
            ((*pButton.offset(i as isize)).szName).as_mut_ptr(),
            (*pButton.offset(i as isize)).coords.x + x - 1 as libc::c_int,
            (*pButton.offset(i as isize)).coords.y,
        );
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawFocus(mut pButton: *mut _uibutton, mut item: libc::c_int) {
    let mut frame: libc::c_int = GetAnimationFrame(8 as libc::c_int, 60 as libc::c_int);
    let mut r: *mut UIRECT = &mut (*pButton.offset(item as isize)).coords;
    DrawArtImage((*r).x, (*r).y, frame, &mut imgFocus);
    DrawArtImage(
        (*r).w + (*r).x - imgFocus.nWidth - 1 as libc::c_int,
        (*r).y,
        frame,
        &mut imgFocus,
    );
}
