use ::libc;
extern "C" {
    pub type SDL_SysWMmsg;
    fn SDL_GetTicks() -> Uint32;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn my_SetWindowProc(wndProc: SDLPROC) -> SDLPROC;
    fn PaletteFadeIn(faderate: libc::c_int);
    fn PaletteFadeOut(faderate: libc::c_int);
    fn FullBlit(bArrow: bool32_t);
    fn ClrDraw();
    static mut force_redraw: libc::c_int;
    static mut gbRunGame: bool32_t;
    fn lock_buf(bFcn: uint8_t);
    fn unlock_buf(bFcn: uint8_t);
    static mut imgMenu: TARTIMAGE;
    fn PrintArtFontCred(
        str: *const libc::c_char,
        x: libc::c_int,
        y: libc::c_int,
        y1: libc::c_int,
        y2: libc::c_int,
    );
    fn SetArtFont(font: libc::c_int);
    fn DrawArtImage(
        SX: libc::c_int,
        SY: libc::c_int,
        nFrame: libc::c_int,
        pImage: *mut TARTIMAGE,
    );
    fn PumpUiMessage(drawfcn: Option::<unsafe extern "C" fn() -> ()>);
    fn InitDialogLoop();
    fn LoadArtWithPal(
        pszFile: *const libc::c_char,
        frames: libc::c_int,
        pImage: *mut TARTIMAGE,
    ) -> bool32_t;
    fn UiWndProc(event: *mut SDL_Event);
}
pub type __uint8_t = libc::c_uchar;
pub type __int16_t = libc::c_short;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type int16_t = __int16_t;
pub type int32_t = __int32_t;
pub type int64_t = __int64_t;
pub type uint8_t = __uint8_t;
pub type uint16_t = __uint16_t;
pub type uint32_t = __uint32_t;
pub type uint64_t = __uint64_t;
pub type Uint8 = uint8_t;
pub type Sint16 = int16_t;
pub type Uint16 = uint16_t;
pub type Sint32 = int32_t;
pub type Uint32 = uint32_t;
pub type Sint64 = int64_t;
pub type Uint64 = uint64_t;
pub type SDL_Scancode = libc::c_uint;
pub const SDL_NUM_SCANCODES: SDL_Scancode = 512;
pub const SDL_SCANCODE_ENDCALL: SDL_Scancode = 290;
pub const SDL_SCANCODE_CALL: SDL_Scancode = 289;
pub const SDL_SCANCODE_SOFTRIGHT: SDL_Scancode = 288;
pub const SDL_SCANCODE_SOFTLEFT: SDL_Scancode = 287;
pub const SDL_SCANCODE_AUDIOFASTFORWARD: SDL_Scancode = 286;
pub const SDL_SCANCODE_AUDIOREWIND: SDL_Scancode = 285;
pub const SDL_SCANCODE_APP2: SDL_Scancode = 284;
pub const SDL_SCANCODE_APP1: SDL_Scancode = 283;
pub const SDL_SCANCODE_SLEEP: SDL_Scancode = 282;
pub const SDL_SCANCODE_EJECT: SDL_Scancode = 281;
pub const SDL_SCANCODE_KBDILLUMUP: SDL_Scancode = 280;
pub const SDL_SCANCODE_KBDILLUMDOWN: SDL_Scancode = 279;
pub const SDL_SCANCODE_KBDILLUMTOGGLE: SDL_Scancode = 278;
pub const SDL_SCANCODE_DISPLAYSWITCH: SDL_Scancode = 277;
pub const SDL_SCANCODE_BRIGHTNESSUP: SDL_Scancode = 276;
pub const SDL_SCANCODE_BRIGHTNESSDOWN: SDL_Scancode = 275;
pub const SDL_SCANCODE_AC_BOOKMARKS: SDL_Scancode = 274;
pub const SDL_SCANCODE_AC_REFRESH: SDL_Scancode = 273;
pub const SDL_SCANCODE_AC_STOP: SDL_Scancode = 272;
pub const SDL_SCANCODE_AC_FORWARD: SDL_Scancode = 271;
pub const SDL_SCANCODE_AC_BACK: SDL_Scancode = 270;
pub const SDL_SCANCODE_AC_HOME: SDL_Scancode = 269;
pub const SDL_SCANCODE_AC_SEARCH: SDL_Scancode = 268;
pub const SDL_SCANCODE_COMPUTER: SDL_Scancode = 267;
pub const SDL_SCANCODE_CALCULATOR: SDL_Scancode = 266;
pub const SDL_SCANCODE_MAIL: SDL_Scancode = 265;
pub const SDL_SCANCODE_WWW: SDL_Scancode = 264;
pub const SDL_SCANCODE_MEDIASELECT: SDL_Scancode = 263;
pub const SDL_SCANCODE_AUDIOMUTE: SDL_Scancode = 262;
pub const SDL_SCANCODE_AUDIOPLAY: SDL_Scancode = 261;
pub const SDL_SCANCODE_AUDIOSTOP: SDL_Scancode = 260;
pub const SDL_SCANCODE_AUDIOPREV: SDL_Scancode = 259;
pub const SDL_SCANCODE_AUDIONEXT: SDL_Scancode = 258;
pub const SDL_SCANCODE_MODE: SDL_Scancode = 257;
pub const SDL_SCANCODE_RGUI: SDL_Scancode = 231;
pub const SDL_SCANCODE_RALT: SDL_Scancode = 230;
pub const SDL_SCANCODE_RSHIFT: SDL_Scancode = 229;
pub const SDL_SCANCODE_RCTRL: SDL_Scancode = 228;
pub const SDL_SCANCODE_LGUI: SDL_Scancode = 227;
pub const SDL_SCANCODE_LALT: SDL_Scancode = 226;
pub const SDL_SCANCODE_LSHIFT: SDL_Scancode = 225;
pub const SDL_SCANCODE_LCTRL: SDL_Scancode = 224;
pub const SDL_SCANCODE_KP_HEXADECIMAL: SDL_Scancode = 221;
pub const SDL_SCANCODE_KP_DECIMAL: SDL_Scancode = 220;
pub const SDL_SCANCODE_KP_OCTAL: SDL_Scancode = 219;
pub const SDL_SCANCODE_KP_BINARY: SDL_Scancode = 218;
pub const SDL_SCANCODE_KP_CLEARENTRY: SDL_Scancode = 217;
pub const SDL_SCANCODE_KP_CLEAR: SDL_Scancode = 216;
pub const SDL_SCANCODE_KP_PLUSMINUS: SDL_Scancode = 215;
pub const SDL_SCANCODE_KP_MEMDIVIDE: SDL_Scancode = 214;
pub const SDL_SCANCODE_KP_MEMMULTIPLY: SDL_Scancode = 213;
pub const SDL_SCANCODE_KP_MEMSUBTRACT: SDL_Scancode = 212;
pub const SDL_SCANCODE_KP_MEMADD: SDL_Scancode = 211;
pub const SDL_SCANCODE_KP_MEMCLEAR: SDL_Scancode = 210;
pub const SDL_SCANCODE_KP_MEMRECALL: SDL_Scancode = 209;
pub const SDL_SCANCODE_KP_MEMSTORE: SDL_Scancode = 208;
pub const SDL_SCANCODE_KP_EXCLAM: SDL_Scancode = 207;
pub const SDL_SCANCODE_KP_AT: SDL_Scancode = 206;
pub const SDL_SCANCODE_KP_SPACE: SDL_Scancode = 205;
pub const SDL_SCANCODE_KP_HASH: SDL_Scancode = 204;
pub const SDL_SCANCODE_KP_COLON: SDL_Scancode = 203;
pub const SDL_SCANCODE_KP_DBLVERTICALBAR: SDL_Scancode = 202;
pub const SDL_SCANCODE_KP_VERTICALBAR: SDL_Scancode = 201;
pub const SDL_SCANCODE_KP_DBLAMPERSAND: SDL_Scancode = 200;
pub const SDL_SCANCODE_KP_AMPERSAND: SDL_Scancode = 199;
pub const SDL_SCANCODE_KP_GREATER: SDL_Scancode = 198;
pub const SDL_SCANCODE_KP_LESS: SDL_Scancode = 197;
pub const SDL_SCANCODE_KP_PERCENT: SDL_Scancode = 196;
pub const SDL_SCANCODE_KP_POWER: SDL_Scancode = 195;
pub const SDL_SCANCODE_KP_XOR: SDL_Scancode = 194;
pub const SDL_SCANCODE_KP_F: SDL_Scancode = 193;
pub const SDL_SCANCODE_KP_E: SDL_Scancode = 192;
pub const SDL_SCANCODE_KP_D: SDL_Scancode = 191;
pub const SDL_SCANCODE_KP_C: SDL_Scancode = 190;
pub const SDL_SCANCODE_KP_B: SDL_Scancode = 189;
pub const SDL_SCANCODE_KP_A: SDL_Scancode = 188;
pub const SDL_SCANCODE_KP_BACKSPACE: SDL_Scancode = 187;
pub const SDL_SCANCODE_KP_TAB: SDL_Scancode = 186;
pub const SDL_SCANCODE_KP_RIGHTBRACE: SDL_Scancode = 185;
pub const SDL_SCANCODE_KP_LEFTBRACE: SDL_Scancode = 184;
pub const SDL_SCANCODE_KP_RIGHTPAREN: SDL_Scancode = 183;
pub const SDL_SCANCODE_KP_LEFTPAREN: SDL_Scancode = 182;
pub const SDL_SCANCODE_CURRENCYSUBUNIT: SDL_Scancode = 181;
pub const SDL_SCANCODE_CURRENCYUNIT: SDL_Scancode = 180;
pub const SDL_SCANCODE_DECIMALSEPARATOR: SDL_Scancode = 179;
pub const SDL_SCANCODE_THOUSANDSSEPARATOR: SDL_Scancode = 178;
pub const SDL_SCANCODE_KP_000: SDL_Scancode = 177;
pub const SDL_SCANCODE_KP_00: SDL_Scancode = 176;
pub const SDL_SCANCODE_EXSEL: SDL_Scancode = 164;
pub const SDL_SCANCODE_CRSEL: SDL_Scancode = 163;
pub const SDL_SCANCODE_CLEARAGAIN: SDL_Scancode = 162;
pub const SDL_SCANCODE_OPER: SDL_Scancode = 161;
pub const SDL_SCANCODE_OUT: SDL_Scancode = 160;
pub const SDL_SCANCODE_SEPARATOR: SDL_Scancode = 159;
pub const SDL_SCANCODE_RETURN2: SDL_Scancode = 158;
pub const SDL_SCANCODE_PRIOR: SDL_Scancode = 157;
pub const SDL_SCANCODE_CLEAR: SDL_Scancode = 156;
pub const SDL_SCANCODE_CANCEL: SDL_Scancode = 155;
pub const SDL_SCANCODE_SYSREQ: SDL_Scancode = 154;
pub const SDL_SCANCODE_ALTERASE: SDL_Scancode = 153;
pub const SDL_SCANCODE_LANG9: SDL_Scancode = 152;
pub const SDL_SCANCODE_LANG8: SDL_Scancode = 151;
pub const SDL_SCANCODE_LANG7: SDL_Scancode = 150;
pub const SDL_SCANCODE_LANG6: SDL_Scancode = 149;
pub const SDL_SCANCODE_LANG5: SDL_Scancode = 148;
pub const SDL_SCANCODE_LANG4: SDL_Scancode = 147;
pub const SDL_SCANCODE_LANG3: SDL_Scancode = 146;
pub const SDL_SCANCODE_LANG2: SDL_Scancode = 145;
pub const SDL_SCANCODE_LANG1: SDL_Scancode = 144;
pub const SDL_SCANCODE_INTERNATIONAL9: SDL_Scancode = 143;
pub const SDL_SCANCODE_INTERNATIONAL8: SDL_Scancode = 142;
pub const SDL_SCANCODE_INTERNATIONAL7: SDL_Scancode = 141;
pub const SDL_SCANCODE_INTERNATIONAL6: SDL_Scancode = 140;
pub const SDL_SCANCODE_INTERNATIONAL5: SDL_Scancode = 139;
pub const SDL_SCANCODE_INTERNATIONAL4: SDL_Scancode = 138;
pub const SDL_SCANCODE_INTERNATIONAL3: SDL_Scancode = 137;
pub const SDL_SCANCODE_INTERNATIONAL2: SDL_Scancode = 136;
pub const SDL_SCANCODE_INTERNATIONAL1: SDL_Scancode = 135;
pub const SDL_SCANCODE_KP_EQUALSAS400: SDL_Scancode = 134;
pub const SDL_SCANCODE_KP_COMMA: SDL_Scancode = 133;
pub const SDL_SCANCODE_VOLUMEDOWN: SDL_Scancode = 129;
pub const SDL_SCANCODE_VOLUMEUP: SDL_Scancode = 128;
pub const SDL_SCANCODE_MUTE: SDL_Scancode = 127;
pub const SDL_SCANCODE_FIND: SDL_Scancode = 126;
pub const SDL_SCANCODE_PASTE: SDL_Scancode = 125;
pub const SDL_SCANCODE_COPY: SDL_Scancode = 124;
pub const SDL_SCANCODE_CUT: SDL_Scancode = 123;
pub const SDL_SCANCODE_UNDO: SDL_Scancode = 122;
pub const SDL_SCANCODE_AGAIN: SDL_Scancode = 121;
pub const SDL_SCANCODE_STOP: SDL_Scancode = 120;
pub const SDL_SCANCODE_SELECT: SDL_Scancode = 119;
pub const SDL_SCANCODE_MENU: SDL_Scancode = 118;
pub const SDL_SCANCODE_HELP: SDL_Scancode = 117;
pub const SDL_SCANCODE_EXECUTE: SDL_Scancode = 116;
pub const SDL_SCANCODE_F24: SDL_Scancode = 115;
pub const SDL_SCANCODE_F23: SDL_Scancode = 114;
pub const SDL_SCANCODE_F22: SDL_Scancode = 113;
pub const SDL_SCANCODE_F21: SDL_Scancode = 112;
pub const SDL_SCANCODE_F20: SDL_Scancode = 111;
pub const SDL_SCANCODE_F19: SDL_Scancode = 110;
pub const SDL_SCANCODE_F18: SDL_Scancode = 109;
pub const SDL_SCANCODE_F17: SDL_Scancode = 108;
pub const SDL_SCANCODE_F16: SDL_Scancode = 107;
pub const SDL_SCANCODE_F15: SDL_Scancode = 106;
pub const SDL_SCANCODE_F14: SDL_Scancode = 105;
pub const SDL_SCANCODE_F13: SDL_Scancode = 104;
pub const SDL_SCANCODE_KP_EQUALS: SDL_Scancode = 103;
pub const SDL_SCANCODE_POWER: SDL_Scancode = 102;
pub const SDL_SCANCODE_APPLICATION: SDL_Scancode = 101;
pub const SDL_SCANCODE_NONUSBACKSLASH: SDL_Scancode = 100;
pub const SDL_SCANCODE_KP_PERIOD: SDL_Scancode = 99;
pub const SDL_SCANCODE_KP_0: SDL_Scancode = 98;
pub const SDL_SCANCODE_KP_9: SDL_Scancode = 97;
pub const SDL_SCANCODE_KP_8: SDL_Scancode = 96;
pub const SDL_SCANCODE_KP_7: SDL_Scancode = 95;
pub const SDL_SCANCODE_KP_6: SDL_Scancode = 94;
pub const SDL_SCANCODE_KP_5: SDL_Scancode = 93;
pub const SDL_SCANCODE_KP_4: SDL_Scancode = 92;
pub const SDL_SCANCODE_KP_3: SDL_Scancode = 91;
pub const SDL_SCANCODE_KP_2: SDL_Scancode = 90;
pub const SDL_SCANCODE_KP_1: SDL_Scancode = 89;
pub const SDL_SCANCODE_KP_ENTER: SDL_Scancode = 88;
pub const SDL_SCANCODE_KP_PLUS: SDL_Scancode = 87;
pub const SDL_SCANCODE_KP_MINUS: SDL_Scancode = 86;
pub const SDL_SCANCODE_KP_MULTIPLY: SDL_Scancode = 85;
pub const SDL_SCANCODE_KP_DIVIDE: SDL_Scancode = 84;
pub const SDL_SCANCODE_NUMLOCKCLEAR: SDL_Scancode = 83;
pub const SDL_SCANCODE_UP: SDL_Scancode = 82;
pub const SDL_SCANCODE_DOWN: SDL_Scancode = 81;
pub const SDL_SCANCODE_LEFT: SDL_Scancode = 80;
pub const SDL_SCANCODE_RIGHT: SDL_Scancode = 79;
pub const SDL_SCANCODE_PAGEDOWN: SDL_Scancode = 78;
pub const SDL_SCANCODE_END: SDL_Scancode = 77;
pub const SDL_SCANCODE_DELETE: SDL_Scancode = 76;
pub const SDL_SCANCODE_PAGEUP: SDL_Scancode = 75;
pub const SDL_SCANCODE_HOME: SDL_Scancode = 74;
pub const SDL_SCANCODE_INSERT: SDL_Scancode = 73;
pub const SDL_SCANCODE_PAUSE: SDL_Scancode = 72;
pub const SDL_SCANCODE_SCROLLLOCK: SDL_Scancode = 71;
pub const SDL_SCANCODE_PRINTSCREEN: SDL_Scancode = 70;
pub const SDL_SCANCODE_F12: SDL_Scancode = 69;
pub const SDL_SCANCODE_F11: SDL_Scancode = 68;
pub const SDL_SCANCODE_F10: SDL_Scancode = 67;
pub const SDL_SCANCODE_F9: SDL_Scancode = 66;
pub const SDL_SCANCODE_F8: SDL_Scancode = 65;
pub const SDL_SCANCODE_F7: SDL_Scancode = 64;
pub const SDL_SCANCODE_F6: SDL_Scancode = 63;
pub const SDL_SCANCODE_F5: SDL_Scancode = 62;
pub const SDL_SCANCODE_F4: SDL_Scancode = 61;
pub const SDL_SCANCODE_F3: SDL_Scancode = 60;
pub const SDL_SCANCODE_F2: SDL_Scancode = 59;
pub const SDL_SCANCODE_F1: SDL_Scancode = 58;
pub const SDL_SCANCODE_CAPSLOCK: SDL_Scancode = 57;
pub const SDL_SCANCODE_SLASH: SDL_Scancode = 56;
pub const SDL_SCANCODE_PERIOD: SDL_Scancode = 55;
pub const SDL_SCANCODE_COMMA: SDL_Scancode = 54;
pub const SDL_SCANCODE_GRAVE: SDL_Scancode = 53;
pub const SDL_SCANCODE_APOSTROPHE: SDL_Scancode = 52;
pub const SDL_SCANCODE_SEMICOLON: SDL_Scancode = 51;
pub const SDL_SCANCODE_NONUSHASH: SDL_Scancode = 50;
pub const SDL_SCANCODE_BACKSLASH: SDL_Scancode = 49;
pub const SDL_SCANCODE_RIGHTBRACKET: SDL_Scancode = 48;
pub const SDL_SCANCODE_LEFTBRACKET: SDL_Scancode = 47;
pub const SDL_SCANCODE_EQUALS: SDL_Scancode = 46;
pub const SDL_SCANCODE_MINUS: SDL_Scancode = 45;
pub const SDL_SCANCODE_SPACE: SDL_Scancode = 44;
pub const SDL_SCANCODE_TAB: SDL_Scancode = 43;
pub const SDL_SCANCODE_BACKSPACE: SDL_Scancode = 42;
pub const SDL_SCANCODE_ESCAPE: SDL_Scancode = 41;
pub const SDL_SCANCODE_RETURN: SDL_Scancode = 40;
pub const SDL_SCANCODE_0: SDL_Scancode = 39;
pub const SDL_SCANCODE_9: SDL_Scancode = 38;
pub const SDL_SCANCODE_8: SDL_Scancode = 37;
pub const SDL_SCANCODE_7: SDL_Scancode = 36;
pub const SDL_SCANCODE_6: SDL_Scancode = 35;
pub const SDL_SCANCODE_5: SDL_Scancode = 34;
pub const SDL_SCANCODE_4: SDL_Scancode = 33;
pub const SDL_SCANCODE_3: SDL_Scancode = 32;
pub const SDL_SCANCODE_2: SDL_Scancode = 31;
pub const SDL_SCANCODE_1: SDL_Scancode = 30;
pub const SDL_SCANCODE_Z: SDL_Scancode = 29;
pub const SDL_SCANCODE_Y: SDL_Scancode = 28;
pub const SDL_SCANCODE_X: SDL_Scancode = 27;
pub const SDL_SCANCODE_W: SDL_Scancode = 26;
pub const SDL_SCANCODE_V: SDL_Scancode = 25;
pub const SDL_SCANCODE_U: SDL_Scancode = 24;
pub const SDL_SCANCODE_T: SDL_Scancode = 23;
pub const SDL_SCANCODE_S: SDL_Scancode = 22;
pub const SDL_SCANCODE_R: SDL_Scancode = 21;
pub const SDL_SCANCODE_Q: SDL_Scancode = 20;
pub const SDL_SCANCODE_P: SDL_Scancode = 19;
pub const SDL_SCANCODE_O: SDL_Scancode = 18;
pub const SDL_SCANCODE_N: SDL_Scancode = 17;
pub const SDL_SCANCODE_M: SDL_Scancode = 16;
pub const SDL_SCANCODE_L: SDL_Scancode = 15;
pub const SDL_SCANCODE_K: SDL_Scancode = 14;
pub const SDL_SCANCODE_J: SDL_Scancode = 13;
pub const SDL_SCANCODE_I: SDL_Scancode = 12;
pub const SDL_SCANCODE_H: SDL_Scancode = 11;
pub const SDL_SCANCODE_G: SDL_Scancode = 10;
pub const SDL_SCANCODE_F: SDL_Scancode = 9;
pub const SDL_SCANCODE_E: SDL_Scancode = 8;
pub const SDL_SCANCODE_D: SDL_Scancode = 7;
pub const SDL_SCANCODE_C: SDL_Scancode = 6;
pub const SDL_SCANCODE_B: SDL_Scancode = 5;
pub const SDL_SCANCODE_A: SDL_Scancode = 4;
pub const SDL_SCANCODE_UNKNOWN: SDL_Scancode = 0;
pub type SDL_Keycode = Sint32;
pub type C2RustUnnamed = libc::c_uint;
pub const SDLK_ENDCALL: C2RustUnnamed = 1073742114;
pub const SDLK_CALL: C2RustUnnamed = 1073742113;
pub const SDLK_SOFTRIGHT: C2RustUnnamed = 1073742112;
pub const SDLK_SOFTLEFT: C2RustUnnamed = 1073742111;
pub const SDLK_AUDIOFASTFORWARD: C2RustUnnamed = 1073742110;
pub const SDLK_AUDIOREWIND: C2RustUnnamed = 1073742109;
pub const SDLK_APP2: C2RustUnnamed = 1073742108;
pub const SDLK_APP1: C2RustUnnamed = 1073742107;
pub const SDLK_SLEEP: C2RustUnnamed = 1073742106;
pub const SDLK_EJECT: C2RustUnnamed = 1073742105;
pub const SDLK_KBDILLUMUP: C2RustUnnamed = 1073742104;
pub const SDLK_KBDILLUMDOWN: C2RustUnnamed = 1073742103;
pub const SDLK_KBDILLUMTOGGLE: C2RustUnnamed = 1073742102;
pub const SDLK_DISPLAYSWITCH: C2RustUnnamed = 1073742101;
pub const SDLK_BRIGHTNESSUP: C2RustUnnamed = 1073742100;
pub const SDLK_BRIGHTNESSDOWN: C2RustUnnamed = 1073742099;
pub const SDLK_AC_BOOKMARKS: C2RustUnnamed = 1073742098;
pub const SDLK_AC_REFRESH: C2RustUnnamed = 1073742097;
pub const SDLK_AC_STOP: C2RustUnnamed = 1073742096;
pub const SDLK_AC_FORWARD: C2RustUnnamed = 1073742095;
pub const SDLK_AC_BACK: C2RustUnnamed = 1073742094;
pub const SDLK_AC_HOME: C2RustUnnamed = 1073742093;
pub const SDLK_AC_SEARCH: C2RustUnnamed = 1073742092;
pub const SDLK_COMPUTER: C2RustUnnamed = 1073742091;
pub const SDLK_CALCULATOR: C2RustUnnamed = 1073742090;
pub const SDLK_MAIL: C2RustUnnamed = 1073742089;
pub const SDLK_WWW: C2RustUnnamed = 1073742088;
pub const SDLK_MEDIASELECT: C2RustUnnamed = 1073742087;
pub const SDLK_AUDIOMUTE: C2RustUnnamed = 1073742086;
pub const SDLK_AUDIOPLAY: C2RustUnnamed = 1073742085;
pub const SDLK_AUDIOSTOP: C2RustUnnamed = 1073742084;
pub const SDLK_AUDIOPREV: C2RustUnnamed = 1073742083;
pub const SDLK_AUDIONEXT: C2RustUnnamed = 1073742082;
pub const SDLK_MODE: C2RustUnnamed = 1073742081;
pub const SDLK_RGUI: C2RustUnnamed = 1073742055;
pub const SDLK_RALT: C2RustUnnamed = 1073742054;
pub const SDLK_RSHIFT: C2RustUnnamed = 1073742053;
pub const SDLK_RCTRL: C2RustUnnamed = 1073742052;
pub const SDLK_LGUI: C2RustUnnamed = 1073742051;
pub const SDLK_LALT: C2RustUnnamed = 1073742050;
pub const SDLK_LSHIFT: C2RustUnnamed = 1073742049;
pub const SDLK_LCTRL: C2RustUnnamed = 1073742048;
pub const SDLK_KP_HEXADECIMAL: C2RustUnnamed = 1073742045;
pub const SDLK_KP_DECIMAL: C2RustUnnamed = 1073742044;
pub const SDLK_KP_OCTAL: C2RustUnnamed = 1073742043;
pub const SDLK_KP_BINARY: C2RustUnnamed = 1073742042;
pub const SDLK_KP_CLEARENTRY: C2RustUnnamed = 1073742041;
pub const SDLK_KP_CLEAR: C2RustUnnamed = 1073742040;
pub const SDLK_KP_PLUSMINUS: C2RustUnnamed = 1073742039;
pub const SDLK_KP_MEMDIVIDE: C2RustUnnamed = 1073742038;
pub const SDLK_KP_MEMMULTIPLY: C2RustUnnamed = 1073742037;
pub const SDLK_KP_MEMSUBTRACT: C2RustUnnamed = 1073742036;
pub const SDLK_KP_MEMADD: C2RustUnnamed = 1073742035;
pub const SDLK_KP_MEMCLEAR: C2RustUnnamed = 1073742034;
pub const SDLK_KP_MEMRECALL: C2RustUnnamed = 1073742033;
pub const SDLK_KP_MEMSTORE: C2RustUnnamed = 1073742032;
pub const SDLK_KP_EXCLAM: C2RustUnnamed = 1073742031;
pub const SDLK_KP_AT: C2RustUnnamed = 1073742030;
pub const SDLK_KP_SPACE: C2RustUnnamed = 1073742029;
pub const SDLK_KP_HASH: C2RustUnnamed = 1073742028;
pub const SDLK_KP_COLON: C2RustUnnamed = 1073742027;
pub const SDLK_KP_DBLVERTICALBAR: C2RustUnnamed = 1073742026;
pub const SDLK_KP_VERTICALBAR: C2RustUnnamed = 1073742025;
pub const SDLK_KP_DBLAMPERSAND: C2RustUnnamed = 1073742024;
pub const SDLK_KP_AMPERSAND: C2RustUnnamed = 1073742023;
pub const SDLK_KP_GREATER: C2RustUnnamed = 1073742022;
pub const SDLK_KP_LESS: C2RustUnnamed = 1073742021;
pub const SDLK_KP_PERCENT: C2RustUnnamed = 1073742020;
pub const SDLK_KP_POWER: C2RustUnnamed = 1073742019;
pub const SDLK_KP_XOR: C2RustUnnamed = 1073742018;
pub const SDLK_KP_F: C2RustUnnamed = 1073742017;
pub const SDLK_KP_E: C2RustUnnamed = 1073742016;
pub const SDLK_KP_D: C2RustUnnamed = 1073742015;
pub const SDLK_KP_C: C2RustUnnamed = 1073742014;
pub const SDLK_KP_B: C2RustUnnamed = 1073742013;
pub const SDLK_KP_A: C2RustUnnamed = 1073742012;
pub const SDLK_KP_BACKSPACE: C2RustUnnamed = 1073742011;
pub const SDLK_KP_TAB: C2RustUnnamed = 1073742010;
pub const SDLK_KP_RIGHTBRACE: C2RustUnnamed = 1073742009;
pub const SDLK_KP_LEFTBRACE: C2RustUnnamed = 1073742008;
pub const SDLK_KP_RIGHTPAREN: C2RustUnnamed = 1073742007;
pub const SDLK_KP_LEFTPAREN: C2RustUnnamed = 1073742006;
pub const SDLK_CURRENCYSUBUNIT: C2RustUnnamed = 1073742005;
pub const SDLK_CURRENCYUNIT: C2RustUnnamed = 1073742004;
pub const SDLK_DECIMALSEPARATOR: C2RustUnnamed = 1073742003;
pub const SDLK_THOUSANDSSEPARATOR: C2RustUnnamed = 1073742002;
pub const SDLK_KP_000: C2RustUnnamed = 1073742001;
pub const SDLK_KP_00: C2RustUnnamed = 1073742000;
pub const SDLK_EXSEL: C2RustUnnamed = 1073741988;
pub const SDLK_CRSEL: C2RustUnnamed = 1073741987;
pub const SDLK_CLEARAGAIN: C2RustUnnamed = 1073741986;
pub const SDLK_OPER: C2RustUnnamed = 1073741985;
pub const SDLK_OUT: C2RustUnnamed = 1073741984;
pub const SDLK_SEPARATOR: C2RustUnnamed = 1073741983;
pub const SDLK_RETURN2: C2RustUnnamed = 1073741982;
pub const SDLK_PRIOR: C2RustUnnamed = 1073741981;
pub const SDLK_CLEAR: C2RustUnnamed = 1073741980;
pub const SDLK_CANCEL: C2RustUnnamed = 1073741979;
pub const SDLK_SYSREQ: C2RustUnnamed = 1073741978;
pub const SDLK_ALTERASE: C2RustUnnamed = 1073741977;
pub const SDLK_KP_EQUALSAS400: C2RustUnnamed = 1073741958;
pub const SDLK_KP_COMMA: C2RustUnnamed = 1073741957;
pub const SDLK_VOLUMEDOWN: C2RustUnnamed = 1073741953;
pub const SDLK_VOLUMEUP: C2RustUnnamed = 1073741952;
pub const SDLK_MUTE: C2RustUnnamed = 1073741951;
pub const SDLK_FIND: C2RustUnnamed = 1073741950;
pub const SDLK_PASTE: C2RustUnnamed = 1073741949;
pub const SDLK_COPY: C2RustUnnamed = 1073741948;
pub const SDLK_CUT: C2RustUnnamed = 1073741947;
pub const SDLK_UNDO: C2RustUnnamed = 1073741946;
pub const SDLK_AGAIN: C2RustUnnamed = 1073741945;
pub const SDLK_STOP: C2RustUnnamed = 1073741944;
pub const SDLK_SELECT: C2RustUnnamed = 1073741943;
pub const SDLK_MENU: C2RustUnnamed = 1073741942;
pub const SDLK_HELP: C2RustUnnamed = 1073741941;
pub const SDLK_EXECUTE: C2RustUnnamed = 1073741940;
pub const SDLK_F24: C2RustUnnamed = 1073741939;
pub const SDLK_F23: C2RustUnnamed = 1073741938;
pub const SDLK_F22: C2RustUnnamed = 1073741937;
pub const SDLK_F21: C2RustUnnamed = 1073741936;
pub const SDLK_F20: C2RustUnnamed = 1073741935;
pub const SDLK_F19: C2RustUnnamed = 1073741934;
pub const SDLK_F18: C2RustUnnamed = 1073741933;
pub const SDLK_F17: C2RustUnnamed = 1073741932;
pub const SDLK_F16: C2RustUnnamed = 1073741931;
pub const SDLK_F15: C2RustUnnamed = 1073741930;
pub const SDLK_F14: C2RustUnnamed = 1073741929;
pub const SDLK_F13: C2RustUnnamed = 1073741928;
pub const SDLK_KP_EQUALS: C2RustUnnamed = 1073741927;
pub const SDLK_POWER: C2RustUnnamed = 1073741926;
pub const SDLK_APPLICATION: C2RustUnnamed = 1073741925;
pub const SDLK_KP_PERIOD: C2RustUnnamed = 1073741923;
pub const SDLK_KP_0: C2RustUnnamed = 1073741922;
pub const SDLK_KP_9: C2RustUnnamed = 1073741921;
pub const SDLK_KP_8: C2RustUnnamed = 1073741920;
pub const SDLK_KP_7: C2RustUnnamed = 1073741919;
pub const SDLK_KP_6: C2RustUnnamed = 1073741918;
pub const SDLK_KP_5: C2RustUnnamed = 1073741917;
pub const SDLK_KP_4: C2RustUnnamed = 1073741916;
pub const SDLK_KP_3: C2RustUnnamed = 1073741915;
pub const SDLK_KP_2: C2RustUnnamed = 1073741914;
pub const SDLK_KP_1: C2RustUnnamed = 1073741913;
pub const SDLK_KP_ENTER: C2RustUnnamed = 1073741912;
pub const SDLK_KP_PLUS: C2RustUnnamed = 1073741911;
pub const SDLK_KP_MINUS: C2RustUnnamed = 1073741910;
pub const SDLK_KP_MULTIPLY: C2RustUnnamed = 1073741909;
pub const SDLK_KP_DIVIDE: C2RustUnnamed = 1073741908;
pub const SDLK_NUMLOCKCLEAR: C2RustUnnamed = 1073741907;
pub const SDLK_UP: C2RustUnnamed = 1073741906;
pub const SDLK_DOWN: C2RustUnnamed = 1073741905;
pub const SDLK_LEFT: C2RustUnnamed = 1073741904;
pub const SDLK_RIGHT: C2RustUnnamed = 1073741903;
pub const SDLK_PAGEDOWN: C2RustUnnamed = 1073741902;
pub const SDLK_END: C2RustUnnamed = 1073741901;
pub const SDLK_DELETE: C2RustUnnamed = 127;
pub const SDLK_PAGEUP: C2RustUnnamed = 1073741899;
pub const SDLK_HOME: C2RustUnnamed = 1073741898;
pub const SDLK_INSERT: C2RustUnnamed = 1073741897;
pub const SDLK_PAUSE: C2RustUnnamed = 1073741896;
pub const SDLK_SCROLLLOCK: C2RustUnnamed = 1073741895;
pub const SDLK_PRINTSCREEN: C2RustUnnamed = 1073741894;
pub const SDLK_F12: C2RustUnnamed = 1073741893;
pub const SDLK_F11: C2RustUnnamed = 1073741892;
pub const SDLK_F10: C2RustUnnamed = 1073741891;
pub const SDLK_F9: C2RustUnnamed = 1073741890;
pub const SDLK_F8: C2RustUnnamed = 1073741889;
pub const SDLK_F7: C2RustUnnamed = 1073741888;
pub const SDLK_F6: C2RustUnnamed = 1073741887;
pub const SDLK_F5: C2RustUnnamed = 1073741886;
pub const SDLK_F4: C2RustUnnamed = 1073741885;
pub const SDLK_F3: C2RustUnnamed = 1073741884;
pub const SDLK_F2: C2RustUnnamed = 1073741883;
pub const SDLK_F1: C2RustUnnamed = 1073741882;
pub const SDLK_CAPSLOCK: C2RustUnnamed = 1073741881;
pub const SDLK_z: C2RustUnnamed = 122;
pub const SDLK_y: C2RustUnnamed = 121;
pub const SDLK_x: C2RustUnnamed = 120;
pub const SDLK_w: C2RustUnnamed = 119;
pub const SDLK_v: C2RustUnnamed = 118;
pub const SDLK_u: C2RustUnnamed = 117;
pub const SDLK_t: C2RustUnnamed = 116;
pub const SDLK_s: C2RustUnnamed = 115;
pub const SDLK_r: C2RustUnnamed = 114;
pub const SDLK_q: C2RustUnnamed = 113;
pub const SDLK_p: C2RustUnnamed = 112;
pub const SDLK_o: C2RustUnnamed = 111;
pub const SDLK_n: C2RustUnnamed = 110;
pub const SDLK_m: C2RustUnnamed = 109;
pub const SDLK_l: C2RustUnnamed = 108;
pub const SDLK_k: C2RustUnnamed = 107;
pub const SDLK_j: C2RustUnnamed = 106;
pub const SDLK_i: C2RustUnnamed = 105;
pub const SDLK_h: C2RustUnnamed = 104;
pub const SDLK_g: C2RustUnnamed = 103;
pub const SDLK_f: C2RustUnnamed = 102;
pub const SDLK_e: C2RustUnnamed = 101;
pub const SDLK_d: C2RustUnnamed = 100;
pub const SDLK_c: C2RustUnnamed = 99;
pub const SDLK_b: C2RustUnnamed = 98;
pub const SDLK_a: C2RustUnnamed = 97;
pub const SDLK_BACKQUOTE: C2RustUnnamed = 96;
pub const SDLK_UNDERSCORE: C2RustUnnamed = 95;
pub const SDLK_CARET: C2RustUnnamed = 94;
pub const SDLK_RIGHTBRACKET: C2RustUnnamed = 93;
pub const SDLK_BACKSLASH: C2RustUnnamed = 92;
pub const SDLK_LEFTBRACKET: C2RustUnnamed = 91;
pub const SDLK_AT: C2RustUnnamed = 64;
pub const SDLK_QUESTION: C2RustUnnamed = 63;
pub const SDLK_GREATER: C2RustUnnamed = 62;
pub const SDLK_EQUALS: C2RustUnnamed = 61;
pub const SDLK_LESS: C2RustUnnamed = 60;
pub const SDLK_SEMICOLON: C2RustUnnamed = 59;
pub const SDLK_COLON: C2RustUnnamed = 58;
pub const SDLK_9: C2RustUnnamed = 57;
pub const SDLK_8: C2RustUnnamed = 56;
pub const SDLK_7: C2RustUnnamed = 55;
pub const SDLK_6: C2RustUnnamed = 54;
pub const SDLK_5: C2RustUnnamed = 53;
pub const SDLK_4: C2RustUnnamed = 52;
pub const SDLK_3: C2RustUnnamed = 51;
pub const SDLK_2: C2RustUnnamed = 50;
pub const SDLK_1: C2RustUnnamed = 49;
pub const SDLK_0: C2RustUnnamed = 48;
pub const SDLK_SLASH: C2RustUnnamed = 47;
pub const SDLK_PERIOD: C2RustUnnamed = 46;
pub const SDLK_MINUS: C2RustUnnamed = 45;
pub const SDLK_COMMA: C2RustUnnamed = 44;
pub const SDLK_PLUS: C2RustUnnamed = 43;
pub const SDLK_ASTERISK: C2RustUnnamed = 42;
pub const SDLK_RIGHTPAREN: C2RustUnnamed = 41;
pub const SDLK_LEFTPAREN: C2RustUnnamed = 40;
pub const SDLK_QUOTE: C2RustUnnamed = 39;
pub const SDLK_AMPERSAND: C2RustUnnamed = 38;
pub const SDLK_DOLLAR: C2RustUnnamed = 36;
pub const SDLK_PERCENT: C2RustUnnamed = 37;
pub const SDLK_HASH: C2RustUnnamed = 35;
pub const SDLK_QUOTEDBL: C2RustUnnamed = 34;
pub const SDLK_EXCLAIM: C2RustUnnamed = 33;
pub const SDLK_SPACE: C2RustUnnamed = 32;
pub const SDLK_TAB: C2RustUnnamed = 9;
pub const SDLK_BACKSPACE: C2RustUnnamed = 8;
pub const SDLK_ESCAPE: C2RustUnnamed = 27;
pub const SDLK_RETURN: C2RustUnnamed = 13;
pub const SDLK_UNKNOWN: C2RustUnnamed = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_Keysym {
    pub scancode: SDL_Scancode,
    pub sym: SDL_Keycode,
    pub mod_0: Uint16,
    pub unused: Uint32,
}
pub type SDL_JoystickID = Sint32;
pub type SDL_JoystickPowerLevel = libc::c_int;
pub const SDL_JOYSTICK_POWER_MAX: SDL_JoystickPowerLevel = 5;
pub const SDL_JOYSTICK_POWER_WIRED: SDL_JoystickPowerLevel = 4;
pub const SDL_JOYSTICK_POWER_FULL: SDL_JoystickPowerLevel = 3;
pub const SDL_JOYSTICK_POWER_MEDIUM: SDL_JoystickPowerLevel = 2;
pub const SDL_JOYSTICK_POWER_LOW: SDL_JoystickPowerLevel = 1;
pub const SDL_JOYSTICK_POWER_EMPTY: SDL_JoystickPowerLevel = 0;
pub const SDL_JOYSTICK_POWER_UNKNOWN: SDL_JoystickPowerLevel = -1;
pub type SDL_TouchID = Sint64;
pub type SDL_FingerID = Sint64;
pub type SDL_GestureID = Sint64;
pub type C2RustUnnamed_0 = libc::c_uint;
pub const SDL_LASTEVENT: C2RustUnnamed_0 = 65535;
pub const SDL_USEREVENT: C2RustUnnamed_0 = 32768;
pub const SDL_POLLSENTINEL: C2RustUnnamed_0 = 32512;
pub const SDL_RENDER_DEVICE_RESET: C2RustUnnamed_0 = 8193;
pub const SDL_RENDER_TARGETS_RESET: C2RustUnnamed_0 = 8192;
pub const SDL_SENSORUPDATE: C2RustUnnamed_0 = 4608;
pub const SDL_AUDIODEVICEREMOVED: C2RustUnnamed_0 = 4353;
pub const SDL_AUDIODEVICEADDED: C2RustUnnamed_0 = 4352;
pub const SDL_DROPCOMPLETE: C2RustUnnamed_0 = 4099;
pub const SDL_DROPBEGIN: C2RustUnnamed_0 = 4098;
pub const SDL_DROPTEXT: C2RustUnnamed_0 = 4097;
pub const SDL_DROPFILE: C2RustUnnamed_0 = 4096;
pub const SDL_CLIPBOARDUPDATE: C2RustUnnamed_0 = 2304;
pub const SDL_MULTIGESTURE: C2RustUnnamed_0 = 2050;
pub const SDL_DOLLARRECORD: C2RustUnnamed_0 = 2049;
pub const SDL_DOLLARGESTURE: C2RustUnnamed_0 = 2048;
pub const SDL_FINGERMOTION: C2RustUnnamed_0 = 1794;
pub const SDL_FINGERUP: C2RustUnnamed_0 = 1793;
pub const SDL_FINGERDOWN: C2RustUnnamed_0 = 1792;
pub const SDL_CONTROLLERSENSORUPDATE: C2RustUnnamed_0 = 1625;
pub const SDL_CONTROLLERTOUCHPADUP: C2RustUnnamed_0 = 1624;
pub const SDL_CONTROLLERTOUCHPADMOTION: C2RustUnnamed_0 = 1623;
pub const SDL_CONTROLLERTOUCHPADDOWN: C2RustUnnamed_0 = 1622;
pub const SDL_CONTROLLERDEVICEREMAPPED: C2RustUnnamed_0 = 1621;
pub const SDL_CONTROLLERDEVICEREMOVED: C2RustUnnamed_0 = 1620;
pub const SDL_CONTROLLERDEVICEADDED: C2RustUnnamed_0 = 1619;
pub const SDL_CONTROLLERBUTTONUP: C2RustUnnamed_0 = 1618;
pub const SDL_CONTROLLERBUTTONDOWN: C2RustUnnamed_0 = 1617;
pub const SDL_CONTROLLERAXISMOTION: C2RustUnnamed_0 = 1616;
pub const SDL_JOYBATTERYUPDATED: C2RustUnnamed_0 = 1543;
pub const SDL_JOYDEVICEREMOVED: C2RustUnnamed_0 = 1542;
pub const SDL_JOYDEVICEADDED: C2RustUnnamed_0 = 1541;
pub const SDL_JOYBUTTONUP: C2RustUnnamed_0 = 1540;
pub const SDL_JOYBUTTONDOWN: C2RustUnnamed_0 = 1539;
pub const SDL_JOYHATMOTION: C2RustUnnamed_0 = 1538;
pub const SDL_JOYBALLMOTION: C2RustUnnamed_0 = 1537;
pub const SDL_JOYAXISMOTION: C2RustUnnamed_0 = 1536;
pub const SDL_MOUSEWHEEL: C2RustUnnamed_0 = 1027;
pub const SDL_MOUSEBUTTONUP: C2RustUnnamed_0 = 1026;
pub const SDL_MOUSEBUTTONDOWN: C2RustUnnamed_0 = 1025;
pub const SDL_MOUSEMOTION: C2RustUnnamed_0 = 1024;
pub const SDL_TEXTEDITING_EXT: C2RustUnnamed_0 = 773;
pub const SDL_KEYMAPCHANGED: C2RustUnnamed_0 = 772;
pub const SDL_TEXTINPUT: C2RustUnnamed_0 = 771;
pub const SDL_TEXTEDITING: C2RustUnnamed_0 = 770;
pub const SDL_KEYUP: C2RustUnnamed_0 = 769;
pub const SDL_KEYDOWN: C2RustUnnamed_0 = 768;
pub const SDL_SYSWMEVENT: C2RustUnnamed_0 = 513;
pub const SDL_WINDOWEVENT: C2RustUnnamed_0 = 512;
pub const SDL_DISPLAYEVENT: C2RustUnnamed_0 = 336;
pub const SDL_LOCALECHANGED: C2RustUnnamed_0 = 263;
pub const SDL_APP_DIDENTERFOREGROUND: C2RustUnnamed_0 = 262;
pub const SDL_APP_WILLENTERFOREGROUND: C2RustUnnamed_0 = 261;
pub const SDL_APP_DIDENTERBACKGROUND: C2RustUnnamed_0 = 260;
pub const SDL_APP_WILLENTERBACKGROUND: C2RustUnnamed_0 = 259;
pub const SDL_APP_LOWMEMORY: C2RustUnnamed_0 = 258;
pub const SDL_APP_TERMINATING: C2RustUnnamed_0 = 257;
pub const SDL_QUIT: C2RustUnnamed_0 = 256;
pub const SDL_FIRSTEVENT: C2RustUnnamed_0 = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_CommonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DisplayEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub display: Uint32,
    pub event: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub data1: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_WindowEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub event: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub data1: Sint32,
    pub data2: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_KeyboardEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub state: Uint8,
    pub repeat: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub keysym: SDL_Keysym,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextEditingEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: [libc::c_char; 32],
    pub start: Sint32,
    pub length: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextEditingExtEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: *mut libc::c_char,
    pub start: Sint32,
    pub length: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TextInputEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub text: [libc::c_char; 32],
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseMotionEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub state: Uint32,
    pub x: Sint32,
    pub y: Sint32,
    pub xrel: Sint32,
    pub yrel: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub button: Uint8,
    pub state: Uint8,
    pub clicks: Uint8,
    pub padding1: Uint8,
    pub x: Sint32,
    pub y: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MouseWheelEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub which: Uint32,
    pub x: Sint32,
    pub y: Sint32,
    pub direction: Uint32,
    pub preciseX: libc::c_float,
    pub preciseY: libc::c_float,
    pub mouseX: Sint32,
    pub mouseY: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyAxisEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub axis: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub value: Sint16,
    pub padding4: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyBallEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub ball: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub xrel: Sint16,
    pub yrel: Sint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyHatEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub hat: Uint8,
    pub value: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub button: Uint8,
    pub state: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_JoyBatteryEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub level: SDL_JoystickPowerLevel,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerAxisEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub axis: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
    pub value: Sint16,
    pub padding4: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerButtonEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub button: Uint8,
    pub state: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerTouchpadEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub touchpad: Sint32,
    pub finger: Sint32,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub pressure: libc::c_float,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_ControllerSensorEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: SDL_JoystickID,
    pub sensor: Sint32,
    pub data: [libc::c_float; 3],
    pub timestamp_us: Uint64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_AudioDeviceEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Uint32,
    pub iscapture: Uint8,
    pub padding1: Uint8,
    pub padding2: Uint8,
    pub padding3: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_TouchFingerEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub fingerId: SDL_FingerID,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub dx: libc::c_float,
    pub dy: libc::c_float,
    pub pressure: libc::c_float,
    pub windowID: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_MultiGestureEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub dTheta: libc::c_float,
    pub dDist: libc::c_float,
    pub x: libc::c_float,
    pub y: libc::c_float,
    pub numFingers: Uint16,
    pub padding: Uint16,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DollarGestureEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub touchId: SDL_TouchID,
    pub gestureId: SDL_GestureID,
    pub numFingers: Uint32,
    pub error: libc::c_float,
    pub x: libc::c_float,
    pub y: libc::c_float,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_DropEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub file: *mut libc::c_char,
    pub windowID: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_SensorEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub which: Sint32,
    pub data: [libc::c_float; 6],
    pub timestamp_us: Uint64,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_QuitEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_UserEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub windowID: Uint32,
    pub code: Sint32,
    pub data1: *mut libc::c_void,
    pub data2: *mut libc::c_void,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_SysWMEvent {
    pub type_0: Uint32,
    pub timestamp: Uint32,
    pub msg: *mut SDL_SysWMmsg,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub union SDL_Event {
    pub type_0: Uint32,
    pub common: SDL_CommonEvent,
    pub display: SDL_DisplayEvent,
    pub window: SDL_WindowEvent,
    pub key: SDL_KeyboardEvent,
    pub edit: SDL_TextEditingEvent,
    pub editExt: SDL_TextEditingExtEvent,
    pub text: SDL_TextInputEvent,
    pub motion: SDL_MouseMotionEvent,
    pub button: SDL_MouseButtonEvent,
    pub wheel: SDL_MouseWheelEvent,
    pub jaxis: SDL_JoyAxisEvent,
    pub jball: SDL_JoyBallEvent,
    pub jhat: SDL_JoyHatEvent,
    pub jbutton: SDL_JoyButtonEvent,
    pub jdevice: SDL_JoyDeviceEvent,
    pub jbattery: SDL_JoyBatteryEvent,
    pub caxis: SDL_ControllerAxisEvent,
    pub cbutton: SDL_ControllerButtonEvent,
    pub cdevice: SDL_ControllerDeviceEvent,
    pub ctouchpad: SDL_ControllerTouchpadEvent,
    pub csensor: SDL_ControllerSensorEvent,
    pub adevice: SDL_AudioDeviceEvent,
    pub sensor: SDL_SensorEvent,
    pub quit: SDL_QuitEvent,
    pub user: SDL_UserEvent,
    pub syswm: SDL_SysWMEvent,
    pub tfinger: SDL_TouchFingerEvent,
    pub mgesture: SDL_MultiGestureEvent,
    pub dgesture: SDL_DollarGestureEvent,
    pub drop: SDL_DropEvent,
    pub padding: [Uint8; 56],
}
pub type C2RustUnnamed_1 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_1 = 255;
pub const VIEWDRAW: C2RustUnnamed_1 = 1;
pub const NODRAW: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const FADE_VFAST: C2RustUnnamed_2 = 128;
pub const FADE_FAST: C2RustUnnamed_2 = 8;
pub const FADE_MED: C2RustUnnamed_2 = 16;
pub const FADE_SLOW: C2RustUnnamed_2 = 8;
pub type bool32_t = uint32_t;
pub type SDLPROC = Option::<unsafe extern "C" fn(*mut SDL_Event) -> ()>;
pub type TARTIMAGE = _artimage;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _artimage {
    pub pData: *mut uint8_t,
    pub nWidth: libc::c_int,
    pub nHeight: libc::c_int,
    pub nFrames: libc::c_int,
    pub bTrans: bool32_t,
    pub bMask: uint8_t,
}
pub const AF_SMALLGRAY: _artfonts = 1;
pub type _artfonts = libc::c_uint;
pub const AF_HUGEGRAY: _artfonts = 7;
pub const AF_HUGE: _artfonts = 6;
pub const AF_BIGGRAY: _artfonts = 5;
pub const AF_BIG: _artfonts = 4;
pub const AF_MEDGRAY: _artfonts = 3;
pub const AF_MED: _artfonts = 2;
pub const AF_SMALL: _artfonts = 0;
#[no_mangle]
pub static mut gszCredits: [*const libc::c_char; 467] = [
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Game Design\0" as *const u8 as *const libc::c_char,
    b"    Blizzard North\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Senior Designers\0" as *const u8 as *const libc::c_char,
    b"    Erich Schaefer, David Brevik\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Additional Design\0" as *const u8 as *const libc::c_char,
    b"    Max Schaefer, Eric Sexton, Kenneth Williams\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Lead Programmer\0" as *const u8 as *const libc::c_char,
    b"    David Brevik\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Senior Programmers\0" as *const u8 as *const libc::c_char,
    b"    Richard Seis, Doron Gartner,\0" as *const u8 as *const libc::c_char,
    b"    Patrick Wyatt, Mike O'Brien\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Programming\0" as *const u8 as *const libc::c_char,
    b"    Peter Brevik, Robin van der Wel, Jon Morin\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Special Guest Programmers\0" as *const u8 as *const libc::c_char,
    b"    Collin Murray, Frank Pearce\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Battle.net Programming\0" as *const u8 as *const libc::c_char,
    b"    Mike O'Brien, Mike Morhaime, Dan Liebgold\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Serial Communications Programming\0" as *const u8 as *const libc::c_char,
    b"    Jeff Strain, Mike O'Brien\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Installer Programming\0" as *const u8 as *const libc::c_char,
    b"    Bob Fitch, Patrick Wyatt\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Art Directors\0" as *const u8 as *const libc::c_char,
    b"    Erich Schaefer, Samwise Didier\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Artwork\0" as *const u8 as *const libc::c_char,
    b"    Michio Okamura, Eric Sexton, Ben Haas, Patrick Tougas,\0" as *const u8
        as *const libc::c_char,
    b"    Kelly Johnson, Erich Schaefer, Max Schaefer, Hugh Tom\0" as *const u8
        as *const libc::c_char,
    b"    Byrne, Roman Kenney, Samwise Didier, Dave Berggren,\0" as *const u8
        as *const libc::c_char,
    b"    Micky Neilson, Eric Flannum, Justin Thavirat, Brian\0" as *const u8
        as *const libc::c_char,
    b"    Sousa, Stu Rose, Nick Carpenter, Joeyray Hall\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Technical Artwork\0" as *const u8 as *const libc::c_char,
    b"    Christopher Root, Mark Sutherland,\0" as *const u8 as *const libc::c_char,
    b"    Robert Djordjevich, Jeffrey Vaughn\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Cinematic Art Directors\0" as *const u8 as *const libc::c_char,
    b"    Duane Stinnett, Matt Samia\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"3D Cinematic Artwork\0" as *const u8 as *const libc::c_char,
    b"    Duane Stinnett, Matt Samia, Rob McNaughton,\0" as *const u8
        as *const libc::c_char,
    b"    Eric Flannum, Dave Pursley, Micky Neilson,\0" as *const u8
        as *const libc::c_char,
    b"    Maxx Marshall, Trevor Jacobs, Brian Sousa,\0" as *const u8
        as *const libc::c_char,
    b"    Samwise Didier, Ron Smorynski, Ben Haas, Patrick Tougas\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Cinematic Technical Artwork\0" as *const u8 as *const libc::c_char,
    b"    Joeyray Hall \0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Executive Producer\0" as *const u8 as *const libc::c_char,
    b"    Allen Adham\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Producer\0" as *const u8 as *const libc::c_char,
    b"    Bill Roper\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Associate Producer\0" as *const u8 as *const libc::c_char,
    b"    James Phinney\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Diablo Strike Team\0" as *const u8 as *const libc::c_char,
    b"    Allen Adham, Ron Millar, Mike O'Brien,\0" as *const u8 as *const libc::c_char,
    b"    James Phinney, Bill Roper, Patrick Wyatt\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Music\0" as *const u8 as *const libc::c_char,
    b"    Matt Uelmen\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Sound Design\0" as *const u8 as *const libc::c_char,
    b"    Matt Uelmen, Glenn Stafford\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Cinematic Music & Sound\0" as *const u8 as *const libc::c_char,
    b"    Glenn Stafford, Matt Uelmen\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Voice Production, Direction & Casting\0" as *const u8 as *const libc::c_char,
    b"    Mark Schwarz, Glenn Stafford, Bill Roper\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Script & Story\0" as *const u8 as *const libc::c_char,
    b"    Erich Schaefer, Eric Sexton,\0" as *const u8 as *const libc::c_char,
    b"    Chris Metzen, Bill Roper\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Voice Editing\0" as *const u8 as *const libc::c_char,
    b"    Glenn Stafford\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Voices\0" as *const u8 as *const libc::c_char,
    b"    Michael Haley, Glynnis Talken, Michael Gough,\0" as *const u8
        as *const libc::c_char,
    b"    Paul Eiding, Lani Minella, Steve Brodie, Bill Roper,\0" as *const u8
        as *const libc::c_char,
    b"    Mark Schwarz, Glenn Stafford, Chris Metzen, Max Schaefer\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Recording Engineer\0" as *const u8 as *const libc::c_char,
    b"    Robert Koenigsberg\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Manual Design & Layout\0" as *const u8 as *const libc::c_char,
    b"    Peter Underwood, Jeffrey Vaughn,\0" as *const u8 as *const libc::c_char,
    b"    Chris Metzen, Bill Roper\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Manual Artwork\0" as *const u8 as *const libc::c_char,
    b"    Samwise Didier, Chris Metzen,\0" as *const u8 as *const libc::c_char,
    b"    Roman Kenney, Maxx Marshall\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Provisional Director of QA (Lead Tester)\0" as *const u8 as *const libc::c_char,
    b"    Shane Dabiri\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"QA Assault Team (Testers)\0" as *const u8 as *const libc::c_char,
    b"    Christopher Cross, Mike Givens, Dave Hale,\0" as *const u8
        as *const libc::c_char,
    b"    Brian \"Doc\" Love, Hung Nguyen, Dean Shipley,\0" as *const u8
        as *const libc::c_char,
    b"    Chris Sigaty, Ian Welke, Jamie Wiggs\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"QA Special Ops Team (Compatibility Testers)\0" as *const u8 as *const libc::c_char,
    b"    Adam Maxwell, Russell \"Rug\" Miller\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"QA Artillery Support (Additional Testers) \0" as *const u8 as *const libc::c_char,
    b"    Rich Alcazar, Mike Jones, Rev. Dan Moore, Matt Morris,\0" as *const u8
        as *const libc::c_char,
    b"    Mark Pfeiffer, Harish \"Pepe the Enforcer\" Rao, Chris Millar\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"QA Counterintelligence\0" as *const u8 as *const libc::c_char,
    b"    Alan Dabiri, Jesse McReynolds, Walter Takata\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Order of Network Information Services\0" as *const u8 as *const libc::c_char,
    b"    Robert Bridenbecker, Jason \"Brother Shaggy\" Schmit,\0" as *const u8
        as *const libc::c_char,
    b"    Jamie \"Brother Gug\" Steigerwald, Richard Seis \0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Customer Support\0" as *const u8 as *const libc::c_char,
    b"    John Schwartz, Vic Larson, Chad Chaudry, Mick Yanko,\0" as *const u8
        as *const libc::c_char,
    b"    Brandon Riseling, Kirk Mahony, Tony Hardy, Richard\0" as *const u8
        as *const libc::c_char,
    b"    Amtower, Collin Smith, Andrew Edwards, Roger Eberhart\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Sales\0" as *const u8 as *const libc::c_char,
    b"    Jorge Rivero, Rob Beatie\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Dunsel\0" as *const u8 as *const libc::c_char,
    b"    Alan Dabiri\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Mr. Dabiri's Background Vocalists\0" as *const u8 as *const libc::c_char,
    b"    Karin Colenzo, Christina Cade,\0" as *const u8 as *const libc::c_char,
    b"    Kim Farrington, Melissa Edwards\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Public Relations\0" as *const u8 as *const libc::c_char,
    b"    Linda Duttenhaver, Susan Wooley\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Marketing\0" as *const u8 as *const libc::c_char,
    b"    John Patrick, Steve Huot, Neal Hubbard, Kathy Carter\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"International Sales\0" as *const u8 as *const libc::c_char,
    b"    Ralph Becker, Chris Yoshimura\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"U.S. Sales\0" as *const u8 as *const libc::c_char,
    b"    Todd Coyle, Danny Kearns\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Manufacturing\0" as *const u8 as *const libc::c_char,
    b"    John Goodman, Tom Bryan\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Legal & Business\0" as *const u8 as *const libc::c_char,
    b"    Paula Duffy, Eric Roeder, Paul Sams, Kenneth Williams\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Special Thanks To\0" as *const u8 as *const libc::c_char,
    b"    Primenet, Earthlink, AOL, Compuserve, ATI, Matrox, STB, \0" as *const u8
        as *const libc::c_char,
    b"    Creative Labs, Logitech, U.S. Robotics, Gravis, Cyrix\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Thanks To\0" as *const u8 as *const libc::c_char,
    b"    Ian Colquhoun, Rod Shean, Brian Fitzgerald, Sharon Schafer, Todd \0"
        as *const u8 as *const libc::c_char,
    b"    Schafer, Richard and Sandra Schaefer, Rick Bowles, Greg Bogden, \0"
        as *const u8 as *const libc::c_char,
    b"    Cindy Sievert, Brad Mason, Chuck Goldman, Karin Colenzo, Wendy \0" as *const u8
        as *const libc::c_char,
    b"    Brevik, Jennie Brevik, Hanna Carroll, Katie Newell, Karen Weiss, \0"
        as *const u8 as *const libc::c_char,
    b"    Kurt Beaver, Stan McDonald, Brian Sexton, Michael Wan, Megan \0" as *const u8
        as *const libc::c_char,
    b"    Williams, Jessica Gensley, Beth Ann Parks, Brian Piltin, Johnathan \0"
        as *const u8 as *const libc::c_char,
    b"    Root, Brett Supernaw, Sabeer Bhatia, Mark Rearick, Brad Mason, \0" as *const u8
        as *const libc::c_char,
    b"    Diane Kodama, Bernadette Sexton, Barbara Uhlmann, Patricia\0" as *const u8
        as *const libc::c_char,
    b"    McDonald, Kris Kelley, Alissa Vaage, Denise Hernandez, Paula \0" as *const u8
        as *const libc::c_char,
    b"    White, Rachel Marie Hawley, Laura Gaber, Isaac Matarasso,\0" as *const u8
        as *const libc::c_char,
    b"    Susan Stafford, Gretchen Witte, Jason Sailor, Eufemia Palomino, \0"
        as *const u8 as *const libc::c_char,
    b"    Nathalie Didier, Nicole Welke, Dawn Caddel, Anna-Marcelle \0" as *const u8
        as *const libc::c_char,
    b"    Okamura, Amber Okamura, Megan Okamura Tracey McNaughton, \0" as *const u8
        as *const libc::c_char,
    b"    Trisha Ann Ochoa, Annie Strain, Dr. Gregory T. Street, Ray the Soda \0"
        as *const u8 as *const libc::c_char,
    b"    Guy, Sam Raimi, A. Guinness Brewing Co., John Woo, Chow Yun Fat, \0"
        as *const u8 as *const libc::c_char,
    b"    Jackie Chan,Proposition 215, Rumiko Takahashi, Bunchy & Mason, \0" as *const u8
        as *const libc::c_char,
    b"    The Friends of Stan, The Zoo Crew, Team Hamro, Brazil 2001, RUSH, \0"
        as *const u8 as *const libc::c_char,
    b"    Cornholio, THE BROS., Dar, Emeril Lagasse, Tom Waits, Ice-Cube, \0"
        as *const u8 as *const libc::c_char,
    b"    The Strike Team Deflectors, Tony Levin, Big Jim and the Twins, \0" as *const u8
        as *const libc::c_char,
    b"    Jag`rmeister, The Megasphere, Condor, The Allower, The Sunday \0" as *const u8
        as *const libc::c_char,
    b"    Night Group, Gravitar, Steinway Pianos, Round Table Pizza, The Poxy \0"
        as *const u8 as *const libc::c_char,
    b"    Boggards, Urban Mystic & Co., Caffeine, Hunter Rose, Marly \0" as *const u8
        as *const libc::c_char,
    b"    mediums in the box, sweet Poteen, Dave Scarpitti, TheByter, Bim \0"
        as *const u8 as *const libc::c_char,
    b"    Man, Krissann for color, Patty at Avalon Tattoo, James, Whaleboy, \0"
        as *const u8 as *const libc::c_char,
    b"    Dunsel Training Institute, monkeys, Dob Bole, Rootes Group, Porshe, \0"
        as *const u8 as *const libc::c_char,
    b"    Bongo, Scarlett, Apollo, The House of Mediocrity, Amelias, The King, \0"
        as *const u8 as *const libc::c_char,
    b"    Saag and all the folks at Davidson\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"In memory of\0" as *const u8 as *const libc::c_char,
    b"    Lawrence and Barbara Williams\0" as *const u8 as *const libc::c_char,
    b"    David A. Hargrave\0" as *const u8 as *const libc::c_char,
    b"    Tony \"Xatre\" Collin\0" as *const u8 as *const libc::c_char,
    b"    Thomas H Sexton\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"Very Special Thanks to\0" as *const u8 as *const libc::c_char,
    b"    Bob and Jan Davidson\0" as *const u8 as *const libc::c_char,
    b"    Walter Forbes\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"The Ring of One Thousand\0" as *const u8 as *const libc::c_char,
    b"    Andrew Abernathy, Christopher Abramo, David Adams, David \0" as *const u8
        as *const libc::c_char,
    b"    Adcox, Marko Agterberg, Cory Aiken, Judah Altaras, John \0" as *const u8
        as *const libc::c_char,
    b"    Alvarez, Jose Alvarez, Richard Amable, Alexander Amaral, \0" as *const u8
        as *const libc::c_char,
    b"    Scott Amis, Vincent Amoroso, Mark An, David Andersen, Jason \0" as *const u8
        as *const libc::c_char,
    b"    Andersen, Aaron Anderson, George Anderson, Matthew \0" as *const u8
        as *const libc::c_char,
    b"    Anderson, Michael Anderson, Sean Anderson, Robert Andrade, \0" as *const u8
        as *const libc::c_char,
    b"    Cerny Andre, Michael Andreev, Devin Angle, Brian Apple, \0" as *const u8
        as *const libc::c_char,
    b"    Brian Arbuthnot, Billy Arden, Dorian Arnold, Andre Arsenault, \0" as *const u8
        as *const libc::c_char,
    b"    Erik Asplund, Mark Assam, John Athey, Jason Attard, Jeff \0" as *const u8
        as *const libc::c_char,
    b"    Atwood, Ricky Au, Scott Avery, Rand Babcock, Steve Babel, \0" as *const u8
        as *const libc::c_char,
    b"    Raymond Bacalso, Ed Bachta, Steven Back, Scott Baeder, Alex \0" as *const u8
        as *const libc::c_char,
    b"    Baevski, Scott Bailey, Kenneth Baird, Thomas Baker, Todd \0" as *const u8
        as *const libc::c_char,
    b"    Bala, Jan Ball, Greg Baltz, Blake Baltzley, Doug Bambrick, Wes \0" as *const u8
        as *const libc::c_char,
    b"    Bangerter, Paul Barfuss, Chris Barghout, Dave Barnebey, Jon \0" as *const u8
        as *const libc::c_char,
    b"    Barnhart, Terje Barth, Nicole Baskin, Bernard Baylen, Ryan \0" as *const u8
        as *const libc::c_char,
    b"    Bear, Phil Bedard, Todd Belcher, Chip Bell, Erez Ben-Aharon, \0" as *const u8
        as *const libc::c_char,
    b"    Jonathan Bender, Nick Bennett, Ireney Berezniak, Ted Berg, \0" as *const u8
        as *const libc::c_char,
    b"    Gunnar Bergem, Russell Beuker, Ed Bickford, Stephen Biles, \0" as *const u8
        as *const libc::c_char,
    b"    John Billdt, Gerald Binder, John Bird, Hannah Blackerby, Tom \0" as *const u8
        as *const libc::c_char,
    b"    Blackerby, Clayton Blackwell, Thomas Blake, Shawn Blaszak, \0" as *const u8
        as *const libc::c_char,
    b"    Daniel Bliss, Fred Bliss, Jeff Bliss, Jon Blum, Rune Boersjoe, \0" as *const u8
        as *const libc::c_char,
    b"    Andrew Boggs, Dave Boisvenu, Joe Bolt, John Bonds, Jeff \0" as *const u8
        as *const libc::c_char,
    b"    Borenstein, Dorian Borin, Ed Boris, Bartholomew Botta, \0" as *const u8
        as *const libc::c_char,
    b"    Michael Boutin, Michael Boyd, Charles Boyer, Mike \0" as *const u8
        as *const libc::c_char,
    b"    Boyersmith, Michael Boyko, Eric Bradberry, John Brandstetter, \0" as *const u8
        as *const libc::c_char,
    b"    Ryan Breding, Paul Brinkmann, Patrick Briscoe, Scott Brisko, \0" as *const u8
        as *const libc::c_char,
    b"    Jeremy Britton, Adrian Broadhead, Glenn Brouwer, Joe Brown, \0" as *const u8
        as *const libc::c_char,
    b"    S\xE9bastien Brulotte, Darrell Brunsch, William Bryan, Jason \0" as *const u8
        as *const libc::c_char,
    b"    Bucher, Chris Buchinger, Clayton Buckingham, John Buckles, \0" as *const u8
        as *const libc::c_char,
    b"    David Bugay, Ed Bujone, Erik Burgess, Gabriel Burkett, Chris \0" as *const u8
        as *const libc::c_char,
    b"    Burnes, Richard Butler, Jeffrey Bye, Dougall Campbell, Donnie \0" as *const u8
        as *const libc::c_char,
    b"    Cannon, Shane Cantrell, Connor Caple, Daniel Carey, James \0" as *const u8
        as *const libc::c_char,
    b"    Carlton, Michael Carmel, Mike Carpenter, Ronald Carruthers, \0" as *const u8
        as *const libc::c_char,
    b"    Phil Carter, Bryce Cartmill, Eric Cartwright, Anthony Caruso, \0" as *const u8
        as *const libc::c_char,
    b"    Lon Casey, Tim Caster, Aaron Chan, Otto Chan, Gene Chang, \0" as *const u8
        as *const libc::c_char,
    b"    Hsiao-Lung Chang, William Chang, George Chappel, Larry \0" as *const u8
        as *const libc::c_char,
    b"    Charbonneau, Troy Chase, Bruce Chen, Chun Hsien Chen, Sam \0" as *const u8
        as *const libc::c_char,
    b"    Chen, Tzu-Mainn Chen, Mike Cheng, Chris Chiapusio, Damien \0" as *const u8
        as *const libc::c_char,
    b"    Chiesa, Nick Chin, Nim Ching, Jonathan Chinn, Michael Chinn, \0" as *const u8
        as *const libc::c_char,
    b"    Philander Chiu, Thayne Christiansen, Philip Chui, Steve \0" as *const u8
        as *const libc::c_char,
    b"    Cintamani, Richard Ciordia, Colin Clark, Steve Clark, Samuel \0" as *const u8
        as *const libc::c_char,
    b"    Clements, Meredith Clifton, Jeff Cohen, Dale Colton, Dax \0" as *const u8
        as *const libc::c_char,
    b"    Combe, Matt Compton, Jacob Conklin, Richard Conn, Zac \0" as *const u8
        as *const libc::c_char,
    b"    Cook, Tim Coolong, Gregory Coomer, Dennis Cosgrove, Kelly \0" as *const u8
        as *const libc::c_char,
    b"    Couch, Andrew Coulter, Eric Coutinho, David Coutts, James \0" as *const u8
        as *const libc::c_char,
    b"    Craig, John Craig, Kazial Craig, John Crawford, Marcelo \0" as *const u8
        as *const libc::c_char,
    b"    Crespo, Orville Crews, Tim Cristy, Elmer Crosby III, Russell \0" as *const u8
        as *const libc::c_char,
    b"    Cullison, Ryan Cupples, Andrew Dagley, Steve Dallaire, Richard \0" as *const u8
        as *const libc::c_char,
    b"    Dalton, David Dandar, Pro Daulo, Rob Dautermann, Mike \0" as *const u8
        as *const libc::c_char,
    b"    Davies, Kalieb Davis, Marshall Davis, Ronald Davis, Danny De \0" as *const u8
        as *const libc::c_char,
    b"    Bie, Marc De Filippis, Myles Deighton, Kent Dejarnett, Anthony \0" as *const u8
        as *const libc::c_char,
    b"    Delarosa, Neil Dempster, Peter Denitto, Joaquim Dentz, Scott \0" as *const u8
        as *const libc::c_char,
    b"    Dewar, Anish Dhingra, Philip Dhingra, David Diaz, Stewart \0" as *const u8
        as *const libc::c_char,
    b"    Dicks, Brad Dietz, Josh Dietz, Colleen Diggins, Mike Ditchburn, \0"
        as *const u8 as *const libc::c_char,
    b"    Eric Dittman, Allen Do, Huy Doan, Matthew Dolman, Antoine \0" as *const u8
        as *const libc::c_char,
    b"    Dongois, Eamonn Donohoe, Bill Dorell, Mark Dorison, Dan \0" as *const u8
        as *const libc::c_char,
    b"    Dorsett, Chris Dorsey, Jim Dos\xE9, Willis Doss, Chin Du, William \0"
        as *const u8 as *const libc::c_char,
    b"    Dubis, Timothy Duewell, Brandon Dunn, Andrew Durham, Don \0" as *const u8
        as *const libc::c_char,
    b"    Duvall, Kevin Dvojack, Daniel Eaton, Paul Eberting, Eric \0" as *const u8
        as *const libc::c_char,
    b"    Echelbarger, Lance Eddleman, Ben Eggers, David Eggum, John \0" as *const u8
        as *const libc::c_char,
    b"    Ehde, Brian Eikenberry, Patrick Elven, Peter Engdahl, Philip \0" as *const u8
        as *const libc::c_char,
    b"    Engdahl, Michael Ennis, Darren Eslinger, Eric Ezell, Darren \0" as *const u8
        as *const libc::c_char,
    b"    Falslev, Stephen Feather, Tony Fenn, Ben Ferguson, Mike \0" as *const u8
        as *const libc::c_char,
    b"    Fernandez, Gwendal Feuillet, Guy Fietz, Julian Figueroa, Dale \0" as *const u8
        as *const libc::c_char,
    b"    Fillpot, Stan Finchem, Michael Finley, Nick Fisher, William \0" as *const u8
        as *const libc::c_char,
    b"    Fisher, Mark Fitlin, Dave Flatt, Joel J. Flores, John Folkers, \0" as *const u8
        as *const libc::c_char,
    b"    Steven Forgie, Tom Forsythe, Matthew Foster, Scott Francis, \0" as *const u8
        as *const libc::c_char,
    b"    Jim Frank, Paulo Fraser, Glenn French, Kurt Frerichs, Chris \0" as *const u8
        as *const libc::c_char,
    b"    Frey, Mark Friedman, Charles Friedmann, Dan Friend, Kirk \0" as *const u8
        as *const libc::c_char,
    b"    Fry, Aaron Fu, Erik Gaalema, Brandon Gabbard, Phil Gagner, \0" as *const u8
        as *const libc::c_char,
    b"    Tommy Gannon, David Gappmayer, Chris Garrison, Tony \0" as *const u8
        as *const libc::c_char,
    b"    Garrison, David Gasca, Jeremy Gasser, Michael Geist, Michael \0" as *const u8
        as *const libc::c_char,
    b"    Genereux, Daniel Genovese, Josh Gerwin, Paul Gibson, William \0" as *const u8
        as *const libc::c_char,
    b"    Gilchrist, Gabriel Gils Carbo, Chad Glendenin, Ryan Glinski, \0" as *const u8
        as *const libc::c_char,
    b"    Dean Gobrecht, Andrew Goldfinch, David Goodman, Mark \0" as *const u8
        as *const libc::c_char,
    b"    Goodson, Matt Gordon, Frank Gorgenyi, Sean Gould, Perry \0" as *const u8
        as *const libc::c_char,
    b"    Goutsos, Ed Govednik, Michael Grayson, Chris Green, Justin \0" as *const u8
        as *const libc::c_char,
    b"    Grenier, Jeff Greulich, Don Grey, Rob Griesbeck, Don Griffes, \0" as *const u8
        as *const libc::c_char,
    b"    Kimberly Griffeth, Jay Grizzard, Don Gronlund, Joe Gross, \0" as *const u8
        as *const libc::c_char,
    b"    Troy Growden, Greg Guilford, David Gusovsky, Jeremy \0" as *const u8
        as *const libc::c_char,
    b"    Guthrie, Adam Gutierrez, James Guzicki, Matthew Haas, Matt \0" as *const u8
        as *const libc::c_char,
    b"    Hadley, Ryan Hagelstrom, Bobby Hagen, Ben Hall, Brian Hall, \0" as *const u8
        as *const libc::c_char,
    b"    Kris Hall, Calvin Hamilton, Kris Hamilton, Bo Hammil, Dave \0" as *const u8
        as *const libc::c_char,
    b"    Hans, Rick Hansen, Robert Harlan, Travis Harlan, Seth \0" as *const u8
        as *const libc::c_char,
    b"    Harman, Jeff Harris, Shawn Hartford, Adam Hartsell, Neil \0" as *const u8
        as *const libc::c_char,
    b"    Harvey, Ray Hayes, John Hein, Chris Heinonen, Christer \0" as *const u8
        as *const libc::c_char,
    b"    Helsing, Chris Hempel, Dustin Hempel, Mathieu Henaire, Matt \0" as *const u8
        as *const libc::c_char,
    b"    Henry, Chuck Herb, Michael Herron, Sage Herron, Thomas \0" as *const u8
        as *const libc::c_char,
    b"    Herschbach, Cliff Hicks, Nelson Hicks, Paul Hierling, William \0" as *const u8
        as *const libc::c_char,
    b"    Hiers, Mike Higdon, Tim Hildebrand, Casey Hinkle, Ryan \0" as *const u8
        as *const libc::c_char,
    b"    Hitchings, Wes Hix, Alan Ho, Jenson Ho, Alan Hoffman, Jeff \0" as *const u8
        as *const libc::c_char,
    b"    Hoffman, Eleanor Hoffmann, Steve Hogg, Richard Holler, Brian \0" as *const u8
        as *const libc::c_char,
    b"    Homolya, Wade Hone, Joe Horvath, Jeff Howe, Eric Hudson, \0" as *const u8
        as *const libc::c_char,
    b"    Glen Huey, Chris Hufnagel, Joshua Hughes, Melissa Hughes, \0" as *const u8
        as *const libc::c_char,
    b"    Arief Hujaya, Thomas Hulen, Ryan Hupp, Justin Hurst, Rick \0" as *const u8
        as *const libc::c_char,
    b"    Hutchins, Steve Iams, Mike Iarossi, Bjorn Idren, Johan Idr\xE9n, \0"
        as *const u8 as *const libc::c_char,
    b"    Micah Imparato, Joe Ingersoll, David Ingram, Greg Ipp, Rodney \0" as *const u8
        as *const libc::c_char,
    b"    Irvin, Darin Isola, Justin Itoh, Mario Ivan, Fredrik Ivarsson, \0" as *const u8
        as *const libc::c_char,
    b"    Dax Jacobson, Michael Jacques, Stevens Jacques, Duane Jahnke, \0" as *const u8
        as *const libc::c_char,
    b"    William Jambrosek, Daniel Janick, Narciso Jaramillo, Neil \0" as *const u8
        as *const libc::c_char,
    b"    Jariwala, Harvie Jarriell, Scott Javadi, Joe Jenkins, Bart \0" as *const u8
        as *const libc::c_char,
    b"    Jennings, Paul Jennings, Julien Jenny, Jason Jensen, Martin \0" as *const u8
        as *const libc::c_char,
    b"    Jeremy, Mark Jeschke, Andy Johnson, James Johnson, Leigh \0" as *const u8
        as *const libc::c_char,
    b"    Johnson, Mark Johnson, Rupert Johnson, Clyde Jones, Michael \0" as *const u8
        as *const libc::c_char,
    b"    Jones, Tim Jordan, Ben Judy, Michael Kaae, Steve Kaczkowski, \0" as *const u8
        as *const libc::c_char,
    b"    Neville Kadwa, Brian Kaisner, Yoshihisa Kameyama, Michael \0" as *const u8
        as *const libc::c_char,
    b"    Kanemura, Daniel Kao, Eric Karabin, Ben Katz, Christopher \0" as *const u8
        as *const libc::c_char,
    b"    Kawamura, Erick Kayser, Craig Keddie, Kevin Kelley, Bryan \0" as *const u8
        as *const libc::c_char,
    b"    Kemp, Michael Kendrigan, Dan Kerber, Timothy Kerber, Tomi \0" as *const u8
        as *const libc::c_char,
    b"    Keski-Heikkil\xE4, Greg Kettering, Nathan Kilber, Howard Kim, \0" as *const u8
        as *const libc::c_char,
    b"    Orrin Kinion, Jon Kirst, David Kitch, John Klingbeil, Neil \0" as *const u8
        as *const libc::c_char,
    b"    Klopfenstein, Kerry Knouse, David Knox, Said Kobeissi, Jeff \0" as *const u8
        as *const libc::c_char,
    b"    Koches, Hades Kong, Jeff Kong, Kevin Konkle, Steve Koon, \0" as *const u8
        as *const libc::c_char,
    b"    David Koontz, Dan Koopmann, Steve Koskela, Kuan Kou, \0" as *const u8
        as *const libc::c_char,
    b"    Cameron Kracke, Jensen Krage, York Kramer, Cedar Kraus, \0" as *const u8
        as *const libc::c_char,
    b"    Jason Kraus, Bobby Krimen, Melissa Krispli, Steven Krispli, \0" as *const u8
        as *const libc::c_char,
    b"    James Kruger, Charles Kubasta, Kimmo Kulonen, Frank \0" as *const u8
        as *const libc::c_char,
    b"    Lackaff, Michael Lacour, Matt Lake, Jason Landry, Hans Erik \0" as *const u8
        as *const libc::c_char,
    b"    Lange, Michael Laramee, Brad Lascelle, Pat Laschinger, Alan \0" as *const u8
        as *const libc::c_char,
    b"    Lau, Sean Laurence, Anthony Lavey, Jr., Gary Le, Huey Le, \0" as *const u8
        as *const libc::c_char,
    b"    Stephane Le Roy Audy, Lim Leandro, Charles Lee, Conroy Lee, \0" as *const u8
        as *const libc::c_char,
    b"    Mike Lee, Shih-Hang Lee, Jonathan Leipert, Jason Lemann, \0" as *const u8
        as *const libc::c_char,
    b"    Ron Lenzi, Mitchell Leon, Stephanie Lesniewski, Brendan \0" as *const u8
        as *const libc::c_char,
    b"    Lewis, Robert Lewis, Sam Liao, Tom Liem, Adam Ligas, Steven \0" as *const u8
        as *const libc::c_char,
    b"    Liggett, Roger Lilley, Benjamin Lim, Jeff Lindholm, Johnson \0" as *const u8
        as *const libc::c_char,
    b"    Linwood, David Litchman, Bruce Lithimane, William Liu, \0" as *const u8
        as *const libc::c_char,
    b"    Wilson Liu, Robert Lobdell, Chris Logan, Razvan Loghin, Jack \0" as *const u8
        as *const libc::c_char,
    b"    Loh, George Loo, Russell Love, Juan Loyola, Ricardo Lozano, \0" as *const u8
        as *const libc::c_char,
    b"    Mike Luban, Tim Luc, Henry Luciano, Dianne Ludwig, Charles \0" as *const u8
        as *const libc::c_char,
    b"    Lueras, Derek Lung, Phong Ly, Scott MacGillivray, Dave Mack, \0" as *const u8
        as *const libc::c_char,
    b"    Alec Mak, Steve Mamayek, Michael Mancini, Daniel Mann, \0" as *const u8
        as *const libc::c_char,
    b"    Michael Mann, Chris Manofsky, Abdullah Marafie, Nicholas \0" as *const u8
        as *const libc::c_char,
    b"    Marcy, Piompino Mariano, Bob Marius, Trey Marshall, Dane \0" as *const u8
        as *const libc::c_char,
    b"    Martin, Gregg Martin, Renard Martin, Rich Martin, Scott \0" as *const u8
        as *const libc::c_char,
    b"    Martin, Thomas Martin, Jon Masters, Christopher Mathews, \0" as *const u8
        as *const libc::c_char,
    b"    Jay Mathis, Marc Matthews, Chris Mazur, Doug McBride, \0" as *const u8
        as *const libc::c_char,
    b"    Mackey McCandlish, Robin McCollum, Steven McCombie, \0" as *const u8
        as *const libc::c_char,
    b"    Andy McConnell, Michael McCourt, Bill McCoy, Doug \0" as *const u8
        as *const libc::c_char,
    b"    McCracken, Michael McDeed, Robert McDonald, Steve \0" as *const u8
        as *const libc::c_char,
    b"    McEachron, Craig McGee, Ryan McKenzie, Michael McKeown, \0" as *const u8
        as *const libc::c_char,
    b"    Daniel McMahon, Colin McMillan, Ian McWilliam, Mark \0" as *const u8
        as *const libc::c_char,
    b"    McWilliams, Khann Mean, Bryan Meason, Kenneth Medley, \0" as *const u8
        as *const libc::c_char,
    b"    Jeff Meek, John Mehr, Christopher Mende, Brian Mendenhall, \0" as *const u8
        as *const libc::c_char,
    b"    Peter Mengel, Michael Mersic, Mike Messom, Don Metcalf, \0" as *const u8
        as *const libc::c_char,
    b"    Gary Metzker, Scott Meyer, Joseph Michaud, Andrew Mielke, \0" as *const u8
        as *const libc::c_char,
    b"    Travis Mikalson, Troy Milburn, Ike Miller, Ronnie Miller, Sean \0" as *const u8
        as *const libc::c_char,
    b"    Miller, Steve Miller, Arthur Min, David Minniti, Brenda \0" as *const u8
        as *const libc::c_char,
    b"    Mirsberger, Bill Misek, David Mitchell, Joseph Mobley, Robert \0" as *const u8
        as *const libc::c_char,
    b"    Mollard, Will Mooar, Curtis Moore, Matthew Moore, Al \0" as *const u8
        as *const libc::c_char,
    b"    Morales, Ryan Moran, Lance Mortensen, Karel Mrazek, Ward \0" as *const u8
        as *const libc::c_char,
    b"    Mullee, William Munoz, Kirk Munro, Craig Murray, Shawn P. \0" as *const u8
        as *const libc::c_char,
    b"    Murray, Travis Murray, Michael Mushrush, Tom Mustaine, \0" as *const u8
        as *const libc::c_char,
    b"    David Myers, Joseph Myett, Morgan Najar, Kenta Nakamura, \0" as *const u8
        as *const libc::c_char,
    b"    Damian Nastri, Joshua Naumann, Nick Navarro, Douglas \0" as *const u8
        as *const libc::c_char,
    b"    Neitzel, Arnold Ng, Anthony Nguyen, Steve Nguyen, Joseph \0" as *const u8
        as *const libc::c_char,
    b"    Nicholas, Charles Nickolaus, Jon Nisbet, Patrick Nomee, David \0" as *const u8
        as *const libc::c_char,
    b"    Norling-Christensen, Bobby Norton, Joseph Nottingham, Frank \0" as *const u8
        as *const libc::c_char,
    b"    O'Connor, Jon Oden, David Oester, Lavern Ogden, Zach \0" as *const u8
        as *const libc::c_char,
    b"    Oglesby, Lucas Oldfield, Toby Olsson, Aaron Ondek, Sean \0" as *const u8
        as *const libc::c_char,
    b"    O'Neill, John Orlando, Samuel Orlando, Donovan Orloski, \0" as *const u8
        as *const libc::c_char,
    b"    David Pai, Nikolas Paldan, David Palek, John Palmieri, Anthony \0" as *const u8
        as *const libc::c_char,
    b"    Palmisano, Sanjay Pandit, Jesse Park, Alex Parker, Jimmy \0" as *const u8
        as *const libc::c_char,
    b"    Pasher, Lukasz Paszek, Andy Patterson, William Pelletier, \0" as *const u8
        as *const libc::c_char,
    b"    Duane Pemberton, Ivan Pemic, Kelly Pendergast, Mike \0" as *const u8
        as *const libc::c_char,
    b"    Penezich, Jon Penk, Willie Penley, Ron Penna, Matthew \0" as *const u8
        as *const libc::c_char,
    b"    Pennington, Kevin Pereira, Ross Perez, Ken Perkins, Brian \0" as *const u8
        as *const libc::c_char,
    b"    Peterik, Kelly Peterson, Chris Phillips, Rod Pickett, Cameron \0" as *const u8
        as *const libc::c_char,
    b"    Pierce, Reuben Pierce, Tim Pilger, Billy Pippin, Brad Plank, \0" as *const u8
        as *const libc::c_char,
    b"    Brian Plant, Craig Platt, David Plunkett, Michael Politi, Albert \0"
        as *const u8 as *const libc::c_char,
    b"    Portillo, Brian Powell, David Powell, Franklin Powers Jr., Alan \0"
        as *const u8 as *const libc::c_char,
    b"    Precourt, Michael Pronchick, Julian Quintana, Justin Radziej, \0" as *const u8
        as *const libc::c_char,
    b"    Steven Rajewski, Shawn Rawles, Ian Reardon, Marc Reed, Ric \0" as *const u8
        as *const libc::c_char,
    b"    Reichelt, Judd Reiffin, David Reilly, Garry Reisky, Drew \0" as *const u8
        as *const libc::c_char,
    b"    Ressler, Robert Reynolds, Walter Reynolds, Michael Rice, Ian \0" as *const u8
        as *const libc::c_char,
    b"    Richards, James Richards, Raymond Richmond, Dustin Riggs, \0" as *const u8
        as *const libc::c_char,
    b"    Keith Riskey, Brian Ro, Scott Roberts, Jorge Rodriguez, Chad \0" as *const u8
        as *const libc::c_char,
    b"    Rogers, Clint Rogers, Robert Rogers, Steve Rogers, Ethan Roots, \0"
        as *const u8 as *const libc::c_char,
    b"    Ron Roque, William Ross, Sebastian Rossi, Jeff Rostis, Ben \0" as *const u8
        as *const libc::c_char,
    b"    Roth, Demar Roth, Rich Rouse, Oleg Rovner, Jonathan Roy, \0" as *const u8
        as *const libc::c_char,
    b"    Drew Rozema, Mike Ruggles, Mathias Russ, James Russell, Jim \0" as *const u8
        as *const libc::c_char,
    b"    Rutledge, James Rutter, Dave Ryder, Chris Salvadras, Anders \0" as *const u8
        as *const libc::c_char,
    b"    Samnerud, Nick Sanders, Jakob Sandgren, Joe Sapinsky, Tyler \0" as *const u8
        as *const libc::c_char,
    b"    Sargent, Jonas Saunders, Mark Savage, Scott Sawyer, Robert \0" as *const u8
        as *const libc::c_char,
    b"    Scanlon, Trevor Schaben, Aaron Schmidt, Chris Schmidt, Greg \0" as *const u8
        as *const libc::c_char,
    b"    Schultz, Nicholas Schumacher, Scott Schumacher, Kevin Scott, \0" as *const u8
        as *const libc::c_char,
    b"    Rastislav Seffer, Robert Seidler, Corey Sellers, Justin Sellers, \0"
        as *const u8 as *const libc::c_char,
    b"    Marc Senecal, George Shannon, Ian Sheffield, Anoop Shekar, \0" as *const u8
        as *const libc::c_char,
    b"    Sandeep Shekar, Kevin Shelton, Leon Shephard, Eric Shepperd, \0" as *const u8
        as *const libc::c_char,
    b"    Jeffrey Shneidman, Samuel Shockey, Mark Shoemaker, Mike \0" as *const u8
        as *const libc::c_char,
    b"    Shupe, Sean Sibbet, Brian Sidharta, Jimmy Sieben, Eric \0" as *const u8
        as *const libc::c_char,
    b"    Siemens, William Silva, Jody Simpson, Jatinder Singh, Sonia \0" as *const u8
        as *const libc::c_char,
    b"    Siu, Omar Skarsvaag, Tom Skiba, Carl Skow, David Skuse, \0" as *const u8
        as *const libc::c_char,
    b"    Robert Slifka, Brent Smith, C. Eric Smith, Jared Smith, Jeffrey \0"
        as *const u8 as *const libc::c_char,
    b"    Smith, Owen Smith, Shannon Smith, Steven Smith, Edward Smola, \0" as *const u8
        as *const libc::c_char,
    b"    Matthew Sneep, Eric Snow, Brad Sobel, Jean-Pierre Solignac, Rasmus \0"
        as *const u8 as *const libc::c_char,
    b"    S\xF8rensen, Andrew Sorg, Poppy Southcott, Ross Specter, Erik Spencer, \0"
        as *const u8 as *const libc::c_char,
    b"    Keith Spencer, Chris Springer, Erikson Squier, Dean St. Onge, Stewart \0"
        as *const u8 as *const libc::c_char,
    b"    Stanfield, John Stanley, Terrence Staton, Benjamin Stein, James \0"
        as *const u8 as *const libc::c_char,
    b"    Steiner, David Steyer, William Stickney, Chris Stiff, James Stofer, \0"
        as *const u8 as *const libc::c_char,
    b"    Norm Storch, Patrick Stovall, Brandon Sturgeon, Sean Stutler, Anne \0"
        as *const u8 as *const libc::c_char,
    b"    Sukprasert, Jamal Sullivan, Bruce Sully, Jay Sung, Park Sung \0" as *const u8
        as *const libc::c_char,
    b"    Joon, Stein Sunnarvik, Nathan Surginer, Robert Swaringen, Lee \0" as *const u8
        as *const libc::c_char,
    b"    Sweeney, David Szabo, Scott Taft, Christian Takvam, Patrick \0" as *const u8
        as *const libc::c_char,
    b"    Talaska, Tadashi Tamaki, Simon Tan, Mark Taraba, Khon-\0" as *const u8
        as *const libc::c_char,
    b"    Whey Tay, John Taylor, Keith Taylor, Donald Temean, Phillip \0" as *const u8
        as *const libc::c_char,
    b"    Tesar, Pete Thao, Brian Thomas, Keith Thomas, Speed Thomas, \0" as *const u8
        as *const libc::c_char,
    b"    Miles Thorpe, Paul Thurrott, Mike Timbol, Nicholas Timmins, \0" as *const u8
        as *const libc::c_char,
    b"    Tom Tobin, Robert Towster, Hien Tran, Timothy Traviss, Toby \0" as *const u8
        as *const libc::c_char,
    b"    Traylor, Tony Treadwell, George Tremoulis, Paul Trinh, Thanh \0" as *const u8
        as *const libc::c_char,
    b"    Trinh, Chris Tristan, Brad Truswell, Jason Tryon, Mike Tu, \0" as *const u8
        as *const libc::c_char,
    b"    Gernel Tuazon, Eric Tuggle, Mike Turnbull, Lyle Ubben, \0" as *const u8
        as *const libc::c_char,
    b"    Amilcar Ubiera, Robert Ulozas, Arie Upton, Mark Van Noy, \0" as *const u8
        as *const libc::c_char,
    b"    Matthew Van Sickler, Jake Vantlin, Tony Vasquez, Brady \0" as *const u8
        as *const libc::c_char,
    b"    Vauclin, Gianpiero Vecchi, Chad Verrall, Chris Vicente, Brett \0" as *const u8
        as *const libc::c_char,
    b"    Vickers, David Vickery, Jonathan Vilante, Simon Vince, Ben \0" as *const u8
        as *const libc::c_char,
    b"    Vinson, David Voelkert, Paul Vogt, Nicholas Voorhies, Robert \0" as *const u8
        as *const libc::c_char,
    b"    Vreeland, Mike Vrooman, Rick Vuong, Brian Wachhaus, Todd \0" as *const u8
        as *const libc::c_char,
    b"    Wachhaus, Caine Wade, Mathew Wadstein, Kenneth Wagenius, \0" as *const u8
        as *const libc::c_char,
    b"    Trevor Wagner, John Wagstaff, Asad Wahid, Richard \0" as *const u8
        as *const libc::c_char,
    b"    Wahlberg, Helio Wakasugui, Richard Walker, Wilkins Walker, \0" as *const u8
        as *const libc::c_char,
    b"    Matthew Wallace, Daniel Walsh, Joel Walters, Andrew Waltz, \0" as *const u8
        as *const libc::c_char,
    b"    Tom Wang, Tony Wang, Jay Ward, Jonathan Ward, John \0" as *const u8
        as *const libc::c_char,
    b"    Warner, Mark Warren, Matt Washer, Mike Watson, Sean \0" as *const u8
        as *const libc::c_char,
    b"    Wattles, Mike Wayne, Christian Wehba, Benjamin Wei, Richard \0" as *const u8
        as *const libc::c_char,
    b"    Weight, Cary Wells, David Wenck, Bill Werring, Leonard \0" as *const u8
        as *const libc::c_char,
    b"    Wesley, Marlon West, Mikael Westerbacka, Brian Wharry, \0" as *const u8
        as *const libc::c_char,
    b"    Chris White, Chris White, Jeremy White, Greg Whitlock, Gary \0" as *const u8
        as *const libc::c_char,
    b"    Widener, Marty Wilfried, Israel Wilkinson, Michael Willams, \0" as *const u8
        as *const libc::c_char,
    b"    Derek Williams, Sean Willson, Nitzan Wilnai, Jim Wilson, \0" as *const u8
        as *const libc::c_char,
    b"    Karsten Wilson, William Wilt, Tim Winn, Brian Winzeler, Matt \0" as *const u8
        as *const libc::c_char,
    b"    Wise, Lee Wissmiller, Brendan Wolfe, Daniel Wolpert, Felix \0" as *const u8
        as *const libc::c_char,
    b"    Wong, Power Wong, Tony Wong, Tim Wood, Timothy Wood, \0" as *const u8
        as *const libc::c_char,
    b"    Jeremy Woods, Michael Woods, Bill Wright, Keith Wright, \0" as *const u8
        as *const libc::c_char,
    b"    Patrick Wu, Gang Xie, Robert Yao, Sun Lim Yap, Stephen Yau, \0" as *const u8
        as *const libc::c_char,
    b"    Erek Yedwabnick, Christopher Yee, Nick Yee, Juan Yip, David \0" as *const u8
        as *const libc::c_char,
    b"    Young, Rob Young, Seth Young, Alex Yu, Terry Zahn, Jia-Ning \0" as *const u8
        as *const libc::c_char,
    b"    Zhang, Eric Zieg, Jordan Zielin, Clint Zimmerman, Matt Zinke \0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"    No souls were sold in the making of this game.\0" as *const u8
        as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
    b" \0" as *const u8 as *const libc::c_char,
    b" \0" as *const u8 as *const libc::c_char,
    b" \0" as *const u8 as *const libc::c_char,
    b"\0" as *const u8 as *const libc::c_char,
];
#[no_mangle]
pub static mut credits_index: libc::c_int = 0;
#[no_mangle]
pub static mut CredTicks: uint32_t = 0;
#[no_mangle]
pub static mut CredFrame: uint32_t = 0;
#[no_mangle]
pub unsafe extern "C" fn InitCreditsMenu() {
    LoadArtWithPal(
        b"ui_art\\credits.pcx\0" as *const u8 as *const libc::c_char,
        1 as libc::c_int,
        &mut imgMenu,
    );
}
#[no_mangle]
pub unsafe extern "C" fn FreeCreditsMenu() {
    let mut p__p: *mut libc::c_void = imgMenu.pData as *mut libc::c_void;
    imgMenu.pData = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
}
#[no_mangle]
pub unsafe extern "C" fn interface_pump_credits_message() {
    let mut i: libc::c_int = 0;
    ClrDraw();
    lock_buf(0 as libc::c_int as uint8_t);
    DrawArtImage(0 as libc::c_int, 0 as libc::c_int, 0 as libc::c_int, &mut imgMenu);
    SetArtFont(AF_SMALLGRAY as libc::c_int);
    let mut CurrTick: uint32_t = SDL_GetTicks();
    if CurrTick.wrapping_sub(CredTicks)
        >= (1000 as libc::c_int / 60 as libc::c_int) as uint32_t
    {
        CredTicks = CurrTick;
        CredFrame = CredFrame.wrapping_add(1);
        CredFrame;
    }
    i = 0 as libc::c_int;
    while i < 16 as libc::c_int {
        if i + credits_index < 467 as libc::c_int {
            PrintArtFontCred(
                gszCredits[(i + credits_index) as usize],
                16 as libc::c_int,
                ((116 as libc::c_int + 16 as libc::c_int * i) as uint32_t)
                    .wrapping_sub(CredFrame) as libc::c_int,
                114 as libc::c_int,
                360 as libc::c_int,
            );
        }
        i += 1;
        i;
    }
    if CredFrame == 16 as libc::c_int as uint32_t {
        credits_index += 1;
        credits_index;
        CredFrame = 0 as libc::c_int as uint32_t;
    }
    unlock_buf(0 as libc::c_int as uint8_t);
    force_redraw = FULLDRAW as libc::c_int;
    FullBlit(0 as libc::c_int as bool32_t);
}
#[no_mangle]
pub unsafe extern "C" fn GM_Credits(mut event: *mut SDL_Event) {
    match (*event).type_0 {
        1025 => {
            gbRunGame = 0 as libc::c_int as bool32_t;
        }
        768 => {
            if (*event).key.keysym.sym == SDLK_RETURN as libc::c_int
                || (*event).key.keysym.sym == SDLK_SPACE as libc::c_int
                || (*event).key.keysym.sym == SDLK_ESCAPE as libc::c_int
            {
                gbRunGame = 0 as libc::c_int as bool32_t;
            }
        }
        _ => {}
    }
    UiWndProc(event);
}
#[no_mangle]
pub unsafe extern "C" fn UiCreditsDialog(mut pixelspersec: uint32_t) -> bool32_t {
    let mut saveProc: SDLPROC = None;
    credits_index = 0 as libc::c_int;
    saveProc = my_SetWindowProc(
        Some(GM_Credits as unsafe extern "C" fn(*mut SDL_Event) -> ()),
    );
    InitCreditsMenu();
    CredTicks = SDL_GetTicks();
    CredFrame = 0 as libc::c_int as uint32_t;
    interface_pump_credits_message();
    PaletteFadeIn(FADE_MED as libc::c_int);
    InitDialogLoop();
    gbRunGame = 1 as libc::c_int as bool32_t;
    while gbRunGame != 0 {
        PumpUiMessage(
            Some(interface_pump_credits_message as unsafe extern "C" fn() -> ()),
        );
    }
    PaletteFadeOut(FADE_MED as libc::c_int);
    saveProc = my_SetWindowProc(saveProc);
    FreeCreditsMenu();
    return 1 as libc::c_int as bool32_t;
}
