use ::libc;
extern "C" {
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn memset(
        _: *mut libc::c_void,
        _: libc::c_int,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn strlen(_: *const libc::c_char) -> libc::c_ulong;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn LoadFileInMem(
        pszName: *const libc::c_char,
        pdwFileLen: *mut uint32_t,
    ) -> *mut uint8_t;
    fn DiabloAllocPtr(dwBytes: uint32_t) -> *mut uint8_t;
    static mut gpPalette: [uint32_t; 256];
    static mut gpBuffer: *mut uint32_t;
    fn LoadArtImage(
        pszFile: *const libc::c_char,
        frames: libc::c_int,
        pImage: *mut TARTIMAGE,
    ) -> bool32_t;
}
pub type C2RustUnnamed = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed = 92160;
pub const BTMBUFFY: C2RustUnnamed = 144;
pub const BTMBUFFX: C2RustUnnamed = 640;
pub const BUFFERSIZE: C2RustUnnamed = 503808;
pub const BUFFERY: C2RustUnnamed = 656;
pub const BUFFERX: C2RustUnnamed = 768;
pub const GAMEY: C2RustUnnamed = 352;
pub const CTRLPANY: C2RustUnnamed = 128;
pub const TOTALY: C2RustUnnamed = 480;
pub const TOTALX: C2RustUnnamed = 640;
pub const MAX_PLRS: C2RustUnnamed = 4;
pub type __uint8_t = libc::c_uchar;
pub type __uint32_t = libc::c_uint;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type bool32_t = uint32_t;
pub type _artfonts = libc::c_uint;
pub const AF_HUGEGRAY: _artfonts = 7;
pub const AF_HUGE: _artfonts = 6;
pub const AF_BIGGRAY: _artfonts = 5;
pub const AF_BIG: _artfonts = 4;
pub const AF_MEDGRAY: _artfonts = 3;
pub const AF_MED: _artfonts = 2;
pub const AF_SMALLGRAY: _artfonts = 1;
pub const AF_SMALL: _artfonts = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _artimage {
    pub pData: *mut uint8_t,
    pub nWidth: libc::c_int,
    pub nHeight: libc::c_int,
    pub nFrames: libc::c_int,
    pub bTrans: bool32_t,
    pub bMask: uint8_t,
}
pub type TARTIMAGE = _artimage;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct UIRECT {
    pub x: libc::c_int,
    pub y: libc::c_int,
    pub w: libc::c_int,
    pub h: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _fontspecs {
    pub bCharWidth: uint8_t,
    pub bCharHeight: uint8_t,
    pub bCharWidths: [uint8_t; 256],
}
pub type TFONTSPECS = _fontspecs;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct _artfont {
    pub tFontSpecs: TFONTSPECS,
    pub pCharData: [*mut uint8_t; 256],
    pub bValid: bool32_t,
}
pub type TARTFONT = _artfont;
#[no_mangle]
pub static mut font42g: TARTFONT = _artfont {
    tFontSpecs: _fontspecs {
        bCharWidth: 0,
        bCharHeight: 0,
        bCharWidths: [0; 256],
    },
    pCharData: [0 as *const uint8_t as *mut uint8_t; 256],
    bValid: 0,
};
#[no_mangle]
pub static mut sgpFont: *mut TARTFONT = 0 as *const TARTFONT as *mut TARTFONT;
#[no_mangle]
pub static mut font30g: TARTFONT = _artfont {
    tFontSpecs: _fontspecs {
        bCharWidth: 0,
        bCharHeight: 0,
        bCharWidths: [0; 256],
    },
    pCharData: [0 as *const uint8_t as *mut uint8_t; 256],
    bValid: 0,
};
#[no_mangle]
pub static mut font16s: TARTFONT = _artfont {
    tFontSpecs: _fontspecs {
        bCharWidth: 0,
        bCharHeight: 0,
        bCharWidths: [0; 256],
    },
    pCharData: [0 as *const uint8_t as *mut uint8_t; 256],
    bValid: 0,
};
#[no_mangle]
pub static mut font24s: TARTFONT = _artfont {
    tFontSpecs: _fontspecs {
        bCharWidth: 0,
        bCharHeight: 0,
        bCharWidths: [0; 256],
    },
    pCharData: [0 as *const uint8_t as *mut uint8_t; 256],
    bValid: 0,
};
#[no_mangle]
pub static mut font16g: TARTFONT = _artfont {
    tFontSpecs: _fontspecs {
        bCharWidth: 0,
        bCharHeight: 0,
        bCharWidths: [0; 256],
    },
    pCharData: [0 as *const uint8_t as *mut uint8_t; 256],
    bValid: 0,
};
#[no_mangle]
pub static mut font24g: TARTFONT = _artfont {
    tFontSpecs: _fontspecs {
        bCharWidth: 0,
        bCharHeight: 0,
        bCharWidths: [0; 256],
    },
    pCharData: [0 as *const uint8_t as *mut uint8_t; 256],
    bValid: 0,
};
#[no_mangle]
pub static mut font30s: TARTFONT = _artfont {
    tFontSpecs: _fontspecs {
        bCharWidth: 0,
        bCharHeight: 0,
        bCharWidths: [0; 256],
    },
    pCharData: [0 as *const uint8_t as *mut uint8_t; 256],
    bValid: 0,
};
#[no_mangle]
pub static mut font42y: TARTFONT = _artfont {
    tFontSpecs: _fontspecs {
        bCharWidth: 0,
        bCharHeight: 0,
        bCharWidths: [0; 256],
    },
    pCharData: [0 as *const uint8_t as *mut uint8_t; 256],
    bValid: 0,
};
#[no_mangle]
pub static mut temp_global_width: libc::c_int = 0 as libc::c_int;
#[no_mangle]
pub static mut remap: [uint8_t; 16] = [
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    0 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    1 as libc::c_int as uint8_t,
    2 as libc::c_int as uint8_t,
    3 as libc::c_int as uint8_t,
    6 as libc::c_int as uint8_t,
    10 as libc::c_int as uint8_t,
    13 as libc::c_int as uint8_t,
];
#[no_mangle]
pub unsafe extern "C" fn SetArtFont(mut font: libc::c_int) {
    match font {
        0 => {
            sgpFont = &mut font16g;
            temp_global_width = 16 as libc::c_int;
        }
        1 => {
            sgpFont = &mut font16s;
            temp_global_width = 16 as libc::c_int;
        }
        2 => {
            sgpFont = &mut font24g;
            temp_global_width = 24 as libc::c_int;
        }
        3 => {
            sgpFont = &mut font24s;
            temp_global_width = 24 as libc::c_int;
        }
        4 => {
            sgpFont = &mut font30g;
            temp_global_width = 32 as libc::c_int;
        }
        5 => {
            sgpFont = &mut font30s;
            temp_global_width = 32 as libc::c_int;
        }
        6 => {
            sgpFont = &mut font42g;
            temp_global_width = 40 as libc::c_int;
        }
        7 => {
            sgpFont = &mut font42y;
            temp_global_width = 44 as libc::c_int;
        }
        _ => {
            sgpFont = &mut font16s;
            temp_global_width = 16 as libc::c_int;
        }
    };
}
#[no_mangle]
pub unsafe extern "C" fn InitArtFonts() {
    font42g.bValid = 0 as libc::c_int as bool32_t;
    font42y.bValid = 0 as libc::c_int as bool32_t;
    font30g.bValid = 0 as libc::c_int as bool32_t;
    font30s.bValid = 0 as libc::c_int as bool32_t;
    font24g.bValid = 0 as libc::c_int as bool32_t;
    font24s.bValid = 0 as libc::c_int as bool32_t;
    font16g.bValid = 0 as libc::c_int as bool32_t;
    font16s.bValid = 0 as libc::c_int as bool32_t;
    sgpFont = 0 as *mut TARTFONT;
}
#[no_mangle]
pub unsafe extern "C" fn FreeAllFonts() {
    FreeArtFont(&mut font42g);
    FreeArtFont(&mut font42y);
    FreeArtFont(&mut font30g);
    FreeArtFont(&mut font30s);
    FreeArtFont(&mut font24g);
    FreeArtFont(&mut font24s);
    FreeArtFont(&mut font16g);
    FreeArtFont(&mut font16s);
    sgpFont = 0 as *mut TARTFONT;
}
#[no_mangle]
pub unsafe extern "C" fn FreeArtFont(mut pFont: *mut TARTFONT) {
    let mut i: libc::c_int = 0;
    if (*pFont).bValid == 0 {
        return;
    }
    i = 0 as libc::c_int;
    while i < 256 as libc::c_int {
        let mut p__p: *mut libc::c_void = (*pFont).pCharData[i as usize]
            as *mut libc::c_void;
        (*pFont).pCharData[i as usize] = 0 as *mut uint8_t;
        mem_free_dbg(p__p);
        i += 1;
        i;
    }
    (*pFont).bValid = 0 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn LoadAllFonts() -> bool32_t {
    LoadArtFont(
        &mut font30g,
        b"ui_art\\font30.bin\0" as *const u8 as *const libc::c_char,
        b"ui_art\\font30g.pcx\0" as *const u8 as *const libc::c_char,
    );
    LoadArtFont(
        &mut font30s,
        b"ui_art\\font30.bin\0" as *const u8 as *const libc::c_char,
        b"ui_art\\font30s.pcx\0" as *const u8 as *const libc::c_char,
    );
    LoadArtFont(
        &mut font24g,
        b"ui_art\\font24.bin\0" as *const u8 as *const libc::c_char,
        b"ui_art\\font24g.pcx\0" as *const u8 as *const libc::c_char,
    );
    LoadArtFont(
        &mut font24s,
        b"ui_art\\font24.bin\0" as *const u8 as *const libc::c_char,
        b"ui_art\\font24s.pcx\0" as *const u8 as *const libc::c_char,
    );
    LoadArtFont(
        &mut font16g,
        b"ui_art\\font16.bin\0" as *const u8 as *const libc::c_char,
        b"ui_art\\font16g.pcx\0" as *const u8 as *const libc::c_char,
    );
    LoadArtFont(
        &mut font16s,
        b"ui_art\\font16.bin\0" as *const u8 as *const libc::c_char,
        b"ui_art\\font16s.pcx\0" as *const u8 as *const libc::c_char,
    );
    LoadArtFont(
        &mut font42g,
        b"ui_art\\font42.bin\0" as *const u8 as *const libc::c_char,
        b"ui_art\\font42g.pcx\0" as *const u8 as *const libc::c_char,
    );
    LoadArtFont(
        &mut font42y,
        b"ui_art\\font42.bin\0" as *const u8 as *const libc::c_char,
        b"ui_art\\font42y.pcx\0" as *const u8 as *const libc::c_char,
    );
    return 1 as libc::c_int as bool32_t;
}
#[no_mangle]
pub unsafe extern "C" fn LoadArtFont(
    mut pFont: *mut TARTFONT,
    mut szSpecs: *const libc::c_char,
    mut szFile: *const libc::c_char,
) {
    let mut pBuffer: *mut uint8_t = 0 as *mut uint8_t;
    let mut i: libc::c_int = 0;
    let mut pImage: TARTIMAGE = _artimage {
        pData: 0 as *mut uint8_t,
        nWidth: 0,
        nHeight: 0,
        nFrames: 0,
        bTrans: 0,
        bMask: 0,
    };
    let mut glyphsize: libc::c_int = 0;
    if (*pFont).bValid != 0 {
        return;
    }
    memset(
        &mut pImage as *mut TARTIMAGE as *mut libc::c_void,
        0 as libc::c_int,
        ::core::mem::size_of::<TARTIMAGE>() as libc::c_ulong,
    );
    pBuffer = LoadFileInMem(szSpecs, 0 as *mut uint32_t);
    memcpy(
        &mut (*pFont).tFontSpecs as *mut TFONTSPECS as *mut libc::c_void,
        pBuffer as *const libc::c_void,
        ::core::mem::size_of::<TFONTSPECS>() as libc::c_ulong,
    );
    let mut p__p: *mut libc::c_void = pBuffer as *mut libc::c_void;
    pBuffer = 0 as *mut uint8_t;
    mem_free_dbg(p__p);
    LoadArtImage(szFile, 256 as libc::c_int, &mut pImage);
    pImage.nHeight /= 256 as libc::c_int;
    i = 0 as libc::c_int;
    while i < 256 as libc::c_int {
        (*pFont).pCharData[i as usize] = 0 as *mut uint8_t;
        i += 1;
        i;
    }
    glyphsize = pImage.nWidth * pImage.nHeight;
    i = 0 as libc::c_int;
    while i < 256 as libc::c_int {
        if (*pFont).tFontSpecs.bCharWidths[i as usize] != 0 {
            (*pFont).pCharData[i as usize] = DiabloAllocPtr(glyphsize as uint32_t);
            memcpy(
                (*pFont).pCharData[i as usize] as *mut libc::c_void,
                &mut *(pImage.pData).offset((glyphsize * i) as isize) as *mut uint8_t
                    as *const libc::c_void,
                glyphsize as libc::c_ulong,
            );
        }
        i += 1;
        i;
    }
    (*pFont).bValid = 1 as libc::c_int as bool32_t;
    let mut p__p_0: *mut libc::c_void = pImage.pData as *mut libc::c_void;
    pImage.pData = 0 as *mut uint8_t;
    mem_free_dbg(p__p_0);
}
#[no_mangle]
pub unsafe extern "C" fn GetFontHeight() -> libc::c_int {
    if sgpFont.is_null() {
        return 0 as libc::c_int;
    }
    if (*sgpFont).bValid != 0 {
        return (*sgpFont).tFontSpecs.bCharHeight as libc::c_int;
    }
    return 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn GetFontWidth() -> libc::c_int {
    if sgpFont.is_null() {
        return 0 as libc::c_int;
    }
    if (*sgpFont).bValid != 0 {
        return (*sgpFont).tFontSpecs.bCharWidth as libc::c_int;
    }
    return 0 as libc::c_int;
}
#[no_mangle]
pub unsafe extern "C" fn GetFontStrWidth(
    mut pszStr: *const libc::c_char,
) -> libc::c_int {
    let mut len: libc::c_int = 0;
    let mut v2: *const libc::c_char = 0 as *const libc::c_char;
    let mut i: uint8_t = 0;
    let mut v4: uint8_t = 0;
    let mut v5: libc::c_int = 0;
    len = 0 as libc::c_int;
    if !sgpFont.is_null() {
        if (*sgpFont).bValid != 0 {
            v2 = pszStr;
            i = *pszStr as uint8_t;
            while i != 0 {
                v4 = (*sgpFont).tFontSpecs.bCharWidths[i as usize];
                if v4 != 0 {
                    v5 = v4 as libc::c_int;
                } else {
                    v5 = (*sgpFont).tFontSpecs.bCharWidth as libc::c_int;
                }
                i = *v2.offset(1 as libc::c_int as isize) as uint8_t;
                len += v5;
                v2 = v2.offset(1);
                v2;
            }
        } else {
            len = 0 as libc::c_int;
        }
    }
    return len;
}
#[no_mangle]
pub unsafe extern "C" fn GetWidthUntilBreak(
    mut pszStr: *const libc::c_char,
) -> libc::c_int {
    let mut result: libc::c_int = 0;
    let mut v2: *mut uint8_t = 0 as *mut uint8_t;
    let mut v3: uint8_t = 0;
    result = 0 as libc::c_int;
    if !sgpFont.is_null() {
        if (*sgpFont).bValid != 0 {
            v2 = pszStr as *mut uint8_t;
            while !(*v2 as libc::c_int == '\0' as i32) {
                if *v2 as libc::c_int == '\n' as i32 {
                    break;
                } else if *v2 as libc::c_int == ' ' as i32 {
                    break;
                } else {
                    v3 = (*sgpFont).tFontSpecs.bCharWidths[*v2 as usize];
                    if v3 as libc::c_int == 0 as libc::c_int {
                        break;
                    }
                    result += v3 as libc::c_int;
                    v2 = v2.offset(1);
                    v2;
                }
            }
        } else {
            result = 0 as libc::c_int;
        }
    }
    return result;
}
#[no_mangle]
pub unsafe extern "C" fn DrawArtFont2(
    mut SX: libc::c_int,
    mut SY: libc::c_int,
    mut glyph: uint8_t,
) {
    let mut src: *mut uint8_t = (*sgpFont).pCharData[glyph as usize];
    let mut dst: *mut uint32_t = &mut *gpBuffer
        .offset(
            (SX + 64 as libc::c_int + (SY + 160 as libc::c_int) * BUFFERX as libc::c_int)
                as isize,
        ) as *mut uint32_t;
    let mut w: libc::c_int = temp_global_width;
    let mut h: libc::c_int = (*sgpFont).tFontSpecs.bCharHeight as libc::c_int;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < h {
        let mut j: libc::c_int = 0 as libc::c_int;
        while j < w {
            if *src.offset(j as isize) as libc::c_int != 32 as libc::c_int {
                *dst.offset(j as isize) = gpPalette[*src.offset(j as isize) as usize];
            }
            j += 1;
            j;
        }
        i += 1;
        i;
        src = src.offset(w as isize);
        dst = dst.offset(768 as libc::c_int as isize);
    }
}
#[no_mangle]
pub unsafe extern "C" fn PrintArtFont(
    mut str: *const libc::c_char,
    mut x: libc::c_int,
    mut y: libc::c_int,
) {
    if sgpFont.is_null() || (*sgpFont).bValid == 0 {
        return;
    }
    let mut i: libc::c_int = 0;
    let mut len: libc::c_int = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < strlen(str) as libc::c_int {
        if !((*sgpFont).pCharData[*str.offset(i as isize) as uint8_t as usize]).is_null()
        {
            DrawArtFont2(x + len, y, *str.offset(i as isize) as uint8_t);
            len
                += (*sgpFont)
                    .tFontSpecs
                    .bCharWidths[*str.offset(i as isize) as uint8_t as usize]
                    as libc::c_int;
        } else {
            len += (*sgpFont).tFontSpecs.bCharWidth as libc::c_int;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn DrawArtFontCred(
    mut SX: libc::c_int,
    mut SY: libc::c_int,
    mut glyph: uint8_t,
    mut y1: libc::c_int,
    mut y2: libc::c_int,
) {
    let mut src: *mut uint8_t = (*sgpFont).pCharData[glyph as usize];
    let mut dst: *mut uint32_t = &mut *gpBuffer
        .offset(
            (SX + 64 as libc::c_int + (SY + 160 as libc::c_int) * BUFFERX as libc::c_int)
                as isize,
        ) as *mut uint32_t;
    let mut w: libc::c_int = temp_global_width;
    let mut h: libc::c_int = (*sgpFont).tFontSpecs.bCharHeight as libc::c_int;
    let mut pStart: *mut uint32_t = &mut *gpBuffer
        .offset(
            (-(64 as libc::c_int) + 64 as libc::c_int
                + (y1 + 160 as libc::c_int) * BUFFERX as libc::c_int) as isize,
        ) as *mut uint32_t;
    let mut pEnd: *mut uint32_t = &mut *gpBuffer
        .offset(
            (-(64 as libc::c_int) + 64 as libc::c_int
                + (y2 + 160 as libc::c_int) * BUFFERX as libc::c_int) as isize,
        ) as *mut uint32_t;
    let mut i: libc::c_int = 0 as libc::c_int;
    while i < h {
        let mut j: libc::c_int = 0 as libc::c_int;
        while j < w {
            if dst >= pStart && dst <= pEnd {
                if *src.offset(j as isize) as libc::c_int != 32 as libc::c_int {
                    *dst
                        .offset(
                            j as isize,
                        ) = gpPalette[(remap[(*src.offset(j as isize) as libc::c_int
                        & 0xf as libc::c_int) as usize] as libc::c_int
                        + 224 as libc::c_int) as usize];
                }
            }
            j += 1;
            j;
        }
        i += 1;
        i;
        src = src.offset(w as isize);
        dst = dst.offset(768 as libc::c_int as isize);
    }
}
#[no_mangle]
pub unsafe extern "C" fn PrintArtFontCred(
    mut str: *const libc::c_char,
    mut x: libc::c_int,
    mut y: libc::c_int,
    mut y1: libc::c_int,
    mut y2: libc::c_int,
) {
    if sgpFont.is_null() || (*sgpFont).bValid == 0 {
        return;
    }
    let mut i: libc::c_int = 0;
    let mut len: libc::c_int = 0 as libc::c_int;
    i = 0 as libc::c_int;
    while i < strlen(str) as libc::c_int {
        if !((*sgpFont).pCharData[*str.offset(i as isize) as uint8_t as usize]).is_null()
        {
            DrawArtFontCred(x + len, y, *str.offset(i as isize) as uint8_t, y1, y2);
            len
                += (*sgpFont)
                    .tFontSpecs
                    .bCharWidths[*str.offset(i as isize) as uint8_t as usize]
                    as libc::c_int;
        } else {
            len += (*sgpFont).tFontSpecs.bCharWidth as libc::c_int;
        }
        i += 1;
        i;
    }
}
#[no_mangle]
pub unsafe extern "C" fn PrintArtFontC(
    mut str: *const libc::c_char,
    mut x: libc::c_int,
    mut y: libc::c_int,
) {
    let mut w: libc::c_int = GetFontStrWidth(str);
    PrintArtFont(
        str,
        640 as libc::c_int / 2 as libc::c_int - w / 2 as libc::c_int + x,
        y,
    );
}
#[no_mangle]
pub unsafe extern "C" fn PrintArtFontB(
    mut pszStr: *const libc::c_char,
    mut pRect: *mut UIRECT,
    mut sx: libc::c_int,
    mut sy: libc::c_int,
) {
    let mut c: uint8_t = 0;
    if sgpFont.is_null() || (*sgpFont).bValid == 0 {
        return;
    }
    if sx < 0 as libc::c_int {
        sx = 0 as libc::c_int;
    }
    if sy < 0 as libc::c_int {
        sy = 0 as libc::c_int;
    }
    while *pszStr as libc::c_int != '\0' as i32 {
        if sy + (*sgpFont).tFontSpecs.bCharHeight as libc::c_int > (*pRect).h {
            return;
        }
        c = *pszStr as uint8_t;
        if c as libc::c_int == '\n' as i32 {
            sx = 0 as libc::c_int;
            sy += (*sgpFont).tFontSpecs.bCharHeight as libc::c_int;
            pszStr = pszStr.offset(1);
            pszStr;
        } else if (*sgpFont).tFontSpecs.bCharWidths[c as usize] as libc::c_int
            == 0 as libc::c_int
        {
            pszStr = pszStr.offset(1);
            if sx + (*sgpFont).tFontSpecs.bCharWidth as libc::c_int
                + GetWidthUntilBreak(pszStr) < (*pRect).w
            {
                sx += (*sgpFont).tFontSpecs.bCharWidth as libc::c_int;
            } else {
                sx = 0 as libc::c_int;
                sy += (*sgpFont).tFontSpecs.bCharHeight as libc::c_int;
            }
        } else if !((*sgpFont).pCharData[c as usize]).is_null() {
            if sx + (*sgpFont).tFontSpecs.bCharWidths[c as usize] as libc::c_int
                <= (*pRect).w
            {
                DrawArtFont2(sx + (*pRect).x, sy + (*pRect).y, c);
                sx += (*sgpFont).tFontSpecs.bCharWidths[c as usize] as libc::c_int;
                pszStr = pszStr.offset(1);
                pszStr;
            } else {
                sx = 0 as libc::c_int;
                sy += (*sgpFont).tFontSpecs.bCharHeight as libc::c_int;
            }
        }
    }
}
