use ::libc;
extern "C" {
    pub type SDL_BlitMap;
    pub type SDL_Window;
    pub type SDL_Renderer;
    pub type SDL_Texture;
    fn SDL_setenv(
        name: *const libc::c_char,
        value: *const libc::c_char,
        overwrite: libc::c_int,
    ) -> libc::c_int;
    fn memcpy(
        _: *mut libc::c_void,
        _: *const libc::c_void,
        _: libc::c_ulong,
    ) -> *mut libc::c_void;
    fn atexit(__func: Option::<unsafe extern "C" fn() -> ()>) -> libc::c_int;
    fn SDL_Quit();
    fn SDL_CreateRGBSurface(
        flags: Uint32,
        width: libc::c_int,
        height: libc::c_int,
        depth: libc::c_int,
        Rmask: Uint32,
        Gmask: Uint32,
        Bmask: Uint32,
        Amask: Uint32,
    ) -> *mut SDL_Surface;
    fn SDL_SetWindowTitle(window: *mut SDL_Window, title: *const libc::c_char);
    fn SDL_WarpMouseInWindow(window: *mut SDL_Window, x: libc::c_int, y: libc::c_int);
    fn SDL_ShowCursor(toggle: libc::c_int) -> libc::c_int;
    fn SDL_Init(flags: Uint32) -> libc::c_int;
    fn SDL_RenderPresent(renderer: *mut SDL_Renderer);
    fn SDL_CreateWindowAndRenderer(
        width: libc::c_int,
        height: libc::c_int,
        window_flags: Uint32,
        window: *mut *mut SDL_Window,
        renderer: *mut *mut SDL_Renderer,
    ) -> libc::c_int;
    fn SDL_CreateTexture(
        renderer: *mut SDL_Renderer,
        format: Uint32,
        access: libc::c_int,
        w: libc::c_int,
        h: libc::c_int,
    ) -> *mut SDL_Texture;
    fn SDL_UpdateTexture(
        texture: *mut SDL_Texture,
        rect: *const SDL_Rect,
        pixels: *const libc::c_void,
        pitch: libc::c_int,
    ) -> libc::c_int;
    fn SDL_RenderClear(renderer: *mut SDL_Renderer) -> libc::c_int;
    fn SDL_RenderCopy(
        renderer: *mut SDL_Renderer,
        texture: *mut SDL_Texture,
        srcrect: *const SDL_Rect,
        dstrect: *const SDL_Rect,
    ) -> libc::c_int;
    fn app_fatal_(
        file: *const libc::c_char,
        line: libc::c_int,
        pszFmt: *const libc::c_char,
        _: ...
    ) -> !;
    fn assert_fail(
        nLineNo: libc::c_int,
        pszFile: *const libc::c_char,
        pszFail: *const libc::c_char,
    );
    fn DiabloAllocPtr(dwBytes: uint32_t) -> *mut uint8_t;
    fn mem_free_dbg(p: *mut libc::c_void);
    fn interface_msg_pump();
    fn savecrsr_reset();
    static mut fullscreen: bool32_t;
    static mut force_redraw: libc::c_int;
    static mut gszAppName: *const libc::c_char;
    static mut bActive: bool32_t;
    static mut gpBuffer: *mut uint32_t;
}
pub type __uint8_t = libc::c_uchar;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type int32_t = __int32_t;
pub type uint8_t = __uint8_t;
pub type uint32_t = __uint32_t;
pub type Uint8 = uint8_t;
pub type Uint32 = uint32_t;
pub type C2RustUnnamed = libc::c_uint;
pub const SDL_PIXELFORMAT_EXTERNAL_OES: C2RustUnnamed = 542328143;
pub const SDL_PIXELFORMAT_NV21: C2RustUnnamed = 825382478;
pub const SDL_PIXELFORMAT_NV12: C2RustUnnamed = 842094158;
pub const SDL_PIXELFORMAT_YVYU: C2RustUnnamed = 1431918169;
pub const SDL_PIXELFORMAT_UYVY: C2RustUnnamed = 1498831189;
pub const SDL_PIXELFORMAT_YUY2: C2RustUnnamed = 844715353;
pub const SDL_PIXELFORMAT_IYUV: C2RustUnnamed = 1448433993;
pub const SDL_PIXELFORMAT_YV12: C2RustUnnamed = 842094169;
pub const SDL_PIXELFORMAT_ABGR32: C2RustUnnamed = 373694468;
pub const SDL_PIXELFORMAT_BGRA32: C2RustUnnamed = 372645892;
pub const SDL_PIXELFORMAT_ARGB32: C2RustUnnamed = 377888772;
pub const SDL_PIXELFORMAT_RGBA32: C2RustUnnamed = 376840196;
pub const SDL_PIXELFORMAT_ARGB2101010: C2RustUnnamed = 372711428;
pub const SDL_PIXELFORMAT_BGRA8888: C2RustUnnamed = 377888772;
pub const SDL_PIXELFORMAT_ABGR8888: C2RustUnnamed = 376840196;
pub const SDL_PIXELFORMAT_RGBA8888: C2RustUnnamed = 373694468;
pub const SDL_PIXELFORMAT_ARGB8888: C2RustUnnamed = 372645892;
pub const SDL_PIXELFORMAT_BGRX8888: C2RustUnnamed = 375789572;
pub const SDL_PIXELFORMAT_BGR888: C2RustUnnamed = 374740996;
pub const SDL_PIXELFORMAT_XBGR8888: C2RustUnnamed = 374740996;
pub const SDL_PIXELFORMAT_RGBX8888: C2RustUnnamed = 371595268;
pub const SDL_PIXELFORMAT_RGB888: C2RustUnnamed = 370546692;
pub const SDL_PIXELFORMAT_XRGB8888: C2RustUnnamed = 370546692;
pub const SDL_PIXELFORMAT_BGR24: C2RustUnnamed = 390076419;
pub const SDL_PIXELFORMAT_RGB24: C2RustUnnamed = 386930691;
pub const SDL_PIXELFORMAT_BGR565: C2RustUnnamed = 357896194;
pub const SDL_PIXELFORMAT_RGB565: C2RustUnnamed = 353701890;
pub const SDL_PIXELFORMAT_BGRA5551: C2RustUnnamed = 360976386;
pub const SDL_PIXELFORMAT_ABGR1555: C2RustUnnamed = 359862274;
pub const SDL_PIXELFORMAT_RGBA5551: C2RustUnnamed = 356782082;
pub const SDL_PIXELFORMAT_ARGB1555: C2RustUnnamed = 355667970;
pub const SDL_PIXELFORMAT_BGRA4444: C2RustUnnamed = 360845314;
pub const SDL_PIXELFORMAT_ABGR4444: C2RustUnnamed = 359796738;
pub const SDL_PIXELFORMAT_RGBA4444: C2RustUnnamed = 356651010;
pub const SDL_PIXELFORMAT_ARGB4444: C2RustUnnamed = 355602434;
pub const SDL_PIXELFORMAT_BGR555: C2RustUnnamed = 357764866;
pub const SDL_PIXELFORMAT_XBGR1555: C2RustUnnamed = 357764866;
pub const SDL_PIXELFORMAT_RGB555: C2RustUnnamed = 353570562;
pub const SDL_PIXELFORMAT_XRGB1555: C2RustUnnamed = 353570562;
pub const SDL_PIXELFORMAT_BGR444: C2RustUnnamed = 357698562;
pub const SDL_PIXELFORMAT_XBGR4444: C2RustUnnamed = 357698562;
pub const SDL_PIXELFORMAT_RGB444: C2RustUnnamed = 353504258;
pub const SDL_PIXELFORMAT_XRGB4444: C2RustUnnamed = 353504258;
pub const SDL_PIXELFORMAT_RGB332: C2RustUnnamed = 336660481;
pub const SDL_PIXELFORMAT_INDEX8: C2RustUnnamed = 318769153;
pub const SDL_PIXELFORMAT_INDEX4MSB: C2RustUnnamed = 304088064;
pub const SDL_PIXELFORMAT_INDEX4LSB: C2RustUnnamed = 303039488;
pub const SDL_PIXELFORMAT_INDEX1MSB: C2RustUnnamed = 287310080;
pub const SDL_PIXELFORMAT_INDEX1LSB: C2RustUnnamed = 286261504;
pub const SDL_PIXELFORMAT_UNKNOWN: C2RustUnnamed = 0;
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_Color {
    pub r: Uint8,
    pub g: Uint8,
    pub b: Uint8,
    pub a: Uint8,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_Palette {
    pub ncolors: libc::c_int,
    pub colors: *mut SDL_Color,
    pub version: Uint32,
    pub refcount: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_PixelFormat {
    pub format: Uint32,
    pub palette: *mut SDL_Palette,
    pub BitsPerPixel: Uint8,
    pub BytesPerPixel: Uint8,
    pub padding: [Uint8; 2],
    pub Rmask: Uint32,
    pub Gmask: Uint32,
    pub Bmask: Uint32,
    pub Amask: Uint32,
    pub Rloss: Uint8,
    pub Gloss: Uint8,
    pub Bloss: Uint8,
    pub Aloss: Uint8,
    pub Rshift: Uint8,
    pub Gshift: Uint8,
    pub Bshift: Uint8,
    pub Ashift: Uint8,
    pub refcount: libc::c_int,
    pub next: *mut SDL_PixelFormat,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_Rect {
    pub x: libc::c_int,
    pub y: libc::c_int,
    pub w: libc::c_int,
    pub h: libc::c_int,
}
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SDL_Surface {
    pub flags: Uint32,
    pub format: *mut SDL_PixelFormat,
    pub w: libc::c_int,
    pub h: libc::c_int,
    pub pitch: libc::c_int,
    pub pixels: *mut libc::c_void,
    pub userdata: *mut libc::c_void,
    pub locked: libc::c_int,
    pub list_blitmap: *mut libc::c_void,
    pub clip_rect: SDL_Rect,
    pub map: *mut SDL_BlitMap,
    pub refcount: libc::c_int,
}
pub type C2RustUnnamed_0 = libc::c_uint;
pub const SDL_WINDOW_INPUT_GRABBED: C2RustUnnamed_0 = 256;
pub const SDL_WINDOW_METAL: C2RustUnnamed_0 = 536870912;
pub const SDL_WINDOW_VULKAN: C2RustUnnamed_0 = 268435456;
pub const SDL_WINDOW_KEYBOARD_GRABBED: C2RustUnnamed_0 = 1048576;
pub const SDL_WINDOW_POPUP_MENU: C2RustUnnamed_0 = 524288;
pub const SDL_WINDOW_TOOLTIP: C2RustUnnamed_0 = 262144;
pub const SDL_WINDOW_UTILITY: C2RustUnnamed_0 = 131072;
pub const SDL_WINDOW_SKIP_TASKBAR: C2RustUnnamed_0 = 65536;
pub const SDL_WINDOW_ALWAYS_ON_TOP: C2RustUnnamed_0 = 32768;
pub const SDL_WINDOW_MOUSE_CAPTURE: C2RustUnnamed_0 = 16384;
pub const SDL_WINDOW_ALLOW_HIGHDPI: C2RustUnnamed_0 = 8192;
pub const SDL_WINDOW_FOREIGN: C2RustUnnamed_0 = 2048;
pub const SDL_WINDOW_FULLSCREEN_DESKTOP: C2RustUnnamed_0 = 4097;
pub const SDL_WINDOW_MOUSE_FOCUS: C2RustUnnamed_0 = 1024;
pub const SDL_WINDOW_INPUT_FOCUS: C2RustUnnamed_0 = 512;
pub const SDL_WINDOW_MOUSE_GRABBED: C2RustUnnamed_0 = 256;
pub const SDL_WINDOW_MAXIMIZED: C2RustUnnamed_0 = 128;
pub const SDL_WINDOW_MINIMIZED: C2RustUnnamed_0 = 64;
pub const SDL_WINDOW_RESIZABLE: C2RustUnnamed_0 = 32;
pub const SDL_WINDOW_BORDERLESS: C2RustUnnamed_0 = 16;
pub const SDL_WINDOW_HIDDEN: C2RustUnnamed_0 = 8;
pub const SDL_WINDOW_SHOWN: C2RustUnnamed_0 = 4;
pub const SDL_WINDOW_OPENGL: C2RustUnnamed_0 = 2;
pub const SDL_WINDOW_FULLSCREEN: C2RustUnnamed_0 = 1;
pub type C2RustUnnamed_1 = libc::c_uint;
pub const SDL_TEXTUREACCESS_TARGET: C2RustUnnamed_1 = 2;
pub const SDL_TEXTUREACCESS_STREAMING: C2RustUnnamed_1 = 1;
pub const SDL_TEXTUREACCESS_STATIC: C2RustUnnamed_1 = 0;
pub type C2RustUnnamed_2 = libc::c_uint;
pub const BTMBUFFMULTISIZE: C2RustUnnamed_2 = 184320;
pub const BTMBUFFSIZE: C2RustUnnamed_2 = 92160;
pub const BTMBUFFY: C2RustUnnamed_2 = 144;
pub const BTMBUFFX: C2RustUnnamed_2 = 640;
pub const BUFFERSIZE: C2RustUnnamed_2 = 503808;
pub const BUFFERY: C2RustUnnamed_2 = 656;
pub const BUFFERX: C2RustUnnamed_2 = 768;
pub const GAMEY: C2RustUnnamed_2 = 352;
pub const CTRLPANY: C2RustUnnamed_2 = 128;
pub const TOTALY: C2RustUnnamed_2 = 480;
pub const TOTALX: C2RustUnnamed_2 = 640;
pub const MAX_PLRS: C2RustUnnamed_2 = 4;
pub type C2RustUnnamed_3 = libc::c_uint;
pub const FULLDRAW: C2RustUnnamed_3 = 255;
pub const VIEWDRAW: C2RustUnnamed_3 = 1;
pub const NODRAW: C2RustUnnamed_3 = 0;
pub type bool32_t = uint32_t;
static mut sdlWindow: *mut SDL_Window = 0 as *const SDL_Window as *mut SDL_Window;
static mut sdlRenderer: *mut SDL_Renderer = 0 as *const SDL_Renderer
    as *mut SDL_Renderer;
static mut sdlSurface: *mut SDL_Surface = 0 as *const SDL_Surface as *mut SDL_Surface;
static mut sdlTexture: *mut SDL_Texture = 0 as *const SDL_Texture as *mut SDL_Texture;
#[no_mangle]
pub unsafe extern "C" fn lock_buf(mut bFcn: uint8_t) {}
#[no_mangle]
pub unsafe extern "C" fn unlock_buf(mut bFcn: uint8_t) {}
#[no_mangle]
pub unsafe extern "C" fn WSetCursorPos(mut x: libc::c_int, mut y: libc::c_int) {
    SDL_WarpMouseInWindow(sdlWindow, x, y);
}
unsafe extern "C" fn SetScreenMode() {
    let mut rmask: uint32_t = 0;
    let mut gmask: uint32_t = 0;
    let mut bmask: uint32_t = 0;
    let mut amask: uint32_t = 0;
    rmask = 0xff as libc::c_int as uint32_t;
    gmask = 0xff00 as libc::c_int as uint32_t;
    bmask = 0xff0000 as libc::c_int as uint32_t;
    amask = 0xff000000 as libc::c_uint;
    sdlSurface = SDL_CreateRGBSurface(
        0 as libc::c_int as Uint32,
        TOTALX as libc::c_int,
        TOTALY as libc::c_int,
        32 as libc::c_int,
        rmask,
        gmask,
        bmask,
        amask,
    );
    if sdlSurface.is_null() {
        app_fatal_(
            b"backend/sdlsys.c\0" as *const u8 as *const libc::c_char,
            71 as libc::c_int,
            b"unable to create surface\0" as *const u8 as *const libc::c_char,
        );
    }
    sdlTexture = SDL_CreateTexture(
        sdlRenderer,
        SDL_PIXELFORMAT_ARGB8888 as libc::c_int as Uint32,
        SDL_TEXTUREACCESS_STREAMING as libc::c_int,
        TOTALX as libc::c_int,
        TOTALY as libc::c_int,
    );
    if sdlTexture.is_null() {
        app_fatal_(
            b"backend/sdlsys.c\0" as *const u8 as *const libc::c_char,
            81 as libc::c_int,
            b"unable to create texture\0" as *const u8 as *const libc::c_char,
        );
    }
}
#[no_mangle]
pub unsafe extern "C" fn SdlSysInit() {
    if !gpBuffer.is_null() {
        assert_fail(
            86 as libc::c_int,
            b"backend/sdlsys.c\0" as *const u8 as *const libc::c_char,
            b"!gpBuffer\0" as *const u8 as *const libc::c_char,
        );
    }
    SDL_setenv(
        b"SDL_VIDEO_CENTERED\0" as *const u8 as *const libc::c_char,
        b"1\0" as *const u8 as *const libc::c_char,
        1 as libc::c_int,
    );
    SDL_Init(0x20 as libc::c_uint);
    atexit(Some(SDL_Quit as unsafe extern "C" fn() -> ()));
    SDL_CreateWindowAndRenderer(
        TOTALX as libc::c_int,
        TOTALY as libc::c_int,
        SDL_WINDOW_SHOWN as libc::c_int as Uint32,
        &mut sdlWindow,
        &mut sdlRenderer,
    );
    SDL_SetWindowTitle(sdlWindow, gszAppName);
    SDL_ShowCursor(0 as libc::c_int);
    SetScreenMode();
    interface_msg_pump();
    bActive = 1 as libc::c_int as bool32_t;
    gpBuffer = DiabloAllocPtr(
        (BUFFERSIZE as libc::c_int as libc::c_ulong)
            .wrapping_mul(::core::mem::size_of::<uint32_t>() as libc::c_ulong)
            as uint32_t,
    ) as *mut uint32_t;
}
#[no_mangle]
pub unsafe extern "C" fn SdlSysFree() {
    let mut p__p: *mut libc::c_void = gpBuffer as *mut libc::c_void;
    gpBuffer = 0 as *mut uint32_t;
    mem_free_dbg(p__p);
}
#[no_mangle]
pub unsafe extern "C" fn SdlSysSwitchModes() {
    fullscreen = (fullscreen == 0) as libc::c_int as bool32_t;
    savecrsr_reset();
    force_redraw = FULLDRAW as libc::c_int;
    SetScreenMode();
}
#[no_mangle]
pub unsafe extern "C" fn SdlSysBlit(
    mut dwX: uint32_t,
    mut dwY: uint32_t,
    mut dwWdt: uint32_t,
    mut dwHgt: uint32_t,
) {
    let mut i: uint32_t = 0;
    let mut pFrom: *mut uint32_t = 0 as *mut uint32_t;
    let mut pTo: *mut uint32_t = 0 as *mut uint32_t;
    if dwX & 3 as libc::c_int as uint32_t != 0 {
        assert_fail(
            123 as libc::c_int,
            b"backend/sdlsys.c\0" as *const u8 as *const libc::c_char,
            b"!(dwX & 3)\0" as *const u8 as *const libc::c_char,
        );
    }
    if dwWdt & 3 as libc::c_int as uint32_t != 0 {
        assert_fail(
            124 as libc::c_int,
            b"backend/sdlsys.c\0" as *const u8 as *const libc::c_char,
            b"!(dwWdt & 3)\0" as *const u8 as *const libc::c_char,
        );
    }
    let mut lSrcOff: int32_t = dwX
        .wrapping_add(64 as libc::c_int as uint32_t)
        .wrapping_add(
            dwY.wrapping_add(160 as libc::c_int as uint32_t)
                * 768 as libc::c_int as uint32_t,
        ) as int32_t;
    let mut lDstOff: int32_t = dwX.wrapping_add(TOTALX as libc::c_int as uint32_t * dwY)
        as int32_t;
    let mut lSrcMod: int32_t = BUFFERX as libc::c_int;
    let mut lDstMod: int32_t = TOTALX as libc::c_int;
    pFrom = &mut *gpBuffer.offset(lSrcOff as isize) as *mut uint32_t;
    pTo = (*sdlSurface).pixels as *mut uint32_t;
    pTo = pTo.offset(lDstOff as isize);
    i = 0 as libc::c_int as uint32_t;
    while i < dwHgt {
        memcpy(
            pTo as *mut libc::c_void,
            pFrom as *const libc::c_void,
            (dwWdt * 4 as libc::c_int as uint32_t) as libc::c_ulong,
        );
        pFrom = pFrom.offset(lSrcMod as isize);
        pTo = pTo.offset(lDstMod as isize);
        i = i.wrapping_add(1);
        i;
    }
    SDL_UpdateTexture(
        sdlTexture,
        0 as *const SDL_Rect,
        (*sdlSurface).pixels,
        (*sdlSurface).pitch,
    );
    SDL_RenderClear(sdlRenderer);
    SDL_RenderCopy(sdlRenderer, sdlTexture, 0 as *const SDL_Rect, 0 as *const SDL_Rect);
    SDL_RenderPresent(sdlRenderer);
}
